import{s as rt,n as ht,o as yt}from"../chunks/scheduler.25b97de1.js";import{S as bt,i as Jt,g as o,s as e,r as c,A as wt,h as i,f as l,c as n,j as Mt,u as m,x as h,k as dt,y as Tt,a as s,v as u,d as M,t as d,w as r}from"../chunks/index.d9030fc9.js";import{C as at}from"../chunks/CodeBlock.e6cd0d95.js";import{H as lt,E as jt}from"../chunks/EditOnGithub.91d95064.js";function Ut(st){let p,F,V,z,y,Y,b,et='<a href="https://github.com/pytorch/ao" rel="nofollow">TorchAO</a> is an architecture optimization library for PyTorch, it provides high performance dtypes, optimization techniques and kernels for inference and training, featuring composability with native PyTorch features like <code>torch.compile</code>, FSDP etc.. Some benchmark numbers can be found <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">here</a>.',q,J,nt="Before you begin, make sure the following libraries are installed with their latest version:",C,w,v,T,ot="By default, the weights are loaded in full precision (torch.float32) regardless of the actual data type the weights are stored in such as torch.float16. Set <code>torch_dtype=&quot;auto&quot;</code> to load the weights in the data type defined in a model’s <code>config.json</code> file to automatically load the most memory-optimal data type.",N,j,E,U,it=`<code>torchao</code> Provides many commonly used types of quantization, including different dtypes like int4, float8 and different flavors like weight only, dynamic quantization etc., only <code>int4_weight_only</code>, <code>int8_weight_only</code> and <code>int8_dynamic_activation_int8_weight</code> are integrated into hugigngface transformers currently, but we can add more when needed.
If you want to run the following codes on CPU even with GPU available, just change <code>device_map=&quot;cpu&quot;</code> and <code>quantization_config = TorchAoConfig(&quot;int4_weight_only&quot;, group_size=128, layout=Int4CPULayout())</code> where <code>layout</code> comes from <code>from torchao.dtypes import Int4CPULayout</code> which is only available from torchao 0.8.0 and higher.`,Q,f,pt="Users can manually specify the quantization types and settings they want to use:",H,Z,x,W,S,_,ct="<code>torchao</code> also provies <code>autoquant</code> feature that automatically chooses a quantization type for quantizable layers such as linear based on microbenchmarks of quantizing and compiling a single linear layer.",$,X,A,G,K,g,mt='torchao quantization is implemented with <a href="https://pytorch.org/docs/stable/notes/extending.html#subclassing-torch-tensor" rel="nofollow">tensor subclasses</a>, it only work with huggingface non-safetensor serialization and deserialization. It relies on <code>torch.load(..., weights_only=True)</code> to avoid arbitrary user code execution during load time and use <a href="https://pytorch.org/docs/stable/notes/serialization.html#torch.serialization.add_safe_globals" rel="nofollow">add_safe_globals</a> to allowlist some known user functions.',L,B,ut="The reason why it does not support safe tensor serialization is that wrapper tensor subclass allows maximum flexibility so we want to make sure the effort of supporting new format of quantized Tensor is low, while safe tensor optimizes for maximum safety (no user code execution), it also means we have to make sure to manually support new quantization format.",D,R,P,I,O,k,tt;return y=new lt({props:{title:"TorchAO",local:"torchao",headingTag:"h1"}}),w=new at({props:{code:"JTIzJTIwVXBkYXRpbmclMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjB0byUyMHRoZSUyMGxhdGVzdCUyMHZlcnNpb24lMkMlMjBhcyUyMHRoZSUyMGV4YW1wbGUlMjBzY3JpcHQlMjBiZWxvdyUyMHVzZXMlMjB0aGUlMjBuZXclMjBhdXRvJTIwY29tcGlsYXRpb24lMEFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwdG9yY2glMjB0b3JjaGFvJTIwdHJhbnNmb3JtZXJz",highlighted:`<span class="hljs-comment"># Updating 🤗 Transformers to the latest version, as the example script below uses the new auto compilation</span>
pip install --upgrade torch torchao transformers`,wrap:!1}}),j=new lt({props:{title:"Manually Choose Quantization Types and Settings",local:"manually-choose-quantization-types-and-settings",headingTag:"h2"}}),Z=new at({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>
<span class="hljs-comment"># We support int4_weight_only, int8_weight_only and int8_dynamic_activation_int8_weight</span>
<span class="hljs-comment"># More examples and documentations for arguments can be found in https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">128</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config)

tokenizer = AutoTokenizer.from_pretrained(model_name)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(quantized_model.device)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speedup</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># benchmark the performance</span>
<span class="hljs-keyword">from</span> torch._inductor.utils <span class="hljs-keyword">import</span> do_bench_using_profiling
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">func: <span class="hljs-type">Callable</span>, *args, **kwargs</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Thin wrapper around do_bench_using_profiling&quot;&quot;&quot;</span>
    no_args = <span class="hljs-keyword">lambda</span>: func(*args, **kwargs)
    time = do_bench_using_profiling(no_args)
    <span class="hljs-keyword">return</span> time * <span class="hljs-number">1e3</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;int4wo-128 model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
output = bf16_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>) <span class="hljs-comment"># auto-compile</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))
`,wrap:!1}}),W=new lt({props:{title:"Automatically Select Quantization Types",local:"automatically-select-quantization-types",headingTag:"h2"}}),X=new at({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;autoquant&quot;</span>, min_sqnr=<span class="hljs-literal">None</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=quantization_config)

tokenizer = AutoTokenizer.from_pretrained(model_name)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speedup</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-comment"># Due to some implementation details we are explicitly calling this now, we may refactor our code and remove this in the future</span>
quantized_model.finalize_autoquant()
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># benchmark the performance</span>
<span class="hljs-keyword">from</span> torch._inductor.utils <span class="hljs-keyword">import</span> do_bench_using_profiling
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">func: <span class="hljs-type">Callable</span>, *args, **kwargs</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Thin wrapper around do_bench_using_profiling&quot;&quot;&quot;</span>
    no_args = <span class="hljs-keyword">lambda</span>: func(*args, **kwargs)
    time = do_bench_using_profiling(no_args)
    <span class="hljs-keyword">return</span> time * <span class="hljs-number">1e3</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;autoquantized model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16)
output = bf16_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>) <span class="hljs-comment"># auto-compile</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))
`,wrap:!1}}),G=new lt({props:{title:"Serialization and Deserialization",local:"serialization-and-deserialization",headingTag:"h2"}}),R=new at({props:{code:"JTIzJTIwc2F2ZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwbG9jYWxseSUwQW91dHB1dF9kaXIlMjAlM0QlMjAlMjJsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQXF1YW50aXplZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQob3V0cHV0X2RpciUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlKSUwQSUwQSUyMyUyMHB1c2glMjB0byUyMGh1Z2dpbmdmYWNlJTIwaHViJTBBJTIzJTIwc2F2ZV90byUyMCUzRCUyMCUyMiU3QnVzZXJfaWQlN0QlMkZsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQSUyMyUyMHF1YW50aXplZF9tb2RlbC5wdXNoX3RvX2h1YihzYXZlX3RvJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2UpJTBBJTBBJTIzJTIwbG9hZCUyMHF1YW50aXplZCUyMG1vZGVsJTBBY2twdF9pZCUyMCUzRCUyMCUyMmxsYW1hMy04Yi1pbnQ0d28tMTI4JTIyJTIwJTIwJTIzJTIwb3IlMjBodWdnaW5nZmFjZSUyMGh1YiUyMG1vZGVsJTIwaWQlMEFsb2FkZWRfcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHRfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEElMEElMEElMjMlMjBjb25maXJtJTIwdGhlJTIwc3BlZWR1cCUwQWxvYWRlZF9xdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjB0b3JjaC5jb21waWxlKGxvYWRlZF9xdWFudGl6ZWRfbW9kZWwlMkMlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyKSUwQXByaW50KCUyMmxvYWRlZCUyMGludDR3by0xMjglMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihsb2FkZWRfcXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TKSk=",highlighted:`<span class="hljs-comment"># save quantized model locally</span>
output_dir = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>
quantized_model.save_pretrained(output_dir, safe_serialization=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># push to huggingface hub</span>
<span class="hljs-comment"># save_to = &quot;{user_id}/llama3-8b-int4wo-128&quot;</span>
<span class="hljs-comment"># quantized_model.push_to_hub(save_to, safe_serialization=False)</span>

<span class="hljs-comment"># load quantized model</span>
ckpt_id = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>  <span class="hljs-comment"># or huggingface hub model id</span>
loaded_quantized_model = AutoModelForCausalLM.from_pretrained(ckpt_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)


<span class="hljs-comment"># confirm the speedup</span>
loaded_quantized_model = torch.<span class="hljs-built_in">compile</span>(loaded_quantized_model, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;loaded int4wo-128 model:&quot;</span>, benchmark_fn(loaded_quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS))`,wrap:!1}}),I=new jt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){p=o("meta"),F=e(),V=o("p"),z=e(),c(y.$$.fragment),Y=e(),b=o("p"),b.innerHTML=et,q=e(),J=o("p"),J.textContent=nt,C=e(),c(w.$$.fragment),v=e(),T=o("p"),T.innerHTML=ot,N=e(),c(j.$$.fragment),E=e(),U=o("p"),U.innerHTML=it,Q=e(),f=o("p"),f.textContent=pt,H=e(),c(Z.$$.fragment),x=e(),c(W.$$.fragment),S=e(),_=o("p"),_.innerHTML=ct,$=e(),c(X.$$.fragment),A=e(),c(G.$$.fragment),K=e(),g=o("p"),g.innerHTML=mt,L=e(),B=o("p"),B.textContent=ut,D=e(),c(R.$$.fragment),P=e(),c(I.$$.fragment),O=e(),k=o("p"),this.h()},l(t){const a=wt("svelte-u9bgzb",document.head);p=i(a,"META",{name:!0,content:!0}),a.forEach(l),F=n(t),V=i(t,"P",{}),Mt(V).forEach(l),z=n(t),m(y.$$.fragment,t),Y=n(t),b=i(t,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1w5ww4g"&&(b.innerHTML=et),q=n(t),J=i(t,"P",{"data-svelte-h":!0}),h(J)!=="svelte-1wrsrbm"&&(J.textContent=nt),C=n(t),m(w.$$.fragment,t),v=n(t),T=i(t,"P",{"data-svelte-h":!0}),h(T)!=="svelte-9fdmcv"&&(T.innerHTML=ot),N=n(t),m(j.$$.fragment,t),E=n(t),U=i(t,"P",{"data-svelte-h":!0}),h(U)!=="svelte-15n0el4"&&(U.innerHTML=it),Q=n(t),f=i(t,"P",{"data-svelte-h":!0}),h(f)!=="svelte-18sirij"&&(f.textContent=pt),H=n(t),m(Z.$$.fragment,t),x=n(t),m(W.$$.fragment,t),S=n(t),_=i(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1ctz5k1"&&(_.innerHTML=ct),$=n(t),m(X.$$.fragment,t),A=n(t),m(G.$$.fragment,t),K=n(t),g=i(t,"P",{"data-svelte-h":!0}),h(g)!=="svelte-14dwjgd"&&(g.innerHTML=mt),L=n(t),B=i(t,"P",{"data-svelte-h":!0}),h(B)!=="svelte-10wmnl9"&&(B.textContent=ut),D=n(t),m(R.$$.fragment,t),P=n(t),m(I.$$.fragment,t),O=n(t),k=i(t,"P",{}),Mt(k).forEach(l),this.h()},h(){dt(p,"name","hf:doc:metadata"),dt(p,"content",ft)},m(t,a){Tt(document.head,p),s(t,F,a),s(t,V,a),s(t,z,a),u(y,t,a),s(t,Y,a),s(t,b,a),s(t,q,a),s(t,J,a),s(t,C,a),u(w,t,a),s(t,v,a),s(t,T,a),s(t,N,a),u(j,t,a),s(t,E,a),s(t,U,a),s(t,Q,a),s(t,f,a),s(t,H,a),u(Z,t,a),s(t,x,a),u(W,t,a),s(t,S,a),s(t,_,a),s(t,$,a),u(X,t,a),s(t,A,a),u(G,t,a),s(t,K,a),s(t,g,a),s(t,L,a),s(t,B,a),s(t,D,a),u(R,t,a),s(t,P,a),u(I,t,a),s(t,O,a),s(t,k,a),tt=!0},p:ht,i(t){tt||(M(y.$$.fragment,t),M(w.$$.fragment,t),M(j.$$.fragment,t),M(Z.$$.fragment,t),M(W.$$.fragment,t),M(X.$$.fragment,t),M(G.$$.fragment,t),M(R.$$.fragment,t),M(I.$$.fragment,t),tt=!0)},o(t){d(y.$$.fragment,t),d(w.$$.fragment,t),d(j.$$.fragment,t),d(Z.$$.fragment,t),d(W.$$.fragment,t),d(X.$$.fragment,t),d(G.$$.fragment,t),d(R.$$.fragment,t),d(I.$$.fragment,t),tt=!1},d(t){t&&(l(F),l(V),l(z),l(Y),l(b),l(q),l(J),l(C),l(v),l(T),l(N),l(E),l(U),l(Q),l(f),l(H),l(x),l(S),l(_),l($),l(A),l(K),l(g),l(L),l(B),l(D),l(P),l(O),l(k)),l(p),r(y,t),r(w,t),r(j,t),r(Z,t),r(W,t),r(X,t),r(G,t),r(R,t),r(I,t)}}}const ft='{"title":"TorchAO","local":"torchao","sections":[{"title":"Manually Choose Quantization Types and Settings","local":"manually-choose-quantization-types-and-settings","sections":[],"depth":2},{"title":"Automatically Select Quantization Types","local":"automatically-select-quantization-types","sections":[],"depth":2},{"title":"Serialization and Deserialization","local":"serialization-and-deserialization","sections":[],"depth":2}],"depth":1}';function Zt(st){return yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends bt{constructor(p){super(),Jt(this,p,Zt,Ut,rt,{})}}export{gt as component};
