import{s as zs,o as As,n as Ds}from"../chunks/scheduler.b108d059.js";import{S as Ps,i as Ks,g as p,s as a,r as o,A as st,h as c,f as l,c as n,j as x,u as r,x as m,k as Ss,y as g,a as e,v as d,d as y,t as M,w as h}from"../chunks/index.008de539.js";import{T as tt}from"../chunks/Tip.aeb15ab7.js";import{C as P}from"../chunks/CodeBlock.3968c746.js";import{H as Ns,E as lt}from"../chunks/EditOnGithub.d1c48e3d.js";function et(ts){let i,j="<code>HfFileSystem</code> 提供了 fsspec 兼容性，这对于需要它的库（例如，直接使用 <code>pandas</code> 读取 Hugging Face 数据集）非常有用。然而，由于这种兼容性层，会引入额外的开销。为了更好的性能和可靠性，建议尽可能使用 <code>HfApi</code> 方法。";return{c(){i=p("p"),i.innerHTML=j},l(U){i=c(U,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1y5y408"&&(i.innerHTML=j)},m(U,L){e(U,i,L)},p:Ds,d(U){U&&l(i)}}}function at(ts){let i,j,U,L,J,ls,w,Gs='除了 <code>HfApi</code>，<code>huggingface_hub</code> 库还提供了 <code>HfFileSystem</code>，这是一个符合 <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec</a> 规范的 Python 文件接口，用于与 Hugging Face Hub 交互。<code>HfFileSystem</code> 基于 <code>HfApi</code> 构建，提供了典型的文件系统操作，如 <code>cp</code>、<code>mv</code>、<code>ls</code>、<code>du</code>、<code>glob</code>、<code>get_file</code> 和 <code>put_file</code>。',es,u,as,k,ns,R,ps,V,Ys="可以传递可选的 <code>revision</code> 参数，以从特定提交（如分支、标签名或提交哈希）运行操作。",cs,C,vs="与 Python 内置的 <code>open</code> 不同，<code>fsspec</code> 的 <code>open</code> 默认是二进制模式 <code>&quot;rb&quot;</code>。这意味着您必须明确设置模式为 <code>&quot;r&quot;</code> 以读取文本模式，或 <code>&quot;w&quot;</code> 以写入文本模式。目前不支持追加到文件（模式 <code>&quot;a&quot;</code> 和 <code>&quot;ab&quot;</code>）",is,b,ms,N,Xs="<code>HfFileSystem</code> 可以与任何集成了 <code>fsspec</code> 的库一起使用，前提是 URL 遵循以下格式：",os,Q,rs,f,Es='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/hf_urls.png"/>',ds,F,Is="对于数据集，<code>repo_type_prefix</code> 为 <code>datasets/</code>，对于Space，<code>repo_type_prefix</code>为 <code>spaces/</code>，模型不需要在 URL 中使用这样的前缀。",ys,$,_s="以下是一些 <code>HfFileSystem</code> 简化与 Hub 交互的有趣集成：",Ms,W,Z,z,Hs='从 Hub 仓库读取/写入 <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame ：',Qs,S,hs,G,Os='同样的工作流程也适用于 <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> 和 <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',Us,T,Y,A,qs='使用 <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a> 查询(远程)Hub文件：',Fs,v,$s,X,D,Bs='使用 <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a> 将 Hub 作为数组存储：',Zs,E,gs,I,us,_,xs='在许多情况下，您必须登录 Hugging Face 账户才能与 Hub 交互。请参阅文档的<a href="../quick-start#authentication">认证</a> 部分，了解有关 Hub 上认证方法的更多信息。',fs,H,Ls="也可以通过将您的 token 作为参数传递给 <code>HfFileSystem</code> 以编程方式登录：",Ts,O,js,q,Ws="如果您以这种方式登录，请注意在共享源代码时不要意外泄露令牌！",Js,B,ws,K,ks;return J=new Ns({props:{title:"通过文件系统 API 与 Hub 交互",local:"通过文件系统-api-与-hub-交互",headingTag:"h1"}}),u=new tt({props:{warning:!0,$$slots:{default:[et]},$$scope:{ctx:ts}}}),k=new Ns({props:{title:"使用方法",local:"使用方法",headingTag:"h2"}}),R=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjAlRTUlODglOTclRTUlODclQkElRTclOUIlQUUlRTUlQkQlOTUlRTQlQjglQUQlRTclOUElODQlRTYlODklODAlRTYlOUMlODklRTYlOTYlODclRTQlQkIlQjYlMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMCVFNSU4OCU5NyVFNSU4NyVCQSVFNCVCQiU5MyVFNSVCQSU5MyVFNCVCOCVBRCVFNyU5QSU4NCVFNiU4OSU4MCVFNiU5QyU4OSUyMCUyMi5jc3YlMjIlMjAlRTYlOTYlODclRTQlQkIlQjYlMEFmcy5nbG9iKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkYqKiUyRiouY3N2JTIyKSUwQSUwQSUyMyUyMCVFOCVBRiVCQiVFNSU4RiU5NiVFOCVCRiU5QyVFNyVBOCU4QiVFNiU5NiU4NyVFNCVCQiVCNiUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhJTIwJTNEJTIwZi5yZWFkbGluZXMoKSUwQSUwQSUyMyUyMCVFOCVCRiU5QyVFNyVBOCU4QiVFNiU5NiU4NyVFNCVCQiVCNiVFNSU4NiU4NSVFNSVBRSVCOSVFOCVBRiVCQiVFNSU4RiU5NiVFNCVCOCVCQSVFNSVBRCU5NyVFNyVBQyVBNiVFNCVCOCVCMiUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjAlRTUlODYlOTklRTUlODUlQTUlRTglQkYlOUMlRTclQTglOEIlRTYlOTYlODclRTQlQkIlQjYlMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnZhbGlkYXRpb24uY3N2JTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnRleHQlMkNsYWJlbCUyMiklMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMkZhbnRhc3RpYyUyMG1vdmllISUyQ2dvb2QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 列出目录中的所有文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 列出仓库中的所有 &quot;.csv&quot; 文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**/*.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 读取远程文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 远程文件内容读取为字符串</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 写入远程文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),b=new Ns({props:{title:"集成",local:"集成",headingTag:"h2"}}),Q=new P({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),S=new P({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMCVFNSVCMCU4NiVFOCVCRiU5QyVFNyVBOCU4QiUyMENTViUyMCVFNiU5NiU4NyVFNCVCQiVCNiVFOCVBRiVCQiVFNSU4RiU5NiVFNSU4OCVCMCUyMERhdGFGcmFtZSUwQWRmJTIwJTNEJTIwcGQucmVhZF9jc3YoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGdHJhaW4uY3N2JTIyKSUwQSUwQSUyMyUyMCVFNSVCMCU4NiUyMERhdGFGcmFtZSUyMCVFNSU4NiU5OSVFNSU4NSVBNSVFOCVCRiU5QyVFNyVBOCU4QiUyMENTViUyMCVFNiU5NiU4NyVFNCVCQiVCNiUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 将远程 CSV 文件读取到 DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 将 DataFrame 写入远程 CSV 文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),v=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjAlRTYlOUYlQTUlRTglQUYlQTIlRTglQkYlOUMlRTclQTglOEIlRTYlOTYlODclRTQlQkIlQjYlRTUlQjklQjYlRTUlQjAlODYlRTclQkIlOTMlRTYlOUUlOUMlRTglQkYlOTQlRTUlOUIlOUUlRTQlQjglQkElMjBEYXRhRnJhbWUlMEFmc19xdWVyeV9maWxlJTIwJTNEJTIwJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YV9kaXIlMkZkYXRhLnBhcnF1ZXQlMjIlMEFkZiUyMCUzRCUyMGR1Y2tkYi5xdWVyeShmJTIyU0VMRUNUJTIwKiUyMEZST00lMjAnJTdCZnNfcXVlcnlfZmlsZSU3RCclMjBMSU1JVCUyMDEwJTIyKS5kZigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 查询远程文件并将结果返回为 DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),E=new P({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjAlRTUlQjAlODYlRTYlOTUlQjAlRTclQkIlODQlRTUlODYlOTklRTUlODUlQTUlRTQlQkIlOTMlRTUlQkElOTMlMEF3aXRoJTIwemFyci5vcGVuX2dyb3VwKCUyMmhmJTNBJTJGJTJGbXktdXNlcm5hbWUlMkZteS1tb2RlbC1yZXBvJTJGYXJyYXktc3RvcmUlMjIlMkMlMjBtb2RlJTNEJTIydyUyMiklMjBhcyUyMHJvb3QlM0ElMEElMjAlMjAlMjBmb28lMjAlM0QlMjByb290LmNyZWF0ZV9ncm91cCglMjJlbWJlZGRpbmdzJTIyKSUwQSUyMCUyMCUyMGZvb2JhciUyMCUzRCUyMGZvby56ZXJvcygnZXhwZXJpbWVudF8wJyUyQyUyMHNoYXBlJTNEKDUwMDAwJTJDJTIwMTAwMCklMkMlMjBjaHVua3MlM0QoMTAwMDAlMkMlMjAxMDAwKSUyQyUyMGR0eXBlJTNEJ2Y0JyklMEElMjAlMjAlMjBmb29iYXIlNUIlM0ElNUQlMjAlM0QlMjBlbWJlZGRpbmdzJTBBJTBBJTIzJTIwJUU0JUJCJThFJUU0JUJCJTkzJUU1JUJBJTkzJUU4JUFGJUJCJUU1JThGJTk2JUU2JTk1JUIwJUU3JUJCJTg0JTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 将数组写入仓库</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 从仓库读取数组</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),I=new Ns({props:{title:"认证",local:"认证",headingTag:"h2"}}),O=new P({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),B=new lt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/cn/guides/hf_file_system.md"}}),{c(){i=p("meta"),j=a(),U=p("p"),L=a(),o(J.$$.fragment),ls=a(),w=p("p"),w.innerHTML=Gs,es=a(),o(u.$$.fragment),as=a(),o(k.$$.fragment),ns=a(),o(R.$$.fragment),ps=a(),V=p("p"),V.innerHTML=Ys,cs=a(),C=p("p"),C.innerHTML=vs,is=a(),o(b.$$.fragment),ms=a(),N=p("p"),N.innerHTML=Xs,os=a(),o(Q.$$.fragment),rs=a(),f=p("div"),f.innerHTML=Es,ds=a(),F=p("p"),F.innerHTML=Is,ys=a(),$=p("p"),$.innerHTML=_s,Ms=a(),W=p("ul"),Z=p("li"),z=p("p"),z.innerHTML=Hs,Qs=a(),o(S.$$.fragment),hs=a(),G=p("p"),G.innerHTML=Os,Us=a(),T=p("ul"),Y=p("li"),A=p("p"),A.innerHTML=qs,Fs=a(),o(v.$$.fragment),$s=a(),X=p("li"),D=p("p"),D.innerHTML=Bs,Zs=a(),o(E.$$.fragment),gs=a(),o(I.$$.fragment),us=a(),_=p("p"),_.innerHTML=xs,fs=a(),H=p("p"),H.innerHTML=Ls,Ts=a(),o(O.$$.fragment),js=a(),q=p("p"),q.textContent=Ws,Js=a(),o(B.$$.fragment),ws=a(),K=p("p"),this.h()},l(s){const t=st("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(l),j=n(s),U=c(s,"P",{}),x(U).forEach(l),L=n(s),r(J.$$.fragment,s),ls=n(s),w=c(s,"P",{"data-svelte-h":!0}),m(w)!=="svelte-8k89ij"&&(w.innerHTML=Gs),es=n(s),r(u.$$.fragment,s),as=n(s),r(k.$$.fragment,s),ns=n(s),r(R.$$.fragment,s),ps=n(s),V=c(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1wzfat4"&&(V.innerHTML=Ys),cs=n(s),C=c(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1iolibw"&&(C.innerHTML=vs),is=n(s),r(b.$$.fragment,s),ms=n(s),N=c(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1evtbpn"&&(N.innerHTML=Xs),os=n(s),r(Q.$$.fragment,s),rs=n(s),f=c(s,"DIV",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-167v4fl"&&(f.innerHTML=Es),ds=n(s),F=c(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-iwgss8"&&(F.innerHTML=Is),ys=n(s),$=c(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-12r7993"&&($.innerHTML=_s),Ms=n(s),W=c(s,"UL",{});var ss=x(W);Z=c(ss,"LI",{});var Rs=x(Z);z=c(Rs,"P",{"data-svelte-h":!0}),m(z)!=="svelte-lwztdr"&&(z.innerHTML=Hs),Qs=n(Rs),r(S.$$.fragment,Rs),Rs.forEach(l),ss.forEach(l),hs=n(s),G=c(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1d71x4n"&&(G.innerHTML=Os),Us=n(s),T=c(s,"UL",{});var Vs=x(T);Y=c(Vs,"LI",{});var Cs=x(Y);A=c(Cs,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1pmewq4"&&(A.innerHTML=qs),Fs=n(Cs),r(v.$$.fragment,Cs),Cs.forEach(l),$s=n(Vs),X=c(Vs,"LI",{});var bs=x(X);D=c(bs,"P",{"data-svelte-h":!0}),m(D)!=="svelte-17onvf5"&&(D.innerHTML=Bs),Zs=n(bs),r(E.$$.fragment,bs),bs.forEach(l),Vs.forEach(l),gs=n(s),r(I.$$.fragment,s),us=n(s),_=c(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1ehmkss"&&(_.innerHTML=xs),fs=n(s),H=c(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-uh366k"&&(H.innerHTML=Ls),Ts=n(s),r(O.$$.fragment,s),js=n(s),q=c(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1cvm5tr"&&(q.textContent=Ws),Js=n(s),r(B.$$.fragment,s),ws=n(s),K=c(s,"P",{}),x(K).forEach(l),this.h()},h(){Ss(i,"name","hf:doc:metadata"),Ss(i,"content",nt),Ss(f,"class","flex justify-center")},m(s,t){g(document.head,i),e(s,j,t),e(s,U,t),e(s,L,t),d(J,s,t),e(s,ls,t),e(s,w,t),e(s,es,t),d(u,s,t),e(s,as,t),d(k,s,t),e(s,ns,t),d(R,s,t),e(s,ps,t),e(s,V,t),e(s,cs,t),e(s,C,t),e(s,is,t),d(b,s,t),e(s,ms,t),e(s,N,t),e(s,os,t),d(Q,s,t),e(s,rs,t),e(s,f,t),e(s,ds,t),e(s,F,t),e(s,ys,t),e(s,$,t),e(s,Ms,t),e(s,W,t),g(W,Z),g(Z,z),g(Z,Qs),d(S,Z,null),e(s,hs,t),e(s,G,t),e(s,Us,t),e(s,T,t),g(T,Y),g(Y,A),g(Y,Fs),d(v,Y,null),g(T,$s),g(T,X),g(X,D),g(X,Zs),d(E,X,null),e(s,gs,t),d(I,s,t),e(s,us,t),e(s,_,t),e(s,fs,t),e(s,H,t),e(s,Ts,t),d(O,s,t),e(s,js,t),e(s,q,t),e(s,Js,t),d(B,s,t),e(s,ws,t),e(s,K,t),ks=!0},p(s,[t]){const ss={};t&2&&(ss.$$scope={dirty:t,ctx:s}),u.$set(ss)},i(s){ks||(y(J.$$.fragment,s),y(u.$$.fragment,s),y(k.$$.fragment,s),y(R.$$.fragment,s),y(b.$$.fragment,s),y(Q.$$.fragment,s),y(S.$$.fragment,s),y(v.$$.fragment,s),y(E.$$.fragment,s),y(I.$$.fragment,s),y(O.$$.fragment,s),y(B.$$.fragment,s),ks=!0)},o(s){M(J.$$.fragment,s),M(u.$$.fragment,s),M(k.$$.fragment,s),M(R.$$.fragment,s),M(b.$$.fragment,s),M(Q.$$.fragment,s),M(S.$$.fragment,s),M(v.$$.fragment,s),M(E.$$.fragment,s),M(I.$$.fragment,s),M(O.$$.fragment,s),M(B.$$.fragment,s),ks=!1},d(s){s&&(l(j),l(U),l(L),l(ls),l(w),l(es),l(as),l(ns),l(ps),l(V),l(cs),l(C),l(is),l(ms),l(N),l(os),l(rs),l(f),l(ds),l(F),l(ys),l($),l(Ms),l(W),l(hs),l(G),l(Us),l(T),l(gs),l(us),l(_),l(fs),l(H),l(Ts),l(js),l(q),l(Js),l(ws),l(K)),l(i),h(J,s),h(u,s),h(k,s),h(R,s),h(b,s),h(Q,s),h(S),h(v),h(E),h(I,s),h(O,s),h(B,s)}}}const nt='{"title":"通过文件系统 API 与 Hub 交互","local":"通过文件系统-api-与-hub-交互","sections":[{"title":"使用方法","local":"使用方法","sections":[],"depth":2},{"title":"集成","local":"集成","sections":[],"depth":2},{"title":"认证","local":"认证","sections":[],"depth":2}],"depth":1}';function pt(ts){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends Ps{constructor(i){super(),Ks(this,i,pt,at,zs,{})}}export{dt as component};
