import{s as eo,f as to,n as ao,o as no}from"../chunks/scheduler.d627b047.js";import{S as oo,i as ro,g as i,s as n,r as p,m as ct,H as Qn,A as lo,h as s,f as a,c as o,j as T,u as m,x as d,n as pt,B as Gn,k as b,y as l,a as r,v as g,d as h,t as f,w as u}from"../chunks/index.73c51727.js";import{D as w}from"../chunks/Docstring.488b7ad2.js";import{C as en}from"../chunks/CodeBlock.b1cdc5f6.js";import{H as x,E as io}from"../chunks/EditOnGithub.859b9ebc.js";function so(tn){let L,ht,mt,ft,U,ut,E,an='<a href="https://huggingface.co/models?other=kto,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-KTO-blue"/></a>',_t,J,vt,W,nn='Kahneman-Tversky Optimization (KTO) was introduced in <a href="https://huggingface.co/papers/2402.01306" rel="nofollow">KTO: Model Alignment as Prospect Theoretic Optimization</a> by <a href="https://huggingface.co/kawine" rel="nofollow">Kawin Ethayarajh</a>, <a href="https://huggingface.co/xwinxu" rel="nofollow">Winnie Xu</a>, <a href="https://huggingface.co/Muennighoff" rel="nofollow">Niklas Muennighoff</a>, Dan Jurafsky, <a href="https://huggingface.co/douwekiela" rel="nofollow">Douwe Kiela</a>.',bt,B,on="The abstract from the paper is the following:",Tt,A,rn="<p>Kahneman &amp; Tversky’s prospect theory tells us that humans perceive random variables in a biased but well-defined manner; for example, humans are famously loss-averse. We show that objectives for aligning LLMs with human feedback implicitly incorporate many of these biases — the success of these objectives (e.g., DPO) over cross-entropy minimization can partly be ascribed to them being human-aware loss functions (HALOs). However, the utility functions these methods attribute to humans still differ from those in the prospect theory literature. Using a Kahneman-Tversky model of human utility, we propose a HALO that directly maximizes the utility of generations instead of maximizing the log-likelihood of preferences, as current methods do. We call this approach Kahneman-Tversky Optimization (KTO), and it matches or exceeds the performance of preference-based methods at scales from 1B to 30B. Crucially, KTO does not need preferences — only a binary signal of whether an output is desirable or undesirable for a given input. This makes it far easier to use in the real world, where preference data is scarce and expensive.</p>",yt,D,ln='The official code can be found in <a href="https://github.com/ContextualAI/HALOs" rel="nofollow">ContextualAI/HALOs</a>.',wt,q,sn='This post-training method was contributed by <a href="https://huggingface.co/kashif" rel="nofollow">Kashif Rasul</a>, <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a>, <a href="https://huggingface.co/lewtun" rel="nofollow">Lewis Tunstall</a> and Pablo Vicente.',xt,R,$t,V,dn='This example demonstrates how to train a model using the KTO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model. We use the preference data from the <a href="https://huggingface.co/datasets/trl-lib/kto-mix-14k" rel="nofollow">KTO Mix 14k</a>. You can view the data in the dataset here:',Ot,O,cn,kt,Z,pn="Below is the script to train the model:",Mt,S,Ct,Q,mn="Execute the script using the following command:",Lt,G,Nt,X,gn="Distributed across 8 x H100 GPUs, the training takes approximately 30 minutes. You can verify the training progress by checking the reward graph. An increasing trend in the reward margin indicates that the model is improving and generating better responses over time.",Kt,Y,hn='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/kto-qwen2-reward-margin.png"/>',Ft,ee,fn='To see how the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-KTO" rel="nofollow">trained model</a> performs, you can use the <a href="clis#chat-interface">TRL Chat CLI</a>.',jt,te,un=`<code>$ trl chat --model_name_or_path trl-lib/Qwen2-0.5B-KTO
<strong><span style="color: red;">&lt;quentin_gallouedec&gt;:</span></strong>
What is the best programming language?

<strong><span style="color: blue;">&lt;trl-lib/Qwen2-0.5B-KTO&gt;:</span></strong>
The best programming language can vary depending on individual preferences, industry-specific requirements, technical skills, and familiarity with the specific use case or task. Here are some widely-used programming languages that have been noted as popular and widely used:                                                                                  

Here are some other factors to consider when choosing a programming language for a project:

 <strong><span style="color: green;">1</span> JavaScript</strong>: JavaScript is at the heart of the web and can be used for building web applications, APIs, and interactive front-end applications like frameworks like React and Angular. It&#39;s similar to C, C++, and F# in syntax structure and is accessible and easy to learn, making it a popular choice for beginners and professionals alike.                                                                   
 <strong><span style="color: green;">2</span> Java</strong>: Known for its object-oriented programming (OOP) and support for Java 8 and .NET, Java is used for developing enterprise-level software applications, high-performance games, as well as mobile apps, game development, and desktop applications.                                                                                                                                                            
 <strong><span style="color: green;">3</span> C++</strong>: Known for its flexibility and scalability, C++ offers comprehensive object-oriented programming and is a popular choice for high-performance computing and other technical fields. It&#39;s a powerful platform for building real-world applications and games at scale.                                                                                                                                         
 <strong><span style="color: green;">4</span> Python</strong>: Developed by Guido van Rossum in 1991, Python is a high-level, interpreted, and dynamically typed language known for its simplicity, readability, and versatility.   
</code>`,Ht,ae,Pt,ne,_n='KTO requires an <a href="dataset_formats#unpaired-preference">unpaired preference dataset</a>. Alternatively, you can provide a <em>paired</em> preference dataset (also known simply as a <em>preference dataset</em>). In this case, the trainer will automatically convert it to an unpaired format by separating the chosen and rejected responses, assigning <code>label = True</code> to the chosen completions and <code>label = False</code> to the rejected ones.',It,oe,vn='The <a href="/docs/trl/v0.15.0/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',zt,re,bn="In theory, the dataset should contain at least one chosen and one rejected completion. However, some users have successfully run KTO using <em>only</em> chosen or only rejected data. If using only rejected data, it is advisable to adopt a conservative learning rate.",Ut,le,Et,ie,Tn='We provide an example script to train a model using the KTO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/trl/scripts/kto.py" rel="nofollow"><code>trl/scripts/kto.py</code></a>',Jt,se,yn='To test the KTO script with the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen2 0.5B model</a> on the <a href="https://huggingface.co/datasets/trl-lib/kto-mix-14k" rel="nofollow">UltraFeedback dataset</a>, run the following command:',Wt,de,Bt,ce,At,pe,Dt,me,wn=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,qt,ge,xn=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. <a href="https://huggingface.co/docs/transformers/v4.49.0/en/model_doc/mixtral#transformers.MixtralConfig" rel="nofollow">MixtralConfig</a>).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: <code>0.001</code>) in the model config.`,Rt,he,Vt,fe,$n="Use a per-step batch size that is at least 4, and an effective batch size between 16 and 128. Even if your effective batch size is large, if your per-step batch size is poor, then the KL estimate in KTO will be poor.",Zt,ue,St,_e,On="Each choice of <code>beta</code> has a maximum learning rate it can tolerate before learning performance degrades. For the default setting of <code>beta = 0.1</code>, the learning rate should typically not exceed <code>1e-6</code> for most models. As <code>beta</code> decreases, the learning rate should also be reduced accordingly. In general, we strongly recommend keeping the learning rate between <code>5e-7</code> and <code>5e-6</code>. Even with small datasets, we advise against using a learning rate outside this range. Instead, opt for more epochs to achieve better results.",Qt,ve,Gt,v,Ta,Ee,kn="desirable_weight",ya,Je,Mn="undesirable_weight",wa,be,Cn="KTOConfig",xa,We,Ln="desirable_weight",$a,Xt,Xn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo>×</mo></mrow><annotation encoding="application/x-tex">\\times</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6667em;vertical-align:-0.0833em;"></span><span class="mord">×</span></span></span></span>',Yt,Be,Nn="undesirable_weight",Oa,ea,Yn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo>×</mo></mrow><annotation encoding="application/x-tex">\\times</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6667em;vertical-align:-0.0833em;"></span><span class="mord">×</span></span></span></span>',ta,aa,Te,na,ye,Kn="While training and evaluating we record the following reward metrics:",oa,we,Fn="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>logps/chosen</code>: the mean log probabilities of the chosen completions</li> <li><code>logps/rejected</code>: the mean log probabilities of the rejected completions</li> <li><code>logits/chosen</code>: the mean logits of the chosen completions</li> <li><code>logits/rejected</code>: the mean logits of the rejected completions</li> <li><code>kl</code>: the KL divergence between the policy model and the reference model</li>",ra,xe,la,c,$e,ka,Ae,jn="Initialize KTOTrainer.",Ma,N,Oe,Ca,De,Hn="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",La,K,ke,Na,qe,Pn="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Ka,k,Me,Fa,Re,In=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ja,Ve,zn="Works both with or without labels.",Ha,F,Ce,Pa,Ze,Un="Generate samples from the model and reference model for the given batch of inputs.",Ia,j,Le,za,Se,En="Compute the log probabilities of the given labels under the given logits.",Ua,H,Ne,Ea,Qe,Jn="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Ja,M,Ke,Wa,Ge,Wn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Ba,Xe,Bn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Aa,C,Fe,Da,Ye,An="Returns the training <code>~torch.utils.data.DataLoader</code>.",qa,et,Dn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Ra,P,je,Va,tt,qn="Compute the KTO loss for a batch of policy and reference model log probabilities.",Za,I,He,Sa,at,Rn="Log <code>logs</code> on the various objects watching training, including stored metrics.",Qa,z,Pe,Ga,nt,Vn="Context manager for handling null reference model (that is, peft adapter manipulation).",ia,Ie,sa,$,ze,Xa,ot,Zn='Configuration class for the <a href="/docs/trl/v0.15.0/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a>.',Ya,rt,Sn=`Using <a href="https://huggingface.co/docs/transformers/v4.49.0/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,da,Ue,ca,gt,pa;return U=new x({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),J=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),R=new x({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),S=new en({props:{code:"JTIzJTIwdHJhaW5fa3RvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMEtUT0NvbmZpZyUyQyUyMEtUT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGa3RvLW1peC0xNGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBLVE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLTAuNUItS1RPJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBLVE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_kto.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> KTOConfig, KTOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/kto-mix-14k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = KTOConfig(output_dir=<span class="hljs-string">&quot;Qwen2-0.5B-KTO&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = KTOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
trainer.train()`,wrap:!1}}),G=new en({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2t0by5weQ==",highlighted:"accelerate launch train_kto.py",wrap:!1}}),ae=new x({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),le=new x({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),de=new en({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRybCUyRnNjcmlwdHMlMkZrdG8ucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMFF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB0cmwtbGliJTJGa3RvLW1peC0xNGslMjAlNUMlMEElMjAlMjAlMjAlMjAtLW51bV90cmFpbl9lcG9jaHMlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMjUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBRd2VuMi0wLjVCLUtUTw==",highlighted:`accelerate launch trl/scripts/kto.py \\
    --model_name_or_path Qwen/Qwen2-0.5B-Instruct \\
    --dataset_name trl-lib/kto-mix-14k \\
    --num_train_epochs 1 \\
    --logging_steps 25 \\
    --output_dir Qwen2-0.5B-KTO`,wrap:!1}}),ce=new x({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),pe=new x({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),he=new x({props:{title:"Batch size recommendations",local:"batch-size-recommendations",headingTag:"h3"}}),ue=new x({props:{title:"Learning rate recommendations",local:"learning-rate-recommendations",headingTag:"h3"}}),ve=new x({props:{title:"Imbalanced data",local:"imbalanced-data",headingTag:"h3"}}),Te=new x({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),xe=new x({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),$e=new w({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[dict] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], dict]] = None"},{name:"model_adapter_name",val:": typing.Optional[str] = None"},{name:"ref_adapter_name",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>list[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L278"}}),Oe=new w({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L926"}}),ke=new w({props:{name:"create_model_card",anchor:"trl.KTOTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the model.`,name:"model_name"},{anchor:"trl.KTOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.KTOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1502"}}),Me=new w({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1406"}}),Ce=new w({props:{name:"generate_from_model_and_ref",anchor:"trl.KTOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1324"}}),Le=new w({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_batch_logps.logits",description:"<strong>logits</strong> &#x2014; Logits of the model (unnormalized). Shape: (batch_size, sequence_length, vocab_size)",name:"logits"},{anchor:"trl.KTOTrainer.get_batch_logps.labels",description:"<strong>labels</strong> &#x2014; Labels for which to compute the log probabilities. Label tokens with a value of label_pad_token_id are ignored. Shape: (batch_size, sequence_length)",name:"labels"},{anchor:"trl.KTOTrainer.get_batch_logps.average_log_prob",description:"<strong>average_log_prob</strong> &#x2014; If True, return the average log probability per (non-masked) token. Otherwise, return the sum of the log probabilities of the (non-masked) tokens.",name:"average_log_prob"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1005",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Ne=new w({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1196"}}),Ke=new w({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v3.3.1/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L871"}}),Fe=new w({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L827"}}),je=new w({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.KTOTrainer.kto_loss.policy_chosen_logps",description:"<strong>policy_chosen_logps</strong> &#x2014; Log probabilities of the policy model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"policy_chosen_logps"},{anchor:"trl.KTOTrainer.kto_loss.policy_rejected_logps",description:"<strong>policy_rejected_logps</strong> &#x2014; Log probabilities of the policy model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"policy_rejected_logps"},{anchor:"trl.KTOTrainer.kto_loss.policy_KL_logps",description:"<strong>policy_KL_logps</strong> &#x2014; Log probabilities of the policy model for the KL responses. Shape: (batch_size,)",name:"policy_KL_logps"},{anchor:"trl.KTOTrainer.kto_loss.reference_chosen_logps",description:"<strong>reference_chosen_logps</strong> &#x2014; Log probabilities of the reference model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"reference_chosen_logps"},{anchor:"trl.KTOTrainer.kto_loss.reference_rejected_logps",description:"<strong>reference_rejected_logps</strong> &#x2014; Log probabilities of the reference model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"reference_rejected_logps"},{anchor:"trl.KTOTrainer.kto_loss.reference_KL_logps",description:"<strong>reference_KL_logps</strong> &#x2014; Log probabilities of the reference model for the KL responses. Shape: (batch_size,)",name:"reference_KL_logps"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),He=new w({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": dict"},{name:"start_time",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"},{anchor:"trl.KTOTrainer.log.start_time",description:`<strong>start_time</strong> (<code>float</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Start time of the training.`,name:"start_time"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L1463"}}),Pe=new w({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_trainer.py#L813"}}),Ie=new x({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),ze=new w({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"max_length",val:": typing.Optional[int] = 1024"},{name:"max_prompt_length",val:": typing.Optional[int] = 512"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"beta",val:": float = 0.1"},{name:"loss_type",val:": str = 'kto'"},{name:"desirable_weight",val:": float = 1.0"},{name:"undesirable_weight",val:": float = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.KTOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5e-7</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/v4.49.0/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model.`,name:"beta"},{anchor:"trl.KTOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;kto&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;kto&quot;</code>: KTO loss from the <a href="https://huggingface.co/papers/2402.01306" rel="nofollow">KTO</a> paper.</li>
<li><code>&quot;apo_zero_unpaired&quot;</code>: Unpaired variant of APO-zero loss from the <a href="https://huggingface.co/papers/2408.06266" rel="nofollow">APO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from both the model and the reference model to W&amp;B or Comet during
evaluation.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.KTOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.KTOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.KTOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> &#x2014; (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.KTOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model and reference model.`,name:"disable_dropout"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/kto_config.py#L21"}}),Ue=new io({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/kto_trainer.md"}}),{c(){L=i("meta"),ht=n(),mt=i("p"),ft=n(),p(U.$$.fragment),ut=n(),E=i("p"),E.innerHTML=an,_t=n(),p(J.$$.fragment),vt=n(),W=i("p"),W.innerHTML=nn,bt=n(),B=i("p"),B.textContent=on,Tt=n(),A=i("blockquote"),A.innerHTML=rn,yt=n(),D=i("p"),D.innerHTML=ln,wt=n(),q=i("p"),q.innerHTML=sn,xt=n(),p(R.$$.fragment),$t=n(),V=i("p"),V.innerHTML=dn,Ot=n(),O=i("iframe"),kt=n(),Z=i("p"),Z.textContent=pn,Mt=n(),p(S.$$.fragment),Ct=n(),Q=i("p"),Q.textContent=mn,Lt=n(),p(G.$$.fragment),Nt=n(),X=i("p"),X.textContent=gn,Kt=n(),Y=i("p"),Y.innerHTML=hn,Ft=n(),ee=i("p"),ee.innerHTML=fn,jt=n(),te=i("pre"),te.innerHTML=un,Ht=n(),p(ae.$$.fragment),Pt=n(),ne=i("p"),ne.innerHTML=_n,It=n(),oe=i("p"),oe.innerHTML=vn,zt=n(),re=i("p"),re.innerHTML=bn,Ut=n(),p(le.$$.fragment),Et=n(),ie=i("p"),ie.innerHTML=Tn,Jt=n(),se=i("p"),se.innerHTML=yn,Wt=n(),p(de.$$.fragment),Bt=n(),p(ce.$$.fragment),At=n(),p(pe.$$.fragment),Dt=n(),me=i("p"),me.innerHTML=wn,qt=n(),ge=i("p"),ge.innerHTML=xn,Rt=n(),p(he.$$.fragment),Vt=n(),fe=i("p"),fe.textContent=$n,Zt=n(),p(ue.$$.fragment),St=n(),_e=i("p"),_e.innerHTML=On,Qt=n(),p(ve.$$.fragment),Gt=n(),v=i("p"),Ta=ct("The "),Ee=i("code"),Ee.textContent=kn,ya=ct(" and "),Je=i("code"),Je.textContent=Mn,wa=ct(" of the "),be=i("a"),be.textContent=Cn,xa=ct(` refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (`),We=i("code"),We.textContent=Ln,$a=n(),Xt=new Qn(!1),Yt=ct(" number of positives) to ("),Be=i("code"),Be.textContent=Nn,Oa=n(),ea=new Qn(!1),ta=ct(" number of negatives) is in the range 1:1 to 4:3."),aa=n(),p(Te.$$.fragment),na=n(),ye=i("p"),ye.textContent=Kn,oa=n(),we=i("ul"),we.innerHTML=Fn,ra=n(),p(xe.$$.fragment),la=n(),c=i("div"),p($e.$$.fragment),ka=n(),Ae=i("p"),Ae.textContent=jn,Ma=n(),N=i("div"),p(Oe.$$.fragment),Ca=n(),De=i("p"),De.textContent=Hn,La=n(),K=i("div"),p(ke.$$.fragment),Na=n(),qe=i("p"),qe.innerHTML=Pn,Ka=n(),k=i("div"),p(Me.$$.fragment),Fa=n(),Re=i("p"),Re.innerHTML=In,ja=n(),Ve=i("p"),Ve.textContent=zn,Ha=n(),F=i("div"),p(Ce.$$.fragment),Pa=n(),Ze=i("p"),Ze.textContent=Un,Ia=n(),j=i("div"),p(Le.$$.fragment),za=n(),Se=i("p"),Se.textContent=En,Ua=n(),H=i("div"),p(Ne.$$.fragment),Ea=n(),Qe=i("p"),Qe.textContent=Jn,Ja=n(),M=i("div"),p(Ke.$$.fragment),Wa=n(),Ge=i("p"),Ge.innerHTML=Wn,Ba=n(),Xe=i("p"),Xe.innerHTML=Bn,Aa=n(),C=i("div"),p(Fe.$$.fragment),Da=n(),Ye=i("p"),Ye.innerHTML=An,qa=n(),et=i("p"),et.innerHTML=Dn,Ra=n(),P=i("div"),p(je.$$.fragment),Va=n(),tt=i("p"),tt.textContent=qn,Za=n(),I=i("div"),p(He.$$.fragment),Sa=n(),at=i("p"),at.innerHTML=Rn,Qa=n(),z=i("div"),p(Pe.$$.fragment),Ga=n(),nt=i("p"),nt.textContent=Vn,ia=n(),p(Ie.$$.fragment),sa=n(),$=i("div"),p(ze.$$.fragment),Xa=n(),ot=i("p"),ot.innerHTML=Zn,Ya=n(),rt=i("p"),rt.innerHTML=Sn,da=n(),p(Ue.$$.fragment),ca=n(),gt=i("p"),this.h()},l(e){const t=lo("svelte-u9bgzb",document.head);L=s(t,"META",{name:!0,content:!0}),t.forEach(a),ht=o(e),mt=s(e,"P",{}),T(mt).forEach(a),ft=o(e),m(U.$$.fragment,e),ut=o(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1pjg7ok"&&(E.innerHTML=an),_t=o(e),m(J.$$.fragment,e),vt=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1ad6dt3"&&(W.innerHTML=nn),bt=o(e),B=s(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-vfdo9a"&&(B.textContent=on),Tt=o(e),A=s(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(A)!=="svelte-1nbtzvm"&&(A.innerHTML=rn),yt=o(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-crl8e"&&(D.innerHTML=ln),wt=o(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1u5zm0"&&(q.innerHTML=sn),xt=o(e),m(R.$$.fragment,e),$t=o(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-gsvz84"&&(V.innerHTML=dn),Ot=o(e),O=s(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),T(O).forEach(a),kt=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-uqytq6"&&(Z.textContent=pn),Mt=o(e),m(S.$$.fragment,e),Ct=o(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-15hino8"&&(Q.textContent=mn),Lt=o(e),m(G.$$.fragment,e),Nt=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1396wsd"&&(X.textContent=gn),Kt=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1uxw1l0"&&(Y.innerHTML=hn),Ft=o(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-ucm2bp"&&(ee.innerHTML=fn),jt=o(e),te=s(e,"PRE",{"data-svelte-h":!0}),d(te)!=="svelte-81578k"&&(te.innerHTML=un),Ht=o(e),m(ae.$$.fragment,e),Pt=o(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-16phm6w"&&(ne.innerHTML=_n),It=o(e),oe=s(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-125i2cx"&&(oe.innerHTML=vn),zt=o(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-4iifkd"&&(re.innerHTML=bn),Ut=o(e),m(le.$$.fragment,e),Et=o(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1cezwm0"&&(ie.innerHTML=Tn),Jt=o(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-nsomyf"&&(se.innerHTML=yn),Wt=o(e),m(de.$$.fragment,e),Bt=o(e),m(ce.$$.fragment,e),At=o(e),m(pe.$$.fragment,e),Dt=o(e),me=s(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-14px1ga"&&(me.innerHTML=wn),qt=o(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-z2ii65"&&(ge.innerHTML=xn),Rt=o(e),m(he.$$.fragment,e),Vt=o(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-z34k5y"&&(fe.textContent=$n),Zt=o(e),m(ue.$$.fragment,e),St=o(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1gf2zn8"&&(_e.innerHTML=On),Qt=o(e),m(ve.$$.fragment,e),Gt=o(e),v=s(e,"P",{});var y=T(v);Ta=pt(y,"The "),Ee=s(y,"CODE",{"data-svelte-h":!0}),d(Ee)!=="svelte-1s37gb0"&&(Ee.textContent=kn),ya=pt(y," and "),Je=s(y,"CODE",{"data-svelte-h":!0}),d(Je)!=="svelte-ddv9an"&&(Je.textContent=Mn),wa=pt(y," of the "),be=s(y,"A",{href:!0,"data-svelte-h":!0}),d(be)!=="svelte-6hnu1a"&&(be.textContent=Cn),xa=pt(y,` refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (`),We=s(y,"CODE",{"data-svelte-h":!0}),d(We)!=="svelte-1s37gb0"&&(We.textContent=Ln),$a=o(y),Xt=Gn(y,!1),Yt=pt(y," number of positives) to ("),Be=s(y,"CODE",{"data-svelte-h":!0}),d(Be)!=="svelte-ddv9an"&&(Be.textContent=Nn),Oa=o(y),ea=Gn(y,!1),ta=pt(y," number of negatives) is in the range 1:1 to 4:3."),y.forEach(a),aa=o(e),m(Te.$$.fragment,e),na=o(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-132s7j9"&&(ye.textContent=Kn),oa=o(e),we=s(e,"UL",{"data-svelte-h":!0}),d(we)!=="svelte-1tas4fp"&&(we.innerHTML=Fn),ra=o(e),m(xe.$$.fragment,e),la=o(e),c=s(e,"DIV",{class:!0});var _=T(c);m($e.$$.fragment,_),ka=o(_),Ae=s(_,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-hyhzxp"&&(Ae.textContent=jn),Ma=o(_),N=s(_,"DIV",{class:!0});var ma=T(N);m(Oe.$$.fragment,ma),Ca=o(ma),De=s(ma,"P",{"data-svelte-h":!0}),d(De)!=="svelte-pt6g01"&&(De.textContent=Hn),ma.forEach(a),La=o(_),K=s(_,"DIV",{class:!0});var ga=T(K);m(ke.$$.fragment,ga),Na=o(ga),qe=s(ga,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1mh859w"&&(qe.innerHTML=Pn),ga.forEach(a),Ka=o(_),k=s(_,"DIV",{class:!0});var lt=T(k);m(Me.$$.fragment,lt),Fa=o(lt),Re=s(lt,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-8qlty5"&&(Re.innerHTML=In),ja=o(lt),Ve=s(lt,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1tyo99t"&&(Ve.textContent=zn),lt.forEach(a),Ha=o(_),F=s(_,"DIV",{class:!0});var ha=T(F);m(Ce.$$.fragment,ha),Pa=o(ha),Ze=s(ha,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-18uwvbi"&&(Ze.textContent=Un),ha.forEach(a),Ia=o(_),j=s(_,"DIV",{class:!0});var fa=T(j);m(Le.$$.fragment,fa),za=o(fa),Se=s(fa,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-4nmimv"&&(Se.textContent=En),fa.forEach(a),Ua=o(_),H=s(_,"DIV",{class:!0});var ua=T(H);m(Ne.$$.fragment,ua),Ea=o(ua),Qe=s(ua,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-db7iek"&&(Qe.textContent=Jn),ua.forEach(a),Ja=o(_),M=s(_,"DIV",{class:!0});var it=T(M);m(Ke.$$.fragment,it),Wa=o(it),Ge=s(it,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-xesobz"&&(Ge.innerHTML=Wn),Ba=o(it),Xe=s(it,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-qg43tm"&&(Xe.innerHTML=Bn),it.forEach(a),Aa=o(_),C=s(_,"DIV",{class:!0});var st=T(C);m(Fe.$$.fragment,st),Da=o(st),Ye=s(st,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-dkae9b"&&(Ye.innerHTML=An),qa=o(st),et=s(st,"P",{"data-svelte-h":!0}),d(et)!=="svelte-hmd5cw"&&(et.innerHTML=Dn),st.forEach(a),Ra=o(_),P=s(_,"DIV",{class:!0});var _a=T(P);m(je.$$.fragment,_a),Va=o(_a),tt=s(_a,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-svckwe"&&(tt.textContent=qn),_a.forEach(a),Za=o(_),I=s(_,"DIV",{class:!0});var va=T(I);m(He.$$.fragment,va),Sa=o(va),at=s(va,"P",{"data-svelte-h":!0}),d(at)!=="svelte-nqksfz"&&(at.innerHTML=Rn),va.forEach(a),Qa=o(_),z=s(_,"DIV",{class:!0});var ba=T(z);m(Pe.$$.fragment,ba),Ga=o(ba),nt=s(ba,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-17kjsy4"&&(nt.textContent=Vn),ba.forEach(a),_.forEach(a),ia=o(e),m(Ie.$$.fragment,e),sa=o(e),$=s(e,"DIV",{class:!0});var dt=T($);m(ze.$$.fragment,dt),Xa=o(dt),ot=s(dt,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-eveoiv"&&(ot.innerHTML=Zn),Ya=o(dt),rt=s(dt,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-2adg1n"&&(rt.innerHTML=Sn),dt.forEach(a),da=o(e),m(Ue.$$.fragment,e),ca=o(e),gt=s(e,"P",{}),T(gt).forEach(a),this.h()},h(){b(L,"name","hf:doc:metadata"),b(L,"content",co),to(O.src,cn="https://huggingface.co/datasets/trl-lib/kto-mix-14k/embed/viewer/default/train?row=0")||b(O,"src",cn),b(O,"frameborder","0"),b(O,"width","100%"),b(O,"height","560px"),b(be,"href","/docs/trl/v0.15.0/en/kto_trainer#trl.KTOConfig"),Xt.a=Yt,ea.a=ta,b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,L),r(e,ht,t),r(e,mt,t),r(e,ft,t),g(U,e,t),r(e,ut,t),r(e,E,t),r(e,_t,t),g(J,e,t),r(e,vt,t),r(e,W,t),r(e,bt,t),r(e,B,t),r(e,Tt,t),r(e,A,t),r(e,yt,t),r(e,D,t),r(e,wt,t),r(e,q,t),r(e,xt,t),g(R,e,t),r(e,$t,t),r(e,V,t),r(e,Ot,t),r(e,O,t),r(e,kt,t),r(e,Z,t),r(e,Mt,t),g(S,e,t),r(e,Ct,t),r(e,Q,t),r(e,Lt,t),g(G,e,t),r(e,Nt,t),r(e,X,t),r(e,Kt,t),r(e,Y,t),r(e,Ft,t),r(e,ee,t),r(e,jt,t),r(e,te,t),r(e,Ht,t),g(ae,e,t),r(e,Pt,t),r(e,ne,t),r(e,It,t),r(e,oe,t),r(e,zt,t),r(e,re,t),r(e,Ut,t),g(le,e,t),r(e,Et,t),r(e,ie,t),r(e,Jt,t),r(e,se,t),r(e,Wt,t),g(de,e,t),r(e,Bt,t),g(ce,e,t),r(e,At,t),g(pe,e,t),r(e,Dt,t),r(e,me,t),r(e,qt,t),r(e,ge,t),r(e,Rt,t),g(he,e,t),r(e,Vt,t),r(e,fe,t),r(e,Zt,t),g(ue,e,t),r(e,St,t),r(e,_e,t),r(e,Qt,t),g(ve,e,t),r(e,Gt,t),r(e,v,t),l(v,Ta),l(v,Ee),l(v,ya),l(v,Je),l(v,wa),l(v,be),l(v,xa),l(v,We),l(v,$a),Xt.m(Xn,v),l(v,Yt),l(v,Be),l(v,Oa),ea.m(Yn,v),l(v,ta),r(e,aa,t),g(Te,e,t),r(e,na,t),r(e,ye,t),r(e,oa,t),r(e,we,t),r(e,ra,t),g(xe,e,t),r(e,la,t),r(e,c,t),g($e,c,null),l(c,ka),l(c,Ae),l(c,Ma),l(c,N),g(Oe,N,null),l(N,Ca),l(N,De),l(c,La),l(c,K),g(ke,K,null),l(K,Na),l(K,qe),l(c,Ka),l(c,k),g(Me,k,null),l(k,Fa),l(k,Re),l(k,ja),l(k,Ve),l(c,Ha),l(c,F),g(Ce,F,null),l(F,Pa),l(F,Ze),l(c,Ia),l(c,j),g(Le,j,null),l(j,za),l(j,Se),l(c,Ua),l(c,H),g(Ne,H,null),l(H,Ea),l(H,Qe),l(c,Ja),l(c,M),g(Ke,M,null),l(M,Wa),l(M,Ge),l(M,Ba),l(M,Xe),l(c,Aa),l(c,C),g(Fe,C,null),l(C,Da),l(C,Ye),l(C,qa),l(C,et),l(c,Ra),l(c,P),g(je,P,null),l(P,Va),l(P,tt),l(c,Za),l(c,I),g(He,I,null),l(I,Sa),l(I,at),l(c,Qa),l(c,z),g(Pe,z,null),l(z,Ga),l(z,nt),r(e,ia,t),g(Ie,e,t),r(e,sa,t),r(e,$,t),g(ze,$,null),l($,Xa),l($,ot),l($,Ya),l($,rt),r(e,da,t),g(Ue,e,t),r(e,ca,t),r(e,gt,t),pa=!0},p:ao,i(e){pa||(h(U.$$.fragment,e),h(J.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(G.$$.fragment,e),h(ae.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(ve.$$.fragment,e),h(Te.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(Oe.$$.fragment,e),h(ke.$$.fragment,e),h(Me.$$.fragment,e),h(Ce.$$.fragment,e),h(Le.$$.fragment,e),h(Ne.$$.fragment,e),h(Ke.$$.fragment,e),h(Fe.$$.fragment,e),h(je.$$.fragment,e),h(He.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(ze.$$.fragment,e),h(Ue.$$.fragment,e),pa=!0)},o(e){f(U.$$.fragment,e),f(J.$$.fragment,e),f(R.$$.fragment,e),f(S.$$.fragment,e),f(G.$$.fragment,e),f(ae.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Oe.$$.fragment,e),f(ke.$$.fragment,e),f(Me.$$.fragment,e),f(Ce.$$.fragment,e),f(Le.$$.fragment,e),f(Ne.$$.fragment,e),f(Ke.$$.fragment,e),f(Fe.$$.fragment,e),f(je.$$.fragment,e),f(He.$$.fragment,e),f(Pe.$$.fragment,e),f(Ie.$$.fragment,e),f(ze.$$.fragment,e),f(Ue.$$.fragment,e),pa=!1},d(e){e&&(a(ht),a(mt),a(ft),a(ut),a(E),a(_t),a(vt),a(W),a(bt),a(B),a(Tt),a(A),a(yt),a(D),a(wt),a(q),a(xt),a($t),a(V),a(Ot),a(O),a(kt),a(Z),a(Mt),a(Ct),a(Q),a(Lt),a(Nt),a(X),a(Kt),a(Y),a(Ft),a(ee),a(jt),a(te),a(Ht),a(Pt),a(ne),a(It),a(oe),a(zt),a(re),a(Ut),a(Et),a(ie),a(Jt),a(se),a(Wt),a(Bt),a(At),a(Dt),a(me),a(qt),a(ge),a(Rt),a(Vt),a(fe),a(Zt),a(St),a(_e),a(Qt),a(Gt),a(v),a(aa),a(na),a(ye),a(oa),a(we),a(ra),a(la),a(c),a(ia),a(sa),a($),a(da),a(ca),a(gt)),a(L),u(U,e),u(J,e),u(R,e),u(S,e),u(G,e),u(ae,e),u(le,e),u(de,e),u(ce,e),u(pe,e),u(he,e),u(ue,e),u(ve,e),u(Te,e),u(xe,e),u($e),u(Oe),u(ke),u(Me),u(Ce),u(Le),u(Ne),u(Ke),u(Fe),u(je),u(He),u(Pe),u(Ie,e),u(ze),u(Ue,e)}}}const co='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3},{"title":"Batch size recommendations","local":"batch-size-recommendations","sections":[],"depth":3},{"title":"Learning rate recommendations","local":"learning-rate-recommendations","sections":[],"depth":3},{"title":"Imbalanced data","local":"imbalanced-data","sections":[],"depth":3}],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function po(tn){return no(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _o extends oo{constructor(L){super(),ro(this,L,po,so,eo,{})}}export{_o as component};
