import{s as Ja,n as ka,o as Ia}from"../chunks/scheduler.a2b4ca8e.js";import{S as Na,i as Aa,g as r,s as o,r as p,A as Fa,h as s,f as t,c as l,j as v,u as _,x as m,k as b,y as n,a as i,v as h,d as u,t as g,w as f}from"../chunks/index.f6e1d51d.js";import{D as T}from"../chunks/Docstring.e7c4afb2.js";import{C as Vt}from"../chunks/CodeBlock.9607aa3b.js";import{H as fe,E as Ka}from"../chunks/EditOnGithub.d27dc01b.js";function Ea(Yt){let $,ze,qe,He,A,Pe,F,ea=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,Be,K,ta=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,We,E,Qe,L,aa="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",Se,q,na="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Re,D,oa="for example:",Ze,z,Xe,H,la=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.`,Ge,P,Ve,B,ra="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Ye,W,et,Q,sa="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",tt,S,ia="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",at,R,da=`The <code>desirable_weight</code> and <code>undesirable_weight</code> refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (<code>desirable_weight</code> <em>number of positives) to (<code>undesirable_weight</code></em> number of negatives) is in the range 1:1 to 4:3.`,nt,Z,ot,X,ma="After this one can then call:",lt,G,rt,V,st,Y,ca="Given the binary signal data indicating whether a completion is desirable or undesirable for a prompt, we can optimize an implicit reward function that aligns with the key principles of Kahneman-Tversky’s prospect theory, such as reference dependence, loss aversion, and diminishing sensitivity.",it,ee,pa=`The <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0.
The <code>KTOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;bco&quot;</code> argument.`,dt,te,mt,d,ae,Ct,ve,_a="Initialize KTOTrainer.",$t,U,ne,Ut,be,ha="Compute the BCO loss for a batch of policy and reference model log probabilities.",xt,x,oe,Ot,Te,ua="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",jt,y,le,Jt,Me,ga=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,kt,ye,fa="Works both with or without labels.",It,O,re,Nt,we,va="Compute the log probabilities of the given labels under the given logits.",At,j,se,Ft,Ce,ba="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Kt,J,ie,Et,$e,Ta="Generate samples from the model and reference model for the given batch of inputs.",Lt,w,de,qt,Ue,Ma="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Dt,xe,ya="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",zt,C,me,Ht,Oe,wa="Returns the training <code>~torch.utils.data.DataLoader</code>.",Pt,je,Ca="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Bt,k,ce,Wt,Je,$a="Compute the KTO loss for a batch of policy and reference model log probabilities.",Qt,I,pe,St,ke,Ua="Log <code>logs</code> on the various objects watching training, including stored metrics.",Rt,N,_e,Zt,Ie,xa="Context manager for handling null reference model (that is, peft adapter manipulation).",ct,he,pt,M,ue,Xt,Ne,Oa='KTOConfig collects all training arguments related to the <a href="/docs/trl/v0.9.2/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> class.',Gt,Ae,ja=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,_t,ge,ht,De,ut;return A=new fe({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),E=new fe({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),z=new Vt({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),P=new fe({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),W=new fe({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),Z=new Vt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMHVuZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSklMEElMEFrdG9fdHJhaW5lciUyMCUzRCUyMEtUT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9yZWYlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
    desirable_weight=<span class="hljs-number">1.0</span>,
    undesirable_weight=<span class="hljs-number">1.0</span>,
)

kto_trainer = KTOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),G=new Vt({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),V=new fe({props:{title:"Loss Functions",local:"loss-functions",headingTag:"h2"}}),te=new fe({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),ae=new T({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"embedding_func",val:": Optional = None"},{name:"embedding_tokenizer",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.KTOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.KTOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L269"}}),ne=new T({props:{name:"bco_loss",anchor:"trl.KTOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": Optional"},{name:"rejected_embeddings",val:": Optional"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1207",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),oe=new T({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L970"}}),le=new T({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1464"}}),re=new T({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1042",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),se=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1257"}}),ie=new T({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1378"}}),de=new T({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <code>Dataset</code>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L917"}}),me=new T({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L876"}}),ce=new T({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1145",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),pe=new T({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L1520"}}),_e=new T({props:{name:"null_ref_context",anchor:"trl.KTOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_trainer.py#L864"}}),he=new fe({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),ue=new T({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"loss_type",val:": Literal = 'kto'"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.
dataset_num_proc &#x2014; (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>):
Number of processes to use for processing the datasets.
loss_type &#x2014; (<code>Literal[&quot;kto&quot;, &quot;bco&quot;]</code>, <em>optional</em>):
The type of loss to use. Either <code>&quot;kto&quot;</code> the default KTO loss, <code>&quot;bco&quot;</code> loss from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper.
prompt_sample_size &#x2014; (<code>int</code>, defaults to 1024):
Number of prompts that are fed to density ratio classifier.
min_density_ratio &#x2014; (<code>float</code>, defaults to 0.5):
The minimum value of the density ratio. The estimated density ratio is clamped to this value.
max_density_ratio &#x2014; (<code>float</code>, defaults to 10.0):
The maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/v0.9.2/trl/trainer/kto_config.py#L22"}}),ge=new Ka({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/kto_trainer.mdx"}}),{c(){$=r("meta"),ze=o(),qe=r("p"),He=o(),p(A.$$.fragment),Pe=o(),F=r("p"),F.innerHTML=ea,Be=o(),K=r("p"),K.textContent=ta,We=o(),p(E.$$.fragment),Qe=o(),L=r("p"),L.textContent=aa,Se=o(),q=r("ul"),q.innerHTML=na,Re=o(),D=r("p"),D.textContent=oa,Ze=o(),p(z.$$.fragment),Xe=o(),H=r("p"),H.innerHTML=la,Ge=o(),p(P.$$.fragment),Ve=o(),B=r("p"),B.innerHTML=ra,Ye=o(),p(W.$$.fragment),et=o(),Q=r("p"),Q.innerHTML=sa,tt=o(),S=r("p"),S.innerHTML=ia,at=o(),R=r("p"),R.innerHTML=da,nt=o(),p(Z.$$.fragment),ot=o(),X=r("p"),X.textContent=ma,lt=o(),p(G.$$.fragment),rt=o(),p(V.$$.fragment),st=o(),Y=r("p"),Y.textContent=ca,it=o(),ee=r("p"),ee.innerHTML=pa,dt=o(),p(te.$$.fragment),mt=o(),d=r("div"),p(ae.$$.fragment),Ct=o(),ve=r("p"),ve.textContent=_a,$t=o(),U=r("div"),p(ne.$$.fragment),Ut=o(),be=r("p"),be.textContent=ha,xt=o(),x=r("div"),p(oe.$$.fragment),Ot=o(),Te=r("p"),Te.textContent=ua,jt=o(),y=r("div"),p(le.$$.fragment),Jt=o(),Me=r("p"),Me.innerHTML=ga,kt=o(),ye=r("p"),ye.textContent=fa,It=o(),O=r("div"),p(re.$$.fragment),Nt=o(),we=r("p"),we.textContent=va,At=o(),j=r("div"),p(se.$$.fragment),Ft=o(),Ce=r("p"),Ce.textContent=ba,Kt=o(),J=r("div"),p(ie.$$.fragment),Et=o(),$e=r("p"),$e.textContent=Ta,Lt=o(),w=r("div"),p(de.$$.fragment),qt=o(),Ue=r("p"),Ue.innerHTML=Ma,Dt=o(),xe=r("p"),xe.innerHTML=ya,zt=o(),C=r("div"),p(me.$$.fragment),Ht=o(),Oe=r("p"),Oe.innerHTML=wa,Pt=o(),je=r("p"),je.innerHTML=Ca,Bt=o(),k=r("div"),p(ce.$$.fragment),Wt=o(),Je=r("p"),Je.textContent=$a,Qt=o(),I=r("div"),p(pe.$$.fragment),St=o(),ke=r("p"),ke.innerHTML=Ua,Rt=o(),N=r("div"),p(_e.$$.fragment),Zt=o(),Ie=r("p"),Ie.textContent=xa,ct=o(),p(he.$$.fragment),pt=o(),M=r("div"),p(ue.$$.fragment),Xt=o(),Ne=r("p"),Ne.innerHTML=Oa,Gt=o(),Ae=r("p"),Ae.innerHTML=ja,_t=o(),p(ge.$$.fragment),ht=o(),De=r("p"),this.h()},l(e){const a=Fa("svelte-u9bgzb",document.head);$=s(a,"META",{name:!0,content:!0}),a.forEach(t),ze=l(e),qe=s(e,"P",{}),v(qe).forEach(t),He=l(e),_(A.$$.fragment,e),Pe=l(e),F=s(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-171dbf3"&&(F.innerHTML=ea),Be=l(e),K=s(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-z1e9ri"&&(K.textContent=ta),We=l(e),_(E.$$.fragment,e),Qe=l(e),L=s(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1792bye"&&(L.textContent=aa),Se=l(e),q=s(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-1bk1n3o"&&(q.innerHTML=na),Re=l(e),D=s(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1gl9mvz"&&(D.textContent=oa),Ze=l(e),_(z.$$.fragment,e),Xe=l(e),H=s(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-109yt43"&&(H.innerHTML=la),Ge=l(e),_(P.$$.fragment,e),Ve=l(e),B=s(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-znx0uh"&&(B.innerHTML=ra),Ye=l(e),_(W.$$.fragment,e),et=l(e),Q=s(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-6k9bp8"&&(Q.innerHTML=sa),tt=l(e),S=s(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1eil2tw"&&(S.innerHTML=ia),at=l(e),R=s(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-ad0vsu"&&(R.innerHTML=da),nt=l(e),_(Z.$$.fragment,e),ot=l(e),X=s(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1lg6q1l"&&(X.textContent=ma),lt=l(e),_(G.$$.fragment,e),rt=l(e),_(V.$$.fragment,e),st=l(e),Y=s(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-17cemnt"&&(Y.textContent=ca),it=l(e),ee=s(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-ohsb6n"&&(ee.innerHTML=pa),dt=l(e),_(te.$$.fragment,e),mt=l(e),d=s(e,"DIV",{class:!0});var c=v(d);_(ae.$$.fragment,c),Ct=l(c),ve=s(c,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-hyhzxp"&&(ve.textContent=_a),$t=l(c),U=s(c,"DIV",{class:!0});var gt=v(U);_(ne.$$.fragment,gt),Ut=l(gt),be=s(gt,"P",{"data-svelte-h":!0}),m(be)!=="svelte-2814fy"&&(be.textContent=ha),gt.forEach(t),xt=l(c),x=s(c,"DIV",{class:!0});var ft=v(x);_(oe.$$.fragment,ft),Ot=l(ft),Te=s(ft,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-pt6g01"&&(Te.textContent=ua),ft.forEach(t),jt=l(c),y=s(c,"DIV",{class:!0});var Fe=v(y);_(le.$$.fragment,Fe),Jt=l(Fe),Me=s(Fe,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-8qlty5"&&(Me.innerHTML=ga),kt=l(Fe),ye=s(Fe,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1tyo99t"&&(ye.textContent=fa),Fe.forEach(t),It=l(c),O=s(c,"DIV",{class:!0});var vt=v(O);_(re.$$.fragment,vt),Nt=l(vt),we=s(vt,"P",{"data-svelte-h":!0}),m(we)!=="svelte-4nmimv"&&(we.textContent=va),vt.forEach(t),At=l(c),j=s(c,"DIV",{class:!0});var bt=v(j);_(se.$$.fragment,bt),Ft=l(bt),Ce=s(bt,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-db7iek"&&(Ce.textContent=ba),bt.forEach(t),Kt=l(c),J=s(c,"DIV",{class:!0});var Tt=v(J);_(ie.$$.fragment,Tt),Et=l(Tt),$e=s(Tt,"P",{"data-svelte-h":!0}),m($e)!=="svelte-18uwvbi"&&($e.textContent=Ta),Tt.forEach(t),Lt=l(c),w=s(c,"DIV",{class:!0});var Ke=v(w);_(de.$$.fragment,Ke),qt=l(Ke),Ue=s(Ke,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-xesobz"&&(Ue.innerHTML=Ma),Dt=l(Ke),xe=s(Ke,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-qg43tm"&&(xe.innerHTML=ya),Ke.forEach(t),zt=l(c),C=s(c,"DIV",{class:!0});var Ee=v(C);_(me.$$.fragment,Ee),Ht=l(Ee),Oe=s(Ee,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-dkae9b"&&(Oe.innerHTML=wa),Pt=l(Ee),je=s(Ee,"P",{"data-svelte-h":!0}),m(je)!=="svelte-hmd5cw"&&(je.innerHTML=Ca),Ee.forEach(t),Bt=l(c),k=s(c,"DIV",{class:!0});var Mt=v(k);_(ce.$$.fragment,Mt),Wt=l(Mt),Je=s(Mt,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-svckwe"&&(Je.textContent=$a),Mt.forEach(t),Qt=l(c),I=s(c,"DIV",{class:!0});var yt=v(I);_(pe.$$.fragment,yt),St=l(yt),ke=s(yt,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-nqksfz"&&(ke.innerHTML=Ua),yt.forEach(t),Rt=l(c),N=s(c,"DIV",{class:!0});var wt=v(N);_(_e.$$.fragment,wt),Zt=l(wt),Ie=s(wt,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-17kjsy4"&&(Ie.textContent=xa),wt.forEach(t),c.forEach(t),ct=l(e),_(he.$$.fragment,e),pt=l(e),M=s(e,"DIV",{class:!0});var Le=v(M);_(ue.$$.fragment,Le),Xt=l(Le),Ne=s(Le,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1bna7gj"&&(Ne.innerHTML=Oa),Gt=l(Le),Ae=s(Le,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-1xl7jqc"&&(Ae.innerHTML=ja),Le.forEach(t),_t=l(e),_(ge.$$.fragment,e),ht=l(e),De=s(e,"P",{}),v(De).forEach(t),this.h()},h(){b($,"name","hf:doc:metadata"),b($,"content",La),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,$),i(e,ze,a),i(e,qe,a),i(e,He,a),h(A,e,a),i(e,Pe,a),i(e,F,a),i(e,Be,a),i(e,K,a),i(e,We,a),h(E,e,a),i(e,Qe,a),i(e,L,a),i(e,Se,a),i(e,q,a),i(e,Re,a),i(e,D,a),i(e,Ze,a),h(z,e,a),i(e,Xe,a),i(e,H,a),i(e,Ge,a),h(P,e,a),i(e,Ve,a),i(e,B,a),i(e,Ye,a),h(W,e,a),i(e,et,a),i(e,Q,a),i(e,tt,a),i(e,S,a),i(e,at,a),i(e,R,a),i(e,nt,a),h(Z,e,a),i(e,ot,a),i(e,X,a),i(e,lt,a),h(G,e,a),i(e,rt,a),h(V,e,a),i(e,st,a),i(e,Y,a),i(e,it,a),i(e,ee,a),i(e,dt,a),h(te,e,a),i(e,mt,a),i(e,d,a),h(ae,d,null),n(d,Ct),n(d,ve),n(d,$t),n(d,U),h(ne,U,null),n(U,Ut),n(U,be),n(d,xt),n(d,x),h(oe,x,null),n(x,Ot),n(x,Te),n(d,jt),n(d,y),h(le,y,null),n(y,Jt),n(y,Me),n(y,kt),n(y,ye),n(d,It),n(d,O),h(re,O,null),n(O,Nt),n(O,we),n(d,At),n(d,j),h(se,j,null),n(j,Ft),n(j,Ce),n(d,Kt),n(d,J),h(ie,J,null),n(J,Et),n(J,$e),n(d,Lt),n(d,w),h(de,w,null),n(w,qt),n(w,Ue),n(w,Dt),n(w,xe),n(d,zt),n(d,C),h(me,C,null),n(C,Ht),n(C,Oe),n(C,Pt),n(C,je),n(d,Bt),n(d,k),h(ce,k,null),n(k,Wt),n(k,Je),n(d,Qt),n(d,I),h(pe,I,null),n(I,St),n(I,ke),n(d,Rt),n(d,N),h(_e,N,null),n(N,Zt),n(N,Ie),i(e,ct,a),h(he,e,a),i(e,pt,a),i(e,M,a),h(ue,M,null),n(M,Xt),n(M,Ne),n(M,Gt),n(M,Ae),i(e,_t,a),h(ge,e,a),i(e,ht,a),i(e,De,a),ut=!0},p:ka,i(e){ut||(u(A.$$.fragment,e),u(E.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(_e.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),ut=!0)},o(e){g(A.$$.fragment,e),g(E.$$.fragment,e),g(z.$$.fragment,e),g(P.$$.fragment,e),g(W.$$.fragment,e),g(Z.$$.fragment,e),g(G.$$.fragment,e),g(V.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(_e.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),ut=!1},d(e){e&&(t(ze),t(qe),t(He),t(Pe),t(F),t(Be),t(K),t(We),t(Qe),t(L),t(Se),t(q),t(Re),t(D),t(Ze),t(Xe),t(H),t(Ge),t(Ve),t(B),t(Ye),t(et),t(Q),t(tt),t(S),t(at),t(R),t(nt),t(ot),t(X),t(lt),t(rt),t(st),t(Y),t(it),t(ee),t(dt),t(mt),t(d),t(ct),t(pt),t(M),t(_t),t(ht),t(De)),t($),f(A,e),f(E,e),f(z,e),f(P,e),f(W,e),f(Z,e),f(G,e),f(V,e),f(te,e),f(ae),f(ne),f(oe),f(le),f(re),f(se),f(ie),f(de),f(me),f(ce),f(pe),f(_e),f(he,e),f(ue),f(ge,e)}}}const La='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"Loss Functions","local":"loss-functions","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function qa(Yt){return Ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends Na{constructor($){super(),Aa(this,$,qa,Ea,Ja,{})}}export{Wa as component};
