import{s as ye,n as je,o as ge}from"../chunks/scheduler.85c25b89.js";import{S as we,i as fe,g as l,s as o,u as c,A as Je,h as n,f as e,c as p,j as h,v as M,y as m,k as i,o as r,a,w as d,d as u,t as y,x as j}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function be(Ft){let g,ht,st,mt,w,U,at,Z,Qt,D,Xt="ResNeSt",ct,x,Ht='A <strong>ResNeSt</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a>, which instead stacks <a href="https://paperswithcode.com/method/split-attention" rel="nofollow">Split-Attention blocks</a>. The cardinal group representations are then concatenated along the channel dimension: $V = \\text{Concat}${$V^{1},V^{2},\\cdots{V}^{K}$}. As in standard residual blocks, the final output $Y$ of otheur Split-Attention block is produced using a shortcut connection: $Y=V+X$, if the input and output feature-map share the same shape.  For blocks with a stride, an appropriate transformation $\\mathcal{T}$ is applied to the shortcut connection to align the output shapes:  $Y=V+\\mathcal{T}(X)$. For example, $\\mathcal{T}$ can be strided convolution or combined convolution-with-pooling.',Mt,f,v,lt,I,St,q,zt="How do I use this model on an image?",dt,W,Pt="To load a pretrained model:",ut,E,yt,N,Lt="To load and preprocess the image:",jt,B,gt,G,Dt="To get the model predictions:",wt,A,ft,_,qt="To get the top-5 predictions class names:",Jt,Q,bt,S,Kt="Replace the model name with the variant you want to use, e.g. <code>resnest101e</code>. You can find the IDs in the model summaries at the top of this page.",Tt,R,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ut,J,C,nt,V,Rt,K,te="How do I finetune this model?",vt,Y,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,F,kt,X,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,$t,b,k,ot,H,Vt,O,ae="How do I train this model?",Zt,z,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',xt,T,$,pt,P,Yt,tt,ne="Citation",It,L,Wt,it,Et;return Z=new rt({}),I=new rt({}),E=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25lc3QxMDFlJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnest101e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),B=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),A=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new rt({}),F=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmVzdDEwMWUnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnest101e&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),H=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QnpoYW5nMjAyMHJlc25lc3QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlJlc05lU3QlM0ElMjBTcGxpdC1BdHRlbnRpb24lMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkhhbmclMjBaaGFuZyUyMGFuZCUyMENob25ncnVvJTIwV3UlMjBhbmQlMjBaaG9uZ3l1ZSUyMFpoYW5nJTIwYW5kJTIwWWklMjBaaHUlMjBhbmQlMjBIYWliaW4lMjBMaW4lMjBhbmQlMjBaaGklMjBaaGFuZyUyMGFuZCUyMFl1ZSUyMFN1biUyMGFuZCUyMFRvbmclMjBIZSUyMGFuZCUyMEpvbmFzJTIwTXVlbGxlciUyMGFuZCUyMFIuJTIwTWFubWF0aGElMjBhbmQlMjBNdSUyMExpJTIwYW5kJTIwQWxleGFuZGVyJTIwU21vbGElN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIwMDQuMDg5NTUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{zhang2020resnest,
      title={ResNeSt: Split-Attention Networks}, 
      author={Hang Zhang <span class="hljs-keyword">and </span>Chongruo Wu <span class="hljs-keyword">and </span>Zhongyue Zhang <span class="hljs-keyword">and </span>Yi Zhu <span class="hljs-keyword">and </span>Haibin Lin <span class="hljs-keyword">and </span>Zhi Zhang <span class="hljs-keyword">and </span>Yue Sun <span class="hljs-keyword">and </span>Tong He <span class="hljs-keyword">and </span><span class="hljs-keyword">Jonas </span>Mueller <span class="hljs-keyword">and </span>R. Manmatha <span class="hljs-keyword">and </span>Mu Li <span class="hljs-keyword">and </span>Alexander Smola},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">2004</span>.<span class="hljs-number">08955</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){g=l("meta"),ht=o(),st=l("p"),mt=o(),w=l("h1"),U=l("a"),at=l("span"),c(Z.$$.fragment),Qt=o(),D=l("span"),D.textContent=Xt,ct=o(),x=l("p"),x.innerHTML=Ht,Mt=o(),f=l("h2"),v=l("a"),lt=l("span"),c(I.$$.fragment),St=o(),q=l("span"),q.textContent=zt,dt=o(),W=l("p"),W.textContent=Pt,ut=o(),c(E.$$.fragment),yt=o(),N=l("p"),N.textContent=Lt,jt=o(),c(B.$$.fragment),gt=o(),G=l("p"),G.textContent=Dt,wt=o(),c(A.$$.fragment),ft=o(),_=l("p"),_.textContent=qt,Jt=o(),c(Q.$$.fragment),bt=o(),S=l("p"),S.innerHTML=Kt,Tt=o(),R=l("p"),R.innerHTML=Ot,Ut=o(),J=l("h2"),C=l("a"),nt=l("span"),c(V.$$.fragment),Rt=o(),K=l("span"),K.textContent=te,vt=o(),Y=l("p"),Y.textContent=ee,Ct=o(),c(F.$$.fragment),kt=o(),X=l("p"),X.innerHTML=se,$t=o(),b=l("h2"),k=l("a"),ot=l("span"),c(H.$$.fragment),Vt=o(),O=l("span"),O.textContent=ae,Zt=o(),z=l("p"),z.innerHTML=le,xt=o(),T=l("h2"),$=l("a"),pt=l("span"),c(P.$$.fragment),Yt=o(),tt=l("span"),tt.textContent=ne,It=o(),c(L.$$.fragment),Wt=o(),it=l("p"),this.h()},l(t){const s=Je("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=p(t),st=n(t,"P",{}),h(st).forEach(e),mt=p(t),w=n(t,"H1",{class:!0});var Nt=h(w);U=n(Nt,"A",{id:!0,class:!0,href:!0});var oe=h(U);at=n(oe,"SPAN",{});var pe=h(at);M(Z.$$.fragment,pe),pe.forEach(e),oe.forEach(e),Qt=p(Nt),D=n(Nt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-14kkxfn"&&(D.textContent=Xt),Nt.forEach(e),ct=p(t),x=n(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-rzo38z"&&(x.innerHTML=Ht),Mt=p(t),f=n(t,"H2",{class:!0});var Bt=h(f);v=n(Bt,"A",{id:!0,class:!0,href:!0});var ie=h(v);lt=n(ie,"SPAN",{});var re=h(lt);M(I.$$.fragment,re),re.forEach(e),ie.forEach(e),St=p(Bt),q=n(Bt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=zt),Bt.forEach(e),dt=p(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=Pt),ut=p(t),M(E.$$.fragment,t),yt=p(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1c2ipa8"&&(N.textContent=Lt),jt=p(t),M(B.$$.fragment,t),gt=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Dt),wt=p(t),M(A.$$.fragment,t),ft=p(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-19cnvx1"&&(_.textContent=qt),Jt=p(t),M(Q.$$.fragment,t),bt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-307al9"&&(S.innerHTML=Kt),Tt=p(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1wmi3ea"&&(R.innerHTML=Ot),Ut=p(t),J=n(t,"H2",{class:!0});var Gt=h(J);C=n(Gt,"A",{id:!0,class:!0,href:!0});var he=h(C);nt=n(he,"SPAN",{});var me=h(nt);M(V.$$.fragment,me),me.forEach(e),he.forEach(e),Rt=p(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Gt.forEach(e),vt=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ee),Ct=p(t),M(F.$$.fragment,t),kt=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1kguc51"&&(X.innerHTML=se),$t=p(t),b=n(t,"H2",{class:!0});var At=h(b);k=n(At,"A",{id:!0,class:!0,href:!0});var ce=h(k);ot=n(ce,"SPAN",{});var Me=h(ot);M(H.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Vt=p(At),O=n(At,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),At.forEach(e),Zt=p(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=le),xt=p(t),T=n(t,"H2",{class:!0});var _t=h(T);$=n(_t,"A",{id:!0,class:!0,href:!0});var de=h($);pt=n(de,"SPAN",{});var ue=h(pt);M(P.$$.fragment,ue),ue.forEach(e),de.forEach(e),Yt=p(_t),tt=n(_t,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),_t.forEach(e),It=p(t),M(L.$$.fragment,t),Wt=p(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(g,"name","hf:doc:metadata"),i(g,"content",JSON.stringify(Te)),i(U,"id","resnest"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#resnest"),i(w,"class","relative group"),i(v,"id","how-do-i-use-this-model-on-an-image"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#how-do-i-use-this-model-on-an-image"),i(f,"class","relative group"),i(C,"id","how-do-i-finetune-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-finetune-this-model"),i(J,"class","relative group"),i(k,"id","how-do-i-train-this-model"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#how-do-i-train-this-model"),i(b,"class","relative group"),i($,"id","citation"),i($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i($,"href","#citation"),i(T,"class","relative group")},m(t,s){r(document.head,g),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,w,s),r(w,U),r(U,at),d(Z,at,null),r(w,Qt),r(w,D),a(t,ct,s),a(t,x,s),a(t,Mt,s),a(t,f,s),r(f,v),r(v,lt),d(I,lt,null),r(f,St),r(f,q),a(t,dt,s),a(t,W,s),a(t,ut,s),d(E,t,s),a(t,yt,s),a(t,N,s),a(t,jt,s),d(B,t,s),a(t,gt,s),a(t,G,s),a(t,wt,s),d(A,t,s),a(t,ft,s),a(t,_,s),a(t,Jt,s),d(Q,t,s),a(t,bt,s),a(t,S,s),a(t,Tt,s),a(t,R,s),a(t,Ut,s),a(t,J,s),r(J,C),r(C,nt),d(V,nt,null),r(J,Rt),r(J,K),a(t,vt,s),a(t,Y,s),a(t,Ct,s),d(F,t,s),a(t,kt,s),a(t,X,s),a(t,$t,s),a(t,b,s),r(b,k),r(k,ot),d(H,ot,null),r(b,Vt),r(b,O),a(t,Zt,s),a(t,z,s),a(t,xt,s),a(t,T,s),r(T,$),r($,pt),d(P,pt,null),r(T,Yt),r(T,tt),a(t,It,s),d(L,t,s),a(t,Wt,s),a(t,it,s),Et=!0},p:je,i(t){Et||(u(Z.$$.fragment,t),u(I.$$.fragment,t),u(E.$$.fragment,t),u(B.$$.fragment,t),u(A.$$.fragment,t),u(Q.$$.fragment,t),u(V.$$.fragment,t),u(F.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Et=!0)},o(t){y(Z.$$.fragment,t),y(I.$$.fragment,t),y(E.$$.fragment,t),y(B.$$.fragment,t),y(A.$$.fragment,t),y(Q.$$.fragment,t),y(V.$$.fragment,t),y(F.$$.fragment,t),y(H.$$.fragment,t),y(P.$$.fragment,t),y(L.$$.fragment,t),Et=!1},d(t){t&&(e(ht),e(st),e(mt),e(w),e(ct),e(x),e(Mt),e(f),e(dt),e(W),e(ut),e(yt),e(N),e(jt),e(gt),e(G),e(wt),e(ft),e(_),e(Jt),e(bt),e(S),e(Tt),e(R),e(Ut),e(J),e(vt),e(Y),e(Ct),e(kt),e(X),e($t),e(b),e(Zt),e(z),e(xt),e(T),e(It),e(Wt),e(it)),e(g),j(Z),j(I),j(E,t),j(B,t),j(A,t),j(Q,t),j(V),j(F,t),j(H),j(P),j(L,t)}}}const Te={local:"resnest",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"ResNeSt"};function Ue(Ft){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends we{constructor(g){super(),fe(this,g,Ue,be,ye,{})}}export{Ze as component};
