import{s as Me,n as ue,o as Je}from"../chunks/scheduler.85c25b89.js";import{S as ge,i as je,g as l,s as i,u as c,A as fe,h as n,f as e,c as o,j as h,v as d,y as m,k as p,o as r,a,w,d as y,t as M,x as u}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Yt){let J,ht,st,mt,g,v,at,Z,At,q,Ht="TResNet",ct,$,zt='A <strong>TResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that aim to boost accuracy while maintaining GPU training and inference efficiency.  They contain several design tricks including a SpaceToDepth stem, <a href="https://paperswithcode.com/method/anti-alias-downsampling" rel="nofollow">Anti-Alias downsampling</a>, In-Place Activated BatchNorm, Blocks selection and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation layers</a>.',dt,j,U,lt,N,Vt,D,Ft="How do I use this model on an image?",wt,x,Pt="To load a pretrained model:",yt,B,Mt,E,Lt="To load and preprocess the image:",ut,G,Jt,_,qt="To get the model predictions:",gt,W,jt,R,Dt="To get the top-5 predictions class names:",ft,A,Tt,V,Kt="Replace the model name with the variant you want to use, e.g. <code>tresnet_l</code>. You can find the IDs in the model summaries at the top of this page.",bt,Q,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,I,nt,S,Qt,K,te="How do I finetune this model?",Ut,X,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",It,Y,Ct,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,T,C,it,z,St,O,ae="How do I train this model?",Zt,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,k,ot,P,Xt,tt,ne="Citation",Nt,L,xt,pt,Bt;return Z=new rt({}),N=new rt({}),B=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RyZXNuZXRfbCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),W=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),A=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new rt({}),Y=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndHJlc25ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QnJpZG5pazIwMjB0cmVzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JUUmVzTmV0JTNBJTIwSGlnaCUyMFBlcmZvcm1hbmNlJTIwR1BVLURlZGljYXRlZCUyMEFyY2hpdGVjdHVyZSU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRhbCUyMFJpZG5payUyMGFuZCUyMEh1c3NhbSUyMExhd2VuJTIwYW5kJTIwQXNhZiUyME5veSUyMGFuZCUyMEVtYW51ZWwlMjBCZW4lMjBCYXJ1Y2glMjBhbmQlMjBHaWxhZCUyMFNoYXJpciUyMGFuZCUyMEl0YW1hciUyMEZyaWVkbWFuJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjMwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{ridnik2020tresnet,
      title={TResNet: High Performance GPU-Dedicated Architecture}, 
      author={Tal Ridnik <span class="hljs-keyword">and </span>Hussam Lawen <span class="hljs-keyword">and </span>Asaf Noy <span class="hljs-keyword">and </span>Emanuel <span class="hljs-keyword">Ben </span><span class="hljs-keyword">Baruch </span><span class="hljs-keyword">and </span>Gilad <span class="hljs-keyword">Sharir </span><span class="hljs-keyword">and </span>Itamar Friedman},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">2003</span>.<span class="hljs-number">13630</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){J=l("meta"),ht=i(),st=l("p"),mt=i(),g=l("h1"),v=l("a"),at=l("span"),c(Z.$$.fragment),At=i(),q=l("span"),q.textContent=Ht,ct=i(),$=l("p"),$.innerHTML=zt,dt=i(),j=l("h2"),U=l("a"),lt=l("span"),c(N.$$.fragment),Vt=i(),D=l("span"),D.textContent=Ft,wt=i(),x=l("p"),x.textContent=Pt,yt=i(),c(B.$$.fragment),Mt=i(),E=l("p"),E.textContent=Lt,ut=i(),c(G.$$.fragment),Jt=i(),_=l("p"),_.textContent=qt,gt=i(),c(W.$$.fragment),jt=i(),R=l("p"),R.textContent=Dt,ft=i(),c(A.$$.fragment),Tt=i(),V=l("p"),V.innerHTML=Kt,bt=i(),Q=l("p"),Q.innerHTML=Ot,vt=i(),f=l("h2"),I=l("a"),nt=l("span"),c(S.$$.fragment),Qt=i(),K=l("span"),K.textContent=te,Ut=i(),X=l("p"),X.textContent=ee,It=i(),c(Y.$$.fragment),Ct=i(),H=l("p"),H.innerHTML=se,kt=i(),T=l("h2"),C=l("a"),it=l("span"),c(z.$$.fragment),St=i(),O=l("span"),O.textContent=ae,Zt=i(),F=l("p"),F.innerHTML=le,$t=i(),b=l("h2"),k=l("a"),ot=l("span"),c(P.$$.fragment),Xt=i(),tt=l("span"),tt.textContent=ne,Nt=i(),c(L.$$.fragment),xt=i(),pt=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);J=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=o(t),st=n(t,"P",{}),h(st).forEach(e),mt=o(t),g=n(t,"H1",{class:!0});var Et=h(g);v=n(Et,"A",{id:!0,class:!0,href:!0});var ie=h(v);at=n(ie,"SPAN",{});var oe=h(at);d(Z.$$.fragment,oe),oe.forEach(e),ie.forEach(e),At=o(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-12atf3q"&&(q.textContent=Ht),Et.forEach(e),ct=o(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-15ptpxo"&&($.innerHTML=zt),dt=o(t),j=n(t,"H2",{class:!0});var Gt=h(j);U=n(Gt,"A",{id:!0,class:!0,href:!0});var pe=h(U);lt=n(pe,"SPAN",{});var re=h(lt);d(N.$$.fragment,re),re.forEach(e),pe.forEach(e),Vt=o(Gt),D=n(Gt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=Ft),Gt.forEach(e),wt=o(t),x=n(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-18ywhxh"&&(x.textContent=Pt),yt=o(t),d(B.$$.fragment,t),Mt=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Lt),ut=o(t),d(G.$$.fragment,t),Jt=o(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=qt),gt=o(t),d(W.$$.fragment,t),jt=o(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19cnvx1"&&(R.textContent=Dt),ft=o(t),d(A.$$.fragment,t),Tt=o(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-rdmov8"&&(V.innerHTML=Kt),bt=o(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1wmi3ea"&&(Q.innerHTML=Ot),vt=o(t),f=n(t,"H2",{class:!0});var _t=h(f);I=n(_t,"A",{id:!0,class:!0,href:!0});var he=h(I);nt=n(he,"SPAN",{});var me=h(nt);d(S.$$.fragment,me),me.forEach(e),he.forEach(e),Qt=o(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),_t.forEach(e),Ut=o(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-9sr7nh"&&(X.textContent=ee),It=o(t),d(Y.$$.fragment,t),Ct=o(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),kt=o(t),T=n(t,"H2",{class:!0});var Wt=h(T);C=n(Wt,"A",{id:!0,class:!0,href:!0});var ce=h(C);it=n(ce,"SPAN",{});var de=h(it);d(z.$$.fragment,de),de.forEach(e),ce.forEach(e),St=o(Wt),O=n(Wt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Wt.forEach(e),Zt=o(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),$t=o(t),b=n(t,"H2",{class:!0});var Rt=h(b);k=n(Rt,"A",{id:!0,class:!0,href:!0});var we=h(k);ot=n(we,"SPAN",{});var ye=h(ot);d(P.$$.fragment,ye),ye.forEach(e),we.forEach(e),Xt=o(Rt),tt=n(Rt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),Rt.forEach(e),Nt=o(t),d(L.$$.fragment,t),xt=o(t),pt=n(t,"P",{}),h(pt).forEach(e),this.h()},h(){p(J,"name","hf:doc:metadata"),p(J,"content",JSON.stringify(be)),p(v,"id","tresnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#tresnet"),p(g,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(j,"class","relative group"),p(I,"id","how-do-i-finetune-this-model"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#how-do-i-finetune-this-model"),p(f,"class","relative group"),p(C,"id","how-do-i-train-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-train-this-model"),p(T,"class","relative group"),p(k,"id","citation"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#citation"),p(b,"class","relative group")},m(t,s){r(document.head,J),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,g,s),r(g,v),r(v,at),w(Z,at,null),r(g,At),r(g,q),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,U),r(U,lt),w(N,lt,null),r(j,Vt),r(j,D),a(t,wt,s),a(t,x,s),a(t,yt,s),w(B,t,s),a(t,Mt,s),a(t,E,s),a(t,ut,s),w(G,t,s),a(t,Jt,s),a(t,_,s),a(t,gt,s),w(W,t,s),a(t,jt,s),a(t,R,s),a(t,ft,s),w(A,t,s),a(t,Tt,s),a(t,V,s),a(t,bt,s),a(t,Q,s),a(t,vt,s),a(t,f,s),r(f,I),r(I,nt),w(S,nt,null),r(f,Qt),r(f,K),a(t,Ut,s),a(t,X,s),a(t,It,s),w(Y,t,s),a(t,Ct,s),a(t,H,s),a(t,kt,s),a(t,T,s),r(T,C),r(C,it),w(z,it,null),r(T,St),r(T,O),a(t,Zt,s),a(t,F,s),a(t,$t,s),a(t,b,s),r(b,k),r(k,ot),w(P,ot,null),r(b,Xt),r(b,tt),a(t,Nt,s),w(L,t,s),a(t,xt,s),a(t,pt,s),Bt=!0},p:ue,i(t){Bt||(y(Z.$$.fragment,t),y(N.$$.fragment,t),y(B.$$.fragment,t),y(G.$$.fragment,t),y(W.$$.fragment,t),y(A.$$.fragment,t),y(S.$$.fragment,t),y(Y.$$.fragment,t),y(z.$$.fragment,t),y(P.$$.fragment,t),y(L.$$.fragment,t),Bt=!0)},o(t){M(Z.$$.fragment,t),M(N.$$.fragment,t),M(B.$$.fragment,t),M(G.$$.fragment,t),M(W.$$.fragment,t),M(A.$$.fragment,t),M(S.$$.fragment,t),M(Y.$$.fragment,t),M(z.$$.fragment,t),M(P.$$.fragment,t),M(L.$$.fragment,t),Bt=!1},d(t){t&&(e(ht),e(st),e(mt),e(g),e(ct),e($),e(dt),e(j),e(wt),e(x),e(yt),e(Mt),e(E),e(ut),e(Jt),e(_),e(gt),e(jt),e(R),e(ft),e(Tt),e(V),e(bt),e(Q),e(vt),e(f),e(Ut),e(X),e(It),e(Ct),e(H),e(kt),e(T),e(Zt),e(F),e($t),e(b),e(Nt),e(xt),e(pt)),e(J),u(Z),u(N),u(B,t),u(G,t),u(W,t),u(A,t),u(S),u(Y,t),u(z),u(P),u(L,t)}}}const be={local:"tresnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"TResNet"};function ve(Yt){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends ge{constructor(J){super(),je(this,J,ve,Te,Me,{})}}export{Ze as component};
