import{s as fn,n as un,o as vn}from"../chunks/scheduler.85c25b89.js";import{S as bn,i as _n,g as a,s as n,u as c,A as yn,h as r,f as o,c as i,j as d,v as g,y as s,k as l,o as t,a as p,w as h,d as f,t as u,x as v}from"../chunks/index.9633332f.js";import{D as b}from"../chunks/Docstring.d451fcbb.js";import{I as Oa}from"../chunks/IconCopyLink.a4acffac.js";function xn(eo){let S,Yt,Ut,ea,G,q,Zt,le,Ba,Ue,to="Optimization",ta,pe,ao="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",aa,k,W,Qt,de,Va,Ze,ro="Optimizers",ra,O,j,Xt,ce,qa,Qe,oo="Factory functions",oa,B,ge,Wa,Xe,no=`Legacy optimizer factory for backwards compatibility.
NOTE: Use create_optimizer_v2 for new code.`,na,z,he,ja,Je,io="Create an optimizer.",Ua,Ke,so=`TODO currently the model is passed in and all parameters are selected for optimization.
For more general use an interface that allows selection of parameters to optimize and lr groups, one of:`,Za,Ye,mo="<li>a filter fn interface that further breaks params into groups in a weight_decay compatible fashion</li> <li>expose the parameters interface and leave it up to caller</li>",ia,V,U,Jt,fe,Qa,et,lo="Optimizer Classes",sa,x,ue,Xa,tt,po="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Ja,at,co="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",Ka,rt,go=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Ya,ot,ho='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',er,Z,ve,tr,nt,fo="Performs a single optimization step.",ma,C,be,ar,it,uo=`Implements Adafactor algorithm.
This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,rr,st,vo=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,or,mt,bo=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,nr,Q,_e,ir,lt,_o="Performs a single optimization step.",la,$,ye,sr,pt,yo="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",mr,X,xe,lr,dt,xo="Gets all parameters in all param_groups with gradients",pr,J,$e,dr,ct,$o="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",cr,K,we,gr,gt,wo="Performs a single optimization step.",hr,Y,Ae,fr,ht,Ao="Zeros out the accumalated hessian traces.",pa,Ce,Le,da,L,Te,ur,ft,Co="Implements AdamW algorithm.",vr,ut,Lo=`The original Adam algorithm was proposed in <code>Adam: A Method for Stochastic Optimization</code><em>.
The AdamW variant was proposed in <code>Decoupled Weight Decay Regularization</code></em>.`,br,vt,To=`.. _Adam\\: A Method for Stochastic Optimization:
<a href="https://arxiv.org/abs/1412.6980" rel="nofollow">https://arxiv.org/abs/1412.6980</a>
.. _Decoupled Weight Decay Regularization:
<a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,_r,ee,De,yr,bt,Do="Performs a single optimization step.",ca,T,ze,xr,_t,zo=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,$r,yt,Mo="LAMB was proposed in <code>Large Batch Optimization for Deep Learning: Training BERT in 76 minutes</code>_.",wr,xt,Po=`.. _Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:
<a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a>
.. _On the Convergence of Adam and Beyond:
<a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a>`,Ar,te,Me,Cr,$t,No="Performs a single optimization step.",ga,M,Pe,Lr,wt,Eo="LARS for PyTorch",Tr,At,Fo='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',Dr,ae,Ne,zr,Ct,Io="Performs a single optimization step.",ha,Ee,Fe,fa,y,Ie,Mr,Lt,Ho=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Pr,Tt,Ro='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Nr,Dt,So=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,Er,zt,Go=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Fr,Mt,ko="On sparse problems both weight_decay and momentum should be set to 0.",Ir,re,He,Hr,Pt,Oo="Performs a single optimization step.",ua,w,Re,Rr,Nt,Bo="Implements Nadam algorithm (a variant of Adam based on Nesterov momentum).",Sr,Et,Vo="It has been proposed in <code>Incorporating Nesterov Momentum into Adam</code>__.",Gr,Ft,qo='<strong><a href="http://cs229.stanford.edu/proj2015/054_report.pdf" rel="nofollow">http://cs229.stanford.edu/proj2015/054_report.pdf</a></strong> <a href="http://www.cs.toronto.edu/~fritz/absps/momentum.pdf" rel="nofollow">http://www.cs.toronto.edu/~fritz/absps/momentum.pdf</a>',kr,It,Wo=`Originally taken from: <a href="https://github.com/pytorch/pytorch/pull/1408" rel="nofollow">https://github.com/pytorch/pytorch/pull/1408</a>
NOTE: Has potential issues but does work well on some problems.`,Or,oe,Se,Br,Ht,jo="Performs a single optimization step.",va,F,Ge,Vr,Rt,Uo="Implements Novograd algorithm.",qr,ne,ke,Wr,St,Zo="Performs a single optimization step.",ba,Oe,Be,_a,_,Ve,jr,Gt,Qo="Implements RMSprop algorithm (TensorFlow style epsilon)",Ur,kt,Xo=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,Zr,Ot,Jo="Noteworthy changes include:",Qr,Bt,Ko="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",Xr,Vt,Yo=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,Jr,qt,en=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,Kr,ie,qe,Yr,Wt,tn="Performs a single optimization step.",ya,We,je,xa,Kt,$a;return le=new Oa({}),de=new Oa({}),ce=new Oa({}),ge=new b({props:{name:"timm.optim.create_optimizer",anchor:"timm.optim.create_optimizer",parameters:[{name:"args",val:""},{name:"model",val:""},{name:"filter_bias_and_bn",val:" = True"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/optim_factory.py#L182"}}),he=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:""},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> (nn.Module) &#x2014; model containing parameters to optimize
opt &#x2014; name of optimizer to create
lr &#x2014; initial learning rate
weight_decay &#x2014; weight decay to apply in optimizer
momentum &#x2014;  momentum for momentum based optimizers (others may use betas via kwargs)
foreach &#x2014; Enable / disable foreach (multi-tensor) operation if True / False. Choose safe default if None
filter_bias_and_bn &#x2014;  filter out bias, bn and other 1d params from weight decay
**kwargs &#x2014; extra optimizer specific kwargs to pass through`,name:"model_or_params"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/optim_factory.py#L193",returnDescription:`
<p>Optimizer</p>
`}}),fe=new Oa({}),ue=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L6"}}),ve=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adabelief.py#L89"}}),be=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:""},{name:"lr",val:" = None"},{name:"eps",val:" = 1e-30"},{name:"eps_scale",val:" = 0.001"},{name:"clip_threshold",val:" = 1.0"},{name:"decay_rate",val:" = -0.8"},{name:"betas",val:" = None"},{name:"weight_decay",val:" = 0.0"},{name:"scale_parameter",val:" = True"},{name:"warmup_init",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adafactor.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adafactor.lr",description:"<strong>lr</strong> (float, optional) &#x2014; external learning rate (default: None)",name:"lr"},{anchor:"timm.optim.Adafactor.eps",description:`<strong>eps</strong> (tuple[float, float]) &#x2014; regularization constants for square gradient
and parameter scale respectively (default: (1e-30, 1e-3))`,name:"eps"},{anchor:"timm.optim.Adafactor.clip_threshold",description:"<strong>clip_threshold</strong> (float) &#x2014; threshold of root mean square of final gradient update (default: 1.0)",name:"clip_threshold"},{anchor:"timm.optim.Adafactor.decay_rate",description:"<strong>decay_rate</strong> (float) &#x2014; coefficient used to compute running averages of square gradient (default: -0.8)",name:"decay_rate"},{anchor:"timm.optim.Adafactor.beta1",description:"<strong>beta1</strong> (float) &#x2014; coefficient used for computing running averages of gradient (default: None)",name:"beta1"},{anchor:"timm.optim.Adafactor.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Adafactor.scale_parameter",description:"<strong>scale_parameter</strong> (bool) &#x2014; if True, learning rate is scaled by root mean square of parameter (default: True)",name:"scale_parameter"},{anchor:"timm.optim.Adafactor.warmup_init",description:`<strong>warmup_init</strong> (bool) &#x2014; time-dependent learning rate computation depends on
whether warm-up initialization is being used (default: False)`,name:"warmup_init"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L16"}}),_e=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adafactor.py#L79"}}),ye=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L9"}}),xe=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L58"}}),$e=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L74"}}),we=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L102"}}),Ae=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adahessian.py#L65"}}),Le=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamp.py#L43"}}),Te=new b({props:{name:"class timm.optim.AdamW",anchor:"timm.optim.AdamW",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.01"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.AdamW.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdamW.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdamW.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdamW.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.AdamW.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay coefficient (default: 1e-2)",name:"weight_decay"},{anchor:"timm.optim.AdamW.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L12"}}),De=new b({props:{name:"step",anchor:"timm.optim.AdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/adamw.py#L58"}}),ze=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"bias_correction",val:" = True"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-06"},{name:"weight_decay",val:" = 0.01"},{name:"grad_averaging",val:" = True"},{name:"max_grad_norm",val:" = 1.0"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate. (default: 1e-3)",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its norm. (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Lamb.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability. (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:`<strong>grad_averaging</strong> (bool, optional) &#x2014; whether apply (1-beta2) to grad when
calculating running averages of gradient. (default: True)`,name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> (float, optional) &#x2014; value used to clip global grad norm (default: 1.0)",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LAMBC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:`<strong>always_adapt</strong> (boolean, optional) &#x2014; Apply adaptive learning rate to 0.0
weight decay parameter (default: False)`,name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L60"}}),Me=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lamb.py#L96"}}),Pe=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L17"}}),Ne=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lars.py#L75"}}),Fe=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/lookahead.py#L15"}}),Ie=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L24"}}),He=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Union[typing.Callable[[], float], NoneType] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/madgrad.py#L85"}}),Re=new b({props:{name:"class timm.optim.Nadam",anchor:"timm.optim.Nadam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.002"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"schedule_decay",val:" = 0.004"}],parametersDescription:[{anchor:"timm.optim.Nadam.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.Nadam.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 2e-3)",name:"lr"},{anchor:"timm.optim.Nadam.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square`,name:"betas"},{anchor:"timm.optim.Nadam.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.Nadam.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Nadam.schedule_decay",description:"<strong>schedule_decay</strong> (float, optional) &#x2014; momentum schedule decay (default: 4e-3)",name:"schedule_decay"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L7"}}),Se=new b({props:{name:"step",anchor:"timm.optim.Nadam.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Nadam.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nadam.py#L43"}}),Ge=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:`<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)
grad_averaging &#x2014; gradient averaging`,name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L13"}}),ke=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/nvnovograd.py#L54"}}),Be=new b({props:{name:"class timm.optim.RAdam",anchor:"timm.optim.RAdam",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/radam.py#L10"}}),Ve=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.01"},{name:"alpha",val:" = 0.9"},{name:"eps",val:" = 1e-10"},{name:"weight_decay",val:" = 0"},{name:"momentum",val:" = 0.0"},{name:"centered",val:" = False"},{name:"decoupled_decay",val:" = False"},{name:"lr_in_momentum",val:" = True"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-2)",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> (float, optional) &#x2014; smoothing (decay) constant (default: 0.9)",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-10)`,name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:`<strong>centered</strong> (bool, optional)  &#x2014; if <code>True</code>, compute the centered RMSProp,
the gradient is normalized by an estimation of its variance`,name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> (bool, optional) &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:`<strong>lr_in_momentum</strong> (bool, optional) &#x2014; learning rate scaling is included in the momentum buffer
update as per defaults in Tensorflow`,name:"lr_in_momentum"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L14"}}),qe=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/rmsprop_tf.py#L72"}}),je=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/main/timm/optim/sgdp.py#L19"}}),{c(){S=a("meta"),Yt=n(),Ut=a("p"),ea=n(),G=a("h1"),q=a("a"),Zt=a("span"),c(le.$$.fragment),Ba=n(),Ue=a("span"),Ue.textContent=to,ta=n(),pe=a("p"),pe.innerHTML=ao,aa=n(),k=a("h2"),W=a("a"),Qt=a("span"),c(de.$$.fragment),Va=n(),Ze=a("span"),Ze.textContent=ro,ra=n(),O=a("h3"),j=a("a"),Xt=a("span"),c(ce.$$.fragment),qa=n(),Qe=a("span"),Qe.textContent=oo,oa=n(),B=a("div"),c(ge.$$.fragment),Wa=n(),Xe=a("p"),Xe.textContent=no,na=n(),z=a("div"),c(he.$$.fragment),ja=n(),Je=a("p"),Je.textContent=io,Ua=n(),Ke=a("p"),Ke.textContent=so,Za=n(),Ye=a("ul"),Ye.innerHTML=mo,ia=n(),V=a("h3"),U=a("a"),Jt=a("span"),c(fe.$$.fragment),Qa=n(),et=a("span"),et.textContent=lo,sa=n(),x=a("div"),c(ue.$$.fragment),Xa=n(),tt=a("p"),tt.textContent=po,Ja=n(),at=a("p"),at.textContent=co,Ka=n(),rt=a("p"),rt.innerHTML=go,Ya=n(),ot=a("ul"),ot.innerHTML=ho,er=n(),Z=a("div"),c(ve.$$.fragment),tr=n(),nt=a("p"),nt.textContent=fo,ma=n(),C=a("div"),c(be.$$.fragment),ar=n(),it=a("p"),it.innerHTML=uo,rr=n(),st=a("p"),st.innerHTML=vo,or=n(),mt=a("p"),mt.innerHTML=bo,nr=n(),Q=a("div"),c(_e.$$.fragment),ir=n(),lt=a("p"),lt.textContent=_o,la=n(),$=a("div"),c(ye.$$.fragment),sr=n(),pt=a("p"),pt.textContent=yo,mr=n(),X=a("div"),c(xe.$$.fragment),lr=n(),dt=a("p"),dt.textContent=xo,pr=n(),J=a("div"),c($e.$$.fragment),dr=n(),ct=a("p"),ct.textContent=$o,cr=n(),K=a("div"),c(we.$$.fragment),gr=n(),gt=a("p"),gt.textContent=wo,hr=n(),Y=a("div"),c(Ae.$$.fragment),fr=n(),ht=a("p"),ht.textContent=Ao,pa=n(),Ce=a("div"),c(Le.$$.fragment),da=n(),L=a("div"),c(Te.$$.fragment),ur=n(),ft=a("p"),ft.textContent=Co,vr=n(),ut=a("p"),ut.innerHTML=Lo,br=n(),vt=a("p"),vt.innerHTML=To,_r=n(),ee=a("div"),c(De.$$.fragment),yr=n(),bt=a("p"),bt.textContent=Do,ca=n(),T=a("div"),c(ze.$$.fragment),xr=n(),_t=a("p"),_t.innerHTML=zo,$r=n(),yt=a("p"),yt.innerHTML=Mo,wr=n(),xt=a("p"),xt.innerHTML=Po,Ar=n(),te=a("div"),c(Me.$$.fragment),Cr=n(),$t=a("p"),$t.textContent=No,ga=n(),M=a("div"),c(Pe.$$.fragment),Lr=n(),wt=a("p"),wt.textContent=Eo,Tr=n(),At=a("p"),At.innerHTML=Fo,Dr=n(),ae=a("div"),c(Ne.$$.fragment),zr=n(),Ct=a("p"),Ct.textContent=Io,ha=n(),Ee=a("div"),c(Fe.$$.fragment),fa=n(),y=a("div"),c(Ie.$$.fragment),Mr=n(),Lt=a("p"),Lt.textContent=Ho,Pr=n(),Tt=a("p"),Tt.innerHTML=Ro,Nr=n(),Dt=a("p"),Dt.textContent=So,Er=n(),zt=a("p"),zt.textContent=Go,Fr=n(),Mt=a("p"),Mt.textContent=ko,Ir=n(),re=a("div"),c(He.$$.fragment),Hr=n(),Pt=a("p"),Pt.textContent=Oo,ua=n(),w=a("div"),c(Re.$$.fragment),Rr=n(),Nt=a("p"),Nt.textContent=Bo,Sr=n(),Et=a("p"),Et.innerHTML=Vo,Gr=n(),Ft=a("p"),Ft.innerHTML=qo,kr=n(),It=a("p"),It.innerHTML=Wo,Or=n(),oe=a("div"),c(Se.$$.fragment),Br=n(),Ht=a("p"),Ht.textContent=jo,va=n(),F=a("div"),c(Ge.$$.fragment),Vr=n(),Rt=a("p"),Rt.textContent=Uo,qr=n(),ne=a("div"),c(ke.$$.fragment),Wr=n(),St=a("p"),St.textContent=Zo,ba=n(),Oe=a("div"),c(Be.$$.fragment),_a=n(),_=a("div"),c(Ve.$$.fragment),jr=n(),Gt=a("p"),Gt.textContent=Qo,Ur=n(),kt=a("p"),kt.textContent=Xo,Zr=n(),Ot=a("p"),Ot.textContent=Jo,Qr=n(),Bt=a("ol"),Bt.innerHTML=Ko,Xr=n(),Vt=a("p"),Vt.innerHTML=Yo,Jr=n(),qt=a("p"),qt.innerHTML=en,Kr=n(),ie=a("div"),c(qe.$$.fragment),Yr=n(),Wt=a("p"),Wt.textContent=tn,ya=n(),We=a("div"),c(je.$$.fragment),xa=n(),Kt=a("p"),this.h()},l(e){const m=yn("svelte-1phssyn",document.head);S=r(m,"META",{name:!0,content:!0}),m.forEach(o),Yt=i(e),Ut=r(e,"P",{}),d(Ut).forEach(o),ea=i(e),G=r(e,"H1",{class:!0});var wa=d(G);q=r(wa,"A",{id:!0,class:!0,href:!0});var an=d(q);Zt=r(an,"SPAN",{});var rn=d(Zt);g(le.$$.fragment,rn),rn.forEach(o),an.forEach(o),Ba=i(wa),Ue=r(wa,"SPAN",{"data-svelte-h":!0}),s(Ue)!=="svelte-1jvrjc2"&&(Ue.textContent=to),wa.forEach(o),ta=i(e),pe=r(e,"P",{"data-svelte-h":!0}),s(pe)!=="svelte-1c6qm22"&&(pe.innerHTML=ao),aa=i(e),k=r(e,"H2",{class:!0});var Aa=d(k);W=r(Aa,"A",{id:!0,class:!0,href:!0});var on=d(W);Qt=r(on,"SPAN",{});var nn=d(Qt);g(de.$$.fragment,nn),nn.forEach(o),on.forEach(o),Va=i(Aa),Ze=r(Aa,"SPAN",{"data-svelte-h":!0}),s(Ze)!=="svelte-2sczpt"&&(Ze.textContent=ro),Aa.forEach(o),ra=i(e),O=r(e,"H3",{class:!0});var Ca=d(O);j=r(Ca,"A",{id:!0,class:!0,href:!0});var sn=d(j);Xt=r(sn,"SPAN",{});var mn=d(Xt);g(ce.$$.fragment,mn),mn.forEach(o),sn.forEach(o),qa=i(Ca),Qe=r(Ca,"SPAN",{"data-svelte-h":!0}),s(Qe)!=="svelte-1n2i7uc"&&(Qe.textContent=oo),Ca.forEach(o),oa=i(e),B=r(e,"DIV",{class:!0});var La=d(B);g(ge.$$.fragment,La),Wa=i(La),Xe=r(La,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-1dlcrvh"&&(Xe.textContent=no),La.forEach(o),na=i(e),z=r(e,"DIV",{class:!0});var se=d(z);g(he.$$.fragment,se),ja=i(se),Je=r(se,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-12lpmmq"&&(Je.textContent=io),Ua=i(se),Ke=r(se,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-ocfv4n"&&(Ke.textContent=so),Za=i(se),Ye=r(se,"UL",{"data-svelte-h":!0}),s(Ye)!=="svelte-qarx5u"&&(Ye.innerHTML=mo),se.forEach(o),ia=i(e),V=r(e,"H3",{class:!0});var Ta=d(V);U=r(Ta,"A",{id:!0,class:!0,href:!0});var ln=d(U);Jt=r(ln,"SPAN",{});var pn=d(Jt);g(fe.$$.fragment,pn),pn.forEach(o),ln.forEach(o),Qa=i(Ta),et=r(Ta,"SPAN",{"data-svelte-h":!0}),s(et)!=="svelte-hrxu3g"&&(et.textContent=lo),Ta.forEach(o),sa=i(e),x=r(e,"DIV",{class:!0});var P=d(x);g(ue.$$.fragment,P),Xa=i(P),tt=r(P,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-1hnunr4"&&(tt.textContent=po),Ja=i(P),at=r(P,"P",{"data-svelte-h":!0}),s(at)!=="svelte-1cjb7xo"&&(at.textContent=co),Ka=i(P),rt=r(P,"P",{"data-svelte-h":!0}),s(rt)!=="svelte-1347q2l"&&(rt.innerHTML=go),Ya=i(P),ot=r(P,"UL",{"data-svelte-h":!0}),s(ot)!=="svelte-12x3l9q"&&(ot.innerHTML=ho),er=i(P),Z=r(P,"DIV",{class:!0});var Da=d(Z);g(ve.$$.fragment,Da),tr=i(Da),nt=r(Da,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-1gr03w4"&&(nt.textContent=fo),Da.forEach(o),P.forEach(o),ma=i(e),C=r(e,"DIV",{class:!0});var I=d(C);g(be.$$.fragment,I),ar=i(I),it=r(I,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1pwmpx3"&&(it.innerHTML=uo),rr=i(I),st=r(I,"P",{"data-svelte-h":!0}),s(st)!=="svelte-1i7ubkr"&&(st.innerHTML=vo),or=i(I),mt=r(I,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-96f97i"&&(mt.innerHTML=bo),nr=i(I),Q=r(I,"DIV",{class:!0});var za=d(Q);g(_e.$$.fragment,za),ir=i(za),lt=r(za,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1gr03w4"&&(lt.textContent=_o),za.forEach(o),I.forEach(o),la=i(e),$=r(e,"DIV",{class:!0});var N=d($);g(ye.$$.fragment,N),sr=i(N),pt=r(N,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-1cuo0rh"&&(pt.textContent=yo),mr=i(N),X=r(N,"DIV",{class:!0});var Ma=d(X);g(xe.$$.fragment,Ma),lr=i(Ma),dt=r(Ma,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-1jz1hl7"&&(dt.textContent=xo),Ma.forEach(o),pr=i(N),J=r(N,"DIV",{class:!0});var Pa=d(J);g($e.$$.fragment,Pa),dr=i(Pa),ct=r(Pa,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-1y1oyzd"&&(ct.textContent=$o),Pa.forEach(o),cr=i(N),K=r(N,"DIV",{class:!0});var Na=d(K);g(we.$$.fragment,Na),gr=i(Na),gt=r(Na,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-1gr03w4"&&(gt.textContent=wo),Na.forEach(o),hr=i(N),Y=r(N,"DIV",{class:!0});var Ea=d(Y);g(Ae.$$.fragment,Ea),fr=i(Ea),ht=r(Ea,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-4lvf5h"&&(ht.textContent=Ao),Ea.forEach(o),N.forEach(o),pa=i(e),Ce=r(e,"DIV",{class:!0});var dn=d(Ce);g(Le.$$.fragment,dn),dn.forEach(o),da=i(e),L=r(e,"DIV",{class:!0});var H=d(L);g(Te.$$.fragment,H),ur=i(H),ft=r(H,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-c51pd7"&&(ft.textContent=Co),vr=i(H),ut=r(H,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-1cgyzi6"&&(ut.innerHTML=Lo),br=i(H),vt=r(H,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-1pe3ewc"&&(vt.innerHTML=To),_r=i(H),ee=r(H,"DIV",{class:!0});var Fa=d(ee);g(De.$$.fragment,Fa),yr=i(Fa),bt=r(Fa,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-1gr03w4"&&(bt.textContent=Do),Fa.forEach(o),H.forEach(o),ca=i(e),T=r(e,"DIV",{class:!0});var R=d(T);g(ze.$$.fragment,R),xr=i(R),_t=r(R,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-d5zqgn"&&(_t.innerHTML=zo),$r=i(R),yt=r(R,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-1wamkfv"&&(yt.innerHTML=Mo),wr=i(R),xt=r(R,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-dty621"&&(xt.innerHTML=Po),Ar=i(R),te=r(R,"DIV",{class:!0});var Ia=d(te);g(Me.$$.fragment,Ia),Cr=i(Ia),$t=r(Ia,"P",{"data-svelte-h":!0}),s($t)!=="svelte-1gr03w4"&&($t.textContent=No),Ia.forEach(o),R.forEach(o),ga=i(e),M=r(e,"DIV",{class:!0});var me=d(M);g(Pe.$$.fragment,me),Lr=i(me),wt=r(me,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-vzcsb8"&&(wt.textContent=Eo),Tr=i(me),At=r(me,"P",{"data-svelte-h":!0}),s(At)!=="svelte-euart9"&&(At.innerHTML=Fo),Dr=i(me),ae=r(me,"DIV",{class:!0});var Ha=d(ae);g(Ne.$$.fragment,Ha),zr=i(Ha),Ct=r(Ha,"P",{"data-svelte-h":!0}),s(Ct)!=="svelte-1gr03w4"&&(Ct.textContent=Io),Ha.forEach(o),me.forEach(o),ha=i(e),Ee=r(e,"DIV",{class:!0});var cn=d(Ee);g(Fe.$$.fragment,cn),cn.forEach(o),fa=i(e),y=r(e,"DIV",{class:!0});var D=d(y);g(Ie.$$.fragment,D),Mr=i(D),Lt=r(D,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-wmmdpx"&&(Lt.textContent=Ho),Pr=i(D),Tt=r(D,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-12dyngi"&&(Tt.innerHTML=Ro),Nr=i(D),Dt=r(D,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-qjjdis"&&(Dt.textContent=So),Er=i(D),zt=r(D,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-rosfou"&&(zt.textContent=Go),Fr=i(D),Mt=r(D,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-hlwvkn"&&(Mt.textContent=ko),Ir=i(D),re=r(D,"DIV",{class:!0});var Ra=d(re);g(He.$$.fragment,Ra),Hr=i(Ra),Pt=r(Ra,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1gr03w4"&&(Pt.textContent=Oo),Ra.forEach(o),D.forEach(o),ua=i(e),w=r(e,"DIV",{class:!0});var E=d(w);g(Re.$$.fragment,E),Rr=i(E),Nt=r(E,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1ss2c23"&&(Nt.textContent=Bo),Sr=i(E),Et=r(E,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-ewqetr"&&(Et.innerHTML=Vo),Gr=i(E),Ft=r(E,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-1q705lb"&&(Ft.innerHTML=qo),kr=i(E),It=r(E,"P",{"data-svelte-h":!0}),s(It)!=="svelte-14ul3re"&&(It.innerHTML=Wo),Or=i(E),oe=r(E,"DIV",{class:!0});var Sa=d(oe);g(Se.$$.fragment,Sa),Br=i(Sa),Ht=r(Sa,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-1gr03w4"&&(Ht.textContent=jo),Sa.forEach(o),E.forEach(o),va=i(e),F=r(e,"DIV",{class:!0});var jt=d(F);g(Ge.$$.fragment,jt),Vr=i(jt),Rt=r(jt,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-5vv99d"&&(Rt.textContent=Uo),qr=i(jt),ne=r(jt,"DIV",{class:!0});var Ga=d(ne);g(ke.$$.fragment,Ga),Wr=i(Ga),St=r(Ga,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1gr03w4"&&(St.textContent=Zo),Ga.forEach(o),jt.forEach(o),ba=i(e),Oe=r(e,"DIV",{class:!0});var gn=d(Oe);g(Be.$$.fragment,gn),gn.forEach(o),_a=i(e),_=r(e,"DIV",{class:!0});var A=d(_);g(Ve.$$.fragment,A),jr=i(A),Gt=r(A,"P",{"data-svelte-h":!0}),s(Gt)!=="svelte-1tqv0s5"&&(Gt.textContent=Qo),Ur=i(A),kt=r(A,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-g10xv4"&&(kt.textContent=Xo),Zr=i(A),Ot=r(A,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-1acg3vg"&&(Ot.textContent=Jo),Qr=i(A),Bt=r(A,"OL",{"data-svelte-h":!0}),s(Bt)!=="svelte-15y6o6y"&&(Bt.innerHTML=Ko),Xr=i(A),Vt=r(A,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-1yvkj2h"&&(Vt.innerHTML=Yo),Jr=i(A),qt=r(A,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-53x1ow"&&(qt.innerHTML=en),Kr=i(A),ie=r(A,"DIV",{class:!0});var ka=d(ie);g(qe.$$.fragment,ka),Yr=i(ka),Wt=r(ka,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-1gr03w4"&&(Wt.textContent=tn),ka.forEach(o),A.forEach(o),ya=i(e),We=r(e,"DIV",{class:!0});var hn=d(We);g(je.$$.fragment,hn),hn.forEach(o),xa=i(e),Kt=r(e,"P",{}),d(Kt).forEach(o),this.h()},h(){l(S,"name","hf:doc:metadata"),l(S,"content",JSON.stringify($n)),l(q,"id","optimization"),l(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(q,"href","#optimization"),l(G,"class","relative group"),l(W,"id","optimizers"),l(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(W,"href","#optimizers"),l(k,"class","relative group"),l(j,"id","timm.optim.create_optimizer"),l(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(j,"href","#timm.optim.create_optimizer"),l(O,"class","relative group"),l(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(U,"id","timm.optim.AdaBelief"),l(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(U,"href","#timm.optim.AdaBelief"),l(V,"class","relative group"),l(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){t(document.head,S),p(e,Yt,m),p(e,Ut,m),p(e,ea,m),p(e,G,m),t(G,q),t(q,Zt),h(le,Zt,null),t(G,Ba),t(G,Ue),p(e,ta,m),p(e,pe,m),p(e,aa,m),p(e,k,m),t(k,W),t(W,Qt),h(de,Qt,null),t(k,Va),t(k,Ze),p(e,ra,m),p(e,O,m),t(O,j),t(j,Xt),h(ce,Xt,null),t(O,qa),t(O,Qe),p(e,oa,m),p(e,B,m),h(ge,B,null),t(B,Wa),t(B,Xe),p(e,na,m),p(e,z,m),h(he,z,null),t(z,ja),t(z,Je),t(z,Ua),t(z,Ke),t(z,Za),t(z,Ye),p(e,ia,m),p(e,V,m),t(V,U),t(U,Jt),h(fe,Jt,null),t(V,Qa),t(V,et),p(e,sa,m),p(e,x,m),h(ue,x,null),t(x,Xa),t(x,tt),t(x,Ja),t(x,at),t(x,Ka),t(x,rt),t(x,Ya),t(x,ot),t(x,er),t(x,Z),h(ve,Z,null),t(Z,tr),t(Z,nt),p(e,ma,m),p(e,C,m),h(be,C,null),t(C,ar),t(C,it),t(C,rr),t(C,st),t(C,or),t(C,mt),t(C,nr),t(C,Q),h(_e,Q,null),t(Q,ir),t(Q,lt),p(e,la,m),p(e,$,m),h(ye,$,null),t($,sr),t($,pt),t($,mr),t($,X),h(xe,X,null),t(X,lr),t(X,dt),t($,pr),t($,J),h($e,J,null),t(J,dr),t(J,ct),t($,cr),t($,K),h(we,K,null),t(K,gr),t(K,gt),t($,hr),t($,Y),h(Ae,Y,null),t(Y,fr),t(Y,ht),p(e,pa,m),p(e,Ce,m),h(Le,Ce,null),p(e,da,m),p(e,L,m),h(Te,L,null),t(L,ur),t(L,ft),t(L,vr),t(L,ut),t(L,br),t(L,vt),t(L,_r),t(L,ee),h(De,ee,null),t(ee,yr),t(ee,bt),p(e,ca,m),p(e,T,m),h(ze,T,null),t(T,xr),t(T,_t),t(T,$r),t(T,yt),t(T,wr),t(T,xt),t(T,Ar),t(T,te),h(Me,te,null),t(te,Cr),t(te,$t),p(e,ga,m),p(e,M,m),h(Pe,M,null),t(M,Lr),t(M,wt),t(M,Tr),t(M,At),t(M,Dr),t(M,ae),h(Ne,ae,null),t(ae,zr),t(ae,Ct),p(e,ha,m),p(e,Ee,m),h(Fe,Ee,null),p(e,fa,m),p(e,y,m),h(Ie,y,null),t(y,Mr),t(y,Lt),t(y,Pr),t(y,Tt),t(y,Nr),t(y,Dt),t(y,Er),t(y,zt),t(y,Fr),t(y,Mt),t(y,Ir),t(y,re),h(He,re,null),t(re,Hr),t(re,Pt),p(e,ua,m),p(e,w,m),h(Re,w,null),t(w,Rr),t(w,Nt),t(w,Sr),t(w,Et),t(w,Gr),t(w,Ft),t(w,kr),t(w,It),t(w,Or),t(w,oe),h(Se,oe,null),t(oe,Br),t(oe,Ht),p(e,va,m),p(e,F,m),h(Ge,F,null),t(F,Vr),t(F,Rt),t(F,qr),t(F,ne),h(ke,ne,null),t(ne,Wr),t(ne,St),p(e,ba,m),p(e,Oe,m),h(Be,Oe,null),p(e,_a,m),p(e,_,m),h(Ve,_,null),t(_,jr),t(_,Gt),t(_,Ur),t(_,kt),t(_,Zr),t(_,Ot),t(_,Qr),t(_,Bt),t(_,Xr),t(_,Vt),t(_,Jr),t(_,qt),t(_,Kr),t(_,ie),h(qe,ie,null),t(ie,Yr),t(ie,Wt),p(e,ya,m),p(e,We,m),h(je,We,null),p(e,xa,m),p(e,Kt,m),$a=!0},p:un,i(e){$a||(f(le.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(ge.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(ve.$$.fragment,e),f(be.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(we.$$.fragment,e),f(Ae.$$.fragment,e),f(Le.$$.fragment,e),f(Te.$$.fragment,e),f(De.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(Pe.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(Ie.$$.fragment,e),f(He.$$.fragment,e),f(Re.$$.fragment,e),f(Se.$$.fragment,e),f(Ge.$$.fragment,e),f(ke.$$.fragment,e),f(Be.$$.fragment,e),f(Ve.$$.fragment,e),f(qe.$$.fragment,e),f(je.$$.fragment,e),$a=!0)},o(e){u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(we.$$.fragment,e),u(Ae.$$.fragment,e),u(Le.$$.fragment,e),u(Te.$$.fragment,e),u(De.$$.fragment,e),u(ze.$$.fragment,e),u(Me.$$.fragment,e),u(Pe.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),u(Ie.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(Se.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(Be.$$.fragment,e),u(Ve.$$.fragment,e),u(qe.$$.fragment,e),u(je.$$.fragment,e),$a=!1},d(e){e&&(o(Yt),o(Ut),o(ea),o(G),o(ta),o(pe),o(aa),o(k),o(ra),o(O),o(oa),o(B),o(na),o(z),o(ia),o(V),o(sa),o(x),o(ma),o(C),o(la),o($),o(pa),o(Ce),o(da),o(L),o(ca),o(T),o(ga),o(M),o(ha),o(Ee),o(fa),o(y),o(ua),o(w),o(va),o(F),o(ba),o(Oe),o(_a),o(_),o(ya),o(We),o(xa),o(Kt)),o(S),v(le),v(de),v(ce),v(ge),v(he),v(fe),v(ue),v(ve),v(be),v(_e),v(ye),v(xe),v($e),v(we),v(Ae),v(Le),v(Te),v(De),v(ze),v(Me),v(Pe),v(Ne),v(Fe),v(Ie),v(He),v(Re),v(Se),v(Ge),v(ke),v(Be),v(Ve),v(qe),v(je)}}}const $n={local:"optimization",sections:[{local:"optimizers",sections:[{local:"timm.optim.create_optimizer",title:"Factory functions"},{local:"timm.optim.AdaBelief",title:"Optimizer Classes"}],title:"Optimizers"}],title:"Optimization"};function wn(eo){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends bn{constructor(S){super(),_n(this,S,wn,xn,fn,{})}}export{Dn as component};
