import{s as rl,n as pl,o as dl}from"../chunks/scheduler.987d3921.js";import{S as ol,i as cl,g as a,s as t,u as c,A as Ml,h as r,f as s,c as i,j as M,v as u,y as p,k as d,o,a as n,w as m,d as h,t as w,x as y}from"../chunks/index.ab17fb05.js";import{I as ys}from"../chunks/IconCopyLink.4b0dcf5a.js";import{C as J}from"../chunks/CodeBlock.043aa174.js";function ul(bs){let T,ge,Je,Ie,j,g,Te,C,Js,me,Us="Wie erstellt man eine benutzerdefinierte Pipeline?",Be,_,gs=`In dieser Anleitung sehen wir uns an, wie Sie eine benutzerdefinierte Pipeline erstellen und sie auf dem <a href="hf.co/models">Hub</a> freigeben oder sie der
🤗 Transformers-Bibliothek hinzufügen.`,ke,z,Is=`Zuallererst müssen Sie entscheiden, welche Roheingaben die Pipeline verarbeiten kann. Es kann sich um Strings, rohe Bytes,
Dictionaries oder was auch immer die wahrscheinlichste gewünschte Eingabe ist. Versuchen Sie, diese Eingaben so rein wie möglich in Python zu halten
denn das macht die Kompatibilität einfacher (auch mit anderen Sprachen über JSON). Dies werden die Eingaben der
Pipeline (<code>Vorverarbeitung</code>).`,Ce,v,Bs=`Definieren Sie dann die <code>Outputs</code>. Dieselbe Richtlinie wie für die Eingänge. Je einfacher, desto besser. Dies werden die Ausgaben der
Methode <code>Postprocess</code>.`,_e,Z,ks=`Beginnen Sie damit, die Basisklasse <code>Pipeline</code> mit den 4 Methoden zu erben, die für die Implementierung von <code>preprocess</code> benötigt werden,
Weiterleiten”, “Nachbearbeitung” und “Parameter säubern”.`,ze,A,ve,E,Cs=`Die Struktur dieser Aufteilung soll eine relativ nahtlose Unterstützung für CPU/GPU ermöglichen und gleichzeitig die Durchführung von
Vor-/Nachbearbeitung auf der CPU in verschiedenen Threads`,Ze,G,_s=`Preprocess” nimmt die ursprünglich definierten Eingaben und wandelt sie in etwas um, das in das Modell eingespeist werden kann. Es kann
mehr Informationen enthalten und ist normalerweise ein <code>Dict</code>.`,Ae,H,zs=`<code>_forward</code> ist das Implementierungsdetail und ist nicht dafür gedacht, direkt aufgerufen zu werden. Weiterleiten” ist die bevorzugte
aufgerufene Methode, da sie Sicherheitsvorkehrungen enthält, die sicherstellen, dass alles auf dem erwarteten Gerät funktioniert. Wenn etwas
mit einem realen Modell verknüpft ist, gehört es in die Methode <code>_forward</code>, alles andere gehört in die Methoden preprocess/postprocess.`,Ee,N,vs=`Die Methode <code>Postprocess</code> nimmt die Ausgabe von <code>_forward</code> und verwandelt sie in die endgültige Ausgabe, die zuvor festgelegt wurde.
zuvor entschieden wurde.`,Ge,V,Zs=`Die Methode <code>_sanitize_parameters</code> ermöglicht es dem Benutzer, beliebige Parameter zu übergeben, wann immer er möchte, sei es bei der Initialisierung
Zeit <code>pipeline(...., maybe_arg=4)</code> oder zur Aufrufzeit <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,He,W,As=`Die Rückgabe von <code>_sanitize_parameters</code> sind die 3 Dicts von kwargs, die direkt an <code>preprocess</code> übergeben werden,
<code>_forward</code> und <code>postprocess</code> übergeben werden. Füllen Sie nichts aus, wenn der Aufrufer keinen zusätzlichen Parameter angegeben hat. Das
erlaubt es, die Standardargumente in der Funktionsdefinition beizubehalten, was immer “natürlicher” ist.`,Ne,R,Es="Ein klassisches Beispiel wäre das Argument <code>top_k</code> in der Nachbearbeitung bei Klassifizierungsaufgaben.",Ve,X,We,q,Gs=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,Re,S,Xe,x,Hs=`Versuchen Sie, die Eingaben/Ausgaben sehr einfach und idealerweise JSON-serialisierbar zu halten, da dies die Verwendung der Pipeline sehr einfach macht
ohne dass die Benutzer neue Arten von Objekten verstehen müssen. Es ist auch relativ üblich, viele verschiedene Arten von Argumenten zu unterstützen
von Argumenten zu unterstützen (Audiodateien, die Dateinamen, URLs oder reine Bytes sein können).`,qe,f,I,je,$,Ts,he,Ns="Hinzufügen zur Liste der unterstützten Aufgaben",Se,P,Vs="Um Ihre <code>neue Aufgabe</code> in die Liste der unterstützten Aufgaben aufzunehmen, müssen Sie sie zur <code>PIPELINE_REGISTRY</code> hinzufügen:",xe,Y,$e,F,Ws="Wenn Sie möchten, können Sie ein Standardmodell angeben. In diesem Fall sollte es mit einer bestimmten Revision (die der Name einer Verzweigung oder ein Commit-Hash sein kann, hier haben wir <code>&quot;abcdef&quot;</code> genommen) sowie mit dem Typ versehen sein:",Pe,Q,Ye,b,B,fe,L,js,we,Rs="Teilen Sie Ihre Pipeline auf dem Hub",Fe,D,Xs=`Um Ihre benutzerdefinierte Pipeline auf dem Hub freizugeben, müssen Sie lediglich den benutzerdefinierten Code Ihrer <code>Pipeline</code>-Unterklasse in einer
Python-Datei speichern. Nehmen wir zum Beispiel an, Sie möchten eine benutzerdefinierte Pipeline für die Klassifizierung von Satzpaaren wie folgt verwenden:`,Qe,K,Le,O,qs=`Die Implementierung ist Framework-unabhängig und funktioniert für PyTorch- und TensorFlow-Modelle. Wenn wir dies in einer Datei
einer Datei namens <code>pair_classification.py</code> gespeichert haben, können wir sie importieren und wie folgt registrieren:`,De,ee,Ke,se,Ss=`Sobald dies geschehen ist, können wir es mit einem vortrainierten Modell verwenden. Zum Beispiel wurde <code>sgugger/finetuned-bert-mrpc</code> auf den
auf den MRPC-Datensatz abgestimmt, der Satzpaare als Paraphrasen oder nicht klassifiziert.`,Oe,le,es,ne,xs="Dann können wir sie auf dem Hub mit der Methode <code>save_pretrained</code> in einem <code>Repository</code> freigeben:",ss,te,ls,ie,$s=`Dadurch wird die Datei, in der Sie <code>PairClassificationPipeline</code> definiert haben, in den Ordner <code>&quot;test-dynamic-pipeline&quot;</code> kopiert,
und speichert das Modell und den Tokenizer der Pipeline, bevor Sie alles in das Repository verschieben
<code>{Ihr_Benutzername}/test-dynamic-pipeline</code>. Danach kann jeder die Pipeline verwenden, solange er die Option
<code>trust_remote_code=True</code> angeben:`,ns,ae,ts,U,k,be,re,fs,ye,Ps="Hinzufügen der Pipeline zu 🤗 Transformers",is,pe,Ys=`Wenn Sie Ihre Pipeline zu 🤗 Transformers beitragen möchten, müssen Sie ein neues Modul im Untermodul <code>pipelines</code> hinzufügen
mit dem Code Ihrer Pipeline hinzufügen. Fügen Sie es dann der Liste der in <code>pipelines/__init__.py</code> definierten Aufgaben hinzu.`,as,de,Fs="Dann müssen Sie noch Tests hinzufügen. Erstellen Sie eine neue Datei <code>tests/test_pipelines_MY_PIPELINE.py</code> mit Beispielen für die anderen Tests.",rs,oe,Qs=`Die Funktion <code>run_pipeline_test</code> ist sehr allgemein gehalten und läuft auf kleinen Zufallsmodellen auf jeder möglichen
Architektur, wie durch <code>model_mapping</code> und <code>tf_model_mapping</code> definiert.`,ps,ce,Ls=`Dies ist sehr wichtig, um die zukünftige Kompatibilität zu testen, d.h. wenn jemand ein neues Modell für
<code>XXXForQuestionAnswering</code> hinzufügt, wird der Pipeline-Test versuchen, mit diesem Modell zu arbeiten. Da die Modelle zufällig sind, ist es
ist es unmöglich, die tatsächlichen Werte zu überprüfen. Deshalb gibt es eine Hilfsfunktion <code>ANY</code>, die einfach versucht, die
Ausgabe der Pipeline TYPE.`,ds,Me,Ds="Außerdem <em>müssen</em> Sie 2 (idealerweise 4) Tests implementieren.",os,ue,Ks=`<li>test_small_model_pt<code>: Definieren Sie 1 kleines Modell für diese Pipeline (es spielt keine Rolle, ob die Ergebnisse keinen Sinn ergeben) und testen Sie die Ausgaben der Pipeline. Die Ergebnisse sollten die gleichen sein wie bei</code>test_small_model_tf\`.</li> <li>test_small_model_tf : Definieren Sie 1 kleines Modell für diese Pipeline (es spielt keine Rolle, ob die Ergebnisse keinen Sinn ergeben)
und testen Sie die Ausgaben der Pipeline. Die Ergebnisse sollten die gleichen sein wie bei <code>test_small_model_pt</code>.</li> <li>test_large_model_pt<code>(</code>optional\`): Testet die Pipeline an einer echten Pipeline, bei der die Ergebnisse
Sinn machen. Diese Tests sind langsam und sollten als solche gekennzeichnet werden. Hier geht es darum, die Pipeline zu präsentieren und sicherzustellen
sicherzustellen, dass es in zukünftigen Versionen keine Abweichungen gibt.</li> <li>test_large_model_tf<code>(</code>optional\`): Testet die Pipeline an einer echten Pipeline, bei der die Ergebnisse
Sinn machen. Diese Tests sind langsam und sollten als solche gekennzeichnet werden. Hier geht es darum, die Pipeline zu präsentieren und sicherzustellen
sicherzustellen, dass es in zukünftigen Versionen keine Abweichungen gibt.</li>`,cs,Ue,Ms;return C=new ys({}),A=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),X=new J({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),S=new J({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),$=new ys({}),Y=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),Q=new J({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),L=new ys({}),K=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),ee=new J({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),le=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),te=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),ae=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),re=new ys({}),{c(){T=a("meta"),ge=t(),Je=a("p"),Ie=t(),j=a("h1"),g=a("a"),Te=a("span"),c(C.$$.fragment),Js=t(),me=a("span"),me.textContent=Us,Be=t(),_=a("p"),_.innerHTML=gs,ke=t(),z=a("p"),z.innerHTML=Is,Ce=t(),v=a("p"),v.innerHTML=Bs,_e=t(),Z=a("p"),Z.innerHTML=ks,ze=t(),c(A.$$.fragment),ve=t(),E=a("p"),E.textContent=Cs,Ze=t(),G=a("p"),G.innerHTML=_s,Ae=t(),H=a("p"),H.innerHTML=zs,Ee=t(),N=a("p"),N.innerHTML=vs,Ge=t(),V=a("p"),V.innerHTML=Zs,He=t(),W=a("p"),W.innerHTML=As,Ne=t(),R=a("p"),R.innerHTML=Es,Ve=t(),c(X.$$.fragment),We=t(),q=a("p"),q.innerHTML=Gs,Re=t(),c(S.$$.fragment),Xe=t(),x=a("p"),x.textContent=Hs,qe=t(),f=a("h2"),I=a("a"),je=a("span"),c($.$$.fragment),Ts=t(),he=a("span"),he.textContent=Ns,Se=t(),P=a("p"),P.innerHTML=Vs,xe=t(),c(Y.$$.fragment),$e=t(),F=a("p"),F.innerHTML=Ws,Pe=t(),c(Q.$$.fragment),Ye=t(),b=a("h2"),B=a("a"),fe=a("span"),c(L.$$.fragment),js=t(),we=a("span"),we.textContent=Rs,Fe=t(),D=a("p"),D.innerHTML=Xs,Qe=t(),c(K.$$.fragment),Le=t(),O=a("p"),O.innerHTML=qs,De=t(),c(ee.$$.fragment),Ke=t(),se=a("p"),se.innerHTML=Ss,Oe=t(),c(le.$$.fragment),es=t(),ne=a("p"),ne.innerHTML=xs,ss=t(),c(te.$$.fragment),ls=t(),ie=a("p"),ie.innerHTML=$s,ns=t(),c(ae.$$.fragment),ts=t(),U=a("h2"),k=a("a"),be=a("span"),c(re.$$.fragment),fs=t(),ye=a("span"),ye.textContent=Ps,is=t(),pe=a("p"),pe.innerHTML=Ys,as=t(),de=a("p"),de.innerHTML=Fs,rs=t(),oe=a("p"),oe.innerHTML=Qs,ps=t(),ce=a("p"),ce.innerHTML=Ls,ds=t(),Me=a("p"),Me.innerHTML=Ds,os=t(),ue=a("ul"),ue.innerHTML=Ks,cs=t(),Ue=a("p"),this.h()},l(e){const l=Ml("svelte-1phssyn",document.head);T=r(l,"META",{name:!0,content:!0}),l.forEach(s),ge=i(e),Je=r(e,"P",{}),M(Je).forEach(s),Ie=i(e),j=r(e,"H1",{class:!0});var us=M(j);g=r(us,"A",{id:!0,class:!0,href:!0});var Os=M(g);Te=r(Os,"SPAN",{});var el=M(Te);u(C.$$.fragment,el),el.forEach(s),Os.forEach(s),Js=i(us),me=r(us,"SPAN",{"data-svelte-h":!0}),p(me)!=="svelte-abu1ih"&&(me.textContent=Us),us.forEach(s),Be=i(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1s3you8"&&(_.innerHTML=gs),ke=i(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1gibur5"&&(z.innerHTML=Is),Ce=i(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1s6g8s2"&&(v.innerHTML=Bs),_e=i(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-178jgk4"&&(Z.innerHTML=ks),ze=i(e),u(A.$$.fragment,e),ve=i(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-prsu03"&&(E.textContent=Cs),Ze=i(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-111rxft"&&(G.innerHTML=_s),Ae=i(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-wh0ews"&&(H.innerHTML=zs),Ee=i(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-dhzsf"&&(N.innerHTML=vs),Ge=i(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1vn0211"&&(V.innerHTML=Zs),He=i(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1gm9nlz"&&(W.innerHTML=As),Ne=i(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1o6q40b"&&(R.innerHTML=Es),Ve=i(e),u(X.$$.fragment,e),We=i(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-nsc0of"&&(q.innerHTML=Gs),Re=i(e),u(S.$$.fragment,e),Xe=i(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-18aybbs"&&(x.textContent=Hs),qe=i(e),f=r(e,"H2",{class:!0});var ms=M(f);I=r(ms,"A",{id:!0,class:!0,href:!0});var sl=M(I);je=r(sl,"SPAN",{});var ll=M(je);u($.$$.fragment,ll),ll.forEach(s),sl.forEach(s),Ts=i(ms),he=r(ms,"SPAN",{"data-svelte-h":!0}),p(he)!=="svelte-1gjvuc3"&&(he.textContent=Ns),ms.forEach(s),Se=i(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1wh7t0j"&&(P.innerHTML=Vs),xe=i(e),u(Y.$$.fragment,e),$e=i(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-3k8nr4"&&(F.innerHTML=Ws),Pe=i(e),u(Q.$$.fragment,e),Ye=i(e),b=r(e,"H2",{class:!0});var hs=M(b);B=r(hs,"A",{id:!0,class:!0,href:!0});var nl=M(B);fe=r(nl,"SPAN",{});var tl=M(fe);u(L.$$.fragment,tl),tl.forEach(s),nl.forEach(s),js=i(hs),we=r(hs,"SPAN",{"data-svelte-h":!0}),p(we)!=="svelte-1lyccby"&&(we.textContent=Rs),hs.forEach(s),Fe=i(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vgfgi6"&&(D.innerHTML=Xs),Qe=i(e),u(K.$$.fragment,e),Le=i(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-rraq57"&&(O.innerHTML=qs),De=i(e),u(ee.$$.fragment,e),Ke=i(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-lmblxt"&&(se.innerHTML=Ss),Oe=i(e),u(le.$$.fragment,e),es=i(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-vi7z9w"&&(ne.innerHTML=xs),ss=i(e),u(te.$$.fragment,e),ls=i(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-bimycc"&&(ie.innerHTML=$s),ns=i(e),u(ae.$$.fragment,e),ts=i(e),U=r(e,"H2",{class:!0});var ws=M(U);k=r(ws,"A",{id:!0,class:!0,href:!0});var il=M(k);be=r(il,"SPAN",{});var al=M(be);u(re.$$.fragment,al),al.forEach(s),il.forEach(s),fs=i(ws),ye=r(ws,"SPAN",{"data-svelte-h":!0}),p(ye)!=="svelte-qdp22s"&&(ye.textContent=Ps),ws.forEach(s),is=i(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-13f7wv7"&&(pe.innerHTML=Ys),as=i(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-ty86wt"&&(de.innerHTML=Fs),rs=i(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1mq6d2v"&&(oe.innerHTML=Qs),ps=i(e),ce=r(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-bcl54q"&&(ce.innerHTML=Ls),ds=i(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-3mgk43"&&(Me.innerHTML=Ds),os=i(e),ue=r(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-moqumw"&&(ue.innerHTML=Ks),cs=i(e),Ue=r(e,"P",{}),M(Ue).forEach(s),this.h()},h(){d(T,"name","hf:doc:metadata"),d(T,"content",JSON.stringify(ml)),d(g,"id","wie-erstellt-man-eine-benutzerdefinierte-pipeline"),d(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(g,"href","#wie-erstellt-man-eine-benutzerdefinierte-pipeline"),d(j,"class","relative group"),d(I,"id","hinzufgen-zur-liste-der-untersttzten-aufgaben"),d(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(I,"href","#hinzufgen-zur-liste-der-untersttzten-aufgaben"),d(f,"class","relative group"),d(B,"id","teilen-sie-ihre-pipeline-auf-dem-hub"),d(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(B,"href","#teilen-sie-ihre-pipeline-auf-dem-hub"),d(b,"class","relative group"),d(k,"id","hinzufgen-der-pipeline-zu-transformers"),d(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(k,"href","#hinzufgen-der-pipeline-zu-transformers"),d(U,"class","relative group")},m(e,l){o(document.head,T),n(e,ge,l),n(e,Je,l),n(e,Ie,l),n(e,j,l),o(j,g),o(g,Te),m(C,Te,null),o(j,Js),o(j,me),n(e,Be,l),n(e,_,l),n(e,ke,l),n(e,z,l),n(e,Ce,l),n(e,v,l),n(e,_e,l),n(e,Z,l),n(e,ze,l),m(A,e,l),n(e,ve,l),n(e,E,l),n(e,Ze,l),n(e,G,l),n(e,Ae,l),n(e,H,l),n(e,Ee,l),n(e,N,l),n(e,Ge,l),n(e,V,l),n(e,He,l),n(e,W,l),n(e,Ne,l),n(e,R,l),n(e,Ve,l),m(X,e,l),n(e,We,l),n(e,q,l),n(e,Re,l),m(S,e,l),n(e,Xe,l),n(e,x,l),n(e,qe,l),n(e,f,l),o(f,I),o(I,je),m($,je,null),o(f,Ts),o(f,he),n(e,Se,l),n(e,P,l),n(e,xe,l),m(Y,e,l),n(e,$e,l),n(e,F,l),n(e,Pe,l),m(Q,e,l),n(e,Ye,l),n(e,b,l),o(b,B),o(B,fe),m(L,fe,null),o(b,js),o(b,we),n(e,Fe,l),n(e,D,l),n(e,Qe,l),m(K,e,l),n(e,Le,l),n(e,O,l),n(e,De,l),m(ee,e,l),n(e,Ke,l),n(e,se,l),n(e,Oe,l),m(le,e,l),n(e,es,l),n(e,ne,l),n(e,ss,l),m(te,e,l),n(e,ls,l),n(e,ie,l),n(e,ns,l),m(ae,e,l),n(e,ts,l),n(e,U,l),o(U,k),o(k,be),m(re,be,null),o(U,fs),o(U,ye),n(e,is,l),n(e,pe,l),n(e,as,l),n(e,de,l),n(e,rs,l),n(e,oe,l),n(e,ps,l),n(e,ce,l),n(e,ds,l),n(e,Me,l),n(e,os,l),n(e,ue,l),n(e,cs,l),n(e,Ue,l),Ms=!0},p:pl,i(e){Ms||(h(C.$$.fragment,e),h(A.$$.fragment,e),h(X.$$.fragment,e),h(S.$$.fragment,e),h($.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),Ms=!0)},o(e){w(C.$$.fragment,e),w(A.$$.fragment,e),w(X.$$.fragment,e),w(S.$$.fragment,e),w($.$$.fragment,e),w(Y.$$.fragment,e),w(Q.$$.fragment,e),w(L.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(le.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(re.$$.fragment,e),Ms=!1},d(e){e&&(s(ge),s(Je),s(Ie),s(j),s(Be),s(_),s(ke),s(z),s(Ce),s(v),s(_e),s(Z),s(ze),s(ve),s(E),s(Ze),s(G),s(Ae),s(H),s(Ee),s(N),s(Ge),s(V),s(He),s(W),s(Ne),s(R),s(Ve),s(We),s(q),s(Re),s(Xe),s(x),s(qe),s(f),s(Se),s(P),s(xe),s($e),s(F),s(Pe),s(Ye),s(b),s(Fe),s(D),s(Qe),s(Le),s(O),s(De),s(Ke),s(se),s(Oe),s(es),s(ne),s(ss),s(ls),s(ie),s(ns),s(ts),s(U),s(is),s(pe),s(as),s(de),s(rs),s(oe),s(ps),s(ce),s(ds),s(Me),s(os),s(ue),s(cs),s(Ue)),s(T),y(C),y(A,e),y(X,e),y(S,e),y($),y(Y,e),y(Q,e),y(L),y(K,e),y(ee,e),y(le,e),y(te,e),y(ae,e),y(re)}}}const ml={local:"wie-erstellt-man-eine-benutzerdefinierte-pipeline",sections:[{local:"hinzufgen-zur-liste-der-untersttzten-aufgaben",title:"Hinzufügen zur Liste der unterstützten Aufgaben"},{local:"teilen-sie-ihre-pipeline-auf-dem-hub",title:"Teilen Sie Ihre Pipeline auf dem Hub"},{local:"hinzufgen-der-pipeline-zu-transformers",title:"Hinzufügen der Pipeline zu 🤗 Transformers"}],title:"Wie erstellt man eine benutzerdefinierte Pipeline?"};function hl(bs){return dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends ol{constructor(T){super(),cl(this,T,hl,ul,rl,{})}}export{jl as component};
