import{s as Xs,n as Ps,o as Ys}from"../chunks/scheduler.9bc65507.js";import{S as Ds,i as Ks,g as l,s as o,u as m,A as Os,h as n,f as t,c as p,j as c,v as d,y as i,k as r,o as h,a,w as u,d as y,t as M,x as g}from"../chunks/index.78c82d43.js";import{I as be}from"../chunks/IconCopyLink.bedaa44d.js";import{C as j}from"../chunks/CodeBlock.73e038be.js";function ea(Kt){let f,Re,Se,He,w,C,$e,S,qt,Ce,Ot="Templates for Chat Models",qe,U,v,Ze,$,Lt,ve,es="Introduction",Le,Z,ts=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong> as well as message text.`,Fe,G,ss=`Most commonly, these roles are “user” for messages sent by the user, and “assistant” for messages sent by the model.
Some models also support a “system” role. System messages are usually sent at the beginning of the conversation
and include directives about how the model should behave in the subsequent chat.`,Xe,z,as=`All language models, including models fine-tuned for chat, operate on linear sequences of tokens and do not intrinsically
have special handling for roles. This means that role information is usually injected by adding control tokens
between messages, to indicate both the message boundary and the relevant roles.`,Pe,B,ls=`Unfortunately, there isn’t (yet!) a standard for which tokens to use, and so different models have been trained
with wildly different formatting and control tokens for chat. This can be a real problem for users - if you use the
wrong format, then the model will be confused by your input, and your performance will be a lot worse than it should be.
This is the problem that <strong>chat templates</strong> aim to resolve.`,Ye,W,ns=`Chat conversations are typically represented as a list of dictionaries, where each dictionary contains <code>role</code>
and <code>content</code> keys, and represents a single chat message. Chat templates are strings containing a Jinja template that
specifies how to format a conversation for a given model into a single tokenizable sequence. By storing this information
with the tokenizer, we can ensure that models get input data in the format they expect.`,De,V,os=`Let’s make this concrete with a quick example using the <code>BlenderBot</code> model. BlenderBot has an extremely simple default
template, which mostly just adds whitespace between rounds of dialogue:`,Ke,E,Oe,R,ps=`Notice how the entire chat is condensed into a single string. If we use <code>tokenize=True</code>, which is the default setting,
that string will also be tokenized for us. To see a more complex template in action, though, let’s use the
<code>meta-llama/Llama-2-7b-chat-hf</code> model. Note that this model has gated access, so you will have to
<a href="https://huggingface.co/meta-llama/Llama-2-7b-chat-hf" rel="nofollow">request access on the repo</a> if you want to run this code yourself:`,et,H,tt,q,is=`Note that this time, the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!)`,st,T,k,Ge,L,Ft,ke,rs="How do chat templates work?",at,F,hs=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. If no chat template is set, the
default template for that model class is used instead. Let’s take a look at the template for <code>BlenderBot</code>:`,lt,X,nt,P,cs=`That’s kind of intimidating. Let’s add some newlines and indentation to make it more readable. Note that
we remove the first newline after each block as well as any preceding whitespace before a block by default, using the
Jinja <code>trim_blocks</code> and <code>lstrip_blocks</code> flags. This means that you can write your templates with indentations and
newlines and still have them function correctly!`,ot,Y,pt,D,ms=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,it,K,rt,O,ds="Effectively, the template does three things:",ht,ee,us="<li>For each message, if the message is a user message, add a blank space before it, otherwise print nothing.</li> <li>Add the message content</li> <li>If the message is not the last message, add two spaces after it. After the final message, print the EOS token.</li>",ct,te,ys=`This is a pretty simple template - it doesn’t add any control tokens, and it doesn’t support “system” messages, which
are a common way to give the model directives about how it should behave in the subsequent conversation.
But Jinja gives you a lot of flexibility to do those things! Let’s see a Jinja template that can format inputs
similarly to the way LLaMA formats them (note that the real LLaMA template includes handling for default system
messages and slightly different system message handling in general - don’t use this one in your actual code!)`,mt,se,dt,ae,Ms=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens based
on the “role” of each message, which represents who sent it. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,ut,J,N,ze,le,Xt,Ne,gs="How do I create a chat template?",yt,ne,js=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Mt,oe,gt,pe,fs=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/v4.34.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,jt,ie,ft,re,ws=`The method <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>.`,wt,I,A,Be,he,Pt,Ae,Us='What are "default" templates?',Ut,ce,Ts=`Before the introduction of chat templates, chat handling was hardcoded at the model class level. For backwards
compatibility, we have retained this class-specific handling as default templates, also set at the class level. If a
model does not have a chat template set, but there is a default template for its model class, the <code>ConversationalPipeline</code>
class and methods like <code>apply_chat_template</code> will use the class template instead. You can find out what the default
template for your tokenizer is by checking the <code>tokenizer.default_chat_template</code> attribute.`,Tt,me,Js=`This is something we do purely for backward compatibility reasons, to avoid breaking any existing workflows. Even when
the class template is appropriate for your model, we strongly recommend overriding the default template by
setting the <code>chat_template</code> attribute explicitly to make it clear to users that your model has been correctly configured
for chat, and to future-proof in case the default templates are ever altered or deprecated.`,Jt,x,_,We,de,Yt,_e,Is="What template should I use?",It,ue,xs=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,xt,ye,bs=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. Our default template for models that don’t have a class-specific template follows the
<a href="https://github.com/openai/openai-python/blob/main/chatml.md" rel="nofollow">ChatML format</a>, and this is a good, flexible choice for many use-cases. It looks like this:`,bt,Me,Ct,ge,Cs="If you like this one, here it is in one-liner form, ready to copy into your code:",vt,je,kt,fe,vs=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,Nt,we,At,Ue,ks=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.ConversationalPipeline">ConversationalPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,_t,b,Q,Ve,Te,Dt,Qe,Ns="I want to use chat templates! How should I get started?",Qt,Je,As=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.apply_chat_template">apply_chat_template()</a>. This applies even if you’re not the model owner - if you’re using a model
with an empty chat template, or one that’s still using the default class template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to
the model repository so that this attribute can be set properly!`,St,Ie,_s=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>ConversationalPipeline</code>!`,$t,xe,Qs=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Zt,Ee,Gt;return S=new be({}),$=new be({}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),H=new j({props:{code:"JTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGVsbG8lMkMlMjBob3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUyMiU3RCUyQyUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkknZCUyMGxpa2UlMjB0byUyMHNob3clMjBvZmYlMjBob3clMjBjaGF0JTIwdGVtcGxhdGluZyUyMHdvcmtzISUyMiU3RCUyQyUwQSU1RCUwQQ==",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

&gt;&gt; chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

&gt;&gt; tokenizer.use_default_system_prompt = <span class="hljs-literal">False</span>
&gt;&gt; tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST] I&#x27;m doing great. How can I help you today? &lt;/s&gt;&lt;s&gt;[INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),L=new be({}),X=new j({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),Y=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),K=new j({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),se=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),le=new be({}),oe=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ie=new j({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),he=new be({}),de=new be({}),Me=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),je=new j({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),we=new j({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|<span class="hljs-type">im_start</span>|<span class="hljs-type">&gt;system</span>
You are a helpful chatbot that will <span class="hljs-built_in">do</span> its best not to say anything so stupid that people tweet about it.&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;user</span>
How are you?&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;
&lt;|im_start</span>|<span class="hljs-type">&gt;assistant</span>
I&#x27;m doing great!&lt;|<span class="hljs-type">im_end</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),Te=new be({}),{c(){f=l("meta"),Re=o(),Se=l("p"),He=o(),w=l("h1"),C=l("a"),$e=l("span"),m(S.$$.fragment),qt=o(),Ce=l("span"),Ce.textContent=Ot,qe=o(),U=l("h2"),v=l("a"),Ze=l("span"),m($.$$.fragment),Lt=o(),ve=l("span"),ve.textContent=es,Le=o(),Z=l("p"),Z.innerHTML=ts,Fe=o(),G=l("p"),G.textContent=ss,Xe=o(),z=l("p"),z.textContent=as,Pe=o(),B=l("p"),B.innerHTML=ls,Ye=o(),W=l("p"),W.innerHTML=ns,De=o(),V=l("p"),V.innerHTML=os,Ke=o(),m(E.$$.fragment),Oe=o(),R=l("p"),R.innerHTML=ps,et=o(),m(H.$$.fragment),tt=o(),q=l("p"),q.textContent=is,st=o(),T=l("h2"),k=l("a"),Ge=l("span"),m(L.$$.fragment),Ft=o(),ke=l("span"),ke.textContent=rs,at=o(),F=l("p"),F.innerHTML=hs,lt=o(),m(X.$$.fragment),nt=o(),P=l("p"),P.innerHTML=cs,ot=o(),m(Y.$$.fragment),pt=o(),D=l("p"),D.innerHTML=ms,it=o(),m(K.$$.fragment),rt=o(),O=l("p"),O.textContent=ds,ht=o(),ee=l("ol"),ee.innerHTML=us,ct=o(),te=l("p"),te.textContent=ys,mt=o(),m(se.$$.fragment),dt=o(),ae=l("p"),ae.textContent=Ms,ut=o(),J=l("h2"),N=l("a"),ze=l("span"),m(le.$$.fragment),Xt=o(),Ne=l("span"),Ne.textContent=gs,yt=o(),ne=l("p"),ne.innerHTML=js,Mt=o(),m(oe.$$.fragment),gt=o(),pe=l("p"),pe.innerHTML=fs,jt=o(),m(ie.$$.fragment),ft=o(),re=l("p"),re.innerHTML=ws,wt=o(),I=l("h2"),A=l("a"),Be=l("span"),m(he.$$.fragment),Pt=o(),Ae=l("span"),Ae.textContent=Us,Ut=o(),ce=l("p"),ce.innerHTML=Ts,Tt=o(),me=l("p"),me.innerHTML=Js,Jt=o(),x=l("h2"),_=l("a"),We=l("span"),m(de.$$.fragment),Yt=o(),_e=l("span"),_e.textContent=Is,It=o(),ue=l("p"),ue.textContent=xs,xt=o(),ye=l("p"),ye.innerHTML=bs,bt=o(),m(Me.$$.fragment),Ct=o(),ge=l("p"),ge.textContent=Cs,vt=o(),m(je.$$.fragment),kt=o(),fe=l("p"),fe.innerHTML=vs,Nt=o(),m(we.$$.fragment),At=o(),Ue=l("p"),Ue.innerHTML=ks,_t=o(),b=l("h2"),Q=l("a"),Ve=l("span"),m(Te.$$.fragment),Dt=o(),Qe=l("span"),Qe.textContent=Ns,Qt=o(),Je=l("p"),Je.innerHTML=As,St=o(),Ie=l("p"),Ie.innerHTML=_s,$t=o(),xe=l("p"),xe.textContent=Qs,Zt=o(),Ee=l("p"),this.h()},l(e){const s=Os("svelte-1phssyn",document.head);f=n(s,"META",{name:!0,content:!0}),s.forEach(t),Re=p(e),Se=n(e,"P",{}),c(Se).forEach(t),He=p(e),w=n(e,"H1",{class:!0});var zt=c(w);C=n(zt,"A",{id:!0,class:!0,href:!0});var Ss=c(C);$e=n(Ss,"SPAN",{});var $s=c($e);d(S.$$.fragment,$s),$s.forEach(t),Ss.forEach(t),qt=p(zt),Ce=n(zt,"SPAN",{"data-svelte-h":!0}),i(Ce)!=="svelte-1d422hf"&&(Ce.textContent=Ot),zt.forEach(t),qe=p(e),U=n(e,"H2",{class:!0});var Bt=c(U);v=n(Bt,"A",{id:!0,class:!0,href:!0});var Zs=c(v);Ze=n(Zs,"SPAN",{});var Gs=c(Ze);d($.$$.fragment,Gs),Gs.forEach(t),Zs.forEach(t),Lt=p(Bt),ve=n(Bt,"SPAN",{"data-svelte-h":!0}),i(ve)!=="svelte-hzp88l"&&(ve.textContent=es),Bt.forEach(t),Le=p(e),Z=n(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1ktexn3"&&(Z.innerHTML=ts),Fe=p(e),G=n(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1xlggqv"&&(G.textContent=ss),Xe=p(e),z=n(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-pmlzkx"&&(z.textContent=as),Pe=p(e),B=n(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-17e4zh4"&&(B.innerHTML=ls),Ye=p(e),W=n(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1bgzjn5"&&(W.innerHTML=ns),De=p(e),V=n(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1n6wf0k"&&(V.innerHTML=os),Ke=p(e),d(E.$$.fragment,e),Oe=p(e),R=n(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1ensusj"&&(R.innerHTML=ps),et=p(e),d(H.$$.fragment,e),tt=p(e),q=n(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-7ppdar"&&(q.textContent=is),st=p(e),T=n(e,"H2",{class:!0});var Wt=c(T);k=n(Wt,"A",{id:!0,class:!0,href:!0});var zs=c(k);Ge=n(zs,"SPAN",{});var Bs=c(Ge);d(L.$$.fragment,Bs),Bs.forEach(t),zs.forEach(t),Ft=p(Wt),ke=n(Wt,"SPAN",{"data-svelte-h":!0}),i(ke)!=="svelte-l0a7qt"&&(ke.textContent=rs),Wt.forEach(t),at=p(e),F=n(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-9hx4bd"&&(F.innerHTML=hs),lt=p(e),d(X.$$.fragment,e),nt=p(e),P=n(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-vicnrv"&&(P.innerHTML=cs),ot=p(e),d(Y.$$.fragment,e),pt=p(e),D=n(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-zet1qo"&&(D.innerHTML=ms),it=p(e),d(K.$$.fragment,e),rt=p(e),O=n(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-9bdwn1"&&(O.textContent=ds),ht=p(e),ee=n(e,"OL",{"data-svelte-h":!0}),i(ee)!=="svelte-yy2gop"&&(ee.innerHTML=us),ct=p(e),te=n(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-jxu6rq"&&(te.textContent=ys),mt=p(e),d(se.$$.fragment,e),dt=p(e),ae=n(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-dqaxjt"&&(ae.textContent=Ms),ut=p(e),J=n(e,"H2",{class:!0});var Vt=c(J);N=n(Vt,"A",{id:!0,class:!0,href:!0});var Ws=c(N);ze=n(Ws,"SPAN",{});var Vs=c(ze);d(le.$$.fragment,Vs),Vs.forEach(t),Ws.forEach(t),Xt=p(Vt),Ne=n(Vt,"SPAN",{"data-svelte-h":!0}),i(Ne)!=="svelte-13ym6bp"&&(Ne.textContent=gs),Vt.forEach(t),yt=p(e),ne=n(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-1ubxgh9"&&(ne.innerHTML=js),Mt=p(e),d(oe.$$.fragment,e),gt=p(e),pe=n(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-1rgwbn3"&&(pe.innerHTML=fs),jt=p(e),d(ie.$$.fragment,e),ft=p(e),re=n(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-39tz4g"&&(re.innerHTML=ws),wt=p(e),I=n(e,"H2",{class:!0});var Et=c(I);A=n(Et,"A",{id:!0,class:!0,href:!0});var Es=c(A);Be=n(Es,"SPAN",{});var Rs=c(Be);d(he.$$.fragment,Rs),Rs.forEach(t),Es.forEach(t),Pt=p(Et),Ae=n(Et,"SPAN",{"data-svelte-h":!0}),i(Ae)!=="svelte-1fukrmy"&&(Ae.textContent=Us),Et.forEach(t),Ut=p(e),ce=n(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-fwloaj"&&(ce.innerHTML=Ts),Tt=p(e),me=n(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-118w8i2"&&(me.innerHTML=Js),Jt=p(e),x=n(e,"H2",{class:!0});var Rt=c(x);_=n(Rt,"A",{id:!0,class:!0,href:!0});var Hs=c(_);We=n(Hs,"SPAN",{});var qs=c(We);d(de.$$.fragment,qs),qs.forEach(t),Hs.forEach(t),Yt=p(Rt),_e=n(Rt,"SPAN",{"data-svelte-h":!0}),i(_e)!=="svelte-14g1i77"&&(_e.textContent=Is),Rt.forEach(t),It=p(e),ue=n(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-5u6sqi"&&(ue.textContent=xs),xt=p(e),ye=n(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-u7dsj6"&&(ye.innerHTML=bs),bt=p(e),d(Me.$$.fragment,e),Ct=p(e),ge=n(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-33pzk5"&&(ge.textContent=Cs),vt=p(e),d(je.$$.fragment,e),kt=p(e),fe=n(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-soh9qu"&&(fe.innerHTML=vs),Nt=p(e),d(we.$$.fragment,e),At=p(e),Ue=n(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-11jpq6m"&&(Ue.innerHTML=ks),_t=p(e),b=n(e,"H2",{class:!0});var Ht=c(b);Q=n(Ht,"A",{id:!0,class:!0,href:!0});var Ls=c(Q);Ve=n(Ls,"SPAN",{});var Fs=c(Ve);d(Te.$$.fragment,Fs),Fs.forEach(t),Ls.forEach(t),Dt=p(Ht),Qe=n(Ht,"SPAN",{"data-svelte-h":!0}),i(Qe)!=="svelte-1comx3g"&&(Qe.textContent=Ns),Ht.forEach(t),Qt=p(e),Je=n(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-x0uf0m"&&(Je.innerHTML=As),St=p(e),Ie=n(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1dmaop5"&&(Ie.innerHTML=_s),$t=p(e),xe=n(e,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-197jyne"&&(xe.textContent=Qs),Zt=p(e),Ee=n(e,"P",{}),c(Ee).forEach(t),this.h()},h(){r(f,"name","hf:doc:metadata"),r(f,"content",JSON.stringify(ta)),r(C,"id","templates-for-chat-models"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#templates-for-chat-models"),r(w,"class","relative group"),r(v,"id","introduction"),r(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(v,"href","#introduction"),r(U,"class","relative group"),r(k,"id","how-do-chat-templates-work"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#how-do-chat-templates-work"),r(T,"class","relative group"),r(N,"id","how-do-i-create-a-chat-template"),r(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(N,"href","#how-do-i-create-a-chat-template"),r(J,"class","relative group"),r(A,"id","what-are-default-templates"),r(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(A,"href","#what-are-default-templates"),r(I,"class","relative group"),r(_,"id","what-template-should-i-use"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#what-template-should-i-use"),r(x,"class","relative group"),r(Q,"id","i-want-to-use-chat-templates-how-should-i-get-started"),r(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Q,"href","#i-want-to-use-chat-templates-how-should-i-get-started"),r(b,"class","relative group")},m(e,s){h(document.head,f),a(e,Re,s),a(e,Se,s),a(e,He,s),a(e,w,s),h(w,C),h(C,$e),u(S,$e,null),h(w,qt),h(w,Ce),a(e,qe,s),a(e,U,s),h(U,v),h(v,Ze),u($,Ze,null),h(U,Lt),h(U,ve),a(e,Le,s),a(e,Z,s),a(e,Fe,s),a(e,G,s),a(e,Xe,s),a(e,z,s),a(e,Pe,s),a(e,B,s),a(e,Ye,s),a(e,W,s),a(e,De,s),a(e,V,s),a(e,Ke,s),u(E,e,s),a(e,Oe,s),a(e,R,s),a(e,et,s),u(H,e,s),a(e,tt,s),a(e,q,s),a(e,st,s),a(e,T,s),h(T,k),h(k,Ge),u(L,Ge,null),h(T,Ft),h(T,ke),a(e,at,s),a(e,F,s),a(e,lt,s),u(X,e,s),a(e,nt,s),a(e,P,s),a(e,ot,s),u(Y,e,s),a(e,pt,s),a(e,D,s),a(e,it,s),u(K,e,s),a(e,rt,s),a(e,O,s),a(e,ht,s),a(e,ee,s),a(e,ct,s),a(e,te,s),a(e,mt,s),u(se,e,s),a(e,dt,s),a(e,ae,s),a(e,ut,s),a(e,J,s),h(J,N),h(N,ze),u(le,ze,null),h(J,Xt),h(J,Ne),a(e,yt,s),a(e,ne,s),a(e,Mt,s),u(oe,e,s),a(e,gt,s),a(e,pe,s),a(e,jt,s),u(ie,e,s),a(e,ft,s),a(e,re,s),a(e,wt,s),a(e,I,s),h(I,A),h(A,Be),u(he,Be,null),h(I,Pt),h(I,Ae),a(e,Ut,s),a(e,ce,s),a(e,Tt,s),a(e,me,s),a(e,Jt,s),a(e,x,s),h(x,_),h(_,We),u(de,We,null),h(x,Yt),h(x,_e),a(e,It,s),a(e,ue,s),a(e,xt,s),a(e,ye,s),a(e,bt,s),u(Me,e,s),a(e,Ct,s),a(e,ge,s),a(e,vt,s),u(je,e,s),a(e,kt,s),a(e,fe,s),a(e,Nt,s),u(we,e,s),a(e,At,s),a(e,Ue,s),a(e,_t,s),a(e,b,s),h(b,Q),h(Q,Ve),u(Te,Ve,null),h(b,Dt),h(b,Qe),a(e,Qt,s),a(e,Je,s),a(e,St,s),a(e,Ie,s),a(e,$t,s),a(e,xe,s),a(e,Zt,s),a(e,Ee,s),Gt=!0},p:Ps,i(e){Gt||(y(S.$$.fragment,e),y($.$$.fragment,e),y(E.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(Me.$$.fragment,e),y(je.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),Gt=!0)},o(e){M(S.$$.fragment,e),M($.$$.fragment,e),M(E.$$.fragment,e),M(H.$$.fragment,e),M(L.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(K.$$.fragment,e),M(se.$$.fragment,e),M(le.$$.fragment,e),M(oe.$$.fragment,e),M(ie.$$.fragment,e),M(he.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(je.$$.fragment,e),M(we.$$.fragment,e),M(Te.$$.fragment,e),Gt=!1},d(e){e&&(t(Re),t(Se),t(He),t(w),t(qe),t(U),t(Le),t(Z),t(Fe),t(G),t(Xe),t(z),t(Pe),t(B),t(Ye),t(W),t(De),t(V),t(Ke),t(Oe),t(R),t(et),t(tt),t(q),t(st),t(T),t(at),t(F),t(lt),t(nt),t(P),t(ot),t(pt),t(D),t(it),t(rt),t(O),t(ht),t(ee),t(ct),t(te),t(mt),t(dt),t(ae),t(ut),t(J),t(yt),t(ne),t(Mt),t(gt),t(pe),t(jt),t(ft),t(re),t(wt),t(I),t(Ut),t(ce),t(Tt),t(me),t(Jt),t(x),t(It),t(ue),t(xt),t(ye),t(bt),t(Ct),t(ge),t(vt),t(kt),t(fe),t(Nt),t(At),t(Ue),t(_t),t(b),t(Qt),t(Je),t(St),t(Ie),t($t),t(xe),t(Zt),t(Ee)),t(f),g(S),g($),g(E,e),g(H,e),g(L),g(X,e),g(Y,e),g(K,e),g(se,e),g(le),g(oe,e),g(ie,e),g(he),g(de),g(Me,e),g(je,e),g(we,e),g(Te)}}}const ta={local:"templates-for-chat-models",sections:[{local:"introduction",title:"Introduction"},{local:"how-do-chat-templates-work",title:"How do chat templates work?"},{local:"how-do-i-create-a-chat-template",title:"How do I create a chat template?"},{local:"what-are-default-templates",title:'What are "default" templates?'},{local:"what-template-should-i-use",title:"What template should I use?"},{local:"i-want-to-use-chat-templates-how-should-i-get-started",title:"I want to use chat templates! How should I get started?"}],title:"Templates for Chat Models"};function sa(Kt){return Ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pa extends Ds{constructor(f){super(),Ks(this,f,sa,ea,Xs,{})}}export{pa as component};
