import{s as On,f as Dn,o as Kn,n as H}from"../chunks/scheduler.9bc65507.js";import{S as es,i as ts,g as n,s as d,u as _,A as os,h as s,f as t,c,j as f,v as b,y as u,k as m,o as r,a as l,w as y,d as v,t as T,x as w}from"../chunks/index.78c82d43.js";import{T as bo}from"../chunks/Tip.87d55b76.js";import{D as B}from"../chunks/Docstring.4e7352e2.js";import{C as Tt}from"../chunks/CodeBlock.73e038be.js";import{I as fe}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Zt}from"../chunks/ExampleCodeBlock.872b014d.js";function ns(L){let i,M="Examples:",p,h,g;return h=new Tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExpbHRDb25maWclMkMlMjBMaWx0TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGlMVCUyMFNDVVQtRExWQ0xhYiUyRmxpbHQtcm9iZXJ0YS1lbi1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExpbHRDb25maWcoKSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMFNDVVQtRExWQ0xhYiUyRmxpbHQtcm9iZXJ0YS1lbi1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMaWx0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LiltConfig, LiltModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a LiLT SCUT-DLVCLab/lilt-roberta-en-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LiltConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model from the SCUT-DLVCLab/lilt-roberta-en-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LiltModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){i=n("p"),i.textContent=M,p=d(),_(h.$$.fragment)},l(o){i=s(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=M),p=c(o),b(h.$$.fragment,o)},m(o,k){l(o,i,k),l(o,p,k),y(h,o,k),g=!0},p:H,i(o){g||(v(h.$$.fragment,o),g=!0)},o(o){T(h.$$.fragment,o),g=!1},d(o){o&&(t(i),t(p)),w(h,o)}}}function ss(L){let i,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=n("p"),i.innerHTML=M},l(p){i=s(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=M)},m(p,h){l(p,i,h)},p:H,d(p){p&&t(i)}}}function as(L){let i,M="Examples:",p,h,g;return h=new Tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJTQ1VULURMVkNMYWIlMkZsaWx0LXJvYmVydGEtZW4tYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyU0NVVC1ETFZDTGFiJTJGbGlsdC1yb2JlcnRhLWVuLWJhc2UlMjIpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJuaWVsc3IlMkZmdW5zZC1sYXlvdXRsbXYzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFleGFtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlMEF3b3JkcyUyMCUzRCUyMGV4YW1wbGUlNUIlMjJ0b2tlbnMlMjIlNUQlMEFib3hlcyUyMCUzRCUyMGV4YW1wbGUlNUIlMjJiYm94ZXMlMjIlNUQlMEElMEFlbmNvZGluZyUyMCUzRCUyMHRva2VuaXplcih3b3JkcyUyQyUyMGJveGVzJTNEYm94ZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;nielsr/funsd-layoutlmv3&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>words = example[<span class="hljs-string">&quot;tokens&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = example[<span class="hljs-string">&quot;bboxes&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(words, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){i=n("p"),i.textContent=M,p=d(),_(h.$$.fragment)},l(o){i=s(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=M),p=c(o),b(h.$$.fragment,o)},m(o,k){l(o,i,k),l(o,p,k),y(h,o,k),g=!0},p:H,i(o){g||(v(h.$$.fragment,o),g=!0)},o(o){T(h.$$.fragment,o),g=!1},d(o){o&&(t(i),t(p)),w(h,o)}}}function rs(L){let i,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=n("p"),i.innerHTML=M},l(p){i=s(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=M)},m(p,h){l(p,i,h)},p:H,d(p){p&&t(i)}}}function is(L){let i,M="Examples:",p,h,g;return h=new Tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU0NVVC1ETFZDTGFiJTJGbGlsdC1yb2JlcnRhLWVuLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTQ1VULURMVkNMYWIlMkZsaWx0LXJvYmVydGEtZW4tYmFzZSUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm5pZWxzciUyRmZ1bnNkLWxheW91dGxtdjMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCUwQXdvcmRzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMnRva2VucyUyMiU1RCUwQWJveGVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmJib3hlcyUyMiU1RCUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKHdvcmRzJTJDJTIwYm94ZXMlM0Rib3hlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMG91dHB1dHMubG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2NsYXNzJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;nielsr/funsd-layoutlmv3&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>words = example[<span class="hljs-string">&quot;tokens&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = example[<span class="hljs-string">&quot;bboxes&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(words, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = outputs.logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = model.config.id2label[predicted_class_idx]`,wrap:!1}}),{c(){i=n("p"),i.textContent=M,p=d(),_(h.$$.fragment)},l(o){i=s(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=M),p=c(o),b(h.$$.fragment,o)},m(o,k){l(o,i,k),l(o,p,k),y(h,o,k),g=!0},p:H,i(o){g||(v(h.$$.fragment,o),g=!0)},o(o){T(h.$$.fragment,o),g=!1},d(o){o&&(t(i),t(p)),w(h,o)}}}function ls(L){let i,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=n("p"),i.innerHTML=M},l(p){i=s(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=M)},m(p,h){l(p,i,h)},p:H,d(p){p&&t(i)}}}function ds(L){let i,M="Examples:",p,h,g;return h=new Tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyU0NVVC1ETFZDTGFiJTJGbGlsdC1yb2JlcnRhLWVuLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJTQ1VULURMVkNMYWIlMkZsaWx0LXJvYmVydGEtZW4tYmFzZSUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm5pZWxzciUyRmZ1bnNkLWxheW91dGxtdjMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGUlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCUwQXdvcmRzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMnRva2VucyUyMiU1RCUwQWJveGVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmJib3hlcyUyMiU1RCUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKHdvcmRzJTJDJTIwYm94ZXMlM0Rib3hlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqZW5jb2RpbmcpJTBBcHJlZGljdGVkX2NsYXNzX2luZGljZXMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cy5hcmdtYXgoLTEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;nielsr/funsd-layoutlmv3&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>words = example[<span class="hljs-string">&quot;tokens&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = example[<span class="hljs-string">&quot;bboxes&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(words, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_indices = outputs.logits.argmax(-<span class="hljs-number">1</span>)`,wrap:!1}}),{c(){i=n("p"),i.textContent=M,p=d(),_(h.$$.fragment)},l(o){i=s(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=M),p=c(o),b(h.$$.fragment,o)},m(o,k){l(o,i,k),l(o,p,k),y(h,o,k),g=!0},p:H,i(o){g||(v(h.$$.fragment,o),g=!0)},o(o){T(h.$$.fragment,o),g=!1},d(o){o&&(t(i),t(p)),w(h,o)}}}function cs(L){let i,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){i=n("p"),i.innerHTML=M},l(p){i=s(p,"P",{"data-svelte-h":!0}),u(i)!=="svelte-fincs2"&&(i.innerHTML=M)},m(p,h){l(p,i,h)},p:H,d(p){p&&t(i)}}}function ps(L){let i,M="Examples:",p,h,g;return h=new Tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlNDVVQtRExWQ0xhYiUyRmxpbHQtcm9iZXJ0YS1lbi1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMlNDVVQtRExWQ0xhYiUyRmxpbHQtcm9iZXJ0YS1lbi1iYXNlJTIyKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybmllbHNyJTJGZnVuc2QtbGF5b3V0bG12MyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBd29yZHMlMjAlM0QlMjBleGFtcGxlJTVCJTIydG9rZW5zJTIyJTVEJTBBYm94ZXMlMjAlM0QlMjBleGFtcGxlJTVCJTIyYmJveGVzJTIyJTVEJTBBJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIod29yZHMlMkMlMjBib3hlcyUzRGJveGVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEElMEFhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0QlMjBvdXRwdXRzLnN0YXJ0X2xvZ2l0cy5hcmdtYXgoKSUwQWFuc3dlcl9lbmRfaW5kZXglMjAlM0QlMjBvdXRwdXRzLmVuZF9sb2dpdHMuYXJnbWF4KCklMEElMEFwcmVkaWN0X2Fuc3dlcl90b2tlbnMlMjAlM0QlMjBlbmNvZGluZy5pbnB1dF9pZHMlNUIwJTJDJTIwYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNBJTIwYW5zd2VyX2VuZF9pbmRleCUyMCUyQiUyMDElNUQlMEFwcmVkaWN0ZWRfYW5zd2VyJTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShwcmVkaWN0X2Fuc3dlcl90b2tlbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;SCUT-DLVCLab/lilt-roberta-en-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;nielsr/funsd-layoutlmv3&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>words = example[<span class="hljs-string">&quot;tokens&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = example[<span class="hljs-string">&quot;bboxes&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(words, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**encoding)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = encoding.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_answer = tokenizer.decode(predict_answer_tokens)`,wrap:!1}}),{c(){i=n("p"),i.textContent=M,p=d(),_(h.$$.fragment)},l(o){i=s(o,"P",{"data-svelte-h":!0}),u(i)!=="svelte-kvfsh7"&&(i.textContent=M),p=c(o),b(h.$$.fragment,o)},m(o,k){l(o,i,k),l(o,p,k),y(h,o,k),g=!0},p:H,i(o){g||(v(h.$$.fragment,o),g=!0)},o(o){T(h.$$.fragment,o),g=!1},d(o){o&&(t(i),t(p)),w(h,o)}}}function hs(L){let i,M,p,h,g,o,k,ge,yo,Ye,on="LiLT",It,N,A,wt,_e,vo,Oe,nn="Overview",Nt,be,sn=`The LiLT model was proposed in <a href="https://arxiv.org/abs/2202.13669" rel="nofollow">LiLT: A Simple yet Effective Language-Independent Layout Transformer for Structured Document Understanding</a> by Jiapeng Wang, Lianwen Jin, Kai Ding.
LiLT allows to combine any pre-trained RoBERTa text encoder with a lightweight Layout Transformer, to enable <a href="layoutlm">LayoutLM</a>-like document understanding for many
languages.`,Rt,ye,an="The abstract from the paper is the following:",Vt,ve,rn="<em>Structured document understanding has attracted considerable attention and made significant progress recently, owing to its crucial role in intelligent document processing. However, most existing related models can only deal with the document data of specific language(s) (typically English) included in the pre-training collection, which is extremely limited. To address this issue, we propose a simple yet effective Language-independent Layout Transformer (LiLT) for structured document understanding. LiLT can be pre-trained on the structured documents of a single language and then directly fine-tuned on other languages with the corresponding off-the-shelf monolingual/multilingual pre-trained textual models. Experimental results on eight languages have shown that LiLT can achieve competitive or even superior performance on diverse widely-used downstream benchmarks, which enables language-independent benefit from the pre-training of document layout structure.</em>",St,Te,ln="Tips:",Xt,we,dn=`<li>To combine the Language-Independent Layout Transformer with a new RoBERTa checkpoint from the <a href="https://huggingface.co/models?search=roberta" rel="nofollow">hub</a>, refer to <a href="https://github.com/jpWang/LiLT#or-generate-your-own-checkpoint-optional" rel="nofollow">this guide</a>.
The script will result in <code>config.json</code> and <code>pytorch_model.bin</code> files being stored locally. After doing this, one can do the following (assuming you’re logged in with your HuggingFace account):</li>`,Et,Me,Gt,ke,cn=`<li>When preparing data for the model, make sure to use the token vocabulary that corresponds to the RoBERTa checkpoint you combined with the Layout Transformer.</li> <li>As <a href="https://huggingface.co/SCUT-DLVCLab/lilt-roberta-en-base" rel="nofollow">lilt-roberta-en-base</a> uses the same vocabulary as <a href="layoutlmv3">LayoutLMv3</a>, one can use <a href="/docs/transformers/v4.34.0/en/model_doc/layoutlmv3#transformers.LayoutLMv3TokenizerFast">LayoutLMv3TokenizerFast</a> to prepare data for the model.
The same is true for <a href="https://huggingface.co/SCUT-DLVCLab/lilt-infoxlm-base" rel="nofollow">lilt-roberta-en-base</a>: one can use <a href="/docs/transformers/v4.34.0/en/model_doc/layoutxlm#transformers.LayoutXLMTokenizerFast">LayoutXLMTokenizerFast</a> for that model.</li>`,Bt,Q,pn,Ht,Le,hn='LiLT architecture. Taken from the <a href="https://arxiv.org/abs/2202.13669">original paper</a>.',At,xe,mn=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/jpwang/lilt" rel="nofollow">here</a>.`,Qt,R,P,Mt,Ce,To,De,un="Resources",Pt,$e,fn="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with LiLT.",Yt,Fe,gn='<li>Demo notebooks for LiLT can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/LiLT" rel="nofollow">here</a>.</li>',Ot,Je,_n="<strong>Documentation resources</strong>",Dt,je,bn='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li>',Kt,ze,yn="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",eo,V,Y,kt,Ue,wo,Ke,vn="LiltConfig",to,q,qe,Mo,et,Tn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltModel">LiltModel</a>. It is used to instantiate a LiLT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the LiLT
<a href="https://huggingface.co/SCUT-DLVCLab/lilt-roberta-en-base" rel="nofollow">SCUT-DLVCLab/lilt-roberta-en-base</a> architecture.
Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ko,O,oo,S,D,Lt,We,Lo,tt,wn="LiltModel",no,F,Ze,xo,ot,Mn=`The bare LiLT Model transformer outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Co,nt,kn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,$o,J,Ie,Fo,st,Ln='The <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltModel">LiltModel</a> forward method, overrides the <code>__call__</code> special method.',Jo,K,jo,ee,so,X,te,xt,Ne,zo,at,xn="LiltForSequenceClassification",ao,x,Re,Uo,rt,Cn=`LiLT Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,qo,it,$n=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wo,lt,Fn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zo,j,Ve,Io,dt,Jn='The <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltForSequenceClassification">LiltForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',No,oe,Ro,ne,ro,E,se,Ct,Se,Vo,ct,jn="LiltForTokenClassification",io,C,Xe,So,pt,zn=`Lilt Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,Xo,ht,Un=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Eo,mt,qn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Go,z,Ee,Bo,ut,Wn='The <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltForTokenClassification">LiltForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',Ho,ae,Ao,re,lo,G,ie,$t,Ge,Qo,ft,Zn="LiltForQuestionAnswering",co,$,Be,Po,gt,In=`Lilt Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Yo,_t,Nn=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Oo,bt,Rn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Do,U,He,Ko,yt,Vn='The <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltForQuestionAnswering">LiltForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',en,le,tn,de,po,Ft,ho;return ge=new fe({}),_e=new fe({}),Me=new Tt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExpbHRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTGlsdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoX3RvX3lvdXJfZmlsZXMlMjIpJTBBbW9kZWwucHVzaF90b19odWIoJTIybmFtZV9vZl9yZXBvX29uX3RoZV9odWIlMjIp",highlighted:`from transformers import LiltModel

model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">LiltModel</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;path_to_your_files&quot;</span>)</span>
model.push<span class="hljs-constructor">_to_hub(<span class="hljs-string">&quot;name_of_repo_on_the_hub&quot;</span>)</span>`,wrap:!1}}),Ce=new fe({}),Ue=new fe({}),qe=new B({props:{name:"class transformers.LiltConfig",anchor:"transformers.LiltConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"pad_token_id",val:" = 0"},{name:"position_embedding_type",val:" = 'absolute'"},{name:"classifier_dropout",val:" = None"},{name:"channel_shrink_ratio",val:" = 4"},{name:"max_2d_position_embeddings",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LiltConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the LiLT model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltModel">LiltModel</a>.`,name:"vocab_size"},{anchor:"transformers.LiltConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer. Should be a multiple of 24.`,name:"hidden_size"},{anchor:"transformers.LiltConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.LiltConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.LiltConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.LiltConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.LiltConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.LiltConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.LiltConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.LiltConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltModel">LiltModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.LiltConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.LiltConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.LiltConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;absolute&quot;</code>) &#x2014;
Type of position embedding. Choose one of <code>&quot;absolute&quot;</code>, <code>&quot;relative_key&quot;</code>, <code>&quot;relative_key_query&quot;</code>. For
positional embeddings use <code>&quot;absolute&quot;</code>. For more information on <code>&quot;relative_key&quot;</code>, please refer to
<a href="https://arxiv.org/abs/1803.02155" rel="nofollow">Self-Attention with Relative Position Representations (Shaw et al.)</a>.
For more information on <code>&quot;relative_key_query&quot;</code>, please refer to <em>Method 4</em> in <a href="https://arxiv.org/abs/2009.13658" rel="nofollow">Improve Transformer Models
with Better Relative Position Embeddings (Huang et al.)</a>.`,name:"position_embedding_type"},{anchor:"transformers.LiltConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"},{anchor:"transformers.LiltConfig.channel_shrink_ratio",description:`<strong>channel_shrink_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The shrink ratio compared to the <code>hidden_size</code> for the channel dimension of the layout embeddings.`,name:"channel_shrink_ratio"},{anchor:"transformers.LiltConfig.max_2d_position_embeddings",description:`<strong>max_2d_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The maximum value that the 2D position embedding might ever be used with. Typically set this to something
large just in case (e.g., 1024).`,name:"max_2d_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/configuration_lilt.py#L30"}}),O=new Zt({props:{anchor:"transformers.LiltConfig.example",$$slots:{default:[ns]},$$scope:{ctx:L}}}),We=new fe({}),Ze=new B({props:{name:"class transformers.LiltModel",anchor:"transformers.LiltModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.LiltModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L691"}}),Ie=new B({props:{name:"forward",anchor:"transformers.LiltModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"bbox",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LiltModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LiltModel.forward.bbox",description:`<strong>bbox</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>) &#x2014;
Bounding boxes of each input sequence tokens. Selected in the range <code>[0, config.max_2d_position_embeddings-1]</code>. Each bounding box should be a normalized version in (x0, y0, x1, y1)
format, where (x0, y0) corresponds to the position of the upper left corner in the bounding box, and (x1,
y1) represents the position of the lower right corner. See <a href="#Overview">Overview</a> for normalization.`,name:"bbox"},{anchor:"transformers.LiltModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LiltModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.LiltModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LiltModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.LiltModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LiltModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LiltModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LiltModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L719",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig"
>LiltConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new bo({props:{$$slots:{default:[ss]},$$scope:{ctx:L}}}),ee=new Zt({props:{anchor:"transformers.LiltModel.forward.example",$$slots:{default:[as]},$$scope:{ctx:L}}}),Ne=new fe({}),Re=new B({props:{name:"class transformers.LiltForSequenceClassification",anchor:"transformers.LiltForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LiltForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L840"}}),Ve=new B({props:{name:"forward",anchor:"transformers.LiltForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"bbox",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LiltForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LiltForSequenceClassification.forward.bbox",description:`<strong>bbox</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>) &#x2014;
Bounding boxes of each input sequence tokens. Selected in the range <code>[0, config.max_2d_position_embeddings-1]</code>. Each bounding box should be a normalized version in (x0, y0, x1, y1)
format, where (x0, y0) corresponds to the position of the upper left corner in the bounding box, and (x1,
y1) represents the position of the lower right corner. See <a href="#Overview">Overview</a> for normalization.`,name:"bbox"},{anchor:"transformers.LiltForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LiltForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.LiltForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LiltForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.LiltForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LiltForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LiltForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LiltForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LiltForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L853",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig"
>LiltConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),oe=new bo({props:{$$slots:{default:[rs]},$$scope:{ctx:L}}}),ne=new Zt({props:{anchor:"transformers.LiltForSequenceClassification.forward.example",$$slots:{default:[is]},$$scope:{ctx:L}}}),Se=new fe({}),Xe=new B({props:{name:"class transformers.LiltForTokenClassification",anchor:"transformers.LiltForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LiltForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L958"}}),Ee=new B({props:{name:"forward",anchor:"transformers.LiltForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"bbox",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LiltForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LiltForTokenClassification.forward.bbox",description:`<strong>bbox</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>) &#x2014;
Bounding boxes of each input sequence tokens. Selected in the range <code>[0, config.max_2d_position_embeddings-1]</code>. Each bounding box should be a normalized version in (x0, y0, x1, y1)
format, where (x0, y0) corresponds to the position of the upper left corner in the bounding box, and (x1,
y1) represents the position of the lower right corner. See <a href="#Overview">Overview</a> for normalization.`,name:"bbox"},{anchor:"transformers.LiltForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LiltForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.LiltForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LiltForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.LiltForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LiltForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LiltForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LiltForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LiltForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L974",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig"
>LiltConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new bo({props:{$$slots:{default:[ls]},$$scope:{ctx:L}}}),re=new Zt({props:{anchor:"transformers.LiltForTokenClassification.forward.example",$$slots:{default:[ds]},$$scope:{ctx:L}}}),Ge=new fe({}),Be=new B({props:{name:"class transformers.LiltForQuestionAnswering",anchor:"transformers.LiltForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LiltForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig">LiltConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L1084"}}),He=new B({props:{name:"forward",anchor:"transformers.LiltForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"bbox",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LiltForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LiltForQuestionAnswering.forward.bbox",description:`<strong>bbox</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>) &#x2014;
Bounding boxes of each input sequence tokens. Selected in the range <code>[0, config.max_2d_position_embeddings-1]</code>. Each bounding box should be a normalized version in (x0, y0, x1, y1)
format, where (x0, y0) corresponds to the position of the upper left corner in the bounding box, and (x1,
y1) represents the position of the lower right corner. See <a href="#Overview">Overview</a> for normalization.`,name:"bbox"},{anchor:"transformers.LiltForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.LiltForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.LiltForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LiltForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.LiltForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LiltForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LiltForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LiltForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LiltForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.LiltForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/lilt/modeling_lilt.py#L1096",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/lilt#transformers.LiltConfig"
>LiltConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new bo({props:{$$slots:{default:[cs]},$$scope:{ctx:L}}}),de=new Zt({props:{anchor:"transformers.LiltForQuestionAnswering.forward.example",$$slots:{default:[ps]},$$scope:{ctx:L}}}),{c(){i=n("meta"),M=d(),p=n("p"),h=d(),g=n("h1"),o=n("a"),k=n("span"),_(ge.$$.fragment),yo=d(),Ye=n("span"),Ye.textContent=on,It=d(),N=n("h2"),A=n("a"),wt=n("span"),_(_e.$$.fragment),vo=d(),Oe=n("span"),Oe.textContent=nn,Nt=d(),be=n("p"),be.innerHTML=sn,Rt=d(),ye=n("p"),ye.textContent=an,Vt=d(),ve=n("p"),ve.innerHTML=rn,St=d(),Te=n("p"),Te.textContent=ln,Xt=d(),we=n("ul"),we.innerHTML=dn,Et=d(),_(Me.$$.fragment),Gt=d(),ke=n("ul"),ke.innerHTML=cn,Bt=d(),Q=n("img"),Ht=d(),Le=n("small"),Le.innerHTML=hn,At=d(),xe=n("p"),xe.innerHTML=mn,Qt=d(),R=n("h2"),P=n("a"),Mt=n("span"),_(Ce.$$.fragment),To=d(),De=n("span"),De.textContent=un,Pt=d(),$e=n("p"),$e.textContent=fn,Yt=d(),Fe=n("ul"),Fe.innerHTML=gn,Ot=d(),Je=n("p"),Je.innerHTML=_n,Dt=d(),je=n("ul"),je.innerHTML=bn,Kt=d(),ze=n("p"),ze.textContent=yn,eo=d(),V=n("h2"),Y=n("a"),kt=n("span"),_(Ue.$$.fragment),wo=d(),Ke=n("span"),Ke.textContent=vn,to=d(),q=n("div"),_(qe.$$.fragment),Mo=d(),et=n("p"),et.innerHTML=Tn,ko=d(),_(O.$$.fragment),oo=d(),S=n("h2"),D=n("a"),Lt=n("span"),_(We.$$.fragment),Lo=d(),tt=n("span"),tt.textContent=wn,no=d(),F=n("div"),_(Ze.$$.fragment),xo=d(),ot=n("p"),ot.innerHTML=Mn,Co=d(),nt=n("p"),nt.innerHTML=kn,$o=d(),J=n("div"),_(Ie.$$.fragment),Fo=d(),st=n("p"),st.innerHTML=Ln,Jo=d(),_(K.$$.fragment),jo=d(),_(ee.$$.fragment),so=d(),X=n("h2"),te=n("a"),xt=n("span"),_(Ne.$$.fragment),zo=d(),at=n("span"),at.textContent=xn,ao=d(),x=n("div"),_(Re.$$.fragment),Uo=d(),rt=n("p"),rt.textContent=Cn,qo=d(),it=n("p"),it.innerHTML=$n,Wo=d(),lt=n("p"),lt.innerHTML=Fn,Zo=d(),j=n("div"),_(Ve.$$.fragment),Io=d(),dt=n("p"),dt.innerHTML=Jn,No=d(),_(oe.$$.fragment),Ro=d(),_(ne.$$.fragment),ro=d(),E=n("h2"),se=n("a"),Ct=n("span"),_(Se.$$.fragment),Vo=d(),ct=n("span"),ct.textContent=jn,io=d(),C=n("div"),_(Xe.$$.fragment),So=d(),pt=n("p"),pt.textContent=zn,Xo=d(),ht=n("p"),ht.innerHTML=Un,Eo=d(),mt=n("p"),mt.innerHTML=qn,Go=d(),z=n("div"),_(Ee.$$.fragment),Bo=d(),ut=n("p"),ut.innerHTML=Wn,Ho=d(),_(ae.$$.fragment),Ao=d(),_(re.$$.fragment),lo=d(),G=n("h2"),ie=n("a"),$t=n("span"),_(Ge.$$.fragment),Qo=d(),ft=n("span"),ft.textContent=Zn,co=d(),$=n("div"),_(Be.$$.fragment),Po=d(),gt=n("p"),gt.innerHTML=In,Yo=d(),_t=n("p"),_t.innerHTML=Nn,Oo=d(),bt=n("p"),bt.innerHTML=Rn,Do=d(),U=n("div"),_(He.$$.fragment),Ko=d(),yt=n("p"),yt.innerHTML=Vn,en=d(),_(le.$$.fragment),tn=d(),_(de.$$.fragment),po=d(),Ft=n("p"),this.h()},l(e){const a=os("svelte-1phssyn",document.head);i=s(a,"META",{name:!0,content:!0}),a.forEach(t),M=c(e),p=s(e,"P",{}),f(p).forEach(t),h=c(e),g=s(e,"H1",{class:!0});var Ae=f(g);o=s(Ae,"A",{id:!0,class:!0,href:!0});var Jt=f(o);k=s(Jt,"SPAN",{});var jt=f(k);b(ge.$$.fragment,jt),jt.forEach(t),Jt.forEach(t),yo=c(Ae),Ye=s(Ae,"SPAN",{"data-svelte-h":!0}),u(Ye)!=="svelte-uifyls"&&(Ye.textContent=on),Ae.forEach(t),It=c(e),N=s(e,"H2",{class:!0});var Qe=f(N);A=s(Qe,"A",{id:!0,class:!0,href:!0});var zt=f(A);wt=s(zt,"SPAN",{});var Ut=f(wt);b(_e.$$.fragment,Ut),Ut.forEach(t),zt.forEach(t),vo=c(Qe),Oe=s(Qe,"SPAN",{"data-svelte-h":!0}),u(Oe)!=="svelte-1jsw1pg"&&(Oe.textContent=nn),Qe.forEach(t),Nt=c(e),be=s(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-151wcjb"&&(be.innerHTML=sn),Rt=c(e),ye=s(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-vfdo9a"&&(ye.textContent=an),Vt=c(e),ve=s(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1949dob"&&(ve.innerHTML=rn),St=c(e),Te=s(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-axv494"&&(Te.textContent=ln),Xt=c(e),we=s(e,"UL",{"data-svelte-h":!0}),u(we)!=="svelte-1yaggt4"&&(we.innerHTML=dn),Et=c(e),b(Me.$$.fragment,e),Gt=c(e),ke=s(e,"UL",{"data-svelte-h":!0}),u(ke)!=="svelte-crxcct"&&(ke.innerHTML=cn),Bt=c(e),Q=s(e,"IMG",{src:!0,alt:!0,width:!0}),Ht=c(e),Le=s(e,"SMALL",{"data-svelte-h":!0}),u(Le)!=="svelte-1gq47mu"&&(Le.innerHTML=hn),At=c(e),xe=s(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-42ikqz"&&(xe.innerHTML=mn),Qt=c(e),R=s(e,"H2",{class:!0});var Pe=f(R);P=s(Pe,"A",{id:!0,class:!0,href:!0});var qt=f(P);Mt=s(qt,"SPAN",{});var Wt=f(Mt);b(Ce.$$.fragment,Wt),Wt.forEach(t),qt.forEach(t),To=c(Pe),De=s(Pe,"SPAN",{"data-svelte-h":!0}),u(De)!=="svelte-w4zzv6"&&(De.textContent=un),Pe.forEach(t),Pt=c(e),$e=s(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-tf03pc"&&($e.textContent=fn),Yt=c(e),Fe=s(e,"UL",{"data-svelte-h":!0}),u(Fe)!=="svelte-11y7yle"&&(Fe.innerHTML=gn),Ot=c(e),Je=s(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-27ts0a"&&(Je.innerHTML=_n),Dt=c(e),je=s(e,"UL",{"data-svelte-h":!0}),u(je)!=="svelte-fiyac8"&&(je.innerHTML=bn),Kt=c(e),ze=s(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-1xesile"&&(ze.textContent=yn),eo=c(e),V=s(e,"H2",{class:!0});var mo=f(V);Y=s(mo,"A",{id:!0,class:!0,href:!0});var Sn=f(Y);kt=s(Sn,"SPAN",{});var Xn=f(kt);b(Ue.$$.fragment,Xn),Xn.forEach(t),Sn.forEach(t),wo=c(mo),Ke=s(mo,"SPAN",{"data-svelte-h":!0}),u(Ke)!=="svelte-eiwo6m"&&(Ke.textContent=vn),mo.forEach(t),to=c(e),q=s(e,"DIV",{class:!0});var vt=f(q);b(qe.$$.fragment,vt),Mo=c(vt),et=s(vt,"P",{"data-svelte-h":!0}),u(et)!=="svelte-pefjw9"&&(et.innerHTML=Tn),ko=c(vt),b(O.$$.fragment,vt),vt.forEach(t),oo=c(e),S=s(e,"H2",{class:!0});var uo=f(S);D=s(uo,"A",{id:!0,class:!0,href:!0});var En=f(D);Lt=s(En,"SPAN",{});var Gn=f(Lt);b(We.$$.fragment,Gn),Gn.forEach(t),En.forEach(t),Lo=c(uo),tt=s(uo,"SPAN",{"data-svelte-h":!0}),u(tt)!=="svelte-1gtj07j"&&(tt.textContent=wn),uo.forEach(t),no=c(e),F=s(e,"DIV",{class:!0});var ce=f(F);b(Ze.$$.fragment,ce),xo=c(ce),ot=s(ce,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-bfa7l6"&&(ot.innerHTML=Mn),Co=c(ce),nt=s(ce,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-hswkmf"&&(nt.innerHTML=kn),$o=c(ce),J=s(ce,"DIV",{class:!0});var pe=f(J);b(Ie.$$.fragment,pe),Fo=c(pe),st=s(pe,"P",{"data-svelte-h":!0}),u(st)!=="svelte-1yqa6vi"&&(st.innerHTML=Ln),Jo=c(pe),b(K.$$.fragment,pe),jo=c(pe),b(ee.$$.fragment,pe),pe.forEach(t),ce.forEach(t),so=c(e),X=s(e,"H2",{class:!0});var fo=f(X);te=s(fo,"A",{id:!0,class:!0,href:!0});var Bn=f(te);xt=s(Bn,"SPAN",{});var Hn=f(xt);b(Ne.$$.fragment,Hn),Hn.forEach(t),Bn.forEach(t),zo=c(fo),at=s(fo,"SPAN",{"data-svelte-h":!0}),u(at)!=="svelte-d427ns"&&(at.textContent=xn),fo.forEach(t),ao=c(e),x=s(e,"DIV",{class:!0});var W=f(x);b(Re.$$.fragment,W),Uo=c(W),rt=s(W,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-m04gc7"&&(rt.textContent=Cn),qo=c(W),it=s(W,"P",{"data-svelte-h":!0}),u(it)!=="svelte-hmtw9k"&&(it.innerHTML=$n),Wo=c(W),lt=s(W,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-hswkmf"&&(lt.innerHTML=Fn),Zo=c(W),j=s(W,"DIV",{class:!0});var he=f(j);b(Ve.$$.fragment,he),Io=c(he),dt=s(he,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-g96ibu"&&(dt.innerHTML=Jn),No=c(he),b(oe.$$.fragment,he),Ro=c(he),b(ne.$$.fragment,he),he.forEach(t),W.forEach(t),ro=c(e),E=s(e,"H2",{class:!0});var go=f(E);se=s(go,"A",{id:!0,class:!0,href:!0});var An=f(se);Ct=s(An,"SPAN",{});var Qn=f(Ct);b(Se.$$.fragment,Qn),Qn.forEach(t),An.forEach(t),Vo=c(go),ct=s(go,"SPAN",{"data-svelte-h":!0}),u(ct)!=="svelte-i34mk8"&&(ct.textContent=jn),go.forEach(t),io=c(e),C=s(e,"DIV",{class:!0});var Z=f(C);b(Xe.$$.fragment,Z),So=c(Z),pt=s(Z,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-if1u0k"&&(pt.textContent=zn),Xo=c(Z),ht=s(Z,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-hmtw9k"&&(ht.innerHTML=Un),Eo=c(Z),mt=s(Z,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-hswkmf"&&(mt.innerHTML=qn),Go=c(Z),z=s(Z,"DIV",{class:!0});var me=f(z);b(Ee.$$.fragment,me),Bo=c(me),ut=s(me,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-r6x6iw"&&(ut.innerHTML=Wn),Ho=c(me),b(ae.$$.fragment,me),Ao=c(me),b(re.$$.fragment,me),me.forEach(t),Z.forEach(t),lo=c(e),G=s(e,"H2",{class:!0});var _o=f(G);ie=s(_o,"A",{id:!0,class:!0,href:!0});var Pn=f(ie);$t=s(Pn,"SPAN",{});var Yn=f($t);b(Ge.$$.fragment,Yn),Yn.forEach(t),Pn.forEach(t),Qo=c(_o),ft=s(_o,"SPAN",{"data-svelte-h":!0}),u(ft)!=="svelte-124h97h"&&(ft.textContent=Zn),_o.forEach(t),co=c(e),$=s(e,"DIV",{class:!0});var I=f($);b(Be.$$.fragment,I),Po=c(I),gt=s(I,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-18mhxtq"&&(gt.innerHTML=In),Yo=c(I),_t=s(I,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-hmtw9k"&&(_t.innerHTML=Nn),Oo=c(I),bt=s(I,"P",{"data-svelte-h":!0}),u(bt)!=="svelte-hswkmf"&&(bt.innerHTML=Rn),Do=c(I),U=s(I,"DIV",{class:!0});var ue=f(U);b(He.$$.fragment,ue),Ko=c(ue),yt=s(ue,"P",{"data-svelte-h":!0}),u(yt)!=="svelte-puxy2a"&&(yt.innerHTML=Vn),en=c(ue),b(le.$$.fragment,ue),tn=c(ue),b(de.$$.fragment,ue),ue.forEach(t),I.forEach(t),po=c(e),Ft=s(e,"P",{}),f(Ft).forEach(t),this.h()},h(){m(i,"name","hf:doc:metadata"),m(i,"content",JSON.stringify(ms)),m(o,"id","lilt"),m(o,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(o,"href","#lilt"),m(g,"class","relative group"),m(A,"id","overview"),m(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(A,"href","#overview"),m(N,"class","relative group"),Dn(Q.src,pn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/lilt_architecture.jpg")||m(Q,"src",pn),m(Q,"alt","drawing"),m(Q,"width","600"),m(P,"id","resources"),m(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(P,"href","#resources"),m(R,"class","relative group"),m(Y,"id","transformers.LiltConfig"),m(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Y,"href","#transformers.LiltConfig"),m(V,"class","relative group"),m(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(D,"id","transformers.LiltModel"),m(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(D,"href","#transformers.LiltModel"),m(S,"class","relative group"),m(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(te,"id","transformers.LiltForSequenceClassification"),m(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(te,"href","#transformers.LiltForSequenceClassification"),m(X,"class","relative group"),m(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(se,"id","transformers.LiltForTokenClassification"),m(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(se,"href","#transformers.LiltForTokenClassification"),m(E,"class","relative group"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ie,"id","transformers.LiltForQuestionAnswering"),m(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ie,"href","#transformers.LiltForQuestionAnswering"),m(G,"class","relative group"),m(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){r(document.head,i),l(e,M,a),l(e,p,a),l(e,h,a),l(e,g,a),r(g,o),r(o,k),y(ge,k,null),r(g,yo),r(g,Ye),l(e,It,a),l(e,N,a),r(N,A),r(A,wt),y(_e,wt,null),r(N,vo),r(N,Oe),l(e,Nt,a),l(e,be,a),l(e,Rt,a),l(e,ye,a),l(e,Vt,a),l(e,ve,a),l(e,St,a),l(e,Te,a),l(e,Xt,a),l(e,we,a),l(e,Et,a),y(Me,e,a),l(e,Gt,a),l(e,ke,a),l(e,Bt,a),l(e,Q,a),l(e,Ht,a),l(e,Le,a),l(e,At,a),l(e,xe,a),l(e,Qt,a),l(e,R,a),r(R,P),r(P,Mt),y(Ce,Mt,null),r(R,To),r(R,De),l(e,Pt,a),l(e,$e,a),l(e,Yt,a),l(e,Fe,a),l(e,Ot,a),l(e,Je,a),l(e,Dt,a),l(e,je,a),l(e,Kt,a),l(e,ze,a),l(e,eo,a),l(e,V,a),r(V,Y),r(Y,kt),y(Ue,kt,null),r(V,wo),r(V,Ke),l(e,to,a),l(e,q,a),y(qe,q,null),r(q,Mo),r(q,et),r(q,ko),y(O,q,null),l(e,oo,a),l(e,S,a),r(S,D),r(D,Lt),y(We,Lt,null),r(S,Lo),r(S,tt),l(e,no,a),l(e,F,a),y(Ze,F,null),r(F,xo),r(F,ot),r(F,Co),r(F,nt),r(F,$o),r(F,J),y(Ie,J,null),r(J,Fo),r(J,st),r(J,Jo),y(K,J,null),r(J,jo),y(ee,J,null),l(e,so,a),l(e,X,a),r(X,te),r(te,xt),y(Ne,xt,null),r(X,zo),r(X,at),l(e,ao,a),l(e,x,a),y(Re,x,null),r(x,Uo),r(x,rt),r(x,qo),r(x,it),r(x,Wo),r(x,lt),r(x,Zo),r(x,j),y(Ve,j,null),r(j,Io),r(j,dt),r(j,No),y(oe,j,null),r(j,Ro),y(ne,j,null),l(e,ro,a),l(e,E,a),r(E,se),r(se,Ct),y(Se,Ct,null),r(E,Vo),r(E,ct),l(e,io,a),l(e,C,a),y(Xe,C,null),r(C,So),r(C,pt),r(C,Xo),r(C,ht),r(C,Eo),r(C,mt),r(C,Go),r(C,z),y(Ee,z,null),r(z,Bo),r(z,ut),r(z,Ho),y(ae,z,null),r(z,Ao),y(re,z,null),l(e,lo,a),l(e,G,a),r(G,ie),r(ie,$t),y(Ge,$t,null),r(G,Qo),r(G,ft),l(e,co,a),l(e,$,a),y(Be,$,null),r($,Po),r($,gt),r($,Yo),r($,_t),r($,Oo),r($,bt),r($,Do),r($,U),y(He,U,null),r(U,Ko),r(U,yt),r(U,en),y(le,U,null),r(U,tn),y(de,U,null),l(e,po,a),l(e,Ft,a),ho=!0},p(e,[a]){const Ae={};a&2&&(Ae.$$scope={dirty:a,ctx:e}),O.$set(Ae);const Jt={};a&2&&(Jt.$$scope={dirty:a,ctx:e}),K.$set(Jt);const jt={};a&2&&(jt.$$scope={dirty:a,ctx:e}),ee.$set(jt);const Qe={};a&2&&(Qe.$$scope={dirty:a,ctx:e}),oe.$set(Qe);const zt={};a&2&&(zt.$$scope={dirty:a,ctx:e}),ne.$set(zt);const Ut={};a&2&&(Ut.$$scope={dirty:a,ctx:e}),ae.$set(Ut);const Pe={};a&2&&(Pe.$$scope={dirty:a,ctx:e}),re.$set(Pe);const qt={};a&2&&(qt.$$scope={dirty:a,ctx:e}),le.$set(qt);const Wt={};a&2&&(Wt.$$scope={dirty:a,ctx:e}),de.$set(Wt)},i(e){ho||(v(ge.$$.fragment,e),v(_e.$$.fragment,e),v(Me.$$.fragment,e),v(Ce.$$.fragment,e),v(Ue.$$.fragment,e),v(qe.$$.fragment,e),v(O.$$.fragment,e),v(We.$$.fragment,e),v(Ze.$$.fragment,e),v(Ie.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(Ne.$$.fragment,e),v(Re.$$.fragment,e),v(Ve.$$.fragment,e),v(oe.$$.fragment,e),v(ne.$$.fragment,e),v(Se.$$.fragment,e),v(Xe.$$.fragment,e),v(Ee.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(Ge.$$.fragment,e),v(Be.$$.fragment,e),v(He.$$.fragment,e),v(le.$$.fragment,e),v(de.$$.fragment,e),ho=!0)},o(e){T(ge.$$.fragment,e),T(_e.$$.fragment,e),T(Me.$$.fragment,e),T(Ce.$$.fragment,e),T(Ue.$$.fragment,e),T(qe.$$.fragment,e),T(O.$$.fragment,e),T(We.$$.fragment,e),T(Ze.$$.fragment,e),T(Ie.$$.fragment,e),T(K.$$.fragment,e),T(ee.$$.fragment,e),T(Ne.$$.fragment,e),T(Re.$$.fragment,e),T(Ve.$$.fragment,e),T(oe.$$.fragment,e),T(ne.$$.fragment,e),T(Se.$$.fragment,e),T(Xe.$$.fragment,e),T(Ee.$$.fragment,e),T(ae.$$.fragment,e),T(re.$$.fragment,e),T(Ge.$$.fragment,e),T(Be.$$.fragment,e),T(He.$$.fragment,e),T(le.$$.fragment,e),T(de.$$.fragment,e),ho=!1},d(e){e&&(t(M),t(p),t(h),t(g),t(It),t(N),t(Nt),t(be),t(Rt),t(ye),t(Vt),t(ve),t(St),t(Te),t(Xt),t(we),t(Et),t(Gt),t(ke),t(Bt),t(Q),t(Ht),t(Le),t(At),t(xe),t(Qt),t(R),t(Pt),t($e),t(Yt),t(Fe),t(Ot),t(Je),t(Dt),t(je),t(Kt),t(ze),t(eo),t(V),t(to),t(q),t(oo),t(S),t(no),t(F),t(so),t(X),t(ao),t(x),t(ro),t(E),t(io),t(C),t(lo),t(G),t(co),t($),t(po),t(Ft)),t(i),w(ge),w(_e),w(Me,e),w(Ce),w(Ue),w(qe),w(O),w(We),w(Ze),w(Ie),w(K),w(ee),w(Ne),w(Re),w(Ve),w(oe),w(ne),w(Se),w(Xe),w(Ee),w(ae),w(re),w(Ge),w(Be),w(He),w(le),w(de)}}}const ms={local:"lilt",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.LiltConfig",title:"LiltConfig"},{local:"transformers.LiltModel",title:"LiltModel"},{local:"transformers.LiltForSequenceClassification",title:"LiltForSequenceClassification"},{local:"transformers.LiltForTokenClassification",title:"LiltForTokenClassification"},{local:"transformers.LiltForQuestionAnswering",title:"LiltForQuestionAnswering"}],title:"LiLT"};function us(L){return Kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends es{constructor(i){super(),ts(this,i,us,hs,On,{})}}export{ws as component};
