import{s as er,f as tr,o as or,n as lt}from"../chunks/scheduler.9bc65507.js";import{S as sr,i as nr,g as s,s as r,u,A as rr,h as n,f as t,c as a,j as p,v as _,y as h,k as m,o,a as c,w as b,d as k,t as y,x as M}from"../chunks/index.78c82d43.js";import{T as qs}from"../chunks/Tip.87d55b76.js";import{D as x}from"../chunks/Docstring.4e7352e2.js";import{C as Yo}from"../chunks/CodeBlock.73e038be.js";import{I as D}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Do}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as ar}from"../chunks/PipelineTag.75b0f707.js";function ir(j){let d,F=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){d=s("p"),d.innerHTML=F},l(g){d=n(g,"P",{"data-svelte-h":!0}),h(d)!=="svelte-j665pk"&&(d.innerHTML=F)},m(g,f){c(g,d,f)},p:lt,d(g){g&&t(d)}}}function lr(j){let d,F="Examples:",g,f,v;return f=new Yo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2tGb3JtZXJDb25maWclMkMlMjBNYXNrRm9ybWVyTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTWFza0Zvcm1lciUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrRm9ybWVyQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MaskFormerConfig, MaskFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MaskFormer facebook/maskformer-swin-base-ade configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MaskFormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/maskformer-swin-base-ade style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=s("p"),d.textContent=F,g=r(),u(f.$$.fragment)},l(l){d=n(l,"P",{"data-svelte-h":!0}),h(d)!=="svelte-kvfsh7"&&(d.textContent=F),g=a(l),_(f.$$.fragment,l)},m(l,w){c(l,d,w),c(l,g,w),b(f,l,w),v=!0},p:lt,i(l){v||(k(f.$$.fragment,l),v=!0)},o(l){y(f.$$.fragment,l),v=!1},d(l){l&&(t(d),t(g)),M(f,l)}}}function cr(j){let d,F=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=s("p"),d.innerHTML=F},l(g){d=n(g,"P",{"data-svelte-h":!0}),h(d)!=="svelte-fincs2"&&(d.innerHTML=F)},m(g,f){c(g,d,f)},p:lt,d(g){g&&t(d)}}}function dr(j){let d,F="Examples:",g,f,v;return f=new Yo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBBREUyMGslMjBzZW1hbnRpYyUyMHNlZ21lbnRhdGlvbiUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1hZGUlMjIpJTBBbW9kZWwlMjAlM0QlMjBNYXNrRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtYWRlJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMHRoZSUyMGRlY29kZXIlMjBvZiUyME1hc2tGb3JtZXIlMjBvdXRwdXRzJTIwaGlkZGVuJTIwc3RhdGVzJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEF0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy50cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdCh0cmFuc2Zvcm1lcl9kZWNvZGVyX2xhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the decoder of MaskFormer outputs hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transformer_decoder_last_hidden_state = outputs.transformer_decoder_last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(transformer_decoder_last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){d=s("p"),d.textContent=F,g=r(),u(f.$$.fragment)},l(l){d=n(l,"P",{"data-svelte-h":!0}),h(d)!=="svelte-kvfsh7"&&(d.textContent=F),g=a(l),_(f.$$.fragment,l)},m(l,w){c(l,d,w),c(l,g,w),b(f,l,w),v=!0},p:lt,i(l){v||(k(f.$$.fragment,l),v=!0)},o(l){y(f.$$.fragment,l),v=!1},d(l){l&&(t(d),t(g)),M(f,l)}}}function mr(j){let d,F=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=s("p"),d.innerHTML=F},l(g){d=n(g,"P",{"data-svelte-h":!0}),h(d)!=="svelte-fincs2"&&(d.innerHTML=F)},m(g,f){c(g,d,f)},p:lt,d(g){g&&t(d)}}}function pr(j){let d,F="Semantic segmentation example:",g,f,v;return f=new Yo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on ADE20k semantic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-ade&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_semantic_map.shape)
[<span class="hljs-number">512</span>, <span class="hljs-number">683</span>]`,wrap:!1}}),{c(){d=s("p"),d.textContent=F,g=r(),u(f.$$.fragment)},l(l){d=n(l,"P",{"data-svelte-h":!0}),h(d)!=="svelte-ec2k7m"&&(d.textContent=F),g=a(l),_(f.$$.fragment,l)},m(l,w){c(l,d,w),c(l,g,w),b(f,l,w),v=!0},p:lt,i(l){v||(k(f.$$.fragment,l),v=!0)},o(l){y(f.$$.fragment,l),v=!1},d(l){l&&(t(d),t(g)),M(f,l)}}}function hr(j){let d,F="Panoptic segmentation example:",g,f,v;return f=new Yo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTIzJTIwbG9hZCUyME1hc2tGb3JtZXIlMjBmaW5lLXR1bmVkJTIwb24lMjBDT0NPJTIwcGFub3B0aWMlMjBzZWdtZW50YXRpb24lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFza2Zvcm1lci1zd2luLWJhc2UtY29jbyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2tGb3JtZXJGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrZm9ybWVyLXN3aW4tYmFzZS1jb2NvJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwY2xhc3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyklNjAlMEElMjMlMjBhbmQlMjBtYXNrc19xdWVyaWVzX2xvZ2l0cyUyMG9mJTIwc2hhcGUlMjAlNjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9xdWVyaWVzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTYwJTBBY2xhc3NfcXVlcmllc19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmNsYXNzX3F1ZXJpZXNfbG9naXRzJTBBbWFza3NfcXVlcmllc19sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLm1hc2tzX3F1ZXJpZXNfbG9naXRzJTBBJTBBJTIzJTIweW91JTIwY2FuJTIwcGFzcyUyMHRoZW0lMjB0byUyMGltYWdlX3Byb2Nlc3NvciUyMGZvciUyMHBvc3Rwcm9jZXNzaW5nJTBBcmVzdWx0JTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19wYW5vcHRpY19zZWdtZW50YXRpb24ob3V0cHV0cyUyQyUyMHRhcmdldF9zaXplcyUzRCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklNUIwJTVEJTBBJTBBJTIzJTIwd2UlMjByZWZlciUyMHRvJTIwdGhlJTIwZGVtbyUyMG5vdGVib29rcyUyMGZvciUyMHZpc3VhbGl6YXRpb24lMjAoc2VlJTIwJTIyUmVzb3VyY2VzJTIyJTIwc2VjdGlvbiUyMGluJTIwdGhlJTIwTWFza0Zvcm1lciUyMGRvY3MpJTBBcHJlZGljdGVkX3Bhbm9wdGljX21hcCUyMCUzRCUyMHJlc3VsdCU1QiUyMnNlZ21lbnRhdGlvbiUyMiU1RCUwQWxpc3QocHJlZGljdGVkX3Bhbm9wdGljX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, MaskFormerForInstanceSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load MaskFormer fine-tuned on COCO panoptic segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MaskFormerForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/maskformer-swin-base-coco&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to image_processor for postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]])[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we refer to the demo notebooks for visualization (see &quot;Resources&quot; section in the MaskFormer docs)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = result[<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)
[<span class="hljs-number">480</span>, <span class="hljs-number">640</span>]`,wrap:!1}}),{c(){d=s("p"),d.textContent=F,g=r(),u(f.$$.fragment)},l(l){d=n(l,"P",{"data-svelte-h":!0}),h(d)!=="svelte-1hqqxa2"&&(d.textContent=F),g=a(l),_(f.$$.fragment,l)},m(l,w){c(l,d,w),c(l,g,w),b(f,l,w),v=!0},p:lt,i(l){v||(k(f.$$.fragment,l),v=!0)},o(l){y(f.$$.fragment,l),v=!1},d(l){l&&(t(d),t(g)),M(f,l)}}}function gr(j){let d,F,g,f,v,l,w,ye,Qo,ct,Ds="MaskFormer",ao,Y,io,E,Q,At,Me,Ko,dt,Ys="Overview",lo,ve,Qs='The MaskFormer model was proposed in <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">Per-Pixel Classification is Not All You Need for Semantic Segmentation</a> by Bowen Cheng, Alexander G. Schwing, Alexander Kirillov. MaskFormer addresses semantic segmentation with a mask classification paradigm instead of performing classic pixel-level classification.',co,Fe,Ks="The abstract from the paper is the following:",mo,we,en="<em>Modern approaches typically formulate semantic segmentation as a per-pixel classification task, while instance-level segmentation is handled with an alternative mask classification. Our key insight: mask classification is sufficiently general to solve both semantic- and instance-level segmentation tasks in a unified manner using the exact same model, loss, and training procedure. Following this observation, we propose MaskFormer, a simple mask classification model which predicts a set of binary masks, each associated with a single global class label prediction. Overall, the proposed mask classification-based method simplifies the landscape of effective approaches to semantic and panoptic segmentation tasks and shows excellent empirical results. In particular, we observe that MaskFormer outperforms per-pixel classification baselines when the number of classes is large. Our mask classification-based method outperforms both current state-of-the-art semantic (55.6 mIoU on ADE20K) and panoptic segmentation (52.7 PQ on COCO) models.</em>",po,Te,tn="Tips:",ho,xe,on=`<li>MaskFormer’s Transformer decoder is identical to the decoder of <a href="detr">DETR</a>. During training, the authors of DETR did find it helpful to use auxiliary losses in the decoder, especially to help the model output the correct number of objects of each class. If you set the parameter <code>use_auxilary_loss</code> of <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> to <code>True</code>, then prediction feedforward neural networks and Hungarian losses are added after each decoder layer (with the FFNs sharing parameters).</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>MaskFormerLoss</code> class of <code>modeling_maskformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/facebookresearch/MaskFormer/blob/da3e60d85fdeedcb31476b5edd7d328826ce56cc/mask_former/modeling/criterion.py#L169" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerImageProcessor">MaskFormerImageProcessor</a> to prepare images for the model and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. Both tasks can be solved using <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,go,$e,sn='The figure below illustrates the architecture of MaskFormer. Taken from the <a href="https://arxiv.org/abs/2107.06278" rel="nofollow">original paper</a>.',fo,Ie,nn,uo,je,rn='This model was contributed by <a href="https://huggingface.co/francesco" rel="nofollow">francesco</a>. The original code can be found <a href="https://github.com/facebookresearch/MaskFormer" rel="nofollow">here</a>.',_o,B,K,Ot,ze,es,mt,an="Resources",bo,Ne,ko,Ue,ln='<li>All notebooks that illustrate inference as well as fine-tuning on custom data with MaskFormer can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/MaskFormer" rel="nofollow">here</a>.</li>',yo,S,ee,qt,Ce,ts,pt,cn="MaskFormer specific outputs",Mo,V,Le,os,ht,dn='Class for outputs of <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. This class returns all the needed hidden states to compute the logits.',vo,J,Ze,ss,gt,mn='Class for outputs of <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.',ns,ft,pn=`This output can be directly passed to <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or or
<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~MaskFormerImageProcessor] for details regarding usage.`,Fo,H,te,Dt,Je,rs,ut,hn="MaskFormerConfig",wo,$,We,as,_t,gn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a>. It is used to instantiate a
MaskFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MaskFormer
<a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a> architecture trained
on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,is,bt,fn=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ls,kt,un='Currently, MaskFormer only supports the <a href="swin">Swin Transformer</a> as backbone.',cs,oe,ds,se,Re,ms,yt,_n=`Instantiate a <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a> (or a derived class) from a pre-trained backbone model configuration and DETR model
configuration.`,To,X,ne,Yt,Pe,ps,Mt,bn="MaskFormerImageProcessor",xo,T,Ee,hs,vt,kn=`Constructs a MaskFormer image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,gs,Ft,yn=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,fs,wt,Be,us,R,Se,_s,Tt,Mn="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",bs,xt,vn=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,ks,re,Ve,ys,$t,Fn=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,Ms,ae,He,vs,It,wn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch.`,Fs,ie,Xe,ws,jt,Tn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,$o,G,le,Qt,Ge,Ts,zt,xn="MaskFormerFeatureExtractor",Io,I,Ae,xs,Nt,Oe,$s,P,qe,Is,Ut,$n="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",js,Ct,In=`MaskFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,zs,ce,De,Ns,Lt,jn=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,Us,de,Ye,Cs,Zt,zn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into instance segmentation predictions. Only
supports PyTorch.`,Ls,me,Qe,Zs,Jt,Nn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,jo,A,pe,Kt,Ke,Js,Wt,Un="MaskFormerModel",zo,W,et,Ws,Rt,Cn=`The bare MaskFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Rs,U,tt,Ps,Pt,Ln='The <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerModel">MaskFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Es,he,Bs,ge,No,O,fe,eo,ot,Ss,Et,Zn="MaskFormerForInstanceSegmentation",Uo,q,st,Vs,z,nt,Hs,Bt,Jn='The <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Xs,ue,Gs,St,Wn="Examples:",As,_e,Os,be,Co,to,Lo;return ye=new D({}),Y=new qs({props:{$$slots:{default:[ir]},$$scope:{ctx:j}}}),Me=new D({}),ze=new D({}),Ne=new ar({props:{pipeline:"image-segmentation"}}),Ce=new D({}),Le=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/modeling_maskformer.py#L146"}}),Ze=new x({props:{name:"class transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_logits",val:": FloatTensor = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the transformer decoder model.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.hidden_states",description:`<strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.`,name:"hidden_states"},{anchor:"transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr&#x2019;s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/modeling_maskformer.py#L189"}}),Je=new D({}),We=new x({props:{name:"class transformers.MaskFormerConfig",anchor:"transformers.MaskFormerConfig",parameters:[{name:"fpn_feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"no_object_weight",val:": float = 0.1"},{name:"use_auxiliary_loss",val:": bool = False"},{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"decoder_config",val:": typing.Optional[typing.Dict] = None"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"dice_weight",val:": float = 1.0"},{name:"cross_entropy_weight",val:": float = 1.0"},{name:"mask_weight",val:": float = 20.0"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.MaskFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.MaskFormerConfig.use_auxiliary_loss(bool,",description:`<strong>use_auxiliary_loss(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code> <code>MaskFormerForInstanceSegmentationOutput</code> will contain the auxiliary losses computed using the
logits from each decoder&#x2019;s stage.`,name:"use_auxiliary_loss(bool,"},{anchor:"transformers.MaskFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the backbone, if unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.decoder_config",description:`<strong>decoder_config</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
The configuration passed to the transformer decoder model, if unset the base config for <code>detr-resnet-50</code>
will be used.`,name:"decoder_config"},{anchor:"transformers.MaskFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.MaskFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.MaskFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.MaskFormerConfig.cross_entropy_weight",description:`<strong>cross_entropy_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The weight for the cross entropy loss.`,name:"cross_entropy_weight"},{anchor:"transformers.MaskFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 20.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.MaskFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/configuration_maskformer.py#L35",raiseDescription:`
<ul>
<li><code>ValueError</code> —
Raised if the backbone model type selected is not in <code>["swin"]</code> or the decoder model type selected is not
in <code>["detr"]</code></li>
</ul>
`,raiseType:`
<p><code>ValueError</code></p>
`}}),oe=new Do({props:{anchor:"transformers.MaskFormerConfig.example",$$slots:{default:[lr]},$$scope:{ctx:j}}}),Re=new x({props:{name:"from_backbone_and_decoder_configs",anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"decoder_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"},{anchor:"transformers.MaskFormerConfig.from_backbone_and_decoder_configs.decoder_config",description:`<strong>decoder_config</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The transformer decoder configuration to use.`,name:"decoder_config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/configuration_maskformer.py#L181",returnDescription:`
<p>An instance of a configuration object</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a></p>
`}}),Pe=new D({}),Ee=new x({props:{name:"class transformers.MaskFormerImageProcessor",anchor:"transformers.MaskFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.MaskFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.MaskFormerImageProcessor.max_size",description:`<strong>max_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1333) &#x2014;
The largest size an image dimension can have (otherwise it&#x2019;s capped). Only has an effect if <code>do_resize</code> is
set to <code>True</code>.`,name:"max_size"},{anchor:"transformers.MaskFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>PIL.Image.Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.MaskFormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.MaskFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.MaskFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1/ 255) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.MaskFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.MaskFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.MaskFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.MaskFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.MaskFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L345"}}),Be=new x({props:{name:"preprocess",anchor:"transformers.MaskFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.Dict[int, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L678"}}),Se=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.34.0/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L876",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Ve=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L1030",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),He=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L1080",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Xe=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L1194",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Ge=new D({}),Ae=new x({props:{name:"class transformers.MaskFormerFeatureExtractor",anchor:"transformers.MaskFormerFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/feature_extraction_maskformer.py#L26"}}),Oe=new x({props:{name:"__call__",anchor:"transformers.MaskFormerFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L572"}}),qe=new x({props:{name:"encode_inputs",anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.MaskFormerFeatureExtractor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.34.0/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L876",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),De=new x({props:{name:"post_process_semantic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L1030",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),Ye=new x({props:{name:"post_process_instance_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L1080",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Qe=new x({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.MaskFormerFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/image_processing_maskformer.py#L1194",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Ke=new D({}),et=new x({props:{name:"class transformers.MaskFormerModel",anchor:"transformers.MaskFormerModel",parameters:[{name:"config",val:": MaskFormerConfig"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerConfig">MaskFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/modeling_maskformer.py#L1633"}}),tt=new x({props:{name:"forward",anchor:"transformers.MaskFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.__call__">MaskFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.MaskFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.MaskFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~MaskFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/modeling_maskformer.py#L1643",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code></li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new qs({props:{$$slots:{default:[cr]},$$scope:{ctx:j}}}),ge=new Do({props:{anchor:"transformers.MaskFormerModel.forward.example",$$slots:{default:[dr]},$$scope:{ctx:j}}}),ot=new D({}),st=new x({props:{name:"class transformers.MaskFormerForInstanceSegmentation",anchor:"transformers.MaskFormerForInstanceSegmentation",parameters:[{name:"config",val:": MaskFormerConfig"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/modeling_maskformer.py#L1732"}}),nt=new x({props:{name:"forward",anchor:"transformers.MaskFormerForInstanceSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerFeatureExtractor.__call__">MaskFormerImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~MaskFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/maskformer/modeling_maskformer.py#L1827",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.MaskFormerConfig"
>MaskFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model (FPN).</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Last hidden states (final feature map) of the last stage of the transformer decoder model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the transformer decoder at the output
of each stage.</li>
<li><strong>hidden_states</strong> <code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> containing <code>encoder_hidden_states</code>, <code>pixel_decoder_hidden_states</code> and
<code>decoder_hidden_states</code>.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights from Detr’s decoder after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/maskformer#transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput"
>transformers.models.maskformer.modeling_maskformer.MaskFormerForInstanceSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new qs({props:{$$slots:{default:[mr]},$$scope:{ctx:j}}}),_e=new Do({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example",$$slots:{default:[pr]},$$scope:{ctx:j}}}),be=new Do({props:{anchor:"transformers.MaskFormerForInstanceSegmentation.forward.example-2",$$slots:{default:[hr]},$$scope:{ctx:j}}}),{c(){d=s("meta"),F=r(),g=s("p"),f=r(),v=s("h1"),l=s("a"),w=s("span"),u(ye.$$.fragment),Qo=r(),ct=s("span"),ct.textContent=Ds,ao=r(),u(Y.$$.fragment),io=r(),E=s("h2"),Q=s("a"),At=s("span"),u(Me.$$.fragment),Ko=r(),dt=s("span"),dt.textContent=Ys,lo=r(),ve=s("p"),ve.innerHTML=Qs,co=r(),Fe=s("p"),Fe.textContent=Ks,mo=r(),we=s("p"),we.innerHTML=en,po=r(),Te=s("p"),Te.textContent=tn,ho=r(),xe=s("ul"),xe.innerHTML=on,go=r(),$e=s("p"),$e.innerHTML=sn,fo=r(),Ie=s("img"),uo=r(),je=s("p"),je.innerHTML=rn,_o=r(),B=s("h2"),K=s("a"),Ot=s("span"),u(ze.$$.fragment),es=r(),mt=s("span"),mt.textContent=an,bo=r(),u(Ne.$$.fragment),ko=r(),Ue=s("ul"),Ue.innerHTML=ln,yo=r(),S=s("h2"),ee=s("a"),qt=s("span"),u(Ce.$$.fragment),ts=r(),pt=s("span"),pt.textContent=cn,Mo=r(),V=s("div"),u(Le.$$.fragment),os=r(),ht=s("p"),ht.innerHTML=dn,vo=r(),J=s("div"),u(Ze.$$.fragment),ss=r(),gt=s("p"),gt.innerHTML=mn,ns=r(),ft=s("p"),ft.innerHTML=pn,Fo=r(),H=s("h2"),te=s("a"),Dt=s("span"),u(Je.$$.fragment),rs=r(),ut=s("span"),ut.textContent=hn,wo=r(),$=s("div"),u(We.$$.fragment),as=r(),_t=s("p"),_t.innerHTML=gn,is=r(),bt=s("p"),bt.innerHTML=fn,ls=r(),kt=s("p"),kt.innerHTML=un,cs=r(),u(oe.$$.fragment),ds=r(),se=s("div"),u(Re.$$.fragment),ms=r(),yt=s("p"),yt.innerHTML=_n,To=r(),X=s("h2"),ne=s("a"),Yt=s("span"),u(Pe.$$.fragment),ps=r(),Mt=s("span"),Mt.textContent=bn,xo=r(),T=s("div"),u(Ee.$$.fragment),hs=r(),vt=s("p"),vt.textContent=kn,gs=r(),Ft=s("p"),Ft.innerHTML=yn,fs=r(),wt=s("div"),u(Be.$$.fragment),us=r(),R=s("div"),u(Se.$$.fragment),_s=r(),Tt=s("p"),Tt.innerHTML=Mn,bs=r(),xt=s("p"),xt.innerHTML=vn,ks=r(),re=s("div"),u(Ve.$$.fragment),ys=r(),$t=s("p"),$t.innerHTML=Fn,Ms=r(),ae=s("div"),u(He.$$.fragment),vs=r(),It=s("p"),It.innerHTML=wn,Fs=r(),ie=s("div"),u(Xe.$$.fragment),ws=r(),jt=s("p"),jt.innerHTML=Tn,$o=r(),G=s("h2"),le=s("a"),Qt=s("span"),u(Ge.$$.fragment),Ts=r(),zt=s("span"),zt.textContent=xn,Io=r(),I=s("div"),u(Ae.$$.fragment),xs=r(),Nt=s("div"),u(Oe.$$.fragment),$s=r(),P=s("div"),u(qe.$$.fragment),Is=r(),Ut=s("p"),Ut.innerHTML=$n,js=r(),Ct=s("p"),Ct.innerHTML=In,zs=r(),ce=s("div"),u(De.$$.fragment),Ns=r(),Lt=s("p"),Lt.innerHTML=jn,Us=r(),de=s("div"),u(Ye.$$.fragment),Cs=r(),Zt=s("p"),Zt.innerHTML=zn,Ls=r(),me=s("div"),u(Qe.$$.fragment),Zs=r(),Jt=s("p"),Jt.innerHTML=Nn,jo=r(),A=s("h2"),pe=s("a"),Kt=s("span"),u(Ke.$$.fragment),Js=r(),Wt=s("span"),Wt.textContent=Un,zo=r(),W=s("div"),u(et.$$.fragment),Ws=r(),Rt=s("p"),Rt.innerHTML=Cn,Rs=r(),U=s("div"),u(tt.$$.fragment),Ps=r(),Pt=s("p"),Pt.innerHTML=Ln,Es=r(),u(he.$$.fragment),Bs=r(),u(ge.$$.fragment),No=r(),O=s("h2"),fe=s("a"),eo=s("span"),u(ot.$$.fragment),Ss=r(),Et=s("span"),Et.textContent=Zn,Uo=r(),q=s("div"),u(st.$$.fragment),Vs=r(),z=s("div"),u(nt.$$.fragment),Hs=r(),Bt=s("p"),Bt.innerHTML=Jn,Xs=r(),u(ue.$$.fragment),Gs=r(),St=s("p"),St.textContent=Wn,As=r(),u(_e.$$.fragment),Os=r(),u(be.$$.fragment),Co=r(),to=s("p"),this.h()},l(e){const i=rr("svelte-1phssyn",document.head);d=n(i,"META",{name:!0,content:!0}),i.forEach(t),F=a(e),g=n(e,"P",{}),p(g).forEach(t),f=a(e),v=n(e,"H1",{class:!0});var rt=p(v);l=n(rt,"A",{id:!0,class:!0,href:!0});var oo=p(l);w=n(oo,"SPAN",{});var so=p(w);_(ye.$$.fragment,so),so.forEach(t),oo.forEach(t),Qo=a(rt),ct=n(rt,"SPAN",{"data-svelte-h":!0}),h(ct)!=="svelte-g9eo46"&&(ct.textContent=Ds),rt.forEach(t),ao=a(e),_(Y.$$.fragment,e),io=a(e),E=n(e,"H2",{class:!0});var at=p(E);Q=n(at,"A",{id:!0,class:!0,href:!0});var no=p(Q);At=n(no,"SPAN",{});var ro=p(At);_(Me.$$.fragment,ro),ro.forEach(t),no.forEach(t),Ko=a(at),dt=n(at,"SPAN",{"data-svelte-h":!0}),h(dt)!=="svelte-1jsw1pg"&&(dt.textContent=Ys),at.forEach(t),lo=a(e),ve=n(e,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1nc0rjr"&&(ve.innerHTML=Qs),co=a(e),Fe=n(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-vfdo9a"&&(Fe.textContent=Ks),mo=a(e),we=n(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-lfolgg"&&(we.innerHTML=en),po=a(e),Te=n(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-axv494"&&(Te.textContent=tn),ho=a(e),xe=n(e,"UL",{"data-svelte-h":!0}),h(xe)!=="svelte-w55s4m"&&(xe.innerHTML=on),go=a(e),$e=n(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-58561s"&&($e.innerHTML=sn),fo=a(e),Ie=n(e,"IMG",{width:!0,src:!0}),uo=a(e),je=n(e,"P",{"data-svelte-h":!0}),h(je)!=="svelte-1j464j"&&(je.innerHTML=rn),_o=a(e),B=n(e,"H2",{class:!0});var it=p(B);K=n(it,"A",{id:!0,class:!0,href:!0});var Rn=p(K);Ot=n(Rn,"SPAN",{});var Pn=p(Ot);_(ze.$$.fragment,Pn),Pn.forEach(t),Rn.forEach(t),es=a(it),mt=n(it,"SPAN",{"data-svelte-h":!0}),h(mt)!=="svelte-w4zzv6"&&(mt.textContent=an),it.forEach(t),bo=a(e),_(Ne.$$.fragment,e),ko=a(e),Ue=n(e,"UL",{"data-svelte-h":!0}),h(Ue)!=="svelte-wxe7j8"&&(Ue.innerHTML=ln),yo=a(e),S=n(e,"H2",{class:!0});var Zo=p(S);ee=n(Zo,"A",{id:!0,class:!0,href:!0});var En=p(ee);qt=n(En,"SPAN",{});var Bn=p(qt);_(Ce.$$.fragment,Bn),Bn.forEach(t),En.forEach(t),ts=a(Zo),pt=n(Zo,"SPAN",{"data-svelte-h":!0}),h(pt)!=="svelte-7euy36"&&(pt.textContent=cn),Zo.forEach(t),Mo=a(e),V=n(e,"DIV",{class:!0});var Jo=p(V);_(Le.$$.fragment,Jo),os=a(Jo),ht=n(Jo,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-hmtsj9"&&(ht.innerHTML=dn),Jo.forEach(t),vo=a(e),J=n(e,"DIV",{class:!0});var Vt=p(J);_(Ze.$$.fragment,Vt),ss=a(Vt),gt=n(Vt,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-96awom"&&(gt.innerHTML=mn),ns=a(Vt),ft=n(Vt,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-qhpq9d"&&(ft.innerHTML=pn),Vt.forEach(t),Fo=a(e),H=n(e,"H2",{class:!0});var Wo=p(H);te=n(Wo,"A",{id:!0,class:!0,href:!0});var Sn=p(te);Dt=n(Sn,"SPAN",{});var Vn=p(Dt);_(Je.$$.fragment,Vn),Vn.forEach(t),Sn.forEach(t),rs=a(Wo),ut=n(Wo,"SPAN",{"data-svelte-h":!0}),h(ut)!=="svelte-1pfyzn8"&&(ut.textContent=hn),Wo.forEach(t),wo=a(e),$=n(e,"DIV",{class:!0});var C=p($);_(We.$$.fragment,C),as=a(C),_t=n(C,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-nib814"&&(_t.innerHTML=gn),is=a(C),bt=n(C,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-10kqkkl"&&(bt.innerHTML=fn),ls=a(C),kt=n(C,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-l3soxz"&&(kt.innerHTML=un),cs=a(C),_(oe.$$.fragment,C),ds=a(C),se=n(C,"DIV",{class:!0});var Ro=p(se);_(Re.$$.fragment,Ro),ms=a(Ro),yt=n(Ro,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-1t9qktc"&&(yt.innerHTML=_n),Ro.forEach(t),C.forEach(t),To=a(e),X=n(e,"H2",{class:!0});var Po=p(X);ne=n(Po,"A",{id:!0,class:!0,href:!0});var Hn=p(ne);Yt=n(Hn,"SPAN",{});var Xn=p(Yt);_(Pe.$$.fragment,Xn),Xn.forEach(t),Hn.forEach(t),ps=a(Po),Mt=n(Po,"SPAN",{"data-svelte-h":!0}),h(Mt)!=="svelte-7eglgf"&&(Mt.textContent=bn),Po.forEach(t),xo=a(e),T=n(e,"DIV",{class:!0});var N=p(T);_(Ee.$$.fragment,N),hs=a(N),vt=n(N,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-1fb5les"&&(vt.textContent=kn),gs=a(N),Ft=n(N,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-1wh3jgn"&&(Ft.innerHTML=yn),fs=a(N),wt=n(N,"DIV",{class:!0});var Gn=p(wt);_(Be.$$.fragment,Gn),Gn.forEach(t),us=a(N),R=n(N,"DIV",{class:!0});var Ht=p(R);_(Se.$$.fragment,Ht),_s=a(Ht),Tt=n(Ht,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-1tetyua"&&(Tt.innerHTML=Mn),bs=a(Ht),xt=n(Ht,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-1r85oma"&&(xt.innerHTML=vn),Ht.forEach(t),ks=a(N),re=n(N,"DIV",{class:!0});var Eo=p(re);_(Ve.$$.fragment,Eo),ys=a(Eo),$t=n(Eo,"P",{"data-svelte-h":!0}),h($t)!=="svelte-1bnicaz"&&($t.innerHTML=Fn),Eo.forEach(t),Ms=a(N),ae=n(N,"DIV",{class:!0});var Bo=p(ae);_(He.$$.fragment,Bo),vs=a(Bo),It=n(Bo,"P",{"data-svelte-h":!0}),h(It)!=="svelte-109ykdi"&&(It.innerHTML=wn),Bo.forEach(t),Fs=a(N),ie=n(N,"DIV",{class:!0});var So=p(ie);_(Xe.$$.fragment,So),ws=a(So),jt=n(So,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-pw2uru"&&(jt.innerHTML=Tn),So.forEach(t),N.forEach(t),$o=a(e),G=n(e,"H2",{class:!0});var Vo=p(G);le=n(Vo,"A",{id:!0,class:!0,href:!0});var An=p(le);Qt=n(An,"SPAN",{});var On=p(Qt);_(Ge.$$.fragment,On),On.forEach(t),An.forEach(t),Ts=a(Vo),zt=n(Vo,"SPAN",{"data-svelte-h":!0}),h(zt)!=="svelte-105b8w8"&&(zt.textContent=xn),Vo.forEach(t),Io=a(e),I=n(e,"DIV",{class:!0});var L=p(I);_(Ae.$$.fragment,L),xs=a(L),Nt=n(L,"DIV",{class:!0});var qn=p(Nt);_(Oe.$$.fragment,qn),qn.forEach(t),$s=a(L),P=n(L,"DIV",{class:!0});var Xt=p(P);_(qe.$$.fragment,Xt),Is=a(Xt),Ut=n(Xt,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-1tetyua"&&(Ut.innerHTML=$n),js=a(Xt),Ct=n(Xt,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-1r85oma"&&(Ct.innerHTML=In),Xt.forEach(t),zs=a(L),ce=n(L,"DIV",{class:!0});var Ho=p(ce);_(De.$$.fragment,Ho),Ns=a(Ho),Lt=n(Ho,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-1bnicaz"&&(Lt.innerHTML=jn),Ho.forEach(t),Us=a(L),de=n(L,"DIV",{class:!0});var Xo=p(de);_(Ye.$$.fragment,Xo),Cs=a(Xo),Zt=n(Xo,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-109ykdi"&&(Zt.innerHTML=zn),Xo.forEach(t),Ls=a(L),me=n(L,"DIV",{class:!0});var Go=p(me);_(Qe.$$.fragment,Go),Zs=a(Go),Jt=n(Go,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-pw2uru"&&(Jt.innerHTML=Nn),Go.forEach(t),L.forEach(t),jo=a(e),A=n(e,"H2",{class:!0});var Ao=p(A);pe=n(Ao,"A",{id:!0,class:!0,href:!0});var Dn=p(pe);Kt=n(Dn,"SPAN",{});var Yn=p(Kt);_(Ke.$$.fragment,Yn),Yn.forEach(t),Dn.forEach(t),Js=a(Ao),Wt=n(Ao,"SPAN",{"data-svelte-h":!0}),h(Wt)!=="svelte-1l9di9p"&&(Wt.textContent=Un),Ao.forEach(t),zo=a(e),W=n(e,"DIV",{class:!0});var Gt=p(W);_(et.$$.fragment,Gt),Ws=a(Gt),Rt=n(Gt,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-1wwkld6"&&(Rt.innerHTML=Cn),Rs=a(Gt),U=n(Gt,"DIV",{class:!0});var ke=p(U);_(tt.$$.fragment,ke),Ps=a(ke),Pt=n(ke,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-ofy328"&&(Pt.innerHTML=Ln),Es=a(ke),_(he.$$.fragment,ke),Bs=a(ke),_(ge.$$.fragment,ke),ke.forEach(t),Gt.forEach(t),No=a(e),O=n(e,"H2",{class:!0});var Oo=p(O);fe=n(Oo,"A",{id:!0,class:!0,href:!0});var Qn=p(fe);eo=n(Qn,"SPAN",{});var Kn=p(eo);_(ot.$$.fragment,Kn),Kn.forEach(t),Qn.forEach(t),Ss=a(Oo),Et=n(Oo,"SPAN",{"data-svelte-h":!0}),h(Et)!=="svelte-bip4yi"&&(Et.textContent=Zn),Oo.forEach(t),Uo=a(e),q=n(e,"DIV",{class:!0});var qo=p(q);_(st.$$.fragment,qo),Vs=a(qo),z=n(qo,"DIV",{class:!0});var Z=p(z);_(nt.$$.fragment,Z),Hs=a(Z),Bt=n(Z,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-anu4so"&&(Bt.innerHTML=Jn),Xs=a(Z),_(ue.$$.fragment,Z),Gs=a(Z),St=n(Z,"P",{"data-svelte-h":!0}),h(St)!=="svelte-kvfsh7"&&(St.textContent=Wn),As=a(Z),_(_e.$$.fragment,Z),Os=a(Z),_(be.$$.fragment,Z),Z.forEach(t),qo.forEach(t),Co=a(e),to=n(e,"P",{}),p(to).forEach(t),this.h()},h(){m(d,"name","hf:doc:metadata"),m(d,"content",JSON.stringify(fr)),m(l,"id","maskformer"),m(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(l,"href","#maskformer"),m(v,"class","relative group"),m(Q,"id","overview"),m(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Q,"href","#overview"),m(E,"class","relative group"),m(Ie,"width","600"),tr(Ie.src,nn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/maskformer_architecture.png")||m(Ie,"src",nn),m(K,"id","resources"),m(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(K,"href","#resources"),m(B,"class","relative group"),m(ee,"id","transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"),m(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ee,"href","#transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput"),m(S,"class","relative group"),m(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(te,"id","transformers.MaskFormerConfig"),m(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(te,"href","#transformers.MaskFormerConfig"),m(H,"class","relative group"),m(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ne,"id","transformers.MaskFormerImageProcessor"),m(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(ne,"href","#transformers.MaskFormerImageProcessor"),m(X,"class","relative group"),m(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(le,"id","transformers.MaskFormerFeatureExtractor"),m(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(le,"href","#transformers.MaskFormerFeatureExtractor"),m(G,"class","relative group"),m(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(pe,"id","transformers.MaskFormerModel"),m(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(pe,"href","#transformers.MaskFormerModel"),m(A,"class","relative group"),m(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(fe,"id","transformers.MaskFormerForInstanceSegmentation"),m(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(fe,"href","#transformers.MaskFormerForInstanceSegmentation"),m(O,"class","relative group"),m(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),m(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){o(document.head,d),c(e,F,i),c(e,g,i),c(e,f,i),c(e,v,i),o(v,l),o(l,w),b(ye,w,null),o(v,Qo),o(v,ct),c(e,ao,i),b(Y,e,i),c(e,io,i),c(e,E,i),o(E,Q),o(Q,At),b(Me,At,null),o(E,Ko),o(E,dt),c(e,lo,i),c(e,ve,i),c(e,co,i),c(e,Fe,i),c(e,mo,i),c(e,we,i),c(e,po,i),c(e,Te,i),c(e,ho,i),c(e,xe,i),c(e,go,i),c(e,$e,i),c(e,fo,i),c(e,Ie,i),c(e,uo,i),c(e,je,i),c(e,_o,i),c(e,B,i),o(B,K),o(K,Ot),b(ze,Ot,null),o(B,es),o(B,mt),c(e,bo,i),b(Ne,e,i),c(e,ko,i),c(e,Ue,i),c(e,yo,i),c(e,S,i),o(S,ee),o(ee,qt),b(Ce,qt,null),o(S,ts),o(S,pt),c(e,Mo,i),c(e,V,i),b(Le,V,null),o(V,os),o(V,ht),c(e,vo,i),c(e,J,i),b(Ze,J,null),o(J,ss),o(J,gt),o(J,ns),o(J,ft),c(e,Fo,i),c(e,H,i),o(H,te),o(te,Dt),b(Je,Dt,null),o(H,rs),o(H,ut),c(e,wo,i),c(e,$,i),b(We,$,null),o($,as),o($,_t),o($,is),o($,bt),o($,ls),o($,kt),o($,cs),b(oe,$,null),o($,ds),o($,se),b(Re,se,null),o(se,ms),o(se,yt),c(e,To,i),c(e,X,i),o(X,ne),o(ne,Yt),b(Pe,Yt,null),o(X,ps),o(X,Mt),c(e,xo,i),c(e,T,i),b(Ee,T,null),o(T,hs),o(T,vt),o(T,gs),o(T,Ft),o(T,fs),o(T,wt),b(Be,wt,null),o(T,us),o(T,R),b(Se,R,null),o(R,_s),o(R,Tt),o(R,bs),o(R,xt),o(T,ks),o(T,re),b(Ve,re,null),o(re,ys),o(re,$t),o(T,Ms),o(T,ae),b(He,ae,null),o(ae,vs),o(ae,It),o(T,Fs),o(T,ie),b(Xe,ie,null),o(ie,ws),o(ie,jt),c(e,$o,i),c(e,G,i),o(G,le),o(le,Qt),b(Ge,Qt,null),o(G,Ts),o(G,zt),c(e,Io,i),c(e,I,i),b(Ae,I,null),o(I,xs),o(I,Nt),b(Oe,Nt,null),o(I,$s),o(I,P),b(qe,P,null),o(P,Is),o(P,Ut),o(P,js),o(P,Ct),o(I,zs),o(I,ce),b(De,ce,null),o(ce,Ns),o(ce,Lt),o(I,Us),o(I,de),b(Ye,de,null),o(de,Cs),o(de,Zt),o(I,Ls),o(I,me),b(Qe,me,null),o(me,Zs),o(me,Jt),c(e,jo,i),c(e,A,i),o(A,pe),o(pe,Kt),b(Ke,Kt,null),o(A,Js),o(A,Wt),c(e,zo,i),c(e,W,i),b(et,W,null),o(W,Ws),o(W,Rt),o(W,Rs),o(W,U),b(tt,U,null),o(U,Ps),o(U,Pt),o(U,Es),b(he,U,null),o(U,Bs),b(ge,U,null),c(e,No,i),c(e,O,i),o(O,fe),o(fe,eo),b(ot,eo,null),o(O,Ss),o(O,Et),c(e,Uo,i),c(e,q,i),b(st,q,null),o(q,Vs),o(q,z),b(nt,z,null),o(z,Hs),o(z,Bt),o(z,Xs),b(ue,z,null),o(z,Gs),o(z,St),o(z,As),b(_e,z,null),o(z,Os),b(be,z,null),c(e,Co,i),c(e,to,i),Lo=!0},p(e,[i]){const rt={};i&2&&(rt.$$scope={dirty:i,ctx:e}),Y.$set(rt);const oo={};i&2&&(oo.$$scope={dirty:i,ctx:e}),oe.$set(oo);const so={};i&2&&(so.$$scope={dirty:i,ctx:e}),he.$set(so);const at={};i&2&&(at.$$scope={dirty:i,ctx:e}),ge.$set(at);const no={};i&2&&(no.$$scope={dirty:i,ctx:e}),ue.$set(no);const ro={};i&2&&(ro.$$scope={dirty:i,ctx:e}),_e.$set(ro);const it={};i&2&&(it.$$scope={dirty:i,ctx:e}),be.$set(it)},i(e){Lo||(k(ye.$$.fragment,e),k(Y.$$.fragment,e),k(Me.$$.fragment,e),k(ze.$$.fragment,e),k(Ne.$$.fragment,e),k(Ce.$$.fragment,e),k(Le.$$.fragment,e),k(Ze.$$.fragment,e),k(Je.$$.fragment,e),k(We.$$.fragment,e),k(oe.$$.fragment,e),k(Re.$$.fragment,e),k(Pe.$$.fragment,e),k(Ee.$$.fragment,e),k(Be.$$.fragment,e),k(Se.$$.fragment,e),k(Ve.$$.fragment,e),k(He.$$.fragment,e),k(Xe.$$.fragment,e),k(Ge.$$.fragment,e),k(Ae.$$.fragment,e),k(Oe.$$.fragment,e),k(qe.$$.fragment,e),k(De.$$.fragment,e),k(Ye.$$.fragment,e),k(Qe.$$.fragment,e),k(Ke.$$.fragment,e),k(et.$$.fragment,e),k(tt.$$.fragment,e),k(he.$$.fragment,e),k(ge.$$.fragment,e),k(ot.$$.fragment,e),k(st.$$.fragment,e),k(nt.$$.fragment,e),k(ue.$$.fragment,e),k(_e.$$.fragment,e),k(be.$$.fragment,e),Lo=!0)},o(e){y(ye.$$.fragment,e),y(Y.$$.fragment,e),y(Me.$$.fragment,e),y(ze.$$.fragment,e),y(Ne.$$.fragment,e),y(Ce.$$.fragment,e),y(Le.$$.fragment,e),y(Ze.$$.fragment,e),y(Je.$$.fragment,e),y(We.$$.fragment,e),y(oe.$$.fragment,e),y(Re.$$.fragment,e),y(Pe.$$.fragment,e),y(Ee.$$.fragment,e),y(Be.$$.fragment,e),y(Se.$$.fragment,e),y(Ve.$$.fragment,e),y(He.$$.fragment,e),y(Xe.$$.fragment,e),y(Ge.$$.fragment,e),y(Ae.$$.fragment,e),y(Oe.$$.fragment,e),y(qe.$$.fragment,e),y(De.$$.fragment,e),y(Ye.$$.fragment,e),y(Qe.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(he.$$.fragment,e),y(ge.$$.fragment,e),y(ot.$$.fragment,e),y(st.$$.fragment,e),y(nt.$$.fragment,e),y(ue.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),Lo=!1},d(e){e&&(t(F),t(g),t(f),t(v),t(ao),t(io),t(E),t(lo),t(ve),t(co),t(Fe),t(mo),t(we),t(po),t(Te),t(ho),t(xe),t(go),t($e),t(fo),t(Ie),t(uo),t(je),t(_o),t(B),t(bo),t(ko),t(Ue),t(yo),t(S),t(Mo),t(V),t(vo),t(J),t(Fo),t(H),t(wo),t($),t(To),t(X),t(xo),t(T),t($o),t(G),t(Io),t(I),t(jo),t(A),t(zo),t(W),t(No),t(O),t(Uo),t(q),t(Co),t(to)),t(d),M(ye),M(Y,e),M(Me),M(ze),M(Ne,e),M(Ce),M(Le),M(Ze),M(Je),M(We),M(oe),M(Re),M(Pe),M(Ee),M(Be),M(Se),M(Ve),M(He),M(Xe),M(Ge),M(Ae),M(Oe),M(qe),M(De),M(Ye),M(Qe),M(Ke),M(et),M(tt),M(he),M(ge),M(ot),M(st),M(nt),M(ue),M(_e),M(be)}}}const fr={local:"maskformer",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.models.maskformer.modeling_maskformer.MaskFormerModelOutput",title:"MaskFormer specific outputs"},{local:"transformers.MaskFormerConfig",title:"MaskFormerConfig"},{local:"transformers.MaskFormerImageProcessor",title:"MaskFormerImageProcessor"},{local:"transformers.MaskFormerFeatureExtractor",title:"MaskFormerFeatureExtractor"},{local:"transformers.MaskFormerModel",title:"MaskFormerModel"},{local:"transformers.MaskFormerForInstanceSegmentation",title:"MaskFormerForInstanceSegmentation"}],title:"MaskFormer"};function ur(j){return or(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tr extends sr{constructor(d){super(),nr(this,d,ur,gr,er,{})}}export{Tr as component};
