import{s as Cr,o as Jr,n as Nn}from"../chunks/scheduler.9bc65507.js";import{S as Ur,i as Zr,g as n,s as i,u,A as xr,h as o,f as t,c as l,j as p,v as m,y as c,k as d,o as a,a as r,w as g,d as f,t as _,x as M}from"../chunks/index.78c82d43.js";import{T as Ls}from"../chunks/Tip.87d55b76.js";import{D as z}from"../chunks/Docstring.4e7352e2.js";import{C as R}from"../chunks/CodeBlock.73e038be.js";import{I as Z}from"../chunks/IconCopyLink.bedaa44d.js";import{E as jr}from"../chunks/ExampleCodeBlock.872b014d.js";function Gr(G){let h,w="Example:",y,v,T;return v=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNdXNpY2dlbkNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRGVjb2RlckNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFQ1Q29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwRW5jb2RlY0NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRleHQlMjBlbmNvZGVyJTJDJTIwYXVkaW8lMjBlbmNvZGVyJTJDJTIwYW5kJTIwZGVjb2RlciUyMG1vZGVsJTIwY29uZmlndXJhdGlvbnMlMEF0ZXh0X2VuY29kZXJfY29uZmlnJTIwJTNEJTIwVDVDb25maWcoKSUwQWF1ZGlvX2VuY29kZXJfY29uZmlnJTIwJTNEJTIwRW5jb2RlY0NvbmZpZygpJTBBZGVjb2Rlcl9jb25maWclMjAlM0QlMjBNdXNpY2dlbkRlY29kZXJDb25maWcoKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNdXNpY2dlbkNvbmZpZy5mcm9tX3N1Yl9tb2RlbHNfY29uZmlnKCUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9jb25maWclMkMlMjBhdWRpb19lbmNvZGVyX2NvbmZpZyUyQyUyMGRlY29kZXJfY29uZmlnJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBY29uZmlnX3RleHRfZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy50ZXh0X2VuY29kZXIlMEFjb25maWdfYXVkaW9fZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyJTBBY29uZmlnX2RlY29kZXIlMjAlM0QlMjBtb2RlbC5jb25maWcuZGVjb2RlciUwQSUwQSUyMyUyMFNhdmluZyUyMHRoZSUyMG1vZGVsJTJDJTIwaW5jbHVkaW5nJTIwaXRzJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEElMEElMjMlMjBsb2FkaW5nJTIwbW9kZWwlMjBhbmQlMjBjb25maWclMjBmcm9tJTIwcHJldHJhaW5lZCUyMGZvbGRlciUwQW11c2ljZ2VuX2NvbmZpZyUyMCUzRCUyME11c2ljZ2VuQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiUyQyUyMGNvbmZpZyUzRG11c2ljZ2VuX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenConfig,
<span class="hljs-meta">... </span>    MusicgenDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenForConditionalGeneration (with random weights) from the facebook/musicgen-small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_config = MusicgenConfig.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>, config=musicgen_config)`,wrap:!1}}),{c(){h=n("p"),h.textContent=w,y=i(),u(v.$$.fragment)},l(b){h=o(b,"P",{"data-svelte-h":!0}),c(h)!=="svelte-11lpom8"&&(h.textContent=w),y=l(b),m(v.$$.fragment,b)},m(b,x){r(b,h,x),r(b,y,x),g(v,b,x),T=!0},p:Nn,i(b){T||(f(v.$$.fragment,b),T=!0)},o(b){_(v.$$.fragment,b),T=!1},d(b){b&&(t(h),t(y)),M(v,b)}}}function $r(G){let h,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){h=n("p"),h.innerHTML=w},l(y){h=o(y,"P",{"data-svelte-h":!0}),c(h)!=="svelte-fincs2"&&(h.innerHTML=w)},m(y,v){r(y,h,v)},p:Nn,d(y){y&&t(h)}}}function Fr(G){let h,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){h=n("p"),h.innerHTML=w},l(y){h=o(y,"P",{"data-svelte-h":!0}),c(h)!=="svelte-fincs2"&&(h.innerHTML=w)},m(y,v){r(y,h,v)},p:Nn,d(y){y&&t(h)}}}function Wr(G){let h,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){h=n("p"),h.innerHTML=w},l(y){h=o(y,"P",{"data-svelte-h":!0}),c(h)!=="svelte-fincs2"&&(h.innerHTML=w)},m(y,v){r(y,h,v)},p:Nn,d(y){y&&t(h)}}}function Nr(G){let h,w="Examples:",y,v,T;return v=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQSUwQXBhZF90b2tlbl9pZCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRpb25fY29uZmlnLnBhZF90b2tlbl9pZCUwQWRlY29kZXJfaW5wdXRfaWRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm9uZXMoKGlucHV0cy5pbnB1dF9pZHMuc2hhcGUlNUIwJTVEJTIwKiUyMG1vZGVsLmRlY29kZXIubnVtX2NvZGVib29rcyUyQyUyMDEpJTJDJTIwZHR5cGUlM0R0b3JjaC5sb25nKSUwQSUyMCUyMCUyMCUyMColMjBwYWRfdG9rZW5faWQlMEEpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTIwKiUyMG51bV9jb2RlYm9va3MlMkMlMjB0Z3RfbGVuJTJDJTIwdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){h=n("p"),h.textContent=w,y=i(),u(v.$$.fragment)},l(b){h=o(b,"P",{"data-svelte-h":!0}),c(h)!=="svelte-kvfsh7"&&(h.textContent=w),y=l(b),m(v.$$.fragment,b)},m(b,x){r(b,h,x),r(b,y,x),g(v,b,x),T=!0},p:Nn,i(b){T||(f(v.$$.fragment,b),T=!0)},o(b){_(v.$$.fragment,b),T=!1},d(b){b&&(t(h),t(y)),M(v,b)}}}function zr(G){let h,w,y,v,T,b,x,ke,Do,xt,Ss="MusicGen",zn,V,ne,Mn,je,Oo,Gt,Ps="Overview",In,Ce,Qs=`The MusicGen model was proposed in the paper <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a>
by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.`,Rn,Je,As=`MusicGen is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned
on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a
sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>,
conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec,
to recover the audio waveform.`,En,Ue,Ds=`Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of
the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g.
hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.`,Xn,Ze,Os="The abstract from the paper is the following:",Bn,xe,Ks=`<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates
over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised
of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for
cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen
can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better
controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human
studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark.
Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>`,qn,Ge,ea=`This model was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original code can be found
<a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the
<a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen-" rel="nofollow">Hugging Face Hub</a>.`,Vn,H,oe,bn,$e,Ko,$t,ta="Generation",Hn,Fe,na=`MusicGen is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly
better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default,
and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code>,
or by overriding the model’s generation config (see below).`,Yn,We,oa=`Generation is limited by the sinusoidal positional embeddings to 30 second inputs. Meaning, MusicGen cannot generate more
than 30 seconds of audio (1503 tokens), and input audio passed by Audio-Prompted Generation contributes to this limit so,
given an input of 20 seconds of audio, MusicGen cannot generate more than 10 seconds of additional audio.`,Ln,Y,se,yn,Ne,es,Ft,sa="Unconditional Generation",Sn,ze,aa=`The inputs for unconditional (or ‘null’) generation can be obtained through the method
<code>MusicgenForConditionalGeneration.get_unconditional_inputs()</code>:`,Pn,Ie,Qn,Re,ra=`The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen
to the generated audio samples, you can either play them in an ipynb notebook:`,An,Ee,Dn,Xe,ia="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>scipy</code>:",On,Be,Kn,L,ae,vn,qe,ts,Wt,la="Text-Conditional Generation",eo,Ve,da=`The model can generate an audio sample conditioned on a text prompt through use of the <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> to pre-process
the inputs:`,to,He,no,Ye,ca=`The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits
(which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or
‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results,
use <code>guidance_scale=3</code> (default).`,oo,S,re,wn,Le,ns,Nt,pa="Audio-Prompted Generation",so,Se,ha=`The same <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> can be used to pre-process an audio prompt that is used for audio continuation. In the
following example, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command
below:`,ao,Pe,ro,Qe,io,Ae,ua=`For batched audio-prompted generation, the generated <code>audio_values</code> can be post-processed to remove padding by using the
<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> class:`,lo,De,co,P,ie,Tn,Oe,os,zt,ma="Generation Configuration",po,Ke,ga=`The default parameters that control the generation process, such as sampling, guidance scale and number of generated
tokens, can be found in the model’s generation config, and updated as desired:`,ho,et,uo,tt,fa=`Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting
<code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the
generation config.`,mo,Q,le,kn,nt,ss,It,_a="Model Structure",go,ot,Ma="The MusicGen model can be de-composed into three distinct stages:",fo,st,ba="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5</li> <li>MusicGen decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio encoder/decoder: used to encode an audio prompt to use as prompt tokens, and recover the audio waveform from the audio tokens predicted by the decoder</li>",_o,at,ya=`Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>,
or as a composite model that includes the text encoder and audio encoder/decoder, corresponding to the class
<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first
specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:`,Mo,rt,bo,it,va=`Since the text encoder and audio encoder/decoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>
can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can
be combined with the frozen text encoder and audio encoder/decoders to recover the composite <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>
model.`,yo,lt,wa="Tips:",vo,dt,Ta="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code></li>",wo,A,de,jn,ct,as,Rt,ka="MusicgenDecoderConfig",To,I,pt,rs,Et,ja=`This is the configuration class to store the configuration of an <code>MusicgenDecoder</code>. It is used to instantiate a
MusicGen decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MusicGen
<a href="https://huggingface.co/facebook/musicgen-small" rel="nofollow">facebook/musicgen-small</a> architecture.`,is,Xt,Ca=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ko,D,ce,Cn,ht,ls,Bt,Ja="MusicgenConfig",jo,J,ut,ds,qt,Ua=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a>. It is used to instantiate a
MusicGen model according to the specified arguments, defining the text encoder, audio encoder and MusicGen decoder
configs.`,cs,Vt,Za=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ps,pe,hs,he,mt,us,Ht,xa=`Instantiate a <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,Co,O,ue,Jn,gt,ms,Yt,Ga="MusicgenProcessor",Jo,U,ft,gs,Lt,$a=`Constructs a MusicGen processor which wraps an EnCodec feature extractor and a T5 tokenizer into a single processor
class.`,fs,St,Fa=`<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> and <code>TTokenizer</code>. See
<code>__call__()</code> and <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,_s,me,_t,Ms,Pt,Wa=`This method is used to decode either batches of audio outputs from the MusicGen model, or batches of token ids
from the tokenizer. In the case of decoding token ids, this method forwards all its arguments to T5Tokenizer’s
<a href="/docs/transformers/v4.34.0/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,bs,ge,Mt,ys,Qt,Na=`This method forwards all its arguments to T5Tokenizer’s <a href="/docs/transformers/v4.34.0/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,Uo,K,fe,Un,bt,vs,At,za="MusicgenModel",Zo,k,yt,ws,Dt,Ia="The bare Musicgen decoder model outputting raw hidden-states without any specific head on top.",Ts,Ot,Ra=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,ks,Kt,Ea=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,js,en,Xa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Cs,E,vt,Js,tn,Ba='The <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a> forward method, overrides the <code>__call__</code> special method.',Us,_e,xo,ee,Me,Zn,wt,Zs,nn,qa="MusicgenForCausalLM",Go,j,Tt,xs,on,Va="The MusicGen decoder model with a language modelling head on top.",Gs,sn,Ha=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,$s,an,Ya=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fs,rn,La=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ws,X,kt,Ns,ln,Sa='The <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',zs,be,$o,te,ye,xn,jt,Is,dn,Pa="MusicgenForConditionalGeneration",Fo,C,Ct,Rs,cn,Qa="The composite MusicGen model with a text encoder, audio encoder and Musicgen decoder,for music generation tasks with one or both of text and audio prompts.",Es,pn,Aa=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,Xs,hn,Da=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Bs,un,Oa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qs,$,Jt,Vs,mn,Ka='The <a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Hs,ve,Ys,we,Wo,Gn,No;return ke=new Z({}),je=new Z({}),$e=new Z({}),Ne=new Z({}),Ie=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip1bmNvbmRpdGlvbmFsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ee=new R({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),Be=new R({props:{code:"aW1wb3J0JTIwc2NpcHklMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwbW9kZWwuY29uZmlnLmF1ZGlvX2VuY29kZXIuc2FtcGxpbmdfcmF0ZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMHJhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwZGF0YSUzRGF1ZGlvX3ZhbHVlcyU1QjAlMkMlMjAwJTVELm51bXB5KCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, rate=sampling_rate, data=audio_values[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].numpy())`,wrap:!1}}),qe=new Z({}),He=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Le=new Z({}),Pe=new R({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip <span class="hljs-keyword">install</span> --upgrade pip
pip <span class="hljs-keyword">install</span> datasets[audio]`,wrap:!1}}),Qe=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBoYWxmJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwMiU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample[<span class="hljs-string">&quot;array&quot;</span>] = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),De=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBxdWFydGVyJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZV8xJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwNCU1RCUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMGhhbGYlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzIlMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjAyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTNEJTVCc2FtcGxlXzElMkMlMjBzYW1wbGVfMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGUlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMGJsdWVzJTIwdHJhY2slMjB3aXRoJTIwZ3Jvb3Z5JTIwc2F4b3Bob25lJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KSUwQSUwQSUyMyUyMHBvc3QtcHJvY2VzcyUyMHRvJTIwcmVtb3ZlJTIwcGFkZGluZyUyMGZyb20lMjB0aGUlMjBiYXRjaGVkJTIwYXVkaW8lMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGF1ZGlvX3ZhbHVlcyUyQyUyMHBhZGRpbmdfbWFzayUzRGlucHV0cy5wYWRkaW5nX21hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># post-process to remove padding from the batched audio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = processor.batch_decode(audio_values, padding_mask=inputs.padding_mask)`,wrap:!1}}),Oe=new Z({}),et=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEElMjMlMjBpbnNwZWN0JTIwdGhlJTIwZGVmYXVsdCUyMGdlbmVyYXRpb24lMjBjb25maWclMEFtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZyUwQSUwQSUyMyUyMGluY3JlYXNlJTIwdGhlJTIwZ3VpZGFuY2UlMjBzY2FsZSUyMHRvJTIwNC4wJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjA0LjAlMEElMEElMjMlMjBkZWNyZWFzZSUyMHRoZSUyMG1heCUyMGxlbmd0aCUyMHRvJTIwMjU2JTIwdG9rZW5zJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcubWF4X2xlbmd0aCUyMCUzRCUyMDI1Ng==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),nt=new Z({}),rt=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbkZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpLmRlY29kZXIlMEFkZWNvZGVyJTIwJTNEJTIwTXVzaWNnZW5Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiUyQyUyMCoqZGVjb2Rlcl9jb25maWcpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKS5kZWNvZGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenForCausalLM, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>, **decoder_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder`,wrap:!1}}),ct=new Z({}),pt=new z({props:{name:"class transformers.MusicgenDecoderConfig",anchor:"transformers.MusicgenDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenDecoderConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether input and output word embeddings should be tied.`,name:"tie_word_embeddings(bool,"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/configuration_musicgen.py#L30"}}),ht=new Z({}),ut=new z({props:{name:"class transformers.MusicgenConfig",anchor:"transformers.MusicgenConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/configuration_musicgen.py#L129"}}),pe=new jr({props:{anchor:"transformers.MusicgenConfig.example",$$slots:{default:[Gr]},$$scope:{ctx:G}}}),mt=new z({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/configuration_musicgen.py#L207",returnDescription:`
<p>An instance of a configuration object</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a></p>
`}}),gt=new Z({}),ft=new z({props:{name:"class transformers.MusicgenProcessor",anchor:"transformers.MusicgenProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>EncodecFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/model_doc/mt5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/processing_musicgen.py#L26"}}),_t=new z({props:{name:"batch_decode",anchor:"transformers.MusicgenProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/processing_musicgen.py#L89"}}),Mt=new z({props:{name:"decode",anchor:"transformers.MusicgenProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/processing_musicgen.py#L107"}}),bt=new Z({}),yt=new z({props:{name:"class transformers.MusicgenModel",anchor:"transformers.MusicgenModel",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/modeling_musicgen.py#L898"}}),vt=new z({props:{name:"forward",anchor:"transformers.MusicgenModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>. inputs_embeds (<code>torch.FloatTensor</code> of shape
<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>): Optionally, instead of passing <code>input_ids</code> you
can choose to directly pass an embedded representation. This is useful if you want more control over how to
convert <code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"past_key_values"},{anchor:"transformers.MusicgenModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/modeling_musicgen.py#L914"}}),_e=new Ls({props:{$$slots:{default:[$r]},$$scope:{ctx:G}}}),wt=new Z({}),Tt=new z({props:{name:"class transformers.MusicgenForCausalLM",anchor:"transformers.MusicgenForCausalLM",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/modeling_musicgen.py#L969"}}),kt=new z({props:{name:"forward",anchor:"transformers.MusicgenForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>. inputs_embeds (<code>torch.FloatTensor</code> of shape
<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>): Optionally, instead of passing <code>input_ids</code> you
can choose to directly pass an embedded representation. This is useful if you want more control over how to
convert <code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"past_key_values"},{anchor:"transformers.MusicgenForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MusicgenForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code></p>
<p>Returns:
<a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput">transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code>: A <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput">transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014; Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014; Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014; Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014; Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014; Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/modeling_musicgen.py#L1001"}}),be=new Ls({props:{$$slots:{default:[Fr]},$$scope:{ctx:G}}}),jt=new Z({}),Ct=new z({props:{name:"class transformers.MusicgenForConditionalGeneration",anchor:"transformers.MusicgenForConditionalGeneration",parameters:[{name:"config",val:": typing.Optional[transformers.models.musicgen.configuration_musicgen.MusicgenConfig] = None"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"audio_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.models.musicgen.modeling_musicgen.MusicgenForCausalLM] = None"}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/modeling_musicgen.py#L1460"}}),Jt=new z({props:{name:"forward",anchor:"transformers.MusicgenForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"padding_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Tuple[typing.Tuple[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/v4.34.0/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>. inputs_embeds (<code>torch.FloatTensor</code> of shape
<code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>): Optionally, instead of passing <code>input_ids</code> you
can choose to directly pass an embedded representation. This is useful if you want more control over how to
convert <code>input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.`,name:"past_key_values"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/musicgen/modeling_musicgen.py#L1816",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new Ls({props:{$$slots:{default:[Wr]},$$scope:{ctx:G}}}),we=new jr({props:{anchor:"transformers.MusicgenForConditionalGeneration.forward.example",$$slots:{default:[Nr]},$$scope:{ctx:G}}}),{c(){h=n("meta"),w=i(),y=n("p"),v=i(),T=n("h1"),b=n("a"),x=n("span"),u(ke.$$.fragment),Do=i(),xt=n("span"),xt.textContent=Ss,zn=i(),V=n("h2"),ne=n("a"),Mn=n("span"),u(je.$$.fragment),Oo=i(),Gt=n("span"),Gt.textContent=Ps,In=i(),Ce=n("p"),Ce.innerHTML=Qs,Rn=i(),Je=n("p"),Je.innerHTML=As,En=i(),Ue=n("p"),Ue.textContent=Ds,Xn=i(),Ze=n("p"),Ze.textContent=Os,Bn=i(),xe=n("p"),xe.innerHTML=Ks,qn=i(),Ge=n("p"),Ge.innerHTML=ea,Vn=i(),H=n("h2"),oe=n("a"),bn=n("span"),u($e.$$.fragment),Ko=i(),$t=n("span"),$t.textContent=ta,Hn=i(),Fe=n("p"),Fe.innerHTML=na,Yn=i(),We=n("p"),We.textContent=oa,Ln=i(),Y=n("h3"),se=n("a"),yn=n("span"),u(Ne.$$.fragment),es=i(),Ft=n("span"),Ft.textContent=sa,Sn=i(),ze=n("p"),ze.innerHTML=aa,Pn=i(),u(Ie.$$.fragment),Qn=i(),Re=n("p"),Re.innerHTML=ra,An=i(),u(Ee.$$.fragment),Dn=i(),Xe=n("p"),Xe.innerHTML=ia,On=i(),u(Be.$$.fragment),Kn=i(),L=n("h3"),ae=n("a"),vn=n("span"),u(qe.$$.fragment),ts=i(),Wt=n("span"),Wt.textContent=la,eo=i(),Ve=n("p"),Ve.innerHTML=da,to=i(),u(He.$$.fragment),no=i(),Ye=n("p"),Ye.innerHTML=ca,oo=i(),S=n("h3"),re=n("a"),wn=n("span"),u(Le.$$.fragment),ns=i(),Nt=n("span"),Nt.textContent=pa,so=i(),Se=n("p"),Se.innerHTML=ha,ao=i(),u(Pe.$$.fragment),ro=i(),u(Qe.$$.fragment),io=i(),Ae=n("p"),Ae.innerHTML=ua,lo=i(),u(De.$$.fragment),co=i(),P=n("h3"),ie=n("a"),Tn=n("span"),u(Oe.$$.fragment),os=i(),zt=n("span"),zt.textContent=ma,po=i(),Ke=n("p"),Ke.textContent=ga,ho=i(),u(et.$$.fragment),uo=i(),tt=n("p"),tt.innerHTML=fa,mo=i(),Q=n("h2"),le=n("a"),kn=n("span"),u(nt.$$.fragment),ss=i(),It=n("span"),It.textContent=_a,go=i(),ot=n("p"),ot.textContent=Ma,fo=i(),st=n("ol"),st.innerHTML=ba,_o=i(),at=n("p"),at.innerHTML=ya,Mo=i(),u(rt.$$.fragment),bo=i(),it=n("p"),it.innerHTML=va,yo=i(),lt=n("p"),lt.textContent=wa,vo=i(),dt=n("ul"),dt.innerHTML=Ta,wo=i(),A=n("h2"),de=n("a"),jn=n("span"),u(ct.$$.fragment),as=i(),Rt=n("span"),Rt.textContent=ka,To=i(),I=n("div"),u(pt.$$.fragment),rs=i(),Et=n("p"),Et.innerHTML=ja,is=i(),Xt=n("p"),Xt.innerHTML=Ca,ko=i(),D=n("h2"),ce=n("a"),Cn=n("span"),u(ht.$$.fragment),ls=i(),Bt=n("span"),Bt.textContent=Ja,jo=i(),J=n("div"),u(ut.$$.fragment),ds=i(),qt=n("p"),qt.innerHTML=Ua,cs=i(),Vt=n("p"),Vt.innerHTML=Za,ps=i(),u(pe.$$.fragment),hs=i(),he=n("div"),u(mt.$$.fragment),us=i(),Ht=n("p"),Ht.innerHTML=xa,Co=i(),O=n("h2"),ue=n("a"),Jn=n("span"),u(gt.$$.fragment),ms=i(),Yt=n("span"),Yt.textContent=Ga,Jo=i(),U=n("div"),u(ft.$$.fragment),gs=i(),Lt=n("p"),Lt.textContent=$a,fs=i(),St=n("p"),St.innerHTML=Fa,_s=i(),me=n("div"),u(_t.$$.fragment),Ms=i(),Pt=n("p"),Pt.innerHTML=Wa,bs=i(),ge=n("div"),u(Mt.$$.fragment),ys=i(),Qt=n("p"),Qt.innerHTML=Na,Uo=i(),K=n("h2"),fe=n("a"),Un=n("span"),u(bt.$$.fragment),vs=i(),At=n("span"),At.textContent=za,Zo=i(),k=n("div"),u(yt.$$.fragment),ws=i(),Dt=n("p"),Dt.textContent=Ia,Ts=i(),Ot=n("p"),Ot.innerHTML=Ra,ks=i(),Kt=n("p"),Kt.innerHTML=Ea,js=i(),en=n("p"),en.innerHTML=Xa,Cs=i(),E=n("div"),u(vt.$$.fragment),Js=i(),tn=n("p"),tn.innerHTML=Ba,Us=i(),u(_e.$$.fragment),xo=i(),ee=n("h2"),Me=n("a"),Zn=n("span"),u(wt.$$.fragment),Zs=i(),nn=n("span"),nn.textContent=qa,Go=i(),j=n("div"),u(Tt.$$.fragment),xs=i(),on=n("p"),on.textContent=Va,Gs=i(),sn=n("p"),sn.innerHTML=Ha,$s=i(),an=n("p"),an.innerHTML=Ya,Fs=i(),rn=n("p"),rn.innerHTML=La,Ws=i(),X=n("div"),u(kt.$$.fragment),Ns=i(),ln=n("p"),ln.innerHTML=Sa,zs=i(),u(be.$$.fragment),$o=i(),te=n("h2"),ye=n("a"),xn=n("span"),u(jt.$$.fragment),Is=i(),dn=n("span"),dn.textContent=Pa,Fo=i(),C=n("div"),u(Ct.$$.fragment),Rs=i(),cn=n("p"),cn.textContent=Qa,Es=i(),pn=n("p"),pn.innerHTML=Aa,Xs=i(),hn=n("p"),hn.innerHTML=Da,Bs=i(),un=n("p"),un.innerHTML=Oa,qs=i(),$=n("div"),u(Jt.$$.fragment),Vs=i(),mn=n("p"),mn.innerHTML=Ka,Hs=i(),u(ve.$$.fragment),Ys=i(),u(we.$$.fragment),Wo=i(),Gn=n("p"),this.h()},l(e){const s=xr("svelte-1phssyn",document.head);h=o(s,"META",{name:!0,content:!0}),s.forEach(t),w=l(e),y=o(e,"P",{}),p(y).forEach(t),v=l(e),T=o(e,"H1",{class:!0});var Ut=p(T);b=o(Ut,"A",{id:!0,class:!0,href:!0});var $n=p(b);x=o($n,"SPAN",{});var Fn=p(x);m(ke.$$.fragment,Fn),Fn.forEach(t),$n.forEach(t),Do=l(Ut),xt=o(Ut,"SPAN",{"data-svelte-h":!0}),c(xt)!=="svelte-5xic8o"&&(xt.textContent=Ss),Ut.forEach(t),zn=l(e),V=o(e,"H2",{class:!0});var Zt=p(V);ne=o(Zt,"A",{id:!0,class:!0,href:!0});var Wn=p(ne);Mn=o(Wn,"SPAN",{});var er=p(Mn);m(je.$$.fragment,er),er.forEach(t),Wn.forEach(t),Oo=l(Zt),Gt=o(Zt,"SPAN",{"data-svelte-h":!0}),c(Gt)!=="svelte-1jsw1pg"&&(Gt.textContent=Ps),Zt.forEach(t),In=l(e),Ce=o(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1glsc0y"&&(Ce.innerHTML=Qs),Rn=l(e),Je=o(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-8d0j4l"&&(Je.innerHTML=As),En=l(e),Ue=o(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-cdry7g"&&(Ue.textContent=Ds),Xn=l(e),Ze=o(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-vfdo9a"&&(Ze.textContent=Os),Bn=l(e),xe=o(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-6qc9b"&&(xe.innerHTML=Ks),qn=l(e),Ge=o(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-1o040cl"&&(Ge.innerHTML=ea),Vn=l(e),H=o(e,"H2",{class:!0});var zo=p(H);oe=o(zo,"A",{id:!0,class:!0,href:!0});var tr=p(oe);bn=o(tr,"SPAN",{});var nr=p(bn);m($e.$$.fragment,nr),nr.forEach(t),tr.forEach(t),Ko=l(zo),$t=o(zo,"SPAN",{"data-svelte-h":!0}),c($t)!=="svelte-j76oon"&&($t.textContent=ta),zo.forEach(t),Hn=l(e),Fe=o(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-1rrub89"&&(Fe.innerHTML=na),Yn=l(e),We=o(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1tppmp9"&&(We.textContent=oa),Ln=l(e),Y=o(e,"H3",{class:!0});var Io=p(Y);se=o(Io,"A",{id:!0,class:!0,href:!0});var or=p(se);yn=o(or,"SPAN",{});var sr=p(yn);m(Ne.$$.fragment,sr),sr.forEach(t),or.forEach(t),es=l(Io),Ft=o(Io,"SPAN",{"data-svelte-h":!0}),c(Ft)!=="svelte-1h35aaq"&&(Ft.textContent=sa),Io.forEach(t),Sn=l(e),ze=o(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-hslupw"&&(ze.innerHTML=aa),Pn=l(e),m(Ie.$$.fragment,e),Qn=l(e),Re=o(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-c9ap2j"&&(Re.innerHTML=ra),An=l(e),m(Ee.$$.fragment,e),Dn=l(e),Xe=o(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-1endcdl"&&(Xe.innerHTML=ia),On=l(e),m(Be.$$.fragment,e),Kn=l(e),L=o(e,"H3",{class:!0});var Ro=p(L);ae=o(Ro,"A",{id:!0,class:!0,href:!0});var ar=p(ae);vn=o(ar,"SPAN",{});var rr=p(vn);m(qe.$$.fragment,rr),rr.forEach(t),ar.forEach(t),ts=l(Ro),Wt=o(Ro,"SPAN",{"data-svelte-h":!0}),c(Wt)!=="svelte-ahrv37"&&(Wt.textContent=la),Ro.forEach(t),eo=l(e),Ve=o(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-z8wa9z"&&(Ve.innerHTML=da),to=l(e),m(He.$$.fragment,e),no=l(e),Ye=o(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-78k595"&&(Ye.innerHTML=ca),oo=l(e),S=o(e,"H3",{class:!0});var Eo=p(S);re=o(Eo,"A",{id:!0,class:!0,href:!0});var ir=p(re);wn=o(ir,"SPAN",{});var lr=p(wn);m(Le.$$.fragment,lr),lr.forEach(t),ir.forEach(t),ns=l(Eo),Nt=o(Eo,"SPAN",{"data-svelte-h":!0}),c(Nt)!=="svelte-17ibtsn"&&(Nt.textContent=pa),Eo.forEach(t),so=l(e),Se=o(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-1bj5n9l"&&(Se.innerHTML=ha),ao=l(e),m(Pe.$$.fragment,e),ro=l(e),m(Qe.$$.fragment,e),io=l(e),Ae=o(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-z1mmws"&&(Ae.innerHTML=ua),lo=l(e),m(De.$$.fragment,e),co=l(e),P=o(e,"H3",{class:!0});var Xo=p(P);ie=o(Xo,"A",{id:!0,class:!0,href:!0});var dr=p(ie);Tn=o(dr,"SPAN",{});var cr=p(Tn);m(Oe.$$.fragment,cr),cr.forEach(t),dr.forEach(t),os=l(Xo),zt=o(Xo,"SPAN",{"data-svelte-h":!0}),c(zt)!=="svelte-sq0kxt"&&(zt.textContent=ma),Xo.forEach(t),po=l(e),Ke=o(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-1qo0662"&&(Ke.textContent=ga),ho=l(e),m(et.$$.fragment,e),uo=l(e),tt=o(e,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-132s853"&&(tt.innerHTML=fa),mo=l(e),Q=o(e,"H2",{class:!0});var Bo=p(Q);le=o(Bo,"A",{id:!0,class:!0,href:!0});var pr=p(le);kn=o(pr,"SPAN",{});var hr=p(kn);m(nt.$$.fragment,hr),hr.forEach(t),pr.forEach(t),ss=l(Bo),It=o(Bo,"SPAN",{"data-svelte-h":!0}),c(It)!=="svelte-1c5fyxn"&&(It.textContent=_a),Bo.forEach(t),go=l(e),ot=o(e,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-52mell"&&(ot.textContent=Ma),fo=l(e),st=o(e,"OL",{"data-svelte-h":!0}),c(st)!=="svelte-12ipaq0"&&(st.innerHTML=ba),_o=l(e),at=o(e,"P",{"data-svelte-h":!0}),c(at)!=="svelte-1w8qv29"&&(at.innerHTML=ya),Mo=l(e),m(rt.$$.fragment,e),bo=l(e),it=o(e,"P",{"data-svelte-h":!0}),c(it)!=="svelte-1ucrc9y"&&(it.innerHTML=va),yo=l(e),lt=o(e,"P",{"data-svelte-h":!0}),c(lt)!=="svelte-axv494"&&(lt.textContent=wa),vo=l(e),dt=o(e,"UL",{"data-svelte-h":!0}),c(dt)!=="svelte-1upux1z"&&(dt.innerHTML=Ta),wo=l(e),A=o(e,"H2",{class:!0});var qo=p(A);de=o(qo,"A",{id:!0,class:!0,href:!0});var ur=p(de);jn=o(ur,"SPAN",{});var mr=p(jn);m(ct.$$.fragment,mr),mr.forEach(t),ur.forEach(t),as=l(qo),Rt=o(qo,"SPAN",{"data-svelte-h":!0}),c(Rt)!=="svelte-1io0bxk"&&(Rt.textContent=ka),qo.forEach(t),To=l(e),I=o(e,"DIV",{class:!0});var gn=p(I);m(pt.$$.fragment,gn),rs=l(gn),Et=o(gn,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-13s74fx"&&(Et.innerHTML=ja),is=l(gn),Xt=o(gn,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-10kqkkl"&&(Xt.innerHTML=Ca),gn.forEach(t),ko=l(e),D=o(e,"H2",{class:!0});var Vo=p(D);ce=o(Vo,"A",{id:!0,class:!0,href:!0});var gr=p(ce);Cn=o(gr,"SPAN",{});var fr=p(Cn);m(ht.$$.fragment,fr),fr.forEach(t),gr.forEach(t),ls=l(Vo),Bt=o(Vo,"SPAN",{"data-svelte-h":!0}),c(Bt)!=="svelte-qt1zra"&&(Bt.textContent=Ja),Vo.forEach(t),jo=l(e),J=o(e,"DIV",{class:!0});var B=p(J);m(ut.$$.fragment,B),ds=l(B),qt=o(B,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-1vb2i9x"&&(qt.innerHTML=Ua),cs=l(B),Vt=o(B,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-10kqkkl"&&(Vt.innerHTML=Za),ps=l(B),m(pe.$$.fragment,B),hs=l(B),he=o(B,"DIV",{class:!0});var Ho=p(he);m(mt.$$.fragment,Ho),us=l(Ho),Ht=o(Ho,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-iatfji"&&(Ht.innerHTML=xa),Ho.forEach(t),B.forEach(t),Co=l(e),O=o(e,"H2",{class:!0});var Yo=p(O);ue=o(Yo,"A",{id:!0,class:!0,href:!0});var _r=p(ue);Jn=o(_r,"SPAN",{});var Mr=p(Jn);m(gt.$$.fragment,Mr),Mr.forEach(t),_r.forEach(t),ms=l(Yo),Yt=o(Yo,"SPAN",{"data-svelte-h":!0}),c(Yt)!=="svelte-16pxd02"&&(Yt.textContent=Ga),Yo.forEach(t),Jo=l(e),U=o(e,"DIV",{class:!0});var q=p(U);m(ft.$$.fragment,q),gs=l(q),Lt=o(q,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-12wttjh"&&(Lt.textContent=$a),fs=l(q),St=o(q,"P",{"data-svelte-h":!0}),c(St)!=="svelte-1rbvuzc"&&(St.innerHTML=Fa),_s=l(q),me=o(q,"DIV",{class:!0});var Lo=p(me);m(_t.$$.fragment,Lo),Ms=l(Lo),Pt=o(Lo,"P",{"data-svelte-h":!0}),c(Pt)!=="svelte-15obpj7"&&(Pt.innerHTML=Wa),Lo.forEach(t),bs=l(q),ge=o(q,"DIV",{class:!0});var So=p(ge);m(Mt.$$.fragment,So),ys=l(So),Qt=o(So,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-j36e87"&&(Qt.innerHTML=Na),So.forEach(t),q.forEach(t),Uo=l(e),K=o(e,"H2",{class:!0});var Po=p(K);fe=o(Po,"A",{id:!0,class:!0,href:!0});var br=p(fe);Un=o(br,"SPAN",{});var yr=p(Un);m(bt.$$.fragment,yr),yr.forEach(t),br.forEach(t),vs=l(Po),At=o(Po,"SPAN",{"data-svelte-h":!0}),c(At)!=="svelte-1kronvb"&&(At.textContent=za),Po.forEach(t),Zo=l(e),k=o(e,"DIV",{class:!0});var F=p(k);m(yt.$$.fragment,F),ws=l(F),Dt=o(F,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-kxc9tj"&&(Dt.textContent=Ia),Ts=l(F),Ot=o(F,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-57mglp"&&(Ot.innerHTML=Ra),ks=l(F),Kt=o(F,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-hmtw9k"&&(Kt.innerHTML=Ea),js=l(F),en=o(F,"P",{"data-svelte-h":!0}),c(en)!=="svelte-hswkmf"&&(en.innerHTML=Xa),Cs=l(F),E=o(F,"DIV",{class:!0});var fn=p(E);m(vt.$$.fragment,fn),Js=l(fn),tn=o(fn,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-1af2tdi"&&(tn.innerHTML=Ba),Us=l(fn),m(_e.$$.fragment,fn),fn.forEach(t),F.forEach(t),xo=l(e),ee=o(e,"H2",{class:!0});var Qo=p(ee);Me=o(Qo,"A",{id:!0,class:!0,href:!0});var vr=p(Me);Zn=o(vr,"SPAN",{});var wr=p(Zn);m(wt.$$.fragment,wr),wr.forEach(t),vr.forEach(t),Zs=l(Qo),nn=o(Qo,"SPAN",{"data-svelte-h":!0}),c(nn)!=="svelte-1mu0a07"&&(nn.textContent=qa),Qo.forEach(t),Go=l(e),j=o(e,"DIV",{class:!0});var W=p(j);m(Tt.$$.fragment,W),xs=l(W),on=o(W,"P",{"data-svelte-h":!0}),c(on)!=="svelte-1l370y5"&&(on.textContent=Va),Gs=l(W),sn=o(W,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-57mglp"&&(sn.innerHTML=Ha),$s=l(W),an=o(W,"P",{"data-svelte-h":!0}),c(an)!=="svelte-hmtw9k"&&(an.innerHTML=Ya),Fs=l(W),rn=o(W,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-hswkmf"&&(rn.innerHTML=La),Ws=l(W),X=o(W,"DIV",{class:!0});var _n=p(X);m(kt.$$.fragment,_n),Ns=l(_n),ln=o(_n,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-60hr3a"&&(ln.innerHTML=Sa),zs=l(_n),m(be.$$.fragment,_n),_n.forEach(t),W.forEach(t),$o=l(e),te=o(e,"H2",{class:!0});var Ao=p(te);ye=o(Ao,"A",{id:!0,class:!0,href:!0});var Tr=p(ye);xn=o(Tr,"SPAN",{});var kr=p(xn);m(jt.$$.fragment,kr),kr.forEach(t),Tr.forEach(t),Is=l(Ao),dn=o(Ao,"SPAN",{"data-svelte-h":!0}),c(dn)!=="svelte-bwi9g1"&&(dn.textContent=Pa),Ao.forEach(t),Fo=l(e),C=o(e,"DIV",{class:!0});var N=p(C);m(Ct.$$.fragment,N),Rs=l(N),cn=o(N,"P",{"data-svelte-h":!0}),c(cn)!=="svelte-1mlnh3w"&&(cn.textContent=Qa),Es=l(N),pn=o(N,"P",{"data-svelte-h":!0}),c(pn)!=="svelte-57mglp"&&(pn.innerHTML=Aa),Xs=l(N),hn=o(N,"P",{"data-svelte-h":!0}),c(hn)!=="svelte-hmtw9k"&&(hn.innerHTML=Da),Bs=l(N),un=o(N,"P",{"data-svelte-h":!0}),c(un)!=="svelte-hswkmf"&&(un.innerHTML=Oa),qs=l(N),$=o(N,"DIV",{class:!0});var Te=p($);m(Jt.$$.fragment,Te),Vs=l(Te),mn=o(Te,"P",{"data-svelte-h":!0}),c(mn)!=="svelte-umatre"&&(mn.innerHTML=Ka),Hs=l(Te),m(ve.$$.fragment,Te),Ys=l(Te),m(we.$$.fragment,Te),Te.forEach(t),N.forEach(t),Wo=l(e),Gn=o(e,"P",{}),p(Gn).forEach(t),this.h()},h(){d(h,"name","hf:doc:metadata"),d(h,"content",JSON.stringify(Ir)),d(b,"id","musicgen"),d(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(b,"href","#musicgen"),d(T,"class","relative group"),d(ne,"id","overview"),d(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ne,"href","#overview"),d(V,"class","relative group"),d(oe,"id","generation"),d(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(oe,"href","#generation"),d(H,"class","relative group"),d(se,"id","unconditional-generation"),d(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(se,"href","#unconditional-generation"),d(Y,"class","relative group"),d(ae,"id","textconditional-generation"),d(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ae,"href","#textconditional-generation"),d(L,"class","relative group"),d(re,"id","audioprompted-generation"),d(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(re,"href","#audioprompted-generation"),d(S,"class","relative group"),d(ie,"id","generation-configuration"),d(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ie,"href","#generation-configuration"),d(P,"class","relative group"),d(le,"id","model-structure"),d(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(le,"href","#model-structure"),d(Q,"class","relative group"),d(de,"id","transformers.MusicgenDecoderConfig"),d(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(de,"href","#transformers.MusicgenDecoderConfig"),d(A,"class","relative group"),d(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ce,"id","transformers.MusicgenConfig"),d(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ce,"href","#transformers.MusicgenConfig"),d(D,"class","relative group"),d(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ue,"id","transformers.MusicgenProcessor"),d(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ue,"href","#transformers.MusicgenProcessor"),d(O,"class","relative group"),d(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(fe,"id","transformers.MusicgenModel"),d(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(fe,"href","#transformers.MusicgenModel"),d(K,"class","relative group"),d(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Me,"id","transformers.MusicgenForCausalLM"),d(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Me,"href","#transformers.MusicgenForCausalLM"),d(ee,"class","relative group"),d(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ye,"id","transformers.MusicgenForConditionalGeneration"),d(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ye,"href","#transformers.MusicgenForConditionalGeneration"),d(te,"class","relative group"),d($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){a(document.head,h),r(e,w,s),r(e,y,s),r(e,v,s),r(e,T,s),a(T,b),a(b,x),g(ke,x,null),a(T,Do),a(T,xt),r(e,zn,s),r(e,V,s),a(V,ne),a(ne,Mn),g(je,Mn,null),a(V,Oo),a(V,Gt),r(e,In,s),r(e,Ce,s),r(e,Rn,s),r(e,Je,s),r(e,En,s),r(e,Ue,s),r(e,Xn,s),r(e,Ze,s),r(e,Bn,s),r(e,xe,s),r(e,qn,s),r(e,Ge,s),r(e,Vn,s),r(e,H,s),a(H,oe),a(oe,bn),g($e,bn,null),a(H,Ko),a(H,$t),r(e,Hn,s),r(e,Fe,s),r(e,Yn,s),r(e,We,s),r(e,Ln,s),r(e,Y,s),a(Y,se),a(se,yn),g(Ne,yn,null),a(Y,es),a(Y,Ft),r(e,Sn,s),r(e,ze,s),r(e,Pn,s),g(Ie,e,s),r(e,Qn,s),r(e,Re,s),r(e,An,s),g(Ee,e,s),r(e,Dn,s),r(e,Xe,s),r(e,On,s),g(Be,e,s),r(e,Kn,s),r(e,L,s),a(L,ae),a(ae,vn),g(qe,vn,null),a(L,ts),a(L,Wt),r(e,eo,s),r(e,Ve,s),r(e,to,s),g(He,e,s),r(e,no,s),r(e,Ye,s),r(e,oo,s),r(e,S,s),a(S,re),a(re,wn),g(Le,wn,null),a(S,ns),a(S,Nt),r(e,so,s),r(e,Se,s),r(e,ao,s),g(Pe,e,s),r(e,ro,s),g(Qe,e,s),r(e,io,s),r(e,Ae,s),r(e,lo,s),g(De,e,s),r(e,co,s),r(e,P,s),a(P,ie),a(ie,Tn),g(Oe,Tn,null),a(P,os),a(P,zt),r(e,po,s),r(e,Ke,s),r(e,ho,s),g(et,e,s),r(e,uo,s),r(e,tt,s),r(e,mo,s),r(e,Q,s),a(Q,le),a(le,kn),g(nt,kn,null),a(Q,ss),a(Q,It),r(e,go,s),r(e,ot,s),r(e,fo,s),r(e,st,s),r(e,_o,s),r(e,at,s),r(e,Mo,s),g(rt,e,s),r(e,bo,s),r(e,it,s),r(e,yo,s),r(e,lt,s),r(e,vo,s),r(e,dt,s),r(e,wo,s),r(e,A,s),a(A,de),a(de,jn),g(ct,jn,null),a(A,as),a(A,Rt),r(e,To,s),r(e,I,s),g(pt,I,null),a(I,rs),a(I,Et),a(I,is),a(I,Xt),r(e,ko,s),r(e,D,s),a(D,ce),a(ce,Cn),g(ht,Cn,null),a(D,ls),a(D,Bt),r(e,jo,s),r(e,J,s),g(ut,J,null),a(J,ds),a(J,qt),a(J,cs),a(J,Vt),a(J,ps),g(pe,J,null),a(J,hs),a(J,he),g(mt,he,null),a(he,us),a(he,Ht),r(e,Co,s),r(e,O,s),a(O,ue),a(ue,Jn),g(gt,Jn,null),a(O,ms),a(O,Yt),r(e,Jo,s),r(e,U,s),g(ft,U,null),a(U,gs),a(U,Lt),a(U,fs),a(U,St),a(U,_s),a(U,me),g(_t,me,null),a(me,Ms),a(me,Pt),a(U,bs),a(U,ge),g(Mt,ge,null),a(ge,ys),a(ge,Qt),r(e,Uo,s),r(e,K,s),a(K,fe),a(fe,Un),g(bt,Un,null),a(K,vs),a(K,At),r(e,Zo,s),r(e,k,s),g(yt,k,null),a(k,ws),a(k,Dt),a(k,Ts),a(k,Ot),a(k,ks),a(k,Kt),a(k,js),a(k,en),a(k,Cs),a(k,E),g(vt,E,null),a(E,Js),a(E,tn),a(E,Us),g(_e,E,null),r(e,xo,s),r(e,ee,s),a(ee,Me),a(Me,Zn),g(wt,Zn,null),a(ee,Zs),a(ee,nn),r(e,Go,s),r(e,j,s),g(Tt,j,null),a(j,xs),a(j,on),a(j,Gs),a(j,sn),a(j,$s),a(j,an),a(j,Fs),a(j,rn),a(j,Ws),a(j,X),g(kt,X,null),a(X,Ns),a(X,ln),a(X,zs),g(be,X,null),r(e,$o,s),r(e,te,s),a(te,ye),a(ye,xn),g(jt,xn,null),a(te,Is),a(te,dn),r(e,Fo,s),r(e,C,s),g(Ct,C,null),a(C,Rs),a(C,cn),a(C,Es),a(C,pn),a(C,Xs),a(C,hn),a(C,Bs),a(C,un),a(C,qs),a(C,$),g(Jt,$,null),a($,Vs),a($,mn),a($,Hs),g(ve,$,null),a($,Ys),g(we,$,null),r(e,Wo,s),r(e,Gn,s),No=!0},p(e,[s]){const Ut={};s&2&&(Ut.$$scope={dirty:s,ctx:e}),pe.$set(Ut);const $n={};s&2&&($n.$$scope={dirty:s,ctx:e}),_e.$set($n);const Fn={};s&2&&(Fn.$$scope={dirty:s,ctx:e}),be.$set(Fn);const Zt={};s&2&&(Zt.$$scope={dirty:s,ctx:e}),ve.$set(Zt);const Wn={};s&2&&(Wn.$$scope={dirty:s,ctx:e}),we.$set(Wn)},i(e){No||(f(ke.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),f(Ne.$$.fragment,e),f(Ie.$$.fragment,e),f(Ee.$$.fragment,e),f(Be.$$.fragment,e),f(qe.$$.fragment,e),f(He.$$.fragment,e),f(Le.$$.fragment,e),f(Pe.$$.fragment,e),f(Qe.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(nt.$$.fragment,e),f(rt.$$.fragment,e),f(ct.$$.fragment,e),f(pt.$$.fragment,e),f(ht.$$.fragment,e),f(ut.$$.fragment,e),f(pe.$$.fragment,e),f(mt.$$.fragment,e),f(gt.$$.fragment,e),f(ft.$$.fragment,e),f(_t.$$.fragment,e),f(Mt.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(vt.$$.fragment,e),f(_e.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f(kt.$$.fragment,e),f(be.$$.fragment,e),f(jt.$$.fragment,e),f(Ct.$$.fragment,e),f(Jt.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),No=!0)},o(e){_(ke.$$.fragment,e),_(je.$$.fragment,e),_($e.$$.fragment,e),_(Ne.$$.fragment,e),_(Ie.$$.fragment,e),_(Ee.$$.fragment,e),_(Be.$$.fragment,e),_(qe.$$.fragment,e),_(He.$$.fragment,e),_(Le.$$.fragment,e),_(Pe.$$.fragment,e),_(Qe.$$.fragment,e),_(De.$$.fragment,e),_(Oe.$$.fragment,e),_(et.$$.fragment,e),_(nt.$$.fragment,e),_(rt.$$.fragment,e),_(ct.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(ut.$$.fragment,e),_(pe.$$.fragment,e),_(mt.$$.fragment,e),_(gt.$$.fragment,e),_(ft.$$.fragment,e),_(_t.$$.fragment,e),_(Mt.$$.fragment,e),_(bt.$$.fragment,e),_(yt.$$.fragment,e),_(vt.$$.fragment,e),_(_e.$$.fragment,e),_(wt.$$.fragment,e),_(Tt.$$.fragment,e),_(kt.$$.fragment,e),_(be.$$.fragment,e),_(jt.$$.fragment,e),_(Ct.$$.fragment,e),_(Jt.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),No=!1},d(e){e&&(t(w),t(y),t(v),t(T),t(zn),t(V),t(In),t(Ce),t(Rn),t(Je),t(En),t(Ue),t(Xn),t(Ze),t(Bn),t(xe),t(qn),t(Ge),t(Vn),t(H),t(Hn),t(Fe),t(Yn),t(We),t(Ln),t(Y),t(Sn),t(ze),t(Pn),t(Qn),t(Re),t(An),t(Dn),t(Xe),t(On),t(Kn),t(L),t(eo),t(Ve),t(to),t(no),t(Ye),t(oo),t(S),t(so),t(Se),t(ao),t(ro),t(io),t(Ae),t(lo),t(co),t(P),t(po),t(Ke),t(ho),t(uo),t(tt),t(mo),t(Q),t(go),t(ot),t(fo),t(st),t(_o),t(at),t(Mo),t(bo),t(it),t(yo),t(lt),t(vo),t(dt),t(wo),t(A),t(To),t(I),t(ko),t(D),t(jo),t(J),t(Co),t(O),t(Jo),t(U),t(Uo),t(K),t(Zo),t(k),t(xo),t(ee),t(Go),t(j),t($o),t(te),t(Fo),t(C),t(Wo),t(Gn)),t(h),M(ke),M(je),M($e),M(Ne),M(Ie,e),M(Ee,e),M(Be,e),M(qe),M(He,e),M(Le),M(Pe,e),M(Qe,e),M(De,e),M(Oe),M(et,e),M(nt),M(rt,e),M(ct),M(pt),M(ht),M(ut),M(pe),M(mt),M(gt),M(ft),M(_t),M(Mt),M(bt),M(yt),M(vt),M(_e),M(wt),M(Tt),M(kt),M(be),M(jt),M(Ct),M(Jt),M(ve),M(we)}}}const Ir={local:"musicgen",sections:[{local:"overview",title:"Overview"},{local:"generation",sections:[{local:"unconditional-generation",title:"Unconditional Generation"},{local:"textconditional-generation",title:"Text-Conditional Generation"},{local:"audioprompted-generation",title:"Audio-Prompted Generation"},{local:"generation-configuration",title:"Generation Configuration"}],title:"Generation"},{local:"model-structure",title:"Model Structure"},{local:"transformers.MusicgenDecoderConfig",title:"MusicgenDecoderConfig"},{local:"transformers.MusicgenConfig",title:"MusicgenConfig"},{local:"transformers.MusicgenProcessor",title:"MusicgenProcessor"},{local:"transformers.MusicgenModel",title:"MusicgenModel"},{local:"transformers.MusicgenForCausalLM",title:"MusicgenForCausalLM"},{local:"transformers.MusicgenForConditionalGeneration",title:"MusicgenForConditionalGeneration"}],title:"MusicGen"};function Rr(G){return Jr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lr extends Ur{constructor(h){super(),Zr(this,h,Rr,zr,Cr,{})}}export{Lr as component};
