import{s as Wn,o as Cn,n as Bn}from"../chunks/scheduler.9bc65507.js";import{S as Gn,i as Xn,g as n,s as o,u as d,A as _n,h as l,f as t,c as r,j as h,v as m,y as c,k as i,o as p,a,w as u,d as y,t as g,x as M}from"../chunks/index.78c82d43.js";import{T as Vn}from"../chunks/Tip.87d55b76.js";import{I as f}from"../chunks/IconCopyLink.bedaa44d.js";import{C as w}from"../chunks/CodeBlock.73e038be.js";function In(Bt){let b,L="The API for the streamer classes is still under development and may change in the future.";return{c(){b=n("p"),b.textContent=L},l(v){b=l(v,"P",{"data-svelte-h":!0}),c(b)!=="svelte-gv2g1g"&&(b.textContent=L)},m(v,st){a(v,b,st)},p:Bn,d(v){v&&t(b)}}}function Rn(Bt){let b,L,v,st,j,I,gt,P,Ps,at,pa="Text generation strategies",Gt,D,ca=`Text generation is essential to many NLP tasks, such as open-ended text generation, summarization, translation, and
more. It also plays a role in a variety of mixed-modality applications that have text as an output like speech-to-text
and vision-to-text. Some of the models that can generate text include
GPT2, XLNet, OpenAI GPT, CTRL, TransformerXL, XLM, Bart, T5, GIT, Whisper.`,Xt,K,ha=`Check out a few examples that use <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to produce
text outputs for different tasks:`,_t,O,da='<li><a href="./tasks/summarization#inference">Text summarization</a></li> <li><a href="./model_doc/git#transformers.GitForCausalLM.forward.example">Image captioning</a></li> <li><a href="./model_doc/whisper#transformers.WhisperForConditionalGeneration.forward.example">Audio transcription</a></li>',Vt,ee,ma=`Note that the inputs to the generate method depend on the model’s modality. They are returned by the model’s preprocessor
class, such as AutoTokenizer or AutoProcessor. If a model’s preprocessor creates more than one kind of input, pass all
the inputs to generate(). You can learn more about the individual model’s preprocessor in the corresponding model’s documentation.`,It,te,ua=`The process of selecting output tokens to generate text is known as decoding, and you can customize the decoding strategy
that the <code>generate()</code> method will use. Modifying a decoding strategy does not change the values of any trainable parameters.
However, it can have a noticeable impact on the quality of the generated output. It can help reduce repetition in the text
and make it more coherent.`,Rt,se,ya="This guide describes:",xt,ae,ga="<li>default generation configuration</li> <li>common decoding strategies and their main parameters</li> <li>saving and sharing custom generation configurations with your fine-tuned model on 🤗 Hub</li>",Ht,T,R,Mt,ne,Ds,nt,Ma="Default text generation configuration",Nt,le,ba=`A decoding strategy for a model is defined in its generation configuration. When using pre-trained models for inference
within a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, the models call the <code>PreTrainedModel.generate()</code> method that applies a default generation
configuration under the hood. The default configuration is also used when no custom configuration has been saved with
the model.`,$t,oe,fa=`When you load a model explicitly, you can inspect the generation configuration that comes with it through
<code>model.generation_config</code>:`,zt,re,Et,ie,wa=`Printing out the <code>model.generation_config</code> reveals only the values that are different from the default generation
configuration, and does not list any of the default values.`,Qt,pe,va=`The default generation configuration limits the size of the output combined with the input prompt to a maximum of 20
tokens to avoid running into resource limitations. The default decoding strategy is greedy search, which is the simplest decoding strategy that picks a token with the highest probability as the next token. For many tasks
and small output sizes this works well. However, when used to generate longer outputs, greedy search can start
producing highly repetitive results.`,Yt,U,x,bt,ce,Ks,lt,ja="Customize text generation",Ft,he,Ta="You can override any <code>generation_config</code> by passing the parameters and their values directly to the <code>generate</code> method:",St,de,At,me,Ua=`Even if the default decoding strategy mostly works for your task, you can still tweak a few things. Some of the
commonly adjusted parameters include:`,qt,ue,Ja=`<li><code>max_new_tokens</code>: the maximum number of tokens to generate. In other words, the size of the output sequence, not
including the tokens in the prompt. As an alternative to using the output’s length as a stopping criteria, you can choose
to stop generation whenever the full generation exceeds some amount of time. To learn more, check <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>.</li> <li><code>num_beams</code>: by specifying a number of beams higher than 1, you are effectively switching from greedy search to
beam search. This strategy evaluates several hypotheses at each time step and eventually chooses the hypothesis that
has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with a lower probability initial tokens and would’ve been ignored by the greedy search.</li> <li><code>do_sample</code>: if set to <code>True</code>, this parameter enables decoding strategies such as multinomial sampling, beam-search
multinomial sampling, Top-K sampling and Top-p sampling. All these strategies select the next token from the probability
distribution over the entire vocabulary with various strategy-specific adjustments.</li> <li><code>num_return_sequences</code>: the number of sequence candidates to return for each input. This option is only available for
the decoding strategies that support multiple sequence candidates, e.g. variations of beam search and sampling. Decoding
strategies like greedy search and contrastive search return a single output sequence.</li>`,Lt,J,H,ft,ye,Os,ot,ka="Save a custom decoding strategy with your model",Pt,ge,Za="If you would like to share your fine-tuned model with a specific generation configuration, you can:",Dt,Me,Wa='<li>Create a <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> class instance</li> <li>Specify the decoding strategy parameters</li> <li>Save your generation configuration with <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>, making sure to leave its <code>config_file_name</code> argument empty</li> <li>Set <code>push_to_hub</code> to <code>True</code> to upload your config to the model’s repo</li>',Kt,be,Ot,fe,Ca=`You can also store several generation configurations in a single directory, making use of the <code>config_file_name</code>
argument in <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">GenerationConfig.save_pretrained()</a>. You can later instantiate them with <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">GenerationConfig.from_pretrained()</a>. This is useful if you want to
store several generation configurations for a single model (e.g. one for creative text generation with sampling, and
one for summarization with beam search). You must have the right Hub permissions to add configuration files to a model.`,es,we,ts,k,N,wt,ve,ea,rt,Ba="Streaming",ss,je,Ga=`The <code>generate()</code> supports streaming, through its <code>streamer</code> input. The <code>streamer</code> input is compatible with any instance
from a class that has the following methods: <code>put()</code> and <code>end()</code>. Internally, <code>put()</code> is used to push new tokens and
<code>end()</code> is used to flag the end of text generation.`,as,$,ns,Te,Xa=`In practice, you can craft your own streaming class for all sorts of purposes! We also have basic streaming classes
ready for you to use. For example, you can use the <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TextStreamer">TextStreamer</a> class to stream the output of <code>generate()</code> into
your screen, one word at a time:`,ls,Ue,os,Z,z,vt,Je,ta,it,_a="Decoding strategies",rs,ke,Va=`Certain combinations of the <code>generate()</code> parameters, and ultimately <code>generation_config</code>, can be used to enable specific
decoding strategies. If you are new to this concept, we recommend reading <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">this blog post that illustrates how common decoding strategies work</a>.`,is,Ze,Ia="Here, we’ll show some of the parameters that control the decoding strategies and illustrate how you can use them.",ps,W,E,jt,We,sa,pt,Ra="Greedy Search",cs,Ce,xa="<code>generate</code> uses greedy search decoding by default so you don’t have to pass any parameters to enable it. This means the parameters <code>num_beams</code> is set to 1 and <code>do_sample=False</code>.",hs,Be,ds,C,Q,Tt,Ge,aa,ct,Ha="Contrastive search",ms,Xe,Na=`The contrastive search decoding strategy was proposed in the 2022 paper <a href="https://arxiv.org/abs/2202.06417" rel="nofollow">A Contrastive Framework for Neural Text Generation</a>.
It demonstrates superior results for generating non-repetitive yet coherent long outputs. To learn how contrastive search
works, check out <a href="https://huggingface.co/blog/introducing-csearch" rel="nofollow">this blog post</a>.
The two main parameters that enable and control the behavior of contrastive search are <code>penalty_alpha</code> and <code>top_k</code>:`,us,_e,ys,B,Y,Ut,Ve,na,ht,$a="Multinomial sampling",gs,Ie,za=`As opposed to greedy search that always chooses a token with the highest probability as the
next token, multinomial sampling (also called ancestral sampling) randomly selects the next token based on the probability distribution over the entire
vocabulary given by the model. Every token with a non-zero probability has a chance of being selected, thus reducing the
risk of repetition.`,Ms,Re,Ea="To enable multinomial sampling set <code>do_sample=True</code> and <code>num_beams=1</code>.",bs,xe,fs,G,F,Jt,He,la,dt,Qa="Beam-search decoding",ws,Ne,Ya=`Unlike greedy search, beam-search decoding keeps several hypotheses at each time step and eventually chooses
the hypothesis that has the overall highest probability for the entire sequence. This has the advantage of identifying high-probability
sequences that start with lower probability initial tokens and would’ve been ignored by the greedy search.`,vs,$e,Fa="To enable this decoding strategy, specify the <code>num_beams</code> (aka number of hypotheses to keep track of) that is greater than 1.",js,ze,Ts,X,S,kt,Ee,oa,mt,Sa="Beam-search multinomial sampling",Us,Qe,Aa=`As the name implies, this decoding strategy combines beam search with multinomial sampling. You need to specify
the <code>num_beams</code> greater than 1, and set <code>do_sample=True</code> to use this decoding strategy.`,Js,Ye,ks,_,A,Zt,Fe,ra,ut,qa="Diverse beam search decoding",Zs,Se,La=`The diverse beam search decoding strategy is an extension of the beam search strategy that allows for generating a more diverse
set of beam sequences to choose from. To learn how it works, refer to <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam Search: Decoding Diverse Solutions from Neural Sequence Models</a>.
This approach has three main parameters: <code>num_beams</code>, <code>num_beam_groups</code>, and <code>diversity_penalty</code>.
The diversity penalty ensures the outputs are distinct across groups, and beam search is used within each group.`,Ws,Ae,Cs,qe,Pa=`This guide illustrates the main parameters that enable various decoding strategies. More advanced parameters exist for the
<code>generate</code> method, which gives you even further control over the <code>generate</code> method’s behavior.
For the complete list of the available parameters, refer to the <a href="./main_classes/text_generation.md">API documentation</a>.`,Bs,V,q,Wt,Le,ia,yt,Da="Assisted Decoding",Gs,Pe,Ka=`Assisted decoding is a modification of the decoding strategies above that uses an assistant model with the same
tokenizer (ideally a much smaller model) to greedily generate a few candidate tokens. The main model then validates
the candidate tokens in a single forward pass, which speeds up the decoding process. Currently, only greedy search
and sampling are supported with assisted decoding, and doesn’t support batched inputs. To learn more about assisted
decoding, check <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">this blog post</a>.`,Xs,De,Oa="To enable assisted decoding, set the <code>assistant_model</code> argument with a model.",_s,Ke,Vs,Oe,en=`When using assisted decoding with sampling methods, you can use the <code>temperature</code> argument to control the randomness
just like in multinomial sampling. However, in assisted decoding, reducing the temperature will help improving latency.`,Is,et,Rs,Ct,xs;return P=new f({}),ne=new f({}),re=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config
GenerationConfig {
    <span class="hljs-string">&quot;bos_token_id&quot;</span>: <span class="hljs-number">50256</span>,
    <span class="hljs-string">&quot;eos_token_id&quot;</span>: <span class="hljs-number">50256</span>,
}`,wrap:!1}}),ce=new f({}),de=new w({props:{code:"bXlfbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>my_model.generate(**inputs, num_beams=<span class="hljs-number">4</span>, do_sample=<span class="hljs-literal">True</span>)',wrap:!1}}),ye=new f({}),be=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwR2VuZXJhdGlvbkNvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm15X2FjY291bnQlMkZteV9tb2RlbCUyMiklMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MCUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDUwJTJDJTIwZW9zX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQSklMEFnZW5lcmF0aW9uX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIybXlfYWNjb3VudCUyRm15X21vZGVsJTIyJTJDJTIwcHVzaF90b19odWIlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">50</span>, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">50</span>, eos_token_id=model.config.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;my_account/my_model&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)`,wrap:!1}}),we=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LXNtYWxsJTIyKSUwQSUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZWFybHlfc3RvcHBpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2Rlcl9zdGFydF90b2tlbl9pZCUzRDAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuJTNEbW9kZWwuY29uZmlnLnBhZF90b2tlbl9pZCUyQyUwQSklMEElMEElMjMlMjBUaXAlM0ElMjBhZGQlMjAlNjBwdXNoX3RvX2h1YiUzRFRydWUlNjAlMjB0byUyMHB1c2glMjB0byUyMHRoZSUyMEh1YiUwQXRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLnNhdmVfcHJldHJhaW5lZCglMjIlMkZ0bXAlMjIlMkMlMjAlMjJ0cmFuc2xhdGlvbl9nZW5lcmF0aW9uX2NvbmZpZy5qc29uJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNvdWxkJTIwdGhlbiUyMHVzZSUyMHRoZSUyMG5hbWVkJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZyUyMGZpbGUlMjB0byUyMHBhcmFtZXRlcml6ZSUyMGdlbmVyYXRpb24lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnRtcCUyMiUyQyUyMCUyMnRyYW5zbGF0aW9uX2dlbmVyYXRpb25fY29uZmlnLmpzb24lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMENvbmZpZ3VyYXRpb24lMjBmaWxlcyUyMGFyZSUyMGVhc3klMjB0byUyMHVzZSElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGdlbmVyYXRpb25fY29uZmlnJTNEZ2VuZXJhdGlvbl9jb25maWcpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer, GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config = GenerationConfig(
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    early_stopping=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    decoder_start_token_id=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    eos_token_id=model.config.eos_token_id,
<span class="hljs-meta">... </span>    pad_token=model.config.pad_token_id,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: add \`push_to_hub=True\` to push to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translation_generation_config.save_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You could then use the named generation config file to parameterize generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;/tmp&quot;</span>, <span class="hljs-string">&quot;translation_generation_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;translate English to French: Configuration files are easy to use!&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, generation_config=generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Les fichiers de configuration sont faciles à utiliser!&#x27;</span>]`,wrap:!1}}),ve=new f({}),$=new Vn({props:{warning:!0,$$slots:{default:[In]},$$scope:{ctx:Bt}}}),Ue=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),Je=new f({}),We=new f({}),Be=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkklMjBsb29rJTIwZm9yd2FyZCUyMHRvJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmRpc3RpbGdwdDIlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I look forward to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;distilgpt2&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;I look forward to seeing you all again!\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n&#x27;</span>]`,wrap:!1}}),Ge=new f({}),_e=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJncHQyLWxhcmdlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcGVuYWx0eV9hbHBoYSUzRDAuNiUyQyUyMHRvcF9rJTNENCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Hugging Face Company is a family owned and operated business. We pride ourselves on being the best
in the business and our customer service is second to none.\\n\\nIf you have any questions about our
products or services, feel free to contact us at any time. We look forward to hearing from you!&#x27;</span>]`,wrap:!1}}),Ve=new f({}),xe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoMCklMjAlMjAlMjMlMjBGb3IlMjByZXByb2R1Y2liaWxpdHklMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyZ3B0Mi1sYXJnZSUyMiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJUb2RheSUyMHdhcyUyMGFuJTIwYW1hemluZyUyMGRheSUyMGJlY2F1c2UlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbnVtX2JlYW1zJTNEMSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;gpt2-large&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Today was an amazing day because&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, num_beams=<span class="hljs-number">1</span>, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today was an amazing day because when you go to the World Cup and you don\\&#x27;t, or when you don\\&#x27;t get invited,
that\\&#x27;s a terrible feeling.&quot;&#x27;</span>]`,wrap:!1}}),He=new f({}),ze=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBhc3RvbmlzaGluZyUyMGhvdyUyMG9uZSUyMGNhbiUyMiUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJncHQyLW1lZGl1bSUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBudW1fYmVhbXMlM0Q1JTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;It is astonishing how one can&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;gpt2-medium&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;It is astonishing how one can have such a profound impact on the lives of so many people in such a short period of
time.&quot;\\n\\nHe added: &quot;I am very proud of the work I have been able to do in the last few years.\\n\\n&quot;I have&#x27;</span>]`,wrap:!1}}),Ee=new f({}),Ye=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMkMlMjBzZXRfc2VlZCUwQXNldF9zZWVkKDApJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIydHJhbnNsYXRlJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwVGhlJTIwaG91c2UlMjBpcyUyMHdvbmRlcmZ1bC4lMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIydDUtc21hbGwlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDUlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;translate English to German: The house is wonderful.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;t5-small&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Das Haus ist wunderbar.&#x27;</span>`,wrap:!1}}),Fe=new f({}),Ae=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/pegasus-xsum&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Permaculture Design Principles are a set of universal design principles &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;that can be applied to any location, climate and culture, and they allow us to design &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the most efficient and sustainable human habitation and food production systems. &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture is a design system that encompasses a wide variety of disciplines, such &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;as ecology, landscape design, environmental science and energy conservation, and the &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Permaculture design principles are drawn from these various disciplines. Each individual &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;design principle itself embodies a complete conceptual framework based on sound &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;scientific principles. When we bring all these separate  principles together, we can &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;create a design system that both looks at whole systems, the parts that these systems &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;consist of, and how those parts interact with each other to create a complex, dynamic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;living system. Each design principle serves as a tool that allows us to integrate all &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the separate parts of a design, referred to as elements, into a functional, synergistic, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;whole system, where the elements harmoniously interact and work together in the most &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;efficient way possible.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, num_beams=<span class="hljs-number">5</span>, num_beam_groups=<span class="hljs-number">5</span>, max_new_tokens=<span class="hljs-number">30</span>, diversity_penalty=<span class="hljs-number">1.0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;The Design Principles are a set of universal design principles that can be applied to any location, climate and
culture, and they allow us to design the&#x27;</span>`,wrap:!1}}),Le=new f({}),Ke=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFsaWNlJTIwYW5kJTIwQm9iJTIyJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMS40Yi1kZWR1cGVkJTIyJTBBYXNzaXN0YW50X2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJFbGV1dGhlckFJJTJGcHl0aGlhLTE2MG0tZGVkdXBlZCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFhc3Npc3RhbnRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoYXNzaXN0YW50X2NoZWNrcG9pbnQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYXNzaXN0YW50X21vZGVsJTNEYXNzaXN0YW50X21vZGVsKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are sitting in a bar. Alice is drinking a beer and Bob is drinking a&#x27;</span>]`,wrap:!1}}),et=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTIwJTIwJTIzJTIwRm9yJTIwcmVwcm9kdWNpYmlsaXR5JTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjIlMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyRWxldXRoZXJBSSUyRnB5dGhpYS0xLjRiLWRlZHVwZWQlMjIlMEFhc3Npc3RhbnRfY2hlY2twb2ludCUyMCUzRCUyMCUyMkVsZXV0aGVyQUklMkZweXRoaWEtMTYwbS1kZWR1cGVkJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQWFzc2lzdGFudF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChhc3Npc3RhbnRfY2hlY2twb2ludCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBhc3Npc3RhbnRfbW9kZWwlM0Rhc3Npc3RhbnRfbW9kZWwlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)  <span class="hljs-comment"># For reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Alice and Bob&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-1.4b-deduped&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_checkpoint = <span class="hljs-string">&quot;EleutherAI/pythia-160m-deduped&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>assistant_model = AutoModelForCausalLM.from_pretrained(assistant_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, assistant_model=assistant_model, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Alice and Bob are going to the same party. It is a small party, in a small&#x27;</span>]`,wrap:!1}}),{c(){b=n("meta"),L=o(),v=n("p"),st=o(),j=n("h1"),I=n("a"),gt=n("span"),d(P.$$.fragment),Ps=o(),at=n("span"),at.textContent=pa,Gt=o(),D=n("p"),D.textContent=ca,Xt=o(),K=n("p"),K.innerHTML=ha,_t=o(),O=n("ul"),O.innerHTML=da,Vt=o(),ee=n("p"),ee.textContent=ma,It=o(),te=n("p"),te.innerHTML=ua,Rt=o(),se=n("p"),se.textContent=ya,xt=o(),ae=n("ul"),ae.innerHTML=ga,Ht=o(),T=n("h2"),R=n("a"),Mt=n("span"),d(ne.$$.fragment),Ds=o(),nt=n("span"),nt.textContent=Ma,Nt=o(),le=n("p"),le.innerHTML=ba,$t=o(),oe=n("p"),oe.innerHTML=fa,zt=o(),d(re.$$.fragment),Et=o(),ie=n("p"),ie.innerHTML=wa,Qt=o(),pe=n("p"),pe.textContent=va,Yt=o(),U=n("h2"),x=n("a"),bt=n("span"),d(ce.$$.fragment),Ks=o(),lt=n("span"),lt.textContent=ja,Ft=o(),he=n("p"),he.innerHTML=Ta,St=o(),d(de.$$.fragment),At=o(),me=n("p"),me.textContent=Ua,qt=o(),ue=n("ul"),ue.innerHTML=Ja,Lt=o(),J=n("h2"),H=n("a"),ft=n("span"),d(ye.$$.fragment),Os=o(),ot=n("span"),ot.textContent=ka,Pt=o(),ge=n("p"),ge.textContent=Za,Dt=o(),Me=n("ul"),Me.innerHTML=Wa,Kt=o(),d(be.$$.fragment),Ot=o(),fe=n("p"),fe.innerHTML=Ca,es=o(),d(we.$$.fragment),ts=o(),k=n("h2"),N=n("a"),wt=n("span"),d(ve.$$.fragment),ea=o(),rt=n("span"),rt.textContent=Ba,ss=o(),je=n("p"),je.innerHTML=Ga,as=o(),d($.$$.fragment),ns=o(),Te=n("p"),Te.innerHTML=Xa,ls=o(),d(Ue.$$.fragment),os=o(),Z=n("h2"),z=n("a"),vt=n("span"),d(Je.$$.fragment),ta=o(),it=n("span"),it.textContent=_a,rs=o(),ke=n("p"),ke.innerHTML=Va,is=o(),Ze=n("p"),Ze.textContent=Ia,ps=o(),W=n("h3"),E=n("a"),jt=n("span"),d(We.$$.fragment),sa=o(),pt=n("span"),pt.textContent=Ra,cs=o(),Ce=n("p"),Ce.innerHTML=xa,hs=o(),d(Be.$$.fragment),ds=o(),C=n("h3"),Q=n("a"),Tt=n("span"),d(Ge.$$.fragment),aa=o(),ct=n("span"),ct.textContent=Ha,ms=o(),Xe=n("p"),Xe.innerHTML=Na,us=o(),d(_e.$$.fragment),ys=o(),B=n("h3"),Y=n("a"),Ut=n("span"),d(Ve.$$.fragment),na=o(),ht=n("span"),ht.textContent=$a,gs=o(),Ie=n("p"),Ie.textContent=za,Ms=o(),Re=n("p"),Re.innerHTML=Ea,bs=o(),d(xe.$$.fragment),fs=o(),G=n("h3"),F=n("a"),Jt=n("span"),d(He.$$.fragment),la=o(),dt=n("span"),dt.textContent=Qa,ws=o(),Ne=n("p"),Ne.textContent=Ya,vs=o(),$e=n("p"),$e.innerHTML=Fa,js=o(),d(ze.$$.fragment),Ts=o(),X=n("h3"),S=n("a"),kt=n("span"),d(Ee.$$.fragment),oa=o(),mt=n("span"),mt.textContent=Sa,Us=o(),Qe=n("p"),Qe.innerHTML=Aa,Js=o(),d(Ye.$$.fragment),ks=o(),_=n("h3"),A=n("a"),Zt=n("span"),d(Fe.$$.fragment),ra=o(),ut=n("span"),ut.textContent=qa,Zs=o(),Se=n("p"),Se.innerHTML=La,Ws=o(),d(Ae.$$.fragment),Cs=o(),qe=n("p"),qe.innerHTML=Pa,Bs=o(),V=n("h3"),q=n("a"),Wt=n("span"),d(Le.$$.fragment),ia=o(),yt=n("span"),yt.textContent=Da,Gs=o(),Pe=n("p"),Pe.innerHTML=Ka,Xs=o(),De=n("p"),De.innerHTML=Oa,_s=o(),d(Ke.$$.fragment),Vs=o(),Oe=n("p"),Oe.innerHTML=en,Is=o(),d(et.$$.fragment),Rs=o(),Ct=n("p"),this.h()},l(e){const s=_n("svelte-1phssyn",document.head);b=l(s,"META",{name:!0,content:!0}),s.forEach(t),L=r(e),v=l(e,"P",{}),h(v).forEach(t),st=r(e),j=l(e,"H1",{class:!0});var tt=h(j);I=l(tt,"A",{id:!0,class:!0,href:!0});var tn=h(I);gt=l(tn,"SPAN",{});var sn=h(gt);m(P.$$.fragment,sn),sn.forEach(t),tn.forEach(t),Ps=r(tt),at=l(tt,"SPAN",{"data-svelte-h":!0}),c(at)!=="svelte-1f4blit"&&(at.textContent=pa),tt.forEach(t),Gt=r(e),D=l(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1pq6r4w"&&(D.textContent=ca),Xt=r(e),K=l(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-p5c5ow"&&(K.innerHTML=ha),_t=r(e),O=l(e,"UL",{"data-svelte-h":!0}),c(O)!=="svelte-18jzu0"&&(O.innerHTML=da),Vt=r(e),ee=l(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-5iqkcx"&&(ee.textContent=ma),It=r(e),te=l(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-agd87v"&&(te.innerHTML=ua),Rt=r(e),se=l(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1gun7m8"&&(se.textContent=ya),xt=r(e),ae=l(e,"UL",{"data-svelte-h":!0}),c(ae)!=="svelte-l1azua"&&(ae.innerHTML=ga),Ht=r(e),T=l(e,"H2",{class:!0});var Hs=h(T);R=l(Hs,"A",{id:!0,class:!0,href:!0});var an=h(R);Mt=l(an,"SPAN",{});var nn=h(Mt);m(ne.$$.fragment,nn),nn.forEach(t),an.forEach(t),Ds=r(Hs),nt=l(Hs,"SPAN",{"data-svelte-h":!0}),c(nt)!=="svelte-thv2tr"&&(nt.textContent=Ma),Hs.forEach(t),Nt=r(e),le=l(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-17hu36s"&&(le.innerHTML=ba),$t=r(e),oe=l(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-2o7gdz"&&(oe.innerHTML=fa),zt=r(e),m(re.$$.fragment,e),Et=r(e),ie=l(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-18srzjs"&&(ie.innerHTML=wa),Qt=r(e),pe=l(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-32rftl"&&(pe.textContent=va),Yt=r(e),U=l(e,"H2",{class:!0});var Ns=h(U);x=l(Ns,"A",{id:!0,class:!0,href:!0});var ln=h(x);bt=l(ln,"SPAN",{});var on=h(bt);m(ce.$$.fragment,on),on.forEach(t),ln.forEach(t),Ks=r(Ns),lt=l(Ns,"SPAN",{"data-svelte-h":!0}),c(lt)!=="svelte-18i90pv"&&(lt.textContent=ja),Ns.forEach(t),Ft=r(e),he=l(e,"P",{"data-svelte-h":!0}),c(he)!=="svelte-qprijs"&&(he.innerHTML=Ta),St=r(e),m(de.$$.fragment,e),At=r(e),me=l(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-t9z639"&&(me.textContent=Ua),qt=r(e),ue=l(e,"UL",{"data-svelte-h":!0}),c(ue)!=="svelte-1i0i0e6"&&(ue.innerHTML=Ja),Lt=r(e),J=l(e,"H2",{class:!0});var $s=h(J);H=l($s,"A",{id:!0,class:!0,href:!0});var rn=h(H);ft=l(rn,"SPAN",{});var pn=h(ft);m(ye.$$.fragment,pn),pn.forEach(t),rn.forEach(t),Os=r($s),ot=l($s,"SPAN",{"data-svelte-h":!0}),c(ot)!=="svelte-1crrg36"&&(ot.textContent=ka),$s.forEach(t),Pt=r(e),ge=l(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1l1ri2h"&&(ge.textContent=Za),Dt=r(e),Me=l(e,"UL",{"data-svelte-h":!0}),c(Me)!=="svelte-15n4cha"&&(Me.innerHTML=Wa),Kt=r(e),m(be.$$.fragment,e),Ot=r(e),fe=l(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-k9hg0n"&&(fe.innerHTML=Ca),es=r(e),m(we.$$.fragment,e),ts=r(e),k=l(e,"H2",{class:!0});var zs=h(k);N=l(zs,"A",{id:!0,class:!0,href:!0});var cn=h(N);wt=l(cn,"SPAN",{});var hn=h(wt);m(ve.$$.fragment,hn),hn.forEach(t),cn.forEach(t),ea=r(zs),rt=l(zs,"SPAN",{"data-svelte-h":!0}),c(rt)!=="svelte-r5rcbb"&&(rt.textContent=Ba),zs.forEach(t),ss=r(e),je=l(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-12rh7l9"&&(je.innerHTML=Ga),as=r(e),m($.$$.fragment,e),ns=r(e),Te=l(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1m9he1z"&&(Te.innerHTML=Xa),ls=r(e),m(Ue.$$.fragment,e),os=r(e),Z=l(e,"H2",{class:!0});var Es=h(Z);z=l(Es,"A",{id:!0,class:!0,href:!0});var dn=h(z);vt=l(dn,"SPAN",{});var mn=h(vt);m(Je.$$.fragment,mn),mn.forEach(t),dn.forEach(t),ta=r(Es),it=l(Es,"SPAN",{"data-svelte-h":!0}),c(it)!=="svelte-1wlre25"&&(it.textContent=_a),Es.forEach(t),rs=r(e),ke=l(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-ip87dk"&&(ke.innerHTML=Va),is=r(e),Ze=l(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-nugt5b"&&(Ze.textContent=Ia),ps=r(e),W=l(e,"H3",{class:!0});var Qs=h(W);E=l(Qs,"A",{id:!0,class:!0,href:!0});var un=h(E);jt=l(un,"SPAN",{});var yn=h(jt);m(We.$$.fragment,yn),yn.forEach(t),un.forEach(t),sa=r(Qs),pt=l(Qs,"SPAN",{"data-svelte-h":!0}),c(pt)!=="svelte-1pp3otr"&&(pt.textContent=Ra),Qs.forEach(t),cs=r(e),Ce=l(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1m7rj88"&&(Ce.innerHTML=xa),hs=r(e),m(Be.$$.fragment,e),ds=r(e),C=l(e,"H3",{class:!0});var Ys=h(C);Q=l(Ys,"A",{id:!0,class:!0,href:!0});var gn=h(Q);Tt=l(gn,"SPAN",{});var Mn=h(Tt);m(Ge.$$.fragment,Mn),Mn.forEach(t),gn.forEach(t),aa=r(Ys),ct=l(Ys,"SPAN",{"data-svelte-h":!0}),c(ct)!=="svelte-1497ha9"&&(ct.textContent=Ha),Ys.forEach(t),ms=r(e),Xe=l(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-m0y9j6"&&(Xe.innerHTML=Na),us=r(e),m(_e.$$.fragment,e),ys=r(e),B=l(e,"H3",{class:!0});var Fs=h(B);Y=l(Fs,"A",{id:!0,class:!0,href:!0});var bn=h(Y);Ut=l(bn,"SPAN",{});var fn=h(Ut);m(Ve.$$.fragment,fn),fn.forEach(t),bn.forEach(t),na=r(Fs),ht=l(Fs,"SPAN",{"data-svelte-h":!0}),c(ht)!=="svelte-1q3sc33"&&(ht.textContent=$a),Fs.forEach(t),gs=r(e),Ie=l(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-vsvvis"&&(Ie.textContent=za),Ms=r(e),Re=l(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-ldtxsn"&&(Re.innerHTML=Ea),bs=r(e),m(xe.$$.fragment,e),fs=r(e),G=l(e,"H3",{class:!0});var Ss=h(G);F=l(Ss,"A",{id:!0,class:!0,href:!0});var wn=h(F);Jt=l(wn,"SPAN",{});var vn=h(Jt);m(He.$$.fragment,vn),vn.forEach(t),wn.forEach(t),la=r(Ss),dt=l(Ss,"SPAN",{"data-svelte-h":!0}),c(dt)!=="svelte-1kucxhs"&&(dt.textContent=Qa),Ss.forEach(t),ws=r(e),Ne=l(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-149ek3p"&&(Ne.textContent=Ya),vs=r(e),$e=l(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-krswod"&&($e.innerHTML=Fa),js=r(e),m(ze.$$.fragment,e),Ts=r(e),X=l(e,"H3",{class:!0});var As=h(X);S=l(As,"A",{id:!0,class:!0,href:!0});var jn=h(S);kt=l(jn,"SPAN",{});var Tn=h(kt);m(Ee.$$.fragment,Tn),Tn.forEach(t),jn.forEach(t),oa=r(As),mt=l(As,"SPAN",{"data-svelte-h":!0}),c(mt)!=="svelte-1w95569"&&(mt.textContent=Sa),As.forEach(t),Us=r(e),Qe=l(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-zgjlvh"&&(Qe.innerHTML=Aa),Js=r(e),m(Ye.$$.fragment,e),ks=r(e),_=l(e,"H3",{class:!0});var qs=h(_);A=l(qs,"A",{id:!0,class:!0,href:!0});var Un=h(A);Zt=l(Un,"SPAN",{});var Jn=h(Zt);m(Fe.$$.fragment,Jn),Jn.forEach(t),Un.forEach(t),ra=r(qs),ut=l(qs,"SPAN",{"data-svelte-h":!0}),c(ut)!=="svelte-9yaih7"&&(ut.textContent=qa),qs.forEach(t),Zs=r(e),Se=l(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-zdhf65"&&(Se.innerHTML=La),Ws=r(e),m(Ae.$$.fragment,e),Cs=r(e),qe=l(e,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-1e7mt8t"&&(qe.innerHTML=Pa),Bs=r(e),V=l(e,"H3",{class:!0});var Ls=h(V);q=l(Ls,"A",{id:!0,class:!0,href:!0});var kn=h(q);Wt=l(kn,"SPAN",{});var Zn=h(Wt);m(Le.$$.fragment,Zn),Zn.forEach(t),kn.forEach(t),ia=r(Ls),yt=l(Ls,"SPAN",{"data-svelte-h":!0}),c(yt)!=="svelte-m6blcs"&&(yt.textContent=Da),Ls.forEach(t),Gs=r(e),Pe=l(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-1i5gxtn"&&(Pe.innerHTML=Ka),Xs=r(e),De=l(e,"P",{"data-svelte-h":!0}),c(De)!=="svelte-ebd3ly"&&(De.innerHTML=Oa),_s=r(e),m(Ke.$$.fragment,e),Vs=r(e),Oe=l(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-m00818"&&(Oe.innerHTML=en),Is=r(e),m(et.$$.fragment,e),Rs=r(e),Ct=l(e,"P",{}),h(Ct).forEach(t),this.h()},h(){i(b,"name","hf:doc:metadata"),i(b,"content",JSON.stringify(xn)),i(I,"id","text-generation-strategies"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#text-generation-strategies"),i(j,"class","relative group"),i(R,"id","default-text-generation-configuration"),i(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(R,"href","#default-text-generation-configuration"),i(T,"class","relative group"),i(x,"id","customize-text-generation"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#customize-text-generation"),i(U,"class","relative group"),i(H,"id","save-a-custom-decoding-strategy-with-your-model"),i(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(H,"href","#save-a-custom-decoding-strategy-with-your-model"),i(J,"class","relative group"),i(N,"id","streaming"),i(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(N,"href","#streaming"),i(k,"class","relative group"),i(z,"id","decoding-strategies"),i(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(z,"href","#decoding-strategies"),i(Z,"class","relative group"),i(E,"id","greedy-search"),i(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(E,"href","#greedy-search"),i(W,"class","relative group"),i(Q,"id","contrastive-search"),i(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(Q,"href","#contrastive-search"),i(C,"class","relative group"),i(Y,"id","multinomial-sampling"),i(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(Y,"href","#multinomial-sampling"),i(B,"class","relative group"),i(F,"id","beamsearch-decoding"),i(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(F,"href","#beamsearch-decoding"),i(G,"class","relative group"),i(S,"id","beamsearch-multinomial-sampling"),i(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(S,"href","#beamsearch-multinomial-sampling"),i(X,"class","relative group"),i(A,"id","diverse-beam-search-decoding"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#diverse-beam-search-decoding"),i(_,"class","relative group"),i(q,"id","assisted-decoding"),i(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(q,"href","#assisted-decoding"),i(V,"class","relative group")},m(e,s){p(document.head,b),a(e,L,s),a(e,v,s),a(e,st,s),a(e,j,s),p(j,I),p(I,gt),u(P,gt,null),p(j,Ps),p(j,at),a(e,Gt,s),a(e,D,s),a(e,Xt,s),a(e,K,s),a(e,_t,s),a(e,O,s),a(e,Vt,s),a(e,ee,s),a(e,It,s),a(e,te,s),a(e,Rt,s),a(e,se,s),a(e,xt,s),a(e,ae,s),a(e,Ht,s),a(e,T,s),p(T,R),p(R,Mt),u(ne,Mt,null),p(T,Ds),p(T,nt),a(e,Nt,s),a(e,le,s),a(e,$t,s),a(e,oe,s),a(e,zt,s),u(re,e,s),a(e,Et,s),a(e,ie,s),a(e,Qt,s),a(e,pe,s),a(e,Yt,s),a(e,U,s),p(U,x),p(x,bt),u(ce,bt,null),p(U,Ks),p(U,lt),a(e,Ft,s),a(e,he,s),a(e,St,s),u(de,e,s),a(e,At,s),a(e,me,s),a(e,qt,s),a(e,ue,s),a(e,Lt,s),a(e,J,s),p(J,H),p(H,ft),u(ye,ft,null),p(J,Os),p(J,ot),a(e,Pt,s),a(e,ge,s),a(e,Dt,s),a(e,Me,s),a(e,Kt,s),u(be,e,s),a(e,Ot,s),a(e,fe,s),a(e,es,s),u(we,e,s),a(e,ts,s),a(e,k,s),p(k,N),p(N,wt),u(ve,wt,null),p(k,ea),p(k,rt),a(e,ss,s),a(e,je,s),a(e,as,s),u($,e,s),a(e,ns,s),a(e,Te,s),a(e,ls,s),u(Ue,e,s),a(e,os,s),a(e,Z,s),p(Z,z),p(z,vt),u(Je,vt,null),p(Z,ta),p(Z,it),a(e,rs,s),a(e,ke,s),a(e,is,s),a(e,Ze,s),a(e,ps,s),a(e,W,s),p(W,E),p(E,jt),u(We,jt,null),p(W,sa),p(W,pt),a(e,cs,s),a(e,Ce,s),a(e,hs,s),u(Be,e,s),a(e,ds,s),a(e,C,s),p(C,Q),p(Q,Tt),u(Ge,Tt,null),p(C,aa),p(C,ct),a(e,ms,s),a(e,Xe,s),a(e,us,s),u(_e,e,s),a(e,ys,s),a(e,B,s),p(B,Y),p(Y,Ut),u(Ve,Ut,null),p(B,na),p(B,ht),a(e,gs,s),a(e,Ie,s),a(e,Ms,s),a(e,Re,s),a(e,bs,s),u(xe,e,s),a(e,fs,s),a(e,G,s),p(G,F),p(F,Jt),u(He,Jt,null),p(G,la),p(G,dt),a(e,ws,s),a(e,Ne,s),a(e,vs,s),a(e,$e,s),a(e,js,s),u(ze,e,s),a(e,Ts,s),a(e,X,s),p(X,S),p(S,kt),u(Ee,kt,null),p(X,oa),p(X,mt),a(e,Us,s),a(e,Qe,s),a(e,Js,s),u(Ye,e,s),a(e,ks,s),a(e,_,s),p(_,A),p(A,Zt),u(Fe,Zt,null),p(_,ra),p(_,ut),a(e,Zs,s),a(e,Se,s),a(e,Ws,s),u(Ae,e,s),a(e,Cs,s),a(e,qe,s),a(e,Bs,s),a(e,V,s),p(V,q),p(q,Wt),u(Le,Wt,null),p(V,ia),p(V,yt),a(e,Gs,s),a(e,Pe,s),a(e,Xs,s),a(e,De,s),a(e,_s,s),u(Ke,e,s),a(e,Vs,s),a(e,Oe,s),a(e,Is,s),u(et,e,s),a(e,Rs,s),a(e,Ct,s),xs=!0},p(e,[s]){const tt={};s&2&&(tt.$$scope={dirty:s,ctx:e}),$.$set(tt)},i(e){xs||(y(P.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(de.$$.fragment,e),y(ye.$$.fragment,e),y(be.$$.fragment,e),y(we.$$.fragment,e),y(ve.$$.fragment,e),y($.$$.fragment,e),y(Ue.$$.fragment,e),y(Je.$$.fragment,e),y(We.$$.fragment,e),y(Be.$$.fragment,e),y(Ge.$$.fragment,e),y(_e.$$.fragment,e),y(Ve.$$.fragment,e),y(xe.$$.fragment,e),y(He.$$.fragment,e),y(ze.$$.fragment,e),y(Ee.$$.fragment,e),y(Ye.$$.fragment,e),y(Fe.$$.fragment,e),y(Ae.$$.fragment,e),y(Le.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),xs=!0)},o(e){g(P.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(ve.$$.fragment,e),g($.$$.fragment,e),g(Ue.$$.fragment,e),g(Je.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(_e.$$.fragment,e),g(Ve.$$.fragment,e),g(xe.$$.fragment,e),g(He.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(Fe.$$.fragment,e),g(Ae.$$.fragment,e),g(Le.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),xs=!1},d(e){e&&(t(L),t(v),t(st),t(j),t(Gt),t(D),t(Xt),t(K),t(_t),t(O),t(Vt),t(ee),t(It),t(te),t(Rt),t(se),t(xt),t(ae),t(Ht),t(T),t(Nt),t(le),t($t),t(oe),t(zt),t(Et),t(ie),t(Qt),t(pe),t(Yt),t(U),t(Ft),t(he),t(St),t(At),t(me),t(qt),t(ue),t(Lt),t(J),t(Pt),t(ge),t(Dt),t(Me),t(Kt),t(Ot),t(fe),t(es),t(ts),t(k),t(ss),t(je),t(as),t(ns),t(Te),t(ls),t(os),t(Z),t(rs),t(ke),t(is),t(Ze),t(ps),t(W),t(cs),t(Ce),t(hs),t(ds),t(C),t(ms),t(Xe),t(us),t(ys),t(B),t(gs),t(Ie),t(Ms),t(Re),t(bs),t(fs),t(G),t(ws),t(Ne),t(vs),t($e),t(js),t(Ts),t(X),t(Us),t(Qe),t(Js),t(ks),t(_),t(Zs),t(Se),t(Ws),t(Cs),t(qe),t(Bs),t(V),t(Gs),t(Pe),t(Xs),t(De),t(_s),t(Vs),t(Oe),t(Is),t(Rs),t(Ct)),t(b),M(P),M(ne),M(re,e),M(ce),M(de,e),M(ye),M(be,e),M(we,e),M(ve),M($,e),M(Ue,e),M(Je),M(We),M(Be,e),M(Ge),M(_e,e),M(Ve),M(xe,e),M(He),M(ze,e),M(Ee),M(Ye,e),M(Fe),M(Ae,e),M(Le),M(Ke,e),M(et,e)}}}const xn={local:"text-generation-strategies",sections:[{local:"default-text-generation-configuration",title:"Default text generation configuration"},{local:"customize-text-generation",title:"Customize text generation"},{local:"save-a-custom-decoding-strategy-with-your-model",title:"Save a custom decoding strategy with your model"},{local:"streaming",title:"Streaming"},{local:"decoding-strategies",sections:[{local:"greedy-search",title:"Greedy Search"},{local:"contrastive-search",title:"Contrastive search"},{local:"multinomial-sampling",title:"Multinomial sampling"},{local:"beamsearch-decoding",title:"Beam-search decoding"},{local:"beamsearch-multinomial-sampling",title:"Beam-search multinomial sampling"},{local:"diverse-beam-search-decoding",title:"Diverse beam search decoding"},{local:"assisted-decoding",title:"Assisted Decoding"}],title:"Decoding strategies"}],title:"Text generation strategies"};function Hn(Bt){return Cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yn extends Gn{constructor(b){super(),Xn(this,b,Hn,Rn,Wn,{})}}export{Yn as component};
