import{s as Dg,o as Kg,n as Og}from"../chunks/scheduler.9bc65507.js";import{S as e1,i as t1,g as a,s as i,u,A as n1,h as s,f as t,c as h,j as p,v as c,y as d,k as r,o,a as l,w as f,d as m,t as v,x as g}from"../chunks/index.78c82d43.js";import{T as a1}from"../chunks/Tip.87d55b76.js";import{Y as $o}from"../chunks/Youtube.b19762b6.js";import{I as $}from"../chunks/IconCopyLink.bedaa44d.js";import{C as b}from"../chunks/CodeBlock.73e038be.js";function s1(wo){let w,It=`Each model’s labels may be different, so be sure to always check the documentation of each model for more information
about their specific labels!`;return{c(){w=a("p"),w.textContent=It},l(x){w=s(x,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1nifkrh"&&(w.textContent=It)},m(x,Ds){l(x,w,Ds)},p:Og,d(x){x&&t(w)}}}function l1(wo){let w,It,x,Ds,_,Me,or,Ft,Vd,Ks,Xu="Glossary",bo,Jt,Gu=`This glossary defines general machine learning and 🤗 Transformers terms to help you better understand the
documentation.`,xo,k,Ne,ir,Wt,Ld,Os,Ru="A",_o,y,Se,hr,Bt,Zd,el,Qu="attention mask",ko,Xt,Yu="The attention mask is an optional argument used when batching sequences together.",yo,Gt,Co,Rt,Du="This argument indicates to the model which tokens should be attended to, and which should not.",jo,Qt,Ku="For example, consider these two sequences:",Ao,Yt,To,Dt,Ou="The encoded versions have different lengths:",Eo,Kt,Po,Ot,ec=`Therefore, we can’t put them together in the same tensor as-is. The first sequence needs to be padded up to the length
of the second one, or the second one needs to be truncated down to the length of the first one.`,Mo,en,tc=`In the first case, the list of IDs will be extended by the padding indices. We can pass a list to the tokenizer and ask
it to pad like this:`,No,tn,So,nn,nc="We can see that 0s have been added on the right of the first sentence to make it the same length as the second one:",Ho,an,qo,sn,ac=`This can then be converted into a tensor in PyTorch or TensorFlow. The attention mask is a binary tensor indicating the
position of the padded indices so that the model does not attend to them. For the <a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>, <code>1</code> indicates a
value that should be attended to, while <code>0</code> indicates a padded value. This attention mask is in the dictionary returned
by the tokenizer under the key “attention_mask”:`,zo,ln,Vo,C,He,pr,rn,Ud,tl,sc="autoencoding models",Lo,on,lc='See <a href="#encoder-models">encoder models</a> and <a href="#masked-language-modeling-mlm">masked language modeling</a>',Zo,j,qe,dr,hn,Id,nl,rc="autoregressive models",Uo,pn,oc='See <a href="#causal-language-modeling">causal language modeling</a> and <a href="#decoder-models">decoder models</a>',Io,A,ze,ur,dn,Fd,al,ic="B",Fo,T,Ve,cr,un,Jd,sl,hc="backbone",Jo,cn,pc='The backbone is the network (embeddings and layers) that outputs the raw hidden states or features. It is usually connected to a <a href="#head">head</a> which accepts the features as its input to make a prediction. For example, <a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a> is a backbone without a specific head on top. Other models can also use <code>VitModel</code> as a backbone such as <a href="model_doc/dpt">DPT</a>.',Wo,E,Le,fr,fn,Wd,ll,dc="C",Bo,P,Ze,mr,mn,Bd,rl,uc="causal language modeling",Xo,vn,cc=`A pretraining task where the model reads the texts in order and has to predict the next word. It’s usually done by
reading the whole sentence but using a mask inside the model to hide the future tokens at a certain timestep.`,Go,M,Ue,vr,gn,Xd,ol,fc="channel",Ro,$n,mc="Color images are made up of some combination of values in three channels - red, green, and blue (RGB) - and grayscale images only have one channel. In 🤗 Transformers, the channel can be the first or last dimension of an image’s tensor: [<code>n_channels</code>, <code>height</code>, <code>width</code>] or [<code>height</code>, <code>width</code>, <code>n_channels</code>].",Qo,N,Ie,gr,wn,Gd,il,vc="connectionist temporal classification (CTC)",Yo,bn,gc="An algorithm which allows a model to learn without knowing exactly how the input and output are aligned; CTC calculates the distribution of all possible outputs for a given input and chooses the most likely output from it. CTC is commonly used in speech recognition tasks because speech doesn’t always cleanly align with the transcript for a variety of reasons such as a speaker’s different speech rates.",Do,S,Fe,$r,xn,Rd,hl,$c="convolution",Ko,_n,wc="A type of layer in a neural network where the input matrix is multiplied element-wise by a smaller matrix (kernel or filter) and the values are summed up in a new matrix. This is known as a convolutional operation which is repeated over the entire input matrix. Each operation is applied to a different segment of the input matrix. Convolutional neural networks (CNNs) are commonly used in computer vision.",Oo,H,Je,wr,kn,Qd,pl,bc="D",ei,q,We,br,yn,Yd,dl,xc="decoder input IDs",ti,Cn,_c=`This input is specific to encoder-decoder models, and contains the input IDs that will be fed to the decoder. These
inputs should be used for sequence to sequence tasks, such as translation or summarization, and are usually built in a
way specific to each model.`,ni,jn,kc=`Most encoder-decoder models (BART, T5) create their <code>decoder_input_ids</code> on their own from the <code>labels</code>. In such models,
passing the <code>labels</code> is the preferred way to handle training.`,ai,An,yc="Please check each model’s docs to see how they handle these input IDs for sequence to sequence training.",si,z,Be,xr,Tn,Dd,ul,Cc="decoder models",li,En,jc=`Also referred to as autoregressive models, decoder models involve a pretraining task (called causal language modeling) where the model reads the texts in order and has to predict the next word. It’s usually done by
reading the whole sentence with a mask to hide future tokens at a certain timestep.`,ri,Pn,oi,V,Xe,_r,Mn,Kd,cl,Ac="deep learning (DL)",ii,Nn,Tc="Machine learning algorithms which uses neural networks with several layers.",hi,L,Ge,kr,Sn,Od,fl,Ec="E",pi,Z,Re,yr,Hn,eu,ml,Pc="encoder models",di,qn,Mc='Also known as autoencoding models, encoder models take an input (such as text or images) and transform them into a condensed numerical representation called an embedding. Oftentimes, encoder models are pretrained using techniques like <a href="#masked-language-modeling-mlm">masked language modeling</a>, which masks parts of the input sequence and forces the model to create more meaningful representations.',ui,zn,ci,U,Qe,Cr,Vn,tu,vl,Nc="F",fi,I,Ye,jr,Ln,nu,gl,Sc="feature extraction",mi,Zn,Hc="The process of selecting and transforming raw data into a set of features that are more informative and useful for machine learning algorithms. Some examples of feature extraction include transforming raw text into word embeddings and extracting important features such as edges or shapes from image/video data.",vi,F,De,Ar,Un,au,$l,qc="feed forward chunking",gi,In,zc=`In each residual attention block in transformers the self-attention layer is usually followed by 2 feed forward layers.
The intermediate embedding size of the feed forward layers is often bigger than the hidden size of the model (e.g., for
<code>bert-base-uncased</code>).`,$i,Fn,Vc=`For an input of size <code>[batch_size, sequence_length]</code>, the memory required to store the intermediate feed forward
embeddings <code>[batch_size, sequence_length, config.intermediate_size]</code> can account for a large fraction of the memory
use. The authors of <a href="https://arxiv.org/abs/2001.04451" rel="nofollow">Reformer: The Efficient Transformer</a> noticed that since the
computation is independent of the <code>sequence_length</code> dimension, it is mathematically equivalent to compute the output
embeddings of both feed forward layers <code>[batch_size, config.hidden_size]_0, ..., [batch_size, config.hidden_size]_n</code>
individually and concat them afterward to <code>[batch_size, sequence_length, config.hidden_size]</code> with <code>n = sequence_length</code>, which trades increased computation time against reduced memory use, but yields a mathematically
<strong>equivalent</strong> result.`,wi,Jn,Lc=`For models employing the function <a href="/docs/transformers/v4.34.0/en/internal/modeling_utils#transformers.apply_chunking_to_forward">apply_chunking_to_forward()</a>, the <code>chunk_size</code> defines the number of output
embeddings that are computed in parallel and thus defines the trade-off between memory and time complexity. If
<code>chunk_size</code> is set to 0, no feed forward chunking is done.`,bi,J,Ke,Tr,Wn,su,wl,Zc="finetuned models",xi,Bn,Uc='Finetuning is a form of transfer learning which involves taking a pretrained model, freezing its weights, and replacing the output layer with a newly added <a href="#head">model head</a>. The model head is trained on your target dataset.',_i,Xn,Ic='See the <a href="https://huggingface.co/docs/transformers/training" rel="nofollow">Fine-tune a pretrained model</a> tutorial for more details, and learn how to fine-tune models with 🤗 Transformers.',ki,W,Oe,Er,Gn,lu,bl,Fc="H",yi,B,et,Pr,Rn,ru,xl,Jc="head",Ci,Qn,Wc="The model head refers to the last layer of a neural network that accepts the raw hidden states and projects them onto a different dimension. There is a different model head for each task. For example:",ji,Yn,Bc='<li><a href="/docs/transformers/v4.34.0/en/model_doc/gpt2#transformers.GPT2ForSequenceClassification">GPT2ForSequenceClassification</a> is a sequence classification head - a linear layer - on top of the base <a href="/docs/transformers/v4.34.0/en/model_doc/gpt2#transformers.GPT2Model">GPT2Model</a>.</li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> is an image classification head - a linear layer on top of the final hidden state of the <code>CLS</code> token - on top of the base <a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a>.</li> <li><a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a> ia a language modeling head with <a href="#connectionist-temporal-classification-(CTC)">CTC</a> on top of the base <a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2Model">Wav2Vec2Model</a>.</li>',Ai,X,tt,Mr,Dn,ou,_l,Xc="I",Ti,G,nt,Nr,Kn,iu,kl,Gc="image patch",Ei,On,Rc="Vision-based Transformers models split an image into smaller patches which are linearly embedded, and then passed as a sequence to the model. You can find the <code>patch_size</code> - or resolution - of the model in its configuration.",Pi,R,at,Sr,ea,hu,yl,Qc="inference",Mi,ta,Yc='Inference is the process of evaluating a model on new data after training is complete. See the <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">Pipeline for inference</a> tutorial to learn how to perform inference with 🤗 Transformers.',Ni,Q,st,Hr,na,pu,Cl,Dc="input IDs",Si,aa,Kc=`The input ids are often the only required parameters to be passed to the model as input. They are token indices,
numerical representations of tokens building the sequences that will be used as input by the model.`,Hi,sa,qi,la,Oc=`Each tokenizer works differently but the underlying mechanism remains the same. Here’s an example using the BERT
tokenizer, which is a <a href="https://arxiv.org/pdf/1609.08144.pdf" rel="nofollow">WordPiece</a> tokenizer:`,zi,ra,Vi,oa,ef="The tokenizer takes care of splitting the sequence into tokens available in the tokenizer vocabulary.",Li,ia,Zi,ha,tf=`The tokens are either words or subwords. Here for instance, “VRAM” wasn’t in the model vocabulary, so it’s been split
in “V”, “RA” and “M”. To indicate those tokens are not separate words but parts of the same word, a double-hash prefix
is added for “RA” and “M”:`,Ui,pa,Ii,da,nf=`These tokens can then be converted into IDs which are understandable by the model. This can be done by directly feeding
the sentence to the tokenizer, which leverages the Rust implementation of <a href="https://github.com/huggingface/tokenizers" rel="nofollow">🤗
Tokenizers</a> for peak performance.`,Fi,ua,Ji,ca,af=`The tokenizer returns a dictionary with all the arguments necessary for its corresponding model to work properly. The
token indices are under the key <code>input_ids</code>:`,Wi,fa,Bi,ma,sf=`Note that the tokenizer automatically adds “special tokens” (if the associated model relies on them) which are special
IDs the model sometimes uses.`,Xi,va,lf="If we decode the previous sequence of ids,",Gi,ga,Ri,$a,rf="we will see",Qi,wa,Yi,ba,of='because this is the way a <a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertModel">BertModel</a> is going to expect its inputs.',Di,Y,lt,qr,xa,du,jl,hf="L",Ki,D,rt,zr,_a,uu,Al,pf="labels",Oi,ka,df=`The labels are an optional argument which can be passed in order for the model to compute the loss itself. These labels
should be the expected prediction of the model: it will use the standard loss in order to compute the loss between its
predictions and the expected value (the label).`,eh,ya,uf="These labels are different according to the model head, for example:",th,Ca,cf=`<li>For sequence classification models, (<a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a>), the model expects a tensor of dimension
<code>(batch_size)</code> with each value of the batch corresponding to the expected label of the entire sequence.</li> <li>For token classification models, (<a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a>), the model expects a tensor of dimension
<code>(batch_size, seq_length)</code> with each value corresponding to the expected label of each individual token.</li> <li>For masked language modeling, (<a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a>), the model expects a tensor of dimension <code>(batch_size, seq_length)</code> with each value corresponding to the expected label of each individual token: the labels being the token
ID for the masked token, and values to be ignored for the rest (usually -100).</li> <li>For sequence to sequence tasks, (<a href="/docs/transformers/v4.34.0/en/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a>, <a href="/docs/transformers/v4.34.0/en/model_doc/mbart#transformers.MBartForConditionalGeneration">MBartForConditionalGeneration</a>), the model
expects a tensor of dimension <code>(batch_size, tgt_seq_length)</code> with each value corresponding to the target sequences
associated with each input sequence. During training, both BART and T5 will make the appropriate
<code>decoder_input_ids</code> and decoder attention masks internally. They usually do not need to be supplied. This does not
apply to models leveraging the Encoder-Decoder framework.</li> <li>For image classification models, (<a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a>), the model expects a tensor of dimension
<code>(batch_size)</code> with each value of the batch corresponding to the expected label of each individual image.</li> <li>For semantic segmentation models, (<a href="/docs/transformers/v4.34.0/en/model_doc/segformer#transformers.SegformerForSemanticSegmentation">SegformerForSemanticSegmentation</a>), the model expects a tensor of dimension
<code>(batch_size, height, width)</code> with each value of the batch corresponding to the expected label of each individual pixel.</li> <li>For object detection models, (<a href="/docs/transformers/v4.34.0/en/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a>), the model expects a list of dictionaries with a
<code>class_labels</code> and <code>boxes</code> key where each value of the batch corresponds to the expected label and number of bounding boxes of each individual image.</li> <li>For automatic speech recognition models, (<a href="/docs/transformers/v4.34.0/en/model_doc/wav2vec2#transformers.Wav2Vec2ForCTC">Wav2Vec2ForCTC</a>), the model expects a tensor of dimension <code>(batch_size, target_length)</code> with each value corresponding to the expected label of each individual token.</li>`,nh,ot,ah,ja,ff=`The base models (<a href="/docs/transformers/v4.34.0/en/model_doc/bert#transformers.BertModel">BertModel</a>) do not accept labels, as these are the base transformer models, simply outputting
features.`,sh,K,it,Vr,Aa,cu,Tl,mf="large language models (LLM)",lh,Ta,vf="A generic term that refers to transformer language models (GPT-3, BLOOM, OPT) that were trained on a large quantity of data. These models also tend to have a large number of learnable parameters (e.g. 175 billion for GPT-3).",rh,O,ht,Lr,Ea,fu,El,gf="M",oh,ee,pt,Zr,Pa,mu,Pl,$f="masked language modeling (MLM)",ih,Ma,wf=`A pretraining task where the model sees a corrupted version of the texts, usually done by
masking some tokens randomly, and has to predict the original text.`,hh,te,dt,Ur,Na,vu,Ml,bf="multimodal",ph,Sa,xf="A task that combines texts with another kind of inputs (for instance images).",dh,ne,ut,Ir,Ha,gu,Nl,_f="N",uh,ae,ct,Fr,qa,$u,Sl,kf="Natural language generation (NLG)",ch,za,yf='All tasks related to generating text (for instance, <a href="https://transformer.huggingface.co/" rel="nofollow">Write With Transformers</a>, translation).',fh,se,ft,Jr,Va,wu,Hl,Cf="Natural language processing (NLP)",mh,La,jf="A generic way to say “deal with texts”.",vh,le,mt,Wr,Za,bu,ql,Af="Natural language understanding (NLU)",gh,Ua,Tf=`All tasks related to understanding what is in a text (for instance classifying the
whole text, individual words).`,$h,re,vt,Br,Ia,xu,zl,Ef="P",wh,oe,gt,Xr,Fa,_u,Vl,Pf="pipeline",bh,Ja,Mf="A pipeline in 🤗 Transformers is an abstraction referring to a series of steps that are executed in a specific order to preprocess and transform data and return a prediction from a model. Some example stages found in a pipeline might be data preprocessing, feature extraction, and normalization.",xh,Wa,Nf='For more details, see <a href="https://huggingface.co/docs/transformers/pipeline_tutorial" rel="nofollow">Pipelines for inference</a>.',_h,ie,$t,Gr,Ba,ku,Ll,Sf="pixel values",kh,Xa,Hf="A tensor of the numerical representations of an image that is passed to a model. The pixel values have a shape of [<code>batch_size</code>, <code>num_channels</code>, <code>height</code>, <code>width</code>], and are generated from an image processor.",yh,he,wt,Rr,Ga,yu,Zl,qf="pooling",Ch,Ra,zf="An operation that reduces a matrix into a smaller matrix, either by taking the maximum or average of the pooled dimension(s). Pooling layers are commonly found between convolutional layers to downsample the feature representation.",jh,pe,bt,Qr,Qa,Cu,Ul,Vf="position IDs",Ah,Ya,Lf=`Contrary to RNNs that have the position of each token embedded within them, transformers are unaware of the position of
each token. Therefore, the position IDs (<code>position_ids</code>) are used by the model to identify each token’s position in the
list of tokens.`,Th,Da,Zf=`They are an optional parameter. If no <code>position_ids</code> are passed to the model, the IDs are automatically created as
absolute positional embeddings.`,Eh,Ka,Uf=`Absolute positional embeddings are selected in the range <code>[0, config.max_position_embeddings - 1]</code>. Some models use
other types of positional embeddings, such as sinusoidal position embeddings or relative position embeddings.`,Ph,de,xt,Yr,Oa,ju,Il,If="preprocessing",Mh,es,Ff='The task of preparing raw data into a format that can be easily consumed by machine learning models. For example, text is typically preprocessed by tokenization. To gain a better idea of what preprocessing looks like for other input types, check out the <a href="https://huggingface.co/docs/transformers/preprocessing" rel="nofollow">Preprocess</a> tutorial.',Nh,ue,_t,Dr,ts,Au,Fl,Jf="pretrained model",Sh,ns,Wf=`A model that has been pretrained on some data (for instance all of Wikipedia). Pretraining methods involve a
self-supervised objective, which can be reading the text and trying to predict the next word (see <a href="#causal-language-modeling">causal language
modeling</a>) or masking some words and trying to predict them (see <a href="#masked-language-modeling-mlm">masked language
modeling</a>).`,Hh,as,Bf="Speech and vision models have their own pretraining objectives. For example, Wav2Vec2 is a speech model pretrained on a contrastive task which requires the model to identify the “true” speech representation from a set of “false” speech representations. On the other hand, BEiT is a vision model pretrained on a masked image modeling task which masks some of the image patches and requires the model to predict the masked patches (similar to the masked language modeling objective).",qh,ce,kt,Kr,ss,Tu,Jl,Xf="R",zh,fe,yt,Or,ls,Eu,Wl,Gf="recurrent neural network (RNN)",Vh,rs,Rf="A type of model that uses a loop over a layer to process texts.",Lh,me,Ct,eo,os,Pu,Bl,Qf="representation learning",Zh,is,Yf="A subfield of machine learning which focuses on learning meaningful representations of raw data. Some examples of representation learning techniques include word embeddings, autoencoders, and Generative Adversarial Networks (GANs).",Uh,ve,jt,to,hs,Mu,Xl,Df="S",Ih,ge,At,no,ps,Nu,Gl,Kf="sampling rate",Fh,ds,Of="A measurement in hertz of the number of samples (the audio signal) taken per second. The sampling rate is a result of discretizing a continuous signal such as speech.",Jh,$e,Tt,ao,us,Su,Rl,em="self-attention",Wh,cs,tm="Each element of the input finds out which other elements of the input they should attend to.",Bh,we,Et,so,fs,Hu,Ql,nm="self-supervised learning",Xh,ms,am='A category of machine learning techniques in which a model creates its own learning objective from unlabeled data. It differs from <a href="#unsupervised-learning">unsupervised learning</a> and <a href="#supervised-learning">supervised learning</a> in that the learning process is supervised, but not explicitly from the user.',Gh,vs,sm='One example of self-supervised learning is <a href="#masked-language-modeling-mlm">masked language modeling</a>, where a model is passed sentences with a proportion of its tokens removed and learns to predict the missing tokens.',Rh,be,Pt,lo,gs,qu,Yl,lm="semi-supervised learning",Qh,$s,rm='A broad category of machine learning training techniques that leverages a small amount of labeled data with a larger quantity of unlabeled data to improve the accuracy of a model, unlike <a href="#supervised-learning">supervised learning</a> and <a href="#unsupervised-learning">unsupervised learning</a>.',Yh,ws,om="An example of a semi-supervised learning approach is “self-training”, in which a model is trained on labeled data, and then used to make predictions on the unlabeled data. The portion of the unlabeled data that the model predicts with the most confidence gets added to the labeled dataset and used to retrain the model.",Dh,xe,Mt,ro,bs,zu,Dl,im="sequence-to-sequence (seq2seq)",Kh,xs,hm=`Models that generate a new sequence from an input, like translation models, or summarization models (such as
<a href="model_doc/bart">Bart</a> or <a href="model_doc/t5">T5</a>).`,Oh,_e,Nt,oo,_s,Vu,Kl,pm="stride",ep,ks,dm='In <a href="#convolution">convolution</a> or <a href="#pooling">pooling</a>, the stride refers to the distance the kernel is moved over a matrix. A stride of 1 means the kernel is moved one pixel over at a time, and a stride of 2 means the kernel is moved two pixels over at a time.',tp,ke,St,io,ys,Lu,Ol,um="supervised learning",np,Cs,cm="A form of model training that directly uses labeled data to correct and instruct model performance. Data is fed into the model being trained, and its predictions are compared to the known labels. The model updates its weights based on how incorrect its predictions were, and the process is repeated to optimize model performance.",ap,ye,Ht,ho,js,Zu,er,fm="T",sp,Ce,qt,po,As,Uu,tr,mm="token",lp,Ts,vm=`A part of a sentence, usually a word, but can also be a subword (non-common words are often split in subwords) or a
punctuation symbol.`,rp,je,zt,uo,Es,Iu,nr,gm="token Type IDs",op,Ps,$m="Some models’ purpose is to do classification on pairs of sentences or question answering.",ip,Ms,hp,Ns,wm=`These require two different sequences to be joined in a single “input_ids” entry, which usually is performed with the
help of special tokens, such as the classifier (<code>[CLS]</code>) and separator (<code>[SEP]</code>) tokens. For example, the BERT model
builds its two sequence input as such:`,pp,Ss,dp,Hs,bm=`We can use our tokenizer to automatically generate such a sentence by passing the two sequences to <code>tokenizer</code> as two
arguments (and not a list, like before) like this:`,up,qs,cp,zs,xm="which will return:",fp,Vs,mp,Ls,_m=`This is enough for some models to understand where one sequence ends and where another begins. However, other models,
such as BERT, also deploy token type IDs (also called segment IDs). They are represented as a binary mask identifying
the two types of sequence in the model.`,vp,Zs,km="The tokenizer returns this mask as the “token_type_ids” entry:",gp,Us,$p,Is,ym=`The first sequence, the “context” used for the question, has all its tokens represented by a <code>0</code>, whereas the second
sequence, corresponding to the “question”, has all its tokens represented by a <code>1</code>.`,wp,Fs,Cm='Some models, like <a href="/docs/transformers/v4.34.0/en/model_doc/xlnet#transformers.XLNetModel">XLNetModel</a> use an additional token represented by a <code>2</code>.',bp,Ae,Vt,co,Js,Fu,ar,jm="transfer learning",xp,Ws,Am="A technique that involves taking a pretrained model and adapting it to a dataset specific to your task. Instead of training a model from scratch, you can leverage knowledge obtained from an existing model as a starting point. This speeds up the learning process and reduces the amount of training data needed.",_p,Te,Lt,fo,Bs,Ju,sr,Tm="transformer",kp,Xs,Em="Self-attention based deep learning model architecture.",yp,Ee,Zt,mo,Gs,Wu,lr,Pm="U",Cp,Pe,Ut,vo,Rs,Bu,rr,Mm="unsupervised learning",jp,Qs,Nm="A form of model training in which data provided to the model is not labeled. Unsupervised learning techniques leverage statistical information of the data distribution to find patterns useful for the task at hand.",Ap,go,Tp;return Ft=new $({}),Wt=new $({}),Bt=new $({}),Gt=new $o({props:{id:"M6adb1j2jPI"}}),Yt=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBc2VxdWVuY2VfYSUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBzaG9ydCUyMHNlcXVlbmNlLiUyMiUwQXNlcXVlbmNlX2IlMjAlM0QlMjAlMjJUaGlzJTIwaXMlMjBhJTIwcmF0aGVyJTIwbG9uZyUyMHNlcXVlbmNlLiUyMEl0JTIwaXMlMjBhdCUyMGxlYXN0JTIwbG9uZ2VyJTIwdGhhbiUyMHRoZSUyMHNlcXVlbmNlJTIwQS4lMjIlMEElMEFlbmNvZGVkX3NlcXVlbmNlX2ElMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VfYSklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEFlbmNvZGVkX3NlcXVlbmNlX2IlMjAlM0QlMjB0b2tlbml6ZXIoc2VxdWVuY2VfYiklNUIlMjJpbnB1dF9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_a = <span class="hljs-string">&quot;This is a short sequence.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_b = <span class="hljs-string">&quot;This is a rather long sequence. It is at least longer than the sequence A.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence_a = tokenizer(sequence_a)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence_b = tokenizer(sequence_b)[<span class="hljs-string">&quot;input_ids&quot;</span>]`,wrap:!1}}),Kt=new b({props:{code:"bGVuKGVuY29kZWRfc2VxdWVuY2VfYSklMkMlMjBsZW4oZW5jb2RlZF9zZXF1ZW5jZV9iKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(encoded_sequence_a), <span class="hljs-built_in">len</span>(encoded_sequence_b)
(<span class="hljs-number">8</span>, <span class="hljs-number">19</span>)`,wrap:!1}}),tn=new b({props:{code:"cGFkZGVkX3NlcXVlbmNlcyUyMCUzRCUyMHRva2VuaXplciglNUJzZXF1ZW5jZV9hJTJDJTIwc2VxdWVuY2VfYiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences = tokenizer([sequence_a, sequence_b], padding=<span class="hljs-literal">True</span>)',wrap:!1}}),an=new b({props:{code:"cGFkZGVkX3NlcXVlbmNlcyU1QiUyMmlucHV0X2lkcyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences[<span class="hljs-string">&quot;input_ids&quot;</span>]
[[<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1603</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">101</span>, <span class="hljs-number">1188</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">170</span>, <span class="hljs-number">1897</span>, <span class="hljs-number">1263</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">119</span>, <span class="hljs-number">1135</span>, <span class="hljs-number">1110</span>, <span class="hljs-number">1120</span>, <span class="hljs-number">1655</span>, <span class="hljs-number">2039</span>, <span class="hljs-number">1190</span>, <span class="hljs-number">1103</span>, <span class="hljs-number">4954</span>, <span class="hljs-number">138</span>, <span class="hljs-number">119</span>, <span class="hljs-number">102</span>]]`,wrap:!1}}),ln=new b({props:{code:"cGFkZGVkX3NlcXVlbmNlcyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>padded_sequences[<span class="hljs-string">&quot;attention_mask&quot;</span>]
[[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>], [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]`,wrap:!1}}),rn=new $({}),hn=new $({}),dn=new $({}),un=new $({}),fn=new $({}),mn=new $({}),gn=new $({}),wn=new $({}),xn=new $({}),kn=new $({}),yn=new $({}),Tn=new $({}),Pn=new $o({props:{id:"d_ixlCubqQw"}}),Mn=new $({}),Sn=new $({}),Hn=new $({}),zn=new $o({props:{id:"H39Z_720T5s"}}),Vn=new $({}),Ln=new $({}),Un=new $({}),Wn=new $({}),Gn=new $({}),Rn=new $({}),Dn=new $({}),Kn=new $({}),ea=new $({}),na=new $({}),sa=new $o({props:{id:"VFp38yj8h3A"}}),ra=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBc2VxdWVuY2UlMjAlM0QlMjAlMjJBJTIwVGl0YW4lMjBSVFglMjBoYXMlMjAyNEdCJTIwb2YlMjBWUkFNJTIy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence = <span class="hljs-string">&quot;A Titan RTX has 24GB of VRAM&quot;</span>`,wrap:!1}}),ia=new b({props:{code:"dG9rZW5pemVkX3NlcXVlbmNlJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuaXplKHNlcXVlbmNlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_sequence = tokenizer.tokenize(sequence)',wrap:!1}}),pa=new b({props:{code:"cHJpbnQodG9rZW5pemVkX3NlcXVlbmNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenized_sequence)
[<span class="hljs-string">&#x27;A&#x27;</span>, <span class="hljs-string">&#x27;Titan&#x27;</span>, <span class="hljs-string">&#x27;R&#x27;</span>, <span class="hljs-string">&#x27;##T&#x27;</span>, <span class="hljs-string">&#x27;##X&#x27;</span>, <span class="hljs-string">&#x27;has&#x27;</span>, <span class="hljs-string">&#x27;24&#x27;</span>, <span class="hljs-string">&#x27;##GB&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;V&#x27;</span>, <span class="hljs-string">&#x27;##RA&#x27;</span>, <span class="hljs-string">&#x27;##M&#x27;</span>]`,wrap:!1}}),ua=new b({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(sequence)',wrap:!1}}),fa=new b({props:{code:"ZW5jb2RlZF9zZXF1ZW5jZSUyMCUzRCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQXByaW50KGVuY29kZWRfc2VxdWVuY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_sequence = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(encoded_sequence)
[<span class="hljs-number">101</span>, <span class="hljs-number">138</span>, <span class="hljs-number">18696</span>, <span class="hljs-number">155</span>, <span class="hljs-number">1942</span>, <span class="hljs-number">3190</span>, <span class="hljs-number">1144</span>, <span class="hljs-number">1572</span>, <span class="hljs-number">13745</span>, <span class="hljs-number">1104</span>, <span class="hljs-number">159</span>, <span class="hljs-number">9664</span>, <span class="hljs-number">2107</span>, <span class="hljs-number">102</span>]`,wrap:!1}}),ga=new b({props:{code:"ZGVjb2RlZF9zZXF1ZW5jZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZW5jb2RlZF9zZXF1ZW5jZSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>decoded_sequence = tokenizer.decode(encoded_sequence)',wrap:!1}}),wa=new b({props:{code:"cHJpbnQoZGVjb2RlZF9zZXF1ZW5jZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(decoded_sequence)
[CLS] A Titan RTX has 24GB of VRAM [SEP]`,wrap:!1}}),xa=new $({}),_a=new $({}),ot=new a1({props:{$$slots:{default:[s1]},$$scope:{ctx:wo}}}),Aa=new $({}),Ea=new $({}),Pa=new $({}),Na=new $({}),Ha=new $({}),qa=new $({}),Va=new $({}),Za=new $({}),Ia=new $({}),Fa=new $({}),Ba=new $({}),Ga=new $({}),Qa=new $({}),Oa=new $({}),ts=new $({}),ss=new $({}),ls=new $({}),os=new $({}),hs=new $({}),ps=new $({}),us=new $({}),fs=new $({}),gs=new $({}),bs=new $({}),_s=new $({}),ys=new $({}),js=new $({}),As=new $({}),Es=new $({}),Ms=new $o({props:{id:"0u3ioSwev3s"}}),Ss=new b({props:{code:"JTIzJTIwJTVCQ0xTJTVEJTIwU0VRVUVOQ0VfQSUyMCU1QlNFUCU1RCUyMFNFUVVFTkNFX0IlMjAlNUJTRVAlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [CLS] SEQUENCE_A [SEP] SEQUENCE_B [SEP]</span>',wrap:!1}}),qs=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBc2VxdWVuY2VfYSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBiYXNlZCUyMGluJTIwTllDJTIyJTBBc2VxdWVuY2VfYiUyMCUzRCUyMCUyMldoZXJlJTIwaXMlMjBIdWdnaW5nRmFjZSUyMGJhc2VkJTNGJTIyJTBBJTBBZW5jb2RlZF9kaWN0JTIwJTNEJTIwdG9rZW5pemVyKHNlcXVlbmNlX2ElMkMlMjBzZXF1ZW5jZV9iKSUwQWRlY29kZWQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGVuY29kZWRfZGljdCU1QiUyMmlucHV0X2lkcyUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_a = <span class="hljs-string">&quot;HuggingFace is based in NYC&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_b = <span class="hljs-string">&quot;Where is HuggingFace based?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dict = tokenizer(sequence_a, sequence_b)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoded = tokenizer.decode(encoded_dict[<span class="hljs-string">&quot;input_ids&quot;</span>])`,wrap:!1}}),Vs=new b({props:{code:"cHJpbnQoZGVjb2RlZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(decoded)
[CLS] HuggingFace <span class="hljs-keyword">is</span> based <span class="hljs-keyword">in</span> NYC [SEP] Where <span class="hljs-keyword">is</span> HuggingFace based? [SEP]`,wrap:!1}}),Us=new b({props:{code:"ZW5jb2RlZF9kaWN0JTVCJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dict[<span class="hljs-string">&quot;token_type_ids&quot;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Js=new $({}),Bs=new $({}),Gs=new $({}),Rs=new $({}),{c(){w=a("meta"),It=i(),x=a("p"),Ds=i(),_=a("h1"),Me=a("a"),or=a("span"),u(Ft.$$.fragment),Vd=i(),Ks=a("span"),Ks.textContent=Xu,bo=i(),Jt=a("p"),Jt.textContent=Gu,xo=i(),k=a("h2"),Ne=a("a"),ir=a("span"),u(Wt.$$.fragment),Ld=i(),Os=a("span"),Os.textContent=Ru,_o=i(),y=a("h3"),Se=a("a"),hr=a("span"),u(Bt.$$.fragment),Zd=i(),el=a("span"),el.textContent=Qu,ko=i(),Xt=a("p"),Xt.textContent=Yu,yo=i(),u(Gt.$$.fragment),Co=i(),Rt=a("p"),Rt.textContent=Du,jo=i(),Qt=a("p"),Qt.textContent=Ku,Ao=i(),u(Yt.$$.fragment),To=i(),Dt=a("p"),Dt.textContent=Ou,Eo=i(),u(Kt.$$.fragment),Po=i(),Ot=a("p"),Ot.textContent=ec,Mo=i(),en=a("p"),en.textContent=tc,No=i(),u(tn.$$.fragment),So=i(),nn=a("p"),nn.textContent=nc,Ho=i(),u(an.$$.fragment),qo=i(),sn=a("p"),sn.innerHTML=ac,zo=i(),u(ln.$$.fragment),Vo=i(),C=a("h3"),He=a("a"),pr=a("span"),u(rn.$$.fragment),Ud=i(),tl=a("span"),tl.textContent=sc,Lo=i(),on=a("p"),on.innerHTML=lc,Zo=i(),j=a("h3"),qe=a("a"),dr=a("span"),u(hn.$$.fragment),Id=i(),nl=a("span"),nl.textContent=rc,Uo=i(),pn=a("p"),pn.innerHTML=oc,Io=i(),A=a("h2"),ze=a("a"),ur=a("span"),u(dn.$$.fragment),Fd=i(),al=a("span"),al.textContent=ic,Fo=i(),T=a("h3"),Ve=a("a"),cr=a("span"),u(un.$$.fragment),Jd=i(),sl=a("span"),sl.textContent=hc,Jo=i(),cn=a("p"),cn.innerHTML=pc,Wo=i(),E=a("h2"),Le=a("a"),fr=a("span"),u(fn.$$.fragment),Wd=i(),ll=a("span"),ll.textContent=dc,Bo=i(),P=a("h3"),Ze=a("a"),mr=a("span"),u(mn.$$.fragment),Bd=i(),rl=a("span"),rl.textContent=uc,Xo=i(),vn=a("p"),vn.textContent=cc,Go=i(),M=a("h3"),Ue=a("a"),vr=a("span"),u(gn.$$.fragment),Xd=i(),ol=a("span"),ol.textContent=fc,Ro=i(),$n=a("p"),$n.innerHTML=mc,Qo=i(),N=a("h3"),Ie=a("a"),gr=a("span"),u(wn.$$.fragment),Gd=i(),il=a("span"),il.textContent=vc,Yo=i(),bn=a("p"),bn.textContent=gc,Do=i(),S=a("h3"),Fe=a("a"),$r=a("span"),u(xn.$$.fragment),Rd=i(),hl=a("span"),hl.textContent=$c,Ko=i(),_n=a("p"),_n.textContent=wc,Oo=i(),H=a("h2"),Je=a("a"),wr=a("span"),u(kn.$$.fragment),Qd=i(),pl=a("span"),pl.textContent=bc,ei=i(),q=a("h3"),We=a("a"),br=a("span"),u(yn.$$.fragment),Yd=i(),dl=a("span"),dl.textContent=xc,ti=i(),Cn=a("p"),Cn.textContent=_c,ni=i(),jn=a("p"),jn.innerHTML=kc,ai=i(),An=a("p"),An.textContent=yc,si=i(),z=a("h3"),Be=a("a"),xr=a("span"),u(Tn.$$.fragment),Dd=i(),ul=a("span"),ul.textContent=Cc,li=i(),En=a("p"),En.textContent=jc,ri=i(),u(Pn.$$.fragment),oi=i(),V=a("h3"),Xe=a("a"),_r=a("span"),u(Mn.$$.fragment),Kd=i(),cl=a("span"),cl.textContent=Ac,ii=i(),Nn=a("p"),Nn.textContent=Tc,hi=i(),L=a("h2"),Ge=a("a"),kr=a("span"),u(Sn.$$.fragment),Od=i(),fl=a("span"),fl.textContent=Ec,pi=i(),Z=a("h3"),Re=a("a"),yr=a("span"),u(Hn.$$.fragment),eu=i(),ml=a("span"),ml.textContent=Pc,di=i(),qn=a("p"),qn.innerHTML=Mc,ui=i(),u(zn.$$.fragment),ci=i(),U=a("h2"),Qe=a("a"),Cr=a("span"),u(Vn.$$.fragment),tu=i(),vl=a("span"),vl.textContent=Nc,fi=i(),I=a("h3"),Ye=a("a"),jr=a("span"),u(Ln.$$.fragment),nu=i(),gl=a("span"),gl.textContent=Sc,mi=i(),Zn=a("p"),Zn.textContent=Hc,vi=i(),F=a("h3"),De=a("a"),Ar=a("span"),u(Un.$$.fragment),au=i(),$l=a("span"),$l.textContent=qc,gi=i(),In=a("p"),In.innerHTML=zc,$i=i(),Fn=a("p"),Fn.innerHTML=Vc,wi=i(),Jn=a("p"),Jn.innerHTML=Lc,bi=i(),J=a("h3"),Ke=a("a"),Tr=a("span"),u(Wn.$$.fragment),su=i(),wl=a("span"),wl.textContent=Zc,xi=i(),Bn=a("p"),Bn.innerHTML=Uc,_i=i(),Xn=a("p"),Xn.innerHTML=Ic,ki=i(),W=a("h2"),Oe=a("a"),Er=a("span"),u(Gn.$$.fragment),lu=i(),bl=a("span"),bl.textContent=Fc,yi=i(),B=a("h3"),et=a("a"),Pr=a("span"),u(Rn.$$.fragment),ru=i(),xl=a("span"),xl.textContent=Jc,Ci=i(),Qn=a("p"),Qn.textContent=Wc,ji=i(),Yn=a("ul"),Yn.innerHTML=Bc,Ai=i(),X=a("h2"),tt=a("a"),Mr=a("span"),u(Dn.$$.fragment),ou=i(),_l=a("span"),_l.textContent=Xc,Ti=i(),G=a("h3"),nt=a("a"),Nr=a("span"),u(Kn.$$.fragment),iu=i(),kl=a("span"),kl.textContent=Gc,Ei=i(),On=a("p"),On.innerHTML=Rc,Pi=i(),R=a("h3"),at=a("a"),Sr=a("span"),u(ea.$$.fragment),hu=i(),yl=a("span"),yl.textContent=Qc,Mi=i(),ta=a("p"),ta.innerHTML=Yc,Ni=i(),Q=a("h3"),st=a("a"),Hr=a("span"),u(na.$$.fragment),pu=i(),Cl=a("span"),Cl.textContent=Dc,Si=i(),aa=a("p"),aa.textContent=Kc,Hi=i(),u(sa.$$.fragment),qi=i(),la=a("p"),la.innerHTML=Oc,zi=i(),u(ra.$$.fragment),Vi=i(),oa=a("p"),oa.textContent=ef,Li=i(),u(ia.$$.fragment),Zi=i(),ha=a("p"),ha.textContent=tf,Ui=i(),u(pa.$$.fragment),Ii=i(),da=a("p"),da.innerHTML=nf,Fi=i(),u(ua.$$.fragment),Ji=i(),ca=a("p"),ca.innerHTML=af,Wi=i(),u(fa.$$.fragment),Bi=i(),ma=a("p"),ma.textContent=sf,Xi=i(),va=a("p"),va.textContent=lf,Gi=i(),u(ga.$$.fragment),Ri=i(),$a=a("p"),$a.textContent=rf,Qi=i(),u(wa.$$.fragment),Yi=i(),ba=a("p"),ba.innerHTML=of,Di=i(),Y=a("h2"),lt=a("a"),qr=a("span"),u(xa.$$.fragment),du=i(),jl=a("span"),jl.textContent=hf,Ki=i(),D=a("h3"),rt=a("a"),zr=a("span"),u(_a.$$.fragment),uu=i(),Al=a("span"),Al.textContent=pf,Oi=i(),ka=a("p"),ka.textContent=df,eh=i(),ya=a("p"),ya.textContent=uf,th=i(),Ca=a("ul"),Ca.innerHTML=cf,nh=i(),u(ot.$$.fragment),ah=i(),ja=a("p"),ja.innerHTML=ff,sh=i(),K=a("h3"),it=a("a"),Vr=a("span"),u(Aa.$$.fragment),cu=i(),Tl=a("span"),Tl.textContent=mf,lh=i(),Ta=a("p"),Ta.textContent=vf,rh=i(),O=a("h2"),ht=a("a"),Lr=a("span"),u(Ea.$$.fragment),fu=i(),El=a("span"),El.textContent=gf,oh=i(),ee=a("h3"),pt=a("a"),Zr=a("span"),u(Pa.$$.fragment),mu=i(),Pl=a("span"),Pl.textContent=$f,ih=i(),Ma=a("p"),Ma.textContent=wf,hh=i(),te=a("h3"),dt=a("a"),Ur=a("span"),u(Na.$$.fragment),vu=i(),Ml=a("span"),Ml.textContent=bf,ph=i(),Sa=a("p"),Sa.textContent=xf,dh=i(),ne=a("h2"),ut=a("a"),Ir=a("span"),u(Ha.$$.fragment),gu=i(),Nl=a("span"),Nl.textContent=_f,uh=i(),ae=a("h3"),ct=a("a"),Fr=a("span"),u(qa.$$.fragment),$u=i(),Sl=a("span"),Sl.textContent=kf,ch=i(),za=a("p"),za.innerHTML=yf,fh=i(),se=a("h3"),ft=a("a"),Jr=a("span"),u(Va.$$.fragment),wu=i(),Hl=a("span"),Hl.textContent=Cf,mh=i(),La=a("p"),La.textContent=jf,vh=i(),le=a("h3"),mt=a("a"),Wr=a("span"),u(Za.$$.fragment),bu=i(),ql=a("span"),ql.textContent=Af,gh=i(),Ua=a("p"),Ua.textContent=Tf,$h=i(),re=a("h2"),vt=a("a"),Br=a("span"),u(Ia.$$.fragment),xu=i(),zl=a("span"),zl.textContent=Ef,wh=i(),oe=a("h3"),gt=a("a"),Xr=a("span"),u(Fa.$$.fragment),_u=i(),Vl=a("span"),Vl.textContent=Pf,bh=i(),Ja=a("p"),Ja.textContent=Mf,xh=i(),Wa=a("p"),Wa.innerHTML=Nf,_h=i(),ie=a("h3"),$t=a("a"),Gr=a("span"),u(Ba.$$.fragment),ku=i(),Ll=a("span"),Ll.textContent=Sf,kh=i(),Xa=a("p"),Xa.innerHTML=Hf,yh=i(),he=a("h3"),wt=a("a"),Rr=a("span"),u(Ga.$$.fragment),yu=i(),Zl=a("span"),Zl.textContent=qf,Ch=i(),Ra=a("p"),Ra.textContent=zf,jh=i(),pe=a("h3"),bt=a("a"),Qr=a("span"),u(Qa.$$.fragment),Cu=i(),Ul=a("span"),Ul.textContent=Vf,Ah=i(),Ya=a("p"),Ya.innerHTML=Lf,Th=i(),Da=a("p"),Da.innerHTML=Zf,Eh=i(),Ka=a("p"),Ka.innerHTML=Uf,Ph=i(),de=a("h3"),xt=a("a"),Yr=a("span"),u(Oa.$$.fragment),ju=i(),Il=a("span"),Il.textContent=If,Mh=i(),es=a("p"),es.innerHTML=Ff,Nh=i(),ue=a("h3"),_t=a("a"),Dr=a("span"),u(ts.$$.fragment),Au=i(),Fl=a("span"),Fl.textContent=Jf,Sh=i(),ns=a("p"),ns.innerHTML=Wf,Hh=i(),as=a("p"),as.textContent=Bf,qh=i(),ce=a("h2"),kt=a("a"),Kr=a("span"),u(ss.$$.fragment),Tu=i(),Jl=a("span"),Jl.textContent=Xf,zh=i(),fe=a("h3"),yt=a("a"),Or=a("span"),u(ls.$$.fragment),Eu=i(),Wl=a("span"),Wl.textContent=Gf,Vh=i(),rs=a("p"),rs.textContent=Rf,Lh=i(),me=a("h3"),Ct=a("a"),eo=a("span"),u(os.$$.fragment),Pu=i(),Bl=a("span"),Bl.textContent=Qf,Zh=i(),is=a("p"),is.textContent=Yf,Uh=i(),ve=a("h2"),jt=a("a"),to=a("span"),u(hs.$$.fragment),Mu=i(),Xl=a("span"),Xl.textContent=Df,Ih=i(),ge=a("h3"),At=a("a"),no=a("span"),u(ps.$$.fragment),Nu=i(),Gl=a("span"),Gl.textContent=Kf,Fh=i(),ds=a("p"),ds.textContent=Of,Jh=i(),$e=a("h3"),Tt=a("a"),ao=a("span"),u(us.$$.fragment),Su=i(),Rl=a("span"),Rl.textContent=em,Wh=i(),cs=a("p"),cs.textContent=tm,Bh=i(),we=a("h3"),Et=a("a"),so=a("span"),u(fs.$$.fragment),Hu=i(),Ql=a("span"),Ql.textContent=nm,Xh=i(),ms=a("p"),ms.innerHTML=am,Gh=i(),vs=a("p"),vs.innerHTML=sm,Rh=i(),be=a("h3"),Pt=a("a"),lo=a("span"),u(gs.$$.fragment),qu=i(),Yl=a("span"),Yl.textContent=lm,Qh=i(),$s=a("p"),$s.innerHTML=rm,Yh=i(),ws=a("p"),ws.textContent=om,Dh=i(),xe=a("h3"),Mt=a("a"),ro=a("span"),u(bs.$$.fragment),zu=i(),Dl=a("span"),Dl.textContent=im,Kh=i(),xs=a("p"),xs.innerHTML=hm,Oh=i(),_e=a("h3"),Nt=a("a"),oo=a("span"),u(_s.$$.fragment),Vu=i(),Kl=a("span"),Kl.textContent=pm,ep=i(),ks=a("p"),ks.innerHTML=dm,tp=i(),ke=a("h3"),St=a("a"),io=a("span"),u(ys.$$.fragment),Lu=i(),Ol=a("span"),Ol.textContent=um,np=i(),Cs=a("p"),Cs.textContent=cm,ap=i(),ye=a("h2"),Ht=a("a"),ho=a("span"),u(js.$$.fragment),Zu=i(),er=a("span"),er.textContent=fm,sp=i(),Ce=a("h3"),qt=a("a"),po=a("span"),u(As.$$.fragment),Uu=i(),tr=a("span"),tr.textContent=mm,lp=i(),Ts=a("p"),Ts.textContent=vm,rp=i(),je=a("h3"),zt=a("a"),uo=a("span"),u(Es.$$.fragment),Iu=i(),nr=a("span"),nr.textContent=gm,op=i(),Ps=a("p"),Ps.textContent=$m,ip=i(),u(Ms.$$.fragment),hp=i(),Ns=a("p"),Ns.innerHTML=wm,pp=i(),u(Ss.$$.fragment),dp=i(),Hs=a("p"),Hs.innerHTML=bm,up=i(),u(qs.$$.fragment),cp=i(),zs=a("p"),zs.textContent=xm,fp=i(),u(Vs.$$.fragment),mp=i(),Ls=a("p"),Ls.textContent=_m,vp=i(),Zs=a("p"),Zs.textContent=km,gp=i(),u(Us.$$.fragment),$p=i(),Is=a("p"),Is.innerHTML=ym,wp=i(),Fs=a("p"),Fs.innerHTML=Cm,bp=i(),Ae=a("h3"),Vt=a("a"),co=a("span"),u(Js.$$.fragment),Fu=i(),ar=a("span"),ar.textContent=jm,xp=i(),Ws=a("p"),Ws.textContent=Am,_p=i(),Te=a("h3"),Lt=a("a"),fo=a("span"),u(Bs.$$.fragment),Ju=i(),sr=a("span"),sr.textContent=Tm,kp=i(),Xs=a("p"),Xs.textContent=Em,yp=i(),Ee=a("h2"),Zt=a("a"),mo=a("span"),u(Gs.$$.fragment),Wu=i(),lr=a("span"),lr.textContent=Pm,Cp=i(),Pe=a("h3"),Ut=a("a"),vo=a("span"),u(Rs.$$.fragment),Bu=i(),rr=a("span"),rr.textContent=Mm,jp=i(),Qs=a("p"),Qs.textContent=Nm,Ap=i(),go=a("p"),this.h()},l(e){const n=n1("svelte-1phssyn",document.head);w=s(n,"META",{name:!0,content:!0}),n.forEach(t),It=h(e),x=s(e,"P",{}),p(x).forEach(t),Ds=h(e),_=s(e,"H1",{class:!0});var Ys=p(_);Me=s(Ys,"A",{id:!0,class:!0,href:!0});var Sm=p(Me);or=s(Sm,"SPAN",{});var Hm=p(or);c(Ft.$$.fragment,Hm),Hm.forEach(t),Sm.forEach(t),Vd=h(Ys),Ks=s(Ys,"SPAN",{"data-svelte-h":!0}),d(Ks)!=="svelte-1uipril"&&(Ks.textContent=Xu),Ys.forEach(t),bo=h(e),Jt=s(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1dvjafk"&&(Jt.textContent=Gu),xo=h(e),k=s(e,"H2",{class:!0});var Ep=p(k);Ne=s(Ep,"A",{id:!0,class:!0,href:!0});var qm=p(Ne);ir=s(qm,"SPAN",{});var zm=p(ir);c(Wt.$$.fragment,zm),zm.forEach(t),qm.forEach(t),Ld=h(Ep),Os=s(Ep,"SPAN",{"data-svelte-h":!0}),d(Os)!=="svelte-10m1sog"&&(Os.textContent=Ru),Ep.forEach(t),_o=h(e),y=s(e,"H3",{class:!0});var Pp=p(y);Se=s(Pp,"A",{id:!0,class:!0,href:!0});var Vm=p(Se);hr=s(Vm,"SPAN",{});var Lm=p(hr);c(Bt.$$.fragment,Lm),Lm.forEach(t),Vm.forEach(t),Zd=h(Pp),el=s(Pp,"SPAN",{"data-svelte-h":!0}),d(el)!=="svelte-1a6z2on"&&(el.textContent=Qu),Pp.forEach(t),ko=h(e),Xt=s(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-zageh2"&&(Xt.textContent=Yu),yo=h(e),c(Gt.$$.fragment,e),Co=h(e),Rt=s(e,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-16bi7cp"&&(Rt.textContent=Du),jo=h(e),Qt=s(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1s3smvj"&&(Qt.textContent=Ku),Ao=h(e),c(Yt.$$.fragment,e),To=h(e),Dt=s(e,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-xx5dsm"&&(Dt.textContent=Ou),Eo=h(e),c(Kt.$$.fragment,e),Po=h(e),Ot=s(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-mhr0gb"&&(Ot.textContent=ec),Mo=h(e),en=s(e,"P",{"data-svelte-h":!0}),d(en)!=="svelte-zbn0tl"&&(en.textContent=tc),No=h(e),c(tn.$$.fragment,e),So=h(e),nn=s(e,"P",{"data-svelte-h":!0}),d(nn)!=="svelte-1lmyquq"&&(nn.textContent=nc),Ho=h(e),c(an.$$.fragment,e),qo=h(e),sn=s(e,"P",{"data-svelte-h":!0}),d(sn)!=="svelte-13y6qem"&&(sn.innerHTML=ac),zo=h(e),c(ln.$$.fragment,e),Vo=h(e),C=s(e,"H3",{class:!0});var Mp=p(C);He=s(Mp,"A",{id:!0,class:!0,href:!0});var Zm=p(He);pr=s(Zm,"SPAN",{});var Um=p(pr);c(rn.$$.fragment,Um),Um.forEach(t),Zm.forEach(t),Ud=h(Mp),tl=s(Mp,"SPAN",{"data-svelte-h":!0}),d(tl)!=="svelte-yqmb5z"&&(tl.textContent=sc),Mp.forEach(t),Lo=h(e),on=s(e,"P",{"data-svelte-h":!0}),d(on)!=="svelte-1oazoau"&&(on.innerHTML=lc),Zo=h(e),j=s(e,"H3",{class:!0});var Np=p(j);qe=s(Np,"A",{id:!0,class:!0,href:!0});var Im=p(qe);dr=s(Im,"SPAN",{});var Fm=p(dr);c(hn.$$.fragment,Fm),Fm.forEach(t),Im.forEach(t),Id=h(Np),nl=s(Np,"SPAN",{"data-svelte-h":!0}),d(nl)!=="svelte-1gfejiv"&&(nl.textContent=rc),Np.forEach(t),Uo=h(e),pn=s(e,"P",{"data-svelte-h":!0}),d(pn)!=="svelte-rond5"&&(pn.innerHTML=oc),Io=h(e),A=s(e,"H2",{class:!0});var Sp=p(A);ze=s(Sp,"A",{id:!0,class:!0,href:!0});var Jm=p(ze);ur=s(Jm,"SPAN",{});var Wm=p(ur);c(dn.$$.fragment,Wm),Wm.forEach(t),Jm.forEach(t),Fd=h(Sp),al=s(Sp,"SPAN",{"data-svelte-h":!0}),d(al)!=="svelte-cf76mt"&&(al.textContent=ic),Sp.forEach(t),Fo=h(e),T=s(e,"H3",{class:!0});var Hp=p(T);Ve=s(Hp,"A",{id:!0,class:!0,href:!0});var Bm=p(Ve);cr=s(Bm,"SPAN",{});var Xm=p(cr);c(un.$$.fragment,Xm),Xm.forEach(t),Bm.forEach(t),Jd=h(Hp),sl=s(Hp,"SPAN",{"data-svelte-h":!0}),d(sl)!=="svelte-hfj3pa"&&(sl.textContent=hc),Hp.forEach(t),Jo=h(e),cn=s(e,"P",{"data-svelte-h":!0}),d(cn)!=="svelte-1l6rcnz"&&(cn.innerHTML=pc),Wo=h(e),E=s(e,"H2",{class:!0});var qp=p(E);Le=s(qp,"A",{id:!0,class:!0,href:!0});var Gm=p(Le);fr=s(Gm,"SPAN",{});var Rm=p(fr);c(fn.$$.fragment,Rm),Rm.forEach(t),Gm.forEach(t),Wd=h(qp),ll=s(qp,"SPAN",{"data-svelte-h":!0}),d(ll)!=="svelte-1fiqomy"&&(ll.textContent=dc),qp.forEach(t),Bo=h(e),P=s(e,"H3",{class:!0});var zp=p(P);Ze=s(zp,"A",{id:!0,class:!0,href:!0});var Qm=p(Ze);mr=s(Qm,"SPAN",{});var Ym=p(mr);c(mn.$$.fragment,Ym),Ym.forEach(t),Qm.forEach(t),Bd=h(zp),rl=s(zp,"SPAN",{"data-svelte-h":!0}),d(rl)!=="svelte-rt542h"&&(rl.textContent=uc),zp.forEach(t),Xo=h(e),vn=s(e,"P",{"data-svelte-h":!0}),d(vn)!=="svelte-1l74vbi"&&(vn.textContent=cc),Go=h(e),M=s(e,"H3",{class:!0});var Vp=p(M);Ue=s(Vp,"A",{id:!0,class:!0,href:!0});var Dm=p(Ue);vr=s(Dm,"SPAN",{});var Km=p(vr);c(gn.$$.fragment,Km),Km.forEach(t),Dm.forEach(t),Xd=h(Vp),ol=s(Vp,"SPAN",{"data-svelte-h":!0}),d(ol)!=="svelte-1rtpzco"&&(ol.textContent=fc),Vp.forEach(t),Ro=h(e),$n=s(e,"P",{"data-svelte-h":!0}),d($n)!=="svelte-ltn37x"&&($n.innerHTML=mc),Qo=h(e),N=s(e,"H3",{class:!0});var Lp=p(N);Ie=s(Lp,"A",{id:!0,class:!0,href:!0});var Om=p(Ie);gr=s(Om,"SPAN",{});var ev=p(gr);c(wn.$$.fragment,ev),ev.forEach(t),Om.forEach(t),Gd=h(Lp),il=s(Lp,"SPAN",{"data-svelte-h":!0}),d(il)!=="svelte-ztate"&&(il.textContent=vc),Lp.forEach(t),Yo=h(e),bn=s(e,"P",{"data-svelte-h":!0}),d(bn)!=="svelte-1fbuf3j"&&(bn.textContent=gc),Do=h(e),S=s(e,"H3",{class:!0});var Zp=p(S);Fe=s(Zp,"A",{id:!0,class:!0,href:!0});var tv=p(Fe);$r=s(tv,"SPAN",{});var nv=p($r);c(xn.$$.fragment,nv),nv.forEach(t),tv.forEach(t),Rd=h(Zp),hl=s(Zp,"SPAN",{"data-svelte-h":!0}),d(hl)!=="svelte-ki4x31"&&(hl.textContent=$c),Zp.forEach(t),Ko=h(e),_n=s(e,"P",{"data-svelte-h":!0}),d(_n)!=="svelte-1ld4khv"&&(_n.textContent=wc),Oo=h(e),H=s(e,"H2",{class:!0});var Up=p(H);Je=s(Up,"A",{id:!0,class:!0,href:!0});var av=p(Je);wr=s(av,"SPAN",{});var sv=p(wr);c(kn.$$.fragment,sv),sv.forEach(t),av.forEach(t),Qd=h(Up),pl=s(Up,"SPAN",{"data-svelte-h":!0}),d(pl)!=="svelte-rbw2dz"&&(pl.textContent=bc),Up.forEach(t),ei=h(e),q=s(e,"H3",{class:!0});var Ip=p(q);We=s(Ip,"A",{id:!0,class:!0,href:!0});var lv=p(We);br=s(lv,"SPAN",{});var rv=p(br);c(yn.$$.fragment,rv),rv.forEach(t),lv.forEach(t),Yd=h(Ip),dl=s(Ip,"SPAN",{"data-svelte-h":!0}),d(dl)!=="svelte-piufod"&&(dl.textContent=xc),Ip.forEach(t),ti=h(e),Cn=s(e,"P",{"data-svelte-h":!0}),d(Cn)!=="svelte-10vz57"&&(Cn.textContent=_c),ni=h(e),jn=s(e,"P",{"data-svelte-h":!0}),d(jn)!=="svelte-1v396xu"&&(jn.innerHTML=kc),ai=h(e),An=s(e,"P",{"data-svelte-h":!0}),d(An)!=="svelte-ssnlyg"&&(An.textContent=yc),si=h(e),z=s(e,"H3",{class:!0});var Fp=p(z);Be=s(Fp,"A",{id:!0,class:!0,href:!0});var ov=p(Be);xr=s(ov,"SPAN",{});var iv=p(xr);c(Tn.$$.fragment,iv),iv.forEach(t),ov.forEach(t),Dd=h(Fp),ul=s(Fp,"SPAN",{"data-svelte-h":!0}),d(ul)!=="svelte-111ylwz"&&(ul.textContent=Cc),Fp.forEach(t),li=h(e),En=s(e,"P",{"data-svelte-h":!0}),d(En)!=="svelte-1ur5avw"&&(En.textContent=jc),ri=h(e),c(Pn.$$.fragment,e),oi=h(e),V=s(e,"H3",{class:!0});var Jp=p(V);Xe=s(Jp,"A",{id:!0,class:!0,href:!0});var hv=p(Xe);_r=s(hv,"SPAN",{});var pv=p(_r);c(Mn.$$.fragment,pv),pv.forEach(t),hv.forEach(t),Kd=h(Jp),cl=s(Jp,"SPAN",{"data-svelte-h":!0}),d(cl)!=="svelte-1to6og0"&&(cl.textContent=Ac),Jp.forEach(t),ii=h(e),Nn=s(e,"P",{"data-svelte-h":!0}),d(Nn)!=="svelte-1fczmsm"&&(Nn.textContent=Tc),hi=h(e),L=s(e,"H2",{class:!0});var Wp=p(L);Ge=s(Wp,"A",{id:!0,class:!0,href:!0});var dv=p(Ge);kr=s(dv,"SPAN",{});var uv=p(kr);c(Sn.$$.fragment,uv),uv.forEach(t),dv.forEach(t),Od=h(Wp),fl=s(Wp,"SPAN",{"data-svelte-h":!0}),d(fl)!=="svelte-gmc0yk"&&(fl.textContent=Ec),Wp.forEach(t),pi=h(e),Z=s(e,"H3",{class:!0});var Bp=p(Z);Re=s(Bp,"A",{id:!0,class:!0,href:!0});var cv=p(Re);yr=s(cv,"SPAN",{});var fv=p(yr);c(Hn.$$.fragment,fv),fv.forEach(t),cv.forEach(t),eu=h(Bp),ml=s(Bp,"SPAN",{"data-svelte-h":!0}),d(ml)!=="svelte-vwguqz"&&(ml.textContent=Pc),Bp.forEach(t),di=h(e),qn=s(e,"P",{"data-svelte-h":!0}),d(qn)!=="svelte-jzdlbw"&&(qn.innerHTML=Mc),ui=h(e),c(zn.$$.fragment,e),ci=h(e),U=s(e,"H2",{class:!0});var Xp=p(U);Qe=s(Xp,"A",{id:!0,class:!0,href:!0});var mv=p(Qe);Cr=s(mv,"SPAN",{});var vv=p(Cr);c(Vn.$$.fragment,vv),vv.forEach(t),mv.forEach(t),tu=h(Xp),vl=s(Xp,"SPAN",{"data-svelte-h":!0}),d(vl)!=="svelte-tbxohd"&&(vl.textContent=Nc),Xp.forEach(t),fi=h(e),I=s(e,"H3",{class:!0});var Gp=p(I);Ye=s(Gp,"A",{id:!0,class:!0,href:!0});var gv=p(Ye);jr=s(gv,"SPAN",{});var $v=p(jr);c(Ln.$$.fragment,$v),$v.forEach(t),gv.forEach(t),nu=h(Gp),gl=s(Gp,"SPAN",{"data-svelte-h":!0}),d(gl)!=="svelte-11ihpm4"&&(gl.textContent=Sc),Gp.forEach(t),mi=h(e),Zn=s(e,"P",{"data-svelte-h":!0}),d(Zn)!=="svelte-14m2s4w"&&(Zn.textContent=Hc),vi=h(e),F=s(e,"H3",{class:!0});var Rp=p(F);De=s(Rp,"A",{id:!0,class:!0,href:!0});var wv=p(De);Ar=s(wv,"SPAN",{});var bv=p(Ar);c(Un.$$.fragment,bv),bv.forEach(t),wv.forEach(t),au=h(Rp),$l=s(Rp,"SPAN",{"data-svelte-h":!0}),d($l)!=="svelte-1t65e5v"&&($l.textContent=qc),Rp.forEach(t),gi=h(e),In=s(e,"P",{"data-svelte-h":!0}),d(In)!=="svelte-1tiu5po"&&(In.innerHTML=zc),$i=h(e),Fn=s(e,"P",{"data-svelte-h":!0}),d(Fn)!=="svelte-1xp8jp0"&&(Fn.innerHTML=Vc),wi=h(e),Jn=s(e,"P",{"data-svelte-h":!0}),d(Jn)!=="svelte-eudh23"&&(Jn.innerHTML=Lc),bi=h(e),J=s(e,"H3",{class:!0});var Qp=p(J);Ke=s(Qp,"A",{id:!0,class:!0,href:!0});var xv=p(Ke);Tr=s(xv,"SPAN",{});var _v=p(Tr);c(Wn.$$.fragment,_v),_v.forEach(t),xv.forEach(t),su=h(Qp),wl=s(Qp,"SPAN",{"data-svelte-h":!0}),d(wl)!=="svelte-uv68vx"&&(wl.textContent=Zc),Qp.forEach(t),xi=h(e),Bn=s(e,"P",{"data-svelte-h":!0}),d(Bn)!=="svelte-192shka"&&(Bn.innerHTML=Uc),_i=h(e),Xn=s(e,"P",{"data-svelte-h":!0}),d(Xn)!=="svelte-1gtjz9f"&&(Xn.innerHTML=Ic),ki=h(e),W=s(e,"H2",{class:!0});var Yp=p(W);Oe=s(Yp,"A",{id:!0,class:!0,href:!0});var kv=p(Oe);Er=s(kv,"SPAN",{});var yv=p(Er);c(Gn.$$.fragment,yv),yv.forEach(t),kv.forEach(t),lu=h(Yp),bl=s(Yp,"SPAN",{"data-svelte-h":!0}),d(bl)!=="svelte-a56n43"&&(bl.textContent=Fc),Yp.forEach(t),yi=h(e),B=s(e,"H3",{class:!0});var Dp=p(B);et=s(Dp,"A",{id:!0,class:!0,href:!0});var Cv=p(et);Pr=s(Cv,"SPAN",{});var jv=p(Pr);c(Rn.$$.fragment,jv),jv.forEach(t),Cv.forEach(t),ru=h(Dp),xl=s(Dp,"SPAN",{"data-svelte-h":!0}),d(xl)!=="svelte-8g2e97"&&(xl.textContent=Jc),Dp.forEach(t),Ci=h(e),Qn=s(e,"P",{"data-svelte-h":!0}),d(Qn)!=="svelte-1espo04"&&(Qn.textContent=Wc),ji=h(e),Yn=s(e,"UL",{"data-svelte-h":!0}),d(Yn)!=="svelte-1whg88x"&&(Yn.innerHTML=Bc),Ai=h(e),X=s(e,"H2",{class:!0});var Kp=p(X);tt=s(Kp,"A",{id:!0,class:!0,href:!0});var Av=p(tt);Mr=s(Av,"SPAN",{});var Tv=p(Mr);c(Dn.$$.fragment,Tv),Tv.forEach(t),Av.forEach(t),ou=h(Kp),_l=s(Kp,"SPAN",{"data-svelte-h":!0}),d(_l)!=="svelte-1e5b988"&&(_l.textContent=Xc),Kp.forEach(t),Ti=h(e),G=s(e,"H3",{class:!0});var Op=p(G);nt=s(Op,"A",{id:!0,class:!0,href:!0});var Ev=p(nt);Nr=s(Ev,"SPAN",{});var Pv=p(Nr);c(Kn.$$.fragment,Pv),Pv.forEach(t),Ev.forEach(t),iu=h(Op),kl=s(Op,"SPAN",{"data-svelte-h":!0}),d(kl)!=="svelte-pbv89k"&&(kl.textContent=Gc),Op.forEach(t),Ei=h(e),On=s(e,"P",{"data-svelte-h":!0}),d(On)!=="svelte-1mw8vlz"&&(On.innerHTML=Rc),Pi=h(e),R=s(e,"H3",{class:!0});var ed=p(R);at=s(ed,"A",{id:!0,class:!0,href:!0});var Mv=p(at);Sr=s(Mv,"SPAN",{});var Nv=p(Sr);c(ea.$$.fragment,Nv),Nv.forEach(t),Mv.forEach(t),hu=h(ed),yl=s(ed,"SPAN",{"data-svelte-h":!0}),d(yl)!=="svelte-15q2hp8"&&(yl.textContent=Qc),ed.forEach(t),Mi=h(e),ta=s(e,"P",{"data-svelte-h":!0}),d(ta)!=="svelte-17c2u3c"&&(ta.innerHTML=Yc),Ni=h(e),Q=s(e,"H3",{class:!0});var td=p(Q);st=s(td,"A",{id:!0,class:!0,href:!0});var Sv=p(st);Hr=s(Sv,"SPAN",{});var Hv=p(Hr);c(na.$$.fragment,Hv),Hv.forEach(t),Sv.forEach(t),pu=h(td),Cl=s(td,"SPAN",{"data-svelte-h":!0}),d(Cl)!=="svelte-y9ft7t"&&(Cl.textContent=Dc),td.forEach(t),Si=h(e),aa=s(e,"P",{"data-svelte-h":!0}),d(aa)!=="svelte-1jkg17q"&&(aa.textContent=Kc),Hi=h(e),c(sa.$$.fragment,e),qi=h(e),la=s(e,"P",{"data-svelte-h":!0}),d(la)!=="svelte-f3pbty"&&(la.innerHTML=Oc),zi=h(e),c(ra.$$.fragment,e),Vi=h(e),oa=s(e,"P",{"data-svelte-h":!0}),d(oa)!=="svelte-1k2pdza"&&(oa.textContent=ef),Li=h(e),c(ia.$$.fragment,e),Zi=h(e),ha=s(e,"P",{"data-svelte-h":!0}),d(ha)!=="svelte-1439yqx"&&(ha.textContent=tf),Ui=h(e),c(pa.$$.fragment,e),Ii=h(e),da=s(e,"P",{"data-svelte-h":!0}),d(da)!=="svelte-uymx78"&&(da.innerHTML=nf),Fi=h(e),c(ua.$$.fragment,e),Ji=h(e),ca=s(e,"P",{"data-svelte-h":!0}),d(ca)!=="svelte-1dyjpha"&&(ca.innerHTML=af),Wi=h(e),c(fa.$$.fragment,e),Bi=h(e),ma=s(e,"P",{"data-svelte-h":!0}),d(ma)!=="svelte-we66x9"&&(ma.textContent=sf),Xi=h(e),va=s(e,"P",{"data-svelte-h":!0}),d(va)!=="svelte-by6kqv"&&(va.textContent=lf),Gi=h(e),c(ga.$$.fragment,e),Ri=h(e),$a=s(e,"P",{"data-svelte-h":!0}),d($a)!=="svelte-1ojjtj3"&&($a.textContent=rf),Qi=h(e),c(wa.$$.fragment,e),Yi=h(e),ba=s(e,"P",{"data-svelte-h":!0}),d(ba)!=="svelte-i8s5u4"&&(ba.innerHTML=of),Di=h(e),Y=s(e,"H2",{class:!0});var nd=p(Y);lt=s(nd,"A",{id:!0,class:!0,href:!0});var qv=p(lt);qr=s(qv,"SPAN",{});var zv=p(qr);c(xa.$$.fragment,zv),zv.forEach(t),qv.forEach(t),du=h(nd),jl=s(nd,"SPAN",{"data-svelte-h":!0}),d(jl)!=="svelte-14v5ixr"&&(jl.textContent=hf),nd.forEach(t),Ki=h(e),D=s(e,"H3",{class:!0});var ad=p(D);rt=s(ad,"A",{id:!0,class:!0,href:!0});var Vv=p(rt);zr=s(Vv,"SPAN",{});var Lv=p(zr);c(_a.$$.fragment,Lv),Lv.forEach(t),Vv.forEach(t),uu=h(ad),Al=s(ad,"SPAN",{"data-svelte-h":!0}),d(Al)!=="svelte-fz2yhc"&&(Al.textContent=pf),ad.forEach(t),Oi=h(e),ka=s(e,"P",{"data-svelte-h":!0}),d(ka)!=="svelte-7ywmff"&&(ka.textContent=df),eh=h(e),ya=s(e,"P",{"data-svelte-h":!0}),d(ya)!=="svelte-psjost"&&(ya.textContent=uf),th=h(e),Ca=s(e,"UL",{"data-svelte-h":!0}),d(Ca)!=="svelte-wd4xnk"&&(Ca.innerHTML=cf),nh=h(e),c(ot.$$.fragment,e),ah=h(e),ja=s(e,"P",{"data-svelte-h":!0}),d(ja)!=="svelte-19d5fjs"&&(ja.innerHTML=ff),sh=h(e),K=s(e,"H3",{class:!0});var sd=p(K);it=s(sd,"A",{id:!0,class:!0,href:!0});var Zv=p(it);Vr=s(Zv,"SPAN",{});var Uv=p(Vr);c(Aa.$$.fragment,Uv),Uv.forEach(t),Zv.forEach(t),cu=h(sd),Tl=s(sd,"SPAN",{"data-svelte-h":!0}),d(Tl)!=="svelte-vkw32"&&(Tl.textContent=mf),sd.forEach(t),lh=h(e),Ta=s(e,"P",{"data-svelte-h":!0}),d(Ta)!=="svelte-1vm9qc5"&&(Ta.textContent=vf),rh=h(e),O=s(e,"H2",{class:!0});var ld=p(O);ht=s(ld,"A",{id:!0,class:!0,href:!0});var Iv=p(ht);Lr=s(Iv,"SPAN",{});var Fv=p(Lr);c(Ea.$$.fragment,Fv),Fv.forEach(t),Iv.forEach(t),fu=h(ld),El=s(ld,"SPAN",{"data-svelte-h":!0}),d(El)!=="svelte-14gc5qc"&&(El.textContent=gf),ld.forEach(t),oh=h(e),ee=s(e,"H3",{class:!0});var rd=p(ee);pt=s(rd,"A",{id:!0,class:!0,href:!0});var Jv=p(pt);Zr=s(Jv,"SPAN",{});var Wv=p(Zr);c(Pa.$$.fragment,Wv),Wv.forEach(t),Jv.forEach(t),mu=h(rd),Pl=s(rd,"SPAN",{"data-svelte-h":!0}),d(Pl)!=="svelte-1ilzsck"&&(Pl.textContent=$f),rd.forEach(t),ih=h(e),Ma=s(e,"P",{"data-svelte-h":!0}),d(Ma)!=="svelte-1kgpofh"&&(Ma.textContent=wf),hh=h(e),te=s(e,"H3",{class:!0});var od=p(te);dt=s(od,"A",{id:!0,class:!0,href:!0});var Bv=p(dt);Ur=s(Bv,"SPAN",{});var Xv=p(Ur);c(Na.$$.fragment,Xv),Xv.forEach(t),Bv.forEach(t),vu=h(od),Ml=s(od,"SPAN",{"data-svelte-h":!0}),d(Ml)!=="svelte-ehvgmz"&&(Ml.textContent=bf),od.forEach(t),ph=h(e),Sa=s(e,"P",{"data-svelte-h":!0}),d(Sa)!=="svelte-me9jqn"&&(Sa.textContent=xf),dh=h(e),ne=s(e,"H2",{class:!0});var id=p(ne);ut=s(id,"A",{id:!0,class:!0,href:!0});var Gv=p(ut);Ir=s(Gv,"SPAN",{});var Rv=p(Ir);c(Ha.$$.fragment,Rv),Rv.forEach(t),Gv.forEach(t),gu=h(id),Nl=s(id,"SPAN",{"data-svelte-h":!0}),d(Nl)!=="svelte-16v7u8p"&&(Nl.textContent=_f),id.forEach(t),uh=h(e),ae=s(e,"H3",{class:!0});var hd=p(ae);ct=s(hd,"A",{id:!0,class:!0,href:!0});var Qv=p(ct);Fr=s(Qv,"SPAN",{});var Yv=p(Fr);c(qa.$$.fragment,Yv),Yv.forEach(t),Qv.forEach(t),$u=h(hd),Sl=s(hd,"SPAN",{"data-svelte-h":!0}),d(Sl)!=="svelte-1bsn48"&&(Sl.textContent=kf),hd.forEach(t),ch=h(e),za=s(e,"P",{"data-svelte-h":!0}),d(za)!=="svelte-1lci4tz"&&(za.innerHTML=yf),fh=h(e),se=s(e,"H3",{class:!0});var pd=p(se);ft=s(pd,"A",{id:!0,class:!0,href:!0});var Dv=p(ft);Jr=s(Dv,"SPAN",{});var Kv=p(Jr);c(Va.$$.fragment,Kv),Kv.forEach(t),Dv.forEach(t),wu=h(pd),Hl=s(pd,"SPAN",{"data-svelte-h":!0}),d(Hl)!=="svelte-134l1nm"&&(Hl.textContent=Cf),pd.forEach(t),mh=h(e),La=s(e,"P",{"data-svelte-h":!0}),d(La)!=="svelte-1xw03f6"&&(La.textContent=jf),vh=h(e),le=s(e,"H3",{class:!0});var dd=p(le);mt=s(dd,"A",{id:!0,class:!0,href:!0});var Ov=p(mt);Wr=s(Ov,"SPAN",{});var eg=p(Wr);c(Za.$$.fragment,eg),eg.forEach(t),Ov.forEach(t),bu=h(dd),ql=s(dd,"SPAN",{"data-svelte-h":!0}),d(ql)!=="svelte-18b0iwg"&&(ql.textContent=Af),dd.forEach(t),gh=h(e),Ua=s(e,"P",{"data-svelte-h":!0}),d(Ua)!=="svelte-jloa1o"&&(Ua.textContent=Tf),$h=h(e),re=s(e,"H2",{class:!0});var ud=p(re);vt=s(ud,"A",{id:!0,class:!0,href:!0});var tg=p(vt);Br=s(tg,"SPAN",{});var ng=p(Br);c(Ia.$$.fragment,ng),ng.forEach(t),tg.forEach(t),xu=h(ud),zl=s(ud,"SPAN",{"data-svelte-h":!0}),d(zl)!=="svelte-sllaq3"&&(zl.textContent=Ef),ud.forEach(t),wh=h(e),oe=s(e,"H3",{class:!0});var cd=p(oe);gt=s(cd,"A",{id:!0,class:!0,href:!0});var ag=p(gt);Xr=s(ag,"SPAN",{});var sg=p(Xr);c(Fa.$$.fragment,sg),sg.forEach(t),ag.forEach(t),_u=h(cd),Vl=s(cd,"SPAN",{"data-svelte-h":!0}),d(Vl)!=="svelte-1dz39qj"&&(Vl.textContent=Pf),cd.forEach(t),bh=h(e),Ja=s(e,"P",{"data-svelte-h":!0}),d(Ja)!=="svelte-11425z2"&&(Ja.textContent=Mf),xh=h(e),Wa=s(e,"P",{"data-svelte-h":!0}),d(Wa)!=="svelte-d7g64p"&&(Wa.innerHTML=Nf),_h=h(e),ie=s(e,"H3",{class:!0});var fd=p(ie);$t=s(fd,"A",{id:!0,class:!0,href:!0});var lg=p($t);Gr=s(lg,"SPAN",{});var rg=p(Gr);c(Ba.$$.fragment,rg),rg.forEach(t),lg.forEach(t),ku=h(fd),Ll=s(fd,"SPAN",{"data-svelte-h":!0}),d(Ll)!=="svelte-1bbupqr"&&(Ll.textContent=Sf),fd.forEach(t),kh=h(e),Xa=s(e,"P",{"data-svelte-h":!0}),d(Xa)!=="svelte-1kebnp7"&&(Xa.innerHTML=Hf),yh=h(e),he=s(e,"H3",{class:!0});var md=p(he);wt=s(md,"A",{id:!0,class:!0,href:!0});var og=p(wt);Rr=s(og,"SPAN",{});var ig=p(Rr);c(Ga.$$.fragment,ig),ig.forEach(t),og.forEach(t),yu=h(md),Zl=s(md,"SPAN",{"data-svelte-h":!0}),d(Zl)!=="svelte-1k27ni1"&&(Zl.textContent=qf),md.forEach(t),Ch=h(e),Ra=s(e,"P",{"data-svelte-h":!0}),d(Ra)!=="svelte-1r6n0wg"&&(Ra.textContent=zf),jh=h(e),pe=s(e,"H3",{class:!0});var vd=p(pe);bt=s(vd,"A",{id:!0,class:!0,href:!0});var hg=p(bt);Qr=s(hg,"SPAN",{});var pg=p(Qr);c(Qa.$$.fragment,pg),pg.forEach(t),hg.forEach(t),Cu=h(vd),Ul=s(vd,"SPAN",{"data-svelte-h":!0}),d(Ul)!=="svelte-18zsdum"&&(Ul.textContent=Vf),vd.forEach(t),Ah=h(e),Ya=s(e,"P",{"data-svelte-h":!0}),d(Ya)!=="svelte-igup9t"&&(Ya.innerHTML=Lf),Th=h(e),Da=s(e,"P",{"data-svelte-h":!0}),d(Da)!=="svelte-11pr6r1"&&(Da.innerHTML=Zf),Eh=h(e),Ka=s(e,"P",{"data-svelte-h":!0}),d(Ka)!=="svelte-1ytbypv"&&(Ka.innerHTML=Uf),Ph=h(e),de=s(e,"H3",{class:!0});var gd=p(de);xt=s(gd,"A",{id:!0,class:!0,href:!0});var dg=p(xt);Yr=s(dg,"SPAN",{});var ug=p(Yr);c(Oa.$$.fragment,ug),ug.forEach(t),dg.forEach(t),ju=h(gd),Il=s(gd,"SPAN",{"data-svelte-h":!0}),d(Il)!=="svelte-a4gzch"&&(Il.textContent=If),gd.forEach(t),Mh=h(e),es=s(e,"P",{"data-svelte-h":!0}),d(es)!=="svelte-f3comh"&&(es.innerHTML=Ff),Nh=h(e),ue=s(e,"H3",{class:!0});var $d=p(ue);_t=s($d,"A",{id:!0,class:!0,href:!0});var cg=p(_t);Dr=s(cg,"SPAN",{});var fg=p(Dr);c(ts.$$.fragment,fg),fg.forEach(t),cg.forEach(t),Au=h($d),Fl=s($d,"SPAN",{"data-svelte-h":!0}),d(Fl)!=="svelte-1nfd652"&&(Fl.textContent=Jf),$d.forEach(t),Sh=h(e),ns=s(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-k4gwb8"&&(ns.innerHTML=Wf),Hh=h(e),as=s(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-1izmrh5"&&(as.textContent=Bf),qh=h(e),ce=s(e,"H2",{class:!0});var wd=p(ce);kt=s(wd,"A",{id:!0,class:!0,href:!0});var mg=p(kt);Kr=s(mg,"SPAN",{});var vg=p(Kr);c(ss.$$.fragment,vg),vg.forEach(t),mg.forEach(t),Tu=h(wd),Jl=s(wd,"SPAN",{"data-svelte-h":!0}),d(Jl)!=="svelte-gav6th"&&(Jl.textContent=Xf),wd.forEach(t),zh=h(e),fe=s(e,"H3",{class:!0});var bd=p(fe);yt=s(bd,"A",{id:!0,class:!0,href:!0});var gg=p(yt);Or=s(gg,"SPAN",{});var $g=p(Or);c(ls.$$.fragment,$g),$g.forEach(t),gg.forEach(t),Eu=h(bd),Wl=s(bd,"SPAN",{"data-svelte-h":!0}),d(Wl)!=="svelte-gqq5xv"&&(Wl.textContent=Gf),bd.forEach(t),Vh=h(e),rs=s(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-1mx2xgz"&&(rs.textContent=Rf),Lh=h(e),me=s(e,"H3",{class:!0});var xd=p(me);Ct=s(xd,"A",{id:!0,class:!0,href:!0});var wg=p(Ct);eo=s(wg,"SPAN",{});var bg=p(eo);c(os.$$.fragment,bg),bg.forEach(t),wg.forEach(t),Pu=h(xd),Bl=s(xd,"SPAN",{"data-svelte-h":!0}),d(Bl)!=="svelte-19j4rbu"&&(Bl.textContent=Qf),xd.forEach(t),Zh=h(e),is=s(e,"P",{"data-svelte-h":!0}),d(is)!=="svelte-161935m"&&(is.textContent=Yf),Uh=h(e),ve=s(e,"H2",{class:!0});var _d=p(ve);jt=s(_d,"A",{id:!0,class:!0,href:!0});var xg=p(jt);to=s(xg,"SPAN",{});var _g=p(to);c(hs.$$.fragment,_g),_g.forEach(t),xg.forEach(t),Mu=h(_d),Xl=s(_d,"SPAN",{"data-svelte-h":!0}),d(Xl)!=="svelte-1jeeotm"&&(Xl.textContent=Df),_d.forEach(t),Ih=h(e),ge=s(e,"H3",{class:!0});var kd=p(ge);At=s(kd,"A",{id:!0,class:!0,href:!0});var kg=p(At);no=s(kg,"SPAN",{});var yg=p(no);c(ps.$$.fragment,yg),yg.forEach(t),kg.forEach(t),Nu=h(kd),Gl=s(kd,"SPAN",{"data-svelte-h":!0}),d(Gl)!=="svelte-1el320y"&&(Gl.textContent=Kf),kd.forEach(t),Fh=h(e),ds=s(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-1lulygn"&&(ds.textContent=Of),Jh=h(e),$e=s(e,"H3",{class:!0});var yd=p($e);Tt=s(yd,"A",{id:!0,class:!0,href:!0});var Cg=p(Tt);ao=s(Cg,"SPAN",{});var jg=p(ao);c(us.$$.fragment,jg),jg.forEach(t),Cg.forEach(t),Su=h(yd),Rl=s(yd,"SPAN",{"data-svelte-h":!0}),d(Rl)!=="svelte-4leln6"&&(Rl.textContent=em),yd.forEach(t),Wh=h(e),cs=s(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-7tevil"&&(cs.textContent=tm),Bh=h(e),we=s(e,"H3",{class:!0});var Cd=p(we);Et=s(Cd,"A",{id:!0,class:!0,href:!0});var Ag=p(Et);so=s(Ag,"SPAN",{});var Tg=p(so);c(fs.$$.fragment,Tg),Tg.forEach(t),Ag.forEach(t),Hu=h(Cd),Ql=s(Cd,"SPAN",{"data-svelte-h":!0}),d(Ql)!=="svelte-1wvp0tu"&&(Ql.textContent=nm),Cd.forEach(t),Xh=h(e),ms=s(e,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-q5srtm"&&(ms.innerHTML=am),Gh=h(e),vs=s(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-1gi4tsf"&&(vs.innerHTML=sm),Rh=h(e),be=s(e,"H3",{class:!0});var jd=p(be);Pt=s(jd,"A",{id:!0,class:!0,href:!0});var Eg=p(Pt);lo=s(Eg,"SPAN",{});var Pg=p(lo);c(gs.$$.fragment,Pg),Pg.forEach(t),Eg.forEach(t),qu=h(jd),Yl=s(jd,"SPAN",{"data-svelte-h":!0}),d(Yl)!=="svelte-1oc14xo"&&(Yl.textContent=lm),jd.forEach(t),Qh=h(e),$s=s(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-pmee3i"&&($s.innerHTML=rm),Yh=h(e),ws=s(e,"P",{"data-svelte-h":!0}),d(ws)!=="svelte-1s8tag4"&&(ws.textContent=om),Dh=h(e),xe=s(e,"H3",{class:!0});var Ad=p(xe);Mt=s(Ad,"A",{id:!0,class:!0,href:!0});var Mg=p(Mt);ro=s(Mg,"SPAN",{});var Ng=p(ro);c(bs.$$.fragment,Ng),Ng.forEach(t),Mg.forEach(t),zu=h(Ad),Dl=s(Ad,"SPAN",{"data-svelte-h":!0}),d(Dl)!=="svelte-1vytoz5"&&(Dl.textContent=im),Ad.forEach(t),Kh=h(e),xs=s(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-1js9xy4"&&(xs.innerHTML=hm),Oh=h(e),_e=s(e,"H3",{class:!0});var Td=p(_e);Nt=s(Td,"A",{id:!0,class:!0,href:!0});var Sg=p(Nt);oo=s(Sg,"SPAN",{});var Hg=p(oo);c(_s.$$.fragment,Hg),Hg.forEach(t),Sg.forEach(t),Vu=h(Td),Kl=s(Td,"SPAN",{"data-svelte-h":!0}),d(Kl)!=="svelte-himw1m"&&(Kl.textContent=pm),Td.forEach(t),ep=h(e),ks=s(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-1uq3sec"&&(ks.innerHTML=dm),tp=h(e),ke=s(e,"H3",{class:!0});var Ed=p(ke);St=s(Ed,"A",{id:!0,class:!0,href:!0});var qg=p(St);io=s(qg,"SPAN",{});var zg=p(io);c(ys.$$.fragment,zg),zg.forEach(t),qg.forEach(t),Lu=h(Ed),Ol=s(Ed,"SPAN",{"data-svelte-h":!0}),d(Ol)!=="svelte-1srr1jv"&&(Ol.textContent=um),Ed.forEach(t),np=h(e),Cs=s(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-14ftbmc"&&(Cs.textContent=cm),ap=h(e),ye=s(e,"H2",{class:!0});var Pd=p(ye);Ht=s(Pd,"A",{id:!0,class:!0,href:!0});var Vg=p(Ht);ho=s(Vg,"SPAN",{});var Lg=p(ho);c(js.$$.fragment,Lg),Lg.forEach(t),Vg.forEach(t),Zu=h(Pd),er=s(Pd,"SPAN",{"data-svelte-h":!0}),d(er)!=="svelte-v7k2kn"&&(er.textContent=fm),Pd.forEach(t),sp=h(e),Ce=s(e,"H3",{class:!0});var Md=p(Ce);qt=s(Md,"A",{id:!0,class:!0,href:!0});var Zg=p(qt);po=s(Zg,"SPAN",{});var Ug=p(po);c(As.$$.fragment,Ug),Ug.forEach(t),Zg.forEach(t),Uu=h(Md),tr=s(Md,"SPAN",{"data-svelte-h":!0}),d(tr)!=="svelte-1kbwtb2"&&(tr.textContent=mm),Md.forEach(t),lp=h(e),Ts=s(e,"P",{"data-svelte-h":!0}),d(Ts)!=="svelte-16cfsju"&&(Ts.textContent=vm),rp=h(e),je=s(e,"H3",{class:!0});var Nd=p(je);zt=s(Nd,"A",{id:!0,class:!0,href:!0});var Ig=p(zt);uo=s(Ig,"SPAN",{});var Fg=p(uo);c(Es.$$.fragment,Fg),Fg.forEach(t),Ig.forEach(t),Iu=h(Nd),nr=s(Nd,"SPAN",{"data-svelte-h":!0}),d(nr)!=="svelte-yy4lku"&&(nr.textContent=gm),Nd.forEach(t),op=h(e),Ps=s(e,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-1lo37lj"&&(Ps.textContent=$m),ip=h(e),c(Ms.$$.fragment,e),hp=h(e),Ns=s(e,"P",{"data-svelte-h":!0}),d(Ns)!=="svelte-10jv2li"&&(Ns.innerHTML=wm),pp=h(e),c(Ss.$$.fragment,e),dp=h(e),Hs=s(e,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-10hgp93"&&(Hs.innerHTML=bm),up=h(e),c(qs.$$.fragment,e),cp=h(e),zs=s(e,"P",{"data-svelte-h":!0}),d(zs)!=="svelte-19vzvwp"&&(zs.textContent=xm),fp=h(e),c(Vs.$$.fragment,e),mp=h(e),Ls=s(e,"P",{"data-svelte-h":!0}),d(Ls)!=="svelte-fygh0e"&&(Ls.textContent=_m),vp=h(e),Zs=s(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-u6fatw"&&(Zs.textContent=km),gp=h(e),c(Us.$$.fragment,e),$p=h(e),Is=s(e,"P",{"data-svelte-h":!0}),d(Is)!=="svelte-13hm16g"&&(Is.innerHTML=ym),wp=h(e),Fs=s(e,"P",{"data-svelte-h":!0}),d(Fs)!=="svelte-1sdgxvv"&&(Fs.innerHTML=Cm),bp=h(e),Ae=s(e,"H3",{class:!0});var Sd=p(Ae);Vt=s(Sd,"A",{id:!0,class:!0,href:!0});var Jg=p(Vt);co=s(Jg,"SPAN",{});var Wg=p(co);c(Js.$$.fragment,Wg),Wg.forEach(t),Jg.forEach(t),Fu=h(Sd),ar=s(Sd,"SPAN",{"data-svelte-h":!0}),d(ar)!=="svelte-1lglydo"&&(ar.textContent=jm),Sd.forEach(t),xp=h(e),Ws=s(e,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-nsuab6"&&(Ws.textContent=Am),_p=h(e),Te=s(e,"H3",{class:!0});var Hd=p(Te);Lt=s(Hd,"A",{id:!0,class:!0,href:!0});var Bg=p(Lt);fo=s(Bg,"SPAN",{});var Xg=p(fo);c(Bs.$$.fragment,Xg),Xg.forEach(t),Bg.forEach(t),Ju=h(Hd),sr=s(Hd,"SPAN",{"data-svelte-h":!0}),d(sr)!=="svelte-v7a99s"&&(sr.textContent=Tm),Hd.forEach(t),kp=h(e),Xs=s(e,"P",{"data-svelte-h":!0}),d(Xs)!=="svelte-cpkjuk"&&(Xs.textContent=Em),yp=h(e),Ee=s(e,"H2",{class:!0});var qd=p(Ee);Zt=s(qd,"A",{id:!0,class:!0,href:!0});var Gg=p(Zt);mo=s(Gg,"SPAN",{});var Rg=p(mo);c(Gs.$$.fragment,Rg),Rg.forEach(t),Gg.forEach(t),Wu=h(qd),lr=s(qd,"SPAN",{"data-svelte-h":!0}),d(lr)!=="svelte-jhoc0c"&&(lr.textContent=Pm),qd.forEach(t),Cp=h(e),Pe=s(e,"H3",{class:!0});var zd=p(Pe);Ut=s(zd,"A",{id:!0,class:!0,href:!0});var Qg=p(Ut);vo=s(Qg,"SPAN",{});var Yg=p(vo);c(Rs.$$.fragment,Yg),Yg.forEach(t),Qg.forEach(t),Bu=h(zd),rr=s(zd,"SPAN",{"data-svelte-h":!0}),d(rr)!=="svelte-l5sh6a"&&(rr.textContent=Mm),zd.forEach(t),jp=h(e),Qs=s(e,"P",{"data-svelte-h":!0}),d(Qs)!=="svelte-1pfu149"&&(Qs.textContent=Nm),Ap=h(e),go=s(e,"P",{}),p(go).forEach(t),this.h()},h(){r(w,"name","hf:doc:metadata"),r(w,"content",JSON.stringify(r1)),r(Me,"id","glossary"),r(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Me,"href","#glossary"),r(_,"class","relative group"),r(Ne,"id","a"),r(Ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ne,"href","#a"),r(k,"class","relative group"),r(Se,"id","attention-mask"),r(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Se,"href","#attention-mask"),r(y,"class","relative group"),r(He,"id","autoencoding-models"),r(He,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(He,"href","#autoencoding-models"),r(C,"class","relative group"),r(qe,"id","autoregressive-models"),r(qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(qe,"href","#autoregressive-models"),r(j,"class","relative group"),r(ze,"id","b"),r(ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ze,"href","#b"),r(A,"class","relative group"),r(Ve,"id","backbone"),r(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ve,"href","#backbone"),r(T,"class","relative group"),r(Le,"id","c"),r(Le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Le,"href","#c"),r(E,"class","relative group"),r(Ze,"id","causal-language-modeling"),r(Ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ze,"href","#causal-language-modeling"),r(P,"class","relative group"),r(Ue,"id","channel"),r(Ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ue,"href","#channel"),r(M,"class","relative group"),r(Ie,"id","connectionist-temporal-classification-ctc"),r(Ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ie,"href","#connectionist-temporal-classification-ctc"),r(N,"class","relative group"),r(Fe,"id","convolution"),r(Fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Fe,"href","#convolution"),r(S,"class","relative group"),r(Je,"id","d"),r(Je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Je,"href","#d"),r(H,"class","relative group"),r(We,"id","decoder-input-ids"),r(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(We,"href","#decoder-input-ids"),r(q,"class","relative group"),r(Be,"id","decoder-models"),r(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Be,"href","#decoder-models"),r(z,"class","relative group"),r(Xe,"id","deep-learning-dl"),r(Xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Xe,"href","#deep-learning-dl"),r(V,"class","relative group"),r(Ge,"id","e"),r(Ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ge,"href","#e"),r(L,"class","relative group"),r(Re,"id","encoder-models"),r(Re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Re,"href","#encoder-models"),r(Z,"class","relative group"),r(Qe,"id","f"),r(Qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Qe,"href","#f"),r(U,"class","relative group"),r(Ye,"id","feature-extraction"),r(Ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ye,"href","#feature-extraction"),r(I,"class","relative group"),r(De,"id","feed-forward-chunking"),r(De,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(De,"href","#feed-forward-chunking"),r(F,"class","relative group"),r(Ke,"id","finetuned-models"),r(Ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ke,"href","#finetuned-models"),r(J,"class","relative group"),r(Oe,"id","h"),r(Oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Oe,"href","#h"),r(W,"class","relative group"),r(et,"id","head"),r(et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(et,"href","#head"),r(B,"class","relative group"),r(tt,"id","i"),r(tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(tt,"href","#i"),r(X,"class","relative group"),r(nt,"id","image-patch"),r(nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(nt,"href","#image-patch"),r(G,"class","relative group"),r(at,"id","inference"),r(at,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(at,"href","#inference"),r(R,"class","relative group"),r(st,"id","input-ids"),r(st,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(st,"href","#input-ids"),r(Q,"class","relative group"),r(lt,"id","l"),r(lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(lt,"href","#l"),r(Y,"class","relative group"),r(rt,"id","labels"),r(rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(rt,"href","#labels"),r(D,"class","relative group"),r(it,"id","large-language-models-llm"),r(it,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(it,"href","#large-language-models-llm"),r(K,"class","relative group"),r(ht,"id","m"),r(ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ht,"href","#m"),r(O,"class","relative group"),r(pt,"id","masked-language-modeling-mlm"),r(pt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(pt,"href","#masked-language-modeling-mlm"),r(ee,"class","relative group"),r(dt,"id","multimodal"),r(dt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(dt,"href","#multimodal"),r(te,"class","relative group"),r(ut,"id","n"),r(ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ut,"href","#n"),r(ne,"class","relative group"),r(ct,"id","natural-language-generation-nlg"),r(ct,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ct,"href","#natural-language-generation-nlg"),r(ae,"class","relative group"),r(ft,"id","natural-language-processing-nlp"),r(ft,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(ft,"href","#natural-language-processing-nlp"),r(se,"class","relative group"),r(mt,"id","natural-language-understanding-nlu"),r(mt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(mt,"href","#natural-language-understanding-nlu"),r(le,"class","relative group"),r(vt,"id","p"),r(vt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(vt,"href","#p"),r(re,"class","relative group"),r(gt,"id","pipeline"),r(gt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(gt,"href","#pipeline"),r(oe,"class","relative group"),r($t,"id","pixel-values"),r($t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($t,"href","#pixel-values"),r(ie,"class","relative group"),r(wt,"id","pooling"),r(wt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(wt,"href","#pooling"),r(he,"class","relative group"),r(bt,"id","position-ids"),r(bt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(bt,"href","#position-ids"),r(pe,"class","relative group"),r(xt,"id","preprocessing"),r(xt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(xt,"href","#preprocessing"),r(de,"class","relative group"),r(_t,"id","pretrained-model"),r(_t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_t,"href","#pretrained-model"),r(ue,"class","relative group"),r(kt,"id","r"),r(kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(kt,"href","#r"),r(ce,"class","relative group"),r(yt,"id","recurrent-neural-network-rnn"),r(yt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(yt,"href","#recurrent-neural-network-rnn"),r(fe,"class","relative group"),r(Ct,"id","representation-learning"),r(Ct,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ct,"href","#representation-learning"),r(me,"class","relative group"),r(jt,"id","s"),r(jt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(jt,"href","#s"),r(ve,"class","relative group"),r(At,"id","sampling-rate"),r(At,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(At,"href","#sampling-rate"),r(ge,"class","relative group"),r(Tt,"id","selfattention"),r(Tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Tt,"href","#selfattention"),r($e,"class","relative group"),r(Et,"id","selfsupervised-learning"),r(Et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Et,"href","#selfsupervised-learning"),r(we,"class","relative group"),r(Pt,"id","semisupervised-learning"),r(Pt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Pt,"href","#semisupervised-learning"),r(be,"class","relative group"),r(Mt,"id","sequencetosequence-seq2seq"),r(Mt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Mt,"href","#sequencetosequence-seq2seq"),r(xe,"class","relative group"),r(Nt,"id","stride"),r(Nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Nt,"href","#stride"),r(_e,"class","relative group"),r(St,"id","supervised-learning"),r(St,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(St,"href","#supervised-learning"),r(ke,"class","relative group"),r(Ht,"id","t"),r(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ht,"href","#t"),r(ye,"class","relative group"),r(qt,"id","token"),r(qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(qt,"href","#token"),r(Ce,"class","relative group"),r(zt,"id","token-type-ids"),r(zt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(zt,"href","#token-type-ids"),r(je,"class","relative group"),r(Vt,"id","transfer-learning"),r(Vt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Vt,"href","#transfer-learning"),r(Ae,"class","relative group"),r(Lt,"id","transformer"),r(Lt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Lt,"href","#transformer"),r(Te,"class","relative group"),r(Zt,"id","u"),r(Zt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Zt,"href","#u"),r(Ee,"class","relative group"),r(Ut,"id","unsupervised-learning"),r(Ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(Ut,"href","#unsupervised-learning"),r(Pe,"class","relative group")},m(e,n){o(document.head,w),l(e,It,n),l(e,x,n),l(e,Ds,n),l(e,_,n),o(_,Me),o(Me,or),f(Ft,or,null),o(_,Vd),o(_,Ks),l(e,bo,n),l(e,Jt,n),l(e,xo,n),l(e,k,n),o(k,Ne),o(Ne,ir),f(Wt,ir,null),o(k,Ld),o(k,Os),l(e,_o,n),l(e,y,n),o(y,Se),o(Se,hr),f(Bt,hr,null),o(y,Zd),o(y,el),l(e,ko,n),l(e,Xt,n),l(e,yo,n),f(Gt,e,n),l(e,Co,n),l(e,Rt,n),l(e,jo,n),l(e,Qt,n),l(e,Ao,n),f(Yt,e,n),l(e,To,n),l(e,Dt,n),l(e,Eo,n),f(Kt,e,n),l(e,Po,n),l(e,Ot,n),l(e,Mo,n),l(e,en,n),l(e,No,n),f(tn,e,n),l(e,So,n),l(e,nn,n),l(e,Ho,n),f(an,e,n),l(e,qo,n),l(e,sn,n),l(e,zo,n),f(ln,e,n),l(e,Vo,n),l(e,C,n),o(C,He),o(He,pr),f(rn,pr,null),o(C,Ud),o(C,tl),l(e,Lo,n),l(e,on,n),l(e,Zo,n),l(e,j,n),o(j,qe),o(qe,dr),f(hn,dr,null),o(j,Id),o(j,nl),l(e,Uo,n),l(e,pn,n),l(e,Io,n),l(e,A,n),o(A,ze),o(ze,ur),f(dn,ur,null),o(A,Fd),o(A,al),l(e,Fo,n),l(e,T,n),o(T,Ve),o(Ve,cr),f(un,cr,null),o(T,Jd),o(T,sl),l(e,Jo,n),l(e,cn,n),l(e,Wo,n),l(e,E,n),o(E,Le),o(Le,fr),f(fn,fr,null),o(E,Wd),o(E,ll),l(e,Bo,n),l(e,P,n),o(P,Ze),o(Ze,mr),f(mn,mr,null),o(P,Bd),o(P,rl),l(e,Xo,n),l(e,vn,n),l(e,Go,n),l(e,M,n),o(M,Ue),o(Ue,vr),f(gn,vr,null),o(M,Xd),o(M,ol),l(e,Ro,n),l(e,$n,n),l(e,Qo,n),l(e,N,n),o(N,Ie),o(Ie,gr),f(wn,gr,null),o(N,Gd),o(N,il),l(e,Yo,n),l(e,bn,n),l(e,Do,n),l(e,S,n),o(S,Fe),o(Fe,$r),f(xn,$r,null),o(S,Rd),o(S,hl),l(e,Ko,n),l(e,_n,n),l(e,Oo,n),l(e,H,n),o(H,Je),o(Je,wr),f(kn,wr,null),o(H,Qd),o(H,pl),l(e,ei,n),l(e,q,n),o(q,We),o(We,br),f(yn,br,null),o(q,Yd),o(q,dl),l(e,ti,n),l(e,Cn,n),l(e,ni,n),l(e,jn,n),l(e,ai,n),l(e,An,n),l(e,si,n),l(e,z,n),o(z,Be),o(Be,xr),f(Tn,xr,null),o(z,Dd),o(z,ul),l(e,li,n),l(e,En,n),l(e,ri,n),f(Pn,e,n),l(e,oi,n),l(e,V,n),o(V,Xe),o(Xe,_r),f(Mn,_r,null),o(V,Kd),o(V,cl),l(e,ii,n),l(e,Nn,n),l(e,hi,n),l(e,L,n),o(L,Ge),o(Ge,kr),f(Sn,kr,null),o(L,Od),o(L,fl),l(e,pi,n),l(e,Z,n),o(Z,Re),o(Re,yr),f(Hn,yr,null),o(Z,eu),o(Z,ml),l(e,di,n),l(e,qn,n),l(e,ui,n),f(zn,e,n),l(e,ci,n),l(e,U,n),o(U,Qe),o(Qe,Cr),f(Vn,Cr,null),o(U,tu),o(U,vl),l(e,fi,n),l(e,I,n),o(I,Ye),o(Ye,jr),f(Ln,jr,null),o(I,nu),o(I,gl),l(e,mi,n),l(e,Zn,n),l(e,vi,n),l(e,F,n),o(F,De),o(De,Ar),f(Un,Ar,null),o(F,au),o(F,$l),l(e,gi,n),l(e,In,n),l(e,$i,n),l(e,Fn,n),l(e,wi,n),l(e,Jn,n),l(e,bi,n),l(e,J,n),o(J,Ke),o(Ke,Tr),f(Wn,Tr,null),o(J,su),o(J,wl),l(e,xi,n),l(e,Bn,n),l(e,_i,n),l(e,Xn,n),l(e,ki,n),l(e,W,n),o(W,Oe),o(Oe,Er),f(Gn,Er,null),o(W,lu),o(W,bl),l(e,yi,n),l(e,B,n),o(B,et),o(et,Pr),f(Rn,Pr,null),o(B,ru),o(B,xl),l(e,Ci,n),l(e,Qn,n),l(e,ji,n),l(e,Yn,n),l(e,Ai,n),l(e,X,n),o(X,tt),o(tt,Mr),f(Dn,Mr,null),o(X,ou),o(X,_l),l(e,Ti,n),l(e,G,n),o(G,nt),o(nt,Nr),f(Kn,Nr,null),o(G,iu),o(G,kl),l(e,Ei,n),l(e,On,n),l(e,Pi,n),l(e,R,n),o(R,at),o(at,Sr),f(ea,Sr,null),o(R,hu),o(R,yl),l(e,Mi,n),l(e,ta,n),l(e,Ni,n),l(e,Q,n),o(Q,st),o(st,Hr),f(na,Hr,null),o(Q,pu),o(Q,Cl),l(e,Si,n),l(e,aa,n),l(e,Hi,n),f(sa,e,n),l(e,qi,n),l(e,la,n),l(e,zi,n),f(ra,e,n),l(e,Vi,n),l(e,oa,n),l(e,Li,n),f(ia,e,n),l(e,Zi,n),l(e,ha,n),l(e,Ui,n),f(pa,e,n),l(e,Ii,n),l(e,da,n),l(e,Fi,n),f(ua,e,n),l(e,Ji,n),l(e,ca,n),l(e,Wi,n),f(fa,e,n),l(e,Bi,n),l(e,ma,n),l(e,Xi,n),l(e,va,n),l(e,Gi,n),f(ga,e,n),l(e,Ri,n),l(e,$a,n),l(e,Qi,n),f(wa,e,n),l(e,Yi,n),l(e,ba,n),l(e,Di,n),l(e,Y,n),o(Y,lt),o(lt,qr),f(xa,qr,null),o(Y,du),o(Y,jl),l(e,Ki,n),l(e,D,n),o(D,rt),o(rt,zr),f(_a,zr,null),o(D,uu),o(D,Al),l(e,Oi,n),l(e,ka,n),l(e,eh,n),l(e,ya,n),l(e,th,n),l(e,Ca,n),l(e,nh,n),f(ot,e,n),l(e,ah,n),l(e,ja,n),l(e,sh,n),l(e,K,n),o(K,it),o(it,Vr),f(Aa,Vr,null),o(K,cu),o(K,Tl),l(e,lh,n),l(e,Ta,n),l(e,rh,n),l(e,O,n),o(O,ht),o(ht,Lr),f(Ea,Lr,null),o(O,fu),o(O,El),l(e,oh,n),l(e,ee,n),o(ee,pt),o(pt,Zr),f(Pa,Zr,null),o(ee,mu),o(ee,Pl),l(e,ih,n),l(e,Ma,n),l(e,hh,n),l(e,te,n),o(te,dt),o(dt,Ur),f(Na,Ur,null),o(te,vu),o(te,Ml),l(e,ph,n),l(e,Sa,n),l(e,dh,n),l(e,ne,n),o(ne,ut),o(ut,Ir),f(Ha,Ir,null),o(ne,gu),o(ne,Nl),l(e,uh,n),l(e,ae,n),o(ae,ct),o(ct,Fr),f(qa,Fr,null),o(ae,$u),o(ae,Sl),l(e,ch,n),l(e,za,n),l(e,fh,n),l(e,se,n),o(se,ft),o(ft,Jr),f(Va,Jr,null),o(se,wu),o(se,Hl),l(e,mh,n),l(e,La,n),l(e,vh,n),l(e,le,n),o(le,mt),o(mt,Wr),f(Za,Wr,null),o(le,bu),o(le,ql),l(e,gh,n),l(e,Ua,n),l(e,$h,n),l(e,re,n),o(re,vt),o(vt,Br),f(Ia,Br,null),o(re,xu),o(re,zl),l(e,wh,n),l(e,oe,n),o(oe,gt),o(gt,Xr),f(Fa,Xr,null),o(oe,_u),o(oe,Vl),l(e,bh,n),l(e,Ja,n),l(e,xh,n),l(e,Wa,n),l(e,_h,n),l(e,ie,n),o(ie,$t),o($t,Gr),f(Ba,Gr,null),o(ie,ku),o(ie,Ll),l(e,kh,n),l(e,Xa,n),l(e,yh,n),l(e,he,n),o(he,wt),o(wt,Rr),f(Ga,Rr,null),o(he,yu),o(he,Zl),l(e,Ch,n),l(e,Ra,n),l(e,jh,n),l(e,pe,n),o(pe,bt),o(bt,Qr),f(Qa,Qr,null),o(pe,Cu),o(pe,Ul),l(e,Ah,n),l(e,Ya,n),l(e,Th,n),l(e,Da,n),l(e,Eh,n),l(e,Ka,n),l(e,Ph,n),l(e,de,n),o(de,xt),o(xt,Yr),f(Oa,Yr,null),o(de,ju),o(de,Il),l(e,Mh,n),l(e,es,n),l(e,Nh,n),l(e,ue,n),o(ue,_t),o(_t,Dr),f(ts,Dr,null),o(ue,Au),o(ue,Fl),l(e,Sh,n),l(e,ns,n),l(e,Hh,n),l(e,as,n),l(e,qh,n),l(e,ce,n),o(ce,kt),o(kt,Kr),f(ss,Kr,null),o(ce,Tu),o(ce,Jl),l(e,zh,n),l(e,fe,n),o(fe,yt),o(yt,Or),f(ls,Or,null),o(fe,Eu),o(fe,Wl),l(e,Vh,n),l(e,rs,n),l(e,Lh,n),l(e,me,n),o(me,Ct),o(Ct,eo),f(os,eo,null),o(me,Pu),o(me,Bl),l(e,Zh,n),l(e,is,n),l(e,Uh,n),l(e,ve,n),o(ve,jt),o(jt,to),f(hs,to,null),o(ve,Mu),o(ve,Xl),l(e,Ih,n),l(e,ge,n),o(ge,At),o(At,no),f(ps,no,null),o(ge,Nu),o(ge,Gl),l(e,Fh,n),l(e,ds,n),l(e,Jh,n),l(e,$e,n),o($e,Tt),o(Tt,ao),f(us,ao,null),o($e,Su),o($e,Rl),l(e,Wh,n),l(e,cs,n),l(e,Bh,n),l(e,we,n),o(we,Et),o(Et,so),f(fs,so,null),o(we,Hu),o(we,Ql),l(e,Xh,n),l(e,ms,n),l(e,Gh,n),l(e,vs,n),l(e,Rh,n),l(e,be,n),o(be,Pt),o(Pt,lo),f(gs,lo,null),o(be,qu),o(be,Yl),l(e,Qh,n),l(e,$s,n),l(e,Yh,n),l(e,ws,n),l(e,Dh,n),l(e,xe,n),o(xe,Mt),o(Mt,ro),f(bs,ro,null),o(xe,zu),o(xe,Dl),l(e,Kh,n),l(e,xs,n),l(e,Oh,n),l(e,_e,n),o(_e,Nt),o(Nt,oo),f(_s,oo,null),o(_e,Vu),o(_e,Kl),l(e,ep,n),l(e,ks,n),l(e,tp,n),l(e,ke,n),o(ke,St),o(St,io),f(ys,io,null),o(ke,Lu),o(ke,Ol),l(e,np,n),l(e,Cs,n),l(e,ap,n),l(e,ye,n),o(ye,Ht),o(Ht,ho),f(js,ho,null),o(ye,Zu),o(ye,er),l(e,sp,n),l(e,Ce,n),o(Ce,qt),o(qt,po),f(As,po,null),o(Ce,Uu),o(Ce,tr),l(e,lp,n),l(e,Ts,n),l(e,rp,n),l(e,je,n),o(je,zt),o(zt,uo),f(Es,uo,null),o(je,Iu),o(je,nr),l(e,op,n),l(e,Ps,n),l(e,ip,n),f(Ms,e,n),l(e,hp,n),l(e,Ns,n),l(e,pp,n),f(Ss,e,n),l(e,dp,n),l(e,Hs,n),l(e,up,n),f(qs,e,n),l(e,cp,n),l(e,zs,n),l(e,fp,n),f(Vs,e,n),l(e,mp,n),l(e,Ls,n),l(e,vp,n),l(e,Zs,n),l(e,gp,n),f(Us,e,n),l(e,$p,n),l(e,Is,n),l(e,wp,n),l(e,Fs,n),l(e,bp,n),l(e,Ae,n),o(Ae,Vt),o(Vt,co),f(Js,co,null),o(Ae,Fu),o(Ae,ar),l(e,xp,n),l(e,Ws,n),l(e,_p,n),l(e,Te,n),o(Te,Lt),o(Lt,fo),f(Bs,fo,null),o(Te,Ju),o(Te,sr),l(e,kp,n),l(e,Xs,n),l(e,yp,n),l(e,Ee,n),o(Ee,Zt),o(Zt,mo),f(Gs,mo,null),o(Ee,Wu),o(Ee,lr),l(e,Cp,n),l(e,Pe,n),o(Pe,Ut),o(Ut,vo),f(Rs,vo,null),o(Pe,Bu),o(Pe,rr),l(e,jp,n),l(e,Qs,n),l(e,Ap,n),l(e,go,n),Tp=!0},p(e,[n]){const Ys={};n&2&&(Ys.$$scope={dirty:n,ctx:e}),ot.$set(Ys)},i(e){Tp||(m(Ft.$$.fragment,e),m(Wt.$$.fragment,e),m(Bt.$$.fragment,e),m(Gt.$$.fragment,e),m(Yt.$$.fragment,e),m(Kt.$$.fragment,e),m(tn.$$.fragment,e),m(an.$$.fragment,e),m(ln.$$.fragment,e),m(rn.$$.fragment,e),m(hn.$$.fragment,e),m(dn.$$.fragment,e),m(un.$$.fragment,e),m(fn.$$.fragment,e),m(mn.$$.fragment,e),m(gn.$$.fragment,e),m(wn.$$.fragment,e),m(xn.$$.fragment,e),m(kn.$$.fragment,e),m(yn.$$.fragment,e),m(Tn.$$.fragment,e),m(Pn.$$.fragment,e),m(Mn.$$.fragment,e),m(Sn.$$.fragment,e),m(Hn.$$.fragment,e),m(zn.$$.fragment,e),m(Vn.$$.fragment,e),m(Ln.$$.fragment,e),m(Un.$$.fragment,e),m(Wn.$$.fragment,e),m(Gn.$$.fragment,e),m(Rn.$$.fragment,e),m(Dn.$$.fragment,e),m(Kn.$$.fragment,e),m(ea.$$.fragment,e),m(na.$$.fragment,e),m(sa.$$.fragment,e),m(ra.$$.fragment,e),m(ia.$$.fragment,e),m(pa.$$.fragment,e),m(ua.$$.fragment,e),m(fa.$$.fragment,e),m(ga.$$.fragment,e),m(wa.$$.fragment,e),m(xa.$$.fragment,e),m(_a.$$.fragment,e),m(ot.$$.fragment,e),m(Aa.$$.fragment,e),m(Ea.$$.fragment,e),m(Pa.$$.fragment,e),m(Na.$$.fragment,e),m(Ha.$$.fragment,e),m(qa.$$.fragment,e),m(Va.$$.fragment,e),m(Za.$$.fragment,e),m(Ia.$$.fragment,e),m(Fa.$$.fragment,e),m(Ba.$$.fragment,e),m(Ga.$$.fragment,e),m(Qa.$$.fragment,e),m(Oa.$$.fragment,e),m(ts.$$.fragment,e),m(ss.$$.fragment,e),m(ls.$$.fragment,e),m(os.$$.fragment,e),m(hs.$$.fragment,e),m(ps.$$.fragment,e),m(us.$$.fragment,e),m(fs.$$.fragment,e),m(gs.$$.fragment,e),m(bs.$$.fragment,e),m(_s.$$.fragment,e),m(ys.$$.fragment,e),m(js.$$.fragment,e),m(As.$$.fragment,e),m(Es.$$.fragment,e),m(Ms.$$.fragment,e),m(Ss.$$.fragment,e),m(qs.$$.fragment,e),m(Vs.$$.fragment,e),m(Us.$$.fragment,e),m(Js.$$.fragment,e),m(Bs.$$.fragment,e),m(Gs.$$.fragment,e),m(Rs.$$.fragment,e),Tp=!0)},o(e){v(Ft.$$.fragment,e),v(Wt.$$.fragment,e),v(Bt.$$.fragment,e),v(Gt.$$.fragment,e),v(Yt.$$.fragment,e),v(Kt.$$.fragment,e),v(tn.$$.fragment,e),v(an.$$.fragment,e),v(ln.$$.fragment,e),v(rn.$$.fragment,e),v(hn.$$.fragment,e),v(dn.$$.fragment,e),v(un.$$.fragment,e),v(fn.$$.fragment,e),v(mn.$$.fragment,e),v(gn.$$.fragment,e),v(wn.$$.fragment,e),v(xn.$$.fragment,e),v(kn.$$.fragment,e),v(yn.$$.fragment,e),v(Tn.$$.fragment,e),v(Pn.$$.fragment,e),v(Mn.$$.fragment,e),v(Sn.$$.fragment,e),v(Hn.$$.fragment,e),v(zn.$$.fragment,e),v(Vn.$$.fragment,e),v(Ln.$$.fragment,e),v(Un.$$.fragment,e),v(Wn.$$.fragment,e),v(Gn.$$.fragment,e),v(Rn.$$.fragment,e),v(Dn.$$.fragment,e),v(Kn.$$.fragment,e),v(ea.$$.fragment,e),v(na.$$.fragment,e),v(sa.$$.fragment,e),v(ra.$$.fragment,e),v(ia.$$.fragment,e),v(pa.$$.fragment,e),v(ua.$$.fragment,e),v(fa.$$.fragment,e),v(ga.$$.fragment,e),v(wa.$$.fragment,e),v(xa.$$.fragment,e),v(_a.$$.fragment,e),v(ot.$$.fragment,e),v(Aa.$$.fragment,e),v(Ea.$$.fragment,e),v(Pa.$$.fragment,e),v(Na.$$.fragment,e),v(Ha.$$.fragment,e),v(qa.$$.fragment,e),v(Va.$$.fragment,e),v(Za.$$.fragment,e),v(Ia.$$.fragment,e),v(Fa.$$.fragment,e),v(Ba.$$.fragment,e),v(Ga.$$.fragment,e),v(Qa.$$.fragment,e),v(Oa.$$.fragment,e),v(ts.$$.fragment,e),v(ss.$$.fragment,e),v(ls.$$.fragment,e),v(os.$$.fragment,e),v(hs.$$.fragment,e),v(ps.$$.fragment,e),v(us.$$.fragment,e),v(fs.$$.fragment,e),v(gs.$$.fragment,e),v(bs.$$.fragment,e),v(_s.$$.fragment,e),v(ys.$$.fragment,e),v(js.$$.fragment,e),v(As.$$.fragment,e),v(Es.$$.fragment,e),v(Ms.$$.fragment,e),v(Ss.$$.fragment,e),v(qs.$$.fragment,e),v(Vs.$$.fragment,e),v(Us.$$.fragment,e),v(Js.$$.fragment,e),v(Bs.$$.fragment,e),v(Gs.$$.fragment,e),v(Rs.$$.fragment,e),Tp=!1},d(e){e&&(t(It),t(x),t(Ds),t(_),t(bo),t(Jt),t(xo),t(k),t(_o),t(y),t(ko),t(Xt),t(yo),t(Co),t(Rt),t(jo),t(Qt),t(Ao),t(To),t(Dt),t(Eo),t(Po),t(Ot),t(Mo),t(en),t(No),t(So),t(nn),t(Ho),t(qo),t(sn),t(zo),t(Vo),t(C),t(Lo),t(on),t(Zo),t(j),t(Uo),t(pn),t(Io),t(A),t(Fo),t(T),t(Jo),t(cn),t(Wo),t(E),t(Bo),t(P),t(Xo),t(vn),t(Go),t(M),t(Ro),t($n),t(Qo),t(N),t(Yo),t(bn),t(Do),t(S),t(Ko),t(_n),t(Oo),t(H),t(ei),t(q),t(ti),t(Cn),t(ni),t(jn),t(ai),t(An),t(si),t(z),t(li),t(En),t(ri),t(oi),t(V),t(ii),t(Nn),t(hi),t(L),t(pi),t(Z),t(di),t(qn),t(ui),t(ci),t(U),t(fi),t(I),t(mi),t(Zn),t(vi),t(F),t(gi),t(In),t($i),t(Fn),t(wi),t(Jn),t(bi),t(J),t(xi),t(Bn),t(_i),t(Xn),t(ki),t(W),t(yi),t(B),t(Ci),t(Qn),t(ji),t(Yn),t(Ai),t(X),t(Ti),t(G),t(Ei),t(On),t(Pi),t(R),t(Mi),t(ta),t(Ni),t(Q),t(Si),t(aa),t(Hi),t(qi),t(la),t(zi),t(Vi),t(oa),t(Li),t(Zi),t(ha),t(Ui),t(Ii),t(da),t(Fi),t(Ji),t(ca),t(Wi),t(Bi),t(ma),t(Xi),t(va),t(Gi),t(Ri),t($a),t(Qi),t(Yi),t(ba),t(Di),t(Y),t(Ki),t(D),t(Oi),t(ka),t(eh),t(ya),t(th),t(Ca),t(nh),t(ah),t(ja),t(sh),t(K),t(lh),t(Ta),t(rh),t(O),t(oh),t(ee),t(ih),t(Ma),t(hh),t(te),t(ph),t(Sa),t(dh),t(ne),t(uh),t(ae),t(ch),t(za),t(fh),t(se),t(mh),t(La),t(vh),t(le),t(gh),t(Ua),t($h),t(re),t(wh),t(oe),t(bh),t(Ja),t(xh),t(Wa),t(_h),t(ie),t(kh),t(Xa),t(yh),t(he),t(Ch),t(Ra),t(jh),t(pe),t(Ah),t(Ya),t(Th),t(Da),t(Eh),t(Ka),t(Ph),t(de),t(Mh),t(es),t(Nh),t(ue),t(Sh),t(ns),t(Hh),t(as),t(qh),t(ce),t(zh),t(fe),t(Vh),t(rs),t(Lh),t(me),t(Zh),t(is),t(Uh),t(ve),t(Ih),t(ge),t(Fh),t(ds),t(Jh),t($e),t(Wh),t(cs),t(Bh),t(we),t(Xh),t(ms),t(Gh),t(vs),t(Rh),t(be),t(Qh),t($s),t(Yh),t(ws),t(Dh),t(xe),t(Kh),t(xs),t(Oh),t(_e),t(ep),t(ks),t(tp),t(ke),t(np),t(Cs),t(ap),t(ye),t(sp),t(Ce),t(lp),t(Ts),t(rp),t(je),t(op),t(Ps),t(ip),t(hp),t(Ns),t(pp),t(dp),t(Hs),t(up),t(cp),t(zs),t(fp),t(mp),t(Ls),t(vp),t(Zs),t(gp),t($p),t(Is),t(wp),t(Fs),t(bp),t(Ae),t(xp),t(Ws),t(_p),t(Te),t(kp),t(Xs),t(yp),t(Ee),t(Cp),t(Pe),t(jp),t(Qs),t(Ap),t(go)),t(w),g(Ft),g(Wt),g(Bt),g(Gt,e),g(Yt,e),g(Kt,e),g(tn,e),g(an,e),g(ln,e),g(rn),g(hn),g(dn),g(un),g(fn),g(mn),g(gn),g(wn),g(xn),g(kn),g(yn),g(Tn),g(Pn,e),g(Mn),g(Sn),g(Hn),g(zn,e),g(Vn),g(Ln),g(Un),g(Wn),g(Gn),g(Rn),g(Dn),g(Kn),g(ea),g(na),g(sa,e),g(ra,e),g(ia,e),g(pa,e),g(ua,e),g(fa,e),g(ga,e),g(wa,e),g(xa),g(_a),g(ot,e),g(Aa),g(Ea),g(Pa),g(Na),g(Ha),g(qa),g(Va),g(Za),g(Ia),g(Fa),g(Ba),g(Ga),g(Qa),g(Oa),g(ts),g(ss),g(ls),g(os),g(hs),g(ps),g(us),g(fs),g(gs),g(bs),g(_s),g(ys),g(js),g(As),g(Es),g(Ms,e),g(Ss,e),g(qs,e),g(Vs,e),g(Us,e),g(Js),g(Bs),g(Gs),g(Rs)}}}const r1={local:"glossary",sections:[{local:"a",sections:[{local:"attention-mask",title:"attention mask"},{local:"autoencoding-models",title:"autoencoding models"},{local:"autoregressive-models",title:"autoregressive models"}],title:"A"},{local:"b",sections:[{local:"backbone",title:"backbone"}],title:"B"},{local:"c",sections:[{local:"causal-language-modeling",title:"causal language modeling"},{local:"channel",title:"channel"},{local:"connectionist-temporal-classification-ctc",title:"connectionist temporal classification (CTC)"},{local:"convolution",title:"convolution"}],title:"C"},{local:"d",sections:[{local:"decoder-input-ids",title:"decoder input IDs"},{local:"decoder-models",title:"decoder models"},{local:"deep-learning-dl",title:"deep learning (DL)"}],title:"D"},{local:"e",sections:[{local:"encoder-models",title:"encoder models"}],title:"E"},{local:"f",sections:[{local:"feature-extraction",title:"feature extraction"},{local:"feed-forward-chunking",title:"feed forward chunking"},{local:"finetuned-models",title:"finetuned models"}],title:"F"},{local:"h",sections:[{local:"head",title:"head"}],title:"H"},{local:"i",sections:[{local:"image-patch",title:"image patch"},{local:"inference",title:"inference"},{local:"input-ids",title:"input IDs"}],title:"I"},{local:"l",sections:[{local:"labels",title:"labels"},{local:"large-language-models-llm",title:"large language models (LLM)"}],title:"L"},{local:"m",sections:[{local:"masked-language-modeling-mlm",title:"masked language modeling (MLM)"},{local:"multimodal",title:"multimodal"}],title:"M"},{local:"n",sections:[{local:"natural-language-generation-nlg",title:"Natural language generation (NLG)"},{local:"natural-language-processing-nlp",title:"Natural language processing (NLP)"},{local:"natural-language-understanding-nlu",title:"Natural language understanding (NLU)"}],title:"N"},{local:"p",sections:[{local:"pipeline",title:"pipeline"},{local:"pixel-values",title:"pixel values"},{local:"pooling",title:"pooling"},{local:"position-ids",title:"position IDs"},{local:"preprocessing",title:"preprocessing"},{local:"pretrained-model",title:"pretrained model"}],title:"P"},{local:"r",sections:[{local:"recurrent-neural-network-rnn",title:"recurrent neural network (RNN)"},{local:"representation-learning",title:"representation learning"}],title:"R"},{local:"s",sections:[{local:"sampling-rate",title:"sampling rate"},{local:"selfattention",title:"self-attention"},{local:"selfsupervised-learning",title:"self-supervised learning "},{local:"semisupervised-learning",title:"semi-supervised learning"},{local:"sequencetosequence-seq2seq",title:"sequence-to-sequence (seq2seq)"},{local:"stride",title:"stride"},{local:"supervised-learning",title:"supervised learning"}],title:"S"},{local:"t",sections:[{local:"token",title:"token"},{local:"token-type-ids",title:"token Type IDs"},{local:"transfer-learning",title:"transfer learning"},{local:"transformer",title:"transformer"}],title:"T"},{local:"u",sections:[{local:"unsupervised-learning",title:"unsupervised learning"}],title:"U"}],title:"Glossary"};function o1(wo){return Kg(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class f1 extends e1{constructor(w){super(),t1(this,w,o1,l1,Dg,{})}}export{f1 as component};
