import{s as Do,o as Oo,n as Z}from"../chunks/scheduler.9bc65507.js";import{S as Ko,i as en,g as n,s as i,u as _,A as tn,h as r,f as t,c as d,j as f,v as b,y as h,k as g,o,a as c,w as y,d as v,t as w,x as M}from"../chunks/index.78c82d43.js";import{T as Dt}from"../chunks/Tip.87d55b76.js";import{D as U}from"../chunks/Docstring.4e7352e2.js";import{C as gt}from"../chunks/CodeBlock.73e038be.js";import{I as A}from"../chunks/IconCopyLink.bedaa44d.js";import{E as ht}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as sn}from"../chunks/PipelineTag.75b0f707.js";function an(x){let s,$="Example:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlZ05ldENvbmZpZyUyQyUyMFJlZ05ldE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFJlZ05ldCUyMHJlZ25ldC15LTQwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFJlZ05ldENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHJlZ25ldC15LTQwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBSZWdOZXRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> RegNetConfig, RegNetModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a RegNet regnet-y-40 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = RegNetConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the regnet-y-40 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RegNetModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-11lpom8"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function on(x){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=n("p"),s.innerHTML=$},l(p){s=r(p,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(p,m){c(p,s,m)},p:Z,d(p){p&&t(s)}}}function nn(x){let s,$="Example:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJlZ05ldE1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEFtb2RlbCUyMCUzRCUyMFJlZ05ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, RegNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RegNetModel.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1088</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-11lpom8"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function rn(x){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=n("p"),s.innerHTML=$},l(p){s=r(p,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(p,m){c(p,s,m)},p:Z,d(p){p&&t(s)}}}function ln(x){let s,$="Example:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFJlZ05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQW1vZGVsJTIwJTNEJTIwUmVnTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZyZWduZXQteS0wNDAlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, RegNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = RegNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-11lpom8"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function dn(x){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=n("p"),s.innerHTML=$},l(p){s=r(p,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(p,m){c(p,s,m)},p:Z,d(p){p&&t(s)}}}function cn(x){let s,$="Example:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGUmVnTmV0TW9kZWwlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGUmVnTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFRegNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFRegNetModel.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1088</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>]`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-11lpom8"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function pn(x){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=n("p"),s.innerHTML=$},l(p){s=r(p,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(p,m){c(p,s,m)},p:Z,d(p){p&&t(s)}}}function mn(x){let s,$="Example:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGUmVnTmV0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZyZWduZXQteS0wNDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlJlZ05ldEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFRegNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFRegNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-11lpom8"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function hn(x){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=n("p"),s.innerHTML=$},l(p){s=r(p,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(p,m){c(p,s,m)},p:Z,d(p){p&&t(s)}}}function gn(x){let s,$="Examples:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhSZWdOZXRNb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZyZWduZXQteS0wNDAlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4UmVnTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGcmVnbmV0LXktMDQwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxRegNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxRegNetModel.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-kvfsh7"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function fn(x){let s,$=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=n("p"),s.innerHTML=$},l(p){s=r(p,"P",{"data-svelte-h":!0}),h(s)!=="svelte-fincs2"&&(s.innerHTML=$)},m(p,m){c(p,s,m)},p:Z,d(p){p&&t(s)}}}function un(x){let s,$="Example:",p,m,u;return m=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhSZWdOZXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhSZWdOZXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRnJlZ25ldC15LTA0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfY2xhc3NfaWR4JTIwJTNEJTIwamF4Lm51bXB5LmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBcHJpbnQoJTIyUHJlZGljdGVkJTIwY2xhc3MlM0ElMjIlMkMlMjBtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWR4Lml0ZW0oKSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxRegNetForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxRegNetForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/regnet-y-040&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = jax.numpy.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx.item()])`,wrap:!1}}),{c(){s=n("p"),s.textContent=$,p=i(),_(m.$$.fragment)},l(a){s=r(a,"P",{"data-svelte-h":!0}),h(s)!=="svelte-11lpom8"&&(s.textContent=$),p=d(a),b(m.$$.fragment,a)},m(a,T){c(a,s,T),c(a,p,T),y(m,a,T),u=!0},p:Z,i(a){u||(v(m.$$.fragment,a),u=!0)},o(a){w(m.$$.fragment,a),u=!1},d(a){a&&(t(s),t(p)),M(m,a)}}}function _n(x){let s,$,p,m,u,a,T,Fe,Ds,ft,Ya="RegNet",us,L,ee,Ot,Re,Os,ut,Qa="Overview",_s,Je,Da='The RegNet model was proposed in <a href="https://arxiv.org/abs/2003.13678" rel="nofollow">Designing Network Design Spaces</a> by Ilija Radosavovic, Raj Prateek Kosaraju, Ross Girshick, Kaiming He, Piotr Dollár.',bs,Ue,Oa="The authors design search spaces to perform Neural Architecture Search (NAS). They first start from a high dimensional search space and iteratively reduce the search space by empirically applying constraints based on the best-performing models sampled by the current search space.",ys,Ze,Ka="The abstract from the paper is the following:",vs,Ie,eo="<em>In this work, we present a new network design paradigm. Our goal is to help advance the understanding of network design and discover design principles that generalize across settings. Instead of focusing on designing individual network instances, we design network design spaces that parametrize populations of networks. The overall process is analogous to classic manual design of networks, but elevated to the design space level. Using our methodology we explore the structure aspect of network design and arrive at a low-dimensional design space consisting of simple, regular networks that we call RegNet. The core insight of the RegNet parametrization is surprisingly simple: widths and depths of good networks can be explained by a quantized linear function. We analyze the RegNet design space and arrive at interesting findings that do not match the current practice of network design. The RegNet design space provides simple and fast networks that work well across a wide range of flop regimes. Under comparable training settings and flops, the RegNet models outperform the popular EfficientNet models while being up to 5x faster on GPUs.</em>",ws,ke,to="Tips:",Ms,We,so='<li>One can use <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images for the model.</li> <li>The huge 10B model from <a href="https://arxiv.org/abs/2103.01988" rel="nofollow">Self-supervised Pretraining of Visual Features in the Wild</a>, trained on one billion Instagram images, is available on the <a href="https://huggingface.co/facebook/regnet-y-10b-seer" rel="nofollow">hub</a></li>',$s,Pe,ao=`This model was contributed by <a href="https://huggingface.co/Francesco" rel="nofollow">Francesco</a>. The TensorFlow version of the model
was contributed by <a href="https://huggingface.com/sayakpaul" rel="nofollow">sayakpaul</a> and <a href="https://huggingface.com/ariG23498" rel="nofollow">ariG23498</a>.
The original code can be found <a href="https://github.com/facebookresearch/pycls" rel="nofollow">here</a>.`,Ts,S,te,Kt,Ge,Ks,_t,oo="Resources",xs,Be,no="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with RegNet.",Cs,ze,Ns,Ve,ro='<li><a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',js,Ee,lo="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Fs,X,se,es,He,ea,bt,io="RegNetConfig",Rs,R,Ae,ta,yt,co=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a>. It is used to instantiate a RegNet
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the RegNet
<a href="https://huggingface.co/facebook/regnet-y-040" rel="nofollow">facebook/regnet-y-040</a> architecture.`,sa,vt,po=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,aa,ae,Js,q,oe,ts,Le,oa,wt,mo="RegNetModel",Us,z,Se,na,Mt,ho=`The bare RegNet model outputting raw features without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ra,I,Xe,la,$t,go='The <a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetModel">RegNetModel</a> forward method, overrides the <code>__call__</code> special method.',ia,ne,da,re,Zs,Y,le,ss,qe,ca,Tt,fo="RegNetForImageClassification",Is,J,Ye,pa,xt,uo=`RegNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,ma,Ct,_o=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ha,k,Qe,ga,Nt,bo='The <a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetForImageClassification">RegNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',fa,ie,ua,de,ks,Q,ce,as,De,_a,jt,yo="TFRegNetModel",Ws,V,Oe,ba,Ft,vo="The bare RegNet model outputting raw features without any specific head on top.",ya,W,Ke,va,Rt,wo='The <a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.TFRegNetModel">TFRegNetModel</a> forward method, overrides the <code>__call__</code> special method.',wa,pe,Ma,me,Ps,D,he,os,et,$a,Jt,Mo="TFRegNetForImageClassification",Gs,E,tt,Ta,Ut,$o=`RegNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,xa,P,st,Ca,Zt,To='The <a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.TFRegNetForImageClassification">TFRegNetForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Na,ge,ja,fe,Bs,O,ue,ns,at,Fa,It,xo="FlaxRegNetModel",zs,C,ot,Ra,kt,Co="The bare RegNet model outputting raw features without any specific head on top.",Ja,Wt,No=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Ua,Pt,jo=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Za,Gt,Fo="Finally, this model supports inherent JAX features such as:",Ia,Bt,Ro='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',ka,G,nt,Wa,zt,Jo="The <code>FlaxRegNetPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Pa,_e,Ga,be,Vs,K,ye,rs,rt,Ba,Vt,Uo="FlaxRegNetForImageClassification",Es,N,lt,za,Et,Zo=`RegNet Model with an image classification head on top (a linear layer on top of the pooled features), e.g. for
ImageNet.`,Va,Ht,Io=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,Ea,At,ko=`This model is also a Flax Linen <a href="https://flax.readthedocs.io/en/latest/flax.linen.html#module" rel="nofollow">flax.linen.Module</a>
subclass. Use it as a regular Flax linen Module and refer to the Flax documentation for all matter related to
general usage and behavior.`,Ha,Lt,Wo="Finally, this model supports inherent JAX features such as:",Aa,St,Po='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',La,B,it,Sa,Xt,Go="The <code>FlaxRegNetPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Xa,ve,qa,we,Hs,ls,As;return Fe=new A({}),Re=new A({}),Ge=new A({}),ze=new sn({props:{pipeline:"image-classification"}}),He=new A({}),Ae=new U({props:{name:"class transformers.RegNetConfig",anchor:"transformers.RegNetConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"embedding_size",val:" = 32"},{name:"hidden_sizes",val:" = [128, 192, 512, 1088]"},{name:"depths",val:" = [2, 6, 12, 2]"},{name:"groups_width",val:" = 64"},{name:"layer_type",val:" = 'y'"},{name:"hidden_act",val:" = 'relu'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.RegNetConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.RegNetConfig.embedding_size",description:`<strong>embedding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality (hidden size) for the embedding layer.`,name:"embedding_size"},{anchor:"transformers.RegNetConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[256, 512, 1024, 2048]</code>) &#x2014;
Dimensionality (hidden size) at each stage.`,name:"hidden_sizes"},{anchor:"transformers.RegNetConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 4, 6, 3]</code>) &#x2014;
Depth (number of layers) for each stage.`,name:"depths"},{anchor:"transformers.RegNetConfig.layer_type",description:`<strong>layer_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;y&quot;</code>) &#x2014;
The layer to use, it can be either <code>&quot;x&quot; or </code>&#x201C;y&#x201D;<code>. An </code>x<code>layer is a ResNet&apos;s BottleNeck layer with</code>reduction<code>fixed to</code>1<code>. While a </code>y<code>layer is a</code>x\` but with squeeze and excitation. Please refer to the
paper for a detailed explanation of how these layers were constructed.`,name:"layer_type"},{anchor:"transformers.RegNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function in each block. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code>
are supported.`,name:"hidden_act"},{anchor:"transformers.RegNetConfig.downsample_in_first_stage",description:`<strong>downsample_in_first_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the first stage will downsample the inputs using a <code>stride</code> of 2.`,name:"downsample_in_first_stage"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/configuration_regnet.py#L28"}}),ae=new ht({props:{anchor:"transformers.RegNetConfig.example",$$slots:{default:[an]},$$scope:{ctx:x}}}),Le=new A({}),Se=new U({props:{name:"class transformers.RegNetModel",anchor:"transformers.RegNetModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RegNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_regnet.py#L331"}}),Xe=new U({props:{name:"forward",anchor:"transformers.RegNetModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RegNetModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.RegNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RegNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_regnet.py#L341",returnDescription:`
<p>A <code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.BaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ne=new Dt({props:{$$slots:{default:[on]},$$scope:{ctx:x}}}),re=new ht({props:{anchor:"transformers.RegNetModel.forward.example",$$slots:{default:[nn]},$$scope:{ctx:x}}}),qe=new A({}),Ye=new U({props:{name:"class transformers.RegNetForImageClassification",anchor:"transformers.RegNetForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.RegNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_regnet.py#L385"}}),Qe=new U({props:{name:"forward",anchor:"transformers.RegNetForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.RegNetForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">ConvNextImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.RegNetForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.RegNetForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.RegNetForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_regnet.py#L398",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"
>transformers.modeling_outputs.ImageClassifierOutputWithNoAttention</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new Dt({props:{$$slots:{default:[rn]},$$scope:{ctx:x}}}),de=new ht({props:{anchor:"transformers.RegNetForImageClassification.forward.example",$$slots:{default:[ln]},$$scope:{ctx:x}}}),De=new A({}),Oe=new U({props:{name:"class transformers.TFRegNetModel",anchor:"transformers.TFRegNetModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFRegNetModel.This",description:`<strong>This</strong> model is a Tensorflow &#x2014;
[tf.keras.layers.Layer](https &#x2014;//<a href="http://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">www.tensorflow.org/api_docs/python/tf/keras/layers/Layer</a>) sub-class. Use it as a`,name:"This"},{anchor:"transformers.TFRegNetModel.regular",description:`<strong>regular</strong> Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and &#x2014;
behavior. &#x2014;
config (<a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>): Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"regular"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_tf_regnet.py#L380"}}),Ke=new U({props:{name:"call",anchor:"transformers.TFRegNetModel.call",parameters:[{name:"pixel_values",val:": Tensor"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFRegNetModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>ConveNextImageProcessor.__call__</code> for details.`,name:"pixel_values"},{anchor:"transformers.TFRegNetModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFRegNetModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_tf_regnet.py#L385",returnDescription:`
<p>A <code>transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndNoAttention</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state after a pooling operation on the spatial dimensions.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndNoAttention</code> or <code>tuple(tf.Tensor)</code></p>
`}}),pe=new Dt({props:{$$slots:{default:[dn]},$$scope:{ctx:x}}}),me=new ht({props:{anchor:"transformers.TFRegNetModel.call.example",$$slots:{default:[cn]},$$scope:{ctx:x}}}),et=new A({}),tt=new U({props:{name:"class transformers.TFRegNetForImageClassification",anchor:"transformers.TFRegNetForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFRegNetForImageClassification.This",description:`<strong>This</strong> model is a Tensorflow &#x2014;
[tf.keras.layers.Layer](https &#x2014;//<a href="http://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">www.tensorflow.org/api_docs/python/tf/keras/layers/Layer</a>) sub-class. Use it as a`,name:"This"},{anchor:"transformers.TFRegNetForImageClassification.regular",description:`<strong>regular</strong> Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and &#x2014;
behavior. &#x2014;
config (<a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>): Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"regular"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_tf_regnet.py#L429"}}),st=new U({props:{name:"call",anchor:"transformers.TFRegNetForImageClassification.call",parameters:[{name:"pixel_values",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"labels",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFRegNetForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>ConveNextImageProcessor.__call__</code> for details.`,name:"pixel_values"},{anchor:"transformers.TFRegNetForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFRegNetForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFRegNetForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_tf_regnet.py#L440",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig"
>RegNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"
>transformers.modeling_tf_outputs.TFSequenceClassifierOutput</a> or <code>tuple(tf.Tensor)</code></p>
`}}),ge=new Dt({props:{$$slots:{default:[pn]},$$scope:{ctx:x}}}),fe=new ht({props:{anchor:"transformers.TFRegNetForImageClassification.call.example",$$slots:{default:[mn]},$$scope:{ctx:x}}}),at=new A({}),ot=new U({props:{name:"class transformers.FlaxRegNetModel",anchor:"transformers.FlaxRegNetModel",parameters:[{name:"config",val:": RegNetConfig"},{name:"input_shape",val:" = (1, 224, 224, 3)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxRegNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxRegNetModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_flax_regnet.py#L689"}}),nt=new U({props:{name:"__call__",anchor:"transformers.FlaxRegNetModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"params",val:": dict = None"},{name:"train",val:": bool = False"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_flax_regnet.py#L596",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.regnet.configuration_regnet.RegNetConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"
>transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new Dt({props:{$$slots:{default:[hn]},$$scope:{ctx:x}}}),be=new ht({props:{anchor:"transformers.FlaxRegNetModel.__call__.example",$$slots:{default:[gn]},$$scope:{ctx:x}}}),rt=new A({}),lt=new U({props:{name:"class transformers.FlaxRegNetForImageClassification",anchor:"transformers.FlaxRegNetForImageClassification",parameters:[{name:"config",val:": RegNetConfig"},{name:"input_shape",val:" = (1, 224, 224, 3)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxRegNetForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/regnet#transformers.RegNetConfig">RegNetConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxRegNetForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_flax_regnet.py#L782"}}),it=new U({props:{name:"__call__",anchor:"transformers.FlaxRegNetForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"params",val:": dict = None"},{name:"train",val:": bool = False"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/regnet/modeling_flax_regnet.py#L596",returnDescription:`
<p>A <code>transformers.modeling_flax_outputs.FlaxImageClassifierOutputWithNoAttention</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.regnet.configuration_regnet.RegNetConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when</li>
<li><strong><code>config.output_hidden_states=True</code>):</strong>
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings, if the model has an embedding layer, + one
for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_flax_outputs.FlaxImageClassifierOutputWithNoAttention</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new Dt({props:{$$slots:{default:[fn]},$$scope:{ctx:x}}}),we=new ht({props:{anchor:"transformers.FlaxRegNetForImageClassification.__call__.example",$$slots:{default:[un]},$$scope:{ctx:x}}}),{c(){s=n("meta"),$=i(),p=n("p"),m=i(),u=n("h1"),a=n("a"),T=n("span"),_(Fe.$$.fragment),Ds=i(),ft=n("span"),ft.textContent=Ya,us=i(),L=n("h2"),ee=n("a"),Ot=n("span"),_(Re.$$.fragment),Os=i(),ut=n("span"),ut.textContent=Qa,_s=i(),Je=n("p"),Je.innerHTML=Da,bs=i(),Ue=n("p"),Ue.textContent=Oa,ys=i(),Ze=n("p"),Ze.textContent=Ka,vs=i(),Ie=n("p"),Ie.innerHTML=eo,ws=i(),ke=n("p"),ke.textContent=to,Ms=i(),We=n("ul"),We.innerHTML=so,$s=i(),Pe=n("p"),Pe.innerHTML=ao,Ts=i(),S=n("h2"),te=n("a"),Kt=n("span"),_(Ge.$$.fragment),Ks=i(),_t=n("span"),_t.textContent=oo,xs=i(),Be=n("p"),Be.textContent=no,Cs=i(),_(ze.$$.fragment),Ns=i(),Ve=n("ul"),Ve.innerHTML=ro,js=i(),Ee=n("p"),Ee.textContent=lo,Fs=i(),X=n("h2"),se=n("a"),es=n("span"),_(He.$$.fragment),ea=i(),bt=n("span"),bt.textContent=io,Rs=i(),R=n("div"),_(Ae.$$.fragment),ta=i(),yt=n("p"),yt.innerHTML=co,sa=i(),vt=n("p"),vt.innerHTML=po,aa=i(),_(ae.$$.fragment),Js=i(),q=n("h2"),oe=n("a"),ts=n("span"),_(Le.$$.fragment),oa=i(),wt=n("span"),wt.textContent=mo,Us=i(),z=n("div"),_(Se.$$.fragment),na=i(),Mt=n("p"),Mt.innerHTML=ho,ra=i(),I=n("div"),_(Xe.$$.fragment),la=i(),$t=n("p"),$t.innerHTML=go,ia=i(),_(ne.$$.fragment),da=i(),_(re.$$.fragment),Zs=i(),Y=n("h2"),le=n("a"),ss=n("span"),_(qe.$$.fragment),ca=i(),Tt=n("span"),Tt.textContent=fo,Is=i(),J=n("div"),_(Ye.$$.fragment),pa=i(),xt=n("p"),xt.textContent=uo,ma=i(),Ct=n("p"),Ct.innerHTML=_o,ha=i(),k=n("div"),_(Qe.$$.fragment),ga=i(),Nt=n("p"),Nt.innerHTML=bo,fa=i(),_(ie.$$.fragment),ua=i(),_(de.$$.fragment),ks=i(),Q=n("h2"),ce=n("a"),as=n("span"),_(De.$$.fragment),_a=i(),jt=n("span"),jt.textContent=yo,Ws=i(),V=n("div"),_(Oe.$$.fragment),ba=i(),Ft=n("p"),Ft.textContent=vo,ya=i(),W=n("div"),_(Ke.$$.fragment),va=i(),Rt=n("p"),Rt.innerHTML=wo,wa=i(),_(pe.$$.fragment),Ma=i(),_(me.$$.fragment),Ps=i(),D=n("h2"),he=n("a"),os=n("span"),_(et.$$.fragment),$a=i(),Jt=n("span"),Jt.textContent=Mo,Gs=i(),E=n("div"),_(tt.$$.fragment),Ta=i(),Ut=n("p"),Ut.textContent=$o,xa=i(),P=n("div"),_(st.$$.fragment),Ca=i(),Zt=n("p"),Zt.innerHTML=To,Na=i(),_(ge.$$.fragment),ja=i(),_(fe.$$.fragment),Bs=i(),O=n("h2"),ue=n("a"),ns=n("span"),_(at.$$.fragment),Fa=i(),It=n("span"),It.textContent=xo,zs=i(),C=n("div"),_(ot.$$.fragment),Ra=i(),kt=n("p"),kt.textContent=Co,Ja=i(),Wt=n("p"),Wt.innerHTML=No,Ua=i(),Pt=n("p"),Pt.innerHTML=jo,Za=i(),Gt=n("p"),Gt.textContent=Fo,Ia=i(),Bt=n("ul"),Bt.innerHTML=Ro,ka=i(),G=n("div"),_(nt.$$.fragment),Wa=i(),zt=n("p"),zt.innerHTML=Jo,Pa=i(),_(_e.$$.fragment),Ga=i(),_(be.$$.fragment),Vs=i(),K=n("h2"),ye=n("a"),rs=n("span"),_(rt.$$.fragment),Ba=i(),Vt=n("span"),Vt.textContent=Uo,Es=i(),N=n("div"),_(lt.$$.fragment),za=i(),Et=n("p"),Et.textContent=Zo,Va=i(),Ht=n("p"),Ht.innerHTML=Io,Ea=i(),At=n("p"),At.innerHTML=ko,Ha=i(),Lt=n("p"),Lt.textContent=Wo,Aa=i(),St=n("ul"),St.innerHTML=Po,La=i(),B=n("div"),_(it.$$.fragment),Sa=i(),Xt=n("p"),Xt.innerHTML=Go,Xa=i(),_(ve.$$.fragment),qa=i(),_(we.$$.fragment),Hs=i(),ls=n("p"),this.h()},l(e){const l=tn("svelte-1phssyn",document.head);s=r(l,"META",{name:!0,content:!0}),l.forEach(t),$=d(e),p=r(e,"P",{}),f(p).forEach(t),m=d(e),u=r(e,"H1",{class:!0});var dt=f(u);a=r(dt,"A",{id:!0,class:!0,href:!0});var is=f(a);T=r(is,"SPAN",{});var ds=f(T);b(Fe.$$.fragment,ds),ds.forEach(t),is.forEach(t),Ds=d(dt),ft=r(dt,"SPAN",{"data-svelte-h":!0}),h(ft)!=="svelte-1r627ri"&&(ft.textContent=Ya),dt.forEach(t),us=d(e),L=r(e,"H2",{class:!0});var ct=f(L);ee=r(ct,"A",{id:!0,class:!0,href:!0});var cs=f(ee);Ot=r(cs,"SPAN",{});var ps=f(Ot);b(Re.$$.fragment,ps),ps.forEach(t),cs.forEach(t),Os=d(ct),ut=r(ct,"SPAN",{"data-svelte-h":!0}),h(ut)!=="svelte-1jsw1pg"&&(ut.textContent=Qa),ct.forEach(t),_s=d(e),Je=r(e,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-vy13p6"&&(Je.innerHTML=Da),bs=d(e),Ue=r(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-1y5hyhh"&&(Ue.textContent=Oa),ys=d(e),Ze=r(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-vfdo9a"&&(Ze.textContent=Ka),vs=d(e),Ie=r(e,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-1judo2o"&&(Ie.innerHTML=eo),ws=d(e),ke=r(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-axv494"&&(ke.textContent=to),Ms=d(e),We=r(e,"UL",{"data-svelte-h":!0}),h(We)!=="svelte-1x9q1xk"&&(We.innerHTML=so),$s=d(e),Pe=r(e,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-1x0i1j0"&&(Pe.innerHTML=ao),Ts=d(e),S=r(e,"H2",{class:!0});var pt=f(S);te=r(pt,"A",{id:!0,class:!0,href:!0});var ms=f(te);Kt=r(ms,"SPAN",{});var hs=f(Kt);b(Ge.$$.fragment,hs),hs.forEach(t),ms.forEach(t),Ks=d(pt),_t=r(pt,"SPAN",{"data-svelte-h":!0}),h(_t)!=="svelte-w4zzv6"&&(_t.textContent=oo),pt.forEach(t),xs=d(e),Be=r(e,"P",{"data-svelte-h":!0}),h(Be)!=="svelte-15k7oqe"&&(Be.textContent=no),Cs=d(e),b(ze.$$.fragment,e),Ns=d(e),Ve=r(e,"UL",{"data-svelte-h":!0}),h(Ve)!=="svelte-e5gh36"&&(Ve.innerHTML=ro),js=d(e),Ee=r(e,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-1xesile"&&(Ee.textContent=lo),Fs=d(e),X=r(e,"H2",{class:!0});var mt=f(X);se=r(mt,"A",{id:!0,class:!0,href:!0});var gs=f(se);es=r(gs,"SPAN",{});var fs=f(es);b(He.$$.fragment,fs),fs.forEach(t),gs.forEach(t),ea=d(mt),bt=r(mt,"SPAN",{"data-svelte-h":!0}),h(bt)!=="svelte-b70cww"&&(bt.textContent=io),mt.forEach(t),Rs=d(e),R=r(e,"DIV",{class:!0});var H=f(R);b(Ae.$$.fragment,H),ta=d(H),yt=r(H,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-kvx516"&&(yt.innerHTML=co),sa=d(H),vt=r(H,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-10kqkkl"&&(vt.innerHTML=po),aa=d(H),b(ae.$$.fragment,H),H.forEach(t),Js=d(e),q=r(e,"H2",{class:!0});var Ls=f(q);oe=r(Ls,"A",{id:!0,class:!0,href:!0});var Bo=f(oe);ts=r(Bo,"SPAN",{});var zo=f(ts);b(Le.$$.fragment,zo),zo.forEach(t),Bo.forEach(t),oa=d(Ls),wt=r(Ls,"SPAN",{"data-svelte-h":!0}),h(wt)!=="svelte-hvc92x"&&(wt.textContent=mo),Ls.forEach(t),Us=d(e),z=r(e,"DIV",{class:!0});var qt=f(z);b(Se.$$.fragment,qt),na=d(qt),Mt=r(qt,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-1ime5d7"&&(Mt.innerHTML=ho),ra=d(qt),I=r(qt,"DIV",{class:!0});var Me=f(I);b(Xe.$$.fragment,Me),la=d(Me),$t=r(Me,"P",{"data-svelte-h":!0}),h($t)!=="svelte-aon3mw"&&($t.innerHTML=go),ia=d(Me),b(ne.$$.fragment,Me),da=d(Me),b(re.$$.fragment,Me),Me.forEach(t),qt.forEach(t),Zs=d(e),Y=r(e,"H2",{class:!0});var Ss=f(Y);le=r(Ss,"A",{id:!0,class:!0,href:!0});var Vo=f(le);ss=r(Vo,"SPAN",{});var Eo=f(ss);b(qe.$$.fragment,Eo),Eo.forEach(t),Vo.forEach(t),ca=d(Ss),Tt=r(Ss,"SPAN",{"data-svelte-h":!0}),h(Tt)!=="svelte-jtrppq"&&(Tt.textContent=fo),Ss.forEach(t),Is=d(e),J=r(e,"DIV",{class:!0});var $e=f(J);b(Ye.$$.fragment,$e),pa=d($e),xt=r($e,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-ipsb0r"&&(xt.textContent=uo),ma=d($e),Ct=r($e,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-1gjh92c"&&(Ct.innerHTML=_o),ha=d($e),k=r($e,"DIV",{class:!0});var Te=f(k);b(Qe.$$.fragment,Te),ga=d(Te),Nt=r(Te,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-bnn07u"&&(Nt.innerHTML=bo),fa=d(Te),b(ie.$$.fragment,Te),ua=d(Te),b(de.$$.fragment,Te),Te.forEach(t),$e.forEach(t),ks=d(e),Q=r(e,"H2",{class:!0});var Xs=f(Q);ce=r(Xs,"A",{id:!0,class:!0,href:!0});var Ho=f(ce);as=r(Ho,"SPAN",{});var Ao=f(as);b(De.$$.fragment,Ao),Ao.forEach(t),Ho.forEach(t),_a=d(Xs),jt=r(Xs,"SPAN",{"data-svelte-h":!0}),h(jt)!=="svelte-1xdiq3z"&&(jt.textContent=yo),Xs.forEach(t),Ws=d(e),V=r(e,"DIV",{class:!0});var Yt=f(V);b(Oe.$$.fragment,Yt),ba=d(Yt),Ft=r(Yt,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-1lrc7eh"&&(Ft.textContent=vo),ya=d(Yt),W=r(Yt,"DIV",{class:!0});var xe=f(W);b(Ke.$$.fragment,xe),va=d(xe),Rt=r(xe,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-1v3dt1g"&&(Rt.innerHTML=wo),wa=d(xe),b(pe.$$.fragment,xe),Ma=d(xe),b(me.$$.fragment,xe),xe.forEach(t),Yt.forEach(t),Ps=d(e),D=r(e,"H2",{class:!0});var qs=f(D);he=r(qs,"A",{id:!0,class:!0,href:!0});var Lo=f(he);os=r(Lo,"SPAN",{});var So=f(os);b(et.$$.fragment,So),So.forEach(t),Lo.forEach(t),$a=d(qs),Jt=r(qs,"SPAN",{"data-svelte-h":!0}),h(Jt)!=="svelte-o9qd0w"&&(Jt.textContent=Mo),qs.forEach(t),Gs=d(e),E=r(e,"DIV",{class:!0});var Qt=f(E);b(tt.$$.fragment,Qt),Ta=d(Qt),Ut=r(Qt,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-ipsb0r"&&(Ut.textContent=$o),xa=d(Qt),P=r(Qt,"DIV",{class:!0});var Ce=f(P);b(st.$$.fragment,Ce),Ca=d(Ce),Zt=r(Ce,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-h0a1bm"&&(Zt.innerHTML=To),Na=d(Ce),b(ge.$$.fragment,Ce),ja=d(Ce),b(fe.$$.fragment,Ce),Ce.forEach(t),Qt.forEach(t),Bs=d(e),O=r(e,"H2",{class:!0});var Ys=f(O);ue=r(Ys,"A",{id:!0,class:!0,href:!0});var Xo=f(ue);ns=r(Xo,"SPAN",{});var qo=f(ns);b(at.$$.fragment,qo),qo.forEach(t),Xo.forEach(t),Fa=d(Ys),It=r(Ys,"SPAN",{"data-svelte-h":!0}),h(It)!=="svelte-164qg24"&&(It.textContent=xo),Ys.forEach(t),zs=d(e),C=r(e,"DIV",{class:!0});var j=f(C);b(ot.$$.fragment,j),Ra=d(j),kt=r(j,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-1lrc7eh"&&(kt.textContent=Co),Ja=d(j),Wt=r(j,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-1co8q4b"&&(Wt.innerHTML=No),Ua=d(j),Pt=r(j,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-9ybkh"&&(Pt.innerHTML=jo),Za=d(j),Gt=r(j,"P",{"data-svelte-h":!0}),h(Gt)!=="svelte-1pplc4a"&&(Gt.textContent=Fo),Ia=d(j),Bt=r(j,"UL",{"data-svelte-h":!0}),h(Bt)!=="svelte-1w7z84m"&&(Bt.innerHTML=Ro),ka=d(j),G=r(j,"DIV",{class:!0});var Ne=f(G);b(nt.$$.fragment,Ne),Wa=d(Ne),zt=r(Ne,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-1xwpegk"&&(zt.innerHTML=Jo),Pa=d(Ne),b(_e.$$.fragment,Ne),Ga=d(Ne),b(be.$$.fragment,Ne),Ne.forEach(t),j.forEach(t),Vs=d(e),K=r(e,"H2",{class:!0});var Qs=f(K);ye=r(Qs,"A",{id:!0,class:!0,href:!0});var Yo=f(ye);rs=r(Yo,"SPAN",{});var Qo=f(rs);b(rt.$$.fragment,Qo),Qo.forEach(t),Yo.forEach(t),Ba=d(Qs),Vt=r(Qs,"SPAN",{"data-svelte-h":!0}),h(Vt)!=="svelte-12ab3b3"&&(Vt.textContent=Uo),Qs.forEach(t),Es=d(e),N=r(e,"DIV",{class:!0});var F=f(N);b(lt.$$.fragment,F),za=d(F),Et=r(F,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-ipsb0r"&&(Et.textContent=Zo),Va=d(F),Ht=r(F,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-1co8q4b"&&(Ht.innerHTML=Io),Ea=d(F),At=r(F,"P",{"data-svelte-h":!0}),h(At)!=="svelte-9ybkh"&&(At.innerHTML=ko),Ha=d(F),Lt=r(F,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-1pplc4a"&&(Lt.textContent=Wo),Aa=d(F),St=r(F,"UL",{"data-svelte-h":!0}),h(St)!=="svelte-1w7z84m"&&(St.innerHTML=Po),La=d(F),B=r(F,"DIV",{class:!0});var je=f(B);b(it.$$.fragment,je),Sa=d(je),Xt=r(je,"P",{"data-svelte-h":!0}),h(Xt)!=="svelte-1xwpegk"&&(Xt.innerHTML=Go),Xa=d(je),b(ve.$$.fragment,je),qa=d(je),b(we.$$.fragment,je),je.forEach(t),F.forEach(t),Hs=d(e),ls=r(e,"P",{}),f(ls).forEach(t),this.h()},h(){g(s,"name","hf:doc:metadata"),g(s,"content",JSON.stringify(bn)),g(a,"id","regnet"),g(a,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(a,"href","#regnet"),g(u,"class","relative group"),g(ee,"id","overview"),g(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(ee,"href","#overview"),g(L,"class","relative group"),g(te,"id","resources"),g(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(te,"href","#resources"),g(S,"class","relative group"),g(se,"id","transformers.RegNetConfig"),g(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(se,"href","#transformers.RegNetConfig"),g(X,"class","relative group"),g(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(oe,"id","transformers.RegNetModel"),g(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(oe,"href","#transformers.RegNetModel"),g(q,"class","relative group"),g(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(le,"id","transformers.RegNetForImageClassification"),g(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(le,"href","#transformers.RegNetForImageClassification"),g(Y,"class","relative group"),g(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ce,"id","transformers.TFRegNetModel"),g(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(ce,"href","#transformers.TFRegNetModel"),g(Q,"class","relative group"),g(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(he,"id","transformers.TFRegNetForImageClassification"),g(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(he,"href","#transformers.TFRegNetForImageClassification"),g(D,"class","relative group"),g(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ue,"id","transformers.FlaxRegNetModel"),g(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(ue,"href","#transformers.FlaxRegNetModel"),g(O,"class","relative group"),g(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ye,"id","transformers.FlaxRegNetForImageClassification"),g(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(ye,"href","#transformers.FlaxRegNetForImageClassification"),g(K,"class","relative group"),g(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){o(document.head,s),c(e,$,l),c(e,p,l),c(e,m,l),c(e,u,l),o(u,a),o(a,T),y(Fe,T,null),o(u,Ds),o(u,ft),c(e,us,l),c(e,L,l),o(L,ee),o(ee,Ot),y(Re,Ot,null),o(L,Os),o(L,ut),c(e,_s,l),c(e,Je,l),c(e,bs,l),c(e,Ue,l),c(e,ys,l),c(e,Ze,l),c(e,vs,l),c(e,Ie,l),c(e,ws,l),c(e,ke,l),c(e,Ms,l),c(e,We,l),c(e,$s,l),c(e,Pe,l),c(e,Ts,l),c(e,S,l),o(S,te),o(te,Kt),y(Ge,Kt,null),o(S,Ks),o(S,_t),c(e,xs,l),c(e,Be,l),c(e,Cs,l),y(ze,e,l),c(e,Ns,l),c(e,Ve,l),c(e,js,l),c(e,Ee,l),c(e,Fs,l),c(e,X,l),o(X,se),o(se,es),y(He,es,null),o(X,ea),o(X,bt),c(e,Rs,l),c(e,R,l),y(Ae,R,null),o(R,ta),o(R,yt),o(R,sa),o(R,vt),o(R,aa),y(ae,R,null),c(e,Js,l),c(e,q,l),o(q,oe),o(oe,ts),y(Le,ts,null),o(q,oa),o(q,wt),c(e,Us,l),c(e,z,l),y(Se,z,null),o(z,na),o(z,Mt),o(z,ra),o(z,I),y(Xe,I,null),o(I,la),o(I,$t),o(I,ia),y(ne,I,null),o(I,da),y(re,I,null),c(e,Zs,l),c(e,Y,l),o(Y,le),o(le,ss),y(qe,ss,null),o(Y,ca),o(Y,Tt),c(e,Is,l),c(e,J,l),y(Ye,J,null),o(J,pa),o(J,xt),o(J,ma),o(J,Ct),o(J,ha),o(J,k),y(Qe,k,null),o(k,ga),o(k,Nt),o(k,fa),y(ie,k,null),o(k,ua),y(de,k,null),c(e,ks,l),c(e,Q,l),o(Q,ce),o(ce,as),y(De,as,null),o(Q,_a),o(Q,jt),c(e,Ws,l),c(e,V,l),y(Oe,V,null),o(V,ba),o(V,Ft),o(V,ya),o(V,W),y(Ke,W,null),o(W,va),o(W,Rt),o(W,wa),y(pe,W,null),o(W,Ma),y(me,W,null),c(e,Ps,l),c(e,D,l),o(D,he),o(he,os),y(et,os,null),o(D,$a),o(D,Jt),c(e,Gs,l),c(e,E,l),y(tt,E,null),o(E,Ta),o(E,Ut),o(E,xa),o(E,P),y(st,P,null),o(P,Ca),o(P,Zt),o(P,Na),y(ge,P,null),o(P,ja),y(fe,P,null),c(e,Bs,l),c(e,O,l),o(O,ue),o(ue,ns),y(at,ns,null),o(O,Fa),o(O,It),c(e,zs,l),c(e,C,l),y(ot,C,null),o(C,Ra),o(C,kt),o(C,Ja),o(C,Wt),o(C,Ua),o(C,Pt),o(C,Za),o(C,Gt),o(C,Ia),o(C,Bt),o(C,ka),o(C,G),y(nt,G,null),o(G,Wa),o(G,zt),o(G,Pa),y(_e,G,null),o(G,Ga),y(be,G,null),c(e,Vs,l),c(e,K,l),o(K,ye),o(ye,rs),y(rt,rs,null),o(K,Ba),o(K,Vt),c(e,Es,l),c(e,N,l),y(lt,N,null),o(N,za),o(N,Et),o(N,Va),o(N,Ht),o(N,Ea),o(N,At),o(N,Ha),o(N,Lt),o(N,Aa),o(N,St),o(N,La),o(N,B),y(it,B,null),o(B,Sa),o(B,Xt),o(B,Xa),y(ve,B,null),o(B,qa),y(we,B,null),c(e,Hs,l),c(e,ls,l),As=!0},p(e,[l]){const dt={};l&2&&(dt.$$scope={dirty:l,ctx:e}),ae.$set(dt);const is={};l&2&&(is.$$scope={dirty:l,ctx:e}),ne.$set(is);const ds={};l&2&&(ds.$$scope={dirty:l,ctx:e}),re.$set(ds);const ct={};l&2&&(ct.$$scope={dirty:l,ctx:e}),ie.$set(ct);const cs={};l&2&&(cs.$$scope={dirty:l,ctx:e}),de.$set(cs);const ps={};l&2&&(ps.$$scope={dirty:l,ctx:e}),pe.$set(ps);const pt={};l&2&&(pt.$$scope={dirty:l,ctx:e}),me.$set(pt);const ms={};l&2&&(ms.$$scope={dirty:l,ctx:e}),ge.$set(ms);const hs={};l&2&&(hs.$$scope={dirty:l,ctx:e}),fe.$set(hs);const mt={};l&2&&(mt.$$scope={dirty:l,ctx:e}),_e.$set(mt);const gs={};l&2&&(gs.$$scope={dirty:l,ctx:e}),be.$set(gs);const fs={};l&2&&(fs.$$scope={dirty:l,ctx:e}),ve.$set(fs);const H={};l&2&&(H.$$scope={dirty:l,ctx:e}),we.$set(H)},i(e){As||(v(Fe.$$.fragment,e),v(Re.$$.fragment,e),v(Ge.$$.fragment,e),v(ze.$$.fragment,e),v(He.$$.fragment,e),v(Ae.$$.fragment,e),v(ae.$$.fragment,e),v(Le.$$.fragment,e),v(Se.$$.fragment,e),v(Xe.$$.fragment,e),v(ne.$$.fragment,e),v(re.$$.fragment,e),v(qe.$$.fragment,e),v(Ye.$$.fragment,e),v(Qe.$$.fragment,e),v(ie.$$.fragment,e),v(de.$$.fragment,e),v(De.$$.fragment,e),v(Oe.$$.fragment,e),v(Ke.$$.fragment,e),v(pe.$$.fragment,e),v(me.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(st.$$.fragment,e),v(ge.$$.fragment,e),v(fe.$$.fragment,e),v(at.$$.fragment,e),v(ot.$$.fragment,e),v(nt.$$.fragment,e),v(_e.$$.fragment,e),v(be.$$.fragment,e),v(rt.$$.fragment,e),v(lt.$$.fragment,e),v(it.$$.fragment,e),v(ve.$$.fragment,e),v(we.$$.fragment,e),As=!0)},o(e){w(Fe.$$.fragment,e),w(Re.$$.fragment,e),w(Ge.$$.fragment,e),w(ze.$$.fragment,e),w(He.$$.fragment,e),w(Ae.$$.fragment,e),w(ae.$$.fragment,e),w(Le.$$.fragment,e),w(Se.$$.fragment,e),w(Xe.$$.fragment,e),w(ne.$$.fragment,e),w(re.$$.fragment,e),w(qe.$$.fragment,e),w(Ye.$$.fragment,e),w(Qe.$$.fragment,e),w(ie.$$.fragment,e),w(de.$$.fragment,e),w(De.$$.fragment,e),w(Oe.$$.fragment,e),w(Ke.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(et.$$.fragment,e),w(tt.$$.fragment,e),w(st.$$.fragment,e),w(ge.$$.fragment,e),w(fe.$$.fragment,e),w(at.$$.fragment,e),w(ot.$$.fragment,e),w(nt.$$.fragment,e),w(_e.$$.fragment,e),w(be.$$.fragment,e),w(rt.$$.fragment,e),w(lt.$$.fragment,e),w(it.$$.fragment,e),w(ve.$$.fragment,e),w(we.$$.fragment,e),As=!1},d(e){e&&(t($),t(p),t(m),t(u),t(us),t(L),t(_s),t(Je),t(bs),t(Ue),t(ys),t(Ze),t(vs),t(Ie),t(ws),t(ke),t(Ms),t(We),t($s),t(Pe),t(Ts),t(S),t(xs),t(Be),t(Cs),t(Ns),t(Ve),t(js),t(Ee),t(Fs),t(X),t(Rs),t(R),t(Js),t(q),t(Us),t(z),t(Zs),t(Y),t(Is),t(J),t(ks),t(Q),t(Ws),t(V),t(Ps),t(D),t(Gs),t(E),t(Bs),t(O),t(zs),t(C),t(Vs),t(K),t(Es),t(N),t(Hs),t(ls)),t(s),M(Fe),M(Re),M(Ge),M(ze,e),M(He),M(Ae),M(ae),M(Le),M(Se),M(Xe),M(ne),M(re),M(qe),M(Ye),M(Qe),M(ie),M(de),M(De),M(Oe),M(Ke),M(pe),M(me),M(et),M(tt),M(st),M(ge),M(fe),M(at),M(ot),M(nt),M(_e),M(be),M(rt),M(lt),M(it),M(ve),M(we)}}}const bn={local:"regnet",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.RegNetConfig",title:"RegNetConfig"},{local:"transformers.RegNetModel",title:"RegNetModel"},{local:"transformers.RegNetForImageClassification",title:"RegNetForImageClassification"},{local:"transformers.TFRegNetModel",title:"TFRegNetModel"},{local:"transformers.TFRegNetForImageClassification",title:"TFRegNetForImageClassification"},{local:"transformers.FlaxRegNetModel",title:"FlaxRegNetModel"},{local:"transformers.FlaxRegNetForImageClassification",title:"FlaxRegNetForImageClassification"}],title:"RegNet"};function yn(x){return Oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jn extends Ko{constructor(s){super(),en(this,s,yn,_n,Do,{})}}export{jn as component};
