import{s as eo,n as to,o as oo}from"../chunks/scheduler.9bc65507.js";import{S as ro,i as no,g as o,s as a,u as w,A as ao,h as r,f as n,c as s,j as p,v as y,y as l,k as u,o as t,a as d,w as x,d as T,t as q,x as $}from"../chunks/index.78c82d43.js";import{D as N}from"../chunks/Docstring.4e7352e2.js";import{I as Zt}from"../chunks/IconCopyLink.bedaa44d.js";function so(bt){let C,ke,Te,ze,k,F,qe,E,Ge,R,wt="Utilities for <code>FeatureExtractors</code>",He,I,yt="This page lists all the utility functions that can be used by the audio <code>FeatureExtractor</code> in order to compute special features from a raw audio using common algorithms such as <em>Short Time Fourier Transform</em> or <em>log mel spectrogram</em>.",Me,S,xt="Most of those are only useful if you are studying the code of the audio processors in the library.",Fe,z,L,$e,B,Ke,J,Tt="Audio Transformations",Le,H,A,Re,Q,qt="Convert frequency from hertz to mels.",Pe,M,O,Je,X,$t="Convert frequency from mels to hertz.",De,f,U,Qe,Y,Ct=`Creates a frequency bin conversion matrix used to obtain a mel spectrogram. This is called a <em>mel filter bank</em>, and
various implementation exist, which differ in the number of filters, the shape of the filters, the way the filters
are spaced, the bandwidth of the filters, and the manner in which the spectrum is warped. The goal of these
features is to approximate the non-linear human perception of the variation in pitch with respect to the frequency.`,Xe,Z,kt="Different banks of mel filters were introduced in the literature. The following variations are supported:",Ye,ee,zt=`<li>MFCC FB-20: introduced in 1980 by Davis and Mermelstein, it assumes a sampling frequency of 10 kHz and a speech
bandwidth of <code>[0, 4600]</code> Hz.</li> <li>MFCC FB-24 HTK: from the Cambridge HMM Toolkit (HTK) (1995) uses a filter bank of 24 filters for a speech
bandwidth of <code>[0, 8000]</code> Hz. This assumes sampling rate ≥ 16 kHz.</li> <li>MFCC FB-40: from the Auditory Toolbox for MATLAB written by Slaney in 1998, assumes a sampling rate of 16 kHz and
speech bandwidth of <code>[133, 6854]</code> Hz. This version also includes area normalization.</li> <li>HFCC-E FB-29 (Human Factor Cepstral Coefficients) of Skowronski and Harris (2004), assumes a sampling rate of
12.5 kHz and speech bandwidth of <code>[0, 6250]</code> Hz.</li>`,Ze,te,Ht=`This code is adapted from <em>torchaudio</em> and <em>librosa</em>. Note that the default parameters of torchaudio’s
<code>melscale_fbanks</code> implement the <code>&quot;htk&quot;</code> filters while librosa uses the <code>&quot;slaney&quot;</code> implementation.`,Ne,_,j,et,oe,Mt=`Finds the best FFT input size for a given <code>window_length</code>. This function takes a given window length and, if not
already a power of two, rounds it up to the next power or two.`,tt,re,Ft=`The FFT algorithm works fastest when the length of the input is a power of two, which may be larger than the size
of the window or analysis frame. For example, if the window is 400 samples, using an FFT input size of 512 samples
is more optimal than an FFT size of 400 samples. Using a larger FFT size does not affect the detected frequencies,
it simply gives a higher frequency resolution (i.e. the frequency bins are smaller).`,Ee,h,V,ot,ne,Lt="Returns an array containing the specified window. This window is intended to be used with <code>stft</code>.",rt,ae,Pt="The following window types are supported:",nt,se,Dt="<li><code>&quot;boxcar&quot;</code>: a rectangular window</li> <li><code>&quot;hamming&quot;</code>: the Hamming window</li> <li><code>&quot;hann&quot;</code>: the Hann window</li> <li><code>&quot;povey&quot;</code>: the Povey window</li>",Ie,c,W,at,ie,Nt="Calculates a spectrogram over one waveform using the Short-Time Fourier Transform.",st,le,Et="This function can create the following kinds of spectrograms:",it,de,It="<li>amplitude spectrogram (<code>power = 1.0</code>)</li> <li>power spectrogram (<code>power = 2.0</code>)</li> <li>complex-valued spectrogram (<code>power = None</code>)</li> <li>log spectrogram (use <code>log_mel</code> argument)</li> <li>mel spectrogram (provide <code>mel_filters</code>)</li> <li>log-mel spectrogram (provide <code>mel_filters</code> and <code>log_mel</code>)</li>",lt,ce,St="How this works:",dt,me,Bt="<li>The input waveform is split into frames of size <code>frame_length</code> that are partially overlapping by `frame_length<ul><li>hop_length` samples.</li></ul></li> <li>Each frame is multiplied by the window and placed into a buffer of size <code>fft_length</code>.</li> <li>The DFT is taken of each windowed frame.</li> <li>The results are stacked into a spectrogram.</li>",ct,ue,At="We make a distinction between the following “blocks” of sample data, each of which may have a different lengths:",mt,pe,Ot="<li>The analysis frame. This is the size of the time slices that the input waveform is split into.</li> <li>The window. Each analysis frame is multiplied by the window to avoid spectral leakage.</li> <li>The FFT input buffer. The length of this determines how many frequency bins are in the spectrogram.</li>",ut,fe,Ut=`In this implementation, the window is assumed to be zero-padded to have the same size as the analysis frame. A
padded window can be obtained from <code>window_function()</code>. The FFT input buffer may be larger than the analysis frame,
typically the next power of two.`,pt,he,jt=`Note: This function is not optimized for speed yet. It should be mostly compatible with <code>librosa.stft</code> and
<code>torchaudio.functional.transforms.Spectrogram</code>, although it is more flexible due to the different ways spectrograms
can be constructed.`,Se,g,G,ft,ge,Vt=`Converts a power spectrogram to the decibel scale. This computes <code>10 * log10(spectrogram / reference)</code>, using basic
logarithm properties for numerical stability.`,ht,_e,Wt=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,gt,ve,Gt="Based on the implementation of <code>librosa.power_to_db</code>.",Be,v,K,_t,be,Kt=`Converts an amplitude spectrogram to the decibel scale. This computes <code>20 * log10(spectrogram / reference)</code>, using
basic logarithm properties for numerical stability.`,vt,we,Rt=`The motivation behind applying the log function on the (mel) spectrogram is that humans do not hear loudness on a
linear scale. Generally to double the perceived volume of a sound we need to put 8 times as much energy into it.
This means that large variations in energy may not sound all that different if the sound is loud to begin with.
This compression operation makes the (mel) spectrogram features match more closely what humans actually hear.`,Ae,Ce,Oe;return E=new Zt({}),B=new Zt({}),A=new N({props:{name:"transformers.audio_utils.hertz_to_mel",anchor:"transformers.audio_utils.hertz_to_mel",parameters:[{name:"freq",val:": typing.Union[float, numpy.ndarray]"},{name:"mel_scale",val:": str = 'htk'"}],parametersDescription:[{anchor:"transformers.audio_utils.hertz_to_mel.freq",description:`<strong>freq</strong> (<code>float</code> or <code>np.ndarray</code>) &#x2014;
The frequency, or multiple frequencies, in hertz (Hz).`,name:"freq"},{anchor:"transformers.audio_utils.hertz_to_mel.mel_scale",description:`<strong>mel_scale</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;htk&quot;</code>) &#x2014;
The mel frequency scale to use, <code>&quot;htk&quot;</code>, <code>&quot;kaldi&quot;</code> or <code>&quot;slaney&quot;</code>.`,name:"mel_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L25",returnDescription:`
<p>The frequencies on the mel scale.</p>
`,returnType:`
<p><code>float</code> or <code>np.ndarray</code></p>
`}}),O=new N({props:{name:"transformers.audio_utils.mel_to_hertz",anchor:"transformers.audio_utils.mel_to_hertz",parameters:[{name:"mels",val:": typing.Union[float, numpy.ndarray]"},{name:"mel_scale",val:": str = 'htk'"}],parametersDescription:[{anchor:"transformers.audio_utils.mel_to_hertz.mels",description:`<strong>mels</strong> (<code>float</code> or <code>np.ndarray</code>) &#x2014;
The frequency, or multiple frequencies, in mels.`,name:"mels"},{anchor:"transformers.audio_utils.mel_to_hertz.mel_scale",description:`<strong>mel_scale</strong> (<code>str</code>, <em>optional</em>, <code>&quot;htk&quot;</code>) &#x2014;
The mel frequency scale to use, <code>&quot;htk&quot;</code>, <code>&quot;kaldi&quot;</code> or <code>&quot;slaney&quot;</code>.`,name:"mel_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L61",returnDescription:`
<p>The frequencies in hertz.</p>
`,returnType:`
<p><code>float</code> or <code>np.ndarray</code></p>
`}}),U=new N({props:{name:"transformers.audio_utils.mel_filter_bank",anchor:"transformers.audio_utils.mel_filter_bank",parameters:[{name:"num_frequency_bins",val:": int"},{name:"num_mel_filters",val:": int"},{name:"min_frequency",val:": float"},{name:"max_frequency",val:": float"},{name:"sampling_rate",val:": int"},{name:"norm",val:": typing.Optional[str] = None"},{name:"mel_scale",val:": str = 'htk'"},{name:"triangularize_in_mel_space",val:": bool = False"}],parametersDescription:[{anchor:"transformers.audio_utils.mel_filter_bank.num_frequency_bins",description:`<strong>num_frequency_bins</strong> (<code>int</code>) &#x2014;
Number of frequencies used to compute the spectrogram (should be the same as in <code>stft</code>).`,name:"num_frequency_bins"},{anchor:"transformers.audio_utils.mel_filter_bank.num_mel_filters",description:`<strong>num_mel_filters</strong> (<code>int</code>) &#x2014;
Number of mel filters to generate.`,name:"num_mel_filters"},{anchor:"transformers.audio_utils.mel_filter_bank.min_frequency",description:`<strong>min_frequency</strong> (<code>float</code>) &#x2014;
Lowest frequency of interest in Hz.`,name:"min_frequency"},{anchor:"transformers.audio_utils.mel_filter_bank.max_frequency",description:`<strong>max_frequency</strong> (<code>float</code>) &#x2014;
Highest frequency of interest in Hz. This should not exceed <code>sampling_rate / 2</code>.`,name:"max_frequency"},{anchor:"transformers.audio_utils.mel_filter_bank.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>) &#x2014;
Sample rate of the audio waveform.`,name:"sampling_rate"},{anchor:"transformers.audio_utils.mel_filter_bank.norm",description:`<strong>norm</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If <code>&quot;slaney&quot;</code>, divide the triangular mel weights by the width of the mel band (area normalization).`,name:"norm"},{anchor:"transformers.audio_utils.mel_filter_bank.mel_scale",description:`<strong>mel_scale</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;htk&quot;</code>) &#x2014;
The mel frequency scale to use, <code>&quot;htk&quot;</code>, <code>&quot;kaldi&quot;</code> or <code>&quot;slaney&quot;</code>.`,name:"mel_scale"},{anchor:"transformers.audio_utils.mel_filter_bank.triangularize_in_mel_space",description:`<strong>triangularize_in_mel_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If this option is enabled, the triangular filter is applied in mel space rather than frequency space. This
should be set to <code>true</code> in order to get the same results as <code>torchaudio</code> when computing mel filters.`,name:"triangularize_in_mel_space"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L119",returnDescription:`
<p>Triangular filter bank matrix. This is a
projection matrix to go from a spectrogram to a mel spectrogram.</p>
`,returnType:`
<p><code>np.ndarray</code> of shape (<code>num_frequency_bins</code>, <code>num_mel_filters</code>)</p>
`}}),j=new N({props:{name:"transformers.audio_utils.optimal_fft_length",anchor:"transformers.audio_utils.optimal_fft_length",parameters:[{name:"window_length",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L207"}}),V=new N({props:{name:"transformers.audio_utils.window_function",anchor:"transformers.audio_utils.window_function",parameters:[{name:"window_length",val:": int"},{name:"name",val:": str = 'hann'"},{name:"periodic",val:": bool = True"},{name:"frame_length",val:": typing.Optional[int] = None"},{name:"center",val:": bool = True"}],parametersDescription:[{anchor:"transformers.audio_utils.window_function.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the window in samples.`,name:"window_length"},{anchor:"transformers.audio_utils.window_function.name",description:`<strong>name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;hann&quot;</code>) &#x2014;
The name of the window function.`,name:"name"},{anchor:"transformers.audio_utils.window_function.periodic",description:`<strong>periodic</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the window is periodic or symmetric.`,name:"periodic"},{anchor:"transformers.audio_utils.window_function.frame_length",description:`<strong>frame_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of the analysis frames in samples. Provide a value for <code>frame_length</code> if the window is smaller
than the frame length, so that it will be zero-padded.`,name:"frame_length"},{anchor:"transformers.audio_utils.window_function.center",description:`<strong>center</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center the window inside the FFT buffer. Only used when <code>frame_length</code> is provided.`,name:"center"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L220",returnDescription:`
<p><code>np.ndarray</code> of shape <code>(window_length,)</code> or <code>(frame_length,)</code> containing the window.</p>
`}}),W=new N({props:{name:"transformers.audio_utils.spectrogram",anchor:"transformers.audio_utils.spectrogram",parameters:[{name:"waveform",val:": ndarray"},{name:"window",val:": ndarray"},{name:"frame_length",val:": int"},{name:"hop_length",val:": int"},{name:"fft_length",val:": typing.Optional[int] = None"},{name:"power",val:": typing.Optional[float] = 1.0"},{name:"center",val:": bool = True"},{name:"pad_mode",val:": str = 'reflect'"},{name:"onesided",val:": bool = True"},{name:"preemphasis",val:": typing.Optional[float] = None"},{name:"mel_filters",val:": typing.Optional[numpy.ndarray] = None"},{name:"mel_floor",val:": float = 1e-10"},{name:"log_mel",val:": typing.Optional[str] = None"},{name:"reference",val:": float = 1.0"},{name:"min_value",val:": float = 1e-10"},{name:"db_range",val:": typing.Optional[float] = None"},{name:"remove_dc_offset",val:": typing.Optional[bool] = None"},{name:"dtype",val:": dtype = <class 'numpy.float32'>"}],parametersDescription:[{anchor:"transformers.audio_utils.spectrogram.waveform",description:`<strong>waveform</strong> (<code>np.ndarray</code> of shape <code>(length,)</code>) &#x2014;
The input waveform. This must be a single real-valued, mono waveform.`,name:"waveform"},{anchor:"transformers.audio_utils.spectrogram.window",description:`<strong>window</strong> (<code>np.ndarray</code> of shape <code>(frame_length,)</code>) &#x2014;
The windowing function to apply, including zero-padding if necessary. The actual window length may be
shorter than <code>frame_length</code>, but we&#x2019;re assuming the array has already been zero-padded.`,name:"window"},{anchor:"transformers.audio_utils.spectrogram.frame_length",description:`<strong>frame_length</strong> (<code>int</code>) &#x2014;
The length of the analysis frames in samples. With librosa this is always equal to <code>fft_length</code> but we also
allow smaller sizes.`,name:"frame_length"},{anchor:"transformers.audio_utils.spectrogram.hop_length",description:`<strong>hop_length</strong> (<code>int</code>) &#x2014;
The stride between successive analysis frames in samples.`,name:"hop_length"},{anchor:"transformers.audio_utils.spectrogram.fft_length",description:`<strong>fft_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The size of the FFT buffer in samples. This determines how many frequency bins the spectrogram will have.
For optimal speed, this should be a power of two. If <code>None</code>, uses <code>frame_length</code>.`,name:"fft_length"},{anchor:"transformers.audio_utils.spectrogram.power",description:`<strong>power</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If 1.0, returns the amplitude spectrogram. If 2.0, returns the power spectrogram. If <code>None</code>, returns
complex numbers.`,name:"power"},{anchor:"transformers.audio_utils.spectrogram.center",description:`<strong>center</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the waveform so that frame <code>t</code> is centered around time <code>t * hop_length</code>. If <code>False</code>, frame
<code>t</code> will start at time <code>t * hop_length</code>.`,name:"center"},{anchor:"transformers.audio_utils.spectrogram.pad_mode",description:`<strong>pad_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;reflect&quot;</code>) &#x2014;
Padding mode used when <code>center</code> is <code>True</code>. Possible values are: <code>&quot;constant&quot;</code> (pad with zeros), <code>&quot;edge&quot;</code>
(pad with edge values), <code>&quot;reflect&quot;</code> (pads with mirrored values).`,name:"pad_mode"},{anchor:"transformers.audio_utils.spectrogram.onesided",description:`<strong>onesided</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, only computes the positive frequencies and returns a spectrogram containing <code>fft_length // 2 + 1</code>
frequency bins. If False, also computes the negative frequencies and returns <code>fft_length</code> frequency bins.`,name:"onesided"},{anchor:"transformers.audio_utils.spectrogram.preemphasis",description:`<strong>preemphasis</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Coefficient for a low-pass filter that applies pre-emphasis before the DFT.`,name:"preemphasis"},{anchor:"transformers.audio_utils.spectrogram.mel_filters",description:`<strong>mel_filters</strong> (<code>np.ndarray</code> of shape <code>(num_freq_bins, num_mel_filters)</code>, <em>optional</em>) &#x2014;
The mel filter bank. If supplied, applies a this filter bank to create a mel spectrogram.`,name:"mel_filters"},{anchor:"transformers.audio_utils.spectrogram.mel_floor",description:`<strong>mel_floor</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-10) &#x2014;
Minimum value of mel frequency banks.`,name:"mel_floor"},{anchor:"transformers.audio_utils.spectrogram.log_mel",description:`<strong>log_mel</strong> (<code>str</code>, <em>optional</em>) &#x2014;
How to convert the spectrogram to log scale. Possible options are: <code>None</code> (don&#x2019;t convert), <code>&quot;log&quot;</code> (take
the natural logarithm) <code>&quot;log10&quot;</code> (take the base-10 logarithm), <code>&quot;dB&quot;</code> (convert to decibels). Can only be
used when <code>power</code> is not <code>None</code>.`,name:"log_mel"},{anchor:"transformers.audio_utils.spectrogram.reference",description:`<strong>reference</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>np.max(spectrogram)</code> to set
the loudest part to 0 dB. Must be greater than zero.`,name:"reference"},{anchor:"transformers.audio_utils.spectrogram.min_value",description:`<strong>min_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-10</code>) &#x2014;
The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking
<code>log(0)</code>. For a power spectrogram, the default of <code>1e-10</code> corresponds to a minimum of -100 dB. For an
amplitude spectrogram, the value <code>1e-5</code> corresponds to -100 dB. Must be greater than zero.`,name:"min_value"},{anchor:"transformers.audio_utils.spectrogram.db_range",description:`<strong>db_range</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.`,name:"db_range"},{anchor:"transformers.audio_utils.spectrogram.remove_dc_offset",description:`<strong>remove_dc_offset</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Subtract mean from waveform on each frame, applied before pre-emphasis. This should be set to <code>true</code> in
order to get the same results as <code>torchaudio.compliance.kaldi.fbank</code> when computing mel filters.`,name:"remove_dc_offset"},{anchor:"transformers.audio_utils.spectrogram.dtype",description:`<strong>dtype</strong> (<code>np.dtype</code>, <em>optional</em>, defaults to <code>np.float32</code>) &#x2014;
Data type of the spectrogram tensor. If <code>power</code> is None, this argument is ignored and the dtype will be
<code>np.complex64</code>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L284",returnDescription:`
<p><code>nd.array</code> containing a spectrogram of shape <code>(num_frequency_bins, length)</code> for a regular spectrogram or shape
<code>(num_mel_filters, length)</code> for a mel spectrogram.</p>
`}}),G=new N({props:{name:"transformers.audio_utils.power_to_db",anchor:"transformers.audio_utils.power_to_db",parameters:[{name:"spectrogram",val:": ndarray"},{name:"reference",val:": float = 1.0"},{name:"min_value",val:": float = 1e-10"},{name:"db_range",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.audio_utils.power_to_db.spectrogram",description:`<strong>spectrogram</strong> (<code>np.ndarray</code>) &#x2014;
The input power (mel) spectrogram. Note that a power spectrogram has the amplitudes squared!`,name:"spectrogram"},{anchor:"transformers.audio_utils.power_to_db.reference",description:`<strong>reference</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>np.max(spectrogram)</code> to set
the loudest part to 0 dB. Must be greater than zero.`,name:"reference"},{anchor:"transformers.audio_utils.power_to_db.min_value",description:`<strong>min_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-10</code>) &#x2014;
The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking
<code>log(0)</code>. The default of <code>1e-10</code> corresponds to a minimum of -100 dB. Must be greater than zero.`,name:"min_value"},{anchor:"transformers.audio_utils.power_to_db.db_range",description:`<strong>db_range</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.`,name:"db_range"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L479",returnDescription:`
<p>the spectrogram in decibels</p>
`,returnType:`
<p><code>np.ndarray</code></p>
`}}),K=new N({props:{name:"transformers.audio_utils.amplitude_to_db",anchor:"transformers.audio_utils.amplitude_to_db",parameters:[{name:"spectrogram",val:": ndarray"},{name:"reference",val:": float = 1.0"},{name:"min_value",val:": float = 1e-05"},{name:"db_range",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.audio_utils.amplitude_to_db.spectrogram",description:`<strong>spectrogram</strong> (<code>np.ndarray</code>) &#x2014;
The input amplitude (mel) spectrogram.`,name:"spectrogram"},{anchor:"transformers.audio_utils.amplitude_to_db.reference",description:`<strong>reference</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Sets the input spectrogram value that corresponds to 0 dB. For example, use <code>np.max(spectrogram)</code> to set
the loudest part to 0 dB. Must be greater than zero.`,name:"reference"},{anchor:"transformers.audio_utils.amplitude_to_db.min_value",description:`<strong>min_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-5</code>) &#x2014;
The spectrogram will be clipped to this minimum value before conversion to decibels, to avoid taking
<code>log(0)</code>. The default of <code>1e-5</code> corresponds to a minimum of -100 dB. Must be greater than zero.`,name:"min_value"},{anchor:"transformers.audio_utils.amplitude_to_db.db_range",description:`<strong>db_range</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Sets the maximum dynamic range in decibels. For example, if <code>db_range = 80</code>, the difference between the
peak value and the smallest value will never be more than 80 dB. Must be greater than zero.`,name:"db_range"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/audio_utils.py#L530",returnDescription:`
<p>the spectrogram in decibels</p>
`,returnType:`
<p><code>np.ndarray</code></p>
`}}),{c(){C=o("meta"),ke=a(),Te=o("p"),ze=a(),k=o("h1"),F=o("a"),qe=o("span"),w(E.$$.fragment),Ge=a(),R=o("span"),R.innerHTML=wt,He=a(),I=o("p"),I.innerHTML=yt,Me=a(),S=o("p"),S.textContent=xt,Fe=a(),z=o("h2"),L=o("a"),$e=o("span"),w(B.$$.fragment),Ke=a(),J=o("span"),J.textContent=Tt,Le=a(),H=o("div"),w(A.$$.fragment),Re=a(),Q=o("p"),Q.textContent=qt,Pe=a(),M=o("div"),w(O.$$.fragment),Je=a(),X=o("p"),X.textContent=$t,De=a(),f=o("div"),w(U.$$.fragment),Qe=a(),Y=o("p"),Y.innerHTML=Ct,Xe=a(),Z=o("p"),Z.textContent=kt,Ye=a(),ee=o("ul"),ee.innerHTML=zt,Ze=a(),te=o("p"),te.innerHTML=Ht,Ne=a(),_=o("div"),w(j.$$.fragment),et=a(),oe=o("p"),oe.innerHTML=Mt,tt=a(),re=o("p"),re.textContent=Ft,Ee=a(),h=o("div"),w(V.$$.fragment),ot=a(),ne=o("p"),ne.innerHTML=Lt,rt=a(),ae=o("p"),ae.textContent=Pt,nt=a(),se=o("ul"),se.innerHTML=Dt,Ie=a(),c=o("div"),w(W.$$.fragment),at=a(),ie=o("p"),ie.textContent=Nt,st=a(),le=o("p"),le.textContent=Et,it=a(),de=o("ul"),de.innerHTML=It,lt=a(),ce=o("p"),ce.textContent=St,dt=a(),me=o("ol"),me.innerHTML=Bt,ct=a(),ue=o("p"),ue.textContent=At,mt=a(),pe=o("ul"),pe.innerHTML=Ot,ut=a(),fe=o("p"),fe.innerHTML=Ut,pt=a(),he=o("p"),he.innerHTML=jt,Se=a(),g=o("div"),w(G.$$.fragment),ft=a(),ge=o("p"),ge.innerHTML=Vt,ht=a(),_e=o("p"),_e.textContent=Wt,gt=a(),ve=o("p"),ve.innerHTML=Gt,Be=a(),v=o("div"),w(K.$$.fragment),_t=a(),be=o("p"),be.innerHTML=Kt,vt=a(),we=o("p"),we.textContent=Rt,Ae=a(),Ce=o("p"),this.h()},l(e){const i=ao("svelte-1phssyn",document.head);C=r(i,"META",{name:!0,content:!0}),i.forEach(n),ke=s(e),Te=r(e,"P",{}),p(Te).forEach(n),ze=s(e),k=r(e,"H1",{class:!0});var Ue=p(k);F=r(Ue,"A",{id:!0,class:!0,href:!0});var Jt=p(F);qe=r(Jt,"SPAN",{});var Qt=p(qe);y(E.$$.fragment,Qt),Qt.forEach(n),Jt.forEach(n),Ge=s(Ue),R=r(Ue,"SPAN",{"data-svelte-h":!0}),l(R)!=="svelte-86ckkg"&&(R.innerHTML=wt),Ue.forEach(n),He=s(e),I=r(e,"P",{"data-svelte-h":!0}),l(I)!=="svelte-sdayy0"&&(I.innerHTML=yt),Me=s(e),S=r(e,"P",{"data-svelte-h":!0}),l(S)!=="svelte-1o3lpho"&&(S.textContent=xt),Fe=s(e),z=r(e,"H2",{class:!0});var je=p(z);L=r(je,"A",{id:!0,class:!0,href:!0});var Xt=p(L);$e=r(Xt,"SPAN",{});var Yt=p($e);y(B.$$.fragment,Yt),Yt.forEach(n),Xt.forEach(n),Ke=s(je),J=r(je,"SPAN",{"data-svelte-h":!0}),l(J)!=="svelte-1ju3eab"&&(J.textContent=Tt),je.forEach(n),Le=s(e),H=r(e,"DIV",{class:!0});var Ve=p(H);y(A.$$.fragment,Ve),Re=s(Ve),Q=r(Ve,"P",{"data-svelte-h":!0}),l(Q)!=="svelte-cxvipk"&&(Q.textContent=qt),Ve.forEach(n),Pe=s(e),M=r(e,"DIV",{class:!0});var We=p(M);y(O.$$.fragment,We),Je=s(We),X=r(We,"P",{"data-svelte-h":!0}),l(X)!=="svelte-zjf634"&&(X.textContent=$t),We.forEach(n),De=s(e),f=r(e,"DIV",{class:!0});var b=p(f);y(U.$$.fragment,b),Qe=s(b),Y=r(b,"P",{"data-svelte-h":!0}),l(Y)!=="svelte-ke4v6b"&&(Y.innerHTML=Ct),Xe=s(b),Z=r(b,"P",{"data-svelte-h":!0}),l(Z)!=="svelte-1qgwg3t"&&(Z.textContent=kt),Ye=s(b),ee=r(b,"UL",{"data-svelte-h":!0}),l(ee)!=="svelte-hp9cn6"&&(ee.innerHTML=zt),Ze=s(b),te=r(b,"P",{"data-svelte-h":!0}),l(te)!=="svelte-7p7meu"&&(te.innerHTML=Ht),b.forEach(n),Ne=s(e),_=r(e,"DIV",{class:!0});var ye=p(_);y(j.$$.fragment,ye),et=s(ye),oe=r(ye,"P",{"data-svelte-h":!0}),l(oe)!=="svelte-7kwh1t"&&(oe.innerHTML=Mt),tt=s(ye),re=r(ye,"P",{"data-svelte-h":!0}),l(re)!=="svelte-iy5srj"&&(re.textContent=Ft),ye.forEach(n),Ee=s(e),h=r(e,"DIV",{class:!0});var P=p(h);y(V.$$.fragment,P),ot=s(P),ne=r(P,"P",{"data-svelte-h":!0}),l(ne)!=="svelte-1ws351k"&&(ne.innerHTML=Lt),rt=s(P),ae=r(P,"P",{"data-svelte-h":!0}),l(ae)!=="svelte-tutl6h"&&(ae.textContent=Pt),nt=s(P),se=r(P,"UL",{"data-svelte-h":!0}),l(se)!=="svelte-1wr1sb5"&&(se.innerHTML=Dt),P.forEach(n),Ie=s(e),c=r(e,"DIV",{class:!0});var m=p(c);y(W.$$.fragment,m),at=s(m),ie=r(m,"P",{"data-svelte-h":!0}),l(ie)!=="svelte-10mwufd"&&(ie.textContent=Nt),st=s(m),le=r(m,"P",{"data-svelte-h":!0}),l(le)!=="svelte-zfp2ya"&&(le.textContent=Et),it=s(m),de=r(m,"UL",{"data-svelte-h":!0}),l(de)!=="svelte-14mziv8"&&(de.innerHTML=It),lt=s(m),ce=r(m,"P",{"data-svelte-h":!0}),l(ce)!=="svelte-axepee"&&(ce.textContent=St),dt=s(m),me=r(m,"OL",{"data-svelte-h":!0}),l(me)!=="svelte-op5gf3"&&(me.innerHTML=Bt),ct=s(m),ue=r(m,"P",{"data-svelte-h":!0}),l(ue)!=="svelte-12asmlu"&&(ue.textContent=At),mt=s(m),pe=r(m,"UL",{"data-svelte-h":!0}),l(pe)!=="svelte-6jlau3"&&(pe.innerHTML=Ot),ut=s(m),fe=r(m,"P",{"data-svelte-h":!0}),l(fe)!=="svelte-ugu4qd"&&(fe.innerHTML=Ut),pt=s(m),he=r(m,"P",{"data-svelte-h":!0}),l(he)!=="svelte-1jpjddx"&&(he.innerHTML=jt),m.forEach(n),Se=s(e),g=r(e,"DIV",{class:!0});var D=p(g);y(G.$$.fragment,D),ft=s(D),ge=r(D,"P",{"data-svelte-h":!0}),l(ge)!=="svelte-1m05y0g"&&(ge.innerHTML=Vt),ht=s(D),_e=r(D,"P",{"data-svelte-h":!0}),l(_e)!=="svelte-12zo44d"&&(_e.textContent=Wt),gt=s(D),ve=r(D,"P",{"data-svelte-h":!0}),l(ve)!=="svelte-1bxqqp"&&(ve.innerHTML=Gt),D.forEach(n),Be=s(e),v=r(e,"DIV",{class:!0});var xe=p(v);y(K.$$.fragment,xe),_t=s(xe),be=r(xe,"P",{"data-svelte-h":!0}),l(be)!=="svelte-lpto01"&&(be.innerHTML=Kt),vt=s(xe),we=r(xe,"P",{"data-svelte-h":!0}),l(we)!=="svelte-12zo44d"&&(we.textContent=Rt),xe.forEach(n),Ae=s(e),Ce=r(e,"P",{}),p(Ce).forEach(n),this.h()},h(){u(C,"name","hf:doc:metadata"),u(C,"content",JSON.stringify(io)),u(F,"id","utilities-for-featureextractors"),u(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(F,"href","#utilities-for-featureextractors"),u(k,"class","relative group"),u(L,"id","transformers.audio_utils.hertz_to_mel"),u(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(L,"href","#transformers.audio_utils.hertz_to_mel"),u(z,"class","relative group"),u(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,C),d(e,ke,i),d(e,Te,i),d(e,ze,i),d(e,k,i),t(k,F),t(F,qe),x(E,qe,null),t(k,Ge),t(k,R),d(e,He,i),d(e,I,i),d(e,Me,i),d(e,S,i),d(e,Fe,i),d(e,z,i),t(z,L),t(L,$e),x(B,$e,null),t(z,Ke),t(z,J),d(e,Le,i),d(e,H,i),x(A,H,null),t(H,Re),t(H,Q),d(e,Pe,i),d(e,M,i),x(O,M,null),t(M,Je),t(M,X),d(e,De,i),d(e,f,i),x(U,f,null),t(f,Qe),t(f,Y),t(f,Xe),t(f,Z),t(f,Ye),t(f,ee),t(f,Ze),t(f,te),d(e,Ne,i),d(e,_,i),x(j,_,null),t(_,et),t(_,oe),t(_,tt),t(_,re),d(e,Ee,i),d(e,h,i),x(V,h,null),t(h,ot),t(h,ne),t(h,rt),t(h,ae),t(h,nt),t(h,se),d(e,Ie,i),d(e,c,i),x(W,c,null),t(c,at),t(c,ie),t(c,st),t(c,le),t(c,it),t(c,de),t(c,lt),t(c,ce),t(c,dt),t(c,me),t(c,ct),t(c,ue),t(c,mt),t(c,pe),t(c,ut),t(c,fe),t(c,pt),t(c,he),d(e,Se,i),d(e,g,i),x(G,g,null),t(g,ft),t(g,ge),t(g,ht),t(g,_e),t(g,gt),t(g,ve),d(e,Be,i),d(e,v,i),x(K,v,null),t(v,_t),t(v,be),t(v,vt),t(v,we),d(e,Ae,i),d(e,Ce,i),Oe=!0},p:to,i(e){Oe||(T(E.$$.fragment,e),T(B.$$.fragment,e),T(A.$$.fragment,e),T(O.$$.fragment,e),T(U.$$.fragment,e),T(j.$$.fragment,e),T(V.$$.fragment,e),T(W.$$.fragment,e),T(G.$$.fragment,e),T(K.$$.fragment,e),Oe=!0)},o(e){q(E.$$.fragment,e),q(B.$$.fragment,e),q(A.$$.fragment,e),q(O.$$.fragment,e),q(U.$$.fragment,e),q(j.$$.fragment,e),q(V.$$.fragment,e),q(W.$$.fragment,e),q(G.$$.fragment,e),q(K.$$.fragment,e),Oe=!1},d(e){e&&(n(ke),n(Te),n(ze),n(k),n(He),n(I),n(Me),n(S),n(Fe),n(z),n(Le),n(H),n(Pe),n(M),n(De),n(f),n(Ne),n(_),n(Ee),n(h),n(Ie),n(c),n(Se),n(g),n(Be),n(v),n(Ae),n(Ce)),n(C),$(E),$(B),$(A),$(O),$(U),$(j),$(V),$(W),$(G),$(K)}}}const io={local:"utilities-for-featureextractors",sections:[{local:"transformers.audio_utils.hertz_to_mel",title:"Audio Transformations"}],title:"Utilities for `FeatureExtractors`"};function lo(bt){return oo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fo extends ro{constructor(C){super(),no(this,C,lo,so,eo,{})}}export{fo as component};
