import{s as h0,o as f0,n as U}from"../chunks/scheduler.9bc65507.js";import{S as _0,i as b0,g as s,s as r,u as d,A as v0,h as o,f as n,c as a,j as f,v as p,y as v,k as l,o as t,a as c,w as m,d as g,t as u,x as h}from"../chunks/index.78c82d43.js";import{T as os}from"../chunks/Tip.87d55b76.js";import{D as y}from"../chunks/Docstring.4e7352e2.js";import{C as I}from"../chunks/CodeBlock.73e038be.js";import{I as G}from"../chunks/IconCopyLink.bedaa44d.js";import{E as D}from"../chunks/ExampleCodeBlock.872b014d.js";function y0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBlcHNpbG9uJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMjBOb3RlJTIwdGhhdCUyMHRoaXMlMjBpcyUyMHNpbWlsYXIlMjB0byUwQSUyMyUyMFRvcCUyMFAlMjBzYW1wbGluZyUyQyUyMHdoaWNoJTIwcmVzdHJpY3RzJTIwdG9rZW5zJTIwYmFzZWQlMjBvbiUyMHRoZWlyJTIwY3VtdWxhdGl2ZSUyMHByb2JhYmlsaXR5LiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function T0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBldGElMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyMFlvdSUyMGNhbiUyMHNlZSUyMGl0JTIwYXMlMjBhJTIwZHluYW1pYyUyMGZvcm0lMjBvZiUwQSUyMyUyMGVwc2lsb24lMjBzYW1wbGluZyUyMHRoYXQlMjBhZGFwdHMlMjBpdHMlMjBjdXRvZmYlMjBwcm9iYWJpbGl0eSUyMGJhc2VkJTIwb24lMjB0aGUlMjBlbnRyb3B5JTIwKGhpZ2glMjBlbnRyb3B5JTIwJTNEJTIwbG93ZXIlMjBjdXRvZmYpLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function $0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences without exponential penalty. We want short sentences, so we limit max_length=30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see that the answer tends to end abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I<span class="hljs-string">&#x27;m not even a lawyer. I&#x27;</span>m a man. I have no real knowledge of politics. I<span class="hljs-string">&#x27;m a

&gt;&gt;&gt; # Generate sequences with exponential penalty, we add the exponential_decay_length_penalty=(start_index, decay_factor)
&gt;&gt;&gt; # We see that instead of cutting at max_tokens, the output comes to an end before (at 25 tokens) and with more meaning
&gt;&gt;&gt; # What happens is that starting from \`start_index\` the EOS token score will be increased by decay_factor exponentially
&gt;&gt;&gt; outputs = model.generate(
...     **inputs,
...     do_sample=True,
...     temperature=0.9,
...     max_length=30,
...     pad_token_id=50256,
...     exponential_decay_length_penalty=(15, 1.6),
... )
&gt;&gt;&gt; print(tokenizer.batch_decode(outputs)[0])
Just wanted to let you know, I&#x27;</span>ve got a very cool t-shirt educating people on how to use the Internet&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate sequences with smaller decay_factor, still improving the hard cutoff mid-sentence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.05</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I<span class="hljs-string">&#x27;ve been working on it for about 6 months and now it&#x27;</span>s <span class="hljs-keyword">in</span> Alpha.&lt;|endoftext|&gt;`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function w0(x){let b,k=`Diverse beam search can be particularly useful in scenarios where a variety of different outputs is desired, rather
than multiple similar sequences. It allows the model to explore different generation paths and provides a broader
coverage of possible outputs.`;return{c(){b=s("p"),b.textContent=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-xttj3z"&&(b.textContent=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function k0(x){let b,k="This logits processor can be resource-intensive, especially when using large models or long sequences.";return{c(){b=s("p"),b.textContent=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-6lf7c0"&&(b.textContent=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function M0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function x0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwSWYlMjB0aGUlMjBtYXhpbXVtJTIwbGVuZ3RoJTIwKGRlZmF1bHQlMjAlM0QlMjAyMCklMjBpcyUyMHNtYWxsZXIlMjB0aGFuJTIwdGhlJTIwbWluaW11bSUyMGxlbmd0aCUyMGNvbnN0cmFpbnQlMkMlMjB0aGUlMjBsYXR0ZXIlMjBpcyUyMGlnbm9yZWQhJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QzMCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEZvciUyMHRlc3RpbmclMjBwdXJwb3NlcyUyQyUyMGxldCdzJTIwc2V0JTIwJTYwZW9zX3Rva2VuJTYwJTIwdG8lMjAlNjAlMjJjb21wYW55JTIyJTYwJTJDJTIwdGhlJTIwZmlyc3QlMjBnZW5lcmF0ZWQlMjB0b2tlbi4lMjBUaGlzJTIwd2lsbCUyMG1ha2UlMEElMjMlMjBnZW5lcmF0aW9uJTIwZW5kJTIwdGhlcmUuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEluY3JlYXNpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBtYWtlJTIwZ2VuZXJhdGlvbiUyMGlnbm9yZSUyMG9jY3VyZW5jZXMlMjAlNjAlMjJjb21wYW55JTIyJTYwJTIwKGVvcyUyMHRva2VuKSUyMGJlZm9yZSUyMHRoZSUwQSUyMyUyMG1pbmltdW0lMjBsZW5ndGglMjBjb25kaXRpb24lMjBpcyUyMGhvbm9yZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX25ld190b2tlbnMlM0QyJTJDJTIwZW9zX3Rva2VuX2lkJTNEMTY2NCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If the maximum length (default = 20) is smaller than the minimum length constraint, the latter is ignored!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company that has been working on a new product <span class="hljs-keyword">for</span> the past year.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For testing purposes, let&#x27;s set \`eos_token\` to \`&quot;company&quot;\`, the first generated token. This will make</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generation end there.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a company

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Increasing \`min_new_tokens\` will make generation ignore occurences \`&quot;company&quot;\` (eos token) before the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># minimum length condition is honored.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>, eos_token_id=<span class="hljs-number">1664</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Hugging Face Company <span class="hljs-keyword">is</span> a new company`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function j0(x){let b,k=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){b=s("p"),b.innerHTML=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-15bvr1j"&&(b.innerHTML=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function L0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySW4lMjBhJTIwd29yZCUyQyUyMHRoZSUyMGNha2UlMjBpcyUyMGElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBwYWRfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjB0YWtlJTIwdGhlJTIwYmFkJTIwd29yZHMlMjBvdXQuJTIwUGxlYXNlJTIwbm90ZSUyMHRoYXQlMjB0aGUlMjB0b2tlbml6ZXIlMjBpcyUyMGluaXRpYWxpemVkJTIwZGlmZmVyZW50bHklMEF0b2tlbml6ZXJfd2l0aF9wcmVmaXhfc3BhY2UlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTBBJTBBJTBBZGVmJTIwZ2V0X3Rva2Vuc19hc19saXN0KHdvcmRfbGlzdCklM0ElMEElMjAlMjAlMjAlMjAlMjJDb252ZXJ0cyUyMGElMjBzZXF1ZW5jZSUyMG9mJTIwd29yZHMlMjBpbnRvJTIwYSUyMGxpc3QlMjBvZiUyMHRva2VucyUyMiUwQSUyMCUyMCUyMCUyMHRva2Vuc19saXN0JTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9saXN0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVkX3dvcmQlMjAlM0QlMjB0b2tlbml6ZXJfd2l0aF9wcmVmaXhfc3BhY2UoJTVCd29yZCU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5zX2xpc3QuYXBwZW5kKHRva2VuaXplZF93b3JkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vuc19saXN0JTBBJTBBJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMGdldF90b2tlbnNfYXNfbGlzdCh3b3JkX2xpc3QlM0QlNUIlMjJtZXNzJTIyJTVEKSUwQW91dHB1dF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBiYWRfd29yZHNfaWRzJTNEYmFkX3dvcmRzX2lkcyUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function F0(x){let b,k=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){b=s("p"),b.innerHTML=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-5zfsi9"&&(b.innerHTML=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function z0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMjBJJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjBhZGQlMjBuZ3JhbSUyMHNpemUlMjB1c2luZyUyMCU2MG5vX3JlcGVhdF9uZ3JhbV9zaXplJTYwLiUyMFRoaXMlMjBzdG9wcyUyMHRoZSUyMHJlcGV0aXRpb25zJTIwKCUyMkklRTIlODAlOTltJTIyKSUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function U0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFRoaXMlMjBnZW5lcmF0ZXMlMjBhJTIwcGVuYWx0eSUyMGZvciUyMHJlcGVhdGVkJTIwdG9rZW5zJTBBcGVuYWxpemVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUocGVuYWxpemVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function J0(x){let b,k=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){b=s("p"),b.innerHTML=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-16cusgy"&&(b.innerHTML=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function C0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function I0(x){let b,k=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){b=s("p"),b.innerHTML=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-1byeoum"&&(b.innerHTML=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function B0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHRlbXBlcmF0dXJlJTNEMS4wJTJDJTIwdGhlJTIwZGVmYXVsdCUyQyUyMHdlJTIwY29uc2lzdGVudGx5JTIwZ2V0JTIwcmFuZG9tJTIwb3V0cHV0cyUyMGR1ZSUyMHRvJTIwcmFuZG9tJTIwc2FtcGxpbmcuJTBBZ2VuZXJhdGVfa3dhcmdzJTIwJTNEJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMCUyQyUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUyMCUyMm51bV9yZXR1cm5fc2VxdWVuY2VzJTIyJTNBJTIwMiU3RCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBIb3dldmVyJTJDJTIwd2l0aCUyMHRlbXBlcmF0dXJlJTIwY2xvc2UlMjB0byUyMDAlMkMlMjBpdCUyMGFwcHJveGltYXRlcyUyMGdyZWVkeSUyMGRlY29kaW5nJTIwc3RyYXRlZ2llcyUyMChpbnZhcmlhbnQpJTBBZ2VuZXJhdGVfa3dhcmdzJTVCJTIydGVtcGVyYXR1cmUlMjIlNUQlMjAlM0QlMjAwLjAwMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjAqKmdlbmVyYXRlX2t3YXJncyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function q0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjAlNjB0b3BfcCU2MCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfcCU2MCUyMGluJTIwdGhlJTIwMC45LTAuOTUlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX3AlM0QwLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function W0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function S0(x){let b,k;return b=new I({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){d(b.$$.fragment)},l($){p(b.$$.fragment,$)},m($,T){m(b,$,T),k=!0},p:U,i($){k||(g(b.$$.fragment,$),k=!0)},o($){u(b.$$.fragment,$),k=!1},d($){h(b,$)}}}function V0(x){let b,k="The API for the streamer classes is still under development and may change in the future.";return{c(){b=s("p"),b.textContent=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-gv2g1g"&&(b.textContent=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function Z0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function E0(x){let b,k="The API for the streamer classes is still under development and may change in the future.";return{c(){b=s("p"),b.textContent=k},l($){b=o($,"P",{"data-svelte-h":!0}),v(b)!=="svelte-gv2g1g"&&(b.textContent=k)},m($,T){c($,b,T)},p:U,d($){$&&n(b)}}}function D0(x){let b,k="Examples:",$,T,w;return T=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){b=s("p"),b.textContent=k,$=r(),d(T.$$.fragment)},l(_){b=o(_,"P",{"data-svelte-h":!0}),v(b)!=="svelte-kvfsh7"&&(b.textContent=k),$=a(_),p(T.$$.fragment,_)},m(_,M){c(_,b,M),c(_,$,M),m(T,_,M),w=!0},p:U,i(_){w||(g(T.$$.fragment,_),w=!0)},o(_){u(T.$$.fragment,_),w=!1},d(_){_&&(n(b),n($)),h(T,_)}}}function P0(x){let b,k,$,T,w,_,M,rs,Nh,bi,By="Utilities for Generation",Vm,as,qy=`This page lists all the utility functions used by <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>,
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, and
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>.`,Zm,is,Wy="Most of those are only useful if you are studying the code of the generate methods in the library.",Em,dt,Nt,_m,cs,Hh,vi,Sy="Generate Outputs",Dm,ls,Vy=`The output of <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Pm,ds,Zy="Here’s an example:",Gm,ps,Xm,ms,Ey=`The <code>generation_output</code> object is a <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput">GreedySearchDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Nm,gs,Dy="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Hm,us,Py=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Rm,hs,Gy=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Om,fs,Xy=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Qm,_s,Am,bs,Ny="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",Ym,vs,Hy=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Km,ys,Ry="We document here all output types.",eg,pt,Ht,bm,Ts,Rh,yi,Oy="PyTorch",tg,mt,$s,Oh,Ti,Qy=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ng,gt,ws,Qh,$i,Ay="Base class for outputs of decoder-only generation models using greedy search.",sg,ut,ks,Ah,wi,Yy=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,og,ht,Ms,Yh,ki,Ky="Base class for outputs of decoder-only generation models using sampling.",rg,ft,xs,Kh,Mi,eT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,ag,_t,js,ef,xi,tT="Base class for outputs of decoder-only generation models using beam search.",ig,bt,Ls,tf,ji,nT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,cg,vt,Fs,nf,Li,sT="Base class for outputs of decoder-only generation models using beam sample.",lg,yt,zs,sf,Fi,oT="Base class for outputs of decoder-only generation models using contrastive search.",dg,Tt,Us,of,zi,rT="Base class for outputs of decoder-only generation models using contrastive search.",pg,$t,Rt,vm,Js,rf,Ui,aT="TensorFlow",mg,wt,Cs,af,Ji,iT=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,gg,kt,Is,cf,Ci,cT="Base class for outputs of decoder-only generation models using greedy search.",ug,Mt,Bs,lf,Ii,lT=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,hg,xt,qs,df,Bi,dT="Base class for outputs of decoder-only generation models using sampling.",fg,jt,Ws,pf,qi,pT=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,_g,Lt,Ss,mf,Wi,mT="Base class for outputs of decoder-only generation models using beam search.",bg,Ft,Vs,gf,Si,gT=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,vg,zt,Zs,uf,Vi,uT="Base class for outputs of decoder-only generation models using beam sample.",yg,Ut,Es,hf,Zi,hT=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,Tg,Jt,Ds,ff,Ei,fT="Base class for outputs of decoder-only generation models using contrastive search.",$g,Ct,Ot,ym,Ps,_f,Di,_T="FLAX",wg,oe,Gs,bf,Pi,bT="Flax Base class for outputs of decoder-only generation models using sampling.",vf,Qt,Xs,yf,Gi,vT="“Returns a new object replacing the specified fields with new values.",kg,re,Ns,Tf,Xi,yT="Flax Base class for outputs of decoder-only generation models using greedy search.",$f,At,Hs,wf,Ni,TT="“Returns a new object replacing the specified fields with new values.",Mg,ae,Rs,kf,Hi,$T="Flax Base class for outputs of decoder-only generation models using greedy search.",Mf,Yt,Os,xf,Ri,wT="“Returns a new object replacing the specified fields with new values.",xg,It,Kt,Tm,Qs,jf,Oi,kT="LogitsProcessor",jg,As,MT=`A <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,Lg,Bt,en,$m,Ys,Lf,Qi,xT="PyTorch",Fg,ie,Ks,Ff,Ai,jT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of <code>Bark</code>’s fine submodel.',zf,Yi,eo,zg,X,to,Uf,Ki,LT=`Logits processor for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Jf,ec,FT='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',Cf,tc,no,Ug,ce,so,If,nc,zT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces no repetition of encoder input ids n-grams for the decoder ids. See
<a href="https://github.com/facebookresearch/ParlAI/blob/master/parlai/core/torch_generator_agent.py#L1350" rel="nofollow">ParlAI</a>.`,Bf,sc,oo,Jg,le,ro,qf,oc,UT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing an exponential penalty on tokens that are not in the original input.',Wf,rc,ao,Cg,N,io,Sf,ac,JT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,Vf,tn,Zf,ic,co,Ig,H,lo,Ef,cc,CT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,Df,nn,Pf,lc,po,Bg,R,mo,Gf,dc,IT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,Xf,sn,Nf,pc,go,qg,de,uo,Hf,mc,BT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token.',Rf,gc,ho,Wg,pe,fo,Of,uc,qT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Qf,hc,_o,Sg,me,bo,Af,fc,WT=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index.`,Yf,_c,vo,Vg,j,yo,Kf,bc,ST='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',e_,vc,VT=`Note that this logits processor is only effective for <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">PreTrainedModel.group_beam_search()</a>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,t_,on,n_,rn,s_,yc,ZT=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,o_,Tc,ET="How It Works:",r_,$c,DT=`<li><strong>Grouping Beams</strong>: Beams are divided into groups. Each group selects tokens independently of the others.</li> <li><strong>Penalizing Repeated Tokens</strong>: If a beam in a group selects a token already chosen by another group in the
same step, a penalty is applied to that token’s score.</li> <li><strong>Promoting Diversity</strong>: This penalty discourages beams within a group from selecting the same tokens as
beams in other groups.</li>`,a_,wc,PT="Benefits:",i_,kc,GT="<li><strong>Diverse Outputs</strong>: Produces a variety of different sequences.</li> <li><strong>Exploration</strong>: Allows the model to explore different paths.</li>",c_,an,l_,Mc,To,Zg,ge,$o,d_,xc,XT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,p_,jc,wo,Eg,ue,ko,m_,Lc,NT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,g_,Fc,Mo,Dg,he,xo,u_,zc,HT="Abstract base class for all logit processors that can be applied during generation.",h_,Uc,jo,Pg,fe,Lo,f_,Jc,RT=`This class can be used to create a list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,__,Cc,Fo,Gg,_e,zo,b_,Ic,OT="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",v_,Bc,Uo,Xg,be,Jo,y_,qc,QT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',T_,Wc,Co,Ng,O,Io,$_,Sc,AT=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Note that for decoder-only models, such as Llama2, <code>min_length</code> will compute the length of <code>prompt + newly generated tokens</code> whereas for other models it will behave as <code>min_new_tokens</code>, that is, taking only into account
the newly generated ones.`,w_,cn,k_,Vc,Bo,Hg,q,qo,M_,Zc,YT='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',x_,ln,j_,dn,L_,Ec,Wo,Rg,W,So,F_,Dc,KT=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,z_,pn,U_,mn,J_,Pc,Vo,Og,ve,Zo,C_,Gc,e1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,I_,Xc,Eo,Qg,Q,Do,B_,Nc,t1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through an exponential penalty. This technique
shares some similarities with coverage mechanisms and other aimed at reducing repetition. During the text
generation process, the probability distribution for the next token is determined using a formula that incorporates
token scores based on their occurrence in the generated sequence. Tokens with higher scores are more likely to be
selected. The formula can be seen in the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>. According to the
paper a penalty of around 1.2 yields a good balance between truthful generation and lack of repetition.`,q_,gn,W_,Hc,Po,Ag,S,Go,S_,Rc,n1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,V_,un,Z_,hn,E_,Oc,Xo,Yg,ye,No,D_,Qc,s1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,P_,Ac,Ho,Kg,Te,Ro,G_,Yc,o1=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,X_,Kc,Oo,eu,V,Qo,N_,el,r1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens.`,H_,fn,R_,_n,O_,tl,Ao,tu,$e,Yo,Q_,nl,a1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',A_,sl,Ko,nu,A,er,Y_,ol,i1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',K_,bn,eb,rl,tr,su,we,nr,tb,al,c1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language
Generation</a> for more information.`,nb,il,sr,ou,Z,or,sb,cl,l1=`Logits processor for Classifier-Free Guidance (CFG). The processors
computes a weighted average across scores from prompt conditional and prompt unconditional (or negative) logits,
parameterized by the <code>guidance_scale</code>. The unconditional scores are computed internally by prompting <code>model</code> with
the <code>unconditional_ids</code> branch.`,ob,ll,d1='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',rb,vn,ab,dl,rr,ru,Y,ar,ib,pl,p1=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,cb,ml,m1='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',lb,gl,ir,au,qt,yn,wm,cr,db,ul,g1="TensorFlow",iu,ke,lr,pb,hl,u1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',mb,fl,dr,cu,Me,pr,gb,_l,h1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',ub,bl,mr,lu,xe,gr,hb,vl,f1=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,fb,yl,ur,du,je,hr,_b,Tl,_1="Abstract base class for all logit processors that can be applied during generation.",bb,Tn,fr,vb,$l,b1="TF method for processing logits.",pu,Le,_r,yb,wl,v1=`This class can be used to create a list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Tb,kl,br,mu,Fe,vr,$b,Ml,y1="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",wb,$n,yr,kb,xl,T1="TF method for warping logits.",gu,ze,Tr,Mb,jl,$1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',xb,Ll,$r,uu,Ue,wr,jb,Fl,w1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Lb,zl,kr,hu,Je,Mr,Fb,Ul,k1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,zb,Jl,xr,fu,Ce,jr,Ub,Cl,M1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',Jb,Il,Lr,_u,Ie,Fr,Cb,Bl,x1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,Ib,ql,zr,bu,Be,Ur,Bb,Wl,j1=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,qb,Sl,Jr,vu,qe,Cr,Wb,Vl,L1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Sb,Zl,Ir,yu,We,Br,Vb,El,F1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Zb,Dl,qr,Tu,Se,Wr,Eb,Pl,z1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',Db,Gl,Sr,$u,Wt,wn,km,Vr,Pb,Xl,U1="FLAX",wu,Ve,Zr,Gb,Nl,J1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',Xb,Hl,Er,ku,Ze,Dr,Nb,Rl,C1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Hb,Ol,Pr,Mu,Ee,Gr,Rb,Ql,I1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,Ob,Al,Xr,xu,De,Nr,Qb,Yl,B1="Abstract base class for all logit processors that can be applied during generation.",Ab,kn,Hr,Yb,Kl,q1="Flax method for processing logits.",ju,Pe,Rr,Kb,ed,W1=`This class can be used to create a list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,ev,td,Or,Lu,Ge,Qr,tv,nd,S1="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",nv,Mn,Ar,sv,sd,V1="Flax method for warping logits.",Fu,Xe,Yr,ov,od,Z1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',rv,rd,Kr,zu,Ne,ea,av,ad,E1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,iv,id,ta,Uu,He,na,cv,cd,D1=`<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,lv,ld,sa,Ju,Re,oa,dv,dd,P1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',pv,pd,ra,Cu,Oe,aa,mv,md,G1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',gv,gd,ia,Iu,Qe,ca,uv,ud,X1='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',hv,hd,la,Bu,Ae,da,fv,fd,N1=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,_v,_d,pa,qu,St,xn,Mm,ma,bv,bd,H1="StoppingCriteria",Wu,ga,R1='A <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusivelly available to our PyTorch implementations.',Su,Ye,ua,vv,vd,O1="Abstract base class for all stopping criteria that can be applied during generation.",yv,yd,ha,Vu,Vt,fa,Tv,Td,_a,Zu,Ke,ba,$v,$d,Q1=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,wv,wd,va,Eu,et,ya,kv,kd,A1=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,Mv,Md,Ta,Du,Zt,jn,xm,$a,xv,xd,Y1="Constraints",Pu,wa,K1='A <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusivelly available to our PyTorch implementations.',Gu,L,ka,jv,jd,e$=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,Lv,Ld,t$="All classes that inherit Constraint must follow the requirement that",Fv,Ln,zv,Fd,n$="will always terminate (halt).",Uv,Fn,Ma,Jv,zd,s$="When called, returns the token that would take this constraint one step closer to being fulfilled.",Cv,zn,xa,Iv,Ud,o$="Creates a new instance of this constraint.",Bv,Un,ja,qv,Jd,r$="Reads in a token and returns whether it creates progress.",Wv,Jn,La,Sv,Cd,a$="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",Vv,Cn,Fa,Zv,Id,i$=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,Ev,In,za,Dv,Bd,c$="Tests whether this constraint has been properly defined.",Pv,st,Ua,Gv,qd,l$=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,Xv,Wd,d$=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Xu,Et,Ja,Nv,Sd,p$='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Nu,Dt,Ca,Hv,Vd,m$='A special <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Hu,K,Ia,Rv,Zd,g$="A class for beam scorers to track its progress through a list of constraints.",Ov,B,Ba,Qv,Ed,u$=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,Av,Dd,h$=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,Yv,Pd,f$="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",Kv,Gd,_$=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,ey,Xd,b$=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,ty,Bn,qa,ny,Nd,v$="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Ru,Pt,qn,jm,Wa,sy,Hd,y$="BeamSearch",Ou,ee,Sa,oy,Rd,T$=`Abstract base class for all beam scorers that are used for <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> and
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>.`,ry,Od,Va,ay,Qd,Za,Qu,C,Ea,iy,Ad,$$='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',cy,Yd,w$=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,ly,Kd,k$=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,dy,ep,Da,py,tp,Pa,Au,te,Ga,my,np,M$='<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',gy,sp,Xa,uy,op,Na,Yu,Gt,Wn,Lm,Ha,hy,rp,x$="Utilities",Ku,tt,Ra,fy,ap,j$="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",_y,ip,L$='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',eh,nt,Oa,by,cp,F$="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",vy,lp,z$='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',th,Xt,Sn,Fm,Qa,yy,dp,U$="Streamers",nh,J,Aa,Ty,pp,J$="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",$y,Vn,wy,Zn,ky,En,Ya,My,mp,C$="Flushes any remaining cache and prints a newline to stdout.",xy,Dn,Ka,jy,gp,I$="Prints the new text to stdout. If the stream is ending, also prints a newline.",Ly,Pn,ei,Fy,up,B$="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",sh,E,ti,zy,hp,q$=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Uy,Gn,Jy,Xn,Cy,Nn,ni,Iy,fp,W$="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",oh,zm,rh;return rs=new G({}),cs=new G({}),ps=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),_s=new I({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),Ts=new G({}),$s=new y({props:{name:"class transformers.generation.GreedySearchEncoderDecoderOutput",anchor:"transformers.generation.GreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L184"}}),ws=new y({props:{name:"class transformers.generation.GreedySearchDecoderOnlyOutput",anchor:"transformers.generation.GreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L88"}}),ks=new y({props:{name:"class transformers.generation.SampleEncoderDecoderOutput",anchor:"transformers.generation.SampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape
<code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.SampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L255"}}),Ms=new y({props:{name:"class transformers.generation.SampleDecoderOnlyOutput",anchor:"transformers.generation.SampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.SampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.SampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L226"}}),xs=new y({props:{name:"class transformers.generation.BeamSearchEncoderDecoderOutput",anchor:"transformers.generation.BeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L333"}}),js=new y({props:{name:"class transformers.generation.BeamSearchDecoderOnlyOutput",anchor:"transformers.generation.BeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L298"}}),Ls=new y({props:{name:"class transformers.generation.BeamSampleEncoderDecoderOutput",anchor:"transformers.generation.BeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>).`,name:"scores"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.BeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L418"}}),Fs=new y({props:{name:"class transformers.generation.BeamSampleDecoderOnlyOutput",anchor:"transformers.generation.BeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.BeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L383"}}),zs=new y({props:{name:"class transformers.generation.ContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.ContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L116"}}),Us=new y({props:{name:"class transformers.generation.ContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when &#x2014;
<code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.hidden_states",description:"<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is &#x2014;",name:"hidden_states"},{anchor:"transformers.generation.ContrastiveSearchDecoderOnlyOutput.passed",description:`<strong>passed</strong> or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"passed"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L155"}}),Js=new G({}),Cs=new y({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L86"}}),Is=new y({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L58"}}),Bs=new y({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L156"}}),qs=new y({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L128"}}),Ws=new y({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L233"}}),Ss=new y({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L198"}}),Vs=new y({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L318"}}),Zs=new y({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L283"}}),Es=new y({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L394"}}),Ds=new y({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.ops.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.ops.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L367"}}),Ps=new G({}),Gs=new y({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L69"}}),Xs=new y({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/flax/struct.py#L111"}}),Ns=new y({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L55"}}),Hs=new y({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/flax/struct.py#L111"}}),Rs=new y({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L83"}}),Os=new y({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/flax/struct.py#L111"}}),Qs=new G({}),Ys=new G({}),Ks=new y({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1553"}}),eo=new y({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1574"}}),to=new y({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1513"}}),no=new y({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1537",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),so=new y({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L763"}}),oo=new y({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L786",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new y({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.hallucination_penalty",description:`<strong>hallucination_penalty</strong> (<code>float</code>) &#x2014;
The parameter for hallucination penalty. 1.0 means no penalty.`,name:"hallucination_penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L323"}}),ao=new y({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L341",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),io=new y({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L493"}}),tn=new D({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[y0]},$$scope:{ctx:x}}}),co=new y({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L546",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new y({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L560"}}),nn=new D({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[T0]},$$scope:{ctx:x}}}),po=new y({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L623",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mo=new y({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1298"}}),sn=new D({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[$0]},$$scope:{ctx:x}}}),go=new y({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1371",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new y({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1230"}}),ho=new y({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1242",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new y({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1252"}}),_o=new y({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1270",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new y({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1428"}}),vo=new y({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1436",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new y({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if group beam search is enabled. The
penalty applied to a beam&#x2019;s score when it generates a token that has already been chosen by another beam
within the same group during the same time step. A higher <code>diversity_penalty</code> will enforce greater
diversity among the beams, making it less likely for multiple beams to choose the same token. Conversely, a
lower penalty will allow beams to more freely choose similar tokens. Adjusting this value can help strike a
balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams used for group beam search. Beam search is a method used that maintains beams (or &#x201C;multiple
hypotheses&#x201D;) at each step, expanding each one and keeping the top-scoring sequences. A higher <code>num_beams</code>
will explore more potential sequences. This can increase chances of finding a high-quality output but also
increases computational cost.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
Each group of beams will operate independently, selecting tokens without considering the choices of other
groups. This division promotes diversity by ensuring that beams within different groups explore different
paths. For instance, if <code>num_beams</code> is 6 and <code>num_beam_groups</code> is 2, there will be 2 groups each containing
3 beams. The choice of <code>num_beam_groups</code> should be made considering the desired level of output diversity
and the total number of beams. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1067"}}),on=new os({props:{$$slots:{default:[w0]},$$scope:{ctx:x}}}),rn=new os({props:{warning:!0,$$slots:{default:[k0]},$$scope:{ctx:x}}}),an=new D({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[M0]},$$scope:{ctx:x}}}),To=new y({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1184",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new y({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1281"}}),wo=new y({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1287",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ko=new y({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1382"}}),Mo=new y({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1390",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new y({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L44"}}),jo=new y({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L47",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lo=new y({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L64"}}),Fo=new y({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L71",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),zo=new y({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L54"}}),Uo=new y({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L57",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Jo=new y({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L101"}}),Co=new y({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L124",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Io=new y({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L133"}}),cn=new D({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[x0]},$$scope:{ctx:x}}}),Bo=new y({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L195",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qo=new y({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L953"}}),ln=new os({props:{$$slots:{default:[j0]},$$scope:{ctx:x}}}),dn=new D({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[L0]},$$scope:{ctx:x}}}),Wo=new y({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L876",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),So=new y({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L706"}}),pn=new os({props:{$$slots:{default:[F0]},$$scope:{ctx:x}}}),mn=new D({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[z0]},$$scope:{ctx:x}}}),Vo=new y({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L752",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zo=new y({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1040"}}),Eo=new y({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1057",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Do=new y({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L270"}}),gn=new D({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[U0]},$$scope:{ctx:x}}}),Po=new y({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L312",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Go=new y({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.Dict[typing.Tuple[int], float]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L805"}}),un=new os({props:{$$slots:{default:[J0]},$$scope:{ctx:x}}}),hn=new D({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[C0]},$$scope:{ctx:x}}}),Xo=new y({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L876",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new y({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1396"}}),Ho=new y({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1407",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ro=new y({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1415"}}),Oo=new y({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1422",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qo=new y({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L205"}}),fn=new os({props:{$$slots:{default:[I0]},$$scope:{ctx:x}}}),_n=new D({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[B0]},$$scope:{ctx:x}}}),Ao=new y({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L264",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Yo=new y({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L415"}}),Ko=new y({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L435",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),er=new y({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L352"}}),bn=new D({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[q0]},$$scope:{ctx:x}}}),tr=new y({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L399",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),nr=new y({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L444"}}),sr=new y({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L469",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),or=new y({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <strong>optional</strong>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.smooth_factor",description:`<strong>smooth_factor</strong> (<code>float</code>, <strong>optional</strong>) &#x2014;
The interpolation weight for CFG Rescale. 1 means no rescaling, 0 reduces to the conditional scores without
CFG. Turn it lower if the output degenerates.`,name:"smooth_factor"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <strong>optional</strong>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1589"}}),vn=new D({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[W0]},$$scope:{ctx:x}}}),rr=new y({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1698"}}),ar=new y({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1446"}}),ir=new y({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/logits_process.py#L1475",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),cr=new G({}),lr=new y({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L448"}}),dr=new y({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L462"}}),pr=new y({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L478"}}),mr=new y({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L495"}}),gr=new y({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L551"}}),ur=new y({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L567"}}),hr=new y({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L53"}}),fr=new y({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_r=new y({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L75"}}),br=new y({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vr=new y({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L64"}}),yr=new y({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Tr=new y({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L202"}}),$r=new y({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L228"}}),wr=new y({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L288"}}),kr=new y({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L367"}}),Mr=new y({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L388"}}),xr=new y({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L427"}}),jr=new y({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L238"}}),Lr=new y({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L280"}}),Fr=new y({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L511"}}),zr=new y({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L522"}}),Ur=new y({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L535"}}),Jr=new y({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L542"}}),Cr=new y({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L98"}}),Ir=new y({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L113"}}),Br=new y({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L118"}}),qr=new y({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L138"}}),Wr=new y({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L146"}}),Sr=new y({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_logits_process.py#L170"}}),Vr=new G({}),Zr=new y({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L194"}}),Er=new y({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L206"}}),Dr=new y({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L216"}}),Pr=new y({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L231"}}),Gr=new y({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L315"}}),Xr=new y({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L337"}}),Nr=new y({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L50"}}),Hr=new y({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Rr=new y({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L72"}}),Or=new y({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qr=new y({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L61"}}),Ar=new y({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`
<p>The processed prediction scores.</p>
`,returnType:`
<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Yr=new y({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L241"}}),Kr=new y({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L262"}}),ea=new y({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L271"}}),ta=new y({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L288"}}),na=new y({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L296"}}),sa=new y({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L309"}}),oa=new y({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L95"}}),ra=new y({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L110"}}),aa=new y({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L159"}}),ia=new y({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L179"}}),ca=new y({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>-float(&quot;Inf&quot;)</code>) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L115"}}),la=new y({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L139"}}),da=new y({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L363"}}),pa=new y({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_logits_process.py#L397"}}),ma=new G({}),ua=new y({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L36"}}),ha=new y({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L39",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),fa=new y({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L124"}}),_a=new y({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L125",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ba=new y({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L44"}}),va=new y({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L60",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ya=new y({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L102"}}),Ta=new y({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/stopping_criteria.py#L119",returnDescription:`
<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),$a=new G({}),ka=new y({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L5"}}),Ln=new D({props:{anchor:"transformers.Constraint.example",$$slots:{default:[S0]},$$scope:{ctx:x}}}),Ma=new y({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L48",returnDescription:`
<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`
<p>token_ids(<code>torch.tensor</code>)</p>
`}}),xa=new y({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L113",returnDescription:`
<p>The same constraint as the one being called from.</p>
`,returnType:`
<p>constraint(<code>Constraint</code>)</p>
`}}),ja=new y({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L60"}}),La=new y({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L104"}}),Fa=new y({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L94"}}),za=new y({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L24"}}),Ua=new y({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L69",returnDescription:`
<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`
<p>stepped(<code>bool</code>)</p>
`}}),Ja=new y({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L129"}}),Ca=new y({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:"<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014; a list of words, where each word is a list of ids. This constraint",name:"nested_token_ids"},{anchor:"transformers.DisjunctiveConstraint.is",description:"<strong>is</strong> fulfilled by generating just one from the list of words. &#x2014;",name:"is"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L261"}}),Ia=new y({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L350"}}),Ba=new y({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L382"}}),qa=new y({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_constraints.py#L417"}}),Wa=new G({}),Sa=new y({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L91"}}),Va=new y({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L97",returnDescription:`
<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`
<p><code>UserDict</code></p>
`}}),Za=new y({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L109",returnDescription:`
<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`
<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),Ea=new y({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L123"}}),Da=new y({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L215"}}),Pa=new y({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L315"}}),Ga=new y({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<code>~transformer.BeamSearchScorer.finalize</code>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L410"}}),Xa=new y({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.34.0/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L504",returnDescription:`
<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`
<p><code>UserDict</code></p>
`}}),Na=new y({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/beam_search.py#L798"}}),Ha=new G({}),Ra=new y({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L4706"}}),Oa=new y({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L3063"}}),Qa=new G({}),Aa=new y({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L38"}}),Vn=new os({props:{warning:!0,$$slots:{default:[V0]},$$scope:{ctx:x}}}),Zn=new D({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[Z0]},$$scope:{ctx:x}}}),Ya=new y({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L116"}}),Ka=new y({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L130"}}),ei=new y({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L82"}}),ti=new y({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L159"}}),Gn=new os({props:{warning:!0,$$slots:{default:[E0]},$$scope:{ctx:x}}}),Xn=new D({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[D0]},$$scope:{ctx:x}}}),ni=new y({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/streamers.py#L213"}}),{c(){b=s("meta"),k=r(),$=s("p"),T=r(),w=s("h1"),_=s("a"),M=s("span"),d(rs.$$.fragment),Nh=r(),bi=s("span"),bi.textContent=By,Vm=r(),as=s("p"),as.innerHTML=qy,Zm=r(),is=s("p"),is.textContent=Wy,Em=r(),dt=s("h2"),Nt=s("a"),_m=s("span"),d(cs.$$.fragment),Hh=r(),vi=s("span"),vi.textContent=Sy,Dm=r(),ls=s("p"),ls.innerHTML=Vy,Pm=r(),ds=s("p"),ds.textContent=Zy,Gm=r(),d(ps.$$.fragment),Xm=r(),ms=s("p"),ms.innerHTML=Ey,Nm=r(),gs=s("ul"),gs.innerHTML=Dy,Hm=r(),us=s("p"),us.innerHTML=Py,Rm=r(),hs=s("p"),hs.innerHTML=Gy,Om=r(),fs=s("p"),fs.innerHTML=Xy,Qm=r(),d(_s.$$.fragment),Am=r(),bs=s("p"),bs.innerHTML=Ny,Ym=r(),vs=s("p"),vs.innerHTML=Hy,Km=r(),ys=s("p"),ys.textContent=Ry,eg=r(),pt=s("h3"),Ht=s("a"),bm=s("span"),d(Ts.$$.fragment),Rh=r(),yi=s("span"),yi.textContent=Oy,tg=r(),mt=s("div"),d($s.$$.fragment),Oh=r(),Ti=s("p"),Ti.textContent=Qy,ng=r(),gt=s("div"),d(ws.$$.fragment),Qh=r(),$i=s("p"),$i.textContent=Ay,sg=r(),ut=s("div"),d(ks.$$.fragment),Ah=r(),wi=s("p"),wi.textContent=Yy,og=r(),ht=s("div"),d(Ms.$$.fragment),Yh=r(),ki=s("p"),ki.textContent=Ky,rg=r(),ft=s("div"),d(xs.$$.fragment),Kh=r(),Mi=s("p"),Mi.textContent=eT,ag=r(),_t=s("div"),d(js.$$.fragment),ef=r(),xi=s("p"),xi.textContent=tT,ig=r(),bt=s("div"),d(Ls.$$.fragment),tf=r(),ji=s("p"),ji.textContent=nT,cg=r(),vt=s("div"),d(Fs.$$.fragment),nf=r(),Li=s("p"),Li.textContent=sT,lg=r(),yt=s("div"),d(zs.$$.fragment),sf=r(),Fi=s("p"),Fi.textContent=oT,dg=r(),Tt=s("div"),d(Us.$$.fragment),of=r(),zi=s("p"),zi.textContent=rT,pg=r(),$t=s("h3"),Rt=s("a"),vm=s("span"),d(Js.$$.fragment),rf=r(),Ui=s("span"),Ui.textContent=aT,mg=r(),wt=s("div"),d(Cs.$$.fragment),af=r(),Ji=s("p"),Ji.textContent=iT,gg=r(),kt=s("div"),d(Is.$$.fragment),cf=r(),Ci=s("p"),Ci.textContent=cT,ug=r(),Mt=s("div"),d(Bs.$$.fragment),lf=r(),Ii=s("p"),Ii.textContent=lT,hg=r(),xt=s("div"),d(qs.$$.fragment),df=r(),Bi=s("p"),Bi.textContent=dT,fg=r(),jt=s("div"),d(Ws.$$.fragment),pf=r(),qi=s("p"),qi.textContent=pT,_g=r(),Lt=s("div"),d(Ss.$$.fragment),mf=r(),Wi=s("p"),Wi.textContent=mT,bg=r(),Ft=s("div"),d(Vs.$$.fragment),gf=r(),Si=s("p"),Si.textContent=gT,vg=r(),zt=s("div"),d(Zs.$$.fragment),uf=r(),Vi=s("p"),Vi.textContent=uT,yg=r(),Ut=s("div"),d(Es.$$.fragment),hf=r(),Zi=s("p"),Zi.textContent=hT,Tg=r(),Jt=s("div"),d(Ds.$$.fragment),ff=r(),Ei=s("p"),Ei.textContent=fT,$g=r(),Ct=s("h3"),Ot=s("a"),ym=s("span"),d(Ps.$$.fragment),_f=r(),Di=s("span"),Di.textContent=_T,wg=r(),oe=s("div"),d(Gs.$$.fragment),bf=r(),Pi=s("p"),Pi.textContent=bT,vf=r(),Qt=s("div"),d(Xs.$$.fragment),yf=r(),Gi=s("p"),Gi.textContent=vT,kg=r(),re=s("div"),d(Ns.$$.fragment),Tf=r(),Xi=s("p"),Xi.textContent=yT,$f=r(),At=s("div"),d(Hs.$$.fragment),wf=r(),Ni=s("p"),Ni.textContent=TT,Mg=r(),ae=s("div"),d(Rs.$$.fragment),kf=r(),Hi=s("p"),Hi.textContent=$T,Mf=r(),Yt=s("div"),d(Os.$$.fragment),xf=r(),Ri=s("p"),Ri.textContent=wT,xg=r(),It=s("h2"),Kt=s("a"),Tm=s("span"),d(Qs.$$.fragment),jf=r(),Oi=s("span"),Oi.textContent=kT,jg=r(),As=s("p"),As.innerHTML=MT,Lg=r(),Bt=s("h3"),en=s("a"),$m=s("span"),d(Ys.$$.fragment),Lf=r(),Qi=s("span"),Qi.textContent=xT,Fg=r(),ie=s("div"),d(Ks.$$.fragment),Ff=r(),Ai=s("p"),Ai.innerHTML=jT,zf=r(),Yi=s("div"),d(eo.$$.fragment),zg=r(),X=s("div"),d(to.$$.fragment),Uf=r(),Ki=s("p"),Ki.innerHTML=LT,Jf=r(),ec=s("p"),ec.innerHTML=FT,Cf=r(),tc=s("div"),d(no.$$.fragment),Ug=r(),ce=s("div"),d(so.$$.fragment),If=r(),nc=s("p"),nc.innerHTML=zT,Bf=r(),sc=s("div"),d(oo.$$.fragment),Jg=r(),le=s("div"),d(ro.$$.fragment),qf=r(),oc=s("p"),oc.innerHTML=UT,Wf=r(),rc=s("div"),d(ao.$$.fragment),Cg=r(),N=s("div"),d(io.$$.fragment),Sf=r(),ac=s("p"),ac.innerHTML=JT,Vf=r(),d(tn.$$.fragment),Zf=r(),ic=s("div"),d(co.$$.fragment),Ig=r(),H=s("div"),d(lo.$$.fragment),Ef=r(),cc=s("p"),cc.innerHTML=CT,Df=r(),d(nn.$$.fragment),Pf=r(),lc=s("div"),d(po.$$.fragment),Bg=r(),R=s("div"),d(mo.$$.fragment),Gf=r(),dc=s("p"),dc.innerHTML=IT,Xf=r(),d(sn.$$.fragment),Nf=r(),pc=s("div"),d(go.$$.fragment),qg=r(),de=s("div"),d(uo.$$.fragment),Hf=r(),mc=s("p"),mc.innerHTML=BT,Rf=r(),gc=s("div"),d(ho.$$.fragment),Wg=r(),pe=s("div"),d(fo.$$.fragment),Of=r(),uc=s("p"),uc.innerHTML=qT,Qf=r(),hc=s("div"),d(_o.$$.fragment),Sg=r(),me=s("div"),d(bo.$$.fragment),Af=r(),fc=s("p"),fc.innerHTML=WT,Yf=r(),_c=s("div"),d(vo.$$.fragment),Vg=r(),j=s("div"),d(yo.$$.fragment),Kf=r(),bc=s("p"),bc.innerHTML=ST,e_=r(),vc=s("p"),vc.innerHTML=VT,t_=r(),d(on.$$.fragment),n_=r(),d(rn.$$.fragment),s_=r(),yc=s("p"),yc.innerHTML=ZT,o_=r(),Tc=s("p"),Tc.textContent=ET,r_=r(),$c=s("ul"),$c.innerHTML=DT,a_=r(),wc=s("p"),wc.textContent=PT,i_=r(),kc=s("ul"),kc.innerHTML=GT,c_=r(),d(an.$$.fragment),l_=r(),Mc=s("div"),d(To.$$.fragment),Zg=r(),ge=s("div"),d($o.$$.fragment),d_=r(),xc=s("p"),xc.innerHTML=XT,p_=r(),jc=s("div"),d(wo.$$.fragment),Eg=r(),ue=s("div"),d(ko.$$.fragment),m_=r(),Lc=s("p"),Lc.innerHTML=NT,g_=r(),Fc=s("div"),d(Mo.$$.fragment),Dg=r(),he=s("div"),d(xo.$$.fragment),u_=r(),zc=s("p"),zc.textContent=HT,h_=r(),Uc=s("div"),d(jo.$$.fragment),Pg=r(),fe=s("div"),d(Lo.$$.fragment),f_=r(),Jc=s("p"),Jc.innerHTML=RT,__=r(),Cc=s("div"),d(Fo.$$.fragment),Gg=r(),_e=s("div"),d(zo.$$.fragment),b_=r(),Ic=s("p"),Ic.textContent=OT,v_=r(),Bc=s("div"),d(Uo.$$.fragment),Xg=r(),be=s("div"),d(Jo.$$.fragment),y_=r(),qc=s("p"),qc.innerHTML=QT,T_=r(),Wc=s("div"),d(Co.$$.fragment),Ng=r(),O=s("div"),d(Io.$$.fragment),$_=r(),Sc=s("p"),Sc.innerHTML=AT,w_=r(),d(cn.$$.fragment),k_=r(),Vc=s("div"),d(Bo.$$.fragment),Hg=r(),q=s("div"),d(qo.$$.fragment),M_=r(),Zc=s("p"),Zc.innerHTML=YT,x_=r(),d(ln.$$.fragment),j_=r(),d(dn.$$.fragment),L_=r(),Ec=s("div"),d(Wo.$$.fragment),Rg=r(),W=s("div"),d(So.$$.fragment),F_=r(),Dc=s("p"),Dc.innerHTML=KT,z_=r(),d(pn.$$.fragment),U_=r(),d(mn.$$.fragment),J_=r(),Pc=s("div"),d(Vo.$$.fragment),Og=r(),ve=s("div"),d(Zo.$$.fragment),C_=r(),Gc=s("p"),Gc.innerHTML=e1,I_=r(),Xc=s("div"),d(Eo.$$.fragment),Qg=r(),Q=s("div"),d(Do.$$.fragment),B_=r(),Nc=s("p"),Nc.innerHTML=t1,q_=r(),d(gn.$$.fragment),W_=r(),Hc=s("div"),d(Po.$$.fragment),Ag=r(),S=s("div"),d(Go.$$.fragment),S_=r(),Rc=s("p"),Rc.innerHTML=n1,V_=r(),d(un.$$.fragment),Z_=r(),d(hn.$$.fragment),E_=r(),Oc=s("div"),d(Xo.$$.fragment),Yg=r(),ye=s("div"),d(No.$$.fragment),D_=r(),Qc=s("p"),Qc.innerHTML=s1,P_=r(),Ac=s("div"),d(Ho.$$.fragment),Kg=r(),Te=s("div"),d(Ro.$$.fragment),G_=r(),Yc=s("p"),Yc.innerHTML=o1,X_=r(),Kc=s("div"),d(Oo.$$.fragment),eu=r(),V=s("div"),d(Qo.$$.fragment),N_=r(),el=s("p"),el.innerHTML=r1,H_=r(),d(fn.$$.fragment),R_=r(),d(_n.$$.fragment),O_=r(),tl=s("div"),d(Ao.$$.fragment),tu=r(),$e=s("div"),d(Yo.$$.fragment),Q_=r(),nl=s("p"),nl.innerHTML=a1,A_=r(),sl=s("div"),d(Ko.$$.fragment),nu=r(),A=s("div"),d(er.$$.fragment),Y_=r(),ol=s("p"),ol.innerHTML=i1,K_=r(),d(bn.$$.fragment),eb=r(),rl=s("div"),d(tr.$$.fragment),su=r(),we=s("div"),d(nr.$$.fragment),tb=r(),al=s("p"),al.innerHTML=c1,nb=r(),il=s("div"),d(sr.$$.fragment),ou=r(),Z=s("div"),d(or.$$.fragment),sb=r(),cl=s("p"),cl.innerHTML=l1,ob=r(),ll=s("p"),ll.innerHTML=d1,rb=r(),d(vn.$$.fragment),ab=r(),dl=s("div"),d(rr.$$.fragment),ru=r(),Y=s("div"),d(ar.$$.fragment),ib=r(),pl=s("p"),pl.innerHTML=p1,cb=r(),ml=s("p"),ml.innerHTML=m1,lb=r(),gl=s("div"),d(ir.$$.fragment),au=r(),qt=s("h3"),yn=s("a"),wm=s("span"),d(cr.$$.fragment),db=r(),ul=s("span"),ul.textContent=g1,iu=r(),ke=s("div"),d(lr.$$.fragment),pb=r(),hl=s("p"),hl.innerHTML=u1,mb=r(),fl=s("div"),d(dr.$$.fragment),cu=r(),Me=s("div"),d(pr.$$.fragment),gb=r(),_l=s("p"),_l.innerHTML=h1,ub=r(),bl=s("div"),d(mr.$$.fragment),lu=r(),xe=s("div"),d(gr.$$.fragment),hb=r(),vl=s("p"),vl.innerHTML=f1,fb=r(),yl=s("div"),d(ur.$$.fragment),du=r(),je=s("div"),d(hr.$$.fragment),_b=r(),Tl=s("p"),Tl.textContent=_1,bb=r(),Tn=s("div"),d(fr.$$.fragment),vb=r(),$l=s("p"),$l.textContent=b1,pu=r(),Le=s("div"),d(_r.$$.fragment),yb=r(),wl=s("p"),wl.innerHTML=v1,Tb=r(),kl=s("div"),d(br.$$.fragment),mu=r(),Fe=s("div"),d(vr.$$.fragment),$b=r(),Ml=s("p"),Ml.textContent=y1,wb=r(),$n=s("div"),d(yr.$$.fragment),kb=r(),xl=s("p"),xl.textContent=T1,gu=r(),ze=s("div"),d(Tr.$$.fragment),Mb=r(),jl=s("p"),jl.innerHTML=$1,xb=r(),Ll=s("div"),d($r.$$.fragment),uu=r(),Ue=s("div"),d(wr.$$.fragment),jb=r(),Fl=s("p"),Fl.innerHTML=w1,Lb=r(),zl=s("div"),d(kr.$$.fragment),hu=r(),Je=s("div"),d(Mr.$$.fragment),Fb=r(),Ul=s("p"),Ul.innerHTML=k1,zb=r(),Jl=s("div"),d(xr.$$.fragment),fu=r(),Ce=s("div"),d(jr.$$.fragment),Ub=r(),Cl=s("p"),Cl.innerHTML=M1,Jb=r(),Il=s("div"),d(Lr.$$.fragment),_u=r(),Ie=s("div"),d(Fr.$$.fragment),Cb=r(),Bl=s("p"),Bl.innerHTML=x1,Ib=r(),ql=s("div"),d(zr.$$.fragment),bu=r(),Be=s("div"),d(Ur.$$.fragment),Bb=r(),Wl=s("p"),Wl.innerHTML=j1,qb=r(),Sl=s("div"),d(Jr.$$.fragment),vu=r(),qe=s("div"),d(Cr.$$.fragment),Wb=r(),Vl=s("p"),Vl.innerHTML=L1,Sb=r(),Zl=s("div"),d(Ir.$$.fragment),yu=r(),We=s("div"),d(Br.$$.fragment),Vb=r(),El=s("p"),El.innerHTML=F1,Zb=r(),Dl=s("div"),d(qr.$$.fragment),Tu=r(),Se=s("div"),d(Wr.$$.fragment),Eb=r(),Pl=s("p"),Pl.innerHTML=z1,Db=r(),Gl=s("div"),d(Sr.$$.fragment),$u=r(),Wt=s("h3"),wn=s("a"),km=s("span"),d(Vr.$$.fragment),Pb=r(),Xl=s("span"),Xl.textContent=U1,wu=r(),Ve=s("div"),d(Zr.$$.fragment),Gb=r(),Nl=s("p"),Nl.innerHTML=J1,Xb=r(),Hl=s("div"),d(Er.$$.fragment),ku=r(),Ze=s("div"),d(Dr.$$.fragment),Nb=r(),Rl=s("p"),Rl.innerHTML=C1,Hb=r(),Ol=s("div"),d(Pr.$$.fragment),Mu=r(),Ee=s("div"),d(Gr.$$.fragment),Rb=r(),Ql=s("p"),Ql.innerHTML=I1,Ob=r(),Al=s("div"),d(Xr.$$.fragment),xu=r(),De=s("div"),d(Nr.$$.fragment),Qb=r(),Yl=s("p"),Yl.textContent=B1,Ab=r(),kn=s("div"),d(Hr.$$.fragment),Yb=r(),Kl=s("p"),Kl.textContent=q1,ju=r(),Pe=s("div"),d(Rr.$$.fragment),Kb=r(),ed=s("p"),ed.innerHTML=W1,ev=r(),td=s("div"),d(Or.$$.fragment),Lu=r(),Ge=s("div"),d(Qr.$$.fragment),tv=r(),nd=s("p"),nd.textContent=S1,nv=r(),Mn=s("div"),d(Ar.$$.fragment),sv=r(),sd=s("p"),sd.textContent=V1,Fu=r(),Xe=s("div"),d(Yr.$$.fragment),ov=r(),od=s("p"),od.innerHTML=Z1,rv=r(),rd=s("div"),d(Kr.$$.fragment),zu=r(),Ne=s("div"),d(ea.$$.fragment),av=r(),ad=s("p"),ad.innerHTML=E1,iv=r(),id=s("div"),d(ta.$$.fragment),Uu=r(),He=s("div"),d(na.$$.fragment),cv=r(),cd=s("p"),cd.innerHTML=D1,lv=r(),ld=s("div"),d(sa.$$.fragment),Ju=r(),Re=s("div"),d(oa.$$.fragment),dv=r(),dd=s("p"),dd.innerHTML=P1,pv=r(),pd=s("div"),d(ra.$$.fragment),Cu=r(),Oe=s("div"),d(aa.$$.fragment),mv=r(),md=s("p"),md.innerHTML=G1,gv=r(),gd=s("div"),d(ia.$$.fragment),Iu=r(),Qe=s("div"),d(ca.$$.fragment),uv=r(),ud=s("p"),ud.innerHTML=X1,hv=r(),hd=s("div"),d(la.$$.fragment),Bu=r(),Ae=s("div"),d(da.$$.fragment),fv=r(),fd=s("p"),fd.innerHTML=N1,_v=r(),_d=s("div"),d(pa.$$.fragment),qu=r(),St=s("h2"),xn=s("a"),Mm=s("span"),d(ma.$$.fragment),bv=r(),bd=s("span"),bd.textContent=H1,Wu=r(),ga=s("p"),ga.innerHTML=R1,Su=r(),Ye=s("div"),d(ua.$$.fragment),vv=r(),vd=s("p"),vd.textContent=O1,yv=r(),yd=s("div"),d(ha.$$.fragment),Vu=r(),Vt=s("div"),d(fa.$$.fragment),Tv=r(),Td=s("div"),d(_a.$$.fragment),Zu=r(),Ke=s("div"),d(ba.$$.fragment),$v=r(),$d=s("p"),$d.innerHTML=Q1,wv=r(),wd=s("div"),d(va.$$.fragment),Eu=r(),et=s("div"),d(ya.$$.fragment),kv=r(),kd=s("p"),kd.innerHTML=A1,Mv=r(),Md=s("div"),d(Ta.$$.fragment),Du=r(),Zt=s("h2"),jn=s("a"),xm=s("span"),d($a.$$.fragment),xv=r(),xd=s("span"),xd.textContent=Y1,Pu=r(),wa=s("p"),wa.innerHTML=K1,Gu=r(),L=s("div"),d(ka.$$.fragment),jv=r(),jd=s("p"),jd.textContent=e$,Lv=r(),Ld=s("p"),Ld.textContent=t$,Fv=r(),d(Ln.$$.fragment),zv=r(),Fd=s("p"),Fd.textContent=n$,Uv=r(),Fn=s("div"),d(Ma.$$.fragment),Jv=r(),zd=s("p"),zd.textContent=s$,Cv=r(),zn=s("div"),d(xa.$$.fragment),Iv=r(),Ud=s("p"),Ud.textContent=o$,Bv=r(),Un=s("div"),d(ja.$$.fragment),qv=r(),Jd=s("p"),Jd.textContent=r$,Wv=r(),Jn=s("div"),d(La.$$.fragment),Sv=r(),Cd=s("p"),Cd.innerHTML=a$,Vv=r(),Cn=s("div"),d(Fa.$$.fragment),Zv=r(),Id=s("p"),Id.textContent=i$,Ev=r(),In=s("div"),d(za.$$.fragment),Dv=r(),Bd=s("p"),Bd.textContent=c$,Pv=r(),st=s("div"),d(Ua.$$.fragment),Gv=r(),qd=s("p"),qd.innerHTML=l$,Xv=r(),Wd=s("p"),Wd.textContent=d$,Xu=r(),Et=s("div"),d(Ja.$$.fragment),Nv=r(),Sd=s("p"),Sd.innerHTML=p$,Nu=r(),Dt=s("div"),d(Ca.$$.fragment),Hv=r(),Vd=s("p"),Vd.innerHTML=m$,Hu=r(),K=s("div"),d(Ia.$$.fragment),Rv=r(),Zd=s("p"),Zd.textContent=g$,Ov=r(),B=s("div"),d(Ba.$$.fragment),Qv=r(),Ed=s("p"),Ed.textContent=u$,Av=r(),Dd=s("p"),Dd.innerHTML=h$,Yv=r(),Pd=s("p"),Pd.innerHTML=f$,Kv=r(),Gd=s("p"),Gd.innerHTML=_$,ey=r(),Xd=s("p"),Xd.textContent=b$,ty=r(),Bn=s("div"),d(qa.$$.fragment),ny=r(),Nd=s("p"),Nd.textContent=v$,Ru=r(),Pt=s("h2"),qn=s("a"),jm=s("span"),d(Wa.$$.fragment),sy=r(),Hd=s("span"),Hd.textContent=y$,Ou=r(),ee=s("div"),d(Sa.$$.fragment),oy=r(),Rd=s("p"),Rd.innerHTML=T$,ry=r(),Od=s("div"),d(Va.$$.fragment),ay=r(),Qd=s("div"),d(Za.$$.fragment),Qu=r(),C=s("div"),d(Ea.$$.fragment),iy=r(),Ad=s("p"),Ad.innerHTML=$$,cy=r(),Yd=s("p"),Yd.innerHTML=w$,ly=r(),Kd=s("p"),Kd.innerHTML=k$,dy=r(),ep=s("div"),d(Da.$$.fragment),py=r(),tp=s("div"),d(Pa.$$.fragment),Au=r(),te=s("div"),d(Ga.$$.fragment),my=r(),np=s("p"),np.innerHTML=M$,gy=r(),sp=s("div"),d(Xa.$$.fragment),uy=r(),op=s("div"),d(Na.$$.fragment),Yu=r(),Gt=s("h2"),Wn=s("a"),Lm=s("span"),d(Ha.$$.fragment),hy=r(),rp=s("span"),rp.textContent=x$,Ku=r(),tt=s("div"),d(Ra.$$.fragment),fy=r(),ap=s("p"),ap.textContent=j$,_y=r(),ip=s("p"),ip.innerHTML=L$,eh=r(),nt=s("div"),d(Oa.$$.fragment),by=r(),cp=s("p"),cp.textContent=F$,vy=r(),lp=s("p"),lp.innerHTML=z$,th=r(),Xt=s("h2"),Sn=s("a"),Fm=s("span"),d(Qa.$$.fragment),yy=r(),dp=s("span"),dp.textContent=U$,nh=r(),J=s("div"),d(Aa.$$.fragment),Ty=r(),pp=s("p"),pp.textContent=J$,$y=r(),d(Vn.$$.fragment),wy=r(),d(Zn.$$.fragment),ky=r(),En=s("div"),d(Ya.$$.fragment),My=r(),mp=s("p"),mp.textContent=C$,xy=r(),Dn=s("div"),d(Ka.$$.fragment),jy=r(),gp=s("p"),gp.textContent=I$,Ly=r(),Pn=s("div"),d(ei.$$.fragment),Fy=r(),up=s("p"),up.textContent=B$,sh=r(),E=s("div"),d(ti.$$.fragment),zy=r(),hp=s("p"),hp.textContent=q$,Uy=r(),d(Gn.$$.fragment),Jy=r(),d(Xn.$$.fragment),Cy=r(),Nn=s("div"),d(ni.$$.fragment),Iy=r(),fp=s("p"),fp.textContent=W$,oh=r(),zm=s("p"),this.h()},l(e){const i=v0("svelte-1phssyn",document.head);b=o(i,"META",{name:!0,content:!0}),i.forEach(n),k=a(e),$=o(e,"P",{}),f($).forEach(n),T=a(e),w=o(e,"H1",{class:!0});var si=f(w);_=o(si,"A",{id:!0,class:!0,href:!0});var Um=f(_);M=o(Um,"SPAN",{});var Jm=f(M);p(rs.$$.fragment,Jm),Jm.forEach(n),Um.forEach(n),Nh=a(si),bi=o(si,"SPAN",{"data-svelte-h":!0}),v(bi)!=="svelte-143p7rg"&&(bi.textContent=By),si.forEach(n),Vm=a(e),as=o(e,"P",{"data-svelte-h":!0}),v(as)!=="svelte-l8fur4"&&(as.innerHTML=qy),Zm=a(e),is=o(e,"P",{"data-svelte-h":!0}),v(is)!=="svelte-1blns9e"&&(is.textContent=Wy),Em=a(e),dt=o(e,"H2",{class:!0});var oi=f(dt);Nt=o(oi,"A",{id:!0,class:!0,href:!0});var Cm=f(Nt);_m=o(Cm,"SPAN",{});var Im=f(_m);p(cs.$$.fragment,Im),Im.forEach(n),Cm.forEach(n),Hh=a(oi),vi=o(oi,"SPAN",{"data-svelte-h":!0}),v(vi)!=="svelte-1j1svdq"&&(vi.textContent=Sy),oi.forEach(n),Dm=a(e),ls=o(e,"P",{"data-svelte-h":!0}),v(ls)!=="svelte-1gg7gaa"&&(ls.innerHTML=Vy),Pm=a(e),ds=o(e,"P",{"data-svelte-h":!0}),v(ds)!=="svelte-wwwyth"&&(ds.textContent=Zy),Gm=a(e),p(ps.$$.fragment,e),Xm=a(e),ms=o(e,"P",{"data-svelte-h":!0}),v(ms)!=="svelte-1fgti5v"&&(ms.innerHTML=Ey),Nm=a(e),gs=o(e,"UL",{"data-svelte-h":!0}),v(gs)!=="svelte-1arpy9m"&&(gs.innerHTML=Dy),Hm=a(e),us=o(e,"P",{"data-svelte-h":!0}),v(us)!=="svelte-xh59rv"&&(us.innerHTML=Py),Rm=a(e),hs=o(e,"P",{"data-svelte-h":!0}),v(hs)!=="svelte-rqavqw"&&(hs.innerHTML=Gy),Om=a(e),fs=o(e,"P",{"data-svelte-h":!0}),v(fs)!=="svelte-qr02he"&&(fs.innerHTML=Xy),Qm=a(e),p(_s.$$.fragment,e),Am=a(e),bs=o(e,"P",{"data-svelte-h":!0}),v(bs)!=="svelte-114v74y"&&(bs.innerHTML=Ny),Ym=a(e),vs=o(e,"P",{"data-svelte-h":!0}),v(vs)!=="svelte-13knclg"&&(vs.innerHTML=Hy),Km=a(e),ys=o(e,"P",{"data-svelte-h":!0}),v(ys)!=="svelte-gz8gow"&&(ys.textContent=Ry),eg=a(e),pt=o(e,"H3",{class:!0});var ri=f(pt);Ht=o(ri,"A",{id:!0,class:!0,href:!0});var Bm=f(Ht);bm=o(Bm,"SPAN",{});var qm=f(bm);p(Ts.$$.fragment,qm),qm.forEach(n),Bm.forEach(n),Rh=a(ri),yi=o(ri,"SPAN",{"data-svelte-h":!0}),v(yi)!=="svelte-1e6sddw"&&(yi.textContent=Oy),ri.forEach(n),tg=a(e),mt=o(e,"DIV",{class:!0});var ai=f(mt);p($s.$$.fragment,ai),Oh=a(ai),Ti=o(ai,"P",{"data-svelte-h":!0}),v(Ti)!=="svelte-1bnrp61"&&(Ti.textContent=Qy),ai.forEach(n),ng=a(e),gt=o(e,"DIV",{class:!0});var ii=f(gt);p(ws.$$.fragment,ii),Qh=a(ii),$i=o(ii,"P",{"data-svelte-h":!0}),v($i)!=="svelte-fenhkk"&&($i.textContent=Ay),ii.forEach(n),sg=a(e),ut=o(e,"DIV",{class:!0});var ci=f(ut);p(ks.$$.fragment,ci),Ah=a(ci),wi=o(ci,"P",{"data-svelte-h":!0}),v(wi)!=="svelte-1dqtgq4"&&(wi.textContent=Yy),ci.forEach(n),og=a(e),ht=o(e,"DIV",{class:!0});var li=f(ht);p(Ms.$$.fragment,li),Yh=a(li),ki=o(li,"P",{"data-svelte-h":!0}),v(ki)!=="svelte-10orfv5"&&(ki.textContent=Ky),li.forEach(n),rg=a(e),ft=o(e,"DIV",{class:!0});var di=f(ft);p(xs.$$.fragment,di),Kh=a(di),Mi=o(di,"P",{"data-svelte-h":!0}),v(Mi)!=="svelte-jg8udg"&&(Mi.textContent=eT),di.forEach(n),ag=a(e),_t=o(e,"DIV",{class:!0});var pi=f(_t);p(js.$$.fragment,pi),ef=a(pi),xi=o(pi,"P",{"data-svelte-h":!0}),v(xi)!=="svelte-1i40667"&&(xi.textContent=tT),pi.forEach(n),ig=a(e),bt=o(e,"DIV",{class:!0});var mi=f(bt);p(Ls.$$.fragment,mi),tf=a(mi),ji=o(mi,"P",{"data-svelte-h":!0}),v(ji)!=="svelte-n5fi8x"&&(ji.textContent=nT),mi.forEach(n),cg=a(e),vt=o(e,"DIV",{class:!0});var gi=f(vt);p(Fs.$$.fragment,gi),nf=a(gi),Li=o(gi,"P",{"data-svelte-h":!0}),v(Li)!=="svelte-h5pj3l"&&(Li.textContent=sT),gi.forEach(n),lg=a(e),yt=o(e,"DIV",{class:!0});var ui=f(yt);p(zs.$$.fragment,ui),sf=a(ui),Fi=o(ui,"P",{"data-svelte-h":!0}),v(Fi)!=="svelte-pru3ks"&&(Fi.textContent=oT),ui.forEach(n),dg=a(e),Tt=o(e,"DIV",{class:!0});var hi=f(Tt);p(Us.$$.fragment,hi),of=a(hi),zi=o(hi,"P",{"data-svelte-h":!0}),v(zi)!=="svelte-pru3ks"&&(zi.textContent=rT),hi.forEach(n),pg=a(e),$t=o(e,"H3",{class:!0});var fi=f($t);Rt=o(fi,"A",{id:!0,class:!0,href:!0});var Wm=f(Rt);vm=o(Wm,"SPAN",{});var Sm=f(vm);p(Js.$$.fragment,Sm),Sm.forEach(n),Wm.forEach(n),rf=a(fi),Ui=o(fi,"SPAN",{"data-svelte-h":!0}),v(Ui)!=="svelte-13st32y"&&(Ui.textContent=aT),fi.forEach(n),mg=a(e),wt=o(e,"DIV",{class:!0});var _i=f(wt);p(Cs.$$.fragment,_i),af=a(_i),Ji=o(_i,"P",{"data-svelte-h":!0}),v(Ji)!=="svelte-1bnrp61"&&(Ji.textContent=iT),_i.forEach(n),gg=a(e),kt=o(e,"DIV",{class:!0});var ah=f(kt);p(Is.$$.fragment,ah),cf=a(ah),Ci=o(ah,"P",{"data-svelte-h":!0}),v(Ci)!=="svelte-fenhkk"&&(Ci.textContent=cT),ah.forEach(n),ug=a(e),Mt=o(e,"DIV",{class:!0});var ih=f(Mt);p(Bs.$$.fragment,ih),lf=a(ih),Ii=o(ih,"P",{"data-svelte-h":!0}),v(Ii)!=="svelte-1dqtgq4"&&(Ii.textContent=lT),ih.forEach(n),hg=a(e),xt=o(e,"DIV",{class:!0});var ch=f(xt);p(qs.$$.fragment,ch),df=a(ch),Bi=o(ch,"P",{"data-svelte-h":!0}),v(Bi)!=="svelte-10orfv5"&&(Bi.textContent=dT),ch.forEach(n),fg=a(e),jt=o(e,"DIV",{class:!0});var lh=f(jt);p(Ws.$$.fragment,lh),pf=a(lh),qi=o(lh,"P",{"data-svelte-h":!0}),v(qi)!=="svelte-jg8udg"&&(qi.textContent=pT),lh.forEach(n),_g=a(e),Lt=o(e,"DIV",{class:!0});var dh=f(Lt);p(Ss.$$.fragment,dh),mf=a(dh),Wi=o(dh,"P",{"data-svelte-h":!0}),v(Wi)!=="svelte-1i40667"&&(Wi.textContent=mT),dh.forEach(n),bg=a(e),Ft=o(e,"DIV",{class:!0});var ph=f(Ft);p(Vs.$$.fragment,ph),gf=a(ph),Si=o(ph,"P",{"data-svelte-h":!0}),v(Si)!=="svelte-n5fi8x"&&(Si.textContent=gT),ph.forEach(n),vg=a(e),zt=o(e,"DIV",{class:!0});var mh=f(zt);p(Zs.$$.fragment,mh),uf=a(mh),Vi=o(mh,"P",{"data-svelte-h":!0}),v(Vi)!=="svelte-h5pj3l"&&(Vi.textContent=uT),mh.forEach(n),yg=a(e),Ut=o(e,"DIV",{class:!0});var gh=f(Ut);p(Es.$$.fragment,gh),hf=a(gh),Zi=o(gh,"P",{"data-svelte-h":!0}),v(Zi)!=="svelte-b9zq6n"&&(Zi.textContent=hT),gh.forEach(n),Tg=a(e),Jt=o(e,"DIV",{class:!0});var uh=f(Jt);p(Ds.$$.fragment,uh),ff=a(uh),Ei=o(uh,"P",{"data-svelte-h":!0}),v(Ei)!=="svelte-pru3ks"&&(Ei.textContent=fT),uh.forEach(n),$g=a(e),Ct=o(e,"H3",{class:!0});var hh=f(Ct);Ot=o(hh,"A",{id:!0,class:!0,href:!0});var S$=f(Ot);ym=o(S$,"SPAN",{});var V$=f(ym);p(Ps.$$.fragment,V$),V$.forEach(n),S$.forEach(n),_f=a(hh),Di=o(hh,"SPAN",{"data-svelte-h":!0}),v(Di)!=="svelte-1iv7dlo"&&(Di.textContent=_T),hh.forEach(n),wg=a(e),oe=o(e,"DIV",{class:!0});var _p=f(oe);p(Gs.$$.fragment,_p),bf=a(_p),Pi=o(_p,"P",{"data-svelte-h":!0}),v(Pi)!=="svelte-qoov36"&&(Pi.textContent=bT),vf=a(_p),Qt=o(_p,"DIV",{class:!0});var fh=f(Qt);p(Xs.$$.fragment,fh),yf=a(fh),Gi=o(fh,"P",{"data-svelte-h":!0}),v(Gi)!=="svelte-5ihtpa"&&(Gi.textContent=vT),fh.forEach(n),_p.forEach(n),kg=a(e),re=o(e,"DIV",{class:!0});var bp=f(re);p(Ns.$$.fragment,bp),Tf=a(bp),Xi=o(bp,"P",{"data-svelte-h":!0}),v(Xi)!=="svelte-1tz7qrd"&&(Xi.textContent=yT),$f=a(bp),At=o(bp,"DIV",{class:!0});var _h=f(At);p(Hs.$$.fragment,_h),wf=a(_h),Ni=o(_h,"P",{"data-svelte-h":!0}),v(Ni)!=="svelte-5ihtpa"&&(Ni.textContent=TT),_h.forEach(n),bp.forEach(n),Mg=a(e),ae=o(e,"DIV",{class:!0});var vp=f(ae);p(Rs.$$.fragment,vp),kf=a(vp),Hi=o(vp,"P",{"data-svelte-h":!0}),v(Hi)!=="svelte-1tz7qrd"&&(Hi.textContent=$T),Mf=a(vp),Yt=o(vp,"DIV",{class:!0});var bh=f(Yt);p(Os.$$.fragment,bh),xf=a(bh),Ri=o(bh,"P",{"data-svelte-h":!0}),v(Ri)!=="svelte-5ihtpa"&&(Ri.textContent=wT),bh.forEach(n),vp.forEach(n),xg=a(e),It=o(e,"H2",{class:!0});var vh=f(It);Kt=o(vh,"A",{id:!0,class:!0,href:!0});var Z$=f(Kt);Tm=o(Z$,"SPAN",{});var E$=f(Tm);p(Qs.$$.fragment,E$),E$.forEach(n),Z$.forEach(n),jf=a(vh),Oi=o(vh,"SPAN",{"data-svelte-h":!0}),v(Oi)!=="svelte-1u5gntf"&&(Oi.textContent=kT),vh.forEach(n),jg=a(e),As=o(e,"P",{"data-svelte-h":!0}),v(As)!=="svelte-f3yvc7"&&(As.innerHTML=MT),Lg=a(e),Bt=o(e,"H3",{class:!0});var yh=f(Bt);en=o(yh,"A",{id:!0,class:!0,href:!0});var D$=f(en);$m=o(D$,"SPAN",{});var P$=f($m);p(Ys.$$.fragment,P$),P$.forEach(n),D$.forEach(n),Lf=a(yh),Qi=o(yh,"SPAN",{"data-svelte-h":!0}),v(Qi)!=="svelte-1e6sddw"&&(Qi.textContent=xT),yh.forEach(n),Fg=a(e),ie=o(e,"DIV",{class:!0});var yp=f(ie);p(Ks.$$.fragment,yp),Ff=a(yp),Ai=o(yp,"P",{"data-svelte-h":!0}),v(Ai)!=="svelte-drtesy"&&(Ai.innerHTML=jT),zf=a(yp),Yi=o(yp,"DIV",{class:!0});var G$=f(Yi);p(eo.$$.fragment,G$),G$.forEach(n),yp.forEach(n),zg=a(e),X=o(e,"DIV",{class:!0});var Hn=f(X);p(to.$$.fragment,Hn),Uf=a(Hn),Ki=o(Hn,"P",{"data-svelte-h":!0}),v(Ki)!=="svelte-151ju3h"&&(Ki.innerHTML=LT),Jf=a(Hn),ec=o(Hn,"P",{"data-svelte-h":!0}),v(ec)!=="svelte-lu7kru"&&(ec.innerHTML=FT),Cf=a(Hn),tc=o(Hn,"DIV",{class:!0});var X$=f(tc);p(no.$$.fragment,X$),X$.forEach(n),Hn.forEach(n),Ug=a(e),ce=o(e,"DIV",{class:!0});var Tp=f(ce);p(so.$$.fragment,Tp),If=a(Tp),nc=o(Tp,"P",{"data-svelte-h":!0}),v(nc)!=="svelte-i2uxap"&&(nc.innerHTML=zT),Bf=a(Tp),sc=o(Tp,"DIV",{class:!0});var N$=f(sc);p(oo.$$.fragment,N$),N$.forEach(n),Tp.forEach(n),Jg=a(e),le=o(e,"DIV",{class:!0});var $p=f(le);p(ro.$$.fragment,$p),qf=a($p),oc=o($p,"P",{"data-svelte-h":!0}),v(oc)!=="svelte-1euyjy8"&&(oc.innerHTML=UT),Wf=a($p),rc=o($p,"DIV",{class:!0});var H$=f(rc);p(ao.$$.fragment,H$),H$.forEach(n),$p.forEach(n),Cg=a(e),N=o(e,"DIV",{class:!0});var Rn=f(N);p(io.$$.fragment,Rn),Sf=a(Rn),ac=o(Rn,"P",{"data-svelte-h":!0}),v(ac)!=="svelte-1g3p3yi"&&(ac.innerHTML=JT),Vf=a(Rn),p(tn.$$.fragment,Rn),Zf=a(Rn),ic=o(Rn,"DIV",{class:!0});var R$=f(ic);p(co.$$.fragment,R$),R$.forEach(n),Rn.forEach(n),Ig=a(e),H=o(e,"DIV",{class:!0});var On=f(H);p(lo.$$.fragment,On),Ef=a(On),cc=o(On,"P",{"data-svelte-h":!0}),v(cc)!=="svelte-9coi3i"&&(cc.innerHTML=CT),Df=a(On),p(nn.$$.fragment,On),Pf=a(On),lc=o(On,"DIV",{class:!0});var O$=f(lc);p(po.$$.fragment,O$),O$.forEach(n),On.forEach(n),Bg=a(e),R=o(e,"DIV",{class:!0});var Qn=f(R);p(mo.$$.fragment,Qn),Gf=a(Qn),dc=o(Qn,"P",{"data-svelte-h":!0}),v(dc)!=="svelte-a8r3fr"&&(dc.innerHTML=IT),Xf=a(Qn),p(sn.$$.fragment,Qn),Nf=a(Qn),pc=o(Qn,"DIV",{class:!0});var Q$=f(pc);p(go.$$.fragment,Q$),Q$.forEach(n),Qn.forEach(n),qg=a(e),de=o(e,"DIV",{class:!0});var wp=f(de);p(uo.$$.fragment,wp),Hf=a(wp),mc=o(wp,"P",{"data-svelte-h":!0}),v(mc)!=="svelte-ntadn"&&(mc.innerHTML=BT),Rf=a(wp),gc=o(wp,"DIV",{class:!0});var A$=f(gc);p(ho.$$.fragment,A$),A$.forEach(n),wp.forEach(n),Wg=a(e),pe=o(e,"DIV",{class:!0});var kp=f(pe);p(fo.$$.fragment,kp),Of=a(kp),uc=o(kp,"P",{"data-svelte-h":!0}),v(uc)!=="svelte-15g4knr"&&(uc.innerHTML=qT),Qf=a(kp),hc=o(kp,"DIV",{class:!0});var Y$=f(hc);p(_o.$$.fragment,Y$),Y$.forEach(n),kp.forEach(n),Sg=a(e),me=o(e,"DIV",{class:!0});var Mp=f(me);p(bo.$$.fragment,Mp),Af=a(Mp),fc=o(Mp,"P",{"data-svelte-h":!0}),v(fc)!=="svelte-lka4kd"&&(fc.innerHTML=WT),Yf=a(Mp),_c=o(Mp,"DIV",{class:!0});var K$=f(_c);p(vo.$$.fragment,K$),K$.forEach(n),Mp.forEach(n),Vg=a(e),j=o(e,"DIV",{class:!0});var F=f(j);p(yo.$$.fragment,F),Kf=a(F),bc=o(F,"P",{"data-svelte-h":!0}),v(bc)!=="svelte-1dk14jl"&&(bc.innerHTML=ST),e_=a(F),vc=o(F,"P",{"data-svelte-h":!0}),v(vc)!=="svelte-1t8rpl0"&&(vc.innerHTML=VT),t_=a(F),p(on.$$.fragment,F),n_=a(F),p(rn.$$.fragment,F),s_=a(F),yc=o(F,"P",{"data-svelte-h":!0}),v(yc)!=="svelte-2fpu88"&&(yc.innerHTML=ZT),o_=a(F),Tc=o(F,"P",{"data-svelte-h":!0}),v(Tc)!=="svelte-1nj4y15"&&(Tc.textContent=ET),r_=a(F),$c=o(F,"UL",{"data-svelte-h":!0}),v($c)!=="svelte-1knkx0p"&&($c.innerHTML=DT),a_=a(F),wc=o(F,"P",{"data-svelte-h":!0}),v(wc)!=="svelte-5xwkxe"&&(wc.textContent=PT),i_=a(F),kc=o(F,"UL",{"data-svelte-h":!0}),v(kc)!=="svelte-7rlln8"&&(kc.innerHTML=GT),c_=a(F),p(an.$$.fragment,F),l_=a(F),Mc=o(F,"DIV",{class:!0});var ew=f(Mc);p(To.$$.fragment,ew),ew.forEach(n),F.forEach(n),Zg=a(e),ge=o(e,"DIV",{class:!0});var xp=f(ge);p($o.$$.fragment,xp),d_=a(xp),xc=o(xp,"P",{"data-svelte-h":!0}),v(xc)!=="svelte-1hcl0ha"&&(xc.innerHTML=XT),p_=a(xp),jc=o(xp,"DIV",{class:!0});var tw=f(jc);p(wo.$$.fragment,tw),tw.forEach(n),xp.forEach(n),Eg=a(e),ue=o(e,"DIV",{class:!0});var jp=f(ue);p(ko.$$.fragment,jp),m_=a(jp),Lc=o(jp,"P",{"data-svelte-h":!0}),v(Lc)!=="svelte-9gfnav"&&(Lc.innerHTML=NT),g_=a(jp),Fc=o(jp,"DIV",{class:!0});var nw=f(Fc);p(Mo.$$.fragment,nw),nw.forEach(n),jp.forEach(n),Dg=a(e),he=o(e,"DIV",{class:!0});var Lp=f(he);p(xo.$$.fragment,Lp),u_=a(Lp),zc=o(Lp,"P",{"data-svelte-h":!0}),v(zc)!=="svelte-y1kta5"&&(zc.textContent=HT),h_=a(Lp),Uc=o(Lp,"DIV",{class:!0});var sw=f(Uc);p(jo.$$.fragment,sw),sw.forEach(n),Lp.forEach(n),Pg=a(e),fe=o(e,"DIV",{class:!0});var Fp=f(fe);p(Lo.$$.fragment,Fp),f_=a(Fp),Jc=o(Fp,"P",{"data-svelte-h":!0}),v(Jc)!=="svelte-l8wqof"&&(Jc.innerHTML=RT),__=a(Fp),Cc=o(Fp,"DIV",{class:!0});var ow=f(Cc);p(Fo.$$.fragment,ow),ow.forEach(n),Fp.forEach(n),Gg=a(e),_e=o(e,"DIV",{class:!0});var zp=f(_e);p(zo.$$.fragment,zp),b_=a(zp),Ic=o(zp,"P",{"data-svelte-h":!0}),v(Ic)!=="svelte-th82mu"&&(Ic.textContent=OT),v_=a(zp),Bc=o(zp,"DIV",{class:!0});var rw=f(Bc);p(Uo.$$.fragment,rw),rw.forEach(n),zp.forEach(n),Xg=a(e),be=o(e,"DIV",{class:!0});var Up=f(be);p(Jo.$$.fragment,Up),y_=a(Up),qc=o(Up,"P",{"data-svelte-h":!0}),v(qc)!=="svelte-nebqir"&&(qc.innerHTML=QT),T_=a(Up),Wc=o(Up,"DIV",{class:!0});var aw=f(Wc);p(Co.$$.fragment,aw),aw.forEach(n),Up.forEach(n),Ng=a(e),O=o(e,"DIV",{class:!0});var An=f(O);p(Io.$$.fragment,An),$_=a(An),Sc=o(An,"P",{"data-svelte-h":!0}),v(Sc)!=="svelte-nrctmo"&&(Sc.innerHTML=AT),w_=a(An),p(cn.$$.fragment,An),k_=a(An),Vc=o(An,"DIV",{class:!0});var iw=f(Vc);p(Bo.$$.fragment,iw),iw.forEach(n),An.forEach(n),Hg=a(e),q=o(e,"DIV",{class:!0});var ot=f(q);p(qo.$$.fragment,ot),M_=a(ot),Zc=o(ot,"P",{"data-svelte-h":!0}),v(Zc)!=="svelte-1seqc3n"&&(Zc.innerHTML=YT),x_=a(ot),p(ln.$$.fragment,ot),j_=a(ot),p(dn.$$.fragment,ot),L_=a(ot),Ec=o(ot,"DIV",{class:!0});var cw=f(Ec);p(Wo.$$.fragment,cw),cw.forEach(n),ot.forEach(n),Rg=a(e),W=o(e,"DIV",{class:!0});var rt=f(W);p(So.$$.fragment,rt),F_=a(rt),Dc=o(rt,"P",{"data-svelte-h":!0}),v(Dc)!=="svelte-hhgmof"&&(Dc.innerHTML=KT),z_=a(rt),p(pn.$$.fragment,rt),U_=a(rt),p(mn.$$.fragment,rt),J_=a(rt),Pc=o(rt,"DIV",{class:!0});var lw=f(Pc);p(Vo.$$.fragment,lw),lw.forEach(n),rt.forEach(n),Og=a(e),ve=o(e,"DIV",{class:!0});var Jp=f(ve);p(Zo.$$.fragment,Jp),C_=a(Jp),Gc=o(Jp,"P",{"data-svelte-h":!0}),v(Gc)!=="svelte-1yvu4vf"&&(Gc.innerHTML=e1),I_=a(Jp),Xc=o(Jp,"DIV",{class:!0});var dw=f(Xc);p(Eo.$$.fragment,dw),dw.forEach(n),Jp.forEach(n),Qg=a(e),Q=o(e,"DIV",{class:!0});var Yn=f(Q);p(Do.$$.fragment,Yn),B_=a(Yn),Nc=o(Yn,"P",{"data-svelte-h":!0}),v(Nc)!=="svelte-exwhzw"&&(Nc.innerHTML=t1),q_=a(Yn),p(gn.$$.fragment,Yn),W_=a(Yn),Hc=o(Yn,"DIV",{class:!0});var pw=f(Hc);p(Po.$$.fragment,pw),pw.forEach(n),Yn.forEach(n),Ag=a(e),S=o(e,"DIV",{class:!0});var at=f(S);p(Go.$$.fragment,at),S_=a(at),Rc=o(at,"P",{"data-svelte-h":!0}),v(Rc)!=="svelte-17fg652"&&(Rc.innerHTML=n1),V_=a(at),p(un.$$.fragment,at),Z_=a(at),p(hn.$$.fragment,at),E_=a(at),Oc=o(at,"DIV",{class:!0});var mw=f(Oc);p(Xo.$$.fragment,mw),mw.forEach(n),at.forEach(n),Yg=a(e),ye=o(e,"DIV",{class:!0});var Cp=f(ye);p(No.$$.fragment,Cp),D_=a(Cp),Qc=o(Cp,"P",{"data-svelte-h":!0}),v(Qc)!=="svelte-1171zzm"&&(Qc.innerHTML=s1),P_=a(Cp),Ac=o(Cp,"DIV",{class:!0});var gw=f(Ac);p(Ho.$$.fragment,gw),gw.forEach(n),Cp.forEach(n),Kg=a(e),Te=o(e,"DIV",{class:!0});var Ip=f(Te);p(Ro.$$.fragment,Ip),G_=a(Ip),Yc=o(Ip,"P",{"data-svelte-h":!0}),v(Yc)!=="svelte-a554sd"&&(Yc.innerHTML=o1),X_=a(Ip),Kc=o(Ip,"DIV",{class:!0});var uw=f(Kc);p(Oo.$$.fragment,uw),uw.forEach(n),Ip.forEach(n),eu=a(e),V=o(e,"DIV",{class:!0});var it=f(V);p(Qo.$$.fragment,it),N_=a(it),el=o(it,"P",{"data-svelte-h":!0}),v(el)!=="svelte-jf5ff1"&&(el.innerHTML=r1),H_=a(it),p(fn.$$.fragment,it),R_=a(it),p(_n.$$.fragment,it),O_=a(it),tl=o(it,"DIV",{class:!0});var hw=f(tl);p(Ao.$$.fragment,hw),hw.forEach(n),it.forEach(n),tu=a(e),$e=o(e,"DIV",{class:!0});var Bp=f($e);p(Yo.$$.fragment,Bp),Q_=a(Bp),nl=o(Bp,"P",{"data-svelte-h":!0}),v(nl)!=="svelte-4ojcid"&&(nl.innerHTML=a1),A_=a(Bp),sl=o(Bp,"DIV",{class:!0});var fw=f(sl);p(Ko.$$.fragment,fw),fw.forEach(n),Bp.forEach(n),nu=a(e),A=o(e,"DIV",{class:!0});var Kn=f(A);p(er.$$.fragment,Kn),Y_=a(Kn),ol=o(Kn,"P",{"data-svelte-h":!0}),v(ol)!=="svelte-1izb6kv"&&(ol.innerHTML=i1),K_=a(Kn),p(bn.$$.fragment,Kn),eb=a(Kn),rl=o(Kn,"DIV",{class:!0});var _w=f(rl);p(tr.$$.fragment,_w),_w.forEach(n),Kn.forEach(n),su=a(e),we=o(e,"DIV",{class:!0});var qp=f(we);p(nr.$$.fragment,qp),tb=a(qp),al=o(qp,"P",{"data-svelte-h":!0}),v(al)!=="svelte-2tw0se"&&(al.innerHTML=c1),nb=a(qp),il=o(qp,"DIV",{class:!0});var bw=f(il);p(sr.$$.fragment,bw),bw.forEach(n),qp.forEach(n),ou=a(e),Z=o(e,"DIV",{class:!0});var ct=f(Z);p(or.$$.fragment,ct),sb=a(ct),cl=o(ct,"P",{"data-svelte-h":!0}),v(cl)!=="svelte-pi0cpg"&&(cl.innerHTML=l1),ob=a(ct),ll=o(ct,"P",{"data-svelte-h":!0}),v(ll)!=="svelte-5qs7tv"&&(ll.innerHTML=d1),rb=a(ct),p(vn.$$.fragment,ct),ab=a(ct),dl=o(ct,"DIV",{class:!0});var vw=f(dl);p(rr.$$.fragment,vw),vw.forEach(n),ct.forEach(n),ru=a(e),Y=o(e,"DIV",{class:!0});var es=f(Y);p(ar.$$.fragment,es),ib=a(es),pl=o(es,"P",{"data-svelte-h":!0}),v(pl)!=="svelte-1sygpwz"&&(pl.innerHTML=p1),cb=a(es),ml=o(es,"P",{"data-svelte-h":!0}),v(ml)!=="svelte-qmmn5t"&&(ml.innerHTML=m1),lb=a(es),gl=o(es,"DIV",{class:!0});var yw=f(gl);p(ir.$$.fragment,yw),yw.forEach(n),es.forEach(n),au=a(e),qt=o(e,"H3",{class:!0});var Th=f(qt);yn=o(Th,"A",{id:!0,class:!0,href:!0});var Tw=f(yn);wm=o(Tw,"SPAN",{});var $w=f(wm);p(cr.$$.fragment,$w),$w.forEach(n),Tw.forEach(n),db=a(Th),ul=o(Th,"SPAN",{"data-svelte-h":!0}),v(ul)!=="svelte-13st32y"&&(ul.textContent=g1),Th.forEach(n),iu=a(e),ke=o(e,"DIV",{class:!0});var Wp=f(ke);p(lr.$$.fragment,Wp),pb=a(Wp),hl=o(Wp,"P",{"data-svelte-h":!0}),v(hl)!=="svelte-voeybv"&&(hl.innerHTML=u1),mb=a(Wp),fl=o(Wp,"DIV",{class:!0});var ww=f(fl);p(dr.$$.fragment,ww),ww.forEach(n),Wp.forEach(n),cu=a(e),Me=o(e,"DIV",{class:!0});var Sp=f(Me);p(pr.$$.fragment,Sp),gb=a(Sp),_l=o(Sp,"P",{"data-svelte-h":!0}),v(_l)!=="svelte-17rwet3"&&(_l.innerHTML=h1),ub=a(Sp),bl=o(Sp,"DIV",{class:!0});var kw=f(bl);p(mr.$$.fragment,kw),kw.forEach(n),Sp.forEach(n),lu=a(e),xe=o(e,"DIV",{class:!0});var Vp=f(xe);p(gr.$$.fragment,Vp),hb=a(Vp),vl=o(Vp,"P",{"data-svelte-h":!0}),v(vl)!=="svelte-1557waw"&&(vl.innerHTML=f1),fb=a(Vp),yl=o(Vp,"DIV",{class:!0});var Mw=f(yl);p(ur.$$.fragment,Mw),Mw.forEach(n),Vp.forEach(n),du=a(e),je=o(e,"DIV",{class:!0});var Zp=f(je);p(hr.$$.fragment,Zp),_b=a(Zp),Tl=o(Zp,"P",{"data-svelte-h":!0}),v(Tl)!=="svelte-y1kta5"&&(Tl.textContent=_1),bb=a(Zp),Tn=o(Zp,"DIV",{class:!0});var $h=f(Tn);p(fr.$$.fragment,$h),vb=a($h),$l=o($h,"P",{"data-svelte-h":!0}),v($l)!=="svelte-5aspnb"&&($l.textContent=b1),$h.forEach(n),Zp.forEach(n),pu=a(e),Le=o(e,"DIV",{class:!0});var Ep=f(Le);p(_r.$$.fragment,Ep),yb=a(Ep),wl=o(Ep,"P",{"data-svelte-h":!0}),v(wl)!=="svelte-16xpl5j"&&(wl.innerHTML=v1),Tb=a(Ep),kl=o(Ep,"DIV",{class:!0});var xw=f(kl);p(br.$$.fragment,xw),xw.forEach(n),Ep.forEach(n),mu=a(e),Fe=o(e,"DIV",{class:!0});var Dp=f(Fe);p(vr.$$.fragment,Dp),$b=a(Dp),Ml=o(Dp,"P",{"data-svelte-h":!0}),v(Ml)!=="svelte-th82mu"&&(Ml.textContent=y1),wb=a(Dp),$n=o(Dp,"DIV",{class:!0});var wh=f($n);p(yr.$$.fragment,wh),kb=a(wh),xl=o(wh,"P",{"data-svelte-h":!0}),v(xl)!=="svelte-hcoglc"&&(xl.textContent=T1),wh.forEach(n),Dp.forEach(n),gu=a(e),ze=o(e,"DIV",{class:!0});var Pp=f(ze);p(Tr.$$.fragment,Pp),Mb=a(Pp),jl=o(Pp,"P",{"data-svelte-h":!0}),v(jl)!=="svelte-1wj83fn"&&(jl.innerHTML=$1),xb=a(Pp),Ll=o(Pp,"DIV",{class:!0});var jw=f(Ll);p($r.$$.fragment,jw),jw.forEach(n),Pp.forEach(n),uu=a(e),Ue=o(e,"DIV",{class:!0});var Gp=f(Ue);p(wr.$$.fragment,Gp),jb=a(Gp),Fl=o(Gp,"P",{"data-svelte-h":!0}),v(Fl)!=="svelte-1lbpi80"&&(Fl.innerHTML=w1),Lb=a(Gp),zl=o(Gp,"DIV",{class:!0});var Lw=f(zl);p(kr.$$.fragment,Lw),Lw.forEach(n),Gp.forEach(n),hu=a(e),Je=o(e,"DIV",{class:!0});var Xp=f(Je);p(Mr.$$.fragment,Xp),Fb=a(Xp),Ul=o(Xp,"P",{"data-svelte-h":!0}),v(Ul)!=="svelte-l6uyww"&&(Ul.innerHTML=k1),zb=a(Xp),Jl=o(Xp,"DIV",{class:!0});var Fw=f(Jl);p(xr.$$.fragment,Fw),Fw.forEach(n),Xp.forEach(n),fu=a(e),Ce=o(e,"DIV",{class:!0});var Np=f(Ce);p(jr.$$.fragment,Np),Ub=a(Np),Cl=o(Np,"P",{"data-svelte-h":!0}),v(Cl)!=="svelte-g5f6kf"&&(Cl.innerHTML=M1),Jb=a(Np),Il=o(Np,"DIV",{class:!0});var zw=f(Il);p(Lr.$$.fragment,zw),zw.forEach(n),Np.forEach(n),_u=a(e),Ie=o(e,"DIV",{class:!0});var Hp=f(Ie);p(Fr.$$.fragment,Hp),Cb=a(Hp),Bl=o(Hp,"P",{"data-svelte-h":!0}),v(Bl)!=="svelte-t5gdhi"&&(Bl.innerHTML=x1),Ib=a(Hp),ql=o(Hp,"DIV",{class:!0});var Uw=f(ql);p(zr.$$.fragment,Uw),Uw.forEach(n),Hp.forEach(n),bu=a(e),Be=o(e,"DIV",{class:!0});var Rp=f(Be);p(Ur.$$.fragment,Rp),Bb=a(Rp),Wl=o(Rp,"P",{"data-svelte-h":!0}),v(Wl)!=="svelte-a554sd"&&(Wl.innerHTML=j1),qb=a(Rp),Sl=o(Rp,"DIV",{class:!0});var Jw=f(Sl);p(Jr.$$.fragment,Jw),Jw.forEach(n),Rp.forEach(n),vu=a(e),qe=o(e,"DIV",{class:!0});var Op=f(qe);p(Cr.$$.fragment,Op),Wb=a(Op),Vl=o(Op,"P",{"data-svelte-h":!0}),v(Vl)!=="svelte-19favda"&&(Vl.innerHTML=L1),Sb=a(Op),Zl=o(Op,"DIV",{class:!0});var Cw=f(Zl);p(Ir.$$.fragment,Cw),Cw.forEach(n),Op.forEach(n),yu=a(e),We=o(e,"DIV",{class:!0});var Qp=f(We);p(Br.$$.fragment,Qp),Vb=a(Qp),El=o(Qp,"P",{"data-svelte-h":!0}),v(El)!=="svelte-pjbkwd"&&(El.innerHTML=F1),Zb=a(Qp),Dl=o(Qp,"DIV",{class:!0});var Iw=f(Dl);p(qr.$$.fragment,Iw),Iw.forEach(n),Qp.forEach(n),Tu=a(e),Se=o(e,"DIV",{class:!0});var Ap=f(Se);p(Wr.$$.fragment,Ap),Eb=a(Ap),Pl=o(Ap,"P",{"data-svelte-h":!0}),v(Pl)!=="svelte-18sh8t7"&&(Pl.innerHTML=z1),Db=a(Ap),Gl=o(Ap,"DIV",{class:!0});var Bw=f(Gl);p(Sr.$$.fragment,Bw),Bw.forEach(n),Ap.forEach(n),$u=a(e),Wt=o(e,"H3",{class:!0});var kh=f(Wt);wn=o(kh,"A",{id:!0,class:!0,href:!0});var qw=f(wn);km=o(qw,"SPAN",{});var Ww=f(km);p(Vr.$$.fragment,Ww),Ww.forEach(n),qw.forEach(n),Pb=a(kh),Xl=o(kh,"SPAN",{"data-svelte-h":!0}),v(Xl)!=="svelte-1iv7dlo"&&(Xl.textContent=U1),kh.forEach(n),wu=a(e),Ve=o(e,"DIV",{class:!0});var Yp=f(Ve);p(Zr.$$.fragment,Yp),Gb=a(Yp),Nl=o(Yp,"P",{"data-svelte-h":!0}),v(Nl)!=="svelte-zv94bn"&&(Nl.innerHTML=J1),Xb=a(Yp),Hl=o(Yp,"DIV",{class:!0});var Sw=f(Hl);p(Er.$$.fragment,Sw),Sw.forEach(n),Yp.forEach(n),ku=a(e),Ze=o(e,"DIV",{class:!0});var Kp=f(Ze);p(Dr.$$.fragment,Kp),Nb=a(Kp),Rl=o(Kp,"P",{"data-svelte-h":!0}),v(Rl)!=="svelte-1yf8m7"&&(Rl.innerHTML=C1),Hb=a(Kp),Ol=o(Kp,"DIV",{class:!0});var Vw=f(Ol);p(Pr.$$.fragment,Vw),Vw.forEach(n),Kp.forEach(n),Mu=a(e),Ee=o(e,"DIV",{class:!0});var em=f(Ee);p(Gr.$$.fragment,em),Rb=a(em),Ql=o(em,"P",{"data-svelte-h":!0}),v(Ql)!=="svelte-rkuqik"&&(Ql.innerHTML=I1),Ob=a(em),Al=o(em,"DIV",{class:!0});var Zw=f(Al);p(Xr.$$.fragment,Zw),Zw.forEach(n),em.forEach(n),xu=a(e),De=o(e,"DIV",{class:!0});var tm=f(De);p(Nr.$$.fragment,tm),Qb=a(tm),Yl=o(tm,"P",{"data-svelte-h":!0}),v(Yl)!=="svelte-y1kta5"&&(Yl.textContent=B1),Ab=a(tm),kn=o(tm,"DIV",{class:!0});var Mh=f(kn);p(Hr.$$.fragment,Mh),Yb=a(Mh),Kl=o(Mh,"P",{"data-svelte-h":!0}),v(Kl)!=="svelte-1l17mwc"&&(Kl.textContent=q1),Mh.forEach(n),tm.forEach(n),ju=a(e),Pe=o(e,"DIV",{class:!0});var nm=f(Pe);p(Rr.$$.fragment,nm),Kb=a(nm),ed=o(nm,"P",{"data-svelte-h":!0}),v(ed)!=="svelte-1msuvzz"&&(ed.innerHTML=W1),ev=a(nm),td=o(nm,"DIV",{class:!0});var Ew=f(td);p(Or.$$.fragment,Ew),Ew.forEach(n),nm.forEach(n),Lu=a(e),Ge=o(e,"DIV",{class:!0});var sm=f(Ge);p(Qr.$$.fragment,sm),tv=a(sm),nd=o(sm,"P",{"data-svelte-h":!0}),v(nd)!=="svelte-th82mu"&&(nd.textContent=S1),nv=a(sm),Mn=o(sm,"DIV",{class:!0});var xh=f(Mn);p(Ar.$$.fragment,xh),sv=a(xh),sd=o(xh,"P",{"data-svelte-h":!0}),v(sd)!=="svelte-1tcb5cf"&&(sd.textContent=V1),xh.forEach(n),sm.forEach(n),Fu=a(e),Xe=o(e,"DIV",{class:!0});var om=f(Xe);p(Yr.$$.fragment,om),ov=a(om),od=o(om,"P",{"data-svelte-h":!0}),v(od)!=="svelte-kpdw0r"&&(od.innerHTML=Z1),rv=a(om),rd=o(om,"DIV",{class:!0});var Dw=f(rd);p(Kr.$$.fragment,Dw),Dw.forEach(n),om.forEach(n),zu=a(e),Ne=o(e,"DIV",{class:!0});var rm=f(Ne);p(ea.$$.fragment,rm),av=a(rm),ad=o(rm,"P",{"data-svelte-h":!0}),v(ad)!=="svelte-13b3njj"&&(ad.innerHTML=E1),iv=a(rm),id=o(rm,"DIV",{class:!0});var Pw=f(id);p(ta.$$.fragment,Pw),Pw.forEach(n),rm.forEach(n),Uu=a(e),He=o(e,"DIV",{class:!0});var am=f(He);p(na.$$.fragment,am),cv=a(am),cd=o(am,"P",{"data-svelte-h":!0}),v(cd)!=="svelte-gno4o1"&&(cd.innerHTML=D1),lv=a(am),ld=o(am,"DIV",{class:!0});var Gw=f(ld);p(sa.$$.fragment,Gw),Gw.forEach(n),am.forEach(n),Ju=a(e),Re=o(e,"DIV",{class:!0});var im=f(Re);p(oa.$$.fragment,im),dv=a(im),dd=o(im,"P",{"data-svelte-h":!0}),v(dd)!=="svelte-sxr190"&&(dd.innerHTML=P1),pv=a(im),pd=o(im,"DIV",{class:!0});var Xw=f(pd);p(ra.$$.fragment,Xw),Xw.forEach(n),im.forEach(n),Cu=a(e),Oe=o(e,"DIV",{class:!0});var cm=f(Oe);p(aa.$$.fragment,cm),mv=a(cm),md=o(cm,"P",{"data-svelte-h":!0}),v(md)!=="svelte-niszw7"&&(md.innerHTML=G1),gv=a(cm),gd=o(cm,"DIV",{class:!0});var Nw=f(gd);p(ia.$$.fragment,Nw),Nw.forEach(n),cm.forEach(n),Iu=a(e),Qe=o(e,"DIV",{class:!0});var lm=f(Qe);p(ca.$$.fragment,lm),uv=a(lm),ud=o(lm,"P",{"data-svelte-h":!0}),v(ud)!=="svelte-110n4jl"&&(ud.innerHTML=X1),hv=a(lm),hd=o(lm,"DIV",{class:!0});var Hw=f(hd);p(la.$$.fragment,Hw),Hw.forEach(n),lm.forEach(n),Bu=a(e),Ae=o(e,"DIV",{class:!0});var dm=f(Ae);p(da.$$.fragment,dm),fv=a(dm),fd=o(dm,"P",{"data-svelte-h":!0}),v(fd)!=="svelte-1sygpwz"&&(fd.innerHTML=N1),_v=a(dm),_d=o(dm,"DIV",{class:!0});var Rw=f(_d);p(pa.$$.fragment,Rw),Rw.forEach(n),dm.forEach(n),qu=a(e),St=o(e,"H2",{class:!0});var jh=f(St);xn=o(jh,"A",{id:!0,class:!0,href:!0});var Ow=f(xn);Mm=o(Ow,"SPAN",{});var Qw=f(Mm);p(ma.$$.fragment,Qw),Qw.forEach(n),Ow.forEach(n),bv=a(jh),bd=o(jh,"SPAN",{"data-svelte-h":!0}),v(bd)!=="svelte-d9s72"&&(bd.textContent=H1),jh.forEach(n),Wu=a(e),ga=o(e,"P",{"data-svelte-h":!0}),v(ga)!=="svelte-16avlbn"&&(ga.innerHTML=R1),Su=a(e),Ye=o(e,"DIV",{class:!0});var pm=f(Ye);p(ua.$$.fragment,pm),vv=a(pm),vd=o(pm,"P",{"data-svelte-h":!0}),v(vd)!=="svelte-rfvu1k"&&(vd.textContent=O1),yv=a(pm),yd=o(pm,"DIV",{class:!0});var Aw=f(yd);p(ha.$$.fragment,Aw),Aw.forEach(n),pm.forEach(n),Vu=a(e),Vt=o(e,"DIV",{class:!0});var Lh=f(Vt);p(fa.$$.fragment,Lh),Tv=a(Lh),Td=o(Lh,"DIV",{class:!0});var Yw=f(Td);p(_a.$$.fragment,Yw),Yw.forEach(n),Lh.forEach(n),Zu=a(e),Ke=o(e,"DIV",{class:!0});var mm=f(Ke);p(ba.$$.fragment,mm),$v=a(mm),$d=o(mm,"P",{"data-svelte-h":!0}),v($d)!=="svelte-4hfu96"&&($d.innerHTML=Q1),wv=a(mm),wd=o(mm,"DIV",{class:!0});var Kw=f(wd);p(va.$$.fragment,Kw),Kw.forEach(n),mm.forEach(n),Eu=a(e),et=o(e,"DIV",{class:!0});var gm=f(et);p(ya.$$.fragment,gm),kv=a(gm),kd=o(gm,"P",{"data-svelte-h":!0}),v(kd)!=="svelte-q5v59n"&&(kd.innerHTML=A1),Mv=a(gm),Md=o(gm,"DIV",{class:!0});var e0=f(Md);p(Ta.$$.fragment,e0),e0.forEach(n),gm.forEach(n),Du=a(e),Zt=o(e,"H2",{class:!0});var Fh=f(Zt);jn=o(Fh,"A",{id:!0,class:!0,href:!0});var t0=f(jn);xm=o(t0,"SPAN",{});var n0=f(xm);p($a.$$.fragment,n0),n0.forEach(n),t0.forEach(n),xv=a(Fh),xd=o(Fh,"SPAN",{"data-svelte-h":!0}),v(xd)!=="svelte-1ucxdbr"&&(xd.textContent=Y1),Fh.forEach(n),Pu=a(e),wa=o(e,"P",{"data-svelte-h":!0}),v(wa)!=="svelte-1vv5qy5"&&(wa.innerHTML=K1),Gu=a(e),L=o(e,"DIV",{class:!0});var z=f(L);p(ka.$$.fragment,z),jv=a(z),jd=o(z,"P",{"data-svelte-h":!0}),v(jd)!=="svelte-1kh5y5v"&&(jd.textContent=e$),Lv=a(z),Ld=o(z,"P",{"data-svelte-h":!0}),v(Ld)!=="svelte-1ygkifj"&&(Ld.textContent=t$),Fv=a(z),p(Ln.$$.fragment,z),zv=a(z),Fd=o(z,"P",{"data-svelte-h":!0}),v(Fd)!=="svelte-7kbd1a"&&(Fd.textContent=n$),Uv=a(z),Fn=o(z,"DIV",{class:!0});var zh=f(Fn);p(Ma.$$.fragment,zh),Jv=a(zh),zd=o(zh,"P",{"data-svelte-h":!0}),v(zd)!=="svelte-691079"&&(zd.textContent=s$),zh.forEach(n),Cv=a(z),zn=o(z,"DIV",{class:!0});var Uh=f(zn);p(xa.$$.fragment,Uh),Iv=a(Uh),Ud=o(Uh,"P",{"data-svelte-h":!0}),v(Ud)!=="svelte-dtkk01"&&(Ud.textContent=o$),Uh.forEach(n),Bv=a(z),Un=o(z,"DIV",{class:!0});var Jh=f(Un);p(ja.$$.fragment,Jh),qv=a(Jh),Jd=o(Jh,"P",{"data-svelte-h":!0}),v(Jd)!=="svelte-11pa7k0"&&(Jd.textContent=r$),Jh.forEach(n),Wv=a(z),Jn=o(z,"DIV",{class:!0});var Ch=f(Jn);p(La.$$.fragment,Ch),Sv=a(Ch),Cd=o(Ch,"P",{"data-svelte-h":!0}),v(Cd)!=="svelte-57vcuk"&&(Cd.innerHTML=a$),Ch.forEach(n),Vv=a(z),Cn=o(z,"DIV",{class:!0});var Ih=f(Cn);p(Fa.$$.fragment,Ih),Zv=a(Ih),Id=o(Ih,"P",{"data-svelte-h":!0}),v(Id)!=="svelte-e342dt"&&(Id.textContent=i$),Ih.forEach(n),Ev=a(z),In=o(z,"DIV",{class:!0});var Bh=f(In);p(za.$$.fragment,Bh),Dv=a(Bh),Bd=o(Bh,"P",{"data-svelte-h":!0}),v(Bd)!=="svelte-vbd5xj"&&(Bd.textContent=c$),Bh.forEach(n),Pv=a(z),st=o(z,"DIV",{class:!0});var um=f(st);p(Ua.$$.fragment,um),Gv=a(um),qd=o(um,"P",{"data-svelte-h":!0}),v(qd)!=="svelte-1c2dshy"&&(qd.innerHTML=l$),Xv=a(um),Wd=o(um,"P",{"data-svelte-h":!0}),v(Wd)!=="svelte-1qvu1un"&&(Wd.textContent=d$),um.forEach(n),z.forEach(n),Xu=a(e),Et=o(e,"DIV",{class:!0});var qh=f(Et);p(Ja.$$.fragment,qh),Nv=a(qh),Sd=o(qh,"P",{"data-svelte-h":!0}),v(Sd)!=="svelte-koz29d"&&(Sd.innerHTML=p$),qh.forEach(n),Nu=a(e),Dt=o(e,"DIV",{class:!0});var Wh=f(Dt);p(Ca.$$.fragment,Wh),Hv=a(Wh),Vd=o(Wh,"P",{"data-svelte-h":!0}),v(Vd)!=="svelte-17xixic"&&(Vd.innerHTML=m$),Wh.forEach(n),Hu=a(e),K=o(e,"DIV",{class:!0});var ts=f(K);p(Ia.$$.fragment,ts),Rv=a(ts),Zd=o(ts,"P",{"data-svelte-h":!0}),v(Zd)!=="svelte-rxlesw"&&(Zd.textContent=g$),Ov=a(ts),B=o(ts,"DIV",{class:!0});var ne=f(B);p(Ba.$$.fragment,ne),Qv=a(ne),Ed=o(ne,"P",{"data-svelte-h":!0}),v(Ed)!=="svelte-15hhlou"&&(Ed.textContent=u$),Av=a(ne),Dd=o(ne,"P",{"data-svelte-h":!0}),v(Dd)!=="svelte-x0d0uq"&&(Dd.innerHTML=h$),Yv=a(ne),Pd=o(ne,"P",{"data-svelte-h":!0}),v(Pd)!=="svelte-1w36vm3"&&(Pd.innerHTML=f$),Kv=a(ne),Gd=o(ne,"P",{"data-svelte-h":!0}),v(Gd)!=="svelte-1niq0qw"&&(Gd.innerHTML=_$),ey=a(ne),Xd=o(ne,"P",{"data-svelte-h":!0}),v(Xd)!=="svelte-af4g6f"&&(Xd.textContent=b$),ne.forEach(n),ty=a(ts),Bn=o(ts,"DIV",{class:!0});var Sh=f(Bn);p(qa.$$.fragment,Sh),ny=a(Sh),Nd=o(Sh,"P",{"data-svelte-h":!0}),v(Nd)!=="svelte-eab6jp"&&(Nd.textContent=v$),Sh.forEach(n),ts.forEach(n),Ru=a(e),Pt=o(e,"H2",{class:!0});var Vh=f(Pt);qn=o(Vh,"A",{id:!0,class:!0,href:!0});var s0=f(qn);jm=o(s0,"SPAN",{});var o0=f(jm);p(Wa.$$.fragment,o0),o0.forEach(n),s0.forEach(n),sy=a(Vh),Hd=o(Vh,"SPAN",{"data-svelte-h":!0}),v(Hd)!=="svelte-1wpuqq0"&&(Hd.textContent=y$),Vh.forEach(n),Ou=a(e),ee=o(e,"DIV",{class:!0});var ns=f(ee);p(Sa.$$.fragment,ns),oy=a(ns),Rd=o(ns,"P",{"data-svelte-h":!0}),v(Rd)!=="svelte-168d6b"&&(Rd.innerHTML=T$),ry=a(ns),Od=o(ns,"DIV",{class:!0});var r0=f(Od);p(Va.$$.fragment,r0),r0.forEach(n),ay=a(ns),Qd=o(ns,"DIV",{class:!0});var a0=f(Qd);p(Za.$$.fragment,a0),a0.forEach(n),ns.forEach(n),Qu=a(e),C=o(e,"DIV",{class:!0});var se=f(C);p(Ea.$$.fragment,se),iy=a(se),Ad=o(se,"P",{"data-svelte-h":!0}),v(Ad)!=="svelte-wkez1k"&&(Ad.innerHTML=$$),cy=a(se),Yd=o(se,"P",{"data-svelte-h":!0}),v(Yd)!=="svelte-19qrwo1"&&(Yd.innerHTML=w$),ly=a(se),Kd=o(se,"P",{"data-svelte-h":!0}),v(Kd)!=="svelte-l79sbt"&&(Kd.innerHTML=k$),dy=a(se),ep=o(se,"DIV",{class:!0});var i0=f(ep);p(Da.$$.fragment,i0),i0.forEach(n),py=a(se),tp=o(se,"DIV",{class:!0});var c0=f(tp);p(Pa.$$.fragment,c0),c0.forEach(n),se.forEach(n),Au=a(e),te=o(e,"DIV",{class:!0});var ss=f(te);p(Ga.$$.fragment,ss),my=a(ss),np=o(ss,"P",{"data-svelte-h":!0}),v(np)!=="svelte-ppih7l"&&(np.innerHTML=M$),gy=a(ss),sp=o(ss,"DIV",{class:!0});var l0=f(sp);p(Xa.$$.fragment,l0),l0.forEach(n),uy=a(ss),op=o(ss,"DIV",{class:!0});var d0=f(op);p(Na.$$.fragment,d0),d0.forEach(n),ss.forEach(n),Yu=a(e),Gt=o(e,"H2",{class:!0});var Zh=f(Gt);Wn=o(Zh,"A",{id:!0,class:!0,href:!0});var p0=f(Wn);Lm=o(p0,"SPAN",{});var m0=f(Lm);p(Ha.$$.fragment,m0),m0.forEach(n),p0.forEach(n),hy=a(Zh),rp=o(Zh,"SPAN",{"data-svelte-h":!0}),v(rp)!=="svelte-z6eyrf"&&(rp.textContent=x$),Zh.forEach(n),Ku=a(e),tt=o(e,"DIV",{class:!0});var hm=f(tt);p(Ra.$$.fragment,hm),fy=a(hm),ap=o(hm,"P",{"data-svelte-h":!0}),v(ap)!=="svelte-1aiwpx2"&&(ap.textContent=j$),_y=a(hm),ip=o(hm,"P",{"data-svelte-h":!0}),v(ip)!=="svelte-ts4ue3"&&(ip.innerHTML=L$),hm.forEach(n),eh=a(e),nt=o(e,"DIV",{class:!0});var fm=f(nt);p(Oa.$$.fragment,fm),by=a(fm),cp=o(fm,"P",{"data-svelte-h":!0}),v(cp)!=="svelte-1aiwpx2"&&(cp.textContent=F$),vy=a(fm),lp=o(fm,"P",{"data-svelte-h":!0}),v(lp)!=="svelte-ts4ue3"&&(lp.innerHTML=z$),fm.forEach(n),th=a(e),Xt=o(e,"H2",{class:!0});var Eh=f(Xt);Sn=o(Eh,"A",{id:!0,class:!0,href:!0});var g0=f(Sn);Fm=o(g0,"SPAN",{});var u0=f(Fm);p(Qa.$$.fragment,u0),u0.forEach(n),g0.forEach(n),yy=a(Eh),dp=o(Eh,"SPAN",{"data-svelte-h":!0}),v(dp)!=="svelte-hzt923"&&(dp.textContent=U$),Eh.forEach(n),nh=a(e),J=o(e,"DIV",{class:!0});var P=f(J);p(Aa.$$.fragment,P),Ty=a(P),pp=o(P,"P",{"data-svelte-h":!0}),v(pp)!=="svelte-5jvlz5"&&(pp.textContent=J$),$y=a(P),p(Vn.$$.fragment,P),wy=a(P),p(Zn.$$.fragment,P),ky=a(P),En=o(P,"DIV",{class:!0});var Dh=f(En);p(Ya.$$.fragment,Dh),My=a(Dh),mp=o(Dh,"P",{"data-svelte-h":!0}),v(mp)!=="svelte-10d94rs"&&(mp.textContent=C$),Dh.forEach(n),xy=a(P),Dn=o(P,"DIV",{class:!0});var Ph=f(Dn);p(Ka.$$.fragment,Ph),jy=a(Ph),gp=o(Ph,"P",{"data-svelte-h":!0}),v(gp)!=="svelte-tm945r"&&(gp.textContent=I$),Ph.forEach(n),Ly=a(P),Pn=o(P,"DIV",{class:!0});var Gh=f(Pn);p(ei.$$.fragment,Gh),Fy=a(Gh),up=o(Gh,"P",{"data-svelte-h":!0}),v(up)!=="svelte-1i1356p"&&(up.textContent=B$),Gh.forEach(n),P.forEach(n),sh=a(e),E=o(e,"DIV",{class:!0});var lt=f(E);p(ti.$$.fragment,lt),zy=a(lt),hp=o(lt,"P",{"data-svelte-h":!0}),v(hp)!=="svelte-190fodr"&&(hp.textContent=q$),Uy=a(lt),p(Gn.$$.fragment,lt),Jy=a(lt),p(Xn.$$.fragment,lt),Cy=a(lt),Nn=o(lt,"DIV",{class:!0});var Xh=f(Nn);p(ni.$$.fragment,Xh),Iy=a(Xh),fp=o(Xh,"P",{"data-svelte-h":!0}),v(fp)!=="svelte-16i5iz"&&(fp.textContent=W$),Xh.forEach(n),lt.forEach(n),oh=a(e),zm=o(e,"P",{}),f(zm).forEach(n),this.h()},h(){l(b,"name","hf:doc:metadata"),l(b,"content",JSON.stringify(G0)),l(_,"id","utilities-for-generation"),l(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(_,"href","#utilities-for-generation"),l(w,"class","relative group"),l(Nt,"id","generate-outputs"),l(Nt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Nt,"href","#generate-outputs"),l(dt,"class","relative group"),l(Ht,"id","transformers.generation.GreedySearchEncoderDecoderOutput"),l(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Ht,"href","#transformers.generation.GreedySearchEncoderDecoderOutput"),l(pt,"class","relative group"),l(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Rt,"id","transformers.generation.TFGreedySearchEncoderDecoderOutput"),l(Rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Rt,"href","#transformers.generation.TFGreedySearchEncoderDecoderOutput"),l($t,"class","relative group"),l(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ot,"id","transformers.generation.FlaxSampleOutput"),l(Ot,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Ot,"href","#transformers.generation.FlaxSampleOutput"),l(Ct,"class","relative group"),l(Qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(At,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Kt,"id","logitsprocessor"),l(Kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Kt,"href","#logitsprocessor"),l(It,"class","relative group"),l(en,"id","transformers.AlternatingCodebooksLogitsProcessor"),l(en,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(en,"href","#transformers.AlternatingCodebooksLogitsProcessor"),l(Bt,"class","relative group"),l(Yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(tc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(sc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(lc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Fc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Bc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Xc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Oc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Kc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(tl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(sl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(rl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(il,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(yn,"id","transformers.TFForcedBOSTokenLogitsProcessor"),l(yn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(yn,"href","#transformers.TFForcedBOSTokenLogitsProcessor"),l(qt,"class","relative group"),l(fl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(bl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(kl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ll,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Jl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Il,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ql,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Sl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(wn,"id","transformers.FlaxForcedBOSTokenLogitsProcessor"),l(wn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(wn,"href","#transformers.FlaxForcedBOSTokenLogitsProcessor"),l(Wt,"class","relative group"),l(Hl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Al,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(rd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(id,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(pd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(hd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(_d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(xn,"id","transformers.StoppingCriteria"),l(xn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(xn,"href","#transformers.StoppingCriteria"),l(St,"class","relative group"),l(yd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(wd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Md,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(jn,"id","transformers.Constraint"),l(jn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(jn,"href","#transformers.Constraint"),l(Zt,"class","relative group"),l(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(qn,"id","transformers.BeamScorer"),l(qn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(qn,"href","#transformers.BeamScorer"),l(Pt,"class","relative group"),l(Od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(tp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(sp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(op,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Wn,"id","transformers.top_k_top_p_filtering"),l(Wn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Wn,"href","#transformers.top_k_top_p_filtering"),l(Gt,"class","relative group"),l(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Sn,"id","transformers.TextStreamer"),l(Sn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Sn,"href","#transformers.TextStreamer"),l(Xt,"class","relative group"),l(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,b),c(e,k,i),c(e,$,i),c(e,T,i),c(e,w,i),t(w,_),t(_,M),m(rs,M,null),t(w,Nh),t(w,bi),c(e,Vm,i),c(e,as,i),c(e,Zm,i),c(e,is,i),c(e,Em,i),c(e,dt,i),t(dt,Nt),t(Nt,_m),m(cs,_m,null),t(dt,Hh),t(dt,vi),c(e,Dm,i),c(e,ls,i),c(e,Pm,i),c(e,ds,i),c(e,Gm,i),m(ps,e,i),c(e,Xm,i),c(e,ms,i),c(e,Nm,i),c(e,gs,i),c(e,Hm,i),c(e,us,i),c(e,Rm,i),c(e,hs,i),c(e,Om,i),c(e,fs,i),c(e,Qm,i),m(_s,e,i),c(e,Am,i),c(e,bs,i),c(e,Ym,i),c(e,vs,i),c(e,Km,i),c(e,ys,i),c(e,eg,i),c(e,pt,i),t(pt,Ht),t(Ht,bm),m(Ts,bm,null),t(pt,Rh),t(pt,yi),c(e,tg,i),c(e,mt,i),m($s,mt,null),t(mt,Oh),t(mt,Ti),c(e,ng,i),c(e,gt,i),m(ws,gt,null),t(gt,Qh),t(gt,$i),c(e,sg,i),c(e,ut,i),m(ks,ut,null),t(ut,Ah),t(ut,wi),c(e,og,i),c(e,ht,i),m(Ms,ht,null),t(ht,Yh),t(ht,ki),c(e,rg,i),c(e,ft,i),m(xs,ft,null),t(ft,Kh),t(ft,Mi),c(e,ag,i),c(e,_t,i),m(js,_t,null),t(_t,ef),t(_t,xi),c(e,ig,i),c(e,bt,i),m(Ls,bt,null),t(bt,tf),t(bt,ji),c(e,cg,i),c(e,vt,i),m(Fs,vt,null),t(vt,nf),t(vt,Li),c(e,lg,i),c(e,yt,i),m(zs,yt,null),t(yt,sf),t(yt,Fi),c(e,dg,i),c(e,Tt,i),m(Us,Tt,null),t(Tt,of),t(Tt,zi),c(e,pg,i),c(e,$t,i),t($t,Rt),t(Rt,vm),m(Js,vm,null),t($t,rf),t($t,Ui),c(e,mg,i),c(e,wt,i),m(Cs,wt,null),t(wt,af),t(wt,Ji),c(e,gg,i),c(e,kt,i),m(Is,kt,null),t(kt,cf),t(kt,Ci),c(e,ug,i),c(e,Mt,i),m(Bs,Mt,null),t(Mt,lf),t(Mt,Ii),c(e,hg,i),c(e,xt,i),m(qs,xt,null),t(xt,df),t(xt,Bi),c(e,fg,i),c(e,jt,i),m(Ws,jt,null),t(jt,pf),t(jt,qi),c(e,_g,i),c(e,Lt,i),m(Ss,Lt,null),t(Lt,mf),t(Lt,Wi),c(e,bg,i),c(e,Ft,i),m(Vs,Ft,null),t(Ft,gf),t(Ft,Si),c(e,vg,i),c(e,zt,i),m(Zs,zt,null),t(zt,uf),t(zt,Vi),c(e,yg,i),c(e,Ut,i),m(Es,Ut,null),t(Ut,hf),t(Ut,Zi),c(e,Tg,i),c(e,Jt,i),m(Ds,Jt,null),t(Jt,ff),t(Jt,Ei),c(e,$g,i),c(e,Ct,i),t(Ct,Ot),t(Ot,ym),m(Ps,ym,null),t(Ct,_f),t(Ct,Di),c(e,wg,i),c(e,oe,i),m(Gs,oe,null),t(oe,bf),t(oe,Pi),t(oe,vf),t(oe,Qt),m(Xs,Qt,null),t(Qt,yf),t(Qt,Gi),c(e,kg,i),c(e,re,i),m(Ns,re,null),t(re,Tf),t(re,Xi),t(re,$f),t(re,At),m(Hs,At,null),t(At,wf),t(At,Ni),c(e,Mg,i),c(e,ae,i),m(Rs,ae,null),t(ae,kf),t(ae,Hi),t(ae,Mf),t(ae,Yt),m(Os,Yt,null),t(Yt,xf),t(Yt,Ri),c(e,xg,i),c(e,It,i),t(It,Kt),t(Kt,Tm),m(Qs,Tm,null),t(It,jf),t(It,Oi),c(e,jg,i),c(e,As,i),c(e,Lg,i),c(e,Bt,i),t(Bt,en),t(en,$m),m(Ys,$m,null),t(Bt,Lf),t(Bt,Qi),c(e,Fg,i),c(e,ie,i),m(Ks,ie,null),t(ie,Ff),t(ie,Ai),t(ie,zf),t(ie,Yi),m(eo,Yi,null),c(e,zg,i),c(e,X,i),m(to,X,null),t(X,Uf),t(X,Ki),t(X,Jf),t(X,ec),t(X,Cf),t(X,tc),m(no,tc,null),c(e,Ug,i),c(e,ce,i),m(so,ce,null),t(ce,If),t(ce,nc),t(ce,Bf),t(ce,sc),m(oo,sc,null),c(e,Jg,i),c(e,le,i),m(ro,le,null),t(le,qf),t(le,oc),t(le,Wf),t(le,rc),m(ao,rc,null),c(e,Cg,i),c(e,N,i),m(io,N,null),t(N,Sf),t(N,ac),t(N,Vf),m(tn,N,null),t(N,Zf),t(N,ic),m(co,ic,null),c(e,Ig,i),c(e,H,i),m(lo,H,null),t(H,Ef),t(H,cc),t(H,Df),m(nn,H,null),t(H,Pf),t(H,lc),m(po,lc,null),c(e,Bg,i),c(e,R,i),m(mo,R,null),t(R,Gf),t(R,dc),t(R,Xf),m(sn,R,null),t(R,Nf),t(R,pc),m(go,pc,null),c(e,qg,i),c(e,de,i),m(uo,de,null),t(de,Hf),t(de,mc),t(de,Rf),t(de,gc),m(ho,gc,null),c(e,Wg,i),c(e,pe,i),m(fo,pe,null),t(pe,Of),t(pe,uc),t(pe,Qf),t(pe,hc),m(_o,hc,null),c(e,Sg,i),c(e,me,i),m(bo,me,null),t(me,Af),t(me,fc),t(me,Yf),t(me,_c),m(vo,_c,null),c(e,Vg,i),c(e,j,i),m(yo,j,null),t(j,Kf),t(j,bc),t(j,e_),t(j,vc),t(j,t_),m(on,j,null),t(j,n_),m(rn,j,null),t(j,s_),t(j,yc),t(j,o_),t(j,Tc),t(j,r_),t(j,$c),t(j,a_),t(j,wc),t(j,i_),t(j,kc),t(j,c_),m(an,j,null),t(j,l_),t(j,Mc),m(To,Mc,null),c(e,Zg,i),c(e,ge,i),m($o,ge,null),t(ge,d_),t(ge,xc),t(ge,p_),t(ge,jc),m(wo,jc,null),c(e,Eg,i),c(e,ue,i),m(ko,ue,null),t(ue,m_),t(ue,Lc),t(ue,g_),t(ue,Fc),m(Mo,Fc,null),c(e,Dg,i),c(e,he,i),m(xo,he,null),t(he,u_),t(he,zc),t(he,h_),t(he,Uc),m(jo,Uc,null),c(e,Pg,i),c(e,fe,i),m(Lo,fe,null),t(fe,f_),t(fe,Jc),t(fe,__),t(fe,Cc),m(Fo,Cc,null),c(e,Gg,i),c(e,_e,i),m(zo,_e,null),t(_e,b_),t(_e,Ic),t(_e,v_),t(_e,Bc),m(Uo,Bc,null),c(e,Xg,i),c(e,be,i),m(Jo,be,null),t(be,y_),t(be,qc),t(be,T_),t(be,Wc),m(Co,Wc,null),c(e,Ng,i),c(e,O,i),m(Io,O,null),t(O,$_),t(O,Sc),t(O,w_),m(cn,O,null),t(O,k_),t(O,Vc),m(Bo,Vc,null),c(e,Hg,i),c(e,q,i),m(qo,q,null),t(q,M_),t(q,Zc),t(q,x_),m(ln,q,null),t(q,j_),m(dn,q,null),t(q,L_),t(q,Ec),m(Wo,Ec,null),c(e,Rg,i),c(e,W,i),m(So,W,null),t(W,F_),t(W,Dc),t(W,z_),m(pn,W,null),t(W,U_),m(mn,W,null),t(W,J_),t(W,Pc),m(Vo,Pc,null),c(e,Og,i),c(e,ve,i),m(Zo,ve,null),t(ve,C_),t(ve,Gc),t(ve,I_),t(ve,Xc),m(Eo,Xc,null),c(e,Qg,i),c(e,Q,i),m(Do,Q,null),t(Q,B_),t(Q,Nc),t(Q,q_),m(gn,Q,null),t(Q,W_),t(Q,Hc),m(Po,Hc,null),c(e,Ag,i),c(e,S,i),m(Go,S,null),t(S,S_),t(S,Rc),t(S,V_),m(un,S,null),t(S,Z_),m(hn,S,null),t(S,E_),t(S,Oc),m(Xo,Oc,null),c(e,Yg,i),c(e,ye,i),m(No,ye,null),t(ye,D_),t(ye,Qc),t(ye,P_),t(ye,Ac),m(Ho,Ac,null),c(e,Kg,i),c(e,Te,i),m(Ro,Te,null),t(Te,G_),t(Te,Yc),t(Te,X_),t(Te,Kc),m(Oo,Kc,null),c(e,eu,i),c(e,V,i),m(Qo,V,null),t(V,N_),t(V,el),t(V,H_),m(fn,V,null),t(V,R_),m(_n,V,null),t(V,O_),t(V,tl),m(Ao,tl,null),c(e,tu,i),c(e,$e,i),m(Yo,$e,null),t($e,Q_),t($e,nl),t($e,A_),t($e,sl),m(Ko,sl,null),c(e,nu,i),c(e,A,i),m(er,A,null),t(A,Y_),t(A,ol),t(A,K_),m(bn,A,null),t(A,eb),t(A,rl),m(tr,rl,null),c(e,su,i),c(e,we,i),m(nr,we,null),t(we,tb),t(we,al),t(we,nb),t(we,il),m(sr,il,null),c(e,ou,i),c(e,Z,i),m(or,Z,null),t(Z,sb),t(Z,cl),t(Z,ob),t(Z,ll),t(Z,rb),m(vn,Z,null),t(Z,ab),t(Z,dl),m(rr,dl,null),c(e,ru,i),c(e,Y,i),m(ar,Y,null),t(Y,ib),t(Y,pl),t(Y,cb),t(Y,ml),t(Y,lb),t(Y,gl),m(ir,gl,null),c(e,au,i),c(e,qt,i),t(qt,yn),t(yn,wm),m(cr,wm,null),t(qt,db),t(qt,ul),c(e,iu,i),c(e,ke,i),m(lr,ke,null),t(ke,pb),t(ke,hl),t(ke,mb),t(ke,fl),m(dr,fl,null),c(e,cu,i),c(e,Me,i),m(pr,Me,null),t(Me,gb),t(Me,_l),t(Me,ub),t(Me,bl),m(mr,bl,null),c(e,lu,i),c(e,xe,i),m(gr,xe,null),t(xe,hb),t(xe,vl),t(xe,fb),t(xe,yl),m(ur,yl,null),c(e,du,i),c(e,je,i),m(hr,je,null),t(je,_b),t(je,Tl),t(je,bb),t(je,Tn),m(fr,Tn,null),t(Tn,vb),t(Tn,$l),c(e,pu,i),c(e,Le,i),m(_r,Le,null),t(Le,yb),t(Le,wl),t(Le,Tb),t(Le,kl),m(br,kl,null),c(e,mu,i),c(e,Fe,i),m(vr,Fe,null),t(Fe,$b),t(Fe,Ml),t(Fe,wb),t(Fe,$n),m(yr,$n,null),t($n,kb),t($n,xl),c(e,gu,i),c(e,ze,i),m(Tr,ze,null),t(ze,Mb),t(ze,jl),t(ze,xb),t(ze,Ll),m($r,Ll,null),c(e,uu,i),c(e,Ue,i),m(wr,Ue,null),t(Ue,jb),t(Ue,Fl),t(Ue,Lb),t(Ue,zl),m(kr,zl,null),c(e,hu,i),c(e,Je,i),m(Mr,Je,null),t(Je,Fb),t(Je,Ul),t(Je,zb),t(Je,Jl),m(xr,Jl,null),c(e,fu,i),c(e,Ce,i),m(jr,Ce,null),t(Ce,Ub),t(Ce,Cl),t(Ce,Jb),t(Ce,Il),m(Lr,Il,null),c(e,_u,i),c(e,Ie,i),m(Fr,Ie,null),t(Ie,Cb),t(Ie,Bl),t(Ie,Ib),t(Ie,ql),m(zr,ql,null),c(e,bu,i),c(e,Be,i),m(Ur,Be,null),t(Be,Bb),t(Be,Wl),t(Be,qb),t(Be,Sl),m(Jr,Sl,null),c(e,vu,i),c(e,qe,i),m(Cr,qe,null),t(qe,Wb),t(qe,Vl),t(qe,Sb),t(qe,Zl),m(Ir,Zl,null),c(e,yu,i),c(e,We,i),m(Br,We,null),t(We,Vb),t(We,El),t(We,Zb),t(We,Dl),m(qr,Dl,null),c(e,Tu,i),c(e,Se,i),m(Wr,Se,null),t(Se,Eb),t(Se,Pl),t(Se,Db),t(Se,Gl),m(Sr,Gl,null),c(e,$u,i),c(e,Wt,i),t(Wt,wn),t(wn,km),m(Vr,km,null),t(Wt,Pb),t(Wt,Xl),c(e,wu,i),c(e,Ve,i),m(Zr,Ve,null),t(Ve,Gb),t(Ve,Nl),t(Ve,Xb),t(Ve,Hl),m(Er,Hl,null),c(e,ku,i),c(e,Ze,i),m(Dr,Ze,null),t(Ze,Nb),t(Ze,Rl),t(Ze,Hb),t(Ze,Ol),m(Pr,Ol,null),c(e,Mu,i),c(e,Ee,i),m(Gr,Ee,null),t(Ee,Rb),t(Ee,Ql),t(Ee,Ob),t(Ee,Al),m(Xr,Al,null),c(e,xu,i),c(e,De,i),m(Nr,De,null),t(De,Qb),t(De,Yl),t(De,Ab),t(De,kn),m(Hr,kn,null),t(kn,Yb),t(kn,Kl),c(e,ju,i),c(e,Pe,i),m(Rr,Pe,null),t(Pe,Kb),t(Pe,ed),t(Pe,ev),t(Pe,td),m(Or,td,null),c(e,Lu,i),c(e,Ge,i),m(Qr,Ge,null),t(Ge,tv),t(Ge,nd),t(Ge,nv),t(Ge,Mn),m(Ar,Mn,null),t(Mn,sv),t(Mn,sd),c(e,Fu,i),c(e,Xe,i),m(Yr,Xe,null),t(Xe,ov),t(Xe,od),t(Xe,rv),t(Xe,rd),m(Kr,rd,null),c(e,zu,i),c(e,Ne,i),m(ea,Ne,null),t(Ne,av),t(Ne,ad),t(Ne,iv),t(Ne,id),m(ta,id,null),c(e,Uu,i),c(e,He,i),m(na,He,null),t(He,cv),t(He,cd),t(He,lv),t(He,ld),m(sa,ld,null),c(e,Ju,i),c(e,Re,i),m(oa,Re,null),t(Re,dv),t(Re,dd),t(Re,pv),t(Re,pd),m(ra,pd,null),c(e,Cu,i),c(e,Oe,i),m(aa,Oe,null),t(Oe,mv),t(Oe,md),t(Oe,gv),t(Oe,gd),m(ia,gd,null),c(e,Iu,i),c(e,Qe,i),m(ca,Qe,null),t(Qe,uv),t(Qe,ud),t(Qe,hv),t(Qe,hd),m(la,hd,null),c(e,Bu,i),c(e,Ae,i),m(da,Ae,null),t(Ae,fv),t(Ae,fd),t(Ae,_v),t(Ae,_d),m(pa,_d,null),c(e,qu,i),c(e,St,i),t(St,xn),t(xn,Mm),m(ma,Mm,null),t(St,bv),t(St,bd),c(e,Wu,i),c(e,ga,i),c(e,Su,i),c(e,Ye,i),m(ua,Ye,null),t(Ye,vv),t(Ye,vd),t(Ye,yv),t(Ye,yd),m(ha,yd,null),c(e,Vu,i),c(e,Vt,i),m(fa,Vt,null),t(Vt,Tv),t(Vt,Td),m(_a,Td,null),c(e,Zu,i),c(e,Ke,i),m(ba,Ke,null),t(Ke,$v),t(Ke,$d),t(Ke,wv),t(Ke,wd),m(va,wd,null),c(e,Eu,i),c(e,et,i),m(ya,et,null),t(et,kv),t(et,kd),t(et,Mv),t(et,Md),m(Ta,Md,null),c(e,Du,i),c(e,Zt,i),t(Zt,jn),t(jn,xm),m($a,xm,null),t(Zt,xv),t(Zt,xd),c(e,Pu,i),c(e,wa,i),c(e,Gu,i),c(e,L,i),m(ka,L,null),t(L,jv),t(L,jd),t(L,Lv),t(L,Ld),t(L,Fv),m(Ln,L,null),t(L,zv),t(L,Fd),t(L,Uv),t(L,Fn),m(Ma,Fn,null),t(Fn,Jv),t(Fn,zd),t(L,Cv),t(L,zn),m(xa,zn,null),t(zn,Iv),t(zn,Ud),t(L,Bv),t(L,Un),m(ja,Un,null),t(Un,qv),t(Un,Jd),t(L,Wv),t(L,Jn),m(La,Jn,null),t(Jn,Sv),t(Jn,Cd),t(L,Vv),t(L,Cn),m(Fa,Cn,null),t(Cn,Zv),t(Cn,Id),t(L,Ev),t(L,In),m(za,In,null),t(In,Dv),t(In,Bd),t(L,Pv),t(L,st),m(Ua,st,null),t(st,Gv),t(st,qd),t(st,Xv),t(st,Wd),c(e,Xu,i),c(e,Et,i),m(Ja,Et,null),t(Et,Nv),t(Et,Sd),c(e,Nu,i),c(e,Dt,i),m(Ca,Dt,null),t(Dt,Hv),t(Dt,Vd),c(e,Hu,i),c(e,K,i),m(Ia,K,null),t(K,Rv),t(K,Zd),t(K,Ov),t(K,B),m(Ba,B,null),t(B,Qv),t(B,Ed),t(B,Av),t(B,Dd),t(B,Yv),t(B,Pd),t(B,Kv),t(B,Gd),t(B,ey),t(B,Xd),t(K,ty),t(K,Bn),m(qa,Bn,null),t(Bn,ny),t(Bn,Nd),c(e,Ru,i),c(e,Pt,i),t(Pt,qn),t(qn,jm),m(Wa,jm,null),t(Pt,sy),t(Pt,Hd),c(e,Ou,i),c(e,ee,i),m(Sa,ee,null),t(ee,oy),t(ee,Rd),t(ee,ry),t(ee,Od),m(Va,Od,null),t(ee,ay),t(ee,Qd),m(Za,Qd,null),c(e,Qu,i),c(e,C,i),m(Ea,C,null),t(C,iy),t(C,Ad),t(C,cy),t(C,Yd),t(C,ly),t(C,Kd),t(C,dy),t(C,ep),m(Da,ep,null),t(C,py),t(C,tp),m(Pa,tp,null),c(e,Au,i),c(e,te,i),m(Ga,te,null),t(te,my),t(te,np),t(te,gy),t(te,sp),m(Xa,sp,null),t(te,uy),t(te,op),m(Na,op,null),c(e,Yu,i),c(e,Gt,i),t(Gt,Wn),t(Wn,Lm),m(Ha,Lm,null),t(Gt,hy),t(Gt,rp),c(e,Ku,i),c(e,tt,i),m(Ra,tt,null),t(tt,fy),t(tt,ap),t(tt,_y),t(tt,ip),c(e,eh,i),c(e,nt,i),m(Oa,nt,null),t(nt,by),t(nt,cp),t(nt,vy),t(nt,lp),c(e,th,i),c(e,Xt,i),t(Xt,Sn),t(Sn,Fm),m(Qa,Fm,null),t(Xt,yy),t(Xt,dp),c(e,nh,i),c(e,J,i),m(Aa,J,null),t(J,Ty),t(J,pp),t(J,$y),m(Vn,J,null),t(J,wy),m(Zn,J,null),t(J,ky),t(J,En),m(Ya,En,null),t(En,My),t(En,mp),t(J,xy),t(J,Dn),m(Ka,Dn,null),t(Dn,jy),t(Dn,gp),t(J,Ly),t(J,Pn),m(ei,Pn,null),t(Pn,Fy),t(Pn,up),c(e,sh,i),c(e,E,i),m(ti,E,null),t(E,zy),t(E,hp),t(E,Uy),m(Gn,E,null),t(E,Jy),m(Xn,E,null),t(E,Cy),t(E,Nn),m(ni,Nn,null),t(Nn,Iy),t(Nn,fp),c(e,oh,i),c(e,zm,i),rh=!0},p(e,[i]){const si={};i&2&&(si.$$scope={dirty:i,ctx:e}),tn.$set(si);const Um={};i&2&&(Um.$$scope={dirty:i,ctx:e}),nn.$set(Um);const Jm={};i&2&&(Jm.$$scope={dirty:i,ctx:e}),sn.$set(Jm);const oi={};i&2&&(oi.$$scope={dirty:i,ctx:e}),on.$set(oi);const Cm={};i&2&&(Cm.$$scope={dirty:i,ctx:e}),rn.$set(Cm);const Im={};i&2&&(Im.$$scope={dirty:i,ctx:e}),an.$set(Im);const ri={};i&2&&(ri.$$scope={dirty:i,ctx:e}),cn.$set(ri);const Bm={};i&2&&(Bm.$$scope={dirty:i,ctx:e}),ln.$set(Bm);const qm={};i&2&&(qm.$$scope={dirty:i,ctx:e}),dn.$set(qm);const ai={};i&2&&(ai.$$scope={dirty:i,ctx:e}),pn.$set(ai);const ii={};i&2&&(ii.$$scope={dirty:i,ctx:e}),mn.$set(ii);const ci={};i&2&&(ci.$$scope={dirty:i,ctx:e}),gn.$set(ci);const li={};i&2&&(li.$$scope={dirty:i,ctx:e}),un.$set(li);const di={};i&2&&(di.$$scope={dirty:i,ctx:e}),hn.$set(di);const pi={};i&2&&(pi.$$scope={dirty:i,ctx:e}),fn.$set(pi);const mi={};i&2&&(mi.$$scope={dirty:i,ctx:e}),_n.$set(mi);const gi={};i&2&&(gi.$$scope={dirty:i,ctx:e}),bn.$set(gi);const ui={};i&2&&(ui.$$scope={dirty:i,ctx:e}),vn.$set(ui);const hi={};i&2&&(hi.$$scope={dirty:i,ctx:e}),Ln.$set(hi);const fi={};i&2&&(fi.$$scope={dirty:i,ctx:e}),Vn.$set(fi);const Wm={};i&2&&(Wm.$$scope={dirty:i,ctx:e}),Zn.$set(Wm);const Sm={};i&2&&(Sm.$$scope={dirty:i,ctx:e}),Gn.$set(Sm);const _i={};i&2&&(_i.$$scope={dirty:i,ctx:e}),Xn.$set(_i)},i(e){rh||(g(rs.$$.fragment,e),g(cs.$$.fragment,e),g(ps.$$.fragment,e),g(_s.$$.fragment,e),g(Ts.$$.fragment,e),g($s.$$.fragment,e),g(ws.$$.fragment,e),g(ks.$$.fragment,e),g(Ms.$$.fragment,e),g(xs.$$.fragment,e),g(js.$$.fragment,e),g(Ls.$$.fragment,e),g(Fs.$$.fragment,e),g(zs.$$.fragment,e),g(Us.$$.fragment,e),g(Js.$$.fragment,e),g(Cs.$$.fragment,e),g(Is.$$.fragment,e),g(Bs.$$.fragment,e),g(qs.$$.fragment,e),g(Ws.$$.fragment,e),g(Ss.$$.fragment,e),g(Vs.$$.fragment,e),g(Zs.$$.fragment,e),g(Es.$$.fragment,e),g(Ds.$$.fragment,e),g(Ps.$$.fragment,e),g(Gs.$$.fragment,e),g(Xs.$$.fragment,e),g(Ns.$$.fragment,e),g(Hs.$$.fragment,e),g(Rs.$$.fragment,e),g(Os.$$.fragment,e),g(Qs.$$.fragment,e),g(Ys.$$.fragment,e),g(Ks.$$.fragment,e),g(eo.$$.fragment,e),g(to.$$.fragment,e),g(no.$$.fragment,e),g(so.$$.fragment,e),g(oo.$$.fragment,e),g(ro.$$.fragment,e),g(ao.$$.fragment,e),g(io.$$.fragment,e),g(tn.$$.fragment,e),g(co.$$.fragment,e),g(lo.$$.fragment,e),g(nn.$$.fragment,e),g(po.$$.fragment,e),g(mo.$$.fragment,e),g(sn.$$.fragment,e),g(go.$$.fragment,e),g(uo.$$.fragment,e),g(ho.$$.fragment,e),g(fo.$$.fragment,e),g(_o.$$.fragment,e),g(bo.$$.fragment,e),g(vo.$$.fragment,e),g(yo.$$.fragment,e),g(on.$$.fragment,e),g(rn.$$.fragment,e),g(an.$$.fragment,e),g(To.$$.fragment,e),g($o.$$.fragment,e),g(wo.$$.fragment,e),g(ko.$$.fragment,e),g(Mo.$$.fragment,e),g(xo.$$.fragment,e),g(jo.$$.fragment,e),g(Lo.$$.fragment,e),g(Fo.$$.fragment,e),g(zo.$$.fragment,e),g(Uo.$$.fragment,e),g(Jo.$$.fragment,e),g(Co.$$.fragment,e),g(Io.$$.fragment,e),g(cn.$$.fragment,e),g(Bo.$$.fragment,e),g(qo.$$.fragment,e),g(ln.$$.fragment,e),g(dn.$$.fragment,e),g(Wo.$$.fragment,e),g(So.$$.fragment,e),g(pn.$$.fragment,e),g(mn.$$.fragment,e),g(Vo.$$.fragment,e),g(Zo.$$.fragment,e),g(Eo.$$.fragment,e),g(Do.$$.fragment,e),g(gn.$$.fragment,e),g(Po.$$.fragment,e),g(Go.$$.fragment,e),g(un.$$.fragment,e),g(hn.$$.fragment,e),g(Xo.$$.fragment,e),g(No.$$.fragment,e),g(Ho.$$.fragment,e),g(Ro.$$.fragment,e),g(Oo.$$.fragment,e),g(Qo.$$.fragment,e),g(fn.$$.fragment,e),g(_n.$$.fragment,e),g(Ao.$$.fragment,e),g(Yo.$$.fragment,e),g(Ko.$$.fragment,e),g(er.$$.fragment,e),g(bn.$$.fragment,e),g(tr.$$.fragment,e),g(nr.$$.fragment,e),g(sr.$$.fragment,e),g(or.$$.fragment,e),g(vn.$$.fragment,e),g(rr.$$.fragment,e),g(ar.$$.fragment,e),g(ir.$$.fragment,e),g(cr.$$.fragment,e),g(lr.$$.fragment,e),g(dr.$$.fragment,e),g(pr.$$.fragment,e),g(mr.$$.fragment,e),g(gr.$$.fragment,e),g(ur.$$.fragment,e),g(hr.$$.fragment,e),g(fr.$$.fragment,e),g(_r.$$.fragment,e),g(br.$$.fragment,e),g(vr.$$.fragment,e),g(yr.$$.fragment,e),g(Tr.$$.fragment,e),g($r.$$.fragment,e),g(wr.$$.fragment,e),g(kr.$$.fragment,e),g(Mr.$$.fragment,e),g(xr.$$.fragment,e),g(jr.$$.fragment,e),g(Lr.$$.fragment,e),g(Fr.$$.fragment,e),g(zr.$$.fragment,e),g(Ur.$$.fragment,e),g(Jr.$$.fragment,e),g(Cr.$$.fragment,e),g(Ir.$$.fragment,e),g(Br.$$.fragment,e),g(qr.$$.fragment,e),g(Wr.$$.fragment,e),g(Sr.$$.fragment,e),g(Vr.$$.fragment,e),g(Zr.$$.fragment,e),g(Er.$$.fragment,e),g(Dr.$$.fragment,e),g(Pr.$$.fragment,e),g(Gr.$$.fragment,e),g(Xr.$$.fragment,e),g(Nr.$$.fragment,e),g(Hr.$$.fragment,e),g(Rr.$$.fragment,e),g(Or.$$.fragment,e),g(Qr.$$.fragment,e),g(Ar.$$.fragment,e),g(Yr.$$.fragment,e),g(Kr.$$.fragment,e),g(ea.$$.fragment,e),g(ta.$$.fragment,e),g(na.$$.fragment,e),g(sa.$$.fragment,e),g(oa.$$.fragment,e),g(ra.$$.fragment,e),g(aa.$$.fragment,e),g(ia.$$.fragment,e),g(ca.$$.fragment,e),g(la.$$.fragment,e),g(da.$$.fragment,e),g(pa.$$.fragment,e),g(ma.$$.fragment,e),g(ua.$$.fragment,e),g(ha.$$.fragment,e),g(fa.$$.fragment,e),g(_a.$$.fragment,e),g(ba.$$.fragment,e),g(va.$$.fragment,e),g(ya.$$.fragment,e),g(Ta.$$.fragment,e),g($a.$$.fragment,e),g(ka.$$.fragment,e),g(Ln.$$.fragment,e),g(Ma.$$.fragment,e),g(xa.$$.fragment,e),g(ja.$$.fragment,e),g(La.$$.fragment,e),g(Fa.$$.fragment,e),g(za.$$.fragment,e),g(Ua.$$.fragment,e),g(Ja.$$.fragment,e),g(Ca.$$.fragment,e),g(Ia.$$.fragment,e),g(Ba.$$.fragment,e),g(qa.$$.fragment,e),g(Wa.$$.fragment,e),g(Sa.$$.fragment,e),g(Va.$$.fragment,e),g(Za.$$.fragment,e),g(Ea.$$.fragment,e),g(Da.$$.fragment,e),g(Pa.$$.fragment,e),g(Ga.$$.fragment,e),g(Xa.$$.fragment,e),g(Na.$$.fragment,e),g(Ha.$$.fragment,e),g(Ra.$$.fragment,e),g(Oa.$$.fragment,e),g(Qa.$$.fragment,e),g(Aa.$$.fragment,e),g(Vn.$$.fragment,e),g(Zn.$$.fragment,e),g(Ya.$$.fragment,e),g(Ka.$$.fragment,e),g(ei.$$.fragment,e),g(ti.$$.fragment,e),g(Gn.$$.fragment,e),g(Xn.$$.fragment,e),g(ni.$$.fragment,e),rh=!0)},o(e){u(rs.$$.fragment,e),u(cs.$$.fragment,e),u(ps.$$.fragment,e),u(_s.$$.fragment,e),u(Ts.$$.fragment,e),u($s.$$.fragment,e),u(ws.$$.fragment,e),u(ks.$$.fragment,e),u(Ms.$$.fragment,e),u(xs.$$.fragment,e),u(js.$$.fragment,e),u(Ls.$$.fragment,e),u(Fs.$$.fragment,e),u(zs.$$.fragment,e),u(Us.$$.fragment,e),u(Js.$$.fragment,e),u(Cs.$$.fragment,e),u(Is.$$.fragment,e),u(Bs.$$.fragment,e),u(qs.$$.fragment,e),u(Ws.$$.fragment,e),u(Ss.$$.fragment,e),u(Vs.$$.fragment,e),u(Zs.$$.fragment,e),u(Es.$$.fragment,e),u(Ds.$$.fragment,e),u(Ps.$$.fragment,e),u(Gs.$$.fragment,e),u(Xs.$$.fragment,e),u(Ns.$$.fragment,e),u(Hs.$$.fragment,e),u(Rs.$$.fragment,e),u(Os.$$.fragment,e),u(Qs.$$.fragment,e),u(Ys.$$.fragment,e),u(Ks.$$.fragment,e),u(eo.$$.fragment,e),u(to.$$.fragment,e),u(no.$$.fragment,e),u(so.$$.fragment,e),u(oo.$$.fragment,e),u(ro.$$.fragment,e),u(ao.$$.fragment,e),u(io.$$.fragment,e),u(tn.$$.fragment,e),u(co.$$.fragment,e),u(lo.$$.fragment,e),u(nn.$$.fragment,e),u(po.$$.fragment,e),u(mo.$$.fragment,e),u(sn.$$.fragment,e),u(go.$$.fragment,e),u(uo.$$.fragment,e),u(ho.$$.fragment,e),u(fo.$$.fragment,e),u(_o.$$.fragment,e),u(bo.$$.fragment,e),u(vo.$$.fragment,e),u(yo.$$.fragment,e),u(on.$$.fragment,e),u(rn.$$.fragment,e),u(an.$$.fragment,e),u(To.$$.fragment,e),u($o.$$.fragment,e),u(wo.$$.fragment,e),u(ko.$$.fragment,e),u(Mo.$$.fragment,e),u(xo.$$.fragment,e),u(jo.$$.fragment,e),u(Lo.$$.fragment,e),u(Fo.$$.fragment,e),u(zo.$$.fragment,e),u(Uo.$$.fragment,e),u(Jo.$$.fragment,e),u(Co.$$.fragment,e),u(Io.$$.fragment,e),u(cn.$$.fragment,e),u(Bo.$$.fragment,e),u(qo.$$.fragment,e),u(ln.$$.fragment,e),u(dn.$$.fragment,e),u(Wo.$$.fragment,e),u(So.$$.fragment,e),u(pn.$$.fragment,e),u(mn.$$.fragment,e),u(Vo.$$.fragment,e),u(Zo.$$.fragment,e),u(Eo.$$.fragment,e),u(Do.$$.fragment,e),u(gn.$$.fragment,e),u(Po.$$.fragment,e),u(Go.$$.fragment,e),u(un.$$.fragment,e),u(hn.$$.fragment,e),u(Xo.$$.fragment,e),u(No.$$.fragment,e),u(Ho.$$.fragment,e),u(Ro.$$.fragment,e),u(Oo.$$.fragment,e),u(Qo.$$.fragment,e),u(fn.$$.fragment,e),u(_n.$$.fragment,e),u(Ao.$$.fragment,e),u(Yo.$$.fragment,e),u(Ko.$$.fragment,e),u(er.$$.fragment,e),u(bn.$$.fragment,e),u(tr.$$.fragment,e),u(nr.$$.fragment,e),u(sr.$$.fragment,e),u(or.$$.fragment,e),u(vn.$$.fragment,e),u(rr.$$.fragment,e),u(ar.$$.fragment,e),u(ir.$$.fragment,e),u(cr.$$.fragment,e),u(lr.$$.fragment,e),u(dr.$$.fragment,e),u(pr.$$.fragment,e),u(mr.$$.fragment,e),u(gr.$$.fragment,e),u(ur.$$.fragment,e),u(hr.$$.fragment,e),u(fr.$$.fragment,e),u(_r.$$.fragment,e),u(br.$$.fragment,e),u(vr.$$.fragment,e),u(yr.$$.fragment,e),u(Tr.$$.fragment,e),u($r.$$.fragment,e),u(wr.$$.fragment,e),u(kr.$$.fragment,e),u(Mr.$$.fragment,e),u(xr.$$.fragment,e),u(jr.$$.fragment,e),u(Lr.$$.fragment,e),u(Fr.$$.fragment,e),u(zr.$$.fragment,e),u(Ur.$$.fragment,e),u(Jr.$$.fragment,e),u(Cr.$$.fragment,e),u(Ir.$$.fragment,e),u(Br.$$.fragment,e),u(qr.$$.fragment,e),u(Wr.$$.fragment,e),u(Sr.$$.fragment,e),u(Vr.$$.fragment,e),u(Zr.$$.fragment,e),u(Er.$$.fragment,e),u(Dr.$$.fragment,e),u(Pr.$$.fragment,e),u(Gr.$$.fragment,e),u(Xr.$$.fragment,e),u(Nr.$$.fragment,e),u(Hr.$$.fragment,e),u(Rr.$$.fragment,e),u(Or.$$.fragment,e),u(Qr.$$.fragment,e),u(Ar.$$.fragment,e),u(Yr.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(na.$$.fragment,e),u(sa.$$.fragment,e),u(oa.$$.fragment,e),u(ra.$$.fragment,e),u(aa.$$.fragment,e),u(ia.$$.fragment,e),u(ca.$$.fragment,e),u(la.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ua.$$.fragment,e),u(ha.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(va.$$.fragment,e),u(ya.$$.fragment,e),u(Ta.$$.fragment,e),u($a.$$.fragment,e),u(ka.$$.fragment,e),u(Ln.$$.fragment,e),u(Ma.$$.fragment,e),u(xa.$$.fragment,e),u(ja.$$.fragment,e),u(La.$$.fragment,e),u(Fa.$$.fragment,e),u(za.$$.fragment,e),u(Ua.$$.fragment,e),u(Ja.$$.fragment,e),u(Ca.$$.fragment,e),u(Ia.$$.fragment,e),u(Ba.$$.fragment,e),u(qa.$$.fragment,e),u(Wa.$$.fragment,e),u(Sa.$$.fragment,e),u(Va.$$.fragment,e),u(Za.$$.fragment,e),u(Ea.$$.fragment,e),u(Da.$$.fragment,e),u(Pa.$$.fragment,e),u(Ga.$$.fragment,e),u(Xa.$$.fragment,e),u(Na.$$.fragment,e),u(Ha.$$.fragment,e),u(Ra.$$.fragment,e),u(Oa.$$.fragment,e),u(Qa.$$.fragment,e),u(Aa.$$.fragment,e),u(Vn.$$.fragment,e),u(Zn.$$.fragment,e),u(Ya.$$.fragment,e),u(Ka.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(Gn.$$.fragment,e),u(Xn.$$.fragment,e),u(ni.$$.fragment,e),rh=!1},d(e){e&&(n(k),n($),n(T),n(w),n(Vm),n(as),n(Zm),n(is),n(Em),n(dt),n(Dm),n(ls),n(Pm),n(ds),n(Gm),n(Xm),n(ms),n(Nm),n(gs),n(Hm),n(us),n(Rm),n(hs),n(Om),n(fs),n(Qm),n(Am),n(bs),n(Ym),n(vs),n(Km),n(ys),n(eg),n(pt),n(tg),n(mt),n(ng),n(gt),n(sg),n(ut),n(og),n(ht),n(rg),n(ft),n(ag),n(_t),n(ig),n(bt),n(cg),n(vt),n(lg),n(yt),n(dg),n(Tt),n(pg),n($t),n(mg),n(wt),n(gg),n(kt),n(ug),n(Mt),n(hg),n(xt),n(fg),n(jt),n(_g),n(Lt),n(bg),n(Ft),n(vg),n(zt),n(yg),n(Ut),n(Tg),n(Jt),n($g),n(Ct),n(wg),n(oe),n(kg),n(re),n(Mg),n(ae),n(xg),n(It),n(jg),n(As),n(Lg),n(Bt),n(Fg),n(ie),n(zg),n(X),n(Ug),n(ce),n(Jg),n(le),n(Cg),n(N),n(Ig),n(H),n(Bg),n(R),n(qg),n(de),n(Wg),n(pe),n(Sg),n(me),n(Vg),n(j),n(Zg),n(ge),n(Eg),n(ue),n(Dg),n(he),n(Pg),n(fe),n(Gg),n(_e),n(Xg),n(be),n(Ng),n(O),n(Hg),n(q),n(Rg),n(W),n(Og),n(ve),n(Qg),n(Q),n(Ag),n(S),n(Yg),n(ye),n(Kg),n(Te),n(eu),n(V),n(tu),n($e),n(nu),n(A),n(su),n(we),n(ou),n(Z),n(ru),n(Y),n(au),n(qt),n(iu),n(ke),n(cu),n(Me),n(lu),n(xe),n(du),n(je),n(pu),n(Le),n(mu),n(Fe),n(gu),n(ze),n(uu),n(Ue),n(hu),n(Je),n(fu),n(Ce),n(_u),n(Ie),n(bu),n(Be),n(vu),n(qe),n(yu),n(We),n(Tu),n(Se),n($u),n(Wt),n(wu),n(Ve),n(ku),n(Ze),n(Mu),n(Ee),n(xu),n(De),n(ju),n(Pe),n(Lu),n(Ge),n(Fu),n(Xe),n(zu),n(Ne),n(Uu),n(He),n(Ju),n(Re),n(Cu),n(Oe),n(Iu),n(Qe),n(Bu),n(Ae),n(qu),n(St),n(Wu),n(ga),n(Su),n(Ye),n(Vu),n(Vt),n(Zu),n(Ke),n(Eu),n(et),n(Du),n(Zt),n(Pu),n(wa),n(Gu),n(L),n(Xu),n(Et),n(Nu),n(Dt),n(Hu),n(K),n(Ru),n(Pt),n(Ou),n(ee),n(Qu),n(C),n(Au),n(te),n(Yu),n(Gt),n(Ku),n(tt),n(eh),n(nt),n(th),n(Xt),n(nh),n(J),n(sh),n(E),n(oh),n(zm)),n(b),h(rs),h(cs),h(ps,e),h(_s,e),h(Ts),h($s),h(ws),h(ks),h(Ms),h(xs),h(js),h(Ls),h(Fs),h(zs),h(Us),h(Js),h(Cs),h(Is),h(Bs),h(qs),h(Ws),h(Ss),h(Vs),h(Zs),h(Es),h(Ds),h(Ps),h(Gs),h(Xs),h(Ns),h(Hs),h(Rs),h(Os),h(Qs),h(Ys),h(Ks),h(eo),h(to),h(no),h(so),h(oo),h(ro),h(ao),h(io),h(tn),h(co),h(lo),h(nn),h(po),h(mo),h(sn),h(go),h(uo),h(ho),h(fo),h(_o),h(bo),h(vo),h(yo),h(on),h(rn),h(an),h(To),h($o),h(wo),h(ko),h(Mo),h(xo),h(jo),h(Lo),h(Fo),h(zo),h(Uo),h(Jo),h(Co),h(Io),h(cn),h(Bo),h(qo),h(ln),h(dn),h(Wo),h(So),h(pn),h(mn),h(Vo),h(Zo),h(Eo),h(Do),h(gn),h(Po),h(Go),h(un),h(hn),h(Xo),h(No),h(Ho),h(Ro),h(Oo),h(Qo),h(fn),h(_n),h(Ao),h(Yo),h(Ko),h(er),h(bn),h(tr),h(nr),h(sr),h(or),h(vn),h(rr),h(ar),h(ir),h(cr),h(lr),h(dr),h(pr),h(mr),h(gr),h(ur),h(hr),h(fr),h(_r),h(br),h(vr),h(yr),h(Tr),h($r),h(wr),h(kr),h(Mr),h(xr),h(jr),h(Lr),h(Fr),h(zr),h(Ur),h(Jr),h(Cr),h(Ir),h(Br),h(qr),h(Wr),h(Sr),h(Vr),h(Zr),h(Er),h(Dr),h(Pr),h(Gr),h(Xr),h(Nr),h(Hr),h(Rr),h(Or),h(Qr),h(Ar),h(Yr),h(Kr),h(ea),h(ta),h(na),h(sa),h(oa),h(ra),h(aa),h(ia),h(ca),h(la),h(da),h(pa),h(ma),h(ua),h(ha),h(fa),h(_a),h(ba),h(va),h(ya),h(Ta),h($a),h(ka),h(Ln),h(Ma),h(xa),h(ja),h(La),h(Fa),h(za),h(Ua),h(Ja),h(Ca),h(Ia),h(Ba),h(qa),h(Wa),h(Sa),h(Va),h(Za),h(Ea),h(Da),h(Pa),h(Ga),h(Xa),h(Na),h(Ha),h(Ra),h(Oa),h(Qa),h(Aa),h(Vn),h(Zn),h(Ya),h(Ka),h(ei),h(ti),h(Gn),h(Xn),h(ni)}}}const G0={local:"utilities-for-generation",sections:[{local:"generate-outputs",sections:[{local:"transformers.generation.GreedySearchEncoderDecoderOutput",title:"PyTorch"},{local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",title:"TensorFlow"},{local:"transformers.generation.FlaxSampleOutput",title:"FLAX"}],title:"Generate Outputs"},{local:"logitsprocessor",sections:[{local:"transformers.AlternatingCodebooksLogitsProcessor",title:"PyTorch"},{local:"transformers.TFForcedBOSTokenLogitsProcessor",title:"TensorFlow"},{local:"transformers.FlaxForcedBOSTokenLogitsProcessor",title:"FLAX"}],title:"LogitsProcessor"},{local:"transformers.StoppingCriteria",title:"StoppingCriteria"},{local:"transformers.Constraint",title:"Constraints"},{local:"transformers.BeamScorer",title:"BeamSearch"},{local:"transformers.top_k_top_p_filtering",title:"Utilities"},{local:"transformers.TextStreamer",title:"Streamers"}],title:"Utilities for Generation"};function X0(x){return f0(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class K0 extends _0{constructor(b){super(),b0(this,b,X0,P0,h0,{})}}export{K0 as component};
