import{s as ct,o as dt,n as Se}from"../chunks/scheduler.9bc65507.js";import{S as pt,i as mt,g as a,s as i,u as M,A as ht,h as o,f as s,c,j as f,v as y,y as g,k as p,o as n,a as d,w as v,d as w,t as _,x as T}from"../chunks/index.78c82d43.js";import{T as it}from"../chunks/Tip.87d55b76.js";import{D as ge}from"../chunks/Docstring.4e7352e2.js";import{C as Gs}from"../chunks/CodeBlock.73e038be.js";import{I as Ge}from"../chunks/IconCopyLink.bedaa44d.js";import{E as xs}from"../chunks/ExampleCodeBlock.872b014d.js";function ft(U){let r,b="Example:",m,h,u;return h=new Gs({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdml0Q29uZmlnJTJDJTIwVml2aXRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaVZpVCUyMGdvb2dsZSUyRnZpdml0LWItMTZ4Mi1raW5ldGljczQwMCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBWaXZpdENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZ2aXZpdC1iLTE2eDIta2luZXRpY3M0MDAlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpdml0TW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitConfig, VivitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a ViViT google/vivit-b-16x2-kinetics400 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VivitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the google/vivit-b-16x2-kinetics400 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=a("p"),r.textContent=b,m=i(),M(h.$$.fragment)},l(t){r=o(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-11lpom8"&&(r.textContent=b),m=c(t),y(h.$$.fragment,t)},m(t,j){d(t,r,j),d(t,m,j),v(h,t,j),u=!0},p:Se,i(t){u||(w(h.$$.fragment,t),u=!0)},o(t){_(h.$$.fragment,t),u=!1},d(t){t&&(s(r),s(m)),T(h,t)}}}function ut(U){let r,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=a("p"),r.innerHTML=b},l(m){r=o(m,"P",{"data-svelte-h":!0}),g(r)!=="svelte-fincs2"&&(r.innerHTML=b)},m(m,h){d(m,r,h)},p:Se,d(m){m&&s(r)}}}function gt(U){let r,b="Examples:",m,h,u;return h=new Gs({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitImageProcessor, VivitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 32 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">32</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container=container, indices=indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VivitImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitModel.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3137</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){r=a("p"),r.textContent=b,m=i(),M(h.$$.fragment)},l(t){r=o(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-kvfsh7"&&(r.textContent=b),m=c(t),y(h.$$.fragment,t)},m(t,j){d(t,r,j),d(t,m,j),v(h,t,j),u=!0},p:Se,i(t){u||(w(h.$$.fragment,t),u=!0)},o(t){_(h.$$.fragment,t),u=!1},d(t){t&&(s(r),s(m)),T(h,t)}}}function Mt(U){let r,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=a("p"),r.innerHTML=b},l(m){r=o(m,"P",{"data-svelte-h":!0}),g(r)!=="svelte-fincs2"&&(r.innerHTML=b)},m(m,h){d(m,r,h)},p:Se,d(m){m&&s(r)}}}function yt(U){let r,b="Examples:",m,h,u;return h=new Gs({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VivitImageProcessor, VivitForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 32 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">32</span>, frame_sample_rate=<span class="hljs-number">4</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container=container, indices=indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VivitImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VivitForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google/vivit-b-16x2-kinetics400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
LABEL_116`,wrap:!1}}),{c(){r=a("p"),r.textContent=b,m=i(),M(h.$$.fragment)},l(t){r=o(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-kvfsh7"&&(r.textContent=b),m=c(t),y(h.$$.fragment,t)},m(t,j){d(t,r,j),d(t,m,j),v(h,t,j),u=!0},p:Se,i(t){u||(w(h.$$.fragment,t),u=!0)},o(t){_(h.$$.fragment,t),u=!1},d(t){t&&(s(r),s(m)),T(h,t)}}}function vt(U){let r,b,m,h,u,t,j,q,ps,Me,ks="Video Vision Transformer (ViViT)",Ye,W,R,ke,K,ms,ye,zs="Overview",Qe,O,Rs=`The Vivit model was proposed in <a href="https://arxiv.org/abs/2103.15691" rel="nofollow">ViViT: A Video Vision Transformer</a> by Anurag Arnab, Mostafa Dehghani, Georg Heigold, Chen Sun, Mario Lučić, Cordelia Schmid.
The paper proposes one of the first successful pure-transformer based set of models for video understanding.`,Pe,ee,As="The abstract from the paper is the following:",Le,se,$s="<em>We present pure-transformer based models for video classification, drawing upon the recent success of such models in image classification. Our model extracts spatio-temporal tokens from the input video, which are then encoded by a series of transformer layers. In order to handle the long sequences of tokens encountered in video, we propose several, efficient variants of our model which factorise the spatial- and temporal-dimensions of the input. Although transformer-based models are known to only be effective when large training datasets are available, we show how we can effectively regularise the model during training and leverage pretrained image models to be able to train on comparatively small datasets. We conduct thorough ablation studies, and achieve state-of-the-art results on multiple video classification benchmarks including Kinetics 400 and 600, Epic Kitchens, Something-Something v2 and Moments in Time, outperforming prior methods based on deep 3D convolutional networks.</em>",He,te,Ns='This model was contributed by <a href="https://huggingface.co/jegormeister" rel="nofollow">jegormeister</a>. The original code (written in JAX) can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/vivit" rel="nofollow">here</a>.',De,x,A,ze,ne,hs,ve,Es="VivitConfig",qe,J,ae,fs,we,Xs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitModel">VivitModel</a>. It is used to instantiate a ViViT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the ViViT
<a href="https://huggingface.co/google/vivit-b-16x2-kinetics400" rel="nofollow">google/vivit-b-16x2-kinetics400</a> architecture.`,us,_e,Fs=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,gs,$,Ke,G,N,Re,oe,Ms,Te,Ss="VivitImageProcessor",Oe,V,re,ys,be,Ys="Constructs a Vivit image processor.",vs,E,le,ws,je,Qs="Preprocess an image or batch of images.",es,k,X,Ae,ie,_s,Je,Ps="VivitModel",ss,Z,ce,Ts,Ue,Ls=`The bare ViViT Transformer model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,bs,I,de,js,Ie,Hs='The <a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitModel">VivitModel</a> forward method, overrides the <code>__call__</code> special method.',Js,F,Us,S,ts,z,Y,$e,pe,Is,Ce,Ds="VivitForVideoClassification",ns,B,me,Cs,Ve,qs=`ViViT Transformer model with a video classification head on top (a linear layer on top of the final hidden state of the
[CLS] token) e.g. for Kinetics-400.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Vs,C,he,Zs,Ze,Ks='The <a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitForVideoClassification">VivitForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',Bs,Q,Ws,P,as,Ne,os;return q=new Ge({}),K=new Ge({}),ne=new Ge({}),ae=new ge({props:{name:"class transformers.VivitConfig",anchor:"transformers.VivitConfig",parameters:[{name:"image_size",val:" = 224"},{name:"num_frames",val:" = 32"},{name:"tubelet_size",val:" = [2, 16, 16]"},{name:"num_channels",val:" = 3"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu_fast'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"qkv_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.VivitConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.VivitConfig.tubelet_size",description:`<strong>tubelet_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 16, 16]</code>) &#x2014;
The size (resolution) of each tubelet.`,name:"tubelet_size"},{anchor:"transformers.VivitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.VivitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.VivitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.VivitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.VivitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.VivitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_fast&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code>, <code>&quot;gelu_fast&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.VivitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.VivitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.VivitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VivitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.VivitConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/configuration_vivit.py#L31"}}),$=new xs({props:{anchor:"transformers.VivitConfig.example",$$slots:{default:[ft]},$$scope:{ctx:U}}}),oe=new Ge({}),re=new ge({props:{name:"class transformers.VivitImageProcessor",anchor:"transformers.VivitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00784313725490196"},{name:"offset",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VivitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 256}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overriden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VivitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VivitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VivitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.VivitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VivitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to 1/127.5) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VivitImageProcessor.offset",description:`<strong>offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to scale the image in both negative and positive directions. Can be overriden by the <code>offset</code> in
the <code>preprocess</code> method.`,name:"offset"},{anchor:"transformers.VivitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VivitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VivitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/image_processing_vivit.py#L64"}}),le=new ge({props:{name:"preprocess",anchor:"transformers.VivitImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"offset",val:": bool = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VivitImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>ImageInput</code>) &#x2014;
Video frames to preprocess. Expects a single or batch of video frames with pixel values ranging from 0
to 255. If passing in frames with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VivitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VivitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.VivitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VivitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.VivitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.VivitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between <code>[-1 - 1]</code> if <code>offset</code> is <code>True</code>, <code>[0, 1]</code> otherwise.`,name:"do_rescale"},{anchor:"transformers.VivitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VivitImageProcessor.preprocess.offset",description:`<strong>offset</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.offset</code>) &#x2014;
Whether to scale the image in both negative and positive directions.`,name:"offset"},{anchor:"transformers.VivitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VivitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.VivitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.VivitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VivitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VivitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/image_processing_vivit.py#L285"}}),ie=new Ge({}),ce=new ge({props:{name:"class transformers.VivitModel",anchor:"transformers.VivitModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.VivitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/modeling_vivit.py#L460"}}),de=new ge({props:{name:"forward",anchor:"transformers.VivitModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VivitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitImageProcessor">VivitImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitImageProcessor.preprocess">VivitImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VivitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VivitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VivitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VivitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/modeling_vivit.py#L488",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitConfig"
>VivitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new it({props:{$$slots:{default:[ut]},$$scope:{ctx:U}}}),S=new xs({props:{anchor:"transformers.VivitModel.forward.example",$$slots:{default:[gt]},$$scope:{ctx:U}}}),pe=new Ge({}),me=new ge({props:{name:"class transformers.VivitForVideoClassification",anchor:"transformers.VivitForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VivitForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitConfig">VivitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/modeling_vivit.py#L614"}}),he=new ge({props:{name:"forward",anchor:"transformers.VivitForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VivitForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitImageProcessor">VivitImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitImageProcessor.preprocess">VivitImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.VivitForVideoClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VivitForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VivitForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VivitForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VivitForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/vivit/modeling_vivit.py#L627",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/vivit#transformers.VivitConfig"
>VivitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new it({props:{$$slots:{default:[Mt]},$$scope:{ctx:U}}}),P=new xs({props:{anchor:"transformers.VivitForVideoClassification.forward.example",$$slots:{default:[yt]},$$scope:{ctx:U}}}),{c(){r=a("meta"),b=i(),m=a("p"),h=i(),u=a("h1"),t=a("a"),j=a("span"),M(q.$$.fragment),ps=i(),Me=a("span"),Me.textContent=ks,Ye=i(),W=a("h2"),R=a("a"),ke=a("span"),M(K.$$.fragment),ms=i(),ye=a("span"),ye.textContent=zs,Qe=i(),O=a("p"),O.innerHTML=Rs,Pe=i(),ee=a("p"),ee.textContent=As,Le=i(),se=a("p"),se.innerHTML=$s,He=i(),te=a("p"),te.innerHTML=Ns,De=i(),x=a("h2"),A=a("a"),ze=a("span"),M(ne.$$.fragment),hs=i(),ve=a("span"),ve.textContent=Es,qe=i(),J=a("div"),M(ae.$$.fragment),fs=i(),we=a("p"),we.innerHTML=Xs,us=i(),_e=a("p"),_e.innerHTML=Fs,gs=i(),M($.$$.fragment),Ke=i(),G=a("h2"),N=a("a"),Re=a("span"),M(oe.$$.fragment),Ms=i(),Te=a("span"),Te.textContent=Ss,Oe=i(),V=a("div"),M(re.$$.fragment),ys=i(),be=a("p"),be.textContent=Ys,vs=i(),E=a("div"),M(le.$$.fragment),ws=i(),je=a("p"),je.textContent=Qs,es=i(),k=a("h2"),X=a("a"),Ae=a("span"),M(ie.$$.fragment),_s=i(),Je=a("span"),Je.textContent=Ps,ss=i(),Z=a("div"),M(ce.$$.fragment),Ts=i(),Ue=a("p"),Ue.innerHTML=Ls,bs=i(),I=a("div"),M(de.$$.fragment),js=i(),Ie=a("p"),Ie.innerHTML=Hs,Js=i(),M(F.$$.fragment),Us=i(),M(S.$$.fragment),ts=i(),z=a("h2"),Y=a("a"),$e=a("span"),M(pe.$$.fragment),Is=i(),Ce=a("span"),Ce.textContent=Ds,ns=i(),B=a("div"),M(me.$$.fragment),Cs=i(),Ve=a("p"),Ve.innerHTML=qs,Vs=i(),C=a("div"),M(he.$$.fragment),Zs=i(),Ze=a("p"),Ze.innerHTML=Ks,Bs=i(),M(Q.$$.fragment),Ws=i(),M(P.$$.fragment),as=i(),Ne=a("p"),this.h()},l(e){const l=ht("svelte-1phssyn",document.head);r=o(l,"META",{name:!0,content:!0}),l.forEach(s),b=c(e),m=o(e,"P",{}),f(m).forEach(s),h=c(e),u=o(e,"H1",{class:!0});var fe=f(u);t=o(fe,"A",{id:!0,class:!0,href:!0});var Ee=f(t);j=o(Ee,"SPAN",{});var Xe=f(j);y(q.$$.fragment,Xe),Xe.forEach(s),Ee.forEach(s),ps=c(fe),Me=o(fe,"SPAN",{"data-svelte-h":!0}),g(Me)!=="svelte-14sr4u6"&&(Me.textContent=ks),fe.forEach(s),Ye=c(e),W=o(e,"H2",{class:!0});var ue=f(W);R=o(ue,"A",{id:!0,class:!0,href:!0});var Fe=f(R);ke=o(Fe,"SPAN",{});var Os=f(ke);y(K.$$.fragment,Os),Os.forEach(s),Fe.forEach(s),ms=c(ue),ye=o(ue,"SPAN",{"data-svelte-h":!0}),g(ye)!=="svelte-1jsw1pg"&&(ye.textContent=zs),ue.forEach(s),Qe=c(e),O=o(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-1dq9qfe"&&(O.innerHTML=Rs),Pe=c(e),ee=o(e,"P",{"data-svelte-h":!0}),g(ee)!=="svelte-vfdo9a"&&(ee.textContent=As),Le=c(e),se=o(e,"P",{"data-svelte-h":!0}),g(se)!=="svelte-1lz2sl9"&&(se.innerHTML=$s),He=c(e),te=o(e,"P",{"data-svelte-h":!0}),g(te)!=="svelte-jnd3xg"&&(te.innerHTML=Ns),De=c(e),x=o(e,"H2",{class:!0});var rs=f(x);A=o(rs,"A",{id:!0,class:!0,href:!0});var et=f(A);ze=o(et,"SPAN",{});var st=f(ze);y(ne.$$.fragment,st),st.forEach(s),et.forEach(s),hs=c(rs),ve=o(rs,"SPAN",{"data-svelte-h":!0}),g(ve)!=="svelte-pwomi5"&&(ve.textContent=Es),rs.forEach(s),qe=c(e),J=o(e,"DIV",{class:!0});var L=f(J);y(ae.$$.fragment,L),fs=c(L),we=o(L,"P",{"data-svelte-h":!0}),g(we)!=="svelte-1mqmnup"&&(we.innerHTML=Xs),us=c(L),_e=o(L,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-10kqkkl"&&(_e.innerHTML=Fs),gs=c(L),y($.$$.fragment,L),L.forEach(s),Ke=c(e),G=o(e,"H2",{class:!0});var ls=f(G);N=o(ls,"A",{id:!0,class:!0,href:!0});var tt=f(N);Re=o(tt,"SPAN",{});var nt=f(Re);y(oe.$$.fragment,nt),nt.forEach(s),tt.forEach(s),Ms=c(ls),Te=o(ls,"SPAN",{"data-svelte-h":!0}),g(Te)!=="svelte-zgqh5o"&&(Te.textContent=Ss),ls.forEach(s),Oe=c(e),V=o(e,"DIV",{class:!0});var Be=f(V);y(re.$$.fragment,Be),ys=c(Be),be=o(Be,"P",{"data-svelte-h":!0}),g(be)!=="svelte-imia5q"&&(be.textContent=Ys),vs=c(Be),E=o(Be,"DIV",{class:!0});var is=f(E);y(le.$$.fragment,is),ws=c(is),je=o(is,"P",{"data-svelte-h":!0}),g(je)!=="svelte-1x3yxsa"&&(je.textContent=Qs),is.forEach(s),Be.forEach(s),es=c(e),k=o(e,"H2",{class:!0});var cs=f(k);X=o(cs,"A",{id:!0,class:!0,href:!0});var at=f(X);Ae=o(at,"SPAN",{});var ot=f(Ae);y(ie.$$.fragment,ot),ot.forEach(s),at.forEach(s),_s=c(cs),Je=o(cs,"SPAN",{"data-svelte-h":!0}),g(Je)!=="svelte-uo83nq"&&(Je.textContent=Ps),cs.forEach(s),ss=c(e),Z=o(e,"DIV",{class:!0});var We=f(Z);y(ce.$$.fragment,We),Ts=c(We),Ue=o(We,"P",{"data-svelte-h":!0}),g(Ue)!=="svelte-6a15m9"&&(Ue.innerHTML=Ls),bs=c(We),I=o(We,"DIV",{class:!0});var H=f(I);y(de.$$.fragment,H),js=c(H),Ie=o(H,"P",{"data-svelte-h":!0}),g(Ie)!=="svelte-1dd50lf"&&(Ie.innerHTML=Hs),Js=c(H),y(F.$$.fragment,H),Us=c(H),y(S.$$.fragment,H),H.forEach(s),We.forEach(s),ts=c(e),z=o(e,"H2",{class:!0});var ds=f(z);Y=o(ds,"A",{id:!0,class:!0,href:!0});var rt=f(Y);$e=o(rt,"SPAN",{});var lt=f($e);y(pe.$$.fragment,lt),lt.forEach(s),rt.forEach(s),Is=c(ds),Ce=o(ds,"SPAN",{"data-svelte-h":!0}),g(Ce)!=="svelte-1ynx8dl"&&(Ce.textContent=Ds),ds.forEach(s),ns=c(e),B=o(e,"DIV",{class:!0});var xe=f(B);y(me.$$.fragment,xe),Cs=c(xe),Ve=o(xe,"P",{"data-svelte-h":!0}),g(Ve)!=="svelte-1u6snus"&&(Ve.innerHTML=qs),Vs=c(xe),C=o(xe,"DIV",{class:!0});var D=f(C);y(he.$$.fragment,D),Zs=c(D),Ze=o(D,"P",{"data-svelte-h":!0}),g(Ze)!=="svelte-997bex"&&(Ze.innerHTML=Ks),Bs=c(D),y(Q.$$.fragment,D),Ws=c(D),y(P.$$.fragment,D),D.forEach(s),xe.forEach(s),as=c(e),Ne=o(e,"P",{}),f(Ne).forEach(s),this.h()},h(){p(r,"name","hf:doc:metadata"),p(r,"content",JSON.stringify(wt)),p(t,"id","video-vision-transformer-vivit"),p(t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(t,"href","#video-vision-transformer-vivit"),p(u,"class","relative group"),p(R,"id","overview"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#overview"),p(W,"class","relative group"),p(A,"id","transformers.VivitConfig"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#transformers.VivitConfig"),p(x,"class","relative group"),p(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(N,"id","transformers.VivitImageProcessor"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#transformers.VivitImageProcessor"),p(G,"class","relative group"),p(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(X,"id","transformers.VivitModel"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#transformers.VivitModel"),p(k,"class","relative group"),p(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(Y,"id","transformers.VivitForVideoClassification"),p(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Y,"href","#transformers.VivitForVideoClassification"),p(z,"class","relative group"),p(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){n(document.head,r),d(e,b,l),d(e,m,l),d(e,h,l),d(e,u,l),n(u,t),n(t,j),v(q,j,null),n(u,ps),n(u,Me),d(e,Ye,l),d(e,W,l),n(W,R),n(R,ke),v(K,ke,null),n(W,ms),n(W,ye),d(e,Qe,l),d(e,O,l),d(e,Pe,l),d(e,ee,l),d(e,Le,l),d(e,se,l),d(e,He,l),d(e,te,l),d(e,De,l),d(e,x,l),n(x,A),n(A,ze),v(ne,ze,null),n(x,hs),n(x,ve),d(e,qe,l),d(e,J,l),v(ae,J,null),n(J,fs),n(J,we),n(J,us),n(J,_e),n(J,gs),v($,J,null),d(e,Ke,l),d(e,G,l),n(G,N),n(N,Re),v(oe,Re,null),n(G,Ms),n(G,Te),d(e,Oe,l),d(e,V,l),v(re,V,null),n(V,ys),n(V,be),n(V,vs),n(V,E),v(le,E,null),n(E,ws),n(E,je),d(e,es,l),d(e,k,l),n(k,X),n(X,Ae),v(ie,Ae,null),n(k,_s),n(k,Je),d(e,ss,l),d(e,Z,l),v(ce,Z,null),n(Z,Ts),n(Z,Ue),n(Z,bs),n(Z,I),v(de,I,null),n(I,js),n(I,Ie),n(I,Js),v(F,I,null),n(I,Us),v(S,I,null),d(e,ts,l),d(e,z,l),n(z,Y),n(Y,$e),v(pe,$e,null),n(z,Is),n(z,Ce),d(e,ns,l),d(e,B,l),v(me,B,null),n(B,Cs),n(B,Ve),n(B,Vs),n(B,C),v(he,C,null),n(C,Zs),n(C,Ze),n(C,Bs),v(Q,C,null),n(C,Ws),v(P,C,null),d(e,as,l),d(e,Ne,l),os=!0},p(e,[l]){const fe={};l&2&&(fe.$$scope={dirty:l,ctx:e}),$.$set(fe);const Ee={};l&2&&(Ee.$$scope={dirty:l,ctx:e}),F.$set(Ee);const Xe={};l&2&&(Xe.$$scope={dirty:l,ctx:e}),S.$set(Xe);const ue={};l&2&&(ue.$$scope={dirty:l,ctx:e}),Q.$set(ue);const Fe={};l&2&&(Fe.$$scope={dirty:l,ctx:e}),P.$set(Fe)},i(e){os||(w(q.$$.fragment,e),w(K.$$.fragment,e),w(ne.$$.fragment,e),w(ae.$$.fragment,e),w($.$$.fragment,e),w(oe.$$.fragment,e),w(re.$$.fragment,e),w(le.$$.fragment,e),w(ie.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(F.$$.fragment,e),w(S.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(he.$$.fragment,e),w(Q.$$.fragment,e),w(P.$$.fragment,e),os=!0)},o(e){_(q.$$.fragment,e),_(K.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),_($.$$.fragment,e),_(oe.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(ie.$$.fragment,e),_(ce.$$.fragment,e),_(de.$$.fragment,e),_(F.$$.fragment,e),_(S.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(Q.$$.fragment,e),_(P.$$.fragment,e),os=!1},d(e){e&&(s(b),s(m),s(h),s(u),s(Ye),s(W),s(Qe),s(O),s(Pe),s(ee),s(Le),s(se),s(He),s(te),s(De),s(x),s(qe),s(J),s(Ke),s(G),s(Oe),s(V),s(es),s(k),s(ss),s(Z),s(ts),s(z),s(ns),s(B),s(as),s(Ne)),s(r),T(q),T(K),T(ne),T(ae),T($),T(oe),T(re),T(le),T(ie),T(ce),T(de),T(F),T(S),T(pe),T(me),T(he),T(Q),T(P)}}}const wt={local:"video-vision-transformer-vivit",sections:[{local:"overview",title:"Overview"},{local:"transformers.VivitConfig",title:"VivitConfig"},{local:"transformers.VivitImageProcessor",title:"VivitImageProcessor"},{local:"transformers.VivitModel",title:"VivitModel"},{local:"transformers.VivitForVideoClassification",title:"VivitForVideoClassification"}],title:"Video Vision Transformer (ViViT)"};function _t(U){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends pt{constructor(r){super(),mt(this,r,_t,vt,ct,{})}}export{Vt as component};
