import{s as Ss,f as Zs,o as qs,n as Yo}from"../chunks/scheduler.9bc65507.js";import{S as Hs,i as As,g as s,s as r,u,A as Vs,h as n,f as o,c as i,j as p,v as _,y as h,k as d,o as t,a as l,w as b,d as y,t as v,x as w}from"../chunks/index.78c82d43.js";import{T as Ws}from"../chunks/Tip.87d55b76.js";import{D as I}from"../chunks/Docstring.4e7352e2.js";import{C as Gt}from"../chunks/CodeBlock.73e038be.js";import{I as pe}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Vt}from"../chunks/ExampleCodeBlock.872b014d.js";import{P as Gs}from"../chunks/PipelineTag.75b0f707.js";function Bs(U){let m,T="Example:",f,g,x;return g=new Gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFlvbG9zQ29uZmlnJTJDJTIwWW9sb3NNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBZT0xPUyUyMGh1c3R2bCUyRnlvbG9zLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwWW9sb3NDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaHVzdHZsJTJGeW9sb3MtYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> YolosConfig, YolosModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a YOLOS hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = YolosConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m=s("p"),m.textContent=T,f=r(),u(g.$$.fragment)},l(c){m=n(c,"P",{"data-svelte-h":!0}),h(m)!=="svelte-11lpom8"&&(m.textContent=T),f=i(c),_(g.$$.fragment,c)},m(c,$){l(c,m,$),l(c,f,$),b(g,c,$),x=!0},p:Yo,i(c){x||(y(g.$$.fragment,c),x=!0)},o(c){v(g.$$.fragment,c),x=!1},d(c){c&&(o(m),o(f)),w(g,c)}}}function Qs(U){let m,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=s("p"),m.innerHTML=T},l(f){m=n(f,"P",{"data-svelte-h":!0}),h(m)!=="svelte-fincs2"&&(m.innerHTML=T)},m(f,g){l(f,m,g)},p:Yo,d(f){f&&o(m)}}}function Xs(U){let m,T="Example:",f,g,x;return g=new Gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFlvbG9zTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyaHVzdHZsJTJGeW9sb3Mtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, YolosModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3401</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){m=s("p"),m.textContent=T,f=r(),u(g.$$.fragment)},l(c){m=n(c,"P",{"data-svelte-h":!0}),h(m)!=="svelte-11lpom8"&&(m.textContent=T),f=i(c),_(g.$$.fragment,c)},m(c,$){l(c,m,$),l(c,f,$),b(g,c,$),x=!0},p:Yo,i(c){x||(y(g.$$.fragment,c),x=!0)},o(c){v(g.$$.fragment,c),x=!1},d(c){c&&(o(m),o(f)),w(g,c)}}}function Ks(U){let m,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){m=s("p"),m.innerHTML=T},l(f){m=n(f,"P",{"data-svelte-h":!0}),h(m)!=="svelte-fincs2"&&(m.innerHTML=T)},m(f,g){l(f,m,g)},p:Yo,d(f){f&&o(m)}}}function en(U){let m,T="Examples:",f,g,x;return g=new Gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMENPQ08lMjBBUEklMEF0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQXJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuOSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIlMEElMjAlMjAlMjAlMjAwJTBBJTVEJTBBJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.994</span> at location [<span class="hljs-number">46.96</span>, <span class="hljs-number">72.61</span>, <span class="hljs-number">181.02</span>, <span class="hljs-number">119.73</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.975</span> at location [<span class="hljs-number">340.66</span>, <span class="hljs-number">79.19</span>, <span class="hljs-number">372.59</span>, <span class="hljs-number">192.65</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.984</span> at location [<span class="hljs-number">12.27</span>, <span class="hljs-number">54.25</span>, <span class="hljs-number">319.42</span>, <span class="hljs-number">470.99</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.922</span> at location [<span class="hljs-number">41.66</span>, <span class="hljs-number">71.96</span>, <span class="hljs-number">178.7</span>, <span class="hljs-number">120.33</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.914</span> at location [<span class="hljs-number">342.34</span>, <span class="hljs-number">21.48</span>, <span class="hljs-number">638.64</span>, <span class="hljs-number">372.46</span>]`,wrap:!1}}),{c(){m=s("p"),m.textContent=T,f=r(),u(g.$$.fragment)},l(c){m=n(c,"P",{"data-svelte-h":!0}),h(m)!=="svelte-kvfsh7"&&(m.textContent=T),f=i(c),_(g.$$.fragment,c)},m(c,$){l(c,m,$),l(c,f,$),b(g,c,$),x=!0},p:Yo,i(c){x||(y(g.$$.fragment,c),x=!0)},o(c){v(g.$$.fragment,c),x=!1},d(c){c&&(o(m),o(f)),w(g,c)}}}function on(U){let m,T,f,g,x,c,$,he,ht,Ae,Bt="YOLOS",Io,N,W,_o,fe,ft,Ve,Qt="Overview",Uo,ge,Xt=`The YOLOS model was proposed in <a href="https://arxiv.org/abs/2106.00666" rel="nofollow">You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection</a> by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.
YOLOS proposes to just leverage the plain <a href="vit">Vision Transformer (ViT)</a> for object detection, inspired by DETR. It turns out that a base-sized encoder-only Transformer can also achieve 42 AP on COCO, similar to DETR and much more complex frameworks such as Faster R-CNN.`,ko,ue,Kt="The abstract from the paper is the following:",zo,_e,es="<em>Can Transformer perform 2D object- and region-level recognition from a pure sequence-to-sequence perspective with minimal knowledge about the 2D spatial structure? To answer this question, we present You Only Look at One Sequence (YOLOS), a series of object detection models based on the vanilla Vision Transformer with the fewest possible modifications, region priors, as well as inductive biases of the target task. We find that YOLOS pre-trained on the mid-sized ImageNet-1k dataset only can already achieve quite competitive performance on the challenging COCO object detection benchmark, e.g., YOLOS-Base directly adopted from BERT-Base architecture can obtain 42.0 box AP on COCO val. We also discuss the impacts as well as limitations of current pre-train schemes and model scaling strategies for Transformer in vision through YOLOS.</em>",Jo,be,os="Tips:",Po,ye,ts='<li>One can use <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> for preparing images (and optional targets) for the model. Contrary to <a href="detr">DETR</a>, YOLOS doesn’t require a <code>pixel_mask</code> to be created.</li>',No,S,ss,Fo,ve,ns='YOLOS architecture. Taken from the <a href="https://arxiv.org/abs/2106.00666">original paper</a>.',Lo,we,as='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/hustvl/YOLOS" rel="nofollow">here</a>.',Eo,F,Z,bo,xe,gt,Ge,rs="Resources",Do,Te,is="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with YOLOS.",Oo,$e,Ro,Me,ls='<li>All example notebooks illustrating inference + fine-tuning <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> on a custom dataset can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/YOLOS" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',Wo,Ce,cs="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",So,L,q,yo,je,ut,Be,ds="YolosConfig",Zo,C,Ye,_t,Qe,ms=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosModel">YolosModel</a>. It is used to instantiate a YOLOS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the YOLOS
<a href="https://huggingface.co/hustvl/yolos-base" rel="nofollow">hustvl/yolos-base</a> architecture.`,bt,Xe,ps=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,yt,H,qo,E,A,vo,Ie,vt,Ke,hs="YolosImageProcessor",Ho,M,Ue,wt,eo,fs="Constructs a Detr image processor.",xt,V,ke,Tt,oo,gs="Preprocess an image or a batch of images so that it can be used by the model.",$t,G,ze,Mt,to,us=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Ct,B,Je,jt,so,_s=`Converts the raw output of <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Ao,D,Q,wo,Pe,Yt,no,bs="YolosFeatureExtractor",Vo,j,Ne,It,X,Fe,Ut,ao,ys="Preprocess an image or a batch of images.",kt,K,Le,zt,ro,vs=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Jt,ee,Ee,Pt,io,ws=`Converts the raw output of <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Go,O,oe,xo,De,Nt,lo,xs="YolosModel",Bo,J,Oe,Ft,co,Ts=`The bare YOLOS Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Lt,k,Re,Et,mo,$s='The <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> forward method, overrides the <code>__call__</code> special method.',Dt,te,Ot,se,Qo,R,ne,To,We,Rt,po,Ms="YolosForObjectDetection",Xo,Y,Se,Wt,ho,Cs="YOLOS Model (consisting of a ViT encoder) with object detection heads on top, for tasks such as COCO detection.",St,fo,js=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Zt,z,Ze,qt,go,Ys='The <a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Ht,ae,At,re,Ko,$o,et;return he=new pe({}),fe=new pe({}),xe=new pe({}),$e=new Gs({props:{pipeline:"object-detection"}}),je=new pe({}),Ye=new I({props:{name:"class transformers.YolosConfig",anchor:"transformers.YolosConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = [512, 864]"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"num_detection_tokens",val:" = 100"},{name:"use_mid_position_embeddings",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.YolosConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.YolosConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.YolosConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.YolosConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.YolosConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.YolosConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.YolosConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.YolosConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.YolosConfig.image_size",description:`<strong>image_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[512, 864]</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.YolosConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.YolosConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3</code>) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.YolosConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.YolosConfig.num_detection_tokens",description:`<strong>num_detection_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to <code>100</code>) &#x2014;
The number of detection tokens.`,name:"num_detection_tokens"},{anchor:"transformers.YolosConfig.use_mid_position_embeddings",description:`<strong>use_mid_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the mid-layer position encodings.`,name:"use_mid_position_embeddings"},{anchor:"transformers.YolosConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.YolosConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.YolosConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.YolosConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.YolosConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.YolosConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.YolosConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/configuration_yolos.py#L35"}}),H=new Vt({props:{anchor:"transformers.YolosConfig.example",$$slots:{default:[Bs]},$$scope:{ctx:U}}}),Ie=new pe({}),Ue=new I({props:{name:"class transformers.YolosImageProcessor",anchor:"transformers.YolosImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.yolos.image_processing_yolos.AnnotionFormat] = <AnnotionFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s (height, width) dimensions after resizing. Can be overridden by the <code>size</code> parameter in
the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.YolosImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image to the largest image in a batch and create a pixel mask. Can be
overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/image_processing_yolos.py#L673"}}),ke=new I({props:{name:"preprocess",anchor:"transformers.YolosImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.yolos.image_processing_yolos.AnnotionFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.YolosImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotionation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotionation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.YolosImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.YolosImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.YolosImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotionFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.YolosImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>, defaults to self.data_format) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/image_processing_yolos.py#L1011"}}),ze=new I({props:{name:"pad",anchor:"transformers.YolosImageProcessor.pad",parameters:[{name:"images",val:": typing.List[numpy.ndarray]"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosImageProcessor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosImageProcessor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/image_processing_yolos.py#L956"}}),Je=new I({props:{name:"post_process_object_detection",anchor:"transformers.YolosImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/image_processing_yolos.py#L1294",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Pe=new pe({}),Ne=new I({props:{name:"class transformers.YolosFeatureExtractor",anchor:"transformers.YolosFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/feature_extraction_yolos.py#L26"}}),Fe=new I({props:{name:"__call__",anchor:"transformers.YolosFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/image_processing_utils.py#L544"}}),Le=new I({props:{name:"pad",anchor:"transformers.YolosFeatureExtractor.pad",parameters:[{name:"images",val:": typing.List[numpy.ndarray]"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosFeatureExtractor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosFeatureExtractor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosFeatureExtractor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosFeatureExtractor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/image_processing_yolos.py#L956"}}),Ee=new I({props:{name:"post_process_object_detection",anchor:"transformers.YolosFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/image_processing_yolos.py#L1294",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),De=new pe({}),Oe=new I({props:{name:"class transformers.YolosModel",anchor:"transformers.YolosModel",parameters:[{name:"config",val:": YolosConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/modeling_yolos.py#L597"}}),Re=new I({props:{name:"forward",anchor:"transformers.YolosModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.YolosModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/modeling_yolos.py#L625",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),te=new Ws({props:{$$slots:{default:[Qs]},$$scope:{ctx:U}}}),se=new Vt({props:{anchor:"transformers.YolosModel.forward.example",$$slots:{default:[Xs]},$$scope:{ctx:U}}}),We=new pe({}),Se=new I({props:{name:"class transformers.YolosForObjectDetection",anchor:"transformers.YolosForObjectDetection",parameters:[{name:"config",val:": YolosConfig"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/modeling_yolos.py#L705"}}),Ze=new I({props:{name:"forward",anchor:"transformers.YolosForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosForObjectDetection.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.YolosForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: <code>&apos;class_labels&apos;</code> and <code>&apos;boxes&apos;</code> (the class labels and bounding boxes of an image in the
batch respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/yolos/modeling_yolos.py#L732",returnDescription:`
<p>A <code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>post_process()</code> to retrieve the unnormalized bounding
boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of
the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`
<p><code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ae=new Ws({props:{$$slots:{default:[Ks]},$$scope:{ctx:U}}}),re=new Vt({props:{anchor:"transformers.YolosForObjectDetection.forward.example",$$slots:{default:[en]},$$scope:{ctx:U}}}),{c(){m=s("meta"),T=r(),f=s("p"),g=r(),x=s("h1"),c=s("a"),$=s("span"),u(he.$$.fragment),ht=r(),Ae=s("span"),Ae.textContent=Bt,Io=r(),N=s("h2"),W=s("a"),_o=s("span"),u(fe.$$.fragment),ft=r(),Ve=s("span"),Ve.textContent=Qt,Uo=r(),ge=s("p"),ge.innerHTML=Xt,ko=r(),ue=s("p"),ue.textContent=Kt,zo=r(),_e=s("p"),_e.innerHTML=es,Jo=r(),be=s("p"),be.textContent=os,Po=r(),ye=s("ul"),ye.innerHTML=ts,No=r(),S=s("img"),Fo=r(),ve=s("small"),ve.innerHTML=ns,Lo=r(),we=s("p"),we.innerHTML=as,Eo=r(),F=s("h2"),Z=s("a"),bo=s("span"),u(xe.$$.fragment),gt=r(),Ge=s("span"),Ge.textContent=rs,Do=r(),Te=s("p"),Te.textContent=is,Oo=r(),u($e.$$.fragment),Ro=r(),Me=s("ul"),Me.innerHTML=ls,Wo=r(),Ce=s("p"),Ce.textContent=cs,So=r(),L=s("h2"),q=s("a"),yo=s("span"),u(je.$$.fragment),ut=r(),Be=s("span"),Be.textContent=ds,Zo=r(),C=s("div"),u(Ye.$$.fragment),_t=r(),Qe=s("p"),Qe.innerHTML=ms,bt=r(),Xe=s("p"),Xe.innerHTML=ps,yt=r(),u(H.$$.fragment),qo=r(),E=s("h2"),A=s("a"),vo=s("span"),u(Ie.$$.fragment),vt=r(),Ke=s("span"),Ke.textContent=hs,Ho=r(),M=s("div"),u(Ue.$$.fragment),wt=r(),eo=s("p"),eo.textContent=fs,xt=r(),V=s("div"),u(ke.$$.fragment),Tt=r(),oo=s("p"),oo.textContent=gs,$t=r(),G=s("div"),u(ze.$$.fragment),Mt=r(),to=s("p"),to.textContent=us,Ct=r(),B=s("div"),u(Je.$$.fragment),jt=r(),so=s("p"),so.innerHTML=_s,Ao=r(),D=s("h2"),Q=s("a"),wo=s("span"),u(Pe.$$.fragment),Yt=r(),no=s("span"),no.textContent=bs,Vo=r(),j=s("div"),u(Ne.$$.fragment),It=r(),X=s("div"),u(Fe.$$.fragment),Ut=r(),ao=s("p"),ao.textContent=ys,kt=r(),K=s("div"),u(Le.$$.fragment),zt=r(),ro=s("p"),ro.textContent=vs,Jt=r(),ee=s("div"),u(Ee.$$.fragment),Pt=r(),io=s("p"),io.innerHTML=ws,Go=r(),O=s("h2"),oe=s("a"),xo=s("span"),u(De.$$.fragment),Nt=r(),lo=s("span"),lo.textContent=xs,Bo=r(),J=s("div"),u(Oe.$$.fragment),Ft=r(),co=s("p"),co.innerHTML=Ts,Lt=r(),k=s("div"),u(Re.$$.fragment),Et=r(),mo=s("p"),mo.innerHTML=$s,Dt=r(),u(te.$$.fragment),Ot=r(),u(se.$$.fragment),Qo=r(),R=s("h2"),ne=s("a"),To=s("span"),u(We.$$.fragment),Rt=r(),po=s("span"),po.textContent=Ms,Xo=r(),Y=s("div"),u(Se.$$.fragment),Wt=r(),ho=s("p"),ho.textContent=Cs,St=r(),fo=s("p"),fo.innerHTML=js,Zt=r(),z=s("div"),u(Ze.$$.fragment),qt=r(),go=s("p"),go.innerHTML=Ys,Ht=r(),u(ae.$$.fragment),At=r(),u(re.$$.fragment),Ko=r(),$o=s("p"),this.h()},l(e){const a=Vs("svelte-1phssyn",document.head);m=n(a,"META",{name:!0,content:!0}),a.forEach(o),T=i(e),f=n(e,"P",{}),p(f).forEach(o),g=i(e),x=n(e,"H1",{class:!0});var qe=p(x);c=n(qe,"A",{id:!0,class:!0,href:!0});var Mo=p(c);$=n(Mo,"SPAN",{});var Co=p($);_(he.$$.fragment,Co),Co.forEach(o),Mo.forEach(o),ht=i(qe),Ae=n(qe,"SPAN",{"data-svelte-h":!0}),h(Ae)!=="svelte-1gfpkpl"&&(Ae.textContent=Bt),qe.forEach(o),Io=i(e),N=n(e,"H2",{class:!0});var He=p(N);W=n(He,"A",{id:!0,class:!0,href:!0});var jo=p(W);_o=n(jo,"SPAN",{});var Is=p(_o);_(fe.$$.fragment,Is),Is.forEach(o),jo.forEach(o),ft=i(He),Ve=n(He,"SPAN",{"data-svelte-h":!0}),h(Ve)!=="svelte-1jsw1pg"&&(Ve.textContent=Qt),He.forEach(o),Uo=i(e),ge=n(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-98a8ak"&&(ge.innerHTML=Xt),ko=i(e),ue=n(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-vfdo9a"&&(ue.textContent=Kt),zo=i(e),_e=n(e,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-ng2z0l"&&(_e.innerHTML=es),Jo=i(e),be=n(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-axv494"&&(be.textContent=os),Po=i(e),ye=n(e,"UL",{"data-svelte-h":!0}),h(ye)!=="svelte-1xffjav"&&(ye.innerHTML=ts),No=i(e),S=n(e,"IMG",{src:!0,alt:!0,width:!0}),Fo=i(e),ve=n(e,"SMALL",{"data-svelte-h":!0}),h(ve)!=="svelte-vits75"&&(ve.innerHTML=ns),Lo=i(e),we=n(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-zgo631"&&(we.innerHTML=as),Eo=i(e),F=n(e,"H2",{class:!0});var ot=p(F);Z=n(ot,"A",{id:!0,class:!0,href:!0});var Us=p(Z);bo=n(Us,"SPAN",{});var ks=p(bo);_(xe.$$.fragment,ks),ks.forEach(o),Us.forEach(o),gt=i(ot),Ge=n(ot,"SPAN",{"data-svelte-h":!0}),h(Ge)!=="svelte-w4zzv6"&&(Ge.textContent=rs),ot.forEach(o),Do=i(e),Te=n(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-93t6s9"&&(Te.textContent=is),Oo=i(e),_($e.$$.fragment,e),Ro=i(e),Me=n(e,"UL",{"data-svelte-h":!0}),h(Me)!=="svelte-svr1d7"&&(Me.innerHTML=ls),Wo=i(e),Ce=n(e,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-1xesile"&&(Ce.textContent=cs),So=i(e),L=n(e,"H2",{class:!0});var tt=p(L);q=n(tt,"A",{id:!0,class:!0,href:!0});var zs=p(q);yo=n(zs,"SPAN",{});var Js=p(yo);_(je.$$.fragment,Js),Js.forEach(o),zs.forEach(o),ut=i(tt),Be=n(tt,"SPAN",{"data-svelte-h":!0}),h(Be)!=="svelte-18jq4zj"&&(Be.textContent=ds),tt.forEach(o),Zo=i(e),C=n(e,"DIV",{class:!0});var ie=p(C);_(Ye.$$.fragment,ie),_t=i(ie),Qe=n(ie,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-1q0e9yp"&&(Qe.innerHTML=ms),bt=i(ie),Xe=n(ie,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-10kqkkl"&&(Xe.innerHTML=ps),yt=i(ie),_(H.$$.fragment,ie),ie.forEach(o),qo=i(e),E=n(e,"H2",{class:!0});var st=p(E);A=n(st,"A",{id:!0,class:!0,href:!0});var Ps=p(A);vo=n(Ps,"SPAN",{});var Ns=p(vo);_(Ie.$$.fragment,Ns),Ns.forEach(o),Ps.forEach(o),vt=i(st),Ke=n(st,"SPAN",{"data-svelte-h":!0}),h(Ke)!=="svelte-12xr7w2"&&(Ke.textContent=hs),st.forEach(o),Ho=i(e),M=n(e,"DIV",{class:!0});var P=p(M);_(Ue.$$.fragment,P),wt=i(P),eo=n(P,"P",{"data-svelte-h":!0}),h(eo)!=="svelte-19j0nu1"&&(eo.textContent=fs),xt=i(P),V=n(P,"DIV",{class:!0});var nt=p(V);_(ke.$$.fragment,nt),Tt=i(nt),oo=n(nt,"P",{"data-svelte-h":!0}),h(oo)!=="svelte-jgz2ra"&&(oo.textContent=gs),nt.forEach(o),$t=i(P),G=n(P,"DIV",{class:!0});var at=p(G);_(ze.$$.fragment,at),Mt=i(at),to=n(at,"P",{"data-svelte-h":!0}),h(to)!=="svelte-1f2f3d6"&&(to.textContent=us),at.forEach(o),Ct=i(P),B=n(P,"DIV",{class:!0});var rt=p(B);_(Je.$$.fragment,rt),jt=i(rt),so=n(rt,"P",{"data-svelte-h":!0}),h(so)!=="svelte-z2bgt5"&&(so.innerHTML=_s),rt.forEach(o),P.forEach(o),Ao=i(e),D=n(e,"H2",{class:!0});var it=p(D);Q=n(it,"A",{id:!0,class:!0,href:!0});var Fs=p(Q);wo=n(Fs,"SPAN",{});var Ls=p(wo);_(Pe.$$.fragment,Ls),Ls.forEach(o),Fs.forEach(o),Yt=i(it),no=n(it,"SPAN",{"data-svelte-h":!0}),h(no)!=="svelte-1i2k8i3"&&(no.textContent=bs),it.forEach(o),Vo=i(e),j=n(e,"DIV",{class:!0});var le=p(j);_(Ne.$$.fragment,le),It=i(le),X=n(le,"DIV",{class:!0});var lt=p(X);_(Fe.$$.fragment,lt),Ut=i(lt),ao=n(lt,"P",{"data-svelte-h":!0}),h(ao)!=="svelte-khengj"&&(ao.textContent=ys),lt.forEach(o),kt=i(le),K=n(le,"DIV",{class:!0});var ct=p(K);_(Le.$$.fragment,ct),zt=i(ct),ro=n(ct,"P",{"data-svelte-h":!0}),h(ro)!=="svelte-1f2f3d6"&&(ro.textContent=vs),ct.forEach(o),Jt=i(le),ee=n(le,"DIV",{class:!0});var dt=p(ee);_(Ee.$$.fragment,dt),Pt=i(dt),io=n(dt,"P",{"data-svelte-h":!0}),h(io)!=="svelte-z2bgt5"&&(io.innerHTML=ws),dt.forEach(o),le.forEach(o),Go=i(e),O=n(e,"H2",{class:!0});var mt=p(O);oe=n(mt,"A",{id:!0,class:!0,href:!0});var Es=p(oe);xo=n(Es,"SPAN",{});var Ds=p(xo);_(De.$$.fragment,Ds),Ds.forEach(o),Es.forEach(o),Nt=i(mt),lo=n(mt,"SPAN",{"data-svelte-h":!0}),h(lo)!=="svelte-17ytdfk"&&(lo.textContent=xs),mt.forEach(o),Bo=i(e),J=n(e,"DIV",{class:!0});var uo=p(J);_(Oe.$$.fragment,uo),Ft=i(uo),co=n(uo,"P",{"data-svelte-h":!0}),h(co)!=="svelte-19k5mgv"&&(co.innerHTML=Ts),Lt=i(uo),k=n(uo,"DIV",{class:!0});var ce=p(k);_(Re.$$.fragment,ce),Et=i(ce),mo=n(ce,"P",{"data-svelte-h":!0}),h(mo)!=="svelte-52vbkl"&&(mo.innerHTML=$s),Dt=i(ce),_(te.$$.fragment,ce),Ot=i(ce),_(se.$$.fragment,ce),ce.forEach(o),uo.forEach(o),Qo=i(e),R=n(e,"H2",{class:!0});var pt=p(R);ne=n(pt,"A",{id:!0,class:!0,href:!0});var Os=p(ne);To=n(Os,"SPAN",{});var Rs=p(To);_(We.$$.fragment,Rs),Rs.forEach(o),Os.forEach(o),Rt=i(pt),po=n(pt,"SPAN",{"data-svelte-h":!0}),h(po)!=="svelte-nryn1e"&&(po.textContent=Ms),pt.forEach(o),Xo=i(e),Y=n(e,"DIV",{class:!0});var de=p(Y);_(Se.$$.fragment,de),Wt=i(de),ho=n(de,"P",{"data-svelte-h":!0}),h(ho)!=="svelte-1yg9bo0"&&(ho.textContent=Cs),St=i(de),fo=n(de,"P",{"data-svelte-h":!0}),h(fo)!=="svelte-1gjh92c"&&(fo.innerHTML=js),Zt=i(de),z=n(de,"DIV",{class:!0});var me=p(z);_(Ze.$$.fragment,me),qt=i(me),go=n(me,"P",{"data-svelte-h":!0}),h(go)!=="svelte-17ohyvb"&&(go.innerHTML=Ys),Ht=i(me),_(ae.$$.fragment,me),At=i(me),_(re.$$.fragment,me),me.forEach(o),de.forEach(o),Ko=i(e),$o=n(e,"P",{}),p($o).forEach(o),this.h()},h(){d(m,"name","hf:doc:metadata"),d(m,"content",JSON.stringify(tn)),d(c,"id","yolos"),d(c,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(c,"href","#yolos"),d(x,"class","relative group"),d(W,"id","overview"),d(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(W,"href","#overview"),d(N,"class","relative group"),Zs(S.src,ss="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/yolos_architecture.png")||d(S,"src",ss),d(S,"alt","drawing"),d(S,"width","600"),d(Z,"id","resources"),d(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Z,"href","#resources"),d(F,"class","relative group"),d(q,"id","transformers.YolosConfig"),d(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(q,"href","#transformers.YolosConfig"),d(L,"class","relative group"),d(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(A,"id","transformers.YolosImageProcessor"),d(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(A,"href","#transformers.YolosImageProcessor"),d(E,"class","relative group"),d(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Q,"id","transformers.YolosFeatureExtractor"),d(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Q,"href","#transformers.YolosFeatureExtractor"),d(D,"class","relative group"),d(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(oe,"id","transformers.YolosModel"),d(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(oe,"href","#transformers.YolosModel"),d(O,"class","relative group"),d(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ne,"id","transformers.YolosForObjectDetection"),d(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ne,"href","#transformers.YolosForObjectDetection"),d(R,"class","relative group"),d(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,m),l(e,T,a),l(e,f,a),l(e,g,a),l(e,x,a),t(x,c),t(c,$),b(he,$,null),t(x,ht),t(x,Ae),l(e,Io,a),l(e,N,a),t(N,W),t(W,_o),b(fe,_o,null),t(N,ft),t(N,Ve),l(e,Uo,a),l(e,ge,a),l(e,ko,a),l(e,ue,a),l(e,zo,a),l(e,_e,a),l(e,Jo,a),l(e,be,a),l(e,Po,a),l(e,ye,a),l(e,No,a),l(e,S,a),l(e,Fo,a),l(e,ve,a),l(e,Lo,a),l(e,we,a),l(e,Eo,a),l(e,F,a),t(F,Z),t(Z,bo),b(xe,bo,null),t(F,gt),t(F,Ge),l(e,Do,a),l(e,Te,a),l(e,Oo,a),b($e,e,a),l(e,Ro,a),l(e,Me,a),l(e,Wo,a),l(e,Ce,a),l(e,So,a),l(e,L,a),t(L,q),t(q,yo),b(je,yo,null),t(L,ut),t(L,Be),l(e,Zo,a),l(e,C,a),b(Ye,C,null),t(C,_t),t(C,Qe),t(C,bt),t(C,Xe),t(C,yt),b(H,C,null),l(e,qo,a),l(e,E,a),t(E,A),t(A,vo),b(Ie,vo,null),t(E,vt),t(E,Ke),l(e,Ho,a),l(e,M,a),b(Ue,M,null),t(M,wt),t(M,eo),t(M,xt),t(M,V),b(ke,V,null),t(V,Tt),t(V,oo),t(M,$t),t(M,G),b(ze,G,null),t(G,Mt),t(G,to),t(M,Ct),t(M,B),b(Je,B,null),t(B,jt),t(B,so),l(e,Ao,a),l(e,D,a),t(D,Q),t(Q,wo),b(Pe,wo,null),t(D,Yt),t(D,no),l(e,Vo,a),l(e,j,a),b(Ne,j,null),t(j,It),t(j,X),b(Fe,X,null),t(X,Ut),t(X,ao),t(j,kt),t(j,K),b(Le,K,null),t(K,zt),t(K,ro),t(j,Jt),t(j,ee),b(Ee,ee,null),t(ee,Pt),t(ee,io),l(e,Go,a),l(e,O,a),t(O,oe),t(oe,xo),b(De,xo,null),t(O,Nt),t(O,lo),l(e,Bo,a),l(e,J,a),b(Oe,J,null),t(J,Ft),t(J,co),t(J,Lt),t(J,k),b(Re,k,null),t(k,Et),t(k,mo),t(k,Dt),b(te,k,null),t(k,Ot),b(se,k,null),l(e,Qo,a),l(e,R,a),t(R,ne),t(ne,To),b(We,To,null),t(R,Rt),t(R,po),l(e,Xo,a),l(e,Y,a),b(Se,Y,null),t(Y,Wt),t(Y,ho),t(Y,St),t(Y,fo),t(Y,Zt),t(Y,z),b(Ze,z,null),t(z,qt),t(z,go),t(z,Ht),b(ae,z,null),t(z,At),b(re,z,null),l(e,Ko,a),l(e,$o,a),et=!0},p(e,[a]){const qe={};a&2&&(qe.$$scope={dirty:a,ctx:e}),H.$set(qe);const Mo={};a&2&&(Mo.$$scope={dirty:a,ctx:e}),te.$set(Mo);const Co={};a&2&&(Co.$$scope={dirty:a,ctx:e}),se.$set(Co);const He={};a&2&&(He.$$scope={dirty:a,ctx:e}),ae.$set(He);const jo={};a&2&&(jo.$$scope={dirty:a,ctx:e}),re.$set(jo)},i(e){et||(y(he.$$.fragment,e),y(fe.$$.fragment,e),y(xe.$$.fragment,e),y($e.$$.fragment,e),y(je.$$.fragment,e),y(Ye.$$.fragment,e),y(H.$$.fragment,e),y(Ie.$$.fragment,e),y(Ue.$$.fragment,e),y(ke.$$.fragment,e),y(ze.$$.fragment,e),y(Je.$$.fragment,e),y(Pe.$$.fragment,e),y(Ne.$$.fragment,e),y(Fe.$$.fragment,e),y(Le.$$.fragment,e),y(Ee.$$.fragment,e),y(De.$$.fragment,e),y(Oe.$$.fragment,e),y(Re.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(We.$$.fragment,e),y(Se.$$.fragment,e),y(Ze.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),et=!0)},o(e){v(he.$$.fragment,e),v(fe.$$.fragment,e),v(xe.$$.fragment,e),v($e.$$.fragment,e),v(je.$$.fragment,e),v(Ye.$$.fragment,e),v(H.$$.fragment,e),v(Ie.$$.fragment,e),v(Ue.$$.fragment,e),v(ke.$$.fragment,e),v(ze.$$.fragment,e),v(Je.$$.fragment,e),v(Pe.$$.fragment,e),v(Ne.$$.fragment,e),v(Fe.$$.fragment,e),v(Le.$$.fragment,e),v(Ee.$$.fragment,e),v(De.$$.fragment,e),v(Oe.$$.fragment,e),v(Re.$$.fragment,e),v(te.$$.fragment,e),v(se.$$.fragment,e),v(We.$$.fragment,e),v(Se.$$.fragment,e),v(Ze.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),et=!1},d(e){e&&(o(T),o(f),o(g),o(x),o(Io),o(N),o(Uo),o(ge),o(ko),o(ue),o(zo),o(_e),o(Jo),o(be),o(Po),o(ye),o(No),o(S),o(Fo),o(ve),o(Lo),o(we),o(Eo),o(F),o(Do),o(Te),o(Oo),o(Ro),o(Me),o(Wo),o(Ce),o(So),o(L),o(Zo),o(C),o(qo),o(E),o(Ho),o(M),o(Ao),o(D),o(Vo),o(j),o(Go),o(O),o(Bo),o(J),o(Qo),o(R),o(Xo),o(Y),o(Ko),o($o)),o(m),w(he),w(fe),w(xe),w($e,e),w(je),w(Ye),w(H),w(Ie),w(Ue),w(ke),w(ze),w(Je),w(Pe),w(Ne),w(Fe),w(Le),w(Ee),w(De),w(Oe),w(Re),w(te),w(se),w(We),w(Se),w(Ze),w(ae),w(re)}}}const tn={local:"yolos",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.YolosConfig",title:"YolosConfig"},{local:"transformers.YolosImageProcessor",title:"YolosImageProcessor"},{local:"transformers.YolosFeatureExtractor",title:"YolosFeatureExtractor"},{local:"transformers.YolosModel",title:"YolosModel"},{local:"transformers.YolosForObjectDetection",title:"YolosForObjectDetection"}],title:"YOLOS"};function sn(U){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hn extends Hs{constructor(m){super(),As(this,m,sn,on,Ss,{})}}export{hn as component};
