import{s as Mn,n as bn,o as yn}from"../chunks/scheduler.9bc65507.js";import{S as vn,i as Jn,g as a,s as i,u as h,A as Tn,h as s,f as t,c as o,j as u,v as g,y as r,k as m,o as p,a as n,w as d,d as c,t as f,x as M}from"../chunks/index.78c82d43.js";import{I as W}from"../chunks/IconCopyLink.bedaa44d.js";import{C as b}from"../chunks/CodeBlock.73e038be.js";import{D as wn}from"../chunks/DocNotebookDropdown.31840a23.js";function Un(dl){let y,Ke,He,Oe,v,_,Ne,R,il,Ee,cl="Multilingual models for inference",et,L,tt,V,fl='There are several multilingual models in 🤗 Transformers, and their inference usage differs from monolingual models. Not <em>all</em> multilingual model usage is different though. Some models, like <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>, can be used just like a monolingual model. This guide will show you how to use multilingual models whose usage differs for inference.',lt,J,C,qe,z,ol,Ge,Ml="XLM",nt,B,bl="XLM has ten different checkpoints, only one of which is monolingual. The nine remaining model checkpoints can be split into two categories: the checkpoints that use language embeddings and those that don’t.",at,T,j,Fe,H,rl,We,yl="XLM with language embeddings",st,N,vl="The following XLM models use language embeddings to specify the language used at inference:",it,q,Jl="<li><code>xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",ot,F,Tl="Language embeddings are represented as a tensor of the same shape as the <code>input_ids</code> passed to the model. The values in these tensors depend on the language used and are identified by the tokenizer’s <code>lang2id</code> and <code>id2lang</code> attributes.",rt,Q,wl="In this example, load the <code>xlm-clm-enfr-1024</code> checkpoint (Causal language modeling, English-French):",mt,P,pt,S,Ul="The <code>lang2id</code> attribute of the tokenizer displays this model’s languages and their ids:",ut,A,ht,Y,kl="Next, create an example input:",gt,D,dt,K,xl="Set the language id as <code>&quot;en&quot;</code> and use it to define the language embedding. The language embedding is a tensor filled with <code>0</code> since that is the language id for English. This tensor should be the same size as <code>input_ids</code>.",ct,O,ft,ee,$l="Now you can pass the <code>input_ids</code> and language embedding to the model:",Mt,te,bt,le,_l='The <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> script can generate text with language embeddings using the <code>xlm-clm</code> checkpoints.',yt,w,Z,Qe,ne,ml,Re,Cl="XLM without language embeddings",vt,ae,jl="The following XLM models do not require language embeddings during inference:",Jt,se,Zl="<li><code>xlm-mlm-17-1280</code> (Masked language modeling, 17 languages)</li> <li><code>xlm-mlm-100-1280</code> (Masked language modeling, 100 languages)</li>",Tt,ie,Xl="These models are used for generic sentence representations, unlike the previous XLM checkpoints.",wt,U,X,Pe,oe,pl,Le,Il="BERT",Ut,re,El="The following BERT models can be used for multilingual tasks:",kt,me,Gl="<li><code>bert-base-multilingual-uncased</code> (Masked language modeling + Next sentence prediction, 102 languages)</li> <li><code>bert-base-multilingual-cased</code> (Masked language modeling + Next sentence prediction, 104 languages)</li>",xt,pe,Wl=`These models do not require language embeddings during inference. They should identify the language from the
context and infer accordingly.`,$t,k,I,Se,ue,ul,Ve,Rl="XLM-RoBERTa",_t,he,Ll="The following XLM-RoBERTa models can be used for multilingual tasks:",Ct,ge,Vl="<li><code>xlm-roberta-base</code> (Masked language modeling, 100 languages)</li> <li><code>xlm-roberta-large</code> (Masked language modeling, 100 languages)</li>",jt,de,zl="XLM-RoBERTa was trained on 2.5TB of newly created and cleaned CommonCrawl data in 100 languages. It provides strong gains over previously released multilingual models like mBERT or XLM on downstream tasks like classification, sequence labeling, and question answering.",Zt,x,E,Ae,ce,hl,ze,Bl="M2M100",Xt,fe,Hl="The following M2M100 models can be used for multilingual translation:",It,Me,Nl="<li><code>facebook/m2m100_418M</code> (Translation)</li> <li><code>facebook/m2m100_1.2B</code> (Translation)</li>",Et,be,ql="In this example, load the <code>facebook/m2m100_418M</code> checkpoint to translate from Chinese to English. You can set the source language in the tokenizer:",Gt,ye,Wt,ve,Fl="Tokenize the text:",Rt,Je,Lt,Te,Ql="M2M100 forces the target language id as the first generated token to translate to the target language. Set the <code>forced_bos_token_id</code> to <code>en</code> in the <code>generate</code> method to translate to English:",Vt,we,zt,$,G,Ye,Ue,gl,Be,Pl="MBart",Bt,ke,Sl="The following MBart models can be used for multilingual translation:",Ht,xe,Al="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (One-to-many multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Many-to-many multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Many-to-one multilingual machine translation, 50 languages)</li> <li><code>facebook/mbart-large-50</code> (Multilingual translation, 50 languages)</li> <li><code>facebook/mbart-large-cc25</code></li>",Nt,$e,Yl="In this example, load the <code>facebook/mbart-large-50-many-to-many-mmt</code> checkpoint to translate Finnish to English. You can set the source language in the tokenizer:",qt,_e,Ft,Ce,Dl="Tokenize the text:",Qt,je,Pt,Ze,Kl="MBart forces the target language id as the first generated token to translate to the target language. Set the <code>forced_bos_token_id</code> to <code>en</code> in the <code>generate</code> method to translate to English:",St,Xe,At,Ie,Ol="If you are using the <code>facebook/mbart-large-50-many-to-one-mmt</code> checkpoint, you don’t need to force the target language id as the first generated token otherwise the usage is the same.",Yt,De,Dt;return R=new W({}),L=new wn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multilingual.ipynb"}]}}),z=new W({}),H=new W({}),P=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),A=new b({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),D=new b({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),O=new b({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),te=new b({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),ne=new W({}),oe=new W({}),ue=new W({}),ce=new W({}),ye=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),Je=new b({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),we=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),Ue=new W({}),_e=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),je=new b({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Xe=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkJTVCJTIyZW5fWFglMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id[<span class="hljs-string">&quot;en_XX&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){y=a("meta"),Ke=i(),He=a("p"),Oe=i(),v=a("h1"),_=a("a"),Ne=a("span"),h(R.$$.fragment),il=i(),Ee=a("span"),Ee.textContent=cl,et=i(),h(L.$$.fragment),tt=i(),V=a("p"),V.innerHTML=fl,lt=i(),J=a("h2"),C=a("a"),qe=a("span"),h(z.$$.fragment),ol=i(),Ge=a("span"),Ge.textContent=Ml,nt=i(),B=a("p"),B.textContent=bl,at=i(),T=a("h3"),j=a("a"),Fe=a("span"),h(H.$$.fragment),rl=i(),We=a("span"),We.textContent=yl,st=i(),N=a("p"),N.textContent=vl,it=i(),q=a("ul"),q.innerHTML=Jl,ot=i(),F=a("p"),F.innerHTML=Tl,rt=i(),Q=a("p"),Q.innerHTML=wl,mt=i(),h(P.$$.fragment),pt=i(),S=a("p"),S.innerHTML=Ul,ut=i(),h(A.$$.fragment),ht=i(),Y=a("p"),Y.textContent=kl,gt=i(),h(D.$$.fragment),dt=i(),K=a("p"),K.innerHTML=xl,ct=i(),h(O.$$.fragment),ft=i(),ee=a("p"),ee.innerHTML=$l,Mt=i(),h(te.$$.fragment),bt=i(),le=a("p"),le.innerHTML=_l,yt=i(),w=a("h3"),Z=a("a"),Qe=a("span"),h(ne.$$.fragment),ml=i(),Re=a("span"),Re.textContent=Cl,vt=i(),ae=a("p"),ae.textContent=jl,Jt=i(),se=a("ul"),se.innerHTML=Zl,Tt=i(),ie=a("p"),ie.textContent=Xl,wt=i(),U=a("h2"),X=a("a"),Pe=a("span"),h(oe.$$.fragment),pl=i(),Le=a("span"),Le.textContent=Il,Ut=i(),re=a("p"),re.textContent=El,kt=i(),me=a("ul"),me.innerHTML=Gl,xt=i(),pe=a("p"),pe.textContent=Wl,$t=i(),k=a("h2"),I=a("a"),Se=a("span"),h(ue.$$.fragment),ul=i(),Ve=a("span"),Ve.textContent=Rl,_t=i(),he=a("p"),he.textContent=Ll,Ct=i(),ge=a("ul"),ge.innerHTML=Vl,jt=i(),de=a("p"),de.textContent=zl,Zt=i(),x=a("h2"),E=a("a"),Ae=a("span"),h(ce.$$.fragment),hl=i(),ze=a("span"),ze.textContent=Bl,Xt=i(),fe=a("p"),fe.textContent=Hl,It=i(),Me=a("ul"),Me.innerHTML=Nl,Et=i(),be=a("p"),be.innerHTML=ql,Gt=i(),h(ye.$$.fragment),Wt=i(),ve=a("p"),ve.textContent=Fl,Rt=i(),h(Je.$$.fragment),Lt=i(),Te=a("p"),Te.innerHTML=Ql,Vt=i(),h(we.$$.fragment),zt=i(),$=a("h2"),G=a("a"),Ye=a("span"),h(Ue.$$.fragment),gl=i(),Be=a("span"),Be.textContent=Pl,Bt=i(),ke=a("p"),ke.textContent=Sl,Ht=i(),xe=a("ul"),xe.innerHTML=Al,Nt=i(),$e=a("p"),$e.innerHTML=Yl,qt=i(),h(_e.$$.fragment),Ft=i(),Ce=a("p"),Ce.textContent=Dl,Qt=i(),h(je.$$.fragment),Pt=i(),Ze=a("p"),Ze.innerHTML=Kl,St=i(),h(Xe.$$.fragment),At=i(),Ie=a("p"),Ie.innerHTML=Ol,Yt=i(),De=a("p"),this.h()},l(e){const l=Tn("svelte-1phssyn",document.head);y=s(l,"META",{name:!0,content:!0}),l.forEach(t),Ke=o(e),He=s(e,"P",{}),u(He).forEach(t),Oe=o(e),v=s(e,"H1",{class:!0});var Kt=u(v);_=s(Kt,"A",{id:!0,class:!0,href:!0});var en=u(_);Ne=s(en,"SPAN",{});var tn=u(Ne);g(R.$$.fragment,tn),tn.forEach(t),en.forEach(t),il=o(Kt),Ee=s(Kt,"SPAN",{"data-svelte-h":!0}),r(Ee)!=="svelte-10fcr4q"&&(Ee.textContent=cl),Kt.forEach(t),et=o(e),g(L.$$.fragment,e),tt=o(e),V=s(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-esxaab"&&(V.innerHTML=fl),lt=o(e),J=s(e,"H2",{class:!0});var Ot=u(J);C=s(Ot,"A",{id:!0,class:!0,href:!0});var ln=u(C);qe=s(ln,"SPAN",{});var nn=u(qe);g(z.$$.fragment,nn),nn.forEach(t),ln.forEach(t),ol=o(Ot),Ge=s(Ot,"SPAN",{"data-svelte-h":!0}),r(Ge)!=="svelte-zmv7xk"&&(Ge.textContent=Ml),Ot.forEach(t),nt=o(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-gat0c0"&&(B.textContent=bl),at=o(e),T=s(e,"H3",{class:!0});var el=u(T);j=s(el,"A",{id:!0,class:!0,href:!0});var an=u(j);Fe=s(an,"SPAN",{});var sn=u(Fe);g(H.$$.fragment,sn),sn.forEach(t),an.forEach(t),rl=o(el),We=s(el,"SPAN",{"data-svelte-h":!0}),r(We)!=="svelte-11nkvfy"&&(We.textContent=yl),el.forEach(t),st=o(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1rdjt2u"&&(N.textContent=vl),it=o(e),q=s(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1iu32ge"&&(q.innerHTML=Jl),ot=o(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-etk90v"&&(F.innerHTML=Tl),rt=o(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1matafr"&&(Q.innerHTML=wl),mt=o(e),g(P.$$.fragment,e),pt=o(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ncydbw"&&(S.innerHTML=Ul),ut=o(e),g(A.$$.fragment,e),ht=o(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1a9p0ho"&&(Y.textContent=kl),gt=o(e),g(D.$$.fragment,e),dt=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-vuczip"&&(K.innerHTML=xl),ct=o(e),g(O.$$.fragment,e),ft=o(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-v1jc9q"&&(ee.innerHTML=$l),Mt=o(e),g(te.$$.fragment,e),bt=o(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-c53qag"&&(le.innerHTML=_l),yt=o(e),w=s(e,"H3",{class:!0});var tl=u(w);Z=s(tl,"A",{id:!0,class:!0,href:!0});var on=u(Z);Qe=s(on,"SPAN",{});var rn=u(Qe);g(ne.$$.fragment,rn),rn.forEach(t),on.forEach(t),ml=o(tl),Re=s(tl,"SPAN",{"data-svelte-h":!0}),r(Re)!=="svelte-xcg9gk"&&(Re.textContent=Cl),tl.forEach(t),vt=o(e),ae=s(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1m6ccze"&&(ae.textContent=jl),Jt=o(e),se=s(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-qmf2p4"&&(se.innerHTML=Zl),Tt=o(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1fn4lmn"&&(ie.textContent=Xl),wt=o(e),U=s(e,"H2",{class:!0});var ll=u(U);X=s(ll,"A",{id:!0,class:!0,href:!0});var mn=u(X);Pe=s(mn,"SPAN",{});var pn=u(Pe);g(oe.$$.fragment,pn),pn.forEach(t),mn.forEach(t),pl=o(ll),Le=s(ll,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-d1aweg"&&(Le.textContent=Il),ll.forEach(t),Ut=o(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ze8b37"&&(re.textContent=El),kt=o(e),me=s(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-q5bq75"&&(me.innerHTML=Gl),xt=o(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1uvjv96"&&(pe.textContent=Wl),$t=o(e),k=s(e,"H2",{class:!0});var nl=u(k);I=s(nl,"A",{id:!0,class:!0,href:!0});var un=u(I);Se=s(un,"SPAN",{});var hn=u(Se);g(ue.$$.fragment,hn),hn.forEach(t),un.forEach(t),ul=o(nl),Ve=s(nl,"SPAN",{"data-svelte-h":!0}),r(Ve)!=="svelte-on8il6"&&(Ve.textContent=Rl),nl.forEach(t),_t=o(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-cq4taf"&&(he.textContent=Ll),Ct=o(e),ge=s(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-1rac7bc"&&(ge.innerHTML=Vl),jt=o(e),de=s(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ahupcy"&&(de.textContent=zl),Zt=o(e),x=s(e,"H2",{class:!0});var al=u(x);E=s(al,"A",{id:!0,class:!0,href:!0});var gn=u(E);Ae=s(gn,"SPAN",{});var dn=u(Ae);g(ce.$$.fragment,dn),dn.forEach(t),gn.forEach(t),hl=o(al),ze=s(al,"SPAN",{"data-svelte-h":!0}),r(ze)!=="svelte-1qywztq"&&(ze.textContent=Bl),al.forEach(t),Xt=o(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1n18e2"&&(fe.textContent=Hl),It=o(e),Me=s(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-xli8b1"&&(Me.innerHTML=Nl),Et=o(e),be=s(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1hz3ybz"&&(be.innerHTML=ql),Gt=o(e),g(ye.$$.fragment,e),Wt=o(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1v7p0in"&&(ve.textContent=Fl),Rt=o(e),g(Je.$$.fragment,e),Lt=o(e),Te=s(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1t7zua3"&&(Te.innerHTML=Ql),Vt=o(e),g(we.$$.fragment,e),zt=o(e),$=s(e,"H2",{class:!0});var sl=u($);G=s(sl,"A",{id:!0,class:!0,href:!0});var cn=u(G);Ye=s(cn,"SPAN",{});var fn=u(Ye);g(Ue.$$.fragment,fn),fn.forEach(t),cn.forEach(t),gl=o(sl),Be=s(sl,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-1ncd2v"&&(Be.textContent=Pl),sl.forEach(t),Bt=o(e),ke=s(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1kinu1v"&&(ke.textContent=Sl),Ht=o(e),xe=s(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-xa5lcq"&&(xe.innerHTML=Al),Nt=o(e),$e=s(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-aaduni"&&($e.innerHTML=Yl),qt=o(e),g(_e.$$.fragment,e),Ft=o(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1v7p0in"&&(Ce.textContent=Dl),Qt=o(e),g(je.$$.fragment,e),Pt=o(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1hdrcsc"&&(Ze.innerHTML=Kl),St=o(e),g(Xe.$$.fragment,e),At=o(e),Ie=s(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1la8qcj"&&(Ie.innerHTML=Ol),Yt=o(e),De=s(e,"P",{}),u(De).forEach(t),this.h()},h(){m(y,"name","hf:doc:metadata"),m(y,"content",JSON.stringify(kn)),m(_,"id","multilingual-models-for-inference"),m(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(_,"href","#multilingual-models-for-inference"),m(v,"class","relative group"),m(C,"id","xlm"),m(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(C,"href","#xlm"),m(J,"class","relative group"),m(j,"id","xlm-with-language-embeddings"),m(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(j,"href","#xlm-with-language-embeddings"),m(T,"class","relative group"),m(Z,"id","xlm-without-language-embeddings"),m(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Z,"href","#xlm-without-language-embeddings"),m(w,"class","relative group"),m(X,"id","bert"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#bert"),m(U,"class","relative group"),m(I,"id","xlmroberta"),m(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(I,"href","#xlmroberta"),m(k,"class","relative group"),m(E,"id","m2m100"),m(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(E,"href","#m2m100"),m(x,"class","relative group"),m(G,"id","mbart"),m(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(G,"href","#mbart"),m($,"class","relative group")},m(e,l){p(document.head,y),n(e,Ke,l),n(e,He,l),n(e,Oe,l),n(e,v,l),p(v,_),p(_,Ne),d(R,Ne,null),p(v,il),p(v,Ee),n(e,et,l),d(L,e,l),n(e,tt,l),n(e,V,l),n(e,lt,l),n(e,J,l),p(J,C),p(C,qe),d(z,qe,null),p(J,ol),p(J,Ge),n(e,nt,l),n(e,B,l),n(e,at,l),n(e,T,l),p(T,j),p(j,Fe),d(H,Fe,null),p(T,rl),p(T,We),n(e,st,l),n(e,N,l),n(e,it,l),n(e,q,l),n(e,ot,l),n(e,F,l),n(e,rt,l),n(e,Q,l),n(e,mt,l),d(P,e,l),n(e,pt,l),n(e,S,l),n(e,ut,l),d(A,e,l),n(e,ht,l),n(e,Y,l),n(e,gt,l),d(D,e,l),n(e,dt,l),n(e,K,l),n(e,ct,l),d(O,e,l),n(e,ft,l),n(e,ee,l),n(e,Mt,l),d(te,e,l),n(e,bt,l),n(e,le,l),n(e,yt,l),n(e,w,l),p(w,Z),p(Z,Qe),d(ne,Qe,null),p(w,ml),p(w,Re),n(e,vt,l),n(e,ae,l),n(e,Jt,l),n(e,se,l),n(e,Tt,l),n(e,ie,l),n(e,wt,l),n(e,U,l),p(U,X),p(X,Pe),d(oe,Pe,null),p(U,pl),p(U,Le),n(e,Ut,l),n(e,re,l),n(e,kt,l),n(e,me,l),n(e,xt,l),n(e,pe,l),n(e,$t,l),n(e,k,l),p(k,I),p(I,Se),d(ue,Se,null),p(k,ul),p(k,Ve),n(e,_t,l),n(e,he,l),n(e,Ct,l),n(e,ge,l),n(e,jt,l),n(e,de,l),n(e,Zt,l),n(e,x,l),p(x,E),p(E,Ae),d(ce,Ae,null),p(x,hl),p(x,ze),n(e,Xt,l),n(e,fe,l),n(e,It,l),n(e,Me,l),n(e,Et,l),n(e,be,l),n(e,Gt,l),d(ye,e,l),n(e,Wt,l),n(e,ve,l),n(e,Rt,l),d(Je,e,l),n(e,Lt,l),n(e,Te,l),n(e,Vt,l),d(we,e,l),n(e,zt,l),n(e,$,l),p($,G),p(G,Ye),d(Ue,Ye,null),p($,gl),p($,Be),n(e,Bt,l),n(e,ke,l),n(e,Ht,l),n(e,xe,l),n(e,Nt,l),n(e,$e,l),n(e,qt,l),d(_e,e,l),n(e,Ft,l),n(e,Ce,l),n(e,Qt,l),d(je,e,l),n(e,Pt,l),n(e,Ze,l),n(e,St,l),d(Xe,e,l),n(e,At,l),n(e,Ie,l),n(e,Yt,l),n(e,De,l),Dt=!0},p:bn,i(e){Dt||(c(R.$$.fragment,e),c(L.$$.fragment,e),c(z.$$.fragment,e),c(H.$$.fragment,e),c(P.$$.fragment,e),c(A.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(_e.$$.fragment,e),c(je.$$.fragment,e),c(Xe.$$.fragment,e),Dt=!0)},o(e){f(R.$$.fragment,e),f(L.$$.fragment,e),f(z.$$.fragment,e),f(H.$$.fragment,e),f(P.$$.fragment,e),f(A.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(ue.$$.fragment,e),f(ce.$$.fragment,e),f(ye.$$.fragment,e),f(Je.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f(_e.$$.fragment,e),f(je.$$.fragment,e),f(Xe.$$.fragment,e),Dt=!1},d(e){e&&(t(Ke),t(He),t(Oe),t(v),t(et),t(tt),t(V),t(lt),t(J),t(nt),t(B),t(at),t(T),t(st),t(N),t(it),t(q),t(ot),t(F),t(rt),t(Q),t(mt),t(pt),t(S),t(ut),t(ht),t(Y),t(gt),t(dt),t(K),t(ct),t(ft),t(ee),t(Mt),t(bt),t(le),t(yt),t(w),t(vt),t(ae),t(Jt),t(se),t(Tt),t(ie),t(wt),t(U),t(Ut),t(re),t(kt),t(me),t(xt),t(pe),t($t),t(k),t(_t),t(he),t(Ct),t(ge),t(jt),t(de),t(Zt),t(x),t(Xt),t(fe),t(It),t(Me),t(Et),t(be),t(Gt),t(Wt),t(ve),t(Rt),t(Lt),t(Te),t(Vt),t(zt),t($),t(Bt),t(ke),t(Ht),t(xe),t(Nt),t($e),t(qt),t(Ft),t(Ce),t(Qt),t(Pt),t(Ze),t(St),t(At),t(Ie),t(Yt),t(De)),t(y),M(R),M(L,e),M(z),M(H),M(P,e),M(A,e),M(D,e),M(O,e),M(te,e),M(ne),M(oe),M(ue),M(ce),M(ye,e),M(Je,e),M(we,e),M(Ue),M(_e,e),M(je,e),M(Xe,e)}}}const kn={local:"multilingual-models-for-inference",sections:[{local:"xlm",sections:[{local:"xlm-with-language-embeddings",title:"XLM with language embeddings"},{local:"xlm-without-language-embeddings",title:"XLM without language embeddings"}],title:"XLM"},{local:"bert",title:"BERT"},{local:"xlmroberta",title:"XLM-RoBERTa"},{local:"m2m100",title:"M2M100"},{local:"mbart",title:"MBart"}],title:"Multilingual models for inference"};function xn(dl){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xn extends vn{constructor(y){super(),Jn(this,y,xn,Un,Mn,{})}}export{Xn as component};
