import{s as Dt,o as Ot,n as es}from"../chunks/scheduler.9bc65507.js";import{S as ts,i as ss,g as l,s as o,u as d,A as ns,h as a,f as t,c as i,j as u,v as m,y as h,k as r,o as p,a as n,w as f,d as v,t as g,x as M,m as ls,n as as}from"../chunks/index.78c82d43.js";import{T as Kt}from"../chunks/Tip.87d55b76.js";import{I as ve}from"../chunks/IconCopyLink.bedaa44d.js";import{C as pt}from"../chunks/CodeBlock.73e038be.js";function os(he){let c;return{c(){c=ls(`Creating an inference engine is a complex topic, and the "best" solution 
will most likely depend on your problem space. Are you on CPU or GPU? Do
you want the lowest latency, the highest throughput, support for
many models, or just highly optimize 1 specific model?
There are many ways to tackle this topic, so what we are going to present is a good default
to get started which may not necessarily be the most optimal solution for you.`)},l(y){c=as(y,`Creating an inference engine is a complex topic, and the "best" solution 
will most likely depend on your problem space. Are you on CPU or GPU? Do
you want the lowest latency, the highest throughput, support for
many models, or just highly optimize 1 specific model?
There are many ways to tackle this topic, so what we are going to present is a good default
to get started which may not necessarily be the most optimal solution for you.`)},m(y,w){n(y,c,w)},d(y){y&&t(c)}}}function is(he){let c,y=`The code sample below is intentionally written like pseudo-code for readability.
Do not run this without checking if it makes sense for your system resources!`;return{c(){c=l("p"),c.textContent=y},l(w){c=a(w,"P",{"data-svelte-h":!0}),h(c)!=="svelte-rnh8z1"&&(c.textContent=y)},m(w,ce){n(w,c,ce)},p:es,d(w){w&&t(c)}}}function rs(he){let c,y,w,ce,T,k,ge,E,ht,ue,mt="Using pipelines for a webserver",ke,I,Ie,A,ft=`The key thing to understand is that we can use an iterator, just like you would <a href="pipeline_tutorial#using-pipelines-on-a-dataset">on a
dataset</a>, since a webserver is basically a system that waits for requests and
treats them as they come in.`,$e,Q,vt=`Usually webservers are multiplexed (multithreaded, async, etc..) to handle various
requests concurrently. Pipelines on the other hand (and mostly the underlying models)
are not really great for parallelism; they take up a lot of RAM, so it’s best to give them all the available resources when they are running or it’s a compute-intensive job.`,xe,S,gt=`We are going to solve that by having the webserver handle the light load of receiving
and sending requests, and having a single thread handling the actual work.
This example is going to use <code>starlette</code>. The actual framework is not really
important, but you might have to tune or change the code if you are using another
one to achieve the same effect.`,Be,H,Mt="Create <code>server.py</code>:",_e,X,qe,Z,Tt="Now you can start it with:",Ne,V,Ee,G,Jt="And you can query it:",Ae,P,Qe,W,bt="And there you go, now you have a good idea of how to create a webserver!",Se,R,Ct=`What is really important is that we load the model only <strong>once</strong>, so there are no copies
of the model on the webserver. This way, no unnecessary RAM is being used.
Then the queuing mechanism allows you to do fancy stuff like maybe accumulating a few
items before inferring to use dynamic batching:`,He,$,Xe,z,Ze,F,Ut=`Again, the proposed code is optimized for readability, not for being the best code.
First of all, there’s no batch size limit which is usually not a
great idea. Next, the timeout is reset on every queue fetch, meaning you could
wait much more than 1ms before running the inference (delaying the first request
by that much).`,Ve,L,jt="It would be better to have a single 1ms deadline.",Ge,Y,kt=`This will always wait for 1ms even if the queue is empty, which might not be the
best since you probably want to start doing inference if there’s nothing in the queue.
But maybe it does make sense if batching is really crucial for your use case.
Again, there’s really no one best solution.`,Pe,J,x,Me,K,ct,ye,It="Few things you might want to consider",We,b,B,Te,D,ut,we,$t="Error checking",Re,O,xt=`There’s a lot that can go wrong in production: out of memory, out of space,
loading the model might fail, the query might be wrong, the query might be
correct but still fail to run because of a model misconfiguration, and so on.`,ze,ee,Bt=`Generally, it’s good if the server outputs the errors to the user, so
adding a lot of <code>try..except</code> statements to show those errors is a good
idea. But keep in mind it may also be a security risk to reveal all those errors depending
on your security context.`,Fe,C,_,Je,te,yt,de,_t="Circuit breaking",Le,se,qt=`Webservers usually look better when they do circuit breaking. It means they
return proper errors when they’re overloaded instead of just waiting for the query indefinitely. Return a 503 error instead of waiting for a super long time or a 504 after a long time.`,Ye,ne,Nt=`This is relatively easy to implement in the proposed code since there is a single queue.
Looking at the queue size is a basic way to start returning errors before your
webserver fails under load.`,Ke,U,q,be,le,wt,me,Et="Blocking the main thread",De,ae,At=`Currently PyTorch is not async aware, and computation will block the main
thread while running. That means it would be better if PyTorch was forced to run
on its own thread/process. This wasn’t done here because the code is a lot more
complex (mostly because threads and async and queues don’t play nice together).
But ultimately it does the same thing.`,Oe,oe,Qt=`This would be important if the inference of single items were long (> 1s) because
in this case, it means every query during inference would have to wait for 1s before
even receiving an error.`,et,j,N,Ce,ie,dt,fe,St="Dynamic batching",tt,re,Ht=`In general, batching is not necessarily an improvement over passing 1 item at
a time (see <a href="./main_classes/pipelines#pipeline-batching">batching details</a> for more information). But it can be very effective
when used in the correct setting. In the API, there is no dynamic
batching by default (too much opportunity for a slowdown). But for BLOOM inference -
which is a very large model - dynamic batching is <strong>essential</strong> to provide a decent experience for everyone.`,st,Ue,nt;return E=new ve({}),I=new Kt({props:{$$slots:{default:[os]},$$scope:{ctx:he}}}),X=new pt({props:{code:"ZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlc3BvbnNlcyUyMGltcG9ydCUyMEpTT05SZXNwb25zZSUwQWZyb20lMjBzdGFybGV0dGUucm91dGluZyUyMGltcG9ydCUyMFJvdXRlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwYXN5bmNpbyUwQSUwQSUwQWFzeW5jJTIwZGVmJTIwaG9tZXBhZ2UocmVxdWVzdCklM0ElMEElMjAlMjAlMjAlMjBwYXlsb2FkJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0LmJvZHkoKSUwQSUyMCUyMCUyMCUyMHN0cmluZyUyMCUzRCUyMHBheWxvYWQuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3ElMjAlM0QlMjBhc3luY2lvLlF1ZXVlKCklMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJlcXVlc3QuYXBwLm1vZGVsX3F1ZXVlLnB1dCgoc3RyaW5nJTJDJTIwcmVzcG9uc2VfcSkpJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwYXdhaXQlMjByZXNwb25zZV9xLmdldCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwSlNPTlJlc3BvbnNlKG91dHB1dCklMEElMEElMEFhc3luYyUyMGRlZiUyMHNlcnZlcl9sb29wKHEpJTNBJTBBJTIwJTIwJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKHN0cmluZyUyQyUyMHJlc3BvbnNlX3EpJTIwJTNEJTIwYXdhaXQlMjBxLmdldCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwcGlwZShzdHJpbmcpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjByZXNwb25zZV9xLnB1dChvdXQpJTBBJTBBJTBBYXBwJTIwJTNEJTIwU3RhcmxldHRlKCUwQSUyMCUyMCUyMCUyMHJvdXRlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJvdXRlKCUyMiUyRiUyMiUyQyUyMGhvbWVwYWdlJTJDJTIwbWV0aG9kcyUzRCU1QiUyMlBPU1QlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBKSUwQSUwQSUwQSU0MGFwcC5vbl9ldmVudCglMjJzdGFydHVwJTIyKSUwQWFzeW5jJTIwZGVmJTIwc3RhcnR1cF9ldmVudCgpJTNBJTBBJTIwJTIwJTIwJTIwcSUyMCUzRCUyMGFzeW5jaW8uUXVldWUoKSUwQSUyMCUyMCUyMCUyMGFwcC5tb2RlbF9xdWV1ZSUyMCUzRCUyMHElMEElMjAlMjAlMjAlMjBhc3luY2lvLmNyZWF0ZV90YXNrKHNlcnZlcl9sb29wKHEpKQ==",highlighted:`<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> asyncio


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">homepage</span>(<span class="hljs-params">request</span>):
    payload = <span class="hljs-keyword">await</span> request.body()
    string = payload.decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
    response_q = asyncio.Queue()
    <span class="hljs-keyword">await</span> request.app.model_queue.put((string, response_q))
    output = <span class="hljs-keyword">await</span> response_q.get()
    <span class="hljs-keyword">return</span> JSONResponse(output)


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">server_loop</span>(<span class="hljs-params">q</span>):
    pipe = pipeline(model=<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        (string, response_q) = <span class="hljs-keyword">await</span> q.get()
        out = pipe(string)
        <span class="hljs-keyword">await</span> response_q.put(out)


app = Starlette(
    routes=[
        Route(<span class="hljs-string">&quot;/&quot;</span>, homepage, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
    ],
)


<span class="hljs-meta">@app.on_event(<span class="hljs-params"><span class="hljs-string">&quot;startup&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">startup_event</span>():
    q = asyncio.Queue()
    app.model_queue = q
    asyncio.create_task(server_loop(q))`,wrap:!1}}),V=new pt({props:{code:"dXZpY29ybiUyMHNlcnZlciUzQWFwcA==",highlighted:"uvicorn server:app",wrap:!1}}),P=new pt({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMC1kJTIwJTIydGVzdCUyMCU1Qk1BU0slNUQlMjIlMjBodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRiUwQSUyMyU1QiU3QiUyMnNjb3JlJTIyJTNBMC43NzQyOTM2MDE1MTI5MDg5JTJDJTIydG9rZW4lMjIlM0ExMDEyJTJDJTIydG9rZW5fc3RyJTIyJTNBJTIyLiUyMiUyQyUyMnNlcXVlbmNlJTIyJTNBJTIydGVzdC4lMjIlN0QlMkMuLi4lNUQ=",highlighted:`curl -X POST -d <span class="hljs-string">&quot;test [MASK]&quot;</span> http://localhost:8000/
<span class="hljs-comment">#[{&quot;score&quot;:0.7742936015129089,&quot;token&quot;:1012,&quot;token_str&quot;:&quot;.&quot;,&quot;sequence&quot;:&quot;test.&quot;},...]</span>`,wrap:!1}}),$=new Kt({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:he}}}),z=new pt({props:{code:"KHN0cmluZyUyQyUyMHJxKSUyMCUzRCUyMGF3YWl0JTIwcS5nZXQoKSUwQXN0cmluZ3MlMjAlM0QlMjAlNUIlNUQlMEFxdWV1ZXMlMjAlM0QlMjAlNUIlNUQlMEF3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoc3RyaW5nJTJDJTIwcnEpJTIwJTNEJTIwYXdhaXQlMjBhc3luY2lvLndhaXRfZm9yKHEuZ2V0KCklMkMlMjB0aW1lb3V0JTNEMC4wMDEpJTIwJTIwJTIzJTIwMW1zJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwYXN5bmNpby5leGNlcHRpb25zLlRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwc3RyaW5ncy5hcHBlbmQoc3RyaW5nKSUwQSUyMCUyMCUyMCUyMHF1ZXVlcy5hcHBlbmQocnEpJTBBc3RyaW5ncyUwQW91dHMlMjAlM0QlMjBwaXBlKHN0cmluZ3MlMkMlMjBiYXRjaF9zaXplJTNEbGVuKHN0cmluZ3MpKSUwQWZvciUyMHJxJTJDJTIwb3V0JTIwaW4lMjB6aXAocXVldWVzJTJDJTIwb3V0cyklM0ElMEElMjAlMjAlMjAlMjBhd2FpdCUyMHJxLnB1dChvdXQp",highlighted:`(string, rq) = <span class="hljs-keyword">await</span> q.get()
strings = []
queues = []
<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    <span class="hljs-keyword">try</span>:
        (string, rq) = <span class="hljs-keyword">await</span> asyncio.wait_for(q.get(), timeout=<span class="hljs-number">0.001</span>)  <span class="hljs-comment"># 1ms</span>
    <span class="hljs-keyword">except</span> asyncio.exceptions.TimeoutError:
        <span class="hljs-keyword">break</span>
    strings.append(string)
    queues.append(rq)
strings
outs = pipe(strings, batch_size=<span class="hljs-built_in">len</span>(strings))
<span class="hljs-keyword">for</span> rq, out <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(queues, outs):
    <span class="hljs-keyword">await</span> rq.put(out)`,wrap:!1}}),K=new ve({}),D=new ve({}),te=new ve({}),le=new ve({}),ie=new ve({}),{c(){c=l("meta"),y=o(),w=l("p"),ce=o(),T=l("h1"),k=l("a"),ge=l("span"),d(E.$$.fragment),ht=o(),ue=l("span"),ue.textContent=mt,ke=o(),d(I.$$.fragment),Ie=o(),A=l("p"),A.innerHTML=ft,$e=o(),Q=l("p"),Q.textContent=vt,xe=o(),S=l("p"),S.innerHTML=gt,Be=o(),H=l("p"),H.innerHTML=Mt,_e=o(),d(X.$$.fragment),qe=o(),Z=l("p"),Z.textContent=Tt,Ne=o(),d(V.$$.fragment),Ee=o(),G=l("p"),G.textContent=Jt,Ae=o(),d(P.$$.fragment),Qe=o(),W=l("p"),W.textContent=bt,Se=o(),R=l("p"),R.innerHTML=Ct,He=o(),d($.$$.fragment),Xe=o(),d(z.$$.fragment),Ze=o(),F=l("p"),F.textContent=Ut,Ve=o(),L=l("p"),L.textContent=jt,Ge=o(),Y=l("p"),Y.textContent=kt,Pe=o(),J=l("h2"),x=l("a"),Me=l("span"),d(K.$$.fragment),ct=o(),ye=l("span"),ye.textContent=It,We=o(),b=l("h3"),B=l("a"),Te=l("span"),d(D.$$.fragment),ut=o(),we=l("span"),we.textContent=$t,Re=o(),O=l("p"),O.textContent=xt,ze=o(),ee=l("p"),ee.innerHTML=Bt,Fe=o(),C=l("h3"),_=l("a"),Je=l("span"),d(te.$$.fragment),yt=o(),de=l("span"),de.textContent=_t,Le=o(),se=l("p"),se.textContent=qt,Ye=o(),ne=l("p"),ne.textContent=Nt,Ke=o(),U=l("h3"),q=l("a"),be=l("span"),d(le.$$.fragment),wt=o(),me=l("span"),me.textContent=Et,De=o(),ae=l("p"),ae.textContent=At,Oe=o(),oe=l("p"),oe.textContent=Qt,et=o(),j=l("h3"),N=l("a"),Ce=l("span"),d(ie.$$.fragment),dt=o(),fe=l("span"),fe.textContent=St,tt=o(),re=l("p"),re.innerHTML=Ht,st=o(),Ue=l("p"),this.h()},l(e){const s=ns("svelte-1phssyn",document.head);c=a(s,"META",{name:!0,content:!0}),s.forEach(t),y=i(e),w=a(e,"P",{}),u(w).forEach(t),ce=i(e),T=a(e,"H1",{class:!0});var pe=u(T);k=a(pe,"A",{id:!0,class:!0,href:!0});var je=u(k);ge=a(je,"SPAN",{});var Xt=u(ge);m(E.$$.fragment,Xt),Xt.forEach(t),je.forEach(t),ht=i(pe),ue=a(pe,"SPAN",{"data-svelte-h":!0}),h(ue)!=="svelte-b1sisp"&&(ue.textContent=mt),pe.forEach(t),ke=i(e),m(I.$$.fragment,e),Ie=i(e),A=a(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-n5c362"&&(A.innerHTML=ft),$e=i(e),Q=a(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1fnss2o"&&(Q.textContent=vt),xe=i(e),S=a(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-8q5x1q"&&(S.innerHTML=gt),Be=i(e),H=a(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-g4gw6x"&&(H.innerHTML=Mt),_e=i(e),m(X.$$.fragment,e),qe=i(e),Z=a(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-1uqobnc"&&(Z.textContent=Tt),Ne=i(e),m(V.$$.fragment,e),Ee=i(e),G=a(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-65h2jl"&&(G.textContent=Jt),Ae=i(e),m(P.$$.fragment,e),Qe=i(e),W=a(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1c2g0w1"&&(W.textContent=bt),Se=i(e),R=a(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1l65fmc"&&(R.innerHTML=Ct),He=i(e),m($.$$.fragment,e),Xe=i(e),m(z.$$.fragment,e),Ze=i(e),F=a(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-14jxcik"&&(F.textContent=Ut),Ve=i(e),L=a(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1bprwig"&&(L.textContent=jt),Ge=i(e),Y=a(e,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-1fuz8qb"&&(Y.textContent=kt),Pe=i(e),J=a(e,"H2",{class:!0});var lt=u(J);x=a(lt,"A",{id:!0,class:!0,href:!0});var Zt=u(x);Me=a(Zt,"SPAN",{});var Vt=u(Me);m(K.$$.fragment,Vt),Vt.forEach(t),Zt.forEach(t),ct=i(lt),ye=a(lt,"SPAN",{"data-svelte-h":!0}),h(ye)!=="svelte-g6vaho"&&(ye.textContent=It),lt.forEach(t),We=i(e),b=a(e,"H3",{class:!0});var at=u(b);B=a(at,"A",{id:!0,class:!0,href:!0});var Gt=u(B);Te=a(Gt,"SPAN",{});var Pt=u(Te);m(D.$$.fragment,Pt),Pt.forEach(t),Gt.forEach(t),ut=i(at),we=a(at,"SPAN",{"data-svelte-h":!0}),h(we)!=="svelte-w9jqzn"&&(we.textContent=$t),at.forEach(t),Re=i(e),O=a(e,"P",{"data-svelte-h":!0}),h(O)!=="svelte-vb47n8"&&(O.textContent=xt),ze=i(e),ee=a(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-n6itpg"&&(ee.innerHTML=Bt),Fe=i(e),C=a(e,"H3",{class:!0});var ot=u(C);_=a(ot,"A",{id:!0,class:!0,href:!0});var Wt=u(_);Je=a(Wt,"SPAN",{});var Rt=u(Je);m(te.$$.fragment,Rt),Rt.forEach(t),Wt.forEach(t),yt=i(ot),de=a(ot,"SPAN",{"data-svelte-h":!0}),h(de)!=="svelte-1kruf21"&&(de.textContent=_t),ot.forEach(t),Le=i(e),se=a(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-1h0ewze"&&(se.textContent=qt),Ye=i(e),ne=a(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-7kt80n"&&(ne.textContent=Nt),Ke=i(e),U=a(e,"H3",{class:!0});var it=u(U);q=a(it,"A",{id:!0,class:!0,href:!0});var zt=u(q);be=a(zt,"SPAN",{});var Ft=u(be);m(le.$$.fragment,Ft),Ft.forEach(t),zt.forEach(t),wt=i(it),me=a(it,"SPAN",{"data-svelte-h":!0}),h(me)!=="svelte-ql5090"&&(me.textContent=Et),it.forEach(t),De=i(e),ae=a(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1vr6kgq"&&(ae.textContent=At),Oe=i(e),oe=a(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-ime2kf"&&(oe.textContent=Qt),et=i(e),j=a(e,"H3",{class:!0});var rt=u(j);N=a(rt,"A",{id:!0,class:!0,href:!0});var Lt=u(N);Ce=a(Lt,"SPAN",{});var Yt=u(Ce);m(ie.$$.fragment,Yt),Yt.forEach(t),Lt.forEach(t),dt=i(rt),fe=a(rt,"SPAN",{"data-svelte-h":!0}),h(fe)!=="svelte-1rbh47g"&&(fe.textContent=St),rt.forEach(t),tt=i(e),re=a(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-hsmuqq"&&(re.innerHTML=Ht),st=i(e),Ue=a(e,"P",{}),u(Ue).forEach(t),this.h()},h(){r(c,"name","hf:doc:metadata"),r(c,"content",JSON.stringify(ps)),r(k,"id","using-pipelines-for-a-webserver"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#using-pipelines-for-a-webserver"),r(T,"class","relative group"),r(x,"id","few-things-you-might-want-to-consider"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#few-things-you-might-want-to-consider"),r(J,"class","relative group"),r(B,"id","error-checking"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#error-checking"),r(b,"class","relative group"),r(_,"id","circuit-breaking"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#circuit-breaking"),r(C,"class","relative group"),r(q,"id","blocking-the-main-thread"),r(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(q,"href","#blocking-the-main-thread"),r(U,"class","relative group"),r(N,"id","dynamic-batching"),r(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(N,"href","#dynamic-batching"),r(j,"class","relative group")},m(e,s){p(document.head,c),n(e,y,s),n(e,w,s),n(e,ce,s),n(e,T,s),p(T,k),p(k,ge),f(E,ge,null),p(T,ht),p(T,ue),n(e,ke,s),f(I,e,s),n(e,Ie,s),n(e,A,s),n(e,$e,s),n(e,Q,s),n(e,xe,s),n(e,S,s),n(e,Be,s),n(e,H,s),n(e,_e,s),f(X,e,s),n(e,qe,s),n(e,Z,s),n(e,Ne,s),f(V,e,s),n(e,Ee,s),n(e,G,s),n(e,Ae,s),f(P,e,s),n(e,Qe,s),n(e,W,s),n(e,Se,s),n(e,R,s),n(e,He,s),f($,e,s),n(e,Xe,s),f(z,e,s),n(e,Ze,s),n(e,F,s),n(e,Ve,s),n(e,L,s),n(e,Ge,s),n(e,Y,s),n(e,Pe,s),n(e,J,s),p(J,x),p(x,Me),f(K,Me,null),p(J,ct),p(J,ye),n(e,We,s),n(e,b,s),p(b,B),p(B,Te),f(D,Te,null),p(b,ut),p(b,we),n(e,Re,s),n(e,O,s),n(e,ze,s),n(e,ee,s),n(e,Fe,s),n(e,C,s),p(C,_),p(_,Je),f(te,Je,null),p(C,yt),p(C,de),n(e,Le,s),n(e,se,s),n(e,Ye,s),n(e,ne,s),n(e,Ke,s),n(e,U,s),p(U,q),p(q,be),f(le,be,null),p(U,wt),p(U,me),n(e,De,s),n(e,ae,s),n(e,Oe,s),n(e,oe,s),n(e,et,s),n(e,j,s),p(j,N),p(N,Ce),f(ie,Ce,null),p(j,dt),p(j,fe),n(e,tt,s),n(e,re,s),n(e,st,s),n(e,Ue,s),nt=!0},p(e,[s]){const pe={};s&2&&(pe.$$scope={dirty:s,ctx:e}),I.$set(pe);const je={};s&2&&(je.$$scope={dirty:s,ctx:e}),$.$set(je)},i(e){nt||(v(E.$$.fragment,e),v(I.$$.fragment,e),v(X.$$.fragment,e),v(V.$$.fragment,e),v(P.$$.fragment,e),v($.$$.fragment,e),v(z.$$.fragment,e),v(K.$$.fragment,e),v(D.$$.fragment,e),v(te.$$.fragment,e),v(le.$$.fragment,e),v(ie.$$.fragment,e),nt=!0)},o(e){g(E.$$.fragment,e),g(I.$$.fragment,e),g(X.$$.fragment,e),g(V.$$.fragment,e),g(P.$$.fragment,e),g($.$$.fragment,e),g(z.$$.fragment,e),g(K.$$.fragment,e),g(D.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(ie.$$.fragment,e),nt=!1},d(e){e&&(t(y),t(w),t(ce),t(T),t(ke),t(Ie),t(A),t($e),t(Q),t(xe),t(S),t(Be),t(H),t(_e),t(qe),t(Z),t(Ne),t(Ee),t(G),t(Ae),t(Qe),t(W),t(Se),t(R),t(He),t(Xe),t(Ze),t(F),t(Ve),t(L),t(Ge),t(Y),t(Pe),t(J),t(We),t(b),t(Re),t(O),t(ze),t(ee),t(Fe),t(C),t(Le),t(se),t(Ye),t(ne),t(Ke),t(U),t(De),t(ae),t(Oe),t(oe),t(et),t(j),t(tt),t(re),t(st),t(Ue)),t(c),M(E),M(I,e),M(X,e),M(V,e),M(P,e),M($,e),M(z,e),M(K),M(D),M(te),M(le),M(ie)}}}const ps={local:"using-pipelines-for-a-webserver",sections:[{local:"few-things-you-might-want-to-consider",sections:[{local:"error-checking",title:"Error checking"},{local:"circuit-breaking",title:"Circuit breaking"},{local:"blocking-the-main-thread",title:"Blocking the main thread"},{local:"dynamic-batching",title:"Dynamic batching"}],title:"Few things you might want to consider"}],title:"Using pipelines for a webserver"};function hs(he){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends ts{constructor(c){super(),ss(this,c,hs,rs,Dt,{})}}export{ms as component};
