import{s as Ll,o as Pl,n as Dl}from"../chunks/scheduler.9bc65507.js";import{S as Ol,i as Kl,g as l,s as i,u as d,A as tn,h as n,f as e,c as o,j as h,v as M,y as p,k as r,o as c,a,w as u,d as g,t as y,x as f,m as en,n as sn}from"../chunks/index.78c82d43.js";import{T as va}from"../chunks/Tip.87d55b76.js";import{I as T}from"../chunks/IconCopyLink.bedaa44d.js";import{C as J}from"../chunks/CodeBlock.73e038be.js";import{D as an}from"../chunks/DocNotebookDropdown.31840a23.js";function ln(W){let m;return{c(){m=en("To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},l(j){m=sn(j,"To run the following examples with a non-quantized version of the model checkpoint you will need at least 20GB of GPU memory.")},m(j,w){a(j,m,w)},d(j){j&&e(m)}}}function nn(W){let m,j=`It is a good idea to include the <code>bad_words_ids</code> in the call to <code>generate</code> to avoid errors arising when increasing
the <code>max_new_tokens</code>: the model will want to generate a new <code>&lt;image&gt;</code> or <code>&lt;fake_token_around_image&gt;</code> token when there
is no image being generated by the model.
You can set it on-the-fly as in this guide, or store in the <code>GenerationConfig</code> as described in the <a href="../generation_strategies">Text generation strategies</a> guide.`;return{c(){m=l("p"),m.innerHTML=j},l(w){m=n(w,"P",{"data-svelte-h":!0}),p(m)!=="svelte-uwc51d"&&(m.innerHTML=j)},m(w,G){a(w,m,G)},p:Dl,d(w){w&&e(m)}}}function on(W){let m,j=`For longer outputs like this, you will greatly benefit from tweaking the text generation strategy. This can help
you significantly improve the quality of the generated output. Check out <a href="../generation_strategies">Text generation strategies</a>
to learn more.`;return{c(){m=l("p"),m.innerHTML=j},l(w){m=n(w,"P",{"data-svelte-h":!0}),p(m)!=="svelte-79vr3a"&&(m.innerHTML=j)},m(w,G){a(w,m,G)},p:Dl,d(w){w&&e(m)}}}function pn(W){let m,j,w,G,U,z,be,st,Ma,de,Za="Image tasks with IDEFICS",Be,at,He,lt,Ia=`While individual tasks can be tackled by fine-tuning specialized models, an alternative approach
that has recently emerged and gained popularity is to use large models for a diverse set of tasks without fine-tuning.
For instance, large language models can handle such NLP tasks as summarization, translation, classification, and more.
This approach is no longer limited to a single modality, such as text, and in this guide, we will illustrate how you can
solve image-text tasks with a large multimodal model called IDEFICS.`,Ee,nt,ka=`<a href="../model_doc/idefics">IDEFICS</a> is an open-access vision and language model based on <a href="https://huggingface.co/papers/2204.14198" rel="nofollow">Flamingo</a>,
a state-of-the-art visual language model initially developed by DeepMind. The model accepts arbitrary sequences of image
and text inputs and generates coherent text as output. It can answer questions about images, describe visual content,
create stories grounded in multiple images, and so on. IDEFICS comes in two variants - <a href="https://huggingface.co/HuggingFaceM4/idefics-80b" rel="nofollow">80 billion parameters</a>
and <a href="https://huggingface.co/HuggingFaceM4/idefics-9b" rel="nofollow">9 billion parameters</a>, both of which are available on the 🤗 Hub. For each variant, you can also find fine-tuned instructed
versions of the model adapted for conversational use cases.`,Ve,it,Ca=`This model is exceptionally versatile and can be used for a wide range of image and multimodal tasks. However,
being a large model means it requires significant computational resources and infrastructure. It is up to you to decide whether
this approach suits your use case better than fine-tuning specialized models for each individual task.`,Xe,ot,xa="In this guide, you’ll learn how to:",Fe,pt,Ra='<li><a href="#loading-the-model">Load IDEFICS</a> and <a href="#loading-the-quantized-version-of-the-model">load the quantized version of the model</a></li> <li>Use IDEFICS for: <ul><li><a href="#image-captioning">Image captioning</a></li> <li><a href="#prompted-image-captioning">Prompted image captioning</a></li> <li><a href="#few-shot-prompting">Few-shot prompting</a></li> <li><a href="#visual-question-answering">Visual question answering</a></li> <li><a href="#image-classification">Image classificaiton</a></li> <li><a href="#image-guided-text-generation">Image-guided text generation</a></li></ul></li> <li><a href="#running-inference-in-batch-mode">Run inference in batch mode</a></li> <li><a href="#idefics-instruct-for-conversational-use">Run IDEFICS instruct for conversational use</a></li>',Ae,rt,_a="Before you begin, make sure you have all the necessary libraries installed.",$e,ct,Ye,Q,Se,b,B,ve,ht,ua,Me,Na="Loading the model",qe,mt,Wa="Let’s start by loading the model’s 9 billion parameters checkpoint:",De,dt,Le,Mt,Ga=`Just like for other Transformers models, you need to load a processor and the model itself from the checkpoint.
The IDEFICS processor wraps a <a href="/docs/transformers/v4.34.0/en/model_doc/llama2#transformers.LlamaTokenizer">LlamaTokenizer</a> and IDEFICS image processor into a single processor to take care of
preparing text and image inputs for the model.`,Pe,ut,Oe,gt,za=`Setting <code>device_map</code> to <code>&quot;auto&quot;</code> will automatically determine how to load and store the model weights in the most optimized
manner given existing devices.`,Ke,v,H,Ze,yt,ga,ue,Qa="Quantized model",ts,ft,Ba=`If high-memory GPU availability is an issue, you can load the quantized version of the model. To load the model and the
processor in 4bit precision, pass a <code>BitsAndBytesConfig</code> to the <code>from_pretrained</code> method and the model will be compressed
on the fly while loading.`,es,wt,ss,jt,Ha="Now that you have the model loaded in one of the suggested ways, let’s move on to exploring tasks that you can use IDEFICS for.",as,Z,E,Ie,Jt,ya,ge,Ea="Image captioning",ls,Tt,Va=`Image captioning is the task of predicting a caption for a given image. A common application is to aid visually impaired
people navigate through different situations, for instance, explore image content online.`,ns,Ut,Xa="To illustrate the task, get an image to be captioned, e.g.:",is,V,Fa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-im-captioning.jpg" alt="Image of a puppy in a flower bed"/>',os,bt,Aa='Photo by <a href="https://unsplash.com/@hendoo" rel="nofollow">Hendo Wang</a>.',ps,vt,$a=`IDEFICS accepts text and image prompts. However, to caption an image, you do not have to provide a text prompt to the
model, only the preprocessed input image. Without a text prompt, the model will start generating text from the
BOS (beginning-of-sequence) token thus creating a caption.`,rs,Zt,Ya="As image input to the model, you can use either an image object (<code>PIL.Image</code>) or a url from which the image can be retrieved.",cs,It,hs,X,ms,I,F,ke,kt,fa,ye,Sa="Prompted image captioning",ds,Ct,qa=`You can extend image captioning by providing a text prompt, which the model will continue given the image. Let’s take
another image to illustrate:`,Ms,A,Da='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-prompted-im-captioning.jpg" alt="Image of the Eiffel Tower at night"/>',us,xt,La='Photo by <a href="https://unsplash.com/@dnevozhai" rel="nofollow">Denys Nevozhai</a>.',gs,Rt,Pa="Textual and image prompts can be passed to the model’s processor as a single list to create appropriate inputs.",ys,_t,fs,k,$,Ce,Nt,wa,fe,Oa="Few-shot prompting",ws,Wt,Ka=`While IDEFICS demonstrates great zero-shot results, your task may require a certain format of the caption, or come with
other restrictions or requirements that increase task’s complexity. Few-shot prompting can be used to enable in-context learning.
By providing examples in the prompt, you can steer the model to generate results that mimic the format of given examples.`,js,Gt,tl=`Let’s use the previous image of the Eiffel Tower as an example for the model and build a prompt that demonstrates to the model
that in addition to learning what the object in an image is, we would also like to get some interesting information about it.
Then, let’s see, if we can get the same response format for an image of the Statue of Liberty:`,Js,Y,el='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-few-shot.jpg" alt="Image of the Statue of Liberty"/>',Ts,zt,sl='Photo by <a href="https://unsplash.com/@jmayobres" rel="nofollow">Juan Mayobre</a>.',Us,Qt,bs,Bt,al=`Notice that just from a single example (i.e., 1-shot) the model has learned how to perform the task. For more complex tasks,
feel free to experiment with a larger number of examples (e.g., 3-shot, 5-shot, etc.).`,vs,C,S,xe,Ht,ja,we,ll="Visual question answering",Zs,Et,nl=`Visual Question Answering (VQA) is the task of answering open-ended questions based on an image. Similar to image
captioning it can be used in accessibility applications, but also in education (reasoning about visual materials), customer
service (questions about products based on images), and image retrieval.`,Is,Vt,il="Let’s get a new image for this task:",ks,q,ol='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-vqa.jpg" alt="Image of a couple having a picnic"/>',Cs,Xt,pl='Photo by <a href="https://unsplash.com/@jarritos" rel="nofollow">Jarritos Mexican Soda</a>.',xs,Ft,rl="You can steer the model from image captioning to visual question answering by prompting it with appropriate instructions:",Rs,At,_s,x,D,Re,$t,Ja,je,cl="Image classification",Ns,Yt,hl=`IDEFICS is capable of classifying images into different categories without being explicitly trained on data containing
labeled examples from those specific categories. Given a list of categories and using its image and text understanding
capabilities, the model can infer which category the image likely belongs to.`,Ws,St,ml="Say, we have this image of a vegetable stand:",Gs,L,dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-classification.jpg" alt="Image of a vegetable stand"/>',zs,qt,Ml='Photo by <a href="https://unsplash.com/@peterwendt" rel="nofollow">Peter Wendt</a>.',Qs,Dt,ul="We can instruct the model to classify the image into one of the categories that we have:",Bs,Lt,Hs,Pt,gl="In the example above we instruct the model to classify the image into a single category, however, you can also prompt the model to do rank classification.",Es,R,P,_e,Ot,Ta,Je,yl="Image-guided text generation",Vs,Kt,fl=`For more creative applications, you can use image-guided text generation to generate text based on an image. This can be
useful to create descriptions of products, ads, descriptions of a scene, etc.`,Xs,te,wl="Let’s prompt IDEFICS to write a story based on a simple image of a red door:",Fs,O,jl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/idefics-story-generation.jpg" alt="Image of a red door with a pumpkin on the steps"/>',As,ee,Jl='Photo by <a href="https://unsplash.com/@devonshiremedia" rel="nofollow">Craig Tidball</a>.',$s,se,Ys,ae,Tl="Looks like IDEFICS noticed the pumpkin on the doorstep and went with a spooky Halloween story about a ghost.",Ss,K,qs,_,tt,Ne,le,Ua,Te,Ul="Running inference in batch mode",Ds,ne,bl=`All of the earlier sections illustrated IDEFICS for a single example. In a very similar fashion, you can run inference
for a batch of examples by passing a list of prompts:`,Ls,ie,Ps,N,et,We,oe,ba,Ue,vl="IDEFICS instruct for conversational use",Os,pe,Zl=`For conversational use cases, you can find fine-tuned instructed versions of the model on the 🤗 Hub:
<code>HuggingFaceM4/idefics-80b-instruct</code> and <code>HuggingFaceM4/idefics-9b-instruct</code>.`,Ks,re,Il=`These checkpoints are the result of fine-tuning the respective base models on a mixture of supervised and instruction
fine-tuning datasets, which boosts the downstream performance while making the models more usable in conversational settings.`,ta,ce,kl="The use and prompting for the conversational use is very similar to using the base models:",ea,he,sa,Ge,aa;return st=new T({}),at=new an({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/idefics.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/idefics.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/idefics.ipynb"}]}}),ct=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwYml0c2FuZGJ5dGVzJTIwc2VudGVuY2VwaWVjZSUyMGFjY2VsZXJhdGUlMjB0cmFuc2Zvcm1lcnM=",highlighted:"pip install -q bitsandbytes sentencepiece accelerate transformers",wrap:!1}}),Q=new va({props:{$$slots:{default:[ln]},$$scope:{ctx:W}}}),ht=new T({}),dt=new J({props:{code:"Y2hlY2twb2ludCUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlTTQlMkZpZGVmaWNzLTliJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b&quot;</span>',wrap:!1}}),ut=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),yt=new T({}),wt=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dCUyQyUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQW1vZGVsJTIwJTNEJTIwSWRlZmljc0ZvclZpc2lvblRleHQyVGV4dC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor, BitsAndBytesConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>quantization_config = BitsAndBytesConfig(
<span class="hljs-meta">... </span>    load_in_4bit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    bnb_4bit_compute_dtype=torch.float16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    quantization_config=quantization_config,
<span class="hljs-meta">... </span>    device_map=<span class="hljs-string">&quot;auto&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Jt=new T({}),It=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU4MzE2MDI0NzcxMS0yMTkxNzc2YjRiOTElM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzU0MiUyNnElM0Q4MCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1583160247711-2191776b4b91?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3542&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
A puppy <span class="hljs-keyword">in</span> a flower bed`,wrap:!1}}),X=new va({props:{$$slots:{default:[nn]},$$scope:{ctx:W}}}),kt=new T({}),_t=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZpbWFnZXMudW5zcGxhc2guY29tJTJGcGhvdG8tMTU0MzM0OTY4OS05YTRkNDI2YmVlOGUlM0ZpeGxpYiUzRHJiLTQuMC4zJTI2aXhpZCUzRE0zd3hNakEzZkRCOE1IeHdhRzkwYnkxd1lXZGxmSHg4ZkdWdWZEQjhmSHg4ZkElMjUzRCUyNTNEJTI2YXV0byUzRGZvcm1hdCUyNmZpdCUzRGNyb3AlMjZ3JTNEMzUwMSUyNnElM0Q4MCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBpcyUyMGFuJTIwaW1hZ2UlMjBvZiUyMCUyMiUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.`,wrap:!1}}),Nt=new T({}),Qt=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1NDMzNDk2ODktOWE0ZDQyNmJlZThlJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1MDElMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIwQW4lMjBpbWFnZSUyMG9mJTIwdGhlJTIwRWlmZmVsJTIwVG93ZXIlMjBhdCUyMG5pZ2h0LiUyMEZ1biUyMGZhY3QlM0ElMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMGlzJTIwdGhlJTIwc2FtZSUyMGhlaWdodCUyMGFzJTIwYW4lMjA4MS1zdG9yZXklMjBidWlsZGluZy4lNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXNlciUzQSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MjQwOTkxNjMyNTMtMzJiN2YwMjU2ODY4JTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDMzODclMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEZXNjcmliZSUyMHRoaXMlMjBpbWFnZS4lNUNuQXNzaXN0YW50JTNBJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIoJTVCJTIyJTNDaW1hZ2UlM0UlMjIlMkMlMjAlMjIlM0NmYWtlX3Rva2VuX2Fyb3VuZF9pbWFnZSUzRSUyMiU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower is the same height as an 81-storey building.\\n&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;User:&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;https://images.unsplash.com/photo-1524099163253-32b7f0256868?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3387&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>           <span class="hljs-string">&quot;Describe this image.\\nAssistant:&quot;</span>
<span class="hljs-meta">... </span>           ]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
User: Describe this image.
Assistant: An image of the Eiffel Tower at night. Fun fact: the Eiffel Tower <span class="hljs-keyword">is</span> the same height <span class="hljs-keyword">as</span> an <span class="hljs-number">81</span>-storey building. 
User: Describe this image.
Assistant: An image of the Statue of Liberty. Fun fact: the Statue of Liberty <span class="hljs-keyword">is</span> <span class="hljs-number">151</span> feet tall.`,wrap:!1}}),Ht=new T({}),At=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIySW5zdHJ1Y3Rpb24lM0ElMjBQcm92aWRlJTIwYW4lMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUyMFVzZSUyMHRoZSUyMGltYWdlJTIwdG8lMjBhbnN3ZXIuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE2MjM5NDQ4ODkyODgtY2QxNDdkYmI1MTdjJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJRdWVzdGlvbiUzQSUyMFdoZXJlJTIwYXJlJTIwdGhlc2UlMjBwZW9wbGUlMjBhbmQlMjB3aGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwbGlrZSUzRiUyMEFuc3dlciUzQSUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Instruction: Provide an answer to the question. Use the image to answer.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Question: Where are these people and what&#x27;s the weather like? Answer:&quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Provide an answer to the question. Use the image to answer.
 Question: Where are these people <span class="hljs-keyword">and</span> what<span class="hljs-string">&#x27;s the weather like? Answer: They&#x27;</span>re <span class="hljs-keyword">in</span> a park <span class="hljs-keyword">in</span> New York City, <span class="hljs-keyword">and</span> it<span class="hljs-string">&#x27;s a beautiful day.</span>`,wrap:!1}}),$t=new T({}),Lt=new J({props:{code:"Y2F0ZWdvcmllcyUyMCUzRCUyMCU1QidhbmltYWxzJyUyQyd2ZWdldGFibGVzJyUyQyUyMCdjaXR5JTIwbGFuZHNjYXBlJyUyQyUyMCdjYXJzJyUyQyUyMCdvZmZpY2UnJTVEJTBBcHJvbXB0JTIwJTNEJTIwJTVCZiUyMkluc3RydWN0aW9uJTNBJTIwQ2xhc3NpZnklMjB0aGUlMjBmb2xsb3dpbmclMjBpbWFnZSUyMGludG8lMjBhJTIwc2luZ2xlJTIwY2F0ZWdvcnklMjBmcm9tJTIwdGhlJTIwZm9sbG93aW5nJTIwbGlzdCUzQSUyMCU3QmNhdGVnb3JpZXMlN0QuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE0NzExOTM5NDU1MDktOWFkMDYxN2FmYWJmJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDM1NDAlMjZxJTNEODAlMjIlMkMlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjJDYXRlZ29yeSUzQSUyMCUyMiUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQWJhZF93b3Jkc19pZHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyKCU1QiUyMiUzQ2ltYWdlJTNFJTIyJTJDJTIwJTIyJTNDZmFrZV90b2tlbl9hcm91bmRfaW1hZ2UlM0UlMjIlNUQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSkuaW5wdXRfaWRzJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q0JTJDJTIwYmFkX3dvcmRzX2lkcyUzRGJhZF93b3Jkc19pZHMpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0ZWRfdGV4dCU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>categories = [<span class="hljs-string">&#x27;animals&#x27;</span>,<span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">f&quot;Instruction: Classify the following image into a single category from the following list: <span class="hljs-subst">{categories}</span>.\\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,    
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Category: &quot;</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">4</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>])
Instruction: Classify the following image into a single category <span class="hljs-keyword">from</span> the following <span class="hljs-built_in">list</span>: [<span class="hljs-string">&#x27;animals&#x27;</span>, <span class="hljs-string">&#x27;vegetables&#x27;</span>, <span class="hljs-string">&#x27;city landscape&#x27;</span>, <span class="hljs-string">&#x27;cars&#x27;</span>, <span class="hljs-string">&#x27;office&#x27;</span>].
Category: Vegetables`,wrap:!1}}),Ot=new T({}),se=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTVCJTIySW5zdHJ1Y3Rpb24lM0ElMjBVc2UlMjB0aGUlMjBpbWFnZSUyMHRvJTIwd3JpdGUlMjBhJTIwc3RvcnkuJTIwJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaW1hZ2VzLnVuc3BsYXNoLmNvbSUyRnBob3RvLTE1MTcwODY4MjIxNTctMmIwMzU4ZTc2ODRhJTNGaXhsaWIlM0RyYi00LjAuMyUyNml4aWQlM0RNM3d4TWpBM2ZEQjhNSHh3YUc5MGJ5MXdZV2RsZkh4OGZHVnVmREI4Zkh4OGZBJTI1M0QlMjUzRCUyNmF1dG8lM0Rmb3JtYXQlMjZmaXQlM0Rjcm9wJTI2dyUzRDIyMDMlMjZxJTNEODAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdG9yeSUzQSUyMCU1Q24lMjIlNUQlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFiYWRfd29yZHNfaWRzJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplciglNUIlMjIlM0NpbWFnZSUzRSUyMiUyQyUyMCUyMiUzQ2Zha2VfdG9rZW5fYXJvdW5kX2ltYWdlJTNFJTIyJTVEJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLmlucHV0X2lkcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG51bV9iZWFtcyUzRDIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUyMGJhZF93b3Jkc19pZHMlM0RiYWRfd29yZHNfaWRzKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZ2VuZXJhdGVkX3RleHQlNUIwJTVEKSUyMCUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;Instruction: Use the image to write a story. \\n&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://images.unsplash.com/photo-1517086822157-2b0358e7684a?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=2203&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Story: \\n&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, num_beams=<span class="hljs-number">2</span>, max_new_tokens=<span class="hljs-number">200</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text[<span class="hljs-number">0</span>]) 
Instruction: Use the image to write a story. 
 Story: 
Once upon a time, there was a little girl who lived <span class="hljs-keyword">in</span> a house <span class="hljs-keyword">with</span> a red door.  She loved her red door.  It was the prettiest door <span class="hljs-keyword">in</span> the whole world.

One day, the little girl was playing <span class="hljs-keyword">in</span> her yard when she noticed a man standing on her doorstep.  He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran inside <span class="hljs-keyword">and</span> told her mother about the man.

Her mother said, “Don’t worry, honey.  He’s just a friendly ghost.”

The little girl wasn’t sure <span class="hljs-keyword">if</span> she believed her mother, but she went outside anyway.

When she got to the door, the man was gone.

The <span class="hljs-built_in">next</span> day, the little girl was playing <span class="hljs-keyword">in</span> her yard again when she noticed the man standing on her doorstep.

He was wearing a long black coat <span class="hljs-keyword">and</span> a top hat.

The little girl ran`,wrap:!1}}),K=new va({props:{$$slots:{default:[on]},$$scope:{ctx:W}}}),le=new T({}),ie=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1543349689-9a4d426bee8e?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3501&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1623944889288-cd147dbb517c?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    [   <span class="hljs-string">&quot;https://images.unsplash.com/photo-1471193945509-9ad0617afabf?ixlib=rb-4.0.3&amp;ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&amp;auto=format&amp;fit=crop&amp;w=3540&amp;q=80&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is an image of &quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, bad_words_ids=bad_words_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i,t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>) 
<span class="hljs-number">0</span>:
This <span class="hljs-keyword">is</span> an image of the Eiffel Tower <span class="hljs-keyword">in</span> Paris, France.

<span class="hljs-number">1</span>:
This <span class="hljs-keyword">is</span> an image of a couple on a picnic blanket.

<span class="hljs-number">2</span>:
This <span class="hljs-keyword">is</span> an image of a vegetable stand.`,wrap:!1}}),oe=new T({}),he=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> IdeficsForVisionText2Text, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;HuggingFaceM4/idefics-9b-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = IdeficsForVisionText2Text.from_pretrained(checkpoint, torch_dtype=torch.bfloat16).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;User: What is in this image?&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/8/86/Id%C3%A9fix.JPG&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant: This picture depicts Idefix, the dog of Obelix in Asterix and Obelix. Idefix is running on the ground.&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nUser:&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;https://static.wikia.nocookie.net/asterix/images/2/25/R22b.gif/revision/latest?cb=20110815073052&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;And who is that?&lt;end_of_utterance&gt;&quot;</span>,

<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\\nAssistant:&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --batched mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(prompts, add_end_of_utterance_token=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># --single sample mode</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inputs = processor(prompts[0], return_tensors=&quot;pt&quot;).to(device)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation args</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>exit_condition = processor.tokenizer(<span class="hljs-string">&quot;&lt;end_of_utterance&gt;&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = processor.tokenizer([<span class="hljs-string">&quot;&lt;image&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;fake_token_around_image&gt;&quot;</span>], add_special_tokens=<span class="hljs-literal">False</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, eos_token_id=exit_condition, bad_words_ids=bad_words_ids, max_length=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(generated_text):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{i}</span>:\\n<span class="hljs-subst">{t}</span>\\n&quot;</span>)`,wrap:!1}}),{c(){m=l("meta"),j=i(),w=l("p"),G=i(),U=l("h1"),z=l("a"),be=l("span"),d(st.$$.fragment),Ma=i(),de=l("span"),de.textContent=Za,Be=i(),d(at.$$.fragment),He=i(),lt=l("p"),lt.textContent=Ia,Ee=i(),nt=l("p"),nt.innerHTML=ka,Ve=i(),it=l("p"),it.textContent=Ca,Xe=i(),ot=l("p"),ot.textContent=xa,Fe=i(),pt=l("ul"),pt.innerHTML=Ra,Ae=i(),rt=l("p"),rt.textContent=_a,$e=i(),d(ct.$$.fragment),Ye=i(),d(Q.$$.fragment),Se=i(),b=l("h2"),B=l("a"),ve=l("span"),d(ht.$$.fragment),ua=i(),Me=l("span"),Me.textContent=Na,qe=i(),mt=l("p"),mt.textContent=Wa,De=i(),d(dt.$$.fragment),Le=i(),Mt=l("p"),Mt.innerHTML=Ga,Pe=i(),d(ut.$$.fragment),Oe=i(),gt=l("p"),gt.innerHTML=za,Ke=i(),v=l("h3"),H=l("a"),Ze=l("span"),d(yt.$$.fragment),ga=i(),ue=l("span"),ue.textContent=Qa,ts=i(),ft=l("p"),ft.innerHTML=Ba,es=i(),d(wt.$$.fragment),ss=i(),jt=l("p"),jt.textContent=Ha,as=i(),Z=l("h2"),E=l("a"),Ie=l("span"),d(Jt.$$.fragment),ya=i(),ge=l("span"),ge.textContent=Ea,ls=i(),Tt=l("p"),Tt.textContent=Va,ns=i(),Ut=l("p"),Ut.textContent=Xa,is=i(),V=l("div"),V.innerHTML=Fa,os=i(),bt=l("p"),bt.innerHTML=Aa,ps=i(),vt=l("p"),vt.textContent=$a,rs=i(),Zt=l("p"),Zt.innerHTML=Ya,cs=i(),d(It.$$.fragment),hs=i(),d(X.$$.fragment),ms=i(),I=l("h2"),F=l("a"),ke=l("span"),d(kt.$$.fragment),fa=i(),ye=l("span"),ye.textContent=Sa,ds=i(),Ct=l("p"),Ct.textContent=qa,Ms=i(),A=l("div"),A.innerHTML=Da,us=i(),xt=l("p"),xt.innerHTML=La,gs=i(),Rt=l("p"),Rt.textContent=Pa,ys=i(),d(_t.$$.fragment),fs=i(),k=l("h2"),$=l("a"),Ce=l("span"),d(Nt.$$.fragment),wa=i(),fe=l("span"),fe.textContent=Oa,ws=i(),Wt=l("p"),Wt.textContent=Ka,js=i(),Gt=l("p"),Gt.textContent=tl,Js=i(),Y=l("div"),Y.innerHTML=el,Ts=i(),zt=l("p"),zt.innerHTML=sl,Us=i(),d(Qt.$$.fragment),bs=i(),Bt=l("p"),Bt.textContent=al,vs=i(),C=l("h2"),S=l("a"),xe=l("span"),d(Ht.$$.fragment),ja=i(),we=l("span"),we.textContent=ll,Zs=i(),Et=l("p"),Et.textContent=nl,Is=i(),Vt=l("p"),Vt.textContent=il,ks=i(),q=l("div"),q.innerHTML=ol,Cs=i(),Xt=l("p"),Xt.innerHTML=pl,xs=i(),Ft=l("p"),Ft.textContent=rl,Rs=i(),d(At.$$.fragment),_s=i(),x=l("h2"),D=l("a"),Re=l("span"),d($t.$$.fragment),Ja=i(),je=l("span"),je.textContent=cl,Ns=i(),Yt=l("p"),Yt.textContent=hl,Ws=i(),St=l("p"),St.textContent=ml,Gs=i(),L=l("div"),L.innerHTML=dl,zs=i(),qt=l("p"),qt.innerHTML=Ml,Qs=i(),Dt=l("p"),Dt.textContent=ul,Bs=i(),d(Lt.$$.fragment),Hs=i(),Pt=l("p"),Pt.textContent=gl,Es=i(),R=l("h2"),P=l("a"),_e=l("span"),d(Ot.$$.fragment),Ta=i(),Je=l("span"),Je.textContent=yl,Vs=i(),Kt=l("p"),Kt.textContent=fl,Xs=i(),te=l("p"),te.textContent=wl,Fs=i(),O=l("div"),O.innerHTML=jl,As=i(),ee=l("p"),ee.innerHTML=Jl,$s=i(),d(se.$$.fragment),Ys=i(),ae=l("p"),ae.textContent=Tl,Ss=i(),d(K.$$.fragment),qs=i(),_=l("h2"),tt=l("a"),Ne=l("span"),d(le.$$.fragment),Ua=i(),Te=l("span"),Te.textContent=Ul,Ds=i(),ne=l("p"),ne.textContent=bl,Ls=i(),d(ie.$$.fragment),Ps=i(),N=l("h2"),et=l("a"),We=l("span"),d(oe.$$.fragment),ba=i(),Ue=l("span"),Ue.textContent=vl,Os=i(),pe=l("p"),pe.innerHTML=Zl,Ks=i(),re=l("p"),re.textContent=Il,ta=i(),ce=l("p"),ce.textContent=kl,ea=i(),d(he.$$.fragment),sa=i(),Ge=l("p"),this.h()},l(t){const s=tn("svelte-1phssyn",document.head);m=n(s,"META",{name:!0,content:!0}),s.forEach(e),j=o(t),w=n(t,"P",{}),h(w).forEach(e),G=o(t),U=n(t,"H1",{class:!0});var me=h(U);z=n(me,"A",{id:!0,class:!0,href:!0});var ze=h(z);be=n(ze,"SPAN",{});var Qe=h(be);M(st.$$.fragment,Qe),Qe.forEach(e),ze.forEach(e),Ma=o(me),de=n(me,"SPAN",{"data-svelte-h":!0}),p(de)!=="svelte-1alwpo7"&&(de.textContent=Za),me.forEach(e),Be=o(t),M(at.$$.fragment,t),He=o(t),lt=n(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-11wnsr"&&(lt.textContent=Ia),Ee=o(t),nt=n(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-1nt7nk6"&&(nt.innerHTML=ka),Ve=o(t),it=n(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1k5g1sg"&&(it.textContent=Ca),Xe=o(t),ot=n(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-fp1hdi"&&(ot.textContent=xa),Fe=o(t),pt=n(t,"UL",{"data-svelte-h":!0}),p(pt)!=="svelte-187zpo0"&&(pt.innerHTML=Ra),Ae=o(t),rt=n(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-qn4ey1"&&(rt.textContent=_a),$e=o(t),M(ct.$$.fragment,t),Ye=o(t),M(Q.$$.fragment,t),Se=o(t),b=n(t,"H2",{class:!0});var la=h(b);B=n(la,"A",{id:!0,class:!0,href:!0});var Cl=h(B);ve=n(Cl,"SPAN",{});var xl=h(ve);M(ht.$$.fragment,xl),xl.forEach(e),Cl.forEach(e),ua=o(la),Me=n(la,"SPAN",{"data-svelte-h":!0}),p(Me)!=="svelte-5o4h2t"&&(Me.textContent=Na),la.forEach(e),qe=o(t),mt=n(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-pbsmkm"&&(mt.textContent=Wa),De=o(t),M(dt.$$.fragment,t),Le=o(t),Mt=n(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-g97fg1"&&(Mt.innerHTML=Ga),Pe=o(t),M(ut.$$.fragment,t),Oe=o(t),gt=n(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-10jwul3"&&(gt.innerHTML=za),Ke=o(t),v=n(t,"H3",{class:!0});var na=h(v);H=n(na,"A",{id:!0,class:!0,href:!0});var Rl=h(H);Ze=n(Rl,"SPAN",{});var _l=h(Ze);M(yt.$$.fragment,_l),_l.forEach(e),Rl.forEach(e),ga=o(na),ue=n(na,"SPAN",{"data-svelte-h":!0}),p(ue)!=="svelte-g72wsb"&&(ue.textContent=Qa),na.forEach(e),ts=o(t),ft=n(t,"P",{"data-svelte-h":!0}),p(ft)!=="svelte-gb566o"&&(ft.innerHTML=Ba),es=o(t),M(wt.$$.fragment,t),ss=o(t),jt=n(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-vovwl0"&&(jt.textContent=Ha),as=o(t),Z=n(t,"H2",{class:!0});var ia=h(Z);E=n(ia,"A",{id:!0,class:!0,href:!0});var Nl=h(E);Ie=n(Nl,"SPAN",{});var Wl=h(Ie);M(Jt.$$.fragment,Wl),Wl.forEach(e),Nl.forEach(e),ya=o(ia),ge=n(ia,"SPAN",{"data-svelte-h":!0}),p(ge)!=="svelte-1uwawv2"&&(ge.textContent=Ea),ia.forEach(e),ls=o(t),Tt=n(t,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-195xyco"&&(Tt.textContent=Va),ns=o(t),Ut=n(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-syqfn9"&&(Ut.textContent=Xa),is=o(t),V=n(t,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-t8y7db"&&(V.innerHTML=Fa),os=o(t),bt=n(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-knozkn"&&(bt.innerHTML=Aa),ps=o(t),vt=n(t,"P",{"data-svelte-h":!0}),p(vt)!=="svelte-10bztc1"&&(vt.textContent=$a),rs=o(t),Zt=n(t,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-sk4o55"&&(Zt.innerHTML=Ya),cs=o(t),M(It.$$.fragment,t),hs=o(t),M(X.$$.fragment,t),ms=o(t),I=n(t,"H2",{class:!0});var oa=h(I);F=n(oa,"A",{id:!0,class:!0,href:!0});var Gl=h(F);ke=n(Gl,"SPAN",{});var zl=h(ke);M(kt.$$.fragment,zl),zl.forEach(e),Gl.forEach(e),fa=o(oa),ye=n(oa,"SPAN",{"data-svelte-h":!0}),p(ye)!=="svelte-1mu97bv"&&(ye.textContent=Sa),oa.forEach(e),ds=o(t),Ct=n(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-15l3yis"&&(Ct.textContent=qa),Ms=o(t),A=n(t,"DIV",{class:!0,"data-svelte-h":!0}),p(A)!=="svelte-1ritb1k"&&(A.innerHTML=Da),us=o(t),xt=n(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-1uz68x8"&&(xt.innerHTML=La),gs=o(t),Rt=n(t,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-cncrxa"&&(Rt.textContent=Pa),ys=o(t),M(_t.$$.fragment,t),fs=o(t),k=n(t,"H2",{class:!0});var pa=h(k);$=n(pa,"A",{id:!0,class:!0,href:!0});var Ql=h($);Ce=n(Ql,"SPAN",{});var Bl=h(Ce);M(Nt.$$.fragment,Bl),Bl.forEach(e),Ql.forEach(e),wa=o(pa),fe=n(pa,"SPAN",{"data-svelte-h":!0}),p(fe)!=="svelte-5vdttc"&&(fe.textContent=Oa),pa.forEach(e),ws=o(t),Wt=n(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-fytdtn"&&(Wt.textContent=Ka),js=o(t),Gt=n(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-148v07a"&&(Gt.textContent=tl),Js=o(t),Y=n(t,"DIV",{class:!0,"data-svelte-h":!0}),p(Y)!=="svelte-gin1vp"&&(Y.innerHTML=el),Ts=o(t),zt=n(t,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-s7b8dy"&&(zt.innerHTML=sl),Us=o(t),M(Qt.$$.fragment,t),bs=o(t),Bt=n(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-mpygyg"&&(Bt.textContent=al),vs=o(t),C=n(t,"H2",{class:!0});var ra=h(C);S=n(ra,"A",{id:!0,class:!0,href:!0});var Hl=h(S);xe=n(Hl,"SPAN",{});var El=h(xe);M(Ht.$$.fragment,El),El.forEach(e),Hl.forEach(e),ja=o(ra),we=n(ra,"SPAN",{"data-svelte-h":!0}),p(we)!=="svelte-pidp3l"&&(we.textContent=ll),ra.forEach(e),Zs=o(t),Et=n(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-cnfg69"&&(Et.textContent=nl),Is=o(t),Vt=n(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-nptt59"&&(Vt.textContent=il),ks=o(t),q=n(t,"DIV",{class:!0,"data-svelte-h":!0}),p(q)!=="svelte-1j2xr8e"&&(q.innerHTML=ol),Cs=o(t),Xt=n(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-1a68h7f"&&(Xt.innerHTML=pl),xs=o(t),Ft=n(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-tdtrto"&&(Ft.textContent=rl),Rs=o(t),M(At.$$.fragment,t),_s=o(t),x=n(t,"H2",{class:!0});var ca=h(x);D=n(ca,"A",{id:!0,class:!0,href:!0});var Vl=h(D);Re=n(Vl,"SPAN",{});var Xl=h(Re);M($t.$$.fragment,Xl),Xl.forEach(e),Vl.forEach(e),Ja=o(ca),je=n(ca,"SPAN",{"data-svelte-h":!0}),p(je)!=="svelte-1cn7k7s"&&(je.textContent=cl),ca.forEach(e),Ns=o(t),Yt=n(t,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-a4cfdv"&&(Yt.textContent=hl),Ws=o(t),St=n(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1xbkffx"&&(St.textContent=ml),Gs=o(t),L=n(t,"DIV",{class:!0,"data-svelte-h":!0}),p(L)!=="svelte-g02ga3"&&(L.innerHTML=dl),zs=o(t),qt=n(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-17q4ltv"&&(qt.innerHTML=Ml),Qs=o(t),Dt=n(t,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-13lz1gw"&&(Dt.textContent=ul),Bs=o(t),M(Lt.$$.fragment,t),Hs=o(t),Pt=n(t,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-571z8p"&&(Pt.textContent=gl),Es=o(t),R=n(t,"H2",{class:!0});var ha=h(R);P=n(ha,"A",{id:!0,class:!0,href:!0});var Fl=h(P);_e=n(Fl,"SPAN",{});var Al=h(_e);M(Ot.$$.fragment,Al),Al.forEach(e),Fl.forEach(e),Ta=o(ha),Je=n(ha,"SPAN",{"data-svelte-h":!0}),p(Je)!=="svelte-16al1v8"&&(Je.textContent=yl),ha.forEach(e),Vs=o(t),Kt=n(t,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1cpi6ml"&&(Kt.textContent=fl),Xs=o(t),te=n(t,"P",{"data-svelte-h":!0}),p(te)!=="svelte-bxfm2h"&&(te.textContent=wl),Fs=o(t),O=n(t,"DIV",{class:!0,"data-svelte-h":!0}),p(O)!=="svelte-1mf93u3"&&(O.innerHTML=jl),As=o(t),ee=n(t,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-75pbgi"&&(ee.innerHTML=Jl),$s=o(t),M(se.$$.fragment,t),Ys=o(t),ae=n(t,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-eumo01"&&(ae.textContent=Tl),Ss=o(t),M(K.$$.fragment,t),qs=o(t),_=n(t,"H2",{class:!0});var ma=h(_);tt=n(ma,"A",{id:!0,class:!0,href:!0});var $l=h(tt);Ne=n($l,"SPAN",{});var Yl=h(Ne);M(le.$$.fragment,Yl),Yl.forEach(e),$l.forEach(e),Ua=o(ma),Te=n(ma,"SPAN",{"data-svelte-h":!0}),p(Te)!=="svelte-thinkx"&&(Te.textContent=Ul),ma.forEach(e),Ds=o(t),ne=n(t,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-2k4kpw"&&(ne.textContent=bl),Ls=o(t),M(ie.$$.fragment,t),Ps=o(t),N=n(t,"H2",{class:!0});var da=h(N);et=n(da,"A",{id:!0,class:!0,href:!0});var Sl=h(et);We=n(Sl,"SPAN",{});var ql=h(We);M(oe.$$.fragment,ql),ql.forEach(e),Sl.forEach(e),ba=o(da),Ue=n(da,"SPAN",{"data-svelte-h":!0}),p(Ue)!=="svelte-1svn972"&&(Ue.textContent=vl),da.forEach(e),Os=o(t),pe=n(t,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-ay5071"&&(pe.innerHTML=Zl),Ks=o(t),re=n(t,"P",{"data-svelte-h":!0}),p(re)!=="svelte-8tbmhu"&&(re.textContent=Il),ta=o(t),ce=n(t,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-ccrnle"&&(ce.textContent=kl),ea=o(t),M(he.$$.fragment,t),sa=o(t),Ge=n(t,"P",{}),h(Ge).forEach(e),this.h()},h(){r(m,"name","hf:doc:metadata"),r(m,"content",JSON.stringify(rn)),r(z,"id","image-tasks-with-idefics"),r(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(z,"href","#image-tasks-with-idefics"),r(U,"class","relative group"),r(B,"id","loading-the-model"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#loading-the-model"),r(b,"class","relative group"),r(H,"id","quantized-model"),r(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(H,"href","#quantized-model"),r(v,"class","relative group"),r(E,"id","image-captioning"),r(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(E,"href","#image-captioning"),r(Z,"class","relative group"),r(V,"class","flex justify-center"),r(F,"id","prompted-image-captioning"),r(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(F,"href","#prompted-image-captioning"),r(I,"class","relative group"),r(A,"class","flex justify-center"),r($,"id","fewshot-prompting"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#fewshot-prompting"),r(k,"class","relative group"),r(Y,"class","flex justify-center"),r(S,"id","visual-question-answering"),r(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(S,"href","#visual-question-answering"),r(C,"class","relative group"),r(q,"class","flex justify-center"),r(D,"id","image-classification"),r(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(D,"href","#image-classification"),r(x,"class","relative group"),r(L,"class","flex justify-center"),r(P,"id","imageguided-text-generation"),r(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(P,"href","#imageguided-text-generation"),r(R,"class","relative group"),r(O,"class","flex justify-center"),r(tt,"id","running-inference-in-batch-mode"),r(tt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(tt,"href","#running-inference-in-batch-mode"),r(_,"class","relative group"),r(et,"id","idefics-instruct-for-conversational-use"),r(et,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(et,"href","#idefics-instruct-for-conversational-use"),r(N,"class","relative group")},m(t,s){c(document.head,m),a(t,j,s),a(t,w,s),a(t,G,s),a(t,U,s),c(U,z),c(z,be),u(st,be,null),c(U,Ma),c(U,de),a(t,Be,s),u(at,t,s),a(t,He,s),a(t,lt,s),a(t,Ee,s),a(t,nt,s),a(t,Ve,s),a(t,it,s),a(t,Xe,s),a(t,ot,s),a(t,Fe,s),a(t,pt,s),a(t,Ae,s),a(t,rt,s),a(t,$e,s),u(ct,t,s),a(t,Ye,s),u(Q,t,s),a(t,Se,s),a(t,b,s),c(b,B),c(B,ve),u(ht,ve,null),c(b,ua),c(b,Me),a(t,qe,s),a(t,mt,s),a(t,De,s),u(dt,t,s),a(t,Le,s),a(t,Mt,s),a(t,Pe,s),u(ut,t,s),a(t,Oe,s),a(t,gt,s),a(t,Ke,s),a(t,v,s),c(v,H),c(H,Ze),u(yt,Ze,null),c(v,ga),c(v,ue),a(t,ts,s),a(t,ft,s),a(t,es,s),u(wt,t,s),a(t,ss,s),a(t,jt,s),a(t,as,s),a(t,Z,s),c(Z,E),c(E,Ie),u(Jt,Ie,null),c(Z,ya),c(Z,ge),a(t,ls,s),a(t,Tt,s),a(t,ns,s),a(t,Ut,s),a(t,is,s),a(t,V,s),a(t,os,s),a(t,bt,s),a(t,ps,s),a(t,vt,s),a(t,rs,s),a(t,Zt,s),a(t,cs,s),u(It,t,s),a(t,hs,s),u(X,t,s),a(t,ms,s),a(t,I,s),c(I,F),c(F,ke),u(kt,ke,null),c(I,fa),c(I,ye),a(t,ds,s),a(t,Ct,s),a(t,Ms,s),a(t,A,s),a(t,us,s),a(t,xt,s),a(t,gs,s),a(t,Rt,s),a(t,ys,s),u(_t,t,s),a(t,fs,s),a(t,k,s),c(k,$),c($,Ce),u(Nt,Ce,null),c(k,wa),c(k,fe),a(t,ws,s),a(t,Wt,s),a(t,js,s),a(t,Gt,s),a(t,Js,s),a(t,Y,s),a(t,Ts,s),a(t,zt,s),a(t,Us,s),u(Qt,t,s),a(t,bs,s),a(t,Bt,s),a(t,vs,s),a(t,C,s),c(C,S),c(S,xe),u(Ht,xe,null),c(C,ja),c(C,we),a(t,Zs,s),a(t,Et,s),a(t,Is,s),a(t,Vt,s),a(t,ks,s),a(t,q,s),a(t,Cs,s),a(t,Xt,s),a(t,xs,s),a(t,Ft,s),a(t,Rs,s),u(At,t,s),a(t,_s,s),a(t,x,s),c(x,D),c(D,Re),u($t,Re,null),c(x,Ja),c(x,je),a(t,Ns,s),a(t,Yt,s),a(t,Ws,s),a(t,St,s),a(t,Gs,s),a(t,L,s),a(t,zs,s),a(t,qt,s),a(t,Qs,s),a(t,Dt,s),a(t,Bs,s),u(Lt,t,s),a(t,Hs,s),a(t,Pt,s),a(t,Es,s),a(t,R,s),c(R,P),c(P,_e),u(Ot,_e,null),c(R,Ta),c(R,Je),a(t,Vs,s),a(t,Kt,s),a(t,Xs,s),a(t,te,s),a(t,Fs,s),a(t,O,s),a(t,As,s),a(t,ee,s),a(t,$s,s),u(se,t,s),a(t,Ys,s),a(t,ae,s),a(t,Ss,s),u(K,t,s),a(t,qs,s),a(t,_,s),c(_,tt),c(tt,Ne),u(le,Ne,null),c(_,Ua),c(_,Te),a(t,Ds,s),a(t,ne,s),a(t,Ls,s),u(ie,t,s),a(t,Ps,s),a(t,N,s),c(N,et),c(et,We),u(oe,We,null),c(N,ba),c(N,Ue),a(t,Os,s),a(t,pe,s),a(t,Ks,s),a(t,re,s),a(t,ta,s),a(t,ce,s),a(t,ea,s),u(he,t,s),a(t,sa,s),a(t,Ge,s),aa=!0},p(t,[s]){const me={};s&2&&(me.$$scope={dirty:s,ctx:t}),Q.$set(me);const ze={};s&2&&(ze.$$scope={dirty:s,ctx:t}),X.$set(ze);const Qe={};s&2&&(Qe.$$scope={dirty:s,ctx:t}),K.$set(Qe)},i(t){aa||(g(st.$$.fragment,t),g(at.$$.fragment,t),g(ct.$$.fragment,t),g(Q.$$.fragment,t),g(ht.$$.fragment,t),g(dt.$$.fragment,t),g(ut.$$.fragment,t),g(yt.$$.fragment,t),g(wt.$$.fragment,t),g(Jt.$$.fragment,t),g(It.$$.fragment,t),g(X.$$.fragment,t),g(kt.$$.fragment,t),g(_t.$$.fragment,t),g(Nt.$$.fragment,t),g(Qt.$$.fragment,t),g(Ht.$$.fragment,t),g(At.$$.fragment,t),g($t.$$.fragment,t),g(Lt.$$.fragment,t),g(Ot.$$.fragment,t),g(se.$$.fragment,t),g(K.$$.fragment,t),g(le.$$.fragment,t),g(ie.$$.fragment,t),g(oe.$$.fragment,t),g(he.$$.fragment,t),aa=!0)},o(t){y(st.$$.fragment,t),y(at.$$.fragment,t),y(ct.$$.fragment,t),y(Q.$$.fragment,t),y(ht.$$.fragment,t),y(dt.$$.fragment,t),y(ut.$$.fragment,t),y(yt.$$.fragment,t),y(wt.$$.fragment,t),y(Jt.$$.fragment,t),y(It.$$.fragment,t),y(X.$$.fragment,t),y(kt.$$.fragment,t),y(_t.$$.fragment,t),y(Nt.$$.fragment,t),y(Qt.$$.fragment,t),y(Ht.$$.fragment,t),y(At.$$.fragment,t),y($t.$$.fragment,t),y(Lt.$$.fragment,t),y(Ot.$$.fragment,t),y(se.$$.fragment,t),y(K.$$.fragment,t),y(le.$$.fragment,t),y(ie.$$.fragment,t),y(oe.$$.fragment,t),y(he.$$.fragment,t),aa=!1},d(t){t&&(e(j),e(w),e(G),e(U),e(Be),e(He),e(lt),e(Ee),e(nt),e(Ve),e(it),e(Xe),e(ot),e(Fe),e(pt),e(Ae),e(rt),e($e),e(Ye),e(Se),e(b),e(qe),e(mt),e(De),e(Le),e(Mt),e(Pe),e(Oe),e(gt),e(Ke),e(v),e(ts),e(ft),e(es),e(ss),e(jt),e(as),e(Z),e(ls),e(Tt),e(ns),e(Ut),e(is),e(V),e(os),e(bt),e(ps),e(vt),e(rs),e(Zt),e(cs),e(hs),e(ms),e(I),e(ds),e(Ct),e(Ms),e(A),e(us),e(xt),e(gs),e(Rt),e(ys),e(fs),e(k),e(ws),e(Wt),e(js),e(Gt),e(Js),e(Y),e(Ts),e(zt),e(Us),e(bs),e(Bt),e(vs),e(C),e(Zs),e(Et),e(Is),e(Vt),e(ks),e(q),e(Cs),e(Xt),e(xs),e(Ft),e(Rs),e(_s),e(x),e(Ns),e(Yt),e(Ws),e(St),e(Gs),e(L),e(zs),e(qt),e(Qs),e(Dt),e(Bs),e(Hs),e(Pt),e(Es),e(R),e(Vs),e(Kt),e(Xs),e(te),e(Fs),e(O),e(As),e(ee),e($s),e(Ys),e(ae),e(Ss),e(qs),e(_),e(Ds),e(ne),e(Ls),e(Ps),e(N),e(Os),e(pe),e(Ks),e(re),e(ta),e(ce),e(ea),e(sa),e(Ge)),e(m),f(st),f(at,t),f(ct,t),f(Q,t),f(ht),f(dt,t),f(ut,t),f(yt),f(wt,t),f(Jt),f(It,t),f(X,t),f(kt),f(_t,t),f(Nt),f(Qt,t),f(Ht),f(At,t),f($t),f(Lt,t),f(Ot),f(se,t),f(K,t),f(le),f(ie,t),f(oe),f(he,t)}}}const rn={local:"image-tasks-with-idefics",sections:[{local:"loading-the-model",sections:[{local:"quantized-model",title:"Quantized model"}],title:"Loading the model"},{local:"image-captioning",title:"Image captioning"},{local:"prompted-image-captioning",title:"Prompted image captioning"},{local:"fewshot-prompting",title:"Few-shot prompting"},{local:"visual-question-answering",title:"Visual question answering"},{local:"image-classification",title:"Image classification"},{local:"imageguided-text-generation",title:"Image-guided text generation"},{local:"running-inference-in-batch-mode",title:"Running inference in batch mode"},{local:"idefics-instruct-for-conversational-use",title:"IDEFICS instruct for conversational use"}],title:"Image tasks with IDEFICS"};function cn(W){return Pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends Ol{constructor(m){super(),Kl(this,m,cn,pn,Ll,{})}}export{yn as component};
