import{s as vi,o as ki,n as xi}from"../chunks/scheduler.9bc65507.js";import{S as $i,i as Ii,g as p,s as l,u as r,A as Zi,h as i,f as s,c as n,j as g,v as h,y as o,k as y,o as M,a,w as c,d as m,t as u,x as d}from"../chunks/index.78c82d43.js";import{T as _i}from"../chunks/Tip.87d55b76.js";import{I as T}from"../chunks/IconCopyLink.bedaa44d.js";import{C as f}from"../chunks/CodeBlock.73e038be.js";import{D as Vi}from"../chunks/DocNotebookDropdown.31840a23.js";function Gi(Ys){let w,K="To follow this guide you will need a GPU. If you’re working in a notebook, run the following line to check if a GPU is available:",U,b,J;return b=new f({props:{code:"IW52aWRpYS1zbWk=",highlighted:"!nvidia-smi",wrap:!1}}),{c(){w=p("p"),w.textContent=K,U=l(),r(b.$$.fragment)},l(j){w=i(j,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1qyctb1"&&(w.textContent=K),U=n(j),h(b.$$.fragment,j)},m(j,C){a(j,w,C),a(j,U,C),c(b,j,C),J=!0},p:xi,i(j){J||(m(b.$$.fragment,j),J=!0)},o(j){u(b.$$.fragment,j),J=!1},d(j){j&&(s(w),s(U)),d(b,j)}}}function Bi(Ys){let w,K,U,b,J,j,C,O,gn,ys,In="Text to speech",Ns,ee,zs,te,Zn=`Text-to-speech (TTS) is the task of creating natural-sounding speech from text, where the speech can be generated in multiple
languages and for multiple speakers. Several text-to-speech models are currently available in 🤗 Transformers, such as
<a href="../model_doc/bark">Bark</a>, <a href="../model_doc/mms">MMS</a>, <a href="../model_doc/vits">VITS</a> and <a href="../model_doc/speecht5">SpeechT5</a>.`,Qs,se,_n=`You can easily generate audio using the <code>&quot;text-to-audio&quot;</code> pipeline (or its alias - <code>&quot;text-to-speech&quot;</code>). Some models, like Bark,
can also be conditioned to generate non-verbal communications such as laughing, sighing and crying, or even add music.
Here’s an example of how you would use the <code>&quot;text-to-speech&quot;</code> pipeline with Bark:`,As,ae,Es,le,Vn="Here’s a code snippet you can use to listen to the resulting audio in a notebook:",Fs,ne,Hs,pe,Gn=`For more examples on what Bark and other pretrained TTS models can do, refer to our
<a href="https://huggingface.co/learn/audio-course/chapter6/pre-trained_models" rel="nofollow">Audio course</a>.`,qs,ie,Bn=`If you are looking to fine-tune a TTS model, you can currently fine-tune SpeechT5 only. SpeechT5 is pre-trained on a combination of
speech-to-text and text-to-speech data, allowing it to learn a unified space of hidden representations shared by both text
and speech. This means that the same pre-trained model can be fine-tuned for different tasks. Furthermore, SpeechT5
supports multiple speakers through x-vector speaker embeddings.`,Ss,oe,Wn="The remainder of this guide illustrates how to:",Ps,re,Rn='<li>Fine-tune <a href="../model_doc/speecht5">SpeechT5</a> that was originally trained on English speech on the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.</li> <li>Use your refined model for inference in one of two ways: using a pipeline or directly.</li>',Ls,he,Xn="Before you begin, make sure you have all the necessary libraries installed:",Ds,ce,Ks,me,Yn="Install 🤗Transformers from source as not all the SpeechT5 features have been merged into an official release yet:",Os,ue,ea,R,ta,de,Nn="We encourage you to log in to your Hugging Face account to upload and share your model with the community. When prompted, enter your token to log in:",sa,ye,aa,v,X,ks,Me,jn,Ms,zn="Load the dataset",la,fe,Qn=`<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. In this guide, we are using the Dutch language subset, feel free to pick another subset.`,na,ge,An=`Note that VoxPopuli or any other automated speech recognition (ASR) dataset may not be the most suitable
option for training TTS models. The features that make it beneficial for ASR, such as excessive background noise, are
typically undesirable in TTS. However, finding top-quality, multilingual, and multi-speaker TTS datasets can be quite
challenging.`,pa,je,En="Let’s load the data:",ia,we,oa,Je,Fn=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,ra,be,ha,k,Y,xs,Te,wn,fs,Hn="Preprocess the data",ca,Ue,qn="Let’s begin by defining the model checkpoint to use and loading the appropriate processor:",ma,Ce,ua,x,N,$s,ve,Jn,gs,Sn="Text cleanup for SpeechT5 tokenization",da,ke,Pn="Start by cleaning up the text data. You’ll need the tokenizer part of the processor to process the text:",ya,xe,Ma,$e,Ln=`The dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which feature to use as the text input,
consider that the SpeechT5 tokenizer doesn’t have any tokens for numbers. In <code>normalized_text</code> the numbers are written
out as text. Thus, it is a better fit, and we recommend using    <code>normalized_text</code> as input text.`,fa,Ie,Dn=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,ga,Ze,Kn=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,ja,_e,wa,Ve,On=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,Ja,Ge,ba,Be,ep=`To handle the unsupported characters identified in the previous step, define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,Ta,We,Ua,Re,tp="Now that you have dealt with special characters in the text, it’s time to shift focus to the audio data.",Ca,$,z,Is,Xe,bn,js,sp="Speakers",va,Ye,ap=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,ka,Ne,xa,ze,lp="By plotting a histogram you can get a sense of how much data there is for each speaker.",$a,Qe,Ia,Q,np='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Za,Ae,pp=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,_a,Ee,Va,Fe,ip="Let’s check how many speakers remain:",Ga,He,Ba,qe,op="Let’s see how many examples are left:",Wa,Se,Ra,Pe,rp="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Xa,Le,hp=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Ya,I,A,Zs,De,Tn,ws,cp="Speaker embeddings",Na,Ke,mp=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,za,Oe,up=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,Qa,et,Aa,tt,dp=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,Ea,st,yp=`For optimal results, we recommend training an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language.`,Fa,Z,E,_s,at,Un,Js,Mp="Processing the dataset",Ha,lt,fp=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,qa,nt,Sa,pt,gp="Verify the processing is correct by looking at a single example:",Pa,it,La,ot,jp="Speaker embeddings should be a 512-element vector:",Da,rt,Ka,ht,wp="The labels should be a log-mel spectrogram with 80 mel bins.",Oa,ct,el,F,Jp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',tl,mt,bp=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,sl,ut,Tp="Now apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",al,dt,ll,yt,Up=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,nl,Mt,pl,ft,Cp="Next, create a basic train/test split:",il,gt,ol,_,H,Vs,jt,Cn,bs,vp="Data collator",rl,wt,kp=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with the special value <code>-100</code>. This special value
instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,hl,Jt,cl,bt,xp=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,ml,Tt,ul,V,q,Gs,Ut,vn,Ts,$p="Train the model",dl,Ct,Ip="Load the pre-trained model from the same checkpoint as you used for loading the processor:",yl,vt,Ml,kt,Zp="The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training.",fl,xt,gl,$t,_p=`Define the training arguments. Here we are not computing any evaluation metrics during the training process. Instead, we’ll
only look at the loss:`,jl,It,wl,Zt,Vp="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",Jl,_t,bl,Vt,Gp=`And with that, you’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,Tl,Gt,Ul,Bt,Bp="To be able to use your checkpoint with a pipeline, make sure to save the processor with the checkpoint:",Cl,Wt,vl,Rt,Wp="Push the final model to the 🤗 Hub:",kl,Xt,xl,G,S,Bs,Yt,kn,Us,Rp="Inference",$l,B,P,Ws,Nt,xn,Cs,Xp="Inference with a pipeline",Il,zt,Yp=`Great, now that you’ve fine-tuned a model, you can use it for inference!
First, let’s see how you can use it with a corresponding pipeline. Let’s create a <code>&quot;text-to-speech&quot;</code> pipeline with your
checkpoint:`,Zl,Qt,_l,At,Np="Pick a piece of text in Dutch you’d like narrated, e.g.:",Vl,Et,Gl,Ft,zp="To use SpeechT5 with the pipeline, you’ll need a speaker embedding. Let’s get it from an example in the test dataset:",Bl,Ht,Wl,qt,Qp="Now you can pass the text and speaker embeddings to the pipeline, and it will take care of the rest:",Rl,St,Xl,Pt,Ap="You can then listen to the result:",Yl,Lt,Nl,W,L,Rs,Dt,$n,vs,Ep="Run inference manually",zl,Kt,Fp="You can achieve the same inference results without using the pipeline, however, more steps will be required.",Ql,Ot,Hp="Load the model from the 🤗 Hub:",Al,es,El,ts,qp="Pick an example from the test dataset obtain a speaker embedding.",Fl,ss,Hl,as,Sp="Define the input text and tokenize it.",ql,ls,Sl,ns,Pp="Create a spectrogram with your model:",Pl,ps,Ll,is,Lp="Visualize the spectrogram, if you’d like to:",Dl,os,Kl,D,Dp='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_2.png" alt="Generated log-mel spectrogram"/>',Ol,rs,Kp="Finally, use the vocoder to turn the spectrogram into sound.",en,hs,tn,cs,Op=`In our experience, obtaining satisfactory results from this model can be challenging. The quality of the speaker
embeddings appears to be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,sn,ms,ei=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,an,us,ti=`Finally, it is essential to consider ethical considerations. Although TTS technology has numerous useful applications, it
may also be used for malicious purposes, such as impersonating someone’s voice without their knowledge or consent. Please
use TTS judiciously and responsibly.`,ln,Xs,nn;return O=new T({}),ee=new Vi({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"}]}}),ae=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJzdW5vJTJGYmFyay1zbWFsbCUyMiklMEF0ZXh0JTIwJTNEJTIwJTIyJTVCY2xlYXJzJTIwdGhyb2F0JTVEJTIwVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjAuLi4lMjBhbmQlMjBJJTIwanVzdCUyMHRvb2slMjBhJTIwbG9uZyUyMHBhdXNlLiUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGUodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;[clears throat] This is a test ... and I just took a long pause.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text)`,wrap:!1}}),ne=new f({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlMkMlMjByYXRlJTNEb3V0cHV0JTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),ce=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install datasets soundfile speechbrain accelerate",wrap:!1}}),ue=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdA==",highlighted:"pip install git+https://github.com/huggingface/transformers.git",wrap:!1}}),R=new _i({props:{$$slots:{default:[Gi]},$$scope:{ctx:Ys}}}),ye=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),Me=new T({}),we=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">20968</span>`,wrap:!1}}),be=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),Te=new T({}),Ce=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),ve=new T({}),xe=new f({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer',wrap:!1}}),_e=new f({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
<span class="hljs-meta">... </span>    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


<span class="hljs-meta">&gt;&gt;&gt; </span>vocabs = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    extract_all_chars,
<span class="hljs-meta">... </span>    batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    keep_in_memory=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    remove_columns=dataset.column_names,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),Ge=new f({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab - tokenizer_vocab
{<span class="hljs-string">&#x27; &#x27;</span>, <span class="hljs-string">&#x27;à&#x27;</span>, <span class="hljs-string">&#x27;ç&#x27;</span>, <span class="hljs-string">&#x27;è&#x27;</span>, <span class="hljs-string">&#x27;ë&#x27;</span>, <span class="hljs-string">&#x27;í&#x27;</span>, <span class="hljs-string">&#x27;ï&#x27;</span>, <span class="hljs-string">&#x27;ö&#x27;</span>, <span class="hljs-string">&#x27;ü&#x27;</span>}`,wrap:!1}}),We=new f({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>replacements = [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
<span class="hljs-meta">... </span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
<span class="hljs-meta">... </span>        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),Xe=new T({}),Ne=new f({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
<span class="hljs-meta">... </span>    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),Qe=new f({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),Ee=new f({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),He=new f({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))
<span class="hljs-number">42</span>`,wrap:!1}}),Se=new f({props:{code:"bGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">9973</span>`,wrap:!1}}),De=new T({}),et=new f({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

<span class="hljs-meta">&gt;&gt;&gt; </span>spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_model = EncoderClassifier.from_hparams(
<span class="hljs-meta">... </span>    source=spk_model_name,
<span class="hljs-meta">... </span>    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
<span class="hljs-meta">... </span>    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
<span class="hljs-meta">... </span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
<span class="hljs-meta">... </span>        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),at=new T({}),nt=new f({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">... </span>    example = processor(
<span class="hljs-meta">... </span>        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
<span class="hljs-meta">... </span>        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>        return_attention_mask=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-comment"># strip off the batch dimension</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),it=new f({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(processed_example.keys())
[<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;stop_labels&#x27;</span>, <span class="hljs-string">&#x27;speaker_embeddings&#x27;</span>]`,wrap:!1}}),rt=new f({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape
(<span class="hljs-number">512</span>,)`,wrap:!1}}),ct=new f({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),dt=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Mt=new f({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
<span class="hljs-meta">... </span>    input_length = <span class="hljs-built_in">len</span>(input_ids)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">8259</span>`,wrap:!1}}),gt=new f({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),jt=new T({}),Jt=new f({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
<span class="hljs-meta">... </span>    processor: <span class="hljs-type">Any</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
<span class="hljs-meta">... </span>        batch = processor.pad(input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># not used during fine-tuning</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>            target_lengths = torch.tensor([<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features])
<span class="hljs-meta">... </span>            target_lengths = target_lengths.new(
<span class="hljs-meta">... </span>                [length - length % model.config.reduction_factor <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths]
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            max_length = <span class="hljs-built_in">max</span>(target_lengths)
<span class="hljs-meta">... </span>            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># also add in the speaker embeddings</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Tt=new f({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = TTSDataCollatorWithPadding(processor=processor)',wrap:!1}}),Ut=new T({}),vt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),xt=new f({props:{code:"bW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNl",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.use_cache = <span class="hljs-literal">False</span>',wrap:!1}}),It=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = Seq2SeqTrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">4000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),_t=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Seq2SeqTrainer(
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Gt=new f({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),Wt=new f({props:{code:"cHJvY2Vzc29yLnNhdmVfcHJldHJhaW5lZCglMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>processor.save_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),Xt=new f({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Yt=new T({}),Nt=new T({}),Qt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)`,wrap:!1}}),Et=new f({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),Ht=new f({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),St=new f({props:{code:"Zm9yd2FyZF9wYXJhbXMlMjAlM0QlMjAlN0IlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlM0ElMjBzcGVha2VyX2VtYmVkZGluZ3MlN0QlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHRleHQlMkMlMjBmb3J3YXJkX3BhcmFtcyUzRGZvcndhcmRfcGFyYW1zKSUwQW91dHB1dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>forward_params = {<span class="hljs-string">&quot;speaker_embeddings&quot;</span>: speaker_embeddings}
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text, forward_params=forward_params)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;audio&#x27;</span>: array([-<span class="hljs-number">6.82714235e-05</span>, -<span class="hljs-number">4.26525949e-04</span>,  <span class="hljs-number">1.06134125e-04</span>, ...,
        -<span class="hljs-number">1.22392643e-03</span>, -<span class="hljs-number">7.76011671e-04</span>,  <span class="hljs-number">3.29112721e-04</span>], dtype=float32),
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),Lt=new f({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJ2F1ZGlvJyU1RCUyQyUyMHJhdGUlM0RvdXRwdXQlNUInc2FtcGxpbmdfcmF0ZSclNUQpJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&#x27;audio&#x27;</span>], rate=output[<span class="hljs-string">&#x27;sampling_rate&#x27;</span>]) `,wrap:!1}}),Dt=new T({}),es=new f({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),ss=new f({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),ls=new f({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ps=new f({props:{code:"c3BlY3Ryb2dyYW0lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZV9zcGVlY2goaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings)',wrap:!1}}),os=new f({props:{code:"cGx0LmZpZ3VyZSgpJTBBcGx0Lmltc2hvdyhzcGVjdHJvZ3JhbS5UKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(spectrogram.T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),hs=new f({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyMCUzRCUyMHZvY29kZXIoc3BlY3Ryb2dyYW0pJTBBJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    speech = vocoder(spectrogram)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),{c(){w=p("meta"),K=l(),U=p("p"),b=l(),J=p("h1"),j=p("a"),C=p("span"),r(O.$$.fragment),gn=l(),ys=p("span"),ys.textContent=In,Ns=l(),r(ee.$$.fragment),zs=l(),te=p("p"),te.innerHTML=Zn,Qs=l(),se=p("p"),se.innerHTML=_n,As=l(),r(ae.$$.fragment),Es=l(),le=p("p"),le.textContent=Vn,Fs=l(),r(ne.$$.fragment),Hs=l(),pe=p("p"),pe.innerHTML=Gn,qs=l(),ie=p("p"),ie.textContent=Bn,Ss=l(),oe=p("p"),oe.textContent=Wn,Ps=l(),re=p("ol"),re.innerHTML=Rn,Ls=l(),he=p("p"),he.textContent=Xn,Ds=l(),r(ce.$$.fragment),Ks=l(),me=p("p"),me.textContent=Yn,Os=l(),r(ue.$$.fragment),ea=l(),r(R.$$.fragment),ta=l(),de=p("p"),de.textContent=Nn,sa=l(),r(ye.$$.fragment),aa=l(),v=p("h2"),X=p("a"),ks=p("span"),r(Me.$$.fragment),jn=l(),Ms=p("span"),Ms.textContent=zn,la=l(),fe=p("p"),fe.innerHTML=Qn,na=l(),ge=p("p"),ge.textContent=An,pa=l(),je=p("p"),je.textContent=En,ia=l(),r(we.$$.fragment),oa=l(),Je=p("p"),Je.textContent=Fn,ra=l(),r(be.$$.fragment),ha=l(),k=p("h2"),Y=p("a"),xs=p("span"),r(Te.$$.fragment),wn=l(),fs=p("span"),fs.textContent=Hn,ca=l(),Ue=p("p"),Ue.textContent=qn,ma=l(),r(Ce.$$.fragment),ua=l(),x=p("h3"),N=p("a"),$s=p("span"),r(ve.$$.fragment),Jn=l(),gs=p("span"),gs.textContent=Sn,da=l(),ke=p("p"),ke.textContent=Pn,ya=l(),r(xe.$$.fragment),Ma=l(),$e=p("p"),$e.innerHTML=Ln,fa=l(),Ie=p("p"),Ie.innerHTML=Dn,ga=l(),Ze=p("p"),Ze.innerHTML=Kn,ja=l(),r(_e.$$.fragment),wa=l(),Ve=p("p"),Ve.textContent=On,Ja=l(),r(Ge.$$.fragment),ba=l(),Be=p("p"),Be.innerHTML=ep,Ta=l(),r(We.$$.fragment),Ua=l(),Re=p("p"),Re.textContent=tp,Ca=l(),$=p("h3"),z=p("a"),Is=p("span"),r(Xe.$$.fragment),bn=l(),js=p("span"),js.textContent=sp,va=l(),Ye=p("p"),Ye.textContent=ap,ka=l(),r(Ne.$$.fragment),xa=l(),ze=p("p"),ze.textContent=lp,$a=l(),r(Qe.$$.fragment),Ia=l(),Q=p("div"),Q.innerHTML=np,Za=l(),Ae=p("p"),Ae.textContent=pp,_a=l(),r(Ee.$$.fragment),Va=l(),Fe=p("p"),Fe.textContent=ip,Ga=l(),r(He.$$.fragment),Ba=l(),qe=p("p"),qe.textContent=op,Wa=l(),r(Se.$$.fragment),Ra=l(),Pe=p("p"),Pe.textContent=rp,Xa=l(),Le=p("p"),Le.textContent=hp,Ya=l(),I=p("h3"),A=p("a"),Zs=p("span"),r(De.$$.fragment),Tn=l(),ws=p("span"),ws.textContent=cp,Na=l(),Ke=p("p"),Ke.innerHTML=mp,za=l(),Oe=p("p"),Oe.innerHTML=up,Qa=l(),r(et.$$.fragment),Aa=l(),tt=p("p"),tt.innerHTML=dp,Ea=l(),st=p("p"),st.textContent=yp,Fa=l(),Z=p("h3"),E=p("a"),_s=p("span"),r(at.$$.fragment),Un=l(),Js=p("span"),Js.textContent=Mp,Ha=l(),lt=p("p"),lt.innerHTML=fp,qa=l(),r(nt.$$.fragment),Sa=l(),pt=p("p"),pt.textContent=gp,Pa=l(),r(it.$$.fragment),La=l(),ot=p("p"),ot.textContent=jp,Da=l(),r(rt.$$.fragment),Ka=l(),ht=p("p"),ht.textContent=wp,Oa=l(),r(ct.$$.fragment),el=l(),F=p("div"),F.innerHTML=Jp,tl=l(),mt=p("p"),mt.textContent=bp,sl=l(),ut=p("p"),ut.textContent=Tp,al=l(),r(dt.$$.fragment),ll=l(),yt=p("p"),yt.textContent=Up,nl=l(),r(Mt.$$.fragment),pl=l(),ft=p("p"),ft.textContent=Cp,il=l(),r(gt.$$.fragment),ol=l(),_=p("h3"),H=p("a"),Vs=p("span"),r(jt.$$.fragment),Cn=l(),bs=p("span"),bs.textContent=vp,rl=l(),wt=p("p"),wt.innerHTML=kp,hl=l(),r(Jt.$$.fragment),cl=l(),bt=p("p"),bt.textContent=xp,ml=l(),r(Tt.$$.fragment),ul=l(),V=p("h2"),q=p("a"),Gs=p("span"),r(Ut.$$.fragment),vn=l(),Ts=p("span"),Ts.textContent=$p,dl=l(),Ct=p("p"),Ct.textContent=Ip,yl=l(),r(vt.$$.fragment),Ml=l(),kt=p("p"),kt.innerHTML=Zp,fl=l(),r(xt.$$.fragment),gl=l(),$t=p("p"),$t.textContent=_p,jl=l(),r(It.$$.fragment),wl=l(),Zt=p("p"),Zt.innerHTML=Vp,Jl=l(),r(_t.$$.fragment),bl=l(),Vt=p("p"),Vt.innerHTML=Gp,Tl=l(),r(Gt.$$.fragment),Ul=l(),Bt=p("p"),Bt.textContent=Bp,Cl=l(),r(Wt.$$.fragment),vl=l(),Rt=p("p"),Rt.textContent=Wp,kl=l(),r(Xt.$$.fragment),xl=l(),G=p("h2"),S=p("a"),Bs=p("span"),r(Yt.$$.fragment),kn=l(),Us=p("span"),Us.textContent=Rp,$l=l(),B=p("h3"),P=p("a"),Ws=p("span"),r(Nt.$$.fragment),xn=l(),Cs=p("span"),Cs.textContent=Xp,Il=l(),zt=p("p"),zt.innerHTML=Yp,Zl=l(),r(Qt.$$.fragment),_l=l(),At=p("p"),At.textContent=Np,Vl=l(),r(Et.$$.fragment),Gl=l(),Ft=p("p"),Ft.textContent=zp,Bl=l(),r(Ht.$$.fragment),Wl=l(),qt=p("p"),qt.textContent=Qp,Rl=l(),r(St.$$.fragment),Xl=l(),Pt=p("p"),Pt.textContent=Ap,Yl=l(),r(Lt.$$.fragment),Nl=l(),W=p("h3"),L=p("a"),Rs=p("span"),r(Dt.$$.fragment),$n=l(),vs=p("span"),vs.textContent=Ep,zl=l(),Kt=p("p"),Kt.textContent=Fp,Ql=l(),Ot=p("p"),Ot.textContent=Hp,Al=l(),r(es.$$.fragment),El=l(),ts=p("p"),ts.textContent=qp,Fl=l(),r(ss.$$.fragment),Hl=l(),as=p("p"),as.textContent=Sp,ql=l(),r(ls.$$.fragment),Sl=l(),ns=p("p"),ns.textContent=Pp,Pl=l(),r(ps.$$.fragment),Ll=l(),is=p("p"),is.textContent=Lp,Dl=l(),r(os.$$.fragment),Kl=l(),D=p("div"),D.innerHTML=Dp,Ol=l(),rs=p("p"),rs.textContent=Kp,en=l(),r(hs.$$.fragment),tn=l(),cs=p("p"),cs.textContent=Op,sn=l(),ms=p("p"),ms.innerHTML=ei,an=l(),us=p("p"),us.textContent=ti,ln=l(),Xs=p("p"),this.h()},l(e){const t=Zi("svelte-1phssyn",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(s),K=n(e),U=i(e,"P",{}),g(U).forEach(s),b=n(e),J=i(e,"H1",{class:!0});var ds=g(J);j=i(ds,"A",{id:!0,class:!0,href:!0});var si=g(j);C=i(si,"SPAN",{});var ai=g(C);h(O.$$.fragment,ai),ai.forEach(s),si.forEach(s),gn=n(ds),ys=i(ds,"SPAN",{"data-svelte-h":!0}),o(ys)!=="svelte-19xbyp3"&&(ys.textContent=In),ds.forEach(s),Ns=n(e),h(ee.$$.fragment,e),zs=n(e),te=i(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-l8vv5f"&&(te.innerHTML=Zn),Qs=n(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-onhyd5"&&(se.innerHTML=_n),As=n(e),h(ae.$$.fragment,e),Es=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-8r9uzp"&&(le.textContent=Vn),Fs=n(e),h(ne.$$.fragment,e),Hs=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-jff0e4"&&(pe.innerHTML=Gn),qs=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-c5wqzo"&&(ie.textContent=Bn),Ss=n(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-13pgbx8"&&(oe.textContent=Wn),Ps=n(e),re=i(e,"OL",{"data-svelte-h":!0}),o(re)!=="svelte-16nfhgc"&&(re.innerHTML=Rn),Ls=n(e),he=i(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1c9nexd"&&(he.textContent=Xn),Ds=n(e),h(ce.$$.fragment,e),Ks=n(e),me=i(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1pk9b4n"&&(me.textContent=Yn),Os=n(e),h(ue.$$.fragment,e),ea=n(e),h(R.$$.fragment,e),ta=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-yib87s"&&(de.textContent=Nn),sa=n(e),h(ye.$$.fragment,e),aa=n(e),v=i(e,"H2",{class:!0});var pn=g(v);X=i(pn,"A",{id:!0,class:!0,href:!0});var li=g(X);ks=i(li,"SPAN",{});var ni=g(ks);h(Me.$$.fragment,ni),ni.forEach(s),li.forEach(s),jn=n(pn),Ms=i(pn,"SPAN",{"data-svelte-h":!0}),o(Ms)!=="svelte-6t1nik"&&(Ms.textContent=zn),pn.forEach(s),la=n(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1lfskuv"&&(fe.innerHTML=Qn),na=n(e),ge=i(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1smm6mj"&&(ge.textContent=An),pa=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1soaqfm"&&(je.textContent=En),ia=n(e),h(we.$$.fragment,e),oa=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1xdebij"&&(Je.textContent=Fn),ra=n(e),h(be.$$.fragment,e),ha=n(e),k=i(e,"H2",{class:!0});var on=g(k);Y=i(on,"A",{id:!0,class:!0,href:!0});var pi=g(Y);xs=i(pi,"SPAN",{});var ii=g(xs);h(Te.$$.fragment,ii),ii.forEach(s),pi.forEach(s),wn=n(on),fs=i(on,"SPAN",{"data-svelte-h":!0}),o(fs)!=="svelte-171xy48"&&(fs.textContent=Hn),on.forEach(s),ca=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1cfkf3a"&&(Ue.textContent=qn),ma=n(e),h(Ce.$$.fragment,e),ua=n(e),x=i(e,"H3",{class:!0});var rn=g(x);N=i(rn,"A",{id:!0,class:!0,href:!0});var oi=g(N);$s=i(oi,"SPAN",{});var ri=g($s);h(ve.$$.fragment,ri),ri.forEach(s),oi.forEach(s),Jn=n(rn),gs=i(rn,"SPAN",{"data-svelte-h":!0}),o(gs)!=="svelte-zd2o8z"&&(gs.textContent=Sn),rn.forEach(s),da=n(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1bseo5y"&&(ke.textContent=Pn),ya=n(e),h(xe.$$.fragment,e),Ma=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-alux34"&&($e.innerHTML=Ln),fa=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1qiuc1m"&&(Ie.innerHTML=Dn),ga=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-l4aof2"&&(Ze.innerHTML=Kn),ja=n(e),h(_e.$$.fragment,e),wa=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-fefaym"&&(Ve.textContent=On),Ja=n(e),h(Ge.$$.fragment,e),ba=n(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1m7sgt2"&&(Be.innerHTML=ep),Ta=n(e),h(We.$$.fragment,e),Ua=n(e),Re=i(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-k1jzc5"&&(Re.textContent=tp),Ca=n(e),$=i(e,"H3",{class:!0});var hn=g($);z=i(hn,"A",{id:!0,class:!0,href:!0});var hi=g(z);Is=i(hi,"SPAN",{});var ci=g(Is);h(Xe.$$.fragment,ci),ci.forEach(s),hi.forEach(s),bn=n(hn),js=i(hn,"SPAN",{"data-svelte-h":!0}),o(js)!=="svelte-1djgoy3"&&(js.textContent=sp),hn.forEach(s),va=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1edo483"&&(Ye.textContent=ap),ka=n(e),h(Ne.$$.fragment,e),xa=n(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1hah56a"&&(ze.textContent=lp),$a=n(e),h(Qe.$$.fragment,e),Ia=n(e),Q=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Q)!=="svelte-1uufiik"&&(Q.innerHTML=np),Za=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1ujf40"&&(Ae.textContent=pp),_a=n(e),h(Ee.$$.fragment,e),Va=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-g2dd32"&&(Fe.textContent=ip),Ga=n(e),h(He.$$.fragment,e),Ba=n(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-hbes5t"&&(qe.textContent=op),Wa=n(e),h(Se.$$.fragment,e),Ra=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-oizlk1"&&(Pe.textContent=rp),Xa=n(e),Le=i(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1n0u7fp"&&(Le.textContent=hp),Ya=n(e),I=i(e,"H3",{class:!0});var cn=g(I);A=i(cn,"A",{id:!0,class:!0,href:!0});var mi=g(A);Zs=i(mi,"SPAN",{});var ui=g(Zs);h(De.$$.fragment,ui),ui.forEach(s),mi.forEach(s),Tn=n(cn),ws=i(cn,"SPAN",{"data-svelte-h":!0}),o(ws)!=="svelte-11a8qqy"&&(ws.textContent=cp),cn.forEach(s),Na=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1xdfpy2"&&(Ke.innerHTML=mp),za=n(e),Oe=i(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-7nncma"&&(Oe.innerHTML=up),Qa=n(e),h(et.$$.fragment,e),Aa=n(e),tt=i(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1mtxkxr"&&(tt.innerHTML=dp),Ea=n(e),st=i(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1az2ed"&&(st.textContent=yp),Fa=n(e),Z=i(e,"H3",{class:!0});var mn=g(Z);E=i(mn,"A",{id:!0,class:!0,href:!0});var di=g(E);_s=i(di,"SPAN",{});var yi=g(_s);h(at.$$.fragment,yi),yi.forEach(s),di.forEach(s),Un=n(mn),Js=i(mn,"SPAN",{"data-svelte-h":!0}),o(Js)!=="svelte-yn1vvh"&&(Js.textContent=Mp),mn.forEach(s),Ha=n(e),lt=i(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1tlidee"&&(lt.innerHTML=fp),qa=n(e),h(nt.$$.fragment,e),Sa=n(e),pt=i(e,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-17mzfft"&&(pt.textContent=gp),Pa=n(e),h(it.$$.fragment,e),La=n(e),ot=i(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-1mqg4ck"&&(ot.textContent=jp),Da=n(e),h(rt.$$.fragment,e),Ka=n(e),ht=i(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-f7g58h"&&(ht.textContent=wp),Oa=n(e),h(ct.$$.fragment,e),el=n(e),F=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(F)!=="svelte-j4o1b8"&&(F.innerHTML=Jp),tl=n(e),mt=i(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1t9vz0y"&&(mt.textContent=bp),sl=n(e),ut=i(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1r5jy40"&&(ut.textContent=Tp),al=n(e),h(dt.$$.fragment,e),ll=n(e),yt=i(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-wvyh3r"&&(yt.textContent=Up),nl=n(e),h(Mt.$$.fragment,e),pl=n(e),ft=i(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-12gx63x"&&(ft.textContent=Cp),il=n(e),h(gt.$$.fragment,e),ol=n(e),_=i(e,"H3",{class:!0});var un=g(_);H=i(un,"A",{id:!0,class:!0,href:!0});var Mi=g(H);Vs=i(Mi,"SPAN",{});var fi=g(Vs);h(jt.$$.fragment,fi),fi.forEach(s),Mi.forEach(s),Cn=n(un),bs=i(un,"SPAN",{"data-svelte-h":!0}),o(bs)!=="svelte-a1w05"&&(bs.textContent=vp),un.forEach(s),rl=n(e),wt=i(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1qadcxm"&&(wt.innerHTML=kp),hl=n(e),h(Jt.$$.fragment,e),cl=n(e),bt=i(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-u623yc"&&(bt.textContent=xp),ml=n(e),h(Tt.$$.fragment,e),ul=n(e),V=i(e,"H2",{class:!0});var dn=g(V);q=i(dn,"A",{id:!0,class:!0,href:!0});var gi=g(q);Gs=i(gi,"SPAN",{});var ji=g(Gs);h(Ut.$$.fragment,ji),ji.forEach(s),gi.forEach(s),vn=n(dn),Ts=i(dn,"SPAN",{"data-svelte-h":!0}),o(Ts)!=="svelte-n13n3f"&&(Ts.textContent=$p),dn.forEach(s),dl=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1kkriue"&&(Ct.textContent=Ip),yl=n(e),h(vt.$$.fragment,e),Ml=n(e),kt=i(e,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-15xsopr"&&(kt.innerHTML=Zp),fl=n(e),h(xt.$$.fragment,e),gl=n(e),$t=i(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-11l73nm"&&($t.textContent=_p),jl=n(e),h(It.$$.fragment,e),wl=n(e),Zt=i(e,"P",{"data-svelte-h":!0}),o(Zt)!=="svelte-1yq1u47"&&(Zt.innerHTML=Vp),Jl=n(e),h(_t.$$.fragment,e),bl=n(e),Vt=i(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1qh8b8v"&&(Vt.innerHTML=Gp),Tl=n(e),h(Gt.$$.fragment,e),Ul=n(e),Bt=i(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-pldkg9"&&(Bt.textContent=Bp),Cl=n(e),h(Wt.$$.fragment,e),vl=n(e),Rt=i(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-hefgo2"&&(Rt.textContent=Wp),kl=n(e),h(Xt.$$.fragment,e),xl=n(e),G=i(e,"H2",{class:!0});var yn=g(G);S=i(yn,"A",{id:!0,class:!0,href:!0});var wi=g(S);Bs=i(wi,"SPAN",{});var Ji=g(Bs);h(Yt.$$.fragment,Ji),Ji.forEach(s),wi.forEach(s),kn=n(yn),Us=i(yn,"SPAN",{"data-svelte-h":!0}),o(Us)!=="svelte-199uz7g"&&(Us.textContent=Rp),yn.forEach(s),$l=n(e),B=i(e,"H3",{class:!0});var Mn=g(B);P=i(Mn,"A",{id:!0,class:!0,href:!0});var bi=g(P);Ws=i(bi,"SPAN",{});var Ti=g(Ws);h(Nt.$$.fragment,Ti),Ti.forEach(s),bi.forEach(s),xn=n(Mn),Cs=i(Mn,"SPAN",{"data-svelte-h":!0}),o(Cs)!=="svelte-1vckfxz"&&(Cs.textContent=Xp),Mn.forEach(s),Il=n(e),zt=i(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1jgqgi3"&&(zt.innerHTML=Yp),Zl=n(e),h(Qt.$$.fragment,e),_l=n(e),At=i(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1jnrzsv"&&(At.textContent=Np),Vl=n(e),h(Et.$$.fragment,e),Gl=n(e),Ft=i(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1kvctpa"&&(Ft.textContent=zp),Bl=n(e),h(Ht.$$.fragment,e),Wl=n(e),qt=i(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-n7ysoq"&&(qt.textContent=Qp),Rl=n(e),h(St.$$.fragment,e),Xl=n(e),Pt=i(e,"P",{"data-svelte-h":!0}),o(Pt)!=="svelte-1rln9cy"&&(Pt.textContent=Ap),Yl=n(e),h(Lt.$$.fragment,e),Nl=n(e),W=i(e,"H3",{class:!0});var fn=g(W);L=i(fn,"A",{id:!0,class:!0,href:!0});var Ui=g(L);Rs=i(Ui,"SPAN",{});var Ci=g(Rs);h(Dt.$$.fragment,Ci),Ci.forEach(s),Ui.forEach(s),$n=n(fn),vs=i(fn,"SPAN",{"data-svelte-h":!0}),o(vs)!=="svelte-1lqchd8"&&(vs.textContent=Ep),fn.forEach(s),zl=n(e),Kt=i(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1r1hsi3"&&(Kt.textContent=Fp),Ql=n(e),Ot=i(e,"P",{"data-svelte-h":!0}),o(Ot)!=="svelte-1ydpy0n"&&(Ot.textContent=Hp),Al=n(e),h(es.$$.fragment,e),El=n(e),ts=i(e,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-fmd5zf"&&(ts.textContent=qp),Fl=n(e),h(ss.$$.fragment,e),Hl=n(e),as=i(e,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1611eam"&&(as.textContent=Sp),ql=n(e),h(ls.$$.fragment,e),Sl=n(e),ns=i(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-eurn6"&&(ns.textContent=Pp),Pl=n(e),h(ps.$$.fragment,e),Ll=n(e),is=i(e,"P",{"data-svelte-h":!0}),o(is)!=="svelte-iofzmb"&&(is.textContent=Lp),Dl=n(e),h(os.$$.fragment,e),Kl=n(e),D=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(D)!=="svelte-16b2dt6"&&(D.innerHTML=Dp),Ol=n(e),rs=i(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-chmo02"&&(rs.textContent=Kp),en=n(e),h(hs.$$.fragment,e),tn=n(e),cs=i(e,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-1fdujzv"&&(cs.textContent=Op),sn=n(e),ms=i(e,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-6lmfh0"&&(ms.innerHTML=ei),an=n(e),us=i(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1mo0fd"&&(us.textContent=ti),ln=n(e),Xs=i(e,"P",{}),g(Xs).forEach(s),this.h()},h(){y(w,"name","hf:doc:metadata"),y(w,"content",JSON.stringify(Wi)),y(j,"id","text-to-speech"),y(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(j,"href","#text-to-speech"),y(J,"class","relative group"),y(X,"id","load-the-dataset"),y(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(X,"href","#load-the-dataset"),y(v,"class","relative group"),y(Y,"id","preprocess-the-data"),y(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(Y,"href","#preprocess-the-data"),y(k,"class","relative group"),y(N,"id","text-cleanup-for-speecht5-tokenization"),y(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(N,"href","#text-cleanup-for-speecht5-tokenization"),y(x,"class","relative group"),y(z,"id","speakers"),y(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(z,"href","#speakers"),y($,"class","relative group"),y(Q,"class","flex justify-center"),y(A,"id","speaker-embeddings"),y(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(A,"href","#speaker-embeddings"),y(I,"class","relative group"),y(E,"id","processing-the-dataset"),y(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(E,"href","#processing-the-dataset"),y(Z,"class","relative group"),y(F,"class","flex justify-center"),y(H,"id","data-collator"),y(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(H,"href","#data-collator"),y(_,"class","relative group"),y(q,"id","train-the-model"),y(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(q,"href","#train-the-model"),y(V,"class","relative group"),y(S,"id","inference"),y(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(S,"href","#inference"),y(G,"class","relative group"),y(P,"id","inference-with-a-pipeline"),y(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(P,"href","#inference-with-a-pipeline"),y(B,"class","relative group"),y(L,"id","run-inference-manually"),y(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(L,"href","#run-inference-manually"),y(W,"class","relative group"),y(D,"class","flex justify-center")},m(e,t){M(document.head,w),a(e,K,t),a(e,U,t),a(e,b,t),a(e,J,t),M(J,j),M(j,C),c(O,C,null),M(J,gn),M(J,ys),a(e,Ns,t),c(ee,e,t),a(e,zs,t),a(e,te,t),a(e,Qs,t),a(e,se,t),a(e,As,t),c(ae,e,t),a(e,Es,t),a(e,le,t),a(e,Fs,t),c(ne,e,t),a(e,Hs,t),a(e,pe,t),a(e,qs,t),a(e,ie,t),a(e,Ss,t),a(e,oe,t),a(e,Ps,t),a(e,re,t),a(e,Ls,t),a(e,he,t),a(e,Ds,t),c(ce,e,t),a(e,Ks,t),a(e,me,t),a(e,Os,t),c(ue,e,t),a(e,ea,t),c(R,e,t),a(e,ta,t),a(e,de,t),a(e,sa,t),c(ye,e,t),a(e,aa,t),a(e,v,t),M(v,X),M(X,ks),c(Me,ks,null),M(v,jn),M(v,Ms),a(e,la,t),a(e,fe,t),a(e,na,t),a(e,ge,t),a(e,pa,t),a(e,je,t),a(e,ia,t),c(we,e,t),a(e,oa,t),a(e,Je,t),a(e,ra,t),c(be,e,t),a(e,ha,t),a(e,k,t),M(k,Y),M(Y,xs),c(Te,xs,null),M(k,wn),M(k,fs),a(e,ca,t),a(e,Ue,t),a(e,ma,t),c(Ce,e,t),a(e,ua,t),a(e,x,t),M(x,N),M(N,$s),c(ve,$s,null),M(x,Jn),M(x,gs),a(e,da,t),a(e,ke,t),a(e,ya,t),c(xe,e,t),a(e,Ma,t),a(e,$e,t),a(e,fa,t),a(e,Ie,t),a(e,ga,t),a(e,Ze,t),a(e,ja,t),c(_e,e,t),a(e,wa,t),a(e,Ve,t),a(e,Ja,t),c(Ge,e,t),a(e,ba,t),a(e,Be,t),a(e,Ta,t),c(We,e,t),a(e,Ua,t),a(e,Re,t),a(e,Ca,t),a(e,$,t),M($,z),M(z,Is),c(Xe,Is,null),M($,bn),M($,js),a(e,va,t),a(e,Ye,t),a(e,ka,t),c(Ne,e,t),a(e,xa,t),a(e,ze,t),a(e,$a,t),c(Qe,e,t),a(e,Ia,t),a(e,Q,t),a(e,Za,t),a(e,Ae,t),a(e,_a,t),c(Ee,e,t),a(e,Va,t),a(e,Fe,t),a(e,Ga,t),c(He,e,t),a(e,Ba,t),a(e,qe,t),a(e,Wa,t),c(Se,e,t),a(e,Ra,t),a(e,Pe,t),a(e,Xa,t),a(e,Le,t),a(e,Ya,t),a(e,I,t),M(I,A),M(A,Zs),c(De,Zs,null),M(I,Tn),M(I,ws),a(e,Na,t),a(e,Ke,t),a(e,za,t),a(e,Oe,t),a(e,Qa,t),c(et,e,t),a(e,Aa,t),a(e,tt,t),a(e,Ea,t),a(e,st,t),a(e,Fa,t),a(e,Z,t),M(Z,E),M(E,_s),c(at,_s,null),M(Z,Un),M(Z,Js),a(e,Ha,t),a(e,lt,t),a(e,qa,t),c(nt,e,t),a(e,Sa,t),a(e,pt,t),a(e,Pa,t),c(it,e,t),a(e,La,t),a(e,ot,t),a(e,Da,t),c(rt,e,t),a(e,Ka,t),a(e,ht,t),a(e,Oa,t),c(ct,e,t),a(e,el,t),a(e,F,t),a(e,tl,t),a(e,mt,t),a(e,sl,t),a(e,ut,t),a(e,al,t),c(dt,e,t),a(e,ll,t),a(e,yt,t),a(e,nl,t),c(Mt,e,t),a(e,pl,t),a(e,ft,t),a(e,il,t),c(gt,e,t),a(e,ol,t),a(e,_,t),M(_,H),M(H,Vs),c(jt,Vs,null),M(_,Cn),M(_,bs),a(e,rl,t),a(e,wt,t),a(e,hl,t),c(Jt,e,t),a(e,cl,t),a(e,bt,t),a(e,ml,t),c(Tt,e,t),a(e,ul,t),a(e,V,t),M(V,q),M(q,Gs),c(Ut,Gs,null),M(V,vn),M(V,Ts),a(e,dl,t),a(e,Ct,t),a(e,yl,t),c(vt,e,t),a(e,Ml,t),a(e,kt,t),a(e,fl,t),c(xt,e,t),a(e,gl,t),a(e,$t,t),a(e,jl,t),c(It,e,t),a(e,wl,t),a(e,Zt,t),a(e,Jl,t),c(_t,e,t),a(e,bl,t),a(e,Vt,t),a(e,Tl,t),c(Gt,e,t),a(e,Ul,t),a(e,Bt,t),a(e,Cl,t),c(Wt,e,t),a(e,vl,t),a(e,Rt,t),a(e,kl,t),c(Xt,e,t),a(e,xl,t),a(e,G,t),M(G,S),M(S,Bs),c(Yt,Bs,null),M(G,kn),M(G,Us),a(e,$l,t),a(e,B,t),M(B,P),M(P,Ws),c(Nt,Ws,null),M(B,xn),M(B,Cs),a(e,Il,t),a(e,zt,t),a(e,Zl,t),c(Qt,e,t),a(e,_l,t),a(e,At,t),a(e,Vl,t),c(Et,e,t),a(e,Gl,t),a(e,Ft,t),a(e,Bl,t),c(Ht,e,t),a(e,Wl,t),a(e,qt,t),a(e,Rl,t),c(St,e,t),a(e,Xl,t),a(e,Pt,t),a(e,Yl,t),c(Lt,e,t),a(e,Nl,t),a(e,W,t),M(W,L),M(L,Rs),c(Dt,Rs,null),M(W,$n),M(W,vs),a(e,zl,t),a(e,Kt,t),a(e,Ql,t),a(e,Ot,t),a(e,Al,t),c(es,e,t),a(e,El,t),a(e,ts,t),a(e,Fl,t),c(ss,e,t),a(e,Hl,t),a(e,as,t),a(e,ql,t),c(ls,e,t),a(e,Sl,t),a(e,ns,t),a(e,Pl,t),c(ps,e,t),a(e,Ll,t),a(e,is,t),a(e,Dl,t),c(os,e,t),a(e,Kl,t),a(e,D,t),a(e,Ol,t),a(e,rs,t),a(e,en,t),c(hs,e,t),a(e,tn,t),a(e,cs,t),a(e,sn,t),a(e,ms,t),a(e,an,t),a(e,us,t),a(e,ln,t),a(e,Xs,t),nn=!0},p(e,[t]){const ds={};t&2&&(ds.$$scope={dirty:t,ctx:e}),R.$set(ds)},i(e){nn||(m(O.$$.fragment,e),m(ee.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(ce.$$.fragment,e),m(ue.$$.fragment,e),m(R.$$.fragment,e),m(ye.$$.fragment,e),m(Me.$$.fragment,e),m(we.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(xe.$$.fragment,e),m(_e.$$.fragment,e),m(Ge.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(Ne.$$.fragment,e),m(Qe.$$.fragment,e),m(Ee.$$.fragment,e),m(He.$$.fragment,e),m(Se.$$.fragment,e),m(De.$$.fragment,e),m(et.$$.fragment,e),m(at.$$.fragment,e),m(nt.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),m(dt.$$.fragment,e),m(Mt.$$.fragment,e),m(gt.$$.fragment,e),m(jt.$$.fragment,e),m(Jt.$$.fragment,e),m(Tt.$$.fragment,e),m(Ut.$$.fragment,e),m(vt.$$.fragment,e),m(xt.$$.fragment,e),m(It.$$.fragment,e),m(_t.$$.fragment,e),m(Gt.$$.fragment,e),m(Wt.$$.fragment,e),m(Xt.$$.fragment,e),m(Yt.$$.fragment,e),m(Nt.$$.fragment,e),m(Qt.$$.fragment,e),m(Et.$$.fragment,e),m(Ht.$$.fragment,e),m(St.$$.fragment,e),m(Lt.$$.fragment,e),m(Dt.$$.fragment,e),m(es.$$.fragment,e),m(ss.$$.fragment,e),m(ls.$$.fragment,e),m(ps.$$.fragment,e),m(os.$$.fragment,e),m(hs.$$.fragment,e),nn=!0)},o(e){u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(R.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(we.$$.fragment,e),u(be.$$.fragment,e),u(Te.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u(_e.$$.fragment,e),u(Ge.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ne.$$.fragment,e),u(Qe.$$.fragment,e),u(Ee.$$.fragment,e),u(He.$$.fragment,e),u(Se.$$.fragment,e),u(De.$$.fragment,e),u(et.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(it.$$.fragment,e),u(rt.$$.fragment,e),u(ct.$$.fragment,e),u(dt.$$.fragment,e),u(Mt.$$.fragment,e),u(gt.$$.fragment,e),u(jt.$$.fragment,e),u(Jt.$$.fragment,e),u(Tt.$$.fragment,e),u(Ut.$$.fragment,e),u(vt.$$.fragment,e),u(xt.$$.fragment,e),u(It.$$.fragment,e),u(_t.$$.fragment,e),u(Gt.$$.fragment,e),u(Wt.$$.fragment,e),u(Xt.$$.fragment,e),u(Yt.$$.fragment,e),u(Nt.$$.fragment,e),u(Qt.$$.fragment,e),u(Et.$$.fragment,e),u(Ht.$$.fragment,e),u(St.$$.fragment,e),u(Lt.$$.fragment,e),u(Dt.$$.fragment,e),u(es.$$.fragment,e),u(ss.$$.fragment,e),u(ls.$$.fragment,e),u(ps.$$.fragment,e),u(os.$$.fragment,e),u(hs.$$.fragment,e),nn=!1},d(e){e&&(s(K),s(U),s(b),s(J),s(Ns),s(zs),s(te),s(Qs),s(se),s(As),s(Es),s(le),s(Fs),s(Hs),s(pe),s(qs),s(ie),s(Ss),s(oe),s(Ps),s(re),s(Ls),s(he),s(Ds),s(Ks),s(me),s(Os),s(ea),s(ta),s(de),s(sa),s(aa),s(v),s(la),s(fe),s(na),s(ge),s(pa),s(je),s(ia),s(oa),s(Je),s(ra),s(ha),s(k),s(ca),s(Ue),s(ma),s(ua),s(x),s(da),s(ke),s(ya),s(Ma),s($e),s(fa),s(Ie),s(ga),s(Ze),s(ja),s(wa),s(Ve),s(Ja),s(ba),s(Be),s(Ta),s(Ua),s(Re),s(Ca),s($),s(va),s(Ye),s(ka),s(xa),s(ze),s($a),s(Ia),s(Q),s(Za),s(Ae),s(_a),s(Va),s(Fe),s(Ga),s(Ba),s(qe),s(Wa),s(Ra),s(Pe),s(Xa),s(Le),s(Ya),s(I),s(Na),s(Ke),s(za),s(Oe),s(Qa),s(Aa),s(tt),s(Ea),s(st),s(Fa),s(Z),s(Ha),s(lt),s(qa),s(Sa),s(pt),s(Pa),s(La),s(ot),s(Da),s(Ka),s(ht),s(Oa),s(el),s(F),s(tl),s(mt),s(sl),s(ut),s(al),s(ll),s(yt),s(nl),s(pl),s(ft),s(il),s(ol),s(_),s(rl),s(wt),s(hl),s(cl),s(bt),s(ml),s(ul),s(V),s(dl),s(Ct),s(yl),s(Ml),s(kt),s(fl),s(gl),s($t),s(jl),s(wl),s(Zt),s(Jl),s(bl),s(Vt),s(Tl),s(Ul),s(Bt),s(Cl),s(vl),s(Rt),s(kl),s(xl),s(G),s($l),s(B),s(Il),s(zt),s(Zl),s(_l),s(At),s(Vl),s(Gl),s(Ft),s(Bl),s(Wl),s(qt),s(Rl),s(Xl),s(Pt),s(Yl),s(Nl),s(W),s(zl),s(Kt),s(Ql),s(Ot),s(Al),s(El),s(ts),s(Fl),s(Hl),s(as),s(ql),s(Sl),s(ns),s(Pl),s(Ll),s(is),s(Dl),s(Kl),s(D),s(Ol),s(rs),s(en),s(tn),s(cs),s(sn),s(ms),s(an),s(us),s(ln),s(Xs)),s(w),d(O),d(ee,e),d(ae,e),d(ne,e),d(ce,e),d(ue,e),d(R,e),d(ye,e),d(Me),d(we,e),d(be,e),d(Te),d(Ce,e),d(ve),d(xe,e),d(_e,e),d(Ge,e),d(We,e),d(Xe),d(Ne,e),d(Qe,e),d(Ee,e),d(He,e),d(Se,e),d(De),d(et,e),d(at),d(nt,e),d(it,e),d(rt,e),d(ct,e),d(dt,e),d(Mt,e),d(gt,e),d(jt),d(Jt,e),d(Tt,e),d(Ut),d(vt,e),d(xt,e),d(It,e),d(_t,e),d(Gt,e),d(Wt,e),d(Xt,e),d(Yt),d(Nt),d(Qt,e),d(Et,e),d(Ht,e),d(St,e),d(Lt,e),d(Dt),d(es,e),d(ss,e),d(ls,e),d(ps,e),d(os,e),d(hs,e)}}}const Wi={local:"text-to-speech",sections:[{local:"load-the-dataset",title:"Load the dataset"},{local:"preprocess-the-data",sections:[{local:"text-cleanup-for-speecht5-tokenization",title:"Text cleanup for SpeechT5 tokenization "},{local:"speakers",title:"Speakers"},{local:"speaker-embeddings",title:"Speaker embeddings"},{local:"processing-the-dataset",title:"Processing the dataset"},{local:"data-collator",title:"Data collator"}],title:"Preprocess the data"},{local:"train-the-model",title:"Train the model"},{local:"inference",sections:[{local:"inference-with-a-pipeline",title:"Inference with a pipeline"},{local:"run-inference-manually",title:"Run inference manually"}],title:"Inference"}],title:"Text to speech"};function Ri(Ys){return ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ei extends $i{constructor(w){super(),Ii(this,w,Ri,Bi,vi,{})}}export{Ei as component};
