import{s as wt,n as xt,o as vt}from"../chunks/scheduler.9bc65507.js";import{S as Jt,i as Ut,g as i,s as l,u as h,A as Ct,h as o,f as t,c as n,j as b,v as m,y as p,k as r,o as c,a,w as g,d as f,t as u,x as d}from"../chunks/index.78c82d43.js";import{I as Xs}from"../chunks/IconCopyLink.bedaa44d.js";import{C as T}from"../chunks/CodeBlock.73e038be.js";import{D as Tt}from"../chunks/DocNotebookDropdown.31840a23.js";function kt(As){let y,rs,ls,cs,j,x,ns,k,Fs,ts,Ps="Zero-shot image classification",hs,$,ms,Z,Ds=`Zero-shot image classification is a task that involves classifying images into different categories using a model that was
not explicitly trained on data containing labeled examples from those specific categories.`,gs,_,Ls=`Traditionally, image classification requires training a model on a specific set of labeled images, and this model learns to
“map” certain image features to labels. When there’s a need to use such model for a classification task that introduces a
new set of labels, fine-tuning is required to “recalibrate” the model.`,fs,R,Ks=`In contrast, zero-shot or open vocabulary image classification models are typically multi-modal models that have been trained on a large
dataset of images and associated descriptions. These models learn aligned vision-language representations that can be used for many downstream tasks including zero-shot image classification.`,us,z,Os=`This is a more flexible approach to image classification that allows models to generalize to new and unseen categories
without the need for additional training data and enables users to query images with free-form text descriptions of their target objects .`,ds,I,st="In this guide you’ll learn how to:",bs,G,tt="<li>create a zero-shot image classification pipeline</li> <li>run zero-shot image classification inference by hand</li>",ys,E,et="Before you begin, make sure you have all the necessary libraries installed:",js,W,Ms,M,v,is,N,Qs,es,at="Zero-shot image classification pipeline",ws,H,lt=`The simplest way to try out inference with a model supporting zero-shot image classification is to use the corresponding <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,xs,B,vs,Y,nt="Next, choose an image you’d like to classify.",Js,S,Us,J,it='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/owl.jpg" alt="Photo of an owl"/>',Cs,q,ot=`Pass the image and the candidate object labels to the pipeline. Here we pass the image directly; other suitable options
include a local path to an image or an image url.
The candidate labels can be simple words like in this example, or more descriptive.`,Ts,F,ks,w,U,os,Q,Vs,as,pt="Zero-shot image classification by hand",$s,V,rt=`Now that you’ve seen how to use the zero-shot image classification pipeline, let’s take a look how you can run zero-shot
image classification manually.`,Zs,X,ct=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,_s,A,Rs,P,ht="Let’s take a different image to switch things up.",zs,D,Is,C,mt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/car.jpg" alt="Photo of a car"/>',Gs,L,gt=`Use the processor to prepare the inputs for the model. The processor combines an image processor that prepares the
image for the model by resizing and normalizing it, and a tokenizer that takes care of the text inputs.`,Es,K,Ws,O,ft="Pass the inputs through the model, and post-process the results:",Ns,ss,Hs,ps,Bs;return k=new Xs({}),$=new Tt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_image_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_image_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_image_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_image_classification.ipynb"}]}}),W=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),N=new Xs({}),B=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm9wZW5haSUyRmNsaXAtdml0LWxhcmdlLXBhdGNoMTQlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-image-classification&quot;</span>)`,wrap:!1}}),S=new T({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRmc4b1M4LTgyRHhJJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4MGIzQnBZM3g4U25Cbk5rdHBaR3d0U0d0OGZIeDhmREo4ZkRFMk56Z3hNRFl3T0RjJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/g8oS8-82DxI/download?ixid=MnwxMjA3fDB8MXx0b3BpY3x8SnBnNktpZGwtSGt8fHx8fDJ8fDE2NzgxMDYwODc&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),F=new T({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvcihpbWFnZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJmb3glMjIlMkMlMjAlMjJiZWFyJTIyJTJDJTIwJTIyc2VhZ3VsbCUyMiUyQyUyMCUyMm93bCUyMiU1RCklMEFwcmVkaWN0aW9ucw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(image, candidate_labels=[<span class="hljs-string">&quot;fox&quot;</span>, <span class="hljs-string">&quot;bear&quot;</span>, <span class="hljs-string">&quot;seagull&quot;</span>, <span class="hljs-string">&quot;owl&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9996670484542847</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;owl&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.000199399160919711</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;seagull&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">7.392891711788252e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fox&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">5.96074532950297e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bear&#x27;</span>}]`,wrap:!1}}),Q=new Xs({}),A=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),D=new T({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRnhCUlFmUjJicU5JJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4aGJHeDhmSHg4Zkh4OGZId3hOamM0TXpnNE9ERXglMjZmb3JjZSUzRHRydWUlMjZ3JTNENjQwJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2U=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/xBRQfR2bqNI/download?ixid=MnwxMjA3fDB8MXxhbGx8fHx8fHx8fHwxNjc4Mzg4ODEx&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),K=new T({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMnRyZWUlMjIlMkMlMjAlMjJjYXIlMjIlMkMlMjAlMjJiaWtlJTIyJTJDJTIwJTIyY2F0JTIyJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRGNhbmRpZGF0ZV9sYWJlbHMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;tree&quot;</span>, <span class="hljs-string">&quot;car&quot;</span>, <span class="hljs-string">&quot;bike&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=candidate_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),ss=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzX3Blcl9pbWFnZSU1QjAlNUQlMEFwcm9icyUyMCUzRCUyMGxvZ2l0cy5zb2Z0bWF4KGRpbSUzRC0xKS5udW1weSgpJTBBc2NvcmVzJTIwJTNEJTIwcHJvYnMudG9saXN0KCklMEElMEFyZXN1bHQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMHNjb3JlJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBjYW5kaWRhdGVfbGFiZWwlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBzY29yZSUyQyUyMGNhbmRpZGF0ZV9sYWJlbCUyMGluJTIwc29ydGVkKHppcChwcm9icyUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMpJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMC14JTVCMCU1RCklMEElNUQlMEElMEFyZXN1bHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits_per_image[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits.softmax(dim=-<span class="hljs-number">1</span>).numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>scores = probs.tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span>result = [
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;label&quot;</span>: candidate_label}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> score, candidate_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">sorted</span>(<span class="hljs-built_in">zip</span>(probs, candidate_labels), key=<span class="hljs-keyword">lambda</span> x: -x[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>result
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.998572</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;car&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0010570387</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bike&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0003393686</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tree&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">3.1572064e-05</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}]`,wrap:!1}}),{c(){y=i("meta"),rs=l(),ls=i("p"),cs=l(),j=i("h1"),x=i("a"),ns=i("span"),h(k.$$.fragment),Fs=l(),ts=i("span"),ts.textContent=Ps,hs=l(),h($.$$.fragment),ms=l(),Z=i("p"),Z.textContent=Ds,gs=l(),_=i("p"),_.textContent=Ls,fs=l(),R=i("p"),R.textContent=Ks,us=l(),z=i("p"),z.textContent=Os,ds=l(),I=i("p"),I.textContent=st,bs=l(),G=i("ul"),G.innerHTML=tt,ys=l(),E=i("p"),E.textContent=et,js=l(),h(W.$$.fragment),Ms=l(),M=i("h2"),v=i("a"),is=i("span"),h(N.$$.fragment),Qs=l(),es=i("span"),es.textContent=at,ws=l(),H=i("p"),H.innerHTML=lt,xs=l(),h(B.$$.fragment),vs=l(),Y=i("p"),Y.textContent=nt,Js=l(),h(S.$$.fragment),Us=l(),J=i("div"),J.innerHTML=it,Cs=l(),q=i("p"),q.textContent=ot,Ts=l(),h(F.$$.fragment),ks=l(),w=i("h2"),U=i("a"),os=i("span"),h(Q.$$.fragment),Vs=l(),as=i("span"),as.textContent=pt,$s=l(),V=i("p"),V.textContent=rt,Zs=l(),X=i("p"),X.innerHTML=ct,_s=l(),h(A.$$.fragment),Rs=l(),P=i("p"),P.textContent=ht,zs=l(),h(D.$$.fragment),Is=l(),C=i("div"),C.innerHTML=mt,Gs=l(),L=i("p"),L.textContent=gt,Es=l(),h(K.$$.fragment),Ws=l(),O=i("p"),O.textContent=ft,Ns=l(),h(ss.$$.fragment),Hs=l(),ps=i("p"),this.h()},l(s){const e=Ct("svelte-1phssyn",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(t),rs=n(s),ls=o(s,"P",{}),b(ls).forEach(t),cs=n(s),j=o(s,"H1",{class:!0});var Ys=b(j);x=o(Ys,"A",{id:!0,class:!0,href:!0});var ut=b(x);ns=o(ut,"SPAN",{});var dt=b(ns);m(k.$$.fragment,dt),dt.forEach(t),ut.forEach(t),Fs=n(Ys),ts=o(Ys,"SPAN",{"data-svelte-h":!0}),p(ts)!=="svelte-1ja1cxh"&&(ts.textContent=Ps),Ys.forEach(t),hs=n(s),m($.$$.fragment,s),ms=n(s),Z=o(s,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1epp0bd"&&(Z.textContent=Ds),gs=n(s),_=o(s,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1cxdsqr"&&(_.textContent=Ls),fs=n(s),R=o(s,"P",{"data-svelte-h":!0}),p(R)!=="svelte-162gw8s"&&(R.textContent=Ks),us=n(s),z=o(s,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1e19xpt"&&(z.textContent=Os),ds=n(s),I=o(s,"P",{"data-svelte-h":!0}),p(I)!=="svelte-jr2b5g"&&(I.textContent=st),bs=n(s),G=o(s,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-d1jtl1"&&(G.innerHTML=tt),ys=n(s),E=o(s,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1c9nexd"&&(E.textContent=et),js=n(s),m(W.$$.fragment,s),Ms=n(s),M=o(s,"H2",{class:!0});var Ss=b(M);v=o(Ss,"A",{id:!0,class:!0,href:!0});var bt=b(v);is=o(bt,"SPAN",{});var yt=b(is);m(N.$$.fragment,yt),yt.forEach(t),bt.forEach(t),Qs=n(Ss),es=o(Ss,"SPAN",{"data-svelte-h":!0}),p(es)!=="svelte-8vrmh1"&&(es.textContent=at),Ss.forEach(t),ws=n(s),H=o(s,"P",{"data-svelte-h":!0}),p(H)!=="svelte-4lia7t"&&(H.innerHTML=lt),xs=n(s),m(B.$$.fragment,s),vs=n(s),Y=o(s,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1de5ng0"&&(Y.textContent=nt),Js=n(s),m(S.$$.fragment,s),Us=n(s),J=o(s,"DIV",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-10yxso1"&&(J.innerHTML=it),Cs=n(s),q=o(s,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ufa490"&&(q.textContent=ot),Ts=n(s),m(F.$$.fragment,s),ks=n(s),w=o(s,"H2",{class:!0});var qs=b(w);U=o(qs,"A",{id:!0,class:!0,href:!0});var jt=b(U);os=o(jt,"SPAN",{});var Mt=b(os);m(Q.$$.fragment,Mt),Mt.forEach(t),jt.forEach(t),Vs=n(qs),as=o(qs,"SPAN",{"data-svelte-h":!0}),p(as)!=="svelte-wir4g3"&&(as.textContent=pt),qs.forEach(t),$s=n(s),V=o(s,"P",{"data-svelte-h":!0}),p(V)!=="svelte-8eyj4j"&&(V.textContent=rt),Zs=n(s),X=o(s,"P",{"data-svelte-h":!0}),p(X)!=="svelte-2afjdk"&&(X.innerHTML=ct),_s=n(s),m(A.$$.fragment,s),Rs=n(s),P=o(s,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1g7c1zc"&&(P.textContent=ht),zs=n(s),m(D.$$.fragment,s),Is=n(s),C=o(s,"DIV",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-1kfxibh"&&(C.innerHTML=mt),Gs=n(s),L=o(s,"P",{"data-svelte-h":!0}),p(L)!=="svelte-17gc4h7"&&(L.textContent=gt),Es=n(s),m(K.$$.fragment,s),Ws=n(s),O=o(s,"P",{"data-svelte-h":!0}),p(O)!=="svelte-n1saee"&&(O.textContent=ft),Ns=n(s),m(ss.$$.fragment,s),Hs=n(s),ps=o(s,"P",{}),b(ps).forEach(t),this.h()},h(){r(y,"name","hf:doc:metadata"),r(y,"content",JSON.stringify($t)),r(x,"id","zeroshot-image-classification"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#zeroshot-image-classification"),r(j,"class","relative group"),r(v,"id","zeroshot-image-classification-pipeline"),r(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(v,"href","#zeroshot-image-classification-pipeline"),r(M,"class","relative group"),r(J,"class","flex justify-center"),r(U,"id","zeroshot-image-classification-by-hand"),r(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(U,"href","#zeroshot-image-classification-by-hand"),r(w,"class","relative group"),r(C,"class","flex justify-center")},m(s,e){c(document.head,y),a(s,rs,e),a(s,ls,e),a(s,cs,e),a(s,j,e),c(j,x),c(x,ns),g(k,ns,null),c(j,Fs),c(j,ts),a(s,hs,e),g($,s,e),a(s,ms,e),a(s,Z,e),a(s,gs,e),a(s,_,e),a(s,fs,e),a(s,R,e),a(s,us,e),a(s,z,e),a(s,ds,e),a(s,I,e),a(s,bs,e),a(s,G,e),a(s,ys,e),a(s,E,e),a(s,js,e),g(W,s,e),a(s,Ms,e),a(s,M,e),c(M,v),c(v,is),g(N,is,null),c(M,Qs),c(M,es),a(s,ws,e),a(s,H,e),a(s,xs,e),g(B,s,e),a(s,vs,e),a(s,Y,e),a(s,Js,e),g(S,s,e),a(s,Us,e),a(s,J,e),a(s,Cs,e),a(s,q,e),a(s,Ts,e),g(F,s,e),a(s,ks,e),a(s,w,e),c(w,U),c(U,os),g(Q,os,null),c(w,Vs),c(w,as),a(s,$s,e),a(s,V,e),a(s,Zs,e),a(s,X,e),a(s,_s,e),g(A,s,e),a(s,Rs,e),a(s,P,e),a(s,zs,e),g(D,s,e),a(s,Is,e),a(s,C,e),a(s,Gs,e),a(s,L,e),a(s,Es,e),g(K,s,e),a(s,Ws,e),a(s,O,e),a(s,Ns,e),g(ss,s,e),a(s,Hs,e),a(s,ps,e),Bs=!0},p:xt,i(s){Bs||(f(k.$$.fragment,s),f($.$$.fragment,s),f(W.$$.fragment,s),f(N.$$.fragment,s),f(B.$$.fragment,s),f(S.$$.fragment,s),f(F.$$.fragment,s),f(Q.$$.fragment,s),f(A.$$.fragment,s),f(D.$$.fragment,s),f(K.$$.fragment,s),f(ss.$$.fragment,s),Bs=!0)},o(s){u(k.$$.fragment,s),u($.$$.fragment,s),u(W.$$.fragment,s),u(N.$$.fragment,s),u(B.$$.fragment,s),u(S.$$.fragment,s),u(F.$$.fragment,s),u(Q.$$.fragment,s),u(A.$$.fragment,s),u(D.$$.fragment,s),u(K.$$.fragment,s),u(ss.$$.fragment,s),Bs=!1},d(s){s&&(t(rs),t(ls),t(cs),t(j),t(hs),t(ms),t(Z),t(gs),t(_),t(fs),t(R),t(us),t(z),t(ds),t(I),t(bs),t(G),t(ys),t(E),t(js),t(Ms),t(M),t(ws),t(H),t(xs),t(vs),t(Y),t(Js),t(Us),t(J),t(Cs),t(q),t(Ts),t(ks),t(w),t($s),t(V),t(Zs),t(X),t(_s),t(Rs),t(P),t(zs),t(Is),t(C),t(Gs),t(L),t(Es),t(Ws),t(O),t(Ns),t(Hs),t(ps)),t(y),d(k),d($,s),d(W,s),d(N),d(B,s),d(S,s),d(F,s),d(Q),d(A,s),d(D,s),d(K,s),d(ss,s)}}}const $t={local:"zeroshot-image-classification",sections:[{local:"zeroshot-image-classification-pipeline",title:"Zero-shot image classification pipeline"},{local:"zeroshot-image-classification-by-hand",title:"Zero-shot image classification by hand"}],title:"Zero-shot image classification"};function Zt(As){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Jt{constructor(y){super(),Ut(this,y,Zt,kt,wt,{})}}export{Et as component};
