import{s as Le,f as Ae,n as De,o as Pe}from"../chunks/scheduler.9bc65507.js";import{S as Ke,i as Oe,g as p,s as l,u as c,A as sa,h as i,f as t,c as n,j as M,v as h,y as o,k as r,o as m,a,w as g,d as u,t as d,x as y}from"../chunks/index.78c82d43.js";import{I as qs}from"../chunks/IconCopyLink.bedaa44d.js";import{C as j}from"../chunks/CodeBlock.73e038be.js";import{D as ta}from"../chunks/DocNotebookDropdown.31840a23.js";function ea(se){let J,Xs,Zs,Es,w,v,Rs,N,At,ks,te="Zero-shot object detection",Gs,H,Ys,B,ee=`Traditionally, models used for <a href="object_detection">object detection</a> require labeled image datasets for training,
and are limited to detecting the set of classes from the training data.`,Ss,q,ae=`Zero-shot object detection is supported by the <a href="../model_doc/owlvit">OWL-ViT</a> model which uses a different approach. OWL-ViT
is an open-vocabulary object detector. It means that it can detect objects in images based on free-text queries without
the need to fine-tune the model on labeled datasets.`,Fs,X,le=`OWL-ViT leverages multi-modal representations to perform open-vocabulary detection. It combines <a href="../model_doc/clip">CLIP</a> with
lightweight object classification and localization heads. Open-vocabulary detection is achieved by embedding free-text queries with the text encoder of CLIP and using them as input to the object classification and localization heads.
associate images and their corresponding textual descriptions, and ViT processes image patches as inputs. The authors
of OWL-ViT first trained CLIP from scratch and then fine-tuned OWL-ViT end to end on standard object detection datasets using
a bipartite matching loss.`,Ls,E,ne="With this approach, the model can detect objects based on textual descriptions without prior training on labeled datasets.",As,G,pe="In this guide, you will learn how to use OWL-ViT:",Ds,Y,ie="<li>to detect objects based on text prompts</li> <li>for batch object detection</li> <li>for image-guided object detection</li>",Ps,S,oe="Before you begin, make sure you have all the necessary libraries installed:",Ks,F,Os,U,C,Qs,L,Dt,Is,re="Zero-shot object detection pipeline",st,A,ce=`The simplest way to try out inference with OWL-ViT is to use it in a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. Instantiate a pipeline
for zero-shot object detection from a <a href="https://huggingface.co/models?other=owlvit" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,tt,D,et,P,he=`Next, choose an image you’d like to detect objects in. Here we’ll use the image of astronaut Eileen Collins that is
a part of the <a href="https://www.nasa.gov/multimedia/imagegallery/index.html" rel="nofollow">NASA</a> Great Images dataset.`,at,K,lt,W,me='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_1.png" alt="Astronaut Eileen Collins"/>',nt,O,ge=`Pass the image and the candidate object labels to look for to the pipeline.
Here we pass the image directly; other suitable options include a local path to an image or an image url. We also pass text descriptions for all items we want to query the image for.`,pt,ss,it,ts,ue="Let’s visualize the predictions:",ot,es,rt,k,de='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_2.png" alt="Visualized predictions on NASA image"/>',ct,f,I,Vs,as,Pt,_s,ye="Text-prompted zero-shot object detection by hand",ht,ls,Me=`Now that you’ve seen how to use the zero-shot object detection pipeline, let’s replicate the same
result manually.`,mt,ns,je=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?other=owlvit" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,gt,ps,ut,is,be="Let’s take a different image to switch things up.",dt,os,yt,_,Je='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_3.png" alt="Beach photo"/>',Mt,rs,we=`Use the processor to prepare the inputs for the model. The processor combines an image processor that prepares the
image for the model by resizing and normalizing it, and a <a href="/docs/transformers/v4.34.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> that takes care of the text inputs.`,jt,cs,bt,hs,Ue=`Pass the inputs through the model, post-process, and visualize the results. Since the image processor resized images before
feeding them to the model, you need to use the <a href="/docs/transformers/v4.34.0/en/model_doc/owlvit#transformers.OwlViTImageProcessor.post_process_object_detection">post_process_object_detection()</a> method to make sure the predicted bounding
boxes have the correct coordinates relative to the original image:`,Jt,ms,wt,z,fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',Ut,x,$,Ns,gs,Kt,zs,xe="Batch processing",ft,us,Te=`You can pass multiple sets of images and text queries to search for different (or same) objects in several images.
Let’s use both an astronaut image and the beach image together.
For batch processing, you should pass text queries as a nested list to the processor and images as lists of PIL images,
PyTorch tensors, or NumPy arrays.`,xt,ds,Tt,ys,ve=`Previously for post-processing you passed the single image’s size as a tensor, but you can also pass a tuple, or, in case
of several images, a list of tuples. Let’s create predictions for the two examples, and visualize the second one (<code>image_idx = 1</code>).`,vt,Ms,Ct,Z,Ce='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_4.png" alt="Beach photo with detected objects"/>',Wt,T,R,Hs,js,Ot,$s,We="Image-guided object detection",kt,bs,ke=`In addition to zero-shot object detection with text queries, OWL-ViT offers image-guided object detection. This means
you can use an image query to find similar objects in the target image.
Unlike text queries, only a single example image is allowed.`,It,Js,Ie=`Let’s take an image with two cats on a couch as a target image, and an image of a single cat
as a query:`,_t,ws,zt,Us,_e="Let’s take a quick look at the images:",$t,fs,Zt,Q,ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_5.png" alt="Cats"/>',Rt,xs,$e="In the preprocessing step, instead of text queries, you now need to use <code>query_images</code>:",Qt,Ts,Vt,vs,Ze=`For predictions, instead of passing the inputs to the model, pass them to <a href="/docs/transformers/v4.34.0/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">image_guided_detection()</a>. Draw the predictions
as before except now there are no labels.`,Nt,Cs,Ht,V,Re='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/zero-sh-obj-detection_6.png" alt="Cats with bounding boxes"/>',Bt,Ws,Qe="If you’d like to interactively try out inference with OWL-ViT, check out this demo:",qt,b,Ve,Xt,Bs,Et;return N=new qs({}),H=new ta({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/zero_shot_object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/zero_shot_object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/zero_shot_object_detection.ipynb"}]}}),F=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),L=new qs({}),D=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRm93bHZpdC1iYXNlLXBhdGNoMzIlMjIlMEFkZXRlY3RvciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEY2hlY2twb2ludCUyQyUyMHRhc2slM0QlMjJ6ZXJvLXNob3Qtb2JqZWN0LWRldGVjdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(model=checkpoint, task=<span class="hljs-string">&quot;zero-shot-object-detection&quot;</span>)`,wrap:!1}}),K=new j({props:{code:"aW1wb3J0JTIwc2tpbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQWltYWdlJTIwJTNEJTIwc2tpbWFnZS5kYXRhLmFzdHJvbmF1dCgpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkobnAudWludDgoaW1hZ2UpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> skimage
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = skimage.data.astronaut()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.fromarray(np.uint8(image)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),ss=new j({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXRlY3RvciglMEElMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNhbmRpZGF0ZV9sYWJlbHMlM0QlNUIlMjJodW1hbiUyMGZhY2UlMjIlMkMlMjAlMjJyb2NrZXQlMjIlMkMlMjAlMjJuYXNhJTIwYmFkZ2UlMjIlMkMlMjAlMjJzdGFyLXNwYW5nbGVkJTIwYmFubmVyJTIyJTVEJTJDJTBBKSUwQXByZWRpY3Rpb25z",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = detector(
<span class="hljs-meta">... </span>    image,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>predictions
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3571370542049408</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;human face&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">180</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">71</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">271</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">178</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.28099656105041504</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">129</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">348</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">206</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">427</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2110239565372467</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">350</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: -<span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">468</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">288</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13790413737297058</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;star-spangled banner&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">105</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">509</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.11950037628412247</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;nasa badge&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">277</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">338</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">327</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">380</span>}},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10649408400058746</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;rocket&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">358</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">64</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">424</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">280</span>}}]`,wrap:!1}}),es=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlRHJhdyUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFmb3IlMjBwcmVkaWN0aW9uJTIwaW4lMjBwcmVkaWN0aW9ucyUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJib3glMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbCUyMCUzRCUyMHByZWRpY3Rpb24lNUIlMjJsYWJlbCUyMiU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlJTIwJTNEJTIwcHJlZGljdGlvbiU1QiUyMnNjb3JlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIweG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCUyMCUzRCUyMGJveC52YWx1ZXMoKSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUyQyUyMG91dGxpbmUlM0QlMjJyZWQlMjIlMkMlMjB3aWR0aCUzRDEpJTBBJTIwJTIwJTIwJTIwZHJhdy50ZXh0KCh4bWluJTJDJTIweW1pbiklMkMlMjBmJTIyJTdCbGFiZWwlN0QlM0ElMjAlN0Jyb3VuZChzY29yZSUyQzIpJTdEJTIyJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prediction <span class="hljs-keyword">in</span> predictions:
<span class="hljs-meta">... </span>    box = prediction[<span class="hljs-string">&quot;box&quot;</span>]
<span class="hljs-meta">... </span>    label = prediction[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>    score = prediction[<span class="hljs-string">&quot;score&quot;</span>]

<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box.values()
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{label}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),as=new qs({}),ps=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),os=new j({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRm9qMHplWTJMdGs0JTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TVRSOGZIQnBZMjVwWTN4bGJud3dmSHg4ZkRFMk56YzBPVEUxTkRrJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlt",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/oj0zeY2Ltk4/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MTR8fHBpY25pY3xlbnwwfHx8fDE2Nzc0OTE1NDk&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>im = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),cs=new j({props:{code:"dGV4dF9xdWVyaWVzJTIwJTNEJTIwJTVCJTIyaGF0JTIyJTJDJTIwJTIyYm9vayUyMiUyQyUyMCUyMnN1bmdsYXNzZXMlMjIlMkMlMjAlMjJjYW1lcmElMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRfcXVlcmllcyUyQyUyMGltYWdlcyUzRGltJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=im, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),ms=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHByb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC4xJTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QjAlNUQlMEElMEFkcmF3JTIwJTNEJTIwSW1hZ2VEcmF3LkRyYXcoaW0pJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWxhYmVscyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQudG9saXN0KCklMEFib3hlcyUyMCUzRCUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RC50b2xpc3QoKSUwQSUwQWZvciUyMGJveCUyQyUyMHNjb3JlJTJDJTIwbGFiZWwlMjBpbiUyMHppcChib3hlcyUyQyUyMHNjb3JlcyUyQyUyMGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjB4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4JTIwJTNEJTIwYm94JTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHhtaW4lMkMlMjB5bWluKSUyQyUyMGYlMjIlN0J0ZXh0X3F1ZXJpZXMlNUJsYWJlbCU1RCU3RCUzQSUyMCU3QnJvdW5kKHNjb3JlJTJDMiklN0QlMjIlMkMlMjBmaWxsJTNEJTIyd2hpdGUlMjIpJTBBJTBBaW0=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([im.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(im)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>im`,wrap:!1}}),gs=new qs({}),ds=new j({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCaW1hZ2UlMkMlMjBpbSU1RCUwQXRleHRfcXVlcmllcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU1QiUyMmh1bWFuJTIwZmFjZSUyMiUyQyUyMCUyMnJvY2tldCUyMiUyQyUyMCUyMm5hc2ElMjBiYWRnZSUyMiUyQyUyMCUyMnN0YXItc3BhbmdsZWQlMjBiYW5uZXIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJoYXQlMjIlMkMlMjAlMjJib29rJTIyJTJDJTIwJTIyc3VuZ2xhc3NlcyUyMiUyQyUyMCUyMmNhbWVyYSUyMiU1RCUyQyUwQSU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dF9xdWVyaWVzJTJDJTIwaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [image, im]
<span class="hljs-meta">&gt;&gt;&gt; </span>text_queries = [
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;human face&quot;</span>, <span class="hljs-string">&quot;rocket&quot;</span>, <span class="hljs-string">&quot;nasa badge&quot;</span>, <span class="hljs-string">&quot;star-spangled banner&quot;</span>],
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;hat&quot;</span>, <span class="hljs-string">&quot;book&quot;</span>, <span class="hljs-string">&quot;sunglasses&quot;</span>, <span class="hljs-string">&quot;camera&quot;</span>],
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text_queries, images=images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Ms=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjAlNUJ4LnNpemUlNUIlM0ElM0EtMSU1RCUyMGZvciUyMHglMjBpbiUyMGltYWdlcyU1RCUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuMSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklMEElMEFpbWFnZV9pZHglMjAlM0QlMjAxJTBBZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlcyU1QmltYWdlX2lkeCU1RCklMEElMEFzY29yZXMlMjAlM0QlMjByZXN1bHRzJTVCaW1hZ2VfaWR4JTVEJTVCJTIyc2NvcmVzJTIyJTVELnRvbGlzdCgpJTBBbGFiZWxzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmxhYmVscyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QmltYWdlX2lkeCU1RCU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeG1pbiUyQyUyMHltaW4pJTJDJTIwZiUyMiU3QnRleHRfcXVlcmllcyU1QmltYWdlX2lkeCU1RCU1QmxhYmVsJTVEJTdEJTNBJTIwJTdCcm91bmQoc2NvcmUlMkMyKSU3RCUyMiUyQyUyMGZpbGwlM0QlMjJ3aGl0ZSUyMiklMEElMEFpbWFnZXMlNUJpbWFnZV9pZHglNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = [x.size[::-<span class="hljs-number">1</span>] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> images]
<span class="hljs-meta">... </span>    results = processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_idx = <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(images[image_idx])

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[image_idx][<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = results[image_idx][<span class="hljs-string">&quot;labels&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[image_idx][<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((xmin, ymin), <span class="hljs-string">f&quot;<span class="hljs-subst">{text_queries[image_idx][label]}</span>: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score,<span class="hljs-number">2</span>)}</span>&quot;</span>, fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images[image_idx]`,wrap:!1}}),js=new qs({}),ws=new j({props:{code:"dXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlX3RhcmdldCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFxdWVyeV91cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDA1MjQyODAuanBnJTIyJTBBcXVlcnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldChxdWVyeV91cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_target = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000524280.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)`,wrap:!1}}),fs=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4JTIwJTNEJTIwcGx0LnN1YnBsb3RzKDElMkMlMjAyKSUwQWF4JTVCMCU1RC5pbXNob3coaW1hZ2VfdGFyZ2V0KSUwQWF4JTVCMSU1RC5pbXNob3cocXVlcnlfaW1hZ2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">0</span>].imshow(image_target)
<span class="hljs-meta">&gt;&gt;&gt; </span>ax[<span class="hljs-number">1</span>].imshow(query_image)`,wrap:!1}}),Ts=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlX3RhcmdldCUyQyUyMHF1ZXJ5X2ltYWdlcyUzRHF1ZXJ5X2ltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image_target, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Cs=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5pbWFnZV9ndWlkZWRfZGV0ZWN0aW9uKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMHRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZV90YXJnZXQuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2ltYWdlX2d1aWRlZF9kZXRlY3Rpb24ob3V0cHV0cyUzRG91dHB1dHMlMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RCUwQSUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZV90YXJnZXQpJTBBJTBBc2NvcmVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RC50b2xpc3QoKSUwQWJveGVzJTIwJTNEJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVELnRvbGlzdCgpJTBBJTBBZm9yJTIwYm94JTJDJTIwc2NvcmUlMkMlMjBsYWJlbCUyMGluJTIwemlwKGJveGVzJTJDJTIwc2NvcmVzJTJDJTIwbGFiZWxzKSUzQSUwQSUyMCUyMCUyMCUyMHhtaW4lMkMlMjB5bWluJTJDJTIweG1heCUyQyUyMHltYXglMjAlM0QlMjBib3glMEElMjAlMjAlMjAlMjBkcmF3LnJlY3RhbmdsZSgoeG1pbiUyQyUyMHltaW4lMkMlMjB4bWF4JTJDJTIweW1heCklMkMlMjBvdXRsaW5lJTNEJTIyd2hpdGUlMjIlMkMlMjB3aWR0aCUzRDQpJTBBJTBBaW1hZ2VfdGFyZ2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image_target.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = processor.post_process_image_guided_detection(outputs=outputs, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image_target)

<span class="hljs-meta">&gt;&gt;&gt; </span>scores = results[<span class="hljs-string">&quot;scores&quot;</span>].tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = results[<span class="hljs-string">&quot;boxes&quot;</span>].tolist()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    xmin, ymin, xmax, ymax = box
<span class="hljs-meta">... </span>    draw.rectangle((xmin, ymin, xmax, ymax), outline=<span class="hljs-string">&quot;white&quot;</span>, width=<span class="hljs-number">4</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_target`,wrap:!1}}),{c(){J=p("meta"),Xs=l(),Zs=p("p"),Es=l(),w=p("h1"),v=p("a"),Rs=p("span"),c(N.$$.fragment),At=l(),ks=p("span"),ks.textContent=te,Gs=l(),c(H.$$.fragment),Ys=l(),B=p("p"),B.innerHTML=ee,Ss=l(),q=p("p"),q.innerHTML=ae,Fs=l(),X=p("p"),X.innerHTML=le,Ls=l(),E=p("p"),E.textContent=ne,As=l(),G=p("p"),G.textContent=pe,Ds=l(),Y=p("ul"),Y.innerHTML=ie,Ps=l(),S=p("p"),S.textContent=oe,Ks=l(),c(F.$$.fragment),Os=l(),U=p("h2"),C=p("a"),Qs=p("span"),c(L.$$.fragment),Dt=l(),Is=p("span"),Is.textContent=re,st=l(),A=p("p"),A.innerHTML=ce,tt=l(),c(D.$$.fragment),et=l(),P=p("p"),P.innerHTML=he,at=l(),c(K.$$.fragment),lt=l(),W=p("div"),W.innerHTML=me,nt=l(),O=p("p"),O.textContent=ge,pt=l(),c(ss.$$.fragment),it=l(),ts=p("p"),ts.textContent=ue,ot=l(),c(es.$$.fragment),rt=l(),k=p("div"),k.innerHTML=de,ct=l(),f=p("h2"),I=p("a"),Vs=p("span"),c(as.$$.fragment),Pt=l(),_s=p("span"),_s.textContent=ye,ht=l(),ls=p("p"),ls.textContent=Me,mt=l(),ns=p("p"),ns.innerHTML=je,gt=l(),c(ps.$$.fragment),ut=l(),is=p("p"),is.textContent=be,dt=l(),c(os.$$.fragment),yt=l(),_=p("div"),_.innerHTML=Je,Mt=l(),rs=p("p"),rs.innerHTML=we,jt=l(),c(cs.$$.fragment),bt=l(),hs=p("p"),hs.innerHTML=Ue,Jt=l(),c(ms.$$.fragment),wt=l(),z=p("div"),z.innerHTML=fe,Ut=l(),x=p("h2"),$=p("a"),Ns=p("span"),c(gs.$$.fragment),Kt=l(),zs=p("span"),zs.textContent=xe,ft=l(),us=p("p"),us.textContent=Te,xt=l(),c(ds.$$.fragment),Tt=l(),ys=p("p"),ys.innerHTML=ve,vt=l(),c(Ms.$$.fragment),Ct=l(),Z=p("div"),Z.innerHTML=Ce,Wt=l(),T=p("h2"),R=p("a"),Hs=p("span"),c(js.$$.fragment),Ot=l(),$s=p("span"),$s.textContent=We,kt=l(),bs=p("p"),bs.textContent=ke,It=l(),Js=p("p"),Js.textContent=Ie,_t=l(),c(ws.$$.fragment),zt=l(),Us=p("p"),Us.textContent=_e,$t=l(),c(fs.$$.fragment),Zt=l(),Q=p("div"),Q.innerHTML=ze,Rt=l(),xs=p("p"),xs.innerHTML=$e,Qt=l(),c(Ts.$$.fragment),Vt=l(),vs=p("p"),vs.innerHTML=Ze,Nt=l(),c(Cs.$$.fragment),Ht=l(),V=p("div"),V.innerHTML=Re,Bt=l(),Ws=p("p"),Ws.textContent=Qe,qt=l(),b=p("iframe"),Xt=l(),Bs=p("p"),this.h()},l(s){const e=sa("svelte-1phssyn",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(t),Xs=n(s),Zs=i(s,"P",{}),M(Zs).forEach(t),Es=n(s),w=i(s,"H1",{class:!0});var Gt=M(w);v=i(Gt,"A",{id:!0,class:!0,href:!0});var Ne=M(v);Rs=i(Ne,"SPAN",{});var He=M(Rs);h(N.$$.fragment,He),He.forEach(t),Ne.forEach(t),At=n(Gt),ks=i(Gt,"SPAN",{"data-svelte-h":!0}),o(ks)!=="svelte-1fbjobs"&&(ks.textContent=te),Gt.forEach(t),Gs=n(s),h(H.$$.fragment,s),Ys=n(s),B=i(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1g13my9"&&(B.innerHTML=ee),Ss=n(s),q=i(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1l6ldib"&&(q.innerHTML=ae),Fs=n(s),X=i(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1r22rri"&&(X.innerHTML=le),Ls=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-c41x80"&&(E.textContent=ne),As=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-leihjc"&&(G.textContent=pe),Ds=n(s),Y=i(s,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-v8ep8v"&&(Y.innerHTML=ie),Ps=n(s),S=i(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1c9nexd"&&(S.textContent=oe),Ks=n(s),h(F.$$.fragment,s),Os=n(s),U=i(s,"H2",{class:!0});var Yt=M(U);C=i(Yt,"A",{id:!0,class:!0,href:!0});var Be=M(C);Qs=i(Be,"SPAN",{});var qe=M(Qs);h(L.$$.fragment,qe),qe.forEach(t),Be.forEach(t),Dt=n(Yt),Is=i(Yt,"SPAN",{"data-svelte-h":!0}),o(Is)!=="svelte-1mll514"&&(Is.textContent=re),Yt.forEach(t),st=n(s),A=i(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1opfm1z"&&(A.innerHTML=ce),tt=n(s),h(D.$$.fragment,s),et=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-henpll"&&(P.innerHTML=he),at=n(s),h(K.$$.fragment,s),lt=n(s),W=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(W)!=="svelte-17qmfee"&&(W.innerHTML=me),nt=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-baa5my"&&(O.textContent=ge),pt=n(s),h(ss.$$.fragment,s),it=n(s),ts=i(s,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-af5rkc"&&(ts.textContent=ue),ot=n(s),h(es.$$.fragment,s),rt=n(s),k=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-1fwpqdn"&&(k.innerHTML=de),ct=n(s),f=i(s,"H2",{class:!0});var St=M(f);I=i(St,"A",{id:!0,class:!0,href:!0});var Xe=M(I);Vs=i(Xe,"SPAN",{});var Ee=M(Vs);h(as.$$.fragment,Ee),Ee.forEach(t),Xe.forEach(t),Pt=n(St),_s=i(St,"SPAN",{"data-svelte-h":!0}),o(_s)!=="svelte-1m72xlr"&&(_s.textContent=ye),St.forEach(t),ht=n(s),ls=i(s,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-xqdy1u"&&(ls.textContent=Me),mt=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-x1kygm"&&(ns.innerHTML=je),gt=n(s),h(ps.$$.fragment,s),ut=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-1g7c1zc"&&(is.textContent=be),dt=n(s),h(os.$$.fragment,s),yt=n(s),_=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(_)!=="svelte-owux8y"&&(_.innerHTML=Je),Mt=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-nuus8n"&&(rs.innerHTML=we),jt=n(s),h(cs.$$.fragment,s),bt=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-vo6fmu"&&(hs.innerHTML=Ue),Jt=n(s),h(ms.$$.fragment,s),wt=n(s),z=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(z)!=="svelte-1m863ar"&&(z.innerHTML=fe),Ut=n(s),x=i(s,"H2",{class:!0});var Ft=M(x);$=i(Ft,"A",{id:!0,class:!0,href:!0});var Ge=M($);Ns=i(Ge,"SPAN",{});var Ye=M(Ns);h(gs.$$.fragment,Ye),Ye.forEach(t),Ge.forEach(t),Kt=n(Ft),zs=i(Ft,"SPAN",{"data-svelte-h":!0}),o(zs)!=="svelte-1iabhzo"&&(zs.textContent=xe),Ft.forEach(t),ft=n(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-16j89af"&&(us.textContent=Te),xt=n(s),h(ds.$$.fragment,s),Tt=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-1si811t"&&(ys.innerHTML=ve),vt=n(s),h(Ms.$$.fragment,s),Ct=n(s),Z=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1m863ar"&&(Z.innerHTML=Ce),Wt=n(s),T=i(s,"H2",{class:!0});var Lt=M(T);R=i(Lt,"A",{id:!0,class:!0,href:!0});var Se=M(R);Hs=i(Se,"SPAN",{});var Fe=M(Hs);h(js.$$.fragment,Fe),Fe.forEach(t),Se.forEach(t),Ot=n(Lt),$s=i(Lt,"SPAN",{"data-svelte-h":!0}),o($s)!=="svelte-t6yg8j"&&($s.textContent=We),Lt.forEach(t),kt=n(s),bs=i(s,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-c78gkh"&&(bs.textContent=ke),It=n(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-1kqxako"&&(Js.textContent=Ie),_t=n(s),h(ws.$$.fragment,s),zt=n(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1yw5ubp"&&(Us.textContent=_e),$t=n(s),h(fs.$$.fragment,s),Zt=n(s),Q=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(Q)!=="svelte-y78yu"&&(Q.innerHTML=ze),Rt=n(s),xs=i(s,"P",{"data-svelte-h":!0}),o(xs)!=="svelte-34zysh"&&(xs.innerHTML=$e),Qt=n(s),h(Ts.$$.fragment,s),Vt=n(s),vs=i(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-27ow86"&&(vs.innerHTML=Ze),Nt=n(s),h(Cs.$$.fragment,s),Ht=n(s),V=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(V)!=="svelte-1f4dev0"&&(V.innerHTML=Re),Bt=n(s),Ws=i(s,"P",{"data-svelte-h":!0}),o(Ws)!=="svelte-14mrmrz"&&(Ws.textContent=Qe),qt=n(s),b=i(s,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),M(b).forEach(t),Xt=n(s),Bs=i(s,"P",{}),M(Bs).forEach(t),this.h()},h(){r(J,"name","hf:doc:metadata"),r(J,"content",JSON.stringify(aa)),r(v,"id","zeroshot-object-detection"),r(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(v,"href","#zeroshot-object-detection"),r(w,"class","relative group"),r(C,"id","zeroshot-object-detection-pipeline"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#zeroshot-object-detection-pipeline"),r(U,"class","relative group"),r(W,"class","flex justify-center"),r(k,"class","flex justify-center"),r(I,"id","textprompted-zeroshot-object-detection-by-hand"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#textprompted-zeroshot-object-detection-by-hand"),r(f,"class","relative group"),r(_,"class","flex justify-center"),r(z,"class","flex justify-center"),r($,"id","batch-processing"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#batch-processing"),r(x,"class","relative group"),r(Z,"class","flex justify-center"),r(R,"id","imageguided-object-detection"),r(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(R,"href","#imageguided-object-detection"),r(T,"class","relative group"),r(Q,"class","flex justify-center"),r(V,"class","flex justify-center"),Ae(b.src,Ve="https://adirik-owl-vit.hf.space")||r(b,"src",Ve),r(b,"frameborder","0"),r(b,"width","850"),r(b,"height","450")},m(s,e){m(document.head,J),a(s,Xs,e),a(s,Zs,e),a(s,Es,e),a(s,w,e),m(w,v),m(v,Rs),g(N,Rs,null),m(w,At),m(w,ks),a(s,Gs,e),g(H,s,e),a(s,Ys,e),a(s,B,e),a(s,Ss,e),a(s,q,e),a(s,Fs,e),a(s,X,e),a(s,Ls,e),a(s,E,e),a(s,As,e),a(s,G,e),a(s,Ds,e),a(s,Y,e),a(s,Ps,e),a(s,S,e),a(s,Ks,e),g(F,s,e),a(s,Os,e),a(s,U,e),m(U,C),m(C,Qs),g(L,Qs,null),m(U,Dt),m(U,Is),a(s,st,e),a(s,A,e),a(s,tt,e),g(D,s,e),a(s,et,e),a(s,P,e),a(s,at,e),g(K,s,e),a(s,lt,e),a(s,W,e),a(s,nt,e),a(s,O,e),a(s,pt,e),g(ss,s,e),a(s,it,e),a(s,ts,e),a(s,ot,e),g(es,s,e),a(s,rt,e),a(s,k,e),a(s,ct,e),a(s,f,e),m(f,I),m(I,Vs),g(as,Vs,null),m(f,Pt),m(f,_s),a(s,ht,e),a(s,ls,e),a(s,mt,e),a(s,ns,e),a(s,gt,e),g(ps,s,e),a(s,ut,e),a(s,is,e),a(s,dt,e),g(os,s,e),a(s,yt,e),a(s,_,e),a(s,Mt,e),a(s,rs,e),a(s,jt,e),g(cs,s,e),a(s,bt,e),a(s,hs,e),a(s,Jt,e),g(ms,s,e),a(s,wt,e),a(s,z,e),a(s,Ut,e),a(s,x,e),m(x,$),m($,Ns),g(gs,Ns,null),m(x,Kt),m(x,zs),a(s,ft,e),a(s,us,e),a(s,xt,e),g(ds,s,e),a(s,Tt,e),a(s,ys,e),a(s,vt,e),g(Ms,s,e),a(s,Ct,e),a(s,Z,e),a(s,Wt,e),a(s,T,e),m(T,R),m(R,Hs),g(js,Hs,null),m(T,Ot),m(T,$s),a(s,kt,e),a(s,bs,e),a(s,It,e),a(s,Js,e),a(s,_t,e),g(ws,s,e),a(s,zt,e),a(s,Us,e),a(s,$t,e),g(fs,s,e),a(s,Zt,e),a(s,Q,e),a(s,Rt,e),a(s,xs,e),a(s,Qt,e),g(Ts,s,e),a(s,Vt,e),a(s,vs,e),a(s,Nt,e),g(Cs,s,e),a(s,Ht,e),a(s,V,e),a(s,Bt,e),a(s,Ws,e),a(s,qt,e),a(s,b,e),a(s,Xt,e),a(s,Bs,e),Et=!0},p:De,i(s){Et||(u(N.$$.fragment,s),u(H.$$.fragment,s),u(F.$$.fragment,s),u(L.$$.fragment,s),u(D.$$.fragment,s),u(K.$$.fragment,s),u(ss.$$.fragment,s),u(es.$$.fragment,s),u(as.$$.fragment,s),u(ps.$$.fragment,s),u(os.$$.fragment,s),u(cs.$$.fragment,s),u(ms.$$.fragment,s),u(gs.$$.fragment,s),u(ds.$$.fragment,s),u(Ms.$$.fragment,s),u(js.$$.fragment,s),u(ws.$$.fragment,s),u(fs.$$.fragment,s),u(Ts.$$.fragment,s),u(Cs.$$.fragment,s),Et=!0)},o(s){d(N.$$.fragment,s),d(H.$$.fragment,s),d(F.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(as.$$.fragment,s),d(ps.$$.fragment,s),d(os.$$.fragment,s),d(cs.$$.fragment,s),d(ms.$$.fragment,s),d(gs.$$.fragment,s),d(ds.$$.fragment,s),d(Ms.$$.fragment,s),d(js.$$.fragment,s),d(ws.$$.fragment,s),d(fs.$$.fragment,s),d(Ts.$$.fragment,s),d(Cs.$$.fragment,s),Et=!1},d(s){s&&(t(Xs),t(Zs),t(Es),t(w),t(Gs),t(Ys),t(B),t(Ss),t(q),t(Fs),t(X),t(Ls),t(E),t(As),t(G),t(Ds),t(Y),t(Ps),t(S),t(Ks),t(Os),t(U),t(st),t(A),t(tt),t(et),t(P),t(at),t(lt),t(W),t(nt),t(O),t(pt),t(it),t(ts),t(ot),t(rt),t(k),t(ct),t(f),t(ht),t(ls),t(mt),t(ns),t(gt),t(ut),t(is),t(dt),t(yt),t(_),t(Mt),t(rs),t(jt),t(bt),t(hs),t(Jt),t(wt),t(z),t(Ut),t(x),t(ft),t(us),t(xt),t(Tt),t(ys),t(vt),t(Ct),t(Z),t(Wt),t(T),t(kt),t(bs),t(It),t(Js),t(_t),t(zt),t(Us),t($t),t(Zt),t(Q),t(Rt),t(xs),t(Qt),t(Vt),t(vs),t(Nt),t(Ht),t(V),t(Bt),t(Ws),t(qt),t(b),t(Xt),t(Bs)),t(J),y(N),y(H,s),y(F,s),y(L),y(D,s),y(K,s),y(ss,s),y(es,s),y(as),y(ps,s),y(os,s),y(cs,s),y(ms,s),y(gs),y(ds,s),y(Ms,s),y(js),y(ws,s),y(fs,s),y(Ts,s),y(Cs,s)}}}const aa={local:"zeroshot-object-detection",sections:[{local:"zeroshot-object-detection-pipeline",title:"Zero-shot object detection pipeline"},{local:"textprompted-zeroshot-object-detection-by-hand",title:"Text-prompted zero-shot object detection by hand"},{local:"batch-processing",title:"Batch processing"},{local:"imageguided-object-detection",title:"Image-guided object detection"}],title:"Zero-shot object detection"};function la(se){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ca extends Ke{constructor(J){super(),Oe(this,J,la,ea,Le,{})}}export{ca as component};
