import{s as Uo,o as jo,n as ct}from"../chunks/scheduler.9bc65507.js";import{S as zo,i as Jo,g as o,s as r,u as _,A as Zo,h as n,f as i,c as a,j as u,v as b,y as m,k as p,o as e,a as x,w as y,d as v,t as w,x as C}from"../chunks/index.78c82d43.js";import{T as $o}from"../chunks/Tip.87d55b76.js";import{D as P}from"../chunks/Docstring.4e7352e2.js";import{C as Mo}from"../chunks/CodeBlock.73e038be.js";import{I as Po}from"../chunks/IconCopyLink.bedaa44d.js";import{E as To}from"../chunks/ExampleCodeBlock.872b014d.js";function Wo(U){let c,$=`A configuration file can be loaded and saved to disk. Loading the configuration file and using this file to
initialize a model does <strong>not</strong> load the model weights. It only affects the model’s configuration.`;return{c(){c=o("p"),c.innerHTML=$},l(f){c=n(f,"P",{"data-svelte-h":!0}),m(c)!=="svelte-s3sff7"&&(c.innerHTML=$)},m(f,g){x(f,c,g)},p:ct,d(f){f&&i(c)}}}function Lo(U){let c,$="Examples:",f,g,k;return g=new Mo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMGNvbmZpZyUyMHRvJTIweW91ciUyMG5hbWVzcGFjZSUyMHdpdGglMjB0aGUlMjBuYW1lJTIwJTIybXktZmluZXR1bmVkLWJlcnQlMjIuJTBBY29uZmlnLnB1c2hfdG9faHViKCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyKSUwQSUwQSUyMyUyMFB1c2glMjB0aGUlMjBjb25maWclMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFjb25maWcucHVzaF90b19odWIoJTIyaHVnZ2luZ2ZhY2UlMkZteS1maW5ldHVuZWQtYmVydCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the config to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
config.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the config to an organization with the name &quot;my-finetuned-bert&quot;.</span>
config.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,f=r(),_(g.$$.fragment)},l(l){c=n(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=$),f=a(l),b(g.$$.fragment,l)},m(l,T){x(l,c,T),x(l,f,T),y(g,l,T),k=!0},p:ct,i(l){k||(v(g.$$.fragment,l),k=!0)},o(l){w(g.$$.fragment,l),k=!1},d(l){l&&(i(c),i(f)),C(g,l)}}}function Io(U){let c,$="Examples:",f,g,k;return g=new Mo({props:{code:"JTIzJTIwV2UlMjBjYW4ndCUyMGluc3RhbnRpYXRlJTIwZGlyZWN0bHklMjB0aGUlMjBiYXNlJTIwY2xhc3MlMjAqUHJldHJhaW5lZENvbmZpZyolMjBzbyUyMGxldCdzJTIwc2hvdyUyMHRoZSUyMGV4YW1wbGVzJTIwb24lMjBhJTBBJTIzJTIwZGVyaXZlZCUyMGNsYXNzJTNBJTIwQmVydENvbmZpZyUwQWNvbmZpZyUyMCUzRCUyMEJlcnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBKSUyMCUyMCUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEJlcnRDb25maWcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMEEpJTIwJTIwJTIzJTIwRS5nLiUyMGNvbmZpZyUyMChvciUyMG1vZGVsKSUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqJTBBY29uZmlnJTIwJTNEJTIwQmVydENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSUyQyUyMGZvbyUzREZhbHNlKSUwQWFzc2VydCUyMGNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUyMCUzRCUzRCUyMFRydWUlMEFjb25maWclMkMlMjB1bnVzZWRfa3dhcmdzJTIwJTNEJTIwQmVydENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUlMkMlMjBmb28lM0RGYWxzZSUyQyUyMHJldHVybl91bnVzZWRfa3dhcmdzJTNEVHJ1ZSUwQSklMEFhc3NlcnQlMjBjb25maWcub3V0cHV0X2F0dGVudGlvbnMlMjAlM0QlM0QlMjBUcnVlJTBBYXNzZXJ0JTIwdW51c2VkX2t3YXJncyUyMCUzRCUzRCUyMCU3QiUyMmZvbyUyMiUzQSUyMEZhbHNlJTdE",highlighted:`<span class="hljs-comment"># We can&#x27;t instantiate directly the base class *PretrainedConfig* so let&#x27;s show the examples on a</span>
<span class="hljs-comment"># derived class: BertConfig</span>
config = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
)  <span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
config = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;./test/saved_model/&quot;</span>
)  <span class="hljs-comment"># E.g. config (or model) was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
config = BertConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/my_configuration.json&quot;</span>)
config = BertConfig.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-keyword">assert</span> config.output_attentions == <span class="hljs-literal">True</span>
config, unused_kwargs = BertConfig.from_pretrained(
    <span class="hljs-string">&quot;bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
)
<span class="hljs-keyword">assert</span> config.output_attentions == <span class="hljs-literal">True</span>
<span class="hljs-keyword">assert</span> unused_kwargs == {<span class="hljs-string">&quot;foo&quot;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,f=r(),_(g.$$.fragment)},l(l){c=n(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=$),f=a(l),b(g.$$.fragment,l)},m(l,T){x(l,c,T),x(l,f,T),y(g,l,T),k=!0},p:ct,i(l){k||(v(g.$$.fragment,l),k=!0)},o(l){w(g.$$.fragment,l),k=!1},d(l){l&&(i(c),i(f)),C(g,l)}}}function Fo(U){let c,$="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=o("p"),c.textContent=$},l(f){c=n(f,"P",{"data-svelte-h":!0}),m(c)!=="svelte-15rpg4"&&(c.textContent=$)},m(f,g){x(f,c,g)},p:ct,d(f){f&&i(c)}}}function Do(U){let c,$,f,g,k,l,T,Y,lt,_e,Qt="Configuration",Re,Q,Ot=`The base class <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> implements the common methods for loading/saving a configuration
either from a local file or directory, or from a pretrained model configuration provided by the library (downloaded
from HuggingFace’s AWS S3 repository).`,Ge,O,Kt=`Each derived config class implements model specific attributes. Common attributes present in all config classes are:
<code>hidden_size</code>, <code>num_attention_heads</code>, and <code>num_hidden_layers</code>. Text models further implement:
<code>vocab_size</code>.`,Xe,Z,W,Ee,K,mt,be,eo="PretrainedConfig",Ye,s,ee,ft,ye,to=`Base class for all configuration classes. Handles a few parameters common to all models’ configurations as well as
methods for loading/downloading/saving configurations.`,ht,L,pt,ve,oo="Class attributes (overridden by derived classes):",gt,we,no=`<li><strong>model_type</strong> (<code>str</code>) — An identifier for the model type, serialized into the JSON file, and used to recreate
the correct object in <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoConfig">AutoConfig</a>.</li> <li><strong>is_composition</strong> (<code>bool</code>) — Whether the config class is composed of multiple sub-configs. In this case the
config has to be initialized from two or more configs of type <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> like:
<a href="/docs/transformers/v4.34.0/en/model_doc/encoder-decoder#transformers.EncoderDecoderConfig">EncoderDecoderConfig</a> or <a href="/docs/transformers/v4.34.0/en/model_doc/rag#transformers.RagConfig">~RagConfig</a>.</li> <li><strong>keys_to_ignore_at_inference</strong> (<code>List[str]</code>) — A list of keys to ignore by default when looking at dictionary
outputs of the model during inference.</li> <li><strong>attribute_map</strong> (<code>Dict[str, str]</code>) — A dict that maps model specific attribute names to the standardized
naming of attributes.</li>`,ut,Ce,ro="Common attributes (present in all subclasses):",_t,xe,ao=`<li><strong>vocab_size</strong> (<code>int</code>) — The number of tokens in the vocabulary, which is also the first dimension of the
embeddings matrix (this attribute may be missing for models that don’t have a text modality like ViT).</li> <li><strong>hidden_size</strong> (<code>int</code>) — The hidden size of the model.</li> <li><strong>num_attention_heads</strong> (<code>int</code>) — The number of attention heads used in the multi-head attention layers of the
model.</li> <li><strong>num_hidden_layers</strong> (<code>int</code>) — The number of blocks in the model.</li>`,bt,j,te,yt,ke,so="Upload the configuration file to the 🤗 Model Hub.",vt,I,wt,F,oe,Ct,$e,io=`Checks whether the passed dictionary and its nested dicts have a <em>torch_dtype</em> key and if it’s not None,
converts torch.dtype to a string of just the type. For example, <code>torch.float32</code> get converted into <em>“float32”</em>
string, which can then be stored in the json format.`,xt,D,ne,kt,Pe,co='Instantiates a <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> from a Python dictionary of parameters.',$t,q,re,Pt,Te,lo='Instantiates a <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> from the path to a JSON file of parameters.',Tt,z,ae,Mt,Me,mo='Instantiate a <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> (or a derived class) from a pretrained model configuration.',Ut,H,jt,N,se,zt,Ue,fo=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> using <code>from_dict</code>.`,Jt,J,ie,Zt,je,ho=`Register this class with a given auto class. This should only be used for custom configurations as the ones in
the library are already mapped with <code>AutoConfig</code>.`,Wt,V,Lt,E,de,It,ze,po=`Save a configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a> class method.`,Ft,S,ce,Dt,Je,go="Serializes this instance to a Python dictionary.",qt,B,le,Ht,Ze,uo=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Nt,A,me,Vt,We,_o="Save this instance to a JSON file.",Et,R,fe,St,Le,bo="Serializes this instance to a JSON string.",Bt,G,he,At,Ie,yo="Updates attributes of this class with attributes from <code>config_dict</code>.",Rt,M,pe,Gt,Fe,vo="Updates attributes of this class with attributes from <code>update_str</code>.",Xt,De,wo=`The expected format is ints, floats and strings as is, and for booleans use <code>true</code> or <code>false</code>. For example:
“n_embd=10,resid_pdrop=0.2,scale_attn_weights=false,summary_type=cls_index”`,Yt,qe,Co="The keys to change have to already exist in the config object.",Qe,Se,Oe;return Y=new Po({}),K=new Po({}),ee=new P({props:{name:"class transformers.PretrainedConfig",anchor:"transformers.PretrainedConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.name_or_path",description:`<strong>name_or_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
Store the string that was passed to <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">PreTrainedModel.from_pretrained()</a> or
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">TFPreTrainedModel.from_pretrained()</a> as <code>pretrained_model_name_or_path</code> if the configuration was created
with such a method.`,name:"name_or_path"},{anchor:"transformers.PretrainedConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should return all hidden-states.`,name:"output_hidden_states"},{anchor:"transformers.PretrainedConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should returns all attentions.`,name:"output_attentions"},{anchor:"transformers.PretrainedConfig.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PretrainedConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.PretrainedConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as decoder or not (in which case it&#x2019;s used as an encoder).`,name:"is_decoder"},{anchor:"transformers.PretrainedConfig.cross_attention_hidden_size**",description:`<strong>cross_attention_hidden_size**</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
The hidden size of the cross-attention layer in case the model is used as a decoder in an encoder-decoder
setting and the cross-attention hidden dimension differs from <code>self.config.hidden_size</code>.`,name:"cross_attention_hidden_size**"},{anchor:"transformers.PretrainedConfig.add_cross_attention",description:`<strong>add_cross_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cross-attention layers should be added to the model. Note, this option is only relevant for models
that can be used as decoder models within the <a href="/docs/transformers/v4.34.0/en/model_doc/encoder-decoder#transformers.EncoderDecoderModel">EncoderDecoderModel</a> class, which consists of all models
in <code>AUTO_MODELS_FOR_CAUSAL_LM</code>.`,name:"add_cross_attention"},{anchor:"transformers.PretrainedConfig.tie_encoder_decoder",description:`<strong>tie_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether all encoder weights should be tied to their equivalent decoder weights. This requires the encoder
and decoder model to have the exact same parameter names.`,name:"tie_encoder_decoder"},{anchor:"transformers.PretrainedConfig.prune_heads",description:`<strong>prune_heads</strong> (<code>Dict[int, List[int]]</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Pruned heads of the model. The keys are the selected layer indices and the associated values, the list of
heads to prune in said layer.</p>
<p>For instance <code>{1: [0, 2], 2: [2, 3]}</code> will prune heads 0 and 2 on layer 1 and heads 2 and 3 on layer 2.`,name:"prune_heads"},{anchor:"transformers.PretrainedConfig.chunk_size_feed_forward",description:`<strong>chunk_size_feed_forward</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
The chunk size of all feed forward layers in the residual attention blocks. A chunk size of <code>0</code> means that
the feed forward layer is not chunked. A chunk size of n means that the feed forward layer processes <code>n</code> &lt;
sequence_length embeddings at a time. For more information on feed forward chunking, see <a href="../glossary.html#feed-forward-chunking">How does Feed
Forward Chunking work?</a>.`,name:"chunk_size_feed_forward"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L49",parameterGroups:[{title:"Parameters for sequence generation",parametersDescription:[{anchor:"transformers.PretrainedConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Maximum length that will be used by default in the <code>generate</code> method of the model.`,name:"max_length"},{anchor:"transformers.PretrainedConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Minimum length that will be used by default in the <code>generate</code> method of the model.`,name:"min_length"},{anchor:"transformers.PretrainedConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag that will be used by default in the <code>generate</code> method of the model. Whether or not to use sampling ;
use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.PretrainedConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Flag that will be used by default in the <code>generate</code> method of the model. Whether to stop the beam search
when at least <code>num_beams</code> sentences are finished per batch or not.`,name:"early_stopping"},{anchor:"transformers.PretrainedConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search that will be used by default in the <code>generate</code> method of the model. 1 means
no beam search.`,name:"num_beams"},{anchor:"transformers.PretrainedConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams
that will be used by default in the <code>generate</code> method of the model. 1 means no group beam search.`,name:"num_beam_groups"},{anchor:"transformers.PretrainedConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Value to control diversity for group beam search. that will be used by default in the <code>generate</code> method of
the model. 0 means no diversity penalty. The higher the penalty, the more diverse are the outputs.`,name:"diversity_penalty"},{anchor:"transformers.PretrainedConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to module the next token probabilities that will be used by default in the <code>generate</code> method
of the model. Must be strictly positive.`,name:"temperature"},{anchor:"transformers.PretrainedConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
Number of highest probability vocabulary tokens to keep for top-k-filtering that will be used by default in
the <code>generate</code> method of the model.`,name:"top_k"},{anchor:"transformers.PretrainedConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Value that will be used by default in the <code>generate</code> method of the model for <code>top_p</code>. If set to float &lt; 1,
only the most probable tokens with probabilities that add up to <code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.PretrainedConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.PretrainedConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Parameter for repetition penalty that will be used by default in the <code>generate</code> method of the model. 1.0
means no penalty.`,name:"repetition_penalty"},{anchor:"transformers.PretrainedConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.PretrainedConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; Value that will be used by default in the &#x2014;
<code>generate</code> method of the model for <code>no_repeat_ngram_size</code>. If set to int &gt; 0, all ngrams of that size can
only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.PretrainedConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; Value that will be used by &#x2014;
default in the <code>generate</code> method of the model for <code>encoder_no_repeat_ngram_size</code>. If set to int &gt; 0, all
ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the <code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.PretrainedConfig.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of token ids that are not allowed to be generated that will be used by default in the <code>generate</code>
method of the model. In order to get the tokens of the words that should not appear in the generated text,
use <code>tokenizer.encode(bad_word, add_prefix_space=True)</code>.`,name:"bad_words_ids"},{anchor:"transformers.PretrainedConfig.num_return_sequences",description:`<strong>num_return_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of independently computed returned sequences for each element in the batch that will be used by
default in the <code>generate</code> method of the model.`,name:"num_return_sequences"},{anchor:"transformers.PretrainedConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should return the logits when used for generation.`,name:"output_scores"},{anchor:"transformers.PretrainedConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a <code>torch.LongTensor</code>.`,name:"return_dict_in_generate"},{anchor:"transformers.PretrainedConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.PretrainedConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"forced_eos_token_id"},{anchor:"transformers.PretrainedConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"}]},{title:"Parameters for fine-tuning tasks",parametersDescription:[{anchor:"transformers.PretrainedConfig.architectures",description:`<strong>architectures</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Model architectures that can be used with the model pretrained weights.`,name:"architectures"},{anchor:"transformers.PretrainedConfig.finetuning_task",description:`<strong>finetuning_task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the task used to fine-tune the model. This can be used when converting from an original (TensorFlow
or PyTorch) checkpoint.`,name:"finetuning_task"},{anchor:"transformers.PretrainedConfig.id2label",description:`<strong>id2label</strong> (<code>Dict[int, str]</code>, <em>optional</em>) &#x2014;
A map from index (for instance prediction index, or target index) to label.`,name:"id2label"},{anchor:"transformers.PretrainedConfig.label2id",description:"<strong>label2id</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014; A map from label to index for the model.",name:"label2id"},{anchor:"transformers.PretrainedConfig.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of labels to use in the last layer added to the model, typically for a classification task.`,name:"num_labels"},{anchor:"transformers.PretrainedConfig.task_specific_params",description:`<strong>task_specific_params</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to store for the current task.`,name:"task_specific_params"},{anchor:"transformers.PretrainedConfig.problem_type",description:`<strong>problem_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Problem type for <code>XxxForSequenceClassification</code> models. Can be one of <code>&quot;regression&quot;</code>,
<code>&quot;single_label_classification&quot;</code> or <code>&quot;multi_label_classification&quot;</code>.`,name:"problem_type"}]},{title:"Parameters linked to the tokenizer",parametersDescription:[{anchor:"transformers.PretrainedConfig.tokenizer_class",description:`<strong>tokenizer_class</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the associated tokenizer class to use (if none is set, will use the tokenizer associated to the
model by default).`,name:"tokenizer_class"},{anchor:"transformers.PretrainedConfig.prefix",description:`<strong>prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A specific prompt that should be added at the beginning of each text before calling the model.`,name:"prefix"},{anchor:"transformers.PretrainedConfig.bos_token_id",description:"<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>beginning-of-stream</em> token.",name:"bos_token_id"},{anchor:"transformers.PretrainedConfig.pad_token_id",description:"<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>padding</em> token.",name:"pad_token_id"},{anchor:"transformers.PretrainedConfig.eos_token_id",description:"<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>end-of-stream</em> token.",name:"eos_token_id"},{anchor:"transformers.PretrainedConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"},{anchor:"transformers.PretrainedConfig.sep_token_id",description:"<strong>sep_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014; The id of the <em>separation</em> token.",name:"sep_token_id"}]},{title:"PyTorch specific parameters",parametersDescription:[{anchor:"transformers.PretrainedConfig.torchscript",description:`<strong>torchscript</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should be used with Torchscript.`,name:"torchscript"},{anchor:"transformers.PretrainedConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied. Note that this is only relevant if the
model has a output word embedding layer.`,name:"tie_word_embeddings"},{anchor:"transformers.PretrainedConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The <code>dtype</code> of the weights. This attribute can be used to initialize the model to a non-default <code>dtype</code>
(which is normally <code>float32</code>) and thus allow for optimal storage allocation. For example, if the saved
model is <code>float16</code>, ideally we want to load it back using the minimal amount of memory needed to load
<code>float16</code> weights. Since the config object is stored in plain text, this attribute contains just the
floating type string without the <code>torch.</code> prefix. For example, for <code>torch.float16</code> \`<code>torch_dtype</code> is the
<code>&quot;float16&quot;</code> string.</p>
<p>This attribute is currently not being used during model loading time, but this may change in the future
versions. But we can already start preparing for the future by saving the dtype with save_pretrained.`,name:"torch_dtype"}]},{title:"TensorFlow specific parameters",parametersDescription:[{anchor:"transformers.PretrainedConfig.use_bfloat16",description:`<strong>use_bfloat16</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the model should use BFloat16 scalars (only used by some TensorFlow models).`,name:"use_bfloat16"},{anchor:"transformers.PretrainedConfig.tf_legacy_loss",description:`<strong>tf_legacy_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model should use legacy TensorFlow losses. Legacy losses have variable output shapes and may
not be XLA-compatible. This option is here for backward compatibility and will be removed in Transformers
v5.`,name:"tf_legacy_loss"}]}]}}),L=new $o({props:{$$slots:{default:[Wo]},$$scope:{ctx:U}}}),te=new P({props:{name:"push_to_hub",anchor:"transformers.PretrainedConfig.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": typing.Optional[bool] = None"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = '10GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = False"},{name:"revision",val:": str = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your config to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.PretrainedConfig.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.PretrainedConfig.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload config&quot;</code>.`,name:"commit_message"},{anchor:"transformers.PretrainedConfig.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.PretrainedConfig.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.PretrainedConfig.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;10GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>).`,name:"max_shard_size"},{anchor:"transformers.PretrainedConfig.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.PretrainedConfig.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.PretrainedConfig.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/hub.py#L786"}}),I=new To({props:{anchor:"transformers.PretrainedConfig.push_to_hub.example",$$slots:{default:[Lo]},$$scope:{ctx:U}}}),oe=new P({props:{name:"dict_torch_dtype_to_str",anchor:"transformers.PretrainedConfig.dict_torch_dtype_to_str",parameters:[{name:"d",val:": typing.Dict[str, typing.Any]"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L982"}}),ne=new P({props:{name:"from_dict",anchor:"transformers.PretrainedConfig.from_dict",parameters:[{name:"config_dict",val:": typing.Dict[str, typing.Any]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_dict.config_dict",description:`<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the configuration object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig.get_config_dict">get_config_dict()</a> method.`,name:"config_dict"},{anchor:"transformers.PretrainedConfig.from_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L723",returnDescription:`
<p>The configuration object instantiated from those parameters.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),re=new P({props:{name:"from_json_file",anchor:"transformers.PretrainedConfig.from_json_file",parameters:[{name:"json_file",val:": typing.Union[str, os.PathLike]"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_json_file.json_file",description:`<strong>json_file</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file containing the parameters.`,name:"json_file"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L781",returnDescription:`
<p>The configuration object instantiated from that JSON file.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),ae=new P({props:{name:"from_pretrained",anchor:"transformers.PretrainedConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved configuration JSON <em>file</em>, e.g., <code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.PretrainedConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.PretrainedConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.PretrainedConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.PretrainedConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.PretrainedConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PretrainedConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.PretrainedConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.PretrainedConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.PretrainedConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L497",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig"
>PretrainedConfig</a></p>
`}}),H=new To({props:{anchor:"transformers.PretrainedConfig.from_pretrained.example",$$slots:{default:[Io]},$$scope:{ctx:U}}}),se=new P({props:{name:"get_config_dict",anchor:"transformers.PretrainedConfig.get_config_dict",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.get_config_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L600",returnDescription:`
<p>The dictionary(ies) that will be used to instantiate the configuration object.</p>
`,returnType:`
<p><code>Tuple[Dict, Dict]</code></p>
`}}),ie=new P({props:{name:"register_for_auto_class",anchor:"transformers.PretrainedConfig.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoConfig'"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoConfig&quot;</code>) &#x2014;
The auto class to register this new configuration with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L994"}}),V=new $o({props:{warning:!0,$$slots:{default:[Fo]},$$scope:{ctx:U}}}),de=new P({props:{name:"save_pretrained",anchor:"transformers.PretrainedConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PretrainedConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.PretrainedConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.PretrainedConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.34.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L423"}}),ce=new P({props:{name:"to_dict",anchor:"transformers.PretrainedConfig.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L863",returnDescription:`
<p>Dictionary of all the attributes that make up this configuration instance.</p>
`,returnType:`
<p><code>Dict[str, Any]</code></p>
`}}),le=new P({props:{name:"to_diff_dict",anchor:"transformers.PretrainedConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L809",returnDescription:`
<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`
<p><code>Dict[str, Any]</code></p>
`}}),me=new P({props:{name:"to_json_file",anchor:"transformers.PretrainedConfig.to_json_file",parameters:[{name:"json_file_path",val:": typing.Union[str, os.PathLike]"},{name:"use_diff",val:": bool = True"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this configuration instance&#x2019;s parameters will be saved.`,name:"json_file_path"},{anchor:"transformers.PretrainedConfig.to_json_file.use_diff",description:`<strong>use_diff</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, only the difference between the config instance and the default <code>PretrainedConfig()</code>
is serialized to JSON file.`,name:"use_diff"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L920"}}),fe=new P({props:{name:"to_json_string",anchor:"transformers.PretrainedConfig.to_json_string",parameters:[{name:"use_diff",val:": bool = True"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.to_json_string.use_diff",description:`<strong>use_diff</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, only the difference between the config instance and the default <code>PretrainedConfig()</code>
is serialized to JSON string.`,name:"use_diff"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L902",returnDescription:`
<p>String containing all the attributes that make up this configuration instance in JSON format.</p>
`,returnType:`
<p><code>str</code></p>
`}}),he=new P({props:{name:"update",anchor:"transformers.PretrainedConfig.update",parameters:[{name:"config_dict",val:": typing.Dict[str, typing.Any]"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.update.config_dict",description:"<strong>config_dict</strong> (<code>Dict[str, Any]</code>) &#x2014; Dictionary of attributes that should be updated for this class.",name:"config_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L934"}}),pe=new P({props:{name:"update_from_string",anchor:"transformers.PretrainedConfig.update_from_string",parameters:[{name:"update_str",val:": str"}],parametersDescription:[{anchor:"transformers.PretrainedConfig.update_from_string.update_str",description:"<strong>update_str</strong> (<code>str</code>) &#x2014; String with attributes that should be updated for this class.",name:"update_str"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/configuration_utils.py#L944"}}),{c(){c=o("meta"),$=r(),f=o("p"),g=r(),k=o("h1"),l=o("a"),T=o("span"),_(Y.$$.fragment),lt=r(),_e=o("span"),_e.textContent=Qt,Re=r(),Q=o("p"),Q.innerHTML=Ot,Ge=r(),O=o("p"),O.innerHTML=Kt,Xe=r(),Z=o("h2"),W=o("a"),Ee=o("span"),_(K.$$.fragment),mt=r(),be=o("span"),be.textContent=eo,Ye=r(),s=o("div"),_(ee.$$.fragment),ft=r(),ye=o("p"),ye.textContent=to,ht=r(),_(L.$$.fragment),pt=r(),ve=o("p"),ve.textContent=oo,gt=r(),we=o("ul"),we.innerHTML=no,ut=r(),Ce=o("p"),Ce.textContent=ro,_t=r(),xe=o("ul"),xe.innerHTML=ao,bt=r(),j=o("div"),_(te.$$.fragment),yt=r(),ke=o("p"),ke.textContent=so,vt=r(),_(I.$$.fragment),wt=r(),F=o("div"),_(oe.$$.fragment),Ct=r(),$e=o("p"),$e.innerHTML=io,xt=r(),D=o("div"),_(ne.$$.fragment),kt=r(),Pe=o("p"),Pe.innerHTML=co,$t=r(),q=o("div"),_(re.$$.fragment),Pt=r(),Te=o("p"),Te.innerHTML=lo,Tt=r(),z=o("div"),_(ae.$$.fragment),Mt=r(),Me=o("p"),Me.innerHTML=mo,Ut=r(),_(H.$$.fragment),jt=r(),N=o("div"),_(se.$$.fragment),zt=r(),Ue=o("p"),Ue.innerHTML=fo,Jt=r(),J=o("div"),_(ie.$$.fragment),Zt=r(),je=o("p"),je.innerHTML=ho,Wt=r(),_(V.$$.fragment),Lt=r(),E=o("div"),_(de.$$.fragment),It=r(),ze=o("p"),ze.innerHTML=po,Ft=r(),S=o("div"),_(ce.$$.fragment),Dt=r(),Je=o("p"),Je.textContent=go,qt=r(),B=o("div"),_(le.$$.fragment),Ht=r(),Ze=o("p"),Ze.textContent=uo,Nt=r(),A=o("div"),_(me.$$.fragment),Vt=r(),We=o("p"),We.textContent=_o,Et=r(),R=o("div"),_(fe.$$.fragment),St=r(),Le=o("p"),Le.textContent=bo,Bt=r(),G=o("div"),_(he.$$.fragment),At=r(),Ie=o("p"),Ie.innerHTML=yo,Rt=r(),M=o("div"),_(pe.$$.fragment),Gt=r(),Fe=o("p"),Fe.innerHTML=vo,Xt=r(),De=o("p"),De.innerHTML=wo,Yt=r(),qe=o("p"),qe.textContent=Co,Qe=r(),Se=o("p"),this.h()},l(t){const h=Zo("svelte-1phssyn",document.head);c=n(h,"META",{name:!0,content:!0}),h.forEach(i),$=a(t),f=n(t,"P",{}),u(f).forEach(i),g=a(t),k=n(t,"H1",{class:!0});var ge=u(k);l=n(ge,"A",{id:!0,class:!0,href:!0});var Be=u(l);T=n(Be,"SPAN",{});var Ae=u(T);b(Y.$$.fragment,Ae),Ae.forEach(i),Be.forEach(i),lt=a(ge),_e=n(ge,"SPAN",{"data-svelte-h":!0}),m(_e)!=="svelte-13rze9p"&&(_e.textContent=Qt),ge.forEach(i),Re=a(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-7spi2r"&&(Q.innerHTML=Ot),Ge=a(t),O=n(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1fich0i"&&(O.innerHTML=Kt),Xe=a(t),Z=n(t,"H2",{class:!0});var ue=u(Z);W=n(ue,"A",{id:!0,class:!0,href:!0});var xo=u(W);Ee=n(xo,"SPAN",{});var ko=u(Ee);b(K.$$.fragment,ko),ko.forEach(i),xo.forEach(i),mt=a(ue),be=n(ue,"SPAN",{"data-svelte-h":!0}),m(be)!=="svelte-43xu6v"&&(be.textContent=eo),ue.forEach(i),Ye=a(t),s=n(t,"DIV",{class:!0});var d=u(s);b(ee.$$.fragment,d),ft=a(d),ye=n(d,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1p9qi0i"&&(ye.textContent=to),ht=a(d),b(L.$$.fragment,d),pt=a(d),ve=n(d,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1qxxkvo"&&(ve.textContent=oo),gt=a(d),we=n(d,"UL",{"data-svelte-h":!0}),m(we)!=="svelte-1aq03so"&&(we.innerHTML=no),ut=a(d),Ce=n(d,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1yi3c0w"&&(Ce.textContent=ro),_t=a(d),xe=n(d,"UL",{"data-svelte-h":!0}),m(xe)!=="svelte-1cjcwii"&&(xe.innerHTML=ao),bt=a(d),j=n(d,"DIV",{class:!0});var He=u(j);b(te.$$.fragment,He),yt=a(He),ke=n(He,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-j50kqf"&&(ke.textContent=so),vt=a(He),b(I.$$.fragment,He),He.forEach(i),wt=a(d),F=n(d,"DIV",{class:!0});var Ke=u(F);b(oe.$$.fragment,Ke),Ct=a(Ke),$e=n(Ke,"P",{"data-svelte-h":!0}),m($e)!=="svelte-m61tyl"&&($e.innerHTML=io),Ke.forEach(i),xt=a(d),D=n(d,"DIV",{class:!0});var et=u(D);b(ne.$$.fragment,et),kt=a(et),Pe=n(et,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-1ixi2it"&&(Pe.innerHTML=co),et.forEach(i),$t=a(d),q=n(d,"DIV",{class:!0});var tt=u(q);b(re.$$.fragment,tt),Pt=a(tt),Te=n(tt,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1yztvaq"&&(Te.innerHTML=lo),tt.forEach(i),Tt=a(d),z=n(d,"DIV",{class:!0});var Ne=u(z);b(ae.$$.fragment,Ne),Mt=a(Ne),Me=n(Ne,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1ffgawg"&&(Me.innerHTML=mo),Ut=a(Ne),b(H.$$.fragment,Ne),Ne.forEach(i),jt=a(d),N=n(d,"DIV",{class:!0});var ot=u(N);b(se.$$.fragment,ot),zt=a(ot),Ue=n(ot,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-91f62g"&&(Ue.innerHTML=fo),ot.forEach(i),Jt=a(d),J=n(d,"DIV",{class:!0});var Ve=u(J);b(ie.$$.fragment,Ve),Zt=a(Ve),je=n(Ve,"P",{"data-svelte-h":!0}),m(je)!=="svelte-30y31e"&&(je.innerHTML=ho),Wt=a(Ve),b(V.$$.fragment,Ve),Ve.forEach(i),Lt=a(d),E=n(d,"DIV",{class:!0});var nt=u(E);b(de.$$.fragment,nt),It=a(nt),ze=n(nt,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-xkpd1a"&&(ze.innerHTML=po),nt.forEach(i),Ft=a(d),S=n(d,"DIV",{class:!0});var rt=u(S);b(ce.$$.fragment,rt),Dt=a(rt),Je=n(rt,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1ww3wqq"&&(Je.textContent=go),rt.forEach(i),qt=a(d),B=n(d,"DIV",{class:!0});var at=u(B);b(le.$$.fragment,at),Ht=a(at),Ze=n(at,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1p6bdas"&&(Ze.textContent=uo),at.forEach(i),Nt=a(d),A=n(d,"DIV",{class:!0});var st=u(A);b(me.$$.fragment,st),Vt=a(st),We=n(st,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1g70y32"&&(We.textContent=_o),st.forEach(i),Et=a(d),R=n(d,"DIV",{class:!0});var it=u(R);b(fe.$$.fragment,it),St=a(it),Le=n(it,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-5ayq1f"&&(Le.textContent=bo),it.forEach(i),Bt=a(d),G=n(d,"DIV",{class:!0});var dt=u(G);b(he.$$.fragment,dt),At=a(dt),Ie=n(dt,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1hh5fg7"&&(Ie.innerHTML=yo),dt.forEach(i),Rt=a(d),M=n(d,"DIV",{class:!0});var X=u(M);b(pe.$$.fragment,X),Gt=a(X),Fe=n(X,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-a2aodj"&&(Fe.innerHTML=vo),Xt=a(X),De=n(X,"P",{"data-svelte-h":!0}),m(De)!=="svelte-179z5e8"&&(De.innerHTML=wo),Yt=a(X),qe=n(X,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-5bouux"&&(qe.textContent=Co),X.forEach(i),d.forEach(i),Qe=a(t),Se=n(t,"P",{}),u(Se).forEach(i),this.h()},h(){p(c,"name","hf:doc:metadata"),p(c,"content",JSON.stringify(qo)),p(l,"id","configuration"),p(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(l,"href","#configuration"),p(k,"class","relative group"),p(W,"id","transformers.PretrainedConfig"),p(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(W,"href","#transformers.PretrainedConfig"),p(Z,"class","relative group"),p(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),p(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,h){e(document.head,c),x(t,$,h),x(t,f,h),x(t,g,h),x(t,k,h),e(k,l),e(l,T),y(Y,T,null),e(k,lt),e(k,_e),x(t,Re,h),x(t,Q,h),x(t,Ge,h),x(t,O,h),x(t,Xe,h),x(t,Z,h),e(Z,W),e(W,Ee),y(K,Ee,null),e(Z,mt),e(Z,be),x(t,Ye,h),x(t,s,h),y(ee,s,null),e(s,ft),e(s,ye),e(s,ht),y(L,s,null),e(s,pt),e(s,ve),e(s,gt),e(s,we),e(s,ut),e(s,Ce),e(s,_t),e(s,xe),e(s,bt),e(s,j),y(te,j,null),e(j,yt),e(j,ke),e(j,vt),y(I,j,null),e(s,wt),e(s,F),y(oe,F,null),e(F,Ct),e(F,$e),e(s,xt),e(s,D),y(ne,D,null),e(D,kt),e(D,Pe),e(s,$t),e(s,q),y(re,q,null),e(q,Pt),e(q,Te),e(s,Tt),e(s,z),y(ae,z,null),e(z,Mt),e(z,Me),e(z,Ut),y(H,z,null),e(s,jt),e(s,N),y(se,N,null),e(N,zt),e(N,Ue),e(s,Jt),e(s,J),y(ie,J,null),e(J,Zt),e(J,je),e(J,Wt),y(V,J,null),e(s,Lt),e(s,E),y(de,E,null),e(E,It),e(E,ze),e(s,Ft),e(s,S),y(ce,S,null),e(S,Dt),e(S,Je),e(s,qt),e(s,B),y(le,B,null),e(B,Ht),e(B,Ze),e(s,Nt),e(s,A),y(me,A,null),e(A,Vt),e(A,We),e(s,Et),e(s,R),y(fe,R,null),e(R,St),e(R,Le),e(s,Bt),e(s,G),y(he,G,null),e(G,At),e(G,Ie),e(s,Rt),e(s,M),y(pe,M,null),e(M,Gt),e(M,Fe),e(M,Xt),e(M,De),e(M,Yt),e(M,qe),x(t,Qe,h),x(t,Se,h),Oe=!0},p(t,[h]){const ge={};h&2&&(ge.$$scope={dirty:h,ctx:t}),L.$set(ge);const Be={};h&2&&(Be.$$scope={dirty:h,ctx:t}),I.$set(Be);const Ae={};h&2&&(Ae.$$scope={dirty:h,ctx:t}),H.$set(Ae);const ue={};h&2&&(ue.$$scope={dirty:h,ctx:t}),V.$set(ue)},i(t){Oe||(v(Y.$$.fragment,t),v(K.$$.fragment,t),v(ee.$$.fragment,t),v(L.$$.fragment,t),v(te.$$.fragment,t),v(I.$$.fragment,t),v(oe.$$.fragment,t),v(ne.$$.fragment,t),v(re.$$.fragment,t),v(ae.$$.fragment,t),v(H.$$.fragment,t),v(se.$$.fragment,t),v(ie.$$.fragment,t),v(V.$$.fragment,t),v(de.$$.fragment,t),v(ce.$$.fragment,t),v(le.$$.fragment,t),v(me.$$.fragment,t),v(fe.$$.fragment,t),v(he.$$.fragment,t),v(pe.$$.fragment,t),Oe=!0)},o(t){w(Y.$$.fragment,t),w(K.$$.fragment,t),w(ee.$$.fragment,t),w(L.$$.fragment,t),w(te.$$.fragment,t),w(I.$$.fragment,t),w(oe.$$.fragment,t),w(ne.$$.fragment,t),w(re.$$.fragment,t),w(ae.$$.fragment,t),w(H.$$.fragment,t),w(se.$$.fragment,t),w(ie.$$.fragment,t),w(V.$$.fragment,t),w(de.$$.fragment,t),w(ce.$$.fragment,t),w(le.$$.fragment,t),w(me.$$.fragment,t),w(fe.$$.fragment,t),w(he.$$.fragment,t),w(pe.$$.fragment,t),Oe=!1},d(t){t&&(i($),i(f),i(g),i(k),i(Re),i(Q),i(Ge),i(O),i(Xe),i(Z),i(Ye),i(s),i(Qe),i(Se)),i(c),C(Y),C(K),C(ee),C(L),C(te),C(I),C(oe),C(ne),C(re),C(ae),C(H),C(se),C(ie),C(V),C(de),C(ce),C(le),C(me),C(fe),C(he),C(pe)}}}const qo={local:"configuration",sections:[{local:"transformers.PretrainedConfig",title:"PretrainedConfig"}],title:"Configuration"};function Ho(U){return jo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Go extends zo{constructor(c){super(),Jo(this,c,Ho,Do,Uo,{})}}export{Go as component};
