import{s as Vs,f as Xs,o as Os,n as dt}from"../chunks/scheduler.9bc65507.js";import{S as Qs,i as Ys,g as n,s as a,u,A as Ks,h as s,f as o,c as r,j as p,v as _,y as h,k as c,o as t,a as m,w as b,d as v,t as y,x as w}from"../chunks/index.78c82d43.js";import{T as An}from"../chunks/Tip.87d55b76.js";import{D}from"../chunks/Docstring.4e7352e2.js";import{C as qo}from"../chunks/CodeBlock.73e038be.js";import{I as X}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Bo}from"../chunks/ExampleCodeBlock.872b014d.js";function ea(k){let d,T="Examples:",g,f,C;return f=new qo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvbmRpdGlvbmFsRGV0ckNvbmZpZyUyQyUyMENvbmRpdGlvbmFsRGV0ck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENvbmRpdGlvbmFsJTIwREVUUiUyMG1pY3Jvc29mdCUyRmNvbmRpdGlvbmFsLWRldHItcmVzbmV0LTUwJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMENvbmRpdGlvbmFsRGV0ckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZjb25kaXRpb25hbC1kZXRyLXJlc25ldC01MCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQ29uZGl0aW9uYWxEZXRyTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ConditionalDetrConfig, ConditionalDetrModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Conditional DETR microsoft/conditional-detr-resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ConditionalDetrConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the microsoft/conditional-detr-resnet-50 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ConditionalDetrModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,g=a(),u(f.$$.fragment)},l(i){d=s(i,"P",{"data-svelte-h":!0}),h(d)!=="svelte-kvfsh7"&&(d.textContent=T),g=r(i),_(f.$$.fragment,i)},m(i,M){m(i,d,M),m(i,g,M),b(f,i,M),C=!0},p:dt,i(i){C||(v(f.$$.fragment,i),C=!0)},o(i){y(f.$$.fragment,i),C=!1},d(i){i&&(o(d),o(g)),w(f,i)}}}function ta(k){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=n("p"),d.innerHTML=T},l(g){d=s(g,"P",{"data-svelte-h":!0}),h(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(g,f){m(g,d,f)},p:dt,d(g){g&&o(d)}}}function oa(k){let d,T="Examples:",g,f,C;return f=new qo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGY29uZGl0aW9uYWwtZGV0ci1yZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmNvbmRpdGlvbmFsLWRldHItcmVzbmV0LTUwJTIyKSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMGZvciUyMHRoZSUyMG1vZGVsJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBmb3J3YXJkJTIwcGFzcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEElMjMlMjB0aGUlMjBsYXN0JTIwaGlkZGVuJTIwc3RhdGVzJTIwYXJlJTIwdGhlJTIwZmluYWwlMjBxdWVyeSUyMGVtYmVkZGluZ3MlMjBvZiUyMHRoZSUyMFRyYW5zZm9ybWVyJTIwZGVjb2RlciUwQSUyMyUyMHRoZXNlJTIwYXJlJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMlMkMlMjBoaWRkZW5fc2l6ZSklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/conditional-detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;microsoft/conditional-detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the last hidden states are the final query embeddings of the Transformer decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># these are of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">300</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,g=a(),u(f.$$.fragment)},l(i){d=s(i,"P",{"data-svelte-h":!0}),h(d)!=="svelte-kvfsh7"&&(d.textContent=T),g=r(i),_(f.$$.fragment,i)},m(i,M){m(i,d,M),m(i,g,M),b(f,i,M),C=!0},p:dt,i(i){C||(v(f.$$.fragment,i),C=!0)},o(i){y(f.$$.fragment,i),C=!1},d(i){i&&(o(d),o(g)),w(f,i)}}}function na(k){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=n("p"),d.innerHTML=T},l(g){d=s(g,"P",{"data-svelte-h":!0}),h(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(g,f){m(g,d,f)},p:dt,d(g){g&&o(d)}}}function sa(k){let d,T="Examples:",g,f,C;return f=new qo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGY29uZGl0aW9uYWwtZGV0ci1yZXNuZXQtNTAlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmNvbmRpdGlvbmFsLWRldHItcmVzbmV0LTUwJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMENPQ08lMjBBUEklMEF0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQXJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuNSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIlMEElMjAlMjAlMjAlMjAwJTBBJTVEJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/conditional-detr-resnet-50&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;microsoft/conditional-detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.833</span> at location [<span class="hljs-number">38.31</span>, <span class="hljs-number">72.1</span>, <span class="hljs-number">177.63</span>, <span class="hljs-number">118.45</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.831</span> at location [<span class="hljs-number">9.2</span>, <span class="hljs-number">51.38</span>, <span class="hljs-number">321.13</span>, <span class="hljs-number">469.0</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.804</span> at location [<span class="hljs-number">340.3</span>, <span class="hljs-number">16.85</span>, <span class="hljs-number">642.93</span>, <span class="hljs-number">370.95</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.683</span> at location [<span class="hljs-number">334.48</span>, <span class="hljs-number">73.49</span>, <span class="hljs-number">366.37</span>, <span class="hljs-number">190.01</span>]
Detected couch <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.535</span> at location [<span class="hljs-number">0.52</span>, <span class="hljs-number">1.19</span>, <span class="hljs-number">640.35</span>, <span class="hljs-number">475.1</span>]`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,g=a(),u(f.$$.fragment)},l(i){d=s(i,"P",{"data-svelte-h":!0}),h(d)!=="svelte-kvfsh7"&&(d.textContent=T),g=r(i),_(f.$$.fragment,i)},m(i,M){m(i,d,M),m(i,g,M),b(f,i,M),C=!0},p:dt,i(i){C||(v(f.$$.fragment,i),C=!0)},o(i){y(f.$$.fragment,i),C=!1},d(i){i&&(o(d),o(g)),w(f,i)}}}function aa(k){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=n("p"),d.innerHTML=T},l(g){d=s(g,"P",{"data-svelte-h":!0}),h(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(g,f){m(g,d,f)},p:dt,d(g){g&&o(d)}}}function ra(k){let d,T="Examples:",g,f,C;return f=new qo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> io
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoImageProcessor,
<span class="hljs-meta">... </span>    ConditionalDetrConfig,
<span class="hljs-meta">... </span>    ConditionalDetrForSegmentation,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.image_transforms <span class="hljs-keyword">import</span> rgb_to_id

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/conditional-detr-resnet-50&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># randomly initialize all weights of the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = ConditionalDetrConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ConditionalDetrForSegmentation(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use the \`post_process_panoptic_segmentation\` method of the \`image_processor\` to retrieve post-processed panoptic segmentation maps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Segmentation results are returned as a list of dictionaries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = image_processor.post_process_panoptic_segmentation(outputs, target_sizes=[(<span class="hljs-number">300</span>, <span class="hljs-number">500</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A tensor of shape (height, width) where each value denotes a segment id, filled with -1 if no segment is found</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>panoptic_seg = result[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get prediction score and segment_id to class_id mapping of each segment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>panoptic_segments_info = result[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segments_info&quot;</span>]`,wrap:!1}}),{c(){d=n("p"),d.textContent=T,g=a(),u(f.$$.fragment)},l(i){d=s(i,"P",{"data-svelte-h":!0}),h(d)!=="svelte-kvfsh7"&&(d.textContent=T),g=r(i),_(f.$$.fragment,i)},m(i,M){m(i,d,M),m(i,g,M),b(f,i,M),C=!0},p:dt,i(i){C||(v(f.$$.fragment,i),C=!0)},o(i){y(f.$$.fragment,i),C=!1},d(i){i&&(o(d),o(g)),w(f,i)}}}function ia(k){let d,T,g,f,C,i,M,De,Go,ct,Hn="Conditional DETR",no,W,O,qt,je,Ao,mt,Vn="Overview",so,ke,Xn='The Conditional DETR model was proposed in <a href="https://arxiv.org/abs/2108.06152" rel="nofollow">Conditional DETR for Fast Training Convergence</a> by Depu Meng, Xiaokang Chen, Zejia Fan, Gang Zeng, Houqiang Li, Yuhui Yuan, Lei Sun, Jingdong Wang. Conditional DETR presents a conditional cross-attention mechanism for fast DETR training. Conditional DETR converges 6.7× to 10× faster than DETR.',ao,$e,On="The abstract from the paper is the following:",ro,Fe,Qn='<em>The recently-developed DETR approach applies the transformer encoder and decoder architecture to object detection and achieves promising performance. In this paper, we handle the critical issue, slow training convergence, and present a conditional cross-attention mechanism for fast DETR training. Our approach is motivated by that the cross-attention in DETR relies highly on the content embeddings for localizing the four extremities and predicting the box, which increases the need for high-quality content embeddings and thus the training difficulty. Our approach, named conditional DETR, learns a conditional spatial query from the decoder embedding for decoder multi-head cross-attention. The benefit is that through the conditional spatial query, each cross-attention head is able to attend to a band containing a distinct region, e.g., one object extremity or a region inside the object box. This narrows down the spatial range for localizing the distinct regions for object classification and box regression, thus relaxing the dependence on the content embeddings and easing the training. Empirical results show that conditional DETR converges 6.7× faster for the backbones R50 and R101 and 10× faster for stronger backbones DC5-R50 and DC5-R101. Code is available at <a href="https://github.com/Atten4Vis/ConditionalDETR" rel="nofollow">https://github.com/Atten4Vis/ConditionalDETR</a>.</em>',io,Q,Yn,lo,ze,Kn='Conditional DETR shows much faster convergence compared to the original DETR. Taken from the <a href="https://arxiv.org/abs/2108.06152">original paper</a>.',co,Ue,es='This model was contributed by <a href="https://huggingface.co/DepuMeng" rel="nofollow">DepuMeng</a>. The original code can be found <a href="https://github.com/Atten4Vis/ConditionalDETR" rel="nofollow">here</a>.',mo,S,Y,Gt,Ie,Ho,pt,ts="Documentation resources",po,Je,os='<li><a href="../tasks/object_detection">Object detection task guide</a></li>',ho,B,K,At,Ne,Vo,ht,ns="ConditionalDetrConfig",go,I,Ee,Xo,gt,ss=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a>. It is used to instantiate
a Conditional DETR model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Conditional DETR
<a href="https://huggingface.co/microsoft/conditional-detr-resnet-50" rel="nofollow">microsoft/conditional-detr-resnet-50</a> architecture.`,Oo,ft,as=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qo,ee,fo,q,te,Ht,Ze,Yo,ut,rs="ConditionalDetrImageProcessor",uo,x,Le,Ko,_t,is="Constructs a Conditional Detr image processor.",en,oe,Re,tn,bt,ls="Preprocess an image or a batch of images so that it can be used by the model.",on,ne,Pe,nn,vt,ds=`Converts the raw output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,sn,se,We,an,yt,cs=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> into instance segmentation predictions. Only supports
PyTorch.`,rn,ae,Se,ln,wt,ms=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,dn,re,Be,cn,Ct,ps=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> into image panoptic segmentation predictions. Only
supports PyTorch.`,_o,G,ie,Vt,qe,mn,Tt,hs="ConditionalDetrFeatureExtractor",bo,j,Ge,pn,le,Ae,hn,Mt,gs="Preprocess an image or a batch of images.",gn,de,He,fn,xt,fs=`Converts the raw output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,un,ce,Ve,_n,Dt,us=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> into instance segmentation predictions. Only supports
PyTorch.`,bn,me,Xe,vn,jt,_s=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,yn,pe,Oe,wn,kt,bs=`Converts the output of <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> into image panoptic segmentation predictions. Only
supports PyTorch.`,vo,A,he,Xt,Qe,Cn,$t,vs="ConditionalDetrModel",yo,$,Ye,Tn,Ft,ys=`The bare Conditional DETR Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,Mn,zt,ws=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,xn,Ut,Cs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Dn,J,Ke,jn,It,Ts='The <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> forward method, overrides the <code>__call__</code> special method.',kn,ge,$n,fe,wo,H,ue,Ot,et,Fn,Jt,Ms="ConditionalDetrForObjectDetection",Co,F,tt,zn,Nt,xs=`CONDITIONAL_DETR Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on
top, for tasks such as COCO detection.`,Un,Et,Ds=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,In,Zt,js=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jn,N,ot,Nn,Lt,ks='The <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',En,_e,Zn,be,To,V,ve,Qt,nt,Ln,Rt,$s="ConditionalDetrForSegmentation",Mo,z,st,Rn,Pt,Fs=`CONDITIONAL_DETR Model (consisting of a backbone and encoder-decoder Transformer) with a segmentation head on top,
for tasks such as COCO panoptic.`,Pn,Wt,zs=`This model inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wn,St,Us=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Sn,E,at,Bn,Bt,Is='The <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a> forward method, overrides the <code>__call__</code> special method.',qn,ye,Gn,we,xo,Yt,Do;return De=new X({}),je=new X({}),Ie=new X({}),Ne=new X({}),Ee=new D({props:{name:"class transformers.ConditionalDetrConfig",anchor:"transformers.ConditionalDetrConfig",parameters:[{name:"use_timm_backbone",val:" = True"},{name:"backbone_config",val:" = None"},{name:"num_channels",val:" = 3"},{name:"num_queries",val:" = 300"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"encoder_layerdrop",val:" = 0.0"},{name:"decoder_layerdrop",val:" = 0.0"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"init_xavier_std",val:" = 1.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"backbone",val:" = 'resnet50'"},{name:"use_pretrained_backbone",val:" = True"},{name:"dilation",val:" = False"},{name:"class_cost",val:" = 2"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"mask_loss_coefficient",val:" = 1"},{name:"dice_loss_coefficient",val:" = 1"},{name:"cls_loss_coefficient",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"focal_alpha",val:" = 0.25"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ConditionalDetrConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to use the <code>timm</code> library for the backbone. If set to <code>False</code>, will use the <code>AutoBackbone</code>
API.`,name:"use_timm_backbone"},{anchor:"transformers.ConditionalDetrConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>) &#x2014;
The configuration of the backbone model. Only used in case <code>use_timm_backbone</code> is set to <code>False</code> in which
case it will default to <code>ResNetConfig()</code>.`,name:"backbone_config"},{anchor:"transformers.ConditionalDetrConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.ConditionalDetrConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> can detect in a single image. For COCO, we recommend 100 queries.`,name:"num_queries"},{anchor:"transformers.ConditionalDetrConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.ConditionalDetrConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.ConditionalDetrConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.ConditionalDetrConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.ConditionalDetrConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.ConditionalDetrConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.ConditionalDetrConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.ConditionalDetrConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.ConditionalDetrConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.ConditionalDetrConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.ConditionalDetrConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.ConditionalDetrConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.ConditionalDetrConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.ConditionalDetrConfig.encoder_layerdrop",description:`<strong>encoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the encoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"encoder_layerdrop"},{anchor:"transformers.ConditionalDetrConfig.decoder_layerdrop",description:`<strong>decoder_layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"decoder_layerdrop"},{anchor:"transformers.ConditionalDetrConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.ConditionalDetrConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.ConditionalDetrConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;resnet50&quot;</code>) &#x2014;
Name of convolutional backbone to use in case <code>use_timm_backbone</code> = <code>True</code>. Supports any convolutional
backbone from the timm package. For a list of all available models, see <a href="https://rwightman.github.io/pytorch-image-models/#load-a-pretrained-model" rel="nofollow">this
page</a>.`,name:"backbone"},{anchor:"transformers.ConditionalDetrConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use pretrained weights for the backbone. Only supported when <code>use_timm_backbone</code> = <code>True</code>.`,name:"use_pretrained_backbone"},{anchor:"transformers.ConditionalDetrConfig.dilation",description:`<strong>dilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to replace stride with dilation in the last convolutional block (DC5). Only supported when
<code>use_timm_backbone</code> = <code>True</code>.`,name:"dilation"},{anchor:"transformers.ConditionalDetrConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.ConditionalDetrConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.ConditionalDetrConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.ConditionalDetrConfig.mask_loss_coefficient",description:`<strong>mask_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the Focal loss in the panoptic segmentation loss.`,name:"mask_loss_coefficient"},{anchor:"transformers.ConditionalDetrConfig.dice_loss_coefficient",description:`<strong>dice_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the DICE/F-1 loss in the panoptic segmentation loss.`,name:"dice_loss_coefficient"},{anchor:"transformers.ConditionalDetrConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.ConditionalDetrConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.ConditionalDetrConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"},{anchor:"transformers.ConditionalDetrConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/configuration_conditional_detr.py#L36"}}),ee=new Bo({props:{anchor:"transformers.ConditionalDetrConfig.example",$$slots:{default:[ea]},$$scope:{ctx:k}}}),Ze=new X({}),Le=new D({props:{name:"class transformers.ConditionalDetrImageProcessor",anchor:"transformers.ConditionalDetrImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.conditional_detr.image_processing_conditional_detr.AnnotionFormat] = <AnnotionFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ConditionalDetrImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.ConditionalDetrImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.ConditionalDetrImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s (height, width) dimensions after resizing. Can be overridden by the <code>size</code> parameter in
the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.ConditionalDetrImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.ConditionalDetrImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.ConditionalDetrImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.ConditionalDetrImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.ConditionalDetrImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.ConditionalDetrImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image to the largest image in a batch and create a pixel mask. Can be
overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L763"}}),Re=new D({props:{name:"preprocess",anchor:"transformers.ConditionalDetrImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.conditional_detr.image_processing_conditional_detr.AnnotionFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotionFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ConditionalDetrImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1104"}}),Pe=new D({props:{name:"post_process_object_detection",anchor:"transformers.ConditionalDetrImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.ConditionalDetrImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1396",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),We=new D({props:{name:"post_process_instance_segmentation",anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE)
format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1504",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Se=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.ConditionalDetrImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple[int, int]] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
A list of tuples (<code>Tuple[int, int]</code>) containing the target size (height, width) of each image in the
batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1455",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),Be=new D({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>) &#x2014;
The outputs from <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>.`,name:"outputs"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.ConditionalDetrImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1589",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized to
the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),qe=new X({}),Ge=new D({props:{name:"class transformers.ConditionalDetrFeatureExtractor",anchor:"transformers.ConditionalDetrFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/feature_extraction_conditional_detr.py#L26"}}),Ae=new D({props:{name:"__call__",anchor:"transformers.ConditionalDetrFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/image_processing_utils.py#L544"}}),He=new D({props:{name:"post_process_object_detection",anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>DetrObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1396",returnDescription:`
<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Ve=new D({props:{name:"post_process_instance_segmentation",anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE)
format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1504",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Xe=new D({props:{name:"post_process_semantic_segmentation",anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple[int, int]] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
A list of tuples (<code>Tuple[int, int]</code>) containing the target size (height, width) of each image in the
batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1455",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),Oe=new D({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>) &#x2014;
The outputs from <a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrForSegmentation">ConditionalDetrForSegmentation</a>.`,name:"outputs"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/image_processing_conditional_detr.py#L1589",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized to
the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Qe=new X({}),Ye=new D({props:{name:"class transformers.ConditionalDetrModel",anchor:"transformers.ConditionalDetrModel",parameters:[{name:"config",val:": ConditionalDetrConfig"}],parametersDescription:[{anchor:"transformers.ConditionalDetrModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/modeling_conditional_detr.py#L1604"}}),Ke=new D({props:{name:"forward",anchor:"transformers.ConditionalDetrModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">ConditionalDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.ConditionalDetrModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.ConditionalDetrModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.ConditionalDetrModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.ConditionalDetrModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.ConditionalDetrModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.ConditionalDetrModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ConditionalDetrModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ConditionalDetrModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/modeling_conditional_detr.py#L1638",returnDescription:`
<p>A <code>transformers.models.conditional_detr.modeling_conditional_detr.ConditionalDetrModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig"
>ConditionalDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(config.decoder_layers, batch_size, sequence_length, hidden_size)</code>, <em>optional</em>, returned when <code>config.auxiliary_loss=True</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
</ul>
`,returnType:`
<p><code>transformers.models.conditional_detr.modeling_conditional_detr.ConditionalDetrModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new An({props:{$$slots:{default:[ta]},$$scope:{ctx:k}}}),fe=new Bo({props:{anchor:"transformers.ConditionalDetrModel.forward.example",$$slots:{default:[oa]},$$scope:{ctx:k}}}),et=new X({}),tt=new D({props:{name:"class transformers.ConditionalDetrForObjectDetection",anchor:"transformers.ConditionalDetrForObjectDetection",parameters:[{name:"config",val:": ConditionalDetrConfig"}],parametersDescription:[{anchor:"transformers.ConditionalDetrForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/modeling_conditional_detr.py#L1773"}}),ot=new D({props:{name:"forward",anchor:"transformers.ConditionalDetrForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">ConditionalDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ConditionalDetrForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/modeling_conditional_detr.py#L1799",returnDescription:`
<p>A <code>transformers.models.conditional_detr.modeling_conditional_detr.ConditionalDetrObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig"
>ConditionalDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve
the unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`
<p><code>transformers.models.conditional_detr.modeling_conditional_detr.ConditionalDetrObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new An({props:{$$slots:{default:[na]},$$scope:{ctx:k}}}),be=new Bo({props:{anchor:"transformers.ConditionalDetrForObjectDetection.forward.example",$$slots:{default:[sa]},$$scope:{ctx:k}}}),nt=new X({}),st=new D({props:{name:"class transformers.ConditionalDetrForSegmentation",anchor:"transformers.ConditionalDetrForSegmentation",parameters:[{name:"config",val:": ConditionalDetrConfig"}],parametersDescription:[{anchor:"transformers.ConditionalDetrForSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/modeling_conditional_detr.py#L1961"}}),at=new D({props:{name:"forward",anchor:"transformers.ConditionalDetrForSegmentation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"pixel_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[typing.List[dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ConditionalDetrForSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">ConditionalDetrImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries)</code>, <em>optional</em>) &#x2014;
Not used by default. Can be used to mask object queries.`,name:"decoder_attention_mask"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing the flattened feature map (output of the backbone + projection layer), you
can choose to directly pass a flattened representation of an image.`,name:"inputs_embeds"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of initializing the queries with a tensor of zeros, you can choose to directly pass an
embedded representation.`,name:"decoder_inputs_embeds"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ConditionalDetrForSegmentation.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss, DICE/F-1 loss and Focal loss. List of dicts, each
dictionary containing at least the following 3 keys: &#x2018;class_labels&#x2019;, &#x2018;boxes&#x2019; and &#x2018;masks&#x2019; (the class labels,
bounding boxes and segmentation masks of an image in the batch respectively). The class labels themselves
should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code>, the boxes a
<code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code> and the masks a
<code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, height, width)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/conditional_detr/modeling_conditional_detr.py#L1983",returnDescription:`
<p>A <code>transformers.models.conditional_detr.modeling_conditional_detr.ConditionalDetrSegmentationOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrConfig"
>ConditionalDetrConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve
the unnormalized bounding boxes.</li>
<li><strong>pred_masks</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height/4, width/4)</code>) — Segmentation masks logits for all queries. See also
<a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor.post_process_semantic_segmentation"
>post_process_semantic_segmentation()</a> or
<a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor.post_process_instance_segmentation"
>post_process_instance_segmentation()</a>
<a
  href="/docs/transformers/v4.34.0/en/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor.post_process_panoptic_segmentation"
>post_process_panoptic_segmentation()</a> to evaluate semantic, instance and
panoptic segmentation masks respectively.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the decoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the encoder at the output of each
layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the encoder, after the attention softmax, used to compute the
weighted average in the self-attention heads.</li>
</ul>
`,returnType:`
<p><code>transformers.models.conditional_detr.modeling_conditional_detr.ConditionalDetrSegmentationOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new An({props:{$$slots:{default:[aa]},$$scope:{ctx:k}}}),we=new Bo({props:{anchor:"transformers.ConditionalDetrForSegmentation.forward.example",$$slots:{default:[ra]},$$scope:{ctx:k}}}),{c(){d=n("meta"),T=a(),g=n("p"),f=a(),C=n("h1"),i=n("a"),M=n("span"),u(De.$$.fragment),Go=a(),ct=n("span"),ct.textContent=Hn,no=a(),W=n("h2"),O=n("a"),qt=n("span"),u(je.$$.fragment),Ao=a(),mt=n("span"),mt.textContent=Vn,so=a(),ke=n("p"),ke.innerHTML=Xn,ao=a(),$e=n("p"),$e.textContent=On,ro=a(),Fe=n("p"),Fe.innerHTML=Qn,io=a(),Q=n("img"),lo=a(),ze=n("small"),ze.innerHTML=Kn,co=a(),Ue=n("p"),Ue.innerHTML=es,mo=a(),S=n("h2"),Y=n("a"),Gt=n("span"),u(Ie.$$.fragment),Ho=a(),pt=n("span"),pt.textContent=ts,po=a(),Je=n("ul"),Je.innerHTML=os,ho=a(),B=n("h2"),K=n("a"),At=n("span"),u(Ne.$$.fragment),Vo=a(),ht=n("span"),ht.textContent=ns,go=a(),I=n("div"),u(Ee.$$.fragment),Xo=a(),gt=n("p"),gt.innerHTML=ss,Oo=a(),ft=n("p"),ft.innerHTML=as,Qo=a(),u(ee.$$.fragment),fo=a(),q=n("h2"),te=n("a"),Ht=n("span"),u(Ze.$$.fragment),Yo=a(),ut=n("span"),ut.textContent=rs,uo=a(),x=n("div"),u(Le.$$.fragment),Ko=a(),_t=n("p"),_t.textContent=is,en=a(),oe=n("div"),u(Re.$$.fragment),tn=a(),bt=n("p"),bt.textContent=ls,on=a(),ne=n("div"),u(Pe.$$.fragment),nn=a(),vt=n("p"),vt.innerHTML=ds,sn=a(),se=n("div"),u(We.$$.fragment),an=a(),yt=n("p"),yt.innerHTML=cs,rn=a(),ae=n("div"),u(Se.$$.fragment),ln=a(),wt=n("p"),wt.innerHTML=ms,dn=a(),re=n("div"),u(Be.$$.fragment),cn=a(),Ct=n("p"),Ct.innerHTML=ps,_o=a(),G=n("h2"),ie=n("a"),Vt=n("span"),u(qe.$$.fragment),mn=a(),Tt=n("span"),Tt.textContent=hs,bo=a(),j=n("div"),u(Ge.$$.fragment),pn=a(),le=n("div"),u(Ae.$$.fragment),hn=a(),Mt=n("p"),Mt.textContent=gs,gn=a(),de=n("div"),u(He.$$.fragment),fn=a(),xt=n("p"),xt.innerHTML=fs,un=a(),ce=n("div"),u(Ve.$$.fragment),_n=a(),Dt=n("p"),Dt.innerHTML=us,bn=a(),me=n("div"),u(Xe.$$.fragment),vn=a(),jt=n("p"),jt.innerHTML=_s,yn=a(),pe=n("div"),u(Oe.$$.fragment),wn=a(),kt=n("p"),kt.innerHTML=bs,vo=a(),A=n("h2"),he=n("a"),Xt=n("span"),u(Qe.$$.fragment),Cn=a(),$t=n("span"),$t.textContent=vs,yo=a(),$=n("div"),u(Ye.$$.fragment),Tn=a(),Ft=n("p"),Ft.textContent=ys,Mn=a(),zt=n("p"),zt.innerHTML=ws,xn=a(),Ut=n("p"),Ut.innerHTML=Cs,Dn=a(),J=n("div"),u(Ke.$$.fragment),jn=a(),It=n("p"),It.innerHTML=Ts,kn=a(),u(ge.$$.fragment),$n=a(),u(fe.$$.fragment),wo=a(),H=n("h2"),ue=n("a"),Ot=n("span"),u(et.$$.fragment),Fn=a(),Jt=n("span"),Jt.textContent=Ms,Co=a(),F=n("div"),u(tt.$$.fragment),zn=a(),Nt=n("p"),Nt.textContent=xs,Un=a(),Et=n("p"),Et.innerHTML=Ds,In=a(),Zt=n("p"),Zt.innerHTML=js,Jn=a(),N=n("div"),u(ot.$$.fragment),Nn=a(),Lt=n("p"),Lt.innerHTML=ks,En=a(),u(_e.$$.fragment),Zn=a(),u(be.$$.fragment),To=a(),V=n("h2"),ve=n("a"),Qt=n("span"),u(nt.$$.fragment),Ln=a(),Rt=n("span"),Rt.textContent=$s,Mo=a(),z=n("div"),u(st.$$.fragment),Rn=a(),Pt=n("p"),Pt.textContent=Fs,Pn=a(),Wt=n("p"),Wt.innerHTML=zs,Wn=a(),St=n("p"),St.innerHTML=Us,Sn=a(),E=n("div"),u(at.$$.fragment),Bn=a(),Bt=n("p"),Bt.innerHTML=Is,qn=a(),u(ye.$$.fragment),Gn=a(),u(we.$$.fragment),xo=a(),Yt=n("p"),this.h()},l(e){const l=Ks("svelte-1phssyn",document.head);d=s(l,"META",{name:!0,content:!0}),l.forEach(o),T=r(e),g=s(e,"P",{}),p(g).forEach(o),f=r(e),C=s(e,"H1",{class:!0});var rt=p(C);i=s(rt,"A",{id:!0,class:!0,href:!0});var Kt=p(i);M=s(Kt,"SPAN",{});var eo=p(M);_(De.$$.fragment,eo),eo.forEach(o),Kt.forEach(o),Go=r(rt),ct=s(rt,"SPAN",{"data-svelte-h":!0}),h(ct)!=="svelte-12rqdeq"&&(ct.textContent=Hn),rt.forEach(o),no=r(e),W=s(e,"H2",{class:!0});var it=p(W);O=s(it,"A",{id:!0,class:!0,href:!0});var to=p(O);qt=s(to,"SPAN",{});var oo=p(qt);_(je.$$.fragment,oo),oo.forEach(o),to.forEach(o),Ao=r(it),mt=s(it,"SPAN",{"data-svelte-h":!0}),h(mt)!=="svelte-1jsw1pg"&&(mt.textContent=Vn),it.forEach(o),so=r(e),ke=s(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-p6b5zw"&&(ke.innerHTML=Xn),ao=r(e),$e=s(e,"P",{"data-svelte-h":!0}),h($e)!=="svelte-vfdo9a"&&($e.textContent=On),ro=r(e),Fe=s(e,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-jvp4bn"&&(Fe.innerHTML=Qn),io=r(e),Q=s(e,"IMG",{src:!0,alt:!0,width:!0}),lo=r(e),ze=s(e,"SMALL",{"data-svelte-h":!0}),h(ze)!=="svelte-w9m4kj"&&(ze.innerHTML=Kn),co=r(e),Ue=s(e,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-7exlsi"&&(Ue.innerHTML=es),mo=r(e),S=s(e,"H2",{class:!0});var lt=p(S);Y=s(lt,"A",{id:!0,class:!0,href:!0});var Js=p(Y);Gt=s(Js,"SPAN",{});var Ns=p(Gt);_(Ie.$$.fragment,Ns),Ns.forEach(o),Js.forEach(o),Ho=r(lt),pt=s(lt,"SPAN",{"data-svelte-h":!0}),h(pt)!=="svelte-n3f0j0"&&(pt.textContent=ts),lt.forEach(o),po=r(e),Je=s(e,"UL",{"data-svelte-h":!0}),h(Je)!=="svelte-10304zi"&&(Je.innerHTML=os),ho=r(e),B=s(e,"H2",{class:!0});var jo=p(B);K=s(jo,"A",{id:!0,class:!0,href:!0});var Es=p(K);At=s(Es,"SPAN",{});var Zs=p(At);_(Ne.$$.fragment,Zs),Zs.forEach(o),Es.forEach(o),Vo=r(jo),ht=s(jo,"SPAN",{"data-svelte-h":!0}),h(ht)!=="svelte-1haaack"&&(ht.textContent=ns),jo.forEach(o),go=r(e),I=s(e,"DIV",{class:!0});var Ce=p(I);_(Ee.$$.fragment,Ce),Xo=r(Ce),gt=s(Ce,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-1y8jvet"&&(gt.innerHTML=ss),Oo=r(Ce),ft=s(Ce,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-10kqkkl"&&(ft.innerHTML=as),Qo=r(Ce),_(ee.$$.fragment,Ce),Ce.forEach(o),fo=r(e),q=s(e,"H2",{class:!0});var ko=p(q);te=s(ko,"A",{id:!0,class:!0,href:!0});var Ls=p(te);Ht=s(Ls,"SPAN",{});var Rs=p(Ht);_(Ze.$$.fragment,Rs),Rs.forEach(o),Ls.forEach(o),Yo=r(ko),ut=s(ko,"SPAN",{"data-svelte-h":!0}),h(ut)!=="svelte-dwhh0d"&&(ut.textContent=rs),ko.forEach(o),uo=r(e),x=s(e,"DIV",{class:!0});var U=p(x);_(Le.$$.fragment,U),Ko=r(U),_t=s(U,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-17j4jp9"&&(_t.textContent=is),en=r(U),oe=s(U,"DIV",{class:!0});var $o=p(oe);_(Re.$$.fragment,$o),tn=r($o),bt=s($o,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-jgz2ra"&&(bt.textContent=ls),$o.forEach(o),on=r(U),ne=s(U,"DIV",{class:!0});var Fo=p(ne);_(Pe.$$.fragment,Fo),nn=r(Fo),vt=s(Fo,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-18n2ocb"&&(vt.innerHTML=ds),Fo.forEach(o),sn=r(U),se=s(U,"DIV",{class:!0});var zo=p(se);_(We.$$.fragment,zo),an=r(zo),yt=s(zo,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-7hjpt4"&&(yt.innerHTML=cs),zo.forEach(o),rn=r(U),ae=s(U,"DIV",{class:!0});var Uo=p(ae);_(Se.$$.fragment,Uo),ln=r(Uo),wt=s(Uo,"P",{"data-svelte-h":!0}),h(wt)!=="svelte-fkvr48"&&(wt.innerHTML=ms),Uo.forEach(o),dn=r(U),re=s(U,"DIV",{class:!0});var Io=p(re);_(Be.$$.fragment,Io),cn=r(Io),Ct=s(Io,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-h56bmo"&&(Ct.innerHTML=ps),Io.forEach(o),U.forEach(o),_o=r(e),G=s(e,"H2",{class:!0});var Jo=p(G);ie=s(Jo,"A",{id:!0,class:!0,href:!0});var Ps=p(ie);Vt=s(Ps,"SPAN",{});var Ws=p(Vt);_(qe.$$.fragment,Ws),Ws.forEach(o),Ps.forEach(o),mn=r(Jo),Tt=s(Jo,"SPAN",{"data-svelte-h":!0}),h(Tt)!=="svelte-pr3vco"&&(Tt.textContent=hs),Jo.forEach(o),bo=r(e),j=s(e,"DIV",{class:!0});var Z=p(j);_(Ge.$$.fragment,Z),pn=r(Z),le=s(Z,"DIV",{class:!0});var No=p(le);_(Ae.$$.fragment,No),hn=r(No),Mt=s(No,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-khengj"&&(Mt.textContent=gs),No.forEach(o),gn=r(Z),de=s(Z,"DIV",{class:!0});var Eo=p(de);_(He.$$.fragment,Eo),fn=r(Eo),xt=s(Eo,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-18n2ocb"&&(xt.innerHTML=fs),Eo.forEach(o),un=r(Z),ce=s(Z,"DIV",{class:!0});var Zo=p(ce);_(Ve.$$.fragment,Zo),_n=r(Zo),Dt=s(Zo,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-7hjpt4"&&(Dt.innerHTML=us),Zo.forEach(o),bn=r(Z),me=s(Z,"DIV",{class:!0});var Lo=p(me);_(Xe.$$.fragment,Lo),vn=r(Lo),jt=s(Lo,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-fkvr48"&&(jt.innerHTML=_s),Lo.forEach(o),yn=r(Z),pe=s(Z,"DIV",{class:!0});var Ro=p(pe);_(Oe.$$.fragment,Ro),wn=r(Ro),kt=s(Ro,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-h56bmo"&&(kt.innerHTML=bs),Ro.forEach(o),Z.forEach(o),vo=r(e),A=s(e,"H2",{class:!0});var Po=p(A);he=s(Po,"A",{id:!0,class:!0,href:!0});var Ss=p(he);Xt=s(Ss,"SPAN",{});var Bs=p(Xt);_(Qe.$$.fragment,Bs),Bs.forEach(o),Ss.forEach(o),Cn=r(Po),$t=s(Po,"SPAN",{"data-svelte-h":!0}),h($t)!=="svelte-qhxwvr"&&($t.textContent=vs),Po.forEach(o),yo=r(e),$=s(e,"DIV",{class:!0});var L=p($);_(Ye.$$.fragment,L),Tn=r(L),Ft=s(L,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-1lwpr2z"&&(Ft.textContent=ys),Mn=r(L),zt=s(L,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-hmtw9k"&&(zt.innerHTML=ws),xn=r(L),Ut=s(L,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-hswkmf"&&(Ut.innerHTML=Cs),Dn=r(L),J=s(L,"DIV",{class:!0});var Te=p(J);_(Ke.$$.fragment,Te),jn=r(Te),It=s(Te,"P",{"data-svelte-h":!0}),h(It)!=="svelte-1cl19dx"&&(It.innerHTML=Ts),kn=r(Te),_(ge.$$.fragment,Te),$n=r(Te),_(fe.$$.fragment,Te),Te.forEach(o),L.forEach(o),wo=r(e),H=s(e,"H2",{class:!0});var Wo=p(H);ue=s(Wo,"A",{id:!0,class:!0,href:!0});var qs=p(ue);Ot=s(qs,"SPAN",{});var Gs=p(Ot);_(et.$$.fragment,Gs),Gs.forEach(o),qs.forEach(o),Fn=r(Wo),Jt=s(Wo,"SPAN",{"data-svelte-h":!0}),h(Jt)!=="svelte-cr1f3h"&&(Jt.textContent=Ms),Wo.forEach(o),Co=r(e),F=s(e,"DIV",{class:!0});var R=p(F);_(tt.$$.fragment,R),zn=r(R),Nt=s(R,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-1b6ijwv"&&(Nt.textContent=xs),Un=r(R),Et=s(R,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-hmtw9k"&&(Et.innerHTML=Ds),In=r(R),Zt=s(R,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-hswkmf"&&(Zt.innerHTML=js),Jn=r(R),N=s(R,"DIV",{class:!0});var Me=p(N);_(ot.$$.fragment,Me),Nn=r(Me),Lt=s(Me,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-1y83vqd"&&(Lt.innerHTML=ks),En=r(Me),_(_e.$$.fragment,Me),Zn=r(Me),_(be.$$.fragment,Me),Me.forEach(o),R.forEach(o),To=r(e),V=s(e,"H2",{class:!0});var So=p(V);ve=s(So,"A",{id:!0,class:!0,href:!0});var As=p(ve);Qt=s(As,"SPAN",{});var Hs=p(Qt);_(nt.$$.fragment,Hs),Hs.forEach(o),As.forEach(o),Ln=r(So),Rt=s(So,"SPAN",{"data-svelte-h":!0}),h(Rt)!=="svelte-1bymhrf"&&(Rt.textContent=$s),So.forEach(o),Mo=r(e),z=s(e,"DIV",{class:!0});var P=p(z);_(st.$$.fragment,P),Rn=r(P),Pt=s(P,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-1qyfet8"&&(Pt.textContent=Fs),Pn=r(P),Wt=s(P,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-hmtw9k"&&(Wt.innerHTML=zs),Wn=r(P),St=s(P,"P",{"data-svelte-h":!0}),h(St)!=="svelte-hswkmf"&&(St.innerHTML=Us),Sn=r(P),E=s(P,"DIV",{class:!0});var xe=p(E);_(at.$$.fragment,xe),Bn=r(xe),Bt=s(xe,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-1noujxt"&&(Bt.innerHTML=Is),qn=r(xe),_(ye.$$.fragment,xe),Gn=r(xe),_(we.$$.fragment,xe),xe.forEach(o),P.forEach(o),xo=r(e),Yt=s(e,"P",{}),p(Yt).forEach(o),this.h()},h(){c(d,"name","hf:doc:metadata"),c(d,"content",JSON.stringify(la)),c(i,"id","conditional-detr"),c(i,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(i,"href","#conditional-detr"),c(C,"class","relative group"),c(O,"id","overview"),c(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(O,"href","#overview"),c(W,"class","relative group"),Xs(Q.src,Yn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/conditional_detr_curve.jpg")||c(Q,"src",Yn),c(Q,"alt","drawing"),c(Q,"width","600"),c(Y,"id","documentation-resources"),c(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Y,"href","#documentation-resources"),c(S,"class","relative group"),c(K,"id","transformers.ConditionalDetrConfig"),c(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(K,"href","#transformers.ConditionalDetrConfig"),c(B,"class","relative group"),c(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(te,"id","transformers.ConditionalDetrImageProcessor"),c(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(te,"href","#transformers.ConditionalDetrImageProcessor"),c(q,"class","relative group"),c(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ie,"id","transformers.ConditionalDetrFeatureExtractor"),c(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ie,"href","#transformers.ConditionalDetrFeatureExtractor"),c(G,"class","relative group"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(he,"id","transformers.ConditionalDetrModel"),c(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(he,"href","#transformers.ConditionalDetrModel"),c(A,"class","relative group"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ue,"id","transformers.ConditionalDetrForObjectDetection"),c(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ue,"href","#transformers.ConditionalDetrForObjectDetection"),c(H,"class","relative group"),c(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ve,"id","transformers.ConditionalDetrForSegmentation"),c(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ve,"href","#transformers.ConditionalDetrForSegmentation"),c(V,"class","relative group"),c(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,d),m(e,T,l),m(e,g,l),m(e,f,l),m(e,C,l),t(C,i),t(i,M),b(De,M,null),t(C,Go),t(C,ct),m(e,no,l),m(e,W,l),t(W,O),t(O,qt),b(je,qt,null),t(W,Ao),t(W,mt),m(e,so,l),m(e,ke,l),m(e,ao,l),m(e,$e,l),m(e,ro,l),m(e,Fe,l),m(e,io,l),m(e,Q,l),m(e,lo,l),m(e,ze,l),m(e,co,l),m(e,Ue,l),m(e,mo,l),m(e,S,l),t(S,Y),t(Y,Gt),b(Ie,Gt,null),t(S,Ho),t(S,pt),m(e,po,l),m(e,Je,l),m(e,ho,l),m(e,B,l),t(B,K),t(K,At),b(Ne,At,null),t(B,Vo),t(B,ht),m(e,go,l),m(e,I,l),b(Ee,I,null),t(I,Xo),t(I,gt),t(I,Oo),t(I,ft),t(I,Qo),b(ee,I,null),m(e,fo,l),m(e,q,l),t(q,te),t(te,Ht),b(Ze,Ht,null),t(q,Yo),t(q,ut),m(e,uo,l),m(e,x,l),b(Le,x,null),t(x,Ko),t(x,_t),t(x,en),t(x,oe),b(Re,oe,null),t(oe,tn),t(oe,bt),t(x,on),t(x,ne),b(Pe,ne,null),t(ne,nn),t(ne,vt),t(x,sn),t(x,se),b(We,se,null),t(se,an),t(se,yt),t(x,rn),t(x,ae),b(Se,ae,null),t(ae,ln),t(ae,wt),t(x,dn),t(x,re),b(Be,re,null),t(re,cn),t(re,Ct),m(e,_o,l),m(e,G,l),t(G,ie),t(ie,Vt),b(qe,Vt,null),t(G,mn),t(G,Tt),m(e,bo,l),m(e,j,l),b(Ge,j,null),t(j,pn),t(j,le),b(Ae,le,null),t(le,hn),t(le,Mt),t(j,gn),t(j,de),b(He,de,null),t(de,fn),t(de,xt),t(j,un),t(j,ce),b(Ve,ce,null),t(ce,_n),t(ce,Dt),t(j,bn),t(j,me),b(Xe,me,null),t(me,vn),t(me,jt),t(j,yn),t(j,pe),b(Oe,pe,null),t(pe,wn),t(pe,kt),m(e,vo,l),m(e,A,l),t(A,he),t(he,Xt),b(Qe,Xt,null),t(A,Cn),t(A,$t),m(e,yo,l),m(e,$,l),b(Ye,$,null),t($,Tn),t($,Ft),t($,Mn),t($,zt),t($,xn),t($,Ut),t($,Dn),t($,J),b(Ke,J,null),t(J,jn),t(J,It),t(J,kn),b(ge,J,null),t(J,$n),b(fe,J,null),m(e,wo,l),m(e,H,l),t(H,ue),t(ue,Ot),b(et,Ot,null),t(H,Fn),t(H,Jt),m(e,Co,l),m(e,F,l),b(tt,F,null),t(F,zn),t(F,Nt),t(F,Un),t(F,Et),t(F,In),t(F,Zt),t(F,Jn),t(F,N),b(ot,N,null),t(N,Nn),t(N,Lt),t(N,En),b(_e,N,null),t(N,Zn),b(be,N,null),m(e,To,l),m(e,V,l),t(V,ve),t(ve,Qt),b(nt,Qt,null),t(V,Ln),t(V,Rt),m(e,Mo,l),m(e,z,l),b(st,z,null),t(z,Rn),t(z,Pt),t(z,Pn),t(z,Wt),t(z,Wn),t(z,St),t(z,Sn),t(z,E),b(at,E,null),t(E,Bn),t(E,Bt),t(E,qn),b(ye,E,null),t(E,Gn),b(we,E,null),m(e,xo,l),m(e,Yt,l),Do=!0},p(e,[l]){const rt={};l&2&&(rt.$$scope={dirty:l,ctx:e}),ee.$set(rt);const Kt={};l&2&&(Kt.$$scope={dirty:l,ctx:e}),ge.$set(Kt);const eo={};l&2&&(eo.$$scope={dirty:l,ctx:e}),fe.$set(eo);const it={};l&2&&(it.$$scope={dirty:l,ctx:e}),_e.$set(it);const to={};l&2&&(to.$$scope={dirty:l,ctx:e}),be.$set(to);const oo={};l&2&&(oo.$$scope={dirty:l,ctx:e}),ye.$set(oo);const lt={};l&2&&(lt.$$scope={dirty:l,ctx:e}),we.$set(lt)},i(e){Do||(v(De.$$.fragment,e),v(je.$$.fragment,e),v(Ie.$$.fragment,e),v(Ne.$$.fragment,e),v(Ee.$$.fragment,e),v(ee.$$.fragment,e),v(Ze.$$.fragment,e),v(Le.$$.fragment,e),v(Re.$$.fragment,e),v(Pe.$$.fragment,e),v(We.$$.fragment,e),v(Se.$$.fragment,e),v(Be.$$.fragment,e),v(qe.$$.fragment,e),v(Ge.$$.fragment,e),v(Ae.$$.fragment,e),v(He.$$.fragment,e),v(Ve.$$.fragment,e),v(Xe.$$.fragment,e),v(Oe.$$.fragment,e),v(Qe.$$.fragment,e),v(Ye.$$.fragment,e),v(Ke.$$.fragment,e),v(ge.$$.fragment,e),v(fe.$$.fragment,e),v(et.$$.fragment,e),v(tt.$$.fragment,e),v(ot.$$.fragment,e),v(_e.$$.fragment,e),v(be.$$.fragment,e),v(nt.$$.fragment,e),v(st.$$.fragment,e),v(at.$$.fragment,e),v(ye.$$.fragment,e),v(we.$$.fragment,e),Do=!0)},o(e){y(De.$$.fragment,e),y(je.$$.fragment,e),y(Ie.$$.fragment,e),y(Ne.$$.fragment,e),y(Ee.$$.fragment,e),y(ee.$$.fragment,e),y(Ze.$$.fragment,e),y(Le.$$.fragment,e),y(Re.$$.fragment,e),y(Pe.$$.fragment,e),y(We.$$.fragment,e),y(Se.$$.fragment,e),y(Be.$$.fragment,e),y(qe.$$.fragment,e),y(Ge.$$.fragment,e),y(Ae.$$.fragment,e),y(He.$$.fragment,e),y(Ve.$$.fragment,e),y(Xe.$$.fragment,e),y(Oe.$$.fragment,e),y(Qe.$$.fragment,e),y(Ye.$$.fragment,e),y(Ke.$$.fragment,e),y(ge.$$.fragment,e),y(fe.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(ot.$$.fragment,e),y(_e.$$.fragment,e),y(be.$$.fragment,e),y(nt.$$.fragment,e),y(st.$$.fragment,e),y(at.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),Do=!1},d(e){e&&(o(T),o(g),o(f),o(C),o(no),o(W),o(so),o(ke),o(ao),o($e),o(ro),o(Fe),o(io),o(Q),o(lo),o(ze),o(co),o(Ue),o(mo),o(S),o(po),o(Je),o(ho),o(B),o(go),o(I),o(fo),o(q),o(uo),o(x),o(_o),o(G),o(bo),o(j),o(vo),o(A),o(yo),o($),o(wo),o(H),o(Co),o(F),o(To),o(V),o(Mo),o(z),o(xo),o(Yt)),o(d),w(De),w(je),w(Ie),w(Ne),w(Ee),w(ee),w(Ze),w(Le),w(Re),w(Pe),w(We),w(Se),w(Be),w(qe),w(Ge),w(Ae),w(He),w(Ve),w(Xe),w(Oe),w(Qe),w(Ye),w(Ke),w(ge),w(fe),w(et),w(tt),w(ot),w(_e),w(be),w(nt),w(st),w(at),w(ye),w(we)}}}const la={local:"conditional-detr",sections:[{local:"overview",title:"Overview"},{local:"documentation-resources",title:"Documentation resources"},{local:"transformers.ConditionalDetrConfig",title:"ConditionalDetrConfig"},{local:"transformers.ConditionalDetrImageProcessor",title:"ConditionalDetrImageProcessor"},{local:"transformers.ConditionalDetrFeatureExtractor",title:"ConditionalDetrFeatureExtractor"},{local:"transformers.ConditionalDetrModel",title:"ConditionalDetrModel"},{local:"transformers.ConditionalDetrForObjectDetection",title:"ConditionalDetrForObjectDetection"},{local:"transformers.ConditionalDetrForSegmentation",title:"ConditionalDetrForSegmentation"}],title:"Conditional DETR"};function da(k){return Os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _a extends Qs{constructor(d){super(),Ys(this,d,da,ia,Vs,{})}}export{_a as component};
