import{s as Ss,o as Xs,n as As}from"../chunks/scheduler.36a0863c.js";import{S as Ns,i as Ys,g as l,s as i,u,A as Fs,h as n,f as s,c as p,j as d,v as m,y as r,k as o,o as c,a,w as f,d as g,t as y,x as M}from"../chunks/index.d0f7a4c4.js";import{T as Qs}from"../chunks/Tip.4c7d7eb1.js";import{I as $e}from"../chunks/IconCopyLink.bc5fad79.js";import{C as v}from"../chunks/CodeBlock.4236768d.js";function Ds(Ue){let h,W="Echa un vistazo a la documentación de <code>pipeline()</code> para obtener una lista completa de tareas admitidas.";return{c(){h=l("p"),h.innerHTML=W},l(j){h=n(j,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1daerre"&&(h.innerHTML=W)},m(j,he){a(j,h,he)},p:As,d(j){j&&s(h)}}}function Ks(Ue){let h,W,j,he,w,T,ye,_,os,de,us="Pipelines para inferencia",be,B,ms='Un <code>pipeline()</code> simplifica el uso de cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> para la inferencia en una variedad de tareas como la generación de texto, la segmentación de imágenes y la clasificación de audio. Incluso si no tienes experiencia con una modalidad específica o no comprendes el código que alimenta los modelos, ¡aún puedes usarlos con el <code>pipeline()</code>! Este tutorial te enseñará a:',Te,H,fs="<li>Utilizar un <code>pipeline()</code> para inferencia.</li> <li>Utilizar un tokenizador o modelo específico.</li> <li>Utilizar un <code>pipeline()</code> para tareas de audio y visión.</li>",ke,k,Je,x,J,Me,E,rs,ue,gs="Uso del pipeline",Ze,V,ys="Si bien cada tarea tiene un <code>pipeline()</code> asociado, es más sencillo usar la abstracción general <code>pipeline()</code> que contiene todos los pipelines de tareas específicas. El <code>pipeline()</code> carga automáticamente un modelo predeterminado y un tokenizador con capacidad de inferencia para tu tarea.",Ce,q,Ms="<li>Comienza creando un <code>pipeline()</code> y específica una tarea de inferencia:</li>",Ge,z,Ie,Z,js="<li>Pasa tu texto de entrada al <code>pipeline()</code>:</li>",We,L,_e,R,vs="Si tienes más de una entrada, pásala como una lista:",Be,P,He,S,ws="Cualquier parámetro adicional para tu tarea también se puede incluir en el <code>pipeline()</code>. La tarea <code>text-generation</code> tiene un método <code>generate()</code> con varios parámetros para controlar la salida. Por ejemplo, si deseas generar más de una salida, defínelo en el parámetro <code>num_return_sequences</code>:",Ee,X,Ve,$,C,je,A,cs,me,xs="Selecciona un modelo y un tokenizador",qe,N,$s='El <code>pipeline()</code> acepta cualquier modelo del <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Hay etiquetas en el Model Hub que te permiten filtrar por el modelo que te gustaría utilizar para tu tarea. Una vez que hayas elegido un modelo apropiado, cárgalo con la clase <code>AutoModelFor</code> y <code>AutoTokenizer</code> correspondientes. Por ejemplo, carga la clase <code>AutoModelForCausalLM</code> para una tarea de modelado de lenguaje causal:',ze,Y,Le,F,Us="Crea un <code>pipeline()</code> para tu tarea y específica el modelo y el tokenizador que cargaste:",Re,Q,Pe,D,bs="Pasa tu texto de entrada a <code>pipeline()</code> para generar algo de texto:",Se,K,Xe,U,G,ve,O,hs,fe,Ts="Pipeline de audio",Ae,ee,ks="La flexibilidad de <code>pipeline()</code> significa que también se puede extender a tareas de audio.",Ne,se,Js='Por ejemplo, clasifiquemos la emoción de un breve fragmento del famoso discurso de John F. Kennedy <a href="https://en.wikipedia.org/wiki/We_choose_to_go_to_the_Moon" rel="nofollow">“We choose to go to the Moon”</a>. Encuentra un modelo de <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">audio classification</a> para reconocimiento de emociones en el Model Hub y cárgalo en el <code>pipeline()</code>:',Ye,te,Fe,ae,Zs="Pasa el archivo de audio al <code>pipeline()</code>:",Qe,le,De,b,I,we,ne,ds,ge,Cs="Pipeline de visión",Ke,ie,Gs="Finalmente, utilizar un <code>pipeline()</code> para tareas de visión es prácticamente igual.",Oe,pe,Is="Específica tu tarea de visión y pasa tu imagen al clasificador. La imagen puede ser un enlace o una ruta local a la imagen. Por ejemplo, ¿qué especie de gato se muestra a continuación?",es,oe,Ws='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',ss,re,ts,xe,as;return _=new $e({}),k=new Qs({props:{$$slots:{default:[Ds]},$$scope:{ctx:Ue}}}),E=new $e({}),z=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),L=new v({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),P=new v({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`,wrap:!1}}),X=new v({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),A=new $e({}),Y=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)`,wrap:!1}}),Q=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),K=new v({props:{code:"Z2VuZXJhdG9yKCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(<span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),O=new $e({}),te=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),le=new v({props:{code:"YXVkaW9fY2xhc3NpZmllciglMjJqZmtfbW9vbl9zcGVlY2gud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier(<span class="hljs-string">&quot;jfk_moon_speech.wav&quot;</span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13856211304664612</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;disgust&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.13148026168346405</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12635163962841034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;angry&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12439591437578201</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.12404385954141617</span>}]`,wrap:!1}}),ne=new $e({}),re=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4403027892112732</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.03433405980467796</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>,
  <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.032148055732250214</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.02353910356760025</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.023034192621707916</span>}]`,wrap:!1}}),{c(){h=l("meta"),W=i(),j=l("p"),he=i(),w=l("h1"),T=l("a"),ye=l("span"),u(_.$$.fragment),os=i(),de=l("span"),de.textContent=us,be=i(),B=l("p"),B.innerHTML=ms,Te=i(),H=l("ul"),H.innerHTML=fs,ke=i(),u(k.$$.fragment),Je=i(),x=l("h2"),J=l("a"),Me=l("span"),u(E.$$.fragment),rs=i(),ue=l("span"),ue.textContent=gs,Ze=i(),V=l("p"),V.innerHTML=ys,Ce=i(),q=l("ol"),q.innerHTML=Ms,Ge=i(),u(z.$$.fragment),Ie=i(),Z=l("ol"),Z.innerHTML=js,We=i(),u(L.$$.fragment),_e=i(),R=l("p"),R.textContent=vs,Be=i(),u(P.$$.fragment),He=i(),S=l("p"),S.innerHTML=ws,Ee=i(),u(X.$$.fragment),Ve=i(),$=l("h3"),C=l("a"),je=l("span"),u(A.$$.fragment),cs=i(),me=l("span"),me.textContent=xs,qe=i(),N=l("p"),N.innerHTML=$s,ze=i(),u(Y.$$.fragment),Le=i(),F=l("p"),F.innerHTML=Us,Re=i(),u(Q.$$.fragment),Pe=i(),D=l("p"),D.innerHTML=bs,Se=i(),u(K.$$.fragment),Xe=i(),U=l("h2"),G=l("a"),ve=l("span"),u(O.$$.fragment),hs=i(),fe=l("span"),fe.textContent=Ts,Ae=i(),ee=l("p"),ee.innerHTML=ks,Ne=i(),se=l("p"),se.innerHTML=Js,Ye=i(),u(te.$$.fragment),Fe=i(),ae=l("p"),ae.innerHTML=Zs,Qe=i(),u(le.$$.fragment),De=i(),b=l("h2"),I=l("a"),we=l("span"),u(ne.$$.fragment),ds=i(),ge=l("span"),ge.textContent=Cs,Ke=i(),ie=l("p"),ie.innerHTML=Gs,Oe=i(),pe=l("p"),pe.textContent=Is,es=i(),oe=l("p"),oe.innerHTML=Ws,ss=i(),u(re.$$.fragment),ts=i(),xe=l("p"),this.h()},l(e){const t=Fs("svelte-1phssyn",document.head);h=n(t,"META",{name:!0,content:!0}),t.forEach(s),W=p(e),j=n(e,"P",{}),d(j).forEach(s),he=p(e),w=n(e,"H1",{class:!0});var ce=d(w);T=n(ce,"A",{id:!0,class:!0,href:!0});var _s=d(T);ye=n(_s,"SPAN",{});var Bs=d(ye);m(_.$$.fragment,Bs),Bs.forEach(s),_s.forEach(s),os=p(ce),de=n(ce,"SPAN",{"data-svelte-h":!0}),r(de)!=="svelte-oksvic"&&(de.textContent=us),ce.forEach(s),be=p(e),B=n(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1k5gyag"&&(B.innerHTML=ms),Te=p(e),H=n(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-7f1ymp"&&(H.innerHTML=fs),ke=p(e),m(k.$$.fragment,e),Je=p(e),x=n(e,"H2",{class:!0});var ls=d(x);J=n(ls,"A",{id:!0,class:!0,href:!0});var Hs=d(J);Me=n(Hs,"SPAN",{});var Es=d(Me);m(E.$$.fragment,Es),Es.forEach(s),Hs.forEach(s),rs=p(ls),ue=n(ls,"SPAN",{"data-svelte-h":!0}),r(ue)!=="svelte-1rqprbn"&&(ue.textContent=gs),ls.forEach(s),Ze=p(e),V=n(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-gjt1nl"&&(V.innerHTML=ys),Ce=p(e),q=n(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-yki1ef"&&(q.innerHTML=Ms),Ge=p(e),m(z.$$.fragment,e),Ie=p(e),Z=n(e,"OL",{start:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1e6diuh"&&(Z.innerHTML=js),We=p(e),m(L.$$.fragment,e),_e=p(e),R=n(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-wgq0wk"&&(R.textContent=vs),Be=p(e),m(P.$$.fragment,e),He=p(e),S=n(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-183jawq"&&(S.innerHTML=ws),Ee=p(e),m(X.$$.fragment,e),Ve=p(e),$=n(e,"H3",{class:!0});var ns=d($);C=n(ns,"A",{id:!0,class:!0,href:!0});var Vs=d(C);je=n(Vs,"SPAN",{});var qs=d(je);m(A.$$.fragment,qs),qs.forEach(s),Vs.forEach(s),cs=p(ns),me=n(ns,"SPAN",{"data-svelte-h":!0}),r(me)!=="svelte-2loqlm"&&(me.textContent=xs),ns.forEach(s),qe=p(e),N=n(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1sfnia5"&&(N.innerHTML=$s),ze=p(e),m(Y.$$.fragment,e),Le=p(e),F=n(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-15my78f"&&(F.innerHTML=Us),Re=p(e),m(Q.$$.fragment,e),Pe=p(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1qfapyh"&&(D.innerHTML=bs),Se=p(e),m(K.$$.fragment,e),Xe=p(e),U=n(e,"H2",{class:!0});var is=d(U);G=n(is,"A",{id:!0,class:!0,href:!0});var zs=d(G);ve=n(zs,"SPAN",{});var Ls=d(ve);m(O.$$.fragment,Ls),Ls.forEach(s),zs.forEach(s),hs=p(is),fe=n(is,"SPAN",{"data-svelte-h":!0}),r(fe)!=="svelte-ve5nm8"&&(fe.textContent=Ts),is.forEach(s),Ae=p(e),ee=n(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-q0unz9"&&(ee.innerHTML=ks),Ne=p(e),se=n(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-5ycnhq"&&(se.innerHTML=Js),Ye=p(e),m(te.$$.fragment,e),Fe=p(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1nrtv5e"&&(ae.innerHTML=Zs),Qe=p(e),m(le.$$.fragment,e),De=p(e),b=n(e,"H2",{class:!0});var ps=d(b);I=n(ps,"A",{id:!0,class:!0,href:!0});var Rs=d(I);we=n(Rs,"SPAN",{});var Ps=d(we);m(ne.$$.fragment,Ps),Ps.forEach(s),Rs.forEach(s),ds=p(ps),ge=n(ps,"SPAN",{"data-svelte-h":!0}),r(ge)!=="svelte-1azo6mg"&&(ge.textContent=Cs),ps.forEach(s),Ke=p(e),ie=n(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1na9ujt"&&(ie.innerHTML=Gs),Oe=p(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-j2gvop"&&(pe.textContent=Is),es=p(e),oe=n(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1bks2jw"&&(oe.innerHTML=Ws),ss=p(e),m(re.$$.fragment,e),ts=p(e),xe=n(e,"P",{}),d(xe).forEach(s),this.h()},h(){o(h,"name","hf:doc:metadata"),o(h,"content",JSON.stringify(Os)),o(T,"id","pipelines-para-inferencia"),o(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(T,"href","#pipelines-para-inferencia"),o(w,"class","relative group"),o(J,"id","uso-del-pipeline"),o(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(J,"href","#uso-del-pipeline"),o(x,"class","relative group"),o(Z,"start","2"),o(C,"id","selecciona-un-modelo-y-un-tokenizador"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#selecciona-un-modelo-y-un-tokenizador"),o($,"class","relative group"),o(G,"id","pipeline-de-audio"),o(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(G,"href","#pipeline-de-audio"),o(U,"class","relative group"),o(I,"id","pipeline-de-visin"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#pipeline-de-visin"),o(b,"class","relative group")},m(e,t){c(document.head,h),a(e,W,t),a(e,j,t),a(e,he,t),a(e,w,t),c(w,T),c(T,ye),f(_,ye,null),c(w,os),c(w,de),a(e,be,t),a(e,B,t),a(e,Te,t),a(e,H,t),a(e,ke,t),f(k,e,t),a(e,Je,t),a(e,x,t),c(x,J),c(J,Me),f(E,Me,null),c(x,rs),c(x,ue),a(e,Ze,t),a(e,V,t),a(e,Ce,t),a(e,q,t),a(e,Ge,t),f(z,e,t),a(e,Ie,t),a(e,Z,t),a(e,We,t),f(L,e,t),a(e,_e,t),a(e,R,t),a(e,Be,t),f(P,e,t),a(e,He,t),a(e,S,t),a(e,Ee,t),f(X,e,t),a(e,Ve,t),a(e,$,t),c($,C),c(C,je),f(A,je,null),c($,cs),c($,me),a(e,qe,t),a(e,N,t),a(e,ze,t),f(Y,e,t),a(e,Le,t),a(e,F,t),a(e,Re,t),f(Q,e,t),a(e,Pe,t),a(e,D,t),a(e,Se,t),f(K,e,t),a(e,Xe,t),a(e,U,t),c(U,G),c(G,ve),f(O,ve,null),c(U,hs),c(U,fe),a(e,Ae,t),a(e,ee,t),a(e,Ne,t),a(e,se,t),a(e,Ye,t),f(te,e,t),a(e,Fe,t),a(e,ae,t),a(e,Qe,t),f(le,e,t),a(e,De,t),a(e,b,t),c(b,I),c(I,we),f(ne,we,null),c(b,ds),c(b,ge),a(e,Ke,t),a(e,ie,t),a(e,Oe,t),a(e,pe,t),a(e,es,t),a(e,oe,t),a(e,ss,t),f(re,e,t),a(e,ts,t),a(e,xe,t),as=!0},p(e,[t]){const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),k.$set(ce)},i(e){as||(g(_.$$.fragment,e),g(k.$$.fragment,e),g(E.$$.fragment,e),g(z.$$.fragment,e),g(L.$$.fragment,e),g(P.$$.fragment,e),g(X.$$.fragment,e),g(A.$$.fragment,e),g(Y.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(ne.$$.fragment,e),g(re.$$.fragment,e),as=!0)},o(e){y(_.$$.fragment,e),y(k.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(L.$$.fragment,e),y(P.$$.fragment,e),y(X.$$.fragment,e),y(A.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),as=!1},d(e){e&&(s(W),s(j),s(he),s(w),s(be),s(B),s(Te),s(H),s(ke),s(Je),s(x),s(Ze),s(V),s(Ce),s(q),s(Ge),s(Ie),s(Z),s(We),s(_e),s(R),s(Be),s(He),s(S),s(Ee),s(Ve),s($),s(qe),s(N),s(ze),s(Le),s(F),s(Re),s(Pe),s(D),s(Se),s(Xe),s(U),s(Ae),s(ee),s(Ne),s(se),s(Ye),s(Fe),s(ae),s(Qe),s(De),s(b),s(Ke),s(ie),s(Oe),s(pe),s(es),s(oe),s(ss),s(ts),s(xe)),s(h),M(_),M(k,e),M(E),M(z,e),M(L,e),M(P,e),M(X,e),M(A),M(Y,e),M(Q,e),M(K,e),M(O),M(te,e),M(le,e),M(ne),M(re,e)}}}const Os={local:"pipelines-para-inferencia",sections:[{local:"uso-del-pipeline",sections:[{local:"selecciona-un-modelo-y-un-tokenizador",title:"Selecciona un modelo y un tokenizador"}],title:"Uso del pipeline"},{local:"pipeline-de-audio",title:"Pipeline de audio"},{local:"pipeline-de-visin",title:"Pipeline de visión"}],title:"Pipelines para inferencia"};function et(Ue){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Ns{constructor(h){super(),Ys(this,h,et,Ks,Ss,{})}}export{it as component};
