import{s as pl,n as il,o as rl}from"../chunks/scheduler.36a0863c.js";import{S as cl,i as dl,g as o,s as t,u as d,A as Ml,h as p,f as s,c as n,j as M,v as u,y as i,k as r,o as c,a,w as m,d as y,t as j,x as J}from"../chunks/index.d0f7a4c4.js";import{I as Js}from"../chunks/IconCopyLink.bc5fad79.js";import{C as w}from"../chunks/CodeBlock.4236768d.js";function ul(Us){let T,Ie,we,Ce,h,I,Te,v,ws,me,bs="¿Cómo puedo crear un pipeline personalizado?",_e,k,Is=`En esta guía, veremos cómo crear un pipeline personalizado y cómo compartirlo en el <a href="hf.co/models">Hub</a> o añadirlo
a la biblioteca 🤗 Transformers.`,Be,Z,Cs=`En primer lugar, debes decidir las entradas que tu pipeline podrá recibir. Pueden ser strings, bytes,
diccionarios o lo que te parezca que vaya a ser la entrada más apropiada. Intenta mantener estas entradas en un
formato que sea tan Python puro como sea posible, puesto que esto facilita la compatibilidad (incluso con otros
lenguajes de programación por medio de JSON). Estos serán los <code>inputs</code> (entradas) del pipeline (<code>preprocess</code>).`,ve,g,_s=`Ahora debes definir los <code>outputs</code> (salidas). Al igual que con los <code>inputs</code>, entre más simple el formato, mejor.
Estas serán las salidas del método <code>postprocess</code> (posprocesamiento).`,ke,q,Bs=`Empieza heredando la clase base <code>Pipeline</code> con los 4 métodos que debemos implementar: <code>preprocess</code> (preprocesamiento),
<code>_forward</code> (ejecución), <code>postprocess</code> (posprocesamiento) y <code>_sanitize_parameters</code> (verificar parámetros).`,Ze,A,ge,E,vs=`La estructura de este desglose es así para garantizar una compatibilidad más o menos transparente con el uso de
CPU/GPU y el pre/posprocesamiento en CPU en varios hilos.`,qe,H,ks=`<code>preprocess</code> tomará las entradas definidas originalmente y las convertirá en algo que se le pueda pasar al modelo.
Podría contener más información y a menudo es un objeto <code>Dict</code> (diccionario).`,Ae,W,Zs=`<code>_forward</code> contiene los detalles de la implementación y no debería ser invocado de forma directa. <code>forward</code> es el
método preferido a utilizar pues contiene verificaciones para asegurar que todo funcione en el dispositivo correcto.
Cualquier cosa que esté relacionada con un modelo real debería ir en el método <code>_forward</code>, todo lo demás va en
los métodos de preprocesamiento y posprocesamiento.`,Ee,V,gs=`Los métodos <code>postprocess</code> reciben la salida <code>_forward</code> y la convierten en la salida final que decidimos
anteriormente.`,He,R,qs=`<code>_sanitize_parameters</code> existe para permitir a los usuarios pasar cualesquiera parámetros cuando lo deseen, ya
sea al momento de inicializar el pipeline <code>pipeline(...., maybe_arg=4)</code> o al momento de invocarlo
<code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.`,We,G,As=`El método <code>_sanitize_parameters</code> devuelve 3 diccionarios de kwargs que serán pasados directamente a <code>preprocess</code>,
<code>_forward</code> y <code>postprocess</code>. No ingreses nada si el caller no se va a invocar con parámetros adicionales.
Esto permite mantener los parámetros por defecto de la definición de la función, lo que es más “natural”.`,Ve,N,Es="Un ejemplo clásico sería un argumento <code>top_k</code> en el posprocesamiento de una tarea de clasificación.",Re,z,Ge,x,Hs=`Para lograrlo, actualizaremos nuestro método <code>postprocess</code> con un valor por defecto de <code>5</code> y  modificaremos
<code>_sanitize_parameters</code> para permitir este nuevo parámetro.`,Ne,X,ze,$,Ws=`Intenta que las entradas y salidas sean muy simples e, idealmente, que puedan serializarse como JSON, pues esto
hace el uso del pipeline muy sencillo sin que el usuario tenga que preocuparse por conocer nuevos tipos de objetos.
También es relativamente común tener compatibilidad con muchos tipos diferentes de argumentos por facilidad de uso
(por ejemplo, los archivos de audio pueden ser nombres de archivo, URLs o bytes).`,xe,f,C,he,Y,Ts,ye,Vs="Añadirlo a la lista de tareas",Xe,F,Rs=`Para registrar tu <code>new-task</code> (nueva tarea) en la lista de tareas, debes añadirla al
<code>PIPELINE_REGISTRY</code> (registro de pipelines):`,$e,Q,Ye,S,Gs="Puedes especificar un modelo por defecto si lo deseas, en cuyo caso debe venir con una versión específica (que puede ser el nombre de un branch o hash de commit, en este caso usamos <code>&quot;abcdef&quot;</code>), así como el tipo:",Fe,P,Qe,U,_,fe,L,hs,je,Ns="Comparte tu pipeline en el Hub",Se,K,zs=`Para compartir tu pipeline personalizado en el Hub, solo tienes que guardar el código personalizado de tu sub-clase
<code>Pipeline</code> en un archivo de Python. Por ejemplo, digamos que queremos usar un pipeline personalizado para la
clasificación de duplas de oraciones de esta forma:`,Pe,D,Le,O,xs=`La implementación es independiente del framework y funcionará con modelos de PyTorch y TensorFlow. Si guardamos
esto en un archivo llamado <code>pair_classification.py</code>, podemos importarlo y registrarlo de la siguiente manera:`,Ke,ee,De,se,Xs=`Una vez hecho esto, podemos usarlo con un modelo pre-entrenado. Por ejemplo, al modelo <code>sgugger/finetuned-bert-mrpc</code>
se le hizo fine-tuning con el dataset MRPC, en el cual se clasifican duplas de oraciones como paráfrasis o no.`,Oe,le,es,ae,$s="Ahora podemos compartirlo en el Hub usando el método <code>save_pretrained</code> (guardar pre-entrenado) en un <code>Repository</code>:",ss,te,ls,ne,Ys=`Esto copiará el archivo donde definiste <code>PairClassificationPipeline</code> dentro de la carpeta <code>&quot;test-dynamic-pipeline&quot;</code>,
y además guardará el modelo y el tokenizer del pipeline, antes de enviar todo al repositorio
<code>{your_username}/test-dynamic-pipeline</code>. Después de esto, cualquier persona puede usarlo siempre que usen la opción
<code>trust_remote_code=True</code> (confiar en código remoto):`,as,oe,ts,b,B,Ue,pe,fs,Je,Fs="Añadir el pipeline a 🤗 Transformers",ns,ie,Qs=`Si quieres contribuir tu pipeline a la biblioteca 🤗 Transformers, tendrás que añadirlo a un nuevo módulo en el
sub-módulo <code>pipelines</code> con el código de tu pipeline. Luego, debes añadirlo a la lista de tareas definidas en
<code>pipelines/__init__.py</code>.`,os,re,Ss=`A continuación tienes que añadir las pruebas. Crea un nuevo archivo llamado <code>tests/test_pipelines_MY_PIPELINE.py</code>
basándote en las pruebas existentes.`,ps,ce,Ps=`La función <code>run_pipeline_test</code> será muy genérica y se correrá sobre modelos pequeños escogidos al azar sobre todas las
arquitecturas posibles definidas en <code>model_mapping</code> y <code>tf_model_mapping</code>.`,is,de,Ls=`Esto es muy importante para probar compatibilidades a futuro, lo que significa que si alguien añade un nuevo modelo
para <code>XXXForQuestionAnswering</code> entonces el pipeline intentará ejecutarse con ese modelo. Ya que los modelos son aleatorios,
es imposible verificar los valores como tales, y es por eso que hay un helper <code>ANY</code> que simplemente intentará que la
salida tenga el mismo tipo que la salida esperada del pipeline.`,rs,Me,Ks="También <em>debes</em> implementar 2 (preferiblemente 4) pruebas:",cs,ue,Ds=`<li><code>test_small_model_pt</code> : Define un (1) modelo pequeño para este pipeline (no importa si los resultados no tienen sentido)
y prueba las salidas del pipeline. Los resultados deberían ser los mismos que en <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Define un (1) modelo pequeño para este pipeline (no importa si los resultados no tienen sentido)
y prueba las salidas del pipeline. Los resultados deberían ser los mismos que en <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Prueba el pipeline en una tarea real en la que los resultados deben tener sentido.
Estas pruebas son lentas y deben marcarse como tales. El objetivo de esto es ejemplificar el pipeline y asegurarse de que
no haya divergencias en versiones futuras.</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Prueba el pipeline en una tarea real en la que los resultados deben tener sentido.
Estas pruebas son lentas y deben marcarse como tales. El objetivo de esto es ejemplificar el pipeline y asegurarse de que
no haya divergencias en versiones futuras.</li>`,ds,be,Ms;return v=new Js({}),A=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFF1aXolQzMlQTElMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBUZW5zb3IoLi4uKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHMlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBwb3N0cHJvY2VzcyhzZWxmJTJDJTIwbW9kZWxfb3V0cHV0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X2NsYXNzJTIwJTNEJTIwbW9kZWxfb3V0cHV0cyU1QiUyMmxvZ2l0cyUyMiU1RC5zb2Z0bWF4KC0xKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGJlc3RfY2xhc3M=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Quizá {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),z=new w({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),X=new w({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBJUMzJUIxYWRlJTIwbGElMjBsJUMzJUIzZ2ljYSUyMHBhcmElMjBtYW5lamFyJTIwZWwlMjB0b3BfayUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJlc3RfY2xhc3MlMEElMEElMEFkZWYlMjBfc2FuaXRpemVfcGFyYW1ldGVycyhzZWxmJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMCUyMm1heWJlX2FyZyUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlNUIlMjJtYXliZV9hcmclMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJtYXliZV9hcmclMjIlNUQlMEElMEElMjAlMjAlMjAlMjBwb3N0cHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMCUyMnRvcF9rJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb3N0cHJvY2Vzc19rd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMnRvcF9rJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMkMlMjAlN0IlN0QlMkMlMjBwb3N0cHJvY2Vzc19rd2FyZ3M=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Añade la lógica para manejar el top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),Y=new Js({}),Q=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),P=new w({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjB0aXBvJTIwZGUlMjBkYXRvcyUyMHF1ZSUyMG1hbmVqYSUzQSUyMHRleHRvJTJDJTIwYXVkaW8lMkMlMjBpbWFnZW4lMkMlMjBtdWx0aS1tb2RhbGlkYWQlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># tipo de datos que maneja: texto, audio, imagen, multi-modalidad</span>
)`,wrap:!1}}),L=new Js({}),D=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),ee=new w({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),le=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),te=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),oe=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new Js({}),{c(){T=o("meta"),Ie=t(),we=o("p"),Ce=t(),h=o("h1"),I=o("a"),Te=o("span"),d(v.$$.fragment),ws=t(),me=o("span"),me.textContent=bs,_e=t(),k=o("p"),k.innerHTML=Is,Be=t(),Z=o("p"),Z.innerHTML=Cs,ve=t(),g=o("p"),g.innerHTML=_s,ke=t(),q=o("p"),q.innerHTML=Bs,Ze=t(),d(A.$$.fragment),ge=t(),E=o("p"),E.textContent=vs,qe=t(),H=o("p"),H.innerHTML=ks,Ae=t(),W=o("p"),W.innerHTML=Zs,Ee=t(),V=o("p"),V.innerHTML=gs,He=t(),R=o("p"),R.innerHTML=qs,We=t(),G=o("p"),G.innerHTML=As,Ve=t(),N=o("p"),N.innerHTML=Es,Re=t(),d(z.$$.fragment),Ge=t(),x=o("p"),x.innerHTML=Hs,Ne=t(),d(X.$$.fragment),ze=t(),$=o("p"),$.textContent=Ws,xe=t(),f=o("h2"),C=o("a"),he=o("span"),d(Y.$$.fragment),Ts=t(),ye=o("span"),ye.textContent=Vs,Xe=t(),F=o("p"),F.innerHTML=Rs,$e=t(),d(Q.$$.fragment),Ye=t(),S=o("p"),S.innerHTML=Gs,Fe=t(),d(P.$$.fragment),Qe=t(),U=o("h2"),_=o("a"),fe=o("span"),d(L.$$.fragment),hs=t(),je=o("span"),je.textContent=Ns,Se=t(),K=o("p"),K.innerHTML=zs,Pe=t(),d(D.$$.fragment),Le=t(),O=o("p"),O.innerHTML=xs,Ke=t(),d(ee.$$.fragment),De=t(),se=o("p"),se.innerHTML=Xs,Oe=t(),d(le.$$.fragment),es=t(),ae=o("p"),ae.innerHTML=$s,ss=t(),d(te.$$.fragment),ls=t(),ne=o("p"),ne.innerHTML=Ys,as=t(),d(oe.$$.fragment),ts=t(),b=o("h2"),B=o("a"),Ue=o("span"),d(pe.$$.fragment),fs=t(),Je=o("span"),Je.textContent=Fs,ns=t(),ie=o("p"),ie.innerHTML=Qs,os=t(),re=o("p"),re.innerHTML=Ss,ps=t(),ce=o("p"),ce.innerHTML=Ps,is=t(),de=o("p"),de.innerHTML=Ls,rs=t(),Me=o("p"),Me.innerHTML=Ks,cs=t(),ue=o("ul"),ue.innerHTML=Ds,ds=t(),be=o("p"),this.h()},l(e){const l=Ml("svelte-1phssyn",document.head);T=p(l,"META",{name:!0,content:!0}),l.forEach(s),Ie=n(e),we=p(e,"P",{}),M(we).forEach(s),Ce=n(e),h=p(e,"H1",{class:!0});var us=M(h);I=p(us,"A",{id:!0,class:!0,href:!0});var Os=M(I);Te=p(Os,"SPAN",{});var el=M(Te);u(v.$$.fragment,el),el.forEach(s),Os.forEach(s),ws=n(us),me=p(us,"SPAN",{"data-svelte-h":!0}),i(me)!=="svelte-1gtobbp"&&(me.textContent=bs),us.forEach(s),_e=n(e),k=p(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1xjd717"&&(k.innerHTML=Is),Be=n(e),Z=p(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-9hudq2"&&(Z.innerHTML=Cs),ve=n(e),g=p(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1nte1oa"&&(g.innerHTML=_s),ke=n(e),q=p(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-sxwk05"&&(q.innerHTML=Bs),Ze=n(e),u(A.$$.fragment,e),ge=n(e),E=p(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1drpjjm"&&(E.textContent=vs),qe=n(e),H=p(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-ou03bc"&&(H.innerHTML=ks),Ae=n(e),W=p(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1p7c6jy"&&(W.innerHTML=Zs),Ee=n(e),V=p(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-3im4jr"&&(V.innerHTML=gs),He=n(e),R=p(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1n3nzkq"&&(R.innerHTML=qs),We=n(e),G=p(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-hjl9w0"&&(G.innerHTML=As),Ve=n(e),N=p(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-hbriii"&&(N.innerHTML=Es),Re=n(e),u(z.$$.fragment,e),Ge=n(e),x=p(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1q1g6rb"&&(x.innerHTML=Hs),Ne=n(e),u(X.$$.fragment,e),ze=n(e),$=p(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-1r0c6lg"&&($.textContent=Ws),xe=n(e),f=p(e,"H2",{class:!0});var ms=M(f);C=p(ms,"A",{id:!0,class:!0,href:!0});var sl=M(C);he=p(sl,"SPAN",{});var ll=M(he);u(Y.$$.fragment,ll),ll.forEach(s),sl.forEach(s),Ts=n(ms),ye=p(ms,"SPAN",{"data-svelte-h":!0}),i(ye)!=="svelte-7opca6"&&(ye.textContent=Vs),ms.forEach(s),Xe=n(e),F=p(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-z7p84k"&&(F.innerHTML=Rs),$e=n(e),u(Q.$$.fragment,e),Ye=n(e),S=p(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-v4vfe7"&&(S.innerHTML=Gs),Fe=n(e),u(P.$$.fragment,e),Qe=n(e),U=p(e,"H2",{class:!0});var ys=M(U);_=p(ys,"A",{id:!0,class:!0,href:!0});var al=M(_);fe=p(al,"SPAN",{});var tl=M(fe);u(L.$$.fragment,tl),tl.forEach(s),al.forEach(s),hs=n(ys),je=p(ys,"SPAN",{"data-svelte-h":!0}),i(je)!=="svelte-15mn0j8"&&(je.textContent=Ns),ys.forEach(s),Se=n(e),K=p(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1x3dswg"&&(K.innerHTML=zs),Pe=n(e),u(D.$$.fragment,e),Le=n(e),O=p(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-664ykw"&&(O.innerHTML=xs),Ke=n(e),u(ee.$$.fragment,e),De=n(e),se=p(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1cbx8mt"&&(se.innerHTML=Xs),Oe=n(e),u(le.$$.fragment,e),es=n(e),ae=p(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-14ugv3p"&&(ae.innerHTML=$s),ss=n(e),u(te.$$.fragment,e),ls=n(e),ne=p(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-iz3f4"&&(ne.innerHTML=Ys),as=n(e),u(oe.$$.fragment,e),ts=n(e),b=p(e,"H2",{class:!0});var js=M(b);B=p(js,"A",{id:!0,class:!0,href:!0});var nl=M(B);Ue=p(nl,"SPAN",{});var ol=M(Ue);u(pe.$$.fragment,ol),ol.forEach(s),nl.forEach(s),fs=n(js),Je=p(js,"SPAN",{"data-svelte-h":!0}),i(Je)!=="svelte-1mjqd88"&&(Je.textContent=Fs),js.forEach(s),ns=n(e),ie=p(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1yvleqa"&&(ie.innerHTML=Qs),os=n(e),re=p(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1ywpgxj"&&(re.innerHTML=Ss),ps=n(e),ce=p(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-10dn6d8"&&(ce.innerHTML=Ps),is=n(e),de=p(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-1fz3esc"&&(de.innerHTML=Ls),rs=n(e),Me=p(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1ssmkmu"&&(Me.innerHTML=Ks),cs=n(e),ue=p(e,"UL",{"data-svelte-h":!0}),i(ue)!=="svelte-15dsdoq"&&(ue.innerHTML=Ds),ds=n(e),be=p(e,"P",{}),M(be).forEach(s),this.h()},h(){r(T,"name","hf:doc:metadata"),r(T,"content",JSON.stringify(ml)),r(I,"id","cmo-puedo-crear-un-pipeline-personalizado"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#cmo-puedo-crear-un-pipeline-personalizado"),r(h,"class","relative group"),r(C,"id","aadirlo-a-la-lista-de-tareas"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#aadirlo-a-la-lista-de-tareas"),r(f,"class","relative group"),r(_,"id","comparte-tu-pipeline-en-el-hub"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#comparte-tu-pipeline-en-el-hub"),r(U,"class","relative group"),r(B,"id","aadir-el-pipeline-a-transformers"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#aadir-el-pipeline-a-transformers"),r(b,"class","relative group")},m(e,l){c(document.head,T),a(e,Ie,l),a(e,we,l),a(e,Ce,l),a(e,h,l),c(h,I),c(I,Te),m(v,Te,null),c(h,ws),c(h,me),a(e,_e,l),a(e,k,l),a(e,Be,l),a(e,Z,l),a(e,ve,l),a(e,g,l),a(e,ke,l),a(e,q,l),a(e,Ze,l),m(A,e,l),a(e,ge,l),a(e,E,l),a(e,qe,l),a(e,H,l),a(e,Ae,l),a(e,W,l),a(e,Ee,l),a(e,V,l),a(e,He,l),a(e,R,l),a(e,We,l),a(e,G,l),a(e,Ve,l),a(e,N,l),a(e,Re,l),m(z,e,l),a(e,Ge,l),a(e,x,l),a(e,Ne,l),m(X,e,l),a(e,ze,l),a(e,$,l),a(e,xe,l),a(e,f,l),c(f,C),c(C,he),m(Y,he,null),c(f,Ts),c(f,ye),a(e,Xe,l),a(e,F,l),a(e,$e,l),m(Q,e,l),a(e,Ye,l),a(e,S,l),a(e,Fe,l),m(P,e,l),a(e,Qe,l),a(e,U,l),c(U,_),c(_,fe),m(L,fe,null),c(U,hs),c(U,je),a(e,Se,l),a(e,K,l),a(e,Pe,l),m(D,e,l),a(e,Le,l),a(e,O,l),a(e,Ke,l),m(ee,e,l),a(e,De,l),a(e,se,l),a(e,Oe,l),m(le,e,l),a(e,es,l),a(e,ae,l),a(e,ss,l),m(te,e,l),a(e,ls,l),a(e,ne,l),a(e,as,l),m(oe,e,l),a(e,ts,l),a(e,b,l),c(b,B),c(B,Ue),m(pe,Ue,null),c(b,fs),c(b,Je),a(e,ns,l),a(e,ie,l),a(e,os,l),a(e,re,l),a(e,ps,l),a(e,ce,l),a(e,is,l),a(e,de,l),a(e,rs,l),a(e,Me,l),a(e,cs,l),a(e,ue,l),a(e,ds,l),a(e,be,l),Ms=!0},p:il,i(e){Ms||(y(v.$$.fragment,e),y(A.$$.fragment,e),y(z.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(P.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),Ms=!0)},o(e){j(v.$$.fragment,e),j(A.$$.fragment,e),j(z.$$.fragment,e),j(X.$$.fragment,e),j(Y.$$.fragment,e),j(Q.$$.fragment,e),j(P.$$.fragment,e),j(L.$$.fragment,e),j(D.$$.fragment,e),j(ee.$$.fragment,e),j(le.$$.fragment,e),j(te.$$.fragment,e),j(oe.$$.fragment,e),j(pe.$$.fragment,e),Ms=!1},d(e){e&&(s(Ie),s(we),s(Ce),s(h),s(_e),s(k),s(Be),s(Z),s(ve),s(g),s(ke),s(q),s(Ze),s(ge),s(E),s(qe),s(H),s(Ae),s(W),s(Ee),s(V),s(He),s(R),s(We),s(G),s(Ve),s(N),s(Re),s(Ge),s(x),s(Ne),s(ze),s($),s(xe),s(f),s(Xe),s(F),s($e),s(Ye),s(S),s(Fe),s(Qe),s(U),s(Se),s(K),s(Pe),s(Le),s(O),s(Ke),s(De),s(se),s(Oe),s(es),s(ae),s(ss),s(ls),s(ne),s(as),s(ts),s(b),s(ns),s(ie),s(os),s(re),s(ps),s(ce),s(is),s(de),s(rs),s(Me),s(cs),s(ue),s(ds),s(be)),s(T),J(v),J(A,e),J(z,e),J(X,e),J(Y),J(Q,e),J(P,e),J(L),J(D,e),J(ee,e),J(le,e),J(te,e),J(oe,e),J(pe)}}}const ml={local:"cmo-puedo-crear-un-pipeline-personalizado",sections:[{local:"aadirlo-a-la-lista-de-tareas",title:"Añadirlo a la lista de tareas"},{local:"comparte-tu-pipeline-en-el-hub",title:"Comparte tu pipeline en el Hub"},{local:"aadir-el-pipeline-a-transformers",title:"Añadir el pipeline a 🤗 Transformers"}],title:"¿Cómo puedo crear un pipeline personalizado?"};function yl(Us){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends cl{constructor(T){super(),dl(this,T,yl,ul,pl,{})}}export{hl as component};
