import{s as $s,o as ks,n as Zt}from"../chunks/scheduler.36a0863c.js";import{S as Ns,i as Bs,g as n,s as a,u as p,m as Zs,A as Rs,h as o,f as t,c as i,j as T,v as d,y as r,n as As,k as M,o as w,a as s,w as m,d as u,t as y,x as f}from"../chunks/index.d0f7a4c4.js";import{T as zt}from"../chunks/Tip.4c7d7eb1.js";import{I as Ke}from"../chunks/IconCopyLink.bc5fad79.js";import{C as j}from"../chunks/CodeBlock.4236768d.js";function Ws(z){let c,U="Se il tuo modello è molto simile a un modello all’interno della libreria, puoi ri-usare la stessa configurazione di quel modello.";return{c(){c=n("p"),c.textContent=U},l(J){c=o(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1j1jq3y"&&(c.textContent=U)},m(J,b){s(J,c,b)},p:Zt,d(J){J&&t(c)}}}function Xs(z){let c,U="Questa API è sperimentale e potrebbe avere alcuni cambiamenti nei prossimi rilasci.";return{c(){c=n("p"),c.textContent=U},l(J){c=o(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1dfgrpm"&&(c.textContent=U)},m(J,b){s(J,c,b)},p:Zt,d(J){J&&t(c)}}}function xs(z){let c,U=`Se stai copiando i file relativi alla modellazione della libreria, dovrai sostituire tutti gli import relativi in cima al file con import del
pacchetto <code>transformers</code>.`;return{c(){c=n("p"),c.innerHTML=U},l(J){c=o(J,"P",{"data-svelte-h":!0}),r(c)!=="svelte-ek1fx"&&(c.innerHTML=U)},m(J,b){s(J,c,b)},p:Zt,d(J){J&&t(c)}}}function Es(z){let c,U,J,b,h,Z,Oe,x,ht,Fe,At="Condividere modelli personalizzati",rl,E,$t=`Se stai scrivendo un nuovo modello, potrebbe essere più semplice iniziare da zero. In questo tutorial, ti mostreremo
come scrivere un modello personalizzato e la sua configurazione in modo che possa essere utilizzato all’interno di
Transformers, e come condividerlo con la community (assieme al relativo codice) così che tutte le persone possano usarlo, anche
se non presente nella libreria 🤗 Transformers.`,cl,G,kt=`Illustriamo tutto questo su un modello ResNet, avvolgendo la classe ResNet della
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">libreria timm</a> in un <code>PreTrainedModel</code>.`,pl,C,A,el,V,Ct,qe,Nt="Scrivere una configurazione personalizzata",dl,Q,Bt=`Nel nostro esempio, prenderemo un paio di argomenti della classe ResNet che potremmo voler modificare.
Configurazioni differenti ci daranno quindi i differenti possibili tipi di ResNet. Salveremo poi questi argomenti,
dopo averne controllato la validità.`,Ml,Y,ml,H,Rt="Le tre cose più importanti da ricordare quando scrivi le tue configurazioni sono le seguenti:",ul,F,Wt="<li>Devi ereditare da <code>Pretrainedconfig</code>,</li> <li>Il metodo <code>__init__</code> del tuo <code>Pretrainedconfig</code> deve accettare i kwargs,</li> <li>I <code>kwargs</code> devono essere passati alla superclass <code>__init__</code></li>",yl,q,Xt=`L’eredità è importante per assicurarsi di ottenere tutte le funzionalità della libreria 🤗 transformers,
mentre gli altri due vincoli derivano dal fatto che un <code>Pretrainedconfig</code> ha più campi di quelli che stai settando.
Quando ricarichi una config da un metodo <code>from_pretrained</code>, questi campi devono essere accettati dalla tua config e
poi inviati alla superclasse.`,fl,S,xt=`Definire un <code>model_type</code> per la tua configurazione (qua <code>model_type = “resnet”</code>) non è obbligatorio, a meno che tu
non voglia registrare il modello con le classi Auto (vedi l’ultima sezione).`,wl,P,Et=`Una volta completato, puoi facilmente creare e salvare la tua configurazione come faresti con ogni altra configurazione
di modelli della libreria. Ecco come possiamo creare la config di un resnet50d e salvarlo:`,Jl,L,Tl,D,Gt=`Questo salverà un file chiamato <code>config.json</code> all’interno della cartella <code>custom-resnet</code>. Potrai poi ricaricare la tua
config con il metodo <code>from_pretrained</code>.`,jl,K,Ul,O,Vt=`Puoi anche usare qualunque altro metodo della classe <code>PretrainedConfig</code>, come <code>push_to_hub()</code>
per caricare direttamente la tua configurazione nell’hub.`,bl,v,$,ll,ee,vt,Se,Qt="Scrivere un modello personalizzato",hl,le,Yt=`Ora che abbiamo la nostra configurazione ResNet, possiamo continuare a scrivere il modello. In realtà, ne scriveremo
due: uno che estrae le features nascoste da una batch di immagini (come <code>BertModel</code>) e uno che è utilizzabile per
la classificazione di immagini (come <code>BertModelForSequenceClassification</code>).`,Cl,te,Ht=`Come abbiamo menzionato in precedenza, scriveremo soltanto un wrapper del modello, per mantenerlo semplice ai fini di
questo esempio. L’unica cosa che dobbiamo fare prima di scrivere questa classe è una mappatura fra i tipi di blocco e
le vere classi dei blocchi. Successivamente il modello è definito tramite la configurazione, passando tutto quanto alla
classe <code>ResNet</code>.`,vl,se,Il,ae,Ft="Per il modello che classificherà le immagini, cambiamo soltanto il metodo forward:",gl,ie,_l,ne,qt=`Nota come, in entrambi i casi, ereditiamo da <code>PreTrainedModel</code> e chiamiamo l’inizializzazione della superclasse
con il metodo <code>config</code> (un po’ come quando scrivi un normale <code>torch.nn.Module</code>). La riga che imposta la  <code>config_class</code>
non è obbligatoria, a meno che tu non voglia registrare il modello con le classi Auto (vedi l’ultima sezione).`,zl,k,Zl,oe,St=`Puoi fare in modo che il tuo modello restituisca in output qualunque cosa tu voglia, ma far restituire un dizionario
come abbiamo fatto per <code>ResnetModelForImageClassification</code>, con la funzione di perdita inclusa quando vengono passate le labels,
renderà il tuo modello direttamente utilizzabile all’interno della classe <code>Trainer</code>. Utilizzare altri formati di output va bene
se hai in progetto di utilizzare un tuo loop di allenamento, o se utilizzerai un’altra libreria per l’addestramento.`,Al,re,Pt="Ora che abbiamo la classe del nostro modello, creiamone uno:",$l,ce,kl,pe,Lt=`Ribadiamo, puoi usare qualunque metodo dei <code>PreTrainedModel</code>, come <code>save_pretrained()</code> o
<code>push_to_hub()</code>. Utilizzeremo quest’ultimo nella prossima sezione, e vedremo come caricare i pesi del
modello assieme al codice del modello stesso. Ma prima, carichiamo alcuni pesi pre-allenati all’interno del nostro modello.`,Nl,de,Dt=`Nel tuo caso specifico, probabilmente allenerai il tuo modello sui tuoi dati. Per velocizzare in questo tutorial,
utilizzeremo la versione pre-allenata del resnet50d. Dato che il nostro modello è soltanto un wrapper attorno a quel modello,
sarà facile trasferirne i pesi:`,Bl,Me,Rl,me,Kt=`Vediamo adesso come assicurarci che quando facciamo <code>save_pretrained()</code> o <code>push_to_hub()</code>,
il codice del modello venga salvato.`,Wl,I,N,tl,ue,It,Pe,Ot="Inviare il codice all'Hub",Xl,B,xl,ye,es=`Innanzitutto, assicurati che il tuo modello sia completamente definito in un file <code>.py</code>. Può sfruttare import relativi
ad altri file, purchè questi siano nella stessa directory (non supportiamo ancora sotto-moduli per questa funzionalità).
Per questo esempio, definiremo un file <code>modeling_resnet.py</code> e un file <code>configuration_resnet.py</code> in una cartella dell’attuale
working directory chiamata <code>resnet_model</code>. Il file configuration contiene il codice per <code>ResnetConfig</code> e il file modeling
contiene il codice di <code>ResnetModel</code> e <code>ResnetModelForImageClassification</code>.`,El,fe,Gl,we,ls="Il file <code>__init__.py</code> può essere vuoto, serve solo perchè Python capisca che <code>resnet_model</code> può essere utilizzato come un modulo.",Vl,R,Ql,Je,ts="Nota che puoi ri-utilizzare (o usare come sottoclassi) un modello/configurazione esistente.",Yl,Te,ss=`Per condividere il tuo modello con la community, segui questi passi: prima importa il modello ResNet e la sua configurazione
dai nuovi file creati:`,Hl,je,Fl,Ue,as=`Dopodichè dovrai dire alla libreria che vuoi copiare i file con il codice di quegli oggetti quando utilizzi il metodo
<code>save_pretrained</code> e registrarli in modo corretto con una Auto classe (specialmente per i modelli). Utilizza semplicemente:`,ql,be,Sl,he,is=`Nota che non c’è bisogno di specificare una Auto classe per la configurazione (c’è solo una Auto classe per le configurazioni,
<code>AutoConfig</code>, ma è diversa per i modelli). Il tuo modello personalizato potrebbe essere utilizzato per diverse tasks,
per cui devi specificare quale delle classi Auto è quella corretta per il tuo modello.`,Pl,Ce,ns="Successivamente, creiamo i modelli e la config come abbiamo fatto in precedenza:",Ll,ve,Dl,Ie,os="Adesso, per inviare il modello all’Hub, assicurati di aver effettuato l’accesso. Lancia dal tuo terminale:",Kl,ge,Ol,_e,rs="O da un notebook:",et,ze,lt,Ze,cs="Potrai poi inviare il tutto sul tuo profilo (o di un’organizzazione di cui fai parte) in questo modo:",tt,Ae,st,$e,ps=`Oltre ai pesi del modello e alla configurazione in formato json, questo ha anche copiato i file <code>.py</code> modeling e
configuration all’interno della cartella <code>custom-resnet50d</code> e ha caricato i risultati sull’Hub. Puoi controllare
i risultati in questa <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.`,at,ke,ds=`Puoi controllare il tutorial di condivisione <a href="model_sharing">tutorial di condivisione</a> per più informazioni sul
metodo con cui inviare all’Hub.`,it,g,W,sl,Ne,gt,Le,Ms="Usare un modello con codice personalizzato",nt,Be,ms=`Puoi usare ogni configurazione, modello o tokenizer con file di codice personalizzati nella sua repository
con le classi Auto e il metodo <code>from_pretrained</code>. Tutti i files e il codice caricati sull’Hub sono scansionati da malware
(fai riferimento alla documentazione <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub security</a> per più informazioni),
ma dovresti comunque assicurarti dell’affidabilità del codice e dell’autore per evitare di eseguire codice dannoso sulla tua macchina.
Imposta <code>trust_remote_code=True</code> per usare un modello con codice personalizzato:`,ot,Re,rt,We,us=`Inoltre, raccomandiamo fortemente di passare un hash del commit come <code>revision</code> per assicurarti che le autrici o gli autori del modello
non abbiano modificato il codice con alcune nuove righe dannose (a meno che non ti fidi completamente della fonte):`,ct,Xe,pt,xe,ys=`Nota che quando cerchi la storia dei commit della repo del modello sull’Hub, c’è un bottone con cui facilmente copiare il
commit hash di ciascun commit.`,dt,_,X,al,Ee,_t,De,fs="Registrare un modello con codice personalizzato nelle classi Auto",Mt,Ge,ws=`Se stai scrivendo una libreria che estende 🤗 Transformers, potresti voler estendere le classi Auto per includere il tuo modello.
Questo è diverso dall’inviare codice nell’Hub: gli utenti dovranno importare la tua libreria per ottenere il modello personalizzato
(anzichè scaricare automaticamente il modello dall’Hub).`,mt,Ve,Js=`Finchè il tuo file di configurazione ha un attributo <code>model_type</code> diverso dai model types esistenti, e finchè le tue
classi modello hanno i corretti attributi <code>config_class</code>, potrai semplicemente aggiungerli alle classi Auto come segue:`,ut,Qe,yt,Ye,Ts=`Nota che il primo argomento utilizzato quando registri la configurazione di un modello personalizzato con <code>AutoConfig</code>
deve corrispondere al <code>model_type</code> della tua configurazione personalizzata, ed il primo argomento utilizzato quando
registri i tuoi modelli personalizzati in una qualunque classe Auto del modello deve corrispondere alla <code>config_class</code>
di quei modelli.`,ft,il,wt;return x=new Ke({}),V=new Ke({}),Y=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),L=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),K=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),ee=new Ke({}),se=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),ie=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),k=new zt({props:{$$slots:{default:[Ws]},$$scope:{ctx:z}}}),ce=new j({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),Me=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ue=new Ke({}),B=new zt({props:{warning:!0,$$slots:{default:[Xs]},$$scope:{ctx:z}}}),fe=new j({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),R=new zt({props:{warning:!0,$$slots:{default:[xs]},$$scope:{ctx:z}}}),je=new j({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),be=new j({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),ve=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ge=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),ze=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ae=new j({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Ne=new Ke({}),Re=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Xe=new j({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ee=new Ke({}),Qe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){c=n("meta"),U=a(),J=n("p"),b=a(),h=n("h1"),Z=n("a"),Oe=n("span"),p(x.$$.fragment),ht=a(),Fe=n("span"),Fe.textContent=At,rl=Zs(`


La libreria 🤗 Transformers è studiata per essere facilmente estendibile. Il codice di ogni modello è interamente 
situato in una sottocartella del repository senza alcuna astrazione, perciò puoi facilmente copiare il file di un 
modello e modificarlo in base ai tuoi bisogni.
`),E=n("p"),E.textContent=$t,cl=a(),G=n("p"),G.innerHTML=kt,pl=a(),C=n("h2"),A=n("a"),el=n("span"),p(V.$$.fragment),Ct=a(),qe=n("span"),qe.textContent=Nt,dl=Zs(`


Prima di iniziare a lavorare al modello, scriviamone la configurazione. La configurazione di un modello è un oggetto
che contiene tutte le informazioni necessarie per la build del modello. Come vedremo nella prossima sezione, il 
modello può soltanto essere inizializzato tramite \`config\`, per cui dovremo rendere tale oggetto più completo possibile.
`),Q=n("p"),Q.textContent=Bt,Ml=a(),p(Y.$$.fragment),ml=a(),H=n("p"),H.textContent=Rt,ul=a(),F=n("ul"),F.innerHTML=Wt,yl=a(),q=n("p"),q.innerHTML=Xt,fl=a(),S=n("p"),S.innerHTML=xt,wl=a(),P=n("p"),P.textContent=Et,Jl=a(),p(L.$$.fragment),Tl=a(),D=n("p"),D.innerHTML=Gt,jl=a(),p(K.$$.fragment),Ul=a(),O=n("p"),O.innerHTML=Vt,bl=a(),v=n("h2"),$=n("a"),ll=n("span"),p(ee.$$.fragment),vt=a(),Se=n("span"),Se.textContent=Qt,hl=a(),le=n("p"),le.innerHTML=Yt,Cl=a(),te=n("p"),te.innerHTML=Ht,vl=a(),p(se.$$.fragment),Il=a(),ae=n("p"),ae.textContent=Ft,gl=a(),p(ie.$$.fragment),_l=a(),ne=n("p"),ne.innerHTML=qt,zl=a(),p(k.$$.fragment),Zl=a(),oe=n("p"),oe.innerHTML=St,Al=a(),re=n("p"),re.textContent=Pt,$l=a(),p(ce.$$.fragment),kl=a(),pe=n("p"),pe.innerHTML=Lt,Nl=a(),de=n("p"),de.textContent=Dt,Bl=a(),p(Me.$$.fragment),Rl=a(),me=n("p"),me.innerHTML=Kt,Wl=a(),I=n("h2"),N=n("a"),tl=n("span"),p(ue.$$.fragment),It=a(),Pe=n("span"),Pe.textContent=Ot,Xl=a(),p(B.$$.fragment),xl=a(),ye=n("p"),ye.innerHTML=es,El=a(),p(fe.$$.fragment),Gl=a(),we=n("p"),we.innerHTML=ls,Vl=a(),p(R.$$.fragment),Ql=a(),Je=n("p"),Je.textContent=ts,Yl=a(),Te=n("p"),Te.textContent=ss,Hl=a(),p(je.$$.fragment),Fl=a(),Ue=n("p"),Ue.innerHTML=as,ql=a(),p(be.$$.fragment),Sl=a(),he=n("p"),he.innerHTML=is,Pl=a(),Ce=n("p"),Ce.textContent=ns,Ll=a(),p(ve.$$.fragment),Dl=a(),Ie=n("p"),Ie.textContent=os,Kl=a(),p(ge.$$.fragment),Ol=a(),_e=n("p"),_e.textContent=rs,et=a(),p(ze.$$.fragment),lt=a(),Ze=n("p"),Ze.textContent=cs,tt=a(),p(Ae.$$.fragment),st=a(),$e=n("p"),$e.innerHTML=ps,at=a(),ke=n("p"),ke.innerHTML=ds,it=a(),g=n("h2"),W=n("a"),sl=n("span"),p(Ne.$$.fragment),gt=a(),Le=n("span"),Le.textContent=Ms,nt=a(),Be=n("p"),Be.innerHTML=ms,ot=a(),p(Re.$$.fragment),rt=a(),We=n("p"),We.innerHTML=us,ct=a(),p(Xe.$$.fragment),pt=a(),xe=n("p"),xe.textContent=ys,dt=a(),_=n("h2"),X=n("a"),al=n("span"),p(Ee.$$.fragment),_t=a(),De=n("span"),De.textContent=fs,Mt=a(),Ge=n("p"),Ge.textContent=ws,mt=a(),Ve=n("p"),Ve.innerHTML=Js,ut=a(),p(Qe.$$.fragment),yt=a(),Ye=n("p"),Ye.innerHTML=Ts,ft=a(),il=n("p"),this.h()},l(e){const l=Rs("svelte-1phssyn",document.head);c=o(l,"META",{name:!0,content:!0}),l.forEach(t),U=i(e),J=o(e,"P",{}),T(J).forEach(t),b=i(e),h=o(e,"H1",{class:!0});var He=T(h);Z=o(He,"A",{id:!0,class:!0,href:!0});var nl=T(Z);Oe=o(nl,"SPAN",{});var ol=T(Oe);d(x.$$.fragment,ol),ol.forEach(t),nl.forEach(t),ht=i(He),Fe=o(He,"SPAN",{"data-svelte-h":!0}),r(Fe)!=="svelte-invj8g"&&(Fe.textContent=At),He.forEach(t),rl=As(e,`


La libreria 🤗 Transformers è studiata per essere facilmente estendibile. Il codice di ogni modello è interamente 
situato in una sottocartella del repository senza alcuna astrazione, perciò puoi facilmente copiare il file di un 
modello e modificarlo in base ai tuoi bisogni.
`),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-9vqb6y"&&(E.textContent=$t),cl=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-gtiyni"&&(G.innerHTML=kt),pl=i(e),C=o(e,"H2",{class:!0});var Jt=T(C);A=o(Jt,"A",{id:!0,class:!0,href:!0});var js=T(A);el=o(js,"SPAN",{});var Us=T(el);d(V.$$.fragment,Us),Us.forEach(t),js.forEach(t),Ct=i(Jt),qe=o(Jt,"SPAN",{"data-svelte-h":!0}),r(qe)!=="svelte-ucfz5u"&&(qe.textContent=Nt),Jt.forEach(t),dl=As(e,`


Prima di iniziare a lavorare al modello, scriviamone la configurazione. La configurazione di un modello è un oggetto
che contiene tutte le informazioni necessarie per la build del modello. Come vedremo nella prossima sezione, il 
modello può soltanto essere inizializzato tramite \`config\`, per cui dovremo rendere tale oggetto più completo possibile.
`),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-vu54em"&&(Q.textContent=Bt),Ml=i(e),d(Y.$$.fragment,e),ml=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-pmvkz7"&&(H.textContent=Rt),ul=i(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-b1zbf8"&&(F.innerHTML=Wt),yl=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-z50i7c"&&(q.innerHTML=Xt),fl=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-ya7kyo"&&(S.innerHTML=xt),wl=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-s5azty"&&(P.textContent=Et),Jl=i(e),d(L.$$.fragment,e),Tl=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-i6yebl"&&(D.innerHTML=Gt),jl=i(e),d(K.$$.fragment,e),Ul=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-qiupgh"&&(O.innerHTML=Vt),bl=i(e),v=o(e,"H2",{class:!0});var Tt=T(v);$=o(Tt,"A",{id:!0,class:!0,href:!0});var bs=T($);ll=o(bs,"SPAN",{});var hs=T(ll);d(ee.$$.fragment,hs),hs.forEach(t),bs.forEach(t),vt=i(Tt),Se=o(Tt,"SPAN",{"data-svelte-h":!0}),r(Se)!=="svelte-iu39nu"&&(Se.textContent=Qt),Tt.forEach(t),hl=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-k6id05"&&(le.innerHTML=Yt),Cl=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-7jzmhs"&&(te.innerHTML=Ht),vl=i(e),d(se.$$.fragment,e),Il=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1n9eqy1"&&(ae.textContent=Ft),gl=i(e),d(ie.$$.fragment,e),_l=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1rhha2m"&&(ne.innerHTML=qt),zl=i(e),d(k.$$.fragment,e),Zl=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1xd6e24"&&(oe.innerHTML=St),Al=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1eigcf8"&&(re.textContent=Pt),$l=i(e),d(ce.$$.fragment,e),kl=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-11w45e"&&(pe.innerHTML=Lt),Nl=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-aatwzz"&&(de.textContent=Dt),Bl=i(e),d(Me.$$.fragment,e),Rl=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-31zx9x"&&(me.innerHTML=Kt),Wl=i(e),I=o(e,"H2",{class:!0});var jt=T(I);N=o(jt,"A",{id:!0,class:!0,href:!0});var Cs=T(N);tl=o(Cs,"SPAN",{});var vs=T(tl);d(ue.$$.fragment,vs),vs.forEach(t),Cs.forEach(t),It=i(jt),Pe=o(jt,"SPAN",{"data-svelte-h":!0}),r(Pe)!=="svelte-17jxeo2"&&(Pe.textContent=Ot),jt.forEach(t),Xl=i(e),d(B.$$.fragment,e),xl=i(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1h1v7pd"&&(ye.innerHTML=es),El=i(e),d(fe.$$.fragment,e),Gl=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1jiyxvm"&&(we.innerHTML=ls),Vl=i(e),d(R.$$.fragment,e),Ql=i(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-lts8a1"&&(Je.textContent=ts),Yl=i(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-7j1ida"&&(Te.textContent=ss),Hl=i(e),d(je.$$.fragment,e),Fl=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-10v4ms0"&&(Ue.innerHTML=as),ql=i(e),d(be.$$.fragment,e),Sl=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-16h756x"&&(he.innerHTML=is),Pl=i(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1p0sixi"&&(Ce.textContent=ns),Ll=i(e),d(ve.$$.fragment,e),Dl=i(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-4z8yqk"&&(Ie.textContent=os),Kl=i(e),d(ge.$$.fragment,e),Ol=i(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1t3y58i"&&(_e.textContent=rs),et=i(e),d(ze.$$.fragment,e),lt=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1scrh7h"&&(Ze.textContent=cs),tt=i(e),d(Ae.$$.fragment,e),st=i(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-amfesh"&&($e.innerHTML=ps),at=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-51ocuc"&&(ke.innerHTML=ds),it=i(e),g=o(e,"H2",{class:!0});var Ut=T(g);W=o(Ut,"A",{id:!0,class:!0,href:!0});var Is=T(W);sl=o(Is,"SPAN",{});var gs=T(sl);d(Ne.$$.fragment,gs),gs.forEach(t),Is.forEach(t),gt=i(Ut),Le=o(Ut,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-vr5zt2"&&(Le.textContent=Ms),Ut.forEach(t),nt=i(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1xalseo"&&(Be.innerHTML=ms),ot=i(e),d(Re.$$.fragment,e),rt=i(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-lcodn"&&(We.innerHTML=us),ct=i(e),d(Xe.$$.fragment,e),pt=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-2poiu5"&&(xe.textContent=ys),dt=i(e),_=o(e,"H2",{class:!0});var bt=T(_);X=o(bt,"A",{id:!0,class:!0,href:!0});var _s=T(X);al=o(_s,"SPAN",{});var zs=T(al);d(Ee.$$.fragment,zs),zs.forEach(t),_s.forEach(t),_t=i(bt),De=o(bt,"SPAN",{"data-svelte-h":!0}),r(De)!=="svelte-180rfw8"&&(De.textContent=fs),bt.forEach(t),Mt=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1ucsuh2"&&(Ge.textContent=ws),mt=i(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-14j7ntv"&&(Ve.innerHTML=Js),ut=i(e),d(Qe.$$.fragment,e),yt=i(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1a07nu7"&&(Ye.innerHTML=Ts),ft=i(e),il=o(e,"P",{}),T(il).forEach(t),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",JSON.stringify(Gs)),M(Z,"id","condividere-modelli-personalizzati"),M(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Z,"href","#condividere-modelli-personalizzati"),M(h,"class","relative group"),M(A,"id","scrivere-una-configurazione-personalizzata"),M(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(A,"href","#scrivere-una-configurazione-personalizzata"),M(C,"class","relative group"),M($,"id","scrivere-un-modello-personalizzato"),M($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M($,"href","#scrivere-un-modello-personalizzato"),M(v,"class","relative group"),M(N,"id","inviare-il-codice-allhub"),M(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(N,"href","#inviare-il-codice-allhub"),M(I,"class","relative group"),M(W,"id","usare-un-modello-con-codice-personalizzato"),M(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(W,"href","#usare-un-modello-con-codice-personalizzato"),M(g,"class","relative group"),M(X,"id","registrare-un-modello-con-codice-personalizzato-nelle-classi-auto"),M(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(X,"href","#registrare-un-modello-con-codice-personalizzato-nelle-classi-auto"),M(_,"class","relative group")},m(e,l){w(document.head,c),s(e,U,l),s(e,J,l),s(e,b,l),s(e,h,l),w(h,Z),w(Z,Oe),m(x,Oe,null),w(h,ht),w(h,Fe),s(e,rl,l),s(e,E,l),s(e,cl,l),s(e,G,l),s(e,pl,l),s(e,C,l),w(C,A),w(A,el),m(V,el,null),w(C,Ct),w(C,qe),s(e,dl,l),s(e,Q,l),s(e,Ml,l),m(Y,e,l),s(e,ml,l),s(e,H,l),s(e,ul,l),s(e,F,l),s(e,yl,l),s(e,q,l),s(e,fl,l),s(e,S,l),s(e,wl,l),s(e,P,l),s(e,Jl,l),m(L,e,l),s(e,Tl,l),s(e,D,l),s(e,jl,l),m(K,e,l),s(e,Ul,l),s(e,O,l),s(e,bl,l),s(e,v,l),w(v,$),w($,ll),m(ee,ll,null),w(v,vt),w(v,Se),s(e,hl,l),s(e,le,l),s(e,Cl,l),s(e,te,l),s(e,vl,l),m(se,e,l),s(e,Il,l),s(e,ae,l),s(e,gl,l),m(ie,e,l),s(e,_l,l),s(e,ne,l),s(e,zl,l),m(k,e,l),s(e,Zl,l),s(e,oe,l),s(e,Al,l),s(e,re,l),s(e,$l,l),m(ce,e,l),s(e,kl,l),s(e,pe,l),s(e,Nl,l),s(e,de,l),s(e,Bl,l),m(Me,e,l),s(e,Rl,l),s(e,me,l),s(e,Wl,l),s(e,I,l),w(I,N),w(N,tl),m(ue,tl,null),w(I,It),w(I,Pe),s(e,Xl,l),m(B,e,l),s(e,xl,l),s(e,ye,l),s(e,El,l),m(fe,e,l),s(e,Gl,l),s(e,we,l),s(e,Vl,l),m(R,e,l),s(e,Ql,l),s(e,Je,l),s(e,Yl,l),s(e,Te,l),s(e,Hl,l),m(je,e,l),s(e,Fl,l),s(e,Ue,l),s(e,ql,l),m(be,e,l),s(e,Sl,l),s(e,he,l),s(e,Pl,l),s(e,Ce,l),s(e,Ll,l),m(ve,e,l),s(e,Dl,l),s(e,Ie,l),s(e,Kl,l),m(ge,e,l),s(e,Ol,l),s(e,_e,l),s(e,et,l),m(ze,e,l),s(e,lt,l),s(e,Ze,l),s(e,tt,l),m(Ae,e,l),s(e,st,l),s(e,$e,l),s(e,at,l),s(e,ke,l),s(e,it,l),s(e,g,l),w(g,W),w(W,sl),m(Ne,sl,null),w(g,gt),w(g,Le),s(e,nt,l),s(e,Be,l),s(e,ot,l),m(Re,e,l),s(e,rt,l),s(e,We,l),s(e,ct,l),m(Xe,e,l),s(e,pt,l),s(e,xe,l),s(e,dt,l),s(e,_,l),w(_,X),w(X,al),m(Ee,al,null),w(_,_t),w(_,De),s(e,Mt,l),s(e,Ge,l),s(e,mt,l),s(e,Ve,l),s(e,ut,l),m(Qe,e,l),s(e,yt,l),s(e,Ye,l),s(e,ft,l),s(e,il,l),wt=!0},p(e,[l]){const He={};l&2&&(He.$$scope={dirty:l,ctx:e}),k.$set(He);const nl={};l&2&&(nl.$$scope={dirty:l,ctx:e}),B.$set(nl);const ol={};l&2&&(ol.$$scope={dirty:l,ctx:e}),R.$set(ol)},i(e){wt||(u(x.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(k.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(ue.$$.fragment,e),u(B.$$.fragment,e),u(fe.$$.fragment,e),u(R.$$.fragment,e),u(je.$$.fragment,e),u(be.$$.fragment,e),u(ve.$$.fragment,e),u(ge.$$.fragment,e),u(ze.$$.fragment,e),u(Ae.$$.fragment,e),u(Ne.$$.fragment,e),u(Re.$$.fragment,e),u(Xe.$$.fragment,e),u(Ee.$$.fragment,e),u(Qe.$$.fragment,e),wt=!0)},o(e){y(x.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(k.$$.fragment,e),y(ce.$$.fragment,e),y(Me.$$.fragment,e),y(ue.$$.fragment,e),y(B.$$.fragment,e),y(fe.$$.fragment,e),y(R.$$.fragment,e),y(je.$$.fragment,e),y(be.$$.fragment,e),y(ve.$$.fragment,e),y(ge.$$.fragment,e),y(ze.$$.fragment,e),y(Ae.$$.fragment,e),y(Ne.$$.fragment,e),y(Re.$$.fragment,e),y(Xe.$$.fragment,e),y(Ee.$$.fragment,e),y(Qe.$$.fragment,e),wt=!1},d(e){e&&(t(U),t(J),t(b),t(h),t(rl),t(E),t(cl),t(G),t(pl),t(C),t(dl),t(Q),t(Ml),t(ml),t(H),t(ul),t(F),t(yl),t(q),t(fl),t(S),t(wl),t(P),t(Jl),t(Tl),t(D),t(jl),t(Ul),t(O),t(bl),t(v),t(hl),t(le),t(Cl),t(te),t(vl),t(Il),t(ae),t(gl),t(_l),t(ne),t(zl),t(Zl),t(oe),t(Al),t(re),t($l),t(kl),t(pe),t(Nl),t(de),t(Bl),t(Rl),t(me),t(Wl),t(I),t(Xl),t(xl),t(ye),t(El),t(Gl),t(we),t(Vl),t(Ql),t(Je),t(Yl),t(Te),t(Hl),t(Fl),t(Ue),t(ql),t(Sl),t(he),t(Pl),t(Ce),t(Ll),t(Dl),t(Ie),t(Kl),t(Ol),t(_e),t(et),t(lt),t(Ze),t(tt),t(st),t($e),t(at),t(ke),t(it),t(g),t(nt),t(Be),t(ot),t(rt),t(We),t(ct),t(pt),t(xe),t(dt),t(_),t(Mt),t(Ge),t(mt),t(Ve),t(ut),t(yt),t(Ye),t(ft),t(il)),t(c),f(x),f(V),f(Y,e),f(L,e),f(K,e),f(ee),f(se,e),f(ie,e),f(k,e),f(ce,e),f(Me,e),f(ue),f(B,e),f(fe,e),f(R,e),f(je,e),f(be,e),f(ve,e),f(ge,e),f(ze,e),f(Ae,e),f(Ne),f(Re,e),f(Xe,e),f(Ee),f(Qe,e)}}}const Gs={local:"condividere-modelli-personalizzati",sections:[{local:"scrivere-una-configurazione-personalizzata",title:"Scrivere una configurazione personalizzata"},{local:"scrivere-un-modello-personalizzato",title:"Scrivere un modello personalizzato"},{local:"inviare-il-codice-allhub",title:"Inviare il codice all'Hub"},{local:"usare-un-modello-con-codice-personalizzato",title:"Usare un modello con codice personalizzato"},{local:"registrare-un-modello-con-codice-personalizzato-nelle-classi-auto",title:"Registrare un modello con codice personalizzato nelle classi Auto"}],title:"Condividere modelli personalizzati"};function Vs(z){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends Ns{constructor(c){super(),Bs(this,c,Vs,Es,$s,{})}}export{Ss as component};
