import{s as Pc,f as Bc,o as Zc,n as Qc}from"../chunks/scheduler.36a0863c.js";import{S as Ec,i as Wc,g as a,s as n,u,A as Dc,h as r,f as i,c as o,j as g,v as d,y as s,k as p,o as c,a as l,w as m,d as f,t as M,x as v}from"../chunks/index.d0f7a4c4.js";import{T as Rc}from"../chunks/Tip.4c7d7eb1.js";import{I as y}from"../chunks/IconCopyLink.bc5fad79.js";import{C as h}from"../chunks/CodeBlock.4236768d.js";function qc(Nl){let T,O="Nel caso siate su Windows, sostituite <code>RUN_SLOW=1</code> con <code>SET RUN_SLOW=1</code>";return{c(){T=a("p"),T.innerHTML=O},l(w){T=r(w,"P",{"data-svelte-h":!0}),s(T)!=="svelte-1gsy2xt"&&(T.innerHTML=O)},m(w,ul){l(w,T,ul)},p:Qc,d(w){w&&i(T)}}}function Sc(Nl){let T,O,w,ul,b,x,Jl,K,vr,dl,_r="Come aggiungere un modello a 🤗 Transformers?",Pl,ee,kr=`Aggiungere un nuovo modello é spesso difficile e richiede una profonda conoscenza della libreria 🤗 Transformers e anche
della repository originale del modello. A Hugging Face cerchiamo di dare alla community sempre piú poteri per aggiungere
modelli independentemente. Quindi, per alcuni nuovi modelli che la community vuole aggiungere a 🤗 Transformers, abbiamo
creato una specifica <em>call-for-model-addition</em> che spiega passo dopo passo come aggiungere il modello richiesto. Con
questo <em>call-for-model-addition</em> vogliamo insegnare a volenterosi e esperti collaboratori della community come implementare
un modello in 🤗 Transformers.`,Bl,te,Ir=`Se questo é qualcosa che può interessarvi, siete liberi di controllare l’attuale “calls-for-model-addition” <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model/open_model_proposals/README.md" rel="nofollow">qui</a>
e contattarci.`,Zl,ie,Lr=`Se il modello sarà selezionato, allora potrete lavorare insieme a un membro di Hugging Face per integrare il modello in 🤗
Transformers. Così facendo, ci guadagnerai in una comprensione totale, sia teorica che pratica, del modello proposto. Inoltre,
sarai l’artefice di un importante contributo open-source a 🤗 Transformers. Durante l’implementazione avrai l’opportunità di:`,Ql,le,zr="<li>ottenere più comprensione delle best practices in open-source</li> <li>capire i principi di design di una della librerie NLP più popolari</li> <li>capire come efficientemente testare complessi modelli NLP</li> <li>capire come integrare utilit Python come <code>black</code>, <code>ruff</code>, <code>make fix-copies</code> in una libreria per garantire sempre di avere un codice leggibile e pulito</li>",El,ne,$r=`Siamo anche contenti se vuoi aggiungere un modello che non può essere trovato nella cartella “calls-for-model-addition”.
Le seguenti sezioni spiegano in dettaglio come aggiungere un nuovo modello. Può anche essere molto utile controllare modelli
già aggiunti <a href="https://github.com/huggingface/transformers/pulls?q=is%3Apr+label%3A%22PR+for+Model+Addition%22+is%3Aclosed" rel="nofollow">qui</a>,
per capire se richiamano il modello che vorreste aggiungere.`,Wl,oe,xr="Per cominciare, vediamo una panoramica general della libreria Transformers.",Dl,C,A,jl,ae,gr,ml,Ar="Panoramica generale su 🤗 Transformers",Rl,re,Hr=`Prima di tutto, vediamo in generale 🤗 Transformers. 🤗 Transformers é una libreria molto strutturata, quindi
puà essere che a volte ci sia un disaccordo con alcune filosofie della libreria o scelte di design. Dalla nostra esperienza,
tuttavia, abbiamo trovato che le scelte fondamentali di design della libreria sono cruciali per usare 🤗 Transformers efficacemente
su larga scala, mantenendo i costi a un livello accettabile.`,ql,se,Nr=`Un buon primo punto di partenza per capire al meglio la libreria é leggere la <a href="filosofia">documentazione sulla nostra filosofia</a>
Da qui, ci sono alcune scelte sul modo di lavorare che cerchiamo di applicare a tutti i modelli:`,Sl,pe,Pr=`<li>La composizione é generalmente favorita sulla sovra-astrazione</li> <li>Duplicare il codice non é sempre male, soprattutto se migliora notevolmente la leggibilità e accessibilità del modello</li> <li>Tutti i files creati per il nuovo modello devono il piu possibile “compatti”. Questo vuol dire che quando qualcuno leggerá il codice
di uno specifico modello, potrá vedere solo il corrispettivo file <code>modeling_....py</code> senza avere multiple dipendenze.</li>`,Gl,ce,Br=`La cosa piú importante, é che consideriamo la libreria non solo un mezzo per dare un prodotto, <em>per esempio</em> dare la possibilità
di usare BERT per inferenza, ma é anche il prodotto reale che noi vogliamo migliorare sempre più. Quindi, quando aggiungi
un modello, non sei solo la persona che userà il modello, ma rappresenti anche tutti coloro che leggeranno,
cercheranno di capire e modificare il tuo modello.`,Vl,ue,Zr="Tenendo questi principi in mente, immergiamoci nel design generale della libreria.",Xl,J,H,Ul,de,hr,fl,Qr="Panoramica sui modelli",Yl,me,Er=`Per aggiungere con successo un modello, é importante capire l’interazione tra il tuo modello e la sua configurazione,
<code>PreTrainedModel</code>, e <code>PretrainedConfig</code>. Per dare un esempio, chiameremo il modello da aggiungere a 🤗 Transformers<br/> <code>BrandNewBert</code>.`,Fl,fe,Wr="Diamo un’occhiata:",Ol,Ml,Dr,Kl,Me,Rr=`Come potete vedere, ci basiamo sull’ereditarietà in 🤗 Transformers, tenendo però il livello di astrazione a un minimo
assoluto.  Non ci sono mai più di due livelli di astrazione per ogni modello nella libreria. <code>BrandNewBertModel</code> eredita
da <code>BrandNewBertPreTrainedModel</code> che, a sua volta, eredita da <code>PreTrainedModel</code> -  semplice no?
Come regola generale, vogliamo essere sicuri che un nuovo modello dipenda solo da <code>PreTrainedModel</code>. Le funzionalità
importanti che sono automaticamente conferite a ogni nuovo modello sono <code>from_pretrained()</code>
e <code>save_pretrained()</code>, che sono usate per serializzazione e deserializzazione. Tutte le altre importanti
funzionalità, come ad esempio <code>BrandNewBertModel.forward</code> devono essere definite completamente nel nuovo script
<code>modeling_brand_new_bert.py</code>. Inoltre, vogliamo essere sicuri che un modello con uno specifico head layer, come
<code>BrandNewBertForMaskedLM</code> non erediti da <code>BrandNewBertModel</code>, ma piuttosto usi <code>BrandNewBertModel</code>
come componente che può essere chiamata nel passaggio forward per mantenere il livello di astrazione basso. Ogni
nuovo modello richieste una classe di configurazione, chiamata <code>BrandNewBertConfig</code>. Questa configurazione é sempre
mantenuta come un attributo in <code>PreTrainedModel</code>, e quindi può essere accessibile tramite l’attributo <code>config</code>
per tutte le classi che ereditano da <code>BrandNewBertPreTrainedModel</code>:`,en,ve,tn,ge,qr=`Analogamente al modello, la configurazione eredita le funzionalità base di serializzazione e deserializzazione da
<code>PretrainedConfig</code>. É da notare che la configurazione e il modello sono sempre serializzati in due formati differenti -
il modello é serializzato in un file <em>pytorch_model.bin</em> mentre la configurazione con <em>config.json</em>. Chiamando
<code>save_pretrained()</code> automaticamente chiamerà <code>save_pretrained()</code>, cosicché sia il
modello che la configurazione siano salvati.`,ln,j,N,_l,he,Tr,vl,Sr="Stile per il codice",nn,Te,Gr=`Quando codifichi un nuovo modello, tieni presente che Transformers ha una sua struttura di fondo come libreria, perciò
ci sono alcuni fatti da considerare su come scrivere un codice :-)`,on,we,Vr=`<li>Il forward pass del tuo modello dev’essere scritto completamente nel file del modello, mentre dev’essere indipendente
da altri modelli nella libreria. Se vuoi riutilizzare un blocco di codice da un altro modello, copia e incolla il codice con un commento <code># Copied from</code> in cima al codice (guarda <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">qui</a>
per un ottimo esempio).</li> <li>Il codice dev’essere interamente comprensibile, anche da persone che non parlano in inglese. Questo significa che le
variabili devono avere un nome descrittivo e bisogna evitare abbreviazioni. Per esempio, <code>activation</code> é molto meglio
che <code>act</code>. Le variabili con una lettera sono da evitare fortemente, almeno che non sia per un indce in un for loop.</li> <li>Generamente é meglio avere un codice esplicito e piú lungo che un codice corto e magico.</li> <li>Evita di subclassare <code>nn.Sequential</code> in Pytorch, puoi subclassare <code>nn.Module</code> e scrivere il forward pass, cosicché
chiunque può effettuare debug sul tuo codice, aggiungendo print o breaking points.</li> <li>La tua function-signature dev’essere type-annoted. Per il resto, é meglio preferire variabili con un nome accettabile
piuttosto che annotazioni per aumentare la comprensione e leggibilità del codice.</li>`,an,U,P,kl,ye,wr,gl,Xr="Panoramica sui tokenizers",rn,be,Yr="Questa sezione sarà creata al piu presto :-(",sn,_,B,Il,Ce,yr,hl,Fr="Aggiungere un modello a 🤗 Transformers passo dopo passo",pn,Je,Or="Ci sono differenti modi per aggiungere un modello a Hugging Face. Qui trovi una lista di blog posts da parte della community su come aggiungere un modello:",cn,je,Kr='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Aggiungere GPT2</a> scritto da <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Aggiungere WMT19 MT</a> scritto da <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',un,Ue,es="Per esperienza, possiamo dirti che quando si aggiunge un modello é meglio tenere a mente le seguenti considerazioni:",dn,_e,ts=`<li>Non sfondare una porta giá aperta! La maggior parte del codice che aggiungerai per un nuovo modello 🤗 Transformers
esiste già da qualche parte in 🤗 Transformers. Prendi un po’ di tempo per trovare codici simili in modelli e tokenizers esistenti e fare un copia-incolla. Ricorda che <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> e <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> sono tuoi buoni amici. Inoltre, ricorda che puó essere molto probabile che il tokenizer per il tuo modello sia basato sull’implementazione di un altro modello, e il codice del tuo modello stesso su un altro ancora. <em>Per esempio</em> il modello FSMT é basato su BART, mentre il tokenizer di FSMT é basato su XLM.</li> <li>Ricorda che qui é piu una sfida ingegneristica che scientifica. Spendi piú tempo per create un efficiente ambiente di debugging piuttosto che cercare di capire tutti gli aspetti teorici dell’articolo del modello.</li> <li>Chiedi aiuto se sei in panne! I modelli sono la parte principale di 🤗 Transformers, perciò qui a Hugging Face siamo più che contenti di aiutarti in ogni passo per aggiungere il tuo modello. Non esitare a chiedere se vedi che non riesci a progredire.</li>`,mn,ke,is="Di seguito, diamo una ricetta generale per aiutare a portare un modello in 🤗 Transformers.",fn,Ie,ls="La lista seguente é un sommario di tutto quello che é stato fatto per aggiungere un modello, e può essere usata come To-Do List:",Mn,Le,ns='<li><ol><li>☐ (Opzionale) Capire gli aspetti teorici del modello</li></ol></li> <li><ol start="2"><li>☐ Preparare l’ambiente dev per transformers</li></ol></li> <li><ol start="3"><li>☐ Preparare l’ambiente debugging della repository originale</li></ol></li> <li><ol start="4"><li>☐ Create uno script che gestisca con successo il forward pass usando la repository originale e checkpoint</li></ol></li> <li><ol start="5"><li>☐ Aggiungere con successo lo scheletro del modello a Transformers</li></ol></li> <li><ol start="6"><li>☐ Convertire i checkpoint original a Transformers checkpoint</li></ol></li> <li><ol start="7"><li>☐ Effettuare con successo la forward pass in Transformers, di modo che dia un output identico al checkpoint originale</li></ol></li> <li><ol start="8"><li>☐ Finire i tests per il modello in Transformers</li></ol></li> <li><ol start="9"><li>☐ Aggiungere con successo Tokenizer in Transformers</li></ol></li> <li><ol start="10"><li>☐ Testare e provare gli integration tests da capo a fine</li></ol></li> <li><ol start="11"><li>☐ Completare i docs</li></ol></li> <li><ol start="12"><li>☐ Caricare i moedl weights all’hub</li></ol></li> <li><ol start="13"><li>☐ Sottomettere una pull request</li></ol></li> <li><ol start="14"><li>☐ (Opzionale) Aggiungere un notebook con una demo</li></ol></li>',vn,ze,os="Per cominciare di solito consigliamo <code>BrandNewBert</code>, partendo dalla teoria, di modo da avere una buona comprensione della teoria generale. TUttavia, se preferisci imparare l’aspetto teorico del modello mentre <em>lavori</em> sul modello é ok immergersi direttamente nel codice di <code>BrandNewBert</code>. Questa opzione puó essere buona se le tue skills ingegneristiche sono meglio che quelle teoriche, o se il paper <code>BrandNewBert</code> ti dá problemi, o se semplicemente ti piace programmare piú che leggere articoli scientifici.",gn,k,Z,Ll,$e,br,Tl,as="1. (Opzionale) Aspetti teorici di BrandNewBert",hn,xe,rs="Allora con calma, prendi un po’ di tempo per leggere l’articolo su <em>BrandNewBert</em> . Sicuramente, alcune sezioni dell’articolo sono molto complesse, ma non preoccuparti! L’obiettivo non é avere una compresione immensa della teoria alla base, ma estrarre le informazioni necessarie per re-implementare con successo il modello in 🤗 Transformers. Quindi, non impazzire sugli aspetti teorici, ma piuttosto focalizzati su quelli pratici, ossia:",Tn,Ae,ss='<li>Che tipo di modello é <em>brand_new_bert</em>? É solo un encoder in stile BERT? O tipo decoder come GPT2? O encoder e decoder stile BART? Dai un’occhiata a <a href="model_summary">model_summary</a> se non sei famigliare con le differenze tra questi modelli</li> <li>Quali sono le applicazioni di <em>brand_new_bert</em>? Classificazione di testo? Generazione di testo? O per tasks del genere seq2seq?</li> <li>Quali sono le nuove aggiunte al modello che lo rendono diverso da BERT/GPT-2/BART?</li> <li>Quali modelli estistenti in <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> sono molto simili a <em>brand_new_bert</em>?</li> <li>Che tipo di tokenizer si usa in questo caso? Un sentencepiece tokenizer? O un word piece tokenizer? Il tokenizer é lo stesso di BERT o BART?</li>',wn,He,ps="Una volta che senti che hai avuto una bella overview dell’architettura del modello, puoi scrivere senza problemi al team di Hugging Face per ogni domanda che tu hai. Questo puó includere domande sull’architettura del modello, o sull’attention layer, etc. Saremo molto felici di aiutarti :)",yn,I,Q,zl,Ne,Cr,wl,cs="2. Prepare il tuo ambiente",bn,Pe,us='<li><p>Forka la <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> cliccando sul tasto ‘Fork’ nella pagina della repository. Questo crea una copia del codice nel tuo account GitHub</p></li> <li><p>Clona il tuo fork <code>transfomers</code> sul tuo dico locale, e aggiungi la repository base come remota:</p></li>',Cn,Be,Jn,E,ds="<li>Crea un ambiente di sviluppo, per esempio tramite questo comando:</li>",jn,Ze,Un,Qe,ms="quindi torna alla directory principale:",_n,Ee,kn,W,fs='<li>Attenzione, raccomandiamo di aggiungere la versione di PyTorch di <em>brand_new_bert</em> a Transfomers. Per installare PyTorch, basta seguire queste istruzioni <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</li>',In,We,Ms="<strong>Nota bene:</strong> Non c’é bisogno di installare o avere installato CUDA. Il nuovo modello può funzionare senza problemi su una CPU.",Ln,D,vs="<li>Per trasferire <em>brand_new_bert</em> To port <em>brand_new_bert</em> avrai bisogno anche accesso alla sua repository originale:</li>",zn,De,$n,Re,gs="Ok, ora hai un ambiente di sviluppo per portare <em>brand_new_bert</em> in 🤗 Transformers.",xn,L,R,$l,qe,Jr,yl,hs="3.-4. Provare un pretrained checkpoint usando la repo originale",An,Se,Ts="Per cominciare, comincerai a lavorare sulla repo originale di <em>brand_new_bert</em>. Come spesso accade, l’implementazione originale é molto sullo stile “ricerca”. Questo significa che a volte la documentazione non é al top, magari manca qualche cosa e il codice puó essere difficile da capire. Tuttavia, questa é e dev’essere la motivazione per reimplementare <em>brand_new_bert</em>. In Hugging Face, uno degli obiettivi principali é di <em>mettere le persone sulle spalle dei giganti</em>, il che si traduce, in questo contesto, di prendere un modello funzionante e riscriverlo e renderlo il piú possibile <strong>accessibile, user-friendly, e leggibile</strong>. Questa é la top motivazione per re-implementare modelli in 🤗 Transformers - cercare di creare nuove complesse tecnologie NLP accessibili a <strong>chiunque</strong>.",Hn,Ge,ws="Riuscire a far girare il modello pretrained originale dalla repository ufficiale é spesso il passo <strong>piu arduo</strong>. Dalla nostra esperienza, é molto importante spendere un p’ di tempo per diventare familiari con il codice base originale. Come test, prova a capire i seguenti punti:",Nn,Ve,ys="<li>Dove si trovano i pretrained weights?</li> <li>Come caricare i pretrained weights nel modello corrispondente?</li> <li>Come girare un tokenizer independentemente dal modello?</li> <li>Prova a tracciare un singolo forward pass, cosicché potrai sapere che classi e funzioni sono richieste per un semplice forward pass. Di solito, dovrai reimplementare queste funzioni e basta</li> <li>Prova a localizzare i componenti importanti del modello: Dove si trova la classe del modello? Ci sono sotto classi nel modello <em>per esempio</em> EngoderModel, DecoderMOdel? Dove si trova il self-attention layer? Ci sono molteplici differenti layer di attention, <em>per esempio</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>Come puoi fare debug sul modello nell’ambiente originale della repo? Devi aggiungere dei <em>print</em> o puoi usare <em>ipdb</em> come debugger interattivo, o vabene anche un IDE efficiente per debug come PyCharm?</li>",Pn,Xe,bs="É molto importante che prima di cominciare a trasferire il modello nuovo tu spenda tempo a fare debug del codice originale in maniera <strong>efficiente</strong>! Inoltre, ricorda che tutta la library é open-soruce, quindi non temere di aprire issue o fare una pull request nella repo originale. Tutti coloro che mantengono la repository saranno piú che felici di avere qualcuno che guarda e gioca con i loro codici!",Bn,Ye,Cs="A questo punto, sta a te decidere quale ambiente per debug vuoi usare. Noi consilgiamo di evitare setup con GPU, che potrebbero costare assai, lavorare su una CPU puó essere un ottimo punto di partenza per indagare la repository originale e per cominciare a scrivere il codice per 🤗 Transformers. Solo alla fine, quando il modello é stato portato con successo in  🤗 Transformers, allora si potrá verificare il suo funzionamento su GPU.",Zn,Fe,Js="In generale ci sono due possibili ambienti di debug per il testare il modello originale:",Qn,Oe,js='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Scripts locali in Python</li>',En,Ke,Us="Il vantaggio dei Jupyter notebooks é la possibilità di eseguire cella per cella, il che può essere utile per decomporre tutte le componenti logiche, cosi da a vere un ciclo di debug più rapido, siccome si possono salvare i risultati da steps intermedi. Inoltre, i notebooks spesso sono molto facili da condividere con altri contributors, il che può essere molto utile se vuoi chiedere aiuto al team di Hugging Face. Se sei famigliare con Jupyter notebooks allora racommandiamo di lavorare in questa maniera.",Wn,et,_s="Ovviamente se non siete abituati a lavorare con i notebook, questo può essere uno svantaggio nell’usare questa tecnologia, sprecando un sacco di tempo per setup e portare tutto al nuovo ambiente, siccome non potreste neanche usare dei tools di debug come <code>ipdb</code>.",Dn,tt,ks="Per ogni pratica code-base, é sempre meglio come primo step caricare un <strong>piccolo</strong> checkpoint pretrained e cercare di riprodurre un singolo forward pass usando un vettore fittizio di IDs fatti da numeri interi. Un esempio per uno script simile, in pseudocodice é:",Rn,it,qn,lt,Is="Per quanto riguarda la strategia di debugging, si può scegliere tra:",Sn,nt,Ls=`<li>Decomporre il modello originario in piccole componenenti e testare ognuna di esse</li> <li>Decomporre il modello originario nel <em>tokenizer</em> originale e nel <em>modello</em> originale, testare un forward pass su questi,
e usare dei print statement o breakpoints intermedi per verificare</li>`,Gn,ot,zs=`Ancora una volta, siete liberi di scegliere quale strategia sia ottimale per voi. Spesso una strategia é piu
avvantaggiosa di un’altra, ma tutto dipende dall’code-base originario.`,Vn,at,$s=`Se il code-base vi permette di decomporre il modello in piccole sub-componenenti, <em>per esempio</em> se il code-base
originario può essere facilmente testato in eager mode, allora vale la pena effettuare un debugging di questo genere.
Ricordate che ci sono dei vantaggi nel decidere di prendere la strada piu impegnativa sin da subito:`,Xn,rt,xs=`<li>negli stage piu finali, quando bisognerà comparare il modello originario all’implementazione in Hugging Face, potrete verificare
automaticamente ogni componente, individualmente, di modo che ci sia una corrispondenza 1:1</li> <li>avrete l’opportunità di decomporre un problema molto grande in piccoli passi, così da strutturare meglio il vostro lavoro</li> <li>separare il modello in componenti logiche vi aiuterà ad avere un’ottima overview sul design del modello, quindi una migliore
comprensione del modello stesso</li> <li>verso gli stage finali i test fatti componente per componente vi aiuterà ad essere sicuri di non andare avanti e indietro
nell’implementazione, così da continuare la modifica del codice senza interruzione</li>`,Yn,st,As=`Un ottimo esempio di come questo può essere fatto é dato da <a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre</a>
per il modello ELECTRA`,Fn,pt,Hs=`Tuttavia, se il code-base originale é molto complesso o le componenti intermedie possono essere testate solo in tramite
compilazione, potrebbe richiedere parecchio tempo o addirittura essere impossibile separare il modello in piccole sotto-componenti.
Un buon esempio é <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">MeshTensorFlow di T5</a>. Questa libreria
é molto complessa e non offre un metodo semplice di decomposizione in sotto-componenti. Per simili librerie, potrete fare
affidamento ai print statements.`,On,ct,Ns=`In ogni caso, indipendentemente da quale strategia scegliete, la procedura raccomandata é di cominciare a fare debug dal
primo layer al layer finale.
É consigliato recuperare gli output dai layers, tramite print o sotto-componenti, nel seguente ordine:`,Kn,ut,Ps="<li>Recuperare gli IDs di input dati al modello</li> <li>Recuperare i word embeddings</li> <li>Recuperare l’input del primo Transformer layer</li> <li>Recuperare l’output del primo Transformer layer</li> <li>Recuperare l’output dei seguenti <code>n - 1</code> Transformer layers</li> <li>Recuperare l’output dell’intero BrandNewBert Model</li>",eo,dt,Bs="Gli IDs in input dovrebbero essere un arrary di interi, <em>per esempio</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",to,mt,Zs="Gli output dei seguenti layer di solito dovrebbero essere degli array di float multi-dimensionali come questo:",io,ft,lo,Mt,Qs=`Ci aspettiamo che ogni modello aggiunto a 🤗 Transformers passi con successo un paio di test d’integrazione. Questo
significa che il modello originale e la sua implementazione in 🤗 Transformers abbiano lo stesso output con una precisione
di 0.001! Siccome é normale che lo stesso esatto modello, scritto in librerie diverse, possa dare output leggermente
diversi, la tolleranza accettata é 1e-3 (0.001). Ricordate che i due modelli devono dare output quasi identici. Dunque,
é molto conveniente comparare gli output intermedi di 🤗 Transformers molteplici volte con gli output intermedi del
modello originale di <em>brand_new_bert</em>. Di seguito vi diamo alcuni consigli per avere un ambiente di debug il piu efficiente
possibile:`,no,vt,Es=`<li>Trovate la migliore strategia per fare debug dei risultati intermedi. Per esempio, é la repository originale scritta in PyTorch?
Se si, molto probabilmente dovrete dedicare un po’ di tempo per scrivere degli script piu lunghi, così da decomporre il
modello originale in piccole sotto-componenti, in modo da poter recuperare i valori intermedi. Oppure, la repo originale
é scritta in Tensorflow 1? Se é così dovrete fare affidamento ai print di Tensorflow <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a>
per avere i valori intermedi. Altro caso, la repo é scritta in Jax? Allora assicuratevi che il modello non sia in <strong>jit</strong>
quanto testate il foward pass, <em>per esempio</em> controllate <a href="https://github.com/google/jax/issues/196" rel="nofollow">questo link</a>.</li> <li>Usate i più piccoli pretrained checkpoint che potete trovare. Piu piccolo é il checkpoint, piu velocemente sarà il vostro
ciclo di debug. Non é efficiente avere un pretrained model così gigante che per il forward pass impieghi piu di 10 secondi.
Nel caso in cui i checkpoints siano molto grandi, e non si possa trovare di meglio, allora é buona consuetudine ricorrere
a fare un dummy model nel nuovo ambiente, con weights inizializzati random e salvare quei weights per comprare la versione 🤗 Transformers
con il vostro modello</li> <li>Accertatevi di usare la via piu semplice per chiamare il forward pass nella repo originale. Sarebbe opportuno trovare
la funzione originaria che chiami <strong>solo</strong> un singolo forward pass, <em>per esempio</em> questa funzione spesso viene chiamata
<code>predict</code>, <code>evaluate</code>, <code>forward</code> o <code>__call__</code>. Siate sicuri di non fare debug su una funzione che chiami <code>forward</code> molteplici
volte, <em>per esempio</em> per generare testo, come <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Cercate di separare la tokenization dal forward pass del modello. Se la repo originaria mostra esempio dove potete dare
come input una stringa, provate a cercare dove nella forward call la stringa viene cambiata in input ids e cominciate il
debug da questo punto. Questo vi garantisce un ottimo punto di partenza per scrivere un piccolo script personale dove dare
gli input al modello, anziche delle stringhe in input.</li> <li>Assicuratevi che il debugging <strong>non</strong> sia in training mode. Spesso questo potra il modello a dare degli output random, per
via dei molteplici dropout layers. Assicuratevi che il forward pass nell’ambiente di debug sia <strong>deterministico</strong>, cosicche
i dropout non siano usati. Alternativamente, potete usare <em>transformers.utils.set_seed</em> se la vecchia e nuova implementazione
sono nello stesso framework.</li>`,oo,gt,Ws="La seguente sezione vi da ulteriori dettagli e accorgimenti su come potete fare tutto questo per <em>brand_new_bert</em>.",ao,z,q,xl,ht,jr,bl,Ds="5.-14. Trasferire BrandNewBert in 🤗 Transformers",ro,Tt,Rs="Allora cominciamo ad aggiungere un nuovo codice in 🤗 Transformers. Andate nel vostro fork clone di 🤗 Transformers:",so,wt,po,yt,qs=`Nel caso speciale in cui stiate aggiungendo un modello, la cui architettura sia identica a una di un modello già esistente,
dovrete solo aggiugnere uno script di conversione, come descritto <a href="#write-a-conversion-script">qui</a>.
In questo caso, potete riutilizzare l’intera architettura del modello gia esistente.`,co,bt,Ss="Se questo non é il caso, cominciamo con il generare un nuovo modello. Avrete due opzioni:",uo,Ct,Gs="<li><code>transformers-cli add-new-model-like</code> per aggiungere un nuovo modello come uno che gia esiste</li> <li><code>transformers-cli add-new-model</code> per aggiungere un nuovo modello da un nostro template (questo assomigliera a BERT o Bart, in base al modello che selezionerete)</li>",mo,Jt,Vs=`In entrambi i casi, l’output vi darà un questionario da riempire con informazioni basi sul modello. Il secondo comando richiede di installare
un <code>cookiecutter</code> - maggiori informazioni <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model" rel="nofollow">qui</a>.`,fo,jt,Xs="<strong>Aprire una Pull Request in main huggingface/transformers repo</strong>",Mo,Ut,Ys=`Prime di cominciare ad adattare il codice automaticamente generato, aprite una nuova PR come “Work in progress (WIP)“,
<em>per esempio</em> ”[WIP] Aggiungere <em>brand_new_bert</em>”, cosicché il team di Hugging Face possa lavorare al vostro fianco nell’
integrare il modello in 🤗 Transformers.`,vo,_t,Fs="Questi sarebbero gli step generali da seguire:",go,kt,Os="<li>Creare un branch dal main branch con un nome descrittivo</li>",ho,It,To,S,Ks="<li>Commit del codice automaticamente generato</li>",wo,Lt,yo,G,ep="<li>Fare fetch e rebase del main esistente</li>",bo,zt,Co,V,tp="<li>Push dei cambiamenti al proprio account:</li>",Jo,$t,jo,X,ip=`<li><p>Una volte che siete soddisfatti dei nuovi cambiamenti, andate sulla webpage del vostro fork su GitHub. Cliccate “Pull request”.
Assiuratevi di aggiungere alcuni membri di Hugging Face come reviewers, nel riguardo alla destra della pagina della PR, cosicche il team
Hugging Face verrà notificato anche per i futuri cambiamenti.</p></li> <li><p>Cambiare la PR a draft, cliccando su “Convert to draft” alla destra della pagina della PR</p></li>`,Uo,xt,lp=`Da quel punto in poi, ricordate di fare commit di ogni progresso e cambiamento, cosicche venga mostrato nella PR. Inoltre,
ricordatevi di tenere aggiornato il vostro lavoro con il main esistente:`,_o,At,ko,Ht,np=`In generale, tutte le domande che avrete riguardo al modello o l’implementazione dovranno essere fatte nella vostra PR
e discusse/risolte nella PR stessa. In questa maniera, il team di Hugging Face sarà sempre notificato quando farete commit
di un nuovo codice o se avrete qualche domanda. É molto utile indicare al team di Hugging Face il codice a cui fate riferimento
nella domanda, cosicche il team potra facilmente capire il problema o la domanda.`,Io,Nt,op=`Per fare questo andate sulla tab “Files changed”, dove potrete vedere tutti i vostri cambiamenti al codice, andate sulla linea
dove volete chiedere una domanda, e cliccate sul simbolo ”+” per aggiungere un commento. Ogni volta che una domanda o problema
é stato risolto, cliccate sul bottone “Resolve”.`,Lo,Pt,ap=`In questa stessa maniera, Hugging Face aprirà domande o commenti nel rivedere il vostro codice. Mi raccomando, chiedete più
domande possibili nella pagina della vostra PR. Se avete domande molto generali, non molto utili per il pubblico, siete liberi
di chiedere al team Hugging Face direttamente su slack o email.`,zo,Bt,rp="<strong>5. Adattare i codici per brand_new_bert</strong>",$o,Zt,sp=`Per prima cosa, ci focalizzeremo sul modello e non sui tokenizer. Tutto il codice relative dovrebbe trovarsi in<br/> <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> e
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,xo,Qt,pp=`Ora potete finalmente cominciare il codice :). Il codice generato in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> avrà sia la stessa architettura di BERT se é un
modello encoder-only o BART se é encoder-decoder. A questo punto, ricordatevi cio che avete imparato all’inizio, riguardo
agli aspetti teorici del modello: <em>In che maniera il modello che sto implmementando é diverso da BERT o BART?</em>. Implementare
questi cambi  spesso vuol dire cambiare il layer <em>self-attention</em>, l’ordine dei layer di normalizzazione e così via…
Ancora una volta ripetiamo, é molto utile vedere architetture simili di modelli gia esistenti in Transformers per avere
un’idea migliore su come implementare il modello.`,Ao,Et,cp=`<strong>Notate</strong> che a questo punto non dovete avere subito un codice tutto corretto o pulito. Piuttosto, é consigliato cominciare con un
codice poco pulito, con copia-incolla del codice originale in <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>
fino a che non avrete tutto il codice necessario. In base alla nostra esperienza, é molto meglio aggiungere una prima bozza
del codice richiesto e poi correggere e migliorare iterativamente. L’unica cosa essenziale che deve funzionare qui é la seguente
instanza:`,Ho,Wt,No,Dt,up=`Questo comando creerà un modello con i parametri di default definiti in <code>BrandNewBergConfig()</code> e weights random. Questo garantisce
che <code>init()</code> di tutte le componenti funzioni correttamente.`,Po,Rt,dp="<strong>6. Scrivere uno script di conversione</strong>",Bo,qt,mp=`Il prossimo step é scrivere uno script per convertire il checkpoint che avete usato per fare debug su <em>brand_new_berts</em> nella
repo originale in un checkpoint per la nuova implementazione di <em>brand_new_bert</em> in 🤗 Transformers. Non é consigliato scrivere
lo script di conversione da zero, ma piuttosto cercate e guardate script gia esistenti in 🤗 Transformers, così da trovarne
uno simile al vostro modello. Di solito basta fare una copia di uno script gia esistente e adattarlo al vostro caso.
Non esistate a chiedre al team di Hugging Face a riguardo.`,Zo,St,fp='<li>Se state convertendo un modello da TensorFlow a PyTorch, un ottimo inizio é vedere <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">questo script di conversione per BERT</a></li> <li>Se state convertendo un modello da PyTorch a PyTorch, <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">lo script di conversione di BART può esservi utile</a></li>',Qo,Gt,Mp=`Qui di seguito spiegheremo come i modelli PyTorch salvano i weights per ogni layer e come i nomi dei layer sono definiti. In PyTorch,
il nomde del layer é definito dal nome della class attribute che date al layer. Definiamo un modello dummy in PyTorch,
chiamato <code>SimpleModel</code>:`,Eo,Vt,Wo,Xt,vp=`Ora possiamo creare un’instanza di questa definizione di modo da inizializzare a random weights: <code>dense</code>, <code>intermediate</code>, <code>layer_norm</code>.
Possiamo usare print per vedere l’architettura del modello:`,Do,Yt,Ro,Ft,gp="Da cui si ottiene:",qo,Ot,So,Kt,hp=`Si può vedere come i nomi dei layers siano definiti dal nome della class attribute in PyTorch. I valori dei weights di uno
specifico layer possono essere visualizzati:`,Go,ei,Vo,ti,Tp="ad esempio:",Xo,ii,Yo,li,wp=`Nello script di conversione, dovreste riempire quei valori di inizializzazione random con gli stessi weights del corrispondente
layer nel checkpoint. <em>Per esempio</em>`,Fo,ni,Oo,oi,yp=`Così facendo, dovete verificare che ogni inizializzazione random di un peso del modello PyTorch e il suo corrispondente peso nel pretrained checkpoint
siano esattamente gli stessi e uguali in <strong>dimensione/shape e nome</strong>. Per fare questo, é <strong>necessario</strong> aggiungere un <code>assert</code>
per la dimensione/shape e nome:`,Ko,ai,ea,ri,bp="Inoltre, dovrete fare il print sia dei nomi che dei weights per essere sicuri che siano gli stessi:",ta,si,ia,pi,Cp=`Se la dimensione o il nome non sono uguali, probabilmente avete sbagliato ad assegnare il peso nel checkpoint o nel layer costrutture di
🤗 Transformers.`,la,ci,Jp=`Una dimensione sbagliata può essere dovuta ad un errore nei parameteri in <code>BrandNewBertConfig()</code>. Tuttavia, può essere anche
che l’implementazione del layer in PyTorch richieda di fare una transposizione della matrice dei weights.`,na,ui,jp=`Infine, controllate <strong>tutti</strong> che tutti i weights inizializzati e fate print di tutti i weights del checkpoint che non sono stati
usati per l’inizializzazione, di modo da essere sicuri che il modello sia correttamente convertito. É normale che ci siano
errori nel test di conversione, fai per un errore in <code>BrandNewBertConfig()</code>, o un errore nell’architettura in 🤗 Transformers,
o un bug in <code>init()</code>.`,oa,di,Up=`Questo step dev’essere fatto tramite iterazioni fino a che non si raggiungano gli stessi valori per i weights. Una volta che
il checkpoint é stato correttamente caricato in 🤗 Transformers, potete salvare il modello in una cartella di vostra scelta
<code>/path/to/converted/checkpoint/folder</code> che contenga sia
<code>pytorch_model.bin</code> che <code>config.json</code>:`,aa,mi,ra,fi,_p="<strong>7. Implementare il forward pass</strong>",sa,Mi,kp=`Una volta che i weights pretrained sono stati correttamente caricati in 🤗 Transformers, dovrete assicurarvi che il forward pass
sia correttamente implementato. <a href="#provare-un-pretrained-checkpoint-usando-la-repo-originale">Qui</a>, avete give creato e provato
uno script che testi il forward pass del modello usando la repo originaria. Ora dovrete fare lo stesso con uno script analogo
usando l’implementazione in 🤗 Transformers anziché l’originale. Piu o meno lo script dovrebbe essere:`,pa,vi,ca,gi,Ip=`Di solito l’output da 🤗 Transformers non é uguale uguale all’output originario, sopratto la prima volta. Non vi abbattete -
é normale! Prima di tutto assicuratevi che non ci siano errori o che non vengano segnalati degli errori nella forward pass.
Spesso capita che ci siano dimensioni sbagliate o data type sbagliati, <em>ad esempio</em> <code>torch.long</code> anziche <code>torch.float32</code>.
Non esistate a chiedere al team Hugging Face!`,ua,hi,Lp=`Nella parte finale assicuratevi che l’implementazione 🤗 Transformers funzioni correttamente cosi da testare che gli output
siano equivalenti a una precisione di <code>1e-3</code>. Controllate che <code>outputs.shape</code> siano le stesse tra 🤗 Transformers e l’implementazione
originaria. Poi, controllate che i valori in output siano identici. Questa é sicuramente la parte più difficile, qui una serie
di errori comuni quando gli output non sono uguali:`,da,Ti,zp=`<li>Alcuni layers non sono stati aggiunti, <em>ad esempio</em> un <em>activation</em> layer non é stato aggiunto, o ci si é scordati di una connessione</li> <li>La matrice del word embedding non é stata ripareggiata</li> <li>Ci sono degli embeddings posizionali sbagliati perché l’implementazione originaria ha un offset</li> <li>Il dropout é in azione durante il forward pass. Per sistemare questo errore controllate che <em>model.training = False</em> e che
il dropout non sia stato attivato nel forward pass, <em>per esempio</em> passate <em>self.training</em> a <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,ma,wi,$p=`La miglior maniera per sistemare il problema é di vedere all’implementazione originaria del forward pass e in 🤗 Transformers
fianco a fianco e vedere se ci sono delle differenze. In teoria, con debug e print degli output intermedie di entrambe le
implementazioni nel forward pass nell’esatta posizione del network dovrebbe aiutarvi a vedere dove ci sono differenze tra
i due frameworks. Come prima mossa controllate che <code>input_ids</code> siano identici in entrambi gli scripts. Da lì andate fino
all’ultimo layer. Potrete notare una differenza tra le due implementazioni a quel punto.`,fa,yi,xp=`Una volta che lo stesso output é stato ragguingi, verificate gli output con <code>torch.allclose(original_output, output, atol=1e-3)</code>.
A questo punto se é tutto a posto: complimenti! Le parti seguenti saranno una passeggiata 😊.`,Ma,bi,Ap="<strong>8. Aggiungere i test necessari per il modello</strong>",va,Ci,Hp=`A questo punto avete aggiunto con successo il vostro nuovo modello. Tuttavia, é molto probabile che il modello non sia
del tutto ok con il design richiesto. Per essere sicuri che l’implementazione sia consona e compatibile con 🤗 Transformers é
necessario implementare dei tests. Il Cookiecutter dovrebbe fornire automaticamente dei file per test per il vostro modello,
di solito nella folder <code>tests/test_modeling_brand_new_bert.py</code>. Provate questo per verificare l’ok nei test piu comuni:`,ga,Ji,ha,ji,Np="Una volta sistemati i test comuni, bisogna assicurarsi che il vostro lavoro sia correttamente testato cosicchè:",Ta,Ui,Pp="<li>a) La community puo capire in maniera semplice il vostro lavoro controllando tests specifici del modello <em>brand_new_bert</em>,</li> <li>b) Implementazioni future del vostro modello non rompano alcune feature importante del modello.</li>",wa,_i,Bp=`Per prima cosa agguingete dei test d’integrazione. Questi sono essenziali perche fanno la stessa funzione degli scripts di
debug usati precedentemente. Un template per questi tests esiste gia nel Cookiecutter ed é sotto il nome di <code>BrandNewBertModelIntegrationTests</code>,
voi dovrete solo completarlo. Una volta che questi tests sono OK, provate:`,ya,ki,ba,Y,Ca,Ii,Zp=`Di seguito, tutte le features che sono utili e necessarire per <em>brand_new_bert</em> devono essere testate in test separati,
contenuti in <code>BrandNewBertModelTester</code>/ <code>BrandNewBertModelTest</code>. spesso la gente si scorda questi test, ma ricordate che sono utili per:`,Ja,Li,Qp="<li>Aiuta gli utenti a capire il vostro codice meglio, richiamando l’attenzione su queste nuove features</li> <li>Developers e contributors futuri potranno velocemente testare nuove implementazioni del modello testanto questi casi speciali.</li>",ja,zi,Ep="<strong>9. Implementare il tokenizer</strong>",Ua,$i,Wp="A questo punto avremo bisogno un tokenizer per <em>brand_new_bert</em>. Di solito il tokenizer é uguale ad altri modelli in 🤗 Transformers.",_a,xi,Dp="É importante che troviate il file con il tokenizer originale e che lo carichiate in 🤗 Transformers.",ka,Ai,Rp=`Per controllare che il tokenizer funzioni in modo corretto, create uno script nella repo originaria che riceva come input
una stringa e ritorni gli <code>input_ids</code>. Piu o meno questo potrebbe essere il codice:`,Ia,Hi,La,Ni,qp=`Potrebbe richiedere un po’ di tempo, ma guardate ancora alla repo originaria per trovare la funzione corretta del tokenizer.
A volte capita di dover riscrivere il tokenizer nella repo originaria, di modo da avere come output gli <code>input_ids</code>.
A quel punto uno script analogo é necessario in 🤗 Transformers:`,za,Pi,$a,Bi,Sp="Una volta che <code>input_ids</code> sono uguali, bisogna aggiungere un test per il tokenizer.",xa,Zi,Gp="Il file test per tokenizer di <em>brand_new_brand</em> dovrebbe avere un paio di hard-coded test d’integrazione.",Aa,Qi,Vp="<strong>10. Test end-to-end</strong>",Ha,Ei,Xp=`Ora che avete il tokenizer, dovrete aggiungere dei test d’integrazione per l’intero workflow in <code>tests/test_modeling_brand_new_bert.py</code> in 🤗 Transformer.
Questi test devono mostrare che un significante campione text-to-text funzioni come ci si aspetta nell’implementazione di  🤗 Transformers.
<em>Per esempio</em> potreste usare dei source-to-target-translation, o un sommario di un articolo, o un domanda-risposta e cosi via.
Se nessuno dei checkpoints é stato ultra parametrizzato per task simili, allora i tests per il modello sono piu che sufficienti.
Nello step finale dovete assicurarvi che il modello sia totalmente funzionale, e consigliamo anche di provare a testare su GPU.
Puo succedere che ci si scordi un <code>.to(self.device)</code> ad esempio. Se non avete accesso a GPU, il team Hugging Face puo provvedere
a testare questo aspetto per voi.`,Na,Wi,Yp="<strong>11. Aggiungere una Docstring</strong>",Pa,Di,Fp=`Siete quasi alla fine! L’ultima cosa rimasta é avere una bella docstring e una pagina doc. Il Cookiecutter dovrebbe provvedere già
un template chiamato <code>docs/source/model_doc/brand_new_bert.rst</code>, che dovrete compilare. La prima cosa che un utente farà
per usare il vostro modello sarà dare una bella lettura al doc. Quindi proponete una documentazione chiara e concisa. É molto
utile per la community avere anche delle <em>Tips</em> per mostrare come il modello puo’ essere usato. Non esitate a chiedere a Hugging Face
riguardo alle docstirng.`,Ba,Ri,Op=`Quindi, assicuratevi che la docstring sia stata aggiunta a <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>.
Assicuratevi che la docstring sia corretta e che includa tutti i necessari input e output. Abbiamo una guida dettagliata per
scrivere la documentazione e docstring.`,Za,qi,Kp="<strong>Rifattorizzare il codice</strong>",Qa,Si,ec="Perfetto! Ora che abbiamo tutto per <em>brand_new_bert</em> controllate che lo stile del codice sia ok:",Ea,Gi,Wa,Vi,tc="E che il codice passi i quality check:",Da,Xi,Ra,Yi,ic=`A volte capita che manchino delle informazioninella docstring o alcuni nomi sbagliati, questo farà fallire i tests sopra.
Ripetiamo: chiedete pure a Hugging Face, saremo lieti di aiutarvi.`,qa,Fi,lc="Per ultimo, fare del refactoring del codice una volta che é stato creato.",Sa,Oi,nc="Avete finito con il codice, congratulazioni! 🎉 Siete fantasticiiiiiii! 😎",Ga,Ki,oc="<strong>12. Caricare il modello sul model hub</strong>",Va,el,ac=`In questa ultima parte dovrete convertire e caricare il modello, con tutti i checkpoints, nel model hub e aggiungere una
model card per ogni checkpoint caricato. Leggete la nostra guida <a href="model_sharing">Model sharing and uploading Page</a> per
avere familiarità con l’hub. Di solito in questa parte lavorate a fianco di Hugging face per decidere un nome che sia ok
per ogni checkpoint, per ottenere i permessi necessari per caricare il modello nell’organizzazione dell’autore di <em>brand_new_bert</em>.
Il metodo <code>push_to_hub</code>, presente in tutti i modelli <code>transformers</code>, é una maniera rapida e indolore per caricare il vostro checkpoint sull’hub:`,Xa,tl,Ya,il,rc=`Vale la pena spendere un po’ di tempo per creare una model card ad-hoc per ogni checkpoint. Le model cards dovrebbero
suggerire le caratteristiche specifiche del checkpoint, <em>per esempio</em> su che dataset il checkpoint é stato pretrained o fine-tuned.
O che su che genere di task il modello lavoro? E anche buona pratica includere del codice su come usare il modello correttamente.`,Fa,ll,sc="<strong>13. (Opzionale) Aggiungere un notebook</strong>",Oa,nl,pc=`É molto utile aggiungere un notebook, che dimostri in dettaglio come <em>brand_new_bert</em> si utilizzi per fare inferenza e/o
fine-tuned su specifiche task. Non é una cosa obbligatoria da avere nella vostra PR, ma é molto utile per la community.`,Ka,ol,cc="<strong>14. Sottomettere la PR</strong>",er,al,uc=`L’ultimissimo step! Ovvero il merge della PR nel main. Di solito il team Hugging face a questo punto vi avrà gia aiutato,
ma é ok prendere un po’ di tempo per pulire la descirzione e commenti nel codice.`,tr,$,F,Al,rl,Ur,Cl,dc="Condividete il vostro lavoro!!",ir,sl,mc=`É ora tempo di prendere un po’ di credito dalla communità per il vostro lavoro! Caricare e implementare un nuovo modello
é un grandissimo contributo per Transformers e l’intera community NLP. Il codice e la conversione dei modelli pre-trained sara
sicuramente utilizzato da centinaia o migliaia di sviluppatori e ricercatori. Siate fieri e orgogliosi di condividere il vostro
traguardo con l’intera community :)`,lr,pl,fc="<strong>Avete create un altro modello che é super facile da usare per tutti quanti nella community! 🤯</strong>",nr,Hl,or;return K=new y({}),ae=new y({}),de=new y({}),ve=new h({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwaWwlMjBtb2RlbGxvJTIwaGElMjBhY2Nlc3NvJTIwYWwlMjBzdW8lMjBjb25maWc=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># il modello ha accesso al suo config</span>`,wrap:!1}}),he=new y({}),ye=new y({}),Ce=new y({}),$e=new y({}),Ne=new y({}),Be=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),Ze=new h({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),Ee=new h({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),De=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUyMCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git 
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),qe=new y({}),it=new h({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),ft=new h({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),ht=new y({}),wt=new h({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),It=new h({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydCUyMA==",highlighted:"git checkout -b add_brand_new_bert ",wrap:!1}}),Lt=new h({props:{code:"Z2l0JTIwYWRkJTIwLiUyMCUwQWdpdCUyMGNvbW1pdCUyMA==",highlighted:`git add . 
git commit `,wrap:!1}}),zt=new h({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUyMCUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbiUyMA==",highlighted:`git fetch upstream 
git rebase upstream/main `,wrap:!1}}),$t=new h({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),At=new h({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),Wt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),Vt=new h({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),Yt=new h({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),Ot=new h({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),ei=new h({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),ii=new h({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),ni=new h({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),ai=new h({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),si=new h({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),mi=new h({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),vi=new h({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),Ji=new h({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X21vZGVsaW5nX2JyYW5kX25ld19iZXJ0LnB5",highlighted:"pytest tests/test_modeling_brand_new_bert.py",wrap:!1}}),ki=new h({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZ0ZXN0X21vZGVsaW5nX2JyYW5kX25ld19iZXJ0LnB5JTNBJTNBQnJhbmROZXdCZXJ0TW9kZWxJbnRlZ3JhdGlvblRlc3Rz",highlighted:"RUN_SLOW=1 pytest -sv tests/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),Y=new Rc({props:{$$slots:{default:[qc]},$$scope:{ctx:Nl}}}),Hi=new h({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),Pi=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Gi=new h({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),Xi=new h({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),tl=new h({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwcmVwb19wYXRoX29yX25hbWUlM0QlMjJicmFuZF9uZXdfYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMFVuY29tbWVudCUyMHRoZSUyMGZvbGxvd2luZyUyMGxpbmUlMjB0byUyMHB1c2glMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTBBJTIwJTIwJTIwJTIwJTIzJTIwb3JnYW5pemF0aW9uJTNEJTIyJTNDT1JHQU5JWkFUSU9OJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJBZGQlMjBtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV90ZW1wX2RpciUzRFRydWUlMkMlMEEp",highlighted:`brand_new_bert.push_to_hub(
    repo_path_or_name=<span class="hljs-string">&quot;brand_new_bert&quot;</span>,
    <span class="hljs-comment"># Uncomment the following line to push to an organization</span>
    <span class="hljs-comment"># organization=&quot;&lt;ORGANIZATION&gt;&quot;,</span>
    commit_message=<span class="hljs-string">&quot;Add model&quot;</span>,
    use_temp_dir=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),rl=new y({}),{c(){T=a("meta"),O=n(),w=a("p"),ul=n(),b=a("h1"),x=a("a"),Jl=a("span"),u(K.$$.fragment),vr=n(),dl=a("span"),dl.textContent=_r,Pl=n(),ee=a("p"),ee.innerHTML=kr,Bl=n(),te=a("p"),te.innerHTML=Ir,Zl=n(),ie=a("p"),ie.textContent=Lr,Ql=n(),le=a("ul"),le.innerHTML=zr,El=n(),ne=a("p"),ne.innerHTML=$r,Wl=n(),oe=a("p"),oe.textContent=xr,Dl=n(),C=a("h2"),A=a("a"),jl=a("span"),u(ae.$$.fragment),gr=n(),ml=a("span"),ml.textContent=Ar,Rl=n(),re=a("p"),re.textContent=Hr,ql=n(),se=a("p"),se.innerHTML=Nr,Sl=n(),pe=a("ul"),pe.innerHTML=Pr,Gl=n(),ce=a("p"),ce.innerHTML=Br,Vl=n(),ue=a("p"),ue.textContent=Zr,Xl=n(),J=a("h3"),H=a("a"),Ul=a("span"),u(de.$$.fragment),hr=n(),fl=a("span"),fl.textContent=Qr,Yl=n(),me=a("p"),me.innerHTML=Er,Fl=n(),fe=a("p"),fe.textContent=Wr,Ol=n(),Ml=a("img"),Kl=n(),Me=a("p"),Me.innerHTML=Rr,en=n(),u(ve.$$.fragment),tn=n(),ge=a("p"),ge.innerHTML=qr,ln=n(),j=a("h3"),N=a("a"),_l=a("span"),u(he.$$.fragment),Tr=n(),vl=a("span"),vl.textContent=Sr,nn=n(),Te=a("p"),Te.textContent=Gr,on=n(),we=a("ol"),we.innerHTML=Vr,an=n(),U=a("h3"),P=a("a"),kl=a("span"),u(ye.$$.fragment),wr=n(),gl=a("span"),gl.textContent=Xr,rn=n(),be=a("p"),be.textContent=Yr,sn=n(),_=a("h2"),B=a("a"),Il=a("span"),u(Ce.$$.fragment),yr=n(),hl=a("span"),hl.textContent=Fr,pn=n(),Je=a("p"),Je.textContent=Or,cn=n(),je=a("ol"),je.innerHTML=Kr,un=n(),Ue=a("p"),Ue.textContent=es,dn=n(),_e=a("ul"),_e.innerHTML=ts,mn=n(),ke=a("p"),ke.textContent=is,fn=n(),Ie=a("p"),Ie.textContent=ls,Mn=n(),Le=a("ul"),Le.innerHTML=ns,vn=n(),ze=a("p"),ze.innerHTML=os,gn=n(),k=a("h3"),Z=a("a"),Ll=a("span"),u($e.$$.fragment),br=n(),Tl=a("span"),Tl.textContent=as,hn=n(),xe=a("p"),xe.innerHTML=rs,Tn=n(),Ae=a("ul"),Ae.innerHTML=ss,wn=n(),He=a("p"),He.textContent=ps,yn=n(),I=a("h3"),Q=a("a"),zl=a("span"),u(Ne.$$.fragment),Cr=n(),wl=a("span"),wl.textContent=cs,bn=n(),Pe=a("ol"),Pe.innerHTML=us,Cn=n(),u(Be.$$.fragment),Jn=n(),E=a("ol"),E.innerHTML=ds,jn=n(),u(Ze.$$.fragment),Un=n(),Qe=a("p"),Qe.textContent=ms,_n=n(),u(Ee.$$.fragment),kn=n(),W=a("ol"),W.innerHTML=fs,In=n(),We=a("p"),We.innerHTML=Ms,Ln=n(),D=a("ol"),D.innerHTML=vs,zn=n(),u(De.$$.fragment),$n=n(),Re=a("p"),Re.innerHTML=gs,xn=n(),L=a("h3"),R=a("a"),$l=a("span"),u(qe.$$.fragment),Jr=n(),yl=a("span"),yl.textContent=hs,An=n(),Se=a("p"),Se.innerHTML=Ts,Hn=n(),Ge=a("p"),Ge.innerHTML=ws,Nn=n(),Ve=a("ul"),Ve.innerHTML=ys,Pn=n(),Xe=a("p"),Xe.innerHTML=bs,Bn=n(),Ye=a("p"),Ye.textContent=Cs,Zn=n(),Fe=a("p"),Fe.textContent=Js,Qn=n(),Oe=a("ul"),Oe.innerHTML=js,En=n(),Ke=a("p"),Ke.textContent=Us,Wn=n(),et=a("p"),et.innerHTML=_s,Dn=n(),tt=a("p"),tt.innerHTML=ks,Rn=n(),u(it.$$.fragment),qn=n(),lt=a("p"),lt.textContent=Is,Sn=n(),nt=a("ul"),nt.innerHTML=Ls,Gn=n(),ot=a("p"),ot.textContent=zs,Vn=n(),at=a("p"),at.innerHTML=$s,Xn=n(),rt=a("ul"),rt.innerHTML=xs,Yn=n(),st=a("p"),st.innerHTML=As,Fn=n(),pt=a("p"),pt.innerHTML=Hs,On=n(),ct=a("p"),ct.textContent=Ns,Kn=n(),ut=a("ol"),ut.innerHTML=Ps,eo=n(),dt=a("p"),dt.innerHTML=Bs,to=n(),mt=a("p"),mt.textContent=Zs,io=n(),u(ft.$$.fragment),lo=n(),Mt=a("p"),Mt.innerHTML=Qs,no=n(),vt=a("ul"),vt.innerHTML=Es,oo=n(),gt=a("p"),gt.innerHTML=Ws,ao=n(),z=a("h3"),q=a("a"),xl=a("span"),u(ht.$$.fragment),jr=n(),bl=a("span"),bl.textContent=Ds,ro=n(),Tt=a("p"),Tt.textContent=Rs,so=n(),u(wt.$$.fragment),po=n(),yt=a("p"),yt.innerHTML=qs,co=n(),bt=a("p"),bt.textContent=Ss,uo=n(),Ct=a("ul"),Ct.innerHTML=Gs,mo=n(),Jt=a("p"),Jt.innerHTML=Vs,fo=n(),jt=a("p"),jt.innerHTML=Xs,Mo=n(),Ut=a("p"),Ut.innerHTML=Ys,vo=n(),_t=a("p"),_t.textContent=Fs,go=n(),kt=a("ol"),kt.innerHTML=Os,ho=n(),u(It.$$.fragment),To=n(),S=a("ol"),S.innerHTML=Ks,wo=n(),u(Lt.$$.fragment),yo=n(),G=a("ol"),G.innerHTML=ep,bo=n(),u(zt.$$.fragment),Co=n(),V=a("ol"),V.innerHTML=tp,Jo=n(),u($t.$$.fragment),jo=n(),X=a("ol"),X.innerHTML=ip,Uo=n(),xt=a("p"),xt.textContent=lp,_o=n(),u(At.$$.fragment),ko=n(),Ht=a("p"),Ht.textContent=np,Io=n(),Nt=a("p"),Nt.textContent=op,Lo=n(),Pt=a("p"),Pt.textContent=ap,zo=n(),Bt=a("p"),Bt.innerHTML=rp,$o=n(),Zt=a("p"),Zt.innerHTML=sp,xo=n(),Qt=a("p"),Qt.innerHTML=pp,Ao=n(),Et=a("p"),Et.innerHTML=cp,Ho=n(),u(Wt.$$.fragment),No=n(),Dt=a("p"),Dt.innerHTML=up,Po=n(),Rt=a("p"),Rt.innerHTML=dp,Bo=n(),qt=a("p"),qt.innerHTML=mp,Zo=n(),St=a("ul"),St.innerHTML=fp,Qo=n(),Gt=a("p"),Gt.innerHTML=Mp,Eo=n(),u(Vt.$$.fragment),Wo=n(),Xt=a("p"),Xt.innerHTML=vp,Do=n(),u(Yt.$$.fragment),Ro=n(),Ft=a("p"),Ft.textContent=gp,qo=n(),u(Ot.$$.fragment),So=n(),Kt=a("p"),Kt.textContent=hp,Go=n(),u(ei.$$.fragment),Vo=n(),ti=a("p"),ti.textContent=Tp,Xo=n(),u(ii.$$.fragment),Yo=n(),li=a("p"),li.innerHTML=wp,Fo=n(),u(ni.$$.fragment),Oo=n(),oi=a("p"),oi.innerHTML=yp,Ko=n(),u(ai.$$.fragment),ea=n(),ri=a("p"),ri.textContent=bp,ta=n(),u(si.$$.fragment),ia=n(),pi=a("p"),pi.textContent=Cp,la=n(),ci=a("p"),ci.innerHTML=Jp,na=n(),ui=a("p"),ui.innerHTML=jp,oa=n(),di=a("p"),di.innerHTML=Up,aa=n(),u(mi.$$.fragment),ra=n(),fi=a("p"),fi.innerHTML=_p,sa=n(),Mi=a("p"),Mi.innerHTML=kp,pa=n(),u(vi.$$.fragment),ca=n(),gi=a("p"),gi.innerHTML=Ip,ua=n(),hi=a("p"),hi.innerHTML=Lp,da=n(),Ti=a("ul"),Ti.innerHTML=zp,ma=n(),wi=a("p"),wi.innerHTML=$p,fa=n(),yi=a("p"),yi.innerHTML=xp,Ma=n(),bi=a("p"),bi.innerHTML=Ap,va=n(),Ci=a("p"),Ci.innerHTML=Hp,ga=n(),u(Ji.$$.fragment),ha=n(),ji=a("p"),ji.textContent=Np,Ta=n(),Ui=a("ul"),Ui.innerHTML=Pp,wa=n(),_i=a("p"),_i.innerHTML=Bp,ya=n(),u(ki.$$.fragment),ba=n(),u(Y.$$.fragment),Ca=n(),Ii=a("p"),Ii.innerHTML=Zp,Ja=n(),Li=a("ul"),Li.innerHTML=Qp,ja=n(),zi=a("p"),zi.innerHTML=Ep,Ua=n(),$i=a("p"),$i.innerHTML=Wp,_a=n(),xi=a("p"),xi.textContent=Dp,ka=n(),Ai=a("p"),Ai.innerHTML=Rp,Ia=n(),u(Hi.$$.fragment),La=n(),Ni=a("p"),Ni.innerHTML=qp,za=n(),u(Pi.$$.fragment),$a=n(),Bi=a("p"),Bi.innerHTML=Sp,xa=n(),Zi=a("p"),Zi.innerHTML=Gp,Aa=n(),Qi=a("p"),Qi.innerHTML=Vp,Ha=n(),Ei=a("p"),Ei.innerHTML=Xp,Na=n(),Wi=a("p"),Wi.innerHTML=Yp,Pa=n(),Di=a("p"),Di.innerHTML=Fp,Ba=n(),Ri=a("p"),Ri.innerHTML=Op,Za=n(),qi=a("p"),qi.innerHTML=Kp,Qa=n(),Si=a("p"),Si.innerHTML=ec,Ea=n(),u(Gi.$$.fragment),Wa=n(),Vi=a("p"),Vi.textContent=tc,Da=n(),u(Xi.$$.fragment),Ra=n(),Yi=a("p"),Yi.textContent=ic,qa=n(),Fi=a("p"),Fi.textContent=lc,Sa=n(),Oi=a("p"),Oi.textContent=nc,Ga=n(),Ki=a("p"),Ki.innerHTML=oc,Va=n(),el=a("p"),el.innerHTML=ac,Xa=n(),u(tl.$$.fragment),Ya=n(),il=a("p"),il.innerHTML=rc,Fa=n(),ll=a("p"),ll.innerHTML=sc,Oa=n(),nl=a("p"),nl.innerHTML=pc,Ka=n(),ol=a("p"),ol.innerHTML=cc,er=n(),al=a("p"),al.textContent=uc,tr=n(),$=a("h3"),F=a("a"),Al=a("span"),u(rl.$$.fragment),Ur=n(),Cl=a("span"),Cl.textContent=dc,ir=n(),sl=a("p"),sl.textContent=mc,lr=n(),pl=a("p"),pl.innerHTML=fc,nr=n(),Hl=a("p"),this.h()},l(e){const t=Dc("svelte-1phssyn",document.head);T=r(t,"META",{name:!0,content:!0}),t.forEach(i),O=o(e),w=r(e,"P",{}),g(w).forEach(i),ul=o(e),b=r(e,"H1",{class:!0});var cl=g(b);x=r(cl,"A",{id:!0,class:!0,href:!0});var Mc=g(x);Jl=r(Mc,"SPAN",{});var vc=g(Jl);d(K.$$.fragment,vc),vc.forEach(i),Mc.forEach(i),vr=o(cl),dl=r(cl,"SPAN",{"data-svelte-h":!0}),s(dl)!=="svelte-jibcz"&&(dl.textContent=_r),cl.forEach(i),Pl=o(e),ee=r(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-mcybxm"&&(ee.innerHTML=kr),Bl=o(e),te=r(e,"P",{"data-svelte-h":!0}),s(te)!=="svelte-i63dob"&&(te.innerHTML=Ir),Zl=o(e),ie=r(e,"P",{"data-svelte-h":!0}),s(ie)!=="svelte-nuipgt"&&(ie.textContent=Lr),Ql=o(e),le=r(e,"UL",{"data-svelte-h":!0}),s(le)!=="svelte-17lssrb"&&(le.innerHTML=zr),El=o(e),ne=r(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-1s0iijf"&&(ne.innerHTML=$r),Wl=o(e),oe=r(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1hjdlgn"&&(oe.textContent=xr),Dl=o(e),C=r(e,"H2",{class:!0});var ar=g(C);A=r(ar,"A",{id:!0,class:!0,href:!0});var gc=g(A);jl=r(gc,"SPAN",{});var hc=g(jl);d(ae.$$.fragment,hc),hc.forEach(i),gc.forEach(i),gr=o(ar),ml=r(ar,"SPAN",{"data-svelte-h":!0}),s(ml)!=="svelte-r71xic"&&(ml.textContent=Ar),ar.forEach(i),Rl=o(e),re=r(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-celw82"&&(re.textContent=Hr),ql=o(e),se=r(e,"P",{"data-svelte-h":!0}),s(se)!=="svelte-1uhsu9n"&&(se.innerHTML=Nr),Sl=o(e),pe=r(e,"UL",{"data-svelte-h":!0}),s(pe)!=="svelte-1puf5lg"&&(pe.innerHTML=Pr),Gl=o(e),ce=r(e,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-fh5e7z"&&(ce.innerHTML=Br),Vl=o(e),ue=r(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-1or0tgf"&&(ue.textContent=Zr),Xl=o(e),J=r(e,"H3",{class:!0});var rr=g(J);H=r(rr,"A",{id:!0,class:!0,href:!0});var Tc=g(H);Ul=r(Tc,"SPAN",{});var wc=g(Ul);d(de.$$.fragment,wc),wc.forEach(i),Tc.forEach(i),hr=o(rr),fl=r(rr,"SPAN",{"data-svelte-h":!0}),s(fl)!=="svelte-gnqnk7"&&(fl.textContent=Qr),rr.forEach(i),Yl=o(e),me=r(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-j8wqm2"&&(me.innerHTML=Er),Fl=o(e),fe=r(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-1kc404e"&&(fe.textContent=Wr),Ol=o(e),Ml=r(e,"IMG",{src:!0}),Kl=o(e),Me=r(e,"P",{"data-svelte-h":!0}),s(Me)!=="svelte-15z3m1e"&&(Me.innerHTML=Rr),en=o(e),d(ve.$$.fragment,e),tn=o(e),ge=r(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-19tom7d"&&(ge.innerHTML=qr),ln=o(e),j=r(e,"H3",{class:!0});var sr=g(j);N=r(sr,"A",{id:!0,class:!0,href:!0});var yc=g(N);_l=r(yc,"SPAN",{});var bc=g(_l);d(he.$$.fragment,bc),bc.forEach(i),yc.forEach(i),Tr=o(sr),vl=r(sr,"SPAN",{"data-svelte-h":!0}),s(vl)!=="svelte-1ypcstf"&&(vl.textContent=Sr),sr.forEach(i),nn=o(e),Te=r(e,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1e0x1j9"&&(Te.textContent=Gr),on=o(e),we=r(e,"OL",{"data-svelte-h":!0}),s(we)!=="svelte-1dh7wut"&&(we.innerHTML=Vr),an=o(e),U=r(e,"H3",{class:!0});var pr=g(U);P=r(pr,"A",{id:!0,class:!0,href:!0});var Cc=g(P);kl=r(Cc,"SPAN",{});var Jc=g(kl);d(ye.$$.fragment,Jc),Jc.forEach(i),Cc.forEach(i),wr=o(pr),gl=r(pr,"SPAN",{"data-svelte-h":!0}),s(gl)!=="svelte-gtjyvt"&&(gl.textContent=Xr),pr.forEach(i),rn=o(e),be=r(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-1h3mdlf"&&(be.textContent=Yr),sn=o(e),_=r(e,"H2",{class:!0});var cr=g(_);B=r(cr,"A",{id:!0,class:!0,href:!0});var jc=g(B);Il=r(jc,"SPAN",{});var Uc=g(Il);d(Ce.$$.fragment,Uc),Uc.forEach(i),jc.forEach(i),yr=o(cr),hl=r(cr,"SPAN",{"data-svelte-h":!0}),s(hl)!=="svelte-1w8531g"&&(hl.textContent=Fr),cr.forEach(i),pn=o(e),Je=r(e,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1kdxkf0"&&(Je.textContent=Or),cn=o(e),je=r(e,"OL",{"data-svelte-h":!0}),s(je)!=="svelte-kjaxqe"&&(je.innerHTML=Kr),un=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-l6ux6x"&&(Ue.textContent=es),dn=o(e),_e=r(e,"UL",{"data-svelte-h":!0}),s(_e)!=="svelte-hnqwmd"&&(_e.innerHTML=ts),mn=o(e),ke=r(e,"P",{"data-svelte-h":!0}),s(ke)!=="svelte-6fjf2p"&&(ke.textContent=is),fn=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),s(Ie)!=="svelte-1a0cf88"&&(Ie.textContent=ls),Mn=o(e),Le=r(e,"UL",{"data-svelte-h":!0}),s(Le)!=="svelte-1vr4224"&&(Le.innerHTML=ns),vn=o(e),ze=r(e,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-zoos1q"&&(ze.innerHTML=os),gn=o(e),k=r(e,"H3",{class:!0});var ur=g(k);Z=r(ur,"A",{id:!0,class:!0,href:!0});var _c=g(Z);Ll=r(_c,"SPAN",{});var kc=g(Ll);d($e.$$.fragment,kc),kc.forEach(i),_c.forEach(i),br=o(ur),Tl=r(ur,"SPAN",{"data-svelte-h":!0}),s(Tl)!=="svelte-24l4pi"&&(Tl.textContent=as),ur.forEach(i),hn=o(e),xe=r(e,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1i01ztv"&&(xe.innerHTML=rs),Tn=o(e),Ae=r(e,"UL",{"data-svelte-h":!0}),s(Ae)!=="svelte-p3axpb"&&(Ae.innerHTML=ss),wn=o(e),He=r(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-jezgdr"&&(He.textContent=ps),yn=o(e),I=r(e,"H3",{class:!0});var dr=g(I);Q=r(dr,"A",{id:!0,class:!0,href:!0});var Ic=g(Q);zl=r(Ic,"SPAN",{});var Lc=g(zl);d(Ne.$$.fragment,Lc),Lc.forEach(i),Ic.forEach(i),Cr=o(dr),wl=r(dr,"SPAN",{"data-svelte-h":!0}),s(wl)!=="svelte-e212a8"&&(wl.textContent=cs),dr.forEach(i),bn=o(e),Pe=r(e,"OL",{"data-svelte-h":!0}),s(Pe)!=="svelte-v6kqrl"&&(Pe.innerHTML=us),Cn=o(e),d(Be.$$.fragment,e),Jn=o(e),E=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(E)!=="svelte-1evkptw"&&(E.innerHTML=ds),jn=o(e),d(Ze.$$.fragment,e),Un=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1jmeh4e"&&(Qe.textContent=ms),_n=o(e),d(Ee.$$.fragment,e),kn=o(e),W=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(W)!=="svelte-1flpp1p"&&(W.innerHTML=fs),In=o(e),We=r(e,"P",{"data-svelte-h":!0}),s(We)!=="svelte-ktjdn9"&&(We.innerHTML=Ms),Ln=o(e),D=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(D)!=="svelte-1ksg1jw"&&(D.innerHTML=vs),zn=o(e),d(De.$$.fragment,e),$n=o(e),Re=r(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-dbtpxy"&&(Re.innerHTML=gs),xn=o(e),L=r(e,"H3",{class:!0});var mr=g(L);R=r(mr,"A",{id:!0,class:!0,href:!0});var zc=g(R);$l=r(zc,"SPAN",{});var $c=g($l);d(qe.$$.fragment,$c),$c.forEach(i),zc.forEach(i),Jr=o(mr),yl=r(mr,"SPAN",{"data-svelte-h":!0}),s(yl)!=="svelte-1uvamyy"&&(yl.textContent=hs),mr.forEach(i),An=o(e),Se=r(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-1qu4jr4"&&(Se.innerHTML=Ts),Hn=o(e),Ge=r(e,"P",{"data-svelte-h":!0}),s(Ge)!=="svelte-110j2za"&&(Ge.innerHTML=ws),Nn=o(e),Ve=r(e,"UL",{"data-svelte-h":!0}),s(Ve)!=="svelte-1o86ips"&&(Ve.innerHTML=ys),Pn=o(e),Xe=r(e,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-1i7tk"&&(Xe.innerHTML=bs),Bn=o(e),Ye=r(e,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-1fqyo7q"&&(Ye.textContent=Cs),Zn=o(e),Fe=r(e,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-1r60y3z"&&(Fe.textContent=Js),Qn=o(e),Oe=r(e,"UL",{"data-svelte-h":!0}),s(Oe)!=="svelte-1ubalb5"&&(Oe.innerHTML=js),En=o(e),Ke=r(e,"P",{"data-svelte-h":!0}),s(Ke)!=="svelte-svralj"&&(Ke.textContent=Us),Wn=o(e),et=r(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-mel9r4"&&(et.innerHTML=_s),Dn=o(e),tt=r(e,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-cjwu38"&&(tt.innerHTML=ks),Rn=o(e),d(it.$$.fragment,e),qn=o(e),lt=r(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1i7fntd"&&(lt.textContent=Is),Sn=o(e),nt=r(e,"UL",{"data-svelte-h":!0}),s(nt)!=="svelte-1b950b5"&&(nt.innerHTML=Ls),Gn=o(e),ot=r(e,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-5ialh3"&&(ot.textContent=zs),Vn=o(e),at=r(e,"P",{"data-svelte-h":!0}),s(at)!=="svelte-13adnmr"&&(at.innerHTML=$s),Xn=o(e),rt=r(e,"UL",{"data-svelte-h":!0}),s(rt)!=="svelte-s9xa0y"&&(rt.innerHTML=xs),Yn=o(e),st=r(e,"P",{"data-svelte-h":!0}),s(st)!=="svelte-dngyoh"&&(st.innerHTML=As),Fn=o(e),pt=r(e,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-kg6we1"&&(pt.innerHTML=Hs),On=o(e),ct=r(e,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-ebp8u2"&&(ct.textContent=Ns),Kn=o(e),ut=r(e,"OL",{"data-svelte-h":!0}),s(ut)!=="svelte-1sk2t1e"&&(ut.innerHTML=Ps),eo=o(e),dt=r(e,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-cnfp5i"&&(dt.innerHTML=Bs),to=o(e),mt=r(e,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-wlz2de"&&(mt.textContent=Zs),io=o(e),d(ft.$$.fragment,e),lo=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-1icu6e6"&&(Mt.innerHTML=Qs),no=o(e),vt=r(e,"UL",{"data-svelte-h":!0}),s(vt)!=="svelte-1ifrof5"&&(vt.innerHTML=Es),oo=o(e),gt=r(e,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-q1g4tr"&&(gt.innerHTML=Ws),ao=o(e),z=r(e,"H3",{class:!0});var fr=g(z);q=r(fr,"A",{id:!0,class:!0,href:!0});var xc=g(q);xl=r(xc,"SPAN",{});var Ac=g(xl);d(ht.$$.fragment,Ac),Ac.forEach(i),xc.forEach(i),jr=o(fr),bl=r(fr,"SPAN",{"data-svelte-h":!0}),s(bl)!=="svelte-cn1rah"&&(bl.textContent=Ds),fr.forEach(i),ro=o(e),Tt=r(e,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-y19szg"&&(Tt.textContent=Rs),so=o(e),d(wt.$$.fragment,e),po=o(e),yt=r(e,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-1c5tp6d"&&(yt.innerHTML=qs),co=o(e),bt=r(e,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-qv115k"&&(bt.textContent=Ss),uo=o(e),Ct=r(e,"UL",{"data-svelte-h":!0}),s(Ct)!=="svelte-erhqs2"&&(Ct.innerHTML=Gs),mo=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-1rwitc3"&&(Jt.innerHTML=Vs),fo=o(e),jt=r(e,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-1lp0v27"&&(jt.innerHTML=Xs),Mo=o(e),Ut=r(e,"P",{"data-svelte-h":!0}),s(Ut)!=="svelte-1l49660"&&(Ut.innerHTML=Ys),vo=o(e),_t=r(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-susl50"&&(_t.textContent=Fs),go=o(e),kt=r(e,"OL",{"data-svelte-h":!0}),s(kt)!=="svelte-5jcgu6"&&(kt.innerHTML=Os),ho=o(e),d(It.$$.fragment,e),To=o(e),S=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(S)!=="svelte-194t2cz"&&(S.innerHTML=Ks),wo=o(e),d(Lt.$$.fragment,e),yo=o(e),G=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(G)!=="svelte-1a8qrdq"&&(G.innerHTML=ep),bo=o(e),d(zt.$$.fragment,e),Co=o(e),V=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(V)!=="svelte-1ntx3yt"&&(V.innerHTML=tp),Jo=o(e),d($t.$$.fragment,e),jo=o(e),X=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(X)!=="svelte-1plevyn"&&(X.innerHTML=ip),Uo=o(e),xt=r(e,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-1j3sibr"&&(xt.textContent=lp),_o=o(e),d(At.$$.fragment,e),ko=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-1nsjpv4"&&(Ht.textContent=np),Io=o(e),Nt=r(e,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-dewsnv"&&(Nt.textContent=op),Lo=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-iueh1s"&&(Pt.textContent=ap),zo=o(e),Bt=r(e,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-13yidk9"&&(Bt.innerHTML=rp),$o=o(e),Zt=r(e,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-d6o9fs"&&(Zt.innerHTML=sp),xo=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-128ejbp"&&(Qt.innerHTML=pp),Ao=o(e),Et=r(e,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-jaq4jf"&&(Et.innerHTML=cp),Ho=o(e),d(Wt.$$.fragment,e),No=o(e),Dt=r(e,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-w8emzm"&&(Dt.innerHTML=up),Po=o(e),Rt=r(e,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-cjyudz"&&(Rt.innerHTML=dp),Bo=o(e),qt=r(e,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-10j71zn"&&(qt.innerHTML=mp),Zo=o(e),St=r(e,"UL",{"data-svelte-h":!0}),s(St)!=="svelte-1vpn2ms"&&(St.innerHTML=fp),Qo=o(e),Gt=r(e,"P",{"data-svelte-h":!0}),s(Gt)!=="svelte-gmncyo"&&(Gt.innerHTML=Mp),Eo=o(e),d(Vt.$$.fragment,e),Wo=o(e),Xt=r(e,"P",{"data-svelte-h":!0}),s(Xt)!=="svelte-zfbl8p"&&(Xt.innerHTML=vp),Do=o(e),d(Yt.$$.fragment,e),Ro=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-bxzo98"&&(Ft.textContent=gp),qo=o(e),d(Ot.$$.fragment,e),So=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-msvb9t"&&(Kt.textContent=hp),Go=o(e),d(ei.$$.fragment,e),Vo=o(e),ti=r(e,"P",{"data-svelte-h":!0}),s(ti)!=="svelte-1t1y1q3"&&(ti.textContent=Tp),Xo=o(e),d(ii.$$.fragment,e),Yo=o(e),li=r(e,"P",{"data-svelte-h":!0}),s(li)!=="svelte-2gi4z2"&&(li.innerHTML=wp),Fo=o(e),d(ni.$$.fragment,e),Oo=o(e),oi=r(e,"P",{"data-svelte-h":!0}),s(oi)!=="svelte-17998hi"&&(oi.innerHTML=yp),Ko=o(e),d(ai.$$.fragment,e),ea=o(e),ri=r(e,"P",{"data-svelte-h":!0}),s(ri)!=="svelte-1lzjagf"&&(ri.textContent=bp),ta=o(e),d(si.$$.fragment,e),ia=o(e),pi=r(e,"P",{"data-svelte-h":!0}),s(pi)!=="svelte-1e4mgvb"&&(pi.textContent=Cp),la=o(e),ci=r(e,"P",{"data-svelte-h":!0}),s(ci)!=="svelte-1fia2hr"&&(ci.innerHTML=Jp),na=o(e),ui=r(e,"P",{"data-svelte-h":!0}),s(ui)!=="svelte-1vr2avi"&&(ui.innerHTML=jp),oa=o(e),di=r(e,"P",{"data-svelte-h":!0}),s(di)!=="svelte-1t5012"&&(di.innerHTML=Up),aa=o(e),d(mi.$$.fragment,e),ra=o(e),fi=r(e,"P",{"data-svelte-h":!0}),s(fi)!=="svelte-9hyeti"&&(fi.innerHTML=_p),sa=o(e),Mi=r(e,"P",{"data-svelte-h":!0}),s(Mi)!=="svelte-11qu2xd"&&(Mi.innerHTML=kp),pa=o(e),d(vi.$$.fragment,e),ca=o(e),gi=r(e,"P",{"data-svelte-h":!0}),s(gi)!=="svelte-6sq3ph"&&(gi.innerHTML=Ip),ua=o(e),hi=r(e,"P",{"data-svelte-h":!0}),s(hi)!=="svelte-13khp56"&&(hi.innerHTML=Lp),da=o(e),Ti=r(e,"UL",{"data-svelte-h":!0}),s(Ti)!=="svelte-rkz3oc"&&(Ti.innerHTML=zp),ma=o(e),wi=r(e,"P",{"data-svelte-h":!0}),s(wi)!=="svelte-1okwk4r"&&(wi.innerHTML=$p),fa=o(e),yi=r(e,"P",{"data-svelte-h":!0}),s(yi)!=="svelte-1wms3g3"&&(yi.innerHTML=xp),Ma=o(e),bi=r(e,"P",{"data-svelte-h":!0}),s(bi)!=="svelte-i0maob"&&(bi.innerHTML=Ap),va=o(e),Ci=r(e,"P",{"data-svelte-h":!0}),s(Ci)!=="svelte-1c7vfm0"&&(Ci.innerHTML=Hp),ga=o(e),d(Ji.$$.fragment,e),ha=o(e),ji=r(e,"P",{"data-svelte-h":!0}),s(ji)!=="svelte-8sms8k"&&(ji.textContent=Np),Ta=o(e),Ui=r(e,"UL",{"data-svelte-h":!0}),s(Ui)!=="svelte-1utz3yu"&&(Ui.innerHTML=Pp),wa=o(e),_i=r(e,"P",{"data-svelte-h":!0}),s(_i)!=="svelte-1xufcow"&&(_i.innerHTML=Bp),ya=o(e),d(ki.$$.fragment,e),ba=o(e),d(Y.$$.fragment,e),Ca=o(e),Ii=r(e,"P",{"data-svelte-h":!0}),s(Ii)!=="svelte-1dvwjty"&&(Ii.innerHTML=Zp),Ja=o(e),Li=r(e,"UL",{"data-svelte-h":!0}),s(Li)!=="svelte-vlkyi5"&&(Li.innerHTML=Qp),ja=o(e),zi=r(e,"P",{"data-svelte-h":!0}),s(zi)!=="svelte-ngul8x"&&(zi.innerHTML=Ep),Ua=o(e),$i=r(e,"P",{"data-svelte-h":!0}),s($i)!=="svelte-ytxoz9"&&($i.innerHTML=Wp),_a=o(e),xi=r(e,"P",{"data-svelte-h":!0}),s(xi)!=="svelte-sdkk44"&&(xi.textContent=Dp),ka=o(e),Ai=r(e,"P",{"data-svelte-h":!0}),s(Ai)!=="svelte-ohw0y7"&&(Ai.innerHTML=Rp),Ia=o(e),d(Hi.$$.fragment,e),La=o(e),Ni=r(e,"P",{"data-svelte-h":!0}),s(Ni)!=="svelte-1yo29jy"&&(Ni.innerHTML=qp),za=o(e),d(Pi.$$.fragment,e),$a=o(e),Bi=r(e,"P",{"data-svelte-h":!0}),s(Bi)!=="svelte-dj5zaz"&&(Bi.innerHTML=Sp),xa=o(e),Zi=r(e,"P",{"data-svelte-h":!0}),s(Zi)!=="svelte-1xqbzg9"&&(Zi.innerHTML=Gp),Aa=o(e),Qi=r(e,"P",{"data-svelte-h":!0}),s(Qi)!=="svelte-1yq64p9"&&(Qi.innerHTML=Vp),Ha=o(e),Ei=r(e,"P",{"data-svelte-h":!0}),s(Ei)!=="svelte-1somwnj"&&(Ei.innerHTML=Xp),Na=o(e),Wi=r(e,"P",{"data-svelte-h":!0}),s(Wi)!=="svelte-1eolzno"&&(Wi.innerHTML=Yp),Pa=o(e),Di=r(e,"P",{"data-svelte-h":!0}),s(Di)!=="svelte-vibpxl"&&(Di.innerHTML=Fp),Ba=o(e),Ri=r(e,"P",{"data-svelte-h":!0}),s(Ri)!=="svelte-1nt2o60"&&(Ri.innerHTML=Op),Za=o(e),qi=r(e,"P",{"data-svelte-h":!0}),s(qi)!=="svelte-17ikozp"&&(qi.innerHTML=Kp),Qa=o(e),Si=r(e,"P",{"data-svelte-h":!0}),s(Si)!=="svelte-17h78jd"&&(Si.innerHTML=ec),Ea=o(e),d(Gi.$$.fragment,e),Wa=o(e),Vi=r(e,"P",{"data-svelte-h":!0}),s(Vi)!=="svelte-168a2an"&&(Vi.textContent=tc),Da=o(e),d(Xi.$$.fragment,e),Ra=o(e),Yi=r(e,"P",{"data-svelte-h":!0}),s(Yi)!=="svelte-13nuxd8"&&(Yi.textContent=ic),qa=o(e),Fi=r(e,"P",{"data-svelte-h":!0}),s(Fi)!=="svelte-18k5kow"&&(Fi.textContent=lc),Sa=o(e),Oi=r(e,"P",{"data-svelte-h":!0}),s(Oi)!=="svelte-1ftaoot"&&(Oi.textContent=nc),Ga=o(e),Ki=r(e,"P",{"data-svelte-h":!0}),s(Ki)!=="svelte-1iv4oh1"&&(Ki.innerHTML=oc),Va=o(e),el=r(e,"P",{"data-svelte-h":!0}),s(el)!=="svelte-bo6tk8"&&(el.innerHTML=ac),Xa=o(e),d(tl.$$.fragment,e),Ya=o(e),il=r(e,"P",{"data-svelte-h":!0}),s(il)!=="svelte-6hjvqd"&&(il.innerHTML=rc),Fa=o(e),ll=r(e,"P",{"data-svelte-h":!0}),s(ll)!=="svelte-1xvbv99"&&(ll.innerHTML=sc),Oa=o(e),nl=r(e,"P",{"data-svelte-h":!0}),s(nl)!=="svelte-wwq3kk"&&(nl.innerHTML=pc),Ka=o(e),ol=r(e,"P",{"data-svelte-h":!0}),s(ol)!=="svelte-1s6evuy"&&(ol.innerHTML=cc),er=o(e),al=r(e,"P",{"data-svelte-h":!0}),s(al)!=="svelte-1d6fg3c"&&(al.textContent=uc),tr=o(e),$=r(e,"H3",{class:!0});var Mr=g($);F=r(Mr,"A",{id:!0,class:!0,href:!0});var Hc=g(F);Al=r(Hc,"SPAN",{});var Nc=g(Al);d(rl.$$.fragment,Nc),Nc.forEach(i),Hc.forEach(i),Ur=o(Mr),Cl=r(Mr,"SPAN",{"data-svelte-h":!0}),s(Cl)!=="svelte-rwe89k"&&(Cl.textContent=dc),Mr.forEach(i),ir=o(e),sl=r(e,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-1wuu6xv"&&(sl.textContent=mc),lr=o(e),pl=r(e,"P",{"data-svelte-h":!0}),s(pl)!=="svelte-1oczpay"&&(pl.innerHTML=fc),nr=o(e),Hl=r(e,"P",{}),g(Hl).forEach(i),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",JSON.stringify(Gc)),p(x,"id","come-aggiungere-un-modello-a-transformers"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#come-aggiungere-un-modello-a-transformers"),p(b,"class","relative group"),p(A,"id","panoramica-generale-su-transformers"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#panoramica-generale-su-transformers"),p(C,"class","relative group"),p(H,"id","panoramica-sui-modelli"),p(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(H,"href","#panoramica-sui-modelli"),p(J,"class","relative group"),Bc(Ml.src,Dr="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||p(Ml,"src",Dr),p(N,"id","stile-per-il-codice"),p(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(N,"href","#stile-per-il-codice"),p(j,"class","relative group"),p(P,"id","panoramica-sui-tokenizers"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#panoramica-sui-tokenizers"),p(U,"class","relative group"),p(B,"id","aggiungere-un-modello-a-transformers-passo-dopo-passo"),p(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(B,"href","#aggiungere-un-modello-a-transformers-passo-dopo-passo"),p(_,"class","relative group"),p(Z,"id","1-opzionale-aspetti-teorici-di-brandnewbert"),p(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Z,"href","#1-opzionale-aspetti-teorici-di-brandnewbert"),p(k,"class","relative group"),p(Q,"id","2-prepare-il-tuo-ambiente"),p(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Q,"href","#2-prepare-il-tuo-ambiente"),p(I,"class","relative group"),p(E,"start","3"),p(W,"start","4"),p(D,"start","5"),p(R,"id","34-provare-un-pretrained-checkpoint-usando-la-repo-originale"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#34-provare-un-pretrained-checkpoint-usando-la-repo-originale"),p(L,"class","relative group"),p(q,"id","514-trasferire-brandnewbert-in-transformers"),p(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(q,"href","#514-trasferire-brandnewbert-in-transformers"),p(z,"class","relative group"),p(S,"start","2"),p(G,"start","3"),p(V,"start","4"),p(X,"start","5"),p(F,"id","condividete-il-vostro-lavoro"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#condividete-il-vostro-lavoro"),p($,"class","relative group")},m(e,t){c(document.head,T),l(e,O,t),l(e,w,t),l(e,ul,t),l(e,b,t),c(b,x),c(x,Jl),m(K,Jl,null),c(b,vr),c(b,dl),l(e,Pl,t),l(e,ee,t),l(e,Bl,t),l(e,te,t),l(e,Zl,t),l(e,ie,t),l(e,Ql,t),l(e,le,t),l(e,El,t),l(e,ne,t),l(e,Wl,t),l(e,oe,t),l(e,Dl,t),l(e,C,t),c(C,A),c(A,jl),m(ae,jl,null),c(C,gr),c(C,ml),l(e,Rl,t),l(e,re,t),l(e,ql,t),l(e,se,t),l(e,Sl,t),l(e,pe,t),l(e,Gl,t),l(e,ce,t),l(e,Vl,t),l(e,ue,t),l(e,Xl,t),l(e,J,t),c(J,H),c(H,Ul),m(de,Ul,null),c(J,hr),c(J,fl),l(e,Yl,t),l(e,me,t),l(e,Fl,t),l(e,fe,t),l(e,Ol,t),l(e,Ml,t),l(e,Kl,t),l(e,Me,t),l(e,en,t),m(ve,e,t),l(e,tn,t),l(e,ge,t),l(e,ln,t),l(e,j,t),c(j,N),c(N,_l),m(he,_l,null),c(j,Tr),c(j,vl),l(e,nn,t),l(e,Te,t),l(e,on,t),l(e,we,t),l(e,an,t),l(e,U,t),c(U,P),c(P,kl),m(ye,kl,null),c(U,wr),c(U,gl),l(e,rn,t),l(e,be,t),l(e,sn,t),l(e,_,t),c(_,B),c(B,Il),m(Ce,Il,null),c(_,yr),c(_,hl),l(e,pn,t),l(e,Je,t),l(e,cn,t),l(e,je,t),l(e,un,t),l(e,Ue,t),l(e,dn,t),l(e,_e,t),l(e,mn,t),l(e,ke,t),l(e,fn,t),l(e,Ie,t),l(e,Mn,t),l(e,Le,t),l(e,vn,t),l(e,ze,t),l(e,gn,t),l(e,k,t),c(k,Z),c(Z,Ll),m($e,Ll,null),c(k,br),c(k,Tl),l(e,hn,t),l(e,xe,t),l(e,Tn,t),l(e,Ae,t),l(e,wn,t),l(e,He,t),l(e,yn,t),l(e,I,t),c(I,Q),c(Q,zl),m(Ne,zl,null),c(I,Cr),c(I,wl),l(e,bn,t),l(e,Pe,t),l(e,Cn,t),m(Be,e,t),l(e,Jn,t),l(e,E,t),l(e,jn,t),m(Ze,e,t),l(e,Un,t),l(e,Qe,t),l(e,_n,t),m(Ee,e,t),l(e,kn,t),l(e,W,t),l(e,In,t),l(e,We,t),l(e,Ln,t),l(e,D,t),l(e,zn,t),m(De,e,t),l(e,$n,t),l(e,Re,t),l(e,xn,t),l(e,L,t),c(L,R),c(R,$l),m(qe,$l,null),c(L,Jr),c(L,yl),l(e,An,t),l(e,Se,t),l(e,Hn,t),l(e,Ge,t),l(e,Nn,t),l(e,Ve,t),l(e,Pn,t),l(e,Xe,t),l(e,Bn,t),l(e,Ye,t),l(e,Zn,t),l(e,Fe,t),l(e,Qn,t),l(e,Oe,t),l(e,En,t),l(e,Ke,t),l(e,Wn,t),l(e,et,t),l(e,Dn,t),l(e,tt,t),l(e,Rn,t),m(it,e,t),l(e,qn,t),l(e,lt,t),l(e,Sn,t),l(e,nt,t),l(e,Gn,t),l(e,ot,t),l(e,Vn,t),l(e,at,t),l(e,Xn,t),l(e,rt,t),l(e,Yn,t),l(e,st,t),l(e,Fn,t),l(e,pt,t),l(e,On,t),l(e,ct,t),l(e,Kn,t),l(e,ut,t),l(e,eo,t),l(e,dt,t),l(e,to,t),l(e,mt,t),l(e,io,t),m(ft,e,t),l(e,lo,t),l(e,Mt,t),l(e,no,t),l(e,vt,t),l(e,oo,t),l(e,gt,t),l(e,ao,t),l(e,z,t),c(z,q),c(q,xl),m(ht,xl,null),c(z,jr),c(z,bl),l(e,ro,t),l(e,Tt,t),l(e,so,t),m(wt,e,t),l(e,po,t),l(e,yt,t),l(e,co,t),l(e,bt,t),l(e,uo,t),l(e,Ct,t),l(e,mo,t),l(e,Jt,t),l(e,fo,t),l(e,jt,t),l(e,Mo,t),l(e,Ut,t),l(e,vo,t),l(e,_t,t),l(e,go,t),l(e,kt,t),l(e,ho,t),m(It,e,t),l(e,To,t),l(e,S,t),l(e,wo,t),m(Lt,e,t),l(e,yo,t),l(e,G,t),l(e,bo,t),m(zt,e,t),l(e,Co,t),l(e,V,t),l(e,Jo,t),m($t,e,t),l(e,jo,t),l(e,X,t),l(e,Uo,t),l(e,xt,t),l(e,_o,t),m(At,e,t),l(e,ko,t),l(e,Ht,t),l(e,Io,t),l(e,Nt,t),l(e,Lo,t),l(e,Pt,t),l(e,zo,t),l(e,Bt,t),l(e,$o,t),l(e,Zt,t),l(e,xo,t),l(e,Qt,t),l(e,Ao,t),l(e,Et,t),l(e,Ho,t),m(Wt,e,t),l(e,No,t),l(e,Dt,t),l(e,Po,t),l(e,Rt,t),l(e,Bo,t),l(e,qt,t),l(e,Zo,t),l(e,St,t),l(e,Qo,t),l(e,Gt,t),l(e,Eo,t),m(Vt,e,t),l(e,Wo,t),l(e,Xt,t),l(e,Do,t),m(Yt,e,t),l(e,Ro,t),l(e,Ft,t),l(e,qo,t),m(Ot,e,t),l(e,So,t),l(e,Kt,t),l(e,Go,t),m(ei,e,t),l(e,Vo,t),l(e,ti,t),l(e,Xo,t),m(ii,e,t),l(e,Yo,t),l(e,li,t),l(e,Fo,t),m(ni,e,t),l(e,Oo,t),l(e,oi,t),l(e,Ko,t),m(ai,e,t),l(e,ea,t),l(e,ri,t),l(e,ta,t),m(si,e,t),l(e,ia,t),l(e,pi,t),l(e,la,t),l(e,ci,t),l(e,na,t),l(e,ui,t),l(e,oa,t),l(e,di,t),l(e,aa,t),m(mi,e,t),l(e,ra,t),l(e,fi,t),l(e,sa,t),l(e,Mi,t),l(e,pa,t),m(vi,e,t),l(e,ca,t),l(e,gi,t),l(e,ua,t),l(e,hi,t),l(e,da,t),l(e,Ti,t),l(e,ma,t),l(e,wi,t),l(e,fa,t),l(e,yi,t),l(e,Ma,t),l(e,bi,t),l(e,va,t),l(e,Ci,t),l(e,ga,t),m(Ji,e,t),l(e,ha,t),l(e,ji,t),l(e,Ta,t),l(e,Ui,t),l(e,wa,t),l(e,_i,t),l(e,ya,t),m(ki,e,t),l(e,ba,t),m(Y,e,t),l(e,Ca,t),l(e,Ii,t),l(e,Ja,t),l(e,Li,t),l(e,ja,t),l(e,zi,t),l(e,Ua,t),l(e,$i,t),l(e,_a,t),l(e,xi,t),l(e,ka,t),l(e,Ai,t),l(e,Ia,t),m(Hi,e,t),l(e,La,t),l(e,Ni,t),l(e,za,t),m(Pi,e,t),l(e,$a,t),l(e,Bi,t),l(e,xa,t),l(e,Zi,t),l(e,Aa,t),l(e,Qi,t),l(e,Ha,t),l(e,Ei,t),l(e,Na,t),l(e,Wi,t),l(e,Pa,t),l(e,Di,t),l(e,Ba,t),l(e,Ri,t),l(e,Za,t),l(e,qi,t),l(e,Qa,t),l(e,Si,t),l(e,Ea,t),m(Gi,e,t),l(e,Wa,t),l(e,Vi,t),l(e,Da,t),m(Xi,e,t),l(e,Ra,t),l(e,Yi,t),l(e,qa,t),l(e,Fi,t),l(e,Sa,t),l(e,Oi,t),l(e,Ga,t),l(e,Ki,t),l(e,Va,t),l(e,el,t),l(e,Xa,t),m(tl,e,t),l(e,Ya,t),l(e,il,t),l(e,Fa,t),l(e,ll,t),l(e,Oa,t),l(e,nl,t),l(e,Ka,t),l(e,ol,t),l(e,er,t),l(e,al,t),l(e,tr,t),l(e,$,t),c($,F),c(F,Al),m(rl,Al,null),c($,Ur),c($,Cl),l(e,ir,t),l(e,sl,t),l(e,lr,t),l(e,pl,t),l(e,nr,t),l(e,Hl,t),or=!0},p(e,[t]){const cl={};t&2&&(cl.$$scope={dirty:t,ctx:e}),Y.$set(cl)},i(e){or||(f(K.$$.fragment,e),f(ae.$$.fragment,e),f(de.$$.fragment,e),f(ve.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(Ne.$$.fragment,e),f(Be.$$.fragment,e),f(Ze.$$.fragment,e),f(Ee.$$.fragment,e),f(De.$$.fragment,e),f(qe.$$.fragment,e),f(it.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(wt.$$.fragment,e),f(It.$$.fragment,e),f(Lt.$$.fragment,e),f(zt.$$.fragment,e),f($t.$$.fragment,e),f(At.$$.fragment,e),f(Wt.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(Ot.$$.fragment,e),f(ei.$$.fragment,e),f(ii.$$.fragment,e),f(ni.$$.fragment,e),f(ai.$$.fragment,e),f(si.$$.fragment,e),f(mi.$$.fragment,e),f(vi.$$.fragment,e),f(Ji.$$.fragment,e),f(ki.$$.fragment,e),f(Y.$$.fragment,e),f(Hi.$$.fragment,e),f(Pi.$$.fragment,e),f(Gi.$$.fragment,e),f(Xi.$$.fragment,e),f(tl.$$.fragment,e),f(rl.$$.fragment,e),or=!0)},o(e){M(K.$$.fragment,e),M(ae.$$.fragment,e),M(de.$$.fragment,e),M(ve.$$.fragment,e),M(he.$$.fragment,e),M(ye.$$.fragment,e),M(Ce.$$.fragment,e),M($e.$$.fragment,e),M(Ne.$$.fragment,e),M(Be.$$.fragment,e),M(Ze.$$.fragment,e),M(Ee.$$.fragment,e),M(De.$$.fragment,e),M(qe.$$.fragment,e),M(it.$$.fragment,e),M(ft.$$.fragment,e),M(ht.$$.fragment,e),M(wt.$$.fragment,e),M(It.$$.fragment,e),M(Lt.$$.fragment,e),M(zt.$$.fragment,e),M($t.$$.fragment,e),M(At.$$.fragment,e),M(Wt.$$.fragment,e),M(Vt.$$.fragment,e),M(Yt.$$.fragment,e),M(Ot.$$.fragment,e),M(ei.$$.fragment,e),M(ii.$$.fragment,e),M(ni.$$.fragment,e),M(ai.$$.fragment,e),M(si.$$.fragment,e),M(mi.$$.fragment,e),M(vi.$$.fragment,e),M(Ji.$$.fragment,e),M(ki.$$.fragment,e),M(Y.$$.fragment,e),M(Hi.$$.fragment,e),M(Pi.$$.fragment,e),M(Gi.$$.fragment,e),M(Xi.$$.fragment,e),M(tl.$$.fragment,e),M(rl.$$.fragment,e),or=!1},d(e){e&&(i(O),i(w),i(ul),i(b),i(Pl),i(ee),i(Bl),i(te),i(Zl),i(ie),i(Ql),i(le),i(El),i(ne),i(Wl),i(oe),i(Dl),i(C),i(Rl),i(re),i(ql),i(se),i(Sl),i(pe),i(Gl),i(ce),i(Vl),i(ue),i(Xl),i(J),i(Yl),i(me),i(Fl),i(fe),i(Ol),i(Ml),i(Kl),i(Me),i(en),i(tn),i(ge),i(ln),i(j),i(nn),i(Te),i(on),i(we),i(an),i(U),i(rn),i(be),i(sn),i(_),i(pn),i(Je),i(cn),i(je),i(un),i(Ue),i(dn),i(_e),i(mn),i(ke),i(fn),i(Ie),i(Mn),i(Le),i(vn),i(ze),i(gn),i(k),i(hn),i(xe),i(Tn),i(Ae),i(wn),i(He),i(yn),i(I),i(bn),i(Pe),i(Cn),i(Jn),i(E),i(jn),i(Un),i(Qe),i(_n),i(kn),i(W),i(In),i(We),i(Ln),i(D),i(zn),i($n),i(Re),i(xn),i(L),i(An),i(Se),i(Hn),i(Ge),i(Nn),i(Ve),i(Pn),i(Xe),i(Bn),i(Ye),i(Zn),i(Fe),i(Qn),i(Oe),i(En),i(Ke),i(Wn),i(et),i(Dn),i(tt),i(Rn),i(qn),i(lt),i(Sn),i(nt),i(Gn),i(ot),i(Vn),i(at),i(Xn),i(rt),i(Yn),i(st),i(Fn),i(pt),i(On),i(ct),i(Kn),i(ut),i(eo),i(dt),i(to),i(mt),i(io),i(lo),i(Mt),i(no),i(vt),i(oo),i(gt),i(ao),i(z),i(ro),i(Tt),i(so),i(po),i(yt),i(co),i(bt),i(uo),i(Ct),i(mo),i(Jt),i(fo),i(jt),i(Mo),i(Ut),i(vo),i(_t),i(go),i(kt),i(ho),i(To),i(S),i(wo),i(yo),i(G),i(bo),i(Co),i(V),i(Jo),i(jo),i(X),i(Uo),i(xt),i(_o),i(ko),i(Ht),i(Io),i(Nt),i(Lo),i(Pt),i(zo),i(Bt),i($o),i(Zt),i(xo),i(Qt),i(Ao),i(Et),i(Ho),i(No),i(Dt),i(Po),i(Rt),i(Bo),i(qt),i(Zo),i(St),i(Qo),i(Gt),i(Eo),i(Wo),i(Xt),i(Do),i(Ro),i(Ft),i(qo),i(So),i(Kt),i(Go),i(Vo),i(ti),i(Xo),i(Yo),i(li),i(Fo),i(Oo),i(oi),i(Ko),i(ea),i(ri),i(ta),i(ia),i(pi),i(la),i(ci),i(na),i(ui),i(oa),i(di),i(aa),i(ra),i(fi),i(sa),i(Mi),i(pa),i(ca),i(gi),i(ua),i(hi),i(da),i(Ti),i(ma),i(wi),i(fa),i(yi),i(Ma),i(bi),i(va),i(Ci),i(ga),i(ha),i(ji),i(Ta),i(Ui),i(wa),i(_i),i(ya),i(ba),i(Ca),i(Ii),i(Ja),i(Li),i(ja),i(zi),i(Ua),i($i),i(_a),i(xi),i(ka),i(Ai),i(Ia),i(La),i(Ni),i(za),i($a),i(Bi),i(xa),i(Zi),i(Aa),i(Qi),i(Ha),i(Ei),i(Na),i(Wi),i(Pa),i(Di),i(Ba),i(Ri),i(Za),i(qi),i(Qa),i(Si),i(Ea),i(Wa),i(Vi),i(Da),i(Ra),i(Yi),i(qa),i(Fi),i(Sa),i(Oi),i(Ga),i(Ki),i(Va),i(el),i(Xa),i(Ya),i(il),i(Fa),i(ll),i(Oa),i(nl),i(Ka),i(ol),i(er),i(al),i(tr),i($),i(ir),i(sl),i(lr),i(pl),i(nr),i(Hl)),i(T),v(K),v(ae),v(de),v(ve,e),v(he),v(ye),v(Ce),v($e),v(Ne),v(Be,e),v(Ze,e),v(Ee,e),v(De,e),v(qe),v(it,e),v(ft,e),v(ht),v(wt,e),v(It,e),v(Lt,e),v(zt,e),v($t,e),v(At,e),v(Wt,e),v(Vt,e),v(Yt,e),v(Ot,e),v(ei,e),v(ii,e),v(ni,e),v(ai,e),v(si,e),v(mi,e),v(vi,e),v(Ji,e),v(ki,e),v(Y,e),v(Hi,e),v(Pi,e),v(Gi,e),v(Xi,e),v(tl,e),v(rl)}}}const Gc={local:"come-aggiungere-un-modello-a-transformers",sections:[{local:"panoramica-generale-su-transformers",sections:[{local:"panoramica-sui-modelli",title:"Panoramica sui modelli"},{local:"stile-per-il-codice",title:"Stile per il codice"},{local:"panoramica-sui-tokenizers",title:"Panoramica sui tokenizers"}],title:"Panoramica generale su 🤗 Transformers"},{local:"aggiungere-un-modello-a-transformers-passo-dopo-passo",sections:[{local:"1-opzionale-aspetti-teorici-di-brandnewbert",title:"1. (Opzionale) Aspetti teorici di BrandNewBert "},{local:"2-prepare-il-tuo-ambiente",title:"2. Prepare il tuo ambiente"},{local:"34-provare-un-pretrained-checkpoint-usando-la-repo-originale",title:"3.-4. Provare un pretrained checkpoint usando la repo originale "},{local:"514-trasferire-brandnewbert-in-transformers",title:"5.-14. Trasferire BrandNewBert in 🤗 Transformers"},{local:"condividete-il-vostro-lavoro",title:"Condividete il vostro lavoro!!"}],title:"Aggiungere un modello a 🤗 Transformers passo dopo passo "}],title:"Come aggiungere un modello a 🤗 Transformers?"};function Vc(Nl){return Zc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class eu extends Ec{constructor(T){super(),Wc(this,T,Vc,Sc,Pc,{})}}export{eu as component};
