import{s as pl,n as ol,o as rl}from"../chunks/scheduler.36a0863c.js";import{S as cl,i as dl,g as i,s as a,u as d,A as Ml,h as p,f as s,c as n,j as M,v as u,y as o,k as r,o as c,a as t,w as m,d as y,t as J,x as w}from"../chunks/index.d0f7a4c4.js";import{I as ws}from"../chunks/IconCopyLink.bc5fad79.js";import{C as T}from"../chunks/CodeBlock.4236768d.js";function ul(Us){let j,Ie,Te,ge,h,I,je,_,Ts,me,bs="Come creare una pipeline personalizzata?",Be,v,Is=`In questa guida, scopriremo come creare una pipeline personalizzata e condividerla sull’ <a href="hf.co/models">Hub</a> o aggiungerla nella libreria
Transformers.`,Ce,k,gs=`Innanzitutto, è necessario decidere gli input grezzi che la pipeline sarà in grado di accettare. Possono essere strings, raw bytes,
dictionaries o qualsiasi cosa sia l’input desiderato più probabile. Cerca di mantenere questi input il più possibile in Python
in quanto facilita la compatibilità (anche con altri linguaggi tramite JSON). Questi saranno gli <code>inputs</code> della
pipeline (<code>preprocess</code>).`,_e,Z,Bs=`Poi definire gli <code>outputs</code>. Stessa strategia degli <code>inputs</code>. Più è seplice e meglio è. Questi saranno gli output del metodo
<code>postprocess</code>.`,ve,z,Cs=`Si parte ereditando la classe base <code>Pipeline</code>. con i 4 metodi che bisogna implementare <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code> e <code>_sanitize_parameters</code>.`,ke,A,Ze,G,_s=`La struttura di questa suddivisione consiste nel supportare in modo relativamente continuo CPU/GPU, supportando allo stesso tempo l’esecuzione di
pre/postelaborazione sulla CPU su thread diversi.`,ze,q,vs=`<code>preprocess</code> prenderà gli input originariamente definiti e li trasformerà in qualcosa di alimentabile dal modello. Potrebbe
contenere più informazioni e di solito è un <code>Dict</code>.`,Ae,N,ks=`<code>_forward</code> è il dettaglio dell’implementazione e non è destinato a essere chiamato direttamente. <code>forward</code> è il metodo preferito per assicurarsi che tutto funzioni correttamente perchè contiene delle slavaguardie. Se qualcosa è
è collegato a un modello reale, appartiene al metodo <code>_forward</code>, tutto il resto è nel preprocess/postprocess.`,Ge,H,Zs="<code>postprocess</code> prende l’otput di <code>_forward</code> e lo trasforma nell’output finale che era stato deciso in precedenza.",qe,V,zs="<code>_sanitize_parameters</code> esiste per consentire agli utenti di passare i parametri ogni volta che desiderano sia a inizialization time <code>pipeline(...., maybe_arg=4)</code> che al call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.",Ne,X,As=`<code>_sanitize_parameters</code> ritorna 3 dicts di kwargs che vengono passati direttamente a <code>preprocess</code>,
<code>_forward</code> e <code>postprocess</code>. Non riempire nulla se il chiamante non ha chiamato con alcun parametro aggiuntivo. Questo
consente di mantenere gli argomenti predefiniti nella definizione della funzione, che è sempre più “naturale”.`,He,W,Gs="Un esempio classico potrebbe essere l’argomento <code>top_k</code> nel post processing dei classification tasks.",Ve,R,Xe,E,qs=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,We,x,Re,$,Ns=`Cercare di mantenere gli input/output molto semplici e idealmente serializzabili in JSON, in quanto ciò rende l’uso della pipeline molto facile
senza richiedere agli utenti di comprendere nuovi tipi di oggetti. È anche relativamente comune supportare molti tipi di argomenti
per facilitarne l’uso (ad esempio file audio, possono essere nomi di file, URL o byte puri).`,Ee,f,g,he,Y,js,ye,Hs="Aggiungilo alla lista dei tasks supportati",xe,Q,Vs="Per registrar il tuo <code>new-task</code> alla lista dei tasks supportati, devi aggiungerlo al <code>PIPELINE_REGISTRY</code>:",$e,S,Ye,F,Xs="Puoi specificare il modello di default che desideri, in questo caso dovrebbe essere accompagnato da una revisione specifica (che può essere il nome di un branch o l’hash di un commit, in questo caso abbiamo preso <code>&quot;abcdef&quot;</code>) e anche dal type:",Qe,P,Se,U,B,fe,L,hs,Je,Ws="Condividi la tua pipeline sull'Hub",Fe,K,Rs=`Per condividere la tua pipeline personalizzata sull’Hub, devi solo salvare il codice della tua sottoclasse <code>Pipeline</code> in un file
python. Per esempio, supponiamo di voler utilizzare una pipeline personalizzata per la classificazione delle coppie di frasi come la seguente:`,Pe,D,Le,O,Es="L’implementazione è agnostica al framework, e lavorerà sia con modelli PyTorch che con TensorFlow. Se l’abbiamo salvato in un file chiamato <code>pair_classification.py</code>, può essere successivamente importato e registrato in questo modo:",Ke,ee,De,se,xs=`Una volta fatto, possiamo usarla con un modello pretrained. L’istanza <code>sgugger/finetuned-bert-mrpc</code> è stata
fine-tuned sul dataset MRPC, che classifica le coppie di frasi come parafrasi o no.`,Oe,le,es,te,$s="Successivamente possiamo condividerlo sull’Hub usando il metodo <code>save_pretrained</code> in un <code>Repository</code>:",ss,ae,ls,ne,Ys=`Questo codice copierà il file dove è stato definitp <code>PairClassificationPipeline</code> all’interno della cartella <code>&quot;test-dynamic-pipeline&quot;</code>,
insieme al salvataggio del modello e del tokenizer della pipeline, prima di pushare il tutto nel repository
<code>{your_username}/test-dynamic-pipeline</code>. Dopodiché chiunque potrà utilizzarlo, purché fornisca l’opzione
<code>trust_remote_code=True</code>:`,ts,ie,as,b,C,Ue,pe,fs,we,Qs="Aggiungere la pipeline a Transformers",ns,oe,Ss=`Se vuoi contribuire con la tua pipeline a Transformers, dovrai aggiungere un modulo nel sottomodulo <code>pipelines</code>
con il codice della tua pipeline, quindi aggiungilo all’elenco dei tasks definiti in <code>pipelines/__init__.py</code>.`,is,re,Fs="Poi hai bisogno di aggiungere i test. Crea un nuovo file <code>tests/test_pipelines_MY_PIPELINE.py</code> con esempi ed altri test.",ps,ce,Ps=`La funzione <code>run_pipeline_test</code> sarà molto generica e su piccoli modelli casuali su ogni possibile
architettura, come definito da <code>model_mapping</code> e <code>tf_model_mapping</code>.`,os,de,Ls=`Questo è molto importante per testare la compatibilità futura, nel senso che se qualcuno aggiunge un nuovo modello di
<code>XXXForQuestionAnswering</code> allora il test della pipeline tenterà di essere eseguito su di esso. Poiché i modelli sono casuali, è
è impossibile controllare i valori effettivi, per questo esiste un aiuto <code>ANY</code> che tenterà solamente di far corrispondere l’output della pipeline TYPE.`,rs,Me,Ks="Hai anche <em>bisogno</em> di implementare 2 (idealmente 4) test.",cs,ue,Ds=`<li><code>test_small_model_pt</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi che non ci siano  derive nelle versioni future</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi
che non ci siano derive nelle versioni future</li>`,ds,be,Ms;return _=new ws({}),A=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),R=new T({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),x=new T({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),Y=new ws({}),S=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),P=new T({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),L=new ws({}),D=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),ee=new T({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),le=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),ae=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`,wrap:!1}}),ie=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),pe=new ws({}),{c(){j=i("meta"),Ie=a(),Te=i("p"),ge=a(),h=i("h1"),I=i("a"),je=i("span"),d(_.$$.fragment),Ts=a(),me=i("span"),me.textContent=bs,Be=a(),v=i("p"),v.innerHTML=Is,Ce=a(),k=i("p"),k.innerHTML=gs,_e=a(),Z=i("p"),Z.innerHTML=Bs,ve=a(),z=i("p"),z.innerHTML=Cs,ke=a(),d(A.$$.fragment),Ze=a(),G=i("p"),G.textContent=_s,ze=a(),q=i("p"),q.innerHTML=vs,Ae=a(),N=i("p"),N.innerHTML=ks,Ge=a(),H=i("p"),H.innerHTML=Zs,qe=a(),V=i("p"),V.innerHTML=zs,Ne=a(),X=i("p"),X.innerHTML=As,He=a(),W=i("p"),W.innerHTML=Gs,Ve=a(),d(R.$$.fragment),Xe=a(),E=i("p"),E.innerHTML=qs,We=a(),d(x.$$.fragment),Re=a(),$=i("p"),$.textContent=Ns,Ee=a(),f=i("h2"),g=i("a"),he=i("span"),d(Y.$$.fragment),js=a(),ye=i("span"),ye.textContent=Hs,xe=a(),Q=i("p"),Q.innerHTML=Vs,$e=a(),d(S.$$.fragment),Ye=a(),F=i("p"),F.innerHTML=Xs,Qe=a(),d(P.$$.fragment),Se=a(),U=i("h2"),B=i("a"),fe=i("span"),d(L.$$.fragment),hs=a(),Je=i("span"),Je.textContent=Ws,Fe=a(),K=i("p"),K.innerHTML=Rs,Pe=a(),d(D.$$.fragment),Le=a(),O=i("p"),O.innerHTML=Es,Ke=a(),d(ee.$$.fragment),De=a(),se=i("p"),se.innerHTML=xs,Oe=a(),d(le.$$.fragment),es=a(),te=i("p"),te.innerHTML=$s,ss=a(),d(ae.$$.fragment),ls=a(),ne=i("p"),ne.innerHTML=Ys,ts=a(),d(ie.$$.fragment),as=a(),b=i("h2"),C=i("a"),Ue=i("span"),d(pe.$$.fragment),fs=a(),we=i("span"),we.textContent=Qs,ns=a(),oe=i("p"),oe.innerHTML=Ss,is=a(),re=i("p"),re.innerHTML=Fs,ps=a(),ce=i("p"),ce.innerHTML=Ps,os=a(),de=i("p"),de.innerHTML=Ls,rs=a(),Me=i("p"),Me.innerHTML=Ks,cs=a(),ue=i("ul"),ue.innerHTML=Ds,ds=a(),be=i("p"),this.h()},l(e){const l=Ml("svelte-1phssyn",document.head);j=p(l,"META",{name:!0,content:!0}),l.forEach(s),Ie=n(e),Te=p(e,"P",{}),M(Te).forEach(s),ge=n(e),h=p(e,"H1",{class:!0});var us=M(h);I=p(us,"A",{id:!0,class:!0,href:!0});var Os=M(I);je=p(Os,"SPAN",{});var el=M(je);u(_.$$.fragment,el),el.forEach(s),Os.forEach(s),Ts=n(us),me=p(us,"SPAN",{"data-svelte-h":!0}),o(me)!=="svelte-1fatcqx"&&(me.textContent=bs),us.forEach(s),Be=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-12w49xe"&&(v.innerHTML=Is),Ce=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1iatkga"&&(k.innerHTML=gs),_e=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-i2xp1j"&&(Z.innerHTML=Bs),ve=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-eef5a9"&&(z.innerHTML=Cs),ke=n(e),u(A.$$.fragment,e),Ze=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1lfi6tr"&&(G.textContent=_s),ze=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-m2oyf8"&&(q.innerHTML=vs),Ae=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-xk0co8"&&(N.innerHTML=ks),Ge=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-wbceks"&&(H.innerHTML=Zs),qe=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1w8676p"&&(V.innerHTML=zs),Ne=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-wn1l5e"&&(X.innerHTML=As),He=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-hymnzr"&&(W.innerHTML=Gs),Ve=n(e),u(R.$$.fragment,e),Xe=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-nsc0of"&&(E.innerHTML=qs),We=n(e),u(x.$$.fragment,e),Re=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1fkgamo"&&($.textContent=Ns),Ee=n(e),f=p(e,"H2",{class:!0});var ms=M(f);g=p(ms,"A",{id:!0,class:!0,href:!0});var sl=M(g);he=p(sl,"SPAN",{});var ll=M(he);u(Y.$$.fragment,ll),ll.forEach(s),sl.forEach(s),js=n(ms),ye=p(ms,"SPAN",{"data-svelte-h":!0}),o(ye)!=="svelte-kfrt11"&&(ye.textContent=Hs),ms.forEach(s),xe=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-4zkgvo"&&(Q.innerHTML=Vs),$e=n(e),u(S.$$.fragment,e),Ye=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-u38mjv"&&(F.innerHTML=Xs),Qe=n(e),u(P.$$.fragment,e),Se=n(e),U=p(e,"H2",{class:!0});var ys=M(U);B=p(ys,"A",{id:!0,class:!0,href:!0});var tl=M(B);fe=p(tl,"SPAN",{});var al=M(fe);u(L.$$.fragment,al),al.forEach(s),tl.forEach(s),hs=n(ys),Je=p(ys,"SPAN",{"data-svelte-h":!0}),o(Je)!=="svelte-1nbz1mx"&&(Je.textContent=Ws),ys.forEach(s),Fe=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-16cgcsm"&&(K.innerHTML=Rs),Pe=n(e),u(D.$$.fragment,e),Le=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-libyk9"&&(O.innerHTML=Es),Ke=n(e),u(ee.$$.fragment,e),De=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-vhle5u"&&(se.innerHTML=xs),Oe=n(e),u(le.$$.fragment,e),es=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-fwx120"&&(te.innerHTML=$s),ss=n(e),u(ae.$$.fragment,e),ls=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1jl4eog"&&(ne.innerHTML=Ys),ts=n(e),u(ie.$$.fragment,e),as=n(e),b=p(e,"H2",{class:!0});var Js=M(b);C=p(Js,"A",{id:!0,class:!0,href:!0});var nl=M(C);Ue=p(nl,"SPAN",{});var il=M(Ue);u(pe.$$.fragment,il),il.forEach(s),nl.forEach(s),fs=n(Js),we=p(Js,"SPAN",{"data-svelte-h":!0}),o(we)!=="svelte-c5m6od"&&(we.textContent=Qs),Js.forEach(s),ns=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-3oo5s6"&&(oe.innerHTML=Ss),is=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-17yxzlw"&&(re.innerHTML=Fs),ps=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-agzokg"&&(ce.innerHTML=Ps),os=n(e),de=p(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-td3vn9"&&(de.innerHTML=Ls),rs=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-dschfg"&&(Me.innerHTML=Ks),cs=n(e),ue=p(e,"UL",{"data-svelte-h":!0}),o(ue)!=="svelte-1c56iwk"&&(ue.innerHTML=Ds),ds=n(e),be=p(e,"P",{}),M(be).forEach(s),this.h()},h(){r(j,"name","hf:doc:metadata"),r(j,"content",JSON.stringify(ml)),r(I,"id","come-creare-una-pipeline-personalizzata"),r(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(I,"href","#come-creare-una-pipeline-personalizzata"),r(h,"class","relative group"),r(g,"id","aggiungilo-alla-lista-dei-tasks-supportati"),r(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(g,"href","#aggiungilo-alla-lista-dei-tasks-supportati"),r(f,"class","relative group"),r(B,"id","condividi-la-tua-pipeline-sullhub"),r(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(B,"href","#condividi-la-tua-pipeline-sullhub"),r(U,"class","relative group"),r(C,"id","aggiungere-la-pipeline-a-transformers"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#aggiungere-la-pipeline-a-transformers"),r(b,"class","relative group")},m(e,l){c(document.head,j),t(e,Ie,l),t(e,Te,l),t(e,ge,l),t(e,h,l),c(h,I),c(I,je),m(_,je,null),c(h,Ts),c(h,me),t(e,Be,l),t(e,v,l),t(e,Ce,l),t(e,k,l),t(e,_e,l),t(e,Z,l),t(e,ve,l),t(e,z,l),t(e,ke,l),m(A,e,l),t(e,Ze,l),t(e,G,l),t(e,ze,l),t(e,q,l),t(e,Ae,l),t(e,N,l),t(e,Ge,l),t(e,H,l),t(e,qe,l),t(e,V,l),t(e,Ne,l),t(e,X,l),t(e,He,l),t(e,W,l),t(e,Ve,l),m(R,e,l),t(e,Xe,l),t(e,E,l),t(e,We,l),m(x,e,l),t(e,Re,l),t(e,$,l),t(e,Ee,l),t(e,f,l),c(f,g),c(g,he),m(Y,he,null),c(f,js),c(f,ye),t(e,xe,l),t(e,Q,l),t(e,$e,l),m(S,e,l),t(e,Ye,l),t(e,F,l),t(e,Qe,l),m(P,e,l),t(e,Se,l),t(e,U,l),c(U,B),c(B,fe),m(L,fe,null),c(U,hs),c(U,Je),t(e,Fe,l),t(e,K,l),t(e,Pe,l),m(D,e,l),t(e,Le,l),t(e,O,l),t(e,Ke,l),m(ee,e,l),t(e,De,l),t(e,se,l),t(e,Oe,l),m(le,e,l),t(e,es,l),t(e,te,l),t(e,ss,l),m(ae,e,l),t(e,ls,l),t(e,ne,l),t(e,ts,l),m(ie,e,l),t(e,as,l),t(e,b,l),c(b,C),c(C,Ue),m(pe,Ue,null),c(b,fs),c(b,we),t(e,ns,l),t(e,oe,l),t(e,is,l),t(e,re,l),t(e,ps,l),t(e,ce,l),t(e,os,l),t(e,de,l),t(e,rs,l),t(e,Me,l),t(e,cs,l),t(e,ue,l),t(e,ds,l),t(e,be,l),Ms=!0},p:ol,i(e){Ms||(y(_.$$.fragment,e),y(A.$$.fragment,e),y(R.$$.fragment,e),y(x.$$.fragment,e),y(Y.$$.fragment,e),y(S.$$.fragment,e),y(P.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),Ms=!0)},o(e){J(_.$$.fragment,e),J(A.$$.fragment,e),J(R.$$.fragment,e),J(x.$$.fragment,e),J(Y.$$.fragment,e),J(S.$$.fragment,e),J(P.$$.fragment,e),J(L.$$.fragment,e),J(D.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(ae.$$.fragment,e),J(ie.$$.fragment,e),J(pe.$$.fragment,e),Ms=!1},d(e){e&&(s(Ie),s(Te),s(ge),s(h),s(Be),s(v),s(Ce),s(k),s(_e),s(Z),s(ve),s(z),s(ke),s(Ze),s(G),s(ze),s(q),s(Ae),s(N),s(Ge),s(H),s(qe),s(V),s(Ne),s(X),s(He),s(W),s(Ve),s(Xe),s(E),s(We),s(Re),s($),s(Ee),s(f),s(xe),s(Q),s($e),s(Ye),s(F),s(Qe),s(Se),s(U),s(Fe),s(K),s(Pe),s(Le),s(O),s(Ke),s(De),s(se),s(Oe),s(es),s(te),s(ss),s(ls),s(ne),s(ts),s(as),s(b),s(ns),s(oe),s(is),s(re),s(ps),s(ce),s(os),s(de),s(rs),s(Me),s(cs),s(ue),s(ds),s(be)),s(j),w(_),w(A,e),w(R,e),w(x,e),w(Y),w(S,e),w(P,e),w(L),w(D,e),w(ee,e),w(le,e),w(ae,e),w(ie,e),w(pe)}}}const ml={local:"come-creare-una-pipeline-personalizzata",sections:[{local:"aggiungilo-alla-lista-dei-tasks-supportati",title:"Aggiungilo alla lista dei tasks supportati"},{local:"condividi-la-tua-pipeline-sullhub",title:"Condividi la tua pipeline sull'Hub"},{local:"aggiungere-la-pipeline-a-transformers",title:"Aggiungere la pipeline a Transformers"}],title:"Come creare una pipeline personalizzata?"};function yl(Us){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends cl{constructor(j){super(),dl(this,j,yl,ul,pl,{})}}export{hl as component};
