import{s as Rs,o as Xs,n as Bt}from"../chunks/scheduler.56730f09.js";import{S as xs,i as Gs,g as M,s as n,u as r,A as Es,h as i,f as t,c as a,j as f,v as c,y as o,k as y,o as T,a as s,w as d,d as m,t as w,x as J}from"../chunks/index.ba464511.js";import{T as Nt}from"../chunks/Tip.70442610.js";import{I as el}from"../chunks/IconCopyLink.89bde88e.js";import{C as j}from"../chunks/CodeBlock.2302fd0d.js";function Ys(g){let p,U="라이브러리에 존재하는 모델과 굉장히 유사하다면, 모델을 생성할 때 구성을 참조해 재사용할 수 있습니다.";return{c(){p=M("p"),p.textContent=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-hf6zh1"&&(p.textContent=U)},m(u,h){s(u,p,h)},p:Bt,d(u){u&&t(p)}}}function Vs(g){let p,U="이 API는 실험적이며 다음 릴리스에서 약간의 변경 사항이 있을 수 있습니다.";return{c(){p=M("p"),p.textContent=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-11fial7"&&(p.textContent=U)},m(u,h){s(u,p,h)},p:Bt,d(u){u&&t(p)}}}function Qs(g){let p,U=`라이브러리에서 모델링 파일을 복사하는 경우,
모든 파일 상단에 있는 상대 경로 임포트(relative import) 부분을 <code>transformers</code> 패키지에서 임포트 하도록 변경해야 합니다.`;return{c(){p=M("p"),p.innerHTML=U},l(u){p=i(u,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1igyulw"&&(p.innerHTML=U)},m(u,h){s(u,p,h)},p:Bt,d(u){u&&t(p)}}}function Hs(g){let p,U,u,h,C,A,ll,G,Zt,Le,Wt="사용자 정의 모델 공유하기",rl,E,Rt=`🤗 Transformers 라이브러리는 쉽게 확장할 수 있도록 설계되었습니다.
모든 모델은 추상화 없이 저장소의 지정된 하위 폴더에 완전히 코딩되어 있으므로, 손쉽게 모델링 파일을 복사하고 필요에 따라 조정할 수 있습니다.`,cl,Y,Xt=`완전히 새로운 모델을 만드는 경우에는 처음부터 시작하는 것이 더 쉬울 수 있습니다.
이 튜토리얼에서는 Transformers 내에서 사용할 수 있도록 사용자 정의 모델과 구성을 작성하는 방법과
🤗 Transformers 라이브러리에 없는 경우에도 누구나 사용할 수 있도록 (의존성과 함께) 커뮤니티에 공유하는 방법을 배울 수 있습니다.`,yl,V,xt='<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 라이브러리</a>의 ResNet 클래스를 <code>PreTrainedModel</code>로 래핑한 ResNet 모델을 예로 모든 것을 설명합니다.',dl,b,$,tl,Q,vt,qe,Gt="사용자 정의 구성 작성하기",ml,H,Et=`모델에 들어가기 전에 먼저 구성을 작성해보도록 하겠습니다.
모델의 <code>configuration</code>은 모델을 만들기 위해 필요한 모든 중요한 것들을 포함하고 있는 객체입니다.
다음 섹션에서 볼 수 있듯이, 모델은 <code>config</code>를 사용해서만 초기화할 수 있기 때문에 완벽한 구성이 필요합니다.`,wl,z,Yt=`아래 예시에서는 ResNet 클래스의 인수(argument)를 조정해보겠습니다.
다른 구성은 가능한 ResNet 중 다른 유형을 제공합니다.
그런 다음 몇 가지 유효성을 확인한 후 해당 인수를 저장합니다.`,Jl,F,Tl,S,Vt="사용자 정의 <code>configuration</code>을 작성할 때 기억해야 할 세 가지 중요한 사항은 다음과 같습니다:",ul,L,Qt="<li><code>PretrainedConfig</code>을 상속해야 합니다.</li> <li><code>PretrainedConfig</code>의 <code>__init__</code>은 모든 kwargs를 허용해야 하고,</li> <li>이러한 <code>kwargs</code>는 상위 클래스 <code>__init__</code>에 전달되어야 합니다.</li>",fl,q,Ht=`상속은 🤗 Transformers 라이브러리에서 모든 기능을 가져오는 것입니다.
이러한 점으로부터 비롯되는 두 가지 제약 조건은 <code>PretrainedConfig</code>에 설정하는 것보다 더 많은 필드가 있습니다.
<code>from_pretrained</code> 메서드로 구성을 다시 로드할 때 해당 필드는 구성에서 수락한 후 상위 클래스로 보내야 합니다.`,jl,P,zt="모델을 auto 클래스에 등록하지 않는 한, <code>configuration</code>에서 <code>model_type</code>을 정의(여기서 <code>model_type=&quot;resnet&quot;</code>)하는 것은 필수 사항이 아닙니다 (마지막 섹션 참조).",Ul,D,Ft=`이렇게 하면 라이브러리의 다른 모델 구성과 마찬가지로 구성을 쉽게 만들고 저장할 수 있습니다.
다음은 resnet50d 구성을 생성하고 저장하는 방법입니다:`,hl,K,Cl,O,St=`이렇게 하면 <code>custom-resnet</code> 폴더 안에 <code>config.json</code>이라는 파일이 저장됩니다.
그런 다음 <code>from_pretrained</code> 메서드를 사용하여 구성을 다시 로드할 수 있습니다.`,bl,ee,Il,le,Lt="구성을 Hub에 직접 업로드하기 위해 <code>PretrainedConfig</code> 클래스의 <code>push_to_hub()</code>와 같은 다른 메서드를 사용할 수 있습니다.",_l,I,k,sl,te,gt,Pe,qt="사용자 정의 모델 작성하기",Zl,se,Pt=`이제 ResNet 구성이 있으므로 모델을 작성할 수 있습니다.
실제로는 두 개를 작성할 것입니다. 하나는 이미지 배치에서 hidden features를 추출하는 것(<code>BertModel</code>과 같이), 다른 하나는 이미지 분류에 적합한 것입니다(<code>BertForSequenceClassification</code>과 같이).`,vl,ne,Dt=`이전에 언급했듯이 이 예제에서는 단순하게 하기 위해 모델의 느슨한 래퍼(loose wrapper)만 작성할 것입니다.
이 클래스를 작성하기 전에 블록 유형과 실제 블록 클래스 간의 매핑 작업만 하면 됩니다.
그런 다음 <code>ResNet</code> 클래스로 전달되어 <code>configuration</code>을 통해 모델이 선언됩니다:`,gl,ae,Al,Me,Kt="이미지 분류 모델을 만들기 위해서는 forward 메소드만 변경하면 됩니다:",$l,ie,kl,oe,Ot=`두 경우 모두 <code>PreTrainedModel</code>를 상속받고, <code>config</code>를 통해 상위 클래스 초기화를 호출하다는 점을 기억하세요 (일반적인 <code>torch.nn.Module</code>을 작성할 때와 비슷함).
모델을 auto 클래스에 등록하고 싶은 경우에는 <code>config_class</code>를 설정하는 부분이 필수입니다 (마지막 섹션 참조).`,Nl,N,Bl,pe,es=`원하는 것을 모델이 반환하도록 할 수 있지만, <code>ResnetModelForImageClassification</code>에서 했던 것 처럼
레이블을 통과시켰을 때 손실과 함께 사전 형태로 반환하는 것이 <code>Trainer</code> 클래스 내에서 직접 모델을 사용하기에 유용합니다.
자신만의 학습 루프 또는 다른 학습 라이브러리를 사용할 계획이라면 다른 출력 형식을 사용해도 좋습니다.`,Wl,re,ls="이제 모델 클래스가 있으므로 하나 생성해 보겠습니다:",Rl,ce,Xl,ye,ts=`다시 말하지만, <code>save_pretrained()</code>또는 <code>push_to_hub()</code>처럼 <code>PreTrainedModel</code>에 속하는 모든 메소드를 사용할 수 있습니다.
다음 섹션에서 두 번째 메소드를 사용해 모델 코드와 모델 가중치를 업로드하는 방법을 살펴보겠습니다.
먼저, 모델 내부에 사전 훈련된 가중치를 로드해 보겠습니다.`,xl,de,ss=`이 예제를 활용할 때는, 사용자 정의 모델을 자신만의 데이터로 학습시킬 것입니다.
이 튜토리얼에서는 빠르게 진행하기 위해 사전 훈련된 resnet50d를 사용하겠습니다.
아래 모델은 resnet50d의 래퍼이기 때문에, 가중치를 쉽게 로드할 수 있습니다.`,Gl,me,El,we,ns="이제 <code>save_pretrained()</code> 또는 <code>push_to_hub()</code>를 사용할 때 모델 코드가 저장되는지 확인해봅시다.",Yl,_,B,nl,Je,At,De,as="Hub로 코드 업로드하기",Vl,W,Ql,Te,Ms=`먼저 모델이 <code>.py</code> 파일에 완전히 정의되어 있는지 확인하세요.
모든 파일이 동일한 작업 경로에 있기 때문에 상대경로 임포트(relative import)에 의존할 수 있습니다 (transformers에서는 이 기능에 대한 하위 모듈을 지원하지 않습니다).
이 예시에서는 작업 경로 안의 <code>resnet_model</code>에서 <code>modeling_resnet.py</code> 파일과 <code>configuration_resnet.py</code> 파일을 정의합니다.
구성 파일에는 <code>ResnetConfig</code>에 대한 코드가 있고 모델링 파일에는 <code>ResnetModel</code> 및 <code>ResnetModelForImageClassification</code>에 대한 코드가 있습니다.`,Hl,ue,zl,fe,is="Python이 <code>resnet_model</code>을 모듈로 사용할 수 있도록 감지하는 목적이기 때문에 <code>__init__.py</code>는 비어 있을 수 있습니다.",Fl,R,Sl,je,os="기존 구성이나 모델을 재사용(또는 서브 클래스화)할 수 있습니다.",Ll,Ue,ps=`커뮤니티에 모델을 공유하기 위해서는 다음 단계를 따라야 합니다:
먼저, 새로 만든 파일에 ResNet 모델과 구성을 임포트합니다:`,ql,he,Pl,Ce,rs=`다음으로 <code>save_pretrained</code> 메소드를 사용해 해당 객체의 코드 파일을 복사하고,
복사한 파일을 Auto 클래스로 등록하고(모델인 경우) 실행합니다:`,Dl,be,Kl,Ie,cs=`<code>configuration</code>에 대한 auto 클래스를 지정할 필요는 없지만(<code>configuration</code> 관련 auto 클래스는 AutoConfig 클래스 하나만 있음), 모델의 경우에는 지정해야 합니다.
사용자 지정 모델은 다양한 작업에 적합할 수 있으므로, 모델에 맞는 auto 클래스를 지정해야 합니다.`,Ol,_e,ys="다음으로, 이전에 작업했던 것과 마찬가지로 구성과 모델을 작성합니다:",et,Ze,lt,ve,ds=`이제 모델을 Hub로 업로드하기 위해 로그인 상태인지 확인하세요.
터미널에서 다음 코드를 실행해 확인할 수 있습니다:`,tt,ge,st,Ae,ms="주피터 노트북의 경우에는 다음과 같습니다:",nt,$e,at,ke,ws="그런 다음 이렇게 자신의 네임스페이스(또는 자신이 속한 조직)에 업로드할 수 있습니다:",Mt,Ne,it,Be,Js=`On top of the modeling weights and the configuration in json format, this also copied the modeling and
configuration <code>.py</code> files in the folder <code>custom-resnet50d</code> and uploaded the result to the Hub. You can check the result
in this <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">model repo</a>.
json 형식의 모델링 가중치와 구성 외에도 <code>custom-resnet50d</code> 폴더 안의 모델링과 구성 <code>.py</code> 파일을 복사하해 Hub에 업로드합니다.
<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">모델 저장소</a>에서 결과를 확인할 수 있습니다.`,ot,We,Ts='<a href="model_sharing">sharing tutorial</a> 문서의 <code>push_to_hub</code> 메소드에서 자세한 내용을 확인할 수 있습니다.',pt,Z,X,al,Re,$t,Ke,us="사용자 정의 코드로 모델 사용하기",rt,Xe,fs=`auto 클래스와 <code>from_pretrained</code> 메소드를 사용하여 사용자 지정 코드 파일과 함께 모든 구성, 모델, 토크나이저를 사용할 수 있습니다.
Hub에 업로드된 모든 파일 및 코드는 멜웨어가 있는지 검사되지만 (자세한 내용은 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 보안</a> 설명 참조),
자신의 컴퓨터에서 모델 코드와 작성자가 악성 코드를 실행하지 않는지 확인해야 합니다.
사용자 정의 코드로 모델을 사용하려면 <code>trust_remote_code=True</code>로 설정하세요:`,ct,xe,yt,Ge,js="모델 작성자가 악의적으로 코드를 업데이트하지 않았다는 점을 확인하기 위해, 커밋 해시(commit hash)를 <code>revision</code>으로 전달하는 것도 강력히 권장됩니다 (모델 작성자를 완전히 신뢰하지 않는 경우).",dt,Ee,mt,Ye,Us="Hub에서 모델 저장소의 커밋 기록을 찾아볼 때, 모든 커밋의 커밋 해시를 쉽게 복사할 수 있는 버튼이 있습니다.",wt,v,x,Ml,Ve,kt,Oe,hs="사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기",Jt,Qe,Cs=`🤗 Transformers를 상속하는 라이브러리를 작성하는 경우 사용자 정의 모델을 auto 클래스에 추가할 수 있습니다.
사용자 정의 모델을 사용하기 위해 해당 라이브러리를 임포트해야 하기 때문에, 이는 Hub로 코드를 업로드하는 것과 다릅니다 (Hub에서 자동적으로 모델 코드를 다운로드 하는 것과 반대).`,Tt,He,bs=`구성에 기존 모델 유형과 다른 <code>model_type</code> 속성이 있고 모델 클래스에 올바른 <code>config_class</code> 속성이 있는 한,
다음과 같이 auto 클래스에 추가할 수 있습니다:`,ut,ze,ft,Fe,Is=`사용자 정의 구성을 <code>AutoConfig</code>에 등록할 때 사용되는 첫 번째 인수는 사용자 정의 구성의 <code>model_type</code>과 일치해야 합니다.
또한, 사용자 정의 모델을 auto 클래스에 등록할 때 사용되는 첫 번째 인수는 해당 모델의 <code>config_class</code>와 일치해야 합니다.`,jt,il,Ut;return G=new el({}),Q=new el({}),F=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),K=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),ee=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),te=new el({}),ae=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),ie=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),N=new Nt({props:{$$slots:{default:[Ys]},$$scope:{ctx:g}}}),ce=new j({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),me=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Je=new el({}),W=new Nt({props:{warning:!0,$$slots:{default:[Vs]},$$scope:{ctx:g}}}),ue=new j({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),R=new Nt({props:{warning:!0,$$slots:{default:[Qs]},$$scope:{ctx:g}}}),he=new j({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),be=new j({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),Ze=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),ge=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$e=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ne=new j({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Re=new el({}),xe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ee=new j({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ve=new el({}),ze=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){p=M("meta"),U=n(),u=M("p"),h=n(),C=M("h1"),A=M("a"),ll=M("span"),r(G.$$.fragment),Zt=n(),Le=M("span"),Le.textContent=Wt,rl=n(),E=M("p"),E.textContent=Rt,cl=n(),Y=M("p"),Y.textContent=Xt,yl=n(),V=M("p"),V.innerHTML=xt,dl=n(),b=M("h2"),$=M("a"),tl=M("span"),r(Q.$$.fragment),vt=n(),qe=M("span"),qe.textContent=Gt,ml=n(),H=M("p"),H.innerHTML=Et,wl=n(),z=M("p"),z.textContent=Yt,Jl=n(),r(F.$$.fragment),Tl=n(),S=M("p"),S.innerHTML=Vt,ul=n(),L=M("ul"),L.innerHTML=Qt,fl=n(),q=M("p"),q.innerHTML=Ht,jl=n(),P=M("p"),P.innerHTML=zt,Ul=n(),D=M("p"),D.textContent=Ft,hl=n(),r(K.$$.fragment),Cl=n(),O=M("p"),O.innerHTML=St,bl=n(),r(ee.$$.fragment),Il=n(),le=M("p"),le.innerHTML=Lt,_l=n(),I=M("h2"),k=M("a"),sl=M("span"),r(te.$$.fragment),gt=n(),Pe=M("span"),Pe.textContent=qt,Zl=n(),se=M("p"),se.innerHTML=Pt,vl=n(),ne=M("p"),ne.innerHTML=Dt,gl=n(),r(ae.$$.fragment),Al=n(),Me=M("p"),Me.textContent=Kt,$l=n(),r(ie.$$.fragment),kl=n(),oe=M("p"),oe.innerHTML=Ot,Nl=n(),r(N.$$.fragment),Bl=n(),pe=M("p"),pe.innerHTML=es,Wl=n(),re=M("p"),re.textContent=ls,Rl=n(),r(ce.$$.fragment),Xl=n(),ye=M("p"),ye.innerHTML=ts,xl=n(),de=M("p"),de.textContent=ss,Gl=n(),r(me.$$.fragment),El=n(),we=M("p"),we.innerHTML=ns,Yl=n(),_=M("h2"),B=M("a"),nl=M("span"),r(Je.$$.fragment),At=n(),De=M("span"),De.textContent=as,Vl=n(),r(W.$$.fragment),Ql=n(),Te=M("p"),Te.innerHTML=Ms,Hl=n(),r(ue.$$.fragment),zl=n(),fe=M("p"),fe.innerHTML=is,Fl=n(),r(R.$$.fragment),Sl=n(),je=M("p"),je.textContent=os,Ll=n(),Ue=M("p"),Ue.textContent=ps,ql=n(),r(he.$$.fragment),Pl=n(),Ce=M("p"),Ce.innerHTML=rs,Dl=n(),r(be.$$.fragment),Kl=n(),Ie=M("p"),Ie.innerHTML=cs,Ol=n(),_e=M("p"),_e.textContent=ys,et=n(),r(Ze.$$.fragment),lt=n(),ve=M("p"),ve.textContent=ds,tt=n(),r(ge.$$.fragment),st=n(),Ae=M("p"),Ae.textContent=ms,nt=n(),r($e.$$.fragment),at=n(),ke=M("p"),ke.textContent=ws,Mt=n(),r(Ne.$$.fragment),it=n(),Be=M("p"),Be.innerHTML=Js,ot=n(),We=M("p"),We.innerHTML=Ts,pt=n(),Z=M("h2"),X=M("a"),al=M("span"),r(Re.$$.fragment),$t=n(),Ke=M("span"),Ke.textContent=us,rt=n(),Xe=M("p"),Xe.innerHTML=fs,ct=n(),r(xe.$$.fragment),yt=n(),Ge=M("p"),Ge.innerHTML=js,dt=n(),r(Ee.$$.fragment),mt=n(),Ye=M("p"),Ye.textContent=Us,wt=n(),v=M("h2"),x=M("a"),Ml=M("span"),r(Ve.$$.fragment),kt=n(),Oe=M("span"),Oe.textContent=hs,Jt=n(),Qe=M("p"),Qe.textContent=Cs,Tt=n(),He=M("p"),He.innerHTML=bs,ut=n(),r(ze.$$.fragment),ft=n(),Fe=M("p"),Fe.innerHTML=Is,jt=n(),il=M("p"),this.h()},l(e){const l=Es("svelte-1phssyn",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),U=a(e),u=i(e,"P",{}),f(u).forEach(t),h=a(e),C=i(e,"H1",{class:!0});var Se=f(C);A=i(Se,"A",{id:!0,class:!0,href:!0});var ol=f(A);ll=i(ol,"SPAN",{});var pl=f(ll);c(G.$$.fragment,pl),pl.forEach(t),ol.forEach(t),Zt=a(Se),Le=i(Se,"SPAN",{"data-svelte-h":!0}),o(Le)!=="svelte-sbleqg"&&(Le.textContent=Wt),Se.forEach(t),rl=a(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-al07n"&&(E.textContent=Rt),cl=a(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1lxcxix"&&(Y.textContent=Xt),yl=a(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-119rg2w"&&(V.innerHTML=xt),dl=a(e),b=i(e,"H2",{class:!0});var ht=f(b);$=i(ht,"A",{id:!0,class:!0,href:!0});var _s=f($);tl=i(_s,"SPAN",{});var Zs=f(tl);c(Q.$$.fragment,Zs),Zs.forEach(t),_s.forEach(t),vt=a(ht),qe=i(ht,"SPAN",{"data-svelte-h":!0}),o(qe)!=="svelte-1dprsqe"&&(qe.textContent=Gt),ht.forEach(t),ml=a(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-la43mp"&&(H.innerHTML=Et),wl=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1qc22zw"&&(z.textContent=Yt),Jl=a(e),c(F.$$.fragment,e),Tl=a(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-nxq6mo"&&(S.innerHTML=Vt),ul=a(e),L=i(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-1tfxli8"&&(L.innerHTML=Qt),fl=a(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-x5ckqo"&&(q.innerHTML=Ht),jl=a(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1kaub1g"&&(P.innerHTML=zt),Ul=a(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ovl0zx"&&(D.textContent=Ft),hl=a(e),c(K.$$.fragment,e),Cl=a(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-d1xscf"&&(O.innerHTML=St),bl=a(e),c(ee.$$.fragment,e),Il=a(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-g1m52h"&&(le.innerHTML=Lt),_l=a(e),I=i(e,"H2",{class:!0});var Ct=f(I);k=i(Ct,"A",{id:!0,class:!0,href:!0});var vs=f(k);sl=i(vs,"SPAN",{});var gs=f(sl);c(te.$$.fragment,gs),gs.forEach(t),vs.forEach(t),gt=a(Ct),Pe=i(Ct,"SPAN",{"data-svelte-h":!0}),o(Pe)!=="svelte-rrb1t5"&&(Pe.textContent=qt),Ct.forEach(t),Zl=a(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-6nuh70"&&(se.innerHTML=Pt),vl=a(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1ufn8h6"&&(ne.innerHTML=Dt),gl=a(e),c(ae.$$.fragment,e),Al=a(e),Me=i(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-10szka3"&&(Me.textContent=Kt),$l=a(e),c(ie.$$.fragment,e),kl=a(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1g3ya33"&&(oe.innerHTML=Ot),Nl=a(e),c(N.$$.fragment,e),Bl=a(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1f99hcg"&&(pe.innerHTML=es),Wl=a(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-68rs2x"&&(re.textContent=ls),Rl=a(e),c(ce.$$.fragment,e),Xl=a(e),ye=i(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-10d07s4"&&(ye.innerHTML=ts),xl=a(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1319e67"&&(de.textContent=ss),Gl=a(e),c(me.$$.fragment,e),El=a(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-rtsgc0"&&(we.innerHTML=ns),Yl=a(e),_=i(e,"H2",{class:!0});var bt=f(_);B=i(bt,"A",{id:!0,class:!0,href:!0});var As=f(B);nl=i(As,"SPAN",{});var $s=f(nl);c(Je.$$.fragment,$s),$s.forEach(t),As.forEach(t),At=a(bt),De=i(bt,"SPAN",{"data-svelte-h":!0}),o(De)!=="svelte-ge3v4r"&&(De.textContent=as),bt.forEach(t),Vl=a(e),c(W.$$.fragment,e),Ql=a(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-q87di4"&&(Te.innerHTML=Ms),Hl=a(e),c(ue.$$.fragment,e),zl=a(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-fw3tvd"&&(fe.innerHTML=is),Fl=a(e),c(R.$$.fragment,e),Sl=a(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-19tqquy"&&(je.textContent=os),Ll=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1tgl3y3"&&(Ue.textContent=ps),ql=a(e),c(he.$$.fragment,e),Pl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-85qz6h"&&(Ce.innerHTML=rs),Dl=a(e),c(be.$$.fragment,e),Kl=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-urqb2q"&&(Ie.innerHTML=cs),Ol=a(e),_e=i(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-th8o9z"&&(_e.textContent=ys),et=a(e),c(Ze.$$.fragment,e),lt=a(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1xhzef1"&&(ve.textContent=ds),tt=a(e),c(ge.$$.fragment,e),st=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-4bt266"&&(Ae.textContent=ms),nt=a(e),c($e.$$.fragment,e),at=a(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-xc5sk0"&&(ke.textContent=ws),Mt=a(e),c(Ne.$$.fragment,e),it=a(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-dnw5aw"&&(Be.innerHTML=Js),ot=a(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-2rsbbb"&&(We.innerHTML=Ts),pt=a(e),Z=i(e,"H2",{class:!0});var It=f(Z);X=i(It,"A",{id:!0,class:!0,href:!0});var ks=f(X);al=i(ks,"SPAN",{});var Ns=f(al);c(Re.$$.fragment,Ns),Ns.forEach(t),ks.forEach(t),$t=a(It),Ke=i(It,"SPAN",{"data-svelte-h":!0}),o(Ke)!=="svelte-yszqfe"&&(Ke.textContent=us),It.forEach(t),rt=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1m1cooj"&&(Xe.innerHTML=fs),ct=a(e),c(xe.$$.fragment,e),yt=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-18oh14g"&&(Ge.innerHTML=js),dt=a(e),c(Ee.$$.fragment,e),mt=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-eerkzr"&&(Ye.textContent=Us),wt=a(e),v=i(e,"H2",{class:!0});var _t=f(v);x=i(_t,"A",{id:!0,class:!0,href:!0});var Bs=f(x);Ml=i(Bs,"SPAN",{});var Ws=f(Ml);c(Ve.$$.fragment,Ws),Ws.forEach(t),Bs.forEach(t),kt=a(_t),Oe=i(_t,"SPAN",{"data-svelte-h":!0}),o(Oe)!=="svelte-juqmvo"&&(Oe.textContent=hs),_t.forEach(t),Jt=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-1w0yfzt"&&(Qe.textContent=Cs),Tt=a(e),He=i(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-xh4cqs"&&(He.innerHTML=bs),ut=a(e),c(ze.$$.fragment,e),ft=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-9j79lz"&&(Fe.innerHTML=Is),jt=a(e),il=i(e,"P",{}),f(il).forEach(t),this.h()},h(){y(p,"name","hf:doc:metadata"),y(p,"content",JSON.stringify(zs)),y(A,"id","sharing-custom-models"),y(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(A,"href","#sharing-custom-models"),y(C,"class","relative group"),y($,"id","writing-a-custom-configuration"),y($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y($,"href","#writing-a-custom-configuration"),y(b,"class","relative group"),y(k,"id","writing-a-custom-model"),y(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(k,"href","#writing-a-custom-model"),y(I,"class","relative group"),y(B,"id","sending-the-code-to-the-hub"),y(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(B,"href","#sending-the-code-to-the-hub"),y(_,"class","relative group"),y(X,"id","using-a-model-with-custom-code"),y(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(X,"href","#using-a-model-with-custom-code"),y(Z,"class","relative group"),y(x,"id","registering-a-model-with-custom-code-to-the-auto-classes"),y(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),y(x,"href","#registering-a-model-with-custom-code-to-the-auto-classes"),y(v,"class","relative group")},m(e,l){T(document.head,p),s(e,U,l),s(e,u,l),s(e,h,l),s(e,C,l),T(C,A),T(A,ll),d(G,ll,null),T(C,Zt),T(C,Le),s(e,rl,l),s(e,E,l),s(e,cl,l),s(e,Y,l),s(e,yl,l),s(e,V,l),s(e,dl,l),s(e,b,l),T(b,$),T($,tl),d(Q,tl,null),T(b,vt),T(b,qe),s(e,ml,l),s(e,H,l),s(e,wl,l),s(e,z,l),s(e,Jl,l),d(F,e,l),s(e,Tl,l),s(e,S,l),s(e,ul,l),s(e,L,l),s(e,fl,l),s(e,q,l),s(e,jl,l),s(e,P,l),s(e,Ul,l),s(e,D,l),s(e,hl,l),d(K,e,l),s(e,Cl,l),s(e,O,l),s(e,bl,l),d(ee,e,l),s(e,Il,l),s(e,le,l),s(e,_l,l),s(e,I,l),T(I,k),T(k,sl),d(te,sl,null),T(I,gt),T(I,Pe),s(e,Zl,l),s(e,se,l),s(e,vl,l),s(e,ne,l),s(e,gl,l),d(ae,e,l),s(e,Al,l),s(e,Me,l),s(e,$l,l),d(ie,e,l),s(e,kl,l),s(e,oe,l),s(e,Nl,l),d(N,e,l),s(e,Bl,l),s(e,pe,l),s(e,Wl,l),s(e,re,l),s(e,Rl,l),d(ce,e,l),s(e,Xl,l),s(e,ye,l),s(e,xl,l),s(e,de,l),s(e,Gl,l),d(me,e,l),s(e,El,l),s(e,we,l),s(e,Yl,l),s(e,_,l),T(_,B),T(B,nl),d(Je,nl,null),T(_,At),T(_,De),s(e,Vl,l),d(W,e,l),s(e,Ql,l),s(e,Te,l),s(e,Hl,l),d(ue,e,l),s(e,zl,l),s(e,fe,l),s(e,Fl,l),d(R,e,l),s(e,Sl,l),s(e,je,l),s(e,Ll,l),s(e,Ue,l),s(e,ql,l),d(he,e,l),s(e,Pl,l),s(e,Ce,l),s(e,Dl,l),d(be,e,l),s(e,Kl,l),s(e,Ie,l),s(e,Ol,l),s(e,_e,l),s(e,et,l),d(Ze,e,l),s(e,lt,l),s(e,ve,l),s(e,tt,l),d(ge,e,l),s(e,st,l),s(e,Ae,l),s(e,nt,l),d($e,e,l),s(e,at,l),s(e,ke,l),s(e,Mt,l),d(Ne,e,l),s(e,it,l),s(e,Be,l),s(e,ot,l),s(e,We,l),s(e,pt,l),s(e,Z,l),T(Z,X),T(X,al),d(Re,al,null),T(Z,$t),T(Z,Ke),s(e,rt,l),s(e,Xe,l),s(e,ct,l),d(xe,e,l),s(e,yt,l),s(e,Ge,l),s(e,dt,l),d(Ee,e,l),s(e,mt,l),s(e,Ye,l),s(e,wt,l),s(e,v,l),T(v,x),T(x,Ml),d(Ve,Ml,null),T(v,kt),T(v,Oe),s(e,Jt,l),s(e,Qe,l),s(e,Tt,l),s(e,He,l),s(e,ut,l),d(ze,e,l),s(e,ft,l),s(e,Fe,l),s(e,jt,l),s(e,il,l),Ut=!0},p(e,[l]){const Se={};l&2&&(Se.$$scope={dirty:l,ctx:e}),N.$set(Se);const ol={};l&2&&(ol.$$scope={dirty:l,ctx:e}),W.$set(ol);const pl={};l&2&&(pl.$$scope={dirty:l,ctx:e}),R.$set(pl)},i(e){Ut||(m(G.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(N.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(Je.$$.fragment,e),m(W.$$.fragment,e),m(ue.$$.fragment,e),m(R.$$.fragment,e),m(he.$$.fragment,e),m(be.$$.fragment,e),m(Ze.$$.fragment,e),m(ge.$$.fragment,e),m($e.$$.fragment,e),m(Ne.$$.fragment,e),m(Re.$$.fragment,e),m(xe.$$.fragment,e),m(Ee.$$.fragment,e),m(Ve.$$.fragment,e),m(ze.$$.fragment,e),Ut=!0)},o(e){w(G.$$.fragment,e),w(Q.$$.fragment,e),w(F.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(ie.$$.fragment,e),w(N.$$.fragment,e),w(ce.$$.fragment,e),w(me.$$.fragment,e),w(Je.$$.fragment,e),w(W.$$.fragment,e),w(ue.$$.fragment,e),w(R.$$.fragment,e),w(he.$$.fragment,e),w(be.$$.fragment,e),w(Ze.$$.fragment,e),w(ge.$$.fragment,e),w($e.$$.fragment,e),w(Ne.$$.fragment,e),w(Re.$$.fragment,e),w(xe.$$.fragment,e),w(Ee.$$.fragment,e),w(Ve.$$.fragment,e),w(ze.$$.fragment,e),Ut=!1},d(e){e&&(t(U),t(u),t(h),t(C),t(rl),t(E),t(cl),t(Y),t(yl),t(V),t(dl),t(b),t(ml),t(H),t(wl),t(z),t(Jl),t(Tl),t(S),t(ul),t(L),t(fl),t(q),t(jl),t(P),t(Ul),t(D),t(hl),t(Cl),t(O),t(bl),t(Il),t(le),t(_l),t(I),t(Zl),t(se),t(vl),t(ne),t(gl),t(Al),t(Me),t($l),t(kl),t(oe),t(Nl),t(Bl),t(pe),t(Wl),t(re),t(Rl),t(Xl),t(ye),t(xl),t(de),t(Gl),t(El),t(we),t(Yl),t(_),t(Vl),t(Ql),t(Te),t(Hl),t(zl),t(fe),t(Fl),t(Sl),t(je),t(Ll),t(Ue),t(ql),t(Pl),t(Ce),t(Dl),t(Kl),t(Ie),t(Ol),t(_e),t(et),t(lt),t(ve),t(tt),t(st),t(Ae),t(nt),t(at),t(ke),t(Mt),t(it),t(Be),t(ot),t(We),t(pt),t(Z),t(rt),t(Xe),t(ct),t(yt),t(Ge),t(dt),t(mt),t(Ye),t(wt),t(v),t(Jt),t(Qe),t(Tt),t(He),t(ut),t(ft),t(Fe),t(jt),t(il)),t(p),J(G),J(Q),J(F,e),J(K,e),J(ee,e),J(te),J(ae,e),J(ie,e),J(N,e),J(ce,e),J(me,e),J(Je),J(W,e),J(ue,e),J(R,e),J(he,e),J(be,e),J(Ze,e),J(ge,e),J($e,e),J(Ne,e),J(Re),J(xe,e),J(Ee,e),J(Ve),J(ze,e)}}}const zs={local:"sharing-custom-models",sections:[{local:"writing-a-custom-configuration",title:"사용자 정의 구성 작성하기"},{local:"writing-a-custom-model",title:"사용자 정의 모델 작성하기"},{local:"sending-the-code-to-the-hub",title:"Hub로 코드 업로드하기"},{local:"using-a-model-with-custom-code",title:"사용자 정의 코드로 모델 사용하기"},{local:"registering-a-model-with-custom-code-to-the-auto-classes",title:"사용자 정의 코드로 만든 모델을 auto 클래스로 등록하기"}],title:"사용자 정의 모델 공유하기"};function Fs(g){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends xs{constructor(p){super(),Gs(this,p,Fs,Hs,Rs,{})}}export{Ks as component};
