import{s as st,n as nt,o as at}from"../chunks/scheduler.56730f09.js";import{S as ot,i as rt,g as n,s as o,u as m,A as pt,h as a,f as l,c as r,j as u,v as f,y as p,k as i,o as c,a as s,w as J,d as T,t as d,x as h}from"../chunks/index.ba464511.js";import{I as je}from"../chunks/IconCopyLink.89bde88e.js";import{C as j}from"../chunks/CodeBlock.2302fd0d.js";import{D as it}from"../chunks/DocNotebookDropdown.68fd8653.js";function ct(wl){let M,ke,he,_e,U,k,Me,Z,Tl,me,yl="TensorFlow 모델을 위한 XLA 통합",ve,V,Re,I,bl='XLA(Accelerated Linear Algebra)는 TensorFlow 모델의 실행 시간을 가속화하기 위한 컴파일러입니다. <a href="https://www.tensorflow.org/xla" rel="nofollow">공식 문서</a>에 따르면 다음과 같습니다:',Ce,x,gl="XLA(Accelerated Linear Algebra)는 선형 대수를 위한 도메인 특화 컴파일러로, TensorFlow 모델을 소스 코드 변경 없이 가속화할 수 있습니다.",Ze,X,jl='TensorFlow에서 XLA를 사용하는 것은 간단합니다. XLA는 <code>tensorflow</code> 라이브러리 내에 패키지로 제공되며, <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>과 같은 그래프 생성 함수에서 <code>jit_compile</code> 인수를 사용하여 활성화할 수 있습니다. <code>fit()</code> 및 <code>predict()</code>와 같은 Keras 메소드를 사용하는 경우, <code>jit_compile</code> 인수를 <code>model.compile()</code>에 전달하여 XLA를 간단하게 활성화할 수 있습니다. 그러나 XLA는 이러한 메소드에 국한되지 않고 임의의 <code>tf.function</code>을 가속화하는 데에도 사용할 수 있습니다.',Ve,Q,kl='🤗 Transformers에서는 <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>, <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>와 같은 모델의 텍스트 생성, 그리고 <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>와 같은 모델의 음성 처리를 포함하여 여러 TensorFlow 메소드가 XLA와 호환되도록 다시 작성되었습니다.',Ie,E,_l="정확한 속도 향상은 모델에 따라 다르지만, 🤗 Transformers 내의 TensorFlow 텍스트 생성 모델의 경우 최대 100배의 속도 향상을 확인했습니다. 이 문서에서는 이러한 모델에 대해 XLA를 사용하여 최대 성능을 얻는 방법을 설명합니다. 또한 XLA 통합의 벤치마크 및 디자인 철학에 대한 추가 자료 링크도 제공할 것입니다.",xe,w,_,Ue,G,dl,fe,vl="XLA를 사용하여 TF 함수 실행하기",Xe,$,Rl="TensorFlow에서 다음과 같은 모델을 고려해 봅시다:",Qe,B,Ee,W,Cl="위 모델은 차원이 <code>(10, )</code>인 입력을 받습니다. 다음과 같이 모델을 사용하여 순전파를 실행할 수 있습니다:",Ge,A,$e,F,Zl="XLA로 컴파일된 함수로 순전파를 실행하려면 다음과 같이 해야 합니다:",Be,z,We,L,Vl="<code>model</code>의 기본 <code>call()</code> 함수는 XLA 그래프를 컴파일하는 데 사용됩니다. 그러나 다른 모델 함수를 XLA로 컴파일하려면 다음과 같이 할 수도 있습니다:",Ae,N,Fe,y,v,we,H,hl,Je,Il="🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기",ze,D,xl="🤗 Transformers에서 XLA로 가속화된 생성을 활성화하려면 최신 버전의 <code>transformers</code>가 설치되어 있어야 합니다. 다음과 같이 설치할 수 있습니다:",Le,Y,Ne,q,Xl="그리고 다음 코드를 실행할 수 있습니다:",He,S,De,O,Ql="알 수 있듯이, <code>generate()</code>에서 XLA를 활성화하는 것은 단 한 줄의 코드입니다. 코드의 나머지 부분은 변경되지 않습니다. 그러나 위 코드 스니펫에서는 XLA에 특정한 몇 가지 주의할 점이 있습니다. XLA가 가져다줄 속도 향상을 실현하기 위해서는 이를 알고 있어야 합니다. 다음 섹션에서 이에 대해 논의합니다.",Ye,b,R,ye,P,Ml,Te,El="주의할 점",qe,K,Gl='XLA 활성화 함수(<code>xla_generate()</code>와 같은)를 처음 실행할 때 내부적으로 계산 그래프를 추론하려고 하며, 이는 시간이 소요됩니다. 이 과정은 <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“추적(tracing)”</a>이라고 알려져 있습니다.',Se,ee,$l="생성 시간이 빠르지 않다는 것을 알 수 있을 것입니다. <code>xla_generate()</code>(또는 다른 XLA 활성화 함수)의 연속 호출은 함수에 전달된 입력이 초기에 구축된 계산 그래프와 동일한 형태를 따른다면, 계산 그래프를 추론할 필요가 없습니다. 이는 입력 형태가 고정된 모달리티(예: 이미지)에는 문제가 되지 않지만, 가변 입력 형태 모달리티(예: 텍스트)를 사용할 때 주의해야 합니다.",Oe,le,Bl="<code>xla_generate()</code>가 항상 동일한 입력 형태로 동작하도록 하려면, 토크나이저를 호출할 때 <code>padding</code> 인수를 지정할 수 있습니다.",Pe,te,Ke,se,Wl="이렇게 하면 <code>xla_generate()</code>에 대한 입력이 항상 추적된 형태로 전달되어 생성 시간이 가속화됩니다. 다음 코드로 이를 확인할 수 있습니다:",el,ne,ll,ae,Al="Tesla T4 GPU에서는 다음과 같은 출력을 예상할 수 있습니다:",tl,oe,sl,re,Fl="<code>xla_generate()</code>의 첫 번째 호출은 추적 때문에 시간이 오래 걸리지만, 연속 호출은 몇 배나 빠릅니다. 생성 옵션에 대한 어떤 변경이든 다시 추적을 유발하므로 생성 시간이 느려질 수 있음을 명심하세요.",nl,pe,zl="이 문서에서는 🤗 Transformers에서 제공하는 모든 텍스트 생성 옵션을 다루지 않았습니다. 고급 사용 사례에 대해 문서를 참조하시기 바랍니다.",al,g,C,be,ie,Ul,de,Ll="추가 자료",ol,ce,Nl="여기에 🤗 Transformers와 XLA에 대해 더 자세히 알고 싶은 경우 도움이 될 수 있는 몇 가지 추가 자료를 제공합니다.",rl,ue,Hl='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">이 Colab 노트북</a>은 XLA와 호환되는 인코더-디코더(<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>와 같은) 및 디코더 전용(<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>와 같은) 텍스트 생성 모델을 실험해 볼 수 있는 대화형 데모를 제공합니다.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">이 블로그 글</a>은 TensorFlow에서 XLA에 대한 친절한 소개와 함께 XLA와 호환되는 모델의 비교 벤치마크에 대한 개요를 제공합니다.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">이 블로그 글</a>은 🤗 Transformers의 TensorFlow 모델에 XLA 지원을 추가하는 것에 대한 디자인 철학을 논의합니다.</li> <li>XLA와 TensorFlow 그래프에 대해 더 자세히 알고 싶은 경우 추천하는 글:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: 기계 학습을 위한 최적화 컴파일러</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">그래프 및 tf.function 소개</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">tf.function으로 성능 향상하기</a></li></ul></li>',pl,ge,il;return Z=new je({}),V=new it({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"}]}}),G=new je({}),B=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),A=new j({props:{code:"JTIzJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTk3JTkwJTIwJUVCJThDJTgwJUVEJTk1JTlDJTIwJUVDJTlFJTg0JUVDJTlEJTk4JUVDJTlEJTk4JTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVDJTlEJTg0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQWlucHV0X3ZlY3Rvcl9kaW0lMjAlM0QlMjAxMCUwQXJhbmRvbV9pbnB1dHMlMjAlM0QlMjB0Zi5yYW5kb20ubm9ybWFsKChiYXRjaF9zaXplJTJDJTIwaW5wdXRfdmVjdG9yX2RpbSkpJTBBJTBBJTIzJTIwJUVDJTg4JTlDJUVDJUEwJTg0JUVEJThDJThDJUVCJUE1JUJDJTIwJUVDJThCJUE0JUVEJTk2JTg5JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQV8lMjAlM0QlMjBtb2RlbChyYW5kb21faW5wdXRzKQ==",highlighted:`<span class="hljs-comment"># 모델에 대한 임의의 입력을 생성합니다.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># 순전파를 실행합니다.</span>
_ = model(random_inputs)`,wrap:!1}}),z=new j({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),N=new j({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),H=new je({}),Y=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),S=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjAlRUMlQjUlOUMlRUMlODYlOEMlMjAlRUIlQjIlODQlRUMlQTAlODQlRUMlOUQlOTglMjBUcmFuc2Zvcm1lcnMlRUElQjAlODAlMjAlRUMlODQlQTQlRUMlQjklOTglRUIlOTAlOTglRUMlOTYlQjQlMjAlRUMlOUUlODglRUMlQTclODAlMjAlRUMlOTUlOEElRUIlOEIlQTQlRUIlQTklQjQlMjAlRUMlOTglQTQlRUIlQTUlOTglRUElQjAlODAlMjAlRUIlQjAlOUMlRUMlODMlOUQlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGNoZWNrX21pbl92ZXJzaW9uJTBBJTBBY2hlY2tfbWluX3ZlcnNpb24oJTIyNC4yMS4wJTIyKSUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBJTIzJTIwWExBJTIwJUVDJTgzJTlEJUVDJTg0JUIxJTIwJUVEJTk1JUE4JUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVCJUE3JThDJUVCJTkzJUE0JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JTlDJTIwJUVEJTk1JTlDJTIwJUVDJUE0JTg0JTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># 최소 버전의 Transformers가 설치되어 있지 않다면 오류가 발생합니다.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># XLA 생성 함수를 만들기 위한 한 줄</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),P=new je({}),te=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMCVFQyU5NyVBQyVFQSVCOCVCMCVFQyU4NCU5QyUyQyUyMHBhZGRpbmclMjAlRUMlOTglQjUlRUMlODUlOTglRUMlOUQlQjQlMjAlRUMlOUUlODglRUIlOEElOTQlMjAlRUQlODYlQTAlRUQlODElQUMlRUIlODIlOTglRUMlOUQlQjQlRUMlQTAlODAlRUIlQTUlQkMlMjAlRUQlOTglQjglRUMlQjYlOUMlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 여기서, padding 옵션이 있는 토크나이저를 호출합니다.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),ne=new j({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),oe=new j({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),ie=new je({}),{c(){M=n("meta"),ke=o(),he=n("p"),_e=o(),U=n("h1"),k=n("a"),Me=n("span"),m(Z.$$.fragment),Tl=o(),me=n("span"),me.textContent=yl,ve=o(),m(V.$$.fragment),Re=o(),I=n("p"),I.innerHTML=bl,Ce=o(),x=n("p"),x.textContent=gl,Ze=o(),X=n("p"),X.innerHTML=jl,Ve=o(),Q=n("p"),Q.innerHTML=kl,Ie=o(),E=n("p"),E.textContent=_l,xe=o(),w=n("h2"),_=n("a"),Ue=n("span"),m(G.$$.fragment),dl=o(),fe=n("span"),fe.textContent=vl,Xe=o(),$=n("p"),$.textContent=Rl,Qe=o(),m(B.$$.fragment),Ee=o(),W=n("p"),W.innerHTML=Cl,Ge=o(),m(A.$$.fragment),$e=o(),F=n("p"),F.textContent=Zl,Be=o(),m(z.$$.fragment),We=o(),L=n("p"),L.innerHTML=Vl,Ae=o(),m(N.$$.fragment),Fe=o(),y=n("h2"),v=n("a"),we=n("span"),m(H.$$.fragment),hl=o(),Je=n("span"),Je.textContent=Il,ze=o(),D=n("p"),D.innerHTML=xl,Le=o(),m(Y.$$.fragment),Ne=o(),q=n("p"),q.textContent=Xl,He=o(),m(S.$$.fragment),De=o(),O=n("p"),O.innerHTML=Ql,Ye=o(),b=n("h2"),R=n("a"),ye=n("span"),m(P.$$.fragment),Ml=o(),Te=n("span"),Te.textContent=El,qe=o(),K=n("p"),K.innerHTML=Gl,Se=o(),ee=n("p"),ee.innerHTML=$l,Oe=o(),le=n("p"),le.innerHTML=Bl,Pe=o(),m(te.$$.fragment),Ke=o(),se=n("p"),se.innerHTML=Wl,el=o(),m(ne.$$.fragment),ll=o(),ae=n("p"),ae.textContent=Al,tl=o(),m(oe.$$.fragment),sl=o(),re=n("p"),re.innerHTML=Fl,nl=o(),pe=n("p"),pe.textContent=zl,al=o(),g=n("h2"),C=n("a"),be=n("span"),m(ie.$$.fragment),Ul=o(),de=n("span"),de.textContent=Ll,ol=o(),ce=n("p"),ce.textContent=Nl,rl=o(),ue=n("ul"),ue.innerHTML=Hl,pl=o(),ge=n("p"),this.h()},l(e){const t=pt("svelte-1phssyn",document.head);M=a(t,"META",{name:!0,content:!0}),t.forEach(l),ke=r(e),he=a(e,"P",{}),u(he).forEach(l),_e=r(e),U=a(e,"H1",{class:!0});var cl=u(U);k=a(cl,"A",{id:!0,class:!0,href:!0});var Dl=u(k);Me=a(Dl,"SPAN",{});var Yl=u(Me);f(Z.$$.fragment,Yl),Yl.forEach(l),Dl.forEach(l),Tl=r(cl),me=a(cl,"SPAN",{"data-svelte-h":!0}),p(me)!=="svelte-dpi4hl"&&(me.textContent=yl),cl.forEach(l),ve=r(e),f(V.$$.fragment,e),Re=r(e),I=a(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-vhpug6"&&(I.innerHTML=bl),Ce=r(e),x=a(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-mb1ukg"&&(x.textContent=gl),Ze=r(e),X=a(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1f4n09x"&&(X.innerHTML=jl),Ve=r(e),Q=a(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1v6brk3"&&(Q.innerHTML=kl),Ie=r(e),E=a(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-148xdun"&&(E.textContent=_l),xe=r(e),w=a(e,"H2",{class:!0});var ul=u(w);_=a(ul,"A",{id:!0,class:!0,href:!0});var ql=u(_);Ue=a(ql,"SPAN",{});var Sl=u(Ue);f(G.$$.fragment,Sl),Sl.forEach(l),ql.forEach(l),dl=r(ul),fe=a(ul,"SPAN",{"data-svelte-h":!0}),p(fe)!=="svelte-1j0t2ik"&&(fe.textContent=vl),ul.forEach(l),Xe=r(e),$=a(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1njozb7"&&($.textContent=Rl),Qe=r(e),f(B.$$.fragment,e),Ee=r(e),W=a(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-7f6oar"&&(W.innerHTML=Cl),Ge=r(e),f(A.$$.fragment,e),$e=r(e),F=a(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1pc9n8q"&&(F.textContent=Zl),Be=r(e),f(z.$$.fragment,e),We=r(e),L=a(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-epruek"&&(L.innerHTML=Vl),Ae=r(e),f(N.$$.fragment,e),Fe=r(e),y=a(e,"H2",{class:!0});var ml=u(y);v=a(ml,"A",{id:!0,class:!0,href:!0});var Ol=u(v);we=a(Ol,"SPAN",{});var Pl=u(we);f(H.$$.fragment,Pl),Pl.forEach(l),Ol.forEach(l),hl=r(ml),Je=a(ml,"SPAN",{"data-svelte-h":!0}),p(Je)!=="svelte-nw7fd2"&&(Je.textContent=Il),ml.forEach(l),ze=r(e),D=a(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1dwvoc4"&&(D.innerHTML=xl),Le=r(e),f(Y.$$.fragment,e),Ne=r(e),q=a(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-183puqa"&&(q.textContent=Xl),He=r(e),f(S.$$.fragment,e),De=r(e),O=a(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-ssbrjd"&&(O.innerHTML=Ql),Ye=r(e),b=a(e,"H2",{class:!0});var fl=u(b);R=a(fl,"A",{id:!0,class:!0,href:!0});var Kl=u(R);ye=a(Kl,"SPAN",{});var et=u(ye);f(P.$$.fragment,et),et.forEach(l),Kl.forEach(l),Ml=r(fl),Te=a(fl,"SPAN",{"data-svelte-h":!0}),p(Te)!=="svelte-1b9slst"&&(Te.textContent=El),fl.forEach(l),qe=r(e),K=a(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1n4in8p"&&(K.innerHTML=Gl),Se=r(e),ee=a(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-h9m36e"&&(ee.innerHTML=$l),Oe=r(e),le=a(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1s012xi"&&(le.innerHTML=Bl),Pe=r(e),f(te.$$.fragment,e),Ke=r(e),se=a(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-f28hgm"&&(se.innerHTML=Wl),el=r(e),f(ne.$$.fragment,e),ll=r(e),ae=a(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1slt67r"&&(ae.textContent=Al),tl=r(e),f(oe.$$.fragment,e),sl=r(e),re=a(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-15kvfy2"&&(re.innerHTML=Fl),nl=r(e),pe=a(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-18p6eo2"&&(pe.textContent=zl),al=r(e),g=a(e,"H2",{class:!0});var Jl=u(g);C=a(Jl,"A",{id:!0,class:!0,href:!0});var lt=u(C);be=a(lt,"SPAN",{});var tt=u(be);f(ie.$$.fragment,tt),tt.forEach(l),lt.forEach(l),Ul=r(Jl),de=a(Jl,"SPAN",{"data-svelte-h":!0}),p(de)!=="svelte-1d5s2qp"&&(de.textContent=Ll),Jl.forEach(l),ol=r(e),ce=a(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-36wvdw"&&(ce.textContent=Nl),rl=r(e),ue=a(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-wv6sfd"&&(ue.innerHTML=Hl),pl=r(e),ge=a(e,"P",{}),u(ge).forEach(l),this.h()},h(){i(M,"name","hf:doc:metadata"),i(M,"content",JSON.stringify(ut)),i(k,"id","xla-integration-for-tensorflow-models"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#xla-integration-for-tensorflow-models"),i(U,"class","relative group"),i(_,"id","running-tf-functions-with-xla"),i(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(_,"href","#running-tf-functions-with-xla"),i(w,"class","relative group"),i(v,"id","running-a-tf-text-generation-model-with-xla-from-transformers"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#running-a-tf-text-generation-model-with-xla-from-transformers"),i(y,"class","relative group"),i(R,"id","gotchas-to-be-aware-of"),i(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(R,"href","#gotchas-to-be-aware-of"),i(b,"class","relative group"),i(C,"id","additional-resources"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#additional-resources"),i(g,"class","relative group")},m(e,t){c(document.head,M),s(e,ke,t),s(e,he,t),s(e,_e,t),s(e,U,t),c(U,k),c(k,Me),J(Z,Me,null),c(U,Tl),c(U,me),s(e,ve,t),J(V,e,t),s(e,Re,t),s(e,I,t),s(e,Ce,t),s(e,x,t),s(e,Ze,t),s(e,X,t),s(e,Ve,t),s(e,Q,t),s(e,Ie,t),s(e,E,t),s(e,xe,t),s(e,w,t),c(w,_),c(_,Ue),J(G,Ue,null),c(w,dl),c(w,fe),s(e,Xe,t),s(e,$,t),s(e,Qe,t),J(B,e,t),s(e,Ee,t),s(e,W,t),s(e,Ge,t),J(A,e,t),s(e,$e,t),s(e,F,t),s(e,Be,t),J(z,e,t),s(e,We,t),s(e,L,t),s(e,Ae,t),J(N,e,t),s(e,Fe,t),s(e,y,t),c(y,v),c(v,we),J(H,we,null),c(y,hl),c(y,Je),s(e,ze,t),s(e,D,t),s(e,Le,t),J(Y,e,t),s(e,Ne,t),s(e,q,t),s(e,He,t),J(S,e,t),s(e,De,t),s(e,O,t),s(e,Ye,t),s(e,b,t),c(b,R),c(R,ye),J(P,ye,null),c(b,Ml),c(b,Te),s(e,qe,t),s(e,K,t),s(e,Se,t),s(e,ee,t),s(e,Oe,t),s(e,le,t),s(e,Pe,t),J(te,e,t),s(e,Ke,t),s(e,se,t),s(e,el,t),J(ne,e,t),s(e,ll,t),s(e,ae,t),s(e,tl,t),J(oe,e,t),s(e,sl,t),s(e,re,t),s(e,nl,t),s(e,pe,t),s(e,al,t),s(e,g,t),c(g,C),c(C,be),J(ie,be,null),c(g,Ul),c(g,de),s(e,ol,t),s(e,ce,t),s(e,rl,t),s(e,ue,t),s(e,pl,t),s(e,ge,t),il=!0},p:nt,i(e){il||(T(Z.$$.fragment,e),T(V.$$.fragment,e),T(G.$$.fragment,e),T(B.$$.fragment,e),T(A.$$.fragment,e),T(z.$$.fragment,e),T(N.$$.fragment,e),T(H.$$.fragment,e),T(Y.$$.fragment,e),T(S.$$.fragment,e),T(P.$$.fragment,e),T(te.$$.fragment,e),T(ne.$$.fragment,e),T(oe.$$.fragment,e),T(ie.$$.fragment,e),il=!0)},o(e){d(Z.$$.fragment,e),d(V.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(A.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),il=!1},d(e){e&&(l(ke),l(he),l(_e),l(U),l(ve),l(Re),l(I),l(Ce),l(x),l(Ze),l(X),l(Ve),l(Q),l(Ie),l(E),l(xe),l(w),l(Xe),l($),l(Qe),l(Ee),l(W),l(Ge),l($e),l(F),l(Be),l(We),l(L),l(Ae),l(Fe),l(y),l(ze),l(D),l(Le),l(Ne),l(q),l(He),l(De),l(O),l(Ye),l(b),l(qe),l(K),l(Se),l(ee),l(Oe),l(le),l(Pe),l(Ke),l(se),l(el),l(ll),l(ae),l(tl),l(sl),l(re),l(nl),l(pe),l(al),l(g),l(ol),l(ce),l(rl),l(ue),l(pl),l(ge)),l(M),h(Z),h(V,e),h(G),h(B,e),h(A,e),h(z,e),h(N,e),h(H),h(Y,e),h(S,e),h(P),h(te,e),h(ne,e),h(oe,e),h(ie)}}}const ut={local:"xla-integration-for-tensorflow-models",sections:[{local:"running-tf-functions-with-xla",title:"XLA를 사용하여 TF 함수 실행하기 "},{local:"running-a-tf-text-generation-model-with-xla-from-transformers",title:"🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기 "},{local:"gotchas-to-be-aware-of",title:"주의할 점 "},{local:"additional-resources",title:"추가 자료 "}],title:"TensorFlow 모델을 위한 XLA 통합 "};function mt(wl){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mt extends ot{constructor(M){super(),rt(this,M,mt,ct,st,{})}}export{Mt as component};
