import{s as kt,n as $t,o as Zt}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as vt,g as p,s as l,r as i,A as Nt,h as m,f as a,c as n,j as It,u as o,x as r,k as Ct,y as xt,a as e,v as c,d as h,t as M,w as g}from"../chunks/index.c9bcf812.js";import{C as Y}from"../chunks/CodeBlock.94efc595.js";import{H as _}from"../chunks/Heading.3c6e5b17.js";function Bt(Mt){let J,X,V,z,y,H,d,gt='<strong>CSPDarknet53</strong> is a convolutional neural network and backbone for object detection that uses <a href="https://paperswithcode.com/method/darknet-53" rel="nofollow">DarkNet-53</a>. It employs a CSPNet strategy to partition the feature map of the base layer into two parts and then merges them through a cross-stage hierarchy. The use of a split and merge strategy allows for more gradient flow through the network.',S,w,Jt='This CNN is used as the backbone for <a href="https://paperswithcode.com/method/yolov4" rel="nofollow">YOLOv4</a>.',A,j,F,T,yt="To load a pretrained model:",L,u,D,f,dt="To load and preprocess the image:",P,b,q,U,wt="To get the model predictions:",K,I,O,C,jt="To get the top-5 predictions class names:",tt,k,st,$,Tt="Replace the model name with the variant you want to use, e.g. <code>cspdarknet53</code>. You can find the IDs in the model summaries at the top of this page.",at,Z,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,W,lt,v,ft="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,N,pt,x,bt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,B,it,G,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,E,rt,Q,ct,R,ht;return y=new _({props:{title:"CSP-DarkNet",local:"csp-darknet",headingTag:"h1"}}),j=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Y({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2NzcGRhcmtuZXQ1MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspdarknet53&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Y({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new Y({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new Y({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Y({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnY3NwZGFya25ldDUzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;cspdarknet53&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new Y({props:{code:"JTQwbWlzYyU3QmJvY2hrb3Zza2l5MjAyMHlvbG92NCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCWU9MT3Y0JTNBJTIwT3B0aW1hbCUyMFNwZWVkJTIwYW5kJTIwQWNjdXJhY3klMjBvZiUyME9iamVjdCUyMERldGVjdGlvbiU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkFsZXhleSUyMEJvY2hrb3Zza2l5JTIwYW5kJTIwQ2hpZW4tWWFvJTIwV2FuZyUyMGFuZCUyMEhvbmctWXVhbiUyME1hcmslMjBMaWFvJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDA0LjEwOTM0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{bochkovskiy2020yolov4,
      title={YOLOv4: Optimal Speed and Accuracy of Object Detection}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2004.10934}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){J=p("meta"),X=l(),V=p("p"),z=l(),i(y.$$.fragment),H=l(),d=p("p"),d.innerHTML=gt,S=l(),w=p("p"),w.innerHTML=Jt,A=l(),i(j.$$.fragment),F=l(),T=p("p"),T.textContent=yt,L=l(),i(u.$$.fragment),D=l(),f=p("p"),f.textContent=dt,P=l(),i(b.$$.fragment),q=l(),U=p("p"),U.textContent=wt,K=l(),i(I.$$.fragment),O=l(),C=p("p"),C.textContent=jt,tt=l(),i(k.$$.fragment),st=l(),$=p("p"),$.innerHTML=Tt,at=l(),Z=p("p"),Z.innerHTML=ut,et=l(),i(W.$$.fragment),lt=l(),v=p("p"),v.textContent=ft,nt=l(),i(N.$$.fragment),pt=l(),x=p("p"),x.innerHTML=bt,mt=l(),i(B.$$.fragment),it=l(),G=p("p"),G.innerHTML=Ut,ot=l(),i(E.$$.fragment),rt=l(),i(Q.$$.fragment),ct=l(),R=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(a),X=n(t),V=m(t,"P",{}),It(V).forEach(a),z=n(t),o(y.$$.fragment,t),H=n(t),d=m(t,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1qc4wgd"&&(d.innerHTML=gt),S=n(t),w=m(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1czs39f"&&(w.innerHTML=Jt),A=n(t),o(j.$$.fragment,t),F=n(t),T=m(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ywhxh"&&(T.textContent=yt),L=n(t),o(u.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1c2ipa8"&&(f.textContent=dt),P=n(t),o(b.$$.fragment,t),q=n(t),U=m(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=wt),K=n(t),o(I.$$.fragment,t),O=n(t),C=m(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-19cnvx1"&&(C.textContent=jt),tt=n(t),o(k.$$.fragment,t),st=n(t),$=m(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1xzvjrb"&&($.innerHTML=Tt),at=n(t),Z=m(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=ut),et=n(t),o(W.$$.fragment,t),lt=n(t),v=m(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-9sr7nh"&&(v.textContent=ft),nt=n(t),o(N.$$.fragment,t),pt=n(t),x=m(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1kguc51"&&(x.innerHTML=bt),mt=n(t),o(B.$$.fragment,t),it=n(t),G=m(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1n0coha"&&(G.innerHTML=Ut),ot=n(t),o(E.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ct=n(t),R=m(t,"P",{}),It(R).forEach(a),this.h()},h(){Ct(J,"name","hf:doc:metadata"),Ct(J,"content",Gt)},m(t,s){xt(document.head,J),e(t,X,s),e(t,V,s),e(t,z,s),c(y,t,s),e(t,H,s),e(t,d,s),e(t,S,s),e(t,w,s),e(t,A,s),c(j,t,s),e(t,F,s),e(t,T,s),e(t,L,s),c(u,t,s),e(t,D,s),e(t,f,s),e(t,P,s),c(b,t,s),e(t,q,s),e(t,U,s),e(t,K,s),c(I,t,s),e(t,O,s),e(t,C,s),e(t,tt,s),c(k,t,s),e(t,st,s),e(t,$,s),e(t,at,s),e(t,Z,s),e(t,et,s),c(W,t,s),e(t,lt,s),e(t,v,s),e(t,nt,s),c(N,t,s),e(t,pt,s),e(t,x,s),e(t,mt,s),c(B,t,s),e(t,it,s),e(t,G,s),e(t,ot,s),c(E,t,s),e(t,rt,s),c(Q,t,s),e(t,ct,s),e(t,R,s),ht=!0},p:$t,i(t){ht||(h(y.$$.fragment,t),h(j.$$.fragment,t),h(u.$$.fragment,t),h(b.$$.fragment,t),h(I.$$.fragment,t),h(k.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),ht=!0)},o(t){M(y.$$.fragment,t),M(j.$$.fragment,t),M(u.$$.fragment,t),M(b.$$.fragment,t),M(I.$$.fragment,t),M(k.$$.fragment,t),M(W.$$.fragment,t),M(N.$$.fragment,t),M(B.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),ht=!1},d(t){t&&(a(X),a(V),a(z),a(H),a(d),a(S),a(w),a(A),a(F),a(T),a(L),a(D),a(f),a(P),a(q),a(U),a(K),a(O),a(C),a(tt),a(st),a($),a(at),a(Z),a(et),a(lt),a(v),a(nt),a(pt),a(x),a(mt),a(it),a(G),a(ot),a(rt),a(ct),a(R)),a(J),g(y,t),g(j,t),g(u,t),g(b,t),g(I,t),g(k,t),g(W,t),g(N,t),g(B,t),g(E,t),g(Q,t)}}}const Gt='{"title":"CSP-DarkNet","local":"csp-darknet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Et(Mt){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends Wt{constructor(J){super(),vt(this,J,Et,Bt,kt,{})}}export{_t as component};
