import{s as fs,n as Cs,o as Is}from"../chunks/scheduler.85c25b89.js";import{S as Zs,i as ks,g as p,s as a,r as i,A as Bs,h as m,f as t,c as n,j as Us,u as M,x as h,k as us,y as $s,a as e,v as o,d as r,t as c,w as y}from"../chunks/index.c9bcf812.js";import{C as x}from"../chunks/CodeBlock.94efc595.js";import{H as S}from"../chunks/Heading.3c6e5b17.js";function Ws(rs){let J,V,v,Y,j,X,w,cs='<strong>MobileNetV2</strong> is a convolutional neural network architecture that seeks to perform well on mobile devices. It is based on an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual structure</a> where the residual connections are between the bottleneck layers.  The intermediate expansion layer uses lightweight depthwise convolutions to filter features as a source of non-linearity. As a whole, the architecture of MobileNetV2 contains the initial fully convolution layer with 32 filters, followed by 19 residual bottleneck layers.',_,T,H,d,ys="To load a pretrained model:",z,g,F,b,hs="To load and preprocess the image:",D,U,L,u,Js="To get the model predictions:",q,f,P,C,js="To get the top-5 predictions class names:",K,I,O,Z,ws="Replace the model name with the variant you want to use, e.g. <code>mobilenetv2_100</code>. You can find the IDs in the model summaries at the top of this page.",ss,k,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,B,ts,$,ds="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",es,W,as,N,gs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,E,ps,Q,bs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,A,is,G,Ms,R,os;return j=new S({props:{title:"MobileNet v2",local:"mobilenet-v2",headingTag:"h1"}}),T=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),g=new x({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYyXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),U=new x({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new x({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new x({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djJfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),A=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),G=new x({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTgwMS0wNDM4MSUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3Qk1hcmslMjBTYW5kbGVyJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQW5kcmV3JTIwRy4lMjBIb3dhcmQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNZW5nbG9uZyUyMFpodSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFuZHJleSUyMFpobW9naW5vdiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExpYW5nJTdCLSU3RENoaWVoJTIwQ2hlbiU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCSW52ZXJ0ZWQlMjBSZXNpZHVhbHMlMjBhbmQlMjBMaW5lYXIlMjBCb3R0bGVuZWNrcyUzQSUyME1vYmlsZSUyME5ldHdvcmtzJTIwZm9yJTIwQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXRlY3Rpb24lMjBhbmQlMjBTZWdtZW50YXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE4MDEuMDQzODElN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxOCU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxODAxLjA0MzgxJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTgwMS4wNDM4MSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QlR1ZSUyQyUyMDEyJTIwSmFuJTIwMjAyMSUyMDE1JTNBMzAlM0EwNiUyMCUyQjAxMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGYWJzLTE4MDEtMDQzODEuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>,
  author    = {Mark Sandler and
               Andrew G. Howard and
               Menglong Zhu and
               Andrey Zhmoginov and
               Liang{-}Chieh Chen},
  title     = {Inverted Residuals and Linear Bottlenecks: Mobile Networks <span class="hljs-keyword">for</span> Classification,
               Detection and Segmentation},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1801.04381</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1801.04381</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1801.04381</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),{c(){J=p("meta"),V=a(),v=p("p"),Y=a(),i(j.$$.fragment),X=a(),w=p("p"),w.innerHTML=cs,_=a(),i(T.$$.fragment),H=a(),d=p("p"),d.textContent=ys,z=a(),i(g.$$.fragment),F=a(),b=p("p"),b.textContent=hs,D=a(),i(U.$$.fragment),L=a(),u=p("p"),u.textContent=Js,q=a(),i(f.$$.fragment),P=a(),C=p("p"),C.textContent=js,K=a(),i(I.$$.fragment),O=a(),Z=p("p"),Z.innerHTML=ws,ss=a(),k=p("p"),k.innerHTML=Ts,ls=a(),i(B.$$.fragment),ts=a(),$=p("p"),$.textContent=ds,es=a(),i(W.$$.fragment),as=a(),N=p("p"),N.innerHTML=gs,ns=a(),i(E.$$.fragment),ps=a(),Q=p("p"),Q.innerHTML=bs,ms=a(),i(A.$$.fragment),is=a(),i(G.$$.fragment),Ms=a(),R=p("p"),this.h()},l(s){const l=Bs("svelte-u9bgzb",document.head);J=m(l,"META",{name:!0,content:!0}),l.forEach(t),V=n(s),v=m(s,"P",{}),Us(v).forEach(t),Y=n(s),M(j.$$.fragment,s),X=n(s),w=m(s,"P",{"data-svelte-h":!0}),h(w)!=="svelte-fgcsw6"&&(w.innerHTML=cs),_=n(s),M(T.$$.fragment,s),H=n(s),d=m(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-18ywhxh"&&(d.textContent=ys),z=n(s),M(g.$$.fragment,s),F=n(s),b=m(s,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1c2ipa8"&&(b.textContent=hs),D=n(s),M(U.$$.fragment,s),L=n(s),u=m(s,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1n9qsq1"&&(u.textContent=Js),q=n(s),M(f.$$.fragment,s),P=n(s),C=m(s,"P",{"data-svelte-h":!0}),h(C)!=="svelte-19cnvx1"&&(C.textContent=js),K=n(s),M(I.$$.fragment,s),O=n(s),Z=m(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-11s0yt3"&&(Z.innerHTML=ws),ss=n(s),k=m(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Ts),ls=n(s),M(B.$$.fragment,s),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-9sr7nh"&&($.textContent=ds),es=n(s),M(W.$$.fragment,s),as=n(s),N=m(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1kguc51"&&(N.innerHTML=gs),ns=n(s),M(E.$$.fragment,s),ps=n(s),Q=m(s,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1n0coha"&&(Q.innerHTML=bs),ms=n(s),M(A.$$.fragment,s),is=n(s),M(G.$$.fragment,s),Ms=n(s),R=m(s,"P",{}),Us(R).forEach(t),this.h()},h(){us(J,"name","hf:doc:metadata"),us(J,"content",Ns)},m(s,l){$s(document.head,J),e(s,V,l),e(s,v,l),e(s,Y,l),o(j,s,l),e(s,X,l),e(s,w,l),e(s,_,l),o(T,s,l),e(s,H,l),e(s,d,l),e(s,z,l),o(g,s,l),e(s,F,l),e(s,b,l),e(s,D,l),o(U,s,l),e(s,L,l),e(s,u,l),e(s,q,l),o(f,s,l),e(s,P,l),e(s,C,l),e(s,K,l),o(I,s,l),e(s,O,l),e(s,Z,l),e(s,ss,l),e(s,k,l),e(s,ls,l),o(B,s,l),e(s,ts,l),e(s,$,l),e(s,es,l),o(W,s,l),e(s,as,l),e(s,N,l),e(s,ns,l),o(E,s,l),e(s,ps,l),e(s,Q,l),e(s,ms,l),o(A,s,l),e(s,is,l),o(G,s,l),e(s,Ms,l),e(s,R,l),os=!0},p:Cs,i(s){os||(r(j.$$.fragment,s),r(T.$$.fragment,s),r(g.$$.fragment,s),r(U.$$.fragment,s),r(f.$$.fragment,s),r(I.$$.fragment,s),r(B.$$.fragment,s),r(W.$$.fragment,s),r(E.$$.fragment,s),r(A.$$.fragment,s),r(G.$$.fragment,s),os=!0)},o(s){c(j.$$.fragment,s),c(T.$$.fragment,s),c(g.$$.fragment,s),c(U.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(B.$$.fragment,s),c(W.$$.fragment,s),c(E.$$.fragment,s),c(A.$$.fragment,s),c(G.$$.fragment,s),os=!1},d(s){s&&(t(V),t(v),t(Y),t(X),t(w),t(_),t(H),t(d),t(z),t(F),t(b),t(D),t(L),t(u),t(q),t(P),t(C),t(K),t(O),t(Z),t(ss),t(k),t(ls),t(ts),t($),t(es),t(as),t(N),t(ns),t(ps),t(Q),t(ms),t(is),t(Ms),t(R)),t(J),y(j,s),y(T,s),y(g,s),y(U,s),y(f,s),y(I,s),y(B,s),y(W,s),y(E,s),y(A,s),y(G,s)}}}const Ns='{"title":"MobileNet v2","local":"mobilenet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Es(rs){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vs extends Zs{constructor(J){super(),ks(this,J,Es,Ws,fs,{})}}export{vs as component};
