import{s as Ct,o as Zt,n as jt}from"../chunks/scheduler.182ea377.js";import{S as Dt,i as Ut,g as a,s,r as g,A as Et,h as r,f as n,c as o,j as L,u,x as m,k as $,y as t,a as l,v as h,d as _,t as v,w as b}from"../chunks/index.abf12888.js";import{T as Wt}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as Ht}from"../chunks/CodeBlock.57fe6e13.js";import{E as Bt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Ae}from"../chunks/Heading.16916d63.js";function At(ae){let d,V='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines. Also, to know more about reducing the memory usage of this pipeline, refer to the [“Reduce memory usage”] section <a href="../../using-diffusers/svd#reduce-memory-usage">here</a>.';return{c(){d=a("p"),d.innerHTML=V},l(x){d=r(x,"P",{"data-svelte-h":!0}),m(d)!=="svelte-12x7hfk"&&(d.innerHTML=V)},m(x,I){l(x,d,I)},p:jt,d(x){x&&n(d)}}}function zt(ae){let d,V="Examples:",x,I,w;return I=new Ht({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSTJWR2VuWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwSTJWR2VuWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYWxpLXZpbGFiJTJGaTJ2Z2VuLXhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFpbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZhbGktdmlsYWIlMkZpMnZnZW4teGwlMkZibG9iJTJGbWFpbiUyRmRhdGElMkZ0ZXN0X2ltYWdlcyUyRmltZ18wMDA5LnBuZyUzRnJhdyUzRHRydWUlMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoaW1hZ2VfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJQYXBlcnMlMjB3ZXJlJTIwZmxvYXRpbmclMjBpbiUyMHRoZSUyMGFpciUyMG9uJTIwYSUyMHRhYmxlJTIwaW4lMjB0aGUlMjBsaWJyYXJ5JTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyRGlzdG9ydGVkJTJDJTIwZGlzY29udGludW91cyUyQyUyMFVnbHklMkMlMjBibHVycnklMkMlMjBsb3clMjByZXNvbHV0aW9uJTJDJTIwbW90aW9ubGVzcyUyQyUyMHN0YXRpYyUyQyUyMGRpc2ZpZ3VyZWQlMkMlMjBkaXNjb25uZWN0ZWQlMjBsaW1icyUyQyUyMFVnbHklMjBmYWNlcyUyQyUyMGluY29tcGxldGUlMjBhcm1zJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoODg4OCklMEElMEFmcmFtZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q5LjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMEEpLmZyYW1lcyU1QjAlNUQlMEF2aWRlb19wYXRoJTIwJTNEJTIwZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJpMnYuZ2lmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> I2VGenXLPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = I2VGenXLPipeline.from_pretrained(<span class="hljs-string">&quot;ali-vilab/i2vgen-xl&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;https://github.com/ali-vilab/i2vgen-xl/blob/main/data/test_images/img_0009.png?raw=true&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(image_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Papers were floating in the air on a table in the library&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Distorted, discontinuous, Ugly, blurry, low resolution, motionless, static, disfigured, disconnected limbs, Ugly faces, incomplete arms&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">8888</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>frames = pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">9.0</span>,
<span class="hljs-meta">... </span>    generator=generator
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = export_to_gif(frames, <span class="hljs-string">&quot;i2v.gif&quot;</span>)`,wrap:!1}}),{c(){d=a("p"),d.textContent=V,x=s(),g(I.$$.fragment)},l(f){d=r(f,"P",{"data-svelte-h":!0}),m(d)!=="svelte-kvfsh7"&&(d.textContent=V),x=o(f),u(I.$$.fragment,f)},m(f,T){l(f,d,T),l(f,x,T),h(I,f,T),w=!0},p:jt,i(f){w||(_(I.$$.fragment,f),w=!0)},o(f){v(I.$$.fragment,f),w=!1},d(f){f&&(n(d),n(x)),b(I,f)}}}function Rt(ae){let d,V,x,I,w,f,T,ft='<a href="https://hf.co/papers/2311.04145.pdf" rel="nofollow">I2VGen-XL: High-Quality Image-to-Video Synthesis via Cascaded Diffusion Models</a> by Shiwei Zhang, Jiayu Wang, Yingya Zhang, Kang Zhao, Hangjie Yuan, Zhiwu Qin, Xiang Wang, Deli Zhao, and Jingren Zhou.',ye,H,gt="The abstract from the paper is:",Le,B,ut='<em>Video synthesis has recently made remarkable strides benefiting from the rapid development of diffusion models. However, it still encounters challenges in terms of semantic accuracy, clarity and spatio-temporal continuity. They primarily arise from the scarcity of well-aligned text-video data and the complex inherent structure of videos, making it difficult for the model to simultaneously ensure semantic and qualitative excellence. In this report, we propose a cascaded I2VGen-XL approach that enhances model performance by decoupling these two factors and ensures the alignment of the input data by utilizing static images as a form of crucial guidance. I2VGen-XL consists of two stages: i) the base stage guarantees coherent semantics and preserves content from input images by using two hierarchical encoders, and ii) the refinement stage enhances the video’s details by incorporating an additional brief text and improves the resolution to 1280×720. To improve the diversity, we collect around 35 million single-shot text-video pairs and 6 billion text-image pairs to optimize the model. By this means, I2VGen-XL can simultaneously enhance the semantic accuracy, continuity of details and clarity of generated videos. Through extensive experiments, we have investigated the underlying principles of I2VGen-XL and compared it with current top methods, which can demonstrate its effectiveness on diverse data. The source code and models will be publicly available at <a href="https://i2vgen-xl.github.io/" rel="nofollow">this https URL</a>.</em>',$e,A,ht='The original codebase can be found <a href="https://github.com/ali-vilab/i2vgen-xl/" rel="nofollow">here</a>. The model checkpoints can be found <a href="https://huggingface.co/ali-vilab/" rel="nofollow">here</a>.',Te,k,Me,z,_t="Sample output with I2VGenXL:",Ve,R,vt=`<tbody><tr><td><center>library.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/i2vgen-xl-example.gif" alt="library" style="width: 300px;"/></center></td></tr></tbody>`,Ge,S,Pe,F,bt='<li>I2VGenXL always uses a <code>clip_skip</code> value of 1. This means it leverages the penultimate layer representations from the text encoder of CLIP.</li> <li>It can generate videos of quality that is often on par with <a href="../../using-diffusers/svd">Stable Video Diffusion</a> (SVD).</li> <li>Unlike SVD, it additionally accepts text prompts as inputs.</li> <li>It can generate higher resolution videos.</li> <li>When using the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> (which is default for this pipeline), less than 50 steps for inference leads to bad results.</li>',Xe,N,ke,p,O,ze,re,xt='Pipeline for image-to-video generation as proposed in <a href="https://i2vgen-xl.github.io/" rel="nofollow">I2VGenXL</a>.',Re,le,It=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Se,G,Y,Fe,pe,wt='The call function to the pipeline for image-to-video generation with <a href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.I2VGenXLPipeline">I2VGenXLPipeline</a>.',Ne,J,Oe,j,Q,Ye,de,yt="Disables the FreeU mechanism if enabled.",Qe,C,q,qe,ce,Lt=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ke,Z,K,et,me,$t=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,tt,y,ee,nt,fe,Tt='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',it,ge,Mt="The suffixes after the scaling factors represent the stages where they are being applied.",st,ue,Vt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ot,D,te,at,he,Gt=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,rt,U,ne,lt,_e,Pt=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,pt,E,ie,dt,ve,Xt="Encodes the prompt into text encoder hidden states.",Je,se,je,M,oe,ct,be,kt="Output class for image-to-video pipeline.",mt,xe,Jt=`PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>`,Ce,we,Ze;return w=new Ae({props:{title:"I2VGen-XL",local:"i2vgen-xl",headingTag:"h1"}}),k=new Wt({props:{$$slots:{default:[At]},$$scope:{ctx:ae}}}),S=new Ae({props:{title:"Notes",local:"notes",headingTag:"h2"}}),N=new Ae({props:{title:"I2VGenXLPipeline",local:"diffusers.I2VGenXLPipeline",headingTag:"h2"}}),O=new P({props:{name:"class diffusers.I2VGenXLPipeline",anchor:"diffusers.I2VGenXLPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"unet",val:": I2VGenXLUNet"},{name:"scheduler",val:": DDIMScheduler"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.I2VGenXLPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.I2VGenXLPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.I2VGenXLPipeline.unet",description:`<strong>unet</strong> (<code>I2VGenXLUNet</code>) &#x2014;
A <code>I2VGenXLUNet</code> to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.I2VGenXLPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L106"}}),Y=new P({props:{name:"__call__",anchor:"diffusers.I2VGenXLPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = 704"},{name:"width",val:": Optional = 1280"},{name:"target_fps",val:": Optional = 16"},{name:"num_frames",val:": int = 16"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"eta",val:": float = 0.0"},{name:"num_videos_per_prompt",val:": Optional = 1"},{name:"decode_chunk_size",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = 1"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
Image or images to guide image generation. If you provide a tensor, it needs to be compatible with
<a href="https://huggingface.co/lambdalabs/sd-image-variations-diffusers/blob/main/feature_extractor/preprocessor_config.json" rel="nofollow"><code>CLIPImageProcessor</code></a>.`,name:"image"},{anchor:"diffusers.I2VGenXLPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.I2VGenXLPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.I2VGenXLPipeline.__call__.target_fps",description:`<strong>target_fps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Frames per second. The rate at which the generated images shall be exported to a video after generation. This is also used as a &#x201C;micro-condition&#x201D; while generation.`,name:"target_fps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of video frames to generate.`,name:"num_frames"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps.`,name:"num_inference_steps"},{anchor:"diffusers.I2VGenXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.I2VGenXLPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.__call__.decode_chunk_size",description:`<strong>decode_chunk_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of frames to decode at a time. The higher the chunk size, the higher the temporal consistency
between frames, but also the higher the memory consumption. By default, the decoder will decode all frames at once
for maximal quality. Reduce <code>decode_chunk_size</code> to reduce memory usage.`,name:"decode_chunk_size"},{anchor:"diffusers.I2VGenXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.I2VGenXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.I2VGenXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.I2VGenXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/gligen#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.I2VGenXLPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.I2VGenXLPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/i2vgenxl#diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput"
>pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput</a> or <code>tuple</code></p>
`}}),J=new Bt({props:{anchor:"diffusers.I2VGenXLPipeline.__call__.example",$$slots:{default:[zt]},$$scope:{ctx:ae}}}),Q=new P({props:{name:"disable_freeu",anchor:"diffusers.I2VGenXLPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L569"}}),q=new P({props:{name:"disable_vae_slicing",anchor:"diffusers.I2VGenXLPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L173"}}),K=new P({props:{name:"disable_vae_tiling",anchor:"diffusers.I2VGenXLPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L190"}}),ee=new P({props:{name:"enable_freeu",anchor:"diffusers.I2VGenXLPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.I2VGenXLPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L546"}}),te=new P({props:{name:"enable_vae_slicing",anchor:"diffusers.I2VGenXLPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L165"}}),ne=new P({props:{name:"enable_vae_tiling",anchor:"diffusers.I2VGenXLPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L181"}}),ie=new P({props:{name:"encode_prompt",anchor:"diffusers.I2VGenXLPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_videos_per_prompt",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_videos_per_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.I2VGenXLPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L197"}}),se=new Ae({props:{title:"I2VGenXLPipelineOutput",local:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",headingTag:"h2"}}),oe=new P({props:{name:"class diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput",parameters:[{name:"frames",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing denoised`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/i2vgen_xl/pipeline_i2vgen_xl.py#L91"}}),{c(){d=a("meta"),V=s(),x=a("p"),I=s(),g(w.$$.fragment),f=s(),T=a("p"),T.innerHTML=ft,ye=s(),H=a("p"),H.textContent=gt,Le=s(),B=a("p"),B.innerHTML=ut,$e=s(),A=a("p"),A.innerHTML=ht,Te=s(),g(k.$$.fragment),Me=s(),z=a("p"),z.textContent=_t,Ve=s(),R=a("table"),R.innerHTML=vt,Ge=s(),g(S.$$.fragment),Pe=s(),F=a("ul"),F.innerHTML=bt,Xe=s(),g(N.$$.fragment),ke=s(),p=a("div"),g(O.$$.fragment),ze=s(),re=a("p"),re.innerHTML=xt,Re=s(),le=a("p"),le.innerHTML=It,Se=s(),G=a("div"),g(Y.$$.fragment),Fe=s(),pe=a("p"),pe.innerHTML=wt,Ne=s(),g(J.$$.fragment),Oe=s(),j=a("div"),g(Q.$$.fragment),Ye=s(),de=a("p"),de.textContent=yt,Qe=s(),C=a("div"),g(q.$$.fragment),qe=s(),ce=a("p"),ce.innerHTML=Lt,Ke=s(),Z=a("div"),g(K.$$.fragment),et=s(),me=a("p"),me.innerHTML=$t,tt=s(),y=a("div"),g(ee.$$.fragment),nt=s(),fe=a("p"),fe.innerHTML=Tt,it=s(),ge=a("p"),ge.textContent=Mt,st=s(),ue=a("p"),ue.innerHTML=Vt,ot=s(),D=a("div"),g(te.$$.fragment),at=s(),he=a("p"),he.textContent=Gt,rt=s(),U=a("div"),g(ne.$$.fragment),lt=s(),_e=a("p"),_e.textContent=Pt,pt=s(),E=a("div"),g(ie.$$.fragment),dt=s(),ve=a("p"),ve.textContent=Xt,Je=s(),g(se.$$.fragment),je=s(),M=a("div"),g(oe.$$.fragment),ct=s(),be=a("p"),be.textContent=kt,mt=s(),xe=a("p"),xe.innerHTML=Jt,Ce=s(),we=a("p"),this.h()},l(e){const i=Et("svelte-u9bgzb",document.head);d=r(i,"META",{name:!0,content:!0}),i.forEach(n),V=o(e),x=r(e,"P",{}),L(x).forEach(n),I=o(e),u(w.$$.fragment,e),f=o(e),T=r(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1wrjkyv"&&(T.innerHTML=ft),ye=o(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1cwsb16"&&(H.textContent=gt),Le=o(e),B=r(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-uj6rwn"&&(B.innerHTML=ut),$e=o(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1okzf4k"&&(A.innerHTML=ht),Te=o(e),u(k.$$.fragment,e),Me=o(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-e24chm"&&(z.textContent=_t),Ve=o(e),R=r(e,"TABLE",{"data-svelte-h":!0}),m(R)!=="svelte-1d0ljr7"&&(R.innerHTML=vt),Ge=o(e),u(S.$$.fragment,e),Pe=o(e),F=r(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-1h7r1o4"&&(F.innerHTML=bt),Xe=o(e),u(N.$$.fragment,e),ke=o(e),p=r(e,"DIV",{class:!0});var c=L(p);u(O.$$.fragment,c),ze=o(c),re=r(c,"P",{"data-svelte-h":!0}),m(re)!=="svelte-va7c9e"&&(re.innerHTML=xt),Re=o(c),le=r(c,"P",{"data-svelte-h":!0}),m(le)!=="svelte-496sm0"&&(le.innerHTML=It),Se=o(c),G=r(c,"DIV",{class:!0});var X=L(G);u(Y.$$.fragment,X),Fe=o(X),pe=r(X,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-wf4rrn"&&(pe.innerHTML=wt),Ne=o(X),u(J.$$.fragment,X),X.forEach(n),Oe=o(c),j=r(c,"DIV",{class:!0});var De=L(j);u(Q.$$.fragment,De),Ye=o(De),de=r(De,"P",{"data-svelte-h":!0}),m(de)!=="svelte-psupw6"&&(de.textContent=yt),De.forEach(n),Qe=o(c),C=r(c,"DIV",{class:!0});var Ue=L(C);u(q.$$.fragment,Ue),qe=o(Ue),ce=r(Ue,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1s3c06i"&&(ce.innerHTML=Lt),Ue.forEach(n),Ke=o(c),Z=r(c,"DIV",{class:!0});var Ee=L(Z);u(K.$$.fragment,Ee),et=o(Ee),me=r(Ee,"P",{"data-svelte-h":!0}),m(me)!=="svelte-pkn4ui"&&(me.innerHTML=$t),Ee.forEach(n),tt=o(c),y=r(c,"DIV",{class:!0});var W=L(y);u(ee.$$.fragment,W),nt=o(W),fe=r(W,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1f3tmq1"&&(fe.innerHTML=Tt),it=o(W),ge=r(W,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-xjijlp"&&(ge.textContent=Mt),st=o(W),ue=r(W,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-hy0nzs"&&(ue.innerHTML=Vt),W.forEach(n),ot=o(c),D=r(c,"DIV",{class:!0});var We=L(D);u(te.$$.fragment,We),at=o(We),he=r(We,"P",{"data-svelte-h":!0}),m(he)!=="svelte-14bnrb6"&&(he.textContent=Gt),We.forEach(n),rt=o(c),U=r(c,"DIV",{class:!0});var He=L(U);u(ne.$$.fragment,He),lt=o(He),_e=r(He,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1xwrf7t"&&(_e.textContent=Pt),He.forEach(n),pt=o(c),E=r(c,"DIV",{class:!0});var Be=L(E);u(ie.$$.fragment,Be),dt=o(Be),ve=r(Be,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-16q0ax1"&&(ve.textContent=Xt),Be.forEach(n),c.forEach(n),Je=o(e),u(se.$$.fragment,e),je=o(e),M=r(e,"DIV",{class:!0});var Ie=L(M);u(oe.$$.fragment,Ie),ct=o(Ie),be=r(Ie,"P",{"data-svelte-h":!0}),m(be)!=="svelte-ulnuw9"&&(be.textContent=kt),mt=o(Ie),xe=r(Ie,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-gk6g69"&&(xe.innerHTML=Jt),Ie.forEach(n),Ce=o(e),we=r(e,"P",{}),L(we).forEach(n),this.h()},h(){$(d,"name","hf:doc:metadata"),$(d,"content",St),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,d),l(e,V,i),l(e,x,i),l(e,I,i),h(w,e,i),l(e,f,i),l(e,T,i),l(e,ye,i),l(e,H,i),l(e,Le,i),l(e,B,i),l(e,$e,i),l(e,A,i),l(e,Te,i),h(k,e,i),l(e,Me,i),l(e,z,i),l(e,Ve,i),l(e,R,i),l(e,Ge,i),h(S,e,i),l(e,Pe,i),l(e,F,i),l(e,Xe,i),h(N,e,i),l(e,ke,i),l(e,p,i),h(O,p,null),t(p,ze),t(p,re),t(p,Re),t(p,le),t(p,Se),t(p,G),h(Y,G,null),t(G,Fe),t(G,pe),t(G,Ne),h(J,G,null),t(p,Oe),t(p,j),h(Q,j,null),t(j,Ye),t(j,de),t(p,Qe),t(p,C),h(q,C,null),t(C,qe),t(C,ce),t(p,Ke),t(p,Z),h(K,Z,null),t(Z,et),t(Z,me),t(p,tt),t(p,y),h(ee,y,null),t(y,nt),t(y,fe),t(y,it),t(y,ge),t(y,st),t(y,ue),t(p,ot),t(p,D),h(te,D,null),t(D,at),t(D,he),t(p,rt),t(p,U),h(ne,U,null),t(U,lt),t(U,_e),t(p,pt),t(p,E),h(ie,E,null),t(E,dt),t(E,ve),l(e,Je,i),h(se,e,i),l(e,je,i),l(e,M,i),h(oe,M,null),t(M,ct),t(M,be),t(M,mt),t(M,xe),l(e,Ce,i),l(e,we,i),Ze=!0},p(e,[i]){const c={};i&2&&(c.$$scope={dirty:i,ctx:e}),k.$set(c);const X={};i&2&&(X.$$scope={dirty:i,ctx:e}),J.$set(X)},i(e){Ze||(_(w.$$.fragment,e),_(k.$$.fragment,e),_(S.$$.fragment,e),_(N.$$.fragment,e),_(O.$$.fragment,e),_(Y.$$.fragment,e),_(J.$$.fragment,e),_(Q.$$.fragment,e),_(q.$$.fragment,e),_(K.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(oe.$$.fragment,e),Ze=!0)},o(e){v(w.$$.fragment,e),v(k.$$.fragment,e),v(S.$$.fragment,e),v(N.$$.fragment,e),v(O.$$.fragment,e),v(Y.$$.fragment,e),v(J.$$.fragment,e),v(Q.$$.fragment,e),v(q.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(ie.$$.fragment,e),v(se.$$.fragment,e),v(oe.$$.fragment,e),Ze=!1},d(e){e&&(n(V),n(x),n(I),n(f),n(T),n(ye),n(H),n(Le),n(B),n($e),n(A),n(Te),n(Me),n(z),n(Ve),n(R),n(Ge),n(Pe),n(F),n(Xe),n(ke),n(p),n(Je),n(je),n(M),n(Ce),n(we)),n(d),b(w,e),b(k,e),b(S,e),b(N,e),b(O),b(Y),b(J),b(Q),b(q),b(K),b(ee),b(te),b(ne),b(ie),b(se,e),b(oe)}}}const St='{"title":"I2VGen-XL","local":"i2vgen-xl","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"I2VGenXLPipeline","local":"diffusers.I2VGenXLPipeline","sections":[],"depth":2},{"title":"I2VGenXLPipelineOutput","local":"diffusers.pipelines.i2vgen_xl.pipeline_i2vgen_xl.I2VGenXLPipelineOutput","sections":[],"depth":2}],"depth":1}';function Ft(ae){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends Dt{constructor(d){super(),Ut(this,d,Ft,Rt,Ct,{})}}export{tn as component};
