import{s as vt,n as bt,o as St}from"../chunks/scheduler.182ea377.js";import{S as xt,i as Dt,g as i,s as r,r as p,A as $t,h as d,f as s,c as n,j as v,u as m,x as u,k as b,y as t,a as l,v as f,d as h,t as g,w as _}from"../chunks/index.abf12888.js";import{D as S}from"../chunks/Docstring.93f6f462.js";import{H as ke}from"../chunks/Heading.16916d63.js";function Tt(et){let x,ce,ae,ue,F,pe,L,tt='Diffusion Exponential Integrator Sampler (DEIS) is proposed in <a href="https://huggingface.co/papers/2204.13902" rel="nofollow">Fast Sampling of Diffusion Models with Exponential Integrator</a> by Qinsheng Zhang and Yongxin Chen. <code>DEISMultistepScheduler</code> is a fast high order solver for diffusion ordinary differential equations (ODEs).',me,P,st="This implementation modifies the polynomial fitting formula in log-rho space instead of the original linear <code>t</code> space in the DEIS paper. The modification enjoys closed-form coefficients for exponential multistep update instead of replying on the numerical solver.",fe,k,rt="The abstract from the paper is:",he,O,nt='<em>The past few years have witnessed the great success of Diffusion models~(DMs) in generating high-fidelity samples in generative modeling tasks. A major limitation of the DM is its notoriously slow sampling procedure which normally requires hundreds to thousands of time discretization steps of the learned diffusion process to reach the desired accuracy. Our goal is to develop a fast sampling method for DMs with a much less number of steps while retaining high sample quality. To this end, we systematically analyze the sampling procedure in DMs and identify key factors that affect the sample quality, among which the method of discretization is most crucial. By carefully examining the learned diffusion process, we propose Diffusion Exponential Integrator Sampler~(DEIS). It is based on the Exponential Integrator designed for discretizing ordinary differential equations (ODEs) and leverages a semilinear structure of the learned diffusion process to reduce the discretization error. The proposed method can be applied to any DMs and can generate high-fidelity samples in as few as 10 steps. In our experiments, it takes about 3 minutes on one A6000 GPU to generate 50k images from CIFAR10. Moreover, by directly using pre-trained DMs, we achieve the state-of-art sampling performance when the number of score function evaluation~(NFE) is limited, e.g., 4.17 FID with 10 NFEs, 3.37 FID, and 9.74 IS with only 15 NFEs on CIFAR10. Code is available at <a href="https://github.com/qsh-zh/deis" rel="nofollow">this https URL</a>.</em>',ge,q,_e,H,ot='It is recommended to set <code>solver_order</code> to 2 or 3, while <code>solver_order=1</code> is equivalent to <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.',ve,z,it=`Dynamic thresholding from <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen</a> is supported, and for pixel-space
diffusion models, you can set <code>thresholding=True</code> to use the dynamic thresholding.`,be,A,Se,a,V,Oe,Z,dt="<code>DEISMultistepScheduler</code> is a fast high order solver for diffusion ordinary differential equations (ODEs).",qe,J,at=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,He,$,N,ze,X,lt="Convert the model output to the corresponding type the DEIS algorithm needs.",Ae,T,j,Ve,ee,ct="One step for the first-order DEIS (equivalent to DDIM).",Ne,y,R,je,te,ut="One step for the second-order multistep DEIS.",Re,I,U,Ue,se,pt="One step for the third-order multistep DEIS.",We,E,W,Be,re,mt=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep.`,Ye,M,B,Ge,ne,ft="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",Ke,w,Y,Qe,oe,ht="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",Ze,C,G,Je,ie,gt=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DEIS.`,xe,K,De,D,Q,Xe,de,_t="Base class for the output of a scheduler’s <code>step</code> function.",$e,le,Te;return F=new ke({props:{title:"DEISMultistepScheduler",local:"deismultistepscheduler",headingTag:"h1"}}),q=new ke({props:{title:"Tips",local:"tips",headingTag:"h2"}}),A=new ke({props:{title:"DEISMultistepScheduler",local:"diffusers.DEISMultistepScheduler",headingTag:"h2"}}),V=new S({props:{name:"class diffusers.DEISMultistepScheduler",anchor:"diffusers.DEISMultistepScheduler",parameters:[{name:"num_train_timesteps",val:": int = 1000"},{name:"beta_start",val:": float = 0.0001"},{name:"beta_end",val:": float = 0.02"},{name:"beta_schedule",val:": str = 'linear'"},{name:"trained_betas",val:": Optional = None"},{name:"solver_order",val:": int = 2"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"algorithm_type",val:": str = 'deis'"},{name:"solver_type",val:": str = 'logrho'"},{name:"lower_order_final",val:": bool = True"},{name:"use_karras_sigmas",val:": Optional = False"},{name:"timestep_spacing",val:": str = 'linspace'"},{name:"steps_offset",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.DEISMultistepScheduler.beta_start",description:`<strong>beta_start</strong> (<code>float</code>, defaults to 0.0001) &#x2014;
The starting <code>beta</code> value of inference.`,name:"beta_start"},{anchor:"diffusers.DEISMultistepScheduler.beta_end",description:`<strong>beta_end</strong> (<code>float</code>, defaults to 0.02) &#x2014;
The final <code>beta</code> value.`,name:"beta_end"},{anchor:"diffusers.DEISMultistepScheduler.beta_schedule",description:`<strong>beta_schedule</strong> (<code>str</code>, defaults to <code>&quot;linear&quot;</code>) &#x2014;
The beta schedule, a mapping from a beta range to a sequence of betas for stepping the model. Choose from
<code>linear</code>, <code>scaled_linear</code>, or <code>squaredcos_cap_v2</code>.`,name:"beta_schedule"},{anchor:"diffusers.DEISMultistepScheduler.trained_betas",description:`<strong>trained_betas</strong> (<code>np.ndarray</code>, <em>optional</em>) &#x2014;
Pass an array of betas directly to the constructor to bypass <code>beta_start</code> and <code>beta_end</code>.`,name:"trained_betas"},{anchor:"diffusers.DEISMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, defaults to 2) &#x2014;
The DEIS order which can be <code>1</code> or <code>2</code> or <code>3</code>. It is recommended to use <code>solver_order=2</code> for guided
sampling, and <code>solver_order=3</code> for unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.DEISMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.DEISMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.DEISMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.DEISMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code>.`,name:"sample_max_value"},{anchor:"diffusers.DEISMultistepScheduler.algorithm_type",description:`<strong>algorithm_type</strong> (<code>str</code>, defaults to <code>deis</code>) &#x2014;
The algorithm type for the solver.`,name:"algorithm_type"},{anchor:"diffusers.DEISMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps.`,name:"lower_order_final"},{anchor:"diffusers.DEISMultistepScheduler.use_karras_sigmas",description:`<strong>use_karras_sigmas</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Karras sigmas for step sizes in the noise schedule during the sampling process. If <code>True</code>,
the sigmas are determined according to a sequence of noise levels {&#x3C3;i}.`,name:"use_karras_sigmas"},{anchor:"diffusers.DEISMultistepScheduler.timestep_spacing",description:`<strong>timestep_spacing</strong> (<code>str</code>, defaults to <code>&quot;linspace&quot;</code>) &#x2014;
The way the timesteps should be scaled. Refer to Table 2 of the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and
Sample Steps are Flawed</a> for more information.`,name:"timestep_spacing"},{anchor:"diffusers.DEISMultistepScheduler.steps_offset",description:`<strong>steps_offset</strong> (<code>int</code>, defaults to 0) &#x2014;
An offset added to the inference steps. You can use a combination of <code>offset=1</code> and
<code>set_alpha_to_one=False</code> to make the last step use step 0 for the previous alpha product like in Stable
Diffusion.`,name:"steps_offset"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L74"}}),N=new S({props:{name:"convert_model_output",anchor:"diffusers.DEISMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DEISMultistepScheduler.convert_model_output.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DEISMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),j=new S({props:{name:"deis_first_order_update",anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update",parameters:[{name:"model_output",val:": FloatTensor"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.prev_timestep",description:`<strong>prev_timestep</strong> (<code>int</code>) &#x2014;
The previous discrete timestep in the diffusion chain.`,name:"prev_timestep"},{anchor:"diffusers.DEISMultistepScheduler.deis_first_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L428",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),R=new S({props:{name:"multistep_deis_second_order_update",anchor:"diffusers.DEISMultistepScheduler.multistep_deis_second_order_update",parameters:[{name:"model_output_list",val:": List"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_second_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_second_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L486",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),U=new S({props:{name:"multistep_deis_third_order_update",anchor:"diffusers.DEISMultistepScheduler.multistep_deis_third_order_update",parameters:[{name:"model_output_list",val:": List"},{name:"*args",val:""},{name:"sample",val:": FloatTensor = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_third_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.DEISMultistepScheduler.multistep_deis_third_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L555",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),W=new S({props:{name:"scale_model_input",anchor:"diffusers.DEISMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L741",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),B=new S({props:{name:"set_begin_index",anchor:"diffusers.DEISMultistepScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L208"}}),Y=new S({props:{name:"set_timesteps",anchor:"diffusers.DEISMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int"},{name:"device",val:": Union = None"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.DEISMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L218"}}),G=new S({props:{name:"step",anchor:"diffusers.DEISMultistepScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": int"},{name:"sample",val:": FloatTensor"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.DEISMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.DEISMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>float</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.DEISMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.DEISMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver_inverse#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_deis_multistep.py#L676",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver_inverse#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver_inverse#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),K=new ke({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),Q=new S({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L50"}}),{c(){x=i("meta"),ce=r(),ae=i("p"),ue=r(),p(F.$$.fragment),pe=r(),L=i("p"),L.innerHTML=tt,me=r(),P=i("p"),P.innerHTML=st,fe=r(),k=i("p"),k.textContent=rt,he=r(),O=i("p"),O.innerHTML=nt,ge=r(),p(q.$$.fragment),_e=r(),H=i("p"),H.innerHTML=ot,ve=r(),z=i("p"),z.innerHTML=it,be=r(),p(A.$$.fragment),Se=r(),a=i("div"),p(V.$$.fragment),Oe=r(),Z=i("p"),Z.innerHTML=dt,qe=r(),J=i("p"),J.innerHTML=at,He=r(),$=i("div"),p(N.$$.fragment),ze=r(),X=i("p"),X.textContent=lt,Ae=r(),T=i("div"),p(j.$$.fragment),Ve=r(),ee=i("p"),ee.textContent=ct,Ne=r(),y=i("div"),p(R.$$.fragment),je=r(),te=i("p"),te.textContent=ut,Re=r(),I=i("div"),p(U.$$.fragment),Ue=r(),se=i("p"),se.textContent=pt,We=r(),E=i("div"),p(W.$$.fragment),Be=r(),re=i("p"),re.textContent=mt,Ye=r(),M=i("div"),p(B.$$.fragment),Ge=r(),ne=i("p"),ne.textContent=ft,Ke=r(),w=i("div"),p(Y.$$.fragment),Qe=r(),oe=i("p"),oe.textContent=ht,Ze=r(),C=i("div"),p(G.$$.fragment),Je=r(),ie=i("p"),ie.textContent=gt,xe=r(),p(K.$$.fragment),De=r(),D=i("div"),p(Q.$$.fragment),Xe=r(),de=i("p"),de.innerHTML=_t,$e=r(),le=i("p"),this.h()},l(e){const o=$t("svelte-u9bgzb",document.head);x=d(o,"META",{name:!0,content:!0}),o.forEach(s),ce=n(e),ae=d(e,"P",{}),v(ae).forEach(s),ue=n(e),m(F.$$.fragment,e),pe=n(e),L=d(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-dg2wky"&&(L.innerHTML=tt),me=n(e),P=d(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-2kur53"&&(P.innerHTML=st),fe=n(e),k=d(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1cwsb16"&&(k.textContent=rt),he=n(e),O=d(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1qgxh8f"&&(O.innerHTML=nt),ge=n(e),m(q.$$.fragment,e),_e=n(e),H=d(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1wcaqyo"&&(H.innerHTML=ot),ve=n(e),z=d(e,"P",{"data-svelte-h":!0}),u(z)!=="svelte-jfe2b1"&&(z.innerHTML=it),be=n(e),m(A.$$.fragment,e),Se=n(e),a=d(e,"DIV",{class:!0});var c=v(a);m(V.$$.fragment,c),Oe=n(c),Z=d(c,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1maiz98"&&(Z.innerHTML=dt),qe=n(c),J=d(c,"P",{"data-svelte-h":!0}),u(J)!=="svelte-linuuh"&&(J.innerHTML=at),He=n(c),$=d(c,"DIV",{class:!0});var ye=v($);m(N.$$.fragment,ye),ze=n(ye),X=d(ye,"P",{"data-svelte-h":!0}),u(X)!=="svelte-10z04zf"&&(X.textContent=lt),ye.forEach(s),Ae=n(c),T=d(c,"DIV",{class:!0});var Ie=v(T);m(j.$$.fragment,Ie),Ve=n(Ie),ee=d(Ie,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-9410ii"&&(ee.textContent=ct),Ie.forEach(s),Ne=n(c),y=d(c,"DIV",{class:!0});var Ee=v(y);m(R.$$.fragment,Ee),je=n(Ee),te=d(Ee,"P",{"data-svelte-h":!0}),u(te)!=="svelte-4wni6b"&&(te.textContent=ut),Ee.forEach(s),Re=n(c),I=d(c,"DIV",{class:!0});var Me=v(I);m(U.$$.fragment,Me),Ue=n(Me),se=d(Me,"P",{"data-svelte-h":!0}),u(se)!=="svelte-cktso6"&&(se.textContent=pt),Me.forEach(s),We=n(c),E=d(c,"DIV",{class:!0});var we=v(E);m(W.$$.fragment,we),Be=n(we),re=d(we,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1rkfgpx"&&(re.textContent=mt),we.forEach(s),Ye=n(c),M=d(c,"DIV",{class:!0});var Ce=v(M);m(B.$$.fragment,Ce),Ge=n(Ce),ne=d(Ce,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1k141rk"&&(ne.textContent=ft),Ce.forEach(s),Ke=n(c),w=d(c,"DIV",{class:!0});var Fe=v(w);m(Y.$$.fragment,Fe),Qe=n(Fe),oe=d(Fe,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-1vzm9q"&&(oe.textContent=ht),Fe.forEach(s),Ze=n(c),C=d(c,"DIV",{class:!0});var Le=v(C);m(G.$$.fragment,Le),Je=n(Le),ie=d(Le,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-vbpl4u"&&(ie.textContent=gt),Le.forEach(s),c.forEach(s),xe=n(e),m(K.$$.fragment,e),De=n(e),D=d(e,"DIV",{class:!0});var Pe=v(D);m(Q.$$.fragment,Pe),Xe=n(Pe),de=d(Pe,"P",{"data-svelte-h":!0}),u(de)!=="svelte-6ojmkw"&&(de.innerHTML=_t),Pe.forEach(s),$e=n(e),le=d(e,"P",{}),v(le).forEach(s),this.h()},h(){b(x,"name","hf:doc:metadata"),b(x,"content",yt),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){t(document.head,x),l(e,ce,o),l(e,ae,o),l(e,ue,o),f(F,e,o),l(e,pe,o),l(e,L,o),l(e,me,o),l(e,P,o),l(e,fe,o),l(e,k,o),l(e,he,o),l(e,O,o),l(e,ge,o),f(q,e,o),l(e,_e,o),l(e,H,o),l(e,ve,o),l(e,z,o),l(e,be,o),f(A,e,o),l(e,Se,o),l(e,a,o),f(V,a,null),t(a,Oe),t(a,Z),t(a,qe),t(a,J),t(a,He),t(a,$),f(N,$,null),t($,ze),t($,X),t(a,Ae),t(a,T),f(j,T,null),t(T,Ve),t(T,ee),t(a,Ne),t(a,y),f(R,y,null),t(y,je),t(y,te),t(a,Re),t(a,I),f(U,I,null),t(I,Ue),t(I,se),t(a,We),t(a,E),f(W,E,null),t(E,Be),t(E,re),t(a,Ye),t(a,M),f(B,M,null),t(M,Ge),t(M,ne),t(a,Ke),t(a,w),f(Y,w,null),t(w,Qe),t(w,oe),t(a,Ze),t(a,C),f(G,C,null),t(C,Je),t(C,ie),l(e,xe,o),f(K,e,o),l(e,De,o),l(e,D,o),f(Q,D,null),t(D,Xe),t(D,de),l(e,$e,o),l(e,le,o),Te=!0},p:bt,i(e){Te||(h(F.$$.fragment,e),h(q.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(N.$$.fragment,e),h(j.$$.fragment,e),h(R.$$.fragment,e),h(U.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(G.$$.fragment,e),h(K.$$.fragment,e),h(Q.$$.fragment,e),Te=!0)},o(e){g(F.$$.fragment,e),g(q.$$.fragment,e),g(A.$$.fragment,e),g(V.$$.fragment,e),g(N.$$.fragment,e),g(j.$$.fragment,e),g(R.$$.fragment,e),g(U.$$.fragment,e),g(W.$$.fragment,e),g(B.$$.fragment,e),g(Y.$$.fragment,e),g(G.$$.fragment,e),g(K.$$.fragment,e),g(Q.$$.fragment,e),Te=!1},d(e){e&&(s(ce),s(ae),s(ue),s(pe),s(L),s(me),s(P),s(fe),s(k),s(he),s(O),s(ge),s(_e),s(H),s(ve),s(z),s(be),s(Se),s(a),s(xe),s(De),s(D),s($e),s(le)),s(x),_(F,e),_(q,e),_(A,e),_(V),_(N),_(j),_(R),_(U),_(W),_(B),_(Y),_(G),_(K,e),_(Q)}}}const yt='{"title":"DEISMultistepScheduler","local":"deismultistepscheduler","sections":[{"title":"Tips","local":"tips","sections":[],"depth":2},{"title":"DEISMultistepScheduler","local":"diffusers.DEISMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function It(et){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends xt{constructor(x){super(),Dt(this,x,It,Tt,vt,{})}}export{Ft as component};
