import{s as Ht,n as qt,o as It}from"../chunks/scheduler.9039eef2.js";import{S as Ot,i as Ut,g as o,s as a,r as m,A as Vt,h as i,f as t,c as n,j as f,u as p,x as u,k as z,y as r,a as d,v as c,d as g,t as h,w as b}from"../chunks/index.cdcc3d35.js";import{D as x}from"../chunks/Docstring.fff63cfc.js";import{H as ze}from"../chunks/Heading.96ce3702.js";function Nt(ut){let T,xe,ve,ye,H,Pe,q,ct="The <code>optimum.neuron.distributed</code> module provides a set of tools to perform distributed training and inference.",Te,I,we,O,gt="The main task in distributed training / inference is being able to shard things such as the model weights, the gradient, and/or the optimizer state. We built <code>Parallelizer</code> classes to handle the sharding.",Ce,U,Me,V,ht="The <code>Parallelizer</code> class is the base abstract class being derived for every model supporting model parallelism. It provides methods to parallelize the model and save and load sharded checkpoints.",Le,s,N,Re,re,bt="Base abstract class that handles model parallelism.",je,C,F,Xe,ae,_t=`Parallelizes the model by transforming regular layer into their parallel counterparts.
Each concrete class must implement it.`,Ge,P,S,Je,ne,ft=`Parallelizes the model by transforming regular layer into their parallel counterparts using
<code>cls._parallelize()</code>.`,Ke,le,zt=`It also makes sure that each parameter has loaded its weights or has been initialized if there is no pre-trained
weights associated to it.`,Qe,$,W,Ye,oe,vt="Creates an optimizer ready for a parallelized model from an existing optimizer.",Ze,ie,$t="There are two cases:",et,de,xt=`<li>The optimizer has been created via a lazy constructor from
<code>optimum.neuron.distributed.utils.make_optimizer_constructor_lazy</code>, it which case the exactly intended optimizer is
created for tensor parallelism.</li> <li>The optimizer was created with a regular constructor. In this case the optimizer for tensor parallelism
is created as close as possible to what was intended but that is not guaranteed.</li>`,tt,se,A,rt,me,B,De,R,ke,j,yt="Each model that supports parallelization in <code>optimum-neuron</code> has its own derived <code>Parallelizer</code> class. The factory class <code>ParallelizersManager</code> allows you to retrieve such model-specific <code>Parallelizer</code>s easily.",Ee,v,X,at,M,G,nt,pe,Pt="Provides the list of supported model types for parallelization.",lt,L,J,ot,ue,Tt="Returns <code>True</code> if the model can be parallelized, <code>False</code> otherwise.",it,D,K,dt,ce,wt="Returns the parallelizer class associated to the model.",He,Q,qe,Y,Ie,Z,Ct="Distributed training / inference is usually needed when the model is too big to fit in one device. Tools that allow for lazy loading of model weights and optimizer states are thus needed to avoid going out-of-memory before parallelization.",Oe,y,ee,st,ge,Mt="Context manager that makes the loading of a model lazy for model parallelism:",mt,he,Lt=`<li>Every <code>torch.nn.Linear</code> is put on the <code>torch.device(&quot;meta&quot;)</code> device, meaning that it takes no memory to
instantiate.</li> <li>Every <code>torch.nn.Embedding</code> is also put on the <code>torch.device(&quot;meta&quot;)</code> device.</li> <li>No state dict is actually loaded, instead a weight map is created and attached to the model. For more
information, read the <code>optimum.neuron.distributed.utils.from_pretrained_for_tp</code> docstring.</li>`,Ue,w,te,pt,be,Dt=`Transforms an optimizer constructor (optimizer class) to make it lazy by not initializing the parameters.
This makes the optimizer lightweight and usable to create a “real” optimizer once the model has been
parallelized.`,Ve,$e,Ne;return H=new ze({props:{title:"Optimum Neuron Distributed",local:"optimum-neuron-distributed",headingTag:"h1"}}),I=new ze({props:{title:"Parallelization",local:"parallelization",headingTag:"h2"}}),U=new ze({props:{title:"Base Parallelizer",local:"optimum.neuron.distributed.Parallelizer",headingTag:"h3"}}),N=new x({props:{name:"class optimum.neuron.distributed.Parallelizer",anchor:"optimum.neuron.distributed.Parallelizer",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L97"}}),F=new x({props:{name:"_parallelize",anchor:"optimum.neuron.distributed.Parallelizer._parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer._parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),S=new x({props:{name:"parallelize",anchor:"optimum.neuron.distributed.Parallelizer.parallelize",parameters:[{name:"model",val:": PreTrainedModel"},{name:"device",val:": Optional = None"},{name:"parallelize_embeddings",val:": bool = True"},{name:"sequence_parallel_enabled",val:": bool = False"},{name:"checkpoint_dir",val:": Union = None"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model to parallelize.`,name:"model"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.device",description:`<strong>device</strong> (<code>Optional[torch.device]</code>, defaults to <code>None</code>) &#x2014;
The device where the new parallel layers should be put.`,name:"device"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.parallelize_embeddings",description:`<strong>parallelize_embeddings</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not the embeddings should be parallelized.
This can be disabled in the case when the TP size does not divide the vocabulary size.`,name:"parallelize_embeddings"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.sequence_parallel_enabled",description:`<strong>sequence_parallel_enabled</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not sequence parallelism is enabled.`,name:"sequence_parallel_enabled"},{anchor:"optimum.neuron.distributed.Parallelizer.parallelize.checkpoint_dir",description:`<strong>checkpoint_dir</strong> (<code>Optional[Union[str, Path]]</code>) &#x2014;
Path to a sharded checkpoint. If specified, the checkpoint weights will be loaded to the parallelized
model.`,name:"checkpoint_dir"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L168",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The parallelized model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PreTrainedModel</code></p>
`}}),W=new x({props:{name:"optimizer_for_tp",anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_tp",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"orig_param_to_parallel_param_on_xla",val:": Mapping"}],parametersDescription:[{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_tp.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
The original optimizer.`,name:"optimizer"},{anchor:"optimum.neuron.distributed.Parallelizer.optimizer_for_tp.orig_param_to_parallel_param_on_xla",description:`<strong>orig_param_to_parallel_param_on_xla</strong> (<code>Mapping[int, torch.nn.Parameter]</code>) &#x2014;
A mapping (e.g. dict-like) that maps the id of a parameter in <code>optimizer</code> to the id of its
parallelized counterpart on an XLA device.`,name:"orig_param_to_parallel_param_on_xla"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor parallelism ready optimizer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.optim.Optimizer</code></p>
`}}),A=new x({props:{name:"save_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.save_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"output_dir",val:": Union"},{name:"as_regular",val:": bool = False"},{name:"as_sharded",val:": bool = True"},{name:"optimizer",val:": Optional = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L549"}}),B=new x({props:{name:"load_model_checkpoint",anchor:"optimum.neuron.distributed.Parallelizer.load_model_checkpoint",parameters:[{name:"model",val:": PreTrainedModel"},{name:"load_dir",val:": Union"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/base.py#L578"}}),R=new ze({props:{title:"Selecting Model-Specific Parallelizer Classes",local:"optimum.neuron.distributed.ParallelizersManager",headingTag:"h3"}}),X=new x({props:{name:"class optimum.neuron.distributed.ParallelizersManager",anchor:"optimum.neuron.distributed.ParallelizersManager",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L51"}}),G=new x({props:{name:"get_supported_model_types",anchor:"optimum.neuron.distributed.ParallelizersManager.get_supported_model_types",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L64"}}),J=new x({props:{name:"is_model_supported",anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.is_model_supported.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L79"}}),K=new x({props:{name:"parallelizer_for_model",anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model",parameters:[{name:"model_type_or_model",val:": Union"}],parametersDescription:[{anchor:"optimum.neuron.distributed.ParallelizersManager.parallelizer_for_model.model_type_or_model",description:`<strong>model_type_or_model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Either the model type or an instance of the model.`,name:"model_type_or_model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/parallelizers_manager.py#L91"}}),Q=new ze({props:{title:"Utils",local:"utils",headingTag:"h2"}}),Y=new ze({props:{title:"Lazy Loading",local:"optimum.neuron.distributed.lazy_load_for_parallelism",headingTag:"h3"}}),ee=new x({props:{name:"optimum.neuron.distributed.lazy_load_for_parallelism",anchor:"optimum.neuron.distributed.lazy_load_for_parallelism",parameters:[{name:"tensor_parallel_size",val:": int = 1"}],parametersDescription:[{anchor:"optimum.neuron.distributed.lazy_load_for_parallelism.tensor_parallel_size",description:`<strong>tensor_parallel_size</strong> (<code>int</code>, defaults to 1) &#x2014;
The parallel size considered for tensor parallel size. If set to 1, no lazy loading is performed.`,name:"tensor_parallel_size"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/utils.py#L705"}}),te=new x({props:{name:"optimum.neuron.distributed.make_optimizer_constructor_lazy",anchor:"optimum.neuron.distributed.make_optimizer_constructor_lazy",parameters:[{name:"optimizer_cls",val:": Type"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/distributed/utils.py#L747"}}),{c(){T=o("meta"),xe=a(),ve=o("p"),ye=a(),m(H.$$.fragment),Pe=a(),q=o("p"),q.innerHTML=ct,Te=a(),m(I.$$.fragment),we=a(),O=o("p"),O.innerHTML=gt,Ce=a(),m(U.$$.fragment),Me=a(),V=o("p"),V.innerHTML=ht,Le=a(),s=o("div"),m(N.$$.fragment),Re=a(),re=o("p"),re.textContent=bt,je=a(),C=o("div"),m(F.$$.fragment),Xe=a(),ae=o("p"),ae.textContent=_t,Ge=a(),P=o("div"),m(S.$$.fragment),Je=a(),ne=o("p"),ne.innerHTML=ft,Ke=a(),le=o("p"),le.textContent=zt,Qe=a(),$=o("div"),m(W.$$.fragment),Ye=a(),oe=o("p"),oe.textContent=vt,Ze=a(),ie=o("p"),ie.textContent=$t,et=a(),de=o("ol"),de.innerHTML=xt,tt=a(),se=o("div"),m(A.$$.fragment),rt=a(),me=o("div"),m(B.$$.fragment),De=a(),m(R.$$.fragment),ke=a(),j=o("p"),j.innerHTML=yt,Ee=a(),v=o("div"),m(X.$$.fragment),at=a(),M=o("div"),m(G.$$.fragment),nt=a(),pe=o("p"),pe.textContent=Pt,lt=a(),L=o("div"),m(J.$$.fragment),ot=a(),ue=o("p"),ue.innerHTML=Tt,it=a(),D=o("div"),m(K.$$.fragment),dt=a(),ce=o("p"),ce.textContent=wt,He=a(),m(Q.$$.fragment),qe=a(),m(Y.$$.fragment),Ie=a(),Z=o("p"),Z.textContent=Ct,Oe=a(),y=o("div"),m(ee.$$.fragment),st=a(),ge=o("p"),ge.textContent=Mt,mt=a(),he=o("ul"),he.innerHTML=Lt,Ue=a(),w=o("div"),m(te.$$.fragment),pt=a(),be=o("p"),be.textContent=Dt,Ve=a(),$e=o("p"),this.h()},l(e){const l=Vt("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(t),xe=n(e),ve=i(e,"P",{}),f(ve).forEach(t),ye=n(e),p(H.$$.fragment,e),Pe=n(e),q=i(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-it0u39"&&(q.innerHTML=ct),Te=n(e),p(I.$$.fragment,e),we=n(e),O=i(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-5ss4zj"&&(O.innerHTML=gt),Ce=n(e),p(U.$$.fragment,e),Me=n(e),V=i(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1bsvcro"&&(V.innerHTML=ht),Le=n(e),s=i(e,"DIV",{class:!0});var _=f(s);p(N.$$.fragment,_),Re=n(_),re=i(_,"P",{"data-svelte-h":!0}),u(re)!=="svelte-h4ipsc"&&(re.textContent=bt),je=n(_),C=i(_,"DIV",{class:!0});var Fe=f(C);p(F.$$.fragment,Fe),Xe=n(Fe),ae=i(Fe,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-1e0iews"&&(ae.textContent=_t),Fe.forEach(t),Ge=n(_),P=i(_,"DIV",{class:!0});var _e=f(P);p(S.$$.fragment,_e),Je=n(_e),ne=i(_e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1ytdrar"&&(ne.innerHTML=ft),Ke=n(_e),le=i(_e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-3oskg6"&&(le.textContent=zt),_e.forEach(t),Qe=n(_),$=i(_,"DIV",{class:!0});var k=f($);p(W.$$.fragment,k),Ye=n(k),oe=i(k,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-gytsrb"&&(oe.textContent=vt),Ze=n(k),ie=i(k,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-k6ubrx"&&(ie.textContent=$t),et=n(k),de=i(k,"OL",{"data-svelte-h":!0}),u(de)!=="svelte-ogaf4b"&&(de.innerHTML=xt),k.forEach(t),tt=n(_),se=i(_,"DIV",{class:!0});var kt=f(se);p(A.$$.fragment,kt),kt.forEach(t),rt=n(_),me=i(_,"DIV",{class:!0});var Et=f(me);p(B.$$.fragment,Et),Et.forEach(t),_.forEach(t),De=n(e),p(R.$$.fragment,e),ke=n(e),j=i(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1x1mrd0"&&(j.innerHTML=yt),Ee=n(e),v=i(e,"DIV",{class:!0});var E=f(v);p(X.$$.fragment,E),at=n(E),M=i(E,"DIV",{class:!0});var Se=f(M);p(G.$$.fragment,Se),nt=n(Se),pe=i(Se,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-esrxt2"&&(pe.textContent=Pt),Se.forEach(t),lt=n(E),L=i(E,"DIV",{class:!0});var We=f(L);p(J.$$.fragment,We),ot=n(We),ue=i(We,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-1bapgxn"&&(ue.innerHTML=Tt),We.forEach(t),it=n(E),D=i(E,"DIV",{class:!0});var Ae=f(D);p(K.$$.fragment,Ae),dt=n(Ae),ce=i(Ae,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-3qe9b8"&&(ce.textContent=wt),Ae.forEach(t),E.forEach(t),He=n(e),p(Q.$$.fragment,e),qe=n(e),p(Y.$$.fragment,e),Ie=n(e),Z=i(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-4ddlue"&&(Z.textContent=Ct),Oe=n(e),y=i(e,"DIV",{class:!0});var fe=f(y);p(ee.$$.fragment,fe),st=n(fe),ge=i(fe,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-bh7x4"&&(ge.textContent=Mt),mt=n(fe),he=i(fe,"UL",{"data-svelte-h":!0}),u(he)!=="svelte-qnyb1e"&&(he.innerHTML=Lt),fe.forEach(t),Ue=n(e),w=i(e,"DIV",{class:!0});var Be=f(w);p(te.$$.fragment,Be),pt=n(Be),be=i(Be,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1agud9l"&&(be.textContent=Dt),Be.forEach(t),Ve=n(e),$e=i(e,"P",{}),f($e).forEach(t),this.h()},h(){z(T,"name","hf:doc:metadata"),z(T,"content",Ft),z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),z(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){r(document.head,T),d(e,xe,l),d(e,ve,l),d(e,ye,l),c(H,e,l),d(e,Pe,l),d(e,q,l),d(e,Te,l),c(I,e,l),d(e,we,l),d(e,O,l),d(e,Ce,l),c(U,e,l),d(e,Me,l),d(e,V,l),d(e,Le,l),d(e,s,l),c(N,s,null),r(s,Re),r(s,re),r(s,je),r(s,C),c(F,C,null),r(C,Xe),r(C,ae),r(s,Ge),r(s,P),c(S,P,null),r(P,Je),r(P,ne),r(P,Ke),r(P,le),r(s,Qe),r(s,$),c(W,$,null),r($,Ye),r($,oe),r($,Ze),r($,ie),r($,et),r($,de),r(s,tt),r(s,se),c(A,se,null),r(s,rt),r(s,me),c(B,me,null),d(e,De,l),c(R,e,l),d(e,ke,l),d(e,j,l),d(e,Ee,l),d(e,v,l),c(X,v,null),r(v,at),r(v,M),c(G,M,null),r(M,nt),r(M,pe),r(v,lt),r(v,L),c(J,L,null),r(L,ot),r(L,ue),r(v,it),r(v,D),c(K,D,null),r(D,dt),r(D,ce),d(e,He,l),c(Q,e,l),d(e,qe,l),c(Y,e,l),d(e,Ie,l),d(e,Z,l),d(e,Oe,l),d(e,y,l),c(ee,y,null),r(y,st),r(y,ge),r(y,mt),r(y,he),d(e,Ue,l),d(e,w,l),c(te,w,null),r(w,pt),r(w,be),d(e,Ve,l),d(e,$e,l),Ne=!0},p:qt,i(e){Ne||(g(H.$$.fragment,e),g(I.$$.fragment,e),g(U.$$.fragment,e),g(N.$$.fragment,e),g(F.$$.fragment,e),g(S.$$.fragment,e),g(W.$$.fragment,e),g(A.$$.fragment,e),g(B.$$.fragment,e),g(R.$$.fragment,e),g(X.$$.fragment,e),g(G.$$.fragment,e),g(J.$$.fragment,e),g(K.$$.fragment,e),g(Q.$$.fragment,e),g(Y.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),Ne=!0)},o(e){h(H.$$.fragment,e),h(I.$$.fragment,e),h(U.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(B.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(G.$$.fragment,e),h(J.$$.fragment,e),h(K.$$.fragment,e),h(Q.$$.fragment,e),h(Y.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),Ne=!1},d(e){e&&(t(xe),t(ve),t(ye),t(Pe),t(q),t(Te),t(we),t(O),t(Ce),t(Me),t(V),t(Le),t(s),t(De),t(ke),t(j),t(Ee),t(v),t(He),t(qe),t(Ie),t(Z),t(Oe),t(y),t(Ue),t(w),t(Ve),t($e)),t(T),b(H,e),b(I,e),b(U,e),b(N),b(F),b(S),b(W),b(A),b(B),b(R,e),b(X),b(G),b(J),b(K),b(Q,e),b(Y,e),b(ee),b(te)}}}const Ft='{"title":"Optimum Neuron Distributed","local":"optimum-neuron-distributed","sections":[{"title":"Parallelization","local":"parallelization","sections":[{"title":"Base Parallelizer","local":"optimum.neuron.distributed.Parallelizer","sections":[],"depth":3},{"title":"Selecting Model-Specific Parallelizer Classes","local":"optimum.neuron.distributed.ParallelizersManager","sections":[],"depth":3}],"depth":2},{"title":"Utils","local":"utils","sections":[{"title":"Lazy Loading","local":"optimum.neuron.distributed.lazy_load_for_parallelism","sections":[],"depth":3}],"depth":2}],"depth":1}';function St(ut){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends Ot{constructor(T){super(),Ut(this,T,St,Nt,Ht,{})}}export{jt as component};
