import{s as Bl,n as jl,o as Zl}from"../chunks/scheduler.00bde567.js";import{S as bl,i as Wl,g as r,s,r as d,A as Gl,h as i,f as t,c as n,j as De,u as c,x as o,k as ul,y as T,a,v as p,d as M,t as m,w as y}from"../chunks/index.752e2ff6.js";import{C as h}from"../chunks/CodeBlock.e62cd1dc.js";import{H as oe}from"../chunks/Heading.476d3364.js";function Rl(Ke){let J,de,re,ce,f,pe,u,qe=`To accelerate training huge models on larger batch sizes, we can use a fully sharded data parallel model.
This type of data parallel paradigm enables fitting more data and larger models by sharding the optimizer states, gradients and parameters.
To read more about it and the benefits, check out the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel blog</a>.
We have integrated the latest PyTorch’s Fully Sharded Data Parallel (FSDP) training feature.
All you need to do is enable it through the config.`,Me,B,me,j,el="On your machine(s) just run:",ye,Z,he,b,ll=`and answer the questions asked. This will generate a config file that will be used automatically to properly set the
default options when doing`,we,W,Je,G,tl="For instance, here is how you would run the NLP example (from the root of the repo) with FSDP enabled:",Ue,R,Te,_,fe,F,al="Currently, <code>Accelerate</code> supports the following config through the CLI:",ue,I,Be,V,sl=`For additional and more nuanced control, you can specify other FSDP parameters via <code>FullyShardedDataParallelPlugin</code>.
When creating <code>FullyShardedDataParallelPlugin</code> object, pass it the parameters that weren’t part of the accelerate config or if you want to override them.
The FSDP parameters will be picked based on the accelerate config file or launch command arguments and other parameters that you will pass directly through the <code>FullyShardedDataParallelPlugin</code> object will set/override that.`,je,C,nl="Below is an example:",Ze,g,be,Y,We,X,rl=`The new recommended way of checkpointing when using FSDP models is to use <code>SHARDED_STATE_DICT</code> as <code>StateDictType</code> when setting up the accelerate config.
Below is the code snippet to save using <code>save_state</code> utility of accelerate.`,Ge,S,Re,v,il="Inspect the ckeckpoint folder to see model and optimizer as shards per process:",_e,k,Fe,H,ol="To load them back for resuming the training, use the <code>load_state</code> utility of accelerate",Ie,x,Ve,N,dl=`When using transformers <code>save_pretrained</code>, pass <code>state_dict=accelerator.get_state_dict(model)</code> to save the model state dict.
Below is an example:`,Ce,Q,ge,E,Ye,z,cl="<code>accelerator.get_state_dict</code> will call the underlying <code>model.state_dict</code> implementation.  With a model wrapped by FSDP, the default behavior of <code>state_dict</code> is to gather all of the state in the rank 0 device.  This can cause CUDA out of memory errors if the parameters don’t fit on a single GPU.",Xe,$,pl="To avoid this, PyTorch provides a context manager that adjusts the behavior of <code>state_dict</code>.  To offload some of the state dict onto CPU, you can use the following code:",Se,A,ve,D,Ml='You can then pass <code>state</code> into the <code>save_pretrained</code> method.  There are several modes for <code>StateDictType</code> and <code>FullStateDictConfig</code> that you can use to control the behavior of <code>state_dict</code>.  For more information, see the <a href="https://pytorch.org/docs/stable/fsdp.html" rel="nofollow">PyTorch documentation</a>.',ke,P,He,L,ml=`<li>PyTorch FSDP auto wraps sub-modules, flattens the parameters and shards the parameters in place.
Due to this, any optimizer created before model wrapping gets broken and occupies more memory.
Hence, it is highly recommended and efficient to prepare the model before creating the optimizer.
<code>Accelerate</code> will automatically wrap the model and create an optimizer for you in case of single model with a warning message.<blockquote><p>FSDP Warning: When using FSDP, it is efficient and recommended to call prepare for the model before creating the optimizer</p></blockquote></li>`,xe,O,yl="However, below is the recommended way to prepare model and optimizer while using FSDP:",Ne,K,Qe,te,w,ae,hl=`In case of a single model, if you have created the optimizer with multiple parameter groups and called prepare with them together,
then the parameter groups will be lost and the following warning is displayed:`,Pe,se,wl=`<p>FSDP Warning: When using FSDP, several parameter groups will be conflated into
a single one due to nested module wrapping and parameter flattening.</p>`,Le,ne,Jl=`This is because parameter groups created before wrapping will have no meaning post wrapping due to parameter flattening of nested FSDP modules into 1D arrays (which can consume many layers).
For instance, below are the named parameters of an FSDP model on GPU 0 (When using 2 GPUs. Around 55M (110M/2) params in 1D arrays as this will have the 1st shard of the parameters).
Here, if one has applied no weight decay for [bias, LayerNorm.weight] the named parameters of an unwrapped BERT model,
it can’t be applied to the below FSDP wrapped model as there are no named parameters with either of those strings and
the parameters of those layers are concatenated with parameters of various other layers.`,Oe,q,Ee,ee,Ul=`<li>In case of multiple models, it is necessary to prepare the models before creating optimizers or else it will throw an error.
Then pass the optimizers to the prepare call in the same order as corresponding models else <code>accelerator.save_state()</code> and <code>accelerator.load_state()</code> will result in wrong/unexpected behaviour.</li> <li>This feature is incompatible with <code>--predict_with_generate</code> in the <code>run_translation.py</code> script of 🤗 <code>Transformers</code> library.</li>`,ze,le,Tl=`For more control, users can leverage the <code>FullyShardedDataParallelPlugin</code>. After creating an instance of this class, users can pass it to the Accelerator class instantiation.
For more information on these options, please refer to the PyTorch <a href="https://github.com/pytorch/pytorch/blob/0df2e863fbd5993a7b9e652910792bd21a516ff3/torch/distributed/fsdp/fully_sharded_data_parallel.py#L236" rel="nofollow">FullyShardedDataParallel</a> code.`,$e,ie,Ae;return f=new oe({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),B=new oe({props:{title:"How it works out of the box",local:"how-it-works-out-of-the-box",headingTag:"h2"}}),Z=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),W=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15X3NjcmlwdC5weSUyMC0tYXJnc190b19teV9zY3JpcHQ=",highlighted:"accelerate launch my_script.py --args_to_my_script",wrap:!1}}),R=new h({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTIwJTdCJTdEJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9zaGFyZGluZ19zdHJhdGVneSUzQSUyMDElMEElMjAlMjBmc2RwX3N0YXRlX2RpY3RfdHlwZSUzQSUyMEZVTExfU1RBVEVfRElDVCUwQSUyMCUyMGZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0ElMjBCZXJ0TGF5ZXIlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl9wcm9jZXNzX2lwJTNBJTIwbnVsbCUwQW1haW5fcHJvY2Vzc19wb3J0JTNBJTIwbnVsbCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWl4ZWRfcHJlY2lzaW9uJTNBJTIwJ25vJyUwQW51bV9tYWNoaW5lcyUzQSUyMDElMEFudW1fcHJvY2Vzc2VzJTNBJTIwMiUwQXVzZV9jcHUlM0ElMjBmYWxzZQ==",highlighted:`compute_environment: LOCAL_MACHINE
deepspeed_config: {}
distributed_type: FSDP
downcast_bf16: <span class="hljs-string">&#x27;no&#x27;</span>
fsdp_config:
  fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP
  fsdp_backward_prefetch_policy: BACKWARD_PRE
  fsdp_offload_params: <span class="hljs-literal">false</span>
  fsdp_sharding_strategy: 1
  fsdp_state_dict_type: FULL_STATE_DICT
  fsdp_transformer_layer_cls_to_wrap: BertLayer
machine_rank: 0
main_process_ip: null
main_process_port: null
main_training_function: main
mixed_precision: <span class="hljs-string">&#x27;no&#x27;</span>
num_machines: 1
num_processes: 2
use_cpu: <span class="hljs-literal">false</span>`,wrap:!1}}),_=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGbmxwX2V4YW1wbGUucHk=",highlighted:"accelerate launch examples/nlp_example.py",wrap:!1}}),I=new h({props:{code:"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",highlighted:'`Sharding Strategy`: [1] FULL_SHARD (shards optimizer states, gradients and parameters), [2] SHARD_GRAD_OP (shards optimizer states and gradients), [3] NO_SHARD (DDP), [4] HYBRID_SHARD (shards optimizer states, gradients and parameters within each node <span class="hljs-keyword">while</span> each node has full copy), [5] HYBRID_SHARD_ZERO2 (shards optimizer states and gradients within each node <span class="hljs-keyword">while</span> each node has full copy)\n\n`Offload Params`: Decides Whether to offload parameters and gradients to CPU\n\n`Auto Wrap Policy`: [1] TRANSFORMER_BASED_WRAP, [2] SIZE_BASED_WRAP, [3] NO_WRAP\n\n`Transformer Layer Class to Wrap`: When using `TRANSFORMER_BASED_WRAP`, user specifies comma-separated string of transformer layer class names (case-sensitive) to wrap ,e.g, \n`BertLayer`, `GPTJBlock`, `T5Block`, `BertLayer,BertEmbeddings,BertSelfOutput`...\nThis is important because submodules that share weights (e.g., embedding layer) should not end up <span class="hljs-keyword">in</span> different FSDP wrapped units.\nUsing this policy, wrapping happens <span class="hljs-keyword">for</span> each block containing Multi-Head Attention followed by couple of MLP layers. \nRemaining layers including the shared embeddings are conveniently wrapped <span class="hljs-keyword">in</span> same outermost FSDP unit.\nTherefore, use this <span class="hljs-keyword">for</span> transformer based models.\nYou can use the `model._no_split_modules` <span class="hljs-keyword">for</span> 🤗 Transformer models by answering `<span class="hljs-built_in">yes</span>` to \n`Do you want to use the model<span class="hljs-string">&#x27;s `_no_split_modules` to wrap. Only applicable for 🤗 Transformers`. \nIt will try to use `model._no_split_modules` when available.  \n\n`Min Num Params`: minimum number of parameters when using `SIZE_BASED_WRAP`\n\n`Backward Prefetch`: [1] BACKWARD_PRE, [2] BACKWARD_POST, [3] NO_PREFETCH\n\n`State Dict Type`: [1] FULL_STATE_DICT, [2] LOCAL_STATE_DICT, [3] SHARDED_STATE_DICT \n\n`Forward Prefetch`: if True, then FSDP explicitly prefetches the next upcoming\nall-gather while executing in the forward pass. only use with Static graphs.\n\n`Use Orig Params`: If True, allows non-uniform `requires_grad` during init, which means support for interspersed frozen and trainable paramteres. \nUseful in cases such as parameter-efficient fine-tuning. \nPlease refer this [blog](https://dev-discuss.pytorch.org/t/rethinking-pytorch-fully-sharded-data-parallel-fsdp-from-first-principles/1019)\n\n`CPU RAM Efficient Model loading`: If True, only the first process loads the pretrained model checkoint while all other processes have empty weights. Only applicable for 🤗 Transformers models. This should be set to False if you experience errors when loading the pretrained 🤗 Transformers model via `from_pretrained` method. When using this, `Sync Module States` needs to be True else all the processes expect the main process would have random empty weights leading to unexpected behaviour during training.\n\n`Sync Module States`: If True, each individually wrapped FSDP unit will broadcast module parameters from rank 0</span>',wrap:!1}}),g=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4lMEFmcm9tJTIwdG9yY2guZGlzdHJpYnV0ZWQuZnNkcC5mdWxseV9zaGFyZGVkX2RhdGFfcGFyYWxsZWwlMjBpbXBvcnQlMjBGdWxsT3B0aW1TdGF0ZURpY3RDb25maWclMkMlMjBGdWxsU3RhdGVEaWN0Q29uZmlnJTBBJTBBZnNkcF9wbHVnaW4lMjAlM0QlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWxQbHVnaW4oJTBBJTIwJTIwJTIwJTIwc3RhdGVfZGljdF9jb25maWclM0RGdWxsU3RhdGVEaWN0Q29uZmlnKG9mZmxvYWRfdG9fY3B1JTNERmFsc2UlMkMlMjByYW5rMF9vbmx5JTNERmFsc2UpJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1fc3RhdGVfZGljdF9jb25maWclM0RGdWxsT3B0aW1TdGF0ZURpY3RDb25maWcob2ZmbG9hZF90b19jcHUlM0RGYWxzZSUyQyUyMHJhbmswX29ubHklM0RGYWxzZSklMkMlMEEpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihmc2RwX3BsdWdpbiUzRGZzZHBfcGx1Z2luKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> FullyShardedDataParallelPlugin
<span class="hljs-keyword">from</span> torch.distributed.fsdp.fully_sharded_data_parallel <span class="hljs-keyword">import</span> FullOptimStateDictConfig, FullStateDictConfig

fsdp_plugin = FullyShardedDataParallelPlugin(
    state_dict_config=FullStateDictConfig(offload_to_cpu=<span class="hljs-literal">False</span>, rank0_only=<span class="hljs-literal">False</span>),
    optim_state_dict_config=FullOptimStateDictConfig(offload_to_cpu=<span class="hljs-literal">False</span>, rank0_only=<span class="hljs-literal">False</span>),
)

accelerator = Accelerator(fsdp_plugin=fsdp_plugin)`,wrap:!1}}),Y=new oe({props:{title:"Saving and loading",local:"saving-and-loading",headingTag:"h2"}}),S=new h({props:{code:"YWNjZWxlcmF0b3Iuc2F2ZV9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:'accelerator.save_state(<span class="hljs-string">&quot;ckpt&quot;</span>)',wrap:!1}}),k=new h({props:{code:"bHMlMjBja3B0JTIwJTBBJTIzJTIwb3B0aW1pemVyXzAlMjAlMjBweXRvcmNoX21vZGVsXzAlMjAlMjByYW5kb21fc3RhdGVzXzAucGtsJTIwJTIwcmFuZG9tX3N0YXRlc18xLnBrbCUyMCUyMHNjaGVkdWxlci5iaW4lMEElMEFjZCUyMGNrcHQlMEElMEFscyUyMG9wdGltaXplcl8wJTBBJTIzJTIwX18wXzAuZGlzdGNwJTIwJTIwX18xXzAuZGlzdGNwJTBBJTBBbHMlMjBweXRvcmNoX21vZGVsXzAlMEElMjMlMjBfXzBfMC5kaXN0Y3AlMjAlMjBfXzFfMC5kaXN0Y3A=",highlighted:`<span class="hljs-built_in">ls</span> ckpt 
<span class="hljs-comment"># optimizer_0  pytorch_model_0  random_states_0.pkl  random_states_1.pkl  scheduler.bin</span>

<span class="hljs-built_in">cd</span> ckpt

<span class="hljs-built_in">ls</span> optimizer_0
<span class="hljs-comment"># __0_0.distcp  __1_0.distcp</span>

<span class="hljs-built_in">ls</span> pytorch_model_0
<span class="hljs-comment"># __0_0.distcp  __1_0.distcp</span>`,wrap:!1}}),x=new h({props:{code:"YWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:'accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)',wrap:!1}}),Q=new h({props:{code:"JTIwJTIwdW53cmFwcGVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzLm91dHB1dF9kaXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBpc19tYWluX3Byb2Nlc3MlM0RhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBzYXZlX2Z1bmN0aW9uJTNEYWNjZWxlcmF0b3Iuc2F2ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHN0YXRlX2RpY3QlM0RhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChtb2RlbCUyQyUyMHVud3JhcCUzREZhbHNlKSUyQyUwQSk=",highlighted:`  unwrapped_model.save_pretrained(
      args.output_dir,
      is_main_process=accelerator.is_main_process,
      save_function=accelerator.save,
<span class="hljs-addition">+     state_dict=accelerator.get_state_dict(model, unwrap=False),</span>
)`,wrap:!1}}),E=new oe({props:{title:"State Dict",local:"state-dict",headingTag:"h3"}}),A=new h({props:{code:"ZnJvbSUyMHRvcmNoLmRpc3RyaWJ1dGVkLmZzZHAlMjBpbXBvcnQlMjBGdWxseVNoYXJkZWREYXRhUGFyYWxsZWwlMjBhcyUyMEZTRFAlMkMlMjBTdGF0ZURpY3RUeXBlJTJDJTIwRnVsbFN0YXRlRGljdENvbmZpZyUwQSUwQWZ1bGxfc3RhdGVfZGljdF9jb25maWclMjAlM0QlMjBGdWxsU3RhdGVEaWN0Q29uZmlnKG9mZmxvYWRfdG9fY3B1JTNEVHJ1ZSUyQyUyMHJhbmswX29ubHklM0RUcnVlKSUwQXdpdGglMjBGU0RQLnN0YXRlX2RpY3RfdHlwZSh1bndyYXBwZWRfbW9kZWwlMkMlMjBTdGF0ZURpY3RUeXBlLkZVTExfU1RBVEVfRElDVCUyQyUyMGZ1bGxfc3RhdGVfZGljdF9jb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwc3RhdGUlMjAlM0QlMjBhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdCh1bndyYXBwZWRfbW9kZWwp",highlighted:`from torch.distributed.fsdp import FullyShardedDataParallel <span class="hljs-keyword">as</span> FSDP, StateDictType, FullStateDictConfig

full_state_dict_config = <span class="hljs-constructor">FullStateDictConfig(<span class="hljs-params">offload_to_cpu</span>=True, <span class="hljs-params">rank0_only</span>=True)</span>
<span class="hljs-keyword">with</span> <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">FSDP</span>.</span></span>state<span class="hljs-constructor">_dict_type(<span class="hljs-params">unwrapped_model</span>, StateDictType.FULL_STATE_DICT, <span class="hljs-params">full_state_dict_config</span>)</span>:
    state = accelerator.get<span class="hljs-constructor">_state_dict(<span class="hljs-params">unwrapped_model</span>)</span>`,wrap:!1}}),P=new oe({props:{title:"A few caveats to be aware of",local:"a-few-caveats-to-be-aware-of",headingTag:"h2"}}),K=new h({props:{code:"JTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBJTJCJTIwbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsKSUwQSUwQSUyMCUyMG9wdGltaXplciUyMCUzRCUyMHRvcmNoLm9wdGltLkFkYW1XKHBhcmFtcyUzRG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEbHIpJTBBJTBBLSUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBLSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUwQS0lMjAlMjAlMjAlMjApJTBBJTBBJTJCJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUwQSUyQiUyMCUyMCUyMCUyMCk=",highlighted:`  model = AutoModelForSequenceClassification.from_pretrained(&quot;bert-base-cased&quot;, return_dict=True)
<span class="hljs-addition">+ model = accelerator.prepare(model)</span>

  optimizer = torch.optim.AdamW(params=model.parameters(), lr=lr)

<span class="hljs-deletion">- model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(</span>
<span class="hljs-deletion">-        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler</span>
<span class="hljs-deletion">-    )</span>

<span class="hljs-addition">+ optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+         optimizer, train_dataloader, eval_dataloader, lr_scheduler</span>
<span class="hljs-addition">+    )</span>`,wrap:!1}}),q=new h({props:{code:"JTdCJTBBJTIwJTIwJ19mc2RwX3dyYXBwZWRfbW9kdWxlLmZsYXRfcGFyYW0nJTNBJTIwdG9yY2guU2l6ZSglNUI0OTQyMDklNUQpJTJDJTIwJTBBJTIwJTIwJ19mc2RwX3dyYXBwZWRfbW9kdWxlLl9mcHdfbW9kdWxlLmJlcnQuZW1iZWRkaW5ncy53b3JkX2VtYmVkZGluZ3MuX2ZzZHBfd3JhcHBlZF9tb2R1bGUuZmxhdF9wYXJhbSclM0ElMjB0b3JjaC5TaXplKCU1QjExNzIwNDQ4JTVEKSUyQyUyMCUwQSUyMCUyMCdfZnNkcF93cmFwcGVkX21vZHVsZS5fZnB3X21vZHVsZS5iZXJ0LmVuY29kZXIuX2ZzZHBfd3JhcHBlZF9tb2R1bGUuZmxhdF9wYXJhbSclM0ElMjB0b3JjaC5TaXplKCU1QjQyNTI3MjMyJTVEKSUwQSU3RA==",highlighted:`{
  <span class="hljs-string">&#x27;_fsdp_wrapped_module.flat_param&#x27;</span>: torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[494209]</span>), 
  <span class="hljs-string">&#x27;_fsdp_wrapped_module._fpw_module.bert.embeddings.word_embeddings._fsdp_wrapped_module.flat_param&#x27;</span>: torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[11720448]</span>), 
  <span class="hljs-string">&#x27;_fsdp_wrapped_module._fpw_module.bert.encoder._fsdp_wrapped_module.flat_param&#x27;</span>: torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[42527232]</span>)
}`,wrap:!1}}),{c(){J=r("meta"),de=s(),re=r("p"),ce=s(),d(f.$$.fragment),pe=s(),u=r("p"),u.innerHTML=qe,Me=s(),d(B.$$.fragment),me=s(),j=r("p"),j.textContent=el,ye=s(),d(Z.$$.fragment),he=s(),b=r("p"),b.textContent=ll,we=s(),d(W.$$.fragment),Je=s(),G=r("p"),G.textContent=tl,Ue=s(),d(R.$$.fragment),Te=s(),d(_.$$.fragment),fe=s(),F=r("p"),F.innerHTML=al,ue=s(),d(I.$$.fragment),Be=s(),V=r("p"),V.innerHTML=sl,je=s(),C=r("p"),C.textContent=nl,Ze=s(),d(g.$$.fragment),be=s(),d(Y.$$.fragment),We=s(),X=r("p"),X.innerHTML=rl,Ge=s(),d(S.$$.fragment),Re=s(),v=r("p"),v.textContent=il,_e=s(),d(k.$$.fragment),Fe=s(),H=r("p"),H.innerHTML=ol,Ie=s(),d(x.$$.fragment),Ve=s(),N=r("p"),N.innerHTML=dl,Ce=s(),d(Q.$$.fragment),ge=s(),d(E.$$.fragment),Ye=s(),z=r("p"),z.innerHTML=cl,Xe=s(),$=r("p"),$.innerHTML=pl,Se=s(),d(A.$$.fragment),ve=s(),D=r("p"),D.innerHTML=Ml,ke=s(),d(P.$$.fragment),He=s(),L=r("ul"),L.innerHTML=ml,xe=s(),O=r("p"),O.textContent=yl,Ne=s(),d(K.$$.fragment),Qe=s(),te=r("ul"),w=r("li"),ae=r("p"),ae.textContent=hl,Pe=s(),se=r("blockquote"),se.innerHTML=wl,Le=s(),ne=r("p"),ne.textContent=Jl,Oe=s(),d(q.$$.fragment),Ee=s(),ee=r("ul"),ee.innerHTML=Ul,ze=s(),le=r("p"),le.innerHTML=Tl,$e=s(),ie=r("p"),this.h()},l(e){const l=Gl("svelte-u9bgzb",document.head);J=i(l,"META",{name:!0,content:!0}),l.forEach(t),de=n(e),re=i(e,"P",{}),De(re).forEach(t),ce=n(e),c(f.$$.fragment,e),pe=n(e),u=i(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-qnvjvw"&&(u.innerHTML=qe),Me=n(e),c(B.$$.fragment,e),me=n(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-3pof6s"&&(j.textContent=el),ye=n(e),c(Z.$$.fragment,e),he=n(e),b=i(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ovz84c"&&(b.textContent=ll),we=n(e),c(W.$$.fragment,e),Je=n(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-12mgqf4"&&(G.textContent=tl),Ue=n(e),c(R.$$.fragment,e),Te=n(e),c(_.$$.fragment,e),fe=n(e),F=i(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-aporbc"&&(F.innerHTML=al),ue=n(e),c(I.$$.fragment,e),Be=n(e),V=i(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1mlu7qv"&&(V.innerHTML=sl),je=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-ks9e2y"&&(C.textContent=nl),Ze=n(e),c(g.$$.fragment,e),be=n(e),c(Y.$$.fragment,e),We=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-105rpu1"&&(X.innerHTML=rl),Ge=n(e),c(S.$$.fragment,e),Re=n(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-fdeueu"&&(v.textContent=il),_e=n(e),c(k.$$.fragment,e),Fe=n(e),H=i(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1v7i9ht"&&(H.innerHTML=ol),Ie=n(e),c(x.$$.fragment,e),Ve=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1y7f54p"&&(N.innerHTML=dl),Ce=n(e),c(Q.$$.fragment,e),ge=n(e),c(E.$$.fragment,e),Ye=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1ubgl5a"&&(z.innerHTML=cl),Xe=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-f8ni70"&&($.innerHTML=pl),Se=n(e),c(A.$$.fragment,e),ve=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-57zs50"&&(D.innerHTML=Ml),ke=n(e),c(P.$$.fragment,e),He=n(e),L=i(e,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-qkyco4"&&(L.innerHTML=ml),xe=n(e),O=i(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1fwhkpj"&&(O.textContent=yl),Ne=n(e),c(K.$$.fragment,e),Qe=n(e),te=i(e,"UL",{});var fl=De(te);w=i(fl,"LI",{});var U=De(w);ae=i(U,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-ow3cmk"&&(ae.textContent=hl),Pe=n(U),se=i(U,"BLOCKQUOTE",{"data-svelte-h":!0}),o(se)!=="svelte-18t0nfq"&&(se.innerHTML=wl),Le=n(U),ne=i(U,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-13qpwrs"&&(ne.textContent=Jl),Oe=n(U),c(q.$$.fragment,U),U.forEach(t),fl.forEach(t),Ee=n(e),ee=i(e,"UL",{"data-svelte-h":!0}),o(ee)!=="svelte-1ofn9e9"&&(ee.innerHTML=Ul),ze=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1dlu8nc"&&(le.innerHTML=Tl),$e=n(e),ie=i(e,"P",{}),De(ie).forEach(t),this.h()},h(){ul(J,"name","hf:doc:metadata"),ul(J,"content",_l)},m(e,l){T(document.head,J),a(e,de,l),a(e,re,l),a(e,ce,l),p(f,e,l),a(e,pe,l),a(e,u,l),a(e,Me,l),p(B,e,l),a(e,me,l),a(e,j,l),a(e,ye,l),p(Z,e,l),a(e,he,l),a(e,b,l),a(e,we,l),p(W,e,l),a(e,Je,l),a(e,G,l),a(e,Ue,l),p(R,e,l),a(e,Te,l),p(_,e,l),a(e,fe,l),a(e,F,l),a(e,ue,l),p(I,e,l),a(e,Be,l),a(e,V,l),a(e,je,l),a(e,C,l),a(e,Ze,l),p(g,e,l),a(e,be,l),p(Y,e,l),a(e,We,l),a(e,X,l),a(e,Ge,l),p(S,e,l),a(e,Re,l),a(e,v,l),a(e,_e,l),p(k,e,l),a(e,Fe,l),a(e,H,l),a(e,Ie,l),p(x,e,l),a(e,Ve,l),a(e,N,l),a(e,Ce,l),p(Q,e,l),a(e,ge,l),p(E,e,l),a(e,Ye,l),a(e,z,l),a(e,Xe,l),a(e,$,l),a(e,Se,l),p(A,e,l),a(e,ve,l),a(e,D,l),a(e,ke,l),p(P,e,l),a(e,He,l),a(e,L,l),a(e,xe,l),a(e,O,l),a(e,Ne,l),p(K,e,l),a(e,Qe,l),a(e,te,l),T(te,w),T(w,ae),T(w,Pe),T(w,se),T(w,Le),T(w,ne),T(w,Oe),p(q,w,null),a(e,Ee,l),a(e,ee,l),a(e,ze,l),a(e,le,l),a(e,$e,l),a(e,ie,l),Ae=!0},p:jl,i(e){Ae||(M(f.$$.fragment,e),M(B.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(_.$$.fragment,e),M(I.$$.fragment,e),M(g.$$.fragment,e),M(Y.$$.fragment,e),M(S.$$.fragment,e),M(k.$$.fragment,e),M(x.$$.fragment,e),M(Q.$$.fragment,e),M(E.$$.fragment,e),M(A.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(q.$$.fragment,e),Ae=!0)},o(e){m(f.$$.fragment,e),m(B.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(_.$$.fragment,e),m(I.$$.fragment,e),m(g.$$.fragment,e),m(Y.$$.fragment,e),m(S.$$.fragment,e),m(k.$$.fragment,e),m(x.$$.fragment,e),m(Q.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),Ae=!1},d(e){e&&(t(de),t(re),t(ce),t(pe),t(u),t(Me),t(me),t(j),t(ye),t(he),t(b),t(we),t(Je),t(G),t(Ue),t(Te),t(fe),t(F),t(ue),t(Be),t(V),t(je),t(C),t(Ze),t(be),t(We),t(X),t(Ge),t(Re),t(v),t(_e),t(Fe),t(H),t(Ie),t(Ve),t(N),t(Ce),t(ge),t(Ye),t(z),t(Xe),t($),t(Se),t(ve),t(D),t(ke),t(He),t(L),t(xe),t(O),t(Ne),t(Qe),t(te),t(Ee),t(ee),t(ze),t(le),t($e),t(ie)),t(J),y(f,e),y(B,e),y(Z,e),y(W,e),y(R,e),y(_,e),y(I,e),y(g,e),y(Y,e),y(S,e),y(k,e),y(x,e),y(Q,e),y(E,e),y(A,e),y(P,e),y(K,e),y(q)}}}const _l='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[{"title":"How it works out of the box","local":"how-it-works-out-of-the-box","sections":[],"depth":2},{"title":"Saving and loading","local":"saving-and-loading","sections":[{"title":"State Dict","local":"state-dict","sections":[],"depth":3}],"depth":2},{"title":"A few caveats to be aware of","local":"a-few-caveats-to-be-aware-of","sections":[],"depth":2}],"depth":1}';function Fl(Ke){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yl extends bl{constructor(J){super(),Wl(this,J,Fl,Rl,Bl,{})}}export{Yl as component};
