import{s as Si,o as Wi,n as Z}from"../chunks/scheduler.182ea377.js";import{S as Di,i as Gi,g as r,s as a,r as f,A as Bi,h as d,f as c,c as i,j as I,u,x as y,k as T,y as o,a as v,v as g,d as h,t as _,w as b}from"../chunks/index.abf12888.js";import{T as Oe}from"../chunks/Tip.230e2334.js";import{D as C}from"../chunks/Docstring.93f6f462.js";import{C as G}from"../chunks/CodeBlock.57fe6e13.js";import{E as D}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as on}from"../chunks/Heading.16916d63.js";function Fi(x){let n,w='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){n=r("p"),n.innerHTML=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1wmc0l4"&&(n.innerHTML=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function Li(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># remove following line if xformers is not installed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;futuristic-looking woman&quot;</span>, num_inference_steps=<span class="hljs-number">20</span>, generator=generator, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function Xi(x){let n,w=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=r("p"),n.innerHTML=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function Ri(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function Vi(x){let n,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=r("p"),n.textContent=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function Ei(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function Yi(x){let n,w="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",l,s,m;return s=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1gc783q"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function zi(x){let n,w="locally:",l,s,m;return s=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-4c75kq"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function Hi(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np.array(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = cv2.Canny(np_image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np_image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>np_image = np.concatenate([np_image, np_image, np_image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(np_image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># speed up diffusion process with faster scheduler and memory optimization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;futuristic-looking woman&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=canny_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function Ai(x){let n,w=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=r("p"),n.innerHTML=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function Qi(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function qi(x){let n,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=r("p"),n.textContent=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function Oi(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function Ki(x){let n,w="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",l,s,m;return s=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1gc783q"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function el(x){let n,w="locally:",l,s,m;return s=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-4c75kq"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function tl(x){let n,w=`This pipeline can be used with checkpoints that have been specifically fine-tuned for inpainting
(<a href="https://huggingface.co/runwayml/stable-diffusion-inpainting" rel="nofollow">runwayml/stable-diffusion-inpainting</a>) as well as
default text-to-image Stable Diffusion checkpoints
(<a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a>). Default text-to-image
Stable Diffusion checkpoints might be preferable for ControlNets that have been fine-tuned on those, such as
<a href="https://huggingface.co/lllyasviel/control_v11p_sd15_inpaint" rel="nofollow">lllyasviel/control_v11p_sd15_inpaint</a>.`;return{c(){n=r("p"),n.innerHTML=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-mk8vnx"&&(n.innerHTML=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function nl(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmRpZmZ1c2VycyUyRnRlc3QtYXJyYXlzJTJGcmVzb2x2ZSUyRm1haW4lMkZzdGFibGVfZGlmZnVzaW9uX2lucGFpbnQlMkZib3kucG5nJTIyJTBBKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgxKSUwQSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmRpZmZ1c2VycyUyRnRlc3QtYXJyYXlzJTJGcmVzb2x2ZSUyRm1haW4lMkZzdGFibGVfZGlmZnVzaW9uX2lucGFpbnQlMkZib3lfbWFzay5wbmclMjIlMEEpJTBBbWFza19pbWFnZSUyMCUzRCUyMG1hc2tfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQSUwQWRlZiUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdlJTBBJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGluaXRfaW1hZ2UpJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExcF9zZDE1X2lucGFpbnQlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwZ2VuZXJhdGUlMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJhJTIwaGFuZHNvbWUlMjBtYW4lMjB3aXRoJTIwcmF5LWJhbiUyMHN1bmdsYXNzZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBldGElM0QxLjAlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, DDIMScheduler
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/test-arrays/resolve/main/stable_diffusion_inpaint/boy_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    image = np.array(image)
<span class="hljs-meta">... </span>    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">... </span>    image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>    image = Image.fromarray(image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image


<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = make_canny_condition(init_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a handsome man with ray-ban sunglasses&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    eta=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function ol(x){let n,w=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=r("p"),n.innerHTML=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-ackzsn"&&(n.innerHTML=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function sl(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function al(x){let n,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=r("p"),n.textContent=w},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-17p1lpg"&&(n.textContent=w)},m(l,s){v(l,n,s)},p:Z,d(l){l&&c(n)}}}function il(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function ll(x){let n,w="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",l,s,m;return s=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-1gc783q"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function rl(x){let n,w="locally:",l,s,m;return s=new G({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-4c75kq"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function dl(x){let n,w="Examples:",l,s,m;return s=new G({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionControlNetPipeline, FlaxControlNetModel


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)


<span class="hljs-meta">&gt;&gt;&gt; </span>rng = create_key(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/test-doc-assets/resolve/main/blog_post_cell_10_output_0.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = <span class="hljs-string">&quot;best quality, extremely detailed&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompts = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load control net and stable diffusion v1-5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet, controlnet_params = FlaxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, from_pt=<span class="hljs-literal">True</span>, dtype=jnp.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe, params = FlaxStableDiffusionControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, revision=<span class="hljs-string">&quot;flax&quot;</span>, dtype=jnp.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>params[<span class="hljs-string">&quot;controlnet&quot;</span>] = controlnet_params

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>rng = jax.random.split(rng, jax.device_count())

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipe.prepare_text_inputs([prompts] * num_samples)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt_ids = pipe.prepare_text_inputs([negative_prompts] * num_samples)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = pipe.prepare_image_inputs([canny_image] * num_samples)

<span class="hljs-meta">&gt;&gt;&gt; </span>p_params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt_ids = shard(negative_prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = shard(processed_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt_ids=prompt_ids,
<span class="hljs-meta">... </span>    image=processed_image,
<span class="hljs-meta">... </span>    params=p_params,
<span class="hljs-meta">... </span>    prng_seed=rng,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    neg_prompt_ids=negative_prompt_ids,
<span class="hljs-meta">... </span>    jit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = pipe.numpy_to_pil(np.asarray(output.reshape((num_samples,) + output.shape[-<span class="hljs-number">3</span>:])))
<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = make_image_grid(output_images, num_samples // <span class="hljs-number">4</span>, <span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_images.save(<span class="hljs-string">&quot;generated_image.png&quot;</span>)`,wrap:!1}}),{c(){n=r("p"),n.textContent=w,l=a(),f(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=w),l=i(t),u(s.$$.fragment,t)},m(t,M){v(t,n,M),v(t,l,M),g(s,t,M),m=!0},p:Z,i(t){m||(h(s.$$.fragment,t),m=!0)},o(t){_(s.$$.fragment,t),m=!1},d(t){t&&(c(n),c(l)),b(s,t)}}}function cl(x){let n,w,l,s,m,t,M,Ua='ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala.',io,Ke,ka="With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",lo,et,Za="The abstract from the paper is:",ro,tt,Pa="<em>We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with “zero convolutions” (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (&lt;50k) and large (&gt;1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.</em>",co,nt,Sa='This model was contributed by <a href="https://huggingface.co/takuma104" rel="nofollow">takuma104</a>. ❤️',po,ot,Wa='The original codebase can be found at <a href="https://github.com/lllyasviel/ControlNet" rel="nofollow">lllyasviel/ControlNet</a>, and you can find official ControlNet checkpoints on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel’s</a> Hub profile.',mo,de,fo,st,uo,J,at,Po,sn,Da="Pipeline for text-to-image generation using Stable Diffusion with ControlNet guidance.",So,an,Ga=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Wo,ln,Ba="The pipeline also inherits the following loading methods:",Do,rn,Fa='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Go,te,it,Bo,dn,La="The call function to the pipeline for generation.",Fo,ce,Lo,X,lt,Xo,cn,Xa=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ro,pe,Vo,me,Eo,fe,rt,Yo,pn,Ra=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,zo,ue,dt,Ho,mn,Va=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ao,ge,ct,Qo,fn,Ea=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,qo,R,pt,Oo,un,Ya=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Ko,he,es,_e,ts,be,mt,ns,gn,za='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',os,P,ft,ss,hn,Ha=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,as,_n,Aa="Example:",is,ye,ls,bn,Qa=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,rs,we,ds,ve,ut,cs,yn,qa="Encodes the prompt into text encoder hidden states.",ps,Me,gt,ms,wn,Oa='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',go,ht,ho,$,_t,fs,vn,Ka="Pipeline for image-to-image generation using Stable Diffusion with ControlNet guidance.",us,Mn,ei=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,gs,xn,ti="The pipeline also inherits the following loading methods:",hs,In,ni='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',_s,ne,bt,bs,Tn,oi="The call function to the pipeline for generation.",ys,xe,ws,V,yt,vs,Cn,si=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ms,Ie,xs,Te,Is,Ce,wt,Ts,Jn,ai=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Cs,Je,vt,Js,jn,ii=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,js,je,Mt,$s,$n,li=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ns,E,xt,Us,Nn,ri=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ks,$e,Zs,Ne,Ps,Ue,It,Ss,Un,di='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Ws,S,Tt,Ds,kn,ci=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Gs,Zn,pi="Example:",Bs,ke,Fs,Pn,mi=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Ls,Ze,Xs,Pe,Ct,Rs,Sn,fi="Encodes the prompt into text encoder hidden states.",_o,Jt,bo,j,jt,Vs,Wn,ui="Pipeline for image inpainting using Stable Diffusion with ControlNet guidance.",Es,Dn,gi=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ys,Gn,hi="The pipeline also inherits the following loading methods:",zs,Bn,_i='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Hs,Se,As,oe,$t,Qs,Fn,bi="The call function to the pipeline for generation.",qs,We,Os,Y,Nt,Ks,Ln,yi=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,ea,De,ta,Ge,na,Be,Ut,oa,Xn,wi=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,sa,Fe,kt,aa,Rn,vi=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,ia,Le,Zt,la,Vn,Mi=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ra,z,Pt,da,En,xi=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ca,Xe,pa,Re,ma,Ve,St,fa,Yn,Ii='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',ua,W,Wt,ga,zn,Ti=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,ha,Hn,Ci="Example:",_a,Ee,ba,An,Ji=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,ya,Ye,wa,ze,Dt,va,Qn,ji="Encodes the prompt into text encoder hidden states.",yo,Gt,wo,ae,Bt,Ma,qn,$i="Output class for Stable Diffusion pipelines.",vo,Ft,Mo,L,Lt,xa,On,Ni="Flax-based pipeline for text-to-image generation using Stable Diffusion with ControlNet Guidance.",Ia,Kn,Ui=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ta,se,Xt,Ca,eo,ki="The call function to the pipeline for generation.",Ja,He,xo,Rt,Io,A,Vt,ja,to,Zi="Output class for Flax-based Stable Diffusion pipelines.",$a,Ae,Et,Na,no,Pi="“Returns a new object replacing the specified fields with new values.",To,ao,Co;return m=new on({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),de=new Oe({props:{$$slots:{default:[Fi]},$$scope:{ctx:x}}}),st=new on({props:{title:"StableDiffusionControlNetPipeline",local:"diffusers.StableDiffusionControlNetPipeline",headingTag:"h2"}}),at=new C({props:{name:"class diffusers.StableDiffusionControlNetPipeline",anchor:"diffusers.StableDiffusionControlNetPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L139"}}),it=new C({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet. When <code>prompt</code> is a list, and if a list of images is passed for a single ControlNet,
each will be paired with each prompt in the <code>prompt</code> list. This also applies to multiple ControlNets,
where a list of image lists can be passed to batch for each prompt and each ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L878",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),ce=new D({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.__call__.example",$$slots:{default:[Li]},$$scope:{ctx:x}}}),lt=new C({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1597"}}),pe=new Oe({props:{warning:!0,$$slots:{default:[Xi]},$$scope:{ctx:x}}}),me=new D({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_attention_slicing.example",$$slots:{default:[Ri]},$$scope:{ctx:x}}}),rt=new C({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1637"}}),dt=new C({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1659"}}),ct=new C({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1666"}}),pt=new C({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1536"}}),he=new Oe({props:{warning:!0,$$slots:{default:[Vi]},$$scope:{ctx:x}}}),_e=new D({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Ei]},$$scope:{ctx:x}}}),mt=new C({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1571"}}),ft=new C({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),ye=new D({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.example",$$slots:{default:[Yi]},$$scope:{ctx:x}}}),we=new D({props:{anchor:"diffusers.StableDiffusionControlNetPipeline.load_textual_inversion.example-2",$$slots:{default:[zi]},$$scope:{ctx:x}}}),ut=new C({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L275"}}),gt=new C({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionControlNetPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionControlNetPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet.py#L827",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),ht=new on({props:{title:"StableDiffusionControlNetImg2ImgPipeline",local:"diffusers.StableDiffusionControlNetImg2ImgPipeline",headingTag:"h2"}}),_t=new C({props:{name:"class diffusers.StableDiffusionControlNetImg2ImgPipeline",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L132"}}),bt=new C({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.8"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The initial image to be used as the starting point for the image generation process. Can also accept
image latents as <code>image</code>, and if passing latents directly they are not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L891",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),xe=new D({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[Hi]},$$scope:{ctx:x}}}),yt=new C({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1597"}}),Ie=new Oe({props:{warning:!0,$$slots:{default:[Ai]},$$scope:{ctx:x}}}),Te=new D({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[Qi]},$$scope:{ctx:x}}}),wt=new C({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1637"}}),vt=new C({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1659"}}),Mt=new C({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1666"}}),xt=new C({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1536"}}),$e=new Oe({props:{warning:!0,$$slots:{default:[qi]},$$scope:{ctx:x}}}),Ne=new D({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Oi]},$$scope:{ctx:x}}}),It=new C({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1571"}}),Tt=new C({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),ke=new D({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.example",$$slots:{default:[Ki]},$$scope:{ctx:x}}}),Ze=new D({props:{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[el]},$$scope:{ctx:x}}}),Ct=new C({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet_img2img.py#L268"}}),Jt=new on({props:{title:"StableDiffusionControlNetInpaintPipeline",local:"diffusers.StableDiffusionControlNetInpaintPipeline",headingTag:"h2"}}),jt=new C({props:{name:"class diffusers.StableDiffusionControlNetInpaintPipeline",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"controlnet",val:": Union"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> or <code>List[ControlNetModel]</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L243"}}),Se=new Oe({props:{$$slots:{default:[tl]},$$scope:{ctx:x}}}),$t=new C({props:{name:"__call__",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"mask_image",val:": Union = None"},{name:"control_image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"padding_mask_crop",val:": Optional = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"controlnet_conditioning_scale",val:": Union = 0.5"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": Union = 0.0"},{name:"control_guidance_end",val:": Union = 1.0"},{name:"clip_skip",val:": Optional = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to be used as the starting point. For both
NumPy array and PyTorch tensor, the expected value range is between <code>[0, 1]</code>. If it&#x2019;s a tensor or a
list or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a NumPy array or
a list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>. It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, &#x2014;
<code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>):
<code>Image</code>, NumPy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a NumPy array or PyTorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for PyTorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for NumPy array, it would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, &#x2014;
<code>List[List[torch.FloatTensor]]</code>, or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.FloatTensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be
accepted as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height
and/or width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in
<code>init</code>, images must be passed as a list such that each element of the list can be correctly batched for
input to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to image and mask_image. If
<code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region with the same aspect ration of the image and
contains all masked area, and then expand that area based on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on
the expanded area before resizing to the original image size for inpainting. This is useful when the masked area is small while the image is large
and contain information inreleant for inpainging, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of IP-adapters.
Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding
if <code>do_classifier_free_guidance</code> is set to <code>True</code>.
If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L1101",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),We=new D({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.__call__.example",$$slots:{default:[nl]},$$scope:{ctx:x}}}),Nt=new C({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1597"}}),De=new Oe({props:{warning:!0,$$slots:{default:[ol]},$$scope:{ctx:x}}}),Ge=new D({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_attention_slicing.example",$$slots:{default:[sl]},$$scope:{ctx:x}}}),Ut=new C({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1637"}}),kt=new C({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1659"}}),Zt=new C({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1666"}}),Pt=new C({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1536"}}),Xe=new Oe({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:x}}}),Re=new D({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[il]},$$scope:{ctx:x}}}),St=new C({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1571"}}),Wt=new C({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),Ee=new D({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.example",$$slots:{default:[ll]},$$scope:{ctx:x}}}),Ye=new D({props:{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.load_textual_inversion.example-2",$$slots:{default:[rl]},$$scope:{ctx:x}}}),Dt=new C({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionControlNetInpaintPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_controlnet_inpaint.py#L393"}}),Gt=new on({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Bt=new C({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Ft=new on({props:{title:"FlaxStableDiffusionControlNetPipeline",local:"diffusers.FlaxStableDiffusionControlNetPipeline",headingTag:"h2"}}),Lt=new C({props:{name:"class diffusers.FlaxStableDiffusionControlNetPipeline",anchor:"diffusers.FlaxStableDiffusionControlNetPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"controlnet",val:": FlaxControlNetModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.FlaxControlNetModel">FlaxControlNetModel</a> &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process.`,name:"controlnet"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_flax_controlnet.py#L111"}}),Xt=new C({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": Union = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"controlnet_conditioning_scale",val:": Union = 1.0"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.prompt_ids",description:`<strong>prompt_ids</strong> (<code>jnp.ndarray</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt_ids"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>jnp.ndarray</code>) &#x2014;
Array representing the ControlNet input condition to provide guidance to the <code>unet</code> for generation.`,name:"image"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.params",description:`<strong>params</strong> (<code>Dict</code> or <code>FrozenDict</code>) &#x2014;
Dictionary containing the model parameters/weights.`,name:"params"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.prng_seed",description:`<strong>prng_seed</strong> (<code>jax.Array</code>) &#x2014;
Array containing random number generator key.`,name:"prng_seed"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>jnp.ndarray</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet/pipeline_flax_controlnet.py#L348",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),He=new D({props:{anchor:"diffusers.FlaxStableDiffusionControlNetPipeline.__call__.example",$$slots:{default:[dl]},$$scope:{ctx:x}}}),Rt=new on({props:{title:"FlaxStableDiffusionControlNetPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Vt=new C({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Et=new C({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){n=r("meta"),w=a(),l=r("p"),s=a(),f(m.$$.fragment),t=a(),M=r("p"),M.innerHTML=Ua,io=a(),Ke=r("p"),Ke.textContent=ka,lo=a(),et=r("p"),et.textContent=Za,ro=a(),tt=r("p"),tt.innerHTML=Pa,co=a(),nt=r("p"),nt.innerHTML=Sa,po=a(),ot=r("p"),ot.innerHTML=Wa,mo=a(),f(de.$$.fragment),fo=a(),f(st.$$.fragment),uo=a(),J=r("div"),f(at.$$.fragment),Po=a(),sn=r("p"),sn.textContent=Da,So=a(),an=r("p"),an.innerHTML=Ga,Wo=a(),ln=r("p"),ln.textContent=Ba,Do=a(),rn=r("ul"),rn.innerHTML=Fa,Go=a(),te=r("div"),f(it.$$.fragment),Bo=a(),dn=r("p"),dn.textContent=La,Fo=a(),f(ce.$$.fragment),Lo=a(),X=r("div"),f(lt.$$.fragment),Xo=a(),cn=r("p"),cn.textContent=Xa,Ro=a(),f(pe.$$.fragment),Vo=a(),f(me.$$.fragment),Eo=a(),fe=r("div"),f(rt.$$.fragment),Yo=a(),pn=r("p"),pn.innerHTML=Ra,zo=a(),ue=r("div"),f(dt.$$.fragment),Ho=a(),mn=r("p"),mn.textContent=Va,Ao=a(),ge=r("div"),f(ct.$$.fragment),Qo=a(),fn=r("p"),fn.innerHTML=Ea,qo=a(),R=r("div"),f(pt.$$.fragment),Oo=a(),un=r("p"),un.innerHTML=Ya,Ko=a(),f(he.$$.fragment),es=a(),f(_e.$$.fragment),ts=a(),be=r("div"),f(mt.$$.fragment),ns=a(),gn=r("p"),gn.innerHTML=za,os=a(),P=r("div"),f(ft.$$.fragment),ss=a(),hn=r("p"),hn.innerHTML=Ha,as=a(),_n=r("p"),_n.textContent=Aa,is=a(),f(ye.$$.fragment),ls=a(),bn=r("p"),bn.innerHTML=Qa,rs=a(),f(we.$$.fragment),ds=a(),ve=r("div"),f(ut.$$.fragment),cs=a(),yn=r("p"),yn.textContent=qa,ps=a(),Me=r("div"),f(gt.$$.fragment),ms=a(),wn=r("p"),wn.innerHTML=Oa,go=a(),f(ht.$$.fragment),ho=a(),$=r("div"),f(_t.$$.fragment),fs=a(),vn=r("p"),vn.textContent=Ka,us=a(),Mn=r("p"),Mn.innerHTML=ei,gs=a(),xn=r("p"),xn.textContent=ti,hs=a(),In=r("ul"),In.innerHTML=ni,_s=a(),ne=r("div"),f(bt.$$.fragment),bs=a(),Tn=r("p"),Tn.textContent=oi,ys=a(),f(xe.$$.fragment),ws=a(),V=r("div"),f(yt.$$.fragment),vs=a(),Cn=r("p"),Cn.textContent=si,Ms=a(),f(Ie.$$.fragment),xs=a(),f(Te.$$.fragment),Is=a(),Ce=r("div"),f(wt.$$.fragment),Ts=a(),Jn=r("p"),Jn.innerHTML=ai,Cs=a(),Je=r("div"),f(vt.$$.fragment),Js=a(),jn=r("p"),jn.textContent=ii,js=a(),je=r("div"),f(Mt.$$.fragment),$s=a(),$n=r("p"),$n.innerHTML=li,Ns=a(),E=r("div"),f(xt.$$.fragment),Us=a(),Nn=r("p"),Nn.innerHTML=ri,ks=a(),f($e.$$.fragment),Zs=a(),f(Ne.$$.fragment),Ps=a(),Ue=r("div"),f(It.$$.fragment),Ss=a(),Un=r("p"),Un.innerHTML=di,Ws=a(),S=r("div"),f(Tt.$$.fragment),Ds=a(),kn=r("p"),kn.innerHTML=ci,Gs=a(),Zn=r("p"),Zn.textContent=pi,Bs=a(),f(ke.$$.fragment),Fs=a(),Pn=r("p"),Pn.innerHTML=mi,Ls=a(),f(Ze.$$.fragment),Xs=a(),Pe=r("div"),f(Ct.$$.fragment),Rs=a(),Sn=r("p"),Sn.textContent=fi,_o=a(),f(Jt.$$.fragment),bo=a(),j=r("div"),f(jt.$$.fragment),Vs=a(),Wn=r("p"),Wn.textContent=ui,Es=a(),Dn=r("p"),Dn.innerHTML=gi,Ys=a(),Gn=r("p"),Gn.textContent=hi,zs=a(),Bn=r("ul"),Bn.innerHTML=_i,Hs=a(),f(Se.$$.fragment),As=a(),oe=r("div"),f($t.$$.fragment),Qs=a(),Fn=r("p"),Fn.textContent=bi,qs=a(),f(We.$$.fragment),Os=a(),Y=r("div"),f(Nt.$$.fragment),Ks=a(),Ln=r("p"),Ln.textContent=yi,ea=a(),f(De.$$.fragment),ta=a(),f(Ge.$$.fragment),na=a(),Be=r("div"),f(Ut.$$.fragment),oa=a(),Xn=r("p"),Xn.innerHTML=wi,sa=a(),Fe=r("div"),f(kt.$$.fragment),aa=a(),Rn=r("p"),Rn.textContent=vi,ia=a(),Le=r("div"),f(Zt.$$.fragment),la=a(),Vn=r("p"),Vn.innerHTML=Mi,ra=a(),z=r("div"),f(Pt.$$.fragment),da=a(),En=r("p"),En.innerHTML=xi,ca=a(),f(Xe.$$.fragment),pa=a(),f(Re.$$.fragment),ma=a(),Ve=r("div"),f(St.$$.fragment),fa=a(),Yn=r("p"),Yn.innerHTML=Ii,ua=a(),W=r("div"),f(Wt.$$.fragment),ga=a(),zn=r("p"),zn.innerHTML=Ti,ha=a(),Hn=r("p"),Hn.textContent=Ci,_a=a(),f(Ee.$$.fragment),ba=a(),An=r("p"),An.innerHTML=Ji,ya=a(),f(Ye.$$.fragment),wa=a(),ze=r("div"),f(Dt.$$.fragment),va=a(),Qn=r("p"),Qn.textContent=ji,yo=a(),f(Gt.$$.fragment),wo=a(),ae=r("div"),f(Bt.$$.fragment),Ma=a(),qn=r("p"),qn.textContent=$i,vo=a(),f(Ft.$$.fragment),Mo=a(),L=r("div"),f(Lt.$$.fragment),xa=a(),On=r("p"),On.textContent=Ni,Ia=a(),Kn=r("p"),Kn.innerHTML=Ui,Ta=a(),se=r("div"),f(Xt.$$.fragment),Ca=a(),eo=r("p"),eo.textContent=ki,Ja=a(),f(He.$$.fragment),xo=a(),f(Rt.$$.fragment),Io=a(),A=r("div"),f(Vt.$$.fragment),ja=a(),to=r("p"),to.textContent=Zi,$a=a(),Ae=r("div"),f(Et.$$.fragment),Na=a(),no=r("p"),no.textContent=Pi,To=a(),ao=r("p"),this.h()},l(e){const p=Bi("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(c),w=i(e),l=d(e,"P",{}),I(l).forEach(c),s=i(e),u(m.$$.fragment,e),t=i(e),M=d(e,"P",{"data-svelte-h":!0}),y(M)!=="svelte-1v2xz23"&&(M.innerHTML=Ua),io=i(e),Ke=d(e,"P",{"data-svelte-h":!0}),y(Ke)!=="svelte-1dn0wji"&&(Ke.textContent=ka),lo=i(e),et=d(e,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1cwsb16"&&(et.textContent=Za),ro=i(e),tt=d(e,"P",{"data-svelte-h":!0}),y(tt)!=="svelte-fbiw6t"&&(tt.innerHTML=Pa),co=i(e),nt=d(e,"P",{"data-svelte-h":!0}),y(nt)!=="svelte-lv721a"&&(nt.innerHTML=Sa),po=i(e),ot=d(e,"P",{"data-svelte-h":!0}),y(ot)!=="svelte-6h8iw0"&&(ot.innerHTML=Wa),mo=i(e),u(de.$$.fragment,e),fo=i(e),u(st.$$.fragment,e),uo=i(e),J=d(e,"DIV",{class:!0});var N=I(J);u(at.$$.fragment,N),Po=i(N),sn=d(N,"P",{"data-svelte-h":!0}),y(sn)!=="svelte-1or48uk"&&(sn.textContent=Da),So=i(N),an=d(N,"P",{"data-svelte-h":!0}),y(an)!=="svelte-496sm0"&&(an.innerHTML=Ga),Wo=i(N),ln=d(N,"P",{"data-svelte-h":!0}),y(ln)!=="svelte-14s6m4u"&&(ln.textContent=Ba),Do=i(N),rn=d(N,"UL",{"data-svelte-h":!0}),y(rn)!=="svelte-17ct35o"&&(rn.innerHTML=Fa),Go=i(N),te=d(N,"DIV",{class:!0});var ie=I(te);u(it.$$.fragment,ie),Bo=i(ie),dn=d(ie,"P",{"data-svelte-h":!0}),y(dn)!=="svelte-50j04k"&&(dn.textContent=La),Fo=i(ie),u(ce.$$.fragment,ie),ie.forEach(c),Lo=i(N),X=d(N,"DIV",{class:!0});var Q=I(X);u(lt.$$.fragment,Q),Xo=i(Q),cn=d(Q,"P",{"data-svelte-h":!0}),y(cn)!=="svelte-10jaql7"&&(cn.textContent=Xa),Ro=i(Q),u(pe.$$.fragment,Q),Vo=i(Q),u(me.$$.fragment,Q),Q.forEach(c),Eo=i(N),fe=d(N,"DIV",{class:!0});var Yt=I(fe);u(rt.$$.fragment,Yt),Yo=i(Yt),pn=d(Yt,"P",{"data-svelte-h":!0}),y(pn)!=="svelte-1lh0nh5"&&(pn.innerHTML=Ra),Yt.forEach(c),zo=i(N),ue=d(N,"DIV",{class:!0});var zt=I(ue);u(dt.$$.fragment,zt),Ho=i(zt),mn=d(zt,"P",{"data-svelte-h":!0}),y(mn)!=="svelte-14bnrb6"&&(mn.textContent=Va),zt.forEach(c),Ao=i(N),ge=d(N,"DIV",{class:!0});var Ht=I(ge);u(ct.$$.fragment,Ht),Qo=i(Ht),fn=d(Ht,"P",{"data-svelte-h":!0}),y(fn)!=="svelte-1s3c06i"&&(fn.innerHTML=Ea),Ht.forEach(c),qo=i(N),R=d(N,"DIV",{class:!0});var q=I(R);u(pt.$$.fragment,q),Oo=i(q),un=d(q,"P",{"data-svelte-h":!0}),y(un)!=="svelte-e03q3e"&&(un.innerHTML=Ya),Ko=i(q),u(he.$$.fragment,q),es=i(q),u(_e.$$.fragment,q),q.forEach(c),ts=i(N),be=d(N,"DIV",{class:!0});var At=I(be);u(mt.$$.fragment,At),ns=i(At),gn=d(At,"P",{"data-svelte-h":!0}),y(gn)!=="svelte-1vfte1e"&&(gn.innerHTML=za),At.forEach(c),os=i(N),P=d(N,"DIV",{class:!0});var B=I(P);u(ft.$$.fragment,B),ss=i(B),hn=d(B,"P",{"data-svelte-h":!0}),y(hn)!=="svelte-1lv88wo"&&(hn.innerHTML=Ha),as=i(B),_n=d(B,"P",{"data-svelte-h":!0}),y(_n)!=="svelte-11lpom8"&&(_n.textContent=Aa),is=i(B),u(ye.$$.fragment,B),ls=i(B),bn=d(B,"P",{"data-svelte-h":!0}),y(bn)!=="svelte-15d7mv5"&&(bn.innerHTML=Qa),rs=i(B),u(we.$$.fragment,B),B.forEach(c),ds=i(N),ve=d(N,"DIV",{class:!0});var Qt=I(ve);u(ut.$$.fragment,Qt),cs=i(Qt),yn=d(Qt,"P",{"data-svelte-h":!0}),y(yn)!=="svelte-16q0ax1"&&(yn.textContent=qa),Qt.forEach(c),ps=i(N),Me=d(N,"DIV",{class:!0});var qt=I(Me);u(gt.$$.fragment,qt),ms=i(qt),wn=d(qt,"P",{"data-svelte-h":!0}),y(wn)!=="svelte-vo59ec"&&(wn.innerHTML=Oa),qt.forEach(c),N.forEach(c),go=i(e),u(ht.$$.fragment,e),ho=i(e),$=d(e,"DIV",{class:!0});var k=I($);u(_t.$$.fragment,k),fs=i(k),vn=d(k,"P",{"data-svelte-h":!0}),y(vn)!=="svelte-pzsf3g"&&(vn.textContent=Ka),us=i(k),Mn=d(k,"P",{"data-svelte-h":!0}),y(Mn)!=="svelte-496sm0"&&(Mn.innerHTML=ei),gs=i(k),xn=d(k,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-14s6m4u"&&(xn.textContent=ti),hs=i(k),In=d(k,"UL",{"data-svelte-h":!0}),y(In)!=="svelte-17ct35o"&&(In.innerHTML=ni),_s=i(k),ne=d(k,"DIV",{class:!0});var le=I(ne);u(bt.$$.fragment,le),bs=i(le),Tn=d(le,"P",{"data-svelte-h":!0}),y(Tn)!=="svelte-50j04k"&&(Tn.textContent=oi),ys=i(le),u(xe.$$.fragment,le),le.forEach(c),ws=i(k),V=d(k,"DIV",{class:!0});var O=I(V);u(yt.$$.fragment,O),vs=i(O),Cn=d(O,"P",{"data-svelte-h":!0}),y(Cn)!=="svelte-10jaql7"&&(Cn.textContent=si),Ms=i(O),u(Ie.$$.fragment,O),xs=i(O),u(Te.$$.fragment,O),O.forEach(c),Is=i(k),Ce=d(k,"DIV",{class:!0});var Ot=I(Ce);u(wt.$$.fragment,Ot),Ts=i(Ot),Jn=d(Ot,"P",{"data-svelte-h":!0}),y(Jn)!=="svelte-1lh0nh5"&&(Jn.innerHTML=ai),Ot.forEach(c),Cs=i(k),Je=d(k,"DIV",{class:!0});var Kt=I(Je);u(vt.$$.fragment,Kt),Js=i(Kt),jn=d(Kt,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-14bnrb6"&&(jn.textContent=ii),Kt.forEach(c),js=i(k),je=d(k,"DIV",{class:!0});var en=I(je);u(Mt.$$.fragment,en),$s=i(en),$n=d(en,"P",{"data-svelte-h":!0}),y($n)!=="svelte-1s3c06i"&&($n.innerHTML=li),en.forEach(c),Ns=i(k),E=d(k,"DIV",{class:!0});var K=I(E);u(xt.$$.fragment,K),Us=i(K),Nn=d(K,"P",{"data-svelte-h":!0}),y(Nn)!=="svelte-e03q3e"&&(Nn.innerHTML=ri),ks=i(K),u($e.$$.fragment,K),Zs=i(K),u(Ne.$$.fragment,K),K.forEach(c),Ps=i(k),Ue=d(k,"DIV",{class:!0});var tn=I(Ue);u(It.$$.fragment,tn),Ss=i(tn),Un=d(tn,"P",{"data-svelte-h":!0}),y(Un)!=="svelte-1vfte1e"&&(Un.innerHTML=di),tn.forEach(c),Ws=i(k),S=d(k,"DIV",{class:!0});var F=I(S);u(Tt.$$.fragment,F),Ds=i(F),kn=d(F,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-1lv88wo"&&(kn.innerHTML=ci),Gs=i(F),Zn=d(F,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-11lpom8"&&(Zn.textContent=pi),Bs=i(F),u(ke.$$.fragment,F),Fs=i(F),Pn=d(F,"P",{"data-svelte-h":!0}),y(Pn)!=="svelte-15d7mv5"&&(Pn.innerHTML=mi),Ls=i(F),u(Ze.$$.fragment,F),F.forEach(c),Xs=i(k),Pe=d(k,"DIV",{class:!0});var nn=I(Pe);u(Ct.$$.fragment,nn),Rs=i(nn),Sn=d(nn,"P",{"data-svelte-h":!0}),y(Sn)!=="svelte-16q0ax1"&&(Sn.textContent=fi),nn.forEach(c),k.forEach(c),_o=i(e),u(Jt.$$.fragment,e),bo=i(e),j=d(e,"DIV",{class:!0});var U=I(j);u(jt.$$.fragment,U),Vs=i(U),Wn=d(U,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-l9ypsb"&&(Wn.textContent=ui),Es=i(U),Dn=d(U,"P",{"data-svelte-h":!0}),y(Dn)!=="svelte-496sm0"&&(Dn.innerHTML=gi),Ys=i(U),Gn=d(U,"P",{"data-svelte-h":!0}),y(Gn)!=="svelte-14s6m4u"&&(Gn.textContent=hi),zs=i(U),Bn=d(U,"UL",{"data-svelte-h":!0}),y(Bn)!=="svelte-17ct35o"&&(Bn.innerHTML=_i),Hs=i(U),u(Se.$$.fragment,U),As=i(U),oe=d(U,"DIV",{class:!0});var re=I(oe);u($t.$$.fragment,re),Qs=i(re),Fn=d(re,"P",{"data-svelte-h":!0}),y(Fn)!=="svelte-50j04k"&&(Fn.textContent=bi),qs=i(re),u(We.$$.fragment,re),re.forEach(c),Os=i(U),Y=d(U,"DIV",{class:!0});var ee=I(Y);u(Nt.$$.fragment,ee),Ks=i(ee),Ln=d(ee,"P",{"data-svelte-h":!0}),y(Ln)!=="svelte-10jaql7"&&(Ln.textContent=yi),ea=i(ee),u(De.$$.fragment,ee),ta=i(ee),u(Ge.$$.fragment,ee),ee.forEach(c),na=i(U),Be=d(U,"DIV",{class:!0});var Jo=I(Be);u(Ut.$$.fragment,Jo),oa=i(Jo),Xn=d(Jo,"P",{"data-svelte-h":!0}),y(Xn)!=="svelte-1lh0nh5"&&(Xn.innerHTML=wi),Jo.forEach(c),sa=i(U),Fe=d(U,"DIV",{class:!0});var jo=I(Fe);u(kt.$$.fragment,jo),aa=i(jo),Rn=d(jo,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-14bnrb6"&&(Rn.textContent=vi),jo.forEach(c),ia=i(U),Le=d(U,"DIV",{class:!0});var $o=I(Le);u(Zt.$$.fragment,$o),la=i($o),Vn=d($o,"P",{"data-svelte-h":!0}),y(Vn)!=="svelte-1s3c06i"&&(Vn.innerHTML=Mi),$o.forEach(c),ra=i(U),z=d(U,"DIV",{class:!0});var Qe=I(z);u(Pt.$$.fragment,Qe),da=i(Qe),En=d(Qe,"P",{"data-svelte-h":!0}),y(En)!=="svelte-e03q3e"&&(En.innerHTML=xi),ca=i(Qe),u(Xe.$$.fragment,Qe),pa=i(Qe),u(Re.$$.fragment,Qe),Qe.forEach(c),ma=i(U),Ve=d(U,"DIV",{class:!0});var No=I(Ve);u(St.$$.fragment,No),fa=i(No),Yn=d(No,"P",{"data-svelte-h":!0}),y(Yn)!=="svelte-1vfte1e"&&(Yn.innerHTML=Ii),No.forEach(c),ua=i(U),W=d(U,"DIV",{class:!0});var H=I(W);u(Wt.$$.fragment,H),ga=i(H),zn=d(H,"P",{"data-svelte-h":!0}),y(zn)!=="svelte-1lv88wo"&&(zn.innerHTML=Ti),ha=i(H),Hn=d(H,"P",{"data-svelte-h":!0}),y(Hn)!=="svelte-11lpom8"&&(Hn.textContent=Ci),_a=i(H),u(Ee.$$.fragment,H),ba=i(H),An=d(H,"P",{"data-svelte-h":!0}),y(An)!=="svelte-15d7mv5"&&(An.innerHTML=Ji),ya=i(H),u(Ye.$$.fragment,H),H.forEach(c),wa=i(U),ze=d(U,"DIV",{class:!0});var Uo=I(ze);u(Dt.$$.fragment,Uo),va=i(Uo),Qn=d(Uo,"P",{"data-svelte-h":!0}),y(Qn)!=="svelte-16q0ax1"&&(Qn.textContent=ji),Uo.forEach(c),U.forEach(c),yo=i(e),u(Gt.$$.fragment,e),wo=i(e),ae=d(e,"DIV",{class:!0});var ko=I(ae);u(Bt.$$.fragment,ko),Ma=i(ko),qn=d(ko,"P",{"data-svelte-h":!0}),y(qn)!=="svelte-1qpjiuf"&&(qn.textContent=$i),ko.forEach(c),vo=i(e),u(Ft.$$.fragment,e),Mo=i(e),L=d(e,"DIV",{class:!0});var qe=I(L);u(Lt.$$.fragment,qe),xa=i(qe),On=d(qe,"P",{"data-svelte-h":!0}),y(On)!=="svelte-11a4l7z"&&(On.textContent=Ni),Ia=i(qe),Kn=d(qe,"P",{"data-svelte-h":!0}),y(Kn)!=="svelte-knddhk"&&(Kn.innerHTML=Ui),Ta=i(qe),se=d(qe,"DIV",{class:!0});var oo=I(se);u(Xt.$$.fragment,oo),Ca=i(oo),eo=d(oo,"P",{"data-svelte-h":!0}),y(eo)!=="svelte-50j04k"&&(eo.textContent=ki),Ja=i(oo),u(He.$$.fragment,oo),oo.forEach(c),qe.forEach(c),xo=i(e),u(Rt.$$.fragment,e),Io=i(e),A=d(e,"DIV",{class:!0});var so=I(A);u(Vt.$$.fragment,so),ja=i(so),to=d(so,"P",{"data-svelte-h":!0}),y(to)!=="svelte-wzv2jc"&&(to.textContent=Zi),$a=i(so),Ae=d(so,"DIV",{class:!0});var Zo=I(Ae);u(Et.$$.fragment,Zo),Na=i(Zo),no=d(Zo,"P",{"data-svelte-h":!0}),y(no)!=="svelte-5ihtpa"&&(no.textContent=Pi),Zo.forEach(c),so.forEach(c),To=i(e),ao=d(e,"P",{}),I(ao).forEach(c),this.h()},h(){T(n,"name","hf:doc:metadata"),T(n,"content",pl),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),v(e,w,p),v(e,l,p),v(e,s,p),g(m,e,p),v(e,t,p),v(e,M,p),v(e,io,p),v(e,Ke,p),v(e,lo,p),v(e,et,p),v(e,ro,p),v(e,tt,p),v(e,co,p),v(e,nt,p),v(e,po,p),v(e,ot,p),v(e,mo,p),g(de,e,p),v(e,fo,p),g(st,e,p),v(e,uo,p),v(e,J,p),g(at,J,null),o(J,Po),o(J,sn),o(J,So),o(J,an),o(J,Wo),o(J,ln),o(J,Do),o(J,rn),o(J,Go),o(J,te),g(it,te,null),o(te,Bo),o(te,dn),o(te,Fo),g(ce,te,null),o(J,Lo),o(J,X),g(lt,X,null),o(X,Xo),o(X,cn),o(X,Ro),g(pe,X,null),o(X,Vo),g(me,X,null),o(J,Eo),o(J,fe),g(rt,fe,null),o(fe,Yo),o(fe,pn),o(J,zo),o(J,ue),g(dt,ue,null),o(ue,Ho),o(ue,mn),o(J,Ao),o(J,ge),g(ct,ge,null),o(ge,Qo),o(ge,fn),o(J,qo),o(J,R),g(pt,R,null),o(R,Oo),o(R,un),o(R,Ko),g(he,R,null),o(R,es),g(_e,R,null),o(J,ts),o(J,be),g(mt,be,null),o(be,ns),o(be,gn),o(J,os),o(J,P),g(ft,P,null),o(P,ss),o(P,hn),o(P,as),o(P,_n),o(P,is),g(ye,P,null),o(P,ls),o(P,bn),o(P,rs),g(we,P,null),o(J,ds),o(J,ve),g(ut,ve,null),o(ve,cs),o(ve,yn),o(J,ps),o(J,Me),g(gt,Me,null),o(Me,ms),o(Me,wn),v(e,go,p),g(ht,e,p),v(e,ho,p),v(e,$,p),g(_t,$,null),o($,fs),o($,vn),o($,us),o($,Mn),o($,gs),o($,xn),o($,hs),o($,In),o($,_s),o($,ne),g(bt,ne,null),o(ne,bs),o(ne,Tn),o(ne,ys),g(xe,ne,null),o($,ws),o($,V),g(yt,V,null),o(V,vs),o(V,Cn),o(V,Ms),g(Ie,V,null),o(V,xs),g(Te,V,null),o($,Is),o($,Ce),g(wt,Ce,null),o(Ce,Ts),o(Ce,Jn),o($,Cs),o($,Je),g(vt,Je,null),o(Je,Js),o(Je,jn),o($,js),o($,je),g(Mt,je,null),o(je,$s),o(je,$n),o($,Ns),o($,E),g(xt,E,null),o(E,Us),o(E,Nn),o(E,ks),g($e,E,null),o(E,Zs),g(Ne,E,null),o($,Ps),o($,Ue),g(It,Ue,null),o(Ue,Ss),o(Ue,Un),o($,Ws),o($,S),g(Tt,S,null),o(S,Ds),o(S,kn),o(S,Gs),o(S,Zn),o(S,Bs),g(ke,S,null),o(S,Fs),o(S,Pn),o(S,Ls),g(Ze,S,null),o($,Xs),o($,Pe),g(Ct,Pe,null),o(Pe,Rs),o(Pe,Sn),v(e,_o,p),g(Jt,e,p),v(e,bo,p),v(e,j,p),g(jt,j,null),o(j,Vs),o(j,Wn),o(j,Es),o(j,Dn),o(j,Ys),o(j,Gn),o(j,zs),o(j,Bn),o(j,Hs),g(Se,j,null),o(j,As),o(j,oe),g($t,oe,null),o(oe,Qs),o(oe,Fn),o(oe,qs),g(We,oe,null),o(j,Os),o(j,Y),g(Nt,Y,null),o(Y,Ks),o(Y,Ln),o(Y,ea),g(De,Y,null),o(Y,ta),g(Ge,Y,null),o(j,na),o(j,Be),g(Ut,Be,null),o(Be,oa),o(Be,Xn),o(j,sa),o(j,Fe),g(kt,Fe,null),o(Fe,aa),o(Fe,Rn),o(j,ia),o(j,Le),g(Zt,Le,null),o(Le,la),o(Le,Vn),o(j,ra),o(j,z),g(Pt,z,null),o(z,da),o(z,En),o(z,ca),g(Xe,z,null),o(z,pa),g(Re,z,null),o(j,ma),o(j,Ve),g(St,Ve,null),o(Ve,fa),o(Ve,Yn),o(j,ua),o(j,W),g(Wt,W,null),o(W,ga),o(W,zn),o(W,ha),o(W,Hn),o(W,_a),g(Ee,W,null),o(W,ba),o(W,An),o(W,ya),g(Ye,W,null),o(j,wa),o(j,ze),g(Dt,ze,null),o(ze,va),o(ze,Qn),v(e,yo,p),g(Gt,e,p),v(e,wo,p),v(e,ae,p),g(Bt,ae,null),o(ae,Ma),o(ae,qn),v(e,vo,p),g(Ft,e,p),v(e,Mo,p),v(e,L,p),g(Lt,L,null),o(L,xa),o(L,On),o(L,Ia),o(L,Kn),o(L,Ta),o(L,se),g(Xt,se,null),o(se,Ca),o(se,eo),o(se,Ja),g(He,se,null),v(e,xo,p),g(Rt,e,p),v(e,Io,p),v(e,A,p),g(Vt,A,null),o(A,ja),o(A,to),o(A,$a),o(A,Ae),g(Et,Ae,null),o(Ae,Na),o(Ae,no),v(e,To,p),v(e,ao,p),Co=!0},p(e,[p]){const N={};p&2&&(N.$$scope={dirty:p,ctx:e}),de.$set(N);const ie={};p&2&&(ie.$$scope={dirty:p,ctx:e}),ce.$set(ie);const Q={};p&2&&(Q.$$scope={dirty:p,ctx:e}),pe.$set(Q);const Yt={};p&2&&(Yt.$$scope={dirty:p,ctx:e}),me.$set(Yt);const zt={};p&2&&(zt.$$scope={dirty:p,ctx:e}),he.$set(zt);const Ht={};p&2&&(Ht.$$scope={dirty:p,ctx:e}),_e.$set(Ht);const q={};p&2&&(q.$$scope={dirty:p,ctx:e}),ye.$set(q);const At={};p&2&&(At.$$scope={dirty:p,ctx:e}),we.$set(At);const B={};p&2&&(B.$$scope={dirty:p,ctx:e}),xe.$set(B);const Qt={};p&2&&(Qt.$$scope={dirty:p,ctx:e}),Ie.$set(Qt);const qt={};p&2&&(qt.$$scope={dirty:p,ctx:e}),Te.$set(qt);const k={};p&2&&(k.$$scope={dirty:p,ctx:e}),$e.$set(k);const le={};p&2&&(le.$$scope={dirty:p,ctx:e}),Ne.$set(le);const O={};p&2&&(O.$$scope={dirty:p,ctx:e}),ke.$set(O);const Ot={};p&2&&(Ot.$$scope={dirty:p,ctx:e}),Ze.$set(Ot);const Kt={};p&2&&(Kt.$$scope={dirty:p,ctx:e}),Se.$set(Kt);const en={};p&2&&(en.$$scope={dirty:p,ctx:e}),We.$set(en);const K={};p&2&&(K.$$scope={dirty:p,ctx:e}),De.$set(K);const tn={};p&2&&(tn.$$scope={dirty:p,ctx:e}),Ge.$set(tn);const F={};p&2&&(F.$$scope={dirty:p,ctx:e}),Xe.$set(F);const nn={};p&2&&(nn.$$scope={dirty:p,ctx:e}),Re.$set(nn);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),Ee.$set(U);const re={};p&2&&(re.$$scope={dirty:p,ctx:e}),Ye.$set(re);const ee={};p&2&&(ee.$$scope={dirty:p,ctx:e}),He.$set(ee)},i(e){Co||(h(m.$$.fragment,e),h(de.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(ce.$$.fragment,e),h(lt.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(mt.$$.fragment,e),h(ft.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(bt.$$.fragment,e),h(xe.$$.fragment,e),h(yt.$$.fragment,e),h(Ie.$$.fragment,e),h(Te.$$.fragment,e),h(wt.$$.fragment,e),h(vt.$$.fragment,e),h(Mt.$$.fragment,e),h(xt.$$.fragment,e),h($e.$$.fragment,e),h(Ne.$$.fragment,e),h(It.$$.fragment,e),h(Tt.$$.fragment,e),h(ke.$$.fragment,e),h(Ze.$$.fragment,e),h(Ct.$$.fragment,e),h(Jt.$$.fragment,e),h(jt.$$.fragment,e),h(Se.$$.fragment,e),h($t.$$.fragment,e),h(We.$$.fragment,e),h(Nt.$$.fragment,e),h(De.$$.fragment,e),h(Ge.$$.fragment,e),h(Ut.$$.fragment,e),h(kt.$$.fragment,e),h(Zt.$$.fragment,e),h(Pt.$$.fragment,e),h(Xe.$$.fragment,e),h(Re.$$.fragment,e),h(St.$$.fragment,e),h(Wt.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Dt.$$.fragment,e),h(Gt.$$.fragment,e),h(Bt.$$.fragment,e),h(Ft.$$.fragment,e),h(Lt.$$.fragment,e),h(Xt.$$.fragment,e),h(He.$$.fragment,e),h(Rt.$$.fragment,e),h(Vt.$$.fragment,e),h(Et.$$.fragment,e),Co=!0)},o(e){_(m.$$.fragment,e),_(de.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(it.$$.fragment,e),_(ce.$$.fragment,e),_(lt.$$.fragment,e),_(pe.$$.fragment,e),_(me.$$.fragment,e),_(rt.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(pt.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(mt.$$.fragment,e),_(ft.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(ut.$$.fragment,e),_(gt.$$.fragment,e),_(ht.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(xe.$$.fragment,e),_(yt.$$.fragment,e),_(Ie.$$.fragment,e),_(Te.$$.fragment,e),_(wt.$$.fragment,e),_(vt.$$.fragment,e),_(Mt.$$.fragment,e),_(xt.$$.fragment,e),_($e.$$.fragment,e),_(Ne.$$.fragment,e),_(It.$$.fragment,e),_(Tt.$$.fragment,e),_(ke.$$.fragment,e),_(Ze.$$.fragment,e),_(Ct.$$.fragment,e),_(Jt.$$.fragment,e),_(jt.$$.fragment,e),_(Se.$$.fragment,e),_($t.$$.fragment,e),_(We.$$.fragment,e),_(Nt.$$.fragment,e),_(De.$$.fragment,e),_(Ge.$$.fragment,e),_(Ut.$$.fragment,e),_(kt.$$.fragment,e),_(Zt.$$.fragment,e),_(Pt.$$.fragment,e),_(Xe.$$.fragment,e),_(Re.$$.fragment,e),_(St.$$.fragment,e),_(Wt.$$.fragment,e),_(Ee.$$.fragment,e),_(Ye.$$.fragment,e),_(Dt.$$.fragment,e),_(Gt.$$.fragment,e),_(Bt.$$.fragment,e),_(Ft.$$.fragment,e),_(Lt.$$.fragment,e),_(Xt.$$.fragment,e),_(He.$$.fragment,e),_(Rt.$$.fragment,e),_(Vt.$$.fragment,e),_(Et.$$.fragment,e),Co=!1},d(e){e&&(c(w),c(l),c(s),c(t),c(M),c(io),c(Ke),c(lo),c(et),c(ro),c(tt),c(co),c(nt),c(po),c(ot),c(mo),c(fo),c(uo),c(J),c(go),c(ho),c($),c(_o),c(bo),c(j),c(yo),c(wo),c(ae),c(vo),c(Mo),c(L),c(xo),c(Io),c(A),c(To),c(ao)),c(n),b(m,e),b(de,e),b(st,e),b(at),b(it),b(ce),b(lt),b(pe),b(me),b(rt),b(dt),b(ct),b(pt),b(he),b(_e),b(mt),b(ft),b(ye),b(we),b(ut),b(gt),b(ht,e),b(_t),b(bt),b(xe),b(yt),b(Ie),b(Te),b(wt),b(vt),b(Mt),b(xt),b($e),b(Ne),b(It),b(Tt),b(ke),b(Ze),b(Ct),b(Jt,e),b(jt),b(Se),b($t),b(We),b(Nt),b(De),b(Ge),b(Ut),b(kt),b(Zt),b(Pt),b(Xe),b(Re),b(St),b(Wt),b(Ee),b(Ye),b(Dt),b(Gt,e),b(Bt),b(Ft,e),b(Lt),b(Xt),b(He),b(Rt,e),b(Vt),b(Et)}}}const pl='{"title":"ControlNet","local":"controlnet","sections":[{"title":"StableDiffusionControlNetPipeline","local":"diffusers.StableDiffusionControlNetPipeline","sections":[],"depth":2},{"title":"StableDiffusionControlNetImg2ImgPipeline","local":"diffusers.StableDiffusionControlNetImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionControlNetInpaintPipeline","local":"diffusers.StableDiffusionControlNetInpaintPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionControlNetPipeline","local":"diffusers.FlaxStableDiffusionControlNetPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionControlNetPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function ml(x){return Wi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends Di{constructor(n){super(),Gi(this,n,ml,cl,Si,{})}}export{wl as component};
