import{s as Xt,o as Ft,n as St}from"../chunks/scheduler.c57aa7ef.js";import{S as Ht,i as Qt,g as o,s as n,r as p,A as zt,h as i,f as l,c as a,j as Nt,u as r,x as m,k as Yt,y as qt,a as s,v as c,d as y,t as M,w as d}from"../chunks/index.c50cb18e.js";import{T as Dt}from"../chunks/Tip.9268b0ca.js";import{C as h}from"../chunks/CodeBlock.34f0a53d.js";import{H as ue}from"../chunks/Heading.c7d7e0e7.js";function Pt(he){let u,w=`For this toy example, we choose an exceedingly large number of hidden units to highlight the efficiency gains
from PEFT, but those gains are in line with more realistic examples.`;return{c(){u=o("p"),u.textContent=w},l(b){u=i(b,"P",{"data-svelte-h":!0}),m(u)!=="svelte-7te1s3"&&(u.textContent=w)},m(b,Me){s(b,u,Me)},p:St,d(b){b&&l(u)}}}function Kt(he){let u,w,b,Me,J,be,j,yt=`Some fine-tuning techniques, such as prompt tuning, are specific to language models. That means in 🤗 PEFT, it is
assumed a 🤗 Transformers model is being used. However, other fine-tuning techniques - like
<a href="../conceptual_guides/lora">LoRA</a> - are not restricted to specific model types.`,fe,T,Mt='In this guide, we will see how LoRA can be applied to a multilayer perceptron, a computer vision model from the <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library, or a new 🤗 Transformers architecture.',we,k,Je,g,dt="Let’s assume that we want to fine-tune a multilayer perceptron with LoRA. Here is the definition:",je,x,Te,C,ut="This is a straightforward multilayer perceptron with an input layer, a hidden layer, and an output layer.",ke,f,ge,U,ht=`There are a few linear layers in this model that could be tuned with LoRA. When working with common 🤗 Transformers
models, PEFT will know which layers to apply LoRA to, but in this case, it is up to us as a user to choose the layers.
To determine the names of the layers to tune:`,xe,v,Ce,L,bt="This should print:",Ue,Z,ve,W,ft=`Let’s say we want to apply LoRA to the input layer and to the hidden layer, those are <code>&#39;seq.0&#39;</code> and <code>&#39;seq.2&#39;</code>. Moreover,
let’s assume we want to update the output layer without LoRA, that would be <code>&#39;seq.4&#39;</code>. The corresponding config would
be:`,Le,_,Ze,$,wt="With that, we can create our PEFT model and check the fraction of parameters trained:",We,G,_e,I,Jt="Finally, we can use any training framework we like, or write our own fit loop, to train the <code>peft_model</code>.",$e,R,jt='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/multilayer_perceptron/multilayer_perceptron_lora.ipynb" rel="nofollow">this notebook</a>.',Ge,V,Ie,A,Tt=`The <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library contains a large number of pretrained computer vision models.
Those can also be fine-tuned with PEFT. Let’s check out how this works in practice.`,Re,B,kt="To start, ensure that timm is installed in the Python environment:",Ve,E,Ae,N,gt="Next we load a timm model for an image classification task:",Be,Y,Ee,X,xt=`Again, we need to make a decision about what layers to apply LoRA to. Since LoRA supports 2D conv layers, and since
those are a major building block of this model, we should apply LoRA to the 2D conv layers. To identify the names of
those layers, let’s look at all the layer names:`,Ne,F,Ye,S,Ct="This will print a very long list, we’ll only show the first few:",Xe,H,Fe,Q,Ut=`Upon closer inspection, we see that the 2D conv layers have names such as <code>&quot;stages.0.blocks.0.mlp.fc1&quot;</code> and
<code>&quot;stages.0.blocks.0.mlp.fc2&quot;</code>. How can we match those layer names specifically? You can write a <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular
expressions</a> to match the layer names. For our case, the regex
<code>r&quot;.*\\.mlp\\.fc\\d&quot;</code> should do the job.`,Se,z,vt=`Furthermore, as in the first example, we should ensure that the output layer, in this case the classification head, is
also updated. Looking at the end of the list printed above, we can see that it’s named <code>&#39;head.fc&#39;</code>. With that in mind,
here is our LoRA config:`,He,q,Qe,D,Lt="Then we only need to create the PEFT model by passing our base model and the config to <code>get_peft_model</code>:",ze,P,qe,K,Zt="This shows us that we only need to train less than 2% of all parameters, which is a huge efficiency gain.",De,O,Wt='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/image_classification/image_classification_timm_peft_lora.ipynb" rel="nofollow">this notebook</a>.',Pe,ee,Ke,te,_t="When new popular transformers architectures are released, we do our best to quickly add them to PEFT. If you come across a transformers model that is not supported out of the box, don’t worry, it will most likely still work if the config is set correctly. Specifically, you have to identify the layers that should be adapted and set them correctly when initializing the corresponding config class, e.g. <code>LoraConfig</code>. Here are some tips to help with this.",Oe,le,$t='As a first step, it is a good idea is to check the existing models for inspiration. You can find them inside of <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> in the PEFT repository. Often, you’ll find a similar architecture that uses the same names. For example, if the new model architecture is a variation of the “mistral” model and you want to apply LoRA, you can see that the entry for “mistral” in <code>TRANSFORMERS_MODELS_TO_LORA_TARGET_MODULES_MAPPING</code> contains <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>. This tells you that for “mistral” models, the <code>target_modules</code> for LoRA should be <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>:',et,se,tt,ne,Gt="If that doesn’t help, check the existing modules in your model architecture with the <code>named_modules</code> method and try to identify the attention layers, especially the key, query, and value layers. Those will often have names such as <code>c_attn</code>, <code>query</code>, <code>q_proj</code>, etc. The key layer is not always adapted, and ideally, you should check whether including it results in better performance.",lt,ae,It='Additionally, linear layers are common targets to be adapted (e.g. in <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">QLoRA paper</a>, authors suggest to adapt them as well). Their names will often contain the strings <code>fc</code> or <code>dense</code>.',st,oe,Rt='If you want to add a new model to PEFT, please create an entry in <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> and open a pull request on the <a href="https://github.com/huggingface/peft/pulls" rel="nofollow">repository</a>. Don’t forget to update the <a href="https://github.com/huggingface/peft#models-support-matrix" rel="nofollow">README</a> as well.',nt,ie,at,me,Vt="You can verify whether you’ve correctly applied a PEFT method to your model in a few ways.",ot,pe,At='<li>Check the fraction of parameters that are trainable with the <a href="/docs/peft/v0.10.0/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method. If this number is lower or higher than expected, check the model <code>repr</code> by printing the model. This shows the names of all the layer types in the model. Ensure that only the intended target layers are replaced by the adapter layers. For example, if LoRA is applied to <code>nn.Linear</code> layers, then you should only see <code>lora.Linear</code> layers being used.</li>',it,re,mt,ce,Bt="<li>Another way you can view the adapted layers is to use the <code>targeted_module_names</code> attribute to list the name of each module that was adapted.</li>",pt,ye,rt,de,ct;return J=new ue({props:{title:"Custom models",local:"custom-models",headingTag:"h1"}}),k=new ue({props:{title:"Multilayer perceptron",local:"multilayer-perceptron",headingTag:"h2"}}),x=new h({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyME1MUChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV91bml0c19oaWRkZW4lM0QyMDAwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2VxJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIoMjAlMkMlMjBudW1fdW5pdHNfaGlkZGVuKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcihudW1fdW5pdHNfaGlkZGVuJTJDJTIwbnVtX3VuaXRzX2hpZGRlbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIobnVtX3VuaXRzX2hpZGRlbiUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTG9nU29mdG1heChkaW0lM0QtMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwWCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnNlcShYKQ==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MLP</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_units_hidden=<span class="hljs-number">2000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.seq = nn.Sequential(
            nn.Linear(<span class="hljs-number">20</span>, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, <span class="hljs-number">2</span>),
            nn.LogSoftmax(dim=-<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, X</span>):
        <span class="hljs-keyword">return</span> self.seq(X)`,wrap:!1}}),f=new Dt({props:{$$slots:{default:[Pt]},$$scope:{ctx:he}}}),v=new h({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),Z=new h({props:{code:"JTVCKCcnJTJDJTIwX19tYWluX18uTUxQKSUyQyUwQSUyMCgnc2VxJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuY29udGFpbmVyLlNlcXVlbnRpYWwpJTJDJTBBJTIwKCdzZXEuMCclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmxpbmVhci5MaW5lYXIpJTJDJTBBJTIwKCdzZXEuMSclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmFjdGl2YXRpb24uUmVMVSklMkMlMEElMjAoJ3NlcS4yJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMubGluZWFyLkxpbmVhciklMkMlMEElMjAoJ3NlcS4zJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuYWN0aXZhdGlvbi5SZUxVKSUyQyUwQSUyMCgnc2VxLjQnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5saW5lYXIuTGluZWFyKSUyQyUwQSUyMCgnc2VxLjUnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5hY3RpdmF0aW9uLkxvZ1NvZnRtYXgpJTVE",highlighted:`[(&#x27;&#x27;, __main__.MLP),
 (<span class="hljs-symbol">&#x27;seq</span>&#x27;, torch.nn.modules.container.Sequential),
 (<span class="hljs-symbol">&#x27;seq.0</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.1</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.2</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.3</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.4</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.5</span>&#x27;, torch.nn.modules.activation.LogSoftmax)]`,wrap:!1}}),_=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnNlcS4wJTIyJTJDJTIwJTIyc2VxLjIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJzZXEuNCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;seq.0&quot;</span>, <span class="hljs-string">&quot;seq.2&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;seq.4&quot;</span>],
)`,wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxQKCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIzJTIwcHJpbnRzJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTYlMkMxNjQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA0JTJDMTAwJTJDMTY0JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4zNjk3OTg4NjY1ODE5MjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = MLP()
peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 56,164 || all params: 4,100,164 || trainable%: 1.369798866581922</span>`,wrap:!1}}),V=new ue({props:{title:"timm models",local:"timm-models",headingTag:"h2"}}),E=new h({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0aW1t",highlighted:"python -m pip install -U timm",wrap:!1}}),Y=new h({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW51bV9jbGFzc2VzJTIwJTNEJTIwLi4uJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0aW1tJTJGcG9vbGZvcm1lcl9tMzYuc2FpbF9pbjFrJTIyJTBBbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbChtb2RlbF9pZCUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fY2xhc3Nlcyk=",highlighted:`<span class="hljs-keyword">import</span> timm

num_classes = ...
model_id = <span class="hljs-string">&quot;timm/poolformer_m36.sail_in1k&quot;</span>
model = timm.create_model(model_id, pretrained=<span class="hljs-literal">True</span>, num_classes=num_classes)`,wrap:!1}}),F=new h({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBtb2RlbC5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> model.named_modules()])',wrap:!1}}),H=new h({props:{code:"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",highlighted:`[(<span class="hljs-string">&#x27;&#x27;</span>, timm.models.metaformer.MetaFormer),
 (<span class="hljs-string">&#x27;stem&#x27;</span>, timm.models.metaformer.Stem),
 (<span class="hljs-string">&#x27;stem.conv&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stem.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0&#x27;</span>, timm.models.metaformer.MetaFormerStage),
 (<span class="hljs-string">&#x27;stages.0.downsample&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0.blocks.0&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale1&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm2&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp&#x27;</span>, timm.layers.mlp.Mlp),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.act&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.activation.GELU),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale2&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.1&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 ...
 (<span class="hljs-string">&#x27;head.global_pool.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.norm&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.LayerNorm2d),
 (<span class="hljs-string">&#x27;head.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.flatten.Flatten),
 (<span class="hljs-string">&#x27;head.drop&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.fc&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Linear)]
 ]`,wrap:!1}}),q=new h({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRHIlMjIuKiU1Qy5tbHAlNUMuZmMlNUNkJTIyJTJDJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyaGVhZC5mYyUyMiU1RCk=",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">r&quot;.*\\.mlp\\.fc\\d&quot;</span>, modules_to_save=[<span class="hljs-string">&quot;head.fc&quot;</span>])',wrap:!1}}),P=new h({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMyUyMHByaW50cyUyMHRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDElMkMwNjQlMkM0NTQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NiUyQzQ2NyUyQzk3NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEuODg1MDU3ODkxMzk4NzY=",highlighted:`peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 1,064,454 || all params: 56,467,974 || trainable%: 1.88505789139876</span>`,wrap:!1}}),ee=new ue({props:{title:"New transformers architectures",local:"new-transformers-architectures",headingTag:"h2"}}),se=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFteV9taXN0cmFsX21vZGVsJTIwJTNEJTIwLi4uJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMC4uLiUyQyUyMCUyMCUyMyUyMG90aGVyJTIwTG9SQSUyMGFyZ3VtZW50cyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobXlfbWlzdHJhbF9tb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

my_mistral_model = ...
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    ...,  <span class="hljs-comment"># other LoRA arguments</span>
)
peft_model = get_peft_model(my_mistral_model, config)`,wrap:!1}}),ie=new ue({props:{title:"Verify parameters and layers",local:"verify-parameters-and-layers",headingTag:"h2"}}),re=new h({props:{code:"cGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygp",highlighted:"peft_model.print_trainable_parameters()",wrap:!1}}),ye=new h({props:{code:"cHJpbnQocGVmdF9tb2RlbC50YXJnZXRlZF9tb2R1bGVfbmFtZXMp",highlighted:'<span class="hljs-built_in">print</span>(peft_model.targeted_module_names)',wrap:!1}}),{c(){u=o("meta"),w=n(),b=o("p"),Me=n(),p(J.$$.fragment),be=n(),j=o("p"),j.innerHTML=yt,fe=n(),T=o("p"),T.innerHTML=Mt,we=n(),p(k.$$.fragment),Je=n(),g=o("p"),g.textContent=dt,je=n(),p(x.$$.fragment),Te=n(),C=o("p"),C.textContent=ut,ke=n(),p(f.$$.fragment),ge=n(),U=o("p"),U.textContent=ht,xe=n(),p(v.$$.fragment),Ce=n(),L=o("p"),L.textContent=bt,Ue=n(),p(Z.$$.fragment),ve=n(),W=o("p"),W.innerHTML=ft,Le=n(),p(_.$$.fragment),Ze=n(),$=o("p"),$.textContent=wt,We=n(),p(G.$$.fragment),_e=n(),I=o("p"),I.innerHTML=Jt,$e=n(),R=o("p"),R.innerHTML=jt,Ge=n(),p(V.$$.fragment),Ie=n(),A=o("p"),A.innerHTML=Tt,Re=n(),B=o("p"),B.textContent=kt,Ve=n(),p(E.$$.fragment),Ae=n(),N=o("p"),N.textContent=gt,Be=n(),p(Y.$$.fragment),Ee=n(),X=o("p"),X.textContent=xt,Ne=n(),p(F.$$.fragment),Ye=n(),S=o("p"),S.textContent=Ct,Xe=n(),p(H.$$.fragment),Fe=n(),Q=o("p"),Q.innerHTML=Ut,Se=n(),z=o("p"),z.innerHTML=vt,He=n(),p(q.$$.fragment),Qe=n(),D=o("p"),D.innerHTML=Lt,ze=n(),p(P.$$.fragment),qe=n(),K=o("p"),K.textContent=Zt,De=n(),O=o("p"),O.innerHTML=Wt,Pe=n(),p(ee.$$.fragment),Ke=n(),te=o("p"),te.innerHTML=_t,Oe=n(),le=o("p"),le.innerHTML=$t,et=n(),p(se.$$.fragment),tt=n(),ne=o("p"),ne.innerHTML=Gt,lt=n(),ae=o("p"),ae.innerHTML=It,st=n(),oe=o("p"),oe.innerHTML=Rt,nt=n(),p(ie.$$.fragment),at=n(),me=o("p"),me.textContent=Vt,ot=n(),pe=o("ul"),pe.innerHTML=At,it=n(),p(re.$$.fragment),mt=n(),ce=o("ul"),ce.innerHTML=Bt,pt=n(),p(ye.$$.fragment),rt=n(),de=o("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),b=i(e,"P",{}),Nt(b).forEach(l),Me=a(e),r(J.$$.fragment,e),be=a(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1twj2ga"&&(j.innerHTML=yt),fe=a(e),T=i(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-14u0q1"&&(T.innerHTML=Mt),we=a(e),r(k.$$.fragment,e),Je=a(e),g=i(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1vzm18b"&&(g.textContent=dt),je=a(e),r(x.$$.fragment,e),Te=a(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-ifflo"&&(C.textContent=ut),ke=a(e),r(f.$$.fragment,e),ge=a(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-19hnh19"&&(U.textContent=ht),xe=a(e),r(v.$$.fragment,e),Ce=a(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-47m0b6"&&(L.textContent=bt),Ue=a(e),r(Z.$$.fragment,e),ve=a(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-hvbljg"&&(W.innerHTML=ft),Le=a(e),r(_.$$.fragment,e),Ze=a(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-12m4713"&&($.textContent=wt),We=a(e),r(G.$$.fragment,e),_e=a(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-3iyeuu"&&(I.innerHTML=Jt),$e=a(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-12a8po"&&(R.innerHTML=jt),Ge=a(e),r(V.$$.fragment,e),Ie=a(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1el2qhw"&&(A.innerHTML=Tt),Re=a(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-132k8n8"&&(B.textContent=kt),Ve=a(e),r(E.$$.fragment,e),Ae=a(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1i7knza"&&(N.textContent=gt),Be=a(e),r(Y.$$.fragment,e),Ee=a(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-66d7qt"&&(X.textContent=xt),Ne=a(e),r(F.$$.fragment,e),Ye=a(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-132x2pj"&&(S.textContent=Ct),Xe=a(e),r(H.$$.fragment,e),Fe=a(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-odd6w6"&&(Q.innerHTML=Ut),Se=a(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-vtvaop"&&(z.innerHTML=vt),He=a(e),r(q.$$.fragment,e),Qe=a(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1ym7j5n"&&(D.innerHTML=Lt),ze=a(e),r(P.$$.fragment,e),qe=a(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1a6hk12"&&(K.textContent=Zt),De=a(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-13ceymq"&&(O.innerHTML=Wt),Pe=a(e),r(ee.$$.fragment,e),Ke=a(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-zh7y7t"&&(te.innerHTML=_t),Oe=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-foxae4"&&(le.innerHTML=$t),et=a(e),r(se.$$.fragment,e),tt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-tkcysf"&&(ne.innerHTML=Gt),lt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-8q7t0u"&&(ae.innerHTML=It),st=a(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-485c9z"&&(oe.innerHTML=Rt),nt=a(e),r(ie.$$.fragment,e),at=a(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-g4uxja"&&(me.textContent=Vt),ot=a(e),pe=i(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-37jknz"&&(pe.innerHTML=At),it=a(e),r(re.$$.fragment,e),mt=a(e),ce=i(e,"UL",{"data-svelte-h":!0}),m(ce)!=="svelte-1lks9wd"&&(ce.innerHTML=Bt),pt=a(e),r(ye.$$.fragment,e),rt=a(e),de=i(e,"P",{}),Nt(de).forEach(l),this.h()},h(){Yt(u,"name","hf:doc:metadata"),Yt(u,"content",Ot)},m(e,t){qt(document.head,u),s(e,w,t),s(e,b,t),s(e,Me,t),c(J,e,t),s(e,be,t),s(e,j,t),s(e,fe,t),s(e,T,t),s(e,we,t),c(k,e,t),s(e,Je,t),s(e,g,t),s(e,je,t),c(x,e,t),s(e,Te,t),s(e,C,t),s(e,ke,t),c(f,e,t),s(e,ge,t),s(e,U,t),s(e,xe,t),c(v,e,t),s(e,Ce,t),s(e,L,t),s(e,Ue,t),c(Z,e,t),s(e,ve,t),s(e,W,t),s(e,Le,t),c(_,e,t),s(e,Ze,t),s(e,$,t),s(e,We,t),c(G,e,t),s(e,_e,t),s(e,I,t),s(e,$e,t),s(e,R,t),s(e,Ge,t),c(V,e,t),s(e,Ie,t),s(e,A,t),s(e,Re,t),s(e,B,t),s(e,Ve,t),c(E,e,t),s(e,Ae,t),s(e,N,t),s(e,Be,t),c(Y,e,t),s(e,Ee,t),s(e,X,t),s(e,Ne,t),c(F,e,t),s(e,Ye,t),s(e,S,t),s(e,Xe,t),c(H,e,t),s(e,Fe,t),s(e,Q,t),s(e,Se,t),s(e,z,t),s(e,He,t),c(q,e,t),s(e,Qe,t),s(e,D,t),s(e,ze,t),c(P,e,t),s(e,qe,t),s(e,K,t),s(e,De,t),s(e,O,t),s(e,Pe,t),c(ee,e,t),s(e,Ke,t),s(e,te,t),s(e,Oe,t),s(e,le,t),s(e,et,t),c(se,e,t),s(e,tt,t),s(e,ne,t),s(e,lt,t),s(e,ae,t),s(e,st,t),s(e,oe,t),s(e,nt,t),c(ie,e,t),s(e,at,t),s(e,me,t),s(e,ot,t),s(e,pe,t),s(e,it,t),c(re,e,t),s(e,mt,t),s(e,ce,t),s(e,pt,t),c(ye,e,t),s(e,rt,t),s(e,de,t),ct=!0},p(e,[t]){const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),f.$set(Et)},i(e){ct||(y(J.$$.fragment,e),y(k.$$.fragment,e),y(x.$$.fragment,e),y(f.$$.fragment,e),y(v.$$.fragment,e),y(Z.$$.fragment,e),y(_.$$.fragment,e),y(G.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(H.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(ye.$$.fragment,e),ct=!0)},o(e){M(J.$$.fragment,e),M(k.$$.fragment,e),M(x.$$.fragment,e),M(f.$$.fragment,e),M(v.$$.fragment,e),M(Z.$$.fragment,e),M(_.$$.fragment,e),M(G.$$.fragment,e),M(V.$$.fragment,e),M(E.$$.fragment,e),M(Y.$$.fragment,e),M(F.$$.fragment,e),M(H.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(ee.$$.fragment,e),M(se.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(ye.$$.fragment,e),ct=!1},d(e){e&&(l(w),l(b),l(Me),l(be),l(j),l(fe),l(T),l(we),l(Je),l(g),l(je),l(Te),l(C),l(ke),l(ge),l(U),l(xe),l(Ce),l(L),l(Ue),l(ve),l(W),l(Le),l(Ze),l($),l(We),l(_e),l(I),l($e),l(R),l(Ge),l(Ie),l(A),l(Re),l(B),l(Ve),l(Ae),l(N),l(Be),l(Ee),l(X),l(Ne),l(Ye),l(S),l(Xe),l(Fe),l(Q),l(Se),l(z),l(He),l(Qe),l(D),l(ze),l(qe),l(K),l(De),l(O),l(Pe),l(Ke),l(te),l(Oe),l(le),l(et),l(tt),l(ne),l(lt),l(ae),l(st),l(oe),l(nt),l(at),l(me),l(ot),l(pe),l(it),l(mt),l(ce),l(pt),l(rt),l(de)),l(u),d(J,e),d(k,e),d(x,e),d(f,e),d(v,e),d(Z,e),d(_,e),d(G,e),d(V,e),d(E,e),d(Y,e),d(F,e),d(H,e),d(q,e),d(P,e),d(ee,e),d(se,e),d(ie,e),d(re,e),d(ye,e)}}}const Ot='{"title":"Custom models","local":"custom-models","sections":[{"title":"Multilayer perceptron","local":"multilayer-perceptron","sections":[],"depth":2},{"title":"timm models","local":"timm-models","sections":[],"depth":2},{"title":"New transformers architectures","local":"new-transformers-architectures","sections":[],"depth":2},{"title":"Verify parameters and layers","local":"verify-parameters-and-layers","sections":[],"depth":2}],"depth":1}';function el(he){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Ht{constructor(u){super(),Qt(this,u,el,Kt,Xt,{})}}export{ol as component};
