import{s as Ue,f as ve,n as Ie,o as Ce}from"../chunks/scheduler.7bc62968.js";import{S as xe,i as Ze,g as i,s as a,r as m,A as Be,h as o,f as s,c as n,j as ge,u as d,x as c,k as Q,y as Ve,a as l,v as u,d as h,t as M,w as b}from"../chunks/index.2f8492b0.js";import{C as $e}from"../chunks/CodeBlock.4e96d6f7.js";import{H as k}from"../chunks/Heading.14fb2476.js";function We(ce){let p,X,H,L,j,N,f,Y,y,pe='Object detection, a critical task in computer vision, has seen significant advancements with models like the YOLO (<a href="https://arxiv.org/abs/1506.02640" rel="nofollow">original paper</a>, <a href="https://github.com/ultralytics/ultralytics" rel="nofollow">latest code version</a>). However, traditional models like YOLO have limitations in detecting objects outside their training datasets. To address this, the AI community has shifted towards developing models that can identify a wider range of objects, leading to the creation of models akin to CLIP but for object detection.',z,T,A,w,me="OWL-ViT represents a leap forward in open-vocabulary object detection. It starts with a training stage similar to CLIP, focusing on a vision and language encoder using a contrastive loss. This foundational stage enables the model to learn a shared representation space for both visual and textual data.",F,J,O,g,de="The innovation in OWL-ViT comes during its fine-tuning stage for object detection. Here, instead of the token pooling and final projection layer used in CLIP, OWL-VIT employs a linear projection of each output token to obtain per-object image embeddings. These embeddings are then used for classification, while box coordinates are derived from token representations through a small MLP. This approach allows OWL-ViT to detect objects and their spatial locations within images, a significant advancement over traditional object detection models.",q,U,ue="Below is a diagram of the Pre-training and Fine-tuning stages of OWL-ViT:",G,v,he='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/owlvit_architecture.jpg" alt="OWL-ViT Pre-training and Fine-tuning"/>',P,I,S,C,Me="After fine-tuning, OWL-ViT excels in open-vocabulary object detection. It can identify objects not explicitly present in the training dataset, thanks to the shared embedding space of the vision and text encoders. This capability makes it possible to use both images and textual queries for object detection, enhancing its versatility.",D,x,K,Z,be="For practical applications, one typically uses text as the query and the image as context. The provided Python example demonstrates how to use the transformers library for running inference with OWL-ViT.",ee,B,te,V,je=`The image should look like this:
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/OWL_ViT_example.jpg" alt="OWL-ViT Example"/>
This example shows a simple use case of OWL-ViT, where we specify objects likely in the dataset like cat and more abstract objects like cat tail which most likely aren’t in any object detection dataset. This shows the powerfulness of OWL-ViT in open-vocabulary object detection.`,se,$,fe="Feel free to use the code to try more complex examples or this Gradio app:",le,r,ye="",Te,ae,W,ne,R,we="OWL-ViT’s approach to object detection represents a notable shift in how AI models understand and interact with the visual world. By integrating language understanding with visual perception, it pushes the boundaries of object detection, enabling more accurate and versatile models capable of identifying a broader range of objects. This evolution in model capabilities is crucial for applications requiring nuanced understanding of visual scenes, particularly in dynamic, real-world environments.",ie,E,Je='For more in-depth information and technical details, refer to the <a href="https://arxiv.org/abs/2205.06230" rel="nofollow">OWL-VIT paper</a>. You can also find information about <a href="https://huggingface.co/docs/transformers/model_doc/owlv2" rel="nofollow">OWL-ViT 2 model</a> in the Hugging face documentation.',oe,_,re;return j=new k({props:{title:"Multimodal Object Detection (OWL-ViT)",local:"multimodal-object-detection-owl-vit",headingTag:"h1"}}),f=new k({props:{title:"Introduction",local:"introduction",headingTag:"h3"}}),T=new k({props:{title:"OWL-ViT: Enhancements and Capabilities",local:"owl-vit-enhancements-and-capabilities",headingTag:"h3"}}),J=new k({props:{title:"Fine-tuning for Object Detection",local:"fine-tuning-for-object-detection",headingTag:"h4"}}),I=new k({props:{title:"Open-Vocabulary Detection",local:"open-vocabulary-detection",headingTag:"h4"}}),x=new k({props:{title:"Example Use Case",local:"example-use-case",headingTag:"h4"}}),B=new $e({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OwlViTProcessor, OwlViTForObjectDetection

processor = OwlViTProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>)
model = OwlViTForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
texts = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>, <span class="hljs-string">&quot;remote control&quot;</span>, <span class="hljs-string">&quot;cat tail&quot;</span>]]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])
results = processor.post_process_object_detection(
    outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>
)
i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
text = texts[i]
boxes, scores, labels = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>], results[i][<span class="hljs-string">&quot;labels&quot;</span>]

<span class="hljs-comment"># Create a draw object</span>
draw = ImageDraw.Draw(image)

<span class="hljs-comment"># Draw each bounding box</span>
<span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text[label]}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
    )
    <span class="hljs-comment"># Draw the bounding box on the image</span>
    draw.rectangle(box, outline=<span class="hljs-string">&quot;red&quot;</span>)

<span class="hljs-comment"># Display the image</span>
image`,wrap:!1}}),W=new k({props:{title:"Conclusion",local:"conclusion",headingTag:"h3"}}),{c(){p=i("meta"),X=a(),H=i("p"),L=a(),m(j.$$.fragment),N=a(),m(f.$$.fragment),Y=a(),y=i("p"),y.innerHTML=pe,z=a(),m(T.$$.fragment),A=a(),w=i("p"),w.textContent=me,F=a(),m(J.$$.fragment),O=a(),g=i("p"),g.textContent=de,q=a(),U=i("p"),U.textContent=ue,G=a(),v=i("p"),v.innerHTML=he,P=a(),m(I.$$.fragment),S=a(),C=i("p"),C.textContent=Me,D=a(),m(x.$$.fragment),K=a(),Z=i("p"),Z.textContent=be,ee=a(),m(B.$$.fragment),te=a(),V=i("p"),V.innerHTML=je,se=a(),$=i("p"),$.textContent=fe,le=a(),r=i("iframe"),r.innerHTML=ye,ae=a(),m(W.$$.fragment),ne=a(),R=i("p"),R.textContent=we,ie=a(),E=i("p"),E.innerHTML=Je,oe=a(),_=i("p"),this.h()},l(e){const t=Be("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(s),X=n(e),H=o(e,"P",{}),ge(H).forEach(s),L=n(e),d(j.$$.fragment,e),N=n(e),d(f.$$.fragment,e),Y=n(e),y=o(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-rcp1v5"&&(y.innerHTML=pe),z=n(e),d(T.$$.fragment,e),A=n(e),w=o(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-z4tskn"&&(w.textContent=me),F=n(e),d(J.$$.fragment,e),O=n(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-v134fy"&&(g.textContent=de),q=n(e),U=o(e,"P",{"data-svelte-h":!0}),c(U)!=="svelte-kfdaj8"&&(U.textContent=ue),G=n(e),v=o(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-yoirbd"&&(v.innerHTML=he),P=n(e),d(I.$$.fragment,e),S=n(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-tptnjo"&&(C.textContent=Me),D=n(e),d(x.$$.fragment,e),K=n(e),Z=o(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-z24mom"&&(Z.textContent=be),ee=n(e),d(B.$$.fragment,e),te=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-85rdgm"&&(V.innerHTML=je),se=n(e),$=o(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-1n8z8mw"&&($.textContent=fe),le=n(e),r=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),c(r)!=="svelte-iir95p"&&(r.innerHTML=ye),ae=n(e),d(W.$$.fragment,e),ne=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-gx5huh"&&(R.textContent=we),ie=n(e),E=o(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1y0r6n7"&&(E.innerHTML=Je),oe=n(e),_=o(e,"P",{}),ge(_).forEach(s),this.h()},h(){Q(p,"name","hf:doc:metadata"),Q(p,"content",Re),ve(r.src,Te="https://johko-OWL-ViT.hf.space")||Q(r,"src",Te),Q(r,"frameborder","0"),Q(r,"width","850"),Q(r,"height","450")},m(e,t){Ve(document.head,p),l(e,X,t),l(e,H,t),l(e,L,t),u(j,e,t),l(e,N,t),u(f,e,t),l(e,Y,t),l(e,y,t),l(e,z,t),u(T,e,t),l(e,A,t),l(e,w,t),l(e,F,t),u(J,e,t),l(e,O,t),l(e,g,t),l(e,q,t),l(e,U,t),l(e,G,t),l(e,v,t),l(e,P,t),u(I,e,t),l(e,S,t),l(e,C,t),l(e,D,t),u(x,e,t),l(e,K,t),l(e,Z,t),l(e,ee,t),u(B,e,t),l(e,te,t),l(e,V,t),l(e,se,t),l(e,$,t),l(e,le,t),l(e,r,t),l(e,ae,t),u(W,e,t),l(e,ne,t),l(e,R,t),l(e,ie,t),l(e,E,t),l(e,oe,t),l(e,_,t),re=!0},p:Ie,i(e){re||(h(j.$$.fragment,e),h(f.$$.fragment,e),h(T.$$.fragment,e),h(J.$$.fragment,e),h(I.$$.fragment,e),h(x.$$.fragment,e),h(B.$$.fragment,e),h(W.$$.fragment,e),re=!0)},o(e){M(j.$$.fragment,e),M(f.$$.fragment,e),M(T.$$.fragment,e),M(J.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),re=!1},d(e){e&&(s(X),s(H),s(L),s(N),s(Y),s(y),s(z),s(A),s(w),s(F),s(O),s(g),s(q),s(U),s(G),s(v),s(P),s(S),s(C),s(D),s(K),s(Z),s(ee),s(te),s(V),s(se),s($),s(le),s(r),s(ae),s(ne),s(R),s(ie),s(E),s(oe),s(_)),s(p),b(j,e),b(f,e),b(T,e),b(J,e),b(I,e),b(x,e),b(B,e),b(W,e)}}}const Re='{"title":"Multimodal Object Detection (OWL-ViT)","local":"multimodal-object-detection-owl-vit","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":3},{"title":"OWL-ViT: Enhancements and Capabilities","local":"owl-vit-enhancements-and-capabilities","sections":[{"title":"Fine-tuning for Object Detection","local":"fine-tuning-for-object-detection","sections":[],"depth":4},{"title":"Open-Vocabulary Detection","local":"open-vocabulary-detection","sections":[],"depth":4},{"title":"Example Use Case","local":"example-use-case","sections":[],"depth":4}],"depth":3},{"title":"Conclusion","local":"conclusion","sections":[],"depth":3}],"depth":1}';function Ee(ce){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends xe{constructor(p){super(),Ze(this,p,Ee,We,Ue,{})}}export{Xe as component};
