import{s as de,n as je,o as Ce}from"../chunks/scheduler.85c25b89.js";import{S as be,i as Ie,g as o,s,r as M,A as ge,h as i,f as l,c as a,j as Ue,u,x as p,k as he,y as ve,a as n,v as r,d as y,t as c,w as f}from"../chunks/index.c9bcf812.js";import{C as ae}from"../chunks/CodeBlock.c004bd26.js";import{H as oe}from"../chunks/getInferenceSnippets.5ea0a804.js";function xe(ie){let m,H,G,Q,T,S,J,pe=`The <code>optimum-neuron</code> package includes a <a href="https://docs.vllm.ai/en/latest/" rel="nofollow">vLLM</a> plugin
that registers an ‘optimum-neuron’ vLLM platform specifically designed to ease the deployment
of models hosted on the Hugging Face hub to AWS Trainium and Inferentia.`,V,w,me="This platform supports two modes of operation:",k,U,Me='<li>it can be used for the inference of pre-exported Neuron models directly from the hub,</li> <li>but it allows also the simplified deployment of vanilla models directly without recompilation using <a href="#hugging-face-neuron-cache">cached artifacts</a>.</li>',E,h,ue="Notes",N,d,re=`<li>only a relevant subset of all possible configurations for a given model are cached,</li> <li>you can use the <code>optimum-cli</code> to get all <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system#neuron-model-cache-lookup-inferentia-only" rel="nofollow">cached configurations</a> for each model.</li> <li>to deploy models that are not cached on the Hugging Face hub, you need to <a href="https://huggingface.co/docs/optimum-neuron/main/en/guides/export_model" rel="nofollow">export</a>
them beforehand.</li>`,z,j,q,C,ye=`The easiest way to use the <code>optimum-neuron</code> vLLM platform is to launch an Amazon ec2 instance using
the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.`,R,b,ce="Note: Trn2 instances are not supported by the <code>optimum-neuron</code> platform yet.",W,I,fe='<li>After launching the instance, follow the instructions in <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AccessingInstancesLinux.html" rel="nofollow">Connect to your instance</a> to connect to the instance</li> <li>Once inside your instance, activate the pre-installed <code>optimum-neuron</code> virtual environment by running</li>',Y,g,F,v,P,x,Te="The easiest way to test a model is to use the python API:",D,B,O,$,K,A,Je="You can also launch an Open AI compatible inference server.",ee,L,te,_,we="Use the following command to test the model:",le,X,ne,Z,se;return T=new oe({props:{title:"optimum-neuron plugin for vLLM",local:"optimum-neuron-plugin-for-vllm",headingTag:"h1"}}),j=new oe({props:{title:"Setup",local:"setup",headingTag:"h2"}}),g=new ae({props:{code:"c291cmNlJTIwJTJGb3B0JTJGYXdzX25ldXJvbnhfdmVudl9weXRvcmNoXzJfNyUyRmJpbiUyRmFjdGl2YXRl",highlighted:"source /opt/aws_neuronx_venv_pytorch_2_7/bin/activate",wrap:!1}}),v=new oe({props:{title:"Offline inference example",local:"offline-inference-example",headingTag:"h2"}}),B=new ae({props:{code:"ZnJvbSUyMHZsbG0lMjBpbXBvcnQlMjBMTE0lMkMlMjBTYW1wbGluZ1BhcmFtcyUwQSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwcHJlc2lkZW50JTIwb2YlMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwZnV0dXJlJTIwb2YlMjBBSSUyMGlzJTIyJTJDJTBBJTVEJTBBc2FtcGxpbmdfcGFyYW1zJTIwJTNEJTIwU2FtcGxpbmdQYXJhbXModGVtcGVyYXR1cmUlM0QwLjglMkMlMjB0b3BfcCUzRDAuOTUpJTBBJTBBbGxtJTIwJTNEJTIwTExNKG1vZGVsJTNEJTIydW5zbG90aCUyRkxsYW1hLTMuMi0xQi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9udW1fc2VxcyUzRDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbW9kZWxfbGVuJTNENDA5NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZSUzRCUyMm5ldXJvbiUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbGxtLmdlbmVyYXRlKHByb21wdHMlMkMlMjBzYW1wbGluZ19wYXJhbXMpJTBBJTBBZm9yJTIwb3V0cHV0JTIwaW4lMjBvdXRwdXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwb3V0cHV0LnByb21wdCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwb3V0cHV0Lm91dHB1dHMlNUIwJTVELnRleHQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJvbXB0JTNBJTIwJTdCcHJvbXB0IXIlN0QlMkMlMjBHZW5lcmF0ZWQlMjB0ZXh0JTNBJTIwJTdCZ2VuZXJhdGVkX3RleHQhciU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> vllm <span class="hljs-keyword">import</span> LLM, SamplingParams

prompts = [
    <span class="hljs-string">&quot;Hello, my name is&quot;</span>,
    <span class="hljs-string">&quot;The president of the United States is&quot;</span>,
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    <span class="hljs-string">&quot;The future of AI is&quot;</span>,
]
sampling_params = SamplingParams(temperature=<span class="hljs-number">0.8</span>, top_p=<span class="hljs-number">0.95</span>)

llm = LLM(model=<span class="hljs-string">&quot;unsloth/Llama-3.2-1B-Instruct&quot;</span>,
          max_num_seqs=<span class="hljs-number">4</span>,
          max_model_len=<span class="hljs-number">4096</span>,
          tensor_parallel_size=<span class="hljs-number">2</span>,
          device=<span class="hljs-string">&quot;neuron&quot;</span>)

outputs = llm.generate(prompts, sampling_params)

<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs:
    prompt = output.prompt
    generated_text = output.outputs[<span class="hljs-number">0</span>].text
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Prompt: <span class="hljs-subst">{prompt!r}</span>, Generated text: <span class="hljs-subst">{generated_text!r}</span>&quot;</span>)`,wrap:!1}}),$=new oe({props:{title:"Online inference example",local:"online-inference-example",headingTag:"h2"}}),L=new ae({props:{code:"cHl0aG9uJTIwLW0lMjB2bGxtLmVudHJ5cG9pbnRzLm9wZW5haS5hcGlfc2VydmVyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbCUzRCUyMnVuc2xvdGglMkZMbGFtYS0zLjItMUItSW5zdHJ1Y3QlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heC1udW0tc2VxcyUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heC1tb2RlbC1sZW4lM0Q0MDk2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10ZW5zb3ItcGFyYWxsZWwtc2l6ZSUzRDIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBvcnQlM0Q4MDgwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kZXZpY2UlMjAlMjJuZXVyb24lMjI=",highlighted:`python -m vllm.entrypoints.openai.api_server \\
    --model=&quot;unsloth/Llama-3.2-1B-Instruct&quot; \\
    --max-num-seqs=4 \\
    --max-model-len=4096 \\
    --tensor-parallel-size=2 \\
    --port=8080 \\
    --device &quot;neuron&quot;`,wrap:!1}}),X=new ae({props:{code:"Y3VybCUyMDEyNy4wLjAuMSUzQTgwODAlMkZ2MSUyRmNvbXBsZXRpb25zJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMnByb21wdCUyMiUzQSUyMk9uZSUyMG9mJTIwbXklMjBmb25kZXN0JTIwbWVtb3J5JTIwaXMlMjIlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDAuOCUyQyUyMCUyMm1heF90b2tlbnMlMjIlM0ExMjglN0Qn",highlighted:`curl 127.0.0.1:8080/v1/completions \\
    -H &#x27;Content-Type: application/json&#x27; \\
    -X POST \\
    -d &#x27;{&quot;prompt&quot;:&quot;One of my fondest memory is&quot;, &quot;temperature&quot;: 0.8, &quot;max_tokens&quot;:128}&#x27;`,wrap:!1}}),{c(){m=o("meta"),H=s(),G=o("p"),Q=s(),M(T.$$.fragment),S=s(),J=o("p"),J.innerHTML=pe,V=s(),w=o("p"),w.textContent=me,k=s(),U=o("ul"),U.innerHTML=Me,E=s(),h=o("p"),h.textContent=ue,N=s(),d=o("ul"),d.innerHTML=re,z=s(),M(j.$$.fragment),q=s(),C=o("p"),C.innerHTML=ye,R=s(),b=o("p"),b.innerHTML=ce,W=s(),I=o("ul"),I.innerHTML=fe,Y=s(),M(g.$$.fragment),F=s(),M(v.$$.fragment),P=s(),x=o("p"),x.textContent=Te,D=s(),M(B.$$.fragment),O=s(),M($.$$.fragment),K=s(),A=o("p"),A.textContent=Je,ee=s(),M(L.$$.fragment),te=s(),_=o("p"),_.textContent=we,le=s(),M(X.$$.fragment),ne=s(),Z=o("p"),this.h()},l(e){const t=ge("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),H=a(e),G=i(e,"P",{}),Ue(G).forEach(l),Q=a(e),u(T.$$.fragment,e),S=a(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-28yqn4"&&(J.innerHTML=pe),V=a(e),w=i(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-z6gb1b"&&(w.textContent=me),k=a(e),U=i(e,"UL",{"data-svelte-h":!0}),p(U)!=="svelte-1y9py5l"&&(U.innerHTML=Me),E=a(e),h=i(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1y2vhyh"&&(h.textContent=ue),N=a(e),d=i(e,"UL",{"data-svelte-h":!0}),p(d)!=="svelte-1isgnu3"&&(d.innerHTML=re),z=a(e),u(j.$$.fragment,e),q=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-vj8im"&&(C.innerHTML=ye),R=a(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-18hhclg"&&(b.innerHTML=ce),W=a(e),I=i(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-140kn6a"&&(I.innerHTML=fe),Y=a(e),u(g.$$.fragment,e),F=a(e),u(v.$$.fragment,e),P=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-12fxvlq"&&(x.textContent=Te),D=a(e),u(B.$$.fragment,e),O=a(e),u($.$$.fragment,e),K=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1nuzwaa"&&(A.textContent=Je),ee=a(e),u(L.$$.fragment,e),te=a(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1fua9k5"&&(_.textContent=we),le=a(e),u(X.$$.fragment,e),ne=a(e),Z=i(e,"P",{}),Ue(Z).forEach(l),this.h()},h(){he(m,"name","hf:doc:metadata"),he(m,"content",Be)},m(e,t){ve(document.head,m),n(e,H,t),n(e,G,t),n(e,Q,t),r(T,e,t),n(e,S,t),n(e,J,t),n(e,V,t),n(e,w,t),n(e,k,t),n(e,U,t),n(e,E,t),n(e,h,t),n(e,N,t),n(e,d,t),n(e,z,t),r(j,e,t),n(e,q,t),n(e,C,t),n(e,R,t),n(e,b,t),n(e,W,t),n(e,I,t),n(e,Y,t),r(g,e,t),n(e,F,t),r(v,e,t),n(e,P,t),n(e,x,t),n(e,D,t),r(B,e,t),n(e,O,t),r($,e,t),n(e,K,t),n(e,A,t),n(e,ee,t),r(L,e,t),n(e,te,t),n(e,_,t),n(e,le,t),r(X,e,t),n(e,ne,t),n(e,Z,t),se=!0},p:je,i(e){se||(y(T.$$.fragment,e),y(j.$$.fragment,e),y(g.$$.fragment,e),y(v.$$.fragment,e),y(B.$$.fragment,e),y($.$$.fragment,e),y(L.$$.fragment,e),y(X.$$.fragment,e),se=!0)},o(e){c(T.$$.fragment,e),c(j.$$.fragment,e),c(g.$$.fragment,e),c(v.$$.fragment,e),c(B.$$.fragment,e),c($.$$.fragment,e),c(L.$$.fragment,e),c(X.$$.fragment,e),se=!1},d(e){e&&(l(H),l(G),l(Q),l(S),l(J),l(V),l(w),l(k),l(U),l(E),l(h),l(N),l(d),l(z),l(q),l(C),l(R),l(b),l(W),l(I),l(Y),l(F),l(P),l(x),l(D),l(O),l(K),l(A),l(ee),l(te),l(_),l(le),l(ne),l(Z)),l(m),f(T,e),f(j,e),f(g,e),f(v,e),f(B,e),f($,e),f(L,e),f(X,e)}}}const Be='{"title":"optimum-neuron plugin for vLLM","local":"optimum-neuron-plugin-for-vllm","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Offline inference example","local":"offline-inference-example","sections":[],"depth":2},{"title":"Online inference example","local":"online-inference-example","sections":[],"depth":2}],"depth":1}';function $e(ie){return Ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ge extends be{constructor(m){super(),Ie(this,m,$e,xe,de,{})}}export{Ge as component};
