import{s as Ce,n as ve,o as We}from"../chunks/scheduler.85c25b89.js";import{S as Ze,i as $e,g as o,s,r as i,A as Ge,h as r,f as l,c as a,j as ce,u as p,x as y,k as Me,y as ye,a as n,v as m,d as u,t as c,w as M}from"../chunks/index.c9bcf812.js";import{D as Xe}from"../chunks/Docstring.e86a2d02.js";import{C as de}from"../chunks/CodeBlock.c004bd26.js";import{H as S}from"../chunks/getInferenceSnippets.5ea0a804.js";function Ve(he){let d,E,q,z,h,Q,b,R,_,be='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',F,g,_e="In <code>optimum-neuron</code>, you can:",H,j,ge="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",Y,w,je='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',D,J,A,T,P,N,K,U,O,X,ee,C,te,v,we="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",le,W,Je="<li>LCM of Stable Diffusion</li>",ne,Z,se,$,Te="<li>LCM of Stable Diffusion XL</li>",ae,G,oe,V,ie,f,I,fe,x,L,re,B,Ne='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',pe,k,me;return h=new S({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h1"}}),b=new S({props:{title:"Overview",local:"overview",headingTag:"h2"}}),J=new S({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),T=new S({props:{title:"LCM of Stable Diffusion",local:"lcm-of-stable-diffusion",headingTag:"h3"}}),N=new de({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyKSUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMHJlcG8lMjBpZCUyQyUyMGVnLiUyMCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIy",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>)  <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>`,wrap:!1}}),U=new S({props:{title:"LCM of Stable Diffusion XL",local:"lcm-of-stable-diffusion-xl",headingTag:"h3"}}),X=new de({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIpJTIwJTIwJTIwJTIzJTIwUmVwbGFjZSUyMHdpdGglMjB5b3VyJTIwcmVwbyUyMGlkJTJDJTIwZWcuJTIwJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMg==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>)   <span class="hljs-comment"># Replace with your repo id, eg. &quot;Jingya/lcm-sdxl-neuronx&quot;</span>`,wrap:!1}}),C=new S({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h2"}}),Z=new de({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),G=new de({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),V=new S({props:{title:"NeuronLatentConsistencyModelPipeline",local:"optimum.neuron.NeuronLatentConsistencyModelPipeline",headingTag:"h2"}}),I=new Xe({props:{name:"class optimum.neuron.NeuronLatentConsistencyModelPipeline",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.3.0/optimum/neuron/modeling_diffusion.py#L1539"}}),L=new Xe({props:{name:"__call__",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.3.0/optimum/neuron/modeling_diffusion.py#L1084"}}),{c(){d=o("meta"),E=s(),q=o("p"),z=s(),i(h.$$.fragment),Q=s(),i(b.$$.fragment),R=s(),_=o("p"),_.innerHTML=be,F=s(),g=o("p"),g.innerHTML=_e,H=s(),j=o("ul"),j.innerHTML=ge,Y=s(),w=o("p"),w.innerHTML=je,D=s(),i(J.$$.fragment),A=s(),i(T.$$.fragment),P=s(),i(N.$$.fragment),K=s(),i(U.$$.fragment),O=s(),i(X.$$.fragment),ee=s(),i(C.$$.fragment),te=s(),v=o("p"),v.textContent=we,le=s(),W=o("ul"),W.innerHTML=Je,ne=s(),i(Z.$$.fragment),se=s(),$=o("ul"),$.innerHTML=Te,ae=s(),i(G.$$.fragment),oe=s(),i(V.$$.fragment),ie=s(),f=o("div"),i(I.$$.fragment),fe=s(),x=o("div"),i(L.$$.fragment),re=s(),B=o("p"),B.innerHTML=Ne,pe=s(),k=o("p"),this.h()},l(e){const t=Ge("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(l),E=a(e),q=r(e,"P",{}),ce(q).forEach(l),z=a(e),p(h.$$.fragment,e),Q=a(e),p(b.$$.fragment,e),R=a(e),_=r(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1ud6a8q"&&(_.innerHTML=be),F=a(e),g=r(e,"P",{"data-svelte-h":!0}),y(g)!=="svelte-1ayizu6"&&(g.innerHTML=_e),H=a(e),j=r(e,"UL",{"data-svelte-h":!0}),y(j)!=="svelte-r4tdj0"&&(j.innerHTML=ge),Y=a(e),w=r(e,"P",{"data-svelte-h":!0}),y(w)!=="svelte-c4lhmw"&&(w.innerHTML=je),D=a(e),p(J.$$.fragment,e),A=a(e),p(T.$$.fragment,e),P=a(e),p(N.$$.fragment,e),K=a(e),p(U.$$.fragment,e),O=a(e),p(X.$$.fragment,e),ee=a(e),p(C.$$.fragment,e),te=a(e),v=r(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1ebkvay"&&(v.textContent=we),le=a(e),W=r(e,"UL",{"data-svelte-h":!0}),y(W)!=="svelte-ffz5jy"&&(W.innerHTML=Je),ne=a(e),p(Z.$$.fragment,e),se=a(e),$=r(e,"UL",{"data-svelte-h":!0}),y($)!=="svelte-8q369c"&&($.innerHTML=Te),ae=a(e),p(G.$$.fragment,e),oe=a(e),p(V.$$.fragment,e),ie=a(e),f=r(e,"DIV",{class:!0});var ue=ce(f);p(I.$$.fragment,ue),fe=a(ue),x=r(ue,"DIV",{class:!0});var Ue=ce(x);p(L.$$.fragment,Ue),Ue.forEach(l),ue.forEach(l),re=a(e),B=r(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1wos5lv"&&(B.innerHTML=Ne),pe=a(e),k=r(e,"P",{}),ce(k).forEach(l),this.h()},h(){Me(d,"name","hf:doc:metadata"),Me(d,"content",Ie),Me(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Me(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){ye(document.head,d),n(e,E,t),n(e,q,t),n(e,z,t),m(h,e,t),n(e,Q,t),m(b,e,t),n(e,R,t),n(e,_,t),n(e,F,t),n(e,g,t),n(e,H,t),n(e,j,t),n(e,Y,t),n(e,w,t),n(e,D,t),m(J,e,t),n(e,A,t),m(T,e,t),n(e,P,t),m(N,e,t),n(e,K,t),m(U,e,t),n(e,O,t),m(X,e,t),n(e,ee,t),m(C,e,t),n(e,te,t),n(e,v,t),n(e,le,t),n(e,W,t),n(e,ne,t),m(Z,e,t),n(e,se,t),n(e,$,t),n(e,ae,t),m(G,e,t),n(e,oe,t),m(V,e,t),n(e,ie,t),n(e,f,t),m(I,f,null),ye(f,fe),ye(f,x),m(L,x,null),n(e,re,t),n(e,B,t),n(e,pe,t),n(e,k,t),me=!0},p:ve,i(e){me||(u(h.$$.fragment,e),u(b.$$.fragment,e),u(J.$$.fragment,e),u(T.$$.fragment,e),u(N.$$.fragment,e),u(U.$$.fragment,e),u(X.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(I.$$.fragment,e),u(L.$$.fragment,e),me=!0)},o(e){c(h.$$.fragment,e),c(b.$$.fragment,e),c(J.$$.fragment,e),c(T.$$.fragment,e),c(N.$$.fragment,e),c(U.$$.fragment,e),c(X.$$.fragment,e),c(C.$$.fragment,e),c(Z.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(I.$$.fragment,e),c(L.$$.fragment,e),me=!1},d(e){e&&(l(E),l(q),l(z),l(Q),l(R),l(_),l(F),l(g),l(H),l(j),l(Y),l(w),l(D),l(A),l(P),l(K),l(O),l(ee),l(te),l(v),l(le),l(W),l(ne),l(se),l($),l(ae),l(oe),l(ie),l(f),l(re),l(B),l(pe),l(k)),l(d),M(h,e),M(b,e),M(J,e),M(T,e),M(N,e),M(U,e),M(X,e),M(C,e),M(Z,e),M(G,e),M(V,e),M(I),M(L)}}}const Ie='{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Export to Neuron","local":"export-to-neuron","sections":[{"title":"LCM of Stable Diffusion","local":"lcm-of-stable-diffusion","sections":[],"depth":3},{"title":"LCM of Stable Diffusion XL","local":"lcm-of-stable-diffusion-xl","sections":[],"depth":3}],"depth":2},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":2},{"title":"NeuronLatentConsistencyModelPipeline","local":"optimum.neuron.NeuronLatentConsistencyModelPipeline","sections":[],"depth":2}],"depth":1}';function Le(he){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends Ze{constructor(d){super(),$e(this,d,Le,Ve,Ce,{})}}export{Ee as component};
