import{s as Ce,n as me,o as he}from"../chunks/scheduler.f6319a2a.js";import{S as ue,i as be,g as M,s as n,r as w,A as Ie,h as y,f as t,c as a,j as Te,u as p,x as o,k as de,y as ge,a as s,v as i,d as U,t as r,w as c}from"../chunks/index.85aa684c.js";import{C as j}from"../chunks/CodeBlock.97b48fd2.js";import{D as fe}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as Nl,E as Be}from"../chunks/EditOnGithub.006048dd.js";function Ae(Fl){let J,nl,tl,al,T,Ml,d,yl,C,zl="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",ol,m,ql="It will be a simple hierarchy, using a <code>ManagedAgent</code> object to wrap the managed web search agent:",wl,h,pl,u,Dl="Let’s set up this system.",il,b,Pl="Run the line below to install the required dependencies:",Ul,I,rl,g,Kl="Let’s login in order to call the HF Inference API:",cl,f,jl,B,Ol='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a> using <code>HfApiModel</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',Jl,A,le='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',Tl,k,dl,Z,Cl,G,ee='For web browsing, we can already use our pre-existing <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/default_tools.py#L151-L176" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> tool to provide a Google search equivalent.',ml,S,te=`But then we will also need to be able to peak into the page found by the <code>DuckDuckGoSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,hl,W,se="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",ul,v,bl,$,ne="Ok, now let’s initialize and test our tool!",Il,V,gl,E,fl,Q,ae="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Bl,_,Me="Which configuration to choose for this agent?",Al,H,ye="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>JsonAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_steps</code> to 10.</li>",kl,L,Zl,R,oe="We then wrap this agent into a <code>ManagedAgent</code> that will make it callable by its manager agent.",Gl,x,Sl,X,we="Finally we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",Wl,Y,pe="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>CodeAgent</code> will be the best choice.",vl,N,ie="Also, we want to ask a question that involves the current year and does additional data calculations: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;numpy&quot;, &quot;pandas&quot;]</code>, just in case the agent needs these packages.",$l,F,Vl,z,Ue="That’s all! Now let’s run our system! We select a question that requires both some calculation and research:",El,q,Ql,D,re="We get this report as the answer:",_l,P,Hl,K,ce='Seems like we’ll need some sizeable powerplants if the <a href="https://gwern.net/scaling-hypothesis" rel="nofollow">scaling hypothesis</a> continues to hold true.',Ll,O,je="Our agents managed to efficiently collaborate towards solving the task! ✅",Rl,ll,Je="💡 You can easily extend this orchestration to more agents: one does the code execution, one the web search, one handles file loadings…",xl,el,Xl,sl,Yl;return T=new Nl({props:{title:"Orchestrate a multi-agent system 🤖🤝🤖",local:"orchestrate-a-multi-agent-system-",headingTag:"h1"}}),d=new fe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/multiagents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/multiagents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/multiagents.ipynb"}]}}),h=new j({props:{code:"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",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  Code interpreter   +--------------------------------+
       tool          |<span class="hljs-string">         Managed agent          </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> Web Search agent </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  Web Search tool     </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             Visit webpage tool </span>|
                     +--------------------------------+`,wrap:!1}}),I=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:'!pip install markdownify duckduckgo-search smolagents <span class="hljs-attr">--upgrade</span> -<span class="hljs-selector-tag">q</span>',wrap:!1}}),f=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> <span class="hljs-keyword">login</span>

<span class="hljs-keyword">login</span>()`,wrap:!1}}),k=new j({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>',wrap:!1}}),Z=new Nl({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h2"}}),v=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = markdownify(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),V=new j({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),E=new Nl({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),L=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29kZUFnZW50JTJDJTBBJTIwJTIwJTIwJTIwVG9vbENhbGxpbmdBZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEhmQXBpTW9kZWwlMkMlMEElMjAlMjAlMjAlMjBNYW5hZ2VkQWdlbnQlMkMlMEElMjAlMjAlMjAlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUwQSUyMCUyMCUyMCUyMExpdGVMTE1Nb2RlbCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwobW9kZWxfaWQpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjB2aXNpdF93ZWJwYWdlJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRDEwJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> (
    CodeAgent,
    ToolCallingAgent,
    HfApiModel,
    ManagedAgent,
    DuckDuckGoSearchTool,
    LiteLLMModel,
)

model = HfApiModel(model_id)

web_agent = ToolCallingAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    model=model,
    max_steps=<span class="hljs-number">10</span>,
)`,wrap:!1}}),x=new j({props:{code:"bWFuYWdlZF93ZWJfYWdlbnQlMjAlM0QlMjBNYW5hZ2VkQWdlbnQoJTBBJTIwJTIwJTIwJTIwYWdlbnQlM0R3ZWJfYWdlbnQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),F=new j({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1Qm1hbmFnZWRfd2ViX2FnZW50JTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJ0aW1lJTIyJTJDJTIwJTIybnVtcHklMjIlMkMlMjAlMjJwYW5kYXMlMjIlNUQlMkMlMEEp",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[managed_web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;numpy&quot;</span>, <span class="hljs-string">&quot;pandas&quot;</span>],
)`,wrap:!1}}),q=new j({props:{code:"YW5zd2VyJTIwJTNEJTIwbWFuYWdlcl9hZ2VudC5ydW4oJTIySWYlMjBMTE0lMjB0cmFpbmluZyUyMGNvbnRpbnVlcyUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUyQyUyMHdoYXQlMjB3b3VsZCUyMGJlJTIwdGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMGluJTIwR1clMjByZXF1aXJlZCUyMHRvJTIwcG93ZXIlMjB0aGUlMjBiaWdnZXN0JTIwdHJhaW5pbmclMjBydW5zJTIwYnklMjAyMDMwJTNGJTIwV2hhdCUyMHdvdWxkJTIwdGhhdCUyMGNvcnJlc3BvbmQlMjB0byUyQyUyMGNvbXBhcmVkJTIwdG8lMjBzb21lJTIwY291bnRyaWVzJTNGJTIwUGxlYXNlJTIwcHJvdmlkZSUyMGElMjBzb3VyY2UlMjBmb3IlMjBhbnklMjBudW1iZXJzJTIwdXNlZC4lMjIp",highlighted:'answer = manager_agent.run(<span class="hljs-string">&quot;If LLM training continues to scale up at the current rhythm until 2030, what would be the electric power in GW required to power the biggest training runs by 2030? What would that correspond to, compared to some countries? Please provide a source for any numbers used.&quot;</span>)',wrap:!1}}),P=new j({props:{code:"QmFzZWQlMjBvbiUyMGN1cnJlbnQlMjBncm93dGglMjBwcm9qZWN0aW9ucyUyMGFuZCUyMGVuZXJneSUyMGNvbnN1bXB0aW9uJTIwZXN0aW1hdGVzJTJDJTIwaWYlMjBMTE0lMjB0cmFpbmluZ3MlMjBjb250aW51ZSUyMHRvJTIwc2NhbGUlMjB1cCUyMGF0JTIwdGhlJTIwJTBBY3VycmVudCUyMHJoeXRobSUyMHVudGlsJTIwMjAzMCUzQSUwQSUwQTEuJTIwVGhlJTIwZWxlY3RyaWMlMjBwb3dlciUyMHJlcXVpcmVkJTIwdG8lMjBwb3dlciUyMHRoZSUyMGJpZ2dlc3QlMjB0cmFpbmluZyUyMHJ1bnMlMjBieSUyMDIwMzAlMjB3b3VsZCUyMGJlJTIwYXBwcm94aW1hdGVseSUyMDMwMy43NCUyMEdXJTJDJTIwd2hpY2glMjAlMEF0cmFuc2xhdGVzJTIwdG8lMjBhYm91dCUyMDIlMkM2NjAlMkM3NjIlMjBHV2glMkZ5ZWFyLiUwQSUwQTIuJTIwQ29tcGFyaW5nJTIwdGhpcyUyMHRvJTIwY291bnRyaWVzJyUyMGVsZWN0cmljaXR5JTIwY29uc3VtcHRpb24lM0ElMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwZXF1aXZhbGVudCUyMHRvJTIwYWJvdXQlMjAzNCUyNSUyMG9mJTIwQ2hpbmEncyUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbi4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGV4Y2VlZCUyMHRoZSUyMHRvdGFsJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwSW5kaWElMjAoMTg0JTI1KSUyQyUyMFJ1c3NpYSUyMCgyNjclMjUpJTJDJTIwYW5kJTIwSmFwYW4lMjAoMjkxJTI1KS4lMEElMjAlMjAlMjAtJTIwSXQlMjB3b3VsZCUyMGJlJTIwbmVhcmx5JTIwOSUyMHRpbWVzJTIwdGhlJTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMG9mJTIwY291bnRyaWVzJTIwbGlrZSUyMEl0YWx5JTIwb3IlMjBNZXhpY28uJTBBJTBBMy4lMjBTb3VyY2UlMjBvZiUyMG51bWJlcnMlM0ElMEElMjAlMjAlMjAtJTIwVGhlJTIwaW5pdGlhbCUyMGVzdGltYXRlJTIwb2YlMjA1JTIwR1clMjBmb3IlMjBmdXR1cmUlMjBMTE0lMjB0cmFpbmluZyUyMGNvbWVzJTIwZnJvbSUyMEFXUyUyMENFTyUyME1hdHQlMjBHYXJtYW4uJTBBJTIwJTIwJTIwLSUyMFRoZSUyMGdyb3d0aCUyMHByb2plY3Rpb24lMjB1c2VkJTIwYSUyMENBR1IlMjBvZiUyMDc5LjgwJTI1JTIwZnJvbSUyMG1hcmtldCUyMHJlc2VhcmNoJTIwYnklMjBTcHJpbmdzLiUwQSUyMCUyMCUyMC0lMjBDb3VudHJ5JTIwZWxlY3RyaWNpdHklMjBjb25zdW1wdGlvbiUyMGRhdGElMjBpcyUyMGZyb20lMjB0aGUlMjBVLlMuJTIwRW5lcmd5JTIwSW5mb3JtYXRpb24lMjBBZG1pbmlzdHJhdGlvbiUyQyUyMHByaW1hcmlseSUyMGZvciUyMHRoZSUyMHllYXIlMjAlMEEyMDIxLg==",highlighted:`Based <span class="hljs-keyword">on</span> current growth projections <span class="hljs-keyword">and</span> energy consumption estimates, <span class="hljs-keyword">if</span> LLM trainings <span class="hljs-keyword">continue</span> <span class="hljs-keyword">to</span> scale up <span class="hljs-keyword">at</span> <span class="hljs-keyword">the</span> 
current rhythm <span class="hljs-keyword">until</span> <span class="hljs-number">2030</span>:

<span class="hljs-number">1.</span> The electric power required <span class="hljs-keyword">to</span> power <span class="hljs-keyword">the</span> biggest training runs <span class="hljs-keyword">by</span> <span class="hljs-number">2030</span> would be approximately <span class="hljs-number">303.74</span> GW, which 
translates <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">2</span>,<span class="hljs-number">660</span>,<span class="hljs-number">762</span> GWh/<span class="hljs-built_in">year</span>.

<span class="hljs-number">2.</span> Comparing this <span class="hljs-keyword">to</span> countries&#x27; electricity consumption:
   - It would be equivalent <span class="hljs-keyword">to</span> <span class="hljs-keyword">about</span> <span class="hljs-number">34</span>% <span class="hljs-keyword">of</span> China&#x27;s total electricity consumption.
   - It would exceed <span class="hljs-keyword">the</span> total electricity consumption <span class="hljs-keyword">of</span> India (<span class="hljs-number">184</span>%), Russia (<span class="hljs-number">267</span>%), <span class="hljs-keyword">and</span> Japan (<span class="hljs-number">291</span>%).
   - It would be nearly <span class="hljs-number">9</span> <span class="hljs-keyword">times</span> <span class="hljs-keyword">the</span> electricity consumption <span class="hljs-keyword">of</span> countries like Italy <span class="hljs-keyword">or</span> Mexico.

<span class="hljs-number">3.</span> Source <span class="hljs-keyword">of</span> numbers:
   - The initial estimate <span class="hljs-keyword">of</span> <span class="hljs-number">5</span> GW <span class="hljs-keyword">for</span> future LLM training comes <span class="hljs-keyword">from</span> AWS CEO Matt Garman.
   - The growth projection used a CAGR <span class="hljs-keyword">of</span> <span class="hljs-number">79.80</span>% <span class="hljs-keyword">from</span> market research <span class="hljs-keyword">by</span> Springs.
   - Country electricity consumption data <span class="hljs-keyword">is</span> <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> U.S. Energy Information Administration, primarily <span class="hljs-keyword">for</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span> 
<span class="hljs-number">2021.</span>`,wrap:!1}}),el=new Be({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/multiagents.md"}}),{c(){J=M("meta"),nl=n(),tl=M("p"),al=n(),w(T.$$.fragment),Ml=n(),w(d.$$.fragment),yl=n(),C=M("p"),C.innerHTML=zl,ol=n(),m=M("p"),m.innerHTML=ql,wl=n(),w(h.$$.fragment),pl=n(),u=M("p"),u.textContent=Dl,il=n(),b=M("p"),b.textContent=Pl,Ul=n(),w(I.$$.fragment),rl=n(),g=M("p"),g.textContent=Kl,cl=n(),w(f.$$.fragment),jl=n(),B=M("p"),B.innerHTML=Ol,Jl=n(),A=M("p"),A.innerHTML=le,Tl=n(),w(k.$$.fragment),dl=n(),w(Z.$$.fragment),Cl=n(),G=M("p"),G.innerHTML=ee,ml=n(),S=M("p"),S.innerHTML=te,hl=n(),W=M("p"),W.innerHTML=se,ul=n(),w(v.$$.fragment),bl=n(),$=M("p"),$.textContent=ne,Il=n(),w(V.$$.fragment),gl=n(),w(E.$$.fragment),fl=n(),Q=M("p"),Q.innerHTML=ae,Bl=n(),_=M("p"),_.textContent=Me,Al=n(),H=M("ul"),H.innerHTML=ye,kl=n(),w(L.$$.fragment),Zl=n(),R=M("p"),R.innerHTML=oe,Gl=n(),w(x.$$.fragment),Sl=n(),X=M("p"),X.innerHTML=we,Wl=n(),Y=M("p"),Y.innerHTML=pe,vl=n(),N=M("p"),N.innerHTML=ie,$l=n(),w(F.$$.fragment),Vl=n(),z=M("p"),z.textContent=Ue,El=n(),w(q.$$.fragment),Ql=n(),D=M("p"),D.textContent=re,_l=n(),w(P.$$.fragment),Hl=n(),K=M("p"),K.innerHTML=ce,Ll=n(),O=M("p"),O.textContent=je,Rl=n(),ll=M("p"),ll.textContent=Je,xl=n(),w(el.$$.fragment),Xl=n(),sl=M("p"),this.h()},l(l){const e=Ie("svelte-u9bgzb",document.head);J=y(e,"META",{name:!0,content:!0}),e.forEach(t),nl=a(l),tl=y(l,"P",{}),Te(tl).forEach(t),al=a(l),p(T.$$.fragment,l),Ml=a(l),p(d.$$.fragment,l),yl=a(l),C=y(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-45abwn"&&(C.innerHTML=zl),ol=a(l),m=y(l,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1se9mth"&&(m.innerHTML=ql),wl=a(l),p(h.$$.fragment,l),pl=a(l),u=y(l,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1occiln"&&(u.textContent=Dl),il=a(l),b=y(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-ofrdjq"&&(b.textContent=Pl),Ul=a(l),p(I.$$.fragment,l),rl=a(l),g=y(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-64fox6"&&(g.textContent=Kl),cl=a(l),p(f.$$.fragment,l),jl=a(l),B=y(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-yyluul"&&(B.innerHTML=Ol),Jl=a(l),A=y(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1faawbb"&&(A.innerHTML=le),Tl=a(l),p(k.$$.fragment,l),dl=a(l),p(Z.$$.fragment,l),Cl=a(l),G=y(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ul1u0f"&&(G.innerHTML=ee),ml=a(l),S=y(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-n7spa8"&&(S.innerHTML=te),hl=a(l),W=y(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ms2uj2"&&(W.innerHTML=se),ul=a(l),p(v.$$.fragment,l),bl=a(l),$=y(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-hbvg5t"&&($.textContent=ne),Il=a(l),p(V.$$.fragment,l),gl=a(l),p(E.$$.fragment,l),fl=a(l),Q=y(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-5768lo"&&(Q.innerHTML=ae),Bl=a(l),_=y(l,"P",{"data-svelte-h":!0}),o(_)!=="svelte-noa5rw"&&(_.textContent=Me),Al=a(l),H=y(l,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-m9bmll"&&(H.innerHTML=ye),kl=a(l),p(L.$$.fragment,l),Zl=a(l),R=y(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1by3x3d"&&(R.innerHTML=oe),Gl=a(l),p(x.$$.fragment,l),Sl=a(l),X=y(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-12kldg5"&&(X.innerHTML=we),Wl=a(l),Y=y(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1btrnf1"&&(Y.innerHTML=pe),vl=a(l),N=y(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1ezr7oa"&&(N.innerHTML=ie),$l=a(l),p(F.$$.fragment,l),Vl=a(l),z=y(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-90lagx"&&(z.textContent=Ue),El=a(l),p(q.$$.fragment,l),Ql=a(l),D=y(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-tvhx1x"&&(D.textContent=re),_l=a(l),p(P.$$.fragment,l),Hl=a(l),K=y(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-19s7crl"&&(K.innerHTML=ce),Ll=a(l),O=y(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-ollz3q"&&(O.textContent=je),Rl=a(l),ll=y(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-rvy62f"&&(ll.textContent=Je),xl=a(l),p(el.$$.fragment,l),Xl=a(l),sl=y(l,"P",{}),Te(sl).forEach(t),this.h()},h(){de(J,"name","hf:doc:metadata"),de(J,"content",ke)},m(l,e){ge(document.head,J),s(l,nl,e),s(l,tl,e),s(l,al,e),i(T,l,e),s(l,Ml,e),i(d,l,e),s(l,yl,e),s(l,C,e),s(l,ol,e),s(l,m,e),s(l,wl,e),i(h,l,e),s(l,pl,e),s(l,u,e),s(l,il,e),s(l,b,e),s(l,Ul,e),i(I,l,e),s(l,rl,e),s(l,g,e),s(l,cl,e),i(f,l,e),s(l,jl,e),s(l,B,e),s(l,Jl,e),s(l,A,e),s(l,Tl,e),i(k,l,e),s(l,dl,e),i(Z,l,e),s(l,Cl,e),s(l,G,e),s(l,ml,e),s(l,S,e),s(l,hl,e),s(l,W,e),s(l,ul,e),i(v,l,e),s(l,bl,e),s(l,$,e),s(l,Il,e),i(V,l,e),s(l,gl,e),i(E,l,e),s(l,fl,e),s(l,Q,e),s(l,Bl,e),s(l,_,e),s(l,Al,e),s(l,H,e),s(l,kl,e),i(L,l,e),s(l,Zl,e),s(l,R,e),s(l,Gl,e),i(x,l,e),s(l,Sl,e),s(l,X,e),s(l,Wl,e),s(l,Y,e),s(l,vl,e),s(l,N,e),s(l,$l,e),i(F,l,e),s(l,Vl,e),s(l,z,e),s(l,El,e),i(q,l,e),s(l,Ql,e),s(l,D,e),s(l,_l,e),i(P,l,e),s(l,Hl,e),s(l,K,e),s(l,Ll,e),s(l,O,e),s(l,Rl,e),s(l,ll,e),s(l,xl,e),i(el,l,e),s(l,Xl,e),s(l,sl,e),Yl=!0},p:me,i(l){Yl||(U(T.$$.fragment,l),U(d.$$.fragment,l),U(h.$$.fragment,l),U(I.$$.fragment,l),U(f.$$.fragment,l),U(k.$$.fragment,l),U(Z.$$.fragment,l),U(v.$$.fragment,l),U(V.$$.fragment,l),U(E.$$.fragment,l),U(L.$$.fragment,l),U(x.$$.fragment,l),U(F.$$.fragment,l),U(q.$$.fragment,l),U(P.$$.fragment,l),U(el.$$.fragment,l),Yl=!0)},o(l){r(T.$$.fragment,l),r(d.$$.fragment,l),r(h.$$.fragment,l),r(I.$$.fragment,l),r(f.$$.fragment,l),r(k.$$.fragment,l),r(Z.$$.fragment,l),r(v.$$.fragment,l),r(V.$$.fragment,l),r(E.$$.fragment,l),r(L.$$.fragment,l),r(x.$$.fragment,l),r(F.$$.fragment,l),r(q.$$.fragment,l),r(P.$$.fragment,l),r(el.$$.fragment,l),Yl=!1},d(l){l&&(t(nl),t(tl),t(al),t(Ml),t(yl),t(C),t(ol),t(m),t(wl),t(pl),t(u),t(il),t(b),t(Ul),t(rl),t(g),t(cl),t(jl),t(B),t(Jl),t(A),t(Tl),t(dl),t(Cl),t(G),t(ml),t(S),t(hl),t(W),t(ul),t(bl),t($),t(Il),t(gl),t(fl),t(Q),t(Bl),t(_),t(Al),t(H),t(kl),t(Zl),t(R),t(Gl),t(Sl),t(X),t(Wl),t(Y),t(vl),t(N),t($l),t(Vl),t(z),t(El),t(Ql),t(D),t(_l),t(Hl),t(K),t(Ll),t(O),t(Rl),t(ll),t(xl),t(Xl),t(sl)),t(J),c(T,l),c(d,l),c(h,l),c(I,l),c(f,l),c(k,l),c(Z,l),c(v,l),c(V,l),c(E,l),c(L,l),c(x,l),c(F,l),c(q,l),c(P,l),c(el,l)}}}const ke='{"title":"Orchestrate a multi-agent system 🤖🤝🤖","local":"orchestrate-a-multi-agent-system-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":2},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Ze(Fl){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends ue{constructor(J){super(),be(this,J,Ze,Ae,Ce,{})}}export{Ve as component};
