import{s as Fe,n as Ie,o as Se}from"../chunks/scheduler.182ea377.js";import{S as Ce,i as Ve,g as n,s as a,r as p,A as He,h as o,f as l,c as i,j as Re,u as m,x as r,k as Je,y as Qe,a as s,v as u,d as c,t as d,w as f}from"../chunks/index.abf12888.js";import{C as H}from"../chunks/CodeBlock.57fe6e13.js";import{D as Ne}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as L}from"../chunks/Heading.16916d63.js";function Le(Ue){let b,E,Q,q,y,z,M,D,w,Ze=`SDXL Turbo is an adversarial time-distilled <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) model capable
of running inference in as little as 1 step.`,A,J,Te="This guide will show you how to use SDXL-Turbo for text-to-image and image-to-image.",P,U,je="Before you begin, make sure you have the following libraries installed:",K,Z,O,T,ee,j,We='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',te,W,le,G,Ge='You can also use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally. For this loading method, you need to set <code>timestep_spacing=&quot;trailing&quot;</code> (feel free to experiment with the other scheduler config values to get better results):',se,$,ae,v,ie,k,$e="For text-to-image, pass a text prompt. By default, SDXL Turbo generates a 512x512 image, and that resolution gives the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 1024x1024, but you should expect quality degradations when doing so.",ne,_,ve=`Make sure to set <code>guidance_scale</code> to 0.0 to disable, as the model was trained without it. A single inference step is enough to generate high quality images.
Increasing the number of steps to 2, 3 or 4 should improve image quality.`,oe,x,pe,g,ke='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-text2img.png" alt="generated image of a racoon in a robe"/>',me,B,re,X,_e=`For image-to-image generation, make sure that <code>num_inference_steps * strength</code> is larger or equal to 1.
The image-to-image pipeline will run for <code>int(num_inference_steps * strength)</code> steps, e.g. <code>0.5 * 2.0 = 1</code> step in
our example below.`,ue,Y,ce,h,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-img2img.png" alt="Image-to-image generation sample using SDXL Turbo"/>',de,R,fe,F,Be="<li>Compile the UNet if you are using PyTorch version 2.0 or higher. The first inference run will be very slow, but subsequent ones will be much faster.</li>",be,I,ge,S,Xe="<li>When using the default VAE, keep it in <code>float32</code> to avoid costly <code>dtype</code> conversions before and after each generation. You only need to do this one before your first generation:</li>",he,C,ye,V,Ye='As an alternative, you can also use a <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">16-bit VAE</a> created by community member <a href="https://huggingface.co/madebyollin" rel="nofollow"><code>@madebyollin</code></a> that does not need to be upcasted to <code>float32</code>.',Me,N,we;return y=new L({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h1"}}),M=new Ne({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"}]}}),Z=new H({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),T=new L({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),W=new H({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),$=new H({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTJGYmxvYiUyRm1haW4lMkZzZF94bF90dXJib18xLjBfZnAxNi5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIydHJhaWxpbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, EulerAncestralDiscreteScheduler
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sdxl-turbo/blob/main/sd_xl_turbo_1.0_fp16.safetensors&quot;</span>,
    torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>)`,wrap:!1}}),v=new L({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),x=new H({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZV90ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjaW5lbWF0aWMlMjBzaG90JTIwb2YlMjBhJTIwYmFieSUyMHJhY29vbiUyMHdlYXJpbmclMjBhbiUyMGludHJpY2F0ZSUyMGl0YWxpYW4lMjBwcmllc3QlMjByb2JlLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline_text2image = pipeline_text2image.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cinematic shot of a baby racoon wearing an intricate italian priest robe.&quot;</span>

image = pipeline_text2image(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),B=new L({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),Y=new H({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZV9pbWFnZTJpbWFnZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhdC5wbmclMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lX2ltYWdlMmltYWdlKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC41JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline_image2image = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

image = pipeline_image2image(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">2</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),R=new L({props:{title:"Speed-up SDXL Turbo even more",local:"speed-up-sdxl-turbo-even-more",headingTag:"h2"}}),I=new H({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:'pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),C=new H({props:{code:"cGlwZS51cGNhc3RfdmFlKCk=",highlighted:"pipe.upcast_vae()",wrap:!1}}),{c(){b=n("meta"),E=a(),Q=n("p"),q=a(),p(y.$$.fragment),z=a(),p(M.$$.fragment),D=a(),w=n("p"),w.innerHTML=Ze,A=a(),J=n("p"),J.textContent=Te,P=a(),U=n("p"),U.textContent=je,K=a(),p(Z.$$.fragment),O=a(),p(T.$$.fragment),ee=a(),j=n("p"),j.innerHTML=We,te=a(),p(W.$$.fragment),le=a(),G=n("p"),G.innerHTML=Ge,se=a(),p($.$$.fragment),ae=a(),p(v.$$.fragment),ie=a(),k=n("p"),k.innerHTML=$e,ne=a(),_=n("p"),_.innerHTML=ve,oe=a(),p(x.$$.fragment),pe=a(),g=n("div"),g.innerHTML=ke,me=a(),p(B.$$.fragment),re=a(),X=n("p"),X.innerHTML=_e,ue=a(),p(Y.$$.fragment),ce=a(),h=n("div"),h.innerHTML=xe,de=a(),p(R.$$.fragment),fe=a(),F=n("ul"),F.innerHTML=Be,be=a(),p(I.$$.fragment),ge=a(),S=n("ul"),S.innerHTML=Xe,he=a(),p(C.$$.fragment),ye=a(),V=n("p"),V.innerHTML=Ye,Me=a(),N=n("p"),this.h()},l(e){const t=He("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),E=i(e),Q=o(e,"P",{}),Re(Q).forEach(l),q=i(e),m(y.$$.fragment,e),z=i(e),m(M.$$.fragment,e),D=i(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1465uj8"&&(w.innerHTML=Ze),A=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-851pbc"&&(J.textContent=Te),P=i(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-cwruts"&&(U.textContent=je),K=i(e),m(Z.$$.fragment,e),O=i(e),m(T.$$.fragment,e),ee=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-hva56b"&&(j.innerHTML=We),te=i(e),m(W.$$.fragment,e),le=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-n9nsod"&&(G.innerHTML=Ge),se=i(e),m($.$$.fragment,e),ae=i(e),m(v.$$.fragment,e),ie=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1urqyhr"&&(k.innerHTML=$e),ne=i(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-d70s1"&&(_.innerHTML=ve),oe=i(e),m(x.$$.fragment,e),pe=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-1lx4ppg"&&(g.innerHTML=ke),me=i(e),m(B.$$.fragment,e),re=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1rvgn5v"&&(X.innerHTML=_e),ue=i(e),m(Y.$$.fragment,e),ce=i(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ovbosa"&&(h.innerHTML=xe),de=i(e),m(R.$$.fragment,e),fe=i(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1k6q17l"&&(F.innerHTML=Be),be=i(e),m(I.$$.fragment,e),ge=i(e),S=o(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-jn62ws"&&(S.innerHTML=Xe),he=i(e),m(C.$$.fragment,e),ye=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1pt3hz0"&&(V.innerHTML=Ye),Me=i(e),N=o(e,"P",{}),Re(N).forEach(l),this.h()},h(){Je(b,"name","hf:doc:metadata"),Je(b,"content",Ee),Je(g,"class","flex justify-center"),Je(h,"class","flex justify-center")},m(e,t){Qe(document.head,b),s(e,E,t),s(e,Q,t),s(e,q,t),u(y,e,t),s(e,z,t),u(M,e,t),s(e,D,t),s(e,w,t),s(e,A,t),s(e,J,t),s(e,P,t),s(e,U,t),s(e,K,t),u(Z,e,t),s(e,O,t),u(T,e,t),s(e,ee,t),s(e,j,t),s(e,te,t),u(W,e,t),s(e,le,t),s(e,G,t),s(e,se,t),u($,e,t),s(e,ae,t),u(v,e,t),s(e,ie,t),s(e,k,t),s(e,ne,t),s(e,_,t),s(e,oe,t),u(x,e,t),s(e,pe,t),s(e,g,t),s(e,me,t),u(B,e,t),s(e,re,t),s(e,X,t),s(e,ue,t),u(Y,e,t),s(e,ce,t),s(e,h,t),s(e,de,t),u(R,e,t),s(e,fe,t),s(e,F,t),s(e,be,t),u(I,e,t),s(e,ge,t),s(e,S,t),s(e,he,t),u(C,e,t),s(e,ye,t),s(e,V,t),s(e,Me,t),s(e,N,t),we=!0},p:Ie,i(e){we||(c(y.$$.fragment,e),c(M.$$.fragment,e),c(Z.$$.fragment,e),c(T.$$.fragment,e),c(W.$$.fragment,e),c($.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(B.$$.fragment,e),c(Y.$$.fragment,e),c(R.$$.fragment,e),c(I.$$.fragment,e),c(C.$$.fragment,e),we=!0)},o(e){d(y.$$.fragment,e),d(M.$$.fragment,e),d(Z.$$.fragment,e),d(T.$$.fragment,e),d(W.$$.fragment,e),d($.$$.fragment,e),d(v.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(Y.$$.fragment,e),d(R.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),we=!1},d(e){e&&(l(E),l(Q),l(q),l(z),l(D),l(w),l(A),l(J),l(P),l(U),l(K),l(O),l(ee),l(j),l(te),l(le),l(G),l(se),l(ae),l(ie),l(k),l(ne),l(_),l(oe),l(pe),l(g),l(me),l(re),l(X),l(ue),l(ce),l(h),l(de),l(fe),l(F),l(be),l(ge),l(S),l(he),l(ye),l(V),l(Me),l(N)),l(b),f(y,e),f(M,e),f(Z,e),f(T,e),f(W,e),f($,e),f(v,e),f(x,e),f(B,e),f(Y,e),f(R,e),f(I,e),f(C,e)}}}const Ee='{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Speed-up SDXL Turbo even more","local":"speed-up-sdxl-turbo-even-more","sections":[],"depth":2}],"depth":1}';function qe(Ue){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oe extends Ce{constructor(b){super(),Ve(this,b,qe,Le,Fe,{})}}export{Oe as component};
