import{s as Ae,o as Le,n as Je}from"../chunks/scheduler.69131cc3.js";import{S as Ye,i as He,g as r,s as a,r as c,A as Se,h as o,f as n,c as i,j as ke,u as f,x as d,k as Ge,y as We,a as l,v as h,d as u,t as $,w}from"../chunks/index.e1f30d73.js";import{T as Ze}from"../chunks/Tip.22e79575.js";import{C as ue}from"../chunks/CodeBlock.30cef355.js";import{H as I}from"../chunks/Heading.0aab6758.js";function Be(X){let s,m="In this example, there are two GPUs for “Multi-GPU” and a TPU pod with 8 workers";return{c(){s=r("p"),s.textContent=m},l(p){s=o(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-k9rq2f"&&(s.textContent=m)},m(p,g){l(p,s,g)},p:Je,d(p){p&&n(s)}}}function Xe(X){let s,m=`Since users can have their own learning rate schedulers defined, we leave this up to the user to decide if they wish to scale their
learning rate or not.`;return{c(){s=r("p"),s.textContent=m},l(p){s=o(p,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1birp9c"&&(s.textContent=m)},m(p,g){l(p,s,g)},p:Je,d(p){p&&n(s)}}}function Ee(X){let s,m,p,g,v,V,T,$e=`Evaluating and comparing the performance from different setups can be quite tricky if you don’t know what to look for.
For example, you cannot run the same script with the same batch size across TPU, multi-GPU, and single-GPU with Accelerate
and expect your results to line up.`,R,x,we="But why?",F,_,ge="There are three reasons for this that this tutorial will cover:",N,C,be="<li><strong>Setting the right seeds</strong></li> <li><strong>Observed Batch Sizes</strong></li> <li><strong>Learning Rates</strong></li>",Q,y,q,U,Me='While this issue has not come up as much, make sure to use <a href="/docs/accelerate/v0.26.1/en/package_reference/utilities#accelerate.utils.set_seed">utils.set_seed()</a> to fully set the seed in all distributed cases so training will be reproducible:',K,j,O,P,ve="Why is this important? Under the hood this will set <strong>5</strong> different seed settings:",D,z,ee,k,Te="The random state, numpy’s state, torch, torch’s cuda state, and if TPUs are available torch_xla’s cuda state.",te,G,ne,Z,xe=`When training with Accelerate, the batch size passed to the dataloader is the <strong>batch size per GPU</strong>. What this entails is
a batch size of 64 on two GPUs is truly a batch size of 128. As a result, when testing on a single GPU this needs to be accounted for,
as well as similarly for TPUs.`,le,J,_e="The below table can be used as a quick reference to try out different batch sizes:",se,b,ae,A,Ce="<thead><tr><th>Single GPU Batch Size</th> <th>Multi-GPU Equivalent Batch Size</th> <th>TPU Equivalent Batch Size</th></tr></thead> <tbody><tr><td>256</td> <td>128</td> <td>32</td></tr> <tr><td>128</td> <td>64</td> <td>16</td></tr> <tr><td>64</td> <td>32</td> <td>8</td></tr> <tr><td>32</td> <td>16</td> <td>4</td></tr></tbody>",ie,L,re,Y,ye=`As noted in multiple sources[<a href="https://aws.amazon.com/blogs/machine-learning/scalable-multi-node-deep-learning-training-using-gpus-in-the-aws-cloud/" rel="nofollow">1</a>][<a href="https://docs.nvidia.com/clara/clara-train-sdk/pt/model.html#classification-models-multi-gpu-training" rel="nofollow">2</a>], the learning rate should be scaled <em>linearly</em> based on the number of devices present. The below
snippet shows doing so with Accelerate:`,oe,M,pe,H,de,S,Ue=`You will also find that <code>accelerate</code> will step the learning rate based on the number of processes being trained on. This is because
of the observed batch size noted earlier. So in the case of 2 GPUs, the learning rate will be stepped twice as often as a single GPU
to account for the batch size being twice as large (if no changes to the batch size on the single GPU instance are made).`,me,W,ce,B,je=`When using gradient accumulation and mixed precision, due to how gradient averaging works (accumulation) and the precision loss (mixed precision),
some degradation in performance is expected. This will be explicitly seen when comparing the batch-wise loss between different compute
setups. However, the overall loss, metric, and general performance at the end of training should be <em>roughly</em> the same.`,fe,E,he;return v=new I({props:{title:"Comparing performance between different device setups",local:"comparing-performance-between-different-device-setups",headingTag:"h1"}}),y=new I({props:{title:"Setting the Seed",local:"setting-the-seed",headingTag:"h2"}}),j=new ue({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBzZXRfc2VlZCUwQSUwQXNldF9zZWVkKDQyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed

set_seed(<span class="hljs-number">42</span>)`,wrap:!1}}),z=new ue({props:{code:"JTIwJTIwJTIwJTIwcmFuZG9tLnNlZWQoc2VlZCklMEElMjAlMjAlMjAlMjBucC5yYW5kb20uc2VlZChzZWVkKSUwQSUyMCUyMCUyMCUyMHRvcmNoLm1hbnVhbF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5tYW51YWxfc2VlZF9hbGwoc2VlZCklMEElMjAlMjAlMjAlMjAlMjMlMjAlNUUlNUUlMjBzYWZlJTIwdG8lMjBjYWxsJTIwdGhpcyUyMGZ1bmN0aW9uJTIwZXZlbiUyMGlmJTIwY3VkYSUyMGlzJTIwbm90JTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwaWYlMjBpc190cHVfYXZhaWxhYmxlKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4bS5zZXRfcm5nX3N0YXRlKHNlZWQp",highlighted:`    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    <span class="hljs-comment"># ^^ safe to call this function even if cuda is not available</span>
    <span class="hljs-keyword">if</span> is_tpu_available():
        xm.set_rng_state(seed)`,wrap:!1}}),G=new I({props:{title:"Observed Batch Sizes",local:"observed-batch-sizes",headingTag:"h2"}}),b=new Ze({props:{$$slots:{default:[Be]},$$scope:{ctx:X}}}),L=new I({props:{title:"Learning Rates",local:"learning-rates",headingTag:"h2"}}),M=new Ze({props:{$$slots:{default:[Xe]},$$scope:{ctx:X}}}),H=new ue({props:{code:"bGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTMlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEFsZWFybmluZ19yYXRlJTIwKiUzRCUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGxlYXJuaW5nX3JhdGUp",highlighted:`learning_rate = <span class="hljs-number">1e-3</span>
accelerator = Accelerator()
learning_rate *= accelerator.num_processes

optimizer = AdamW(params=model.parameters(), lr=learning_rate)`,wrap:!1}}),W=new I({props:{title:"Gradient Accumulation and Mixed Precision",local:"gradient-accumulation-and-mixed-precision",headingTag:"h2"}}),{c(){s=r("meta"),m=a(),p=r("p"),g=a(),c(v.$$.fragment),V=a(),T=r("p"),T.textContent=$e,R=a(),x=r("p"),x.textContent=we,F=a(),_=r("p"),_.textContent=ge,N=a(),C=r("ol"),C.innerHTML=be,Q=a(),c(y.$$.fragment),q=a(),U=r("p"),U.innerHTML=Me,K=a(),c(j.$$.fragment),O=a(),P=r("p"),P.innerHTML=ve,D=a(),c(z.$$.fragment),ee=a(),k=r("p"),k.textContent=Te,te=a(),c(G.$$.fragment),ne=a(),Z=r("p"),Z.innerHTML=xe,le=a(),J=r("p"),J.textContent=_e,se=a(),c(b.$$.fragment),ae=a(),A=r("table"),A.innerHTML=Ce,ie=a(),c(L.$$.fragment),re=a(),Y=r("p"),Y.innerHTML=ye,oe=a(),c(M.$$.fragment),pe=a(),c(H.$$.fragment),de=a(),S=r("p"),S.innerHTML=Ue,me=a(),c(W.$$.fragment),ce=a(),B=r("p"),B.innerHTML=je,fe=a(),E=r("p"),this.h()},l(e){const t=Se("svelte-u9bgzb",document.head);s=o(t,"META",{name:!0,content:!0}),t.forEach(n),m=i(e),p=o(e,"P",{}),ke(p).forEach(n),g=i(e),f(v.$$.fragment,e),V=i(e),T=o(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1u8i7ng"&&(T.textContent=$e),R=i(e),x=o(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1pzk3n6"&&(x.textContent=we),F=i(e),_=o(e,"P",{"data-svelte-h":!0}),d(_)!=="svelte-1px1vea"&&(_.textContent=ge),N=i(e),C=o(e,"OL",{"data-svelte-h":!0}),d(C)!=="svelte-1ezajja"&&(C.innerHTML=be),Q=i(e),f(y.$$.fragment,e),q=i(e),U=o(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-fdwry2"&&(U.innerHTML=Me),K=i(e),f(j.$$.fragment,e),O=i(e),P=o(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-bvqjor"&&(P.innerHTML=ve),D=i(e),f(z.$$.fragment,e),ee=i(e),k=o(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1x4b50a"&&(k.textContent=Te),te=i(e),f(G.$$.fragment,e),ne=i(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-y1nchk"&&(Z.innerHTML=xe),le=i(e),J=o(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1pogoqw"&&(J.textContent=_e),se=i(e),f(b.$$.fragment,e),ae=i(e),A=o(e,"TABLE",{"data-svelte-h":!0}),d(A)!=="svelte-4k3weo"&&(A.innerHTML=Ce),ie=i(e),f(L.$$.fragment,e),re=i(e),Y=o(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1xakrqo"&&(Y.innerHTML=ye),oe=i(e),f(M.$$.fragment,e),pe=i(e),f(H.$$.fragment,e),de=i(e),S=o(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1z0alx"&&(S.innerHTML=Ue),me=i(e),f(W.$$.fragment,e),ce=i(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1oucnsg"&&(B.innerHTML=je),fe=i(e),E=o(e,"P",{}),ke(E).forEach(n),this.h()},h(){Ge(s,"name","hf:doc:metadata"),Ge(s,"content",Ie)},m(e,t){We(document.head,s),l(e,m,t),l(e,p,t),l(e,g,t),h(v,e,t),l(e,V,t),l(e,T,t),l(e,R,t),l(e,x,t),l(e,F,t),l(e,_,t),l(e,N,t),l(e,C,t),l(e,Q,t),h(y,e,t),l(e,q,t),l(e,U,t),l(e,K,t),h(j,e,t),l(e,O,t),l(e,P,t),l(e,D,t),h(z,e,t),l(e,ee,t),l(e,k,t),l(e,te,t),h(G,e,t),l(e,ne,t),l(e,Z,t),l(e,le,t),l(e,J,t),l(e,se,t),h(b,e,t),l(e,ae,t),l(e,A,t),l(e,ie,t),h(L,e,t),l(e,re,t),l(e,Y,t),l(e,oe,t),h(M,e,t),l(e,pe,t),h(H,e,t),l(e,de,t),l(e,S,t),l(e,me,t),h(W,e,t),l(e,ce,t),l(e,B,t),l(e,fe,t),l(e,E,t),he=!0},p(e,[t]){const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),b.$set(Pe);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),M.$set(ze)},i(e){he||(u(v.$$.fragment,e),u(y.$$.fragment,e),u(j.$$.fragment,e),u(z.$$.fragment,e),u(G.$$.fragment,e),u(b.$$.fragment,e),u(L.$$.fragment,e),u(M.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),he=!0)},o(e){$(v.$$.fragment,e),$(y.$$.fragment,e),$(j.$$.fragment,e),$(z.$$.fragment,e),$(G.$$.fragment,e),$(b.$$.fragment,e),$(L.$$.fragment,e),$(M.$$.fragment,e),$(H.$$.fragment,e),$(W.$$.fragment,e),he=!1},d(e){e&&(n(m),n(p),n(g),n(V),n(T),n(R),n(x),n(F),n(_),n(N),n(C),n(Q),n(q),n(U),n(K),n(O),n(P),n(D),n(ee),n(k),n(te),n(ne),n(Z),n(le),n(J),n(se),n(ae),n(A),n(ie),n(re),n(Y),n(oe),n(pe),n(de),n(S),n(me),n(ce),n(B),n(fe),n(E)),n(s),w(v,e),w(y,e),w(j,e),w(z,e),w(G,e),w(b,e),w(L,e),w(M,e),w(H,e),w(W,e)}}}const Ie='{"title":"Comparing performance between different device setups","local":"comparing-performance-between-different-device-setups","sections":[{"title":"Setting the Seed","local":"setting-the-seed","sections":[],"depth":2},{"title":"Observed Batch Sizes","local":"observed-batch-sizes","sections":[],"depth":2},{"title":"Learning Rates","local":"learning-rates","sections":[],"depth":2},{"title":"Gradient Accumulation and Mixed Precision","local":"gradient-accumulation-and-mixed-precision","sections":[],"depth":2}],"depth":1}';function Ve(X){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Ye{constructor(s){super(),He(this,s,Ve,Ee,Ae,{})}}export{Ke as component};
