import{s as Ls,o as qs,n as Ht}from"../chunks/scheduler.8c3d61f6.js";import{S as Ps,i as Ks,g as M,s as a,r as c,A as Os,h as i,f as t,c as n,j as Ds,u as J,x as p,k as $s,y as la,a as s,v as m,d,t as T,w as U}from"../chunks/index.da70eac4.js";import{T as zt}from"../chunks/Tip.1d9b8c37.js";import{C as j}from"../chunks/CodeBlock.a9c4becf.js";import{H as Z,E as ea}from"../chunks/getInferenceSnippets.c28dea0b.js";function ta(h){let o,r="🧪 <strong>Experimental Feature</strong>: Modular Diffusers is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){o=M("p"),o.innerHTML=r},l(y){o=i(y,"P",{"data-svelte-h":!0}),p(o)!=="svelte-11qh5l3"&&(o.innerHTML=r)},m(y,w){s(y,o,w)},p:Ht,d(y){y&&t(o)}}}function sa(h){let o,r="💡  use <code>print(dd_pipeline.doc)</code> to check compiled inputs and outputs of the built piepline.",y,w,f="e.g. after we added <code>diffdiff_map</code> as an input in this step, we can run <code>print(dd_pipeline.doc)</code> to verify that it shows up in the docstring as a user input.";return{c(){o=M("p"),o.innerHTML=r,y=a(),w=M("p"),w.innerHTML=f},l(b){o=i(b,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1fmrtdn"&&(o.innerHTML=r),y=n(b),w=i(b,"P",{"data-svelte-h":!0}),p(w)!=="svelte-16ri2fv"&&(w.innerHTML=f)},m(b,u){s(b,o,u),s(b,y,u),s(b,w,u)},p:Ht,d(b){b&&(t(o),t(y),t(w))}}}function aa(h){let o,r="💡  Implement incrementally! Run the example script as you go, and insert <code>print(state)</code> and <code>print(block_state)</code> everywhere inside the <code>__call__</code> method to inspect the intermediate results. This helps you understand what’s going on and what each line you just added does.";return{c(){o=M("p"),o.innerHTML=r},l(y){o=i(y,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1ktq700"&&(o.innerHTML=r)},m(y,w){s(y,o,w)},p:Ht,d(y){y&&t(o)}}}function na(h){let o,r="Note that it’s perfectly fine not to use <code>AutoPipelineBlocks</code>. In fact, we recommend only using <code>AutoPipelineBlocks</code> to package your workflow at the end once you’ve verified all your pipelines work as expected.";return{c(){o=M("p"),o.innerHTML=r},l(y){o=i(y,"P",{"data-svelte-h":!0}),p(o)!=="svelte-wy1vy"&&(o.innerHTML=r)},m(y,w){s(y,o,w)},p:Ht,d(y){y&&t(o)}}}function Ma(h){let o,r,y,w,f,b,u,ie,R,xt="In this tutorial we will walk through the process of adding a new pipeline to the modular framework using differential diffusion as our example. We’ll cover the complete workflow from implementation to deployment: implementing the new pipeline, ensuring compatibility with existing tools, sharing the code on Hugging Face Hub, and deploying it as a UI node.",pe,B,Dt="We’ll also demonstrate the 4-step framework process we use for implementing new basic pipelines in the modular system.",oe,g,$t="<li><p><strong>Start with an existing pipeline as a base</strong></p> <ul><li>Identify which existing pipeline is most similar to the one you want to implement</li> <li>Determine what part of the pipeline needs modification</li></ul></li> <li><p><strong>Build a working pipeline structure first</strong></p> <ul><li>Assemble the complete pipeline structure</li> <li>Use existing blocks wherever possible</li> <li>For new blocks, create placeholders (e.g. you can copy from similar blocks and change the name) without implementing custom logic just yet</li></ul></li> <li><p><strong>Set up an example</strong></p> <ul><li>Create a simple inference script with expected inputs/outputs</li></ul></li> <li><p><strong>Implement your custom logic and test incrementally</strong></p> <ul><li>Add the custom logics the blocks you want to change</li> <li>Test incrementally, and inspect pipeline states and debug as needed</li></ul></li>",ce,X,Lt="Let’s see how this works with the Differential Diffusion example.",Je,N,me,V,de,E,qt='Differential diffusion (<a href="https://differential-diffusion.github.io/" rel="nofollow">https://differential-diffusion.github.io/</a>) is an image-to-image workflow, so it makes sense for us to start with the preset of pipeline blocks used to build img2img pipeline (<code>IMAGE2IMAGE_BLOCKS</code>) and see how we can build this new pipeline with them.',Te,W,Ue,A,Pt='Note that “denoise” (<code>StableDiffusionXLDenoiseStep</code>) is a <code>LoopSequentialPipelineBlocks</code> that contains 3 loop blocks (more on LoopSequentialPipelineBlocks <a href="https://huggingface.co/docs/diffusers/modular_diffusers/write_own_pipeline_block#loopsequentialpipelineblocks" rel="nofollow">here</a>)',ye,k,je,Q,we,_,Kt="Let’s compare standard image-to-image and differential diffusion! The key difference in algorithm is that standard image-to-image diffusion applies uniform noise across all pixels based on a single <code>strength</code> parameter, but differential diffusion uses a change map where each pixel value determines when that region starts denoising. Regions with lower values get “frozen” earlier by replacing them with noised original latents, preserving more of the original image.",re,S,Ot="Therefore, the key differences when it comes to pipeline implementation would be:",be,Y,ls="<li>The <code>prepare_latents</code> step (which prepares the change map and pre-computes noised latents for all timesteps)</li> <li>The <code>denoise</code> step (which selectively applies denoising based on the change map)</li> <li>Since differential diffusion doesn’t use the <code>strength</code> parameter, we’ll use the text-to-image <code>set_timesteps</code> step instead of the image-to-image version</li>",ue,v,es="To implement differntial diffusion, we can reuse most blocks from image-to-image and text-to-image workflows, only modifying the <code>prepare_latents</code> step and the first part of the <code>denoise</code> step (i.e. <code>before_denoiser (StableDiffusionXLLoopBeforeDenoiser)</code>).",he,F,ts="Here’s a flowchart showing the pipeline structure and the changes we need to make:",fe,z,ss='<img src="https://mermaid.ink/img/pako:eNqVVO9r4kAQ_VeWLQWFKEk00eRDwZpa7Q-ucPfpYpE1mdWlcTdsVmpb-7_fZk1tTCl3J0Sy8968N5kZ9g0nIgUc4pUk-Rr9iuYc6d_Ibs14vlXoQYpNrtqo07lAo1jBTi2AlynysWIa6DJmG7KCBnZpsHHMSqkqNjaxKC5ALRTbQKEgLyosMthVnEvIiYRFRhRwVaBoNpmUT0W7MrTJkUbSdJEInlbwxMDXcQpcsAKq6OH_2mDTODIY4yt0J0ReUaYGnLXiJVChdSsB-enfPhBnhnjT-rCQj-1K_8Ygt62YUAVy8Ykf4FvU6XYu9rpuIGqPpvXSzs_RVEj2KrgiGUp02zNQTHBEM_FcK3BfQbBHd7qAst-PxvW-9WOrypnNylG0G9oRUMYBFeolg-IQTTJSFDqOUkZp-fwsQURZloVnlPpLf2kVSoonCM-SwCUuqY6dZ5aqddjLd1YiMiFLNrWorrxj9EOmP4El37lsl_9p5PzFqIqwVwgdN981fDM94bphH5I06R8NXZ_4QcPQPTFs6JltPrS6JssFhw9N817l27bdyM-lSKAo6iVBAAnQY0n9wLO9wbcluY7ruUFDtdguH74K0yENKDkK-8nAG6TfNrfy_bf-HjdrlOfZS7VYSAlU5JAwyhLE9WrWVw1dWdPTXauDsy8LUkdHtnX_pfMnBOvSGluRNbGurbuTHtdZN9Zts1MljC19_7EUh0puwcIbkBtSHvFbic6xWsMG5jjUrymRT3M85-86Jyf8txCbjzQptqs1DinJCn3a5qm-viJG9M26OUYlcH0_jsWWKxwGttHA4Rve4dD1el3H8_yh49hD3_X7roVfcNhx-l3b14PxvGHQ0xMa9t4t_Gp8na7tDvu-4w08HXecweD9D4X54ZI" alt="DiffDiff Pipeline Structure"/>',Ze,H,Ie,x,as="ok now we’ve identified the blocks to modify, let’s build the pipeline skeleton first - at this stage, our goal is to get the pipeline struture working end-to-end (even though it’s just doing the img2img behavior). I would simply create placeholder blocks by copying from existing ones:",Ce,D,Ge,$,ns="<code>SDXLDiffDiffLoopBeforeDenoiser</code> is the be part of the denoise loop we need to change. Let’s use it to assemble a <code>SDXLDiffDiffDenoiseStep</code>.",Re,L,Be,q,Ms="Now we can put together our differential diffusion pipeline.",ge,P,Xe,K,Ne,O,is="ok, so now our blocks should be able to compile without an error, we can move on to the next step. Let’s setup a simple example so we can run the pipeline as we build it. diff-diff use same model checkpoints as SDXL so we can fetch the models from a regular SDXL repo.",Ve,ll,Ee,el,ps="We will use this example script:",We,tl,Ae,sl,os=`If you run the script right now, you will get a complaint about unexpected input <code>diffdiff_map</code>.
and you would get the same result as the original img2img pipeline.`,ke,al,Qe,nl,cs="Let’s modify the pipeline so that we can get expected result with this example script.",_e,Ml,Js="We’ll start with the <code>prepare_latents</code> step. The main changes are:",Se,il,ms="<li>Requires a new user input <code>diffdiff_map</code></li> <li>Requires new component <code>mask_processor</code> to process the <code>diffdiff_map</code></li> <li>Requires new intermediate inputs: <ul><li>Need <code>timestep</code> instead of <code>latent_timestep</code> to precompute all the latents</li> <li>Need <code>num_inference_steps</code> to create the <code>diffdiff_masks</code></li></ul></li> <li>create a new output <code>diffdiff_masks</code> and <code>original_latents</code></li>",Ye,I,ve,pl,ds="Once we make sure all the variables we need are available in the block state, we can implement the diff-diff logic inside <code>__call__</code>. We created 2 new variables: the change map <code>diffdiff_mask</code> and the pre-computed noised latents for all timesteps <code>original_latents</code>.",Fe,C,ze,ol,Ts="Here are the key changes we made to implement differential diffusion:",He,cl,Us="<strong>1. Modified <code>prepare_latents</code> step:</strong>",xe,Jl,De,ml,ys="<strong>2. Modified <code>before_denoiser</code> step:</strong>",$e,dl,Le,Tl,js="That’s all there is to it! We’ve just created a simple sequential pipeline by mix-and-match some existing and new pipeline blocks.",qe,Ul,ws="Now we use the process we’ve prepred in step2 to build the pipeline and inspect it.",Pe,yl,Ke,jl,rs="Run the example now, you should see an apple with its right half transformed into a green pear.",Oe,wl,bs='<img src="https://cdn-uploads.huggingface.co/production/uploads/624ef9ba9d608e459387b34e/4zqJOz-35Q0i6jyUW3liL.png" alt="Image description"/>',lt,rl,et,bl,us='We provide an auto IP-adapter block that you can plug-and-play into your modular workflow. It’s an <code>AutoPipelineBlocks</code>, so it will only run when the user passes an IP adapter image. In this tutorial, we’ll focus on how to package it into your differential diffusion workflow. To learn more about <code>AutoPipelineBlocks</code>, see <a href="./auto_pipeline_blocks.md">here</a>',tt,ul,hs='We talked about how to add IP-adapter into your workflow in the <a href="./modular_pipeline.md">Modular Pipeline Guide</a>. Let’s just go ahead to create the IP-adapter block.',st,hl,at,fl,fs="We can directly add the ip-adapter block instance to the <code>diffdiff_blocks</code> that we created before. The <code>sub_blocks</code> attribute is a <code>InsertableDict</code>, so we’re able to insert the it at specific position (index <code>0</code> here).",nt,Zl,Mt,Il,Zs="Take a look at the new diff-diff pipeline with ip-adapter!",it,Cl,pt,Gl,Is="The pipeline now lists ip-adapter as its first block, and tells you that it will run only if <code>ip_adapter_image</code> is provided. It also includes the two new components from ip-adpater: <code>image_encoder</code> and <code>feature_extractor</code>",ot,Rl,ct,Bl,Cs="Let’s test it out. We used an orange image to condition the generation via ip-addapter and we can see a slight orange color and texture in the final output.",Jt,gl,mt,Xl,dt,Nl,Gs="What about controlnet? Can differential diffusion work with controlnet? The key differences between a regular pipeline and a ControlNet pipeline are:",Tt,Vl,Rs="<li>A ControlNet input step that prepares the control condition</li> <li>Inside the denoising loop, a modified denoiser step where the control image is first processed through ControlNet, then control information is injected into the UNet</li>",Ut,El,Bs="From looking at the code workflow: differential diffusion only modifies the “before denoiser” step, while ControlNet operates within the “denoiser” itself. Since they intervene at different points in the pipeline, they should work together without conflicts.",yt,Wl,gs="Intuitively, these two techniques are orthogonal and should combine naturally: differential diffusion controls how much the inference process can deviate from the original in each region, while ControlNet controls in what direction that change occurs.",jt,Al,Xs="With this understanding, let’s assemble the diffdiff-controlnet loop by combining the diffdiff before-denoiser step and controlnet denoiser step.",wt,kl,rt,Ql,Ns="We provide a auto controlnet input block that you can directly put into your workflow to proceess the <code>control_image</code>: similar to auto ip-adapter block, this step will only run if <code>control_image</code> input is passed from user. It work with both controlnet and controlnet union.",bt,_l,ut,Sl,ht,Yl,Vs="Let’s assemble the blocks and run an example using controlnet + differential diffusion. We used a tomato as <code>control_image</code>, so you can see that in the output, the right half that transformed into a pear had a tomato-like shape.",ft,vl,Zt,Fl,Es="Optionally, We can combine <code>SDXLDiffDiffControlNetDenoiseStep</code> and <code>SDXLDiffDiffDenoiseStep</code> into a <code>AutoPipelineBlocks</code> so that same workflow can work with or without controlnet.",It,zl,Ct,Hl,Ws="<code>SDXLDiffDiffAutoDenoiseStep</code> will run the ControlNet denoise step if <code>control_image</code> input is provided, otherwise it will run the regular denoise step.",Gt,G,Rt,xl,As="Now you can create the differential diffusion preset that works with ip-adapter & controlnet.",Bt,Dl,gt,$l,ks="to use",Xt,Ll,Nt,ql,Vt,Pl,Qs='You can easily share your differential diffusion workflow on the Hub by creating a modular repo. This is one created using the code we just wrote together: <a href="https://huggingface.co/YiYiXu/modular-diffdiff" rel="nofollow">https://huggingface.co/YiYiXu/modular-diffdiff</a>',Et,Kl,_s="To create a Modular Repo and share on hub, you just need to run <code>save_pretrained()</code> along with the <code>push_to_hub=True</code> flag. Note that if your pipeline contains custom block, you need to manually upload the code to the hub. But we are working on a command line tool to help you upload it very easily.",Wt,Ol,At,le,Ss="With a modular repo, it is very easy for the community to use the workflow you just created! Here is an example to use the differential-diffusion pipeline we just created and shared.",kt,ee,Qt,te,Ys="see more usage example on model card.",_t,se,St,ae,vs="[YIYI TODO: for now, here is an example of mellon node https://huggingface.co/YiYiXu/diff-diff-mellon]",Yt,ne,vt,Me,Ft;return f=new Z({props:{title:"End-to-End Developer Guide: Building with Modular Diffusers",local:"end-to-end-developer-guide-building-with-modular-diffusers",headingTag:"h1"}}),u=new zt({props:{warning:!0,$$slots:{default:[ta]},$$scope:{ctx:h}}}),N=new Z({props:{title:"Differential Diffusion Pipeline",local:"differential-diffusion-pipeline",headingTag:"h2"}}),V=new Z({props:{title:"Start with an existing pipeline",local:"start-with-an-existing-pipeline",headingTag:"h3"}}),W=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBSU1BR0UySU1BR0VfQkxPQ0tTJTIwJTNEJTIwSW5zZXJ0YWJsZURpY3QoJTVCJTBBJTIwJTIwJTIwJTIwKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMVGV4dEVuY29kZXJTdGVwKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJpbWFnZV9lbmNvZGVyJTIyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExWYWVFbmNvZGVyU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyaW5wdXQlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTElucHV0U3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyc2V0X3RpbWVzdGVwcyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1NldFRpbWVzdGVwc1N0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMnByZXBhcmVfbGF0ZW50cyUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVMYXRlbnRzU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIycHJlcGFyZV9hZGRfY29uZCUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1ByZXBhcmVBZGRpdGlvbmFsQ29uZGl0aW9uaW5nU3RlcCklMkMlMEElMjAlMjAlMjAlMjAoJTIyZGVub2lzZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZVN0ZXApJTJDJTBBJTIwJTIwJTIwJTIwKCUyMmRlY29kZSUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVjb2RlU3RlcCklMEElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS
<span class="hljs-meta">&gt;&gt;&gt; </span>IMAGE2IMAGE_BLOCKS = InsertableDict([
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;text_encoder&quot;</span>, StableDiffusionXLTextEncoderStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;image_encoder&quot;</span>, StableDiffusionXLVaeEncoderStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;input&quot;</span>, StableDiffusionXLInputStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;set_timesteps&quot;</span>, StableDiffusionXLImg2ImgSetTimestepsStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;prepare_latents&quot;</span>, StableDiffusionXLImg2ImgPrepareLatentsStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;prepare_add_cond&quot;</span>, StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;denoise&quot;</span>, StableDiffusionXLDenoiseStep),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;decode&quot;</span>, StableDiffusionXLDecodeStep)
<span class="hljs-meta">... </span>])`,wrap:!1}}),k=new j({props:{code:"ZGVub2lzZV9ibG9ja3MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEKCklMEFwcmludChkZW5vaXNlX2Jsb2Nrcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>denoise_blocks = IMAGE2IMAGE_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(denoise_blocks)`,wrap:!1}}),Q=new j({props:{code:"U3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlU3RlcCglMEElMjAlMjBDbGFzcyUzQSUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BXcmFwcGVyJTBBJTBBJTIwJTIwRGVzY3JpcHRpb24lM0ElMjBEZW5vaXNlJTIwc3RlcCUyMHRoYXQlMjBpdGVyYXRpdmVseSUyMGRlbm9pc2UlMjB0aGUlMjBsYXRlbnRzLiUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMEl0cyUyMGxvb3AlMjBsb2dpYyUyMGlzJTIwZGVmaW5lZCUyMGluJTIwJTYwU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIuX19jYWxsX18lNjAlMjBtZXRob2QlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBBdCUyMGVhY2glMjBpdGVyYXRpb24lMkMlMjBpdCUyMHJ1bnMlMjBibG9ja3MlMjBkZWZpbmVkJTIwaW4lMjAlNjBzdWJfYmxvY2tzJTYwJTIwc2VxdWVuY2lhbGx5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMCU2MFN0YWJsZURpZmZ1c2lvblhMTG9vcEJlZm9yZURlbm9pc2VyJTYwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMCU2MFN0YWJsZURpZmZ1c2lvblhMTG9vcERlbm9pc2VyJTYwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMCU2MFN0YWJsZURpZmZ1c2lvblhMTG9vcEFmdGVyRGVub2lzZXIlNjAlMEElMjAlMjAlMjAlMjAlMjAlMjBUaGlzJTIwYmxvY2slMjBzdXBwb3J0cyUyMGJvdGglMjB0ZXh0MmltZyUyMGFuZCUyMGltZzJpbWclMjB0YXNrcy4lMEElMEElMEElMjAlMjBDb21wb25lbnRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTIwKCU2MEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwZ3VpZGVyJTIwKCU2MENsYXNzaWZpZXJGcmVlR3VpZGFuY2UlNjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwdW5ldCUyMCglNjBVTmV0MkRDb25kaXRpb25Nb2RlbCU2MCklMEElMEElMjAlMjBTdWItQmxvY2tzJTNBJTBBJTIwJTIwJTIwJTIwJTVCMCU1RCUyMGJlZm9yZV9kZW5vaXNlciUyMChTdGFibGVEaWZmdXNpb25YTExvb3BCZWZvcmVEZW5vaXNlciklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXNjcmlwdGlvbiUzQSUyMHN0ZXAlMjB3aXRoaW4lMjB0aGUlMjBkZW5vaXNpbmclMjBsb29wJTIwdGhhdCUyMHByZXBhcmUlMjB0aGUlMjBsYXRlbnQlMjBpbnB1dCUyMGZvciUyMHRoZSUyMGRlbm9pc2VyLiUyMFRoaXMlMjBibG9jayUyMHNob3VsZCUyMGJlJTIwdXNlZCUyMHRvJTIwY29tcG9zZSUyMHRoZSUyMCU2MHN1Yl9ibG9ja3MlNjAlMjBhdHRyaWJ1dGUlMjBvZiUyMGElMjAlNjBMb29wU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTYwJTIwb2JqZWN0JTIwKGUuZy4lMjAlNjBTdGFibGVEaWZmdXNpb25YTERlbm9pc2VMb29wV3JhcHBlciU2MCklMEElMEElMjAlMjAlMjAlMjAlNUIxJTVEJTIwZGVub2lzZXIlMjAoU3RhYmxlRGlmZnVzaW9uWExMb29wRGVub2lzZXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGVzY3JpcHRpb24lM0ElMjBTdGVwJTIwd2l0aGluJTIwdGhlJTIwZGVub2lzaW5nJTIwbG9vcCUyMHRoYXQlMjBkZW5vaXNlJTIwdGhlJTIwbGF0ZW50cyUyMHdpdGglMjBndWlkYW5jZS4lMjBUaGlzJTIwYmxvY2slMjBzaG91bGQlMjBiZSUyMHVzZWQlMjB0byUyMGNvbXBvc2UlMjB0aGUlMjAlNjBzdWJfYmxvY2tzJTYwJTIwYXR0cmlidXRlJTIwb2YlMjBhJTIwJTYwTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyU2MCUyMG9iamVjdCUyMChlLmcuJTIwJTYwU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIlNjApJTBBJTBBJTIwJTIwJTIwJTIwJTVCMiU1RCUyMGFmdGVyX2Rlbm9pc2VyJTIwKFN0YWJsZURpZmZ1c2lvblhMTG9vcEFmdGVyRGVub2lzZXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGVzY3JpcHRpb24lM0ElMjBzdGVwJTIwd2l0aGluJTIwdGhlJTIwZGVub2lzaW5nJTIwbG9vcCUyMHRoYXQlMjB1cGRhdGUlMjB0aGUlMjBsYXRlbnRzLiUyMFRoaXMlMjBibG9jayUyMHNob3VsZCUyMGJlJTIwdXNlZCUyMHRvJTIwY29tcG9zZSUyMHRoZSUyMCU2MHN1Yl9ibG9ja3MlNjAlMjBhdHRyaWJ1dGUlMjBvZiUyMGElMjAlNjBMb29wU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTYwJTIwb2JqZWN0JTIwKGUuZy4lMjAlNjBTdGFibGVEaWZmdXNpb25YTERlbm9pc2VMb29wV3JhcHBlciU2MCklMEElMEEp",highlighted:'StableDiffusionXLDenoiseStep(\n<span class="hljs-title">  Class:</span> StableDiffusionXLDenoiseLoopWrapper\n\n<span class="hljs-title">  Description:</span> Denoise step that iteratively denoise the latents. \n      Its loop logic is defined in `StableDiffusionXLDenoiseLoopWrapper.__call__` method \n<span class="hljs-title">      At each iteration, it runs blocks defined in `sub_blocks` sequencially:</span>\n       - `StableDiffusionXLLoopBeforeDenoiser`\n       - `StableDiffusionXLLoopDenoiser`\n       - `StableDiffusionXLLoopAfterDenoiser`\n      This block supports both text2img <span class="hljs-literal">and</span> img2img tasks.\n\n\n<span class="hljs-title">  Components:</span>\n      scheduler (`EulerDiscreteScheduler`)\n      guider (`ClassifierFreeGuidance`)\n      unet (`UNet2DConditionModel`)\n\n<span class="hljs-title">  Sub-Blocks:</span>\n    [<span class="hljs-number">0</span>] before_denoiser (StableDiffusionXLLoopBeforeDenoiser)\n<span class="hljs-title">       Description:</span> step within the denoising loop that prepare the latent input for the denoiser. This block should be used to compose the `sub_blocks` attribute of a `LoopSequentialPipelineBlocks` object (e.g. `StableDiffusionXLDenoiseLoopWrapper`)\n\n    [<span class="hljs-number">1</span>] denoiser (StableDiffusionXLLoopDenoiser)\n<span class="hljs-title">       Description:</span> Step within the denoising loop that denoise the latents with guidance. This block should be used to compose the `sub_blocks` attribute of a `LoopSequentialPipelineBlocks` object (e.g. `StableDiffusionXLDenoiseLoopWrapper`)\n\n    [<span class="hljs-number">2</span>] after_denoiser (StableDiffusionXLLoopAfterDenoiser)\n<span class="hljs-title">       Description:</span> step within the denoising loop that update the latents. This block should be used to compose the `sub_blocks` attribute of a `LoopSequentialPipelineBlocks` object (e.g. `StableDiffusionXLDenoiseLoopWrapper`)\n\n)',wrap:!1}}),H=new Z({props:{title:"Build a Working Pipeline Structure",local:"build-a-working-pipeline-structure",headingTag:"h3"}}),D=new j({props:{code:"JTIzJTIwQ29weSUyMGV4aXN0aW5nJTIwYmxvY2tzJTIwYXMlMjBwbGFjZWhvbGRlcnMlMEFjbGFzcyUyMFNEWExEaWZmRGlmZlByZXBhcmVMYXRlbnRzU3RlcChQaXBlbGluZUJsb2NrKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvcGllZCUyMGZyb20lMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQcmVwYXJlTGF0ZW50c1N0ZXAlMjAtJTIwd2lsbCUyMG1vZGlmeSUyMGxhdGVyJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTIwc2FtZSUyMGltcGxlbWVudGF0aW9uJTIwYXMlMjBTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQcmVwYXJlTGF0ZW50c1N0ZXAlMEElMEFjbGFzcyUyMFNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlcihQaXBlbGluZUJsb2NrKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNvcGllZCUyMGZyb20lMjBTdGFibGVEaWZmdXNpb25YTExvb3BCZWZvcmVEZW5vaXNlciUyMC0lMjB3aWxsJTIwbW9kaWZ5JTIwbGF0ZXIlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjBzYW1lJTIwaW1wbGVtZW50YXRpb24lMjBhcyUyMFN0YWJsZURpZmZ1c2lvblhMTG9vcEJlZm9yZURlbm9pc2Vy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Copy existing blocks as placeholders</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffPrepareLatentsStep</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLImg2ImgPrepareLatentsStep - will modify later&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># ... same implementation as StableDiffusionXLImg2ImgPrepareLatentsStep</span>
<span class="hljs-meta">... </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffLoopBeforeDenoiser</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Copied from StableDiffusionXLLoopBeforeDenoiser - will modify later&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># ... same implementation as StableDiffusionXLLoopBeforeDenoiser</span>`,wrap:!1}}),L=new j({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcChTdGFibGVEaWZmdXNpb25YTERlbm9pc2VMb29wV3JhcHBlciklM0ElMEElMjAlMjAlMjAlMjBibG9ja19jbGFzc2VzJTIwJTNEJTIwJTVCU0RYTERpZmZEaWZmTG9vcEJlZm9yZURlbm9pc2VyJTJDJTIwU3RhYmxlRGlmZnVzaW9uWExMb29wRGVub2lzZXIlMkMlMjBTdGFibGVEaWZmdXNpb25YTExvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
<span class="hljs-meta">... </span>    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLLoopDenoiser, StableDiffusionXLLoopAfterDenoiser]
<span class="hljs-meta">... </span>    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]`,wrap:!1}}),P=new j({props:{code:"RElGRkRJRkZfQkxPQ0tTJTIwJTNEJTIwSU1BR0UySU1BR0VfQkxPQ0tTLmNvcHkoKSUwQURJRkZESUZGX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9CTE9DS1MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwU0RYTERpZmZEaWZmRGVub2lzZVN0ZXAlMEElMEFkZF9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9CTE9DS1MpJTBBcHJpbnQoZGRfYmxvY2tzKSUwQSUyMyUyMEF0JTIwdGhpcyUyMHBvaW50JTJDJTIwdGhlJTIwcGlwZWxpbmUlMjB3b3JrcyUyMGV4YWN0bHklMjBsaWtlJTIwaW1nMmltZyUyMHNpbmNlJTIwb3VyJTIwYmxvY2tzJTIwYXJlJTIwanVzdCUyMGNvcGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffDenoiseStep
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_BLOCKS)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dd_blocks)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># At this point, the pipeline works exactly like img2img since our blocks are just copies</span>`,wrap:!1}}),K=new Z({props:{title:"Set up an example",local:"set-up-an-example",headingTag:"h3"}}),ll=new j({props:{code:"ZGRfcGlwZWxpbmUlMjAlM0QlMjBkZF9ibG9ja3MuaW5pdF9waXBlbGluZSglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkZF9waXBlbGluZS5sb2FkX2RlZmF1bHRfY29tcG9uZW5ldHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWRkX3BpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline.load_default_componenets(torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),tl=new j({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk96enlHVCUyRnRlc3RpbmctcmVzb3VyY2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmZXJlbnRpYWwlMkYyMDI0MDMyOTIxMTEyOV80MDI0OTExOTMwLnBuZyUzRmRvd25sb2FkJTNEdHJ1ZSUyMiklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGZ3JhZGllbnRfbWFzay5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTIwJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdyZWVuJTIwcGVhciUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmJsdXJyeSUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZGRfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZGlmZmRpZmZfbWFwJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIlMEEpJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyZGlmZmRpZmZfb3V0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>) 
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dd_pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    diffdiff_map=mask,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    output=<span class="hljs-string">&quot;images&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;diffdiff_out.png&quot;</span>)`,wrap:!1}}),al=new Z({props:{title:"implement your custom logic and test incrementally",local:"implement-your-custom-logic-and-test-incrementally",headingTag:"h3"}}),I=new zt({props:{$$slots:{default:[sa]},$$scope:{ctx:h}}}),C=new zt({props:{$$slots:{default:[aa]},$$scope:{ctx:h}}}),Jl=new j({props:{code:"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",highlighted:`class SDXLDiffDiffPrepareLatentsStep(PipelineBlock):
    @property
    def expected_components(self) -&gt; List[ComponentSpec]:
        return [
            ComponentSpec(&quot;vae&quot;, AutoencoderKL),
            ComponentSpec(&quot;scheduler&quot;, EulerDiscreteScheduler),
<span class="hljs-addition">+           ComponentSpec(&quot;mask_processor&quot;, VaeImageProcessor, config=FrozenDict({&quot;do_normalize&quot;: False, &quot;do_convert_grayscale&quot;: True}))</span>
        ]

    @property
    def inputs(self) -&gt; List[Tuple[str, Any]]:
        return [
<span class="hljs-addition">+           InputParam(&quot;diffdiff_map&quot;, required=True),</span>
        ]

    @property
    def intermediate_inputs(self) -&gt; List[InputParam]:
        return [
            InputParam(&quot;generator&quot;),
<span class="hljs-deletion">-           InputParam(&quot;latent_timestep&quot;, required=True, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;timesteps&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;num_inference_steps&quot;, type_hint=int),</span>
        ]

    @property
    def intermediate_outputs(self) -&gt; List[OutputParam]:
        return [
<span class="hljs-addition">+           OutputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           OutputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, state: PipelineState):
        # ... existing logic ...
<span class="hljs-addition">+       # Process change map and create masks</span>
<span class="hljs-addition">+       diffdiff_map = components.mask_processor.preprocess(block_state.diffdiff_map, height=latent_height, width=latent_width)</span>
<span class="hljs-addition">+       thresholds = torch.arange(block_state.num_inference_steps, dtype=diffdiff_map.dtype) / block_state.num_inference_steps</span>
<span class="hljs-addition">+       block_state.diffdiff_masks = diffdiff_map &gt; (thresholds + (block_state.denoising_start or 0))</span>
<span class="hljs-addition">+       block_state.original_latents = block_state.latents</span>`,wrap:!1}}),dl=new j({props:{code:"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",highlighted:`class SDXLDiffDiffLoopBeforeDenoiser(PipelineBlock):
    @property
    def description(self) -&gt; str:
        return (
            &quot;Step within the denoising loop for differential diffusion that prepare the latent input for the denoiser&quot;
        )

<span class="hljs-addition">+   @property</span>
<span class="hljs-addition">+   def inputs(self) -&gt; List[Tuple[str, Any]]:</span>
<span class="hljs-addition">+       return [</span>
<span class="hljs-addition">+           InputParam(&quot;denoising_start&quot;),</span>
<span class="hljs-addition">+       ]</span>

    @property
    def intermediate_inputs(self) -&gt; List[str]:
        return [
            InputParam(&quot;latents&quot;, required=True, type_hint=torch.Tensor),
<span class="hljs-addition">+           InputParam(&quot;original_latents&quot;, type_hint=torch.Tensor),</span>
<span class="hljs-addition">+           InputParam(&quot;diffdiff_masks&quot;, type_hint=torch.Tensor),</span>
        ]

    def __call__(self, components, block_state, i, t):
<span class="hljs-addition">+       # Apply differential diffusion logic</span>
<span class="hljs-addition">+       if i == 0 and block_state.denoising_start is None:</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[:1]</span>
<span class="hljs-addition">+       else:</span>
<span class="hljs-addition">+           block_state.mask = block_state.diffdiff_masks[i].unsqueeze(0).unsqueeze(1)</span>
<span class="hljs-addition">+           block_state.latents = block_state.original_latents[i] * block_state.mask + block_state.latents * (1 - block_state.mask)</span>
        
        # ... rest of existing logic ...`,wrap:!1}}),yl=new j({props:{code:"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",highlighted:`&gt;&gt; dd_pipeline
SequentialPipelineBlocks(
  Class: ModularPipelineBlocks

  Description: 


  Components:
      text_encoder (\`CLIPTextModel\`)
      text_encoder_2 (\`CLIPTextModelWithProjection\`)
      tokenizer (\`CLIPTokenizer\`)
      tokenizer_2 (\`CLIPTokenizer\`)
      guider (\`ClassifierFreeGuidance\`)
      vae (\`AutoencoderKL\`)
      image_processor (\`VaeImageProcessor\`)
      scheduler (\`EulerDiscreteScheduler\`)
      mask_processor (\`VaeImageProcessor\`)
      unet (\`UNet2DConditionModel\`)

  Configs:
      force_zeros_for_empty_prompt (default: <span class="hljs-literal">True</span>)
      requires_aesthetics_score (default: <span class="hljs-literal">False</span>)

  Blocks:
    [<span class="hljs-number">0</span>] text_encoder (StableDiffusionXLTextEncoderStep)
       Description: Text Encoder step that generate text_embeddings to guide the image generation

    [<span class="hljs-number">1</span>] image_encoder (StableDiffusionXLVaeEncoderStep)
       Description: Vae Encoder step that encode the <span class="hljs-built_in">input</span> image into a latent representation

    [<span class="hljs-number">2</span>] <span class="hljs-built_in">input</span> (StableDiffusionXLInputStep)
       Description: Input processing step that:
                     <span class="hljs-number">1.</span> Determines \`batch_size\` <span class="hljs-keyword">and</span> \`dtype\` based on \`prompt_embeds\`
                     <span class="hljs-number">2.</span> Adjusts <span class="hljs-built_in">input</span> tensor shapes based on \`batch_size\` (number of prompts) <span class="hljs-keyword">and</span> \`num_images_per_prompt\`
                   
                   All <span class="hljs-built_in">input</span> tensors are expected to have either batch_size=<span class="hljs-number">1</span> <span class="hljs-keyword">or</span> <span class="hljs-keyword">match</span> the batch_size
                   of prompt_embeds. The tensors will be duplicated across the batch dimension to
                   have a final batch_size of batch_size * num_images_per_prompt.

    [<span class="hljs-number">3</span>] set_timesteps (StableDiffusionXLSetTimestepsStep)
       Description: Step that sets the schedule<span class="hljs-string">r&#x27;s timesteps for inference

    [4] prepare_latents (SDXLDiffDiffPrepareLatentsStep)
       Description: Step that prepares the latents for the differential diffusion generation process

    [5] prepare_add_cond (StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep)
       Description: Step that prepares the additional conditioning for the image-to-image/inpainting generation process

    [6] denoise (SDXLDiffDiffDenoiseStep)
       Description: Pipeline block that iteratively denoise the latents over \`timesteps\`. The specific steps with each iteration can be customized with \`sub_blocks\` attributes

    [7] decode (StableDiffusionXLDecodeStep)
       Description: Step that decodes the denoised latents into images

)</span>`,wrap:!1}}),rl=new Z({props:{title:"Adding IP-adapter",local:"adding-ip-adapter",headingTag:"h2"}}),hl=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLmVuY29kZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQWlwX2FkYXB0ZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.encoders <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep
<span class="hljs-meta">&gt;&gt;&gt; </span>ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()`,wrap:!1}}),Zl=new j({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrJTJDJTIwMCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)',wrap:!1}}),Cl=new j({props:{code:"cHJpbnQoZGRfYmxvY2tzKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dd_blocks)',wrap:!1}}),Rl=new j({props:{code:"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",highlighted:`SequentialPipelineBlocks(
<span class="hljs-title">  Class:</span> ModularPipelineBlocks

  ====================================================================================================
  This pipeline contains blocks that are selected at runtime based on inputs.
<span class="hljs-title">  Trigger Inputs:</span> {&#x27;ip_adapter_image&#x27;}
  Use \`get_execution_blocks()\` with input names to see selected blocks (e.g. \`get_execution_blocks(&#x27;ip_adapter_image&#x27;)\`).
  ====================================================================================================


<span class="hljs-title">  Description:</span> 


<span class="hljs-title">  Components:</span>
      image_encoder (\`CLIPVisionModelWithProjection\`)
      feature_extractor (\`CLIPImageProcessor\`)
      unet (\`UNet2DConditionModel\`)
      guider (\`ClassifierFreeGuidance\`)
      text_encoder (\`CLIPTextModel\`)
      text_encoder_2 (\`CLIPTextModelWithProjection\`)
      tokenizer (\`CLIPTokenizer\`)
      tokenizer_2 (\`CLIPTokenizer\`)
      vae (\`AutoencoderKL\`)
      image_processor (\`VaeImageProcessor\`)
      scheduler (\`EulerDiscreteScheduler\`)
      mask_processor (\`VaeImageProcessor\`)

<span class="hljs-title">  Configs:</span>
<span class="hljs-title">      force_zeros_for_empty_prompt (default:</span> <span class="hljs-literal">True</span>)
<span class="hljs-title">      requires_aesthetics_score (default:</span> <span class="hljs-literal">False</span>)

<span class="hljs-title">  Blocks:</span>
    [<span class="hljs-number">0</span>] ip_adapter (StableDiffusionXLAutoIPAdapterStep)
<span class="hljs-title">       Description:</span> Run IP Adapter step if \`ip_adapter_image\` is provided.

    [<span class="hljs-number">1</span>] text_encoder (StableDiffusionXLTextEncoderStep)
<span class="hljs-title">       Description:</span> Text Encoder step that generate text_embeddings to guide the image generation

    [<span class="hljs-number">2</span>] image_encoder (StableDiffusionXLVaeEncoderStep)
<span class="hljs-title">       Description:</span> Vae Encoder step that encode the input image into a latent representation

    [<span class="hljs-number">3</span>] input (StableDiffusionXLInputStep)
<span class="hljs-title">       Description: Input processing step that:</span>
                     <span class="hljs-number">1</span>. Determines \`batch_size\` <span class="hljs-literal">and</span> \`dtype\` based on \`prompt_embeds\`
                     <span class="hljs-number">2</span>. Adjusts input tensor shapes based on \`batch_size\` (number of prompts) <span class="hljs-literal">and</span> \`num_images_per_prompt\`
                   
                   All input tensors are expected to have either batch_size=<span class="hljs-number">1</span> <span class="hljs-literal">or</span> match the batch_size
                   of prompt_embeds. The tensors will be duplicated across the batch dimension to
                   have a final batch_size of batch_size * num_images_per_prompt.

    [<span class="hljs-number">4</span>] set_timesteps (StableDiffusionXLSetTimestepsStep)
<span class="hljs-title">       Description:</span> Step that sets the scheduler&#x27;s timesteps for inference

    [<span class="hljs-number">5</span>] prepare_latents (SDXLDiffDiffPrepareLatentsStep)
<span class="hljs-title">       Description:</span> Step that prepares the latents for the differential diffusion generation process

    [<span class="hljs-number">6</span>] prepare_add_cond (StableDiffusionXLImg2ImgPrepareAdditionalConditioningStep)
<span class="hljs-title">       Description:</span> Step that prepares the additional conditioning for the image-to-image/inpainting generation process

    [<span class="hljs-number">7</span>] denoise (SDXLDiffDiffDenoiseStep)
<span class="hljs-title">       Description:</span> Pipeline block that iteratively denoise the latents over \`timesteps\`. The specific steps with each iteration can be customized with \`sub_blocks\` attributes

    [<span class="hljs-number">8</span>] decode (StableDiffusionXLDecodeStep)
<span class="hljs-title">       Description:</span> Step that decodes the denoised latents into images

)`,wrap:!1}}),gl=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ip_adapter_block = StableDiffusionXLAutoIPAdapterStep()
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_block, <span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline.load_default_components(torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline.loader.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline.loader.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline = dd_pipeline.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_orange.jpeg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>) 
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dd_pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    ip_adapter_image=ip_adapter_image,
<span class="hljs-meta">... </span>    diffdiff_map=mask,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    output=<span class="hljs-string">&quot;images&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),Xl=new Z({props:{title:"Working with ControlNets",local:"working-with-controlnets",headingTag:"h2"}}),kl=new j({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAoU3RhYmxlRGlmZnVzaW9uWExEZW5vaXNlTG9vcFdyYXBwZXIpJTNBJTBBJTIwJTIwJTIwJTIwYmxvY2tfY2xhc3NlcyUyMCUzRCUyMCU1QlNEWExEaWZmRGlmZkxvb3BCZWZvcmVEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldExvb3BEZW5vaXNlciUyQyUyMFN0YWJsZURpZmZ1c2lvblhMRGVub2lzZUxvb3BBZnRlckRlbm9pc2VyJTVEJTBBJTIwJTIwJTIwJTIwYmxvY2tfbmFtZXMlMjAlM0QlMjAlNUIlMjJiZWZvcmVfZGVub2lzZXIlMjIlMkMlMjAlMjJkZW5vaXNlciUyMiUyQyUyMCUyMmFmdGVyX2Rlbm9pc2VyJTIyJTVEJTBBJTBBY29udHJvbG5ldF9kZW5vaXNlX2Jsb2NrJTIwJTNEJTIwU0RYTERpZmZEaWZmQ29udHJvbE5ldERlbm9pc2VTdGVwKCklMEElMjMlMjBwcmludChjb250cm9sbmV0X2Rlbm9pc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffControlNetDenoiseStep</span>(<span class="hljs-title class_ inherited__">StableDiffusionXLDenoiseLoopWrapper</span>):
<span class="hljs-meta">... </span>    block_classes = [SDXLDiffDiffLoopBeforeDenoiser, StableDiffusionXLControlNetLoopDenoiser, StableDiffusionXLDenoiseLoopAfterDenoiser]
<span class="hljs-meta">... </span>    block_names = [<span class="hljs-string">&quot;before_denoiser&quot;</span>, <span class="hljs-string">&quot;denoiser&quot;</span>, <span class="hljs-string">&quot;after_denoiser&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_denoise_block = SDXLDiffDiffControlNetDenoiseStep()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># print(controlnet_denoise)</span>`,wrap:!1}}),_l=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsLm1vZHVsYXJfYmxvY2tzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvQ29udHJvbE5ldElucHV0U3RlcCUwQWNvbnRyb2xfaW5wdXRfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sTmV0SW5wdXRTdGVwKCklMEFwcmludChjb250cm9sX2lucHV0X2Jsb2NrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks <span class="hljs-keyword">import</span> StableDiffusionXLAutoControlNetInputStep
<span class="hljs-meta">&gt;&gt;&gt; </span>control_input_block = StableDiffusionXLAutoControlNetInputStep()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(control_input_block)`,wrap:!1}}),Sl=new j({props:{code:"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",highlighted:`StableDiffusionXLAutoControlNetInputStep(
  Class: AutoPipelineBlocks

  ====================================================================================================
  This pipeline contains blocks that are selected at runtime based on inputs.
  Trigger Inputs: [&#x27;control_image&#x27;, &#x27;control_mode&#x27;]
  ====================================================================================================


  Description: Controlnet Input step that <span class="hljs-keyword">prepare</span> the controlnet input.
      This <span class="hljs-keyword">is</span> an auto pipeline block that works <span class="hljs-keyword">for</span> both controlnet <span class="hljs-keyword">and</span> controlnet_union.
       (it should be called <span class="hljs-keyword">right</span> before the denoise step) - <span class="hljs-symbol">\`StableDiffusionXLControlNetUnionInputStep\`</span> <span class="hljs-keyword">is</span> called <span class="hljs-keyword">to</span> <span class="hljs-keyword">prepare</span> the controlnet input <span class="hljs-keyword">when</span> <span class="hljs-symbol">\`control_mode\`</span> <span class="hljs-keyword">and</span> <span class="hljs-symbol">\`control_image\`</span> are provided.
       - <span class="hljs-symbol">\`StableDiffusionXLControlNetInputStep\`</span> <span class="hljs-keyword">is</span> called <span class="hljs-keyword">to</span> <span class="hljs-keyword">prepare</span> the controlnet input <span class="hljs-keyword">when</span> <span class="hljs-symbol">\`control_image\`</span> <span class="hljs-keyword">is</span> provided. - <span class="hljs-keyword">if</span> neither <span class="hljs-symbol">\`control_mode\`</span> nor <span class="hljs-symbol">\`control_image\`</span> <span class="hljs-keyword">is</span> provided, step will be skipped.


  Components:
      controlnet (<span class="hljs-symbol">\`ControlNetUnionModel\`</span>)
      control_image_processor (<span class="hljs-symbol">\`VaeImageProcessor\`</span>)

  Sub-Blocks:
    • controlnet_union [<span class="hljs-keyword">trigger</span>: control_mode] (StableDiffusionXLControlNetUnionInputStep)
       Description: step that prepares inputs <span class="hljs-keyword">for</span> the ControlNetUnion model

    • controlnet [<span class="hljs-keyword">trigger</span>: control_image] (StableDiffusionXLControlNetInputStep)
       Description: step that <span class="hljs-keyword">prepare</span> inputs <span class="hljs-keyword">for</span> controlnet

)
`,wrap:!1}}),vl=new j({props:{code:"ZGRfYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmNvbnRyb2xuZXRfaW5wdXQlMjIlMkMlMjBjb250cm9sX2lucHV0X2Jsb2NrJTJDJTIwNyklMEFkZF9ibG9ja3Muc3ViX2Jsb2NrcyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBjb250cm9sbmV0X2Rlbm9pc2VfYmxvY2slMEElMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29sbGVjdGlvbiUzRCUyMmRpZmZkaWZmJTIyKSUwQWRkX3BpcGVsaW5lLmxvYWRfZGVmYXVsdF9jb21wb25lbnRzKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX3BpcGVsaW5lLnRvKGRldmljZSklMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmRpZmZfdG9tYXRvX2Nhbm55LmpwZWclMjIpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk96enlHVCUyRnRlc3RpbmctcmVzb3VyY2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmZXJlbnRpYWwlMkYyMDI0MDMyOTIxMTEyOV80MDI0OTExOTMwLnBuZyUzRmRvd25sb2FkJTNEdHJ1ZSUyMiklMEFtYXNrJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZPenp5R1QlMkZ0ZXN0aW5nLXJlc291cmNlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZmVyZW50aWFsJTJGZ3JhZGllbnRfbWFzay5wbmclM0Zkb3dubG9hZCUzRHRydWUlMjIpJTIwJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdyZWVuJTIwcGVhciUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmJsdXJyeSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0RkZXZpY2UpLm1hbnVhbF9zZWVkKDQyKSUwQSUwQWltYWdlJTIwJTNEJTIwZGRfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGRpZmZkaWZmX21hcCUzRG1hc2slMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTNEJTIyaW1hZ2VzJTIyJTBBKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dd_blocks.sub_blocks.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>, control_input_block, <span class="hljs-number">7</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_denoise_block
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline = dd_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline.load_default_components(torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline = dd_pipeline.to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/diffdiff_tomato_canny.jpeg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/20240329211129_4024911930.png?download=true&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/OzzyGT/testing-resources/resolve/main/differential/gradient_mask.png?download=true&quot;</span>) 
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a green pear&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;blurry&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=device).manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dd_pipeline(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
<span class="hljs-meta">... </span>    diffdiff_map=mask,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    output=<span class="hljs-string">&quot;images&quot;</span>
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),zl=new j({props:{code:"Y2xhc3MlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAoQXV0b1BpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMGJsb2NrX2NsYXNzZXMlMjAlM0QlMjAlNUJTRFhMRGlmZkRpZmZDb250cm9sTmV0RGVub2lzZVN0ZXAlMkMlMjBTRFhMRGlmZkRpZmZEZW5vaXNlU3RlcCU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX25hbWVzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9kZW5vaXNlJTIyJTJDJTIwJTIyZGVub2lzZSUyMiU1RCUwQSUyMCUyMCUyMCUyMGJsb2NrX3RyaWdnZXJfaW5wdXRzJTIwJTNEJTIwJTVCJTIyY29udHJvbG5ldF9jb25kJTIyJTJDJTIwTm9uZSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">SDXLDiffDiffAutoDenoiseStep</span>(<span class="hljs-title class_ inherited__">AutoPipelineBlocks</span>):
<span class="hljs-meta">... </span>    block_classes = [SDXLDiffDiffControlNetDenoiseStep, SDXLDiffDiffDenoiseStep]
<span class="hljs-meta">... </span>    block_names = [<span class="hljs-string">&quot;controlnet_denoise&quot;</span>, <span class="hljs-string">&quot;denoise&quot;</span>]
<span class="hljs-meta">... </span>    block_trigger_inputs = [<span class="hljs-string">&quot;controlnet_cond&quot;</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),G=new zt({props:{$$slots:{default:[na]},$$scope:{ctx:h}}}),Dl=new j({props:{code:"RElGRkRJRkZfQVVUT19CTE9DS1MlMjAlM0QlMjBJTUFHRTJJTUFHRV9CTE9DS1MuY29weSgpJTBBRElGRkRJRkZfQVVUT19CTE9DS1MlNUIlMjJwcmVwYXJlX2xhdGVudHMlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZQcmVwYXJlTGF0ZW50c1N0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUyU1QiUyMnNldF90aW1lc3RlcHMlMjIlNUQlMEFESUZGRElGRl9BVVRPX0JMT0NLUyU1QiUyMmRlbm9pc2UlMjIlNUQlMjAlM0QlMjBTRFhMRGlmZkRpZmZBdXRvRGVub2lzZVN0ZXAlMEFESUZGRElGRl9BVVRPX0JMT0NLUy5pbnNlcnQoJTIyaXBfYWRhcHRlciUyMiUyQyUyMFN0YWJsZURpZmZ1c2lvblhMQXV0b0lQQWRhcHRlclN0ZXAlMkMlMjAwKSUwQURJRkZESUZGX0FVVE9fQkxPQ0tTLmluc2VydCglMjJjb250cm9sbmV0X2lucHV0JTIyJTJDU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0QXV0b0lucHV0JTJDJTIwNyklMEElMEFwcmludChESUZGRElGRl9BVVRPX0JMT0NLUyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_AUTO_BLOCKS = IMAGE2IMAGE_BLOCKS.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = SDXLDiffDiffPrepareLatentsStep
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>] = TEXT2IMAGE_BLOCKS[<span class="hljs-string">&quot;set_timesteps&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_AUTO_BLOCKS[<span class="hljs-string">&quot;denoise&quot;</span>] = SDXLDiffDiffAutoDenoiseStep
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>DIFFDIFF_AUTO_BLOCKS.insert(<span class="hljs-string">&quot;controlnet_input&quot;</span>,StableDiffusionXLControlNetAutoInput, <span class="hljs-number">7</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(DIFFDIFF_AUTO_BLOCKS)`,wrap:!1}}),Ll=new j({props:{code:"ZGRfYXV0b19ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChESUZGRElGRl9BVVRPX0JMT0NLUyklMEFkZF9waXBlbGluZSUyMCUzRCUyMGRkX2F1dG9fYmxvY2tzLmluaXRfcGlwZWxpbmUoLi4uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dd_auto_blocks = SequentialPipelineBlocks.from_blocks_dict(DIFFDIFF_AUTO_BLOCKS)
<span class="hljs-meta">&gt;&gt;&gt; </span>dd_pipeline = dd_auto_blocks.init_pipeline(...)`,wrap:!1}}),ql=new Z({props:{title:"Creating a Modular Repo",local:"creating-a-modular-repo",headingTag:"h2"}}),Ol=new j({props:{code:"ZGRfcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRnRlc3RfbW9kdWxhcl9kb2MlMjIlMkMlMjBwdXNoX3RvX2h1YiUzRFRydWUp",highlighted:'dd_pipeline.save_pretrained(<span class="hljs-string">&quot;YiYiXu/test_modular_doc&quot;</span>, push_to_hub=<span class="hljs-literal">True</span>)',wrap:!1}}),ee=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyME1vZHVsYXJQaXBlbGluZSUyQyUyMENvbXBvbmVudHNNYW5hZ2VyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMEElMEFjb21wb25lbnRzJTIwJTNEJTIwQ29tcG9uZW50c01hbmFnZXIoKSUwQSUwQWRpZmZkaWZmX3BpcGVsaW5lJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwY29tcG9uZW50c19tYW5hZ2VyJTNEY29tcG9uZW50cyUyQyUyMGNvbGxlY3Rpb24lM0QlMjJkaWZmZGlmZiUyMiklMEFkaWZmZGlmZl9waXBlbGluZS5sb2FkX2RlZmF1bHRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBY29tcG9uZW50cy5lbmFibGVfYXV0b19jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>components = ComponentsManager()
<span class="hljs-meta">&gt;&gt;&gt; </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>diffdiff_pipeline = ModularPipeline.from_pretrained(repo_id, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components, collection=<span class="hljs-string">&quot;diffdiff&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>diffdiff_pipeline.load_default_components(torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>components.enable_auto_cpu_offload()`,wrap:!1}}),se=new Z({props:{title:"deploy a mellon node",local:"deploy-a-mellon-node",headingTag:"h2"}}),ne=new ea({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/end_to_end_guide.md"}}),{c(){o=M("meta"),r=a(),y=M("p"),w=a(),c(f.$$.fragment),b=a(),c(u.$$.fragment),ie=a(),R=M("p"),R.textContent=xt,pe=a(),B=M("p"),B.textContent=Dt,oe=a(),g=M("ol"),g.innerHTML=$t,ce=a(),X=M("p"),X.textContent=Lt,Je=a(),c(N.$$.fragment),me=a(),c(V.$$.fragment),de=a(),E=M("p"),E.innerHTML=qt,Te=a(),c(W.$$.fragment),Ue=a(),A=M("p"),A.innerHTML=Pt,ye=a(),c(k.$$.fragment),je=a(),c(Q.$$.fragment),we=a(),_=M("p"),_.innerHTML=Kt,re=a(),S=M("p"),S.textContent=Ot,be=a(),Y=M("ol"),Y.innerHTML=ls,ue=a(),v=M("p"),v.innerHTML=es,he=a(),F=M("p"),F.textContent=ts,fe=a(),z=M("p"),z.innerHTML=ss,Ze=a(),c(H.$$.fragment),Ie=a(),x=M("p"),x.textContent=as,Ce=a(),c(D.$$.fragment),Ge=a(),$=M("p"),$.innerHTML=ns,Re=a(),c(L.$$.fragment),Be=a(),q=M("p"),q.textContent=Ms,ge=a(),c(P.$$.fragment),Xe=a(),c(K.$$.fragment),Ne=a(),O=M("p"),O.textContent=is,Ve=a(),c(ll.$$.fragment),Ee=a(),el=M("p"),el.textContent=ps,We=a(),c(tl.$$.fragment),Ae=a(),sl=M("p"),sl.innerHTML=os,ke=a(),c(al.$$.fragment),Qe=a(),nl=M("p"),nl.textContent=cs,_e=a(),Ml=M("p"),Ml.innerHTML=Js,Se=a(),il=M("ul"),il.innerHTML=ms,Ye=a(),c(I.$$.fragment),ve=a(),pl=M("p"),pl.innerHTML=ds,Fe=a(),c(C.$$.fragment),ze=a(),ol=M("p"),ol.textContent=Ts,He=a(),cl=M("p"),cl.innerHTML=Us,xe=a(),c(Jl.$$.fragment),De=a(),ml=M("p"),ml.innerHTML=ys,$e=a(),c(dl.$$.fragment),Le=a(),Tl=M("p"),Tl.textContent=js,qe=a(),Ul=M("p"),Ul.textContent=ws,Pe=a(),c(yl.$$.fragment),Ke=a(),jl=M("p"),jl.textContent=rs,Oe=a(),wl=M("p"),wl.innerHTML=bs,lt=a(),c(rl.$$.fragment),et=a(),bl=M("p"),bl.innerHTML=us,tt=a(),ul=M("p"),ul.innerHTML=hs,st=a(),c(hl.$$.fragment),at=a(),fl=M("p"),fl.innerHTML=fs,nt=a(),c(Zl.$$.fragment),Mt=a(),Il=M("p"),Il.textContent=Zs,it=a(),c(Cl.$$.fragment),pt=a(),Gl=M("p"),Gl.innerHTML=Is,ot=a(),c(Rl.$$.fragment),ct=a(),Bl=M("p"),Bl.textContent=Cs,Jt=a(),c(gl.$$.fragment),mt=a(),c(Xl.$$.fragment),dt=a(),Nl=M("p"),Nl.textContent=Gs,Tt=a(),Vl=M("ol"),Vl.innerHTML=Rs,Ut=a(),El=M("p"),El.textContent=Bs,yt=a(),Wl=M("p"),Wl.textContent=gs,jt=a(),Al=M("p"),Al.textContent=Xs,wt=a(),c(kl.$$.fragment),rt=a(),Ql=M("p"),Ql.innerHTML=Ns,bt=a(),c(_l.$$.fragment),ut=a(),c(Sl.$$.fragment),ht=a(),Yl=M("p"),Yl.innerHTML=Vs,ft=a(),c(vl.$$.fragment),Zt=a(),Fl=M("p"),Fl.innerHTML=Es,It=a(),c(zl.$$.fragment),Ct=a(),Hl=M("p"),Hl.innerHTML=Ws,Gt=a(),c(G.$$.fragment),Rt=a(),xl=M("p"),xl.textContent=As,Bt=a(),c(Dl.$$.fragment),gt=a(),$l=M("p"),$l.textContent=ks,Xt=a(),c(Ll.$$.fragment),Nt=a(),c(ql.$$.fragment),Vt=a(),Pl=M("p"),Pl.innerHTML=Qs,Et=a(),Kl=M("p"),Kl.innerHTML=_s,Wt=a(),c(Ol.$$.fragment),At=a(),le=M("p"),le.textContent=Ss,kt=a(),c(ee.$$.fragment),Qt=a(),te=M("p"),te.textContent=Ys,_t=a(),c(se.$$.fragment),St=a(),ae=M("p"),ae.textContent=vs,Yt=a(),c(ne.$$.fragment),vt=a(),Me=M("p"),this.h()},l(l){const e=Os("svelte-u9bgzb",document.head);o=i(e,"META",{name:!0,content:!0}),e.forEach(t),r=n(l),y=i(l,"P",{}),Ds(y).forEach(t),w=n(l),J(f.$$.fragment,l),b=n(l),J(u.$$.fragment,l),ie=n(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-ah51rm"&&(R.textContent=xt),pe=n(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-q8pbl8"&&(B.textContent=Dt),oe=n(l),g=i(l,"OL",{"data-svelte-h":!0}),p(g)!=="svelte-ic8w5h"&&(g.innerHTML=$t),ce=n(l),X=i(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-vd2vm7"&&(X.textContent=Lt),Je=n(l),J(N.$$.fragment,l),me=n(l),J(V.$$.fragment,l),de=n(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1ckzp7j"&&(E.innerHTML=qt),Te=n(l),J(W.$$.fragment,l),Ue=n(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-16iflyl"&&(A.innerHTML=Pt),ye=n(l),J(k.$$.fragment,l),je=n(l),J(Q.$$.fragment,l),we=n(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1jaxdnk"&&(_.innerHTML=Kt),re=n(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-16j8f35"&&(S.textContent=Ot),be=n(l),Y=i(l,"OL",{"data-svelte-h":!0}),p(Y)!=="svelte-9mzypu"&&(Y.innerHTML=ls),ue=n(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1njl7f7"&&(v.innerHTML=es),he=n(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-6yjvng"&&(F.textContent=ts),fe=n(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-19xrt2z"&&(z.innerHTML=ss),Ze=n(l),J(H.$$.fragment,l),Ie=n(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-htmxyh"&&(x.textContent=as),Ce=n(l),J(D.$$.fragment,l),Ge=n(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1h9rp65"&&($.innerHTML=ns),Re=n(l),J(L.$$.fragment,l),Be=n(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1kjlg3r"&&(q.textContent=Ms),ge=n(l),J(P.$$.fragment,l),Xe=n(l),J(K.$$.fragment,l),Ne=n(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-15obvlk"&&(O.textContent=is),Ve=n(l),J(ll.$$.fragment,l),Ee=n(l),el=i(l,"P",{"data-svelte-h":!0}),p(el)!=="svelte-dx1yg"&&(el.textContent=ps),We=n(l),J(tl.$$.fragment,l),Ae=n(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-11o6vb9"&&(sl.innerHTML=os),ke=n(l),J(al.$$.fragment,l),Qe=n(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-t8s3od"&&(nl.textContent=cs),_e=n(l),Ml=i(l,"P",{"data-svelte-h":!0}),p(Ml)!=="svelte-me5buj"&&(Ml.innerHTML=Js),Se=n(l),il=i(l,"UL",{"data-svelte-h":!0}),p(il)!=="svelte-zyaxw1"&&(il.innerHTML=ms),Ye=n(l),J(I.$$.fragment,l),ve=n(l),pl=i(l,"P",{"data-svelte-h":!0}),p(pl)!=="svelte-11q7ywa"&&(pl.innerHTML=ds),Fe=n(l),J(C.$$.fragment,l),ze=n(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-8lo2o8"&&(ol.textContent=Ts),He=n(l),cl=i(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-192zqht"&&(cl.innerHTML=Us),xe=n(l),J(Jl.$$.fragment,l),De=n(l),ml=i(l,"P",{"data-svelte-h":!0}),p(ml)!=="svelte-1gzuzik"&&(ml.innerHTML=ys),$e=n(l),J(dl.$$.fragment,l),Le=n(l),Tl=i(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-1c0d30o"&&(Tl.textContent=js),qe=n(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-o3bfrg"&&(Ul.textContent=ws),Pe=n(l),J(yl.$$.fragment,l),Ke=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-wdqdqg"&&(jl.textContent=rs),Oe=n(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-5a63qd"&&(wl.innerHTML=bs),lt=n(l),J(rl.$$.fragment,l),et=n(l),bl=i(l,"P",{"data-svelte-h":!0}),p(bl)!=="svelte-16errsw"&&(bl.innerHTML=us),tt=n(l),ul=i(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-dwbzmn"&&(ul.innerHTML=hs),st=n(l),J(hl.$$.fragment,l),at=n(l),fl=i(l,"P",{"data-svelte-h":!0}),p(fl)!=="svelte-c1au0n"&&(fl.innerHTML=fs),nt=n(l),J(Zl.$$.fragment,l),Mt=n(l),Il=i(l,"P",{"data-svelte-h":!0}),p(Il)!=="svelte-ufmqyk"&&(Il.textContent=Zs),it=n(l),J(Cl.$$.fragment,l),pt=n(l),Gl=i(l,"P",{"data-svelte-h":!0}),p(Gl)!=="svelte-hmexoo"&&(Gl.innerHTML=Is),ot=n(l),J(Rl.$$.fragment,l),ct=n(l),Bl=i(l,"P",{"data-svelte-h":!0}),p(Bl)!=="svelte-42nr41"&&(Bl.textContent=Cs),Jt=n(l),J(gl.$$.fragment,l),mt=n(l),J(Xl.$$.fragment,l),dt=n(l),Nl=i(l,"P",{"data-svelte-h":!0}),p(Nl)!=="svelte-ozranp"&&(Nl.textContent=Gs),Tt=n(l),Vl=i(l,"OL",{"data-svelte-h":!0}),p(Vl)!=="svelte-1a4y58l"&&(Vl.innerHTML=Rs),Ut=n(l),El=i(l,"P",{"data-svelte-h":!0}),p(El)!=="svelte-cwx54i"&&(El.textContent=Bs),yt=n(l),Wl=i(l,"P",{"data-svelte-h":!0}),p(Wl)!=="svelte-15k9fsb"&&(Wl.textContent=gs),jt=n(l),Al=i(l,"P",{"data-svelte-h":!0}),p(Al)!=="svelte-1bqr5ww"&&(Al.textContent=Xs),wt=n(l),J(kl.$$.fragment,l),rt=n(l),Ql=i(l,"P",{"data-svelte-h":!0}),p(Ql)!=="svelte-1jp82cg"&&(Ql.innerHTML=Ns),bt=n(l),J(_l.$$.fragment,l),ut=n(l),J(Sl.$$.fragment,l),ht=n(l),Yl=i(l,"P",{"data-svelte-h":!0}),p(Yl)!=="svelte-1fka27c"&&(Yl.innerHTML=Vs),ft=n(l),J(vl.$$.fragment,l),Zt=n(l),Fl=i(l,"P",{"data-svelte-h":!0}),p(Fl)!=="svelte-1xb1uxq"&&(Fl.innerHTML=Es),It=n(l),J(zl.$$.fragment,l),Ct=n(l),Hl=i(l,"P",{"data-svelte-h":!0}),p(Hl)!=="svelte-d9g24d"&&(Hl.innerHTML=Ws),Gt=n(l),J(G.$$.fragment,l),Rt=n(l),xl=i(l,"P",{"data-svelte-h":!0}),p(xl)!=="svelte-8tic47"&&(xl.textContent=As),Bt=n(l),J(Dl.$$.fragment,l),gt=n(l),$l=i(l,"P",{"data-svelte-h":!0}),p($l)!=="svelte-utdv0m"&&($l.textContent=ks),Xt=n(l),J(Ll.$$.fragment,l),Nt=n(l),J(ql.$$.fragment,l),Vt=n(l),Pl=i(l,"P",{"data-svelte-h":!0}),p(Pl)!=="svelte-16uc9yx"&&(Pl.innerHTML=Qs),Et=n(l),Kl=i(l,"P",{"data-svelte-h":!0}),p(Kl)!=="svelte-ag6wkn"&&(Kl.innerHTML=_s),Wt=n(l),J(Ol.$$.fragment,l),At=n(l),le=i(l,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1n7fos4"&&(le.textContent=Ss),kt=n(l),J(ee.$$.fragment,l),Qt=n(l),te=i(l,"P",{"data-svelte-h":!0}),p(te)!=="svelte-92hmpb"&&(te.textContent=Ys),_t=n(l),J(se.$$.fragment,l),St=n(l),ae=i(l,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1i8wquf"&&(ae.textContent=vs),Yt=n(l),J(ne.$$.fragment,l),vt=n(l),Me=i(l,"P",{}),Ds(Me).forEach(t),this.h()},h(){$s(o,"name","hf:doc:metadata"),$s(o,"content",ia)},m(l,e){la(document.head,o),s(l,r,e),s(l,y,e),s(l,w,e),m(f,l,e),s(l,b,e),m(u,l,e),s(l,ie,e),s(l,R,e),s(l,pe,e),s(l,B,e),s(l,oe,e),s(l,g,e),s(l,ce,e),s(l,X,e),s(l,Je,e),m(N,l,e),s(l,me,e),m(V,l,e),s(l,de,e),s(l,E,e),s(l,Te,e),m(W,l,e),s(l,Ue,e),s(l,A,e),s(l,ye,e),m(k,l,e),s(l,je,e),m(Q,l,e),s(l,we,e),s(l,_,e),s(l,re,e),s(l,S,e),s(l,be,e),s(l,Y,e),s(l,ue,e),s(l,v,e),s(l,he,e),s(l,F,e),s(l,fe,e),s(l,z,e),s(l,Ze,e),m(H,l,e),s(l,Ie,e),s(l,x,e),s(l,Ce,e),m(D,l,e),s(l,Ge,e),s(l,$,e),s(l,Re,e),m(L,l,e),s(l,Be,e),s(l,q,e),s(l,ge,e),m(P,l,e),s(l,Xe,e),m(K,l,e),s(l,Ne,e),s(l,O,e),s(l,Ve,e),m(ll,l,e),s(l,Ee,e),s(l,el,e),s(l,We,e),m(tl,l,e),s(l,Ae,e),s(l,sl,e),s(l,ke,e),m(al,l,e),s(l,Qe,e),s(l,nl,e),s(l,_e,e),s(l,Ml,e),s(l,Se,e),s(l,il,e),s(l,Ye,e),m(I,l,e),s(l,ve,e),s(l,pl,e),s(l,Fe,e),m(C,l,e),s(l,ze,e),s(l,ol,e),s(l,He,e),s(l,cl,e),s(l,xe,e),m(Jl,l,e),s(l,De,e),s(l,ml,e),s(l,$e,e),m(dl,l,e),s(l,Le,e),s(l,Tl,e),s(l,qe,e),s(l,Ul,e),s(l,Pe,e),m(yl,l,e),s(l,Ke,e),s(l,jl,e),s(l,Oe,e),s(l,wl,e),s(l,lt,e),m(rl,l,e),s(l,et,e),s(l,bl,e),s(l,tt,e),s(l,ul,e),s(l,st,e),m(hl,l,e),s(l,at,e),s(l,fl,e),s(l,nt,e),m(Zl,l,e),s(l,Mt,e),s(l,Il,e),s(l,it,e),m(Cl,l,e),s(l,pt,e),s(l,Gl,e),s(l,ot,e),m(Rl,l,e),s(l,ct,e),s(l,Bl,e),s(l,Jt,e),m(gl,l,e),s(l,mt,e),m(Xl,l,e),s(l,dt,e),s(l,Nl,e),s(l,Tt,e),s(l,Vl,e),s(l,Ut,e),s(l,El,e),s(l,yt,e),s(l,Wl,e),s(l,jt,e),s(l,Al,e),s(l,wt,e),m(kl,l,e),s(l,rt,e),s(l,Ql,e),s(l,bt,e),m(_l,l,e),s(l,ut,e),m(Sl,l,e),s(l,ht,e),s(l,Yl,e),s(l,ft,e),m(vl,l,e),s(l,Zt,e),s(l,Fl,e),s(l,It,e),m(zl,l,e),s(l,Ct,e),s(l,Hl,e),s(l,Gt,e),m(G,l,e),s(l,Rt,e),s(l,xl,e),s(l,Bt,e),m(Dl,l,e),s(l,gt,e),s(l,$l,e),s(l,Xt,e),m(Ll,l,e),s(l,Nt,e),m(ql,l,e),s(l,Vt,e),s(l,Pl,e),s(l,Et,e),s(l,Kl,e),s(l,Wt,e),m(Ol,l,e),s(l,At,e),s(l,le,e),s(l,kt,e),m(ee,l,e),s(l,Qt,e),s(l,te,e),s(l,_t,e),m(se,l,e),s(l,St,e),s(l,ae,e),s(l,Yt,e),m(ne,l,e),s(l,vt,e),s(l,Me,e),Ft=!0},p(l,[e]){const Fs={};e&2&&(Fs.$$scope={dirty:e,ctx:l}),u.$set(Fs);const zs={};e&2&&(zs.$$scope={dirty:e,ctx:l}),I.$set(zs);const Hs={};e&2&&(Hs.$$scope={dirty:e,ctx:l}),C.$set(Hs);const xs={};e&2&&(xs.$$scope={dirty:e,ctx:l}),G.$set(xs)},i(l){Ft||(d(f.$$.fragment,l),d(u.$$.fragment,l),d(N.$$.fragment,l),d(V.$$.fragment,l),d(W.$$.fragment,l),d(k.$$.fragment,l),d(Q.$$.fragment,l),d(H.$$.fragment,l),d(D.$$.fragment,l),d(L.$$.fragment,l),d(P.$$.fragment,l),d(K.$$.fragment,l),d(ll.$$.fragment,l),d(tl.$$.fragment,l),d(al.$$.fragment,l),d(I.$$.fragment,l),d(C.$$.fragment,l),d(Jl.$$.fragment,l),d(dl.$$.fragment,l),d(yl.$$.fragment,l),d(rl.$$.fragment,l),d(hl.$$.fragment,l),d(Zl.$$.fragment,l),d(Cl.$$.fragment,l),d(Rl.$$.fragment,l),d(gl.$$.fragment,l),d(Xl.$$.fragment,l),d(kl.$$.fragment,l),d(_l.$$.fragment,l),d(Sl.$$.fragment,l),d(vl.$$.fragment,l),d(zl.$$.fragment,l),d(G.$$.fragment,l),d(Dl.$$.fragment,l),d(Ll.$$.fragment,l),d(ql.$$.fragment,l),d(Ol.$$.fragment,l),d(ee.$$.fragment,l),d(se.$$.fragment,l),d(ne.$$.fragment,l),Ft=!0)},o(l){T(f.$$.fragment,l),T(u.$$.fragment,l),T(N.$$.fragment,l),T(V.$$.fragment,l),T(W.$$.fragment,l),T(k.$$.fragment,l),T(Q.$$.fragment,l),T(H.$$.fragment,l),T(D.$$.fragment,l),T(L.$$.fragment,l),T(P.$$.fragment,l),T(K.$$.fragment,l),T(ll.$$.fragment,l),T(tl.$$.fragment,l),T(al.$$.fragment,l),T(I.$$.fragment,l),T(C.$$.fragment,l),T(Jl.$$.fragment,l),T(dl.$$.fragment,l),T(yl.$$.fragment,l),T(rl.$$.fragment,l),T(hl.$$.fragment,l),T(Zl.$$.fragment,l),T(Cl.$$.fragment,l),T(Rl.$$.fragment,l),T(gl.$$.fragment,l),T(Xl.$$.fragment,l),T(kl.$$.fragment,l),T(_l.$$.fragment,l),T(Sl.$$.fragment,l),T(vl.$$.fragment,l),T(zl.$$.fragment,l),T(G.$$.fragment,l),T(Dl.$$.fragment,l),T(Ll.$$.fragment,l),T(ql.$$.fragment,l),T(Ol.$$.fragment,l),T(ee.$$.fragment,l),T(se.$$.fragment,l),T(ne.$$.fragment,l),Ft=!1},d(l){l&&(t(r),t(y),t(w),t(b),t(ie),t(R),t(pe),t(B),t(oe),t(g),t(ce),t(X),t(Je),t(me),t(de),t(E),t(Te),t(Ue),t(A),t(ye),t(je),t(we),t(_),t(re),t(S),t(be),t(Y),t(ue),t(v),t(he),t(F),t(fe),t(z),t(Ze),t(Ie),t(x),t(Ce),t(Ge),t($),t(Re),t(Be),t(q),t(ge),t(Xe),t(Ne),t(O),t(Ve),t(Ee),t(el),t(We),t(Ae),t(sl),t(ke),t(Qe),t(nl),t(_e),t(Ml),t(Se),t(il),t(Ye),t(ve),t(pl),t(Fe),t(ze),t(ol),t(He),t(cl),t(xe),t(De),t(ml),t($e),t(Le),t(Tl),t(qe),t(Ul),t(Pe),t(Ke),t(jl),t(Oe),t(wl),t(lt),t(et),t(bl),t(tt),t(ul),t(st),t(at),t(fl),t(nt),t(Mt),t(Il),t(it),t(pt),t(Gl),t(ot),t(ct),t(Bl),t(Jt),t(mt),t(dt),t(Nl),t(Tt),t(Vl),t(Ut),t(El),t(yt),t(Wl),t(jt),t(Al),t(wt),t(rt),t(Ql),t(bt),t(ut),t(ht),t(Yl),t(ft),t(Zt),t(Fl),t(It),t(Ct),t(Hl),t(Gt),t(Rt),t(xl),t(Bt),t(gt),t($l),t(Xt),t(Nt),t(Vt),t(Pl),t(Et),t(Kl),t(Wt),t(At),t(le),t(kt),t(Qt),t(te),t(_t),t(St),t(ae),t(Yt),t(vt),t(Me)),t(o),U(f,l),U(u,l),U(N,l),U(V,l),U(W,l),U(k,l),U(Q,l),U(H,l),U(D,l),U(L,l),U(P,l),U(K,l),U(ll,l),U(tl,l),U(al,l),U(I,l),U(C,l),U(Jl,l),U(dl,l),U(yl,l),U(rl,l),U(hl,l),U(Zl,l),U(Cl,l),U(Rl,l),U(gl,l),U(Xl,l),U(kl,l),U(_l,l),U(Sl,l),U(vl,l),U(zl,l),U(G,l),U(Dl,l),U(Ll,l),U(ql,l),U(Ol,l),U(ee,l),U(se,l),U(ne,l)}}}const ia='{"title":"End-to-End Developer Guide: Building with Modular Diffusers","local":"end-to-end-developer-guide-building-with-modular-diffusers","sections":[{"title":"Differential Diffusion Pipeline","local":"differential-diffusion-pipeline","sections":[{"title":"Start with an existing pipeline","local":"start-with-an-existing-pipeline","sections":[],"depth":3},{"title":"Build a Working Pipeline Structure","local":"build-a-working-pipeline-structure","sections":[],"depth":3},{"title":"Set up an example","local":"set-up-an-example","sections":[],"depth":3},{"title":"implement your custom logic and test incrementally","local":"implement-your-custom-logic-and-test-incrementally","sections":[],"depth":3}],"depth":2},{"title":"Adding IP-adapter","local":"adding-ip-adapter","sections":[],"depth":2},{"title":"Working with ControlNets","local":"working-with-controlnets","sections":[],"depth":2},{"title":"Creating a Modular Repo","local":"creating-a-modular-repo","sections":[],"depth":2},{"title":"deploy a mellon node","local":"deploy-a-mellon-node","sections":[],"depth":2}],"depth":1}';function pa(h){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends Ps{constructor(o){super(),Ks(this,o,pa,Ma,Ls,{})}}export{Ta as component};
