import{s as Go,o as Io,n as B}from"../chunks/scheduler.8c3d61f6.js";import{S as vo,i as Co,g as p,s as n,r as u,A as Wo,h as o,f as t,c as a,j as Bo,u as d,x as r,k as el,y as qo,a as l,v as m,d as f,t as h,w as b}from"../chunks/index.da70eac4.js";import{T as G}from"../chunks/Tip.1d9b8c37.js";import{C as M}from"../chunks/CodeBlock.a9c4becf.js";import{H as Z,E as Xo}from"../chunks/getInferenceSnippets.c28dea0b.js";import{H as Vo,a as _i}from"../chunks/HfOption.6ab18950.js";function Lo($){let i,j="🧪 <strong>Experimental Feature</strong>: Modular Diffusers is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){i=p("p"),i.innerHTML=j},l(c){i=o(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-11qh5l3"&&(i.innerHTML=j)},m(c,g){l(c,i,g)},p:B,d(c){c&&t(i)}}}function So($){let i,j='This guide shows you how to use predefined blocks. If you want to learn how to create your own pipeline blocks, see the <a href="pipeline_block.md">PipelineBlock guide</a> for creating individual blocks, and the multi-block guides for connecting them together:',c,g,k='<li><a href="sequential_pipeline_blocks.md">SequentialPipelineBlocks</a> (for linear workflows)</li> <li><a href="loop_sequential_pipeline_blocks.md">LoopSequentialPipelineBlocks</a> (for iterative workflows)</li> <li><a href="auto_pipeline_blocks.md">AutoPipelineBlocks</a> (for conditional workflows)</li>',w,y,U='For information on how data flows through pipelines, see the <a href="modular_diffusers_states.md">PipelineState and BlockState guide</a>.';return{c(){i=p("p"),i.innerHTML=j,c=n(),g=p("ul"),g.innerHTML=k,w=n(),y=p("p"),y.innerHTML=U},l(T){i=o(T,"P",{"data-svelte-h":!0}),r(i)!=="svelte-7o9ugj"&&(i.innerHTML=j),c=a(T),g=o(T,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-o8tp3o"&&(g.innerHTML=k),w=a(T),y=o(T,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1fb5414"&&(y.innerHTML=U)},m(T,x){l(T,i,x),l(T,c,x),l(T,g,x),l(T,w,x),l(T,y,x)},p:B,d(T){T&&(t(i),t(c),t(g),t(w),t(y))}}}function Yo($){let i,j="💡 You can find all the block classes presets we support for each model in <code>ALL_BLOCKS</code>.",c,g,k,w,y="Each model provides a dictionary that maps all supported tasks/techniques to their corresponding block classes presets. For SDXL, it is",U,T,x;return g=new M({props:{code:"JTIzJTIwRm9yJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwWEwlMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzLnN0YWJsZV9kaWZmdXNpb25feGwlMjBpbXBvcnQlMjBBTExfQkxPQ0tTJTBBQUxMX0JMT0NLUyUwQSUyMyUyMEZvciUyMG90aGVyJTIwbW9kZWxzLi4uJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy4lM0Ntb2RlbF9uYW1lJTNFJTIwaW1wb3J0JTIwQUxMX0JMT0NLUw==",highlighted:`<span class="hljs-comment"># For Stable Diffusion XL</span>
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> ALL_BLOCKS
ALL_BLOCKS
<span class="hljs-comment"># For other models...</span>
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.&lt;model_name&gt; <span class="hljs-keyword">import</span> ALL_BLOCKS`,wrap:!1}}),T=new M({props:{code:"QUxMX0JMT0NLUyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRleHQyaW1nJTIyJTNBJTIwVEVYVDJJTUFHRV9CTE9DS1MlMkMlMEElMjAlMjAlMjAlMjAlMjJpbWcyaW1nJTIyJTNBJTIwSU1BR0UySU1BR0VfQkxPQ0tTJTJDJTBBJTIwJTIwJTIwJTIwJTIyaW5wYWludCUyMiUzQSUyMElOUEFJTlRfQkxPQ0tTJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29udHJvbG5ldCUyMiUzQSUyMENPTlRST0xORVRfQkxPQ0tTJTJDJTBBJTIwJTIwJTIwJTIwJTIyaXBfYWRhcHRlciUyMiUzQSUyMElQX0FEQVBURVJfQkxPQ0tTJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXV0byUyMiUzQSUyMEFVVE9fQkxPQ0tTJTJDJTBBJTdE",highlighted:`ALL_BLOCKS = {
    <span class="hljs-string">&quot;text2img&quot;</span>: TEXT2IMAGE_BLOCKS,
    <span class="hljs-string">&quot;img2img&quot;</span>: IMAGE2IMAGE_BLOCKS,
    <span class="hljs-string">&quot;inpaint&quot;</span>: INPAINT_BLOCKS,
    <span class="hljs-string">&quot;controlnet&quot;</span>: CONTROLNET_BLOCKS,
    <span class="hljs-string">&quot;ip_adapter&quot;</span>: IP_ADAPTER_BLOCKS,
    <span class="hljs-string">&quot;auto&quot;</span>: AUTO_BLOCKS,
}`,wrap:!1}}),{c(){i=p("p"),i.innerHTML=j,c=n(),u(g.$$.fragment),k=n(),w=p("p"),w.textContent=y,U=n(),u(T.$$.fragment)},l(J){i=o(J,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1iu2bgl"&&(i.innerHTML=j),c=a(J),d(g.$$.fragment,J),k=a(J),w=o(J,"P",{"data-svelte-h":!0}),r(w)!=="svelte-8bbxo4"&&(w.textContent=y),U=a(J),d(T.$$.fragment,J)},m(J,_){l(J,i,_),l(J,c,_),m(g,J,_),l(J,k,_),l(J,w,_),l(J,U,_),m(T,J,_),x=!0},p:B,i(J){x||(f(g.$$.fragment,J),f(T.$$.fragment,J),x=!0)},o(J){h(g.$$.fragment,J),h(T.$$.fragment,J),x=!1},d(J){J&&(t(i),t(c),t(k),t(w),t(U)),b(g,J),b(T,J)}}}function Ro($){let i,j='💡 <strong>ComponentsManager</strong> is the model registry and management system in diffusers, it track all the models in one place and let you add, remove and reuse them across different workflows in most efficient way. Without it, you’d need to manually manage GPU memory, device placement, and component sharing between workflows. See the <a href="components_manager.md">Components Manager guide</a> for detailed information.';return{c(){i=p("p"),i.innerHTML=j},l(c){i=o(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-w13he7"&&(i.innerHTML=j)},m(c,g){l(c,i,g)},p:B,d(c){c&&t(i)}}}function No($){let i,j='💡 <strong>Component Type Changes</strong>: The component type (pretrained vs config-based) can change when you update components. These types are initially defined in pipeline blocks’ <code>expected_components</code> field using <code>ComponentSpec</code> with <code>default_creation_method</code>. See the <a href="#customizing-guidance-techniques">Customizing Guidance Techniques</a> section for examples of how this works in practice.';return{c(){i=p("p"),i.innerHTML=j},l(c){i=o(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1ff9ave"&&(i.innerHTML=j)},m(c,g){l(c,i,g)},p:B,d(c){c&&t(i)}}}function Ho($){let i,j="💡 <strong>Modifying Component Specs</strong>: You can get a copy of the current component spec from the pipeline using <code>get_component_spec()</code>. This makes it easy to modify the spec and updating components.",c,g,k;return g=new M({props:{code:"dW5ldF9zcGVjJTIwJTNEJTIwdDJpX3BpcGVsaW5lLmdldF9jb21wb25lbnRfc3BlYyglMjJ1bmV0JTIyKSUwQXVuZXRfc3BlYyUwQSUwQXVuZXRfc3BlYy5yZXBvJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBJTBBdW5ldCUyMCUzRCUyMHVuZXRfc3BlYy5sb2FkKHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>unet_spec = t2i_pipeline.get_component_spec(<span class="hljs-string">&quot;unet&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unet_spec
ComponentSpec(
    name=<span class="hljs-string">&#x27;unet&#x27;</span>, 
    type_hint=&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.models.unets.unet_2d_condition.UNet2DConditionModel&#x27;</span>&gt;, 
    repo=<span class="hljs-string">&#x27;RunDiffusion/Juggernaut-XL-v9&#x27;</span>, 
    subfolder=<span class="hljs-string">&#x27;unet&#x27;</span>, 
    variant=<span class="hljs-string">&#x27;fp16&#x27;</span>, 
    default_creation_method=<span class="hljs-string">&#x27;from_pretrained&#x27;</span>
)

<span class="hljs-comment"># Modify the spec to load from a different repository</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unet_spec.repo = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>

<span class="hljs-comment"># Load the component with the modified spec</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unet = unet_spec.load(torch_dtype=torch.float16)`,wrap:!1}}),{c(){i=p("p"),i.innerHTML=j,c=n(),u(g.$$.fragment)},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-104t12l"&&(i.innerHTML=j),c=a(w),d(g.$$.fragment,w)},m(w,y){l(w,i,y),l(w,c,y),m(g,w,y),k=!0},p:B,i(w){k||(f(g.$$.fragment,w),k=!0)},o(w){h(g.$$.fragment,w),k=!1},d(w){w&&(t(i),t(c)),b(g,w)}}}function Qo($){let i,j="<li>For <code>from_config</code> components (like guiders, schedulers): You can pass an object of required type OR pass a ComponentSpec directly (which calls <code>create()</code> under the hood)</li> <li>For <code>from_pretrained</code> components (like models): You must use ComponentSpec to ensure proper tagging and loading</li>";return{c(){i=p("ul"),i.innerHTML=j},l(c){i=o(c,"UL",{"data-svelte-h":!0}),r(i)!=="svelte-pva5xa"&&(i.innerHTML=j)},m(c,g){l(c,i,g)},p:B,d(c){c&&t(i)}}}function Fo($){let i,j="Experiment with different techniques and parameters to find what works best for your specific use case! You can find all the guider class we support [here](TODO: API doc)",c,g,k="Additionally, you can write your own guider implementations, for example, CFG Zero* combined with Skip Layer Guidance, and they should be compatible out-of-the-box with modular diffusers!";return{c(){i=p("p"),i.textContent=j,c=n(),g=p("p"),g.textContent=k},l(w){i=o(w,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1esqlay"&&(i.textContent=j),c=a(w),g=o(w,"P",{"data-svelte-h":!0}),r(g)!=="svelte-50g51l"&&(g.textContent=k)},m(w,y){l(w,i,y),l(w,c,y),l(w,g,y)},p:B,d(w){w&&(t(i),t(c),t(g))}}}function Eo($){let i,j="You can inspect the docstring of a <code>ModularPipeline</code> to check what arguments the pipeline accepts and how to specify the <code>output</code> you want. It will list all available outputs (basically everything in the intermediate pipeline state) so you can choose from the list.",c,g,k,w,y="<strong>Important</strong>: It is important to always check the docstring because arguments can be different from standard pipelines that you’re familar with. For example, in Modular Diffusers we standardized controlnet image input as <code>control_image</code>, but regular pipelines have inconsistencies over the names, e.g. controlnet text-to-image uses <code>image</code> while SDXL controlnet img2img uses <code>control_image</code>.",U,T,x="<strong>Note</strong>: The <code>output</code> list might be longer than you expected - it includes everything in the intermediate state that you can choose to return. Most of the time, you’ll just want <code>output=&quot;images&quot;</code> or <code>output=&quot;latents&quot;</code>.",J;return g=new M({props:{code:"dDJpX3BpcGVsaW5lLmRvYw==",highlighted:"t2i_pipeline.doc",wrap:!1}}),{c(){i=p("p"),i.innerHTML=j,c=n(),u(g.$$.fragment),k=n(),w=p("p"),w.innerHTML=y,U=n(),T=p("p"),T.innerHTML=x},l(_){i=o(_,"P",{"data-svelte-h":!0}),r(i)!=="svelte-61h1bw"&&(i.innerHTML=j),c=a(_),d(g.$$.fragment,_),k=a(_),w=o(_,"P",{"data-svelte-h":!0}),r(w)!=="svelte-l6qwlc"&&(w.innerHTML=y),U=a(_),T=o(_,"P",{"data-svelte-h":!0}),r(T)!=="svelte-8hegdt"&&(T.innerHTML=x)},m(_,I){l(_,i,I),l(_,c,I),m(g,_,I),l(_,k,I),l(_,w,I),l(_,U,I),l(_,T,I),J=!0},p:B,i(_){J||(f(g.$$.fragment,_),J=!0)},o(_){h(g.$$.fragment,_),J=!1},d(_){_&&(t(i),t(c),t(k),t(w),t(U),t(T)),b(g,_)}}}function zo($){let i,j;return i=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwVEVYVDJJTUFHRV9CTE9DS1MlMEElMEElMjMlMjBjcmVhdGUlMjBwaXBlbGluZSUyMGZyb20lMjBvZmZpY2lhbCUyMGJsb2NrcyUyMHByZXNldCUwQWJsb2NrcyUyMCUzRCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2Nrcy5mcm9tX2Jsb2Nrc19kaWN0KFRFWFQySU1BR0VfQkxPQ0tTKSUwQSUwQW1vZHVsYXJfcmVwb19pZCUyMCUzRCUyMCUyMllpWWlYdSUyRm1vZHVsYXItbG9hZGVyLXQyaS0wNzA0JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBibG9ja3MuaW5pdF9waXBlbGluZShtb2R1bGFyX3JlcG9faWQpJTBBJTBBcGlwZWxpbmUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwcnVuJTIwcGlwZWxpbmUlMkMlMjBuZWVkJTIwdG8lMjBwYXNzJTIwYSUyMCUyMm91dHB1dCUzRGltYWdlcyUyMiUyMGFyZ3VtZW50JTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTIwb3V0cHV0JTNEJTIyaW1hZ2VzJTIyKSU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm1vZHVsYXJfdDJpX291dC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> TEXT2IMAGE_BLOCKS

<span class="hljs-comment"># create pipeline from official blocks preset</span>
blocks = SequentialPipelineBlocks.from_blocks_dict(TEXT2IMAGE_BLOCKS)

modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-0704&quot;</span>
pipeline = blocks.init_pipeline(modular_repo_id)

pipeline.load_default_components(torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># run pipeline, need to pass a &quot;output=images&quot; argument</span>
image = pipeline(prompt=<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;modular_t2i_out.png&quot;</span>)`,wrap:!1}}),{c(){u(i.$$.fragment)},l(c){d(i.$$.fragment,c)},m(c,g){m(i,c,g),j=!0},p:B,i(c){j||(f(i.$$.fragment,c),j=!0)},o(c){h(i.$$.fragment,c),j=!1},d(c){b(i,c)}}}function Po($){let i,j;return i=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU1BR0UySU1BR0VfQkxPQ0tTJTBBJTBBJTIzJTIwY3JlYXRlJTIwcGlwZWxpbmUlMjBmcm9tJTIwYmxvY2tzJTIwcHJlc2V0JTBBYmxvY2tzJTIwJTNEJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzLmZyb21fYmxvY2tzX2RpY3QoSU1BR0UySU1BR0VfQkxPQ0tTKSUwQSUwQW1vZHVsYXJfcmVwb19pZCUyMCUzRCUyMCUyMllpWWlYdSUyRm1vZHVsYXItbG9hZGVyLXQyaS0wNzA0JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBibG9ja3MuaW5pdF9waXBlbGluZShtb2R1bGFyX3JlcG9faWQpJTBBJTBBcGlwZWxpbmUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGc2R4bC10ZXh0MmltZy5wbmclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGRvZyUyMGNhdGNoaW5nJTIwYSUyMGZyaXNiZWUlMjBpbiUyMHRoZSUyMGp1bmdsZSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjglMkMlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybW9kdWxhcl9pMmlfb3V0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> IMAGE2IMAGE_BLOCKS

<span class="hljs-comment"># create pipeline from blocks preset</span>
blocks = SequentialPipelineBlocks.from_blocks_dict(IMAGE2IMAGE_BLOCKS)

modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-0704&quot;</span>
pipeline = blocks.init_pipeline(modular_repo_id)

pipeline.load_default_components(torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
init_image = load_image(url)
prompt = <span class="hljs-string">&quot;a dog catching a frisbee in the jungle&quot;</span>
image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.8</span>, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;modular_i2i_out.png&quot;</span>)`,wrap:!1}}),{c(){u(i.$$.fragment)},l(c){d(i.$$.fragment,c)},m(c,g){m(i,c,g),j=!0},p:B,i(c){j||(f(i.$$.fragment,c),j=!0)},o(c){h(i.$$.fragment,c),j=!1},d(c){b(i,c)}}}function Ao($){let i,j;return i=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwSU5QQUlOVF9CTE9DS1MlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQSUyMyUyMGNyZWF0ZSUyMHBpcGVsaW5lJTIwZnJvbSUyMGJsb2NrcyUyMHByZXNldCUwQWJsb2NrcyUyMCUzRCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2Nrcy5mcm9tX2Jsb2Nrc19kaWN0KElOUEFJTlRfQkxPQ0tTKSUwQSUwQW1vZHVsYXJfcmVwb19pZCUyMCUzRCUyMCUyMllpWWlYdSUyRm1vZHVsYXItbG9hZGVyLXQyaS0wNzA0JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBibG9ja3MuaW5pdF9waXBlbGluZShtb2R1bGFyX3JlcG9faWQpJTBBJTBBcGlwZWxpbmUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtdGV4dDJpbWcucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLWlucGFpbnQtbWFzay5wbmclMjIlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKG1hc2tfdXJsKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBkZWVwJTIwc2VhJTIwZGl2ZXIlMjBmbG9hdGluZyUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuODUlMkMlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybW9kdWFyX2lucGFpbnRfb3V0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> INPAINT_BLOCKS
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-comment"># create pipeline from blocks preset</span>
blocks = SequentialPipelineBlocks.from_blocks_dict(INPAINT_BLOCKS)

modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-0704&quot;</span>
pipeline = blocks.init_pipeline(modular_repo_id)

pipeline.load_default_components(torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>

init_image = load_image(img_url)
mask_image = load_image(mask_url)

prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;moduar_inpaint_out.png&quot;</span>)`,wrap:!1}}),{c(){u(i.$$.fragment)},l(c){d(i.$$.fragment,c)},m(c,g){m(i,c,g),j=!0},p:B,i(c){j||(f(i.$$.fragment,c),j=!0)},o(c){h(i.$$.fragment,c),j=!1},d(c){b(i,c)}}}function Do($){let i,j,c,g,k,w;return i=new _i({props:{id:"basic-tasks",option:"text-to-image",$$slots:{default:[zo]},$$scope:{ctx:$}}}),c=new _i({props:{id:"basic-tasks",option:"image-to-image",$$slots:{default:[Po]},$$scope:{ctx:$}}}),k=new _i({props:{id:"basic-tasks",option:"inpainting",$$slots:{default:[Ao]},$$scope:{ctx:$}}}),{c(){u(i.$$.fragment),j=n(),u(c.$$.fragment),g=n(),u(k.$$.fragment)},l(y){d(i.$$.fragment,y),j=a(y),d(c.$$.fragment,y),g=a(y),d(k.$$.fragment,y)},m(y,U){m(i,y,U),l(y,j,U),m(c,y,U),l(y,g,U),m(k,y,U),w=!0},p(y,U){const T={};U&2&&(T.$$scope={dirty:U,ctx:y}),i.$set(T);const x={};U&2&&(x.$$scope={dirty:U,ctx:y}),c.$set(x);const J={};U&2&&(J.$$scope={dirty:U,ctx:y}),k.$set(J)},i(y){w||(f(i.$$.fragment,y),f(c.$$.fragment,y),f(k.$$.fragment,y),w=!0)},o(y){h(i.$$.fragment,y),h(c.$$.fragment,y),h(k.$$.fragment,y),w=!1},d(y){y&&(t(j),t(g)),b(i,y),b(c,y),b(k,y)}}}function Ko($){let i,j="💡 <strong>How to explore new tasks</strong>: When you want to figure out how to do a specific task in Modular Diffusers, it is a good idea to start by checking what block classes presets we offer in <code>ALL_BLOCKS</code>. Then create the block instance and inspect it - it will show you the required components, description, and sub-blocks. This is crucial for understanding what each block does and what it needs.";return{c(){i=p("p"),i.innerHTML=j},l(c){i=o(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1fkro9g"&&(i.innerHTML=j)},m(c,g){l(c,i,g)},p:B,d(c){c&&t(i)}}}function Oo($){let i,j='💡 <strong>Auto Blocks</strong>: This is first time we meet a Auto Blocks! <code>AutoPipelineBlocks</code> automatically adapt to your inputs by combining multiple workflows with conditional logic. This is why one convenient block can work for all tasks and controlnet types. See the <a href="./auto_pipeline_blocks.md">Auto Blocks Guide</a> for more details.';return{c(){i=p("p"),i.innerHTML=j},l(c){i=o(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-9bz89q"&&(i.innerHTML=j)},m(c,g){l(c,i,g)},p:B,d(c){c&&t(i)}}}function er($){let i,j,c,g,k,w,y,U,T,x="<code>ModularPipeline</code> is the main interface for end users to run pipelines in Modular Diffusers. It takes pipeline blocks and converts them into a runnable pipeline that can load models and execute the computation steps.",J,_,I="In this guide, we will focus on how to build pipelines using the blocks we officially support at diffusers 🧨. We’ll cover how to use predefined blocks and convert them into a <code>ModularPipeline</code> for execution.",sl,v,tl,E,ll,z,ki="In Modular Diffusers system, you build pipelines using Pipeline blocks. Pipeline Blocks are fundamental building blocks - they define what components, inputs/outputs, and computation logics are needed. They are designed to be assembled into workflows for tasks such as image generation, video creation, and inpainting. But they are just definitions and don’t actually run anything. To execute blocks, you need to put them into a <code>ModularPipeline</code>. We’ll first learn how to create predefined blocks here before talking about how to run them using <code>ModularPipeline</code>.",nl,P,$i="All pipeline blocks inherit from the base class <code>ModularPipelineBlocks</code>, including:",al,A,Ui="<li><code>PipelineBlock</code>: The most granular block - you define the input/output/components requirements and computation logic.</li> <li><code>SequentialPipelineBlocks</code>: A multi-block composed of multiple blocks that run sequentially, passing outputs as inputs to the next block.</li> <li><code>LoopSequentialPipelineBlocks</code>: A special type of <code>SequentialPipelineBlocks</code> that runs the same sequence of blocks multiple times (loops), typically used for iterative processes like denoising steps in diffusion models.</li> <li><code>AutoPipelineBlocks</code>: A multi-block composed of multiple blocks that are selected at runtime based on the inputs.</li>",il,D,xi="It is very easy to use a <code>ModularPipelineBlocks</code> officially supported in 🧨 Diffusers",pl,K,ol,O,Zi="This is a single <code>PipelineBlock</code>. You’ll see that this text encoder block uses 2 text_encoders, 2 tokenizers as well as a guider component. It takes user inputs such as <code>prompt</code> and <code>negative_prompt</code>, and return text embeddings outputs such as <code>prompt_embeds</code> and <code>negative_prompt_embeds</code>.",rl,ee,cl,se,Bi="More commonly, you need multiple blocks to build your workflow. You can create a <code>SequentialPipelineBlocks</code> using block class presets from 🧨 Diffusers. <code>TEXT2IMAGE_BLOCKS</code> is a dict containing all the blocks needed for text-to-image generation.",ul,te,dl,le,Gi="This creates a <code>SequentialPipelineBlocks</code>. Unlike the <code>text_encoder_block</code> we saw earlier, this is a multi-block and its <code>sub_blocks</code> attribute contains a list of other blocks (text_encoder, input, set_timesteps, prepare_latents, prepare_added_con, denoise, decode). Its requirements for components, inputs, and intermediate inputs are combined from these blocks that compose it. At runtime, it executes its sub-blocks sequentially and passes the pipeline state from one block to another.",ml,ne,fl,ae,Ii="This is the block classes preset (<code>TEXT2IMAGE_BLOCKS</code>) we used: It is just a dictionary that maps names to ModularPipelineBlocks classes",hl,ie,bl,pe,vi="When we create a <code>SequentialPipelineBlocks</code> from this preset, it instantiates each block class into actual block objects. Its <code>sub_blocks</code> attribute now contains these instantiated objects:",gl,oe,Ml,re,Ci="Note that both the block classes preset and the <code>sub_blocks</code> attribute are <code>InsertableDict</code> objects. This is a custom dictionary that extends <code>OrderedDict</code> with the ability to insert items at specific positions. You can perform all standard dictionary operations (get, set, delete) plus insert items at any index, which is particularly useful for reordering or inserting blocks in the middle of a pipeline.",yl,ce,Wi="<strong>Add a block:</strong>",jl,ue,wl,de,qi="<strong>Remove a block:</strong>",Tl,me,Jl,fe,Xi="<strong>Swap block:</strong>",_l,he,kl,be,Vi="This means you can mix-and-match blocks in very flexible ways. Let’s see some real examples:",$l,ge,Li=`<strong>Example 1: Adding IP-Adapter to the Block Classes Preset</strong>
Let’s make a new block classes preset by insert IP-Adapter at index 0 (before the text_encoder block), and create a text-to-image pipeline with IP-Adapter support:`,Ul,Me,xl,ye,Si=`<strong>Example 2: Extracting a block from a multi-block</strong>
You can extract a block instance from the multi-block to use it independently. A common pattern is to use text_encoder to process prompts once, then reuse the text embeddings outputs to generate multiple images with different settings (schedulers, seeds, inference steps). We can do this by simply extracting the text_encoder block from the pipeline.`,Zl,je,Bl,we,Yi="The multi-block now has fewer components and no longer has the <code>text_encoder</code> block. If you check its docstring <code>t2i_blocks.doc</code>, you will see that it no longer accepts <code>prompt</code> as input - you will need to pass the embeddings instead.",Gl,Te,Il,C,vl,Je,Ri="This covers the essentials of pipeline blocks! Like we have already mentioned, <strong>pipeline blocks are not runnable by themselves</strong>. They are essentially <strong>“definitions”</strong> - they define the specifications and computational steps for a pipeline, but they do not contain any model states. To actually run them, you need to convert them into a <code>ModularPipeline</code> object.",Cl,_e,Wl,ke,Ni="To convert blocks into a runnable pipeline, you may need a repository if your blocks contain <strong>pretrained components</strong> (models with checkpoints that need to be loaded from the Hub). Pipeline blocks define what components they need (like a UNet, text encoder, etc.), as well as how to create them: components can be either created using <strong>from_pretrained</strong> method (with checkpoints) or <strong>from_config</strong> (initialized from scratch with default configuration, usually stateless like a guider or scheduler).",ql,$e,Hi="If your pipeline contains <strong>pretrained components</strong>, you typically need to use a repository to provide the loading specifications and metadata.",Xl,Ue,Qi='<code>ModularPipeline</code> works specifically with modular repositories, which offer more flexibility in component loading compared to traditional repositories. You can find an example modular repo <a href="https://huggingface.co/YiYiXu/modular-diffdiff" rel="nofollow">here</a>.',Vl,xe,Fi="A <code>DiffusionPipeline</code> defines <code>model_index.json</code> to configure its components. However, repositories for Modular Diffusers work with <code>modular_model_index.json</code>. Let’s walk through the differences here.",Ll,Ze,Ei="In standard <code>model_index.json</code>, each component entry is a <code>(library, class)</code> tuple:",Sl,Be,Yl,Ge,zi="In <code>modular_model_index.json</code>, each component entry contains 3 elements: <code>(library, class, loading_specs_dict)</code>",Rl,Ie,Pi="<li><code>library</code> and <code>class</code>: Information about the actual component loaded in the pipeline at the time of saving (will be <code>null</code> if not loaded)</li> <li><code>loading_specs_dict</code>: A dictionary containing all information required to load this component, including <code>repo</code>, <code>revision</code>, <code>subfolder</code>, <code>variant</code>, and <code>type_hint</code>.</li>",Nl,ve,Hl,Ce,Ai="Unlike standard repositories where components must be in subfolders within the same repo, modular repositories can fetch components from different repositories based on the <code>loading_specs_dict</code>. e.g. the <code>text_encoder</code> component will be fetched from the “text_encoder” folder in <code>stabilityai/stable-diffusion-xl-base-1.0</code> while other components come from different repositories.",Ql,We,Fl,qe,Di="Each <code>ModularPipelineBlocks</code> has an <code>init_pipeline</code> method that can initialize a <code>ModularPipeline</code> object based on its component and configuration specifications.",El,Xe,Ki="Let’s convert our <code>t2i_blocks</code> (which we created earlier) into a runnable <code>ModularPipeline</code>. We’ll use a <code>ComponentsManager</code> to handle device placement, memory management, and component reuse automatically:",zl,Ve,Pl,W,Al,Le,Oi="The <code>init_pipeline()</code> method creates a ModularPipeline and loads component specifications from the repository’s <code>modular_model_index.json</code> file, but doesn’t load the actual models yet.",Dl,Se,Kl,Ye,ep="You can create a <code>ModularPipeline</code> from a HuggingFace Hub repository with <code>from_pretrained</code> method, as long as it’s a modular repo:",Ol,Re,en,Ne,sp="Loading custom code is also supported:",sn,He,tn,Qe,tp="This modular repository contains custom code. The folder contains these files:",ln,Fe,nn,Ee,lp='The <a href="https://huggingface.co/YiYiXu/modular-diffdiff-0704/blob/main/config.json" rel="nofollow"><code>config.json</code></a> file defines a custom <code>DiffDiffBlocks</code> class and points to its implementation:',an,ze,pn,Pe,np='The <code>auto_map</code> tells the pipeline where to find the custom blocks definition - in this case, it’s looking for <code>DiffDiffBlocks</code> in the <code>block.py</code> file. The actual <code>DiffDiffBlocks</code> class is defined in <a href="https://huggingface.co/YiYiXu/modular-diffdiff-0704/blob/main/block.py" rel="nofollow"><code>block.py</code></a> within the repository.',on,Ae,ap="When <code>diffdiff_pipeline.blocks</code> is created, it’s based on the <code>DiffDiffBlocks</code> definition from the custom code in the repository, allowing you to use specialized blocks that aren’t part of the standard diffusers library.",rn,De,cn,Ke,ip="Unlike <code>DiffusionPipeline</code>, when you create a <code>ModularPipeline</code> instance (whether using <code>from_pretrained</code> or converting from pipeline blocks), its components aren’t loaded automatically. You need to explicitly load model components using <code>load_default_components</code> or <code>load_components(names=..,)</code>:",un,Oe,dn,es,pp="All expected components are now loaded into the pipeline. You can also partially load specific components using the <code>names</code> argument. For example, to only load unet and vae:",mn,ss,fn,ts,op="You can inspect the pipeline’s loading status by simply printing the pipeline itself. It helps you understand what components are expected to load, which ones are already loaded, how they were loaded, and what loading specs are available. Let’s print out the <code>t2i_pipeline</code>:",hn,ls,bn,ns,rp="You can see all the <strong>pretrained components</strong> that will be loaded using <code>from_pretrained</code> method are listed as entries. Each entry contains 3 elements: <code>(library, class, loading_specs_dict)</code>:",gn,as,cp="<li><strong><code>library</code> and <code>class</code></strong>: Show the actual loaded component info. If <code>null</code>, the component is not loaded yet.</li> <li><strong><code>loading_specs_dict</code></strong>: Contains all the information needed to load the component (repo, subfolder, variant, etc.)</li>",Mn,is,up="In this example:",yn,ps,dp="<li><strong>Loaded components</strong>: <code>vae</code> and <code>unet</code> (their <code>library</code> and <code>class</code> fields show the actual loaded models)</li> <li><strong>Not loaded yet</strong>: <code>scheduler</code>, <code>text_encoder</code>, <code>text_encoder_2</code>, <code>tokenizer</code>, <code>tokenizer_2</code> (their <code>library</code> and <code>class</code> fields are <code>null</code>, but you can see their loading specs to know where they’ll be loaded from when you call <code>load_components()</code>)</li>",jn,os,mp="You’re looking at essentailly the pipeline’s config dict that’s synced with the <code>modular_model_index.json</code> from the repository you used during <code>init_pipeline()</code> - it takes the loading specs that match the pipeline’s component requirements.",wn,rs,fp="For example, if your pipeline needs a <code>text_encoder</code> component, it will include the loading spec for <code>text_encoder</code> from the modular repo during the <code>init_pipeline</code>. If the pipeline doesn’t need a component (like <code>controlnet</code> in a basic text-to-image pipeline), that component won’t be included even if it exists in the modular repo.",Tn,cs,hp="There are also a few properties that can provide a quick summary of component loading status:",Jn,us,_n,ds,bp="From config components (like <code>guider</code> and <code>image_processor</code>) are not included in the pipeline output above because they don’t need loading specs - they’re already initialized during pipeline creation. You can see this because they’re not listed in <code>null_component_names</code>.",kn,ms,$n,fs,gp="When you call <code>pipeline.load_components(names=)</code> or <code>pipeline.load_default_components()</code>, it uses the loading specs from the modular repository’s <code>modular_model_index.json</code>. You can change where components are loaded from by modifying the <code>modular_model_index.json</code> in the repository. Just find the file on the Hub and click edit - you can change any field in the loading specs: <code>repo</code>, <code>subfolder</code>, <code>variant</code>, <code>revision</code>, etc.",Un,hs,xn,bs,Mp="Now if you create a pipeline using the same blocks and updated repository, it will by default load from the new repository.",Zn,gs,Bn,Ms,Gn,ys,yp="Similar to <code>DiffusionPipeline</code>, you can load components separately to replace the default ones in the pipeline. In Modular Diffusers, the approach depends on the component type:",In,js,jp="<li><strong>Pretrained components</strong> (<code>default_creation_method=&#39;from_pretrained&#39;</code>): Must use <code>ComponentSpec</code> to load them to update the existing one.</li> <li><strong>Config components</strong> (<code>default_creation_method=&#39;from_config&#39;</code>): These are components that don’t need loading specs - they’re created during pipeline initialization with default config. To update them, you can either pass the object directly or pass a ComponentSpec directly.</li>",vn,q,Cn,ws,wp="<code>ComponentSpec</code> defines how to create or load components and can actually create them using its <code>create()</code> method (for ConfigMixin objects) or <code>load()</code> method (wrapper around <code>from_pretrained()</code>). When a component is loaded with a ComponentSpec, it gets tagged with a unique ID that encodes its creation parameters, allowing you to always extract the original specification using <code>ComponentSpec.from_component()</code>.",Wn,Ts,Tp="Now let’s look at how to update pretrained components in practice:",qn,Js,Jp="So instead of",Xn,_s,Vn,ks,_p="You should load your model like this",Ln,$s,Sn,Us,kp="The key difference is that the second unet retains its loading specs, so you can extract the spec and recreate the unet:",Yn,xs,Rn,Zs,$p="To replace the unet in the pipeline",Nn,Bs,Hn,Gs,Up="Not only is the <code>unet</code> component swapped, but its loading specs are also updated from “RunDiffusion/Juggernaut-XL-v9” to “stabilityai/stable-diffusion-xl-base-1.0” in pipeline config. This means that if you save the pipeline now and load it back with <code>from_pretrained</code>, the new pipeline will by default load the SDXL original unet.",Qn,Is,Fn,X,En,vs,zn,Cs,xp='Guiders are implementations of different <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">classifier-free guidance</a> techniques that can be applied during the denoising process to improve generation quality, control, and adherence to prompts. They work by steering the model predictions towards desired directions and away from undesired directions. In diffusers, guiders are implemented as subclasses of <code>BaseGuidance</code>. They can easily be integrated into modular pipelines and provide a flexible way to enhance generation quality without modifying the underlying diffusion models.',Pn,Ws,Zp="<strong>ClassifierFreeGuidance (CFG)</strong> is the first and most common guidance technique, used in all our standard pipelines. We also offer many other guidance techniques from the latest research in this area - <strong>PerturbedAttentionGuidance (PAG)</strong>, <strong>SkipLayerGuidance (SLG)</strong>, <strong>SmoothedEnergyGuidance (SEG)</strong>, and others that can provide better results for specific use cases.",An,qs,Bp="This section demonstrates how to use guiders using the component updating methods we just learned. Since <code>BaseGuidance</code> components are stateless (similar to schedulers), they are typically created with default configurations during pipeline initialization using <code>default_creation_method=&#39;from_config&#39;</code>. This means they don’t require loading specs from the repository - you won’t see guider listed in <code>modular_model_index.json</code> files.",Dn,Xs,Gp="Let’s take a look at the default guider configuration:",Kn,Vs,On,Ls,Ip="As you can see, the guider is configured to use <code>ClassifierFreeGuidance</code> with default parameters and <code>default_creation_method=&#39;from_config&#39;</code>, meaning it’s created during pipeline initialization rather than loaded from a repository. Let’s verify this, here we run <code>init_pipeline()</code> without a modular repo, and there it is, a guider with the default configuration we just saw",ea,Ss,sa,Ys,ta,Rs,vp="To change parameters of the same guider type (e.g., adjusting the <code>guidance_scale</code> for CFG), you have two options:",la,Ns,Cp="<strong>Option 1: Use ComponentSpec.create() method</strong>",na,Hs,Wp="You just need to pass the parameter with the new value to override the default one.",aa,Qs,ia,Fs,qp="<strong>Option 2: Pass ComponentSpec directly</strong>",pa,Es,Xp="Update the spec directly and pass it to <code>update_components()</code>.",oa,zs,ra,Ps,Vp="Both approaches produce the same result:",ca,As,ua,Ds,da,Ks,Lp="Switching between guidance techniques is as simple as passing a guider object of that technique:",ma,Os,fa,et,Sp="Note that you will get a warning about changing the guider type, which is expected:",ha,st,ba,V,ga,tt,Yp="Let’s verify that the guider has been updated:",Ma,lt,ya,nt,Rp="The component spec has also been updated to reflect the new guider type:",ja,at,wa,it,Np="The “guider” is still a <code>from_config</code> component: is still not included in the pipeline config and will not be saved into the <code>modular_model_index.json</code>.",Ta,pt,Ja,ot,Hp="However, you can change it to a <code>from_pretrained</code> component, which allows you to upload your customized guider to the Hub and load it into your pipeline.",_a,rt,ka,ct,Qp="If you already have a guider saved on the Hub and a <code>modular_model_index.json</code> with the loading spec for that guider, it will automatically be changed to a <code>from_pretrained</code> component during pipeline initialization.",$a,ut,Fp="For example, this <code>modular_model_index.json</code> includes loading specs for the guider:",Ua,dt,xa,mt,Ep="When you use this repository to create a pipeline with the same blocks (that originally configured guider as a <code>from_config</code> component), the guider becomes a <code>from_pretrained</code> component. This means it doesn’t get created during initialization, and after you call <code>load_default_components()</code>, it loads based on the spec - resulting in the PAG guider instead of the default CFG.",Za,ft,Ba,ht,Ga,bt,zp="Now let’s see how we can share the guider on the Hub and change it to a <code>from_pretrained</code> component.",Ia,gt,va,Mt,Pp="Voilà! Now you have a subfolder called <code>pag_guider</code> on that repository.",Ca,yt,Ap="You have a few options to make this guider available in your pipeline:",Wa,jt,Dp="<li><p><strong>Directly modify the <code>modular_model_index.json</code></strong> to add a loading spec for the guider by pointing to a folder containing the desired guider config.</p></li> <li><p><strong>Use the <code>update_components</code> method</strong> to change it to a <code>from_pretrained</code> component for your pipeline. This is easier if you just want to try it out with different repositories.</p></li>",qa,wt,Kp="Let’s use the second approach and change our guider_spec to use <code>from_pretrained</code> as the default creation method and update the loading spec to use this subfolder we just created:",Xa,Tt,Va,Jt,Op="You will get a warning about changing the creation method:",La,_t,Sa,kt,eo="Now not only the <code>guider</code> component and its component_spec are updated, but so is the pipeline config.",Ya,$t,so="If you want to change the default behavior for future pipelines, you can push the updated pipeline to the Hub. This way, when others use your repository, they’ll get the PAG guider by default. However, this is optional - you don’t have to do this if you just want to experiment locally.",Ra,Ut,Na,L,Ha,xt,Qa,Zt,to="The API to run the <code>ModularPipeline</code> is very similar to how you would run a regular <code>DiffusionPipeline</code>:",Fa,Bt,Ea,Gt,lo="There are a few key differences though:",za,It,no="<li>You can also pass a <code>PipelineState</code> object directly to the pipeline instead of individual arguments</li> <li>If you do not specify the <code>output</code> argument, it returns the <code>PipelineState</code> object</li> <li>You can pass a list as <code>output</code>, e.g. <code>pipeline(... output=[&quot;images&quot;, &quot;latents&quot;])</code> will return a dictionary containing both the generated image and the final denoised latents</li>",Pa,vt,ao="Under the hood, <code>ModularPipeline</code>’s <code>__call__</code> method is a wrapper around the pipeline blocks’ <code>__call__</code> method: it creates a <code>PipelineState</code> object and populates it with user inputs, then returns the output to the user based on the <code>output</code> argument. It also ensures that all pipeline-level config and components are exposed to all pipeline blocks by preparing and passing a <code>components</code> input.",Aa,S,Da,Ct,Ka,Wt,io="These are minimum inference examples for basic tasks: text-to-image, image-to-image, and inpainting. The process to create different pipelines is the same - only difference is the block classes presets. The inference is also more or less same to standard pipelines, but please always check <code>.doc</code> for correct input names and remember to pass <code>output=&quot;images&quot;</code>.",Oa,Y,ei,qt,si,Xt,po="For ControlNet, we provide one auto block you can place at the <code>denoise</code> step. Let’s create it and inspect it to see what it tells us.",ti,R,li,Vt,ni,N,ai,Lt,oo="The block shows us it has two steps (prepare inputs + denoise) and supports all tasks with both controlnet and controlnet union. Most importantly, it tells us to place it at the ‘denoise’ step. Let’s do exactly that:",ii,St,pi,Yt,ro="Before we convert the blocks into a pipeline and load its components, let’s inspect the blocks and its docs again to make sure it was assembled correctly. You should be able to see that <code>controlnet</code> and <code>control_image_processor</code> are now listed as <code>Components</code>, so we should initialize the pipeline with a repo that contains desired loading specs for these 2 components.",oi,Rt,ri,Nt,ci,Ht,co="<strong>Challenge time!</strong> Before we show you how to apply IP-adapter, try doing it yourself! Use the same process we just walked you through with ControlNet: check the official blocks preset, inspect the block instance and docstring <code>.doc</code>, and adapt a regular IP-adapter example to modular.",ui,Qt,uo="Let’s walk through the steps:",di,Ft,mo="<li>Check blocks preset</li>",mi,Et,fi,H,fo="<li>inspect the block &amp; doc</li>",hi,zt,bi,Q,ho="<li>follow the instruction to build</li>",gi,Pt,Mi,F,bo="<li>adapt an example to modular</li>",yi,At,go='We are using <a href="https://huggingface.co/docs/diffusers/using-diffusers/ip_adapter?ipadapter-variants=IP-Adapter+Plus#ip-adapter" rel="nofollow">this one</a> from our IP-Adapter doc!',ji,Dt,wi,Kt,Ti,Ot,Ji;return k=new Z({props:{title:"ModularPipeline",local:"modularpipeline",headingTag:"h1"}}),y=new G({props:{warning:!0,$$slots:{default:[Lo]},$$scope:{ctx:$}}}),v=new G({props:{$$slots:{default:[So]},$$scope:{ctx:$}}}),E=new Z({props:{title:"Create ModularPipelineBlocks",local:"create-modularpipelineblocks",headingTag:"h2"}}),K=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExUZXh0RW5jb2RlclN0ZXAlMEElMEF0ZXh0X2VuY29kZXJfYmxvY2slMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFRleHRFbmNvZGVyU3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> StableDiffusionXLTextEncoderStep

text_encoder_block = StableDiffusionXLTextEncoderStep()`,wrap:!1}}),ee=new M({props:{code:"dGV4dF9lbmNvZGVyX2Jsb2Nr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_block
StableDiffusionXLTextEncoderStep(
  Class: PipelineBlock
  Description: Text Encoder step that generate text_embeddings to guide the image generation
    Components:
        text_encoder (\`CLIPTextModel\`)
        text_encoder_2 (\`CLIPTextModelWithProjection\`)
        tokenizer (\`CLIPTokenizer\`)
        tokenizer_2 (\`CLIPTokenizer\`)
        guider (\`ClassifierFreeGuidance\`)
    Configs:
        force_zeros_for_empty_prompt (default: <span class="hljs-literal">True</span>)
  Inputs:
    prompt=<span class="hljs-literal">None</span>, prompt_2=<span class="hljs-literal">None</span>, negative_prompt=<span class="hljs-literal">None</span>, negative_prompt_2=<span class="hljs-literal">None</span>, cross_attention_kwargs=<span class="hljs-literal">None</span>, clip_skip=<span class="hljs-literal">None</span>
  Intermediates:
    - outputs: prompt_embeds, negative_prompt_embeds, pooled_prompt_embeds, negative_pooled_prompt_embeds
)`,wrap:!1}}),te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUwQWZyb20lMjBkaWZmdXNlcnMubW9kdWxhcl9waXBlbGluZXMuc3RhYmxlX2RpZmZ1c2lvbl94bCUyMGltcG9ydCUyMFRFWFQySU1BR0VfQkxPQ0tTJTBBdDJpX2Jsb2NrcyUyMCUzRCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2Nrcy5mcm9tX2Jsb2Nrc19kaWN0KFRFWFQySU1BR0VfQkxPQ0tTKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> TEXT2IMAGE_BLOCKS
t2i_blocks = SequentialPipelineBlocks.from_blocks_dict(TEXT2IMAGE_BLOCKS)`,wrap:!1}}),ne=new M({props:{code:"dDJpX2Jsb2NrcyUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_blocks
SequentialPipelineBlocks(
  Class: ModularPipelineBlocks

  Description: 


  Components:
      text_encoder (\`CLIPTextModel\`)
      text_encoder_2 (\`CLIPTextModelWithProjection\`)
      tokenizer (\`CLIPTokenizer\`)
      tokenizer_2 (\`CLIPTokenizer\`)
      guider (\`ClassifierFreeGuidance\`)
      scheduler (\`EulerDiscreteScheduler\`)
      unet (\`UNet2DConditionModel\`)
      vae (\`AutoencoderKL\`)
      image_processor (\`VaeImageProcessor\`)

  Configs:
      force_zeros_for_empty_prompt (default: <span class="hljs-literal">True</span>)

  Sub-Blocks:
    [<span class="hljs-number">0</span>] text_encoder (StableDiffusionXLTextEncoderStep)
       Description: Text Encoder step that generate text_embeddings to guide the image generation

    [<span class="hljs-number">1</span>] <span class="hljs-built_in">input</span> (StableDiffusionXLInputStep)
       Description: Input processing step that:
                     <span class="hljs-number">1.</span> Determines \`batch_size\` <span class="hljs-keyword">and</span> \`dtype\` based on \`prompt_embeds\`
                     <span class="hljs-number">2.</span> Adjusts <span class="hljs-built_in">input</span> tensor shapes based on \`batch_size\` (number of prompts) <span class="hljs-keyword">and</span> \`num_images_per_prompt\`
                   
                   All <span class="hljs-built_in">input</span> tensors are expected to have either batch_size=<span class="hljs-number">1</span> <span class="hljs-keyword">or</span> <span class="hljs-keyword">match</span> the batch_size
                   of prompt_embeds. The tensors will be duplicated across the batch dimension to
                   have a final batch_size of batch_size * num_images_per_prompt.

    [<span class="hljs-number">2</span>] set_timesteps (StableDiffusionXLSetTimestepsStep)
       Description: Step that sets the schedule<span class="hljs-string">r&#x27;s timesteps for inference

    [3] prepare_latents (StableDiffusionXLPrepareLatentsStep)
       Description: Prepare latents step that prepares the latents for the text-to-image generation process

    [4] prepare_add_cond (StableDiffusionXLPrepareAdditionalConditioningStep)
       Description: Step that prepares the additional conditioning for the text-to-image generation process

    [5] denoise (StableDiffusionXLDenoiseStep)
       Description: Denoise step that iteratively denoise the latents. 
                   Its loop logic is defined in \`StableDiffusionXLDenoiseLoopWrapper.__call__\` method 
                   At each iteration, it runs blocks defined in \`sub_blocks\` sequencially:
                    - \`StableDiffusionXLLoopBeforeDenoiser\`
                    - \`StableDiffusionXLLoopDenoiser\`
                    - \`StableDiffusionXLLoopAfterDenoiser\`
                   This block supports both text2img and img2img tasks.

    [6] decode (StableDiffusionXLDecodeStep)
       Description: Step that decodes the denoised latents into images

)</span>`,wrap:!1}}),ie=new M({props:{code:"VEVYVDJJTUFHRV9CTE9DS1M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>TEXT2IMAGE_BLOCKS
InsertableDict([
  <span class="hljs-number">0</span>: (<span class="hljs-string">&#x27;text_encoder&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.encoders.StableDiffusionXLTextEncoderStep&#x27;</span>&gt;),
  <span class="hljs-number">1</span>: (<span class="hljs-string">&#x27;input&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLInputStep&#x27;</span>&gt;),
  <span class="hljs-number">2</span>: (<span class="hljs-string">&#x27;set_timesteps&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLSetTimestepsStep&#x27;</span>&gt;),
  <span class="hljs-number">3</span>: (<span class="hljs-string">&#x27;prepare_latents&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLPrepareLatentsStep&#x27;</span>&gt;),
  <span class="hljs-number">4</span>: (<span class="hljs-string">&#x27;prepare_add_cond&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLPrepareAdditionalConditioningStep&#x27;</span>&gt;),
  <span class="hljs-number">5</span>: (<span class="hljs-string">&#x27;denoise&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.denoise.StableDiffusionXLDenoiseLoop&#x27;</span>&gt;),
  <span class="hljs-number">6</span>: (<span class="hljs-string">&#x27;decode&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.decoders.StableDiffusionXLDecodeStep&#x27;</span>&gt;)
])`,wrap:!1}}),oe=new M({props:{code:"dDJpX2Jsb2Nrcy5zdWJfYmxvY2tz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_blocks.sub_blocks
InsertableDict([
  <span class="hljs-number">0</span>: (<span class="hljs-string">&#x27;text_encoder&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.encoders.StableDiffusionXLTextEncoderStep&#x27;</span>&gt;),
  <span class="hljs-number">1</span>: (<span class="hljs-string">&#x27;input&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLInputStep&#x27;</span>&gt;),
  <span class="hljs-number">2</span>: (<span class="hljs-string">&#x27;set_timesteps&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLSetTimestepsStep&#x27;</span>&gt;),
  <span class="hljs-number">3</span>: (<span class="hljs-string">&#x27;prepare_latents&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLPrepareLatentsStep&#x27;</span>&gt;),
  <span class="hljs-number">4</span>: (<span class="hljs-string">&#x27;prepare_add_cond&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.before_denoise.StableDiffusionXLPrepareAdditionalConditioningStep&#x27;</span>&gt;),
  <span class="hljs-number">5</span>: (<span class="hljs-string">&#x27;denoise&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.denoise.StableDiffusionXLDenoiseStep&#x27;</span>&gt;),
  <span class="hljs-number">6</span>: (<span class="hljs-string">&#x27;decode&#x27;</span>, &lt;obj <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.decoders.StableDiffusionXLDecodeStep&#x27;</span>&gt;)
])`,wrap:!1}}),ue=new M({props:{code:"JTIzJTIwQkxPQ0tTJTIwaXMlMjBkaWN0JTIwb2YlMjBibG9jayUyMGNsYXNzZXMlMkMlMjB5b3UlMjBuZWVkJTIwdG8lMjBhZGQlMjBjbGFzcyUyMHRvJTIwaXQlMEFCTE9DS1MuaW5zZXJ0KCUyMmJsb2NrX25hbWUlMjIlMkMlMjBCbG9ja0NsYXNzJTJDJTIwaW5kZXgpJTBBJTIzJTIwc3ViX2Jsb2NrcyUyMGF0dHJpYnV0ZSUyMGNvbnRhaW5zJTIwaW5zdGFuY2UlMkMlMjBhZGQlMjBhJTIwYmxvY2slMjBpbnN0YW5jZSUyMHRvJTIwdGhlJTIwJTIwYXR0cmlidXRlJTBBdDJpX2Jsb2Nrcy5zdWJfYmxvY2tzLmluc2VydCglMjJibG9ja19uYW1lJTIyJTJDJTIwYmxvY2tfaW5zdGFuY2UlMkMlMjBpbmRleCk=",highlighted:`<span class="hljs-comment"># BLOCKS is dict of block classes, you need to add class to it</span>
BLOCKS.insert(<span class="hljs-string">&quot;block_name&quot;</span>, BlockClass, index)
<span class="hljs-comment"># sub_blocks attribute contains instance, add a block instance to the  attribute</span>
t2i_blocks.sub_blocks.insert(<span class="hljs-string">&quot;block_name&quot;</span>, block_instance, index)`,wrap:!1}}),me=new M({props:{code:"JTIzJTIwcmVtb3ZlJTIwYSUyMGJsb2NrJTIwY2xhc3MlMjBmcm9tJTIwcHJlc2V0JTBBQkxPQ0tTLnBvcCglMjJ0ZXh0X2VuY29kZXIlMjIpJTBBJTIzJTIwc3BsaXQlMjBvdXQlMjBhJTIwYmxvY2slMjBpbnN0YW5jZSUyMG9uJTIwaXRzJTIwb3duJTBBdGV4dF9lbmNvZGVyX2Jsb2NrJTIwJTNEJTIwdDJpX2Jsb2Nrcy5zdWJfYmxvY2tzLnBvcCglMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-comment"># remove a block class from preset</span>
BLOCKS.pop(<span class="hljs-string">&quot;text_encoder&quot;</span>)
<span class="hljs-comment"># split out a block instance on its own</span>
text_encoder_block = t2i_blocks.sub_blocks.pop(<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),he=new M({props:{code:"JTIzJTIwUmVwbGFjZSUyMGJsb2NrJTIwY2xhc3MlMjBpbiUyMHByZXNldCUwQUJMT0NLUyU1QiUyMnByZXBhcmVfbGF0ZW50cyUyMiU1RCUyMCUzRCUyMEN1c3RvbVByZXBhcmVMYXRlbnRzJTBBJTIzJTIwUmVwbGFjZSUyMGluJTIwc3ViX2Jsb2NrcyUyMGF0dHJpYnV0ZSUyMHVzaW5nJTIwYW4lMjBibG9jayUyMGluc3RhbmNlJTBBdDJpX2Jsb2Nrcy5zdWJfYmxvY2tzJTVCJTIycHJlcGFyZV9sYXRlbnRzJTIyJTVEJTIwJTNEJTIwQ3VzdG9tUHJlcGFyZUxhdGVudHMoKQ==",highlighted:`<span class="hljs-comment"># Replace block class in preset</span>
BLOCKS[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = CustomPrepareLatents
<span class="hljs-comment"># Replace in sub_blocks attribute using an block instance</span>
t2i_blocks.sub_blocks[<span class="hljs-string">&quot;prepare_latents&quot;</span>] = CustomPrepareLatents()`,wrap:!1}}),Me=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQUNVU1RPTV9CTE9DS1MlMjAlM0QlMjBURVhUMklNQUdFX0JMT0NLUy5jb3B5KCklMEElMjMlMjBDVVNUT01fQkxPQ0tTJTIwaXMlMjBub3clMjBhJTIwcHJlc2V0JTIwaW5jbHVkaW5nJTIwaXBfYWRhcHRlciUwQUNVU1RPTV9CTE9DS1MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9JUEFkYXB0ZXJTdGVwJTJDJTIwMCklMEElMjMlMjBjcmVhdGUlMjBhJTIwYmxvY2tzJTIwaXNudGFuY2UlMjBmcm9tJTIwdGhlJTIwcHJlc2V0JTBBY3VzdG9tX2Jsb2NrcyUyMCUzRCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2Nrcy5mcm9tX2Jsb2Nrc19kaWN0KENVU1RPTV9CTE9DS1Mp",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep
CUSTOM_BLOCKS = TEXT2IMAGE_BLOCKS.copy()
<span class="hljs-comment"># CUSTOM_BLOCKS is now a preset including ip_adapter</span>
CUSTOM_BLOCKS.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, StableDiffusionXLAutoIPAdapterStep, <span class="hljs-number">0</span>)
<span class="hljs-comment"># create a blocks isntance from the preset</span>
custom_blocks = SequentialPipelineBlocks.from_blocks_dict(CUSTOM_BLOCKS)`,wrap:!1}}),je=new M({props:{code:"dGV4dF9lbmNvZGVyX2Jsb2NrcyUyMCUzRCUyMHQyaV9ibG9ja3Muc3ViX2Jsb2Nrcy5wb3AoJTIydGV4dF9lbmNvZGVyJTIyKSUwQXRleHRfZW5jb2Rlcl9ibG9ja3M=",highlighted:`<span class="hljs-comment"># this gives you StableDiffusionXLTextEncoderStep()</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_blocks = t2i_blocks.sub_blocks.pop(<span class="hljs-string">&quot;text_encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_blocks`,wrap:!1}}),Te=new M({props:{code:"dDJpX2Jsb2NrcyUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_blocks
SequentialPipelineBlocks(
  Class: ModularPipelineBlocks

  Description: 

  Components:
      scheduler (\`EulerDiscreteScheduler\`)
      guider (\`ClassifierFreeGuidance\`)
      unet (\`UNet2DConditionModel\`)
      vae (\`AutoencoderKL\`)
      image_processor (\`VaeImageProcessor\`)

  Blocks:
    [<span class="hljs-number">0</span>] <span class="hljs-built_in">input</span> (StableDiffusionXLInputStep)
       Description: Input processing step that:
                     <span class="hljs-number">1.</span> Determines \`batch_size\` <span class="hljs-keyword">and</span> \`dtype\` based on \`prompt_embeds\`
                     <span class="hljs-number">2.</span> Adjusts <span class="hljs-built_in">input</span> tensor shapes based on \`batch_size\` (number of prompts) <span class="hljs-keyword">and</span> \`num_images_per_prompt\`
                   
                   All <span class="hljs-built_in">input</span> tensors are expected to have either batch_size=<span class="hljs-number">1</span> <span class="hljs-keyword">or</span> <span class="hljs-keyword">match</span> the batch_size
                   of prompt_embeds. The tensors will be duplicated across the batch dimension to
                   have a final batch_size of batch_size * num_images_per_prompt.

    [<span class="hljs-number">1</span>] set_timesteps (StableDiffusionXLSetTimestepsStep)
       Description: Step that sets the schedule<span class="hljs-string">r&#x27;s timesteps for inference

    [2] prepare_latents (StableDiffusionXLPrepareLatentsStep)
       Description: Prepare latents step that prepares the latents for the text-to-image generation process

    [3] prepare_add_cond (StableDiffusionXLPrepareAdditionalConditioningStep)
       Description: Step that prepares the additional conditioning for the text-to-image generation process

    [4] denoise (StableDiffusionXLDenoiseLoop)
       Description: Denoise step that iteratively denoise the latents. 
                   Its loop logic is defined in \`StableDiffusionXLDenoiseLoopWrapper.__call__\` method 
                   At each iteration, it runs blocks defined in \`blocks\` sequencially:
                    - \`StableDiffusionXLLoopBeforeDenoiser\`
                    - \`StableDiffusionXLLoopDenoiser\`
                    - \`StableDiffusionXLLoopAfterDenoiser\`
                   

    [5] decode (StableDiffusionXLDecodeStep)
       Description: Step that decodes the denoised latents into images

)</span>`,wrap:!1}}),C=new G({props:{$$slots:{default:[Yo]},$$scope:{ctx:$}}}),_e=new Z({props:{title:"Modular Repo",local:"modular-repo",headingTag:"h2"}}),Be=new M({props:{code:"JTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSU1RCUyQw==",highlighted:`<span class="hljs-string">&quot;text_encoder&quot;</span>: [
  <span class="hljs-string">&quot;transformers&quot;</span>,
  <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
],`,wrap:!1}}),ve=new M({props:{code:"JTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwbnVsbCUyQyUyMCUyMCUyMyUyMGxpYnJhcnklMjBvZiUyMGFjdHVhbCUyMGxvYWRlZCUyMGNvbXBvbmVudCUyMChzYW1lJTIwYXMlMjBpbiUyMG1vZGVsX2luZGV4Lmpzb24pJTBBJTIwJTIwbnVsbCUyQyUyMCUyMCUyMyUyMGNsYXNzJTIwb2YlMjBhY3R1YWwlMjBsb2FkZWQlMjBjb21wb25lbmV0JTIwKHNhbWUlMjBhcyUyMGluJTIwbW9kZWxfaW5kZXguanNvbiklMEElMjAlMjAlN0IlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb2FkaW5nJTIwc3BlY3MlMjBtYXAlMjAodW5pcXVlJTIwdG8lMjBtb2R1bGFyX21vZGVsX2luZGV4Lmpzb24pJTBBJTIwJTIwJTIwJTIwJTIycmVwbyUyMiUzQSUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMCUyMCUyMyUyMGNhbiUyMGJlJTIwYSUyMGRpZmZlcmVudCUyMHJlcG8lMEElMjAlMjAlMjAlMjAlMjJyZXZpc2lvbiUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlMjJzdWJmb2xkZXIlMjIlM0ElMjAlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0eXBlX2hpbnQlMjIlM0ElMjAlNUIlMjAlMjAlMjMlMjAobGlicmFyeSUyQyUyMGNsYXNzKSUyMGZvciUyMHRoZSUyMGV4cGVjdGVkJTIwY29tcG9uZW50JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhcmlhbnQlMjIlM0ElMjBudWxsJTBBJTIwJTIwJTdEJTBBJTVEJTJD",highlighted:`<span class="hljs-string">&quot;text_encoder&quot;</span>: [
  null,  <span class="hljs-comment"># library of actual loaded component (same as in model_index.json)</span>
  null,  <span class="hljs-comment"># class of actual loaded componenet (same as in model_index.json)</span>
  {      <span class="hljs-comment"># loading specs map (unique to modular_model_index.json)</span>
    <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,  <span class="hljs-comment"># can be a different repo</span>
    <span class="hljs-string">&quot;revision&quot;</span>: null,
    <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;text_encoder&quot;</span>,
    <span class="hljs-string">&quot;type_hint&quot;</span>: [  <span class="hljs-comment"># (library, class) for the expected component</span>
      <span class="hljs-string">&quot;transformers&quot;</span>,  
      <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
    ],
    <span class="hljs-string">&quot;variant&quot;</span>: null
  }
],`,wrap:!1}}),We=new Z({props:{title:"Creating a ModularPipeline from ModularPipelineBlocks",local:"creating-a-modularpipeline-from-modularpipelineblocks",headingTag:"h2"}}),Ve=new M({props:{code:"JTIzJTIwV2UlMjBhbHJlYWR5JTIwaGF2ZSUyMHRoaXMlMjBmcm9tJTIwZWFybGllciUwQXQyaV9ibG9ja3MlMjAlM0QlMjBTZXF1ZW50aWFsUGlwZWxpbmVCbG9ja3MuZnJvbV9ibG9ja3NfZGljdChURVhUMklNQUdFX0JMT0NLUyklMEElMEElMjMlMjBOb3clMjBjb252ZXJ0JTIwaXQlMjB0byUyMGElMjBNb2R1bGFyUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29tcG9uZW50c01hbmFnZXIlMEFtb2R1bGFyX3JlcG9faWQlMjAlM0QlMjAlMjJZaVlpWHUlMkZtb2R1bGFyLWxvYWRlci10MmktMDcwNCUyMiUwQWNvbXBvbmVudHMlMjAlM0QlMjBDb21wb25lbnRzTWFuYWdlcigpJTBBdDJpX3BpcGVsaW5lJTIwJTNEJTIwdDJpX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKG1vZHVsYXJfcmVwb19pZCUyQyUyMGNvbXBvbmVudHNfbWFuYWdlciUzRGNvbXBvbmVudHMp",highlighted:`<span class="hljs-comment"># We already have this from earlier</span>
t2i_blocks = SequentialPipelineBlocks.from_blocks_dict(TEXT2IMAGE_BLOCKS)

<span class="hljs-comment"># Now convert it to a ModularPipeline</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentsManager
modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-0704&quot;</span>
components = ComponentsManager()
t2i_pipeline = t2i_blocks.init_pipeline(modular_repo_id, components_manager=components)`,wrap:!1}}),W=new G({props:{$$slots:{default:[Ro]},$$scope:{ctx:$}}}),Se=new Z({props:{title:"Creating a ModularPipeline with from_pretrained",local:"creating-a-modularpipeline-with-frompretrained",headingTag:"h2"}}),Re=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME1vZHVsYXJQaXBlbGluZSUyQyUyMENvbXBvbmVudHNNYW5hZ2VyJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudHNNYW5hZ2VyKCklMEFwaXBlbGluZSUyMCUzRCUyME1vZHVsYXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyWWlZaVh1JTJGbW9kdWxhci1sb2FkZXItdDJpLTA3MDQlMjIlMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager
components = ComponentsManager()
pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-0704&quot;</span>, components_manager=components)`,wrap:!1}}),He=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME1vZHVsYXJQaXBlbGluZSUyQyUyMENvbXBvbmVudHNNYW5hZ2VyJTBBY29tcG9uZW50cyUyMCUzRCUyMENvbXBvbmVudHNNYW5hZ2VyKCklMEFtb2R1bGFyX3JlcG9faWQlMjAlM0QlMjAlMjJZaVlpWHUlMkZtb2R1bGFyLWRpZmZkaWZmLTA3MDQlMjIlMEFkaWZmZGlmZl9waXBlbGluZSUyMCUzRCUyME1vZHVsYXJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kdWxhcl9yZXBvX2lkJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTIwY29tcG9uZW50c19tYW5hZ2VyJTNEY29tcG9uZW50cyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager
components = ComponentsManager()
modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-diffdiff-0704&quot;</span>
diffdiff_pipeline = ModularPipeline.from_pretrained(modular_repo_id, trust_remote_code=<span class="hljs-literal">True</span>, components_manager=components)`,wrap:!1}}),Fe=new M({props:{code:"bW9kdWxhci1kaWZmZGlmZi0wNzA0JTJGJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwYmxvY2sucHklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDdXN0b20lMjBwaXBlbGluZSUyMGJsb2NrcyUyMGltcGxlbWVudGF0aW9uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQaXBlbGluZSUyMGNvbmZpZ3VyYXRpb24lMjBhbmQlMjBhdXRvX21hcCUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG1vZHVsYXJfbW9kZWxfaW5kZXguanNvbiUyMCUyMCUyMCUyMCUyMyUyMENvbXBvbmVudCUyMGxvYWRpbmclMjBzcGVjaWZpY2F0aW9ucw==",highlighted:`modular-<span class="hljs-keyword">diffdiff-0704/
</span>├── <span class="hljs-keyword">block.py </span>                   <span class="hljs-comment"># Custom pipeline blocks implementation</span>
├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json </span>                <span class="hljs-comment"># Pipeline configuration and auto_map</span>
└── modular_model_index.<span class="hljs-keyword">json </span>   <span class="hljs-comment"># Component loading specifications</span>`,wrap:!1}}),ze=new M({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJEaWZmRGlmZkJsb2NrcyUyMiUyQyUwQSUyMCUyMCUyMmF1dG9fbWFwJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyTW9kdWxhclBpcGVsaW5lQmxvY2tzJTIyJTNBJTIwJTIyYmxvY2suRGlmZkRpZmZCbG9ja3MlMjIlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;DiffDiffBlocks&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;auto_map&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;ModularPipelineBlocks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;block.DiffDiffBlocks&quot;</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),De=new Z({props:{title:"Loading components into a ModularPipeline",local:"loading-components-into-a-modularpipeline",headingTag:"h2"}}),Oe=new M({props:{code:"JTIzJTIwVGhpcyUyMHdpbGwlMjBsb2FkJTIwQUxMJTIwdGhlJTIwZXhwZWN0ZWQlMjBjb21wb25lbnRzJTIwaW50byUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEF0MmlfcGlwZWxpbmUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXQyaV9waXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-comment"># This will load ALL the expected components into pipeline</span>
<span class="hljs-keyword">import</span> torch
t2i_pipeline.load_default_components(torch_dtype=torch.float16)
t2i_pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ss=new M({props:{code:"dDJpX3BpcGVsaW5lLmxvYWRfY29tcG9uZW50cyhuYW1lcyUzRCU1QiUyMnVuZXQlMjIlMkMlMjAlMjJ2YWUlMjIlNUQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.load_components(names=[<span class="hljs-string">&quot;unet&quot;</span>, <span class="hljs-string">&quot;vae&quot;</span>], torch_dtype=torch.float16)',wrap:!1}}),ls=new M({props:{code:"dDJpX3BpcGVsaW5l",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline
StableDiffusionXLModularPipeline {
  <span class="hljs-string">&quot;_blocks_class_name&quot;</span>: <span class="hljs-string">&quot;SequentialPipelineBlocks&quot;</span>,
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;StableDiffusionXLModularPipeline&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.35.0.dev0&quot;</span>,
  <span class="hljs-string">&quot;force_zeros_for_empty_prompt&quot;</span>: true,
  <span class="hljs-string">&quot;scheduler&quot;</span>: [
    null,
    null,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;scheduler&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;diffusers&quot;</span>,
        <span class="hljs-string">&quot;EulerDiscreteScheduler&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: null
    }
  ],
  <span class="hljs-string">&quot;text_encoder&quot;</span>: [
    null,
    null,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;text_encoder&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;transformers&quot;</span>,
        <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: null
    }
  ],
  <span class="hljs-string">&quot;text_encoder_2&quot;</span>: [
    null,
    null,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;text_encoder_2&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;transformers&quot;</span>,
        <span class="hljs-string">&quot;CLIPTextModelWithProjection&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: null
    }
  ],
  <span class="hljs-string">&quot;tokenizer&quot;</span>: [
    null,
    null,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;tokenizer&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;transformers&quot;</span>,
        <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: null
    }
  ],
  <span class="hljs-string">&quot;tokenizer_2&quot;</span>: [
    null,
    null,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;tokenizer_2&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;transformers&quot;</span>,
        <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: null
    }
  ],
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;unet&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;diffusers&quot;</span>,
        <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: <span class="hljs-string">&quot;fp16&quot;</span>
    }
  ],
  <span class="hljs-string">&quot;vae&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: null,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;diffusers&quot;</span>,
        <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: null
    }
  ]
}`,wrap:!1}}),us=new M({props:{code:"dDJpX3BpcGVsaW5lLmNvbXBvbmVudF9uYW1lcyUwQSUwQXQyaV9waXBlbGluZS5udWxsX2NvbXBvbmVudF9uYW1lcyUwQSUwQXQyaV9waXBlbGluZS5wcmV0cmFpbmVkX2NvbXBvbmVudF9uYW1lcyUwQSUwQXQyaV9waXBlbGluZS5jb25maWdfY29tcG9uZW50X25hbWVz",highlighted:`<span class="hljs-comment"># All components expected by the pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.component_names
[<span class="hljs-string">&#x27;text_encoder&#x27;</span>, <span class="hljs-string">&#x27;text_encoder_2&#x27;</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>, <span class="hljs-string">&#x27;tokenizer_2&#x27;</span>, <span class="hljs-string">&#x27;guider&#x27;</span>, <span class="hljs-string">&#x27;scheduler&#x27;</span>, <span class="hljs-string">&#x27;unet&#x27;</span>, <span class="hljs-string">&#x27;vae&#x27;</span>, <span class="hljs-string">&#x27;image_processor&#x27;</span>]

<span class="hljs-comment"># Components that are not loaded yet (will be loaded with from_pretrained)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.null_component_names
[<span class="hljs-string">&#x27;text_encoder&#x27;</span>, <span class="hljs-string">&#x27;text_encoder_2&#x27;</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>, <span class="hljs-string">&#x27;tokenizer_2&#x27;</span>, <span class="hljs-string">&#x27;scheduler&#x27;</span>]

<span class="hljs-comment"># Components that will be loaded from pretrained models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.pretrained_component_names
[<span class="hljs-string">&#x27;text_encoder&#x27;</span>, <span class="hljs-string">&#x27;text_encoder_2&#x27;</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>, <span class="hljs-string">&#x27;tokenizer_2&#x27;</span>, <span class="hljs-string">&#x27;scheduler&#x27;</span>, <span class="hljs-string">&#x27;unet&#x27;</span>, <span class="hljs-string">&#x27;vae&#x27;</span>]

<span class="hljs-comment"># Components that are created with default config (no repo needed)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.config_component_names
[<span class="hljs-string">&#x27;guider&#x27;</span>, <span class="hljs-string">&#x27;image_processor&#x27;</span>]`,wrap:!1}}),ms=new Z({props:{title:"Modifying Loading Specs",local:"modifying-loading-specs",headingTag:"h2"}}),hs=new M({props:{code:"JTIzJTIwT3JpZ2luYWwlMjBzcGVjJTIwaW4lMjBtb2R1bGFyX21vZGVsX2luZGV4Lmpzb24lMEElMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwbnVsbCUyQyUyMG51bGwlMkMlMEElMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJyZXBvJTIyJTNBJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3ViZm9sZGVyJTIyJTNBJTIwJTIydW5ldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhcmlhbnQlMjIlM0ElMjAlMjJmcDE2JTIyJTBBJTIwJTIwJTdEJTBBJTVEJTBBJTBBJTIzJTIwTW9kaWZpZWQlMjBzcGVjJTIwLSUyMGNoYW5nZWQlMjByZXBvJTJDJTIwc3ViZm9sZGVyJTJDJTIwYW5kJTIwdmFyaWFudCUwQSUyMnVuZXQlMjIlM0ElMjAlNUIlMEElMjAlMjBudWxsJTJDJTIwbnVsbCUyQyUwQSUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnJlcG8lMjIlM0ElMjAlMjJSdW5EaWZmdXNpb24lMkZKdWdnZXJuYXV0LVhMLXY5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3ViZm9sZGVyJTIyJTNBJTIwJTIydW5ldCUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnZhcmlhbnQlMjIlM0ElMjAlMjJmcDE2JTIyJTBBJTIwJTIwJTdEJTBBJTVE",highlighted:`<span class="hljs-comment"># Original spec in modular_model_index.json</span>
<span class="hljs-string">&quot;unet&quot;</span>: [
  null, null,
  {
    <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;unet&quot;</span>,
    <span class="hljs-string">&quot;variant&quot;</span>: <span class="hljs-string">&quot;fp16&quot;</span>
  }
]

<span class="hljs-comment"># Modified spec - changed repo, subfolder, and variant</span>
<span class="hljs-string">&quot;unet&quot;</span>: [
  null, null,
  {
    <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>,
    <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;unet&quot;</span>, 
    <span class="hljs-string">&quot;variant&quot;</span>: <span class="hljs-string">&quot;fp16&quot;</span>
  }
]`,wrap:!1}}),gs=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBNb2R1bGFyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRm1vZHVsYXItbG9hZGVyLXQyaS0wNzA0JTIyJTJDJTIwY29tcG9uZW50c19tYW5hZ2VyJTNEY29tcG9uZW50cyklMEFwaXBlbGluZS5sb2FkX2NvbXBvbmVudHMobmFtZXMlM0QlMjJ1bmV0JTIyKQ==",highlighted:`pipeline = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-0704&quot;</span>, components_manager=components)
pipeline.load_components(names=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),Ms=new Z({props:{title:"Updating components in a ModularPipeline",local:"updating-components-in-a-modularpipeline",headingTag:"h2"}}),q=new G({props:{$$slots:{default:[No]},$$scope:{ctx:$}}}),_s=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEF1bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel
<span class="hljs-keyword">import</span> torch
unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),$s=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudFNwZWMlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUwQXVuZXRfc3BlYyUyMCUzRCUyMENvbXBvbmVudFNwZWMobmFtZSUzRCUyMnVuZXQlMjIlMkN0eXBlX2hpbnQlM0RVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMHJlcG8lM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBdW5ldDIlMjAlM0QlMjB1bmV0X3NwZWMubG9hZCh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentSpec, UNet2DConditionModel
unet_spec = ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>,type_hint=UNet2DConditionModel, repo=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
unet2 = unet_spec.load(torch_dtype=torch.float16)`,wrap:!1}}),xs=new M({props:{code:"c3BlYyUyMCUzRCUyMENvbXBvbmVudFNwZWMuZnJvbV9jb21wb25lbnQoJTIydW5ldCUyMiUyQyUyMHVuZXQyKSUwQXNwZWMlMEF1bmV0Ml9yZWNyZWF0ZCUyMCUzRCUyMHNwZWMubG9hZCh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-comment"># component -&gt; spec</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>spec = ComponentSpec.from_component(<span class="hljs-string">&quot;unet&quot;</span>, unet2)
<span class="hljs-meta">&gt;&gt;&gt; </span>spec
ComponentSpec(name=<span class="hljs-string">&#x27;unet&#x27;</span>, type_hint=&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.models.unets.unet_2d_condition.UNet2DConditionModel&#x27;</span>&gt;, description=<span class="hljs-literal">None</span>, config=<span class="hljs-literal">None</span>, repo=<span class="hljs-string">&#x27;stabilityai/stable-diffusion-xl-base-1.0&#x27;</span>, subfolder=<span class="hljs-string">&#x27;unet&#x27;</span>, variant=<span class="hljs-string">&#x27;fp16&#x27;</span>, revision=<span class="hljs-literal">None</span>, default_creation_method=<span class="hljs-string">&#x27;from_pretrained&#x27;</span>)
<span class="hljs-comment"># spec -&gt; component</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>unet2_recreatd = spec.load(torch_dtype=torch.float16)`,wrap:!1}}),Bs=new M({props:{code:"dDJpX3BpcGVsaW5lLnVwZGF0ZV9jb21wb25lbnRzKHVuZXQlM0R1bmV0Mik=",highlighted:'t2i_pipeline.update<span class="hljs-constructor">_components(<span class="hljs-params">unet</span>=<span class="hljs-params">unet2</span>)</span>',wrap:!1}}),Is=new M({props:{code:"dDJpX3BpcGVsaW5l",highlighted:`&gt;&gt;&gt; t2i_pipeline
<span class="hljs-symbol">StableDiffusionXLModularPipeline</span> {
  ...
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>,
    {
      <span class="hljs-string">&quot;repo&quot;</span>: <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
      <span class="hljs-string">&quot;revision&quot;</span>: null,
      <span class="hljs-string">&quot;subfolder&quot;</span>: <span class="hljs-string">&quot;unet&quot;</span>,
      <span class="hljs-string">&quot;type_hint&quot;</span>: [
        <span class="hljs-string">&quot;diffusers&quot;</span>,
        <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
      ],
      <span class="hljs-string">&quot;variant&quot;</span>: <span class="hljs-string">&quot;fp16&quot;</span>
    }
  ],
  ...
}  `,wrap:!1}}),X=new G({props:{$$slots:{default:[Ho]},$$scope:{ctx:$}}}),vs=new Z({props:{title:"Customizing Guidance Techniques",local:"customizing-guidance-techniques",headingTag:"h2"}}),Vs=new M({props:{code:"dDJpX3BpcGVsaW5lLmdldF9jb21wb25lbnRfc3BlYyglMjJndWlkZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.get_component_spec(<span class="hljs-string">&quot;guider&quot;</span>)
ComponentSpec(name=<span class="hljs-string">&#x27;guider&#x27;</span>, type_hint=&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.guiders.classifier_free_guidance.ClassifierFreeGuidance&#x27;</span>&gt;, description=<span class="hljs-literal">None</span>, config=FrozenDict([(<span class="hljs-string">&#x27;guidance_scale&#x27;</span>, <span class="hljs-number">7.5</span>), (<span class="hljs-string">&#x27;guidance_rescale&#x27;</span>, <span class="hljs-number">0.0</span>), (<span class="hljs-string">&#x27;use_original_formulation&#x27;</span>, <span class="hljs-literal">False</span>), (<span class="hljs-string">&#x27;start&#x27;</span>, <span class="hljs-number">0.0</span>), (<span class="hljs-string">&#x27;stop&#x27;</span>, <span class="hljs-number">1.0</span>), (<span class="hljs-string">&#x27;_use_default_values&#x27;</span>, [<span class="hljs-string">&#x27;start&#x27;</span>, <span class="hljs-string">&#x27;guidance_rescale&#x27;</span>, <span class="hljs-string">&#x27;stop&#x27;</span>, <span class="hljs-string">&#x27;use_original_formulation&#x27;</span>])]), repo=<span class="hljs-literal">None</span>, subfolder=<span class="hljs-literal">None</span>, variant=<span class="hljs-literal">None</span>, revision=<span class="hljs-literal">None</span>, default_creation_method=<span class="hljs-string">&#x27;from_config&#x27;</span>)`,wrap:!1}}),Ss=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjB0MmlfYmxvY2tzLmluaXRfcGlwZWxpbmUoKSUwQXBpcGVsaW5lLmd1aWRlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = t2i_blocks.init_pipeline()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.guider
ClassifierFreeGuidance {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;ClassifierFreeGuidance&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.35.0.dev0&quot;</span>,
  <span class="hljs-string">&quot;guidance_rescale&quot;</span>: <span class="hljs-number">0.0</span>,
  <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">7.5</span>,
  <span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-number">0.0</span>,
  <span class="hljs-string">&quot;stop&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;use_original_formulation&quot;</span>: false
}`,wrap:!1}}),Ys=new Z({props:{title:"Modify Parameters of the Same Guider Type",local:"modify-parameters-of-the-same-guider-type",headingTag:"h4"}}),Qs=new M({props:{code:"Z3VpZGVyX3NwZWMlMjAlM0QlMjB0MmlfcGlwZWxpbmUuZ2V0X2NvbXBvbmVudF9zcGVjKCUyMmd1aWRlciUyMiklMEFndWlkZXIlMjAlM0QlMjBndWlkZXJfc3BlYy5jcmVhdGUoZ3VpZGFuY2Vfc2NhbGUlM0QxMCklMEF0MmlfcGlwZWxpbmUudXBkYXRlX2NvbXBvbmVudHMoZ3VpZGVyJTNEZ3VpZGVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>guider_spec = t2i_pipeline.get_component_spec(<span class="hljs-string">&quot;guider&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>guider = guider_spec.create(guidance_scale=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.update_components(guider=guider)`,wrap:!1}}),zs=new M({props:{code:"Z3VpZGVyX3NwZWMlMjAlM0QlMjB0MmlfcGlwZWxpbmUuZ2V0X2NvbXBvbmVudF9zcGVjKCUyMmd1aWRlciUyMiklMEFndWlkZXJfc3BlYy5jb25maWclNUIlMjJndWlkYW5jZV9zY2FsZSUyMiU1RCUyMCUzRCUyMDEwJTBBdDJpX3BpcGVsaW5lLnVwZGF0ZV9jb21wb25lbnRzKGd1aWRlciUzRGd1aWRlcl9zcGVjKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>guider_spec = t2i_pipeline.get_component_spec(<span class="hljs-string">&quot;guider&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>guider_spec.config[<span class="hljs-string">&quot;guidance_scale&quot;</span>] = <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.update_components(guider=guider_spec)`,wrap:!1}}),As=new M({props:{code:"dDJpX3BpcGVsaW5lLmd1aWRlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.guider
ClassifierFreeGuidance {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;ClassifierFreeGuidance&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.35.0.dev0&quot;</span>,
  <span class="hljs-string">&quot;guidance_rescale&quot;</span>: <span class="hljs-number">0.0</span>,
  <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">10</span>,
  <span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-number">0.0</span>,
  <span class="hljs-string">&quot;stop&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;use_original_formulation&quot;</span>: false
}`,wrap:!1}}),Ds=new Z({props:{title:"Switch to a Different Guider Type",local:"switch-to-a-different-guider-type",headingTag:"h4"}}),Os=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExheWVyU2tpcENvbmZpZyUyQyUyMFBlcnR1cmJlZEF0dGVudGlvbkd1aWRhbmNlJTBBY29uZmlnJTIwJTNEJTIwTGF5ZXJTa2lwQ29uZmlnKGluZGljZXMlM0QlNUIyJTJDJTIwOSU1RCUyQyUyMGZxbiUzRCUyMm1pZF9ibG9jay5hdHRlbnRpb25zLjAudHJhbnNmb3JtZXJfYmxvY2tzJTIyJTJDJTIwc2tpcF9hdHRlbnRpb24lM0RGYWxzZSUyQyUyMHNraXBfYXR0ZW50aW9uX3Njb3JlcyUzRFRydWUlMkMlMjBza2lwX2ZmJTNERmFsc2UpJTBBZ3VpZGVyJTIwJTNEJTIwUGVydHVyYmVkQXR0ZW50aW9uR3VpZGFuY2UoJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q1LjAlMkMlMjBwZXJ0dXJiZWRfZ3VpZGFuY2Vfc2NhbGUlM0QyLjUlMkMlMjBwZXJ0dXJiZWRfZ3VpZGFuY2VfY29uZmlnJTNEY29uZmlnJTBBKSUwQXQyaV9waXBlbGluZS51cGRhdGVfY29tcG9uZW50cyhndWlkZXIlM0RndWlkZXIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LayerSkipConfig, PerturbedAttentionGuidance
config = LayerSkipConfig(indices=[<span class="hljs-number">2</span>, <span class="hljs-number">9</span>], fqn=<span class="hljs-string">&quot;mid_block.attentions.0.transformer_blocks&quot;</span>, skip_attention=<span class="hljs-literal">False</span>, skip_attention_scores=<span class="hljs-literal">True</span>, skip_ff=<span class="hljs-literal">False</span>)
guider = PerturbedAttentionGuidance(
    guidance_scale=<span class="hljs-number">5.0</span>, perturbed_guidance_scale=<span class="hljs-number">2.5</span>, perturbed_guidance_config=config
)
t2i_pipeline.update_components(guider=guider)`,wrap:!1}}),st=new M({props:{code:"TW9kdWxhclBpcGVsaW5lLnVwZGF0ZV9jb21wb25lbnRzJTNBJTIwYWRkaW5nJTIwZ3VpZGVyJTIwd2l0aCUyMG5ldyUyMHR5cGUlM0ElMjBQZXJ0dXJiZWRBdHRlbnRpb25HdWlkYW5jZSUyQyUyMHByZXZpb3VzJTIwdHlwZSUzQSUyMENsYXNzaWZpZXJGcmVlR3VpZGFuY2U=",highlighted:'<span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">ModularPipeline</span>.</span></span>update_components: adding guider <span class="hljs-keyword">with</span> <span class="hljs-keyword">new</span> <span class="hljs-keyword">type</span>: PerturbedAttentionGuidance, previous <span class="hljs-keyword">type</span>: ClassifierFreeGuidance',wrap:!1}}),V=new G({props:{$$slots:{default:[Qo]},$$scope:{ctx:$}}}),lt=new M({props:{code:"dDJpX3BpcGVsaW5lLmd1aWRlciUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.guider
PerturbedAttentionGuidance {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;PerturbedAttentionGuidance&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.35.0.dev0&quot;</span>,
  <span class="hljs-string">&quot;guidance_rescale&quot;</span>: <span class="hljs-number">0.0</span>,
  <span class="hljs-string">&quot;guidance_scale&quot;</span>: <span class="hljs-number">5.0</span>,
  <span class="hljs-string">&quot;perturbed_guidance_config&quot;</span>: {
    <span class="hljs-string">&quot;dropout&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;fqn&quot;</span>: <span class="hljs-string">&quot;mid_block.attentions.0.transformer_blocks&quot;</span>,
    <span class="hljs-string">&quot;indices&quot;</span>: [
      <span class="hljs-number">2</span>,
      <span class="hljs-number">9</span>
    ],
    <span class="hljs-string">&quot;skip_attention&quot;</span>: false,
    <span class="hljs-string">&quot;skip_attention_scores&quot;</span>: true,
    <span class="hljs-string">&quot;skip_ff&quot;</span>: false
  },
  <span class="hljs-string">&quot;perturbed_guidance_layers&quot;</span>: null,
  <span class="hljs-string">&quot;perturbed_guidance_scale&quot;</span>: <span class="hljs-number">2.5</span>,
  <span class="hljs-string">&quot;perturbed_guidance_start&quot;</span>: <span class="hljs-number">0.01</span>,
  <span class="hljs-string">&quot;perturbed_guidance_stop&quot;</span>: <span class="hljs-number">0.2</span>,
  <span class="hljs-string">&quot;start&quot;</span>: <span class="hljs-number">0.0</span>,
  <span class="hljs-string">&quot;stop&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;use_original_formulation&quot;</span>: false
}
`,wrap:!1}}),at=new M({props:{code:"dDJpX3BpcGVsaW5lLmdldF9jb21wb25lbnRfc3BlYyglMjJndWlkZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_pipeline.get_component_spec(<span class="hljs-string">&quot;guider&quot;</span>)
ComponentSpec(name=<span class="hljs-string">&#x27;guider&#x27;</span>, type_hint=&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.guiders.perturbed_attention_guidance.PerturbedAttentionGuidance&#x27;</span>&gt;, description=<span class="hljs-literal">None</span>, config=FrozenDict([(<span class="hljs-string">&#x27;guidance_scale&#x27;</span>, <span class="hljs-number">5.0</span>), (<span class="hljs-string">&#x27;perturbed_guidance_scale&#x27;</span>, <span class="hljs-number">2.5</span>), (<span class="hljs-string">&#x27;perturbed_guidance_start&#x27;</span>, <span class="hljs-number">0.01</span>), (<span class="hljs-string">&#x27;perturbed_guidance_stop&#x27;</span>, <span class="hljs-number">0.2</span>), (<span class="hljs-string">&#x27;perturbed_guidance_layers&#x27;</span>, <span class="hljs-literal">None</span>), (<span class="hljs-string">&#x27;perturbed_guidance_config&#x27;</span>, LayerSkipConfig(indices=[<span class="hljs-number">2</span>, <span class="hljs-number">9</span>], fqn=<span class="hljs-string">&#x27;mid_block.attentions.0.transformer_blocks&#x27;</span>, skip_attention=<span class="hljs-literal">False</span>, skip_attention_scores=<span class="hljs-literal">True</span>, skip_ff=<span class="hljs-literal">False</span>, dropout=<span class="hljs-number">1.0</span>)), (<span class="hljs-string">&#x27;guidance_rescale&#x27;</span>, <span class="hljs-number">0.0</span>), (<span class="hljs-string">&#x27;use_original_formulation&#x27;</span>, <span class="hljs-literal">False</span>), (<span class="hljs-string">&#x27;start&#x27;</span>, <span class="hljs-number">0.0</span>), (<span class="hljs-string">&#x27;stop&#x27;</span>, <span class="hljs-number">1.0</span>), (<span class="hljs-string">&#x27;_use_default_values&#x27;</span>, [<span class="hljs-string">&#x27;perturbed_guidance_start&#x27;</span>, <span class="hljs-string">&#x27;use_original_formulation&#x27;</span>, <span class="hljs-string">&#x27;perturbed_guidance_layers&#x27;</span>, <span class="hljs-string">&#x27;stop&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>, <span class="hljs-string">&#x27;guidance_rescale&#x27;</span>, <span class="hljs-string">&#x27;perturbed_guidance_stop&#x27;</span>]), (<span class="hljs-string">&#x27;_class_name&#x27;</span>, <span class="hljs-string">&#x27;PerturbedAttentionGuidance&#x27;</span>), (<span class="hljs-string">&#x27;_diffusers_version&#x27;</span>, <span class="hljs-string">&#x27;0.35.0.dev0&#x27;</span>)]), repo=<span class="hljs-literal">None</span>, subfolder=<span class="hljs-literal">None</span>, variant=<span class="hljs-literal">None</span>, revision=<span class="hljs-literal">None</span>, default_creation_method=<span class="hljs-string">&#x27;from_config&#x27;</span>)`,wrap:!1}}),pt=new M({props:{code:"YXNzZXJ0JTIwJTIyZ3VpZGVyJTIyJTIwbm90JTIwaW4lMjAlMjB0MmlfcGlwZWxpbmUuY29uZmln",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> <span class="hljs-string">&quot;guider&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span>  t2i_pipeline.config',wrap:!1}}),rt=new Z({props:{title:"Loading Custom Guiders from Hub",local:"loading-custom-guiders-from-hub",headingTag:"h4"}}),dt=new M({props:{code:"JTdCJTBBJTIwJTIwJTIyZ3VpZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBvJTIyJTNBJTIwJTIyWWlZaVh1JTJGbW9kdWxhci1sb2FkZXItdDJpLWd1aWRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJldmlzaW9uJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1YmZvbGRlciUyMiUzQSUyMCUyMnBhZ19ndWlkZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlX2hpbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQZXJ0dXJiZWRBdHRlbnRpb25HdWlkYW5jZSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZhcmlhbnQlMjIlM0ElMjBudWxsJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;guider&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-guider&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;subfolder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;pag_guider&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;type_hint&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;PerturbedAttentionGuidance&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;variant&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ft=new M({props:{code:"dDJpX3BpcGVsaW5lJTIwJTNEJTIwdDJpX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKCUyMllpWWlYdSUyRm1vZHVsYXItZG9jLWd1aWRlciUyMiklMEFhc3NlcnQlMjB0MmlfcGlwZWxpbmUuZ3VpZGVyJTIwaXMlMjBOb25lJTIwJTIwJTIzJTIwTm90JTIwY3JlYXRlZCUyMGR1cmluZyUyMGluaXQlMEF0MmlfcGlwZWxpbmUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHMoKSUwQXQyaV9waXBlbGluZS5ndWlkZXIlMjAlMjAlMjMlMjBOb3clMjBsb2FkZWQlMjBhcyUyMFBBRyUyMGd1aWRlcg==",highlighted:`t2i_pipeline = t2i_blocks.init_pipeline(<span class="hljs-string">&quot;YiYiXu/modular-doc-guider&quot;</span>)
<span class="hljs-keyword">assert</span> t2i_pipeline.guider <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>  <span class="hljs-comment"># Not created during init</span>
t2i_pipeline.load_default_components()
t2i_pipeline.guider  <span class="hljs-comment"># Now loaded as PAG guider</span>`,wrap:!1}}),ht=new Z({props:{title:"Upload Custom Guider to Hub for Easy Loading & Sharing",local:"upload-custom-guider-to-hub-for-easy-loading--sharing",headingTag:"h4"}}),gt=new M({props:{code:"Z3VpZGVyLnB1c2hfdG9faHViKCUyMllpWWlYdSUyRm1vZHVsYXItbG9hZGVyLXQyaS1ndWlkZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJwYWdfZ3VpZGVyJTIyKQ==",highlighted:'guider.push_to_hub(<span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-guider&quot;</span>, subfolder=<span class="hljs-string">&quot;pag_guider&quot;</span>)',wrap:!1}}),Tt=new M({props:{code:"Z3VpZGVyX3NwZWMlMjAlM0QlMjB0MmlfcGlwZWxpbmUuZ2V0X2NvbXBvbmVudF9zcGVjKCUyMmd1aWRlciUyMiklMEFndWlkZXJfc3BlYy5kZWZhdWx0X2NyZWF0aW9uX21ldGhvZCUzRCUyMmZyb21fcHJldHJhaW5lZCUyMiUwQWd1aWRlcl9zcGVjLnJlcG8lM0QlMjJZaVlpWHUlMkZtb2R1bGFyLWxvYWRlci10MmktZ3VpZGVyJTIyJTBBZ3VpZGVyX3NwZWMuc3ViZm9sZGVyJTNEJTIycGFnX2d1aWRlciUyMiUwQXBhZ19ndWlkZXIlMjAlM0QlMjBndWlkZXJfc3BlYy5sb2FkKCklMEF0MmlfcGlwZWxpbmUudXBkYXRlX2NvbXBvbmVudHMoZ3VpZGVyJTNEcGFnX2d1aWRlcik=",highlighted:`guider_spec = t2i_pipeline.get_component_spec(<span class="hljs-string">&quot;guider&quot;</span>)
guider_spec.default_creation_method=<span class="hljs-string">&quot;from_pretrained&quot;</span>
guider_spec.repo=<span class="hljs-string">&quot;YiYiXu/modular-loader-t2i-guider&quot;</span>
guider_spec.subfolder=<span class="hljs-string">&quot;pag_guider&quot;</span>
pag_guider = guider_spec.load()
t2i_pipeline.update_components(guider=pag_guider)`,wrap:!1}}),_t=new M({props:{code:"TW9kdWxhclBpcGVsaW5lLnVwZGF0ZV9jb21wb25lbnRzJTNBJTIwY2hhbmdpbmclMjB0aGUlMjBkZWZhdWx0X2NyZWF0aW9uX21ldGhvZCUyMG9mJTIwZ3VpZGVyJTIwZnJvbSUyMGZyb21fY29uZmlnJTIwdG8lMjBmcm9tX3ByZXRyYWluZWQu",highlighted:'ModularPipeline.update_components: changing <span class="hljs-keyword">the</span> default_creation_method <span class="hljs-keyword">of</span> guider <span class="hljs-built_in">from</span> from_config <span class="hljs-built_in">to</span> from_pretrained.',wrap:!1}}),Ut=new M({props:{code:"dDJpX3BpcGVsaW5lLnB1c2hfdG9faHViKCUyMllpWWlYdSUyRm1vZHVsYXItZG9jLWd1aWRlciUyMik=",highlighted:'t2i_pipeline.push_to_hub(<span class="hljs-string">&quot;YiYiXu/modular-doc-guider&quot;</span>)',wrap:!1}}),L=new G({props:{$$slots:{default:[Fo]},$$scope:{ctx:$}}}),xt=new Z({props:{title:"Running a ModularPipeline",local:"running-a-modularpipeline",headingTag:"h2"}}),Bt=new M({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlMjJhJTIwY2F0JTIyJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1JTJDJTIwb3V0cHV0JTNEJTIyaW1hZ2VzJTIyKSU1QjAlNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(prompt=<span class="hljs-string">&quot;a cat&quot;</span>, num_inference_steps=<span class="hljs-number">15</span>, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]',wrap:!1}}),S=new G({props:{$$slots:{default:[Eo]},$$scope:{ctx:$}}}),Ct=new Z({props:{title:"Text-to-Image, Image-to-Image, and Inpainting",local:"text-to-image-image-to-image-and-inpainting",headingTag:"h4"}}),Y=new Vo({props:{id:"basic-tasks",options:["text-to-image","image-to-image","inpainting"],$$slots:{default:[Do]},$$scope:{ctx:$}}}),qt=new Z({props:{title:"ControlNet",local:"controlnet",headingTag:"h4"}}),R=new G({props:{$$slots:{default:[Ko]},$$scope:{ctx:$}}}),Vt=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwQUxMX0JMT0NLUyUwQUFMTF9CTE9DS1MlNUIlMjJjb250cm9sbmV0JTIyJTVEJTBBY29udHJvbG5ldF9ibG9ja3MlMjAlM0QlMjBBTExfQkxPQ0tTJTVCJTIyY29udHJvbG5ldCUyMiU1RCU1QiUyMmRlbm9pc2UlMjIlNUQoKSUwQWNvbnRyb2xuZXRfYmxvY2tzJTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> ALL_BLOCKS
<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_BLOCKS[<span class="hljs-string">&quot;controlnet&quot;</span>]
InsertableDict([
  <span class="hljs-number">0</span>: (<span class="hljs-string">&#x27;denoise&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks.StableDiffusionXLAutoControlnetStep&#x27;</span>&gt;)
])
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_blocks = ALL_BLOCKS[<span class="hljs-string">&quot;controlnet&quot;</span>][<span class="hljs-string">&quot;denoise&quot;</span>]()
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_blocks
StableDiffusionXLAutoControlnetStep(
  Class: SequentialPipelineBlocks

  ====================================================================================================
  This pipeline contains blocks that are selected at runtime based on inputs.
  Trigger Inputs: {<span class="hljs-string">&#x27;mask&#x27;</span>, <span class="hljs-string">&#x27;control_mode&#x27;</span>, <span class="hljs-string">&#x27;control_image&#x27;</span>, <span class="hljs-string">&#x27;controlnet_cond&#x27;</span>}
  Use \`get_execution_blocks()\` <span class="hljs-keyword">with</span> <span class="hljs-built_in">input</span> names to see selected blocks (e.g. \`get_execution_blocks(<span class="hljs-string">&#x27;mask&#x27;</span>)\`).
  ====================================================================================================


  Description: Controlnet auto step that prepare the controlnet <span class="hljs-built_in">input</span> <span class="hljs-keyword">and</span> denoise the latents. It works <span class="hljs-keyword">for</span> both controlnet <span class="hljs-keyword">and</span> controlnet_union <span class="hljs-keyword">and</span> supports text2img, img2img <span class="hljs-keyword">and</span> inpainting tasks. (it should be replace at <span class="hljs-string">&#x27;denoise&#x27;</span> step)


  Components:
      controlnet (\`ControlNetUnionModel\`)
      control_image_processor (\`VaeImageProcessor\`)
      scheduler (\`EulerDiscreteScheduler\`)
      unet (\`UNet2DConditionModel\`)
      guider (\`ClassifierFreeGuidance\`)

  Sub-Blocks:
    [<span class="hljs-number">0</span>] controlnet_input (StableDiffusionXLAutoControlNetInputStep)
       Description: Controlnet Input step that prepare the controlnet <span class="hljs-built_in">input</span>.
                   This <span class="hljs-keyword">is</span> an auto pipeline block that works <span class="hljs-keyword">for</span> both controlnet <span class="hljs-keyword">and</span> controlnet_union.
                    (it should be called right before the denoise step) - \`StableDiffusionXLControlNetUnionInputStep\` <span class="hljs-keyword">is</span> called to prepare the controlnet <span class="hljs-built_in">input</span> when \`control_mode\` <span class="hljs-keyword">and</span> \`control_image\` are provided.
                    - \`StableDiffusionXLControlNetInputStep\` <span class="hljs-keyword">is</span> called to prepare the controlnet <span class="hljs-built_in">input</span> when \`control_image\` <span class="hljs-keyword">is</span> provided. - <span class="hljs-keyword">if</span> neither \`control_mode\` nor \`control_image\` <span class="hljs-keyword">is</span> provided, step will be skipped.

    [<span class="hljs-number">1</span>] controlnet_denoise (StableDiffusionXLAutoControlNetDenoiseStep)
       Description: Denoise step that iteratively denoise the latents <span class="hljs-keyword">with</span> controlnet. This <span class="hljs-keyword">is</span> a auto pipeline block that using controlnet <span class="hljs-keyword">for</span> text2img, img2img <span class="hljs-keyword">and</span> inpainting tasks.This block should <span class="hljs-keyword">not</span> be used without a controlnet_cond <span class="hljs-built_in">input</span> - \`StableDiffusionXLInpaintControlNetDenoiseStep\` (inpaint_controlnet_denoise) <span class="hljs-keyword">is</span> used when mask <span class="hljs-keyword">is</span> provided. - \`StableDiffusionXLControlNetDenoiseStep\` (controlnet_denoise) <span class="hljs-keyword">is</span> used when mask <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> provided but controlnet_cond <span class="hljs-keyword">is</span> provided. - If neither mask nor controlnet_cond are provided, step will be skipped.

)`,wrap:!1}}),N=new G({props:{$$slots:{default:[Oo]},$$scope:{ctx:$}}}),St=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwVEVYVDJJTUFHRV9CTE9DS1MlMkMlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sbmV0U3RlcCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBJTIzJTIwY3JlYXRlJTIwcGlwZWxpbmUlMjBmcm9tJTIwYmxvY2tzJTIwcHJlc2V0JTBBYmxvY2tzJTIwJTNEJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzLmZyb21fYmxvY2tzX2RpY3QoVEVYVDJJTUFHRV9CTE9DS1MpJTBBJTBBJTIzJTIwdGhlc2UlMjB0d28lMjBsaW5lcyUyMGFwcGxpZXMlMjBjb250cm9sbmV0JTBBY29udHJvbG5ldF9ibG9ja3MlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEF1dG9Db250cm9sbmV0U3RlcCgpJTBBYmxvY2tzLnN1Yl9ibG9ja3MlNUIlMjJkZW5vaXNlJTIyJTVEJTIwJTNEJTIwY29udHJvbG5ldF9ibG9ja3MlMjA=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> TEXT2IMAGE_BLOCKS, StableDiffusionXLAutoControlnetStep
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-comment"># create pipeline from blocks preset</span>
blocks = SequentialPipelineBlocks.from_blocks_dict(TEXT2IMAGE_BLOCKS)

<span class="hljs-comment"># these two lines applies controlnet</span>
controlnet_blocks = StableDiffusionXLAutoControlnetStep()
blocks.sub_blocks[<span class="hljs-string">&quot;denoise&quot;</span>] = controlnet_blocks `,wrap:!1}}),Rt=new M({props:{code:"JTIzJTIwbWFrZSUyMHN1cmUlMjB0byUyMGElMjBtb2R1bGFyX3JlcG8lMjBpbmNsdWRpbmclMjBjb250cm9sbmV0JTBBbW9kdWxhcl9yZXBvX2lkJTIwJTNEJTIwJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMEFwaXBlbGluZSUyMCUzRCUyMGJsb2Nrcy5pbml0X3BpcGVsaW5lKG1vZHVsYXJfcmVwb19pZCklMEFwaXBlbGluZS5sb2FkX2RlZmF1bHRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBnZW5lcmF0ZSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc2RfY29udHJvbG5ldCUyRmJpcmRfY2FubnkucG5nJTIyJTBBKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMGJpcmQlMjIlMkMlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNSUyQyUyMGNvbnRyb2xfaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiUwQSklNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJtb2R1bGFyX2NvbnRyb2xfb3V0LnBuZyUyMik=",highlighted:`<span class="hljs-comment"># make sure to a modular_repo including controlnet</span>
modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>
pipeline = blocks.init_pipeline(modular_repo_id)
pipeline.load_default_components(torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># generate</span>
canny_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/bird_canny.png&quot;</span>
)
image = pipeline(
    prompt=<span class="hljs-string">&quot;a bird&quot;</span>, controlnet_conditioning_scale=<span class="hljs-number">0.5</span>, control_image=canny_image, output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;modular_control_out.png&quot;</span>)`,wrap:!1}}),Nt=new Z({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h4"}}),Et=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwQUxMX0JMT0NLUyUwQUFMTF9CTE9DS1MlNUIlMjJpcF9hZGFwdGVyJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> ALL_BLOCKS
<span class="hljs-meta">&gt;&gt;&gt; </span>ALL_BLOCKS[<span class="hljs-string">&quot;ip_adapter&quot;</span>]
InsertableDict([
  <span class="hljs-number">0</span>: (<span class="hljs-string">&#x27;ip_adapter&#x27;</span>, &lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;diffusers.modular_pipelines.stable_diffusion_xl.modular_blocks.StableDiffusionXLAutoIPAdapterStep&#x27;</span>&gt;)
])`,wrap:!1}}),zt=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCUwQWlwX2FkYXB0ZXJfYmxvY2tzJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExBdXRvSVBBZGFwdGVyU3RlcCgpJTBBaXBfYWRhcHRlcl9ibG9ja3MlMEElMEElMEElMEElMEElMEElMEE=",highlighted:`&gt;&gt;&gt; <span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> StableDiffusionXLAutoIPAdapterStep
&gt;&gt;&gt; ip_adapter_blocks = StableDiffusionXLAutoIPAdapterStep()
&gt;&gt;&gt; ip_adapter_blocks
StableDiffusionXLAutoIPAdapterStep(
  <span class="hljs-keyword">Class</span>: AutoPipelineBlocks

  ====================================================================================================
  <span class="hljs-keyword">This</span> pipeline contains blocks that are selected at <span class="hljs-keyword">runtime</span> based on inputs.
  Trigger Inputs: {<span class="hljs-string">&#x27;ip_adapter_image&#x27;</span>}
  Use \`get_execution_blocks()\` with input names to see selected blocks (e.g. \`get_execution_blocks(<span class="hljs-string">&#x27;ip_adapter_image&#x27;</span>)\`).
  ====================================================================================================


  <span class="hljs-keyword">Description</span>: Run IP Adapter <span class="hljs-keyword">step</span> <span class="hljs-keyword">if</span> \`ip_adapter_image\` is provided. <span class="hljs-keyword">This</span> <span class="hljs-keyword">step</span> should be placed before the <span class="hljs-string">&#x27;input&#x27;</span> <span class="hljs-keyword">step</span>.
      


  Components:
      image_encoder (\`CLIPVisionModelWithProjection\`)
      feature_extractor (\`CLIPImageProcessor\`)
      unet (\`UNet2DConditionModel\`)
      guider (\`ClassifierFreeGuidance\`)

  Sub-Blocks:
    • ip_adapter [trigger: ip_adapter_image] (StableDiffusionXLIPAdapterStep)
       <span class="hljs-keyword">Description</span>: IP Adapter <span class="hljs-keyword">step</span> that prepares ip adapter image embeddings.
                   Note that <span class="hljs-keyword">this</span> <span class="hljs-keyword">step</span> only prepares the embeddings - in order <span class="hljs-keyword">for</span> it to work correctly, you need to load ip adapter weights <span class="hljs-keyword">into</span> unet via ModularPipeline.load_ip_adapter() and pipeline.set_ip_adapter_scale().
                   See [ModularIPAdapterMixin](https:<span class="hljs-comment">//huggingface.co/docs/diffusers/api/loaders/ip_adapter#diffusers.loaders.ModularIPAdapterMixin) for more details</span>

)`,wrap:!1}}),Pt=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwVEVYVDJJTUFHRV9CTE9DS1MlMEElMEElMjMlMjBjcmVhdGUlMjBwaXBlbGluZSUyMGZyb20lMjBvZmZpY2lhbCUyMGJsb2NrcyUyMHByZXNldCUwQWJsb2NrcyUyMCUzRCUyMFNlcXVlbnRpYWxQaXBlbGluZUJsb2Nrcy5mcm9tX2Jsb2Nrc19kaWN0KFRFWFQySU1BR0VfQkxPQ0tTKSUwQSUwQSUyMyUyMGluc2VydCUyMGlwX2FkYXB0ZXJfYmxvY2tzJTIwYmVmb3JlJTIwdGhlJTIwaW5wdXQlMjBzdGVwJTIwYXMlMjBpbnN0cnVjdGVkJTBBYmxvY2tzLnN1Yl9ibG9ja3MuaW5zZXJ0KCUyMmlwX2FkYXB0ZXIlMjIlMkMlMjBpcF9hZGFwdGVyX2Jsb2NrcyUyQyUyMDEpJTBBJTBBJTIzJTIwaW5zcGVjJTIwdGhlJTIwYmxvY2tzJTIwYmVmb3JlJTIweW91JTIwY29udmVydCUyMGl0JTIwaW50byUyMHBpcGVsaW5lcyUyQyUwQSUyMyUyMGFuZCUyMG1ha2UlMjBzdXJlJTIwdG8lMjB1c2UlMjBhJTIwcmVwbyUyMHRoYXQlMjBjb250YWlucyUyMHRoZSUyMGxvYWRpbmclMjBzcGVjJTIwZm9yJTIwYWxsJTIwY29tcG9uZW50cyUwQSUyMyUyMGZvciUyMGlwLWFkYXB0ZXIlMkMlMjB5b3UlMjBuZWVkJTIwaW1hZ2VfZW5jb2RlciUyMCUyNiUyMGZlYXR1cmVfZXh0cmFjdG9yJTBBbW9kdWxhcl9yZXBvX2lkJTIwJTNEJTIwJTIyWWlZaVh1JTJGbW9kdWxhci1kZW1vLWF1dG8lMjIlMEFwaXBlbGluZSUyMCUzRCUyMGJsb2Nrcy5pbml0X3BpcGVsaW5lKG1vZHVsYXJfcmVwb19pZCklMEElMEFwaXBlbGluZS5sb2FkX2RlZmF1bHRfY29tcG9uZW50cyh0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiUwQSklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjgpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> TEXT2IMAGE_BLOCKS

<span class="hljs-comment"># create pipeline from official blocks preset</span>
blocks = SequentialPipelineBlocks.from_blocks_dict(TEXT2IMAGE_BLOCKS)

<span class="hljs-comment"># insert ip_adapter_blocks before the input step as instructed</span>
blocks.sub_blocks.insert(<span class="hljs-string">&quot;ip_adapter&quot;</span>, ip_adapter_blocks, <span class="hljs-number">1</span>)

<span class="hljs-comment"># inspec the blocks before you convert it into pipelines,</span>
<span class="hljs-comment"># and make sure to use a repo that contains the loading spec for all components</span>
<span class="hljs-comment"># for ip-adapter, you need image_encoder &amp; feature_extractor</span>
modular_repo_id = <span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>
pipeline = blocks.init_pipeline(modular_repo_id)

pipeline.load_default_components(torch_dtype=torch.float16)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.8</span>)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Dt=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9kaW5lci5wbmclMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwcG9sYXIlMjBiZWFyJTIwc2l0dGluZyUyMGluJTIwYSUyMGNoYWlyJTIwZHJpbmtpbmclMjBhJTIwbWlsa3NoYWtlJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyZGVmb3JtZWQlMkMlMjB1Z2x5JTJDJTIwd3JvbmclMjBwcm9wb3J0aW9uJTJDJTIwbG93JTIwcmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIlMEEpJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybW9kdWxhcl9pcGFfb3V0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    output=<span class="hljs-string">&quot;images&quot;</span>
)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;modular_ipa_out.png&quot;</span>)`,wrap:!1}}),Kt=new Xo({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/modular_pipeline.md"}}),{c(){i=p("meta"),j=n(),c=p("p"),g=n(),u(k.$$.fragment),w=n(),u(y.$$.fragment),U=n(),T=p("p"),T.innerHTML=x,J=n(),_=p("p"),_.innerHTML=I,sl=n(),u(v.$$.fragment),tl=n(),u(E.$$.fragment),ll=n(),z=p("p"),z.innerHTML=ki,nl=n(),P=p("p"),P.innerHTML=$i,al=n(),A=p("ul"),A.innerHTML=Ui,il=n(),D=p("p"),D.innerHTML=xi,pl=n(),u(K.$$.fragment),ol=n(),O=p("p"),O.innerHTML=Zi,rl=n(),u(ee.$$.fragment),cl=n(),se=p("p"),se.innerHTML=Bi,ul=n(),u(te.$$.fragment),dl=n(),le=p("p"),le.innerHTML=Gi,ml=n(),u(ne.$$.fragment),fl=n(),ae=p("p"),ae.innerHTML=Ii,hl=n(),u(ie.$$.fragment),bl=n(),pe=p("p"),pe.innerHTML=vi,gl=n(),u(oe.$$.fragment),Ml=n(),re=p("p"),re.innerHTML=Ci,yl=n(),ce=p("p"),ce.innerHTML=Wi,jl=n(),u(ue.$$.fragment),wl=n(),de=p("p"),de.innerHTML=qi,Tl=n(),u(me.$$.fragment),Jl=n(),fe=p("p"),fe.innerHTML=Xi,_l=n(),u(he.$$.fragment),kl=n(),be=p("p"),be.textContent=Vi,$l=n(),ge=p("p"),ge.innerHTML=Li,Ul=n(),u(Me.$$.fragment),xl=n(),ye=p("p"),ye.innerHTML=Si,Zl=n(),u(je.$$.fragment),Bl=n(),we=p("p"),we.innerHTML=Yi,Gl=n(),u(Te.$$.fragment),Il=n(),u(C.$$.fragment),vl=n(),Je=p("p"),Je.innerHTML=Ri,Cl=n(),u(_e.$$.fragment),Wl=n(),ke=p("p"),ke.innerHTML=Ni,ql=n(),$e=p("p"),$e.innerHTML=Hi,Xl=n(),Ue=p("p"),Ue.innerHTML=Qi,Vl=n(),xe=p("p"),xe.innerHTML=Fi,Ll=n(),Ze=p("p"),Ze.innerHTML=Ei,Sl=n(),u(Be.$$.fragment),Yl=n(),Ge=p("p"),Ge.innerHTML=zi,Rl=n(),Ie=p("ul"),Ie.innerHTML=Pi,Nl=n(),u(ve.$$.fragment),Hl=n(),Ce=p("p"),Ce.innerHTML=Ai,Ql=n(),u(We.$$.fragment),Fl=n(),qe=p("p"),qe.innerHTML=Di,El=n(),Xe=p("p"),Xe.innerHTML=Ki,zl=n(),u(Ve.$$.fragment),Pl=n(),u(W.$$.fragment),Al=n(),Le=p("p"),Le.innerHTML=Oi,Dl=n(),u(Se.$$.fragment),Kl=n(),Ye=p("p"),Ye.innerHTML=ep,Ol=n(),u(Re.$$.fragment),en=n(),Ne=p("p"),Ne.textContent=sp,sn=n(),u(He.$$.fragment),tn=n(),Qe=p("p"),Qe.textContent=tp,ln=n(),u(Fe.$$.fragment),nn=n(),Ee=p("p"),Ee.innerHTML=lp,an=n(),u(ze.$$.fragment),pn=n(),Pe=p("p"),Pe.innerHTML=np,on=n(),Ae=p("p"),Ae.innerHTML=ap,rn=n(),u(De.$$.fragment),cn=n(),Ke=p("p"),Ke.innerHTML=ip,un=n(),u(Oe.$$.fragment),dn=n(),es=p("p"),es.innerHTML=pp,mn=n(),u(ss.$$.fragment),fn=n(),ts=p("p"),ts.innerHTML=op,hn=n(),u(ls.$$.fragment),bn=n(),ns=p("p"),ns.innerHTML=rp,gn=n(),as=p("ul"),as.innerHTML=cp,Mn=n(),is=p("p"),is.textContent=up,yn=n(),ps=p("ul"),ps.innerHTML=dp,jn=n(),os=p("p"),os.innerHTML=mp,wn=n(),rs=p("p"),rs.innerHTML=fp,Tn=n(),cs=p("p"),cs.textContent=hp,Jn=n(),u(us.$$.fragment),_n=n(),ds=p("p"),ds.innerHTML=bp,kn=n(),u(ms.$$.fragment),$n=n(),fs=p("p"),fs.innerHTML=gp,Un=n(),u(hs.$$.fragment),xn=n(),bs=p("p"),bs.textContent=Mp,Zn=n(),u(gs.$$.fragment),Bn=n(),u(Ms.$$.fragment),Gn=n(),ys=p("p"),ys.innerHTML=yp,In=n(),js=p("ul"),js.innerHTML=jp,vn=n(),u(q.$$.fragment),Cn=n(),ws=p("p"),ws.innerHTML=wp,Wn=n(),Ts=p("p"),Ts.textContent=Tp,qn=n(),Js=p("p"),Js.textContent=Jp,Xn=n(),u(_s.$$.fragment),Vn=n(),ks=p("p"),ks.textContent=_p,Ln=n(),u($s.$$.fragment),Sn=n(),Us=p("p"),Us.textContent=kp,Yn=n(),u(xs.$$.fragment),Rn=n(),Zs=p("p"),Zs.textContent=$p,Nn=n(),u(Bs.$$.fragment),Hn=n(),Gs=p("p"),Gs.innerHTML=Up,Qn=n(),u(Is.$$.fragment),Fn=n(),u(X.$$.fragment),En=n(),u(vs.$$.fragment),zn=n(),Cs=p("p"),Cs.innerHTML=xp,Pn=n(),Ws=p("p"),Ws.innerHTML=Zp,An=n(),qs=p("p"),qs.innerHTML=Bp,Dn=n(),Xs=p("p"),Xs.textContent=Gp,Kn=n(),u(Vs.$$.fragment),On=n(),Ls=p("p"),Ls.innerHTML=Ip,ea=n(),u(Ss.$$.fragment),sa=n(),u(Ys.$$.fragment),ta=n(),Rs=p("p"),Rs.innerHTML=vp,la=n(),Ns=p("p"),Ns.innerHTML=Cp,na=n(),Hs=p("p"),Hs.textContent=Wp,aa=n(),u(Qs.$$.fragment),ia=n(),Fs=p("p"),Fs.innerHTML=qp,pa=n(),Es=p("p"),Es.innerHTML=Xp,oa=n(),u(zs.$$.fragment),ra=n(),Ps=p("p"),Ps.textContent=Vp,ca=n(),u(As.$$.fragment),ua=n(),u(Ds.$$.fragment),da=n(),Ks=p("p"),Ks.textContent=Lp,ma=n(),u(Os.$$.fragment),fa=n(),et=p("p"),et.textContent=Sp,ha=n(),u(st.$$.fragment),ba=n(),u(V.$$.fragment),ga=n(),tt=p("p"),tt.textContent=Yp,Ma=n(),u(lt.$$.fragment),ya=n(),nt=p("p"),nt.textContent=Rp,ja=n(),u(at.$$.fragment),wa=n(),it=p("p"),it.innerHTML=Np,Ta=n(),u(pt.$$.fragment),Ja=n(),ot=p("p"),ot.innerHTML=Hp,_a=n(),u(rt.$$.fragment),ka=n(),ct=p("p"),ct.innerHTML=Qp,$a=n(),ut=p("p"),ut.innerHTML=Fp,Ua=n(),u(dt.$$.fragment),xa=n(),mt=p("p"),mt.innerHTML=Ep,Za=n(),u(ft.$$.fragment),Ba=n(),u(ht.$$.fragment),Ga=n(),bt=p("p"),bt.innerHTML=zp,Ia=n(),u(gt.$$.fragment),va=n(),Mt=p("p"),Mt.innerHTML=Pp,Ca=n(),yt=p("p"),yt.textContent=Ap,Wa=n(),jt=p("ol"),jt.innerHTML=Dp,qa=n(),wt=p("p"),wt.innerHTML=Kp,Xa=n(),u(Tt.$$.fragment),Va=n(),Jt=p("p"),Jt.textContent=Op,La=n(),u(_t.$$.fragment),Sa=n(),kt=p("p"),kt.innerHTML=eo,Ya=n(),$t=p("p"),$t.textContent=so,Ra=n(),u(Ut.$$.fragment),Na=n(),u(L.$$.fragment),Ha=n(),u(xt.$$.fragment),Qa=n(),Zt=p("p"),Zt.innerHTML=to,Fa=n(),u(Bt.$$.fragment),Ea=n(),Gt=p("p"),Gt.textContent=lo,za=n(),It=p("ol"),It.innerHTML=no,Pa=n(),vt=p("p"),vt.innerHTML=ao,Aa=n(),u(S.$$.fragment),Da=n(),u(Ct.$$.fragment),Ka=n(),Wt=p("p"),Wt.innerHTML=io,Oa=n(),u(Y.$$.fragment),ei=n(),u(qt.$$.fragment),si=n(),Xt=p("p"),Xt.innerHTML=po,ti=n(),u(R.$$.fragment),li=n(),u(Vt.$$.fragment),ni=n(),u(N.$$.fragment),ai=n(),Lt=p("p"),Lt.textContent=oo,ii=n(),u(St.$$.fragment),pi=n(),Yt=p("p"),Yt.innerHTML=ro,oi=n(),u(Rt.$$.fragment),ri=n(),u(Nt.$$.fragment),ci=n(),Ht=p("p"),Ht.innerHTML=co,ui=n(),Qt=p("p"),Qt.textContent=uo,di=n(),Ft=p("ol"),Ft.innerHTML=mo,mi=n(),u(Et.$$.fragment),fi=n(),H=p("ol"),H.innerHTML=fo,hi=n(),u(zt.$$.fragment),bi=n(),Q=p("ol"),Q.innerHTML=ho,gi=n(),u(Pt.$$.fragment),Mi=n(),F=p("ol"),F.innerHTML=bo,yi=n(),At=p("p"),At.innerHTML=go,ji=n(),u(Dt.$$.fragment),wi=n(),u(Kt.$$.fragment),Ti=n(),Ot=p("p"),this.h()},l(e){const s=Wo("svelte-u9bgzb",document.head);i=o(s,"META",{name:!0,content:!0}),s.forEach(t),j=a(e),c=o(e,"P",{}),Bo(c).forEach(t),g=a(e),d(k.$$.fragment,e),w=a(e),d(y.$$.fragment,e),U=a(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-14h81hv"&&(T.innerHTML=x),J=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-f6oz5n"&&(_.innerHTML=I),sl=a(e),d(v.$$.fragment,e),tl=a(e),d(E.$$.fragment,e),ll=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1x8pk7u"&&(z.innerHTML=ki),nl=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-13lsz2q"&&(P.innerHTML=$i),al=a(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-fv7zkr"&&(A.innerHTML=Ui),il=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-6rc13t"&&(D.innerHTML=xi),pl=a(e),d(K.$$.fragment,e),ol=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-j9znyd"&&(O.innerHTML=Zi),rl=a(e),d(ee.$$.fragment,e),cl=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-f8mebp"&&(se.innerHTML=Bi),ul=a(e),d(te.$$.fragment,e),dl=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-exn8w9"&&(le.innerHTML=Gi),ml=a(e),d(ne.$$.fragment,e),fl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-143wuw6"&&(ae.innerHTML=Ii),hl=a(e),d(ie.$$.fragment,e),bl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-lp03vj"&&(pe.innerHTML=vi),gl=a(e),d(oe.$$.fragment,e),Ml=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1j1t6iv"&&(re.innerHTML=Ci),yl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-14fxc5m"&&(ce.innerHTML=Wi),jl=a(e),d(ue.$$.fragment,e),wl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-11cgoy5"&&(de.innerHTML=qi),Tl=a(e),d(me.$$.fragment,e),Jl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-weuwnx"&&(fe.innerHTML=Xi),_l=a(e),d(he.$$.fragment,e),kl=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-nsxsu4"&&(be.textContent=Vi),$l=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-duhu0z"&&(ge.innerHTML=Li),Ul=a(e),d(Me.$$.fragment,e),xl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-14jelb5"&&(ye.innerHTML=Si),Zl=a(e),d(je.$$.fragment,e),Bl=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-u4kp4u"&&(we.innerHTML=Yi),Gl=a(e),d(Te.$$.fragment,e),Il=a(e),d(C.$$.fragment,e),vl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ekh1wv"&&(Je.innerHTML=Ri),Cl=a(e),d(_e.$$.fragment,e),Wl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1kao3k1"&&(ke.innerHTML=Ni),ql=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-tegpo4"&&($e.innerHTML=Hi),Xl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-17zvy7e"&&(Ue.innerHTML=Qi),Vl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ycj0wy"&&(xe.innerHTML=Fi),Ll=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1vmw4gr"&&(Ze.innerHTML=Ei),Sl=a(e),d(Be.$$.fragment,e),Yl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-gxancp"&&(Ge.innerHTML=zi),Rl=a(e),Ie=o(e,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-107f998"&&(Ie.innerHTML=Pi),Nl=a(e),d(ve.$$.fragment,e),Hl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-7ittim"&&(Ce.innerHTML=Ai),Ql=a(e),d(We.$$.fragment,e),Fl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-jtwth8"&&(qe.innerHTML=Di),El=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1afy7a4"&&(Xe.innerHTML=Ki),zl=a(e),d(Ve.$$.fragment,e),Pl=a(e),d(W.$$.fragment,e),Al=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1dvdh2z"&&(Le.innerHTML=Oi),Dl=a(e),d(Se.$$.fragment,e),Kl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1711rzq"&&(Ye.innerHTML=ep),Ol=a(e),d(Re.$$.fragment,e),en=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-gtmcub"&&(Ne.textContent=sp),sn=a(e),d(He.$$.fragment,e),tn=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-aad207"&&(Qe.textContent=tp),ln=a(e),d(Fe.$$.fragment,e),nn=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1juzgj"&&(Ee.innerHTML=lp),an=a(e),d(ze.$$.fragment,e),pn=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1vn1o8k"&&(Pe.innerHTML=np),on=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1ywa8pm"&&(Ae.innerHTML=ap),rn=a(e),d(De.$$.fragment,e),cn=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-4mvx0e"&&(Ke.innerHTML=ip),un=a(e),d(Oe.$$.fragment,e),dn=a(e),es=o(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-1c9iz5d"&&(es.innerHTML=pp),mn=a(e),d(ss.$$.fragment,e),fn=a(e),ts=o(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-18uy5ju"&&(ts.innerHTML=op),hn=a(e),d(ls.$$.fragment,e),bn=a(e),ns=o(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-aj04nf"&&(ns.innerHTML=rp),gn=a(e),as=o(e,"UL",{"data-svelte-h":!0}),r(as)!=="svelte-17lbc83"&&(as.innerHTML=cp),Mn=a(e),is=o(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-15bi1il"&&(is.textContent=up),yn=a(e),ps=o(e,"UL",{"data-svelte-h":!0}),r(ps)!=="svelte-zwkdv4"&&(ps.innerHTML=dp),jn=a(e),os=o(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1o98bnb"&&(os.innerHTML=mp),wn=a(e),rs=o(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-e0gfuv"&&(rs.innerHTML=fp),Tn=a(e),cs=o(e,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-q1s7rj"&&(cs.textContent=hp),Jn=a(e),d(us.$$.fragment,e),_n=a(e),ds=o(e,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-u41c9d"&&(ds.innerHTML=bp),kn=a(e),d(ms.$$.fragment,e),$n=a(e),fs=o(e,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-14jnawd"&&(fs.innerHTML=gp),Un=a(e),d(hs.$$.fragment,e),xn=a(e),bs=o(e,"P",{"data-svelte-h":!0}),r(bs)!=="svelte-ewnlrw"&&(bs.textContent=Mp),Zn=a(e),d(gs.$$.fragment,e),Bn=a(e),d(Ms.$$.fragment,e),Gn=a(e),ys=o(e,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-142s7uo"&&(ys.innerHTML=yp),In=a(e),js=o(e,"UL",{"data-svelte-h":!0}),r(js)!=="svelte-yp3jh"&&(js.innerHTML=jp),vn=a(e),d(q.$$.fragment,e),Cn=a(e),ws=o(e,"P",{"data-svelte-h":!0}),r(ws)!=="svelte-4b0omr"&&(ws.innerHTML=wp),Wn=a(e),Ts=o(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-198tnkb"&&(Ts.textContent=Tp),qn=a(e),Js=o(e,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-1bc04it"&&(Js.textContent=Jp),Xn=a(e),d(_s.$$.fragment,e),Vn=a(e),ks=o(e,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-qptszn"&&(ks.textContent=_p),Ln=a(e),d($s.$$.fragment,e),Sn=a(e),Us=o(e,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-2fo2fq"&&(Us.textContent=kp),Yn=a(e),d(xs.$$.fragment,e),Rn=a(e),Zs=o(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-1tkcinu"&&(Zs.textContent=$p),Nn=a(e),d(Bs.$$.fragment,e),Hn=a(e),Gs=o(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-e1vgvl"&&(Gs.innerHTML=Up),Qn=a(e),d(Is.$$.fragment,e),Fn=a(e),d(X.$$.fragment,e),En=a(e),d(vs.$$.fragment,e),zn=a(e),Cs=o(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-13obvjk"&&(Cs.innerHTML=xp),Pn=a(e),Ws=o(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1gum3yp"&&(Ws.innerHTML=Zp),An=a(e),qs=o(e,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-p53xgu"&&(qs.innerHTML=Bp),Dn=a(e),Xs=o(e,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-dt9m29"&&(Xs.textContent=Gp),Kn=a(e),d(Vs.$$.fragment,e),On=a(e),Ls=o(e,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-1xjugy8"&&(Ls.innerHTML=Ip),ea=a(e),d(Ss.$$.fragment,e),sa=a(e),d(Ys.$$.fragment,e),ta=a(e),Rs=o(e,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-1kya8e6"&&(Rs.innerHTML=vp),la=a(e),Ns=o(e,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-qhjrz4"&&(Ns.innerHTML=Cp),na=a(e),Hs=o(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-1yvbgva"&&(Hs.textContent=Wp),aa=a(e),d(Qs.$$.fragment,e),ia=a(e),Fs=o(e,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-1dpjpjf"&&(Fs.innerHTML=qp),pa=a(e),Es=o(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-1bgqadd"&&(Es.innerHTML=Xp),oa=a(e),d(zs.$$.fragment,e),ra=a(e),Ps=o(e,"P",{"data-svelte-h":!0}),r(Ps)!=="svelte-s5g7hb"&&(Ps.textContent=Vp),ca=a(e),d(As.$$.fragment,e),ua=a(e),d(Ds.$$.fragment,e),da=a(e),Ks=o(e,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-tulvz4"&&(Ks.textContent=Lp),ma=a(e),d(Os.$$.fragment,e),fa=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-wxznmr"&&(et.textContent=Sp),ha=a(e),d(st.$$.fragment,e),ba=a(e),d(V.$$.fragment,e),ga=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1x24ygx"&&(tt.textContent=Yp),Ma=a(e),d(lt.$$.fragment,e),ya=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-169ip08"&&(nt.textContent=Rp),ja=a(e),d(at.$$.fragment,e),wa=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-c0anvk"&&(it.innerHTML=Np),Ta=a(e),d(pt.$$.fragment,e),Ja=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1nap4cr"&&(ot.innerHTML=Hp),_a=a(e),d(rt.$$.fragment,e),ka=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1hqgbsy"&&(ct.innerHTML=Qp),$a=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1ae1ij0"&&(ut.innerHTML=Fp),Ua=a(e),d(dt.$$.fragment,e),xa=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-16q8ck"&&(mt.innerHTML=Ep),Za=a(e),d(ft.$$.fragment,e),Ba=a(e),d(ht.$$.fragment,e),Ga=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1h04j0a"&&(bt.innerHTML=zp),Ia=a(e),d(gt.$$.fragment,e),va=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1ory5le"&&(Mt.innerHTML=Pp),Ca=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-ei0qxu"&&(yt.textContent=Ap),Wa=a(e),jt=o(e,"OL",{"data-svelte-h":!0}),r(jt)!=="svelte-tmtq35"&&(jt.innerHTML=Dp),qa=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-kst83c"&&(wt.innerHTML=Kp),Xa=a(e),d(Tt.$$.fragment,e),Va=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-1y9qlex"&&(Jt.textContent=Op),La=a(e),d(_t.$$.fragment,e),Sa=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1pt9ert"&&(kt.innerHTML=eo),Ya=a(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-s37sho"&&($t.textContent=so),Ra=a(e),d(Ut.$$.fragment,e),Na=a(e),d(L.$$.fragment,e),Ha=a(e),d(xt.$$.fragment,e),Qa=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-19vwwbj"&&(Zt.innerHTML=to),Fa=a(e),d(Bt.$$.fragment,e),Ea=a(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-13lkbx5"&&(Gt.textContent=lo),za=a(e),It=o(e,"OL",{"data-svelte-h":!0}),r(It)!=="svelte-16kbj5a"&&(It.innerHTML=no),Pa=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1k4wrr3"&&(vt.innerHTML=ao),Aa=a(e),d(S.$$.fragment,e),Da=a(e),d(Ct.$$.fragment,e),Ka=a(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-119pbdc"&&(Wt.innerHTML=io),Oa=a(e),d(Y.$$.fragment,e),ei=a(e),d(qt.$$.fragment,e),si=a(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1xycv15"&&(Xt.innerHTML=po),ti=a(e),d(R.$$.fragment,e),li=a(e),d(Vt.$$.fragment,e),ni=a(e),d(N.$$.fragment,e),ai=a(e),Lt=o(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-1i8x4c3"&&(Lt.textContent=oo),ii=a(e),d(St.$$.fragment,e),pi=a(e),Yt=o(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-zqvktu"&&(Yt.innerHTML=ro),oi=a(e),d(Rt.$$.fragment,e),ri=a(e),d(Nt.$$.fragment,e),ci=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1gbw09g"&&(Ht.innerHTML=co),ui=a(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-pu1b97"&&(Qt.textContent=uo),di=a(e),Ft=o(e,"OL",{"data-svelte-h":!0}),r(Ft)!=="svelte-1sy384"&&(Ft.innerHTML=mo),mi=a(e),d(Et.$$.fragment,e),fi=a(e),H=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(H)!=="svelte-12nwn7m"&&(H.innerHTML=fo),hi=a(e),d(zt.$$.fragment,e),bi=a(e),Q=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(Q)!=="svelte-hjvbv0"&&(Q.innerHTML=ho),gi=a(e),d(Pt.$$.fragment,e),Mi=a(e),F=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(F)!=="svelte-f83e52"&&(F.innerHTML=bo),yi=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-af1nse"&&(At.innerHTML=go),ji=a(e),d(Dt.$$.fragment,e),wi=a(e),d(Kt.$$.fragment,e),Ti=a(e),Ot=o(e,"P",{}),Bo(Ot).forEach(t),this.h()},h(){el(i,"name","hf:doc:metadata"),el(i,"content",sr),el(H,"start","2"),el(Q,"start","3"),el(F,"start","4")},m(e,s){qo(document.head,i),l(e,j,s),l(e,c,s),l(e,g,s),m(k,e,s),l(e,w,s),m(y,e,s),l(e,U,s),l(e,T,s),l(e,J,s),l(e,_,s),l(e,sl,s),m(v,e,s),l(e,tl,s),m(E,e,s),l(e,ll,s),l(e,z,s),l(e,nl,s),l(e,P,s),l(e,al,s),l(e,A,s),l(e,il,s),l(e,D,s),l(e,pl,s),m(K,e,s),l(e,ol,s),l(e,O,s),l(e,rl,s),m(ee,e,s),l(e,cl,s),l(e,se,s),l(e,ul,s),m(te,e,s),l(e,dl,s),l(e,le,s),l(e,ml,s),m(ne,e,s),l(e,fl,s),l(e,ae,s),l(e,hl,s),m(ie,e,s),l(e,bl,s),l(e,pe,s),l(e,gl,s),m(oe,e,s),l(e,Ml,s),l(e,re,s),l(e,yl,s),l(e,ce,s),l(e,jl,s),m(ue,e,s),l(e,wl,s),l(e,de,s),l(e,Tl,s),m(me,e,s),l(e,Jl,s),l(e,fe,s),l(e,_l,s),m(he,e,s),l(e,kl,s),l(e,be,s),l(e,$l,s),l(e,ge,s),l(e,Ul,s),m(Me,e,s),l(e,xl,s),l(e,ye,s),l(e,Zl,s),m(je,e,s),l(e,Bl,s),l(e,we,s),l(e,Gl,s),m(Te,e,s),l(e,Il,s),m(C,e,s),l(e,vl,s),l(e,Je,s),l(e,Cl,s),m(_e,e,s),l(e,Wl,s),l(e,ke,s),l(e,ql,s),l(e,$e,s),l(e,Xl,s),l(e,Ue,s),l(e,Vl,s),l(e,xe,s),l(e,Ll,s),l(e,Ze,s),l(e,Sl,s),m(Be,e,s),l(e,Yl,s),l(e,Ge,s),l(e,Rl,s),l(e,Ie,s),l(e,Nl,s),m(ve,e,s),l(e,Hl,s),l(e,Ce,s),l(e,Ql,s),m(We,e,s),l(e,Fl,s),l(e,qe,s),l(e,El,s),l(e,Xe,s),l(e,zl,s),m(Ve,e,s),l(e,Pl,s),m(W,e,s),l(e,Al,s),l(e,Le,s),l(e,Dl,s),m(Se,e,s),l(e,Kl,s),l(e,Ye,s),l(e,Ol,s),m(Re,e,s),l(e,en,s),l(e,Ne,s),l(e,sn,s),m(He,e,s),l(e,tn,s),l(e,Qe,s),l(e,ln,s),m(Fe,e,s),l(e,nn,s),l(e,Ee,s),l(e,an,s),m(ze,e,s),l(e,pn,s),l(e,Pe,s),l(e,on,s),l(e,Ae,s),l(e,rn,s),m(De,e,s),l(e,cn,s),l(e,Ke,s),l(e,un,s),m(Oe,e,s),l(e,dn,s),l(e,es,s),l(e,mn,s),m(ss,e,s),l(e,fn,s),l(e,ts,s),l(e,hn,s),m(ls,e,s),l(e,bn,s),l(e,ns,s),l(e,gn,s),l(e,as,s),l(e,Mn,s),l(e,is,s),l(e,yn,s),l(e,ps,s),l(e,jn,s),l(e,os,s),l(e,wn,s),l(e,rs,s),l(e,Tn,s),l(e,cs,s),l(e,Jn,s),m(us,e,s),l(e,_n,s),l(e,ds,s),l(e,kn,s),m(ms,e,s),l(e,$n,s),l(e,fs,s),l(e,Un,s),m(hs,e,s),l(e,xn,s),l(e,bs,s),l(e,Zn,s),m(gs,e,s),l(e,Bn,s),m(Ms,e,s),l(e,Gn,s),l(e,ys,s),l(e,In,s),l(e,js,s),l(e,vn,s),m(q,e,s),l(e,Cn,s),l(e,ws,s),l(e,Wn,s),l(e,Ts,s),l(e,qn,s),l(e,Js,s),l(e,Xn,s),m(_s,e,s),l(e,Vn,s),l(e,ks,s),l(e,Ln,s),m($s,e,s),l(e,Sn,s),l(e,Us,s),l(e,Yn,s),m(xs,e,s),l(e,Rn,s),l(e,Zs,s),l(e,Nn,s),m(Bs,e,s),l(e,Hn,s),l(e,Gs,s),l(e,Qn,s),m(Is,e,s),l(e,Fn,s),m(X,e,s),l(e,En,s),m(vs,e,s),l(e,zn,s),l(e,Cs,s),l(e,Pn,s),l(e,Ws,s),l(e,An,s),l(e,qs,s),l(e,Dn,s),l(e,Xs,s),l(e,Kn,s),m(Vs,e,s),l(e,On,s),l(e,Ls,s),l(e,ea,s),m(Ss,e,s),l(e,sa,s),m(Ys,e,s),l(e,ta,s),l(e,Rs,s),l(e,la,s),l(e,Ns,s),l(e,na,s),l(e,Hs,s),l(e,aa,s),m(Qs,e,s),l(e,ia,s),l(e,Fs,s),l(e,pa,s),l(e,Es,s),l(e,oa,s),m(zs,e,s),l(e,ra,s),l(e,Ps,s),l(e,ca,s),m(As,e,s),l(e,ua,s),m(Ds,e,s),l(e,da,s),l(e,Ks,s),l(e,ma,s),m(Os,e,s),l(e,fa,s),l(e,et,s),l(e,ha,s),m(st,e,s),l(e,ba,s),m(V,e,s),l(e,ga,s),l(e,tt,s),l(e,Ma,s),m(lt,e,s),l(e,ya,s),l(e,nt,s),l(e,ja,s),m(at,e,s),l(e,wa,s),l(e,it,s),l(e,Ta,s),m(pt,e,s),l(e,Ja,s),l(e,ot,s),l(e,_a,s),m(rt,e,s),l(e,ka,s),l(e,ct,s),l(e,$a,s),l(e,ut,s),l(e,Ua,s),m(dt,e,s),l(e,xa,s),l(e,mt,s),l(e,Za,s),m(ft,e,s),l(e,Ba,s),m(ht,e,s),l(e,Ga,s),l(e,bt,s),l(e,Ia,s),m(gt,e,s),l(e,va,s),l(e,Mt,s),l(e,Ca,s),l(e,yt,s),l(e,Wa,s),l(e,jt,s),l(e,qa,s),l(e,wt,s),l(e,Xa,s),m(Tt,e,s),l(e,Va,s),l(e,Jt,s),l(e,La,s),m(_t,e,s),l(e,Sa,s),l(e,kt,s),l(e,Ya,s),l(e,$t,s),l(e,Ra,s),m(Ut,e,s),l(e,Na,s),m(L,e,s),l(e,Ha,s),m(xt,e,s),l(e,Qa,s),l(e,Zt,s),l(e,Fa,s),m(Bt,e,s),l(e,Ea,s),l(e,Gt,s),l(e,za,s),l(e,It,s),l(e,Pa,s),l(e,vt,s),l(e,Aa,s),m(S,e,s),l(e,Da,s),m(Ct,e,s),l(e,Ka,s),l(e,Wt,s),l(e,Oa,s),m(Y,e,s),l(e,ei,s),m(qt,e,s),l(e,si,s),l(e,Xt,s),l(e,ti,s),m(R,e,s),l(e,li,s),m(Vt,e,s),l(e,ni,s),m(N,e,s),l(e,ai,s),l(e,Lt,s),l(e,ii,s),m(St,e,s),l(e,pi,s),l(e,Yt,s),l(e,oi,s),m(Rt,e,s),l(e,ri,s),m(Nt,e,s),l(e,ci,s),l(e,Ht,s),l(e,ui,s),l(e,Qt,s),l(e,di,s),l(e,Ft,s),l(e,mi,s),m(Et,e,s),l(e,fi,s),l(e,H,s),l(e,hi,s),m(zt,e,s),l(e,bi,s),l(e,Q,s),l(e,gi,s),m(Pt,e,s),l(e,Mi,s),l(e,F,s),l(e,yi,s),l(e,At,s),l(e,ji,s),m(Dt,e,s),l(e,wi,s),m(Kt,e,s),l(e,Ti,s),l(e,Ot,s),Ji=!0},p(e,[s]){const Mo={};s&2&&(Mo.$$scope={dirty:s,ctx:e}),y.$set(Mo);const yo={};s&2&&(yo.$$scope={dirty:s,ctx:e}),v.$set(yo);const jo={};s&2&&(jo.$$scope={dirty:s,ctx:e}),C.$set(jo);const wo={};s&2&&(wo.$$scope={dirty:s,ctx:e}),W.$set(wo);const To={};s&2&&(To.$$scope={dirty:s,ctx:e}),q.$set(To);const Jo={};s&2&&(Jo.$$scope={dirty:s,ctx:e}),X.$set(Jo);const _o={};s&2&&(_o.$$scope={dirty:s,ctx:e}),V.$set(_o);const ko={};s&2&&(ko.$$scope={dirty:s,ctx:e}),L.$set(ko);const $o={};s&2&&($o.$$scope={dirty:s,ctx:e}),S.$set($o);const Uo={};s&2&&(Uo.$$scope={dirty:s,ctx:e}),Y.$set(Uo);const xo={};s&2&&(xo.$$scope={dirty:s,ctx:e}),R.$set(xo);const Zo={};s&2&&(Zo.$$scope={dirty:s,ctx:e}),N.$set(Zo)},i(e){Ji||(f(k.$$.fragment,e),f(y.$$.fragment,e),f(v.$$.fragment,e),f(E.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ue.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(Me.$$.fragment,e),f(je.$$.fragment,e),f(Te.$$.fragment,e),f(C.$$.fragment,e),f(_e.$$.fragment,e),f(Be.$$.fragment,e),f(ve.$$.fragment,e),f(We.$$.fragment,e),f(Ve.$$.fragment,e),f(W.$$.fragment,e),f(Se.$$.fragment,e),f(Re.$$.fragment,e),f(He.$$.fragment,e),f(Fe.$$.fragment,e),f(ze.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(ss.$$.fragment,e),f(ls.$$.fragment,e),f(us.$$.fragment,e),f(ms.$$.fragment,e),f(hs.$$.fragment,e),f(gs.$$.fragment,e),f(Ms.$$.fragment,e),f(q.$$.fragment,e),f(_s.$$.fragment,e),f($s.$$.fragment,e),f(xs.$$.fragment,e),f(Bs.$$.fragment,e),f(Is.$$.fragment,e),f(X.$$.fragment,e),f(vs.$$.fragment,e),f(Vs.$$.fragment,e),f(Ss.$$.fragment,e),f(Ys.$$.fragment,e),f(Qs.$$.fragment,e),f(zs.$$.fragment,e),f(As.$$.fragment,e),f(Ds.$$.fragment,e),f(Os.$$.fragment,e),f(st.$$.fragment,e),f(V.$$.fragment,e),f(lt.$$.fragment,e),f(at.$$.fragment,e),f(pt.$$.fragment,e),f(rt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(Tt.$$.fragment,e),f(_t.$$.fragment,e),f(Ut.$$.fragment,e),f(L.$$.fragment,e),f(xt.$$.fragment,e),f(Bt.$$.fragment,e),f(S.$$.fragment,e),f(Ct.$$.fragment,e),f(Y.$$.fragment,e),f(qt.$$.fragment,e),f(R.$$.fragment,e),f(Vt.$$.fragment,e),f(N.$$.fragment,e),f(St.$$.fragment,e),f(Rt.$$.fragment,e),f(Nt.$$.fragment,e),f(Et.$$.fragment,e),f(zt.$$.fragment,e),f(Pt.$$.fragment,e),f(Dt.$$.fragment,e),f(Kt.$$.fragment,e),Ji=!0)},o(e){h(k.$$.fragment,e),h(y.$$.fragment,e),h(v.$$.fragment,e),h(E.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(ue.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(Me.$$.fragment,e),h(je.$$.fragment,e),h(Te.$$.fragment,e),h(C.$$.fragment,e),h(_e.$$.fragment,e),h(Be.$$.fragment,e),h(ve.$$.fragment,e),h(We.$$.fragment,e),h(Ve.$$.fragment,e),h(W.$$.fragment,e),h(Se.$$.fragment,e),h(Re.$$.fragment,e),h(He.$$.fragment,e),h(Fe.$$.fragment,e),h(ze.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(ss.$$.fragment,e),h(ls.$$.fragment,e),h(us.$$.fragment,e),h(ms.$$.fragment,e),h(hs.$$.fragment,e),h(gs.$$.fragment,e),h(Ms.$$.fragment,e),h(q.$$.fragment,e),h(_s.$$.fragment,e),h($s.$$.fragment,e),h(xs.$$.fragment,e),h(Bs.$$.fragment,e),h(Is.$$.fragment,e),h(X.$$.fragment,e),h(vs.$$.fragment,e),h(Vs.$$.fragment,e),h(Ss.$$.fragment,e),h(Ys.$$.fragment,e),h(Qs.$$.fragment,e),h(zs.$$.fragment,e),h(As.$$.fragment,e),h(Ds.$$.fragment,e),h(Os.$$.fragment,e),h(st.$$.fragment,e),h(V.$$.fragment,e),h(lt.$$.fragment,e),h(at.$$.fragment,e),h(pt.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(ft.$$.fragment,e),h(ht.$$.fragment,e),h(gt.$$.fragment,e),h(Tt.$$.fragment,e),h(_t.$$.fragment,e),h(Ut.$$.fragment,e),h(L.$$.fragment,e),h(xt.$$.fragment,e),h(Bt.$$.fragment,e),h(S.$$.fragment,e),h(Ct.$$.fragment,e),h(Y.$$.fragment,e),h(qt.$$.fragment,e),h(R.$$.fragment,e),h(Vt.$$.fragment,e),h(N.$$.fragment,e),h(St.$$.fragment,e),h(Rt.$$.fragment,e),h(Nt.$$.fragment,e),h(Et.$$.fragment,e),h(zt.$$.fragment,e),h(Pt.$$.fragment,e),h(Dt.$$.fragment,e),h(Kt.$$.fragment,e),Ji=!1},d(e){e&&(t(j),t(c),t(g),t(w),t(U),t(T),t(J),t(_),t(sl),t(tl),t(ll),t(z),t(nl),t(P),t(al),t(A),t(il),t(D),t(pl),t(ol),t(O),t(rl),t(cl),t(se),t(ul),t(dl),t(le),t(ml),t(fl),t(ae),t(hl),t(bl),t(pe),t(gl),t(Ml),t(re),t(yl),t(ce),t(jl),t(wl),t(de),t(Tl),t(Jl),t(fe),t(_l),t(kl),t(be),t($l),t(ge),t(Ul),t(xl),t(ye),t(Zl),t(Bl),t(we),t(Gl),t(Il),t(vl),t(Je),t(Cl),t(Wl),t(ke),t(ql),t($e),t(Xl),t(Ue),t(Vl),t(xe),t(Ll),t(Ze),t(Sl),t(Yl),t(Ge),t(Rl),t(Ie),t(Nl),t(Hl),t(Ce),t(Ql),t(Fl),t(qe),t(El),t(Xe),t(zl),t(Pl),t(Al),t(Le),t(Dl),t(Kl),t(Ye),t(Ol),t(en),t(Ne),t(sn),t(tn),t(Qe),t(ln),t(nn),t(Ee),t(an),t(pn),t(Pe),t(on),t(Ae),t(rn),t(cn),t(Ke),t(un),t(dn),t(es),t(mn),t(fn),t(ts),t(hn),t(bn),t(ns),t(gn),t(as),t(Mn),t(is),t(yn),t(ps),t(jn),t(os),t(wn),t(rs),t(Tn),t(cs),t(Jn),t(_n),t(ds),t(kn),t($n),t(fs),t(Un),t(xn),t(bs),t(Zn),t(Bn),t(Gn),t(ys),t(In),t(js),t(vn),t(Cn),t(ws),t(Wn),t(Ts),t(qn),t(Js),t(Xn),t(Vn),t(ks),t(Ln),t(Sn),t(Us),t(Yn),t(Rn),t(Zs),t(Nn),t(Hn),t(Gs),t(Qn),t(Fn),t(En),t(zn),t(Cs),t(Pn),t(Ws),t(An),t(qs),t(Dn),t(Xs),t(Kn),t(On),t(Ls),t(ea),t(sa),t(ta),t(Rs),t(la),t(Ns),t(na),t(Hs),t(aa),t(ia),t(Fs),t(pa),t(Es),t(oa),t(ra),t(Ps),t(ca),t(ua),t(da),t(Ks),t(ma),t(fa),t(et),t(ha),t(ba),t(ga),t(tt),t(Ma),t(ya),t(nt),t(ja),t(wa),t(it),t(Ta),t(Ja),t(ot),t(_a),t(ka),t(ct),t($a),t(ut),t(Ua),t(xa),t(mt),t(Za),t(Ba),t(Ga),t(bt),t(Ia),t(va),t(Mt),t(Ca),t(yt),t(Wa),t(jt),t(qa),t(wt),t(Xa),t(Va),t(Jt),t(La),t(Sa),t(kt),t(Ya),t($t),t(Ra),t(Na),t(Ha),t(Qa),t(Zt),t(Fa),t(Ea),t(Gt),t(za),t(It),t(Pa),t(vt),t(Aa),t(Da),t(Ka),t(Wt),t(Oa),t(ei),t(si),t(Xt),t(ti),t(li),t(ni),t(ai),t(Lt),t(ii),t(pi),t(Yt),t(oi),t(ri),t(ci),t(Ht),t(ui),t(Qt),t(di),t(Ft),t(mi),t(fi),t(H),t(hi),t(bi),t(Q),t(gi),t(Mi),t(F),t(yi),t(At),t(ji),t(wi),t(Ti),t(Ot)),t(i),b(k,e),b(y,e),b(v,e),b(E,e),b(K,e),b(ee,e),b(te,e),b(ne,e),b(ie,e),b(oe,e),b(ue,e),b(me,e),b(he,e),b(Me,e),b(je,e),b(Te,e),b(C,e),b(_e,e),b(Be,e),b(ve,e),b(We,e),b(Ve,e),b(W,e),b(Se,e),b(Re,e),b(He,e),b(Fe,e),b(ze,e),b(De,e),b(Oe,e),b(ss,e),b(ls,e),b(us,e),b(ms,e),b(hs,e),b(gs,e),b(Ms,e),b(q,e),b(_s,e),b($s,e),b(xs,e),b(Bs,e),b(Is,e),b(X,e),b(vs,e),b(Vs,e),b(Ss,e),b(Ys,e),b(Qs,e),b(zs,e),b(As,e),b(Ds,e),b(Os,e),b(st,e),b(V,e),b(lt,e),b(at,e),b(pt,e),b(rt,e),b(dt,e),b(ft,e),b(ht,e),b(gt,e),b(Tt,e),b(_t,e),b(Ut,e),b(L,e),b(xt,e),b(Bt,e),b(S,e),b(Ct,e),b(Y,e),b(qt,e),b(R,e),b(Vt,e),b(N,e),b(St,e),b(Rt,e),b(Nt,e),b(Et,e),b(zt,e),b(Pt,e),b(Dt,e),b(Kt,e)}}}const sr='{"title":"ModularPipeline","local":"modularpipeline","sections":[{"title":"Create ModularPipelineBlocks","local":"create-modularpipelineblocks","sections":[],"depth":2},{"title":"Modular Repo","local":"modular-repo","sections":[],"depth":2},{"title":"Creating a ModularPipeline from ModularPipelineBlocks","local":"creating-a-modularpipeline-from-modularpipelineblocks","sections":[],"depth":2},{"title":"Creating a ModularPipeline with from_pretrained","local":"creating-a-modularpipeline-with-frompretrained","sections":[],"depth":2},{"title":"Loading components into a ModularPipeline","local":"loading-components-into-a-modularpipeline","sections":[],"depth":2},{"title":"Modifying Loading Specs","local":"modifying-loading-specs","sections":[],"depth":2},{"title":"Updating components in a ModularPipeline","local":"updating-components-in-a-modularpipeline","sections":[],"depth":2},{"title":"Customizing Guidance Techniques","local":"customizing-guidance-techniques","sections":[{"title":"Modify Parameters of the Same Guider Type","local":"modify-parameters-of-the-same-guider-type","sections":[],"depth":4},{"title":"Switch to a Different Guider Type","local":"switch-to-a-different-guider-type","sections":[],"depth":4},{"title":"Loading Custom Guiders from Hub","local":"loading-custom-guiders-from-hub","sections":[],"depth":4},{"title":"Upload Custom Guider to Hub for Easy Loading & Sharing","local":"upload-custom-guider-to-hub-for-easy-loading--sharing","sections":[],"depth":4}],"depth":2},{"title":"Running a ModularPipeline","local":"running-a-modularpipeline","sections":[{"title":"Text-to-Image, Image-to-Image, and Inpainting","local":"text-to-image-image-to-image-and-inpainting","sections":[],"depth":4},{"title":"ControlNet","local":"controlnet","sections":[],"depth":4},{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":4}],"depth":2}],"depth":1}';function tr($){return Io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rr extends vo{constructor(i){super(),Co(this,i,tr,er,Go,{})}}export{rr as component};
